// This file is auto-generated by @hey-api/openapi-ts

export type actions_billing_usage = {
  /**
   * The amount of free GitHub Actions minutes available.
   */
  included_minutes: number;
  minutes_used_breakdown: {
    /**
     * Total minutes used on macOS runner machines.
     */
    MACOS?: number;
    /**
     * Total minutes used on Ubuntu runner machines.
     */
    UBUNTU?: number;
    /**
     * Total minutes used on Windows runner machines.
     */
    WINDOWS?: number;
    /**
     * Total minutes used on macOS 12 core runner machines.
     */
    macos_12_core?: number;
    /**
     * Total minutes used on all runner machines.
     */
    total?: number;
    /**
     * Total minutes used on Ubuntu 16 core runner machines.
     */
    ubuntu_16_core?: number;
    /**
     * Total minutes used on Ubuntu 32 core runner machines.
     */
    ubuntu_32_core?: number;
    /**
     * Total minutes used on Ubuntu 4 core runner machines.
     */
    ubuntu_4_core?: number;
    /**
     * Total minutes used on Ubuntu 64 core runner machines.
     */
    ubuntu_64_core?: number;
    /**
     * Total minutes used on Ubuntu 8 core runner machines.
     */
    ubuntu_8_core?: number;
    /**
     * Total minutes used on Windows 16 core runner machines.
     */
    windows_16_core?: number;
    /**
     * Total minutes used on Windows 32 core runner machines.
     */
    windows_32_core?: number;
    /**
     * Total minutes used on Windows 4 core runner machines.
     */
    windows_4_core?: number;
    /**
     * Total minutes used on Windows 64 core runner machines.
     */
    windows_64_core?: number;
    /**
     * Total minutes used on Windows 8 core runner machines.
     */
    windows_8_core?: number;
  };
  /**
   * The sum of the free and paid GitHub Actions minutes used.
   */
  total_minutes_used: number;
  /**
   * The total paid GitHub Actions minutes used.
   */
  total_paid_minutes_used: number;
};

/**
 * Repository actions caches
 */
export type actions_cache_list = {
  /**
   * Array of caches
   */
  actions_caches: Array<{
    created_at?: string;
    id?: number;
    key?: string;
    last_accessed_at?: string;
    ref?: string;
    size_in_bytes?: number;
    version?: string;
  }>;
  /**
   * Total number of caches
   */
  total_count: number;
};

/**
 * GitHub Actions Cache Usage by repository.
 */
export type actions_cache_usage_by_repository = {
  /**
   * The number of active caches in the repository.
   */
  active_caches_count: number;
  /**
   * The sum of the size in bytes of all the active cache items in the repository.
   */
  active_caches_size_in_bytes: number;
  /**
   * The repository owner and name for the cache usage being shown.
   */
  full_name: string;
};

export type actions_cache_usage_org_enterprise = {
  /**
   * The count of active caches across all repositories of an enterprise or an organization.
   */
  total_active_caches_count: number;
  /**
   * The total size in bytes of all active cache items across all repositories of an enterprise or an organization.
   */
  total_active_caches_size_in_bytes: number;
};

/**
 * Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.
 */
export type actions_can_approve_pull_request_reviews = boolean;

/**
 * The default workflow permissions granted to the GITHUB_TOKEN when running workflows.
 */
export type actions_default_workflow_permissions = 'read' | 'write';

/**
 * Whether GitHub Actions is enabled on the repository.
 */
export type actions_enabled = boolean;

export type actions_get_default_workflow_permissions = {
  can_approve_pull_request_reviews: actions_can_approve_pull_request_reviews;
  default_workflow_permissions: actions_default_workflow_permissions;
};

export type actions_organization_permissions = {
  allowed_actions?: allowed_actions;
  enabled_repositories: enabled_repositories;
  selected_actions_url?: selected_actions_url;
  /**
   * The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.
   */
  selected_repositories_url?: string;
};

/**
 * The public key used for setting Actions Secrets.
 */
export type actions_public_key = {
  created_at?: string;
  id?: number;
  /**
   * The Base64 encoded public key.
   */
  key: string;
  /**
   * The identifier for the key.
   */
  key_id: string;
  title?: string;
  url?: string;
};

export type actions_repository_permissions = {
  allowed_actions?: allowed_actions;
  enabled: actions_enabled;
  selected_actions_url?: selected_actions_url;
};

/**
 * Set secrets for GitHub Actions.
 */
export type actions_secret = {
  created_at: string;
  /**
   * The name of the secret.
   */
  name: string;
  updated_at: string;
};

export type actions_set_default_workflow_permissions = {
  can_approve_pull_request_reviews?: actions_can_approve_pull_request_reviews;
  default_workflow_permissions?: actions_default_workflow_permissions;
};

export type actions_variable = {
  /**
   * The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  created_at: string;
  /**
   * The name of the variable.
   */
  name: string;
  /**
   * The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  updated_at: string;
  /**
   * The value of the variable.
   */
  value: string;
};

export type actions_workflow_access_to_repository = {
  /**
   * Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
   * repository.
   *
   * `none` means the access is only possible from workflows in this repository. `user` level access allows sharing across user owned private repos only. `organization` level access allows sharing across the organization.
   */
  access_level: 'none' | 'user' | 'organization';
};

/**
 * Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
 * repository.
 *
 * `none` means the access is only possible from workflows in this repository. `user` level access allows sharing across user owned private repos only. `organization` level access allows sharing across the organization.
 */
export type access_level = 'none' | 'user' | 'organization';

/**
 * Actor
 */
export type actor = {
  avatar_url: string;
  display_login?: string;
  gravatar_id: string | null;
  id: number;
  login: string;
  url: string;
};

/**
 * Added to Project Issue Event
 */
export type added_to_project_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  project_card?: {
    column_name: string;
    id: number;
    previous_column_name?: string;
    project_id: number;
    project_url: string;
    url: string;
  };
  url: string;
};

/**
 * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
 */
export type alert_created_at = string;

/**
 * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
 */
export type alert_dismissed_at = string | null;

/**
 * The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
 */
export type alert_fixed_at = string | null;

/**
 * The GitHub URL of the alert resource.
 */
export type alert_html_url = string;

/**
 * The REST API URL for fetching the list of instances for an alert.
 */
export type alert_instances_url = string;

/**
 * The security alert number.
 */
export type alert_number = number;

/**
 * The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
 */
export type alert_updated_at = string;

/**
 * The REST API URL of the alert resource.
 */
export type alert_url = string;

/**
 * The permissions policy that controls the actions and reusable workflows that are allowed to run.
 */
export type allowed_actions = 'all' | 'local_only' | 'selected';

/**
 * Api Overview
 */
export type api_overview = {
  actions?: Array<string>;
  api?: Array<string>;
  dependabot?: Array<string>;
  git?: Array<string>;
  hooks?: Array<string>;
  importer?: Array<string>;
  packages?: Array<string>;
  pages?: Array<string>;
  ssh_key_fingerprints?: {
    SHA256_DSA?: string;
    SHA256_ECDSA?: string;
    SHA256_ED25519?: string;
    SHA256_RSA?: string;
  };
  ssh_keys?: Array<string>;
  verifiable_password_authentication: boolean;
  web?: Array<string>;
};

/**
 * The permissions granted to the user-to-server access token.
 */
export type app_permissions = {
  /**
   * The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
   */
  actions?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
   */
  administration?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for checks on code.
   */
  checks?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
   */
  contents?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for deployments and deployment statuses.
   */
  deployments?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for managing repository environments.
   */
  environments?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
   */
  issues?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for organization teams and members.
   */
  members?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
   */
  metadata?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to manage access to an organization.
   */
  organization_administration?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to view and manage announcement banners for an organization.
   */
  organization_announcement_banners?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for custom repository roles management. This property is in beta and is subject to change.
   */
  organization_custom_roles?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to manage the post-receive hooks for an organization.
   */
  organization_hooks?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for organization packages published to GitHub Packages.
   */
  organization_packages?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for viewing an organization's plan.
   */
  organization_plan?: 'read';
  /**
   * The level of permission to grant the access token to manage organization projects and projects beta (where available).
   */
  organization_projects?: 'read' | 'write' | 'admin';
  /**
   * The level of permission to grant the access token to manage organization secrets.
   */
  organization_secrets?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
   */
  organization_self_hosted_runners?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to view and manage users blocked by the organization.
   */
  organization_user_blocking?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for packages published to GitHub Packages.
   */
  packages?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
   */
  pages?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
   */
  pull_requests?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to view and manage announcement banners for a repository.
   */
  repository_announcement_banners?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to manage the post-receive hooks for a repository.
   */
  repository_hooks?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to manage repository projects, columns, and cards.
   */
  repository_projects?: 'read' | 'write' | 'admin';
  /**
   * The level of permission to grant the access token to view and manage secret scanning alerts.
   */
  secret_scanning_alerts?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to manage repository secrets.
   */
  secrets?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to view and manage security events like code scanning alerts.
   */
  security_events?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to manage just a single file.
   */
  single_file?: 'read' | 'write';
  /**
   * The level of permission to grant the access token for commit statuses.
   */
  statuses?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to manage team discussions and related comments.
   */
  team_discussions?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to manage Dependabot alerts.
   */
  vulnerability_alerts?: 'read' | 'write';
  /**
   * The level of permission to grant the access token to update GitHub Actions workflow files.
   */
  workflows?: 'write';
};

/**
 * The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.
 */
export type actions = 'read' | 'write';

/**
 * The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.
 */
export type administration = 'read' | 'write';

/**
 * The level of permission to grant the access token for checks on code.
 */
export type checks = 'read' | 'write';

/**
 * The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.
 */
export type contents = 'read' | 'write';

/**
 * The level of permission to grant the access token for deployments and deployment statuses.
 */
export type deployments = 'read' | 'write';

/**
 * The level of permission to grant the access token for managing repository environments.
 */
export type environments = 'read' | 'write';

/**
 * The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.
 */
export type issues = 'read' | 'write';

/**
 * The level of permission to grant the access token for organization teams and members.
 */
export type members = 'read' | 'write';

/**
 * The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.
 */
export type metadata = 'read' | 'write';

/**
 * The level of permission to grant the access token to manage access to an organization.
 */
export type organization_administration = 'read' | 'write';

/**
 * The level of permission to grant the access token to view and manage announcement banners for an organization.
 */
export type organization_announcement_banners = 'read' | 'write';

/**
 * The level of permission to grant the access token for custom repository roles management. This property is in beta and is subject to change.
 */
export type organization_custom_roles = 'read' | 'write';

/**
 * The level of permission to grant the access token to manage the post-receive hooks for an organization.
 */
export type organization_hooks = 'read' | 'write';

/**
 * The level of permission to grant the access token for organization packages published to GitHub Packages.
 */
export type organization_packages = 'read' | 'write';

/**
 * The level of permission to grant the access token for viewing an organization's plan.
 */
export type organization_plan = 'read';

/**
 * The level of permission to grant the access token to manage organization projects and projects beta (where available).
 */
export type organization_projects = 'read' | 'write' | 'admin';

/**
 * The level of permission to grant the access token to manage organization secrets.
 */
export type organization_secrets = 'read' | 'write';

/**
 * The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.
 */
export type organization_self_hosted_runners = 'read' | 'write';

/**
 * The level of permission to grant the access token to view and manage users blocked by the organization.
 */
export type organization_user_blocking = 'read' | 'write';

/**
 * The level of permission to grant the access token for packages published to GitHub Packages.
 */
export type packages = 'read' | 'write';

/**
 * The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
 */
export type pages = 'read' | 'write';

/**
 * The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.
 */
export type pull_requests = 'read' | 'write';

/**
 * The level of permission to grant the access token to view and manage announcement banners for a repository.
 */
export type repository_announcement_banners = 'read' | 'write';

/**
 * The level of permission to grant the access token to manage the post-receive hooks for a repository.
 */
export type repository_hooks = 'read' | 'write';

/**
 * The level of permission to grant the access token to manage repository projects, columns, and cards.
 */
export type repository_projects = 'read' | 'write' | 'admin';

/**
 * The level of permission to grant the access token to view and manage secret scanning alerts.
 */
export type secret_scanning_alerts = 'read' | 'write';

/**
 * The level of permission to grant the access token to manage repository secrets.
 */
export type secrets = 'read' | 'write';

/**
 * The level of permission to grant the access token to view and manage security events like code scanning alerts.
 */
export type security_events = 'read' | 'write';

/**
 * The level of permission to grant the access token to manage just a single file.
 */
export type single_file = 'read' | 'write';

/**
 * The level of permission to grant the access token for commit statuses.
 */
export type statuses = 'read' | 'write';

/**
 * The level of permission to grant the access token to manage team discussions and related comments.
 */
export type team_discussions = 'read' | 'write';

/**
 * The level of permission to grant the access token to manage Dependabot alerts.
 */
export type vulnerability_alerts = 'read' | 'write';

/**
 * The level of permission to grant the access token to update GitHub Actions workflow files.
 */
export type workflows = 'write';

/**
 * An artifact
 */
export type artifact = {
  archive_download_url: string;
  created_at: string | null;
  /**
   * Whether or not the artifact has expired.
   */
  expired: boolean;
  expires_at: string | null;
  id: number;
  /**
   * The name of the artifact.
   */
  name: string;
  node_id: string;
  /**
   * The size in bytes of the artifact.
   */
  size_in_bytes: number;
  updated_at: string | null;
  url: string;
  workflow_run?: {
    head_branch?: string;
    head_repository_id?: number;
    head_sha?: string;
    id?: number;
    repository_id?: number;
  } | null;
};

/**
 * Assigned Issue Event
 */
export type assigned_issue_event = {
  actor: simple_user;
  assignee: simple_user;
  assigner: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: integration;
  url: string;
};

/**
 * Authentication Token
 */
export type authentication_token = {
  /**
   * The time this token expires
   */
  expires_at: string;
  permissions?: {
    [key: string]: string;
  };
  /**
   * The repositories this token has access to
   */
  repositories?: Array<repository>;
  /**
   * Describe whether all repositories have been selected or there's a selection involved
   */
  repository_selection?: 'all' | 'selected';
  single_file?: string | null;
  /**
   * The token used for authentication
   */
  token: string;
};

/**
 * Describe whether all repositories have been selected or there's a selection involved
 */
export type repository_selection = 'all' | 'selected';

/**
 * How the author is associated with the repository.
 */
export type author_association =
  | 'COLLABORATOR'
  | 'CONTRIBUTOR'
  | 'FIRST_TIMER'
  | 'FIRST_TIME_CONTRIBUTOR'
  | 'MANNEQUIN'
  | 'MEMBER'
  | 'NONE'
  | 'OWNER';

/**
 * The authorization for an OAuth app, GitHub App, or a Personal Access Token.
 */
export type authorization = {
  app: {
    client_id: string;
    name: string;
    url: string;
  };
  created_at: string;
  expires_at: string | null;
  fingerprint: string | null;
  hashed_token: string | null;
  id: number;
  installation?: nullable_scoped_installation;
  note: string | null;
  note_url: string | null;
  /**
   * A list of scopes that this authorization is in.
   */
  scopes: Array<string> | null;
  token: string;
  token_last_eight: string | null;
  updated_at: string;
  url: string;
  user?: nullable_simple_user;
};

/**
 * The status of auto merging a pull request.
 */
export type auto_merge = {
  /**
   * Commit message for the merge commit.
   */
  commit_message: string;
  /**
   * Title for the merge commit message.
   */
  commit_title: string;
  enabled_by: simple_user;
  /**
   * The merge method to use.
   */
  merge_method: 'merge' | 'squash' | 'rebase';
} | null;

/**
 * The merge method to use.
 */
export type merge_method = 'merge' | 'squash' | 'rebase';

/**
 * An autolink reference.
 */
export type autolink = {
  id: number;
  /**
   * Whether this autolink reference matches alphanumeric characters. If false, this autolink reference only matches numeric characters.
   */
  is_alphanumeric: boolean;
  /**
   * The prefix of a key that is linkified.
   */
  key_prefix: string;
  /**
   * A template for the target URL that is generated if a key was found.
   */
  url_template: string;
};

/**
 * Base Gist
 */
export type base_gist = {
  comments: number;
  comments_url: string;
  commits_url: string;
  created_at: string;
  description: string | null;
  files: {
    [key: string]: {
      filename?: string;
      language?: string;
      raw_url?: string;
      size?: number;
      type?: string;
    };
  };
  forks?: Array<string>;
  forks_url: string;
  git_pull_url: string;
  git_push_url: string;
  history?: Array<string>;
  html_url: string;
  id: string;
  node_id: string;
  owner?: simple_user;
  public: boolean;
  truncated?: boolean;
  updated_at: string;
  url: string;
  user: nullable_simple_user;
};

/**
 * Basic Error
 */
export type basic_error = {
  documentation_url?: string;
  message?: string;
  status?: string;
  url?: string;
};

/**
 * Blob
 */
export type blob = {
  content: string;
  encoding: string;
  highlighted_content?: string;
  node_id: string;
  sha: string;
  size: number | null;
  url: string;
};

/**
 * Branch Protection
 */
export type branch_protection = {
  allow_deletions?: {
    enabled?: boolean;
  };
  allow_force_pushes?: {
    enabled?: boolean;
  };
  /**
   * Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
   */
  allow_fork_syncing?: {
    enabled?: boolean;
  };
  block_creations?: {
    enabled?: boolean;
  };
  enabled?: boolean;
  enforce_admins?: protected_branch_admin_enforced;
  /**
   * Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
   */
  lock_branch?: {
    enabled?: boolean;
  };
  name?: string;
  protection_url?: string;
  required_conversation_resolution?: {
    enabled?: boolean;
  };
  required_linear_history?: {
    enabled?: boolean;
  };
  required_pull_request_reviews?: protected_branch_pull_request_review;
  required_signatures?: {
    enabled: boolean;
    url: string;
  };
  required_status_checks?: protected_branch_required_status_check;
  restrictions?: branch_restriction_policy;
  url?: string;
};

/**
 * Branch Restriction Policy
 */
export type branch_restriction_policy = {
  apps: Array<{
    created_at?: string;
    description?: string;
    events?: Array<string>;
    external_url?: string;
    html_url?: string;
    id?: number;
    name?: string;
    node_id?: string;
    owner?: {
      avatar_url?: string;
      description?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      hooks_url?: string;
      html_url?: string;
      id?: number;
      issues_url?: string;
      login?: string;
      members_url?: string;
      node_id?: string;
      organizations_url?: string;
      public_members_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
    permissions?: {
      contents?: string;
      issues?: string;
      metadata?: string;
      single_file?: string;
    };
    slug?: string;
    updated_at?: string;
  }>;
  apps_url: string;
  teams: Array<{
    description?: string | null;
    html_url?: string;
    id?: number;
    members_url?: string;
    name?: string;
    node_id?: string;
    parent?: string | null;
    permission?: string;
    privacy?: string;
    repositories_url?: string;
    slug?: string;
    url?: string;
  }>;
  teams_url: string;
  url: string;
  users: Array<{
    avatar_url?: string;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id?: number;
    login?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: string;
    url?: string;
  }>;
  users_url: string;
};

/**
 * Branch Short
 */
export type branch_short = {
  commit: {
    sha: string;
    url: string;
  };
  name: string;
  protected: boolean;
};

/**
 * Branch With Protection
 */
export type branch_with_protection = {
  _links: {
    html: string;
    self: string;
  };
  commit: commit;
  name: string;
  pattern?: string;
  protected: boolean;
  protection: branch_protection;
  protection_url: string;
  required_approving_review_count?: number;
};

/**
 * Check Annotation
 */
export type check_annotation = {
  annotation_level: string | null;
  blob_href: string;
  end_column: number | null;
  end_line: number;
  message: string | null;
  path: string;
  raw_details: string | null;
  start_column: number | null;
  start_line: number;
  title: string | null;
};

/**
 * A check performed on the code of a given code change
 */
export type check_run = {
  app: nullable_integration;
  check_suite: {
    id: number;
  } | null;
  completed_at: string | null;
  conclusion: ('success' | 'failure' | 'neutral' | 'cancelled' | 'skipped' | 'timed_out' | 'action_required') | null;
  deployment?: deployment_simple;
  details_url: string | null;
  external_id: string | null;
  /**
   * The SHA of the commit that is being checked.
   */
  head_sha: string;
  html_url: string | null;
  /**
   * The id of the check.
   */
  id: number;
  /**
   * The name of the check.
   */
  name: string;
  node_id: string;
  output: {
    annotations_count: number;
    annotations_url: string;
    summary: string | null;
    text: string | null;
    title: string | null;
  };
  pull_requests: Array<pull_request_minimal>;
  started_at: string | null;
  /**
   * The phase of the lifecycle that the check is currently in.
   */
  status: 'queued' | 'in_progress' | 'completed';
  url: string;
};

export type conclusion = 'success' | 'failure' | 'neutral' | 'cancelled' | 'skipped' | 'timed_out' | 'action_required';

/**
 * The phase of the lifecycle that the check is currently in.
 */
export type status = 'queued' | 'in_progress' | 'completed';

/**
 * A check performed on the code of a given code change
 */
export type check_run_with_simple_check_suite = {
  app: nullable_integration;
  check_suite: simple_check_suite;
  completed_at: string | null;
  conclusion:
    | (
        | 'waiting'
        | 'pending'
        | 'startup_failure'
        | 'stale'
        | 'success'
        | 'failure'
        | 'neutral'
        | 'cancelled'
        | 'skipped'
        | 'timed_out'
        | 'action_required'
      )
    | null;
  deployment?: deployment_simple;
  details_url: string;
  external_id: string;
  /**
   * The SHA of the commit that is being checked.
   */
  head_sha: string;
  html_url: string;
  /**
   * The id of the check.
   */
  id: number;
  /**
   * The name of the check.
   */
  name: string;
  node_id: string;
  output: {
    annotations_count: number;
    annotations_url: string;
    summary: string | null;
    text: string | null;
    title: string | null;
  };
  pull_requests: Array<pull_request_minimal>;
  started_at: string;
  /**
   * The phase of the lifecycle that the check is currently in.
   */
  status: 'queued' | 'in_progress' | 'completed' | 'pending';
  url: string;
};

export type conclusion2 =
  | 'waiting'
  | 'pending'
  | 'startup_failure'
  | 'stale'
  | 'success'
  | 'failure'
  | 'neutral'
  | 'cancelled'
  | 'skipped'
  | 'timed_out'
  | 'action_required';

/**
 * The phase of the lifecycle that the check is currently in.
 */
export type status2 = 'queued' | 'in_progress' | 'completed' | 'pending';

/**
 * A suite of checks performed on the code of a given code change
 */
export type check_suite = {
  after: string | null;
  app: nullable_integration;
  before: string | null;
  check_runs_url: string;
  conclusion:
    | (
        | 'success'
        | 'failure'
        | 'neutral'
        | 'cancelled'
        | 'skipped'
        | 'timed_out'
        | 'action_required'
        | 'startup_failure'
        | 'stale'
      )
    | null;
  created_at: string | null;
  head_branch: string | null;
  head_commit: simple_commit;
  /**
   * The SHA of the head commit that is being checked.
   */
  head_sha: string;
  id: number;
  latest_check_runs_count: number;
  node_id: string;
  pull_requests: Array<pull_request_minimal> | null;
  repository: minimal_repository;
  rerequestable?: boolean;
  runs_rerequestable?: boolean;
  status: ('queued' | 'in_progress' | 'completed') | null;
  updated_at: string | null;
  url: string | null;
};

export type conclusion3 =
  | 'success'
  | 'failure'
  | 'neutral'
  | 'cancelled'
  | 'skipped'
  | 'timed_out'
  | 'action_required'
  | 'startup_failure'
  | 'stale';

/**
 * Check suite configuration preferences for a repository.
 */
export type check_suite_preference = {
  preferences: {
    auto_trigger_checks?: Array<{
      app_id: number;
      setting: boolean;
    }>;
  };
  repository: minimal_repository;
};

/**
 * Clone Traffic
 */
export type clone_traffic = {
  clones: Array<traffic>;
  count: number;
  uniques: number;
};

/**
 * Code Frequency Stat
 */
export type code_frequency_stat = Array<number>;

/**
 * Code Of Conduct
 */
export type code_of_conduct = {
  body?: string;
  html_url: string | null;
  key: string;
  name: string;
  url: string;
};

/**
 * Code of Conduct Simple
 */
export type code_of_conduct_simple = {
  html_url: string | null;
  key: string;
  name: string;
  url: string;
};

export type code_scanning_alert = {
  created_at: alert_created_at;
  dismissed_at: alert_dismissed_at;
  dismissed_by: nullable_simple_user;
  dismissed_comment?: code_scanning_alert_dismissed_comment;
  dismissed_reason: code_scanning_alert_dismissed_reason;
  fixed_at?: alert_fixed_at;
  html_url: alert_html_url;
  instances_url: alert_instances_url;
  most_recent_instance: code_scanning_alert_instance;
  number: alert_number;
  rule: code_scanning_alert_rule;
  state: code_scanning_alert_state;
  tool: code_scanning_analysis_tool;
  updated_at?: alert_updated_at;
  url: alert_url;
};

/**
 * A classification of the file. For example to identify it as generated.
 */
export type code_scanning_alert_classification = 'source' | 'generated' | 'test' | 'library';

/**
 * The dismissal comment associated with the dismissal of the alert.
 */
export type code_scanning_alert_dismissed_comment = string | null;

/**
 * **Required when the state is dismissed.** The reason for dismissing or closing the alert.
 */
export type code_scanning_alert_dismissed_reason = 'false positive' | "won't fix" | 'used in tests';

/**
 * Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
 */
export type code_scanning_alert_environment = string;

export type code_scanning_alert_instance = {
  analysis_key?: code_scanning_analysis_analysis_key;
  category?: code_scanning_analysis_category;
  /**
   * Classifications that have been applied to the file that triggered the alert.
   * For example identifying it as documentation, or a generated file.
   */
  classifications?: Array<code_scanning_alert_classification>;
  commit_sha?: string;
  environment?: code_scanning_alert_environment;
  html_url?: string;
  location?: code_scanning_alert_location;
  message?: {
    text?: string;
  };
  ref?: code_scanning_ref;
  state?: code_scanning_alert_state;
};

export type code_scanning_alert_items = {
  created_at: alert_created_at;
  dismissed_at: alert_dismissed_at;
  dismissed_by: nullable_simple_user;
  dismissed_comment?: code_scanning_alert_dismissed_comment;
  dismissed_reason: code_scanning_alert_dismissed_reason;
  fixed_at?: alert_fixed_at;
  html_url: alert_html_url;
  instances_url: alert_instances_url;
  most_recent_instance: code_scanning_alert_instance;
  number: alert_number;
  rule: code_scanning_alert_rule_summary;
  state: code_scanning_alert_state;
  tool: code_scanning_analysis_tool;
  updated_at?: alert_updated_at;
  url: alert_url;
};

/**
 * Describe a region within a file for the alert.
 */
export type code_scanning_alert_location = {
  end_column?: number;
  end_line?: number;
  path?: string;
  start_column?: number;
  start_line?: number;
};

export type code_scanning_alert_rule = {
  /**
   * A short description of the rule used to detect the alert.
   */
  description?: string;
  /**
   * description of the rule used to detect the alert.
   */
  full_description?: string;
  /**
   * Detailed documentation for the rule as GitHub Flavored Markdown.
   */
  help?: string | null;
  /**
   * A link to the documentation for the rule used to detect the alert.
   */
  help_uri?: string | null;
  /**
   * A unique identifier for the rule used to detect the alert.
   */
  id?: string | null;
  /**
   * The name of the rule used to detect the alert.
   */
  name?: string;
  /**
   * The security severity of the alert.
   */
  security_severity_level?: ('low' | 'medium' | 'high' | 'critical') | null;
  /**
   * The severity of the alert.
   */
  severity?: ('none' | 'note' | 'warning' | 'error') | null;
  /**
   * A set of tags applicable for the rule.
   */
  tags?: Array<string> | null;
};

/**
 * The security severity of the alert.
 */
export type security_severity_level = 'low' | 'medium' | 'high' | 'critical';

/**
 * The severity of the alert.
 */
export type severity = 'none' | 'note' | 'warning' | 'error';

export type code_scanning_alert_rule_summary = {
  /**
   * A short description of the rule used to detect the alert.
   */
  description?: string;
  /**
   * A unique identifier for the rule used to detect the alert.
   */
  id?: string | null;
  /**
   * The name of the rule used to detect the alert.
   */
  name?: string;
  /**
   * The severity of the alert.
   */
  severity?: ('none' | 'note' | 'warning' | 'error') | null;
  /**
   * A set of tags applicable for the rule.
   */
  tags?: Array<string> | null;
};

/**
 * Sets the state of the code scanning alert. You must provide `dismissed_reason` when you set the state to `dismissed`.
 */
export type code_scanning_alert_set_state = 'open' | 'dismissed';

/**
 * Severity of a code scanning alert.
 */
export type code_scanning_alert_severity = 'critical' | 'high' | 'medium' | 'low' | 'warning' | 'note' | 'error';

/**
 * State of a code scanning alert.
 */
export type code_scanning_alert_state = 'open' | 'closed' | 'dismissed' | 'fixed';

export type code_scanning_analysis = {
  analysis_key: code_scanning_analysis_analysis_key;
  category?: code_scanning_analysis_category;
  commit_sha: code_scanning_analysis_commit_sha;
  created_at: code_scanning_analysis_created_at;
  deletable: boolean;
  environment: code_scanning_analysis_environment;
  error: string;
  /**
   * Unique identifier for this analysis.
   */
  id: number;
  ref: code_scanning_ref;
  /**
   * The total number of results in the analysis.
   */
  results_count: number;
  /**
   * The total number of rules used in the analysis.
   */
  rules_count: number;
  sarif_id: code_scanning_analysis_sarif_id;
  tool: code_scanning_analysis_tool;
  url: code_scanning_analysis_url;
  /**
   * Warning generated when processing the analysis
   */
  warning: string;
};

/**
 * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
 */
export type code_scanning_analysis_analysis_key = string;

/**
 * Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.
 */
export type code_scanning_analysis_category = string;

/**
 * The SHA of the commit to which the analysis you are uploading relates.
 */
export type code_scanning_analysis_commit_sha = string;

/**
 * The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
 */
export type code_scanning_analysis_created_at = string;

/**
 * Successful deletion of a code scanning analysis
 */
export type code_scanning_analysis_deletion = {
  /**
   * Next deletable analysis in chain, with last analysis deletion confirmation
   */
  readonly confirm_delete_url: string | null;
  /**
   * Next deletable analysis in chain, without last analysis deletion confirmation
   */
  readonly next_analysis_url: string | null;
};

/**
 * Identifies the variable values associated with the environment in which this analysis was performed.
 */
export type code_scanning_analysis_environment = string;

/**
 * A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string. For more information, see "[SARIF support for code scanning](https://docs.github.com/code-security/secure-coding/sarif-support-for-code-scanning)."
 */
export type code_scanning_analysis_sarif_file = string;

/**
 * An identifier for the upload.
 */
export type code_scanning_analysis_sarif_id = string;

export type code_scanning_analysis_tool = {
  guid?: code_scanning_analysis_tool_guid;
  name?: code_scanning_analysis_tool_name;
  version?: code_scanning_analysis_tool_version;
};

/**
 * The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data.
 */
export type code_scanning_analysis_tool_guid = string | null;

/**
 * The name of the tool used to generate the code scanning analysis.
 */
export type code_scanning_analysis_tool_name = string;

/**
 * The version of the tool used to generate the code scanning analysis.
 */
export type code_scanning_analysis_tool_version = string | null;

/**
 * The REST API URL of the analysis resource.
 */
export type code_scanning_analysis_url = string;

/**
 * A CodeQL database.
 */
export type code_scanning_codeql_database = {
  /**
   * The MIME type of the CodeQL database file.
   */
  content_type: string;
  /**
   * The date and time at which the CodeQL database was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  created_at: string;
  /**
   * The ID of the CodeQL database.
   */
  id: number;
  /**
   * The language of the CodeQL database.
   */
  language: string;
  /**
   * The name of the CodeQL database.
   */
  name: string;
  /**
   * The size of the CodeQL database file in bytes.
   */
  size: number;
  /**
   * The date and time at which the CodeQL database was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  updated_at: string;
  uploader: simple_user;
  /**
   * The URL at which to download the CodeQL database. The `Accept` header must be set to the value of the `content_type` property.
   */
  url: string;
};

export type code_scanning_organization_alert_items = {
  created_at: alert_created_at;
  dismissed_at: alert_dismissed_at;
  dismissed_by: nullable_simple_user;
  dismissed_comment?: code_scanning_alert_dismissed_comment;
  dismissed_reason: code_scanning_alert_dismissed_reason;
  fixed_at?: alert_fixed_at;
  html_url: alert_html_url;
  instances_url: alert_instances_url;
  most_recent_instance: code_scanning_alert_instance;
  number: alert_number;
  repository: simple_repository;
  rule: code_scanning_alert_rule;
  state: code_scanning_alert_state;
  tool: code_scanning_analysis_tool;
  updated_at?: alert_updated_at;
  url: alert_url;
};

/**
 * The full Git reference, formatted as `refs/heads/<branch name>`,
 * `refs/pull/<number>/merge`, or `refs/pull/<number>/head`.
 */
export type code_scanning_ref = string;

export type code_scanning_sarifs_receipt = {
  id?: code_scanning_analysis_sarif_id;
  /**
   * The REST API URL for checking the status of the upload.
   */
  readonly url?: string;
};

export type code_scanning_sarifs_status = {
  /**
   * The REST API URL for getting the analyses associated with the upload.
   */
  readonly analyses_url?: string | null;
  /**
   * Any errors that ocurred during processing of the delivery.
   */
  readonly errors?: Array<string> | null;
  /**
   * `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.
   */
  processing_status?: 'pending' | 'complete' | 'failed';
};

/**
 * `pending` files have not yet been processed, while `complete` means results from the SARIF have been stored. `failed` files have either not been processed at all, or could only be partially processed.
 */
export type processing_status = 'pending' | 'complete' | 'failed';

/**
 * Code Search Result Item
 */
export type code_search_result_item = {
  file_size?: number;
  git_url: string;
  html_url: string;
  language?: string | null;
  last_modified_at?: string;
  line_numbers?: Array<string>;
  name: string;
  path: string;
  repository: minimal_repository;
  score: number;
  sha: string;
  text_matches?: search_result_text_matches;
  url: string;
};

/**
 * A list of errors found in a repo's CODEOWNERS file
 */
export type codeowners_errors = {
  errors: Array<{
    /**
     * The column number where this errors occurs.
     */
    column: number;
    /**
     * The type of error.
     */
    kind: string;
    /**
     * The line number where this errors occurs.
     */
    line: number;
    /**
     * A human-readable description of the error, combining information from multiple fields, laid out for display in a monospaced typeface (for example, a command-line setting).
     */
    message: string;
    /**
     * The path of the file where the error occured.
     */
    path: string;
    /**
     * The contents of the line where the error occurs.
     */
    source?: string;
    /**
     * Suggested action to fix the error. This will usually be `null`, but is provided for some common errors.
     */
    suggestion?: string | null;
  }>;
};

/**
 * A codespace.
 */
export type codespace = {
  billable_owner: simple_user;
  created_at: string;
  /**
   * Path to devcontainer.json from repo root used to create Codespace.
   */
  devcontainer_path?: string | null;
  /**
   * Display name for this codespace.
   */
  display_name?: string | null;
  /**
   * UUID identifying this codespace's environment.
   */
  environment_id: string | null;
  /**
   * Details about the codespace's git repository.
   */
  git_status: {
    /**
     * The number of commits the local repository is ahead of the remote.
     */
    ahead?: number;
    /**
     * The number of commits the local repository is behind the remote.
     */
    behind?: number;
    /**
     * Whether the local repository has uncommitted changes.
     */
    has_uncommitted_changes?: boolean;
    /**
     * Whether the local repository has unpushed changes.
     */
    has_unpushed_changes?: boolean;
    /**
     * The current branch (or SHA if in detached HEAD state) of the local repository.
     */
    ref?: string;
  };
  id: number;
  /**
   * The number of minutes of inactivity after which this codespace will be automatically stopped.
   */
  idle_timeout_minutes: number | null;
  /**
   * Text to show user when codespace idle timeout minutes has been overriden by an organization policy
   */
  idle_timeout_notice?: string | null;
  /**
   * The text to display to a user when a codespace has been stopped for a potentially actionable reason.
   */
  last_known_stop_notice?: string | null;
  /**
   * Last known time this codespace was started.
   */
  last_used_at: string;
  /**
   * The Azure region where this codespace is located.
   */
  location: 'EastUs' | 'SouthEastAsia' | 'WestEurope' | 'WestUs2';
  machine: nullable_codespace_machine;
  /**
   * API URL to access available alternate machine types for this codespace.
   */
  machines_url: string;
  /**
   * Automatically generated name of this codespace.
   */
  name: string;
  owner: simple_user;
  /**
   * Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.
   */
  pending_operation?: boolean | null;
  /**
   * Text to show user when codespace is disabled by a pending operation
   */
  pending_operation_disabled_reason?: string | null;
  /**
   * Whether the codespace was created from a prebuild.
   */
  prebuild: boolean | null;
  /**
   * API URL to publish this codespace to a new repository.
   */
  publish_url?: string | null;
  /**
   * API URL for the Pull Request associated with this codespace, if any.
   */
  pulls_url: string | null;
  recent_folders: Array<string>;
  repository: minimal_repository;
  /**
   * When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"
   */
  retention_expires_at?: string | null;
  /**
   * Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
   */
  retention_period_minutes?: number | null;
  runtime_constraints?: {
    /**
     * The privacy settings a user can select from when forwarding a port.
     */
    allowed_port_privacy_settings?: Array<string> | null;
  };
  /**
   * API URL to start this codespace.
   */
  start_url: string;
  /**
   * State of this codespace.
   */
  state:
    | 'string'
    | 'Created'
    | 'Queued'
    | 'Provisioning'
    | 'Available'
    | 'Awaiting'
    | 'Unavailable'
    | 'Deleted'
    | 'Moved'
    | 'Shutdown'
    | 'Archived'
    | 'Starting'
    | 'ShuttingDown'
    | 'Failed'
    | 'Exporting'
    | 'Updating'
    | 'Rebuilding';
  /**
   * API URL to stop this codespace.
   */
  stop_url: string;
  updated_at: string;
  /**
   * API URL for this codespace.
   */
  url: string;
  /**
   * URL to access this codespace on the web.
   */
  web_url: string;
};

/**
 * The Azure region where this codespace is located.
 */
export type location = 'EastUs' | 'SouthEastAsia' | 'WestEurope' | 'WestUs2';

/**
 * State of this codespace.
 */
export type state =
  | 'string'
  | 'Created'
  | 'Queued'
  | 'Provisioning'
  | 'Available'
  | 'Awaiting'
  | 'Unavailable'
  | 'Deleted'
  | 'Moved'
  | 'Shutdown'
  | 'Archived'
  | 'Starting'
  | 'ShuttingDown'
  | 'Failed'
  | 'Exporting'
  | 'Updating'
  | 'Rebuilding';

/**
 * An export of a codespace. Also, latest export details for a codespace can be fetched with id = latest
 */
export type codespace_export_details = {
  /**
   * Name of the exported branch
   */
  branch?: string | null;
  /**
   * Completion time of the last export operation
   */
  completed_at?: string | null;
  /**
   * Url for fetching export details
   */
  export_url?: string;
  /**
   * Web url for the exported branch
   */
  html_url?: string | null;
  /**
   * Id for the export details
   */
  id?: string;
  /**
   * Git commit SHA of the exported branch
   */
  sha?: string | null;
  /**
   * State of the latest export
   */
  state?: string | null;
};

/**
 * A description of the machine powering a codespace.
 */
export type codespace_machine = {
  /**
   * How many cores are available to the codespace.
   */
  cpus: number;
  /**
   * The display name of the machine includes cores, memory, and storage.
   */
  display_name: string;
  /**
   * How much memory is available to the codespace.
   */
  memory_in_bytes: number;
  /**
   * The name of the machine.
   */
  name: string;
  /**
   * The operating system of the machine.
   */
  operating_system: string;
  /**
   * Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
   */
  prebuild_availability: ('none' | 'ready' | 'in_progress') | null;
  /**
   * How much storage is available to the codespace.
   */
  storage_in_bytes: number;
};

/**
 * Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
 */
export type prebuild_availability = 'none' | 'ready' | 'in_progress';

/**
 * A codespace.
 */
export type codespace_with_full_repository = {
  billable_owner: simple_user;
  created_at: string;
  /**
   * Path to devcontainer.json from repo root used to create Codespace.
   */
  devcontainer_path?: string | null;
  /**
   * Display name for this codespace.
   */
  display_name?: string | null;
  /**
   * UUID identifying this codespace's environment.
   */
  environment_id: string | null;
  /**
   * Details about the codespace's git repository.
   */
  git_status: {
    /**
     * The number of commits the local repository is ahead of the remote.
     */
    ahead?: number;
    /**
     * The number of commits the local repository is behind the remote.
     */
    behind?: number;
    /**
     * Whether the local repository has uncommitted changes.
     */
    has_uncommitted_changes?: boolean;
    /**
     * Whether the local repository has unpushed changes.
     */
    has_unpushed_changes?: boolean;
    /**
     * The current branch (or SHA if in detached HEAD state) of the local repository.
     */
    ref?: string;
  };
  id: number;
  /**
   * The number of minutes of inactivity after which this codespace will be automatically stopped.
   */
  idle_timeout_minutes: number | null;
  /**
   * Text to show user when codespace idle timeout minutes has been overriden by an organization policy
   */
  idle_timeout_notice?: string | null;
  /**
   * Last known time this codespace was started.
   */
  last_used_at: string;
  /**
   * The Azure region where this codespace is located.
   */
  location: 'EastUs' | 'SouthEastAsia' | 'WestEurope' | 'WestUs2';
  machine: nullable_codespace_machine;
  /**
   * API URL to access available alternate machine types for this codespace.
   */
  machines_url: string;
  /**
   * Automatically generated name of this codespace.
   */
  name: string;
  owner: simple_user;
  /**
   * Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.
   */
  pending_operation?: boolean | null;
  /**
   * Text to show user when codespace is disabled by a pending operation
   */
  pending_operation_disabled_reason?: string | null;
  /**
   * Whether the codespace was created from a prebuild.
   */
  prebuild: boolean | null;
  /**
   * API URL to publish this codespace to a new repository.
   */
  publish_url?: string | null;
  /**
   * API URL for the Pull Request associated with this codespace, if any.
   */
  pulls_url: string | null;
  recent_folders: Array<string>;
  repository: full_repository;
  /**
   * When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"
   */
  retention_expires_at?: string | null;
  /**
   * Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).
   */
  retention_period_minutes?: number | null;
  runtime_constraints?: {
    /**
     * The privacy settings a user can select from when forwarding a port.
     */
    allowed_port_privacy_settings?: Array<string> | null;
  };
  /**
   * API URL to start this codespace.
   */
  start_url: string;
  /**
   * State of this codespace.
   */
  state:
    | 'string'
    | 'Created'
    | 'Queued'
    | 'Provisioning'
    | 'Available'
    | 'Awaiting'
    | 'Unavailable'
    | 'Deleted'
    | 'Moved'
    | 'Shutdown'
    | 'Archived'
    | 'Starting'
    | 'ShuttingDown'
    | 'Failed'
    | 'Exporting'
    | 'Updating'
    | 'Rebuilding';
  /**
   * API URL to stop this codespace.
   */
  stop_url: string;
  updated_at: string;
  /**
   * API URL for this codespace.
   */
  url: string;
  /**
   * URL to access this codespace on the web.
   */
  web_url: string;
};

/**
 * Secrets for a GitHub Codespace.
 */
export type codespaces_org_secret = {
  /**
   * The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  created_at: string;
  /**
   * The name of the secret
   */
  name: string;
  /**
   * The API URL at which the list of repositories this secret is visible to can be retrieved
   */
  selected_repositories_url?: string;
  /**
   * The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  updated_at: string;
  /**
   * The type of repositories in the organization that the secret is visible to
   */
  visibility: 'all' | 'private' | 'selected';
};

/**
 * The type of repositories in the organization that the secret is visible to
 */
export type visibility = 'all' | 'private' | 'selected';

/**
 * The public key used for setting Codespaces secrets.
 */
export type codespaces_public_key = {
  created_at?: string;
  id?: number;
  /**
   * The Base64 encoded public key.
   */
  key: string;
  /**
   * The identifier for the key.
   */
  key_id: string;
  title?: string;
  url?: string;
};

/**
 * Secrets for a GitHub Codespace.
 */
export type codespaces_secret = {
  /**
   * The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  created_at: string;
  /**
   * The name of the secret
   */
  name: string;
  /**
   * The API URL at which the list of repositories this secret is visible to can be retrieved
   */
  selected_repositories_url: string;
  /**
   * The date and time at which the secret was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  updated_at: string;
  /**
   * The type of repositories in the organization that the secret is visible to
   */
  visibility: 'all' | 'private' | 'selected';
};

/**
 * The public key used for setting user Codespaces' Secrets.
 */
export type codespaces_user_public_key = {
  /**
   * The Base64 encoded public key.
   */
  key: string;
  /**
   * The identifier for the key.
   */
  key_id: string;
};

/**
 * Collaborator
 */
export type collaborator = {
  avatar_url: string;
  email?: string | null;
  events_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  gravatar_id: string | null;
  html_url: string;
  id: number;
  login: string;
  name?: string | null;
  node_id: string;
  organizations_url: string;
  permissions?: {
    admin: boolean;
    maintain?: boolean;
    pull: boolean;
    push: boolean;
    triage?: boolean;
  };
  received_events_url: string;
  repos_url: string;
  role_name: string;
  site_admin: boolean;
  starred_url: string;
  subscriptions_url: string;
  type: string;
  url: string;
};

export type combined_billing_usage = {
  /**
   * Numbers of days left in billing cycle.
   */
  days_left_in_billing_cycle: number;
  /**
   * Estimated storage space (GB) used in billing cycle.
   */
  estimated_paid_storage_for_month: number;
  /**
   * Estimated sum of free and paid storage space (GB) used in billing cycle.
   */
  estimated_storage_for_month: number;
};

/**
 * Combined Commit Status
 */
export type combined_commit_status = {
  commit_url: string;
  repository: minimal_repository;
  sha: string;
  state: string;
  statuses: Array<simple_commit_status>;
  total_count: number;
  url: string;
};

/**
 * Commit
 */
export type commit = {
  author: nullable_simple_user;
  comments_url: string;
  commit: {
    author: nullable_git_user;
    comment_count: number;
    committer: nullable_git_user;
    message: string;
    tree: {
      sha: string;
      url: string;
    };
    url: string;
    verification?: verification;
  };
  committer: nullable_simple_user;
  files?: Array<diff_entry>;
  html_url: string;
  node_id: string;
  parents: Array<{
    html_url?: string;
    sha: string;
    url: string;
  }>;
  sha: string;
  stats?: {
    additions?: number;
    deletions?: number;
    total?: number;
  };
  url: string;
};

/**
 * Commit Activity
 */
export type commit_activity = {
  days: Array<number>;
  total: number;
  week: number;
};

/**
 * Commit Comment
 */
export type commit_comment = {
  author_association: author_association;
  body: string;
  commit_id: string;
  created_at: string;
  html_url: string;
  id: number;
  line: number | null;
  node_id: string;
  path: string | null;
  position: number | null;
  reactions?: reaction_rollup;
  updated_at: string;
  url: string;
  user: nullable_simple_user;
};

/**
 * Commit Comparison
 */
export type commit_comparison = {
  ahead_by: number;
  base_commit: commit;
  behind_by: number;
  commits: Array<commit>;
  diff_url: string;
  files?: Array<diff_entry>;
  html_url: string;
  merge_base_commit: commit;
  patch_url: string;
  permalink_url: string;
  status: 'diverged' | 'ahead' | 'behind' | 'identical';
  total_commits: number;
  url: string;
};

export type status3 = 'diverged' | 'ahead' | 'behind' | 'identical';

/**
 * Commit Search Result Item
 */
export type commit_search_result_item = {
  author: nullable_simple_user;
  comments_url: string;
  commit: {
    author: {
      date: string;
      email: string;
      name: string;
    };
    comment_count: number;
    committer: nullable_git_user;
    message: string;
    tree: {
      sha: string;
      url: string;
    };
    url: string;
    verification?: verification;
  };
  committer: nullable_git_user;
  html_url: string;
  node_id: string;
  parents: Array<{
    html_url?: string;
    sha?: string;
    url?: string;
  }>;
  repository: minimal_repository;
  score: number;
  sha: string;
  text_matches?: search_result_text_matches;
  url: string;
};

/**
 * Community Profile
 */
export type community_profile = {
  content_reports_enabled?: boolean;
  description: string | null;
  documentation: string | null;
  files: {
    code_of_conduct: nullable_code_of_conduct_simple;
    code_of_conduct_file: nullable_community_health_file;
    contributing: nullable_community_health_file;
    issue_template: nullable_community_health_file;
    license: nullable_license_simple;
    pull_request_template: nullable_community_health_file;
    readme: nullable_community_health_file;
  };
  health_percentage: number;
  updated_at: string | null;
};

/**
 * A list of directory items
 */
export type content_directory = Array<{
  _links: {
    git: string | null;
    html: string | null;
    self: string;
  };
  content?: string;
  download_url: string | null;
  git_url: string | null;
  html_url: string | null;
  name: string;
  path: string;
  sha: string;
  size: number;
  type: 'dir' | 'file' | 'submodule' | 'symlink';
  url: string;
}>;

/**
 * Content File
 */
export type content_file = {
  _links: {
    git: string | null;
    html: string | null;
    self: string;
  };
  content: string;
  download_url: string | null;
  encoding: string;
  git_url: string | null;
  html_url: string | null;
  name: string;
  path: string;
  sha: string;
  size: number;
  submodule_git_url?: string;
  target?: string;
  type: 'file';
  url: string;
};

export type type = 'file';

/**
 * An object describing a submodule
 */
export type content_submodule = {
  _links: {
    git: string | null;
    html: string | null;
    self: string;
  };
  download_url: string | null;
  git_url: string | null;
  html_url: string | null;
  name: string;
  path: string;
  sha: string;
  size: number;
  submodule_git_url: string;
  type: 'submodule';
  url: string;
};

export type type2 = 'submodule';

/**
 * An object describing a symlink
 */
export type content_symlink = {
  _links: {
    git: string | null;
    html: string | null;
    self: string;
  };
  download_url: string | null;
  git_url: string | null;
  html_url: string | null;
  name: string;
  path: string;
  sha: string;
  size: number;
  target: string;
  type: 'symlink';
  url: string;
};

export type type3 = 'symlink';

/**
 * Content Traffic
 */
export type content_traffic = {
  count: number;
  path: string;
  title: string;
  uniques: number;
};

/**
 * Content Tree
 */
export type content_tree = {
  _links: {
    git: string | null;
    html: string | null;
    self: string;
  };
  download_url: string | null;
  entries?: Array<{
    _links: {
      git: string | null;
      html: string | null;
      self: string;
    };
    content?: string;
    download_url: string | null;
    git_url: string | null;
    html_url: string | null;
    name: string;
    path: string;
    sha: string;
    size: number;
    type: string;
    url: string;
  }>;
  git_url: string | null;
  html_url: string | null;
  name: string;
  path: string;
  sha: string;
  size: number;
  type: string;
  url: string;
};

/**
 * Contributor
 */
export type contributor = {
  avatar_url?: string;
  contributions: number;
  email?: string;
  events_url?: string;
  followers_url?: string;
  following_url?: string;
  gists_url?: string;
  gravatar_id?: string | null;
  html_url?: string;
  id?: number;
  login?: string;
  name?: string;
  node_id?: string;
  organizations_url?: string;
  received_events_url?: string;
  repos_url?: string;
  site_admin?: boolean;
  starred_url?: string;
  subscriptions_url?: string;
  type: string;
  url?: string;
};

/**
 * Contributor Activity
 */
export type contributor_activity = {
  author: nullable_simple_user;
  total: number;
  weeks: Array<{
    a?: number;
    c?: number;
    d?: number;
    w?: number;
  }>;
};

/**
 * Converted Note to Issue Issue Event
 */
export type converted_note_to_issue_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: integration;
  project_card?: {
    column_name: string;
    id: number;
    previous_column_name?: string;
    project_id: number;
    project_url: string;
    url: string;
  };
  url: string;
};

/**
 * Demilestoned Issue Event
 */
export type demilestoned_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  milestone: {
    title: string;
  };
  node_id: string;
  performed_via_github_app: nullable_integration;
  url: string;
};

/**
 * A Dependabot alert.
 */
export type dependabot_alert = {
  created_at: alert_created_at;
  /**
   * Details for the vulnerable dependency.
   */
  readonly dependency: {
    /**
     * The full path to the dependency manifest file, relative to the root of the repository.
     */
    readonly manifest_path?: string;
    package?: dependabot_alert_package;
    /**
     * The execution scope of the vulnerable dependency.
     */
    readonly scope?: ('development' | 'runtime') | null;
  };
  dismissed_at: alert_dismissed_at;
  dismissed_by: nullable_simple_user;
  /**
   * An optional comment associated with the alert's dismissal.
   */
  dismissed_comment: string | null;
  /**
   * The reason that the alert was dismissed.
   */
  dismissed_reason: ('fix_started' | 'inaccurate' | 'no_bandwidth' | 'not_used' | 'tolerable_risk') | null;
  fixed_at: alert_fixed_at;
  html_url: alert_html_url;
  number: alert_number;
  security_advisory: dependabot_alert_security_advisory;
  security_vulnerability: dependabot_alert_security_vulnerability;
  /**
   * The state of the Dependabot alert.
   */
  readonly state: 'dismissed' | 'fixed' | 'open';
  updated_at: alert_updated_at;
  url: alert_url;
};

/**
 * The execution scope of the vulnerable dependency.
 */
export type scope = 'development' | 'runtime';

/**
 * The reason that the alert was dismissed.
 */
export type dismissed_reason = 'fix_started' | 'inaccurate' | 'no_bandwidth' | 'not_used' | 'tolerable_risk';

/**
 * The state of the Dependabot alert.
 */
export type state2 = 'dismissed' | 'fixed' | 'open';

/**
 * Details for the vulnerable package.
 */
export type dependabot_alert_package = {
  /**
   * The package's language or package management ecosystem.
   */
  readonly ecosystem: string;
  /**
   * The unique package name within its ecosystem.
   */
  readonly name: string;
};

/**
 * Details for the GitHub Security Advisory.
 */
export type dependabot_alert_security_advisory = {
  /**
   * The unique CVE ID assigned to the advisory.
   */
  readonly cve_id: string | null;
  /**
   * Details for the advisory pertaining to the Common Vulnerability Scoring System.
   */
  readonly cvss: {
    /**
     * The overall CVSS score of the advisory.
     */
    readonly score: number;
    /**
     * The full CVSS vector string for the advisory.
     */
    readonly vector_string: string | null;
  };
  /**
   * Details for the advisory pertaining to Common Weakness Enumeration.
   */
  readonly cwes: Array<{
    /**
     * The unique CWE ID.
     */
    readonly cwe_id: string;
    /**
     * The short, plain text name of the CWE.
     */
    readonly name: string;
  }>;
  /**
   * A long-form Markdown-supported description of the advisory.
   */
  readonly description: string;
  /**
   * The unique GitHub Security Advisory ID assigned to the advisory.
   */
  readonly ghsa_id: string;
  /**
   * Values that identify this advisory among security information sources.
   */
  readonly identifiers: Array<{
    /**
     * The type of advisory identifier.
     */
    readonly type: 'CVE' | 'GHSA';
    /**
     * The value of the advisory identifer.
     */
    readonly value: string;
  }>;
  /**
   * The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  readonly published_at: string;
  /**
   * Links to additional advisory information.
   */
  readonly references: Array<{
    /**
     * The URL of the reference.
     */
    readonly url: string;
  }>;
  /**
   * The severity of the advisory.
   */
  readonly severity: 'low' | 'medium' | 'high' | 'critical';
  /**
   * A short, plain text summary of the advisory.
   */
  readonly summary: string;
  /**
   * The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  readonly updated_at: string;
  /**
   * Vulnerable version range information for the advisory.
   */
  readonly vulnerabilities: Array<dependabot_alert_security_vulnerability>;
  /**
   * The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  readonly withdrawn_at: string | null;
};

/**
 * The severity of the advisory.
 */
export type severity2 = 'low' | 'medium' | 'high' | 'critical';

/**
 * Details pertaining to one vulnerable version range for the advisory.
 */
export type dependabot_alert_security_vulnerability = {
  /**
   * Details pertaining to the package version that patches this vulnerability.
   */
  readonly first_patched_version: {
    /**
     * The package version that patches this vulnerability.
     */
    readonly identifier: string;
  } | null;
  package: dependabot_alert_package;
  /**
   * The severity of the vulnerability.
   */
  readonly severity: 'low' | 'medium' | 'high' | 'critical';
  /**
   * Conditions that identify vulnerable versions of this vulnerability's package.
   */
  readonly vulnerable_version_range: string;
};

/**
 * A Dependabot alert.
 */
export type dependabot_alert_with_repository = {
  created_at: alert_created_at;
  /**
   * Details for the vulnerable dependency.
   */
  readonly dependency: {
    /**
     * The full path to the dependency manifest file, relative to the root of the repository.
     */
    readonly manifest_path?: string;
    package?: dependabot_alert_package;
    /**
     * The execution scope of the vulnerable dependency.
     */
    readonly scope?: ('development' | 'runtime') | null;
  };
  dismissed_at: alert_dismissed_at;
  dismissed_by: nullable_simple_user;
  /**
   * An optional comment associated with the alert's dismissal.
   */
  dismissed_comment: string | null;
  /**
   * The reason that the alert was dismissed.
   */
  dismissed_reason: ('fix_started' | 'inaccurate' | 'no_bandwidth' | 'not_used' | 'tolerable_risk') | null;
  fixed_at: alert_fixed_at;
  html_url: alert_html_url;
  number: alert_number;
  repository: simple_repository;
  security_advisory: dependabot_alert_security_advisory;
  security_vulnerability: dependabot_alert_security_vulnerability;
  /**
   * The state of the Dependabot alert.
   */
  readonly state: 'dismissed' | 'fixed' | 'open';
  updated_at: alert_updated_at;
  url: alert_url;
};

/**
 * The public key used for setting Dependabot Secrets.
 */
export type dependabot_public_key = {
  /**
   * The Base64 encoded public key.
   */
  key: string;
  /**
   * The identifier for the key.
   */
  key_id: string;
};

/**
 * Set secrets for Dependabot.
 */
export type dependabot_secret = {
  created_at: string;
  /**
   * The name of the secret.
   */
  name: string;
  updated_at: string;
};

export type dependency = {
  /**
   * Array of package-url (PURLs) of direct child dependencies.
   */
  dependencies?: Array<string>;
  metadata?: metadata;
  /**
   * Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.
   */
  package_url?: string;
  /**
   * A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.
   */
  relationship?: 'direct' | 'indirect';
  /**
   * A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.
   */
  scope?: 'runtime' | 'development';
};

/**
 * A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.
 */
export type relationship = 'direct' | 'indirect';

/**
 * A diff of the dependencies between two commits.
 */
export type dependency_graph_diff = Array<{
  change_type: 'added' | 'removed';
  ecosystem: string;
  license: string | null;
  manifest: string;
  name: string;
  package_url: string | null;
  /**
   * Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.
   */
  scope: 'string' | 'runtime' | 'development';
  source_repository_url: string | null;
  version: string;
  vulnerabilities: Array<{
    advisory_ghsa_id: string;
    advisory_summary: string;
    advisory_url: string;
    severity: string;
  }>;
}>;

/**
 * An SSH key granting access to a single repository.
 */
export type deploy_key = {
  added_by?: string | null;
  created_at: string;
  id: number;
  key: string;
  last_used?: string | null;
  read_only: boolean;
  title: string;
  url: string;
  verified: boolean;
};

/**
 * A request for a specific ref(branch,sha,tag) to be deployed
 */
export type deployment = {
  created_at: string;
  creator: nullable_simple_user;
  description: string | null;
  /**
   * Name for the target deployment environment.
   */
  environment: string;
  /**
   * Unique identifier of the deployment
   */
  id: number;
  node_id: string;
  original_environment?: string;
  payload:
    | {
        [key: string]: string;
      }
    | string;
  performed_via_github_app?: nullable_integration;
  /**
   * Specifies if the given environment is one that end-users directly interact with. Default: false.
   */
  production_environment?: boolean;
  /**
   * The ref to deploy. This can be a branch, tag, or sha.
   */
  ref: string;
  repository_url: string;
  sha: string;
  statuses_url: string;
  /**
   * Parameter to specify a task to execute
   */
  task: string;
  /**
   * Specifies if the given environment is will no longer exist at some point in the future. Default: false.
   */
  transient_environment?: boolean;
  updated_at: string;
  url: string;
};

/**
 * Details of a deployment branch policy.
 */
export type deployment_branch_policy = {
  /**
   * The unique identifier of the branch policy.
   */
  id?: number;
  /**
   * The name pattern that branches must match in order to deploy to the environment.
   */
  name?: string;
  node_id?: string;
};

export type deployment_branch_policy_name_pattern = {
  /**
   * The name pattern that branches must match in order to deploy to the environment.
   *
   * Wildcard characters will not match `/`. For example, to match branches that begin with `release/` and contain an additional single slash, use `release**`.
   * For more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch).
   */
  name: string;
};

/**
 * The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`.
 */
export type deployment_branch_policy_settings = {
  /**
   * Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`.
   */
  custom_branch_policies: boolean;
  /**
   * Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`.
   */
  protected_branches: boolean;
} | null;

/**
 * The type of reviewer.
 */
export type deployment_reviewer_type = 'User' | 'Team';

/**
 * A deployment created as the result of an Actions check run from a workflow that references an environment
 */
export type deployment_simple = {
  created_at: string;
  description: string | null;
  /**
   * Name for the target deployment environment.
   */
  environment: string;
  /**
   * Unique identifier of the deployment
   */
  id: number;
  node_id: string;
  original_environment?: string;
  performed_via_github_app?: nullable_integration;
  /**
   * Specifies if the given environment is one that end-users directly interact with. Default: false.
   */
  production_environment?: boolean;
  repository_url: string;
  statuses_url: string;
  /**
   * Parameter to specify a task to execute
   */
  task: string;
  /**
   * Specifies if the given environment is will no longer exist at some point in the future. Default: false.
   */
  transient_environment?: boolean;
  updated_at: string;
  url: string;
};

/**
 * The status of a deployment.
 */
export type deployment_status = {
  created_at: string;
  creator: nullable_simple_user;
  deployment_url: string;
  /**
   * A short description of the status.
   */
  description: string;
  /**
   * The environment of the deployment that the status is for.
   */
  environment?: string;
  /**
   * The URL for accessing your environment.
   */
  environment_url?: string;
  id: number;
  /**
   * The URL to associate with this status.
   */
  log_url?: string;
  node_id: string;
  performed_via_github_app?: nullable_integration;
  repository_url: string;
  /**
   * The state of the status.
   */
  state: 'error' | 'failure' | 'inactive' | 'pending' | 'success' | 'queued' | 'in_progress';
  /**
   * Deprecated: the URL to associate with this status.
   */
  target_url: string;
  updated_at: string;
  url: string;
};

/**
 * The state of the status.
 */
export type state3 = 'error' | 'failure' | 'inactive' | 'pending' | 'success' | 'queued' | 'in_progress';

/**
 * Diff Entry
 */
export type diff_entry = {
  additions: number;
  blob_url: string;
  changes: number;
  contents_url: string;
  deletions: number;
  filename: string;
  patch?: string;
  previous_filename?: string;
  raw_url: string;
  sha: string;
  status: 'added' | 'removed' | 'modified' | 'renamed' | 'copied' | 'changed' | 'unchanged';
};

export type status4 = 'added' | 'removed' | 'modified' | 'renamed' | 'copied' | 'changed' | 'unchanged';

/**
 * A Discussion in a repository.
 */
export type discussion = {
  active_lock_reason: string | null;
  answer_chosen_at: string | null;
  answer_chosen_by: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  answer_html_url: string | null;
  /**
   * How the author is associated with the repository.
   */
  author_association:
    | 'COLLABORATOR'
    | 'CONTRIBUTOR'
    | 'FIRST_TIMER'
    | 'FIRST_TIME_CONTRIBUTOR'
    | 'MANNEQUIN'
    | 'MEMBER'
    | 'NONE'
    | 'OWNER';
  body: string;
  category: {
    created_at: string;
    description: string;
    emoji: string;
    id: number;
    is_answerable: boolean;
    name: string;
    node_id?: string;
    repository_id: number;
    slug: string;
    updated_at: string;
  };
  comments: number;
  created_at: string;
  html_url: string;
  id: number;
  locked: boolean;
  node_id: string;
  number: number;
  reactions?: {
    '+1': number;
    '-1': number;
    confused: number;
    eyes: number;
    heart: number;
    hooray: number;
    laugh: number;
    rocket: number;
    total_count: number;
    url: string;
  };
  repository_url: string;
  /**
   * The current state of the discussion.
   * `converting` means that the discussion is being converted from an issue.
   * `transferring` means that the discussion is being transferred from another repository.
   */
  state: 'open' | 'locked' | 'converting' | 'transferring';
  timeline_url?: string;
  title: string;
  updated_at: string;
  user: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
};

export type type4 = 'Bot' | 'User' | 'Organization';

/**
 * How the author is associated with the repository.
 */
export type author_association2 =
  | 'COLLABORATOR'
  | 'CONTRIBUTOR'
  | 'FIRST_TIMER'
  | 'FIRST_TIME_CONTRIBUTOR'
  | 'MANNEQUIN'
  | 'MEMBER'
  | 'NONE'
  | 'OWNER';

/**
 * The current state of the discussion.
 * `converting` means that the discussion is being converted from an issue.
 * `transferring` means that the discussion is being transferred from another repository.
 */
export type state4 = 'open' | 'locked' | 'converting' | 'transferring';

/**
 * Email
 */
export type email = {
  email: string;
  primary: boolean;
  verified: boolean;
  visibility: string | null;
};

/**
 * An object without any properties.
 */
export type empty_object = {
  [key: string]: string;
};

/**
 * The policy that controls the repositories in the organization that are allowed to run GitHub Actions.
 */
export type enabled_repositories = 'all' | 'none' | 'selected';

/**
 * An enterprise on GitHub.
 */
export type enterprise = {
  avatar_url: string;
  created_at: string | null;
  /**
   * A short description of the enterprise.
   */
  description?: string | null;
  html_url: string;
  /**
   * Unique identifier of the enterprise
   */
  id: number;
  /**
   * The name of the enterprise.
   */
  name: string;
  node_id: string;
  /**
   * The slug url identifier for the enterprise.
   */
  slug: string;
  updated_at: string | null;
  /**
   * The enterprise's website URL.
   */
  website_url?: string | null;
};

/**
 * Details of a deployment environment
 */
export type environment = {
  /**
   * The time that the environment was created, in ISO 8601 format.
   */
  created_at: string;
  deployment_branch_policy?: deployment_branch_policy_settings;
  html_url: string;
  /**
   * The id of the environment.
   */
  id: number;
  /**
   * The name of the environment.
   */
  name: string;
  node_id: string;
  protection_rules?: Array<
    | {
        id: number;
        node_id: string;
        type: string;
        wait_timer?: wait_timer;
      }
    | {
        id: number;
        node_id: string;
        /**
         * The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
         */
        reviewers?: Array<{
          reviewer?: simple_user | team;
          type?: deployment_reviewer_type;
        }>;
        type: string;
      }
    | {
        id: number;
        node_id: string;
        type: string;
      }
  >;
  /**
   * The time that the environment was last updated, in ISO 8601 format.
   */
  updated_at: string;
  url: string;
};

/**
 * An entry in the reviews log for environment deployments
 */
export type environment_approvals = {
  /**
   * The comment submitted with the deployment review
   */
  comment: string;
  /**
   * The list of environments that were approved or rejected
   */
  environments: Array<{
    /**
     * The time that the environment was created, in ISO 8601 format.
     */
    created_at?: string;
    html_url?: string;
    /**
     * The id of the environment.
     */
    id?: number;
    /**
     * The name of the environment.
     */
    name?: string;
    node_id?: string;
    /**
     * The time that the environment was last updated, in ISO 8601 format.
     */
    updated_at?: string;
    url?: string;
  }>;
  /**
   * Whether deployment to the environment(s) was approved or rejected or pending (with comments)
   */
  state: 'approved' | 'rejected' | 'pending';
  user: simple_user;
};

/**
 * Whether deployment to the environment(s) was approved or rejected or pending (with comments)
 */
export type state5 = 'approved' | 'rejected' | 'pending';

/**
 * Event
 */
export type event = {
  actor: actor;
  created_at: string | null;
  id: string;
  org?: actor;
  payload: {
    action?: string;
    comment?: issue_comment;
    issue?: issue;
    pages?: Array<{
      action?: string;
      html_url?: string;
      page_name?: string;
      sha?: string;
      summary?: string | null;
      title?: string;
    }>;
  };
  public: boolean;
  repo: {
    id: number;
    name: string;
    url: string;
  };
  type: string | null;
};

/**
 * Feed
 */
export type feed = {
  _links: {
    current_user?: link_with_type;
    current_user_actor?: link_with_type;
    current_user_organization?: link_with_type;
    current_user_organizations?: Array<link_with_type>;
    current_user_public?: link_with_type;
    repository_discussions?: link_with_type;
    repository_discussions_category?: link_with_type;
    security_advisories?: link_with_type;
    timeline: link_with_type;
    user: link_with_type;
  };
  current_user_actor_url?: string;
  current_user_organization_url?: string;
  current_user_organization_urls?: Array<string>;
  current_user_public_url?: string;
  current_user_url?: string;
  /**
   * A feed of discussions for a given repository and category.
   */
  repository_discussions_category_url?: string;
  /**
   * A feed of discussions for a given repository.
   */
  repository_discussions_url?: string;
  security_advisories_url?: string;
  timeline_url: string;
  user_url: string;
};

/**
 * File Commit
 */
export type file_commit = {
  commit: {
    author?: {
      date?: string;
      email?: string;
      name?: string;
    };
    committer?: {
      date?: string;
      email?: string;
      name?: string;
    };
    html_url?: string;
    message?: string;
    node_id?: string;
    parents?: Array<{
      html_url?: string;
      sha?: string;
      url?: string;
    }>;
    sha?: string;
    tree?: {
      sha?: string;
      url?: string;
    };
    url?: string;
    verification?: {
      payload?: string | null;
      reason?: string;
      signature?: string | null;
      verified?: boolean;
    };
  };
  content: {
    _links?: {
      git?: string;
      html?: string;
      self?: string;
    };
    download_url?: string;
    git_url?: string;
    html_url?: string;
    name?: string;
    path?: string;
    sha?: string;
    size?: number;
    type?: string;
    url?: string;
  } | null;
};

/**
 * Full Repository
 */
export type full_repository = {
  allow_auto_merge?: boolean;
  allow_forking?: boolean;
  allow_merge_commit?: boolean;
  allow_rebase_merge?: boolean;
  allow_squash_merge?: boolean;
  allow_update_branch?: boolean;
  /**
   * Whether anonymous git access is allowed.
   */
  anonymous_access_enabled?: boolean;
  archive_url: string;
  archived: boolean;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  clone_url: string;
  code_of_conduct?: code_of_conduct_simple;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  created_at: string;
  default_branch: string;
  delete_branch_on_merge?: boolean;
  deployments_url: string;
  description: string | null;
  /**
   * Returns whether or not this repository disabled.
   */
  disabled: boolean;
  downloads_url: string;
  events_url: string;
  fork: boolean;
  forks: number;
  forks_count: number;
  forks_url: string;
  full_name: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  has_discussions: boolean;
  has_downloads: boolean;
  has_issues: boolean;
  has_pages: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  homepage: string | null;
  hooks_url: string;
  html_url: string;
  id: number;
  is_template?: boolean;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  language: string | null;
  languages_url: string;
  license: nullable_license_simple;
  master_branch?: string;
  /**
   * The default value for a merge commit message.
   *
   * - `PR_TITLE` - default to the pull request's title.
   * - `PR_BODY` - default to the pull request's body.
   * - `BLANK` - default to a blank commit message.
   */
  merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
  /**
   * The default value for a merge commit title.
   *
   * - `PR_TITLE` - default to the pull request's title.
   * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
   */
  merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
  merges_url: string;
  milestones_url: string;
  mirror_url: string | null;
  name: string;
  network_count: number;
  node_id: string;
  notifications_url: string;
  open_issues: number;
  open_issues_count: number;
  organization?: nullable_simple_user;
  owner: simple_user;
  parent?: repository;
  permissions?: {
    admin: boolean;
    maintain?: boolean;
    pull: boolean;
    push: boolean;
    triage?: boolean;
  };
  private: boolean;
  pulls_url: string;
  pushed_at: string;
  releases_url: string;
  security_and_analysis?: security_and_analysis;
  /**
   * The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
   */
  size: number;
  source?: repository;
  /**
   * The default value for a squash merge commit message:
   *
   * - `PR_BODY` - default to the pull request's body.
   * - `COMMIT_MESSAGES` - default to the branch's commit messages.
   * - `BLANK` - default to a blank commit message.
   */
  squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
  /**
   * The default value for a squash merge commit title:
   *
   * - `PR_TITLE` - default to the pull request's title.
   * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
   */
  squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
  ssh_url: string;
  stargazers_count: number;
  stargazers_url: string;
  statuses_url: string;
  subscribers_count: number;
  subscribers_url: string;
  subscription_url: string;
  svn_url: string;
  tags_url: string;
  teams_url: string;
  temp_clone_token?: string | null;
  template_repository?: nullable_repository;
  topics?: Array<string>;
  trees_url: string;
  updated_at: string;
  url: string;
  use_squash_pr_title_as_default?: boolean;
  /**
   * The repository visibility: public, private, or internal.
   */
  visibility?: string;
  watchers: number;
  watchers_count: number;
  web_commit_signoff_required?: boolean;
};

/**
 * The default value for a merge commit message.
 *
 * - `PR_TITLE` - default to the pull request's title.
 * - `PR_BODY` - default to the pull request's body.
 * - `BLANK` - default to a blank commit message.
 */
export type merge_commit_message = 'PR_BODY' | 'PR_TITLE' | 'BLANK';

/**
 * The default value for a merge commit title.
 *
 * - `PR_TITLE` - default to the pull request's title.
 * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
 */
export type merge_commit_title = 'PR_TITLE' | 'MERGE_MESSAGE';

/**
 * The default value for a squash merge commit message:
 *
 * - `PR_BODY` - default to the pull request's body.
 * - `COMMIT_MESSAGES` - default to the branch's commit messages.
 * - `BLANK` - default to a blank commit message.
 */
export type squash_merge_commit_message = 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';

/**
 * The default value for a squash merge commit title:
 *
 * - `PR_TITLE` - default to the pull request's title.
 * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
 */
export type squash_merge_commit_title = 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';

/**
 * A comment made to a gist.
 */
export type gist_comment = {
  author_association: author_association;
  /**
   * The comment text.
   */
  body: string;
  created_at: string;
  id: number;
  node_id: string;
  updated_at: string;
  url: string;
  user: nullable_simple_user;
};

/**
 * Gist Commit
 */
export type gist_commit = {
  change_status: {
    additions?: number;
    deletions?: number;
    total?: number;
  };
  committed_at: string;
  url: string;
  user: nullable_simple_user;
  version: string;
};

/**
 * Gist History
 */
export type gist_history = {
  change_status?: {
    additions?: number;
    deletions?: number;
    total?: number;
  };
  committed_at?: string;
  url?: string;
  user?: nullable_simple_user;
  version?: string;
};

/**
 * Gist Simple
 */
export type gist_simple = {
  comments?: number;
  comments_url?: string;
  commits_url?: string;
  created_at?: string;
  description?: string | null;
  files?: {
    [key: string]: {
      content?: string;
      filename?: string;
      language?: string;
      raw_url?: string;
      size?: number;
      truncated?: boolean;
      type?: string;
    } | null;
  };
  /**
   * Gist
   */
  fork_of?: {
    comments: number;
    comments_url: string;
    commits_url: string;
    created_at: string;
    description: string | null;
    files: {
      [key: string]: {
        filename?: string;
        language?: string;
        raw_url?: string;
        size?: number;
        type?: string;
      };
    };
    forks?: Array<string>;
    forks_url: string;
    git_pull_url: string;
    git_push_url: string;
    history?: Array<string>;
    html_url: string;
    id: string;
    node_id: string;
    owner?: nullable_simple_user;
    public: boolean;
    truncated?: boolean;
    updated_at: string;
    url: string;
    user: nullable_simple_user;
  } | null;
  /**
   * @deprecated
   */
  forks?: Array<{
    created_at?: string;
    id?: string;
    updated_at?: string;
    url?: string;
    user?: public_user;
  }> | null;
  forks_url?: string;
  git_pull_url?: string;
  git_push_url?: string;
  /**
   * @deprecated
   */
  history?: Array<gist_history> | null;
  html_url?: string;
  id?: string;
  node_id?: string;
  owner?: simple_user;
  public?: boolean;
  truncated?: boolean;
  updated_at?: string;
  url?: string;
  user?: string | null;
};

/**
 * Low-level Git commit operations within a repository
 */
export type git_commit = {
  /**
   * Identifying information for the git-user
   */
  author: {
    /**
     * Timestamp of the commit
     */
    date: string;
    /**
     * Git email address of the user
     */
    email: string;
    /**
     * Name of the git user
     */
    name: string;
  };
  /**
   * Identifying information for the git-user
   */
  committer: {
    /**
     * Timestamp of the commit
     */
    date: string;
    /**
     * Git email address of the user
     */
    email: string;
    /**
     * Name of the git user
     */
    name: string;
  };
  html_url: string;
  /**
   * Message describing the purpose of the commit
   */
  message: string;
  node_id: string;
  parents: Array<{
    html_url: string;
    /**
     * SHA for the commit
     */
    sha: string;
    url: string;
  }>;
  /**
   * SHA for the commit
   */
  sha: string;
  tree: {
    /**
     * SHA for the commit
     */
    sha: string;
    url: string;
  };
  url: string;
  verification: {
    payload: string | null;
    reason: string;
    signature: string | null;
    verified: boolean;
  };
};

/**
 * Git references within a repository
 */
export type git_ref = {
  node_id: string;
  object: {
    /**
     * SHA for the reference
     */
    sha: string;
    type: string;
    url: string;
  };
  ref: string;
  url: string;
};

/**
 * Metadata for a Git tag
 */
export type git_tag = {
  /**
   * Message describing the purpose of the tag
   */
  message: string;
  node_id: string;
  object: {
    sha: string;
    type: string;
    url: string;
  };
  sha: string;
  /**
   * Name of the tag
   */
  tag: string;
  tagger: {
    date: string;
    email: string;
    name: string;
  };
  /**
   * URL for the tag
   */
  url: string;
  verification?: verification;
};

/**
 * The hierarchy between files in a Git repository.
 */
export type git_tree = {
  sha: string;
  /**
   * Objects specifying a tree structure
   */
  tree: Array<{
    mode?: string;
    path?: string;
    sha?: string;
    size?: number;
    type?: string;
    url?: string;
  }>;
  truncated: boolean;
  url: string;
};

/**
 * Gitignore Template
 */
export type gitignore_template = {
  name: string;
  source: string;
};

/**
 * A unique encryption key
 */
export type gpg_key = {
  can_certify: boolean;
  can_encrypt_comms: boolean;
  can_encrypt_storage: boolean;
  can_sign: boolean;
  created_at: string;
  emails: Array<{
    email?: string;
    verified?: boolean;
  }>;
  expires_at: string | null;
  id: number;
  key_id: string;
  name?: string | null;
  primary_key_id: number | null;
  public_key: string;
  raw_key: string | null;
  revoked: boolean;
  subkeys: Array<{
    can_certify?: boolean;
    can_encrypt_comms?: boolean;
    can_encrypt_storage?: boolean;
    can_sign?: boolean;
    created_at?: string;
    emails?: Array<string>;
    expires_at?: string | null;
    id?: number;
    key_id?: string;
    primary_key_id?: number;
    public_key?: string;
    raw_key?: string | null;
    revoked?: boolean;
    subkeys?: Array<string>;
  }>;
};

/**
 * Webhooks for repositories.
 */
export type hook = {
  /**
   * Determines whether the hook is actually triggered on pushes.
   */
  active: boolean;
  config: {
    content_type?: webhook_config_content_type;
    digest?: string;
    email?: string;
    insecure_ssl?: webhook_config_insecure_ssl;
    password?: string;
    room?: string;
    secret?: webhook_config_secret;
    subdomain?: string;
    token?: string;
    url?: webhook_config_url;
  };
  created_at: string;
  deliveries_url?: string;
  /**
   * Determines what events the hook is triggered for. Default: ['push'].
   */
  events: Array<string>;
  /**
   * Unique identifier of the webhook.
   */
  id: number;
  last_response: hook_response;
  /**
   * The name of a valid service, use 'web' for a webhook.
   */
  name: string;
  ping_url: string;
  test_url: string;
  type: string;
  updated_at: string;
  url: string;
};

/**
 * Delivery made by a webhook.
 */
export type hook_delivery = {
  /**
   * The type of activity for the event that triggered the delivery.
   */
  action: string | null;
  /**
   * Time when the delivery was delivered.
   */
  delivered_at: string;
  /**
   * Time spent delivering.
   */
  duration: number;
  /**
   * The event that triggered the delivery.
   */
  event: string;
  /**
   * Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
   */
  guid: string;
  /**
   * Unique identifier of the delivery.
   */
  id: number;
  /**
   * The id of the GitHub App installation associated with this event.
   */
  installation_id: number | null;
  /**
   * Whether the delivery is a redelivery.
   */
  redelivery: boolean;
  /**
   * The id of the repository associated with this event.
   */
  repository_id: number | null;
  request: {
    /**
     * The request headers sent with the webhook delivery.
     */
    headers: {
      [key: string]: string;
    } | null;
    /**
     * The webhook payload.
     */
    payload: {
      [key: string]: string;
    } | null;
  };
  response: {
    /**
     * The response headers received when the delivery was made.
     */
    headers: {
      [key: string]: string;
    } | null;
    /**
     * The response payload received.
     */
    payload: {
      [key: string]: string;
    } | null;
  };
  /**
   * Description of the status of the attempted delivery
   */
  status: string;
  /**
   * Status code received when delivery was made.
   */
  status_code: number;
  /**
   * The URL target of the delivery.
   */
  url?: string;
};

/**
 * Delivery made by a webhook, without request and response information.
 */
export type hook_delivery_item = {
  /**
   * The type of activity for the event that triggered the delivery.
   */
  action: string | null;
  /**
   * Time when the webhook delivery occurred.
   */
  delivered_at: string;
  /**
   * Time spent delivering.
   */
  duration: number;
  /**
   * The event that triggered the delivery.
   */
  event: string;
  /**
   * Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).
   */
  guid: string;
  /**
   * Unique identifier of the webhook delivery.
   */
  id: number;
  /**
   * The id of the GitHub App installation associated with this event.
   */
  installation_id: number | null;
  /**
   * Whether the webhook delivery is a redelivery.
   */
  redelivery: boolean;
  /**
   * The id of the repository associated with this event.
   */
  repository_id: number | null;
  /**
   * Describes the response returned after attempting the delivery.
   */
  status: string;
  /**
   * Status code received when delivery was made.
   */
  status_code: number;
};

export type hook_response = {
  code: number | null;
  message: string | null;
  status: string | null;
};

/**
 * Hovercard
 */
export type hovercard = {
  contexts: Array<{
    message: string;
    octicon: string;
  }>;
};

/**
 * A repository import from an external source.
 */
export type _import = {
  authors_count?: number | null;
  authors_url: string;
  commit_count?: number | null;
  error_message?: string | null;
  failed_step?: string | null;
  has_large_files?: boolean;
  html_url: string;
  import_percent?: number | null;
  large_files_count?: number;
  large_files_size?: number;
  message?: string;
  project_choices?: Array<{
    human_name?: string;
    tfvc_project?: string;
    vcs?: string;
  }>;
  push_percent?: number | null;
  repository_url: string;
  status:
    | 'auth'
    | 'error'
    | 'none'
    | 'detecting'
    | 'choose'
    | 'auth_failed'
    | 'importing'
    | 'mapping'
    | 'waiting_to_push'
    | 'pushing'
    | 'complete'
    | 'setup'
    | 'string'
    | 'detection_found_multiple'
    | 'detection_found_nothing'
    | 'detection_needs_auth';
  status_text?: string | null;
  svc_root?: string;
  svn_root?: string;
  tfvc_project?: string;
  url: string;
  use_lfs?: boolean;
  vcs: string | null;
  /**
   * The URL of the originating repository.
   */
  vcs_url: string;
};

export type status5 =
  | 'auth'
  | 'error'
  | 'none'
  | 'detecting'
  | 'choose'
  | 'auth_failed'
  | 'importing'
  | 'mapping'
  | 'waiting_to_push'
  | 'pushing'
  | 'complete'
  | 'setup'
  | 'string'
  | 'detection_found_multiple'
  | 'detection_found_nothing'
  | 'detection_needs_auth';

/**
 * Installation
 */
export type installation = {
  access_tokens_url: string;
  account: (simple_user | enterprise) | null;
  app_id: number;
  app_slug: string;
  contact_email?: string | null;
  created_at: string;
  events: Array<string>;
  has_multiple_single_files?: boolean;
  html_url: string;
  /**
   * The ID of the installation.
   */
  id: number;
  permissions: app_permissions;
  repositories_url: string;
  /**
   * Describe whether all repositories have been selected or there's a selection involved
   */
  repository_selection: 'all' | 'selected';
  single_file_name: string | null;
  single_file_paths?: Array<string>;
  suspended_at: string | null;
  suspended_by: nullable_simple_user;
  /**
   * The ID of the user or organization this token is being scoped to.
   */
  target_id: number;
  target_type: string;
  updated_at: string;
};

/**
 * Authentication token for a GitHub App installed on a user or org.
 */
export type installation_token = {
  expires_at: string;
  has_multiple_single_files?: boolean;
  permissions?: app_permissions;
  repositories?: Array<repository>;
  repository_selection?: 'all' | 'selected';
  single_file?: string;
  single_file_paths?: Array<string>;
  token: string;
};

/**
 * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
 */
export type integration = {
  client_id?: string;
  client_secret?: string;
  created_at: string;
  description: string | null;
  /**
   * The list of events for the GitHub app
   */
  events: Array<string>;
  external_url: string;
  html_url: string;
  /**
   * Unique identifier of the GitHub app
   */
  id: number;
  /**
   * The number of installations associated with the GitHub app
   */
  installations_count?: number;
  /**
   * The name of the GitHub app
   */
  name: string;
  node_id: string;
  owner: nullable_simple_user;
  pem?: string;
  /**
   * The set of permissions for the GitHub app
   */
  permissions: {
    checks?: string;
    contents?: string;
    deployments?: string;
    issues?: string;
    metadata?: string;
    [key: string]: string | undefined;
  };
  /**
   * The slug name of the GitHub app
   */
  slug?: string;
  updated_at: string;
  webhook_secret?: string | null;
};

/**
 * The duration of the interaction restriction. Default: `one_day`.
 */
export type interaction_expiry = 'one_day' | 'three_days' | 'one_week' | 'one_month' | 'six_months';

/**
 * The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect.
 */
export type interaction_group = 'existing_users' | 'contributors_only' | 'collaborators_only';

/**
 * Limit interactions to a specific type of user for a specified duration
 */
export type interaction_limit = {
  expiry?: interaction_expiry;
  limit: interaction_group;
};

/**
 * Interaction limit settings.
 */
export type interaction_limit_response = {
  expires_at: string;
  limit: interaction_group;
  origin: string;
};

/**
 * Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
 */
export type issue = {
  active_lock_reason?: string | null;
  assignee: nullable_simple_user;
  assignees?: Array<simple_user> | null;
  author_association: author_association;
  /**
   * Contents of the issue
   */
  body?: string | null;
  body_html?: string;
  body_text?: string;
  closed_at: string | null;
  closed_by?: nullable_simple_user;
  comments: number;
  comments_url: string;
  created_at: string;
  draft?: boolean;
  events_url: string;
  html_url: string;
  id: number;
  /**
   * Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
   */
  labels: Array<
    | string
    | {
        color?: string | null;
        default?: boolean;
        description?: string | null;
        id?: number;
        name?: string;
        node_id?: string;
        url?: string;
      }
  >;
  labels_url: string;
  locked: boolean;
  milestone: nullable_milestone;
  node_id: string;
  /**
   * Number uniquely identifying the issue within its repository
   */
  number: number;
  performed_via_github_app?: nullable_integration;
  pull_request?: {
    diff_url: string | null;
    html_url: string | null;
    merged_at?: string | null;
    patch_url: string | null;
    url: string | null;
  };
  reactions?: reaction_rollup;
  repository?: repository;
  repository_url: string;
  /**
   * State of the issue; either 'open' or 'closed'
   */
  state: string;
  /**
   * The reason for the current state
   */
  state_reason?: ('completed' | 'reopened' | 'not_planned') | null;
  timeline_url?: string;
  /**
   * Title of the issue
   */
  title: string;
  updated_at: string;
  /**
   * URL for the issue
   */
  url: string;
  user: nullable_simple_user;
};

/**
 * The reason for the current state
 */
export type state_reason = 'completed' | 'reopened' | 'not_planned';

/**
 * Comments provide a way for people to collaborate on an issue.
 */
export type issue_comment = {
  author_association: author_association;
  /**
   * Contents of the issue comment
   */
  body?: string;
  body_html?: string;
  body_text?: string;
  created_at: string;
  html_url: string;
  /**
   * Unique identifier of the issue comment
   */
  id: number;
  issue_url: string;
  node_id: string;
  performed_via_github_app?: nullable_integration;
  reactions?: reaction_rollup;
  updated_at: string;
  /**
   * URL for the issue comment
   */
  url: string;
  user: nullable_simple_user;
};

/**
 * Issue Event
 */
export type issue_event = {
  actor: nullable_simple_user;
  assignee?: nullable_simple_user;
  assigner?: nullable_simple_user;
  author_association?: author_association;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  dismissed_review?: issue_event_dismissed_review;
  event: string;
  id: number;
  issue?: nullable_issue;
  label?: issue_event_label;
  lock_reason?: string | null;
  milestone?: issue_event_milestone;
  node_id: string;
  performed_via_github_app?: nullable_integration;
  project_card?: issue_event_project_card;
  rename?: issue_event_rename;
  requested_reviewer?: nullable_simple_user;
  requested_team?: team;
  review_requester?: nullable_simple_user;
  url: string;
};

export type issue_event_dismissed_review = {
  dismissal_commit_id?: string | null;
  dismissal_message: string | null;
  review_id: number;
  state: string;
};

/**
 * Issue Event for Issue
 */
export type issue_event_for_issue =
  | labeled_issue_event
  | unlabeled_issue_event
  | assigned_issue_event
  | unassigned_issue_event
  | milestoned_issue_event
  | demilestoned_issue_event
  | renamed_issue_event
  | review_requested_issue_event
  | review_request_removed_issue_event
  | review_dismissed_issue_event
  | locked_issue_event
  | added_to_project_issue_event
  | moved_column_in_project_issue_event
  | removed_from_project_issue_event
  | converted_note_to_issue_issue_event;

/**
 * Issue Event Label
 */
export type issue_event_label = {
  color: string | null;
  name: string | null;
};

/**
 * Issue Event Milestone
 */
export type issue_event_milestone = {
  title: string;
};

/**
 * Issue Event Project Card
 */
export type issue_event_project_card = {
  column_name: string;
  id: number;
  previous_column_name?: string;
  project_id: number;
  project_url: string;
  url: string;
};

/**
 * Issue Event Rename
 */
export type issue_event_rename = {
  from: string;
  to: string;
};

/**
 * Issue Search Result Item
 */
export type issue_search_result_item = {
  active_lock_reason?: string | null;
  assignee: nullable_simple_user;
  assignees?: Array<simple_user> | null;
  author_association: author_association;
  body?: string;
  body_html?: string;
  body_text?: string;
  closed_at: string | null;
  comments: number;
  comments_url: string;
  created_at: string;
  draft?: boolean;
  events_url: string;
  html_url: string;
  id: number;
  labels: Array<{
    color?: string;
    default?: boolean;
    description?: string | null;
    id?: number;
    name?: string;
    node_id?: string;
    url?: string;
  }>;
  labels_url: string;
  locked: boolean;
  milestone: nullable_milestone;
  node_id: string;
  number: number;
  performed_via_github_app?: nullable_integration;
  pull_request?: {
    diff_url: string | null;
    html_url: string | null;
    merged_at?: string | null;
    patch_url: string | null;
    url: string | null;
  };
  reactions?: reaction_rollup;
  repository?: repository;
  repository_url: string;
  score: number;
  state: string;
  state_reason?: string | null;
  text_matches?: search_result_text_matches;
  timeline_url?: string;
  title: string;
  updated_at: string;
  url: string;
  user: nullable_simple_user;
};

/**
 * Information of a job execution in a workflow run
 */
export type job = {
  check_run_url: string;
  /**
   * The time that the job finished, in ISO 8601 format.
   */
  completed_at: string | null;
  /**
   * The outcome of the job.
   */
  conclusion: ('success' | 'failure' | 'neutral' | 'cancelled' | 'skipped' | 'timed_out' | 'action_required') | null;
  /**
   * The name of the current branch.
   */
  head_branch: string | null;
  /**
   * The SHA of the commit that is being run.
   */
  head_sha: string;
  html_url: string | null;
  /**
   * The id of the job.
   */
  id: number;
  /**
   * Labels for the workflow job. Specified by the "runs_on" attribute in the action's workflow file.
   */
  labels: Array<string>;
  /**
   * The name of the job.
   */
  name: string;
  node_id: string;
  /**
   * Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.
   */
  run_attempt?: number;
  /**
   * The id of the associated workflow run.
   */
  run_id: number;
  run_url: string;
  /**
   * The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
   */
  runner_group_id: number | null;
  /**
   * The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
   */
  runner_group_name: string | null;
  /**
   * The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
   */
  runner_id: number | null;
  /**
   * The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)
   */
  runner_name: string | null;
  /**
   * The time that the job started, in ISO 8601 format.
   */
  started_at: string;
  /**
   * The phase of the lifecycle that the job is currently in.
   */
  status: 'queued' | 'in_progress' | 'completed';
  /**
   * Steps in this job.
   */
  steps?: Array<{
    /**
     * The time that the job finished, in ISO 8601 format.
     */
    completed_at?: string | null;
    /**
     * The outcome of the job.
     */
    conclusion: string | null;
    /**
     * The name of the job.
     */
    name: string;
    number: number;
    /**
     * The time that the step started, in ISO 8601 format.
     */
    started_at?: string | null;
    /**
     * The phase of the lifecycle that the job is currently in.
     */
    status: 'queued' | 'in_progress' | 'completed';
  }>;
  url: string;
  /**
   * The name of the workflow.
   */
  workflow_name: string | null;
};

/**
 * Key
 */
export type key = {
  created_at: string;
  id: number;
  key: string;
  read_only: boolean;
  title: string;
  url: string;
  verified: boolean;
};

/**
 * Key Simple
 */
export type key_simple = {
  id: number;
  key: string;
};

/**
 * Color-coded labels help you categorize and filter your issues (just like labels in Gmail).
 */
export type label = {
  /**
   * 6-character hex code, without the leading #, identifying the color
   */
  color: string;
  default: boolean;
  description: string | null;
  id: number;
  /**
   * The name of the label.
   */
  name: string;
  node_id: string;
  /**
   * URL for the label
   */
  url: string;
};

/**
 * Label Search Result Item
 */
export type label_search_result_item = {
  color: string;
  default: boolean;
  description: string | null;
  id: number;
  name: string;
  node_id: string;
  score: number;
  text_matches?: search_result_text_matches;
  url: string;
};

/**
 * Labeled Issue Event
 */
export type labeled_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  label: {
    color: string;
    name: string;
  };
  node_id: string;
  performed_via_github_app: nullable_integration;
  url: string;
};

/**
 * Language
 */
export type language = {
  [key: string]: number;
};

/**
 * License
 */
export type license = {
  body: string;
  conditions: Array<string>;
  description: string;
  featured: boolean;
  html_url: string;
  implementation: string;
  key: string;
  limitations: Array<string>;
  name: string;
  node_id: string;
  permissions: Array<string>;
  spdx_id: string | null;
  url: string | null;
};

/**
 * License Content
 */
export type license_content = {
  _links: {
    git: string | null;
    html: string | null;
    self: string;
  };
  content: string;
  download_url: string | null;
  encoding: string;
  git_url: string | null;
  html_url: string | null;
  license: nullable_license_simple;
  name: string;
  path: string;
  sha: string;
  size: number;
  type: string;
  url: string;
};

/**
 * License Simple
 */
export type license_simple = {
  html_url?: string;
  key: string;
  name: string;
  node_id: string;
  spdx_id: string | null;
  url: string | null;
};

/**
 * Hypermedia Link
 */
export type link = {
  href: string;
};

/**
 * Hypermedia Link with Type
 */
export type link_with_type = {
  href: string;
  type: string;
};

/**
 * Locked Issue Event
 */
export type locked_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  lock_reason: string | null;
  node_id: string;
  performed_via_github_app: nullable_integration;
  url: string;
};

export type manifest = {
  file?: {
    /**
     * The path of the manifest file relative to the root of the Git repository.
     */
    source_location?: string;
  };
  metadata?: metadata;
  /**
   * The name of the manifest.
   */
  name: string;
  /**
   * A collection of resolved package dependencies.
   */
  resolved?: {
    [key: string]: dependency;
  };
};

export type marketplace_account = {
  email?: string | null;
  id: number;
  login: string;
  node_id?: string;
  organization_billing_email?: string | null;
  type: string;
  url: string;
};

/**
 * Marketplace Listing Plan
 */
export type marketplace_listing_plan = {
  accounts_url: string;
  bullets: Array<string>;
  description: string;
  has_free_trial: boolean;
  id: number;
  monthly_price_in_cents: number;
  name: string;
  number: number;
  price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
  state: string;
  unit_name: string | null;
  url: string;
  yearly_price_in_cents: number;
};

export type price_model = 'FREE' | 'FLAT_RATE' | 'PER_UNIT';

/**
 * Marketplace Purchase
 */
export type marketplace_purchase = {
  email?: string | null;
  id: number;
  login: string;
  marketplace_pending_change?: {
    effective_date?: string;
    id?: number;
    is_installed?: boolean;
    plan?: marketplace_listing_plan;
    unit_count?: number | null;
  } | null;
  marketplace_purchase: {
    billing_cycle?: string;
    free_trial_ends_on?: string | null;
    is_installed?: boolean;
    next_billing_date?: string | null;
    on_free_trial?: boolean;
    plan?: marketplace_listing_plan;
    unit_count?: number | null;
    updated_at?: string;
  };
  organization_billing_email?: string;
  type: string;
  url: string;
};

/**
 * Results of a successful merge upstream request
 */
export type merged_upstream = {
  base_branch?: string;
  merge_type?: 'merge' | 'fast-forward' | 'none';
  message?: string;
};

export type merge_type = 'merge' | 'fast-forward' | 'none';

/**
 * User-defined metadata to store domain-specific information limited to 8 keys with scalar values.
 */
export type metadata2 = {
  [key: string]: (string | number | boolean) | null;
};

/**
 * A migration.
 */
export type migration = {
  archive_url?: string;
  created_at: string;
  exclude?: Array<string>;
  exclude_attachments: boolean;
  exclude_git_data: boolean;
  exclude_metadata: boolean;
  exclude_owner_projects: boolean;
  exclude_releases: boolean;
  guid: string;
  id: number;
  lock_repositories: boolean;
  node_id: string;
  org_metadata_only: boolean;
  owner: nullable_simple_user;
  /**
   * The repositories included in the migration. Only returned for export migrations.
   */
  repositories: Array<repository>;
  state: string;
  updated_at: string;
  url: string;
};

/**
 * A collection of related issues and pull requests.
 */
export type milestone = {
  closed_at: string | null;
  closed_issues: number;
  created_at: string;
  creator: nullable_simple_user;
  description: string | null;
  due_on: string | null;
  html_url: string;
  id: number;
  labels_url: string;
  node_id: string;
  /**
   * The number of the milestone.
   */
  number: number;
  open_issues: number;
  /**
   * The state of the milestone.
   */
  state: 'open' | 'closed';
  /**
   * The title of the milestone.
   */
  title: string;
  updated_at: string;
  url: string;
};

/**
 * The state of the milestone.
 */
export type state6 = 'open' | 'closed';

/**
 * Milestoned Issue Event
 */
export type milestoned_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  milestone: {
    title: string;
  };
  node_id: string;
  performed_via_github_app: nullable_integration;
  url: string;
};

/**
 * Minimal Repository
 */
export type minimal_repository = {
  allow_forking?: boolean;
  archive_url: string;
  archived?: boolean;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  clone_url?: string;
  code_of_conduct?: code_of_conduct;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  created_at?: string | null;
  default_branch?: string;
  delete_branch_on_merge?: boolean;
  deployments_url: string;
  description: string | null;
  disabled?: boolean;
  downloads_url: string;
  events_url: string;
  fork: boolean;
  forks?: number;
  forks_count?: number;
  forks_url: string;
  full_name: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url?: string;
  has_discussions?: boolean;
  has_downloads?: boolean;
  has_issues?: boolean;
  has_pages?: boolean;
  has_projects?: boolean;
  has_wiki?: boolean;
  homepage?: string | null;
  hooks_url: string;
  html_url: string;
  id: number;
  is_template?: boolean;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  language?: string | null;
  languages_url: string;
  license?: {
    key?: string;
    name?: string;
    node_id?: string;
    spdx_id?: string;
    url?: string;
  } | null;
  merges_url: string;
  milestones_url: string;
  mirror_url?: string | null;
  name: string;
  network_count?: number;
  node_id: string;
  notifications_url: string;
  open_issues?: number;
  open_issues_count?: number;
  owner: simple_user;
  permissions?: {
    admin?: boolean;
    maintain?: boolean;
    pull?: boolean;
    push?: boolean;
    triage?: boolean;
  };
  private: boolean;
  pulls_url: string;
  pushed_at?: string | null;
  releases_url: string;
  role_name?: string;
  security_and_analysis?: security_and_analysis;
  /**
   * The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
   */
  size?: number;
  ssh_url?: string;
  stargazers_count?: number;
  stargazers_url: string;
  statuses_url: string;
  subscribers_count?: number;
  subscribers_url: string;
  subscription_url: string;
  svn_url?: string;
  tags_url: string;
  teams_url: string;
  temp_clone_token?: string;
  topics?: Array<string>;
  trees_url: string;
  updated_at?: string | null;
  url: string;
  visibility?: string;
  watchers?: number;
  watchers_count?: number;
  web_commit_signoff_required?: boolean;
};

/**
 * Moved Column in Project Issue Event
 */
export type moved_column_in_project_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  project_card?: {
    column_name: string;
    id: number;
    previous_column_name?: string;
    project_id: number;
    project_url: string;
    url: string;
  };
  url: string;
};

/**
 * The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
 */
export type nullable_alert_updated_at = string | null;

/**
 * Code of Conduct Simple
 */
export type nullable_code_of_conduct_simple = {
  html_url: string | null;
  key: string;
  name: string;
  url: string;
} | null;

/**
 * A description of the machine powering a codespace.
 */
export type nullable_codespace_machine = {
  /**
   * How many cores are available to the codespace.
   */
  cpus: number;
  /**
   * The display name of the machine includes cores, memory, and storage.
   */
  display_name: string;
  /**
   * How much memory is available to the codespace.
   */
  memory_in_bytes: number;
  /**
   * The name of the machine.
   */
  name: string;
  /**
   * The operating system of the machine.
   */
  operating_system: string;
  /**
   * Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.
   */
  prebuild_availability: ('none' | 'ready' | 'in_progress') | null;
  /**
   * How much storage is available to the codespace.
   */
  storage_in_bytes: number;
} | null;

/**
 * Collaborator
 */
export type nullable_collaborator = {
  avatar_url: string;
  email?: string | null;
  events_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  gravatar_id: string | null;
  html_url: string;
  id: number;
  login: string;
  name?: string | null;
  node_id: string;
  organizations_url: string;
  permissions?: {
    admin: boolean;
    maintain?: boolean;
    pull: boolean;
    push: boolean;
    triage?: boolean;
  };
  received_events_url: string;
  repos_url: string;
  role_name: string;
  site_admin: boolean;
  starred_url: string;
  subscriptions_url: string;
  type: string;
  url: string;
} | null;

export type nullable_community_health_file = {
  html_url: string;
  url: string;
} | null;

/**
 * Metaproperties for Git author/committer information.
 */
export type nullable_git_user = {
  date?: string;
  email?: string;
  name?: string;
} | null;

/**
 * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
 */
export type nullable_integration = {
  client_id?: string;
  client_secret?: string;
  created_at: string;
  description: string | null;
  /**
   * The list of events for the GitHub app
   */
  events: Array<string>;
  external_url: string;
  html_url: string;
  /**
   * Unique identifier of the GitHub app
   */
  id: number;
  /**
   * The number of installations associated with the GitHub app
   */
  installations_count?: number;
  /**
   * The name of the GitHub app
   */
  name: string;
  node_id: string;
  owner: nullable_simple_user;
  pem?: string;
  /**
   * The set of permissions for the GitHub app
   */
  permissions: {
    checks?: string;
    contents?: string;
    deployments?: string;
    issues?: string;
    metadata?: string;
    [key: string]: string | undefined;
  };
  /**
   * The slug name of the GitHub app
   */
  slug?: string;
  updated_at: string;
  webhook_secret?: string | null;
} | null;

/**
 * Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
 */
export type nullable_issue = {
  active_lock_reason?: string | null;
  assignee: nullable_simple_user;
  assignees?: Array<simple_user> | null;
  author_association: author_association;
  /**
   * Contents of the issue
   */
  body?: string | null;
  body_html?: string;
  body_text?: string;
  closed_at: string | null;
  closed_by?: nullable_simple_user;
  comments: number;
  comments_url: string;
  created_at: string;
  draft?: boolean;
  events_url: string;
  html_url: string;
  id: number;
  /**
   * Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
   */
  labels: Array<
    | string
    | {
        color?: string | null;
        default?: boolean;
        description?: string | null;
        id?: number;
        name?: string;
        node_id?: string;
        url?: string;
      }
  >;
  labels_url: string;
  locked: boolean;
  milestone: nullable_milestone;
  node_id: string;
  /**
   * Number uniquely identifying the issue within its repository
   */
  number: number;
  performed_via_github_app?: nullable_integration;
  pull_request?: {
    diff_url: string | null;
    html_url: string | null;
    merged_at?: string | null;
    patch_url: string | null;
    url: string | null;
  };
  reactions?: reaction_rollup;
  repository?: repository;
  repository_url: string;
  /**
   * State of the issue; either 'open' or 'closed'
   */
  state: string;
  /**
   * The reason for the current state
   */
  state_reason?: ('completed' | 'reopened' | 'not_planned') | null;
  timeline_url?: string;
  /**
   * Title of the issue
   */
  title: string;
  updated_at: string;
  /**
   * URL for the issue
   */
  url: string;
  user: nullable_simple_user;
} | null;

/**
 * License Simple
 */
export type nullable_license_simple = {
  html_url?: string;
  key: string;
  name: string;
  node_id: string;
  spdx_id: string | null;
  url: string | null;
} | null;

/**
 * A collection of related issues and pull requests.
 */
export type nullable_milestone = {
  closed_at: string | null;
  closed_issues: number;
  created_at: string;
  creator: nullable_simple_user;
  description: string | null;
  due_on: string | null;
  html_url: string;
  id: number;
  labels_url: string;
  node_id: string;
  /**
   * The number of the milestone.
   */
  number: number;
  open_issues: number;
  /**
   * The state of the milestone.
   */
  state: 'open' | 'closed';
  /**
   * The title of the milestone.
   */
  title: string;
  updated_at: string;
  url: string;
} | null;

/**
 * Minimal Repository
 */
export type nullable_minimal_repository = {
  allow_forking?: boolean;
  archive_url: string;
  archived?: boolean;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  clone_url?: string;
  code_of_conduct?: code_of_conduct;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  created_at?: string | null;
  default_branch?: string;
  delete_branch_on_merge?: boolean;
  deployments_url: string;
  description: string | null;
  disabled?: boolean;
  downloads_url: string;
  events_url: string;
  fork: boolean;
  forks?: number;
  forks_count?: number;
  forks_url: string;
  full_name: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url?: string;
  has_discussions?: boolean;
  has_downloads?: boolean;
  has_issues?: boolean;
  has_pages?: boolean;
  has_projects?: boolean;
  has_wiki?: boolean;
  homepage?: string | null;
  hooks_url: string;
  html_url: string;
  id: number;
  is_template?: boolean;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  language?: string | null;
  languages_url: string;
  license?: {
    key?: string;
    name?: string;
    node_id?: string;
    spdx_id?: string;
    url?: string;
  } | null;
  merges_url: string;
  milestones_url: string;
  mirror_url?: string | null;
  name: string;
  network_count?: number;
  node_id: string;
  notifications_url: string;
  open_issues?: number;
  open_issues_count?: number;
  owner: simple_user;
  permissions?: {
    admin?: boolean;
    maintain?: boolean;
    pull?: boolean;
    push?: boolean;
    triage?: boolean;
  };
  private: boolean;
  pulls_url: string;
  pushed_at?: string | null;
  releases_url: string;
  role_name?: string;
  security_and_analysis?: security_and_analysis;
  /**
   * The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
   */
  size?: number;
  ssh_url?: string;
  stargazers_count?: number;
  stargazers_url: string;
  statuses_url: string;
  subscribers_count?: number;
  subscribers_url: string;
  subscription_url: string;
  svn_url?: string;
  tags_url: string;
  teams_url: string;
  temp_clone_token?: string;
  topics?: Array<string>;
  trees_url: string;
  updated_at?: string | null;
  url: string;
  visibility?: string;
  watchers?: number;
  watchers_count?: number;
  web_commit_signoff_required?: boolean;
} | null;

/**
 * A repository on GitHub.
 */
export type nullable_repository = {
  /**
   * Whether to allow Auto-merge to be used on pull requests.
   */
  allow_auto_merge?: boolean;
  /**
   * Whether to allow forking this repo
   */
  allow_forking?: boolean;
  /**
   * Whether to allow merge commits for pull requests.
   */
  allow_merge_commit?: boolean;
  /**
   * Whether to allow rebase merges for pull requests.
   */
  allow_rebase_merge?: boolean;
  /**
   * Whether to allow squash merges for pull requests.
   */
  allow_squash_merge?: boolean;
  /**
   * Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
   */
  allow_update_branch?: boolean;
  /**
   * Whether anonymous git access is enabled for this repository
   */
  anonymous_access_enabled?: boolean;
  archive_url: string;
  /**
   * Whether the repository is archived.
   */
  archived: boolean;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  clone_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  created_at: string | null;
  /**
   * The default branch of the repository.
   */
  default_branch: string;
  /**
   * Whether to delete head branches when pull requests are merged
   */
  delete_branch_on_merge?: boolean;
  deployments_url: string;
  description: string | null;
  /**
   * Returns whether or not this repository disabled.
   */
  disabled: boolean;
  downloads_url: string;
  events_url: string;
  fork: boolean;
  forks: number;
  forks_count: number;
  forks_url: string;
  full_name: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  /**
   * Whether discussions are enabled.
   */
  has_discussions?: boolean;
  /**
   * Whether downloads are enabled.
   */
  has_downloads: boolean;
  /**
   * Whether issues are enabled.
   */
  has_issues: boolean;
  has_pages: boolean;
  /**
   * Whether projects are enabled.
   */
  has_projects: boolean;
  /**
   * Whether the wiki is enabled.
   */
  has_wiki: boolean;
  homepage: string | null;
  hooks_url: string;
  html_url: string;
  /**
   * Unique identifier of the repository
   */
  id: number;
  /**
   * Whether this repository acts as a template that can be used to generate new repositories.
   */
  is_template?: boolean;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  language: string | null;
  languages_url: string;
  license: nullable_license_simple;
  master_branch?: string;
  /**
   * The default value for a merge commit message.
   *
   * - `PR_TITLE` - default to the pull request's title.
   * - `PR_BODY` - default to the pull request's body.
   * - `BLANK` - default to a blank commit message.
   */
  merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
  /**
   * The default value for a merge commit title.
   *
   * - `PR_TITLE` - default to the pull request's title.
   * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
   */
  merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
  merges_url: string;
  milestones_url: string;
  mirror_url: string | null;
  /**
   * The name of the repository.
   */
  name: string;
  network_count?: number;
  node_id: string;
  notifications_url: string;
  open_issues: number;
  open_issues_count: number;
  organization?: nullable_simple_user;
  owner: simple_user;
  permissions?: {
    admin: boolean;
    maintain?: boolean;
    pull: boolean;
    push: boolean;
    triage?: boolean;
  };
  /**
   * Whether the repository is private or public.
   */
  private: boolean;
  pulls_url: string;
  pushed_at: string | null;
  releases_url: string;
  /**
   * The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
   */
  size: number;
  /**
   * The default value for a squash merge commit message:
   *
   * - `PR_BODY` - default to the pull request's body.
   * - `COMMIT_MESSAGES` - default to the branch's commit messages.
   * - `BLANK` - default to a blank commit message.
   */
  squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
  /**
   * The default value for a squash merge commit title:
   *
   * - `PR_TITLE` - default to the pull request's title.
   * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
   */
  squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
  ssh_url: string;
  stargazers_count: number;
  stargazers_url: string;
  starred_at?: string;
  statuses_url: string;
  subscribers_count?: number;
  subscribers_url: string;
  subscription_url: string;
  svn_url: string;
  tags_url: string;
  teams_url: string;
  temp_clone_token?: string;
  template_repository?: {
    allow_auto_merge?: boolean;
    allow_merge_commit?: boolean;
    allow_rebase_merge?: boolean;
    allow_squash_merge?: boolean;
    allow_update_branch?: boolean;
    archive_url?: string;
    archived?: boolean;
    assignees_url?: string;
    blobs_url?: string;
    branches_url?: string;
    clone_url?: string;
    collaborators_url?: string;
    comments_url?: string;
    commits_url?: string;
    compare_url?: string;
    contents_url?: string;
    contributors_url?: string;
    created_at?: string;
    default_branch?: string;
    delete_branch_on_merge?: boolean;
    deployments_url?: string;
    description?: string;
    disabled?: boolean;
    downloads_url?: string;
    events_url?: string;
    fork?: boolean;
    forks_count?: number;
    forks_url?: string;
    full_name?: string;
    git_commits_url?: string;
    git_refs_url?: string;
    git_tags_url?: string;
    git_url?: string;
    has_downloads?: boolean;
    has_issues?: boolean;
    has_pages?: boolean;
    has_projects?: boolean;
    has_wiki?: boolean;
    homepage?: string;
    hooks_url?: string;
    html_url?: string;
    id?: number;
    is_template?: boolean;
    issue_comment_url?: string;
    issue_events_url?: string;
    issues_url?: string;
    keys_url?: string;
    labels_url?: string;
    language?: string;
    languages_url?: string;
    /**
     * The default value for a merge commit message.
     *
     * - `PR_TITLE` - default to the pull request's title.
     * - `PR_BODY` - default to the pull request's body.
     * - `BLANK` - default to a blank commit message.
     */
    merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
    /**
     * The default value for a merge commit title.
     *
     * - `PR_TITLE` - default to the pull request's title.
     * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
     */
    merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
    merges_url?: string;
    milestones_url?: string;
    mirror_url?: string;
    name?: string;
    network_count?: number;
    node_id?: string;
    notifications_url?: string;
    open_issues_count?: number;
    owner?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
    permissions?: {
      admin?: boolean;
      maintain?: boolean;
      pull?: boolean;
      push?: boolean;
      triage?: boolean;
    };
    private?: boolean;
    pulls_url?: string;
    pushed_at?: string;
    releases_url?: string;
    size?: number;
    /**
     * The default value for a squash merge commit message:
     *
     * - `PR_BODY` - default to the pull request's body.
     * - `COMMIT_MESSAGES` - default to the branch's commit messages.
     * - `BLANK` - default to a blank commit message.
     */
    squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
    /**
     * The default value for a squash merge commit title:
     *
     * - `PR_TITLE` - default to the pull request's title.
     * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
     */
    squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
    ssh_url?: string;
    stargazers_count?: number;
    stargazers_url?: string;
    statuses_url?: string;
    subscribers_count?: number;
    subscribers_url?: string;
    subscription_url?: string;
    svn_url?: string;
    tags_url?: string;
    teams_url?: string;
    temp_clone_token?: string;
    topics?: Array<string>;
    trees_url?: string;
    updated_at?: string;
    url?: string;
    use_squash_pr_title_as_default?: boolean;
    visibility?: string;
    watchers_count?: number;
  } | null;
  topics?: Array<string>;
  trees_url: string;
  updated_at: string | null;
  url: string;
  /**
   * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
   * @deprecated
   */
  use_squash_pr_title_as_default?: boolean;
  /**
   * The repository visibility: public, private, or internal.
   */
  visibility?: string;
  watchers: number;
  watchers_count: number;
  /**
   * Whether to require contributors to sign off on web-based commits
   */
  web_commit_signoff_required?: boolean;
} | null;

export type nullable_scoped_installation = {
  account: simple_user;
  has_multiple_single_files?: boolean;
  permissions: app_permissions;
  repositories_url: string;
  /**
   * Describe whether all repositories have been selected or there's a selection involved
   */
  repository_selection: 'all' | 'selected';
  single_file_name: string | null;
  single_file_paths?: Array<string>;
} | null;

/**
 * A commit.
 */
export type nullable_simple_commit = {
  author: {
    email: string;
    name: string;
  } | null;
  committer: {
    email: string;
    name: string;
  } | null;
  id: string;
  message: string;
  timestamp: string;
  tree_id: string;
} | null;

/**
 * A GitHub user.
 */
export type nullable_simple_user = {
  avatar_url: string;
  email?: string | null;
  events_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  gravatar_id: string | null;
  html_url: string;
  id: number;
  login: string;
  name?: string | null;
  node_id: string;
  organizations_url: string;
  received_events_url: string;
  repos_url: string;
  site_admin: boolean;
  starred_at?: string;
  starred_url: string;
  subscriptions_url: string;
  type: string;
  url: string;
} | null;

/**
 * Groups of organization members that gives permissions on specified repositories.
 */
export type nullable_team_simple = {
  /**
   * Description of the team
   */
  description: string | null;
  html_url: string;
  /**
   * Unique identifier of the team
   */
  id: number;
  /**
   * Distinguished Name (DN) that team maps to within LDAP environment
   */
  ldap_dn?: string;
  members_url: string;
  /**
   * Name of the team
   */
  name: string;
  node_id: string;
  /**
   * Permission that the team will have for its repositories
   */
  permission: string;
  /**
   * The level of privacy this team should have
   */
  privacy?: string;
  repositories_url: string;
  slug: string;
  /**
   * URL for the team
   */
  url: string;
} | null;

/**
 * Actions OIDC Subject customization
 */
export type oidc_custom_sub = {
  /**
   * Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.
   */
  include_claim_keys: Array<string>;
};

/**
 * Actions OIDC subject customization for a repository
 */
export type oidc_custom_sub_repo = {
  /**
   * Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.
   */
  include_claim_keys?: Array<string>;
  /**
   * Whether to use the default template or not. If `true`, the `include_claim_keys` field is ignored.
   */
  use_default: boolean;
};

/**
 * Org Hook
 */
export type org_hook = {
  active: boolean;
  config: {
    content_type?: string;
    insecure_ssl?: string;
    secret?: string;
    url?: string;
  };
  created_at: string;
  deliveries_url?: string;
  events: Array<string>;
  id: number;
  name: string;
  ping_url: string;
  type: string;
  updated_at: string;
  url: string;
};

/**
 * Org Membership
 */
export type org_membership = {
  organization: organization_simple;
  organization_url: string;
  permissions?: {
    can_create_repository: boolean;
  };
  /**
   * The user's membership type in the organization.
   */
  role: 'admin' | 'member' | 'billing_manager';
  /**
   * The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
   */
  state: 'active' | 'pending';
  url: string;
  user: nullable_simple_user;
};

/**
 * The user's membership type in the organization.
 */
export type role = 'admin' | 'member' | 'billing_manager';

/**
 * The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.
 */
export type state7 = 'active' | 'pending';

/**
 * Secrets for GitHub Actions for an organization.
 */
export type organization_actions_secret = {
  created_at: string;
  /**
   * The name of the secret.
   */
  name: string;
  selected_repositories_url?: string;
  updated_at: string;
  /**
   * Visibility of a secret
   */
  visibility: 'all' | 'private' | 'selected';
};

/**
 * Organization variable for GitHub Actions.
 */
export type organization_actions_variable = {
  /**
   * The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  created_at: string;
  /**
   * The name of the variable.
   */
  name: string;
  selected_repositories_url?: string;
  /**
   * The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.
   */
  updated_at: string;
  /**
   * The value of the variable.
   */
  value: string;
  /**
   * Visibility of a variable
   */
  visibility: 'all' | 'private' | 'selected';
};

/**
 * Secrets for GitHub Dependabot for an organization.
 */
export type organization_dependabot_secret = {
  created_at: string;
  /**
   * The name of the secret.
   */
  name: string;
  selected_repositories_url?: string;
  updated_at: string;
  /**
   * Visibility of a secret
   */
  visibility: 'all' | 'private' | 'selected';
};

/**
 * Organization Full
 */
export type organization_full = {
  /**
   * Whether GitHub Advanced Security is enabled for new repositories and repositories transferred to this organization.
   *
   * This field is only visible to organization owners or members of a team with the security manager role.
   */
  advanced_security_enabled_for_new_repositories?: boolean;
  avatar_url: string;
  billing_email?: string | null;
  blog?: string;
  collaborators?: number | null;
  company?: string;
  created_at: string;
  default_repository_permission?: string | null;
  /**
   * Whether GitHub Advanced Security is automatically enabled for new repositories and repositories transferred to
   * this organization.
   *
   * This field is only visible to organization owners or members of a team with the security manager role.
   */
  dependabot_alerts_enabled_for_new_repositories?: boolean;
  /**
   * Whether dependabot security updates are automatically enabled for new repositories and repositories transferred
   * to this organization.
   *
   * This field is only visible to organization owners or members of a team with the security manager role.
   */
  dependabot_security_updates_enabled_for_new_repositories?: boolean;
  /**
   * Whether dependency graph is automatically enabled for new repositories and repositories transferred to this
   * organization.
   *
   * This field is only visible to organization owners or members of a team with the security manager role.
   */
  dependency_graph_enabled_for_new_repositories?: boolean;
  description: string | null;
  disk_usage?: number | null;
  email?: string;
  events_url: string;
  followers: number;
  following: number;
  has_organization_projects: boolean;
  has_repository_projects: boolean;
  hooks_url: string;
  html_url: string;
  id: number;
  is_verified?: boolean;
  issues_url: string;
  location?: string;
  login: string;
  members_allowed_repository_creation_type?: string;
  members_can_create_internal_repositories?: boolean;
  members_can_create_pages?: boolean;
  members_can_create_private_pages?: boolean;
  members_can_create_private_repositories?: boolean;
  members_can_create_public_pages?: boolean;
  members_can_create_public_repositories?: boolean;
  members_can_create_repositories?: boolean | null;
  members_can_fork_private_repositories?: boolean | null;
  members_url: string;
  name?: string;
  node_id: string;
  owned_private_repos?: number;
  plan?: {
    filled_seats?: number;
    name: string;
    private_repos: number;
    seats?: number;
    space: number;
  };
  private_gists?: number | null;
  public_gists: number;
  public_members_url: string;
  public_repos: number;
  repos_url: string;
  /**
   * Whether secret scanning is automatically enabled for new repositories and repositories transferred to this
   * organization.
   *
   * This field is only visible to organization owners or members of a team with the security manager role.
   */
  secret_scanning_enabled_for_new_repositories?: boolean;
  /**
   * An optional URL string to display to contributors who are blocked from pushing a secret.
   */
  secret_scanning_push_protection_custom_link?: string | null;
  /**
   * Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.
   */
  secret_scanning_push_protection_custom_link_enabled?: boolean;
  /**
   * Whether secret scanning push protection is automatically enabled for new repositories and repositories
   * transferred to this organization.
   *
   * This field is only visible to organization owners or members of a team with the security manager role.
   */
  secret_scanning_push_protection_enabled_for_new_repositories?: boolean;
  total_private_repos?: number;
  twitter_username?: string | null;
  two_factor_requirement_enabled?: boolean | null;
  type: string;
  updated_at: string;
  url: string;
  web_commit_signoff_required?: boolean;
};

/**
 * Organization Invitation
 */
export type organization_invitation = {
  created_at: string;
  email: string | null;
  failed_at?: string | null;
  failed_reason?: string | null;
  id: number;
  invitation_source?: string;
  invitation_teams_url: string;
  inviter: simple_user;
  login: string | null;
  node_id: string;
  role: string;
  team_count: number;
};

export type organization_secret_scanning_alert = {
  created_at?: alert_created_at;
  html_url?: alert_html_url;
  /**
   * The REST API URL of the code locations for this alert.
   */
  locations_url?: string;
  number?: alert_number;
  /**
   * Whether push protection was bypassed for the detected secret.
   */
  push_protection_bypassed?: boolean | null;
  /**
   * The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  push_protection_bypassed_at?: string | null;
  push_protection_bypassed_by?: nullable_simple_user;
  repository?: simple_repository;
  resolution?: secret_scanning_alert_resolution;
  /**
   * The comment that was optionally added when this alert was closed
   */
  resolution_comment?: string | null;
  /**
   * The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  resolved_at?: string | null;
  resolved_by?: nullable_simple_user;
  /**
   * The secret that was detected.
   */
  secret?: string;
  /**
   * The type of secret that secret scanning detected.
   */
  secret_type?: string;
  /**
   * User-friendly name for the detected secret, matching the `secret_type`.
   * For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."
   */
  secret_type_display_name?: string;
  state?: secret_scanning_alert_state;
  updated_at?: nullable_alert_updated_at;
  url?: alert_url;
};

/**
 * A GitHub organization.
 */
export type organization_simple = {
  avatar_url: string;
  description: string | null;
  events_url: string;
  hooks_url: string;
  id: number;
  issues_url: string;
  login: string;
  members_url: string;
  node_id: string;
  public_members_url: string;
  repos_url: string;
  url: string;
};

/**
 * A software package
 */
export type _package = {
  created_at: string;
  html_url: string;
  /**
   * Unique identifier of the package.
   */
  id: number;
  /**
   * The name of the package.
   */
  name: string;
  owner?: nullable_simple_user;
  package_type: 'npm' | 'maven' | 'rubygems' | 'docker' | 'nuget' | 'container';
  repository?: nullable_minimal_repository;
  updated_at: string;
  url: string;
  /**
   * The number of versions of the package.
   */
  version_count: number;
  visibility: 'private' | 'public';
};

export type package_type = 'npm' | 'maven' | 'rubygems' | 'docker' | 'nuget' | 'container';

export type visibility2 = 'private' | 'public';

/**
 * A version of a software package
 */
export type package_version = {
  created_at: string;
  deleted_at?: string;
  description?: string;
  html_url?: string;
  /**
   * Unique identifier of the package version.
   */
  id: number;
  license?: string;
  metadata?: {
    container?: {
      tags: Array<string>;
    };
    docker?: {
      tag?: Array<string>;
    };
    package_type: 'npm' | 'maven' | 'rubygems' | 'docker' | 'nuget' | 'container';
  };
  /**
   * The name of the package version.
   */
  name: string;
  package_html_url: string;
  updated_at: string;
  url: string;
};

export type packages_billing_usage = {
  /**
   * Free storage space (GB) for GitHub Packages.
   */
  included_gigabytes_bandwidth: number;
  /**
   * Sum of the free and paid storage space (GB) for GitHuub Packages.
   */
  total_gigabytes_bandwidth_used: number;
  /**
   * Total paid storage space (GB) for GitHuub Packages.
   */
  total_paid_gigabytes_bandwidth_used: number;
};

/**
 * The configuration for GitHub Pages for a repository.
 */
export type page = {
  /**
   * The process in which the Page will be built.
   */
  build_type?: ('legacy' | 'workflow') | null;
  /**
   * The Pages site's custom domain
   */
  cname: string | null;
  /**
   * Whether the Page has a custom 404 page.
   */
  custom_404: boolean;
  /**
   * The web address the Page can be accessed from.
   */
  html_url?: string;
  https_certificate?: pages_https_certificate;
  /**
   * Whether https is enabled on the domain
   */
  https_enforced?: boolean;
  /**
   * The timestamp when a pending domain becomes unverified.
   */
  pending_domain_unverified_at?: string | null;
  /**
   * The state if the domain is verified
   */
  protected_domain_state?: ('pending' | 'verified' | 'unverified') | null;
  /**
   * Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site.
   */
  public: boolean;
  source?: pages_source_hash;
  /**
   * The status of the most recent build of the Page.
   */
  status: ('built' | 'building' | 'errored') | null;
  /**
   * The API address for accessing this Page resource.
   */
  url: string;
};

/**
 * The process in which the Page will be built.
 */
export type build_type = 'legacy' | 'workflow';

/**
 * The state if the domain is verified
 */
export type protected_domain_state = 'pending' | 'verified' | 'unverified';

/**
 * The status of the most recent build of the Page.
 */
export type status6 = 'built' | 'building' | 'errored';

/**
 * Page Build
 */
export type page_build = {
  commit: string;
  created_at: string;
  duration: number;
  error: {
    message: string | null;
  };
  pusher: nullable_simple_user;
  status: string;
  updated_at: string;
  url: string;
};

/**
 * Page Build Status
 */
export type page_build_status = {
  status: string;
  url: string;
};

/**
 * The GitHub Pages deployment status.
 */
export type page_deployment = {
  /**
   * The URI to the deployed GitHub Pages.
   */
  page_url: string;
  /**
   * The URI to the deployed GitHub Pages preview.
   */
  preview_url?: string;
  /**
   * The URI to monitor GitHub Pages deployment status.
   */
  status_url: string;
};

/**
 * Pages Health Check Status
 */
export type pages_health_check = {
  alt_domain?: {
    caa_error?: string | null;
    dns_resolves?: boolean;
    enforces_https?: boolean;
    has_cname_record?: boolean | null;
    has_mx_records_present?: boolean | null;
    host?: string;
    https_error?: string | null;
    is_a_record?: boolean | null;
    is_apex_domain?: boolean;
    is_cloudflare_ip?: boolean | null;
    is_cname_to_fastly?: boolean | null;
    is_cname_to_github_user_domain?: boolean | null;
    is_cname_to_pages_dot_github_dot_com?: boolean | null;
    is_fastly_ip?: boolean | null;
    is_https_eligible?: boolean | null;
    is_non_github_pages_ip_present?: boolean | null;
    is_old_ip_address?: boolean | null;
    is_pages_domain?: boolean;
    is_pointed_to_github_pages_ip?: boolean | null;
    is_proxied?: boolean | null;
    is_served_by_pages?: boolean | null;
    is_valid?: boolean;
    is_valid_domain?: boolean;
    nameservers?: string;
    reason?: string | null;
    responds_to_https?: boolean;
    should_be_a_record?: boolean | null;
    uri?: string;
  } | null;
  domain?: {
    caa_error?: string | null;
    dns_resolves?: boolean;
    enforces_https?: boolean;
    has_cname_record?: boolean | null;
    has_mx_records_present?: boolean | null;
    host?: string;
    https_error?: string | null;
    is_a_record?: boolean | null;
    is_apex_domain?: boolean;
    is_cloudflare_ip?: boolean | null;
    is_cname_to_fastly?: boolean | null;
    is_cname_to_github_user_domain?: boolean | null;
    is_cname_to_pages_dot_github_dot_com?: boolean | null;
    is_fastly_ip?: boolean | null;
    is_https_eligible?: boolean | null;
    is_non_github_pages_ip_present?: boolean | null;
    is_old_ip_address?: boolean | null;
    is_pages_domain?: boolean;
    is_pointed_to_github_pages_ip?: boolean | null;
    is_proxied?: boolean | null;
    is_served_by_pages?: boolean | null;
    is_valid?: boolean;
    is_valid_domain?: boolean;
    nameservers?: string;
    reason?: string | null;
    responds_to_https?: boolean;
    should_be_a_record?: boolean | null;
    uri?: string;
  };
};

export type pages_https_certificate = {
  description: string;
  /**
   * Array of the domain set and its alternate name (if it is configured)
   */
  domains: Array<string>;
  expires_at?: string;
  state:
    | 'new'
    | 'authorization_created'
    | 'authorization_pending'
    | 'authorized'
    | 'authorization_revoked'
    | 'issued'
    | 'uploaded'
    | 'approved'
    | 'errored'
    | 'bad_authz'
    | 'destroy_pending'
    | 'dns_changed';
};

export type state8 =
  | 'new'
  | 'authorization_created'
  | 'authorization_pending'
  | 'authorized'
  | 'authorization_revoked'
  | 'issued'
  | 'uploaded'
  | 'approved'
  | 'errored'
  | 'bad_authz'
  | 'destroy_pending'
  | 'dns_changed';

export type pages_source_hash = {
  branch: string;
  path: string;
};

export type participation_stats = {
  all: Array<number>;
  owner: Array<number>;
};

/**
 * Details of a deployment that is waiting for protection rules to pass
 */
export type pending_deployment = {
  /**
   * Whether the currently authenticated user can approve the deployment
   */
  current_user_can_approve: boolean;
  environment: {
    html_url?: string;
    /**
     * The id of the environment.
     */
    id?: number;
    /**
     * The name of the environment.
     */
    name?: string;
    node_id?: string;
    url?: string;
  };
  /**
   * The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.
   */
  reviewers: Array<{
    reviewer?: simple_user | team;
    type?: deployment_reviewer_type;
  }>;
  /**
   * The set duration of the wait timer
   */
  wait_timer: number;
  /**
   * The time that the wait timer began.
   */
  wait_timer_started_at: string | null;
};

/**
 * Porter Author
 */
export type porter_author = {
  email: string;
  id: number;
  import_url: string;
  name: string;
  remote_id: string;
  remote_name: string;
  url: string;
};

/**
 * Porter Large File
 */
export type porter_large_file = {
  oid: string;
  path: string;
  ref_name: string;
  size: number;
};

/**
 * Private User
 */
export type private_user = {
  avatar_url: string;
  bio: string | null;
  blog: string | null;
  business_plus?: boolean;
  collaborators: number;
  company: string | null;
  created_at: string;
  disk_usage: number;
  email: string | null;
  events_url: string;
  followers: number;
  followers_url: string;
  following: number;
  following_url: string;
  gists_url: string;
  gravatar_id: string | null;
  hireable: boolean | null;
  html_url: string;
  id: number;
  ldap_dn?: string;
  location: string | null;
  login: string;
  name: string | null;
  node_id: string;
  organizations_url: string;
  owned_private_repos: number;
  plan?: {
    collaborators: number;
    name: string;
    private_repos: number;
    space: number;
  };
  private_gists: number;
  public_gists: number;
  public_repos: number;
  received_events_url: string;
  repos_url: string;
  site_admin: boolean;
  starred_url: string;
  subscriptions_url: string;
  suspended_at?: string | null;
  total_private_repos: number;
  twitter_username?: string | null;
  two_factor_authentication: boolean;
  type: string;
  updated_at: string;
  url: string;
};

/**
 * Projects are a way to organize columns and cards of work.
 */
export type project = {
  /**
   * Body of the project
   */
  body: string | null;
  columns_url: string;
  created_at: string;
  creator: nullable_simple_user;
  html_url: string;
  id: number;
  /**
   * Name of the project
   */
  name: string;
  node_id: string;
  number: number;
  /**
   * The baseline permission that all organization members have on this project. Only present if owner is an organization.
   */
  organization_permission?: 'read' | 'write' | 'admin' | 'none';
  owner_url: string;
  /**
   * Whether or not this project can be seen by everyone. Only present if owner is an organization.
   */
  private?: boolean;
  /**
   * State of the project; either 'open' or 'closed'
   */
  state: string;
  updated_at: string;
  url: string;
};

/**
 * The baseline permission that all organization members have on this project. Only present if owner is an organization.
 */
export type organization_permission = 'read' | 'write' | 'admin' | 'none';

/**
 * Project cards represent a scope of work.
 */
export type project_card = {
  /**
   * Whether or not the card is archived
   */
  archived?: boolean;
  column_name?: string;
  column_url: string;
  content_url?: string;
  created_at: string;
  creator: nullable_simple_user;
  /**
   * The project card's ID
   */
  id: number;
  node_id: string;
  note: string | null;
  project_id?: string;
  project_url: string;
  updated_at: string;
  url: string;
};

/**
 * Project Collaborator Permission
 */
export type project_collaborator_permission = {
  permission: string;
  user: nullable_simple_user;
};

/**
 * Project columns contain cards of work.
 */
export type project_column = {
  cards_url: string;
  created_at: string;
  /**
   * The unique identifier of the project column
   */
  id: number;
  /**
   * Name of the project column
   */
  name: string;
  node_id: string;
  project_url: string;
  updated_at: string;
  url: string;
};

/**
 * A projects v2 project
 */
export type projects_v2 = {
  closed_at: string | null;
  created_at: string;
  creator: simple_user;
  deleted_at: string | null;
  deleted_by: nullable_simple_user;
  description: string | null;
  id: number;
  node_id: string;
  number: number;
  owner: simple_user;
  public: boolean;
  short_description: string | null;
  title: string;
  updated_at: string;
};

/**
 * An item belonging to a project
 */
export type projects_v2_item = {
  archived_at: string | null;
  content_node_id: string;
  content_type: projects_v2_item_content_type;
  created_at: string;
  creator?: simple_user;
  id: number;
  node_id?: string;
  project_node_id?: string;
  updated_at: string;
};

/**
 * The type of content tracked in a project item
 */
export type projects_v2_item_content_type = 'Issue' | 'PullRequest' | 'DraftIssue';

/**
 * Branch protections protect branches
 */
export type protected_branch = {
  allow_deletions?: {
    enabled: boolean;
  };
  allow_force_pushes?: {
    enabled: boolean;
  };
  /**
   * Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.
   */
  allow_fork_syncing?: {
    enabled?: boolean;
  };
  block_creations?: {
    enabled: boolean;
  };
  enforce_admins?: {
    enabled: boolean;
    url: string;
  };
  /**
   * Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.
   */
  lock_branch?: {
    enabled?: boolean;
  };
  required_conversation_resolution?: {
    enabled?: boolean;
  };
  required_linear_history?: {
    enabled: boolean;
  };
  required_pull_request_reviews?: {
    bypass_pull_request_allowances?: {
      apps?: Array<integration>;
      teams: Array<team>;
      users: Array<simple_user>;
    };
    dismiss_stale_reviews?: boolean;
    dismissal_restrictions?: {
      apps?: Array<integration>;
      teams: Array<team>;
      teams_url: string;
      url: string;
      users: Array<simple_user>;
      users_url: string;
    };
    require_code_owner_reviews?: boolean;
    /**
     * Whether the most recent push must be approved by someone other than the person who pushed it.
     */
    require_last_push_approval?: boolean;
    required_approving_review_count?: number;
    url: string;
  };
  required_signatures?: {
    enabled: boolean;
    url: string;
  };
  required_status_checks?: status_check_policy;
  restrictions?: branch_restriction_policy;
  url: string;
};

/**
 * Protected Branch Admin Enforced
 */
export type protected_branch_admin_enforced = {
  enabled: boolean;
  url: string;
};

/**
 * Protected Branch Pull Request Review
 */
export type protected_branch_pull_request_review = {
  /**
   * Allow specific users, teams, or apps to bypass pull request requirements.
   */
  bypass_pull_request_allowances?: {
    /**
     * The list of apps allowed to bypass pull request requirements.
     */
    apps?: Array<integration>;
    /**
     * The list of teams allowed to bypass pull request requirements.
     */
    teams?: Array<team>;
    /**
     * The list of users allowed to bypass pull request requirements.
     */
    users?: Array<simple_user>;
  };
  dismiss_stale_reviews: boolean;
  dismissal_restrictions?: {
    /**
     * The list of apps with review dismissal access.
     */
    apps?: Array<integration>;
    /**
     * The list of teams with review dismissal access.
     */
    teams?: Array<team>;
    teams_url?: string;
    url?: string;
    /**
     * The list of users with review dismissal access.
     */
    users?: Array<simple_user>;
    users_url?: string;
  };
  require_code_owner_reviews: boolean;
  /**
   * Whether the most recent push must be approved by someone other than the person who pushed it.
   */
  require_last_push_approval?: boolean;
  required_approving_review_count?: number;
  url?: string;
};

/**
 * Protected Branch Required Status Check
 */
export type protected_branch_required_status_check = {
  checks: Array<{
    app_id: number | null;
    context: string;
  }>;
  contexts: Array<string>;
  contexts_url?: string;
  enforcement_level?: string;
  strict?: boolean;
  url?: string;
};

/**
 * Public User
 */
export type public_user = {
  avatar_url: string;
  bio: string | null;
  blog: string | null;
  collaborators?: number;
  company: string | null;
  created_at: string;
  disk_usage?: number;
  email: string | null;
  events_url: string;
  followers: number;
  followers_url: string;
  following: number;
  following_url: string;
  gists_url: string;
  gravatar_id: string | null;
  hireable: boolean | null;
  html_url: string;
  id: number;
  location: string | null;
  login: string;
  name: string | null;
  node_id: string;
  organizations_url: string;
  owned_private_repos?: number;
  plan?: {
    collaborators: number;
    name: string;
    private_repos: number;
    space: number;
  };
  private_gists?: number;
  public_gists: number;
  public_repos: number;
  received_events_url: string;
  repos_url: string;
  site_admin: boolean;
  starred_url: string;
  subscriptions_url: string;
  suspended_at?: string | null;
  total_private_repos?: number;
  twitter_username?: string | null;
  type: string;
  updated_at: string;
  url: string;
};

/**
 * Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.
 */
export type pull_request = {
  _links: {
    comments: link;
    commits: link;
    html: link;
    issue: link;
    review_comment: link;
    review_comments: link;
    self: link;
    statuses: link;
  };
  active_lock_reason?: string | null;
  additions: number;
  assignee: nullable_simple_user;
  assignees?: Array<simple_user> | null;
  author_association: author_association;
  auto_merge: auto_merge;
  base: {
    label: string;
    ref: string;
    repo: {
      allow_forking?: boolean;
      allow_merge_commit?: boolean;
      allow_rebase_merge?: boolean;
      allow_squash_merge?: boolean;
      archive_url: string;
      archived: boolean;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      clone_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      created_at: string;
      default_branch: string;
      deployments_url: string;
      description: string | null;
      disabled: boolean;
      downloads_url: string;
      events_url: string;
      fork: boolean;
      forks: number;
      forks_count: number;
      forks_url: string;
      full_name: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      has_discussions: boolean;
      has_downloads: boolean;
      has_issues: boolean;
      has_pages: boolean;
      has_projects: boolean;
      has_wiki: boolean;
      homepage: string | null;
      hooks_url: string;
      html_url: string;
      id: number;
      is_template?: boolean;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      language: string | null;
      languages_url: string;
      license: nullable_license_simple;
      master_branch?: string;
      merges_url: string;
      milestones_url: string;
      mirror_url: string | null;
      name: string;
      node_id: string;
      notifications_url: string;
      open_issues: number;
      open_issues_count: number;
      owner: {
        avatar_url: string;
        events_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        gravatar_id: string | null;
        html_url: string;
        id: number;
        login: string;
        node_id: string;
        organizations_url: string;
        received_events_url: string;
        repos_url: string;
        site_admin: boolean;
        starred_url: string;
        subscriptions_url: string;
        type: string;
        url: string;
      };
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        pull: boolean;
        push: boolean;
        triage?: boolean;
      };
      private: boolean;
      pulls_url: string;
      pushed_at: string;
      releases_url: string;
      size: number;
      ssh_url: string;
      stargazers_count: number;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      svn_url: string;
      tags_url: string;
      teams_url: string;
      temp_clone_token?: string;
      topics?: Array<string>;
      trees_url: string;
      updated_at: string;
      url: string;
      /**
       * The repository visibility: public, private, or internal.
       */
      visibility?: string;
      watchers: number;
      watchers_count: number;
      web_commit_signoff_required?: boolean;
    };
    sha: string;
    user: {
      avatar_url: string;
      events_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      gravatar_id: string | null;
      html_url: string;
      id: number;
      login: string;
      node_id: string;
      organizations_url: string;
      received_events_url: string;
      repos_url: string;
      site_admin: boolean;
      starred_url: string;
      subscriptions_url: string;
      type: string;
      url: string;
    };
  };
  body: string | null;
  changed_files: number;
  closed_at: string | null;
  comments: number;
  comments_url: string;
  commits: number;
  commits_url: string;
  created_at: string;
  deletions: number;
  diff_url: string;
  /**
   * Indicates whether or not the pull request is a draft.
   */
  draft?: boolean;
  head: {
    label: string;
    ref: string;
    repo: {
      allow_forking?: boolean;
      allow_merge_commit?: boolean;
      allow_rebase_merge?: boolean;
      allow_squash_merge?: boolean;
      archive_url: string;
      archived: boolean;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      clone_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      created_at: string;
      default_branch: string;
      deployments_url: string;
      description: string | null;
      disabled: boolean;
      downloads_url: string;
      events_url: string;
      fork: boolean;
      forks: number;
      forks_count: number;
      forks_url: string;
      full_name: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      has_discussions: boolean;
      has_downloads: boolean;
      has_issues: boolean;
      has_pages: boolean;
      has_projects: boolean;
      has_wiki: boolean;
      homepage: string | null;
      hooks_url: string;
      html_url: string;
      id: number;
      is_template?: boolean;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      language: string | null;
      languages_url: string;
      license: {
        key: string;
        name: string;
        node_id: string;
        spdx_id: string | null;
        url: string | null;
      } | null;
      master_branch?: string;
      merges_url: string;
      milestones_url: string;
      mirror_url: string | null;
      name: string;
      node_id: string;
      notifications_url: string;
      open_issues: number;
      open_issues_count: number;
      owner: {
        avatar_url: string;
        events_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        gravatar_id: string | null;
        html_url: string;
        id: number;
        login: string;
        node_id: string;
        organizations_url: string;
        received_events_url: string;
        repos_url: string;
        site_admin: boolean;
        starred_url: string;
        subscriptions_url: string;
        type: string;
        url: string;
      };
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        pull: boolean;
        push: boolean;
        triage?: boolean;
      };
      private: boolean;
      pulls_url: string;
      pushed_at: string;
      releases_url: string;
      size: number;
      ssh_url: string;
      stargazers_count: number;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      svn_url: string;
      tags_url: string;
      teams_url: string;
      temp_clone_token?: string;
      topics?: Array<string>;
      trees_url: string;
      updated_at: string;
      url: string;
      /**
       * The repository visibility: public, private, or internal.
       */
      visibility?: string;
      watchers: number;
      watchers_count: number;
      web_commit_signoff_required?: boolean;
    } | null;
    sha: string;
    user: {
      avatar_url: string;
      events_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      gravatar_id: string | null;
      html_url: string;
      id: number;
      login: string;
      node_id: string;
      organizations_url: string;
      received_events_url: string;
      repos_url: string;
      site_admin: boolean;
      starred_url: string;
      subscriptions_url: string;
      type: string;
      url: string;
    };
  };
  html_url: string;
  id: number;
  issue_url: string;
  labels: Array<{
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    name: string;
    node_id: string;
    url: string;
  }>;
  locked: boolean;
  /**
   * Indicates whether maintainers can modify the pull request.
   */
  maintainer_can_modify: boolean;
  merge_commit_sha: string | null;
  mergeable: boolean | null;
  mergeable_state: string;
  merged: boolean;
  merged_at: string | null;
  merged_by: nullable_simple_user;
  milestone: nullable_milestone;
  node_id: string;
  /**
   * Number uniquely identifying the pull request within its repository.
   */
  number: number;
  patch_url: string;
  rebaseable?: boolean | null;
  requested_reviewers?: Array<simple_user> | null;
  requested_teams?: Array<team_simple> | null;
  review_comment_url: string;
  review_comments: number;
  review_comments_url: string;
  /**
   * State of this Pull Request. Either `open` or `closed`.
   */
  state: 'open' | 'closed';
  statuses_url: string;
  /**
   * The title of the pull request.
   */
  title: string;
  updated_at: string;
  url: string;
  user: nullable_simple_user;
};

/**
 * Pull Request Merge Result
 */
export type pull_request_merge_result = {
  merged: boolean;
  message: string;
  sha: string;
};

export type pull_request_minimal = {
  base: {
    ref: string;
    repo: {
      id: number;
      name: string;
      url: string;
    };
    sha: string;
  };
  head: {
    ref: string;
    repo: {
      id: number;
      name: string;
      url: string;
    };
    sha: string;
  };
  id: number;
  number: number;
  url: string;
};

/**
 * Pull Request Reviews are reviews on pull requests.
 */
export type pull_request_review = {
  _links: {
    html: {
      href: string;
    };
    pull_request: {
      href: string;
    };
  };
  author_association: author_association;
  /**
   * The text of the review.
   */
  body: string;
  body_html?: string;
  body_text?: string;
  /**
   * A commit SHA for the review. If the commit object was garbage collected or forcibly deleted, then it no longer exists in Git and this value will be `null`.
   */
  commit_id: string | null;
  html_url: string;
  /**
   * Unique identifier of the review
   */
  id: number;
  node_id: string;
  pull_request_url: string;
  state: string;
  submitted_at?: string;
  user: nullable_simple_user;
};

/**
 * Pull Request Review Comments are comments on a portion of the Pull Request's diff.
 */
export type pull_request_review_comment = {
  _links: {
    html: {
      href: string;
    };
    pull_request: {
      href: string;
    };
    self: {
      href: string;
    };
  };
  author_association: author_association;
  /**
   * The text of the comment.
   */
  body: string;
  body_html?: string;
  body_text?: string;
  /**
   * The SHA of the commit to which the comment applies.
   */
  commit_id: string;
  created_at: string;
  /**
   * The diff of the line that the comment refers to.
   */
  diff_hunk: string;
  /**
   * HTML URL for the pull request review comment.
   */
  html_url: string;
  /**
   * The ID of the pull request review comment.
   */
  id: number;
  /**
   * The comment ID to reply to.
   */
  in_reply_to_id?: number;
  /**
   * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
   */
  line?: number;
  /**
   * The node ID of the pull request review comment.
   */
  node_id: string;
  /**
   * The SHA of the original commit to which the comment applies.
   */
  original_commit_id: string;
  /**
   * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
   */
  original_line?: number;
  /**
   * The index of the original line in the diff to which the comment applies. This field is deprecated; use `original_line` instead.
   */
  original_position: number;
  /**
   * The first line of the range for a multi-line comment.
   */
  original_start_line?: number | null;
  /**
   * The relative path of the file to which the comment applies.
   */
  path: string;
  /**
   * The line index in the diff to which the comment applies. This field is deprecated; use `line` instead.
   */
  position: number;
  /**
   * The ID of the pull request review to which the comment belongs.
   */
  pull_request_review_id: number | null;
  /**
   * URL for the pull request that the review comment belongs to.
   */
  pull_request_url: string;
  reactions?: reaction_rollup;
  /**
   * The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
   */
  side?: 'LEFT' | 'RIGHT';
  /**
   * The first line of the range for a multi-line comment.
   */
  start_line?: number | null;
  /**
   * The side of the first line of the range for a multi-line comment.
   */
  start_side?: ('LEFT' | 'RIGHT') | null;
  updated_at: string;
  /**
   * URL for the pull request review comment
   */
  url: string;
  user: simple_user;
};

/**
 * The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
 */
export type side = 'LEFT' | 'RIGHT';

/**
 * The side of the first line of the range for a multi-line comment.
 */
export type start_side = 'LEFT' | 'RIGHT';

/**
 * Pull Request Review Request
 */
export type pull_request_review_request = {
  teams: Array<team>;
  users: Array<simple_user>;
};

/**
 * Pull Request Simple
 */
export type pull_request_simple = {
  _links: {
    comments: link;
    commits: link;
    html: link;
    issue: link;
    review_comment: link;
    review_comments: link;
    self: link;
    statuses: link;
  };
  active_lock_reason?: string | null;
  assignee: nullable_simple_user;
  assignees?: Array<simple_user> | null;
  author_association: author_association;
  auto_merge: auto_merge;
  base: {
    label: string;
    ref: string;
    repo: repository;
    sha: string;
    user: nullable_simple_user;
  };
  body: string | null;
  closed_at: string | null;
  comments_url: string;
  commits_url: string;
  created_at: string;
  diff_url: string;
  /**
   * Indicates whether or not the pull request is a draft.
   */
  draft?: boolean;
  head: {
    label: string;
    ref: string;
    repo: repository;
    sha: string;
    user: nullable_simple_user;
  };
  html_url: string;
  id: number;
  issue_url: string;
  labels: Array<{
    color: string;
    default: boolean;
    description: string;
    id: number;
    name: string;
    node_id: string;
    url: string;
  }>;
  locked: boolean;
  merge_commit_sha: string | null;
  merged_at: string | null;
  milestone: nullable_milestone;
  node_id: string;
  number: number;
  patch_url: string;
  requested_reviewers?: Array<simple_user> | null;
  requested_teams?: Array<team> | null;
  review_comment_url: string;
  review_comments_url: string;
  state: string;
  statuses_url: string;
  title: string;
  updated_at: string;
  url: string;
  user: nullable_simple_user;
};

export type rate_limit = {
  limit: number;
  remaining: number;
  reset: number;
  used: number;
};

/**
 * Rate Limit Overview
 */
export type rate_limit_overview = {
  rate: rate_limit;
  resources: {
    actions_runner_registration?: rate_limit;
    code_scanning_upload?: rate_limit;
    core: rate_limit;
    dependency_snapshots?: rate_limit;
    graphql?: rate_limit;
    integration_manifest?: rate_limit;
    scim?: rate_limit;
    search: rate_limit;
    source_import?: rate_limit;
  };
};

/**
 * Reactions to conversations provide a way to help people express their feelings more simply and effectively.
 */
export type reaction = {
  /**
   * The reaction to use
   */
  content: '+1' | '-1' | 'laugh' | 'confused' | 'heart' | 'hooray' | 'rocket' | 'eyes';
  created_at: string;
  id: number;
  node_id: string;
  user: nullable_simple_user;
};

/**
 * The reaction to use
 */
export type content = '+1' | '-1' | 'laugh' | 'confused' | 'heart' | 'hooray' | 'rocket' | 'eyes';

export type reaction_rollup = {
  '+1': number;
  '-1': number;
  confused: number;
  eyes: number;
  heart: number;
  hooray: number;
  laugh: number;
  rocket: number;
  total_count: number;
  url: string;
};

/**
 * A workflow referenced/reused by the initial caller workflow
 */
export type referenced_workflow = {
  path: string;
  ref?: string;
  sha: string;
};

/**
 * Referrer Traffic
 */
export type referrer_traffic = {
  count: number;
  referrer: string;
  uniques: number;
};

/**
 * A release.
 */
export type release = {
  assets: Array<release_asset>;
  assets_url: string;
  author: simple_user;
  body?: string | null;
  body_html?: string;
  body_text?: string;
  created_at: string;
  /**
   * The URL of the release discussion.
   */
  discussion_url?: string;
  /**
   * true to create a draft (unpublished) release, false to create a published one.
   */
  draft: boolean;
  html_url: string;
  id: number;
  mentions_count?: number;
  name: string | null;
  node_id: string;
  /**
   * Whether to identify the release as a prerelease or a full release.
   */
  prerelease: boolean;
  published_at: string | null;
  reactions?: reaction_rollup;
  /**
   * The name of the tag.
   */
  tag_name: string;
  tarball_url: string | null;
  /**
   * Specifies the commitish value that determines where the Git tag is created from.
   */
  target_commitish: string;
  upload_url: string;
  url: string;
  zipball_url: string | null;
};

/**
 * Data related to a release.
 */
export type release_asset = {
  browser_download_url: string;
  content_type: string;
  created_at: string;
  download_count: number;
  id: number;
  label: string | null;
  /**
   * The file name of the asset.
   */
  name: string;
  node_id: string;
  size: number;
  /**
   * State of the release asset.
   */
  state: 'uploaded' | 'open';
  updated_at: string;
  uploader: nullable_simple_user;
  url: string;
};

/**
 * State of the release asset.
 */
export type state9 = 'uploaded' | 'open';

/**
 * Generated name and body describing a release
 */
export type release_notes_content = {
  /**
   * The generated body describing the contents of the release supporting markdown formatting
   */
  body: string;
  /**
   * The generated name of the release
   */
  name: string;
};

/**
 * Removed from Project Issue Event
 */
export type removed_from_project_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  project_card?: {
    column_name: string;
    id: number;
    previous_column_name?: string;
    project_id: number;
    project_url: string;
    url: string;
  };
  url: string;
};

/**
 * Renamed Issue Event
 */
export type renamed_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  rename: {
    from: string;
    to: string;
  };
  url: string;
};

/**
 * Set repository secrets for GitHub Codespaces.
 */
export type repo_codespaces_secret = {
  created_at: string;
  /**
   * The name of the secret.
   */
  name: string;
  updated_at: string;
};

/**
 * A GitHub Actions required workflow
 */
export type repo_required_workflow = {
  badge_url: string;
  created_at: string;
  html_url: string;
  id: number;
  name: string;
  node_id: string;
  path: string;
  source_repository: minimal_repository;
  state: 'active' | 'deleted';
  updated_at: string;
  url: string;
};

export type state10 = 'active' | 'deleted';

/**
 * Repo Search Result Item
 */
export type repo_search_result_item = {
  allow_auto_merge?: boolean;
  allow_forking?: boolean;
  allow_merge_commit?: boolean;
  allow_rebase_merge?: boolean;
  allow_squash_merge?: boolean;
  archive_url: string;
  archived: boolean;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  clone_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  created_at: string;
  default_branch: string;
  delete_branch_on_merge?: boolean;
  deployments_url: string;
  description: string | null;
  /**
   * Returns whether or not this repository disabled.
   */
  disabled: boolean;
  downloads_url: string;
  events_url: string;
  fork: boolean;
  forks: number;
  forks_count: number;
  forks_url: string;
  full_name: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  has_discussions?: boolean;
  has_downloads: boolean;
  has_issues: boolean;
  has_pages: boolean;
  has_projects: boolean;
  has_wiki: boolean;
  homepage: string | null;
  hooks_url: string;
  html_url: string;
  id: number;
  is_template?: boolean;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  language: string | null;
  languages_url: string;
  license: nullable_license_simple;
  master_branch?: string;
  merges_url: string;
  milestones_url: string;
  mirror_url: string | null;
  name: string;
  node_id: string;
  notifications_url: string;
  open_issues: number;
  open_issues_count: number;
  owner: nullable_simple_user;
  permissions?: {
    admin: boolean;
    maintain?: boolean;
    pull: boolean;
    push: boolean;
    triage?: boolean;
  };
  private: boolean;
  pulls_url: string;
  pushed_at: string;
  releases_url: string;
  score: number;
  size: number;
  ssh_url: string;
  stargazers_count: number;
  stargazers_url: string;
  statuses_url: string;
  subscribers_url: string;
  subscription_url: string;
  svn_url: string;
  tags_url: string;
  teams_url: string;
  temp_clone_token?: string;
  text_matches?: search_result_text_matches;
  topics?: Array<string>;
  trees_url: string;
  updated_at: string;
  url: string;
  /**
   * The repository visibility: public, private, or internal.
   */
  visibility?: string;
  watchers: number;
  watchers_count: number;
  web_commit_signoff_required?: boolean;
};

/**
 * A repository on GitHub.
 */
export type repository = {
  /**
   * Whether to allow Auto-merge to be used on pull requests.
   */
  allow_auto_merge?: boolean;
  /**
   * Whether to allow forking this repo
   */
  allow_forking?: boolean;
  /**
   * Whether to allow merge commits for pull requests.
   */
  allow_merge_commit?: boolean;
  /**
   * Whether to allow rebase merges for pull requests.
   */
  allow_rebase_merge?: boolean;
  /**
   * Whether to allow squash merges for pull requests.
   */
  allow_squash_merge?: boolean;
  /**
   * Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.
   */
  allow_update_branch?: boolean;
  /**
   * Whether anonymous git access is enabled for this repository
   */
  anonymous_access_enabled?: boolean;
  archive_url: string;
  /**
   * Whether the repository is archived.
   */
  archived: boolean;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  clone_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  created_at: string | null;
  /**
   * The default branch of the repository.
   */
  default_branch: string;
  /**
   * Whether to delete head branches when pull requests are merged
   */
  delete_branch_on_merge?: boolean;
  deployments_url: string;
  description: string | null;
  /**
   * Returns whether or not this repository disabled.
   */
  disabled: boolean;
  downloads_url: string;
  events_url: string;
  fork: boolean;
  forks: number;
  forks_count: number;
  forks_url: string;
  full_name: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  /**
   * Whether discussions are enabled.
   */
  has_discussions?: boolean;
  /**
   * Whether downloads are enabled.
   */
  has_downloads: boolean;
  /**
   * Whether issues are enabled.
   */
  has_issues: boolean;
  has_pages: boolean;
  /**
   * Whether projects are enabled.
   */
  has_projects: boolean;
  /**
   * Whether the wiki is enabled.
   */
  has_wiki: boolean;
  homepage: string | null;
  hooks_url: string;
  html_url: string;
  /**
   * Unique identifier of the repository
   */
  id: number;
  /**
   * Whether this repository acts as a template that can be used to generate new repositories.
   */
  is_template?: boolean;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  language: string | null;
  languages_url: string;
  license: nullable_license_simple;
  master_branch?: string;
  /**
   * The default value for a merge commit message.
   *
   * - `PR_TITLE` - default to the pull request's title.
   * - `PR_BODY` - default to the pull request's body.
   * - `BLANK` - default to a blank commit message.
   */
  merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
  /**
   * The default value for a merge commit title.
   *
   * - `PR_TITLE` - default to the pull request's title.
   * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
   */
  merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
  merges_url: string;
  milestones_url: string;
  mirror_url: string | null;
  /**
   * The name of the repository.
   */
  name: string;
  network_count?: number;
  node_id: string;
  notifications_url: string;
  open_issues: number;
  open_issues_count: number;
  organization?: nullable_simple_user;
  owner: simple_user;
  permissions?: {
    admin: boolean;
    maintain?: boolean;
    pull: boolean;
    push: boolean;
    triage?: boolean;
  };
  /**
   * Whether the repository is private or public.
   */
  private: boolean;
  pulls_url: string;
  pushed_at: string | null;
  releases_url: string;
  /**
   * The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.
   */
  size: number;
  /**
   * The default value for a squash merge commit message:
   *
   * - `PR_BODY` - default to the pull request's body.
   * - `COMMIT_MESSAGES` - default to the branch's commit messages.
   * - `BLANK` - default to a blank commit message.
   */
  squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
  /**
   * The default value for a squash merge commit title:
   *
   * - `PR_TITLE` - default to the pull request's title.
   * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
   */
  squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
  ssh_url: string;
  stargazers_count: number;
  stargazers_url: string;
  starred_at?: string;
  statuses_url: string;
  subscribers_count?: number;
  subscribers_url: string;
  subscription_url: string;
  svn_url: string;
  tags_url: string;
  teams_url: string;
  temp_clone_token?: string;
  template_repository?: {
    allow_auto_merge?: boolean;
    allow_merge_commit?: boolean;
    allow_rebase_merge?: boolean;
    allow_squash_merge?: boolean;
    allow_update_branch?: boolean;
    archive_url?: string;
    archived?: boolean;
    assignees_url?: string;
    blobs_url?: string;
    branches_url?: string;
    clone_url?: string;
    collaborators_url?: string;
    comments_url?: string;
    commits_url?: string;
    compare_url?: string;
    contents_url?: string;
    contributors_url?: string;
    created_at?: string;
    default_branch?: string;
    delete_branch_on_merge?: boolean;
    deployments_url?: string;
    description?: string;
    disabled?: boolean;
    downloads_url?: string;
    events_url?: string;
    fork?: boolean;
    forks_count?: number;
    forks_url?: string;
    full_name?: string;
    git_commits_url?: string;
    git_refs_url?: string;
    git_tags_url?: string;
    git_url?: string;
    has_downloads?: boolean;
    has_issues?: boolean;
    has_pages?: boolean;
    has_projects?: boolean;
    has_wiki?: boolean;
    homepage?: string;
    hooks_url?: string;
    html_url?: string;
    id?: number;
    is_template?: boolean;
    issue_comment_url?: string;
    issue_events_url?: string;
    issues_url?: string;
    keys_url?: string;
    labels_url?: string;
    language?: string;
    languages_url?: string;
    /**
     * The default value for a merge commit message.
     *
     * - `PR_TITLE` - default to the pull request's title.
     * - `PR_BODY` - default to the pull request's body.
     * - `BLANK` - default to a blank commit message.
     */
    merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
    /**
     * The default value for a merge commit title.
     *
     * - `PR_TITLE` - default to the pull request's title.
     * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
     */
    merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
    merges_url?: string;
    milestones_url?: string;
    mirror_url?: string;
    name?: string;
    network_count?: number;
    node_id?: string;
    notifications_url?: string;
    open_issues_count?: number;
    owner?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
    permissions?: {
      admin?: boolean;
      maintain?: boolean;
      pull?: boolean;
      push?: boolean;
      triage?: boolean;
    };
    private?: boolean;
    pulls_url?: string;
    pushed_at?: string;
    releases_url?: string;
    size?: number;
    /**
     * The default value for a squash merge commit message:
     *
     * - `PR_BODY` - default to the pull request's body.
     * - `COMMIT_MESSAGES` - default to the branch's commit messages.
     * - `BLANK` - default to a blank commit message.
     */
    squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
    /**
     * The default value for a squash merge commit title:
     *
     * - `PR_TITLE` - default to the pull request's title.
     * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
     */
    squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
    ssh_url?: string;
    stargazers_count?: number;
    stargazers_url?: string;
    statuses_url?: string;
    subscribers_count?: number;
    subscribers_url?: string;
    subscription_url?: string;
    svn_url?: string;
    tags_url?: string;
    teams_url?: string;
    temp_clone_token?: string;
    topics?: Array<string>;
    trees_url?: string;
    updated_at?: string;
    url?: string;
    use_squash_pr_title_as_default?: boolean;
    visibility?: string;
    watchers_count?: number;
  } | null;
  topics?: Array<string>;
  trees_url: string;
  updated_at: string | null;
  url: string;
  /**
   * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
   * @deprecated
   */
  use_squash_pr_title_as_default?: boolean;
  /**
   * The repository visibility: public, private, or internal.
   */
  visibility?: string;
  watchers: number;
  watchers_count: number;
  /**
   * Whether to require contributors to sign off on web-based commits
   */
  web_commit_signoff_required?: boolean;
};

/**
 * Repository Collaborator Permission
 */
export type repository_collaborator_permission = {
  permission: string;
  role_name: string;
  user: nullable_collaborator;
};

/**
 * Repository invitations let you manage who you collaborate with.
 */
export type repository_invitation = {
  created_at: string;
  /**
   * Whether or not the invitation has expired
   */
  expired?: boolean;
  html_url: string;
  /**
   * Unique identifier of the repository invitation.
   */
  id: number;
  invitee: nullable_simple_user;
  inviter: nullable_simple_user;
  node_id: string;
  /**
   * The permission associated with the invitation.
   */
  permissions: 'read' | 'write' | 'admin' | 'triage' | 'maintain';
  repository: minimal_repository;
  /**
   * URL for the repository invitation
   */
  url: string;
};

/**
 * The permission associated with the invitation.
 */
export type permissions = 'read' | 'write' | 'admin' | 'triage' | 'maintain';

/**
 * Repository invitations let you manage who you collaborate with.
 */
export type repository_subscription = {
  created_at: string;
  /**
   * Determines if all notifications should be blocked from this repository.
   */
  ignored: boolean;
  reason: string | null;
  repository_url: string;
  /**
   * Determines if notifications should be received from this repository.
   */
  subscribed: boolean;
  url: string;
};

export type required_workflow = {
  created_at: string;
  /**
   * Unique identifier for a required workflow
   */
  id: number;
  /**
   * Name present in the workflow file
   */
  name: string;
  /**
   * Path of the workflow file
   */
  path: string;
  /**
   * Ref at which the workflow file will be selected
   */
  ref: string;
  repository: minimal_repository;
  /**
   * Scope of the required workflow
   */
  scope: 'all' | 'selected';
  selected_repositories_url?: string;
  /**
   * State of the required workflow
   */
  state: 'active' | 'deleted';
  updated_at: string;
};

/**
 * Scope of the required workflow
 */
export type scope2 = 'all' | 'selected';

/**
 * Legacy Review Comment
 */
export type review_comment = {
  _links: {
    html: link;
    pull_request: link;
    self: link;
  };
  author_association: author_association;
  body: string;
  body_html?: string;
  body_text?: string;
  commit_id: string;
  created_at: string;
  diff_hunk: string;
  html_url: string;
  id: number;
  in_reply_to_id?: number;
  /**
   * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
   */
  line?: number;
  node_id: string;
  original_commit_id: string;
  /**
   * The original line of the blob to which the comment applies. The last line of the range for a multi-line comment
   */
  original_line?: number;
  original_position: number;
  /**
   * The original first line of the range for a multi-line comment.
   */
  original_start_line?: number | null;
  path: string;
  position: number | null;
  pull_request_review_id: number | null;
  pull_request_url: string;
  reactions?: reaction_rollup;
  /**
   * The side of the first line of the range for a multi-line comment.
   */
  side?: 'LEFT' | 'RIGHT';
  /**
   * The first line of the range for a multi-line comment.
   */
  start_line?: number | null;
  /**
   * The side of the first line of the range for a multi-line comment.
   */
  start_side?: ('LEFT' | 'RIGHT') | null;
  updated_at: string;
  url: string;
  user: nullable_simple_user;
};

/**
 * Review Dismissed Issue Event
 */
export type review_dismissed_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  dismissed_review: {
    dismissal_commit_id?: string;
    dismissal_message: string | null;
    review_id: number;
    state: string;
  };
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  url: string;
};

/**
 * Review Request Removed Issue Event
 */
export type review_request_removed_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  requested_reviewer?: simple_user;
  requested_team?: team;
  review_requester: simple_user;
  url: string;
};

/**
 * Review Requested Issue Event
 */
export type review_requested_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  requested_reviewer?: simple_user;
  requested_team?: team;
  review_requester: simple_user;
  url: string;
};

export type root = {
  authorizations_url: string;
  code_search_url: string;
  commit_search_url: string;
  current_user_authorizations_html_url: string;
  current_user_repositories_url: string;
  current_user_url: string;
  emails_url: string;
  emojis_url: string;
  events_url: string;
  feeds_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  hub_url: string;
  issue_search_url: string;
  issues_url: string;
  keys_url: string;
  label_search_url: string;
  notifications_url: string;
  organization_repositories_url: string;
  organization_teams_url: string;
  organization_url: string;
  public_gists_url: string;
  rate_limit_url: string;
  repository_search_url: string;
  repository_url: string;
  starred_gists_url: string;
  starred_url: string;
  topic_search_url?: string;
  user_organizations_url: string;
  user_repositories_url: string;
  user_search_url: string;
  user_url: string;
};

/**
 * A self hosted runner
 */
export type runner = {
  busy: boolean;
  /**
   * The id of the runner.
   */
  id: number;
  labels: Array<runner_label>;
  /**
   * The name of the runner.
   */
  name: string;
  /**
   * The Operating System of the runner.
   */
  os: string;
  /**
   * The status of the runner.
   */
  status: string;
};

/**
 * Runner Application
 */
export type runner_application = {
  architecture: string;
  download_url: string;
  filename: string;
  os: string;
  sha256_checksum?: string;
  /**
   * A short lived bearer token used to download the runner, if needed.
   */
  temp_download_token?: string;
};

/**
 * A label for a self hosted runner
 */
export type runner_label = {
  /**
   * Unique identifier of the label.
   */
  id?: number;
  /**
   * Name of the label.
   */
  name: string;
  /**
   * The type of label. Read-only labels are applied automatically when the runner is configured.
   */
  type?: 'read-only' | 'custom';
};

/**
 * The type of label. Read-only labels are applied automatically when the runner is configured.
 */
export type type5 = 'read-only' | 'custom';

/**
 * Scim Error
 */
export type scim_error = {
  detail?: string | null;
  documentation_url?: string | null;
  message?: string | null;
  schemas?: Array<string>;
  scimType?: string | null;
  status?: number;
};

export type search_result_text_matches = Array<{
  fragment?: string;
  matches?: Array<{
    indices?: Array<number>;
    text?: string;
  }>;
  object_type?: string | null;
  object_url?: string;
  property?: string;
}>;

export type secret_scanning_alert = {
  created_at?: alert_created_at;
  html_url?: alert_html_url;
  /**
   * The REST API URL of the code locations for this alert.
   */
  locations_url?: string;
  number?: alert_number;
  /**
   * Whether push protection was bypassed for the detected secret.
   */
  push_protection_bypassed?: boolean | null;
  /**
   * The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  push_protection_bypassed_at?: string | null;
  push_protection_bypassed_by?: nullable_simple_user;
  resolution?: secret_scanning_alert_resolution;
  /**
   * An optional comment to resolve an alert.
   */
  resolution_comment?: string | null;
  /**
   * The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  resolved_at?: string | null;
  resolved_by?: nullable_simple_user;
  /**
   * The secret that was detected.
   */
  secret?: string;
  /**
   * The type of secret that secret scanning detected.
   */
  secret_type?: string;
  /**
   * User-friendly name for the detected secret, matching the `secret_type`.
   * For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."
   */
  secret_type_display_name?: string;
  state?: secret_scanning_alert_state;
  updated_at?: nullable_alert_updated_at;
  url?: alert_url;
};

/**
 * **Required when the `state` is `resolved`.** The reason for resolving the alert.
 */
export type secret_scanning_alert_resolution = 'false_positive' | 'wont_fix' | 'revoked' | 'used_in_tests';

/**
 * An optional comment when closing an alert. Cannot be updated or deleted. Must be `null` when changing `state` to `open`.
 */
export type secret_scanning_alert_resolution_comment = string | null;

/**
 * Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.
 */
export type secret_scanning_alert_state = 'open' | 'resolved';

export type secret_scanning_location = {
  details:
    | secret_scanning_location_commit
    | secret_scanning_location_issue_title
    | secret_scanning_location_issue_body
    | secret_scanning_location_issue_comment;
  /**
   * The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
   */
  type: 'commit' | 'issue_title' | 'issue_body' | 'issue_comment';
};

/**
 * The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
 */
export type type6 = 'commit' | 'issue_title' | 'issue_body' | 'issue_comment';

/**
 * Represents a 'commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository.
 */
export type secret_scanning_location_commit = {
  /**
   * SHA-1 hash ID of the associated blob
   */
  blob_sha: string;
  /**
   * The API URL to get the associated blob resource
   */
  blob_url: string;
  /**
   * SHA-1 hash ID of the associated commit
   */
  commit_sha: string;
  /**
   * The API URL to get the associated commit resource
   */
  commit_url: string;
  /**
   * The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII
   */
  end_column: number;
  /**
   * Line number at which the secret ends in the file
   */
  end_line: number;
  /**
   * The file path in the repository
   */
  path: string;
  /**
   * The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII
   */
  start_column: number;
  /**
   * Line number at which the secret starts in the file
   */
  start_line: number;
};

/**
 * Represents an 'issue_body' secret scanning location type. This location type shows that a secret was detected in the body of an issue.
 */
export type secret_scanning_location_issue_body = {
  /**
   * The API URL to get the issue where the secret was detected.
   */
  issue_body_url: string;
};

/**
 * Represents an 'issue_comment' secret scanning location type. This location type shows that a secret was detected in a comment on an issue.
 */
export type secret_scanning_location_issue_comment = {
  /**
   * The API URL to get the issue comment where the secret was detected.
   */
  issue_comment_url: string;
};

/**
 * Represents an 'issue_title' secret scanning location type. This location type shows that a secret was detected in the title of an issue.
 */
export type secret_scanning_location_issue_title = {
  /**
   * The API URL to get the issue where the secret was detected.
   */
  issue_title_url: string;
};

export type security_and_analysis = {
  advanced_security?: {
    status?: 'enabled' | 'disabled';
  };
  secret_scanning?: {
    status?: 'enabled' | 'disabled';
  };
  secret_scanning_push_protection?: {
    status?: 'enabled' | 'disabled';
  };
} | null;

export type status7 = 'enabled' | 'disabled';

export type selected_actions = {
  /**
   * Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.
   */
  github_owned_allowed?: boolean;
  /**
   * Specifies a list of string-matching patterns to allow specific action(s) and reusable workflow(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa*`.
   *
   * **Note**: The `patterns_allowed` setting only applies to public repositories.
   */
  patterns_allowed?: Array<string>;
  /**
   * Whether actions from GitHub Marketplace verified creators are allowed. Set to `true` to allow all actions by GitHub Marketplace verified creators.
   */
  verified_allowed?: boolean;
};

/**
 * The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.
 */
export type selected_actions_url = string;

/**
 * Short Blob
 */
export type short_blob = {
  sha: string;
  url: string;
};

/**
 * Short Branch
 */
export type short_branch = {
  commit: {
    sha: string;
    url: string;
  };
  name: string;
  protected: boolean;
  protection?: branch_protection;
  protection_url?: string;
};

/**
 * A suite of checks performed on the code of a given code change
 */
export type simple_check_suite = {
  after?: string | null;
  app?: integration;
  before?: string | null;
  conclusion?:
    | (
        | 'success'
        | 'failure'
        | 'neutral'
        | 'cancelled'
        | 'skipped'
        | 'timed_out'
        | 'action_required'
        | 'stale'
        | 'startup_failure'
      )
    | null;
  created_at?: string;
  head_branch?: string | null;
  /**
   * The SHA of the head commit that is being checked.
   */
  head_sha?: string;
  id?: number;
  node_id?: string;
  pull_requests?: Array<pull_request_minimal>;
  repository?: minimal_repository;
  status?: 'queued' | 'in_progress' | 'completed' | 'pending' | 'waiting';
  updated_at?: string;
  url?: string;
};

export type status8 = 'queued' | 'in_progress' | 'completed' | 'pending' | 'waiting';

/**
 * A commit.
 */
export type simple_commit = {
  author: {
    email: string;
    name: string;
  } | null;
  committer: {
    email: string;
    name: string;
  } | null;
  id: string;
  message: string;
  timestamp: string;
  tree_id: string;
};

export type simple_commit_status = {
  avatar_url: string | null;
  context: string;
  created_at: string;
  description: string | null;
  id: number;
  node_id: string;
  required?: boolean | null;
  state: string;
  target_url: string | null;
  updated_at: string;
  url: string;
};

/**
 * The GitHub App installation. This property is included when the event is configured for and sent to a GitHub App.
 */
export type simple_installation = {
  /**
   * The ID of the installation.
   */
  id: number;
  /**
   * The global node ID of the installation.
   */
  node_id: string;
};

/**
 * A GitHub repository.
 */
export type simple_repository = {
  /**
   * A template for the API URL to download the repository as an archive.
   */
  archive_url: string;
  /**
   * A template for the API URL to list the available assignees for issues in the repository.
   */
  assignees_url: string;
  /**
   * A template for the API URL to create or retrieve a raw Git blob in the repository.
   */
  blobs_url: string;
  /**
   * A template for the API URL to get information about branches in the repository.
   */
  branches_url: string;
  /**
   * A template for the API URL to get information about collaborators of the repository.
   */
  collaborators_url: string;
  /**
   * A template for the API URL to get information about comments on the repository.
   */
  comments_url: string;
  /**
   * A template for the API URL to get information about commits on the repository.
   */
  commits_url: string;
  /**
   * A template for the API URL to compare two commits or refs.
   */
  compare_url: string;
  /**
   * A template for the API URL to get the contents of the repository.
   */
  contents_url: string;
  /**
   * A template for the API URL to list the contributors to the repository.
   */
  contributors_url: string;
  /**
   * The API URL to list the deployments of the repository.
   */
  deployments_url: string;
  /**
   * The repository description.
   */
  description: string | null;
  /**
   * The API URL to list the downloads on the repository.
   */
  downloads_url: string;
  /**
   * The API URL to list the events of the repository.
   */
  events_url: string;
  /**
   * Whether the repository is a fork.
   */
  fork: boolean;
  /**
   * The API URL to list the forks of the repository.
   */
  forks_url: string;
  /**
   * The full, globally unique, name of the repository.
   */
  full_name: string;
  /**
   * A template for the API URL to get information about Git commits of the repository.
   */
  git_commits_url: string;
  /**
   * A template for the API URL to get information about Git refs of the repository.
   */
  git_refs_url: string;
  /**
   * A template for the API URL to get information about Git tags of the repository.
   */
  git_tags_url: string;
  /**
   * The API URL to list the hooks on the repository.
   */
  hooks_url: string;
  /**
   * The URL to view the repository on GitHub.com.
   */
  html_url: string;
  /**
   * A unique identifier of the repository.
   */
  id: number;
  /**
   * A template for the API URL to get information about issue comments on the repository.
   */
  issue_comment_url: string;
  /**
   * A template for the API URL to get information about issue events on the repository.
   */
  issue_events_url: string;
  /**
   * A template for the API URL to get information about issues on the repository.
   */
  issues_url: string;
  /**
   * A template for the API URL to get information about deploy keys on the repository.
   */
  keys_url: string;
  /**
   * A template for the API URL to get information about labels of the repository.
   */
  labels_url: string;
  /**
   * The API URL to get information about the languages of the repository.
   */
  languages_url: string;
  /**
   * The API URL to merge branches in the repository.
   */
  merges_url: string;
  /**
   * A template for the API URL to get information about milestones of the repository.
   */
  milestones_url: string;
  /**
   * The name of the repository.
   */
  name: string;
  /**
   * The GraphQL identifier of the repository.
   */
  node_id: string;
  /**
   * A template for the API URL to get information about notifications on the repository.
   */
  notifications_url: string;
  owner: simple_user;
  /**
   * Whether the repository is private.
   */
  private: boolean;
  /**
   * A template for the API URL to get information about pull requests on the repository.
   */
  pulls_url: string;
  /**
   * A template for the API URL to get information about releases on the repository.
   */
  releases_url: string;
  /**
   * The API URL to list the stargazers on the repository.
   */
  stargazers_url: string;
  /**
   * A template for the API URL to get information about statuses of a commit.
   */
  statuses_url: string;
  /**
   * The API URL to list the subscribers on the repository.
   */
  subscribers_url: string;
  /**
   * The API URL to subscribe to notifications for this repository.
   */
  subscription_url: string;
  /**
   * The API URL to get information about tags on the repository.
   */
  tags_url: string;
  /**
   * The API URL to list the teams on the repository.
   */
  teams_url: string;
  /**
   * A template for the API URL to create or retrieve a raw Git tree of the repository.
   */
  trees_url: string;
  /**
   * The URL to get more information about the repository from the GitHub API.
   */
  url: string;
};

/**
 * A GitHub user.
 */
export type simple_user = {
  avatar_url: string;
  email?: string | null;
  events_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  gravatar_id: string | null;
  html_url: string;
  id: number;
  login: string;
  name?: string | null;
  node_id: string;
  organizations_url: string;
  received_events_url: string;
  repos_url: string;
  site_admin: boolean;
  starred_at?: string;
  starred_url: string;
  subscriptions_url: string;
  type: string;
  url: string;
};

/**
 * Create a new snapshot of a repository's dependencies.
 */
export type snapshot = {
  /**
   * A description of the detector used.
   */
  detector: {
    /**
     * The name of the detector used.
     */
    name: string;
    /**
     * The url of the detector used.
     */
    url: string;
    /**
     * The version of the detector used.
     */
    version: string;
  };
  job: {
    /**
     * Correlator provides a key that is used to group snapshots submitted over time. Only the "latest" submitted snapshot for a given combination of `job.correlator` and `detector.name` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given "wave" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation.
     */
    correlator: string;
    /**
     * The url for the job.
     */
    html_url?: string;
    /**
     * The external ID of the job.
     */
    id: string;
  };
  /**
   * A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.
   */
  manifests?: {
    [key: string]: manifest;
  };
  metadata?: metadata;
  /**
   * The repository branch that triggered this snapshot.
   */
  ref: string;
  /**
   * The time at which the snapshot was scanned.
   */
  scanned: string;
  /**
   * The commit SHA associated with this dependency snapshot. Maximum length: 40 characters.
   */
  sha: string;
  /**
   * The version of the repository snapshot submission.
   */
  version: number;
};

/**
 * A public SSH key used to sign Git commits
 */
export type ssh_signing_key = {
  created_at: string;
  id: number;
  key: string;
  title: string;
};

/**
 * Stargazer
 */
export type stargazer = {
  starred_at: string;
  user: nullable_simple_user;
};

/**
 * Starred Repository
 */
export type starred_repository = {
  repo: repository;
  starred_at: string;
};

/**
 * State Change Issue Event
 */
export type state_change_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  state_reason?: string | null;
  url: string;
};

/**
 * The status of a commit.
 */
export type status9 = {
  avatar_url: string | null;
  context: string;
  created_at: string;
  creator: nullable_simple_user;
  description: string | null;
  id: number;
  node_id: string;
  state: string;
  target_url: string | null;
  updated_at: string;
  url: string;
};

/**
 * Status Check Policy
 */
export type status_check_policy = {
  checks: Array<{
    app_id: number | null;
    context: string;
  }>;
  contexts: Array<string>;
  contexts_url: string;
  strict: boolean;
  url: string;
};

/**
 * Tag
 */
export type tag = {
  commit: {
    sha: string;
    url: string;
  };
  name: string;
  node_id: string;
  tarball_url: string;
  zipball_url: string;
};

/**
 * Tag protection
 */
export type tag_protection = {
  created_at?: string;
  enabled?: boolean;
  id?: number;
  pattern: string;
  updated_at?: string;
};

/**
 * Groups of organization members that gives permissions on specified repositories.
 */
export type team = {
  description: string | null;
  html_url: string;
  id: number;
  members_url: string;
  name: string;
  node_id: string;
  parent: nullable_team_simple;
  permission: string;
  permissions?: {
    admin: boolean;
    maintain: boolean;
    pull: boolean;
    push: boolean;
    triage: boolean;
  };
  privacy?: string;
  repositories_url: string;
  slug: string;
  url: string;
};

/**
 * A team discussion is a persistent record of a free-form conversation within a team.
 */
export type team_discussion = {
  author: nullable_simple_user;
  /**
   * The main text of the discussion.
   */
  body: string;
  body_html: string;
  /**
   * The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
   */
  body_version: string;
  comments_count: number;
  comments_url: string;
  created_at: string;
  html_url: string;
  last_edited_at: string | null;
  node_id: string;
  /**
   * The unique sequence number of a team discussion.
   */
  number: number;
  /**
   * Whether or not this discussion should be pinned for easy retrieval.
   */
  pinned: boolean;
  /**
   * Whether or not this discussion should be restricted to team members and organization administrators.
   */
  private: boolean;
  reactions?: reaction_rollup;
  team_url: string;
  /**
   * The title of the discussion.
   */
  title: string;
  updated_at: string;
  url: string;
};

/**
 * A reply to a discussion within a team.
 */
export type team_discussion_comment = {
  author: nullable_simple_user;
  /**
   * The main text of the comment.
   */
  body: string;
  body_html: string;
  /**
   * The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
   */
  body_version: string;
  created_at: string;
  discussion_url: string;
  html_url: string;
  last_edited_at: string | null;
  node_id: string;
  /**
   * The unique sequence number of a team discussion comment.
   */
  number: number;
  reactions?: reaction_rollup;
  updated_at: string;
  url: string;
};

/**
 * Groups of organization members that gives permissions on specified repositories.
 */
export type team_full = {
  created_at: string;
  description: string | null;
  html_url: string;
  /**
   * Unique identifier of the team
   */
  id: number;
  /**
   * Distinguished Name (DN) that team maps to within LDAP environment
   */
  ldap_dn?: string;
  members_count: number;
  members_url: string;
  /**
   * Name of the team
   */
  name: string;
  node_id: string;
  organization: team_organization;
  parent?: nullable_team_simple;
  /**
   * Permission that the team will have for its repositories
   */
  permission: string;
  /**
   * The level of privacy this team should have
   */
  privacy?: 'closed' | 'secret';
  repos_count: number;
  repositories_url: string;
  slug: string;
  updated_at: string;
  /**
   * URL for the team
   */
  url: string;
};

/**
 * The level of privacy this team should have
 */
export type privacy = 'closed' | 'secret';

/**
 * Team Membership
 */
export type team_membership = {
  /**
   * The role of the user in the team.
   */
  role: 'member' | 'maintainer';
  /**
   * The state of the user's membership in the team.
   */
  state: 'active' | 'pending';
  url: string;
};

/**
 * The role of the user in the team.
 */
export type role2 = 'member' | 'maintainer';

/**
 * Team Organization
 */
export type team_organization = {
  avatar_url: string;
  billing_email?: string | null;
  blog?: string;
  collaborators?: number | null;
  company?: string;
  created_at: string;
  default_repository_permission?: string | null;
  description: string | null;
  disk_usage?: number | null;
  email?: string;
  events_url: string;
  followers: number;
  following: number;
  has_organization_projects: boolean;
  has_repository_projects: boolean;
  hooks_url: string;
  html_url: string;
  id: number;
  is_verified?: boolean;
  issues_url: string;
  location?: string;
  login: string;
  members_allowed_repository_creation_type?: string;
  members_can_create_internal_repositories?: boolean;
  members_can_create_pages?: boolean;
  members_can_create_private_pages?: boolean;
  members_can_create_private_repositories?: boolean;
  members_can_create_public_pages?: boolean;
  members_can_create_public_repositories?: boolean;
  members_can_create_repositories?: boolean | null;
  members_can_fork_private_repositories?: boolean | null;
  members_url: string;
  name?: string;
  node_id: string;
  owned_private_repos?: number;
  plan?: {
    filled_seats?: number;
    name: string;
    private_repos: number;
    seats?: number;
    space: number;
  };
  private_gists?: number | null;
  public_gists: number;
  public_members_url: string;
  public_repos: number;
  repos_url: string;
  total_private_repos?: number;
  twitter_username?: string | null;
  two_factor_requirement_enabled?: boolean | null;
  type: string;
  updated_at: string;
  url: string;
  web_commit_signoff_required?: boolean;
};

/**
 * A team's access to a project.
 */
export type team_project = {
  body: string | null;
  columns_url: string;
  created_at: string;
  creator: simple_user;
  html_url: string;
  id: number;
  name: string;
  node_id: string;
  number: number;
  /**
   * The organization permission for this project. Only present when owner is an organization.
   */
  organization_permission?: string;
  owner_url: string;
  permissions: {
    admin: boolean;
    read: boolean;
    write: boolean;
  };
  /**
   * Whether the project is private or not. Only present when owner is an organization.
   */
  private?: boolean;
  state: string;
  updated_at: string;
  url: string;
};

/**
 * A team's access to a repository.
 */
export type team_repository = {
  /**
   * Whether to allow Auto-merge to be used on pull requests.
   */
  allow_auto_merge?: boolean;
  /**
   * Whether to allow forking this repo
   */
  allow_forking?: boolean;
  /**
   * Whether to allow merge commits for pull requests.
   */
  allow_merge_commit?: boolean;
  /**
   * Whether to allow rebase merges for pull requests.
   */
  allow_rebase_merge?: boolean;
  /**
   * Whether to allow squash merges for pull requests.
   */
  allow_squash_merge?: boolean;
  archive_url: string;
  /**
   * Whether the repository is archived.
   */
  archived: boolean;
  assignees_url: string;
  blobs_url: string;
  branches_url: string;
  clone_url: string;
  collaborators_url: string;
  comments_url: string;
  commits_url: string;
  compare_url: string;
  contents_url: string;
  contributors_url: string;
  created_at: string | null;
  /**
   * The default branch of the repository.
   */
  default_branch: string;
  /**
   * Whether to delete head branches when pull requests are merged
   */
  delete_branch_on_merge?: boolean;
  deployments_url: string;
  description: string | null;
  /**
   * Returns whether or not this repository disabled.
   */
  disabled: boolean;
  downloads_url: string;
  events_url: string;
  fork: boolean;
  forks: number;
  forks_count: number;
  forks_url: string;
  full_name: string;
  git_commits_url: string;
  git_refs_url: string;
  git_tags_url: string;
  git_url: string;
  /**
   * Whether downloads are enabled.
   */
  has_downloads: boolean;
  /**
   * Whether issues are enabled.
   */
  has_issues: boolean;
  has_pages: boolean;
  /**
   * Whether projects are enabled.
   */
  has_projects: boolean;
  /**
   * Whether the wiki is enabled.
   */
  has_wiki: boolean;
  homepage: string | null;
  hooks_url: string;
  html_url: string;
  /**
   * Unique identifier of the repository
   */
  id: number;
  /**
   * Whether this repository acts as a template that can be used to generate new repositories.
   */
  is_template?: boolean;
  issue_comment_url: string;
  issue_events_url: string;
  issues_url: string;
  keys_url: string;
  labels_url: string;
  language: string | null;
  languages_url: string;
  license: nullable_license_simple;
  master_branch?: string;
  merges_url: string;
  milestones_url: string;
  mirror_url: string | null;
  /**
   * The name of the repository.
   */
  name: string;
  network_count?: number;
  node_id: string;
  notifications_url: string;
  open_issues: number;
  open_issues_count: number;
  owner: nullable_simple_user;
  permissions?: {
    admin: boolean;
    maintain?: boolean;
    pull: boolean;
    push: boolean;
    triage?: boolean;
  };
  /**
   * Whether the repository is private or public.
   */
  private: boolean;
  pulls_url: string;
  pushed_at: string | null;
  releases_url: string;
  role_name?: string;
  size: number;
  ssh_url: string;
  stargazers_count: number;
  stargazers_url: string;
  statuses_url: string;
  subscribers_count?: number;
  subscribers_url: string;
  subscription_url: string;
  svn_url: string;
  tags_url: string;
  teams_url: string;
  temp_clone_token?: string;
  template_repository?: nullable_repository;
  topics?: Array<string>;
  trees_url: string;
  updated_at: string | null;
  url: string;
  /**
   * The repository visibility: public, private, or internal.
   */
  visibility?: string;
  watchers: number;
  watchers_count: number;
  /**
   * Whether to require contributors to sign off on web-based commits
   */
  web_commit_signoff_required?: boolean;
};

/**
 * Groups of organization members that gives permissions on specified repositories.
 */
export type team_simple = {
  /**
   * Description of the team
   */
  description: string | null;
  html_url: string;
  /**
   * Unique identifier of the team
   */
  id: number;
  /**
   * Distinguished Name (DN) that team maps to within LDAP environment
   */
  ldap_dn?: string;
  members_url: string;
  /**
   * Name of the team
   */
  name: string;
  node_id: string;
  /**
   * Permission that the team will have for its repositories
   */
  permission: string;
  /**
   * The level of privacy this team should have
   */
  privacy?: string;
  repositories_url: string;
  slug: string;
  /**
   * URL for the team
   */
  url: string;
};

/**
 * Thread
 */
export type thread = {
  id: string;
  last_read_at: string | null;
  reason: string;
  repository: minimal_repository;
  subject: {
    latest_comment_url: string;
    title: string;
    type: string;
    url: string;
  };
  subscription_url: string;
  unread: boolean;
  updated_at: string;
  url: string;
};

/**
 * Thread Subscription
 */
export type thread_subscription = {
  created_at: string | null;
  ignored: boolean;
  reason: string | null;
  repository_url?: string;
  subscribed: boolean;
  thread_url?: string;
  url: string;
};

/**
 * Timeline Assigned Issue Event
 */
export type timeline_assigned_issue_event = {
  actor: simple_user;
  assignee: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  url: string;
};

/**
 * Timeline Comment Event
 */
export type timeline_comment_event = {
  actor: simple_user;
  author_association: author_association;
  /**
   * Contents of the issue comment
   */
  body?: string;
  body_html?: string;
  body_text?: string;
  created_at: string;
  event: string;
  html_url: string;
  /**
   * Unique identifier of the issue comment
   */
  id: number;
  issue_url: string;
  node_id: string;
  performed_via_github_app?: nullable_integration;
  reactions?: reaction_rollup;
  updated_at: string;
  /**
   * URL for the issue comment
   */
  url: string;
  user: simple_user;
};

/**
 * Timeline Commit Commented Event
 */
export type timeline_commit_commented_event = {
  comments?: Array<commit_comment>;
  commit_id?: string;
  event?: string;
  node_id?: string;
};

/**
 * Timeline Committed Event
 */
export type timeline_committed_event = {
  /**
   * Identifying information for the git-user
   */
  author: {
    /**
     * Timestamp of the commit
     */
    date: string;
    /**
     * Git email address of the user
     */
    email: string;
    /**
     * Name of the git user
     */
    name: string;
  };
  /**
   * Identifying information for the git-user
   */
  committer: {
    /**
     * Timestamp of the commit
     */
    date: string;
    /**
     * Git email address of the user
     */
    email: string;
    /**
     * Name of the git user
     */
    name: string;
  };
  event?: string;
  html_url: string;
  /**
   * Message describing the purpose of the commit
   */
  message: string;
  node_id: string;
  parents: Array<{
    html_url: string;
    /**
     * SHA for the commit
     */
    sha: string;
    url: string;
  }>;
  /**
   * SHA for the commit
   */
  sha: string;
  tree: {
    /**
     * SHA for the commit
     */
    sha: string;
    url: string;
  };
  url: string;
  verification: {
    payload: string | null;
    reason: string;
    signature: string | null;
    verified: boolean;
  };
};

/**
 * Timeline Cross Referenced Event
 */
export type timeline_cross_referenced_event = {
  actor?: simple_user;
  created_at: string;
  event: string;
  source: {
    issue?: issue;
    type?: string;
  };
  updated_at: string;
};

/**
 * Timeline Event
 */
export type timeline_issue_events =
  | labeled_issue_event
  | unlabeled_issue_event
  | milestoned_issue_event
  | demilestoned_issue_event
  | renamed_issue_event
  | review_requested_issue_event
  | review_request_removed_issue_event
  | review_dismissed_issue_event
  | locked_issue_event
  | added_to_project_issue_event
  | moved_column_in_project_issue_event
  | removed_from_project_issue_event
  | converted_note_to_issue_issue_event
  | timeline_comment_event
  | timeline_cross_referenced_event
  | timeline_committed_event
  | timeline_reviewed_event
  | timeline_line_commented_event
  | timeline_commit_commented_event
  | timeline_assigned_issue_event
  | timeline_unassigned_issue_event
  | state_change_issue_event;

/**
 * Timeline Line Commented Event
 */
export type timeline_line_commented_event = {
  comments?: Array<pull_request_review_comment>;
  event?: string;
  node_id?: string;
};

/**
 * Timeline Reviewed Event
 */
export type timeline_reviewed_event = {
  _links: {
    html: {
      href: string;
    };
    pull_request: {
      href: string;
    };
  };
  author_association: author_association;
  /**
   * The text of the review.
   */
  body: string | null;
  body_html?: string;
  body_text?: string;
  /**
   * A commit SHA for the review.
   */
  commit_id: string;
  event: string;
  html_url: string;
  /**
   * Unique identifier of the review
   */
  id: number;
  node_id: string;
  pull_request_url: string;
  state: string;
  submitted_at?: string;
  user: simple_user;
};

/**
 * Timeline Unassigned Issue Event
 */
export type timeline_unassigned_issue_event = {
  actor: simple_user;
  assignee: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  url: string;
};

/**
 * A topic aggregates entities that are related to a subject.
 */
export type topic = {
  names: Array<string>;
};

/**
 * Topic Search Result Item
 */
export type topic_search_result_item = {
  aliases?: Array<{
    topic_relation?: {
      id?: number;
      name?: string;
      relation_type?: string;
      topic_id?: number;
    };
  }> | null;
  created_at: string;
  created_by: string | null;
  curated: boolean;
  description: string | null;
  display_name: string | null;
  featured: boolean;
  logo_url?: string | null;
  name: string;
  related?: Array<{
    topic_relation?: {
      id?: number;
      name?: string;
      relation_type?: string;
      topic_id?: number;
    };
  }> | null;
  released: string | null;
  repository_count?: number | null;
  score: number;
  short_description: string | null;
  text_matches?: search_result_text_matches;
  updated_at: string;
};

export type traffic = {
  count: number;
  timestamp: string;
  uniques: number;
};

/**
 * Unassigned Issue Event
 */
export type unassigned_issue_event = {
  actor: simple_user;
  assignee: simple_user;
  assigner: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  node_id: string;
  performed_via_github_app: nullable_integration;
  url: string;
};

/**
 * Unlabeled Issue Event
 */
export type unlabeled_issue_event = {
  actor: simple_user;
  commit_id: string | null;
  commit_url: string | null;
  created_at: string;
  event: string;
  id: number;
  label: {
    color: string;
    name: string;
  };
  node_id: string;
  performed_via_github_app: nullable_integration;
  url: string;
};

/**
 * User Marketplace Purchase
 */
export type user_marketplace_purchase = {
  account: marketplace_account;
  billing_cycle: string;
  free_trial_ends_on: string | null;
  next_billing_date: string | null;
  on_free_trial: boolean;
  plan: marketplace_listing_plan;
  unit_count: number | null;
  updated_at: string | null;
};

/**
 * User Search Result Item
 */
export type user_search_result_item = {
  avatar_url: string;
  bio?: string | null;
  blog?: string | null;
  company?: string | null;
  created_at?: string;
  email?: string | null;
  events_url: string;
  followers?: number;
  followers_url: string;
  following?: number;
  following_url: string;
  gists_url: string;
  gravatar_id: string | null;
  hireable?: boolean | null;
  html_url: string;
  id: number;
  location?: string | null;
  login: string;
  name?: string | null;
  node_id: string;
  organizations_url: string;
  public_gists?: number;
  public_repos?: number;
  received_events_url: string;
  repos_url: string;
  score: number;
  site_admin: boolean;
  starred_url: string;
  subscriptions_url: string;
  suspended_at?: string | null;
  text_matches?: search_result_text_matches;
  type: string;
  updated_at?: string;
  url: string;
};

/**
 * Validation Error
 */
export type validation_error = {
  documentation_url: string;
  errors?: Array<{
    code: string;
    field?: string;
    index?: number;
    message?: string;
    resource?: string;
    value?: string | null | number | null | Array<string> | null;
  }>;
  message: string;
};

/**
 * Validation Error Simple
 */
export type validation_error_simple = {
  documentation_url: string;
  errors?: Array<string>;
  message: string;
};

export type verification = {
  payload: string | null;
  reason: string;
  signature: string | null;
  verified: boolean;
};

/**
 * View Traffic
 */
export type view_traffic = {
  count: number;
  uniques: number;
  views: Array<traffic>;
};

/**
 * The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).
 */
export type wait_timer = number;

export type webhook_branch_protection_rule_created = {
  action: 'created';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  /**
   * The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
   */
  rule: {
    admin_enforced: boolean;
    allow_deletions_enforcement_level: 'off' | 'non_admins' | 'everyone';
    allow_force_pushes_enforcement_level: 'off' | 'non_admins' | 'everyone';
    authorized_actor_names: Array<string>;
    authorized_actors_only: boolean;
    authorized_dismissal_actors_only: boolean;
    create_protected?: boolean;
    created_at: string;
    dismiss_stale_reviews_on_push: boolean;
    id: number;
    ignore_approvals_from_contributors: boolean;
    linear_history_requirement_enforcement_level: 'off' | 'non_admins' | 'everyone';
    merge_queue_enforcement_level: 'off' | 'non_admins' | 'everyone';
    name: string;
    pull_request_reviews_enforcement_level: 'off' | 'non_admins' | 'everyone';
    repository_id: number;
    require_code_owner_review: boolean;
    required_approving_review_count: number;
    required_conversation_resolution_level: 'off' | 'non_admins' | 'everyone';
    required_deployments_enforcement_level: 'off' | 'non_admins' | 'everyone';
    required_status_checks: Array<string>;
    required_status_checks_enforcement_level: 'off' | 'non_admins' | 'everyone';
    signature_requirement_enforcement_level: 'off' | 'non_admins' | 'everyone';
    strict_required_status_checks_policy: boolean;
    updated_at: string;
  };
  sender: simple_user;
};

export type action = 'created';

export type allow_deletions_enforcement_level = 'off' | 'non_admins' | 'everyone';

export type allow_force_pushes_enforcement_level = 'off' | 'non_admins' | 'everyone';

export type linear_history_requirement_enforcement_level = 'off' | 'non_admins' | 'everyone';

export type merge_queue_enforcement_level = 'off' | 'non_admins' | 'everyone';

export type pull_request_reviews_enforcement_level = 'off' | 'non_admins' | 'everyone';

export type required_conversation_resolution_level = 'off' | 'non_admins' | 'everyone';

export type required_deployments_enforcement_level = 'off' | 'non_admins' | 'everyone';

export type required_status_checks_enforcement_level = 'off' | 'non_admins' | 'everyone';

export type signature_requirement_enforcement_level = 'off' | 'non_admins' | 'everyone';

export type webhook_branch_protection_rule_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  /**
   * The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
   */
  rule: {
    admin_enforced: boolean;
    allow_deletions_enforcement_level: 'off' | 'non_admins' | 'everyone';
    allow_force_pushes_enforcement_level: 'off' | 'non_admins' | 'everyone';
    authorized_actor_names: Array<string>;
    authorized_actors_only: boolean;
    authorized_dismissal_actors_only: boolean;
    create_protected?: boolean;
    created_at: string;
    dismiss_stale_reviews_on_push: boolean;
    id: number;
    ignore_approvals_from_contributors: boolean;
    linear_history_requirement_enforcement_level: 'off' | 'non_admins' | 'everyone';
    merge_queue_enforcement_level: 'off' | 'non_admins' | 'everyone';
    name: string;
    pull_request_reviews_enforcement_level: 'off' | 'non_admins' | 'everyone';
    repository_id: number;
    require_code_owner_review: boolean;
    required_approving_review_count: number;
    required_conversation_resolution_level: 'off' | 'non_admins' | 'everyone';
    required_deployments_enforcement_level: 'off' | 'non_admins' | 'everyone';
    required_status_checks: Array<string>;
    required_status_checks_enforcement_level: 'off' | 'non_admins' | 'everyone';
    signature_requirement_enforcement_level: 'off' | 'non_admins' | 'everyone';
    strict_required_status_checks_policy: boolean;
    updated_at: string;
  };
  sender: simple_user;
};

export type action2 = 'deleted';

export type webhook_branch_protection_rule_edited = {
  action: 'edited';
  /**
   * If the action was `edited`, the changes to the rule.
   */
  changes?: {
    admin_enforced?: {
      from: boolean | null;
    };
    authorized_actor_names?: {
      from: Array<string>;
    };
    authorized_actors_only?: {
      from: boolean | null;
    };
    authorized_dismissal_actors_only?: {
      from: boolean | null;
    };
    linear_history_requirement_enforcement_level?: {
      from: 'off' | 'non_admins' | 'everyone';
    };
    required_status_checks?: {
      from: Array<string>;
    };
    required_status_checks_enforcement_level?: {
      from: 'off' | 'non_admins' | 'everyone';
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  /**
   * The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
   */
  rule: {
    admin_enforced: boolean;
    allow_deletions_enforcement_level: 'off' | 'non_admins' | 'everyone';
    allow_force_pushes_enforcement_level: 'off' | 'non_admins' | 'everyone';
    authorized_actor_names: Array<string>;
    authorized_actors_only: boolean;
    authorized_dismissal_actors_only: boolean;
    create_protected?: boolean;
    created_at: string;
    dismiss_stale_reviews_on_push: boolean;
    id: number;
    ignore_approvals_from_contributors: boolean;
    linear_history_requirement_enforcement_level: 'off' | 'non_admins' | 'everyone';
    merge_queue_enforcement_level: 'off' | 'non_admins' | 'everyone';
    name: string;
    pull_request_reviews_enforcement_level: 'off' | 'non_admins' | 'everyone';
    repository_id: number;
    require_code_owner_review: boolean;
    required_approving_review_count: number;
    required_conversation_resolution_level: 'off' | 'non_admins' | 'everyone';
    required_deployments_enforcement_level: 'off' | 'non_admins' | 'everyone';
    required_status_checks: Array<string>;
    required_status_checks_enforcement_level: 'off' | 'non_admins' | 'everyone';
    signature_requirement_enforcement_level: 'off' | 'non_admins' | 'everyone';
    strict_required_status_checks_policy: boolean;
    updated_at: string;
  };
  sender: simple_user;
};

export type action3 = 'edited';

export type from = 'off' | 'non_admins' | 'everyone';

export type webhook_check_run_completed = {
  action?: 'completed';
  check_run: check_run_with_simple_check_suite;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action4 = 'completed';

/**
 * The check_run.completed webhook encoded with URL encoding
 */
export type webhook_check_run_completed_form_encoded = {
  /**
   * A URL-encoded string of the check_run.completed JSON payload. The decoded payload is a JSON object.
   */
  payload: string;
};

export type webhook_check_run_created = {
  action?: 'created';
  check_run: check_run_with_simple_check_suite;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

/**
 * The check_run.created webhook encoded with URL encoding
 */
export type webhook_check_run_created_form_encoded = {
  /**
   * A URL-encoded string of the check_run.created JSON payload. The decoded payload is a JSON object.
   */
  payload: string;
};

export type webhook_check_run_requested_action = {
  action: 'requested_action';
  check_run: check_run_with_simple_check_suite;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  /**
   * The action requested by the user.
   */
  requested_action?: {
    /**
     * The integrator reference of the action requested by the user.
     */
    identifier?: string;
  };
  sender: simple_user;
};

export type action5 = 'requested_action';

/**
 * The check_run.requested_action webhook encoded with URL encoding
 */
export type webhook_check_run_requested_action_form_encoded = {
  /**
   * A URL-encoded string of the check_run.requested_action JSON payload. The decoded payload is a JSON object.
   */
  payload: string;
};

export type webhook_check_run_rerequested = {
  action?: 'rerequested';
  check_run: check_run_with_simple_check_suite;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action6 = 'rerequested';

/**
 * The check_run.rerequested webhook encoded with URL encoding
 */
export type webhook_check_run_rerequested_form_encoded = {
  /**
   * A URL-encoded string of the check_run.rerequested JSON payload. The decoded payload is a JSON object.
   */
  payload: string;
};

export type webhook_check_suite_completed = {
  action: 'completed';
  actions_meta?: {
    [key: string]: string;
  } | null;
  /**
   * The [check_suite](https://docs.github.com/rest/reference/checks#suites).
   */
  check_suite: {
    after: string | null;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    app: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'merge_group'
        | 'pull_request_review_thread'
        | 'workflow_job'
        | 'merge_queue_entry'
        | 'security_and_analysis'
        | 'projects_v2_item'
        | 'secret_scanning_alert_location'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write' | 'admin';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    };
    before: string | null;
    check_runs_url: string;
    /**
     * The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.
     */
    conclusion:
      | (
          | 'success'
          | 'failure'
          | 'neutral'
          | 'cancelled'
          | 'timed_out'
          | 'action_required'
          | 'stale'
          | 'skipped'
          | 'startup_failure'
        )
      | null;
    created_at: string;
    /**
     * The head branch name the changes are on.
     */
    head_branch: string | null;
    head_commit: {
      /**
       * Metaproperties for Git author/committer information.
       */
      author: {
        date?: string;
        email: string | null;
        /**
         * The git author's name.
         */
        name: string;
        username?: string;
      };
      /**
       * Metaproperties for Git author/committer information.
       */
      committer: {
        date?: string;
        email: string | null;
        /**
         * The git author's name.
         */
        name: string;
        username?: string;
      };
      id: string;
      message: string;
      timestamp: string;
      tree_id: string;
    };
    /**
     * The SHA of the head commit that is being checked.
     */
    head_sha: string;
    id: number;
    latest_check_runs_count: number;
    node_id: string;
    /**
     * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
     */
    pull_requests: Array<{
      base: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      head: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      id: number;
      number: number;
      url: string;
    }>;
    rerequestable?: boolean;
    runs_rerequestable?: boolean;
    /**
     * The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
     */
    status: ('requested' | 'in_progress' | 'completed' | 'queued' | 'pending') | null;
    updated_at: string;
    /**
     * URL that points to the check suite API resource.
     */
    url: string;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type content_references = 'read' | 'write';

export type discussions = 'read' | 'write';

export type emails = 'read' | 'write';

export type keys = 'read' | 'write';

export type organization_plan2 = 'read' | 'write';

export type security_scanning_alert = 'read' | 'write';

export type workflows2 = 'read' | 'write';

/**
 * The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
 */
export type status10 = 'requested' | 'in_progress' | 'completed' | 'queued' | 'pending';

export type webhook_check_suite_requested = {
  action: 'requested';
  actions_meta?: {
    [key: string]: string;
  } | null;
  /**
   * The [check_suite](https://docs.github.com/rest/reference/checks#suites).
   */
  check_suite: {
    after: string | null;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    app: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'pull_request_review_thread'
        | 'workflow_job'
        | 'merge_queue_entry'
        | 'security_and_analysis'
        | 'secret_scanning_alert_location'
        | 'projects_v2_item'
        | 'merge_group'
        | 'repository_import'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write' | 'admin';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    };
    before: string | null;
    check_runs_url: string;
    /**
     * The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
     */
    conclusion:
      | ('success' | 'failure' | 'neutral' | 'cancelled' | 'timed_out' | 'action_required' | 'stale' | 'skipped')
      | null;
    created_at: string;
    /**
     * The head branch name the changes are on.
     */
    head_branch: string | null;
    head_commit: {
      /**
       * Metaproperties for Git author/committer information.
       */
      author: {
        date?: string;
        email: string | null;
        /**
         * The git author's name.
         */
        name: string;
        username?: string;
      };
      /**
       * Metaproperties for Git author/committer information.
       */
      committer: {
        date?: string;
        email: string | null;
        /**
         * The git author's name.
         */
        name: string;
        username?: string;
      };
      id: string;
      message: string;
      timestamp: string;
      tree_id: string;
    };
    /**
     * The SHA of the head commit that is being checked.
     */
    head_sha: string;
    id: number;
    latest_check_runs_count: number;
    node_id: string;
    /**
     * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
     */
    pull_requests: Array<{
      base: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      head: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      id: number;
      number: number;
      url: string;
    }>;
    rerequestable?: boolean;
    runs_rerequestable?: boolean;
    /**
     * The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
     */
    status: ('requested' | 'in_progress' | 'completed' | 'queued') | null;
    updated_at: string;
    /**
     * URL that points to the check suite API resource.
     */
    url: string;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action7 = 'requested';

/**
 * The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
 */
export type conclusion4 =
  | 'success'
  | 'failure'
  | 'neutral'
  | 'cancelled'
  | 'timed_out'
  | 'action_required'
  | 'stale'
  | 'skipped';

/**
 * The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
 */
export type status11 = 'requested' | 'in_progress' | 'completed' | 'queued';

export type webhook_check_suite_rerequested = {
  action: 'rerequested';
  actions_meta?: {
    rerun_info?: {
      job_ids?: Array<string>;
      plan_id?: string;
    };
  } | null;
  /**
   * The [check_suite](https://docs.github.com/rest/reference/checks#suites).
   */
  check_suite: {
    after: string | null;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    app: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'pull_request_review_thread'
        | 'merge_queue_entry'
        | 'workflow_job'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write' | 'admin';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    };
    before: string | null;
    check_runs_url: string;
    /**
     * The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
     */
    conclusion: ('success' | 'failure' | 'neutral' | 'cancelled' | 'timed_out' | 'action_required' | 'stale') | null;
    created_at: string;
    /**
     * The head branch name the changes are on.
     */
    head_branch: string | null;
    head_commit: {
      /**
       * Metaproperties for Git author/committer information.
       */
      author: {
        date?: string;
        email: string | null;
        /**
         * The git author's name.
         */
        name: string;
        username?: string;
      };
      /**
       * Metaproperties for Git author/committer information.
       */
      committer: {
        date?: string;
        email: string | null;
        /**
         * The git author's name.
         */
        name: string;
        username?: string;
      };
      id: string;
      message: string;
      timestamp: string;
      tree_id: string;
    };
    /**
     * The SHA of the head commit that is being checked.
     */
    head_sha: string;
    id: number;
    latest_check_runs_count: number;
    node_id: string;
    /**
     * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
     */
    pull_requests: Array<{
      base: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      head: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      id: number;
      number: number;
      url: string;
    }>;
    rerequestable?: boolean;
    runs_rerequestable?: boolean;
    /**
     * The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.
     */
    status: ('requested' | 'in_progress' | 'completed' | 'queued') | null;
    updated_at: string;
    /**
     * URL that points to the check suite API resource.
     */
    url: string;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

/**
 * The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
 */
export type conclusion5 = 'success' | 'failure' | 'neutral' | 'cancelled' | 'timed_out' | 'action_required' | 'stale';

export type webhook_code_scanning_alert_appeared_in_branch = {
  action: 'appeared_in_branch';
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string | null;
    dismissed_by: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: ('false positive' | "won't fix" | 'sed in tests') | null;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    most_recent_instance?: {
      /**
       * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
       */
      analysis_key: string;
      classifications?: Array<string>;
      commit_sha?: string;
      /**
       * Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
       */
      environment: string;
      location?: {
        end_column?: number;
        end_line?: number;
        path?: string;
        start_column?: number;
        start_line?: number;
      };
      message?: {
        text?: string;
      };
      /**
       * The full Git reference, formatted as `refs/heads/<branch name>`.
       */
      ref: string;
      /**
       * State of a code scanning alert.
       */
      state: 'open' | 'dismissed' | 'fixed';
    } | null;
    /**
     * The code scanning alert number.
     */
    number: number;
    rule: {
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      /**
       * The severity of the alert.
       */
      severity: ('none' | 'note' | 'warning' | 'error') | null;
    };
    /**
     * State of a code scanning alert.
     */
    state: 'open' | 'dismissed' | 'fixed';
    tool: {
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
    };
    url: string;
  };
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  repository: repository;
  sender: simple_user;
};

export type action8 = 'appeared_in_branch';

/**
 * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
 */
export type dismissed_reason2 = 'false positive' | "won't fix" | 'used in tests';

export type webhook_code_scanning_alert_closed_by_user = {
  action: 'closed_by_user';
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string;
    dismissed_by: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: ('false positive' | "won't fix" | 'used in tests') | null;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    most_recent_instance?: {
      /**
       * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
       */
      analysis_key: string;
      classifications?: Array<string>;
      commit_sha?: string;
      /**
       * Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
       */
      environment: string;
      location?: {
        end_column?: number;
        end_line?: number;
        path?: string;
        start_column?: number;
        start_line?: number;
      };
      message?: {
        text?: string;
      };
      /**
       * The full Git reference, formatted as `refs/heads/<branch name>`.
       */
      ref: string;
      /**
       * State of a code scanning alert.
       */
      state: 'open' | 'dismissed' | 'fixed';
    } | null;
    /**
     * The code scanning alert number.
     */
    number: number;
    rule: {
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      full_description?: string;
      help?: string | null;
      /**
       * A link to the documentation for the rule used to detect the alert.
       */
      help_uri?: string | null;
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      name?: string;
      /**
       * The severity of the alert.
       */
      severity: ('none' | 'note' | 'warning' | 'error') | null;
      tags?: Array<string> | null;
    };
    /**
     * State of a code scanning alert.
     */
    state: 'dismissed' | 'fixed';
    tool: {
      guid?: string | null;
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
    };
    url: string;
  };
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  repository: repository;
  sender: simple_user;
};

export type action9 = 'closed_by_user';

export type webhook_code_scanning_alert_created = {
  action: 'created';
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string | null;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string;
    dismissed_by: string;
    dismissed_comment?: code_scanning_alert_dismissed_comment;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: string;
    fixed_at?: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances_url?: string;
    most_recent_instance?: {
      /**
       * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
       */
      analysis_key: string;
      classifications?: Array<string>;
      commit_sha?: string;
      /**
       * Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
       */
      environment: string;
      location?: {
        end_column?: number;
        end_line?: number;
        path?: string;
        start_column?: number;
        start_line?: number;
      };
      message?: {
        text?: string;
      };
      /**
       * The full Git reference, formatted as `refs/heads/<branch name>`.
       */
      ref: string;
      /**
       * State of a code scanning alert.
       */
      state: 'open' | 'dismissed' | 'fixed';
    } | null;
    /**
     * The code scanning alert number.
     */
    number: number;
    rule: {
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      full_description?: string;
      help?: string | null;
      /**
       * A link to the documentation for the rule used to detect the alert.
       */
      help_uri?: string | null;
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      name?: string;
      /**
       * The severity of the alert.
       */
      severity: ('none' | 'note' | 'warning' | 'error') | null;
      tags?: Array<string> | null;
    };
    /**
     * State of a code scanning alert.
     */
    state: 'open' | 'dismissed';
    tool: {
      guid?: string | null;
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
    } | null;
    updated_at?: string | null;
    url: string;
  };
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  repository: repository;
  sender: simple_user;
};

export type webhook_code_scanning_alert_fixed = {
  action: 'fixed';
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string | null;
    dismissed_by: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: ('false positive' | "won't fix" | 'used in tests') | null;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances_url?: string;
    most_recent_instance?: {
      /**
       * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
       */
      analysis_key: string;
      classifications?: Array<string>;
      commit_sha?: string;
      /**
       * Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
       */
      environment: string;
      location?: {
        end_column?: number;
        end_line?: number;
        path?: string;
        start_column?: number;
        start_line?: number;
      };
      message?: {
        text?: string;
      };
      /**
       * The full Git reference, formatted as `refs/heads/<branch name>`.
       */
      ref: string;
      /**
       * State of a code scanning alert.
       */
      state: 'open' | 'dismissed' | 'fixed';
    } | null;
    /**
     * The code scanning alert number.
     */
    number: number;
    rule: {
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      full_description?: string;
      help?: string | null;
      /**
       * A link to the documentation for the rule used to detect the alert.
       */
      help_uri?: string | null;
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      name?: string;
      /**
       * The severity of the alert.
       */
      severity: ('none' | 'note' | 'warning' | 'error') | null;
      tags?: Array<string> | null;
    };
    /**
     * State of a code scanning alert.
     */
    state: 'fixed';
    tool: {
      guid?: string | null;
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
    };
    url: string;
  };
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  repository: repository;
  sender: simple_user;
};

export type action10 = 'fixed';

export type webhook_code_scanning_alert_reopened = {
  action: 'reopened';
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string | null;
    dismissed_by: {
      [key: string]: string;
    } | null;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: string | null;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    most_recent_instance?: {
      /**
       * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
       */
      analysis_key: string;
      classifications?: Array<string>;
      commit_sha?: string;
      /**
       * Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
       */
      environment: string;
      location?: {
        end_column?: number;
        end_line?: number;
        path?: string;
        start_column?: number;
        start_line?: number;
      };
      message?: {
        text?: string;
      };
      /**
       * The full Git reference, formatted as `refs/heads/<branch name>`.
       */
      ref: string;
      /**
       * State of a code scanning alert.
       */
      state: 'open' | 'dismissed' | 'fixed';
    } | null;
    /**
     * The code scanning alert number.
     */
    number: number;
    rule: {
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      full_description?: string;
      help?: string | null;
      /**
       * A link to the documentation for the rule used to detect the alert.
       */
      help_uri?: string | null;
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      name?: string;
      /**
       * The severity of the alert.
       */
      severity: ('none' | 'note' | 'warning' | 'error') | null;
      tags?: Array<string> | null;
    };
    /**
     * State of a code scanning alert.
     */
    state: 'open' | 'dismissed' | 'fixed';
    tool: {
      guid?: string | null;
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
    };
    url: string;
  } | null;
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string | null;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string | null;
  repository: repository;
  sender: simple_user;
};

export type action11 = 'reopened';

export type webhook_code_scanning_alert_reopened_by_user = {
  action: 'reopened_by_user';
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string;
    dismissed_by: string;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    most_recent_instance?: {
      /**
       * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
       */
      analysis_key: string;
      classifications?: Array<string>;
      commit_sha?: string;
      /**
       * Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
       */
      environment: string;
      location?: {
        end_column?: number;
        end_line?: number;
        path?: string;
        start_column?: number;
        start_line?: number;
      };
      message?: {
        text?: string;
      };
      /**
       * The full Git reference, formatted as `refs/heads/<branch name>`.
       */
      ref: string;
      /**
       * State of a code scanning alert.
       */
      state: 'open' | 'dismissed' | 'fixed';
    } | null;
    /**
     * The code scanning alert number.
     */
    number: number;
    rule: {
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      /**
       * The severity of the alert.
       */
      severity: ('none' | 'note' | 'warning' | 'error') | null;
    };
    /**
     * State of a code scanning alert.
     */
    state: 'open' | 'fixed';
    tool: {
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
    };
    url: string;
  };
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  repository: repository;
  sender: simple_user;
};

export type action12 = 'reopened_by_user';

export type webhook_commit_comment_created = {
  /**
   * The action performed. Can be `created`.
   */
  action: 'created';
  /**
   * The [commit comment](https://docs.github.com/rest/reference/repos#get-a-commit-comment) resource.
   */
  comment: {
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The text of the comment.
     */
    body: string;
    /**
     * The SHA of the commit to which the comment applies.
     */
    commit_id: string;
    created_at: string;
    html_url: string;
    /**
     * The ID of the commit comment.
     */
    id: number;
    /**
     * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
     */
    line: number | null;
    /**
     * The node ID of the commit comment.
     */
    node_id: string;
    /**
     * The relative path of the file to which the comment applies.
     */
    path: string | null;
    /**
     * The line index in the diff to which the comment applies.
     */
    position: number | null;
    reactions?: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

/**
 * Configuration object of the webhook
 */
export type webhook_config = {
  content_type?: webhook_config_content_type;
  insecure_ssl?: webhook_config_insecure_ssl;
  secret?: webhook_config_secret;
  url?: webhook_config_url;
};

/**
 * The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
 */
export type webhook_config_content_type = string;

export type webhook_config_insecure_ssl = string | number;

/**
 * If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
 */
export type webhook_config_secret = string;

/**
 * The URL to which the payloads will be delivered.
 */
export type webhook_config_url = string;

export type webhook_create = {
  /**
   * The repository's current description.
   */
  description: string | null;
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The name of the repository's default branch (usually `main`).
   */
  master_branch: string;
  organization?: organization_simple;
  /**
   * The pusher type for the event. Can be either `user` or a deploy key.
   */
  pusher_type: string;
  /**
   * The [`git ref`](https://docs.github.com/rest/reference/git#get-a-reference) resource.
   */
  ref: string;
  /**
   * The type of Git ref object created in the repository.
   */
  ref_type: 'tag' | 'branch';
  repository: repository;
  sender: simple_user;
};

/**
 * The type of Git ref object created in the repository.
 */
export type ref_type = 'tag' | 'branch';

export type webhook_delete = {
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * The pusher type for the event. Can be either `user` or a deploy key.
   */
  pusher_type: string;
  /**
   * The [`git ref`](https://docs.github.com/rest/reference/git#get-a-reference) resource.
   */
  ref: string;
  /**
   * The type of Git ref object deleted in the repository.
   */
  ref_type: 'tag' | 'branch';
  repository: repository;
  sender: simple_user;
};

export type webhook_dependabot_alert_created = {
  action: 'created';
  alert: dependabot_alert;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_dependabot_alert_dismissed = {
  action: 'dismissed';
  alert: dependabot_alert;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action13 = 'dismissed';

export type webhook_dependabot_alert_fixed = {
  action: 'fixed';
  alert: dependabot_alert;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_dependabot_alert_reintroduced = {
  action: 'reintroduced';
  alert: dependabot_alert;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action14 = 'reintroduced';

export type webhook_dependabot_alert_reopened = {
  action: 'reopened';
  alert: dependabot_alert;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_deploy_key_created = {
  action: 'created';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [`deploy key`](https://docs.github.com/rest/reference/deployments#get-a-deploy-key) resource.
   */
  key: {
    added_by?: string | null;
    created_at: string;
    id: number;
    key: string;
    last_used?: string | null;
    read_only: boolean;
    title: string;
    url: string;
    verified: boolean;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_deploy_key_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [`deploy key`](https://docs.github.com/rest/reference/deployments#get-a-deploy-key) resource.
   */
  key: {
    added_by?: string | null;
    created_at: string;
    id: number;
    key: string;
    last_used?: string | null;
    read_only: boolean;
    title: string;
    url: string;
    verified: boolean;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_deployment_created = {
  action: 'created';
  /**
   * The [deployment](https://docs.github.com/rest/reference/deployments#list-deployments).
   */
  deployment: {
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    description: string | null;
    environment: string;
    id: number;
    node_id: string;
    original_environment: string;
    payload:
      | {
          [key: string]: string;
        }
      | string;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'workflow_job'
        | 'pull_request_review_thread'
        | 'merge_queue_entry'
        | 'secret_scanning_alert_location'
        | 'merge_group'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    production_environment?: boolean;
    ref: string;
    repository_url: string;
    sha: string;
    statuses_url: string;
    task: string;
    transient_environment?: boolean;
    updated_at: string;
    url: string;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
  workflow: {
    badge_url: string;
    created_at: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    path: string;
    state: string;
    updated_at: string;
    url: string;
  } | null;
  workflow_run: {
    actor: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    artifacts_url?: string;
    cancel_url?: string;
    check_suite_id: number;
    check_suite_node_id: string;
    check_suite_url?: string;
    conclusion: ('success' | 'failure' | 'neutral' | 'cancelled' | 'timed_out' | 'action_required' | 'stale') | null;
    created_at: string;
    display_title: string;
    event: string;
    head_branch: string;
    head_commit?: string;
    head_repository?: {
      archive_url?: string;
      assignees_url?: string;
      blobs_url?: string;
      branches_url?: string;
      collaborators_url?: string;
      comments_url?: string;
      commits_url?: string;
      compare_url?: string;
      contents_url?: string;
      contributors_url?: string;
      deployments_url?: string;
      description?: string;
      downloads_url?: string;
      events_url?: string;
      fork?: boolean;
      forks_url?: string;
      full_name?: string;
      git_commits_url?: string;
      git_refs_url?: string;
      git_tags_url?: string;
      hooks_url?: string;
      html_url?: string;
      id?: number;
      issue_comment_url?: string;
      issue_events_url?: string;
      issues_url?: string;
      keys_url?: string;
      labels_url?: string;
      languages_url?: string;
      merges_url?: string;
      milestones_url?: string;
      name?: string;
      node_id?: string;
      notifications_url?: string;
      owner?: {
        avatar_url?: string;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id?: number;
        login?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: string;
        url?: string;
      };
      private?: boolean;
      pulls_url?: string;
      releases_url?: string;
      stargazers_url?: string;
      statuses_url?: string;
      subscribers_url?: string;
      subscription_url?: string;
      tags_url?: string;
      teams_url?: string;
      trees_url?: string;
      url?: string;
    };
    head_sha: string;
    html_url: string;
    id: number;
    jobs_url?: string;
    logs_url?: string;
    name: string;
    node_id: string;
    path: string;
    previous_attempt_url?: string;
    pull_requests: Array<{
      base: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      head: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      id: number;
      number: number;
      url: string;
    }>;
    referenced_workflows?: Array<{
      path: string;
      ref?: string;
      sha: string;
    }> | null;
    repository?: {
      archive_url?: string;
      assignees_url?: string;
      blobs_url?: string;
      branches_url?: string;
      collaborators_url?: string;
      comments_url?: string;
      commits_url?: string;
      compare_url?: string;
      contents_url?: string;
      contributors_url?: string;
      deployments_url?: string;
      description?: string;
      downloads_url?: string;
      events_url?: string;
      fork?: boolean;
      forks_url?: string;
      full_name?: string;
      git_commits_url?: string;
      git_refs_url?: string;
      git_tags_url?: string;
      hooks_url?: string;
      html_url?: string;
      id?: number;
      issue_comment_url?: string;
      issue_events_url?: string;
      issues_url?: string;
      keys_url?: string;
      labels_url?: string;
      languages_url?: string;
      merges_url?: string;
      milestones_url?: string;
      name?: string;
      node_id?: string;
      notifications_url?: string;
      owner?: {
        avatar_url?: string;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id?: number;
        login?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: string;
        url?: string;
      };
      private?: boolean;
      pulls_url?: string;
      releases_url?: string;
      stargazers_url?: string;
      statuses_url?: string;
      subscribers_url?: string;
      subscription_url?: string;
      tags_url?: string;
      teams_url?: string;
      trees_url?: string;
      url?: string;
    };
    rerun_url?: string;
    run_attempt: number;
    run_number: number;
    run_started_at: string;
    status: 'requested' | 'in_progress' | 'completed' | 'queued' | 'waiting' | 'pending';
    triggering_actor?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    updated_at: string;
    url: string;
    workflow_id: number;
    workflow_url?: string;
  } | null;
};

export type organization_projects2 = 'read' | 'write';

export type repository_projects2 = 'read' | 'write';

export type status12 = 'requested' | 'in_progress' | 'completed' | 'queued' | 'waiting' | 'pending';

export type webhook_deployment_status_created = {
  action: 'created';
  check_run?: {
    completed_at: string | null;
    /**
     * The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
     */
    conclusion:
      | ('success' | 'failure' | 'neutral' | 'cancelled' | 'timed_out' | 'action_required' | 'stale' | 'skipped')
      | null;
    details_url: string;
    external_id: string;
    /**
     * The SHA of the commit that is being checked.
     */
    head_sha: string;
    html_url: string;
    /**
     * The id of the check.
     */
    id: number;
    /**
     * The name of the check run.
     */
    name: string;
    node_id: string;
    started_at: string;
    /**
     * The current status of the check run. Can be `queued`, `in_progress`, or `completed`.
     */
    status: 'queued' | 'in_progress' | 'completed' | 'waiting' | 'pending';
    url: string;
  } | null;
  /**
   * The [deployment](https://docs.github.com/rest/reference/deployments#list-deployments).
   */
  deployment: {
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    description: string | null;
    environment: string;
    id: number;
    node_id: string;
    original_environment: string;
    payload:
      | (
          | string
          | {
              [key: string]: string;
            }
        )
      | null;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'merge_queue_entry'
        | 'workflow_job'
        | 'pull_request_review_thread'
        | 'secret_scanning_alert_location'
        | 'merge_group'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    production_environment?: boolean;
    ref: string;
    repository_url: string;
    sha: string;
    statuses_url: string;
    task: string;
    transient_environment?: boolean;
    updated_at: string;
    url: string;
  };
  /**
   * The [deployment status](https://docs.github.com/rest/reference/deployments#list-deployment-statuses).
   */
  deployment_status: {
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    deployment_url: string;
    /**
     * The optional human-readable description added to the status.
     */
    description: string;
    environment: string;
    environment_url?: string;
    id: number;
    log_url?: string;
    node_id: string;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'pull_request_review_thread'
        | 'merge_queue_entry'
        | 'workflow_job'
        | 'merge_group'
        | 'secret_scanning_alert_location'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    repository_url: string;
    /**
     * The new state. Can be `pending`, `success`, `failure`, or `error`.
     */
    state: string;
    /**
     * The optional link added to the status.
     */
    target_url: string;
    updated_at: string;
    url: string;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
  workflow?: {
    badge_url: string;
    created_at: string;
    html_url: string;
    id: number;
    name: string;
    node_id: string;
    path: string;
    state: string;
    updated_at: string;
    url: string;
  } | null;
  workflow_run?: {
    actor: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    artifacts_url?: string;
    cancel_url?: string;
    check_suite_id: number;
    check_suite_node_id: string;
    check_suite_url?: string;
    conclusion:
      | (
          | 'success'
          | 'failure'
          | 'neutral'
          | 'cancelled'
          | 'timed_out'
          | 'action_required'
          | 'stale'
          | 'startup_failure'
        )
      | null;
    created_at: string;
    display_title: string;
    event: string;
    head_branch: string;
    head_commit?: string;
    head_repository?: {
      archive_url?: string;
      assignees_url?: string;
      blobs_url?: string;
      branches_url?: string;
      collaborators_url?: string;
      comments_url?: string;
      commits_url?: string;
      compare_url?: string;
      contents_url?: string;
      contributors_url?: string;
      deployments_url?: string;
      description?: string;
      downloads_url?: string;
      events_url?: string;
      fork?: boolean;
      forks_url?: string;
      full_name?: string;
      git_commits_url?: string;
      git_refs_url?: string;
      git_tags_url?: string;
      hooks_url?: string;
      html_url?: string;
      id?: number;
      issue_comment_url?: string;
      issue_events_url?: string;
      issues_url?: string;
      keys_url?: string;
      labels_url?: string;
      languages_url?: string;
      merges_url?: string;
      milestones_url?: string;
      name?: string;
      node_id?: string;
      notifications_url?: string;
      owner?: {
        avatar_url?: string;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id?: number;
        login?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: string;
        url?: string;
      };
      private?: boolean;
      pulls_url?: string;
      releases_url?: string;
      stargazers_url?: string;
      statuses_url?: string;
      subscribers_url?: string;
      subscription_url?: string;
      tags_url?: string;
      teams_url?: string;
      trees_url?: string;
      url?: string;
    };
    head_sha: string;
    html_url: string;
    id: number;
    jobs_url?: string;
    logs_url?: string;
    name: string;
    node_id: string;
    path: string;
    previous_attempt_url?: string;
    pull_requests: Array<{
      base: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      head: {
        ref: string;
        repo: {
          id: number;
          name: string;
          url: string;
        };
        sha: string;
      };
      id: number;
      number: number;
      url: string;
    }>;
    referenced_workflows?: Array<{
      path: string;
      ref?: string;
      sha: string;
    }> | null;
    repository?: {
      archive_url?: string;
      assignees_url?: string;
      blobs_url?: string;
      branches_url?: string;
      collaborators_url?: string;
      comments_url?: string;
      commits_url?: string;
      compare_url?: string;
      contents_url?: string;
      contributors_url?: string;
      deployments_url?: string;
      description?: string;
      downloads_url?: string;
      events_url?: string;
      fork?: boolean;
      forks_url?: string;
      full_name?: string;
      git_commits_url?: string;
      git_refs_url?: string;
      git_tags_url?: string;
      hooks_url?: string;
      html_url?: string;
      id?: number;
      issue_comment_url?: string;
      issue_events_url?: string;
      issues_url?: string;
      keys_url?: string;
      labels_url?: string;
      languages_url?: string;
      merges_url?: string;
      milestones_url?: string;
      name?: string;
      node_id?: string;
      notifications_url?: string;
      owner?: {
        avatar_url?: string;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id?: number;
        login?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: string;
        url?: string;
      };
      private?: boolean;
      pulls_url?: string;
      releases_url?: string;
      stargazers_url?: string;
      statuses_url?: string;
      subscribers_url?: string;
      subscription_url?: string;
      tags_url?: string;
      teams_url?: string;
      trees_url?: string;
      url?: string;
    };
    rerun_url?: string;
    run_attempt: number;
    run_number: number;
    run_started_at: string;
    status: 'requested' | 'in_progress' | 'completed' | 'queued' | 'waiting' | 'pending';
    triggering_actor: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    updated_at: string;
    url: string;
    workflow_id: number;
    workflow_url?: string;
  } | null;
};

export type webhook_discussion_answered = {
  action: 'answered';
  answer: {
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    body: string;
    child_comment_count: number;
    created_at: string;
    discussion_id: number;
    html_url: string;
    id: number;
    node_id: string;
    parent_id: string;
    reactions?: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    updated_at: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action15 = 'answered';

export type webhook_discussion_category_changed = {
  action: 'category_changed';
  changes: {
    category: {
      from: {
        created_at: string;
        description: string;
        emoji: string;
        id: number;
        is_answerable: boolean;
        name: string;
        node_id?: string;
        repository_id: number;
        slug: string;
        updated_at: string;
      };
    };
  };
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action16 = 'category_changed';

export type webhook_discussion_comment_created = {
  action: 'created';
  comment: {
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    body: string;
    child_comment_count: number;
    created_at: string;
    discussion_id: number;
    html_url: string;
    id: number;
    node_id: string;
    parent_id: number | null;
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    updated_at: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_discussion_comment_deleted = {
  action: 'deleted';
  comment: {
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    body: string;
    child_comment_count: number;
    created_at: string;
    discussion_id: number;
    html_url: string;
    id: number;
    node_id: string;
    parent_id: number | null;
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    updated_at: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_discussion_comment_edited = {
  action: 'edited';
  changes: {
    body: {
      from: string;
    };
  };
  comment: {
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    body: string;
    child_comment_count: number;
    created_at: string;
    discussion_id: number;
    html_url: string;
    id: number;
    node_id: string;
    parent_id: number | null;
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    updated_at: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_discussion_created = {
  action: 'created';
  discussion: {
    active_lock_reason: string | null;
    answer_chosen_at: string | null;
    answer_chosen_by: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    answer_html_url: string | null;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    body: string | null;
    category: {
      created_at: string;
      description: string;
      emoji: string;
      id: number;
      is_answerable: boolean;
      name: string;
      node_id?: string;
      repository_id: number;
      slug: string;
      updated_at: string;
    };
    comments: number;
    created_at: string;
    html_url: string;
    id: number;
    locked: boolean;
    node_id: string;
    number: number;
    reactions?: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    state: 'open' | 'locked' | 'converting' | 'transferring';
    timeline_url?: string;
    title: string;
    updated_at: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  } & {
    active_lock_reason?: string;
    answer_chosen_at: string;
    answer_chosen_by: string;
    answer_html_url: string | null;
    author_association?: string;
    body?: string | null;
    category?: {
      created_at?: string;
      description?: string;
      emoji?: string;
      id?: number;
      is_answerable?: boolean;
      name?: string;
      node_id?: string;
      repository_id?: number;
      slug?: string;
      updated_at?: string;
    };
    comments?: number;
    created_at?: string;
    html_url?: string;
    id?: number;
    locked: boolean;
    node_id?: string;
    number?: number;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    state: 'open' | 'converting' | 'transferring';
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_discussion_deleted = {
  action: 'deleted';
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_discussion_edited = {
  action: 'edited';
  changes?: {
    body?: {
      from: string;
    };
    title?: {
      from: string;
    };
  };
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_discussion_labeled = {
  action: 'labeled';
  discussion: {
    active_lock_reason: string | null;
    answer_chosen_at: string | null;
    answer_chosen_by: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    answer_html_url: string | null;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    body: string | null;
    category: {
      created_at: string;
      description: string;
      emoji: string;
      id: number;
      is_answerable: boolean;
      name: string;
      node_id?: string;
      repository_id: number;
      slug: string;
      updated_at: string;
    };
    comments: number;
    created_at: string;
    html_url: string;
    id: number;
    locked: boolean;
    node_id: string;
    number: number;
    reactions?: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    state: 'open' | 'locked' | 'converting' | 'transferring';
    timeline_url?: string;
    title: string;
    updated_at: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  label: {
    /**
     * 6-character hex code, without the leading #, identifying the color
     */
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    /**
     * The name of the label.
     */
    name: string;
    node_id: string;
    /**
     * URL for the label
     */
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action17 = 'labeled';

export type webhook_discussion_locked = {
  action: 'locked';
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action18 = 'locked';

export type webhook_discussion_pinned = {
  action: 'pinned';
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action19 = 'pinned';

export type webhook_discussion_transferred = {
  action: 'transferred';
  changes: {
    new_discussion: {
      active_lock_reason: string | null;
      answer_chosen_at: string | null;
      answer_chosen_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      answer_html_url: string | null;
      /**
       * How the author is associated with the repository.
       */
      author_association:
        | 'COLLABORATOR'
        | 'CONTRIBUTOR'
        | 'FIRST_TIMER'
        | 'FIRST_TIME_CONTRIBUTOR'
        | 'MANNEQUIN'
        | 'MEMBER'
        | 'NONE'
        | 'OWNER';
      body: string;
      category: {
        created_at: string;
        description: string;
        emoji: string;
        id: number;
        is_answerable: boolean;
        name: string;
        node_id?: string;
        repository_id: number;
        slug: string;
        updated_at: string;
      };
      comments: number;
      created_at: string;
      html_url: string;
      id: number;
      locked: boolean;
      node_id: string;
      number: number;
      reactions?: {
        '+1': number;
        '-1': number;
        confused: number;
        eyes: number;
        heart: number;
        hooray: number;
        laugh: number;
        rocket: number;
        total_count: number;
        url: string;
      };
      repository_url: string;
      state: 'open' | 'locked' | 'converting' | 'transferring';
      timeline_url?: string;
      title: string;
      updated_at: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    /**
     * A git repository
     */
    new_repository: {
      /**
       * Whether to allow auto-merge for pull requests.
       */
      allow_auto_merge?: boolean;
      /**
       * Whether to allow private forks
       */
      allow_forking?: boolean;
      /**
       * Whether to allow merge commits for pull requests.
       */
      allow_merge_commit?: boolean;
      /**
       * Whether to allow rebase merges for pull requests.
       */
      allow_rebase_merge?: boolean;
      /**
       * Whether to allow squash merges for pull requests.
       */
      allow_squash_merge?: boolean;
      allow_update_branch?: boolean;
      archive_url: string;
      /**
       * Whether the repository is archived.
       */
      archived: boolean;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      clone_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      created_at: number | string;
      /**
       * The default branch of the repository.
       */
      default_branch: string;
      /**
       * Whether to delete head branches when pull requests are merged
       */
      delete_branch_on_merge?: boolean;
      deployments_url: string;
      description: string | null;
      /**
       * Returns whether or not this repository is disabled.
       */
      disabled?: boolean;
      downloads_url: string;
      events_url: string;
      fork: boolean;
      forks: number;
      forks_count: number;
      forks_url: string;
      full_name: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      /**
       * Whether discussions are enabled.
       */
      has_discussions: boolean;
      /**
       * Whether downloads are enabled.
       */
      has_downloads: boolean;
      /**
       * Whether issues are enabled.
       */
      has_issues: boolean;
      has_pages: boolean;
      /**
       * Whether projects are enabled.
       */
      has_projects: boolean;
      /**
       * Whether the wiki is enabled.
       */
      has_wiki: boolean;
      homepage: string | null;
      hooks_url: string;
      html_url: string;
      /**
       * Unique identifier of the repository
       */
      id: number;
      is_template?: boolean;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      language: string | null;
      languages_url: string;
      license: {
        key: string;
        name: string;
        node_id: string;
        spdx_id: string;
        url: string | null;
      } | null;
      master_branch?: string;
      merges_url: string;
      milestones_url: string;
      mirror_url: string | null;
      /**
       * The name of the repository.
       */
      name: string;
      node_id: string;
      notifications_url: string;
      open_issues: number;
      open_issues_count: number;
      organization?: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        pull: boolean;
        push: boolean;
        triage?: boolean;
      };
      /**
       * Whether the repository is private or public.
       */
      private: boolean;
      public?: boolean;
      pulls_url: string;
      pushed_at: (number | string) | null;
      releases_url: string;
      role_name?: string | null;
      size: number;
      ssh_url: string;
      stargazers?: number;
      stargazers_count: number;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      svn_url: string;
      tags_url: string;
      teams_url: string;
      topics: Array<string>;
      trees_url: string;
      updated_at: string;
      url: string;
      visibility: 'public' | 'private' | 'internal';
      watchers: number;
      watchers_count: number;
      /**
       * Whether to require contributors to sign off on web-based commits
       */
      web_commit_signoff_required?: boolean;
    };
  };
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action20 = 'transferred';

export type visibility3 = 'public' | 'private' | 'internal';

export type webhook_discussion_unanswered = {
  action: 'unanswered';
  discussion: discussion;
  old_answer: {
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    body: string;
    child_comment_count: number;
    created_at: string;
    discussion_id: number;
    html_url: string;
    id: number;
    node_id: string;
    parent_id: string;
    reactions?: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    updated_at: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization?: organization_simple;
  repository: repository;
  sender?: simple_user;
};

export type action21 = 'unanswered';

export type webhook_discussion_unlabeled = {
  action: 'unlabeled';
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  label: {
    /**
     * 6-character hex code, without the leading #, identifying the color
     */
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    /**
     * The name of the label.
     */
    name: string;
    node_id: string;
    /**
     * URL for the label
     */
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action22 = 'unlabeled';

export type webhook_discussion_unlocked = {
  action: 'unlocked';
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action23 = 'unlocked';

export type webhook_discussion_unpinned = {
  action: 'unpinned';
  discussion: discussion;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action24 = 'unpinned';

/**
 * A user forks a repository.
 */
export type webhook_fork = {
  enterprise?: enterprise;
  /**
   * The created [`repository`](https://docs.github.com/rest/reference/repos#get-a-repository) resource.
   */
  forkee: {
    /**
     * Whether to allow auto-merge for pull requests.
     */
    allow_auto_merge?: boolean;
    /**
     * Whether to allow private forks
     */
    allow_forking?: boolean;
    /**
     * Whether to allow merge commits for pull requests.
     */
    allow_merge_commit?: boolean;
    /**
     * Whether to allow rebase merges for pull requests.
     */
    allow_rebase_merge?: boolean;
    /**
     * Whether to allow squash merges for pull requests.
     */
    allow_squash_merge?: boolean;
    allow_update_branch?: boolean;
    archive_url: string;
    /**
     * Whether the repository is archived.
     */
    archived: boolean;
    assignees_url: string;
    blobs_url: string;
    branches_url: string;
    clone_url: string;
    collaborators_url: string;
    comments_url: string;
    commits_url: string;
    compare_url: string;
    contents_url: string;
    contributors_url: string;
    created_at: number | string;
    /**
     * The default branch of the repository.
     */
    default_branch: string;
    /**
     * Whether to delete head branches when pull requests are merged
     */
    delete_branch_on_merge?: boolean;
    deployments_url: string;
    description: string | null;
    /**
     * Returns whether or not this repository is disabled.
     */
    disabled?: boolean;
    downloads_url: string;
    events_url: string;
    fork: boolean;
    forks: number;
    forks_count: number;
    forks_url: string;
    full_name: string;
    git_commits_url: string;
    git_refs_url: string;
    git_tags_url: string;
    git_url: string;
    /**
     * Whether downloads are enabled.
     */
    has_downloads: boolean;
    /**
     * Whether issues are enabled.
     */
    has_issues: boolean;
    has_pages: boolean;
    /**
     * Whether projects are enabled.
     */
    has_projects: boolean;
    /**
     * Whether the wiki is enabled.
     */
    has_wiki: boolean;
    homepage: string | null;
    hooks_url: string;
    html_url: string;
    /**
     * Unique identifier of the repository
     */
    id: number;
    is_template?: boolean;
    issue_comment_url: string;
    issue_events_url: string;
    issues_url: string;
    keys_url: string;
    labels_url: string;
    language: string | null;
    languages_url: string;
    license: {
      key: string;
      name: string;
      node_id: string;
      spdx_id: string;
      url: string | null;
    } | null;
    master_branch?: string;
    merges_url: string;
    milestones_url: string;
    mirror_url: string | null;
    /**
     * The name of the repository.
     */
    name: string;
    node_id: string;
    notifications_url: string;
    open_issues: number;
    open_issues_count: number;
    organization?: string;
    owner: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    permissions?: {
      admin: boolean;
      maintain?: boolean;
      pull: boolean;
      push: boolean;
      triage?: boolean;
    };
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
    public?: boolean;
    pulls_url: string;
    pushed_at: (number | string) | null;
    releases_url: string;
    role_name?: string | null;
    size: number;
    ssh_url: string;
    stargazers?: number;
    stargazers_count: number;
    stargazers_url: string;
    statuses_url: string;
    subscribers_url: string;
    subscription_url: string;
    svn_url: string;
    tags_url: string;
    teams_url: string;
    topics: Array<string>;
    trees_url: string;
    updated_at: string;
    url: string;
    visibility: 'public' | 'private' | 'internal';
    watchers: number;
    watchers_count: number;
    /**
     * Whether to require contributors to sign off on web-based commits
     */
    web_commit_signoff_required?: boolean;
  } & {
    allow_forking?: boolean;
    archive_url?: string;
    archived?: boolean;
    assignees_url?: string;
    blobs_url?: string;
    branches_url?: string;
    clone_url?: string;
    collaborators_url?: string;
    comments_url?: string;
    commits_url?: string;
    compare_url?: string;
    contents_url?: string;
    contributors_url?: string;
    created_at?: string;
    default_branch?: string;
    deployments_url?: string;
    description?: string | null;
    disabled?: boolean;
    downloads_url?: string;
    events_url?: string;
    fork?: boolean;
    forks?: number;
    forks_count?: number;
    forks_url?: string;
    full_name?: string;
    git_commits_url?: string;
    git_refs_url?: string;
    git_tags_url?: string;
    git_url?: string;
    has_downloads?: boolean;
    has_issues?: boolean;
    has_pages?: boolean;
    has_projects?: boolean;
    has_wiki?: boolean;
    homepage?: string | null;
    hooks_url?: string;
    html_url?: string;
    id?: number;
    is_template?: boolean;
    issue_comment_url?: string;
    issue_events_url?: string;
    issues_url?: string;
    keys_url?: string;
    labels_url?: string;
    language?: string;
    languages_url?: string;
    license?: {
      [key: string]: string;
    } | null;
    merges_url?: string;
    milestones_url?: string;
    mirror_url?: string;
    name?: string;
    node_id?: string;
    notifications_url?: string;
    open_issues?: number;
    open_issues_count?: number;
    owner?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
    private?: boolean;
    public?: boolean;
    pulls_url?: string;
    pushed_at?: string;
    releases_url?: string;
    size?: number;
    ssh_url?: string;
    stargazers_count?: number;
    stargazers_url?: string;
    statuses_url?: string;
    subscribers_url?: string;
    subscription_url?: string;
    svn_url?: string;
    tags_url?: string;
    teams_url?: string;
    topics?: Array<string>;
    trees_url?: string;
    updated_at?: string;
    url?: string;
    visibility?: string;
    watchers?: number;
    watchers_count?: number;
  };
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_github_app_authorization_revoked = {
  action: 'revoked';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository?: repository;
  sender: simple_user;
};

export type action25 = 'revoked';

export type webhook_gollum = {
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * The pages that were updated.
   */
  pages: Array<{
    /**
     * The action that was performed on the page. Can be `created` or `edited`.
     */
    action: 'created' | 'edited';
    /**
     * Points to the HTML wiki page.
     */
    html_url: string;
    /**
     * The name of the page.
     */
    page_name: string;
    /**
     * The latest commit SHA of the page.
     */
    sha: string;
    summary: string | null;
    /**
     * The current page title.
     */
    title: string;
  }>;
  repository: repository;
  sender: simple_user;
};

export type webhook_installation_created = {
  action: 'created';
  enterprise?: enterprise;
  installation: installation;
  organization?: organization_simple;
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: Array<{
    full_name: string;
    /**
     * Unique identifier of the repository
     */
    id: number;
    /**
     * The name of the repository.
     */
    name: string;
    node_id: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }>;
  repository?: repository;
  requester?: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  sender: simple_user;
};

export type webhook_installation_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation: installation;
  organization?: organization_simple;
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: Array<{
    full_name: string;
    /**
     * Unique identifier of the repository
     */
    id: number;
    /**
     * The name of the repository.
     */
    name: string;
    node_id: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }>;
  repository?: repository;
  requester?: string;
  sender: simple_user;
};

export type webhook_installation_new_permissions_accepted = {
  action: 'new_permissions_accepted';
  enterprise?: enterprise;
  installation: installation;
  organization?: organization_simple;
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: Array<{
    full_name: string;
    /**
     * Unique identifier of the repository
     */
    id: number;
    /**
     * The name of the repository.
     */
    name: string;
    node_id: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }>;
  repository?: repository;
  requester?: string;
  sender: simple_user;
};

export type action26 = 'new_permissions_accepted';

export type webhook_installation_repositories_added = {
  action: 'added';
  enterprise?: enterprise;
  installation: installation;
  organization?: organization_simple;
  /**
   * An array of repository objects, which were added to the installation.
   */
  repositories_added: Array<{
    full_name: string;
    /**
     * Unique identifier of the repository
     */
    id: number;
    /**
     * The name of the repository.
     */
    name: string;
    node_id: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }>;
  /**
   * An array of repository objects, which were removed from the installation.
   */
  repositories_removed: Array<{
    full_name?: string;
    /**
     * Unique identifier of the repository
     */
    id?: number;
    /**
     * The name of the repository.
     */
    name?: string;
    node_id?: string;
    /**
     * Whether the repository is private or public.
     */
    private?: boolean;
  }>;
  repository?: repository;
  /**
   * Describe whether all repositories have been selected or there's a selection involved
   */
  repository_selection: 'all' | 'selected';
  requester: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  sender: simple_user;
};

export type action27 = 'added';

export type webhook_installation_repositories_removed = {
  action: 'removed';
  enterprise?: enterprise;
  installation: installation;
  organization?: organization_simple;
  /**
   * An array of repository objects, which were added to the installation.
   */
  repositories_added: Array<{
    full_name: string;
    /**
     * Unique identifier of the repository
     */
    id: number;
    /**
     * The name of the repository.
     */
    name: string;
    node_id: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }>;
  /**
   * An array of repository objects, which were removed from the installation.
   */
  repositories_removed: Array<{
    full_name: string;
    /**
     * Unique identifier of the repository
     */
    id: number;
    /**
     * The name of the repository.
     */
    name: string;
    node_id: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }>;
  repository?: repository;
  /**
   * Describe whether all repositories have been selected or there's a selection involved
   */
  repository_selection: 'all' | 'selected';
  requester: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  sender: simple_user;
};

export type action28 = 'removed';

export type webhook_installation_suspend = {
  action: 'suspend';
  enterprise?: enterprise;
  installation: installation;
  organization?: organization_simple;
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: Array<{
    full_name: string;
    /**
     * Unique identifier of the repository
     */
    id: number;
    /**
     * The name of the repository.
     */
    name: string;
    node_id: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }>;
  repository?: repository;
  requester?: string;
  sender: simple_user;
};

export type action29 = 'suspend';

export type webhook_installation_target_renamed = {
  account: {
    avatar_url: string;
    created_at?: string;
    description?: string;
    events_url?: string;
    followers?: number;
    followers_url?: string;
    following?: number;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    has_organization_projects?: boolean;
    has_repository_projects?: boolean;
    hooks_url?: string;
    html_url: string;
    id: number;
    is_verified?: boolean;
    issues_url?: string;
    login?: string;
    members_url?: string;
    name?: string;
    node_id: string;
    organizations_url?: string;
    public_gists?: number;
    public_members_url?: string;
    public_repos?: number;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    slug?: string;
    starred_url?: string;
    subscriptions_url?: string;
    type?: string;
    updated_at?: string;
    url?: string;
    website_url?: string;
  };
  action: string;
  changes: {
    login?: {
      from: string;
    };
    slug?: {
      from: string;
    };
  };
  enterprise?: enterprise;
  installation: simple_installation;
  organization?: organization_simple;
  repository?: repository;
  sender?: simple_user;
  target_type: string;
};

export type webhook_installation_unsuspend = {
  action: 'unsuspend';
  enterprise?: enterprise;
  installation: installation;
  organization?: organization_simple;
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: Array<{
    full_name: string;
    /**
     * Unique identifier of the repository
     */
    id: number;
    /**
     * The name of the repository.
     */
    name: string;
    node_id: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }>;
  repository?: repository;
  requester?: string;
  sender: simple_user;
};

export type action30 = 'unsuspend';

export type webhook_issue_comment_created = {
  action: 'created';
  /**
   * The [comment](https://docs.github.com/rest/reference/issues#comments) itself.
   */
  comment: {
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue comment
     */
    body: string;
    created_at: string;
    html_url: string;
    /**
     * Unique identifier of the issue comment
     */
    id: number;
    issue_url: string;
    node_id: string;
    performed_via_github_app: nullable_integration;
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    updated_at: string;
    /**
     * URL for the issue comment
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) the comment belongs to.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'reminder'
        | 'pull_request_review_thread'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write' | 'admin';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  } & {
    active_lock_reason?: string | null;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    body?: string | null;
    closed_at?: string | null;
    comments?: number;
    comments_url?: string;
    created_at?: string;
    events_url?: string;
    html_url?: string;
    id?: number;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url?: string;
    locked: boolean;
    milestone?: {
      [key: string]: string;
    } | null;
    node_id?: string;
    number?: number;
    performed_via_github_app?: {
      [key: string]: string;
    } | null;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state: 'open' | 'closed';
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type active_lock_reason = 'resolved' | 'off-topic' | 'too heated' | 'spam';

export type webhook_issue_comment_deleted = {
  action: 'deleted';
  /**
   * The [comment](https://docs.github.com/rest/reference/issues#comments) itself.
   */
  comment: {
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue comment
     */
    body: string;
    created_at: string;
    html_url: string;
    /**
     * Unique identifier of the issue comment
     */
    id: number;
    issue_url: string;
    node_id: string;
    performed_via_github_app: nullable_integration;
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    updated_at: string;
    /**
     * URL for the issue comment
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) the comment belongs to.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  } & {
    active_lock_reason?: string | null;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    body?: string | null;
    closed_at?: string | null;
    comments?: number;
    comments_url?: string;
    created_at?: string;
    events_url?: string;
    html_url?: string;
    id?: number;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url?: string;
    locked: boolean;
    milestone?: {
      [key: string]: string;
    } | null;
    node_id?: string;
    number?: number;
    performed_via_github_app?: {
      [key: string]: string;
    } | null;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state: 'open' | 'closed';
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type type7 = 'Bot' | 'User' | 'Organization' | 'Mannequin';

export type webhook_issue_comment_edited = {
  action: 'edited';
  /**
   * The changes to the comment.
   */
  changes: {
    body?: {
      /**
       * The previous version of the body.
       */
      from: string;
    };
  };
  /**
   * The [comment](https://docs.github.com/rest/reference/issues#comments) itself.
   */
  comment: {
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue comment
     */
    body: string;
    created_at: string;
    html_url: string;
    /**
     * Unique identifier of the issue comment
     */
    id: number;
    issue_url: string;
    node_id: string;
    performed_via_github_app: nullable_integration;
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    updated_at: string;
    /**
     * URL for the issue comment
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) the comment belongs to.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'reminder'
        | 'pull_request_review_thread'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  } & {
    active_lock_reason?: string | null;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    body?: string | null;
    closed_at?: string | null;
    comments?: number;
    comments_url?: string;
    created_at?: string;
    events_url?: string;
    html_url?: string;
    id?: number;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url?: string;
    locked: boolean;
    milestone?: {
      [key: string]: string;
    } | null;
    node_id?: string;
    number?: number;
    performed_via_github_app?: {
      [key: string]: string;
    } | null;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state: 'open' | 'closed';
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_assigned = {
  /**
   * The action that was performed.
   */
  action: 'assigned';
  assignee?: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'reminder'
        | 'pull_request_review_thread'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

/**
 * The action that was performed.
 */
export type action31 = 'assigned';

export type webhook_issues_closed = {
  /**
   * The action that was performed.
   */
  action: 'closed';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'security_and_analysis'
        | 'reminder'
        | 'pull_request_review_thread'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  } & {
    active_lock_reason?: string | null;
    assignee?: {
      [key: string]: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    body?: string | null;
    closed_at: string | null;
    comments?: number;
    comments_url?: string;
    created_at?: string;
    events_url?: string;
    html_url?: string;
    id?: number;
    labels?: Array<{
      [key: string]: string;
    } | null>;
    labels_url?: string;
    locked?: boolean;
    milestone?: {
      [key: string]: string;
    } | null;
    node_id?: string;
    number?: number;
    performed_via_github_app?: {
      [key: string]: string;
    } | null;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    state: 'closed' | 'open';
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

/**
 * The action that was performed.
 */
export type action32 = 'closed';

export type webhook_issues_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'reminder'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_demilestoned = {
  action: 'demilestoned';
  enterprise?: enterprise;
  installation?: simple_installation;
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  } & {
    active_lock_reason?: string | null;
    assignee?: {
      [key: string]: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    body?: string | null;
    closed_at?: string | null;
    comments?: number;
    comments_url?: string;
    created_at?: string;
    events_url?: string;
    html_url?: string;
    id?: number;
    labels?: Array<{
      [key: string]: string;
    } | null>;
    labels_url?: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id?: string;
    number?: number;
    performed_via_github_app?: {
      [key: string]: string;
    } | null;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    state?: string;
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  /**
   * A collection of related issues and pull requests.
   */
  milestone?: {
    closed_at: string | null;
    closed_issues: number;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    description: string | null;
    due_on: string | null;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    /**
     * The number of the milestone.
     */
    number: number;
    open_issues: number;
    /**
     * The state of the milestone.
     */
    state: 'open' | 'closed';
    /**
     * The title of the milestone.
     */
    title: string;
    updated_at: string;
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action33 = 'demilestoned';

export type webhook_issues_edited = {
  action: 'edited';
  /**
   * The changes to the issue.
   */
  changes: {
    body?: {
      /**
       * The previous version of the body.
       */
      from: string;
    };
    title?: {
      /**
       * The previous version of the title.
       */
      from: string;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'security_and_analysis'
        | 'pull_request_review_thread'
        | 'reminder'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  label?: {
    /**
     * 6-character hex code, without the leading #, identifying the color
     */
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    /**
     * The name of the label.
     */
    name: string;
    node_id: string;
    /**
     * URL for the label
     */
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_labeled = {
  action: 'labeled';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'pull_request_review_thread'
        | 'reminder'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  label?: {
    /**
     * 6-character hex code, without the leading #, identifying the color
     */
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    /**
     * The name of the label.
     */
    name: string;
    node_id: string;
    /**
     * URL for the label
     */
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_locked = {
  action: 'locked';
  enterprise?: enterprise;
  installation?: simple_installation;
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'reminder'
        | 'security_and_analysis'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  } & {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      [key: string]: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    body?: string | null;
    closed_at?: string | null;
    comments?: number;
    comments_url?: string;
    created_at?: string;
    events_url?: string;
    html_url?: string;
    id?: number;
    labels?: Array<{
      [key: string]: string;
    } | null>;
    labels_url?: string;
    locked: boolean;
    milestone?: {
      [key: string]: string;
    } | null;
    node_id?: string;
    number?: number;
    performed_via_github_app?: {
      [key: string]: string;
    } | null;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    state?: string;
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_milestoned = {
  action: 'milestoned';
  enterprise?: enterprise;
  installation?: simple_installation;
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'reminder'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  } & {
    active_lock_reason?: string | null;
    assignee?: {
      [key: string]: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    body?: string | null;
    closed_at?: string | null;
    comments?: number;
    comments_url?: string;
    created_at?: string;
    events_url?: string;
    html_url?: string;
    id?: number;
    labels?: Array<{
      [key: string]: string;
    } | null>;
    labels_url?: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    };
    node_id?: string;
    number?: number;
    performed_via_github_app?: {
      [key: string]: string;
    } | null;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    state?: string;
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  /**
   * A collection of related issues and pull requests.
   */
  milestone: {
    closed_at: string | null;
    closed_issues: number;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    description: string | null;
    due_on: string | null;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    /**
     * The number of the milestone.
     */
    number: number;
    open_issues: number;
    /**
     * The state of the milestone.
     */
    state: 'open' | 'closed';
    /**
     * The title of the milestone.
     */
    title: string;
    updated_at: string;
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action34 = 'milestoned';

export type webhook_issues_opened = {
  action: 'opened';
  changes?: {
    /**
     * The [issue](https://docs.github.com/rest/reference/issues) itself.
     */
    old_issue: {
      active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
      assignee?: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      assignees: Array<{
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null>;
      /**
       * How the author is associated with the repository.
       */
      author_association:
        | 'COLLABORATOR'
        | 'CONTRIBUTOR'
        | 'FIRST_TIMER'
        | 'FIRST_TIME_CONTRIBUTOR'
        | 'MANNEQUIN'
        | 'MEMBER'
        | 'NONE'
        | 'OWNER';
      /**
       * Contents of the issue
       */
      body: string | null;
      closed_at: string | null;
      comments: number;
      comments_url: string;
      created_at: string;
      draft?: boolean;
      events_url: string;
      html_url: string;
      id: number;
      labels?: Array<{
        /**
         * 6-character hex code, without the leading #, identifying the color
         */
        color: string;
        default: boolean;
        description: string | null;
        id: number;
        /**
         * The name of the label.
         */
        name: string;
        node_id: string;
        /**
         * URL for the label
         */
        url: string;
      }>;
      labels_url: string;
      locked?: boolean;
      /**
       * A collection of related issues and pull requests.
       */
      milestone: {
        closed_at: string | null;
        closed_issues: number;
        created_at: string;
        creator: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        description: string | null;
        due_on: string | null;
        html_url: string;
        id: number;
        labels_url: string;
        node_id: string;
        /**
         * The number of the milestone.
         */
        number: number;
        open_issues: number;
        /**
         * The state of the milestone.
         */
        state: 'open' | 'closed';
        /**
         * The title of the milestone.
         */
        title: string;
        updated_at: string;
        url: string;
      } | null;
      node_id: string;
      number: number;
      /**
       * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
       */
      performed_via_github_app?: {
        created_at: string | null;
        description: string | null;
        /**
         * The list of events for the GitHub app
         */
        events?: Array<
          | 'branch_protection_rule'
          | 'check_run'
          | 'check_suite'
          | 'code_scanning_alert'
          | 'commit_comment'
          | 'content_reference'
          | 'create'
          | 'delete'
          | 'deployment'
          | 'deployment_review'
          | 'deployment_status'
          | 'deploy_key'
          | 'discussion'
          | 'discussion_comment'
          | 'fork'
          | 'gollum'
          | 'issues'
          | 'issue_comment'
          | 'label'
          | 'member'
          | 'membership'
          | 'milestone'
          | 'organization'
          | 'org_block'
          | 'page_build'
          | 'project'
          | 'project_card'
          | 'project_column'
          | 'public'
          | 'pull_request'
          | 'pull_request_review'
          | 'pull_request_review_comment'
          | 'push'
          | 'registry_package'
          | 'release'
          | 'repository'
          | 'repository_dispatch'
          | 'secret_scanning_alert'
          | 'star'
          | 'status'
          | 'team'
          | 'team_add'
          | 'watch'
          | 'workflow_dispatch'
          | 'workflow_run'
        >;
        external_url: string | null;
        html_url: string;
        /**
         * Unique identifier of the GitHub app
         */
        id: number | null;
        /**
         * The name of the GitHub app
         */
        name: string;
        node_id: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        /**
         * The set of permissions for the GitHub app
         */
        permissions?: {
          actions?: 'read' | 'write';
          administration?: 'read' | 'write';
          checks?: 'read' | 'write';
          content_references?: 'read' | 'write';
          contents?: 'read' | 'write';
          deployments?: 'read' | 'write';
          discussions?: 'read' | 'write';
          emails?: 'read' | 'write';
          environments?: 'read' | 'write';
          issues?: 'read' | 'write';
          keys?: 'read' | 'write';
          members?: 'read' | 'write';
          metadata?: 'read' | 'write';
          organization_administration?: 'read' | 'write';
          organization_hooks?: 'read' | 'write';
          organization_packages?: 'read' | 'write';
          organization_plan?: 'read' | 'write';
          organization_projects?: 'read' | 'write';
          organization_secrets?: 'read' | 'write';
          organization_self_hosted_runners?: 'read' | 'write';
          organization_user_blocking?: 'read' | 'write';
          packages?: 'read' | 'write';
          pages?: 'read' | 'write';
          pull_requests?: 'read' | 'write';
          repository_hooks?: 'read' | 'write';
          repository_projects?: 'read' | 'write';
          secret_scanning_alerts?: 'read' | 'write';
          secrets?: 'read' | 'write';
          security_events?: 'read' | 'write';
          security_scanning_alert?: 'read' | 'write';
          single_file?: 'read' | 'write';
          statuses?: 'read' | 'write';
          team_discussions?: 'read' | 'write';
          vulnerability_alerts?: 'read' | 'write';
          workflows?: 'read' | 'write';
        };
        /**
         * The slug name of the GitHub app
         */
        slug?: string;
        updated_at: string | null;
      } | null;
      pull_request?: {
        diff_url?: string;
        html_url?: string;
        merged_at?: string | null;
        patch_url?: string;
        url?: string;
      };
      reactions: {
        '+1': number;
        '-1': number;
        confused: number;
        eyes: number;
        heart: number;
        hooray: number;
        laugh: number;
        rocket: number;
        total_count: number;
        url: string;
      };
      repository_url: string;
      /**
       * State of the issue; either 'open' or 'closed'
       */
      state?: 'open' | 'closed';
      state_reason?: string | null;
      timeline_url?: string;
      /**
       * Title of the issue
       */
      title: string;
      updated_at: string;
      /**
       * URL for the issue
       */
      url: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    } | null;
    /**
     * A git repository
     */
    old_repository: {
      /**
       * Whether to allow auto-merge for pull requests.
       */
      allow_auto_merge?: boolean;
      /**
       * Whether to allow private forks
       */
      allow_forking?: boolean;
      /**
       * Whether to allow merge commits for pull requests.
       */
      allow_merge_commit?: boolean;
      /**
       * Whether to allow rebase merges for pull requests.
       */
      allow_rebase_merge?: boolean;
      /**
       * Whether to allow squash merges for pull requests.
       */
      allow_squash_merge?: boolean;
      allow_update_branch?: boolean;
      archive_url: string;
      /**
       * Whether the repository is archived.
       */
      archived: boolean;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      clone_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      created_at: number | string;
      /**
       * The default branch of the repository.
       */
      default_branch: string;
      /**
       * Whether to delete head branches when pull requests are merged
       */
      delete_branch_on_merge?: boolean;
      deployments_url: string;
      description: string | null;
      /**
       * Returns whether or not this repository is disabled.
       */
      disabled?: boolean;
      downloads_url: string;
      events_url: string;
      fork: boolean;
      forks: number;
      forks_count: number;
      forks_url: string;
      full_name: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      /**
       * Whether downloads are enabled.
       */
      has_downloads: boolean;
      /**
       * Whether issues are enabled.
       */
      has_issues: boolean;
      has_pages: boolean;
      /**
       * Whether projects are enabled.
       */
      has_projects: boolean;
      /**
       * Whether the wiki is enabled.
       */
      has_wiki: boolean;
      homepage: string | null;
      hooks_url: string;
      html_url: string;
      /**
       * Unique identifier of the repository
       */
      id: number;
      is_template?: boolean;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      language: string | null;
      languages_url: string;
      license: {
        key: string;
        name: string;
        node_id: string;
        spdx_id: string;
        url: string | null;
      } | null;
      master_branch?: string;
      merges_url: string;
      milestones_url: string;
      mirror_url: string | null;
      /**
       * The name of the repository.
       */
      name: string;
      node_id: string;
      notifications_url: string;
      open_issues: number;
      open_issues_count: number;
      organization?: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        pull: boolean;
        push: boolean;
        triage?: boolean;
      };
      /**
       * Whether the repository is private or public.
       */
      private: boolean;
      public?: boolean;
      pulls_url: string;
      pushed_at: (number | string) | null;
      releases_url: string;
      role_name?: string | null;
      size: number;
      ssh_url: string;
      stargazers?: number;
      stargazers_count: number;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      svn_url: string;
      tags_url: string;
      teams_url: string;
      topics: Array<string>;
      trees_url: string;
      updated_at: string;
      url: string;
      visibility: 'public' | 'private' | 'internal';
      watchers: number;
      watchers_count: number;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'security_and_analysis'
        | 'pull_request_review_thread'
        | 'reminder'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type action35 = 'opened';

export type webhook_issues_pinned = {
  action: 'pinned';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_reopened = {
  action: 'reopened';
  enterprise?: enterprise;
  installation?: simple_installation;
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'pull_request_review_thread'
        | 'reminder'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write' | 'admin';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  } & {
    active_lock_reason?: string | null;
    assignee?: {
      [key: string]: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    body?: string | null;
    closed_at?: string | null;
    comments?: number;
    comments_url?: string;
    created_at?: string;
    events_url?: string;
    html_url?: string;
    id?: number;
    labels?: Array<{
      [key: string]: string;
    } | null>;
    labels_url?: string;
    locked?: boolean;
    milestone?: {
      [key: string]: string;
    } | null;
    node_id?: string;
    number?: number;
    performed_via_github_app?: {
      [key: string]: string;
    } | null;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    state: 'open' | 'closed';
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_transferred = {
  action: 'transferred';
  changes: {
    /**
     * The [issue](https://docs.github.com/rest/reference/issues) itself.
     */
    new_issue: {
      active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
      assignee?: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      assignees: Array<{
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null>;
      /**
       * How the author is associated with the repository.
       */
      author_association:
        | 'COLLABORATOR'
        | 'CONTRIBUTOR'
        | 'FIRST_TIMER'
        | 'FIRST_TIME_CONTRIBUTOR'
        | 'MANNEQUIN'
        | 'MEMBER'
        | 'NONE'
        | 'OWNER';
      /**
       * Contents of the issue
       */
      body: string | null;
      closed_at: string | null;
      comments: number;
      comments_url: string;
      created_at: string;
      draft?: boolean;
      events_url: string;
      html_url: string;
      id: number;
      labels?: Array<{
        /**
         * 6-character hex code, without the leading #, identifying the color
         */
        color: string;
        default: boolean;
        description: string | null;
        id: number;
        /**
         * The name of the label.
         */
        name: string;
        node_id: string;
        /**
         * URL for the label
         */
        url: string;
      }>;
      labels_url: string;
      locked?: boolean;
      /**
       * A collection of related issues and pull requests.
       */
      milestone: {
        closed_at: string | null;
        closed_issues: number;
        created_at: string;
        creator: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        description: string | null;
        due_on: string | null;
        html_url: string;
        id: number;
        labels_url: string;
        node_id: string;
        /**
         * The number of the milestone.
         */
        number: number;
        open_issues: number;
        /**
         * The state of the milestone.
         */
        state: 'open' | 'closed';
        /**
         * The title of the milestone.
         */
        title: string;
        updated_at: string;
        url: string;
      } | null;
      node_id: string;
      number: number;
      /**
       * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
       */
      performed_via_github_app?: {
        created_at: string | null;
        description: string | null;
        /**
         * The list of events for the GitHub app
         */
        events?: Array<
          | 'branch_protection_rule'
          | 'check_run'
          | 'check_suite'
          | 'code_scanning_alert'
          | 'commit_comment'
          | 'content_reference'
          | 'create'
          | 'delete'
          | 'deployment'
          | 'deployment_review'
          | 'deployment_status'
          | 'deploy_key'
          | 'discussion'
          | 'discussion_comment'
          | 'fork'
          | 'gollum'
          | 'issues'
          | 'issue_comment'
          | 'label'
          | 'member'
          | 'membership'
          | 'milestone'
          | 'organization'
          | 'org_block'
          | 'page_build'
          | 'project'
          | 'project_card'
          | 'project_column'
          | 'public'
          | 'pull_request'
          | 'pull_request_review'
          | 'pull_request_review_comment'
          | 'push'
          | 'registry_package'
          | 'release'
          | 'repository'
          | 'repository_dispatch'
          | 'secret_scanning_alert'
          | 'star'
          | 'status'
          | 'team'
          | 'team_add'
          | 'watch'
          | 'workflow_dispatch'
          | 'workflow_run'
        >;
        external_url: string | null;
        html_url: string;
        /**
         * Unique identifier of the GitHub app
         */
        id: number | null;
        /**
         * The name of the GitHub app
         */
        name: string;
        node_id: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        /**
         * The set of permissions for the GitHub app
         */
        permissions?: {
          actions?: 'read' | 'write';
          administration?: 'read' | 'write';
          checks?: 'read' | 'write';
          content_references?: 'read' | 'write';
          contents?: 'read' | 'write';
          deployments?: 'read' | 'write';
          discussions?: 'read' | 'write';
          emails?: 'read' | 'write';
          environments?: 'read' | 'write';
          issues?: 'read' | 'write';
          keys?: 'read' | 'write';
          members?: 'read' | 'write';
          metadata?: 'read' | 'write';
          organization_administration?: 'read' | 'write';
          organization_hooks?: 'read' | 'write';
          organization_packages?: 'read' | 'write';
          organization_plan?: 'read' | 'write';
          organization_projects?: 'read' | 'write';
          organization_secrets?: 'read' | 'write';
          organization_self_hosted_runners?: 'read' | 'write';
          organization_user_blocking?: 'read' | 'write';
          packages?: 'read' | 'write';
          pages?: 'read' | 'write';
          pull_requests?: 'read' | 'write';
          repository_hooks?: 'read' | 'write';
          repository_projects?: 'read' | 'write';
          secret_scanning_alerts?: 'read' | 'write';
          secrets?: 'read' | 'write';
          security_events?: 'read' | 'write';
          security_scanning_alert?: 'read' | 'write';
          single_file?: 'read' | 'write';
          statuses?: 'read' | 'write';
          team_discussions?: 'read' | 'write';
          vulnerability_alerts?: 'read' | 'write';
          workflows?: 'read' | 'write';
        };
        /**
         * The slug name of the GitHub app
         */
        slug?: string;
        updated_at: string | null;
      } | null;
      pull_request?: {
        diff_url?: string;
        html_url?: string;
        merged_at?: string | null;
        patch_url?: string;
        url?: string;
      };
      reactions: {
        '+1': number;
        '-1': number;
        confused: number;
        eyes: number;
        heart: number;
        hooray: number;
        laugh: number;
        rocket: number;
        total_count: number;
        url: string;
      };
      repository_url: string;
      /**
       * State of the issue; either 'open' or 'closed'
       */
      state?: 'open' | 'closed';
      state_reason?: string | null;
      timeline_url?: string;
      /**
       * Title of the issue
       */
      title: string;
      updated_at: string;
      /**
       * URL for the issue
       */
      url: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    /**
     * A git repository
     */
    new_repository: {
      /**
       * Whether to allow auto-merge for pull requests.
       */
      allow_auto_merge?: boolean;
      /**
       * Whether to allow private forks
       */
      allow_forking?: boolean;
      /**
       * Whether to allow merge commits for pull requests.
       */
      allow_merge_commit?: boolean;
      /**
       * Whether to allow rebase merges for pull requests.
       */
      allow_rebase_merge?: boolean;
      /**
       * Whether to allow squash merges for pull requests.
       */
      allow_squash_merge?: boolean;
      allow_update_branch?: boolean;
      archive_url: string;
      /**
       * Whether the repository is archived.
       */
      archived: boolean;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      clone_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      created_at: number | string;
      /**
       * The default branch of the repository.
       */
      default_branch: string;
      /**
       * Whether to delete head branches when pull requests are merged
       */
      delete_branch_on_merge?: boolean;
      deployments_url: string;
      description: string | null;
      /**
       * Returns whether or not this repository is disabled.
       */
      disabled?: boolean;
      downloads_url: string;
      events_url: string;
      fork: boolean;
      forks: number;
      forks_count: number;
      forks_url: string;
      full_name: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      /**
       * Whether discussions are enabled.
       */
      has_discussions: boolean;
      /**
       * Whether downloads are enabled.
       */
      has_downloads: boolean;
      /**
       * Whether issues are enabled.
       */
      has_issues: boolean;
      has_pages: boolean;
      /**
       * Whether projects are enabled.
       */
      has_projects: boolean;
      /**
       * Whether the wiki is enabled.
       */
      has_wiki: boolean;
      homepage: string | null;
      hooks_url: string;
      html_url: string;
      /**
       * Unique identifier of the repository
       */
      id: number;
      is_template?: boolean;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      language: string | null;
      languages_url: string;
      license: {
        key: string;
        name: string;
        node_id: string;
        spdx_id: string;
        url: string | null;
      } | null;
      master_branch?: string;
      merges_url: string;
      milestones_url: string;
      mirror_url: string | null;
      /**
       * The name of the repository.
       */
      name: string;
      node_id: string;
      notifications_url: string;
      open_issues: number;
      open_issues_count: number;
      organization?: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      permissions?: {
        admin: boolean;
        maintain?: boolean;
        pull: boolean;
        push: boolean;
        triage?: boolean;
      };
      /**
       * Whether the repository is private or public.
       */
      private: boolean;
      public?: boolean;
      pulls_url: string;
      pushed_at: (number | string) | null;
      releases_url: string;
      role_name?: string | null;
      size: number;
      ssh_url: string;
      stargazers?: number;
      stargazers_count: number;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      svn_url: string;
      tags_url: string;
      teams_url: string;
      topics: Array<string>;
      trees_url: string;
      updated_at: string;
      url: string;
      visibility: 'public' | 'private' | 'internal';
      watchers: number;
      watchers_count: number;
      /**
       * Whether to require contributors to sign off on web-based commits
       */
      web_commit_signoff_required?: boolean;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_unassigned = {
  /**
   * The action that was performed.
   */
  action: 'unassigned';
  assignee?: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
    url?: string;
  } | null;
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'reminder'
        | 'pull_request_review_thread'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

/**
 * The action that was performed.
 */
export type action36 = 'unassigned';

export type webhook_issues_unlabeled = {
  action: 'unlabeled';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
        | 'reminder'
        | 'pull_request_review_thread'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write' | 'admin';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  label?: {
    /**
     * 6-character hex code, without the leading #, identifying the color
     */
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    /**
     * The name of the label.
     */
    name: string;
    node_id: string;
    /**
     * URL for the label
     */
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_unlocked = {
  action: 'unlocked';
  enterprise?: enterprise;
  installation?: simple_installation;
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  } & {
    active_lock_reason: string;
    assignee?: {
      [key: string]: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    body?: string | null;
    closed_at?: string | null;
    comments?: number;
    comments_url?: string;
    created_at?: string;
    events_url?: string;
    html_url?: string;
    id?: number;
    labels?: Array<{
      [key: string]: string;
    } | null>;
    labels_url?: string;
    locked: boolean;
    milestone?: {
      [key: string]: string;
    } | null;
    node_id?: string;
    number?: number;
    performed_via_github_app?: string;
    reactions?: {
      '+1'?: number;
      '-1'?: number;
      confused?: number;
      eyes?: number;
      heart?: number;
      hooray?: number;
      laugh?: number;
      rocket?: number;
      total_count?: number;
      url?: string;
    };
    repository_url?: string;
    state?: string;
    timeline_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_issues_unpinned = {
  action: 'unpinned';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The [issue](https://docs.github.com/rest/reference/issues) itself.
   */
  issue: {
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    assignee?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * Contents of the issue
     */
    body: string | null;
    closed_at: string | null;
    comments: number;
    comments_url: string;
    created_at: string;
    draft?: boolean;
    events_url: string;
    html_url: string;
    id: number;
    labels?: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    labels_url: string;
    locked?: boolean;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    number: number;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    performed_via_github_app?: {
      created_at: string | null;
      description: string | null;
      /**
       * The list of events for the GitHub app
       */
      events?: Array<
        | 'branch_protection_rule'
        | 'check_run'
        | 'check_suite'
        | 'code_scanning_alert'
        | 'commit_comment'
        | 'content_reference'
        | 'create'
        | 'delete'
        | 'deployment'
        | 'deployment_review'
        | 'deployment_status'
        | 'deploy_key'
        | 'discussion'
        | 'discussion_comment'
        | 'fork'
        | 'gollum'
        | 'issues'
        | 'issue_comment'
        | 'label'
        | 'member'
        | 'membership'
        | 'milestone'
        | 'organization'
        | 'org_block'
        | 'page_build'
        | 'project'
        | 'project_card'
        | 'project_column'
        | 'public'
        | 'pull_request'
        | 'pull_request_review'
        | 'pull_request_review_comment'
        | 'push'
        | 'registry_package'
        | 'release'
        | 'repository'
        | 'repository_dispatch'
        | 'secret_scanning_alert'
        | 'star'
        | 'status'
        | 'team'
        | 'team_add'
        | 'watch'
        | 'workflow_dispatch'
        | 'workflow_run'
      >;
      external_url: string | null;
      html_url: string;
      /**
       * Unique identifier of the GitHub app
       */
      id: number | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      node_id: string;
      owner: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The set of permissions for the GitHub app
       */
      permissions?: {
        actions?: 'read' | 'write';
        administration?: 'read' | 'write';
        checks?: 'read' | 'write';
        content_references?: 'read' | 'write';
        contents?: 'read' | 'write';
        deployments?: 'read' | 'write';
        discussions?: 'read' | 'write';
        emails?: 'read' | 'write';
        environments?: 'read' | 'write';
        issues?: 'read' | 'write';
        keys?: 'read' | 'write';
        members?: 'read' | 'write';
        metadata?: 'read' | 'write';
        organization_administration?: 'read' | 'write';
        organization_hooks?: 'read' | 'write';
        organization_packages?: 'read' | 'write';
        organization_plan?: 'read' | 'write';
        organization_projects?: 'read' | 'write';
        organization_secrets?: 'read' | 'write';
        organization_self_hosted_runners?: 'read' | 'write';
        organization_user_blocking?: 'read' | 'write';
        packages?: 'read' | 'write';
        pages?: 'read' | 'write';
        pull_requests?: 'read' | 'write';
        repository_hooks?: 'read' | 'write';
        repository_projects?: 'read' | 'write';
        secret_scanning_alerts?: 'read' | 'write';
        secrets?: 'read' | 'write';
        security_events?: 'read' | 'write';
        security_scanning_alert?: 'read' | 'write';
        single_file?: 'read' | 'write';
        statuses?: 'read' | 'write';
        team_discussions?: 'read' | 'write';
        vulnerability_alerts?: 'read' | 'write';
        workflows?: 'read' | 'write';
      };
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      updated_at: string | null;
    } | null;
    pull_request?: {
      diff_url?: string;
      html_url?: string;
      merged_at?: string | null;
      patch_url?: string;
      url?: string;
    };
    reactions: {
      '+1': number;
      '-1': number;
      confused: number;
      eyes: number;
      heart: number;
      hooray: number;
      laugh: number;
      rocket: number;
      total_count: number;
      url: string;
    };
    repository_url: string;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state?: 'open' | 'closed';
    state_reason?: string | null;
    timeline_url?: string;
    /**
     * Title of the issue
     */
    title: string;
    updated_at: string;
    /**
     * URL for the issue
     */
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_label_created = {
  action: 'created';
  enterprise?: enterprise;
  installation?: simple_installation;
  label: {
    /**
     * 6-character hex code, without the leading #, identifying the color
     */
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    /**
     * The name of the label.
     */
    name: string;
    node_id: string;
    /**
     * URL for the label
     */
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender?: simple_user;
};

export type webhook_label_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation?: simple_installation;
  label: {
    /**
     * 6-character hex code, without the leading #, identifying the color
     */
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    /**
     * The name of the label.
     */
    name: string;
    node_id: string;
    /**
     * URL for the label
     */
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_label_edited = {
  action: 'edited';
  /**
   * The changes to the label if the action was `edited`.
   */
  changes?: {
    color?: {
      /**
       * The previous version of the color if the action was `edited`.
       */
      from: string;
    };
    description?: {
      /**
       * The previous version of the description if the action was `edited`.
       */
      from: string;
    };
    name?: {
      /**
       * The previous version of the name if the action was `edited`.
       */
      from: string;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  label: {
    /**
     * 6-character hex code, without the leading #, identifying the color
     */
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    /**
     * The name of the label.
     */
    name: string;
    node_id: string;
    /**
     * URL for the label
     */
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_marketplace_purchase_cancelled = {
  action: 'cancelled';
  effective_date: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  marketplace_purchase: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string | null;
    next_billing_date?: string | null;
    on_free_trial: boolean;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  } & {
    account?: {
      id?: number;
      login?: string;
      node_id?: string;
      organization_billing_email?: string | null;
      type?: string;
    };
    billing_cycle?: string;
    free_trial_ends_on?: string | null;
    next_billing_date: string | null;
    on_free_trial?: boolean;
    plan?: {
      bullets?: Array<string | null>;
      description?: string;
      has_free_trial?: boolean;
      id?: number;
      monthly_price_in_cents?: number;
      name?: string;
      price_model?: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name?: string | null;
      yearly_price_in_cents?: number;
    };
    unit_count?: number;
  };
  organization?: organization_simple;
  previous_marketplace_purchase?: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date?: string | null;
    on_free_trial: boolean;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  };
  repository?: repository;
  sender: simple_user;
};

export type action37 = 'cancelled';

export type webhook_marketplace_purchase_changed = {
  action: 'changed';
  effective_date: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  marketplace_purchase: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string | null;
    next_billing_date?: string | null;
    on_free_trial: boolean;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  } & {
    account?: {
      id?: number;
      login?: string;
      node_id?: string;
      organization_billing_email?: string | null;
      type?: string;
    };
    billing_cycle?: string;
    free_trial_ends_on?: string | null;
    next_billing_date: string | null;
    on_free_trial?: boolean;
    plan?: {
      bullets?: Array<string | null>;
      description?: string;
      has_free_trial?: boolean;
      id?: number;
      monthly_price_in_cents?: number;
      name?: string;
      price_model?: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name?: string | null;
      yearly_price_in_cents?: number;
    };
    unit_count?: number;
  };
  organization?: organization_simple;
  previous_marketplace_purchase?: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string | null;
    next_billing_date?: string | null;
    on_free_trial: boolean | null;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  };
  repository?: repository;
  sender: simple_user;
};

export type action38 = 'changed';

export type webhook_marketplace_purchase_pending_change = {
  action: 'pending_change';
  effective_date: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  marketplace_purchase: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string | null;
    next_billing_date?: string | null;
    on_free_trial: boolean;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  } & {
    account?: {
      id?: number;
      login?: string;
      node_id?: string;
      organization_billing_email?: string | null;
      type?: string;
    };
    billing_cycle?: string;
    free_trial_ends_on?: string | null;
    next_billing_date: string | null;
    on_free_trial?: boolean;
    plan?: {
      bullets?: Array<string | null>;
      description?: string;
      has_free_trial?: boolean;
      id?: number;
      monthly_price_in_cents?: number;
      name?: string;
      price_model?: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name?: string | null;
      yearly_price_in_cents?: number;
    };
    unit_count?: number;
  };
  organization?: organization_simple;
  previous_marketplace_purchase?: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string | null;
    next_billing_date?: string | null;
    on_free_trial: boolean;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  };
  repository?: repository;
  sender: simple_user;
};

export type action39 = 'pending_change';

export type webhook_marketplace_purchase_pending_change_cancelled = {
  action: 'pending_change_cancelled';
  effective_date: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  marketplace_purchase: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date?: string | null;
    on_free_trial: boolean;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  } & {
    next_billing_date: string;
  };
  organization?: organization_simple;
  previous_marketplace_purchase?: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date?: string | null;
    on_free_trial: boolean;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  };
  repository?: repository;
  sender: simple_user;
};

export type action40 = 'pending_change_cancelled';

export type webhook_marketplace_purchase_purchased = {
  action: 'purchased';
  effective_date: string;
  enterprise?: enterprise;
  installation?: simple_installation;
  marketplace_purchase: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string | null;
    next_billing_date?: string | null;
    on_free_trial: boolean;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  } & {
    account?: {
      id?: number;
      login?: string;
      node_id?: string;
      organization_billing_email?: string | null;
      type?: string;
    };
    billing_cycle?: string;
    free_trial_ends_on?: string | null;
    next_billing_date: string | null;
    on_free_trial?: boolean;
    plan?: {
      bullets?: Array<string | null>;
      description?: string;
      has_free_trial?: boolean;
      id?: number;
      monthly_price_in_cents?: number;
      name?: string;
      price_model?: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name?: string | null;
      yearly_price_in_cents?: number;
    };
    unit_count?: number;
  };
  organization?: organization_simple;
  previous_marketplace_purchase?: {
    account: {
      id: number;
      login: string;
      node_id: string;
      organization_billing_email: string | null;
      type: string;
    };
    billing_cycle: string;
    free_trial_ends_on: string;
    next_billing_date?: string | null;
    on_free_trial: boolean;
    plan: {
      bullets: Array<string>;
      description: string;
      has_free_trial: boolean;
      id: number;
      monthly_price_in_cents: number;
      name: string;
      price_model: 'FREE' | 'FLAT_RATE' | 'PER_UNIT';
      unit_name: string | null;
      yearly_price_in_cents: number;
    };
    unit_count: number;
  };
  repository?: repository;
  sender: simple_user;
};

export type action41 = 'purchased';

export type webhook_member_added = {
  action: 'added';
  changes?: {
    permission?: {
      to: 'write' | 'admin' | 'read';
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  member: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type to = 'write' | 'admin' | 'read';

export type webhook_member_edited = {
  action: 'edited';
  /**
   * The changes to the collaborator permissions
   */
  changes: {
    old_permission?: {
      /**
       * The previous permissions of the collaborator if the action was edited.
       */
      from: string;
    };
    permission?: {
      from?: string | null;
      to?: string | null;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  member: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_member_removed = {
  action: 'removed';
  enterprise?: enterprise;
  installation?: simple_installation;
  member: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_membership_added = {
  action: 'added';
  enterprise?: enterprise;
  installation?: simple_installation;
  member: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  organization: organization_simple;
  repository?: repository;
  /**
   * The scope of the membership. Currently, can only be `team`.
   */
  scope: 'team';
  sender: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  /**
   * Groups of organization members that gives permissions on specified repositories.
   */
  team: {
    deleted?: boolean;
    /**
     * Description of the team
     */
    description?: string | null;
    html_url?: string;
    /**
     * Unique identifier of the team
     */
    id: number;
    members_url?: string;
    /**
     * Name of the team
     */
    name: string;
    node_id?: string;
    parent?: {
      /**
       * Description of the team
       */
      description: string | null;
      html_url: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url: string;
      /**
       * Name of the team
       */
      name: string;
      node_id: string;
      /**
       * Permission that the team will have for its repositories
       */
      permission: string;
      privacy: 'open' | 'closed' | 'secret';
      repositories_url: string;
      slug: string;
      /**
       * URL for the team
       */
      url: string;
    } | null;
    /**
     * Permission that the team will have for its repositories
     */
    permission?: string;
    privacy?: 'open' | 'closed' | 'secret';
    repositories_url?: string;
    slug?: string;
    /**
     * URL for the team
     */
    url?: string;
  };
};

/**
 * The scope of the membership. Currently, can only be `team`.
 */
export type scope3 = 'team';

export type privacy2 = 'open' | 'closed' | 'secret';

export type webhook_membership_removed = {
  action: 'removed';
  enterprise?: enterprise;
  installation?: simple_installation;
  member: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  organization: organization_simple;
  repository?: repository;
  /**
   * The scope of the membership. Currently, can only be `team`.
   */
  scope: 'team' | 'organization';
  sender: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  /**
   * Groups of organization members that gives permissions on specified repositories.
   */
  team: {
    deleted?: boolean;
    /**
     * Description of the team
     */
    description?: string | null;
    html_url?: string;
    /**
     * Unique identifier of the team
     */
    id: number;
    members_url?: string;
    /**
     * Name of the team
     */
    name: string;
    node_id?: string;
    parent?: {
      /**
       * Description of the team
       */
      description: string | null;
      html_url: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url: string;
      /**
       * Name of the team
       */
      name: string;
      node_id: string;
      /**
       * Permission that the team will have for its repositories
       */
      permission: string;
      privacy: 'open' | 'closed' | 'secret';
      repositories_url: string;
      slug: string;
      /**
       * URL for the team
       */
      url: string;
    } | null;
    /**
     * Permission that the team will have for its repositories
     */
    permission?: string;
    privacy?: 'open' | 'closed' | 'secret';
    repositories_url?: string;
    slug?: string;
    /**
     * URL for the team
     */
    url?: string;
  };
};

/**
 * The scope of the membership. Currently, can only be `team`.
 */
export type scope4 = 'team' | 'organization';

export type webhook_merge_group_checks_requested = {
  action: string;
  installation?: simple_installation;
  merge_group: {
    /**
     * The full ref of the branch the merge group will be merged into.
     */
    base_ref: string;
    /**
     * The SHA of the merge group's parent commit.
     */
    base_sha: string;
    head_commit: {
      /**
       * Metaproperties for Git author/committer information.
       */
      author: {
        date?: string;
        email: string | null;
        /**
         * The git author's name.
         */
        name: string;
        username?: string;
      };
      /**
       * Metaproperties for Git author/committer information.
       */
      committer: {
        date?: string;
        email: string | null;
        /**
         * The git author's name.
         */
        name: string;
        username?: string;
      };
      id: string;
      message: string;
      timestamp: string;
      tree_id: string;
    };
    /**
     * The full ref of the merge group.
     */
    head_ref: string;
    /**
     * The SHA of the merge group.
     */
    head_sha: string;
  };
  organization?: organization_simple;
  repository?: repository;
  sender?: simple_user;
};

export type webhook_meta_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  /**
   * The modified webhook. This will contain different keys based on the type of webhook it is: repository, organization, business, app, or GitHub Marketplace.
   */
  hook: {
    active: boolean;
    config: {
      content_type: 'json' | 'form';
      insecure_ssl: string;
      secret?: string;
      url: string;
    };
    created_at: string;
    events: Array<
      | '*'
      | 'branch_protection_rule'
      | 'check_run'
      | 'check_suite'
      | 'code_scanning_alert'
      | 'commit_comment'
      | 'create'
      | 'delete'
      | 'deployment'
      | 'deployment_status'
      | 'deploy_key'
      | 'discussion'
      | 'discussion_comment'
      | 'fork'
      | 'gollum'
      | 'issues'
      | 'issue_comment'
      | 'label'
      | 'member'
      | 'membership'
      | 'meta'
      | 'milestone'
      | 'organization'
      | 'org_block'
      | 'package'
      | 'page_build'
      | 'project'
      | 'project_card'
      | 'project_column'
      | 'public'
      | 'pull_request'
      | 'pull_request_review'
      | 'pull_request_review_comment'
      | 'pull_request_review_thread'
      | 'push'
      | 'registry_package'
      | 'release'
      | 'repository'
      | 'repository_import'
      | 'repository_vulnerability_alert'
      | 'secret_scanning_alert'
      | 'secret_scanning_alert_location'
      | 'security_and_analysis'
      | 'star'
      | 'status'
      | 'team'
      | 'team_add'
      | 'watch'
      | 'workflow_job'
      | 'workflow_run'
      | 'repository_dispatch'
      | 'projects_v2_item'
    >;
    id: number;
    name: string;
    type: string;
    updated_at: string;
  };
  /**
   * The id of the modified webhook.
   */
  hook_id: number;
  installation?: simple_installation;
  organization?: organization_simple;
  repository?: nullable_repository;
  sender?: simple_user;
};

export type content_type = 'json' | 'form';

export type webhook_milestone_closed = {
  action: 'closed';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * A collection of related issues and pull requests.
   */
  milestone: {
    closed_at: string | null;
    closed_issues: number;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    description: string | null;
    due_on: string | null;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    /**
     * The number of the milestone.
     */
    number: number;
    open_issues: number;
    /**
     * The state of the milestone.
     */
    state: 'open' | 'closed';
    /**
     * The title of the milestone.
     */
    title: string;
    updated_at: string;
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_milestone_created = {
  action: 'created';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * A collection of related issues and pull requests.
   */
  milestone: {
    closed_at: string | null;
    closed_issues: number;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    description: string | null;
    due_on: string | null;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    /**
     * The number of the milestone.
     */
    number: number;
    open_issues: number;
    /**
     * The state of the milestone.
     */
    state: 'open' | 'closed';
    /**
     * The title of the milestone.
     */
    title: string;
    updated_at: string;
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_milestone_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * A collection of related issues and pull requests.
   */
  milestone: {
    closed_at: string | null;
    closed_issues: number;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    description: string | null;
    due_on: string | null;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    /**
     * The number of the milestone.
     */
    number: number;
    open_issues: number;
    /**
     * The state of the milestone.
     */
    state: 'open' | 'closed';
    /**
     * The title of the milestone.
     */
    title: string;
    updated_at: string;
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_milestone_edited = {
  action: 'edited';
  /**
   * The changes to the milestone if the action was `edited`.
   */
  changes: {
    description?: {
      /**
       * The previous version of the description if the action was `edited`.
       */
      from: string;
    };
    due_on?: {
      /**
       * The previous version of the due date if the action was `edited`.
       */
      from: string;
    };
    title?: {
      /**
       * The previous version of the title if the action was `edited`.
       */
      from: string;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * A collection of related issues and pull requests.
   */
  milestone: {
    closed_at: string | null;
    closed_issues: number;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    description: string | null;
    due_on: string | null;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    /**
     * The number of the milestone.
     */
    number: number;
    open_issues: number;
    /**
     * The state of the milestone.
     */
    state: 'open' | 'closed';
    /**
     * The title of the milestone.
     */
    title: string;
    updated_at: string;
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_milestone_opened = {
  action: 'opened';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * A collection of related issues and pull requests.
   */
  milestone: {
    closed_at: string | null;
    closed_issues: number;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    description: string | null;
    due_on: string | null;
    html_url: string;
    id: number;
    labels_url: string;
    node_id: string;
    /**
     * The number of the milestone.
     */
    number: number;
    open_issues: number;
    /**
     * The state of the milestone.
     */
    state: 'open' | 'closed';
    /**
     * The title of the milestone.
     */
    title: string;
    updated_at: string;
    url: string;
  };
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_org_block_blocked = {
  action: 'blocked';
  blocked_user: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization: organization_simple;
  repository?: repository;
  sender: simple_user;
};

export type action42 = 'blocked';

export type webhook_org_block_unblocked = {
  action: 'unblocked';
  blocked_user: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  enterprise?: enterprise;
  installation?: simple_installation;
  organization: organization_simple;
  repository?: repository;
  sender: simple_user;
};

export type action43 = 'unblocked';

export type webhook_organization_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The membership between the user and the organization. Not present when the action is `member_invited`.
   */
  membership?: {
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization: organization_simple;
  repository?: repository;
  sender: simple_user;
};

export type webhook_organization_member_added = {
  action: 'member_added';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The membership between the user and the organization. Not present when the action is `member_invited`.
   */
  membership: {
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization: organization_simple;
  repository?: repository;
  sender: simple_user;
};

export type action44 = 'member_added';

export type webhook_organization_member_invited = {
  action: 'member_invited';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The invitation for the user or email if the action is `member_invited`.
   */
  invitation: {
    created_at: string;
    email: string | null;
    failed_at: string | null;
    failed_reason: string | null;
    id: number;
    invitation_source?: string;
    invitation_teams_url: string;
    inviter: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    login: string | null;
    node_id: string;
    role: string;
    team_count: number;
  };
  organization: organization_simple;
  repository?: repository;
  sender: simple_user;
  user?: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
};

export type action45 = 'member_invited';

export type webhook_organization_member_removed = {
  action: 'member_removed';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The membership between the user and the organization. Not present when the action is `member_invited`.
   */
  membership: {
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization: organization_simple;
  repository?: repository;
  sender: simple_user;
};

export type action46 = 'member_removed';

export type webhook_organization_renamed = {
  action: 'renamed';
  changes?: {
    login?: {
      from?: string;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The membership between the user and the organization. Not present when the action is `member_invited`.
   */
  membership?: {
    organization_url: string;
    role: string;
    state: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
  };
  organization: organization_simple;
  repository?: repository;
  sender: simple_user;
};

export type action47 = 'renamed';

export type webhook_package_published = {
  action: 'published';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * Information about the package.
   */
  package: {
    created_at: string | null;
    description: string | null;
    ecosystem: string;
    html_url: string;
    id: number;
    name: string;
    namespace: string;
    owner: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    package_type: string;
    package_version: {
      author?: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      body?:
        | string
        | {
            [key: string]: string;
          };
      body_html?: string;
      container_metadata?: {
        labels?: {
          [key: string]: string;
        } | null;
        manifest?: {
          [key: string]: string;
        } | null;
        tag?: {
          digest?: string;
          name?: string;
        };
      } | null;
      created_at?: string;
      description: string;
      docker_metadata?: Array<string>;
      draft?: boolean;
      html_url: string;
      id: number;
      installation_command: string;
      manifest?: string;
      metadata: Array<{
        [key: string]: string;
      }>;
      name: string;
      npm_metadata?: {
        author?: {
          [key: string]: string;
        } | null;
        bin?: {
          [key: string]: string;
        };
        bugs?: {
          [key: string]: string;
        } | null;
        commit_oid?: string;
        contributors?: Array<{
          [key: string]: string;
        }>;
        cpu?: Array<string>;
        deleted_by_id?: number;
        dependencies?: {
          [key: string]: string;
        };
        description?: string;
        dev_dependencies?: {
          [key: string]: string;
        };
        directories?: {
          [key: string]: string;
        } | null;
        dist?: {
          [key: string]: string;
        } | null;
        engines?: {
          [key: string]: string;
        };
        files?: Array<string>;
        git_head?: string;
        has_shrinkwrap?: boolean;
        homepage?: string;
        id?: string;
        installation_command?: string;
        keywords?: Array<string>;
        license?: string;
        main?: string;
        maintainers?: Array<{
          [key: string]: string;
        }>;
        man?: {
          [key: string]: string;
        };
        name?: string;
        node_version?: string;
        npm_user?: string;
        npm_version?: string;
        optional_dependencies?: {
          [key: string]: string;
        };
        os?: Array<string>;
        peer_dependencies?: {
          [key: string]: string;
        };
        published_via_actions?: boolean;
        readme?: string;
        release_id?: number;
        repository?: {
          [key: string]: string;
        } | null;
        scripts?: {
          [key: string]: string;
        };
        version?: string;
      } | null;
      nuget_metadata?: Array<{
        id?: number | string;
        name?: string;
        value?:
          | boolean
          | string
          | number
          | {
              branch?: string;
              commit?: string;
              type?: string;
              url?: string;
            };
      }> | null;
      package_files: Array<{
        content_type: string;
        created_at: string;
        download_url: string;
        id: number;
        md5: string | null;
        name: string;
        sha1: string | null;
        sha256: string | null;
        size: number;
        state: string | null;
        updated_at: string;
      }>;
      package_url?: string;
      prerelease?: boolean;
      release?: {
        author: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        created_at: string;
        draft: boolean;
        html_url: string;
        id: number;
        name: string | null;
        prerelease: boolean;
        published_at: string;
        tag_name: string;
        target_commitish: string;
        url: string;
      };
      rubygems_metadata?: Array<string>;
      source_url?: string;
      summary: string;
      tag_name?: string;
      target_commitish?: string;
      target_oid?: string;
      updated_at?: string;
      version: string;
    } | null;
    registry: {
      about_url: string;
      name: string;
      type: string;
      url: string;
      vendor: string;
    } | null;
    updated_at: string | null;
  };
  repository?: repository;
  sender: simple_user;
};

export type action48 = 'published';

export type webhook_package_updated = {
  action: 'updated';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  /**
   * Information about the package.
   */
  package: {
    created_at: string;
    description: string | null;
    ecosystem: string;
    html_url: string;
    id: number;
    name: string;
    namespace: string;
    owner: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    package_type: string;
    package_version: {
      author: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      body: string;
      body_html: string;
      created_at: string;
      description: string;
      docker_metadata?: Array<string>;
      draft?: boolean;
      html_url: string;
      id: number;
      installation_command: string;
      manifest?: string;
      metadata: Array<string>;
      name: string;
      package_files: Array<{
        content_type: string;
        created_at: string;
        download_url: string;
        id: number;
        md5: string | null;
        name: string;
        sha1: string | null;
        sha256: string;
        size: number;
        state: string;
        updated_at: string;
      }>;
      package_url?: string;
      prerelease?: boolean;
      release?: {
        author: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        created_at: string;
        draft: boolean;
        html_url: string;
        id: number;
        name: string;
        prerelease: boolean;
        published_at: string;
        tag_name: string;
        target_commitish: string;
        url: string;
      };
      rubygems_metadata?: Array<string>;
      source_url?: string;
      summary: string;
      tag_name?: string;
      target_commitish: string;
      target_oid: string;
      updated_at: string;
      version: string;
    };
    registry: {
      about_url: string;
      name: string;
      type: string;
      url: string;
      vendor: string;
    } | null;
    updated_at: string;
  };
  repository: repository;
  sender: simple_user;
};

export type action49 = 'updated';

export type webhook_page_build = {
  /**
   * The [List GitHub Pages builds](https://docs.github.com/rest/reference/repos#list-github-pages-builds) itself.
   */
  build: {
    commit: string | null;
    created_at: string;
    duration: number;
    error: {
      message: string | null;
    };
    pusher: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    status: string;
    updated_at: string;
    url: string;
  };
  enterprise?: enterprise;
  id: number;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_ping = {
  /**
   * The webhook that is being pinged
   */
  hook?: {
    /**
     * Determines whether the hook is actually triggered for the events it subscribes to.
     */
    active: boolean;
    /**
     * Only included for GitHub Apps. When you register a new GitHub App, GitHub sends a ping event to the webhook URL you specified during registration. The GitHub App ID sent in this field is required for authenticating an app.
     */
    app_id?: number;
    config: {
      content_type?: webhook_config_content_type;
      insecure_ssl?: webhook_config_insecure_ssl;
      secret?: webhook_config_secret;
      url?: webhook_config_url;
    };
    created_at: string;
    deliveries_url?: string;
    /**
     * Determines what events the hook is triggered for. Default: ['push'].
     */
    events: Array<string>;
    /**
     * Unique identifier of the webhook.
     */
    id: number;
    last_response?: hook_response;
    /**
     * The type of webhook. The only valid value is 'web'.
     */
    name: 'web';
    ping_url?: string;
    test_url?: string;
    type: string;
    updated_at: string;
    url?: string;
  };
  /**
   * The ID of the webhook that triggered the ping.
   */
  hook_id?: number;
  organization?: organization_simple;
  repository?: repository;
  sender?: simple_user;
  /**
   * Random string of GitHub zen.
   */
  zen?: string;
};

/**
 * The type of webhook. The only valid value is 'web'.
 */
export type name = 'web';

/**
 * The webhooks ping payload encoded with URL encoding.
 */
export type webhook_ping_form_encoded = {
  /**
   * A URL-encoded string of the ping JSON payload. The decoded payload is a JSON object.
   */
  payload: string;
};

export type webhook_project_card_converted = {
  action: 'converted';
  changes: {
    note: {
      from: string;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project_card: {
    after_id?: number | null;
    /**
     * Whether or not the card is archived
     */
    archived: boolean;
    column_id: number;
    column_url: string;
    content_url?: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * The project card's ID
     */
    id: number;
    node_id: string;
    note: string | null;
    project_url: string;
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender: simple_user;
};

export type action50 = 'converted';

export type webhook_project_card_created = {
  action: 'created';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project_card: {
    after_id?: number | null;
    /**
     * Whether or not the card is archived
     */
    archived: boolean;
    column_id: number;
    column_url: string;
    content_url?: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * The project card's ID
     */
    id: number;
    node_id: string;
    note: string | null;
    project_url: string;
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender: simple_user;
};

export type webhook_project_card_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project_card: {
    after_id?: number | null;
    /**
     * Whether or not the card is archived
     */
    archived: boolean;
    column_id: number | null;
    column_url: string;
    content_url?: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    /**
     * The project card's ID
     */
    id: number;
    node_id: string;
    note: string | null;
    project_url: string;
    updated_at: string;
    url: string;
  };
  repository?: nullable_repository;
  sender: simple_user;
};

export type webhook_project_card_edited = {
  action: 'edited';
  changes: {
    note: {
      from: string | null;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project_card: {
    after_id?: number | null;
    /**
     * Whether or not the card is archived
     */
    archived: boolean;
    column_id: number;
    column_url: string;
    content_url?: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * The project card's ID
     */
    id: number;
    node_id: string;
    note: string | null;
    project_url: string;
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender: simple_user;
};

export type webhook_project_card_moved = {
  action: 'moved';
  changes?: {
    column_id: {
      from: number;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project_card: {
    after_id?: number | null;
    /**
     * Whether or not the card is archived
     */
    archived: boolean;
    column_id: number;
    column_url: string;
    content_url?: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    /**
     * The project card's ID
     */
    id: number;
    node_id: string;
    note: string | null;
    project_url: string;
    updated_at: string;
    url: string;
  } & {
    after_id: number | null;
    archived?: boolean;
    column_id?: number;
    column_url?: string;
    created_at?: string;
    creator?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    } | null;
    id?: number;
    node_id?: string;
    note?: string | null;
    project_url?: string;
    updated_at?: string;
    url?: string;
  };
  repository?: repository;
  sender: simple_user;
};

export type action51 = 'moved';

export type webhook_project_closed = {
  action: 'closed';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project: {
    /**
     * Body of the project
     */
    body: string | null;
    columns_url: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    html_url: string;
    id: number;
    /**
     * Name of the project
     */
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    /**
     * State of the project; either 'open' or 'closed'
     */
    state: 'open' | 'closed';
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender: simple_user;
};

export type webhook_project_column_created = {
  action: 'created';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project_column: {
    after_id?: number | null;
    cards_url: string;
    created_at: string;
    /**
     * The unique identifier of the project column
     */
    id: number;
    /**
     * Name of the project column
     */
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender?: simple_user;
};

export type webhook_project_column_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project_column: {
    after_id?: number | null;
    cards_url: string;
    created_at: string;
    /**
     * The unique identifier of the project column
     */
    id: number;
    /**
     * Name of the project column
     */
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  repository?: nullable_repository;
  sender?: simple_user;
};

export type webhook_project_column_edited = {
  action: 'edited';
  changes: {
    name?: {
      from: string;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project_column: {
    after_id?: number | null;
    cards_url: string;
    created_at: string;
    /**
     * The unique identifier of the project column
     */
    id: number;
    /**
     * Name of the project column
     */
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender?: simple_user;
};

export type webhook_project_column_moved = {
  action: 'moved';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project_column: {
    after_id?: number | null;
    cards_url: string;
    created_at: string;
    /**
     * The unique identifier of the project column
     */
    id: number;
    /**
     * Name of the project column
     */
    name: string;
    node_id: string;
    project_url: string;
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender: simple_user;
};

export type webhook_project_created = {
  action: 'created';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project: {
    /**
     * Body of the project
     */
    body: string | null;
    columns_url: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    html_url: string;
    id: number;
    /**
     * Name of the project
     */
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    /**
     * State of the project; either 'open' or 'closed'
     */
    state: 'open' | 'closed';
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender: simple_user;
};

export type webhook_project_deleted = {
  action: 'deleted';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project: {
    /**
     * Body of the project
     */
    body: string | null;
    columns_url: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    html_url: string;
    id: number;
    /**
     * Name of the project
     */
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    /**
     * State of the project; either 'open' or 'closed'
     */
    state: 'open' | 'closed';
    updated_at: string;
    url: string;
  };
  repository?: nullable_repository;
  sender?: simple_user;
};

export type webhook_project_edited = {
  action: 'edited';
  /**
   * The changes to the project if the action was `edited`.
   */
  changes?: {
    body?: {
      /**
       * The previous version of the body if the action was `edited`.
       */
      from: string;
    };
    name?: {
      /**
       * The changes to the project if the action was `edited`.
       */
      from: string;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project: {
    /**
     * Body of the project
     */
    body: string | null;
    columns_url: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    html_url: string;
    id: number;
    /**
     * Name of the project
     */
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    /**
     * State of the project; either 'open' or 'closed'
     */
    state: 'open' | 'closed';
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender?: simple_user;
};

export type webhook_project_reopened = {
  action: 'reopened';
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  project: {
    /**
     * Body of the project
     */
    body: string | null;
    columns_url: string;
    created_at: string;
    creator: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    html_url: string;
    id: number;
    /**
     * Name of the project
     */
    name: string;
    node_id: string;
    number: number;
    owner_url: string;
    /**
     * State of the project; either 'open' or 'closed'
     */
    state: 'open' | 'closed';
    updated_at: string;
    url: string;
  };
  repository?: repository;
  sender: simple_user;
};

export type webhook_projects_v2_item_archived = {
  action: 'archived';
  changes: {
    archived_at?: {
      from?: string | null;
      to?: string | null;
    };
  };
  installation?: simple_installation;
  organization: organization_simple;
  projects_v2_item: projects_v2_item;
  sender: simple_user;
};

export type action52 = 'archived';

export type webhook_projects_v2_item_converted = {
  action: 'converted';
  changes: {
    content_type?: {
      from?: string | null;
      to?: string;
    };
  };
  installation?: simple_installation;
  organization: organization_simple;
  projects_v2_item: projects_v2_item;
  sender: simple_user;
};

export type webhook_projects_v2_item_created = {
  action: 'created';
  installation?: simple_installation;
  organization: organization_simple;
  projects_v2_item: projects_v2_item;
  sender: simple_user;
};

export type webhook_projects_v2_item_deleted = {
  action: 'deleted';
  installation?: simple_installation;
  organization: organization_simple;
  projects_v2_item: projects_v2_item;
  sender: simple_user;
};

export type webhook_projects_v2_item_edited = {
  action: 'edited';
  changes?:
    | {
        field_value: {
          field_node_id?: string;
          field_type?: string;
        };
      }
    | {
        body: {
          from?: string | null;
          to?: string | null;
        };
      };
  installation?: simple_installation;
  organization: organization_simple;
  projects_v2_item: projects_v2_item;
  sender: simple_user;
};

export type webhook_projects_v2_item_reordered = {
  action: 'reordered';
  changes: {
    previous_projects_v2_item_node_id?: {
      from?: string | null;
      to?: string | null;
    };
  };
  installation?: simple_installation;
  organization: organization_simple;
  projects_v2_item: projects_v2_item;
  sender: simple_user;
};

export type action53 = 'reordered';

export type webhook_projects_v2_item_restored = {
  action: 'restored';
  changes: {
    archived_at?: {
      from?: string | null;
      to?: string | null;
    };
  };
  installation?: simple_installation;
  organization: organization_simple;
  projects_v2_item: projects_v2_item;
  sender: simple_user;
};

export type action54 = 'restored';

export type webhook_projects_v2_project_closed = {
  action: 'closed';
  organization: organization_simple;
  projects_v2: projects_v2;
  sender: simple_user;
};

/**
 * A project was created
 */
export type webhook_projects_v2_project_created = {
  action: 'created';
  organization: organization_simple;
  projects_v2: projects_v2;
  sender: simple_user;
};

export type webhook_projects_v2_project_edited = {
  action: 'edited';
  changes: {
    description?: {
      from?: string | null;
      to?: string | null;
    };
    public?: {
      from?: boolean;
      to?: boolean;
    };
    short_description?: {
      from?: string | null;
      to?: string | null;
    };
    title?: {
      from?: string;
      to?: string;
    };
  };
  organization: organization_simple;
  projects_v2: projects_v2;
  sender: simple_user;
};

export type webhook_projects_v2_project_reopened = {
  action: 'reopened';
  organization: organization_simple;
  projects_v2: projects_v2;
  sender: simple_user;
};

export type webhook_public = {
  enterprise?: enterprise;
  installation?: simple_installation;
  organization?: organization_simple;
  repository: repository;
  sender: simple_user;
};

export type webhook_pull_request_assigned = {
  action: 'assigned';
  assignee: {
    avatar_url?: string;
    deleted?: boolean;
    email?: string | null;
    events_url?: string;
    followers_url?: string;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    html_url?: string;
    id: number;
    login: string;
    name?: string;
    node_id?: string;
    organizations_url?: string;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    starred_url?: string;
    subscriptions_url?: string;
    type?: 'Bot' | 'User' | 'Organization';
    url?: string;
  } | null;
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The pull request number.
   */
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string | null;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      } | null;
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description: string | null;
          html_url: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url: string;
          /**
           * Name of the team
           */
          name: string;
          node_id: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission: string;
          privacy: 'open' | 'closed' | 'secret';
          repositories_url: string;
          slug: string;
          /**
           * URL for the team
           */
          url: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  repository: repository;
  sender: simple_user;
};

export type webhook_pull_request_auto_merge_disabled = {
  action: 'auto_merge_disabled';
  enterprise?: enterprise;
  installation?: simple_installation;
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description: string | null;
          html_url: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url: string;
          /**
           * Name of the team
           */
          name: string;
          node_id: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission: string;
          privacy: 'open' | 'closed' | 'secret';
          repositories_url: string;
          slug: string;
          /**
           * URL for the team
           */
          url: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  reason: string;
  repository: repository;
  sender: simple_user;
};

export type action55 = 'auto_merge_disabled';

export type webhook_pull_request_auto_merge_enabled = {
  action: 'auto_merge_enabled';
  enterprise?: enterprise;
  installation?: simple_installation;
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description: string | null;
          html_url: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url: string;
          /**
           * Name of the team
           */
          name: string;
          node_id: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission: string;
          privacy: 'open' | 'closed' | 'secret';
          repositories_url: string;
          slug: string;
          /**
           * URL for the team
           */
          url: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  reason?: string;
  repository: repository;
  sender: simple_user;
};

export type action56 = 'auto_merge_enabled';

export type webhook_pull_request_closed = {
  action: 'closed';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The pull request number.
   */
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string | null;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit message title.
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title.
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      } | null;
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description: string | null;
          html_url: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url: string;
          /**
           * Name of the team
           */
          name: string;
          node_id: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission: string;
          privacy: 'open' | 'closed' | 'secret';
          repositories_url: string;
          slug: string;
          /**
           * URL for the team
           */
          url: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  } & {
    _links?: {
      comments?: {
        href?: string;
      };
      commits?: {
        href?: string;
      };
      html?: {
        href?: string;
      };
      issue?: {
        href?: string;
      };
      review_comment?: {
        href?: string;
      };
      review_comments?: {
        href?: string;
      };
      self?: {
        href?: string;
      };
      statuses?: {
        href?: string;
      };
    };
    active_lock_reason?: string | null;
    additions?: number;
    assignee?: {
      [key: string]: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    auto_merge?: {
      [key: string]: string;
    } | null;
    base?: {
      label?: string;
      ref?: string;
      repo?: {
        allow_auto_merge?: boolean;
        allow_forking?: boolean;
        allow_merge_commit?: boolean;
        allow_rebase_merge?: boolean;
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url?: string;
        archived?: boolean;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        clone_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        created_at?: string;
        default_branch?: string;
        delete_branch_on_merge?: boolean;
        deployments_url?: string;
        description?: string | null;
        disabled?: boolean;
        downloads_url?: string;
        events_url?: string;
        fork?: boolean;
        forks?: number;
        forks_count?: number;
        forks_url?: string;
        full_name?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        has_downloads?: boolean;
        has_issues?: boolean;
        has_pages?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        homepage?: string | null;
        hooks_url?: string;
        html_url?: string;
        id?: number;
        is_template?: boolean;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        language?: string | null;
        languages_url?: string;
        license?: {
          [key: string]: string;
        } | null;
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url?: string;
        milestones_url?: string;
        mirror_url?: string | null;
        name?: string;
        node_id?: string;
        notifications_url?: string;
        open_issues?: number;
        open_issues_count?: number;
        owner?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
        };
        private?: boolean;
        pulls_url?: string;
        pushed_at?: string;
        releases_url?: string;
        size?: number;
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url?: string;
        stargazers_count?: number;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        svn_url?: string;
        tags_url?: string;
        teams_url?: string;
        topics?: Array<string | null>;
        trees_url?: string;
        updated_at?: string;
        url?: string;
        use_squash_pr_title_as_default?: boolean;
        visibility?: string;
        watchers?: number;
        watchers_count?: number;
        web_commit_signoff_required?: boolean;
      };
      sha?: string;
      user?: {
        avatar_url?: string;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id?: number;
        login?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: string;
        url?: string;
      };
    };
    body?: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url?: string;
    commits?: number;
    commits_url?: string;
    created_at?: string;
    deletions?: number;
    diff_url?: string;
    draft?: boolean;
    head?: {
      label?: string | null;
      ref?: string;
      repo?: {
        allow_auto_merge?: boolean;
        allow_forking?: boolean;
        allow_merge_commit?: boolean;
        allow_rebase_merge?: boolean;
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url?: string;
        archived?: boolean;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        clone_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        created_at?: string;
        default_branch?: string;
        delete_branch_on_merge?: boolean;
        deployments_url?: string;
        description?: string | null;
        disabled?: boolean;
        downloads_url?: string;
        events_url?: string;
        fork?: boolean;
        forks?: number;
        forks_count?: number;
        forks_url?: string;
        full_name?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        has_downloads?: boolean;
        has_issues?: boolean;
        has_pages?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        homepage?: string | null;
        hooks_url?: string;
        html_url?: string;
        id?: number;
        is_template?: boolean;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        language?: string | null;
        languages_url?: string;
        license?: {
          [key: string]: string;
        } | null;
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url?: string;
        milestones_url?: string;
        mirror_url?: string | null;
        name?: string;
        node_id?: string;
        notifications_url?: string;
        open_issues?: number;
        open_issues_count?: number;
        owner?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
        } | null;
        private?: boolean;
        pulls_url?: string;
        pushed_at?: string;
        releases_url?: string;
        size?: number;
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url?: string;
        stargazers_count?: number;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        svn_url?: string;
        tags_url?: string;
        teams_url?: string;
        topics?: Array<string | null>;
        trees_url?: string;
        updated_at?: string;
        url?: string;
        use_squash_pr_title_as_default?: boolean;
        visibility?: string;
        watchers?: number;
        watchers_count?: number;
        web_commit_signoff_required?: boolean;
      } | null;
      sha?: string;
      user?: {
        avatar_url?: string;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id?: number;
        login?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: string;
        url?: string;
      } | null;
    };
    html_url?: string;
    id?: number;
    issue_url?: string;
    labels?: Array<{
      [key: string]: string;
    } | null>;
    locked?: boolean;
    maintainer_can_modify?: boolean;
    merge_commit_sha?: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged: boolean;
    merged_at?: string | null;
    merged_by?: {
      [key: string]: string;
    } | null;
    milestone?: {
      [key: string]: string;
    } | null;
    node_id?: string;
    number?: number;
    patch_url?: string;
    rebaseable?: boolean | null;
    requested_reviewers?: Array<{
      [key: string]: string;
    } | null>;
    requested_teams?: Array<{
      [key: string]: string;
    } | null>;
    review_comment_url?: string;
    review_comments?: number;
    review_comments_url?: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'closed' | 'open';
    statuses_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  repository: repository;
  sender: simple_user;
};

export type webhook_pull_request_converted_to_draft = {
  action: 'converted_to_draft';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The pull request number.
   */
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      } | null;
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description?: string | null;
          html_url?: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url?: string;
          /**
           * Name of the team
           */
          name: string;
          node_id?: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission?: string;
          privacy?: 'open' | 'closed' | 'secret';
          repositories_url?: string;
          slug?: string;
          /**
           * URL for the team
           */
          url?: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  } & {
    _links?: {
      comments?: {
        href?: string;
      };
      commits?: {
        href?: string;
      };
      html?: {
        href?: string;
      };
      issue?: {
        href?: string;
      };
      review_comment?: {
        href?: string;
      };
      review_comments?: {
        href?: string;
      };
      self?: {
        href?: string;
      };
      statuses?: {
        href?: string;
      };
    };
    active_lock_reason?: string | null;
    additions?: number;
    assignee?: {
      [key: string]: string;
    } | null;
    assignees?: Array<{
      [key: string]: string;
    } | null>;
    author_association?: string;
    auto_merge?: {
      [key: string]: string;
    } | null;
    base?: {
      label?: string;
      ref?: string;
      repo?: {
        allow_auto_merge?: boolean;
        allow_forking?: boolean;
        allow_merge_commit?: boolean;
        allow_rebase_merge?: boolean;
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url?: string;
        archived?: boolean;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        clone_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        created_at?: string;
        default_branch?: string;
        delete_branch_on_merge?: boolean;
        deployments_url?: string;
        description?: string | null;
        disabled?: boolean;
        downloads_url?: string;
        events_url?: string;
        fork?: boolean;
        forks?: number;
        forks_count?: number;
        forks_url?: string;
        full_name?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        has_downloads?: boolean;
        has_issues?: boolean;
        has_pages?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        homepage?: string | null;
        hooks_url?: string;
        html_url?: string;
        id?: number;
        is_template?: boolean;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        language?: string | null;
        languages_url?: string;
        license?: {
          [key: string]: string;
        } | null;
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url?: string;
        milestones_url?: string;
        mirror_url?: string;
        name?: string;
        node_id?: string;
        notifications_url?: string;
        open_issues?: number;
        open_issues_count?: number;
        owner?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
        };
        private?: boolean;
        pulls_url?: string;
        pushed_at?: string;
        releases_url?: string;
        size?: number;
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url?: string;
        stargazers_count?: number;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        svn_url?: string;
        tags_url?: string;
        teams_url?: string;
        topics?: Array<string | null>;
        trees_url?: string;
        updated_at?: string;
        url?: string;
        use_squash_pr_title_as_default?: boolean;
        visibility?: string;
        watchers?: number;
        watchers_count?: number;
        web_commit_signoff_required?: boolean;
      };
      sha?: string;
      user?: {
        avatar_url?: string;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id?: number;
        login?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: string;
        url?: string;
      };
    };
    body?: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url?: string;
    commits?: number;
    commits_url?: string;
    created_at?: string;
    deletions?: number;
    diff_url?: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head?: {
      label?: string;
      ref?: string;
      repo?: {
        allow_auto_merge?: boolean;
        allow_forking?: boolean;
        allow_merge_commit?: boolean;
        allow_rebase_merge?: boolean;
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url?: string;
        archived?: boolean;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        clone_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        created_at?: string;
        default_branch?: string;
        delete_branch_on_merge?: boolean;
        deployments_url?: string;
        description?: string | null;
        disabled?: boolean;
        downloads_url?: string;
        events_url?: string;
        fork?: boolean;
        forks?: number;
        forks_count?: number;
        forks_url?: string;
        full_name?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        has_downloads?: boolean;
        has_issues?: boolean;
        has_pages?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        homepage?: string | null;
        hooks_url?: string;
        html_url?: string;
        id?: number;
        is_template?: boolean;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        language?: string | null;
        languages_url?: string;
        license?: {
          [key: string]: string;
        } | null;
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url?: string;
        milestones_url?: string;
        mirror_url?: string;
        name?: string;
        node_id?: string;
        notifications_url?: string;
        open_issues?: number;
        open_issues_count?: number;
        owner?: {
          avatar_url?: string;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id?: number;
          login?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: string;
          url?: string;
        };
        private?: boolean;
        pulls_url?: string;
        pushed_at?: string;
        releases_url?: string;
        size?: number;
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url?: string;
        stargazers_count?: number;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        svn_url?: string;
        tags_url?: string;
        teams_url?: string;
        topics?: Array<string | null>;
        trees_url?: string;
        updated_at?: string;
        url?: string;
        use_squash_pr_title_as_default?: boolean;
        visibility?: string;
        watchers?: number;
        watchers_count?: number;
        web_commit_signoff_required?: boolean;
      } | null;
      sha?: string;
      user?: {
        avatar_url?: string;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id?: number;
        login?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: string;
        url?: string;
      };
    };
    html_url?: string;
    id?: number;
    issue_url?: string;
    labels?: Array<{
      [key: string]: string;
    } | null>;
    locked?: boolean;
    maintainer_can_modify?: boolean;
    merge_commit_sha?: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged: boolean;
    merged_at: string;
    merged_by: string;
    milestone?: {
      [key: string]: string;
    } | null;
    node_id?: string;
    number?: number;
    patch_url?: string;
    rebaseable?: boolean | null;
    requested_reviewers?: Array<{
      [key: string]: string;
    } | null>;
    requested_teams?: Array<{
      [key: string]: string;
    } | null>;
    review_comment_url?: string;
    review_comments?: number;
    review_comments_url?: string;
    state?: string;
    statuses_url?: string;
    title?: string;
    updated_at?: string;
    url?: string;
    user?: {
      avatar_url?: string;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id?: number;
      login?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: string;
      url?: string;
    };
  };
  repository: repository;
  sender: simple_user;
};

export type action57 = 'converted_to_draft';

export type webhook_pull_request_demilestoned = {
  action: 'demilestoned';
  enterprise?: enterprise;
  milestone?: milestone;
  /**
   * The pull request number.
   */
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description?: string | null;
          html_url?: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url?: string;
          /**
           * Name of the team
           */
          name: string;
          node_id?: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission?: string;
          privacy?: 'open' | 'closed' | 'secret';
          repositories_url?: string;
          slug?: string;
          /**
           * URL for the team
           */
          url?: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  repository: repository;
  sender?: simple_user;
};

export type webhook_pull_request_dequeued = {
  action: 'dequeued';
  enterprise?: enterprise;
  installation?: simple_installation;
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description?: string | null;
          html_url?: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url?: string;
          /**
           * Name of the team
           */
          name: string;
          node_id?: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission?: string;
          privacy?: 'open' | 'closed' | 'secret';
          repositories_url?: string;
          slug?: string;
          /**
           * URL for the team
           */
          url?: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  reason: string;
  repository: repository;
  sender: simple_user;
};

export type action58 = 'dequeued';

export type webhook_pull_request_edited = {
  action: 'edited';
  /**
   * The changes to the comment if the action was `edited`.
   */
  changes: {
    base?: {
      ref: {
        from: string;
      };
      sha: {
        from: string;
      };
    };
    body?: {
      /**
       * The previous version of the body if the action was `edited`.
       */
      from: string;
    };
    title?: {
      /**
       * The previous version of the title if the action was `edited`.
       */
      from: string;
    };
  };
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The pull request number.
   */
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string | null;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      } | null;
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description: string | null;
          html_url: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url: string;
          /**
           * Name of the team
           */
          name: string;
          node_id: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission: string;
          privacy: 'open' | 'closed' | 'secret';
          repositories_url: string;
          slug: string;
          /**
           * URL for the team
           */
          url: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  repository: repository;
  sender?: simple_user;
};

export type webhook_pull_request_enqueued = {
  action: 'enqueued';
  enterprise?: enterprise;
  installation?: simple_installation;
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description?: string | null;
          html_url?: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url?: string;
          /**
           * Name of the team
           */
          name: string;
          node_id?: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission?: string;
          privacy?: 'open' | 'closed' | 'secret';
          repositories_url?: string;
          slug?: string;
          /**
           * URL for the team
           */
          url?: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  repository: repository;
  sender: simple_user;
};

export type action59 = 'enqueued';

export type webhook_pull_request_labeled = {
  action: 'labeled';
  enterprise?: enterprise;
  installation?: simple_installation;
  label?: {
    /**
     * 6-character hex code, without the leading #, identifying the color
     */
    color: string;
    default: boolean;
    description: string | null;
    id: number;
    /**
     * The name of the label.
     */
    name: string;
    node_id: string;
    /**
     * URL for the label
     */
    url: string;
  };
  /**
   * The pull request number.
   */
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string | null;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      } | null;
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    html_url: string;
    id: number;
    issue_url: string;
    labels: Array<{
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
      description: string | null;
      id: number;
      /**
       * The name of the label.
       */
      name: string;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
    }>;
    locked: boolean;
    /**
     * Indicates whether maintainers can modify the pull request.
     */
    maintainer_can_modify?: boolean;
    merge_commit_sha: string | null;
    mergeable?: boolean | null;
    mergeable_state?: string;
    merged?: boolean | null;
    merged_at: string | null;
    merged_by?: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      closed_at: string | null;
      closed_issues: number;
      created_at: string;
      creator: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
        url?: string;
      } | null;
      description: string | null;
      due_on: string | null;
      html_url: string;
      id: number;
      labels_url: string;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      open_issues: number;
      /**
       * The state of the milestone.
       */
      state: 'open' | 'closed';
      /**
       * The title of the milestone.
       */
      title: string;
      updated_at: string;
      url: string;
    } | null;
    node_id: string;
    /**
     * Number uniquely identifying the pull request within its repository.
     */
    number: number;
    patch_url: string;
    rebaseable?: boolean | null;
    requested_reviewers: Array<
      | {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
          url?: string;
        }
      | null
      | {
          deleted?: boolean;
          /**
           * Description of the team
           */
          description: string | null;
          html_url: string;
          /**
           * Unique identifier of the team
           */
          id: number;
          members_url: string;
          /**
           * Name of the team
           */
          name: string;
          node_id: string;
          parent?: {
            /**
             * Description of the team
             */
            description: string | null;
            html_url: string;
            /**
             * Unique identifier of the team
             */
            id: number;
            members_url: string;
            /**
             * Name of the team
             */
            name: string;
            node_id: string;
            /**
             * Permission that the team will have for its repositories
             */
            permission: string;
            privacy: 'open' | 'closed' | 'secret';
            repositories_url: string;
            slug: string;
            /**
             * URL for the team
             */
            url: string;
          } | null;
          /**
           * Permission that the team will have for its repositories
           */
          permission: string;
          privacy: 'open' | 'closed' | 'secret';
          repositories_url: string;
          slug: string;
          /**
           * URL for the team
           */
          url: string;
        }
    >;
    requested_teams: Array<{
      deleted?: boolean;
      /**
       * Description of the team
       */
      description?: string | null;
      html_url?: string;
      /**
       * Unique identifier of the team
       */
      id: number;
      members_url?: string;
      /**
       * Name of the team
       */
      name: string;
      node_id?: string;
      parent?: {
        /**
         * Description of the team
         */
        description: string | null;
        html_url: string;
        /**
         * Unique identifier of the team
         */
        id: number;
        members_url: string;
        /**
         * Name of the team
         */
        name: string;
        node_id: string;
        /**
         * Permission that the team will have for its repositories
         */
        permission: string;
        privacy: 'open' | 'closed' | 'secret';
        repositories_url: string;
        slug: string;
        /**
         * URL for the team
         */
        url: string;
      } | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission?: string;
      privacy?: 'open' | 'closed' | 'secret';
      repositories_url?: string;
      slug?: string;
      /**
       * URL for the team
       */
      url?: string;
    }>;
    review_comment_url: string;
    review_comments?: number;
    review_comments_url: string;
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: 'open' | 'closed';
    statuses_url: string;
    /**
     * The title of the pull request.
     */
    title: string;
    updated_at: string;
    url: string;
    user: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null;
  };
  repository: repository;
  sender: simple_user;
};

export type webhook_pull_request_locked = {
  action: 'locked';
  enterprise?: enterprise;
  installation?: simple_installation;
  /**
   * The pull request number.
   */
  number: number;
  organization?: organization_simple;
  pull_request: {
    _links: {
      comments: {
        href: string;
      };
      commits: {
        href: string;
      };
      html: {
        href: string;
      };
      issue: {
        href: string;
      };
      review_comment: {
        href: string;
      };
      review_comments: {
        href: string;
      };
      self: {
        href: string;
      };
      statuses: {
        href: string;
      };
    };
    active_lock_reason: ('resolved' | 'off-topic' | 'too heated' | 'spam') | null;
    additions?: number;
    assignee: {
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization';
      url?: string;
    } | null;
    assignees: Array<{
      avatar_url?: string;
      deleted?: boolean;
      email?: string | null;
      events_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      gravatar_id?: string;
      html_url?: string;
      id: number;
      login: string;
      name?: string;
      node_id?: string;
      organizations_url?: string;
      received_events_url?: string;
      repos_url?: string;
      site_admin?: boolean;
      starred_url?: string;
      subscriptions_url?: string;
      type?: 'Bot' | 'User' | 'Organization' | 'Mannequin';
      url?: string;
    } | null>;
    /**
     * How the author is associated with the repository.
     */
    author_association:
      | 'COLLABORATOR'
      | 'CONTRIBUTOR'
      | 'FIRST_TIMER'
      | 'FIRST_TIME_CONTRIBUTOR'
      | 'MANNEQUIN'
      | 'MEMBER'
      | 'NONE'
      | 'OWNER';
    /**
     * The status of auto merging a pull request.
     */
    auto_merge: {
      /**
       * Commit message for the merge commit.
       */
      commit_message: string | null;
      /**
       * Title for the merge commit message.
       */
      commit_title: string | null;
      enabled_by: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
      /**
       * The merge method to use.
       */
      merge_method: 'merge' | 'squash' | 'rebase';
    } | null;
    base: {
      label: string;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: number;
        open_issues_count: number;
        organization?: string;
        owner: {
          avatar_url?: string;
          deleted?: boolean;
          email?: string | null;
          events_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          gravatar_id?: string;
          html_url?: string;
          id: number;
          login: string;
          name?: string;
          node_id?: string;
          organizations_url?: string;
          received_events_url?: string;
          repos_url?: string;
          site_admin?: boolean;
          starred_url?: string;
          subscriptions_url?: string;
          type?: 'Bot' | 'User' | 'Organization';
          url?: string;
        } | null;
        permissions?: {
          admin: boolean;
          maintain?: boolean;
          pull: boolean;
          push: boolean;
          triage?: boolean;
        };
        /**
         * Whether the repository is private or public.
         */
        private: boolean;
        public?: boolean;
        pulls_url: string;
        pushed_at: (number | string) | null;
        releases_url: string;
        role_name?: string | null;
        size: number;
        /**
         * The default value for a squash merge commit message:
         *
         * - `PR_BODY` - default to the pull request's body.
         * - `COMMIT_MESSAGES` - default to the branch's commit messages.
         * - `BLANK` - default to a blank commit message.
         */
        squash_merge_commit_message?: 'PR_BODY' | 'COMMIT_MESSAGES' | 'BLANK';
        /**
         * The default value for a squash merge commit title:
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `COMMIT_OR_PR_TITLE` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).
         */
        squash_merge_commit_title?: 'PR_TITLE' | 'COMMIT_OR_PR_TITLE';
        ssh_url: string;
        stargazers?: number;
        stargazers_count: number;
        stargazers_url: string;
        statuses_url: string;
        subscribers_url: string;
        subscription_url: string;
        svn_url: string;
        tags_url: string;
        teams_url: string;
        topics: Array<string>;
        trees_url: string;
        updated_at: string;
        url: string;
        /**
         * Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.
         */
        use_squash_pr_title_as_default?: boolean;
        visibility: 'public' | 'private' | 'internal';
        watchers: number;
        watchers_count: number;
        /**
         * Whether to require contributors to sign off on web-based commits
         */
        web_commit_signoff_required?: boolean;
      };
      sha: string;
      user: {
        avatar_url?: string;
        deleted?: boolean;
        email?: string | null;
        events_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        gravatar_id?: string;
        html_url?: string;
        id: number;
        login: string;
        name?: string;
        node_id?: string;
        organizations_url?: string;
        received_events_url?: string;
        repos_url?: string;
        site_admin?: boolean;
        starred_url?: string;
        subscriptions_url?: string;
        type?: 'Bot' | 'User' | 'Organization';
        url?: string;
      } | null;
    };
    body: string | null;
    changed_files?: number;
    closed_at: string | null;
    comments?: number;
    comments_url: string;
    commits?: number;
    commits_url: string;
    created_at: string;
    deletions?: number;
    diff_url: string;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: boolean;
    head: {
      label: string | null;
      ref: string;
      /**
       * A git repository
       */
      repo: {
        /**
         * Whether to allow auto-merge for pull requests.
         */
        allow_auto_merge?: boolean;
        /**
         * Whether to allow private forks
         */
        allow_forking?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        allow_update_branch?: boolean;
        archive_url: string;
        /**
         * Whether the repository is archived.
         */
        archived: boolean;
        assignees_url: string;
        blobs_url: string;
        branches_url: string;
        clone_url: string;
        collaborators_url: string;
        comments_url: string;
        commits_url: string;
        compare_url: string;
        contents_url: string;
        contributors_url: string;
        created_at: number | string;
        /**
         * The default branch of the repository.
         */
        default_branch: string;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        deployments_url: string;
        description: string | null;
        /**
         * Returns whether or not this repository is disabled.
         */
        disabled?: boolean;
        downloads_url: string;
        events_url: string;
        fork: boolean;
        forks: number;
        forks_count: number;
        forks_url: string;
        full_name: string;
        git_commits_url: string;
        git_refs_url: string;
        git_tags_url: string;
        git_url: string;
        /**
         * Whether discussions are enabled.
         */
        has_discussions: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues: boolean;
        has_pages: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki: boolean;
        homepage: string | null;
        hooks_url: string;
        html_url: string;
        /**
         * Unique identifier of the repository
         */
        id: number;
        is_template?: boolean;
        issue_comment_url: string;
        issue_events_url: string;
        issues_url: string;
        keys_url: string;
        labels_url: string;
        language: string | null;
        languages_url: string;
        license: {
          key: string;
          name: string;
          node_id: string;
          spdx_id: string;
          url: string | null;
        } | null;
        master_branch?: string;
        /**
         * The default value for a merge commit message.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `PR_BODY` - default to the pull request's body.
         * - `BLANK` - default to a blank commit message.
         */
        merge_commit_message?: 'PR_BODY' | 'PR_TITLE' | 'BLANK';
        /**
         * The default value for a merge commit title.
         *
         * - `PR_TITLE` - default to the pull request's title.
         * - `MERGE_MESSAGE` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).
         */
        merge_commit_title?: 'PR_TITLE' | 'MERGE_MESSAGE';
        merges_url: string;
        milestones_url: string;
        mirror_url: string | null;
        /**
         * The name of the repository.
         */
        name: string;
        node_id: string;
        notifications_url: string;
        open_issues: numbe