// This file is auto-generated by @hey-api/openapi-ts

export const actions_billing_usageSchema = {
  properties: {
    included_minutes: {
      description: 'The amount of free GitHub Actions minutes available.',
      type: 'integer',
    },
    minutes_used_breakdown: {
      properties: {
        MACOS: {
          description: 'Total minutes used on macOS runner machines.',
          type: 'integer',
        },
        UBUNTU: {
          description: 'Total minutes used on Ubuntu runner machines.',
          type: 'integer',
        },
        WINDOWS: {
          description: 'Total minutes used on Windows runner machines.',
          type: 'integer',
        },
        macos_12_core: {
          description: 'Total minutes used on macOS 12 core runner machines.',
          type: 'integer',
        },
        total: {
          description: 'Total minutes used on all runner machines.',
          type: 'integer',
        },
        ubuntu_16_core: {
          description: 'Total minutes used on Ubuntu 16 core runner machines.',
          type: 'integer',
        },
        ubuntu_32_core: {
          description: 'Total minutes used on Ubuntu 32 core runner machines.',
          type: 'integer',
        },
        ubuntu_4_core: {
          description: 'Total minutes used on Ubuntu 4 core runner machines.',
          type: 'integer',
        },
        ubuntu_64_core: {
          description: 'Total minutes used on Ubuntu 64 core runner machines.',
          type: 'integer',
        },
        ubuntu_8_core: {
          description: 'Total minutes used on Ubuntu 8 core runner machines.',
          type: 'integer',
        },
        windows_16_core: {
          description: 'Total minutes used on Windows 16 core runner machines.',
          type: 'integer',
        },
        windows_32_core: {
          description: 'Total minutes used on Windows 32 core runner machines.',
          type: 'integer',
        },
        windows_4_core: {
          description: 'Total minutes used on Windows 4 core runner machines.',
          type: 'integer',
        },
        windows_64_core: {
          description: 'Total minutes used on Windows 64 core runner machines.',
          type: 'integer',
        },
        windows_8_core: {
          description: 'Total minutes used on Windows 8 core runner machines.',
          type: 'integer',
        },
      },
      type: 'object',
    },
    total_minutes_used: {
      description: 'The sum of the free and paid GitHub Actions minutes used.',
      type: 'integer',
    },
    total_paid_minutes_used: {
      description: 'The total paid GitHub Actions minutes used.',
      type: 'integer',
    },
  },
  required: ['total_minutes_used', 'total_paid_minutes_used', 'included_minutes', 'minutes_used_breakdown'],
  type: 'object',
} as const;

export const actions_cache_listSchema = {
  description: 'Repository actions caches',
  properties: {
    actions_caches: {
      description: 'Array of caches',
      items: {
        properties: {
          created_at: {
            example: '2019-01-24T22:45:36.000Z',
            format: 'date-time',
            type: 'string',
          },
          id: {
            example: 2,
            type: 'integer',
          },
          key: {
            example: 'Linux-node-958aff96db2d75d67787d1e634ae70b659de937b',
            type: 'string',
          },
          last_accessed_at: {
            example: '2019-01-24T22:45:36.000Z',
            format: 'date-time',
            type: 'string',
          },
          ref: {
            example: 'refs/heads/main',
            type: 'string',
          },
          size_in_bytes: {
            example: 1024,
            type: 'integer',
          },
          version: {
            example: '73885106f58cc52a7df9ec4d4a5622a5614813162cb516c759a30af6bf56e6f0',
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    total_count: {
      description: 'Total number of caches',
      example: 2,
      type: 'integer',
    },
  },
  required: ['total_count', 'actions_caches'],
  title: 'Repository actions caches',
  type: 'object',
} as const;

export const actions_cache_usage_by_repositorySchema = {
  description: 'GitHub Actions Cache Usage by repository.',
  properties: {
    active_caches_count: {
      description: 'The number of active caches in the repository.',
      example: 3,
      type: 'integer',
    },
    active_caches_size_in_bytes: {
      description: 'The sum of the size in bytes of all the active cache items in the repository.',
      example: 2322142,
      type: 'integer',
    },
    full_name: {
      description: 'The repository owner and name for the cache usage being shown.',
      example: 'octo-org/Hello-World',
      type: 'string',
    },
  },
  required: ['full_name', 'active_caches_size_in_bytes', 'active_caches_count'],
  title: 'Actions Cache Usage by repository',
  type: 'object',
} as const;

export const actions_cache_usage_org_enterpriseSchema = {
  properties: {
    total_active_caches_count: {
      description: 'The count of active caches across all repositories of an enterprise or an organization.',
      type: 'integer',
    },
    total_active_caches_size_in_bytes: {
      description:
        'The total size in bytes of all active cache items across all repositories of an enterprise or an organization.',
      type: 'integer',
    },
  },
  required: ['total_active_caches_count', 'total_active_caches_size_in_bytes'],
  type: 'object',
} as const;

export const actions_can_approve_pull_request_reviewsSchema = {
  description: 'Whether GitHub Actions can approve pull requests. Enabling this can be a security risk.',
  type: 'boolean',
} as const;

export const actions_default_workflow_permissionsSchema = {
  description: 'The default workflow permissions granted to the GITHUB_TOKEN when running workflows.',
  enum: ['read', 'write'],
  type: 'string',
} as const;

export const actions_enabledSchema = {
  description: 'Whether GitHub Actions is enabled on the repository.',
  type: 'boolean',
} as const;

export const actions_get_default_workflow_permissionsSchema = {
  properties: {
    can_approve_pull_request_reviews: {
      $ref: '#/components/schemas/actions-can-approve-pull-request-reviews',
    },
    default_workflow_permissions: {
      $ref: '#/components/schemas/actions-default-workflow-permissions',
    },
  },
  required: ['default_workflow_permissions', 'can_approve_pull_request_reviews'],
  type: 'object',
} as const;

export const actions_organization_permissionsSchema = {
  properties: {
    allowed_actions: {
      $ref: '#/components/schemas/allowed-actions',
    },
    enabled_repositories: {
      $ref: '#/components/schemas/enabled-repositories',
    },
    selected_actions_url: {
      $ref: '#/components/schemas/selected-actions-url',
    },
    selected_repositories_url: {
      description:
        'The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.',
      type: 'string',
    },
  },
  required: ['enabled_repositories'],
  type: 'object',
} as const;

export const actions_public_keySchema = {
  description: 'The public key used for setting Actions Secrets.',
  properties: {
    created_at: {
      example: '2011-01-26T19:01:12Z',
      type: 'string',
    },
    id: {
      example: 2,
      type: 'integer',
    },
    key: {
      description: 'The Base64 encoded public key.',
      example: 'hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=',
      type: 'string',
    },
    key_id: {
      description: 'The identifier for the key.',
      example: '1234567',
      type: 'string',
    },
    title: {
      example: 'ssh-rsa AAAAB3NzaC1yc2EAAA',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/user/keys/2',
      type: 'string',
    },
  },
  required: ['key_id', 'key'],
  title: 'ActionsPublicKey',
  type: 'object',
} as const;

export const actions_repository_permissionsSchema = {
  properties: {
    allowed_actions: {
      $ref: '#/components/schemas/allowed-actions',
    },
    enabled: {
      $ref: '#/components/schemas/actions-enabled',
    },
    selected_actions_url: {
      $ref: '#/components/schemas/selected-actions-url',
    },
  },
  required: ['enabled'],
  type: 'object',
} as const;

export const actions_secretSchema = {
  description: 'Set secrets for GitHub Actions.',
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    name: {
      description: 'The name of the secret.',
      example: 'SECRET_TOKEN',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
  },
  required: ['name', 'created_at', 'updated_at'],
  title: 'Actions Secret',
  type: 'object',
} as const;

export const actions_set_default_workflow_permissionsSchema = {
  properties: {
    can_approve_pull_request_reviews: {
      $ref: '#/components/schemas/actions-can-approve-pull-request-reviews',
    },
    default_workflow_permissions: {
      $ref: '#/components/schemas/actions-default-workflow-permissions',
    },
  },
  type: 'object',
} as const;

export const actions_variableSchema = {
  properties: {
    created_at: {
      description: "The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      example: '2019-01-24T22:45:36.000Z',
      format: 'date-time',
      type: 'string',
    },
    name: {
      description: 'The name of the variable.',
      example: 'USERNAME',
      type: 'string',
    },
    updated_at: {
      description:
        "The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      example: '2019-01-24T22:45:36.000Z',
      format: 'date-time',
      type: 'string',
    },
    value: {
      description: 'The value of the variable.',
      example: 'octocat',
      type: 'string',
    },
  },
  required: ['name', 'value', 'created_at', 'updated_at'],
  title: 'Actions Variable',
  type: 'object',
} as const;

export const actions_workflow_access_to_repositorySchema = {
  properties: {
    access_level: {
      description: `Defines the level of access that workflows outside of the repository have to actions and reusable workflows within the
repository.

\`none\` means the access is only possible from workflows in this repository. \`user\` level access allows sharing across user owned private repos only. \`organization\` level access allows sharing across the organization.`,
      enum: ['none', 'user', 'organization'],
      type: 'string',
    },
  },
  required: ['access_level'],
  type: 'object',
} as const;

export const actorSchema = {
  description: 'Actor',
  properties: {
    avatar_url: {
      format: 'uri',
      type: 'string',
    },
    display_login: {
      type: 'string',
    },
    gravatar_id: {
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    login: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['id', 'login', 'gravatar_id', 'url', 'avatar_url'],
  title: 'Actor',
  type: 'object',
} as const;

export const added_to_project_issue_eventSchema = {
  description: 'Added to Project Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    project_card: {
      properties: {
        column_name: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        previous_column_name: {
          type: 'string',
        },
        project_id: {
          type: 'integer',
        },
        project_url: {
          format: 'uri',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['id', 'url', 'project_id', 'project_url', 'column_name'],
      type: 'object',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Added to Project Issue Event',
  type: 'object',
} as const;

export const alert_created_atSchema = {
  description: 'The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
  format: 'date-time',
  readOnly: true,
  type: 'string',
} as const;

export const alert_dismissed_atSchema = {
  description: 'The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
  format: 'date-time',
  nullable: true,
  readOnly: true,
  type: 'string',
} as const;

export const alert_fixed_atSchema = {
  description:
    'The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
  format: 'date-time',
  nullable: true,
  readOnly: true,
  type: 'string',
} as const;

export const alert_html_urlSchema = {
  description: 'The GitHub URL of the alert resource.',
  format: 'uri',
  readOnly: true,
  type: 'string',
} as const;

export const alert_instances_urlSchema = {
  description: 'The REST API URL for fetching the list of instances for an alert.',
  format: 'uri',
  readOnly: true,
  type: 'string',
} as const;

export const alert_numberSchema = {
  description: 'The security alert number.',
  readOnly: true,
  type: 'integer',
} as const;

export const alert_updated_atSchema = {
  description: 'The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
  format: 'date-time',
  readOnly: true,
  type: 'string',
} as const;

export const alert_urlSchema = {
  description: 'The REST API URL of the alert resource.',
  format: 'uri',
  readOnly: true,
  type: 'string',
} as const;

export const allowed_actionsSchema = {
  description: 'The permissions policy that controls the actions and reusable workflows that are allowed to run.',
  enum: ['all', 'local_only', 'selected'],
  type: 'string',
} as const;

export const api_overviewSchema = {
  description: 'Api Overview',
  properties: {
    actions: {
      example: ['13.64.0.0/16', '13.65.0.0/16'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    api: {
      example: ['127.0.0.1/32'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    dependabot: {
      example: ['192.168.7.15/32', '192.168.7.16/32'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    git: {
      example: ['127.0.0.1/32'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    hooks: {
      example: ['127.0.0.1/32'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    importer: {
      example: ['54.158.161.132', '54.226.70.38'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    packages: {
      example: ['13.65.0.0/16', '157.55.204.33/32', '2a01:111:f403:f90c::/62'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    pages: {
      example: ['192.30.252.153/32', '192.30.252.154/32'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    ssh_key_fingerprints: {
      properties: {
        SHA256_DSA: {
          type: 'string',
        },
        SHA256_ECDSA: {
          type: 'string',
        },
        SHA256_ED25519: {
          type: 'string',
        },
        SHA256_RSA: {
          type: 'string',
        },
      },
      type: 'object',
    },
    ssh_keys: {
      example: ['ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIOMqqnkVzrm0SdG6UOoqKLsabgH5C9okWi0dh2l9GKJl'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    verifiable_password_authentication: {
      example: true,
      type: 'boolean',
    },
    web: {
      example: ['127.0.0.1/32'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['verifiable_password_authentication'],
  title: 'Api Overview',
  type: 'object',
} as const;

export const app_permissionsSchema = {
  description: 'The permissions granted to the user-to-server access token.',
  example: {
    contents: 'read',
    deployments: 'write',
    issues: 'read',
    single_file: 'read',
  },
  properties: {
    actions: {
      description:
        'The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts.',
      enum: ['read', 'write'],
      type: 'string',
    },
    administration: {
      description:
        'The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation.',
      enum: ['read', 'write'],
      type: 'string',
    },
    checks: {
      description: 'The level of permission to grant the access token for checks on code.',
      enum: ['read', 'write'],
      type: 'string',
    },
    contents: {
      description:
        'The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges.',
      enum: ['read', 'write'],
      type: 'string',
    },
    deployments: {
      description: 'The level of permission to grant the access token for deployments and deployment statuses.',
      enum: ['read', 'write'],
      type: 'string',
    },
    environments: {
      description: 'The level of permission to grant the access token for managing repository environments.',
      enum: ['read', 'write'],
      type: 'string',
    },
    issues: {
      description:
        'The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones.',
      enum: ['read', 'write'],
      type: 'string',
    },
    members: {
      description: 'The level of permission to grant the access token for organization teams and members.',
      enum: ['read', 'write'],
      type: 'string',
    },
    metadata: {
      description:
        'The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata.',
      enum: ['read', 'write'],
      type: 'string',
    },
    organization_administration: {
      description: 'The level of permission to grant the access token to manage access to an organization.',
      enum: ['read', 'write'],
      type: 'string',
    },
    organization_announcement_banners: {
      description:
        'The level of permission to grant the access token to view and manage announcement banners for an organization.',
      enum: ['read', 'write'],
      type: 'string',
    },
    organization_custom_roles: {
      description:
        'The level of permission to grant the access token for custom repository roles management. This property is in beta and is subject to change.',
      enum: ['read', 'write'],
      type: 'string',
    },
    organization_hooks: {
      description:
        'The level of permission to grant the access token to manage the post-receive hooks for an organization.',
      enum: ['read', 'write'],
      type: 'string',
    },
    organization_packages: {
      description:
        'The level of permission to grant the access token for organization packages published to GitHub Packages.',
      enum: ['read', 'write'],
      type: 'string',
    },
    organization_plan: {
      description: "The level of permission to grant the access token for viewing an organization's plan.",
      enum: ['read'],
      type: 'string',
    },
    organization_projects: {
      description:
        'The level of permission to grant the access token to manage organization projects and projects beta (where available).',
      enum: ['read', 'write', 'admin'],
      type: 'string',
    },
    organization_secrets: {
      description: 'The level of permission to grant the access token to manage organization secrets.',
      enum: ['read', 'write'],
      type: 'string',
    },
    organization_self_hosted_runners: {
      description:
        'The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization.',
      enum: ['read', 'write'],
      type: 'string',
    },
    organization_user_blocking: {
      description:
        'The level of permission to grant the access token to view and manage users blocked by the organization.',
      enum: ['read', 'write'],
      type: 'string',
    },
    packages: {
      description: 'The level of permission to grant the access token for packages published to GitHub Packages.',
      enum: ['read', 'write'],
      type: 'string',
    },
    pages: {
      description:
        'The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.',
      enum: ['read', 'write'],
      type: 'string',
    },
    pull_requests: {
      description:
        'The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges.',
      enum: ['read', 'write'],
      type: 'string',
    },
    repository_announcement_banners: {
      description:
        'The level of permission to grant the access token to view and manage announcement banners for a repository.',
      enum: ['read', 'write'],
      type: 'string',
    },
    repository_hooks: {
      description:
        'The level of permission to grant the access token to manage the post-receive hooks for a repository.',
      enum: ['read', 'write'],
      type: 'string',
    },
    repository_projects: {
      description:
        'The level of permission to grant the access token to manage repository projects, columns, and cards.',
      enum: ['read', 'write', 'admin'],
      type: 'string',
    },
    secret_scanning_alerts: {
      description: 'The level of permission to grant the access token to view and manage secret scanning alerts.',
      enum: ['read', 'write'],
      type: 'string',
    },
    secrets: {
      description: 'The level of permission to grant the access token to manage repository secrets.',
      enum: ['read', 'write'],
      type: 'string',
    },
    security_events: {
      description:
        'The level of permission to grant the access token to view and manage security events like code scanning alerts.',
      enum: ['read', 'write'],
      type: 'string',
    },
    single_file: {
      description: 'The level of permission to grant the access token to manage just a single file.',
      enum: ['read', 'write'],
      type: 'string',
    },
    statuses: {
      description: 'The level of permission to grant the access token for commit statuses.',
      enum: ['read', 'write'],
      type: 'string',
    },
    team_discussions: {
      description: 'The level of permission to grant the access token to manage team discussions and related comments.',
      enum: ['read', 'write'],
      type: 'string',
    },
    vulnerability_alerts: {
      description: 'The level of permission to grant the access token to manage Dependabot alerts.',
      enum: ['read', 'write'],
      type: 'string',
    },
    workflows: {
      description: 'The level of permission to grant the access token to update GitHub Actions workflow files.',
      enum: ['write'],
      type: 'string',
    },
  },
  title: 'App Permissions',
  type: 'object',
} as const;

export const artifactSchema = {
  description: 'An artifact',
  properties: {
    archive_download_url: {
      example: 'https://api.github.com/repos/github/hello-world/actions/artifacts/5/zip',
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    expired: {
      description: 'Whether or not the artifact has expired.',
      type: 'boolean',
    },
    expires_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    id: {
      example: 5,
      type: 'integer',
    },
    name: {
      description: 'The name of the artifact.',
      example: 'AdventureWorks.Framework',
      type: 'string',
    },
    node_id: {
      example: 'MDEwOkNoZWNrU3VpdGU1',
      type: 'string',
    },
    size_in_bytes: {
      description: 'The size in bytes of the artifact.',
      example: 12345,
      type: 'integer',
    },
    updated_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/github/hello-world/actions/artifacts/5',
      type: 'string',
    },
    workflow_run: {
      nullable: true,
      properties: {
        head_branch: {
          example: 'main',
          type: 'string',
        },
        head_repository_id: {
          example: 42,
          type: 'integer',
        },
        head_sha: {
          example: '009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d',
          type: 'string',
        },
        id: {
          example: 10,
          type: 'integer',
        },
        repository_id: {
          example: 42,
          type: 'integer',
        },
      },
      type: 'object',
    },
  },
  required: [
    'id',
    'node_id',
    'name',
    'size_in_bytes',
    'url',
    'archive_download_url',
    'expired',
    'created_at',
    'expires_at',
    'updated_at',
  ],
  title: 'Artifact',
  type: 'object',
} as const;

export const assigned_issue_eventSchema = {
  description: 'Assigned Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    assignee: {
      $ref: '#/components/schemas/simple-user',
    },
    assigner: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
    'assignee',
    'assigner',
  ],
  title: 'Assigned Issue Event',
  type: 'object',
} as const;

export const authentication_tokenSchema = {
  description: 'Authentication Token',
  properties: {
    expires_at: {
      description: 'The time this token expires',
      example: '2016-07-11T22:14:10Z',
      format: 'date-time',
      type: 'string',
    },
    permissions: {
      example: {
        deployments: 'write',
        issues: 'read',
      },
      type: 'object',
    },
    repositories: {
      description: 'The repositories this token has access to',
      items: {
        $ref: '#/components/schemas/repository',
      },
      type: 'array',
    },
    repository_selection: {
      description: "Describe whether all repositories have been selected or there's a selection involved",
      enum: ['all', 'selected'],
      type: 'string',
    },
    single_file: {
      example: 'config.yaml',
      nullable: true,
      type: 'string',
    },
    token: {
      description: 'The token used for authentication',
      example: 'v1.1f699f1069f60xxx',
      type: 'string',
    },
  },
  required: ['token', 'expires_at'],
  title: 'Authentication Token',
  type: 'object',
} as const;

export const author_associationSchema = {
  description: 'How the author is associated with the repository.',
  enum: [
    'COLLABORATOR',
    'CONTRIBUTOR',
    'FIRST_TIMER',
    'FIRST_TIME_CONTRIBUTOR',
    'MANNEQUIN',
    'MEMBER',
    'NONE',
    'OWNER',
  ],
  example: 'OWNER',
  title: 'author_association',
  type: 'string',
} as const;

export const authorizationSchema = {
  description: 'The authorization for an OAuth app, GitHub App, or a Personal Access Token.',
  properties: {
    app: {
      properties: {
        client_id: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['client_id', 'name', 'url'],
      type: 'object',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    expires_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    fingerprint: {
      nullable: true,
      type: 'string',
    },
    hashed_token: {
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    installation: {
      $ref: '#/components/schemas/nullable-scoped-installation',
    },
    note: {
      nullable: true,
      type: 'string',
    },
    note_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    scopes: {
      description: 'A list of scopes that this authorization is in.',
      items: {
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
    token: {
      type: 'string',
    },
    token_last_eight: {
      nullable: true,
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    'app',
    'id',
    'note',
    'note_url',
    'scopes',
    'token',
    'hashed_token',
    'token_last_eight',
    'fingerprint',
    'url',
    'created_at',
    'updated_at',
    'expires_at',
  ],
  title: 'Authorization',
  type: 'object',
} as const;

export const auto_mergeSchema = {
  description: 'The status of auto merging a pull request.',
  nullable: true,
  properties: {
    commit_message: {
      description: 'Commit message for the merge commit.',
      type: 'string',
    },
    commit_title: {
      description: 'Title for the merge commit message.',
      type: 'string',
    },
    enabled_by: {
      $ref: '#/components/schemas/simple-user',
    },
    merge_method: {
      description: 'The merge method to use.',
      enum: ['merge', 'squash', 'rebase'],
      type: 'string',
    },
  },
  required: ['enabled_by', 'merge_method', 'commit_title', 'commit_message'],
  title: 'Auto merge',
  type: 'object',
} as const;

export const autolinkSchema = {
  description: 'An autolink reference.',
  properties: {
    id: {
      example: 3,
      type: 'integer',
    },
    is_alphanumeric: {
      description:
        'Whether this autolink reference matches alphanumeric characters. If false, this autolink reference only matches numeric characters.',
      example: true,
      type: 'boolean',
    },
    key_prefix: {
      description: 'The prefix of a key that is linkified.',
      example: 'TICKET-',
      type: 'string',
    },
    url_template: {
      description: 'A template for the target URL that is generated if a key was found.',
      example: 'https://example.com/TICKET?query=<num>',
      type: 'string',
    },
  },
  required: ['id', 'key_prefix', 'url_template', 'is_alphanumeric'],
  title: 'Autolink reference',
  type: 'object',
} as const;

export const base_gistSchema = {
  description: 'Base Gist',
  properties: {
    comments: {
      type: 'integer',
    },
    comments_url: {
      format: 'uri',
      type: 'string',
    },
    commits_url: {
      format: 'uri',
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    description: {
      nullable: true,
      type: 'string',
    },
    files: {
      additionalProperties: {
        properties: {
          filename: {
            type: 'string',
          },
          language: {
            type: 'string',
          },
          raw_url: {
            type: 'string',
          },
          size: {
            type: 'integer',
          },
          type: {
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'object',
    },
    forks: {
      items: {},
      type: 'array',
    },
    forks_url: {
      format: 'uri',
      type: 'string',
    },
    git_pull_url: {
      format: 'uri',
      type: 'string',
    },
    git_push_url: {
      format: 'uri',
      type: 'string',
    },
    history: {
      items: {},
      type: 'array',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    public: {
      type: 'boolean',
    },
    truncated: {
      type: 'boolean',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'forks_url',
    'commits_url',
    'git_pull_url',
    'git_push_url',
    'html_url',
    'comments_url',
    'public',
    'description',
    'comments',
    'user',
    'files',
    'created_at',
    'updated_at',
  ],
  title: 'Base Gist',
  type: 'object',
} as const;

export const basic_errorSchema = {
  description: 'Basic Error',
  properties: {
    documentation_url: {
      type: 'string',
    },
    message: {
      type: 'string',
    },
    status: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
  },
  title: 'Basic Error',
  type: 'object',
} as const;

export const blobSchema = {
  description: 'Blob',
  properties: {
    content: {
      type: 'string',
    },
    encoding: {
      type: 'string',
    },
    highlighted_content: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    sha: {
      type: 'string',
    },
    size: {
      nullable: true,
      type: 'integer',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['sha', 'url', 'node_id', 'size', 'content', 'encoding'],
  title: 'Blob',
  type: 'object',
} as const;

export const branch_protectionSchema = {
  description: 'Branch Protection',
  properties: {
    allow_deletions: {
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    allow_force_pushes: {
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    allow_fork_syncing: {
      description:
        'Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.',
      properties: {
        enabled: {
          default: false,
          type: 'boolean',
        },
      },
      type: 'object',
    },
    block_creations: {
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    enabled: {
      type: 'boolean',
    },
    enforce_admins: {
      $ref: '#/components/schemas/protected-branch-admin-enforced',
    },
    lock_branch: {
      description:
        'Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.',
      properties: {
        enabled: {
          default: false,
          type: 'boolean',
        },
      },
      type: 'object',
    },
    name: {
      example: '"branch/with/protection"',
      type: 'string',
    },
    protection_url: {
      example:
        '"https://api.github.com/repos/owner-79e94e2d36b3fd06a32bb213/AAA_Public_Repo/branches/branch/with/protection/protection"',
      type: 'string',
    },
    required_conversation_resolution: {
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    required_linear_history: {
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    required_pull_request_reviews: {
      $ref: '#/components/schemas/protected-branch-pull-request-review',
    },
    required_signatures: {
      properties: {
        enabled: {
          example: true,
          type: 'boolean',
        },
        url: {
          example: 'https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_signatures',
          format: 'uri',
          type: 'string',
        },
      },
      required: ['url', 'enabled'],
      type: 'object',
    },
    required_status_checks: {
      $ref: '#/components/schemas/protected-branch-required-status-check',
    },
    restrictions: {
      $ref: '#/components/schemas/branch-restriction-policy',
    },
    url: {
      type: 'string',
    },
  },
  title: 'Branch Protection',
  type: 'object',
} as const;

export const branch_restriction_policySchema = {
  description: 'Branch Restriction Policy',
  properties: {
    apps: {
      items: {
        properties: {
          created_at: {
            type: 'string',
          },
          description: {
            type: 'string',
          },
          events: {
            items: {
              type: 'string',
            },
            type: 'array',
          },
          external_url: {
            type: 'string',
          },
          html_url: {
            type: 'string',
          },
          id: {
            type: 'integer',
          },
          name: {
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          owner: {
            properties: {
              avatar_url: {
                type: 'string',
              },
              description: {
                type: 'string',
              },
              events_url: {
                type: 'string',
              },
              followers_url: {
                example: '"https://api.github.com/users/testorg-ea8ec76d71c3af4b/followers"',
                type: 'string',
              },
              following_url: {
                example: '"https://api.github.com/users/testorg-ea8ec76d71c3af4b/following{/other_user}"',
                type: 'string',
              },
              gists_url: {
                example: '"https://api.github.com/users/testorg-ea8ec76d71c3af4b/gists{/gist_id}"',
                type: 'string',
              },
              gravatar_id: {
                example: '""',
                type: 'string',
              },
              hooks_url: {
                type: 'string',
              },
              html_url: {
                example: '"https://github.com/testorg-ea8ec76d71c3af4b"',
                type: 'string',
              },
              id: {
                type: 'integer',
              },
              issues_url: {
                type: 'string',
              },
              login: {
                type: 'string',
              },
              members_url: {
                type: 'string',
              },
              node_id: {
                type: 'string',
              },
              organizations_url: {
                example: '"https://api.github.com/users/testorg-ea8ec76d71c3af4b/orgs"',
                type: 'string',
              },
              public_members_url: {
                type: 'string',
              },
              received_events_url: {
                example: '"https://api.github.com/users/testorg-ea8ec76d71c3af4b/received_events"',
                type: 'string',
              },
              repos_url: {
                type: 'string',
              },
              site_admin: {
                example: false,
                type: 'boolean',
              },
              starred_url: {
                example: '"https://api.github.com/users/testorg-ea8ec76d71c3af4b/starred{/owner}{/repo}"',
                type: 'string',
              },
              subscriptions_url: {
                example: '"https://api.github.com/users/testorg-ea8ec76d71c3af4b/subscriptions"',
                type: 'string',
              },
              type: {
                example: '"Organization"',
                type: 'string',
              },
              url: {
                type: 'string',
              },
            },
            type: 'object',
          },
          permissions: {
            properties: {
              contents: {
                type: 'string',
              },
              issues: {
                type: 'string',
              },
              metadata: {
                type: 'string',
              },
              single_file: {
                type: 'string',
              },
            },
            type: 'object',
          },
          slug: {
            type: 'string',
          },
          updated_at: {
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    apps_url: {
      format: 'uri',
      type: 'string',
    },
    teams: {
      items: {
        properties: {
          description: {
            nullable: true,
            type: 'string',
          },
          html_url: {
            type: 'string',
          },
          id: {
            type: 'integer',
          },
          members_url: {
            type: 'string',
          },
          name: {
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          parent: {
            nullable: true,
            type: 'string',
          },
          permission: {
            type: 'string',
          },
          privacy: {
            type: 'string',
          },
          repositories_url: {
            type: 'string',
          },
          slug: {
            type: 'string',
          },
          url: {
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    teams_url: {
      format: 'uri',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    users: {
      items: {
        properties: {
          avatar_url: {
            type: 'string',
          },
          events_url: {
            type: 'string',
          },
          followers_url: {
            type: 'string',
          },
          following_url: {
            type: 'string',
          },
          gists_url: {
            type: 'string',
          },
          gravatar_id: {
            type: 'string',
          },
          html_url: {
            type: 'string',
          },
          id: {
            type: 'integer',
          },
          login: {
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          organizations_url: {
            type: 'string',
          },
          received_events_url: {
            type: 'string',
          },
          repos_url: {
            type: 'string',
          },
          site_admin: {
            type: 'boolean',
          },
          starred_url: {
            type: 'string',
          },
          subscriptions_url: {
            type: 'string',
          },
          type: {
            type: 'string',
          },
          url: {
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    users_url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'users_url', 'teams_url', 'apps_url', 'users', 'teams', 'apps'],
  title: 'Branch Restriction Policy',
  type: 'object',
} as const;

export const branch_shortSchema = {
  description: 'Branch Short',
  properties: {
    commit: {
      properties: {
        sha: {
          type: 'string',
        },
        url: {
          type: 'string',
        },
      },
      required: ['sha', 'url'],
      type: 'object',
    },
    name: {
      type: 'string',
    },
    protected: {
      type: 'boolean',
    },
  },
  required: ['name', 'commit', 'protected'],
  title: 'Branch Short',
  type: 'object',
} as const;

export const branch_with_protectionSchema = {
  description: 'Branch With Protection',
  properties: {
    _links: {
      properties: {
        html: {
          type: 'string',
        },
        self: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['html', 'self'],
      type: 'object',
    },
    commit: {
      $ref: '#/components/schemas/commit',
    },
    name: {
      type: 'string',
    },
    pattern: {
      example: '"mas*"',
      type: 'string',
    },
    protected: {
      type: 'boolean',
    },
    protection: {
      $ref: '#/components/schemas/branch-protection',
    },
    protection_url: {
      format: 'uri',
      type: 'string',
    },
    required_approving_review_count: {
      example: 1,
      type: 'integer',
    },
  },
  required: ['name', 'commit', '_links', 'protection', 'protected', 'protection_url'],
  title: 'Branch With Protection',
  type: 'object',
} as const;

export const check_annotationSchema = {
  description: 'Check Annotation',
  properties: {
    annotation_level: {
      example: 'warning',
      nullable: true,
      type: 'string',
    },
    blob_href: {
      type: 'string',
    },
    end_column: {
      example: 10,
      nullable: true,
      type: 'integer',
    },
    end_line: {
      example: 2,
      type: 'integer',
    },
    message: {
      example: "Check your spelling for 'banaas'.",
      nullable: true,
      type: 'string',
    },
    path: {
      example: 'README.md',
      type: 'string',
    },
    raw_details: {
      example: "Do you mean 'bananas' or 'banana'?",
      nullable: true,
      type: 'string',
    },
    start_column: {
      example: 5,
      nullable: true,
      type: 'integer',
    },
    start_line: {
      example: 2,
      type: 'integer',
    },
    title: {
      example: 'Spell Checker',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'path',
    'blob_href',
    'start_line',
    'end_line',
    'start_column',
    'end_column',
    'annotation_level',
    'title',
    'message',
    'raw_details',
  ],
  title: 'Check Annotation',
  type: 'object',
} as const;

export const check_runSchema = {
  description: 'A check performed on the code of a given code change',
  properties: {
    app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    check_suite: {
      nullable: true,
      properties: {
        id: {
          type: 'integer',
        },
      },
      required: ['id'],
      type: 'object',
    },
    completed_at: {
      example: '2018-05-04T01:14:52Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    conclusion: {
      enum: ['success', 'failure', 'neutral', 'cancelled', 'skipped', 'timed_out', 'action_required'],
      example: 'neutral',
      nullable: true,
      type: 'string',
    },
    deployment: {
      $ref: '#/components/schemas/deployment-simple',
    },
    details_url: {
      example: 'https://example.com',
      nullable: true,
      type: 'string',
    },
    external_id: {
      example: '42',
      nullable: true,
      type: 'string',
    },
    head_sha: {
      description: 'The SHA of the commit that is being checked.',
      example: '009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/github/hello-world/runs/4',
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'The id of the check.',
      example: 21,
      type: 'integer',
    },
    name: {
      description: 'The name of the check.',
      example: 'test-coverage',
      type: 'string',
    },
    node_id: {
      example: 'MDg6Q2hlY2tSdW40',
      type: 'string',
    },
    output: {
      properties: {
        annotations_count: {
          type: 'integer',
        },
        annotations_url: {
          format: 'uri',
          type: 'string',
        },
        summary: {
          nullable: true,
          type: 'string',
        },
        text: {
          nullable: true,
          type: 'string',
        },
        title: {
          nullable: true,
          type: 'string',
        },
      },
      required: ['title', 'summary', 'text', 'annotations_count', 'annotations_url'],
      type: 'object',
    },
    pull_requests: {
      items: {
        $ref: '#/components/schemas/pull-request-minimal',
      },
      type: 'array',
    },
    started_at: {
      example: '2018-05-04T01:14:52Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    status: {
      description: 'The phase of the lifecycle that the check is currently in.',
      enum: ['queued', 'in_progress', 'completed'],
      example: 'queued',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/github/hello-world/check-runs/4',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'head_sha',
    'name',
    'url',
    'html_url',
    'details_url',
    'status',
    'conclusion',
    'started_at',
    'completed_at',
    'external_id',
    'check_suite',
    'output',
    'app',
    'pull_requests',
  ],
  title: 'CheckRun',
  type: 'object',
} as const;

export const check_run_with_simple_check_suiteSchema = {
  description: 'A check performed on the code of a given code change',
  properties: {
    app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    check_suite: {
      $ref: '#/components/schemas/simple-check-suite',
    },
    completed_at: {
      example: '2018-05-04T01:14:52Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    conclusion: {
      enum: [
        'waiting',
        'pending',
        'startup_failure',
        'stale',
        'success',
        'failure',
        'neutral',
        'cancelled',
        'skipped',
        'timed_out',
        'action_required',
      ],
      example: 'neutral',
      nullable: true,
      type: 'string',
    },
    deployment: {
      $ref: '#/components/schemas/deployment-simple',
    },
    details_url: {
      example: 'https://example.com',
      type: 'string',
    },
    external_id: {
      example: '42',
      type: 'string',
    },
    head_sha: {
      description: 'The SHA of the commit that is being checked.',
      example: '009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/github/hello-world/runs/4',
      type: 'string',
    },
    id: {
      description: 'The id of the check.',
      example: 21,
      type: 'integer',
    },
    name: {
      description: 'The name of the check.',
      example: 'test-coverage',
      type: 'string',
    },
    node_id: {
      example: 'MDg6Q2hlY2tSdW40',
      type: 'string',
    },
    output: {
      properties: {
        annotations_count: {
          type: 'integer',
        },
        annotations_url: {
          format: 'uri',
          type: 'string',
        },
        summary: {
          nullable: true,
          type: 'string',
        },
        text: {
          nullable: true,
          type: 'string',
        },
        title: {
          nullable: true,
          type: 'string',
        },
      },
      required: ['title', 'summary', 'text', 'annotations_count', 'annotations_url'],
      type: 'object',
    },
    pull_requests: {
      items: {
        $ref: '#/components/schemas/pull-request-minimal',
      },
      type: 'array',
    },
    started_at: {
      example: '2018-05-04T01:14:52Z',
      format: 'date-time',
      type: 'string',
    },
    status: {
      description: 'The phase of the lifecycle that the check is currently in.',
      enum: ['queued', 'in_progress', 'completed', 'pending'],
      example: 'queued',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/github/hello-world/check-runs/4',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'head_sha',
    'name',
    'url',
    'html_url',
    'details_url',
    'status',
    'conclusion',
    'started_at',
    'completed_at',
    'external_id',
    'check_suite',
    'output',
    'app',
    'pull_requests',
  ],
  title: 'CheckRun',
  type: 'object',
} as const;

export const check_suiteSchema = {
  description: 'A suite of checks performed on the code of a given code change',
  properties: {
    after: {
      example: 'd6fde92930d4715a2b49857d24b940956b26d2d3',
      nullable: true,
      type: 'string',
    },
    app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    before: {
      example: '146e867f55c26428e5f9fade55a9bbf5e95a7912',
      nullable: true,
      type: 'string',
    },
    check_runs_url: {
      type: 'string',
    },
    conclusion: {
      enum: [
        'success',
        'failure',
        'neutral',
        'cancelled',
        'skipped',
        'timed_out',
        'action_required',
        'startup_failure',
        'stale',
        null,
      ],
      example: 'neutral',
      nullable: true,
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    head_branch: {
      example: 'master',
      nullable: true,
      type: 'string',
    },
    head_commit: {
      $ref: '#/components/schemas/simple-commit',
    },
    head_sha: {
      description: 'The SHA of the head commit that is being checked.',
      example: '009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d',
      type: 'string',
    },
    id: {
      example: 5,
      type: 'integer',
    },
    latest_check_runs_count: {
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOkNoZWNrU3VpdGU1',
      type: 'string',
    },
    pull_requests: {
      items: {
        $ref: '#/components/schemas/pull-request-minimal',
      },
      nullable: true,
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    rerequestable: {
      type: 'boolean',
    },
    runs_rerequestable: {
      type: 'boolean',
    },
    status: {
      enum: ['queued', 'in_progress', 'completed'],
      example: 'completed',
      nullable: true,
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/github/hello-world/check-suites/5',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'head_branch',
    'status',
    'conclusion',
    'head_sha',
    'url',
    'before',
    'after',
    'created_at',
    'updated_at',
    'app',
    'head_commit',
    'repository',
    'latest_check_runs_count',
    'check_runs_url',
    'pull_requests',
  ],
  title: 'CheckSuite',
  type: 'object',
} as const;

export const check_suite_preferenceSchema = {
  description: 'Check suite configuration preferences for a repository.',
  properties: {
    preferences: {
      properties: {
        auto_trigger_checks: {
          items: {
            properties: {
              app_id: {
                type: 'integer',
              },
              setting: {
                type: 'boolean',
              },
            },
            required: ['app_id', 'setting'],
            type: 'object',
          },
          type: 'array',
        },
      },
      type: 'object',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
  },
  required: ['preferences', 'repository'],
  title: 'Check Suite Preference',
  type: 'object',
} as const;

export const clone_trafficSchema = {
  description: 'Clone Traffic',
  properties: {
    clones: {
      items: {
        $ref: '#/components/schemas/traffic',
      },
      type: 'array',
    },
    count: {
      example: 173,
      type: 'integer',
    },
    uniques: {
      example: 128,
      type: 'integer',
    },
  },
  required: ['uniques', 'count', 'clones'],
  title: 'Clone Traffic',
  type: 'object',
} as const;

export const code_frequency_statSchema = {
  description: 'Code Frequency Stat',
  items: {
    type: 'integer',
  },
  title: 'Code Frequency Stat',
  type: 'array',
} as const;

export const code_of_conductSchema = {
  description: 'Code Of Conduct',
  properties: {
    body: {
      example: `# Contributor Covenant Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, gender identity and expression, level of experience, nationality, personal appearance, race, religion, or sexual identity and orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response
                  to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address,
                  posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported by contacting the project team at [EMAIL]. The project team will review and investigate all complaints, and will respond in a way that it deems appropriate to the circumstances. The project team is obligated to maintain confidentiality with regard to the reporter of an incident. Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4, available at [http://contributor-covenant.org/version/1/4][version]

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/
`,
      type: 'string',
    },
    html_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    key: {
      example: 'contributor_covenant',
      type: 'string',
    },
    name: {
      example: 'Contributor Covenant',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/codes_of_conduct/contributor_covenant',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'html_url', 'key', 'name'],
  title: 'Code Of Conduct',
  type: 'object',
} as const;

export const code_of_conduct_simpleSchema = {
  description: 'Code of Conduct Simple',
  properties: {
    html_url: {
      example: 'https://github.com/github/docs/blob/main/CODE_OF_CONDUCT.md',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    key: {
      example: 'citizen_code_of_conduct',
      type: 'string',
    },
    name: {
      example: 'Citizen Code of Conduct',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/github/docs/community/code_of_conduct',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'key', 'name', 'html_url'],
  title: 'Code Of Conduct Simple',
  type: 'object',
} as const;

export const code_scanning_alertSchema = {
  properties: {
    created_at: {
      $ref: '#/components/schemas/alert-created-at',
    },
    dismissed_at: {
      $ref: '#/components/schemas/alert-dismissed-at',
    },
    dismissed_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    dismissed_comment: {
      $ref: '#/components/schemas/code-scanning-alert-dismissed-comment',
    },
    dismissed_reason: {
      $ref: '#/components/schemas/code-scanning-alert-dismissed-reason',
    },
    fixed_at: {
      $ref: '#/components/schemas/alert-fixed-at',
    },
    html_url: {
      $ref: '#/components/schemas/alert-html-url',
    },
    instances_url: {
      $ref: '#/components/schemas/alert-instances-url',
    },
    most_recent_instance: {
      $ref: '#/components/schemas/code-scanning-alert-instance',
    },
    number: {
      $ref: '#/components/schemas/alert-number',
    },
    rule: {
      $ref: '#/components/schemas/code-scanning-alert-rule',
    },
    state: {
      $ref: '#/components/schemas/code-scanning-alert-state',
    },
    tool: {
      $ref: '#/components/schemas/code-scanning-analysis-tool',
    },
    updated_at: {
      $ref: '#/components/schemas/alert-updated-at',
    },
    url: {
      $ref: '#/components/schemas/alert-url',
    },
  },
  required: [
    'number',
    'created_at',
    'url',
    'html_url',
    'instances_url',
    'state',
    'dismissed_by',
    'dismissed_at',
    'dismissed_reason',
    'rule',
    'tool',
    'most_recent_instance',
  ],
  type: 'object',
} as const;

export const code_scanning_alert_classificationSchema = {
  description: 'A classification of the file. For example to identify it as generated.',
  enum: ['source', 'generated', 'test', 'library'],
  nullable: true,
  type: 'string',
} as const;

export const code_scanning_alert_dismissed_commentSchema = {
  description: 'The dismissal comment associated with the dismissal of the alert.',
  maxLength: 280,
  nullable: true,
  type: 'string',
} as const;

export const code_scanning_alert_dismissed_reasonSchema = {
  description: '**Required when the state is dismissed.** The reason for dismissing or closing the alert.',
  enum: [null, 'false positive', "won't fix", 'used in tests'],
  nullable: true,
  type: 'string',
} as const;

export const code_scanning_alert_environmentSchema = {
  description:
    'Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.',
  type: 'string',
} as const;

export const code_scanning_alert_instanceSchema = {
  properties: {
    analysis_key: {
      $ref: '#/components/schemas/code-scanning-analysis-analysis-key',
    },
    category: {
      $ref: '#/components/schemas/code-scanning-analysis-category',
    },
    classifications: {
      description: `Classifications that have been applied to the file that triggered the alert.
For example identifying it as documentation, or a generated file.`,
      items: {
        $ref: '#/components/schemas/code-scanning-alert-classification',
      },
      type: 'array',
    },
    commit_sha: {
      type: 'string',
    },
    environment: {
      $ref: '#/components/schemas/code-scanning-alert-environment',
    },
    html_url: {
      type: 'string',
    },
    location: {
      $ref: '#/components/schemas/code-scanning-alert-location',
    },
    message: {
      properties: {
        text: {
          type: 'string',
        },
      },
      type: 'object',
    },
    ref: {
      $ref: '#/components/schemas/code-scanning-ref',
    },
    state: {
      $ref: '#/components/schemas/code-scanning-alert-state',
    },
  },
  type: 'object',
} as const;

export const code_scanning_alert_itemsSchema = {
  properties: {
    created_at: {
      $ref: '#/components/schemas/alert-created-at',
    },
    dismissed_at: {
      $ref: '#/components/schemas/alert-dismissed-at',
    },
    dismissed_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    dismissed_comment: {
      $ref: '#/components/schemas/code-scanning-alert-dismissed-comment',
    },
    dismissed_reason: {
      $ref: '#/components/schemas/code-scanning-alert-dismissed-reason',
    },
    fixed_at: {
      $ref: '#/components/schemas/alert-fixed-at',
    },
    html_url: {
      $ref: '#/components/schemas/alert-html-url',
    },
    instances_url: {
      $ref: '#/components/schemas/alert-instances-url',
    },
    most_recent_instance: {
      $ref: '#/components/schemas/code-scanning-alert-instance',
    },
    number: {
      $ref: '#/components/schemas/alert-number',
    },
    rule: {
      $ref: '#/components/schemas/code-scanning-alert-rule-summary',
    },
    state: {
      $ref: '#/components/schemas/code-scanning-alert-state',
    },
    tool: {
      $ref: '#/components/schemas/code-scanning-analysis-tool',
    },
    updated_at: {
      $ref: '#/components/schemas/alert-updated-at',
    },
    url: {
      $ref: '#/components/schemas/alert-url',
    },
  },
  required: [
    'number',
    'created_at',
    'url',
    'html_url',
    'instances_url',
    'state',
    'dismissed_by',
    'dismissed_at',
    'dismissed_reason',
    'rule',
    'tool',
    'most_recent_instance',
  ],
  type: 'object',
} as const;

export const code_scanning_alert_locationSchema = {
  description: 'Describe a region within a file for the alert.',
  properties: {
    end_column: {
      type: 'integer',
    },
    end_line: {
      type: 'integer',
    },
    path: {
      type: 'string',
    },
    start_column: {
      type: 'integer',
    },
    start_line: {
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const code_scanning_alert_ruleSchema = {
  properties: {
    description: {
      description: 'A short description of the rule used to detect the alert.',
      type: 'string',
    },
    full_description: {
      description: 'description of the rule used to detect the alert.',
      type: 'string',
    },
    help: {
      description: 'Detailed documentation for the rule as GitHub Flavored Markdown.',
      nullable: true,
      type: 'string',
    },
    help_uri: {
      description: 'A link to the documentation for the rule used to detect the alert.',
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'A unique identifier for the rule used to detect the alert.',
      nullable: true,
      type: 'string',
    },
    name: {
      description: 'The name of the rule used to detect the alert.',
      type: 'string',
    },
    security_severity_level: {
      description: 'The security severity of the alert.',
      enum: ['low', 'medium', 'high', 'critical'],
      nullable: true,
      type: 'string',
    },
    severity: {
      description: 'The severity of the alert.',
      enum: ['none', 'note', 'warning', 'error'],
      nullable: true,
      type: 'string',
    },
    tags: {
      description: 'A set of tags applicable for the rule.',
      items: {
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const code_scanning_alert_rule_summarySchema = {
  properties: {
    description: {
      description: 'A short description of the rule used to detect the alert.',
      type: 'string',
    },
    id: {
      description: 'A unique identifier for the rule used to detect the alert.',
      nullable: true,
      type: 'string',
    },
    name: {
      description: 'The name of the rule used to detect the alert.',
      type: 'string',
    },
    severity: {
      description: 'The severity of the alert.',
      enum: ['none', 'note', 'warning', 'error'],
      nullable: true,
      type: 'string',
    },
    tags: {
      description: 'A set of tags applicable for the rule.',
      items: {
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const code_scanning_alert_set_stateSchema = {
  description:
    'Sets the state of the code scanning alert. You must provide `dismissed_reason` when you set the state to `dismissed`.',
  enum: ['open', 'dismissed'],
  type: 'string',
} as const;

export const code_scanning_alert_severitySchema = {
  description: 'Severity of a code scanning alert.',
  enum: ['critical', 'high', 'medium', 'low', 'warning', 'note', 'error'],
  type: 'string',
} as const;

export const code_scanning_alert_stateSchema = {
  description: 'State of a code scanning alert.',
  enum: ['open', 'closed', 'dismissed', 'fixed'],
  type: 'string',
} as const;

export const code_scanning_analysisSchema = {
  properties: {
    analysis_key: {
      $ref: '#/components/schemas/code-scanning-analysis-analysis-key',
    },
    category: {
      $ref: '#/components/schemas/code-scanning-analysis-category',
    },
    commit_sha: {
      $ref: '#/components/schemas/code-scanning-analysis-commit-sha',
    },
    created_at: {
      $ref: '#/components/schemas/code-scanning-analysis-created-at',
    },
    deletable: {
      type: 'boolean',
    },
    environment: {
      $ref: '#/components/schemas/code-scanning-analysis-environment',
    },
    error: {
      example: 'error reading field xyz',
      type: 'string',
    },
    id: {
      description: 'Unique identifier for this analysis.',
      type: 'integer',
    },
    ref: {
      $ref: '#/components/schemas/code-scanning-ref',
    },
    results_count: {
      description: 'The total number of results in the analysis.',
      type: 'integer',
    },
    rules_count: {
      description: 'The total number of rules used in the analysis.',
      type: 'integer',
    },
    sarif_id: {
      $ref: '#/components/schemas/code-scanning-analysis-sarif-id',
    },
    tool: {
      $ref: '#/components/schemas/code-scanning-analysis-tool',
    },
    url: {
      $ref: '#/components/schemas/code-scanning-analysis-url',
    },
    warning: {
      description: 'Warning generated when processing the analysis',
      example: '123 results were ignored',
      type: 'string',
    },
  },
  required: [
    'ref',
    'commit_sha',
    'analysis_key',
    'environment',
    'error',
    'created_at',
    'results_count',
    'rules_count',
    'id',
    'url',
    'sarif_id',
    'tool',
    'deletable',
    'warning',
  ],
  type: 'object',
} as const;

export const code_scanning_analysis_analysis_keySchema = {
  description:
    'Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.',
  type: 'string',
} as const;

export const code_scanning_analysis_categorySchema = {
  description:
    'Identifies the configuration under which the analysis was executed. Used to distinguish between multiple analyses for the same tool and commit, but performed on different languages or different parts of the code.',
  type: 'string',
} as const;

export const code_scanning_analysis_commit_shaSchema = {
  description: 'The SHA of the commit to which the analysis you are uploading relates.',
  maxLength: 40,
  minLength: 40,
  pattern: '^[0-9a-fA-F]+$',
  type: 'string',
} as const;

export const code_scanning_analysis_created_atSchema = {
  description: 'The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
  format: 'date-time',
  readOnly: true,
  type: 'string',
} as const;

export const code_scanning_analysis_deletionSchema = {
  description: 'Successful deletion of a code scanning analysis',
  properties: {
    confirm_delete_url: {
      description: 'Next deletable analysis in chain, with last analysis deletion confirmation',
      format: 'uri',
      nullable: true,
      readOnly: true,
      type: 'string',
    },
    next_analysis_url: {
      description: 'Next deletable analysis in chain, without last analysis deletion confirmation',
      format: 'uri',
      nullable: true,
      readOnly: true,
      type: 'string',
    },
  },
  required: ['next_analysis_url', 'confirm_delete_url'],
  title: 'Analysis deletion',
  type: 'object',
} as const;

export const code_scanning_analysis_environmentSchema = {
  description: 'Identifies the variable values associated with the environment in which this analysis was performed.',
  type: 'string',
} as const;

export const code_scanning_analysis_sarif_fileSchema = {
  description:
    'A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string. For more information, see "[SARIF support for code scanning](https://docs.github.com/code-security/secure-coding/sarif-support-for-code-scanning)."',
  type: 'string',
} as const;

export const code_scanning_analysis_sarif_idSchema = {
  description: 'An identifier for the upload.',
  example: '6c81cd8e-b078-4ac3-a3be-1dad7dbd0b53',
  type: 'string',
} as const;

export const code_scanning_analysis_toolSchema = {
  properties: {
    guid: {
      $ref: '#/components/schemas/code-scanning-analysis-tool-guid',
    },
    name: {
      $ref: '#/components/schemas/code-scanning-analysis-tool-name',
    },
    version: {
      $ref: '#/components/schemas/code-scanning-analysis-tool-version',
    },
  },
  type: 'object',
} as const;

export const code_scanning_analysis_tool_guidSchema = {
  description:
    'The GUID of the tool used to generate the code scanning analysis, if provided in the uploaded SARIF data.',
  nullable: true,
  type: 'string',
} as const;

export const code_scanning_analysis_tool_nameSchema = {
  description: 'The name of the tool used to generate the code scanning analysis.',
  type: 'string',
} as const;

export const code_scanning_analysis_tool_versionSchema = {
  description: 'The version of the tool used to generate the code scanning analysis.',
  nullable: true,
  type: 'string',
} as const;

export const code_scanning_analysis_urlSchema = {
  description: 'The REST API URL of the analysis resource.',
  format: 'uri',
  readOnly: true,
  type: 'string',
} as const;

export const code_scanning_codeql_databaseSchema = {
  description: 'A CodeQL database.',
  properties: {
    content_type: {
      description: 'The MIME type of the CodeQL database file.',
      type: 'string',
    },
    created_at: {
      description:
        "The date and time at which the CodeQL database was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      format: 'date-time',
      type: 'string',
    },
    id: {
      description: 'The ID of the CodeQL database.',
      type: 'integer',
    },
    language: {
      description: 'The language of the CodeQL database.',
      type: 'string',
    },
    name: {
      description: 'The name of the CodeQL database.',
      type: 'string',
    },
    size: {
      description: 'The size of the CodeQL database file in bytes.',
      type: 'integer',
    },
    updated_at: {
      description:
        "The date and time at which the CodeQL database was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      format: 'date-time',
      type: 'string',
    },
    uploader: {
      $ref: '#/components/schemas/simple-user',
    },
    url: {
      description:
        'The URL at which to download the CodeQL database. The `Accept` header must be set to the value of the `content_type` property.',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['id', 'name', 'language', 'uploader', 'content_type', 'size', 'created_at', 'updated_at', 'url'],
  title: 'CodeQL Database',
  type: 'object',
} as const;

export const code_scanning_organization_alert_itemsSchema = {
  properties: {
    created_at: {
      $ref: '#/components/schemas/alert-created-at',
    },
    dismissed_at: {
      $ref: '#/components/schemas/alert-dismissed-at',
    },
    dismissed_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    dismissed_comment: {
      $ref: '#/components/schemas/code-scanning-alert-dismissed-comment',
    },
    dismissed_reason: {
      $ref: '#/components/schemas/code-scanning-alert-dismissed-reason',
    },
    fixed_at: {
      $ref: '#/components/schemas/alert-fixed-at',
    },
    html_url: {
      $ref: '#/components/schemas/alert-html-url',
    },
    instances_url: {
      $ref: '#/components/schemas/alert-instances-url',
    },
    most_recent_instance: {
      $ref: '#/components/schemas/code-scanning-alert-instance',
    },
    number: {
      $ref: '#/components/schemas/alert-number',
    },
    repository: {
      $ref: '#/components/schemas/simple-repository',
    },
    rule: {
      $ref: '#/components/schemas/code-scanning-alert-rule',
    },
    state: {
      $ref: '#/components/schemas/code-scanning-alert-state',
    },
    tool: {
      $ref: '#/components/schemas/code-scanning-analysis-tool',
    },
    updated_at: {
      $ref: '#/components/schemas/alert-updated-at',
    },
    url: {
      $ref: '#/components/schemas/alert-url',
    },
  },
  required: [
    'number',
    'created_at',
    'url',
    'html_url',
    'instances_url',
    'state',
    'dismissed_by',
    'dismissed_at',
    'dismissed_reason',
    'rule',
    'tool',
    'most_recent_instance',
    'repository',
  ],
  type: 'object',
} as const;

export const code_scanning_refSchema = {
  description: `The full Git reference, formatted as \`refs/heads/<branch name>\`,
\`refs/pull/<number>/merge\`, or \`refs/pull/<number>/head\`.`,
  type: 'string',
} as const;

export const code_scanning_sarifs_receiptSchema = {
  properties: {
    id: {
      $ref: '#/components/schemas/code-scanning-analysis-sarif-id',
    },
    url: {
      description: 'The REST API URL for checking the status of the upload.',
      format: 'uri',
      readOnly: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const code_scanning_sarifs_statusSchema = {
  properties: {
    analyses_url: {
      description: 'The REST API URL for getting the analyses associated with the upload.',
      format: 'uri',
      nullable: true,
      readOnly: true,
      type: 'string',
    },
    errors: {
      description: 'Any errors that ocurred during processing of the delivery.',
      items: {
        type: 'string',
      },
      nullable: true,
      readOnly: true,
      type: 'array',
    },
    processing_status: {
      description: `\`pending\` files have not yet been processed, while \`complete\` means results from the SARIF have been stored. \`failed\` files have either not been processed at all, or could only be partially processed.`,
      enum: ['pending', 'complete', 'failed'],
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const code_search_result_itemSchema = {
  description: 'Code Search Result Item',
  properties: {
    file_size: {
      type: 'integer',
    },
    git_url: {
      format: 'uri',
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    language: {
      nullable: true,
      type: 'string',
    },
    last_modified_at: {
      format: 'date-time',
      type: 'string',
    },
    line_numbers: {
      example: ['73..77', '77..78'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    name: {
      type: 'string',
    },
    path: {
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    score: {
      type: 'number',
    },
    sha: {
      type: 'string',
    },
    text_matches: {
      $ref: '#/components/schemas/search-result-text-matches',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['score', 'name', 'path', 'sha', 'git_url', 'html_url', 'url', 'repository'],
  title: 'Code Search Result Item',
  type: 'object',
} as const;

export const codeowners_errorsSchema = {
  description: "A list of errors found in a repo's CODEOWNERS file",
  properties: {
    errors: {
      items: {
        properties: {
          column: {
            description: 'The column number where this errors occurs.',
            example: 3,
            type: 'integer',
          },
          kind: {
            description: 'The type of error.',
            example: 'Invalid owner',
            type: 'string',
          },
          line: {
            description: 'The line number where this errors occurs.',
            example: 7,
            type: 'integer',
          },
          message: {
            description:
              'A human-readable description of the error, combining information from multiple fields, laid out for display in a monospaced typeface (for example, a command-line setting).',
            example: `Invalid owner on line 7:

  * user
    ^`,
            type: 'string',
          },
          path: {
            description: 'The path of the file where the error occured.',
            example: '.github/CODEOWNERS',
            type: 'string',
          },
          source: {
            description: 'The contents of the line where the error occurs.',
            example: '* user',
            type: 'string',
          },
          suggestion: {
            description:
              'Suggested action to fix the error. This will usually be `null`, but is provided for some common errors.',
            example: 'The pattern `/` will never match anything, did you mean `*` instead?',
            nullable: true,
            type: 'string',
          },
        },
        required: ['line', 'column', 'kind', 'message', 'path'],
        type: 'object',
      },
      type: 'array',
    },
  },
  required: ['errors'],
  title: 'CODEOWNERS errors',
  type: 'object',
} as const;

export const codespaceSchema = {
  description: 'A codespace.',
  properties: {
    billable_owner: {
      $ref: '#/components/schemas/simple-user',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    devcontainer_path: {
      description: 'Path to devcontainer.json from repo root used to create Codespace.',
      example: '.devcontainer/example/devcontainer.json',
      nullable: true,
      type: 'string',
    },
    display_name: {
      description: 'Display name for this codespace.',
      example: 'bookish space pancake',
      nullable: true,
      type: 'string',
    },
    environment_id: {
      description: "UUID identifying this codespace's environment.",
      example: '26a7c758-7299-4a73-b978-5a92a7ae98a0',
      nullable: true,
      type: 'string',
    },
    git_status: {
      description: "Details about the codespace's git repository.",
      properties: {
        ahead: {
          description: 'The number of commits the local repository is ahead of the remote.',
          example: 0,
          type: 'integer',
        },
        behind: {
          description: 'The number of commits the local repository is behind the remote.',
          example: 0,
          type: 'integer',
        },
        has_uncommitted_changes: {
          description: 'Whether the local repository has uncommitted changes.',
          type: 'boolean',
        },
        has_unpushed_changes: {
          description: 'Whether the local repository has unpushed changes.',
          type: 'boolean',
        },
        ref: {
          description: 'The current branch (or SHA if in detached HEAD state) of the local repository.',
          example: 'main',
          type: 'string',
        },
      },
      type: 'object',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    idle_timeout_minutes: {
      description: 'The number of minutes of inactivity after which this codespace will be automatically stopped.',
      example: 60,
      nullable: true,
      type: 'integer',
    },
    idle_timeout_notice: {
      description: 'Text to show user when codespace idle timeout minutes has been overriden by an organization policy',
      nullable: true,
      type: 'string',
    },
    last_known_stop_notice: {
      description:
        'The text to display to a user when a codespace has been stopped for a potentially actionable reason.',
      example: "you've used 100% of your spending limit for Codespaces",
      nullable: true,
      type: 'string',
    },
    last_used_at: {
      description: 'Last known time this codespace was started.',
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    location: {
      description: 'The Azure region where this codespace is located.',
      enum: ['EastUs', 'SouthEastAsia', 'WestEurope', 'WestUs2'],
      example: 'WestUs2',
      type: 'string',
    },
    machine: {
      $ref: '#/components/schemas/nullable-codespace-machine',
    },
    machines_url: {
      description: 'API URL to access available alternate machine types for this codespace.',
      format: 'uri',
      type: 'string',
    },
    name: {
      description: 'Automatically generated name of this codespace.',
      example: 'monalisa-octocat-hello-world-g4wpq6h95q',
      type: 'string',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    pending_operation: {
      description:
        'Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.',
      nullable: true,
      type: 'boolean',
    },
    pending_operation_disabled_reason: {
      description: 'Text to show user when codespace is disabled by a pending operation',
      nullable: true,
      type: 'string',
    },
    prebuild: {
      description: 'Whether the codespace was created from a prebuild.',
      example: false,
      nullable: true,
      type: 'boolean',
    },
    publish_url: {
      description: 'API URL to publish this codespace to a new repository.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    pulls_url: {
      description: 'API URL for the Pull Request associated with this codespace, if any.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    recent_folders: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    retention_expires_at: {
      description: 'When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"',
      example: '2011-01-26T20:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    retention_period_minutes: {
      description:
        'Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).',
      example: 60,
      nullable: true,
      type: 'integer',
    },
    runtime_constraints: {
      properties: {
        allowed_port_privacy_settings: {
          description: 'The privacy settings a user can select from when forwarding a port.',
          items: {
            type: 'string',
          },
          nullable: true,
          type: 'array',
        },
      },
      type: 'object',
    },
    start_url: {
      description: 'API URL to start this codespace.',
      format: 'uri',
      type: 'string',
    },
    state: {
      description: 'State of this codespace.',
      enum: [
        'Unknown',
        'Created',
        'Queued',
        'Provisioning',
        'Available',
        'Awaiting',
        'Unavailable',
        'Deleted',
        'Moved',
        'Shutdown',
        'Archived',
        'Starting',
        'ShuttingDown',
        'Failed',
        'Exporting',
        'Updating',
        'Rebuilding',
      ],
      example: 'Available',
      type: 'string',
    },
    stop_url: {
      description: 'API URL to stop this codespace.',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      description: 'API URL for this codespace.',
      format: 'uri',
      type: 'string',
    },
    web_url: {
      description: 'URL to access this codespace on the web.',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'name',
    'environment_id',
    'owner',
    'billable_owner',
    'repository',
    'machine',
    'prebuild',
    'created_at',
    'updated_at',
    'last_used_at',
    'state',
    'url',
    'git_status',
    'location',
    'idle_timeout_minutes',
    'web_url',
    'machines_url',
    'start_url',
    'stop_url',
    'pulls_url',
    'recent_folders',
  ],
  title: 'Codespace',
  type: 'object',
} as const;

export const codespace_export_detailsSchema = {
  description: 'An export of a codespace. Also, latest export details for a codespace can be fetched with id = latest',
  properties: {
    branch: {
      description: 'Name of the exported branch',
      example: 'codespace-monalisa-octocat-hello-world-g4wpq6h95q',
      nullable: true,
      type: 'string',
    },
    completed_at: {
      description: 'Completion time of the last export operation',
      example: '2021-01-01T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    export_url: {
      description: 'Url for fetching export details',
      example: 'https://api.github.com/user/codespaces/:name/exports/latest',
      type: 'string',
    },
    html_url: {
      description: 'Web url for the exported branch',
      example: 'https://github.com/octocat/hello-world/tree/:branch',
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'Id for the export details',
      example: 'latest',
      type: 'string',
    },
    sha: {
      description: 'Git commit SHA of the exported branch',
      example: 'fd95a81ca01e48ede9f39c799ecbcef817b8a3b2',
      nullable: true,
      type: 'string',
    },
    state: {
      description: 'State of the latest export',
      example: 'succeeded | failed | in_progress',
      nullable: true,
      type: 'string',
    },
  },
  title: 'Fetches information about an export of a codespace.',
  type: 'object',
} as const;

export const codespace_machineSchema = {
  description: 'A description of the machine powering a codespace.',
  properties: {
    cpus: {
      description: 'How many cores are available to the codespace.',
      example: 4,
      type: 'integer',
    },
    display_name: {
      description: 'The display name of the machine includes cores, memory, and storage.',
      example: '4 cores, 8 GB RAM, 64 GB storage',
      type: 'string',
    },
    memory_in_bytes: {
      description: 'How much memory is available to the codespace.',
      example: 8589934592,
      type: 'integer',
    },
    name: {
      description: 'The name of the machine.',
      example: 'standardLinux',
      type: 'string',
    },
    operating_system: {
      description: 'The operating system of the machine.',
      example: 'linux',
      type: 'string',
    },
    prebuild_availability: {
      description:
        'Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.',
      enum: ['none', 'ready', 'in_progress'],
      example: 'ready',
      nullable: true,
      type: 'string',
    },
    storage_in_bytes: {
      description: 'How much storage is available to the codespace.',
      example: 68719476736,
      type: 'integer',
    },
  },
  required: [
    'name',
    'display_name',
    'operating_system',
    'storage_in_bytes',
    'memory_in_bytes',
    'cpus',
    'prebuild_availability',
  ],
  title: 'Codespace machine',
  type: 'object',
} as const;

export const codespace_with_full_repositorySchema = {
  description: 'A codespace.',
  properties: {
    billable_owner: {
      $ref: '#/components/schemas/simple-user',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    devcontainer_path: {
      description: 'Path to devcontainer.json from repo root used to create Codespace.',
      example: '.devcontainer/example/devcontainer.json',
      nullable: true,
      type: 'string',
    },
    display_name: {
      description: 'Display name for this codespace.',
      example: 'bookish space pancake',
      nullable: true,
      type: 'string',
    },
    environment_id: {
      description: "UUID identifying this codespace's environment.",
      example: '26a7c758-7299-4a73-b978-5a92a7ae98a0',
      nullable: true,
      type: 'string',
    },
    git_status: {
      description: "Details about the codespace's git repository.",
      properties: {
        ahead: {
          description: 'The number of commits the local repository is ahead of the remote.',
          example: 0,
          type: 'integer',
        },
        behind: {
          description: 'The number of commits the local repository is behind the remote.',
          example: 0,
          type: 'integer',
        },
        has_uncommitted_changes: {
          description: 'Whether the local repository has uncommitted changes.',
          type: 'boolean',
        },
        has_unpushed_changes: {
          description: 'Whether the local repository has unpushed changes.',
          type: 'boolean',
        },
        ref: {
          description: 'The current branch (or SHA if in detached HEAD state) of the local repository.',
          example: 'main',
          type: 'string',
        },
      },
      type: 'object',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    idle_timeout_minutes: {
      description: 'The number of minutes of inactivity after which this codespace will be automatically stopped.',
      example: 60,
      nullable: true,
      type: 'integer',
    },
    idle_timeout_notice: {
      description: 'Text to show user when codespace idle timeout minutes has been overriden by an organization policy',
      nullable: true,
      type: 'string',
    },
    last_used_at: {
      description: 'Last known time this codespace was started.',
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    location: {
      description: 'The Azure region where this codespace is located.',
      enum: ['EastUs', 'SouthEastAsia', 'WestEurope', 'WestUs2'],
      example: 'WestUs2',
      type: 'string',
    },
    machine: {
      $ref: '#/components/schemas/nullable-codespace-machine',
    },
    machines_url: {
      description: 'API URL to access available alternate machine types for this codespace.',
      format: 'uri',
      type: 'string',
    },
    name: {
      description: 'Automatically generated name of this codespace.',
      example: 'monalisa-octocat-hello-world-g4wpq6h95q',
      type: 'string',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    pending_operation: {
      description:
        'Whether or not a codespace has a pending async operation. This would mean that the codespace is temporarily unavailable. The only thing that you can do with a codespace in this state is delete it.',
      nullable: true,
      type: 'boolean',
    },
    pending_operation_disabled_reason: {
      description: 'Text to show user when codespace is disabled by a pending operation',
      nullable: true,
      type: 'string',
    },
    prebuild: {
      description: 'Whether the codespace was created from a prebuild.',
      example: false,
      nullable: true,
      type: 'boolean',
    },
    publish_url: {
      description: 'API URL to publish this codespace to a new repository.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    pulls_url: {
      description: 'API URL for the Pull Request associated with this codespace, if any.',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    recent_folders: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/full-repository',
    },
    retention_expires_at: {
      description: 'When a codespace will be auto-deleted based on the "retention_period_minutes" and "last_used_at"',
      example: '2011-01-26T20:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    retention_period_minutes: {
      description:
        'Duration in minutes after codespace has gone idle in which it will be deleted. Must be integer minutes between 0 and 43200 (30 days).',
      example: 60,
      nullable: true,
      type: 'integer',
    },
    runtime_constraints: {
      properties: {
        allowed_port_privacy_settings: {
          description: 'The privacy settings a user can select from when forwarding a port.',
          items: {
            type: 'string',
          },
          nullable: true,
          type: 'array',
        },
      },
      type: 'object',
    },
    start_url: {
      description: 'API URL to start this codespace.',
      format: 'uri',
      type: 'string',
    },
    state: {
      description: 'State of this codespace.',
      enum: [
        'Unknown',
        'Created',
        'Queued',
        'Provisioning',
        'Available',
        'Awaiting',
        'Unavailable',
        'Deleted',
        'Moved',
        'Shutdown',
        'Archived',
        'Starting',
        'ShuttingDown',
        'Failed',
        'Exporting',
        'Updating',
        'Rebuilding',
      ],
      example: 'Available',
      type: 'string',
    },
    stop_url: {
      description: 'API URL to stop this codespace.',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      description: 'API URL for this codespace.',
      format: 'uri',
      type: 'string',
    },
    web_url: {
      description: 'URL to access this codespace on the web.',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'name',
    'environment_id',
    'owner',
    'billable_owner',
    'repository',
    'machine',
    'prebuild',
    'created_at',
    'updated_at',
    'last_used_at',
    'state',
    'url',
    'git_status',
    'location',
    'idle_timeout_minutes',
    'web_url',
    'machines_url',
    'start_url',
    'stop_url',
    'pulls_url',
    'recent_folders',
  ],
  title: 'Codespace',
  type: 'object',
} as const;

export const codespaces_org_secretSchema = {
  description: 'Secrets for a GitHub Codespace.',
  properties: {
    created_at: {
      description: "The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      format: 'date-time',
      type: 'string',
    },
    name: {
      description: 'The name of the secret',
      example: 'SECRET_NAME',
      type: 'string',
    },
    selected_repositories_url: {
      description: 'The API URL at which the list of repositories this secret is visible to can be retrieved',
      example: 'https://api.github.com/orgs/ORGANIZATION/codespaces/secrets/SECRET_NAME/repositories',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      description: "The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      format: 'date-time',
      type: 'string',
    },
    visibility: {
      description: 'The type of repositories in the organization that the secret is visible to',
      enum: ['all', 'private', 'selected'],
      type: 'string',
    },
  },
  required: ['name', 'created_at', 'updated_at', 'visibility'],
  title: 'Codespaces Secret',
  type: 'object',
} as const;

export const codespaces_public_keySchema = {
  description: 'The public key used for setting Codespaces secrets.',
  properties: {
    created_at: {
      example: '2011-01-26T19:01:12Z',
      type: 'string',
    },
    id: {
      example: 2,
      type: 'integer',
    },
    key: {
      description: 'The Base64 encoded public key.',
      example: 'hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=',
      type: 'string',
    },
    key_id: {
      description: 'The identifier for the key.',
      example: '1234567',
      type: 'string',
    },
    title: {
      example: 'ssh-rsa AAAAB3NzaC1yc2EAAA',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/user/keys/2',
      type: 'string',
    },
  },
  required: ['key_id', 'key'],
  title: 'CodespacesPublicKey',
  type: 'object',
} as const;

export const codespaces_secretSchema = {
  description: 'Secrets for a GitHub Codespace.',
  properties: {
    created_at: {
      description: "The date and time at which the secret was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      format: 'date-time',
      type: 'string',
    },
    name: {
      description: 'The name of the secret',
      example: 'SECRET_NAME',
      type: 'string',
    },
    selected_repositories_url: {
      description: 'The API URL at which the list of repositories this secret is visible to can be retrieved',
      example: 'https://api.github.com/user/secrets/SECRET_NAME/repositories',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      description:
        "The date and time at which the secret was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      format: 'date-time',
      type: 'string',
    },
    visibility: {
      description: 'The type of repositories in the organization that the secret is visible to',
      enum: ['all', 'private', 'selected'],
      type: 'string',
    },
  },
  required: ['name', 'created_at', 'updated_at', 'visibility', 'selected_repositories_url'],
  title: 'Codespaces Secret',
  type: 'object',
} as const;

export const codespaces_user_public_keySchema = {
  description: "The public key used for setting user Codespaces' Secrets.",
  properties: {
    key: {
      description: 'The Base64 encoded public key.',
      example: 'hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=',
      type: 'string',
    },
    key_id: {
      description: 'The identifier for the key.',
      example: '1234567',
      type: 'string',
    },
  },
  required: ['key_id', 'key'],
  title: 'CodespacesUserPublicKey',
  type: 'object',
} as const;

export const collaboratorSchema = {
  description: 'Collaborator',
  properties: {
    avatar_url: {
      example: 'https://github.com/images/error/octocat_happy.gif',
      format: 'uri',
      type: 'string',
    },
    email: {
      nullable: true,
      type: 'string',
    },
    events_url: {
      example: 'https://api.github.com/users/octocat/events{/privacy}',
      type: 'string',
    },
    followers_url: {
      example: 'https://api.github.com/users/octocat/followers',
      format: 'uri',
      type: 'string',
    },
    following_url: {
      example: 'https://api.github.com/users/octocat/following{/other_user}',
      type: 'string',
    },
    gists_url: {
      example: 'https://api.github.com/users/octocat/gists{/gist_id}',
      type: 'string',
    },
    gravatar_id: {
      example: '41d064eb2195891e12d0413f63227ea7',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    login: {
      example: 'octocat',
      type: 'string',
    },
    name: {
      nullable: true,
      type: 'string',
    },
    node_id: {
      example: 'MDQ6VXNlcjE=',
      type: 'string',
    },
    organizations_url: {
      example: 'https://api.github.com/users/octocat/orgs',
      format: 'uri',
      type: 'string',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      required: ['pull', 'push', 'admin'],
      type: 'object',
    },
    received_events_url: {
      example: 'https://api.github.com/users/octocat/received_events',
      format: 'uri',
      type: 'string',
    },
    repos_url: {
      example: 'https://api.github.com/users/octocat/repos',
      format: 'uri',
      type: 'string',
    },
    role_name: {
      example: 'admin',
      type: 'string',
    },
    site_admin: {
      type: 'boolean',
    },
    starred_url: {
      example: 'https://api.github.com/users/octocat/starred{/owner}{/repo}',
      type: 'string',
    },
    subscriptions_url: {
      example: 'https://api.github.com/users/octocat/subscriptions',
      format: 'uri',
      type: 'string',
    },
    type: {
      example: 'User',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/users/octocat',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'avatar_url',
    'events_url',
    'followers_url',
    'following_url',
    'gists_url',
    'gravatar_id',
    'html_url',
    'id',
    'node_id',
    'login',
    'organizations_url',
    'received_events_url',
    'repos_url',
    'site_admin',
    'starred_url',
    'subscriptions_url',
    'type',
    'url',
    'role_name',
  ],
  title: 'Collaborator',
  type: 'object',
} as const;

export const combined_billing_usageSchema = {
  properties: {
    days_left_in_billing_cycle: {
      description: 'Numbers of days left in billing cycle.',
      type: 'integer',
    },
    estimated_paid_storage_for_month: {
      description: 'Estimated storage space (GB) used in billing cycle.',
      type: 'integer',
    },
    estimated_storage_for_month: {
      description: 'Estimated sum of free and paid storage space (GB) used in billing cycle.',
      type: 'integer',
    },
  },
  required: ['days_left_in_billing_cycle', 'estimated_paid_storage_for_month', 'estimated_storage_for_month'],
  type: 'object',
} as const;

export const combined_commit_statusSchema = {
  description: 'Combined Commit Status',
  properties: {
    commit_url: {
      format: 'uri',
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    sha: {
      type: 'string',
    },
    state: {
      type: 'string',
    },
    statuses: {
      items: {
        $ref: '#/components/schemas/simple-commit-status',
      },
      type: 'array',
    },
    total_count: {
      type: 'integer',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['state', 'sha', 'total_count', 'statuses', 'repository', 'commit_url', 'url'],
  title: 'Combined Commit Status',
  type: 'object',
} as const;

export const commitSchema = {
  description: 'Commit',
  properties: {
    author: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    comments_url: {
      example:
        'https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e/comments',
      format: 'uri',
      type: 'string',
    },
    commit: {
      properties: {
        author: {
          $ref: '#/components/schemas/nullable-git-user',
        },
        comment_count: {
          example: 0,
          type: 'integer',
        },
        committer: {
          $ref: '#/components/schemas/nullable-git-user',
        },
        message: {
          example: 'Fix all the bugs',
          type: 'string',
        },
        tree: {
          properties: {
            sha: {
              example: '827efc6d56897b048c772eb4087f854f46256132',
              type: 'string',
            },
            url: {
              example: 'https://api.github.com/repos/octocat/Hello-World/tree/827efc6d56897b048c772eb4087f854f46256132',
              format: 'uri',
              type: 'string',
            },
          },
          required: ['sha', 'url'],
          type: 'object',
        },
        url: {
          example: 'https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e',
          format: 'uri',
          type: 'string',
        },
        verification: {
          $ref: '#/components/schemas/verification',
        },
      },
      required: ['author', 'committer', 'comment_count', 'message', 'tree', 'url'],
      type: 'object',
    },
    committer: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    files: {
      items: {
        $ref: '#/components/schemas/diff-entry',
      },
      type: 'array',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/commit/6dcb09b5b57875f334f61aebed695e2e4193db5e',
      format: 'uri',
      type: 'string',
    },
    node_id: {
      example: 'MDY6Q29tbWl0NmRjYjA5YjViNTc4NzVmMzM0ZjYxYWViZWQ2OTVlMmU0MTkzZGI1ZQ==',
      type: 'string',
    },
    parents: {
      items: {
        properties: {
          html_url: {
            example: 'https://github.com/octocat/Hello-World/commit/7638417db6d59f3c431d3e1f261cc637155684cd',
            format: 'uri',
            type: 'string',
          },
          sha: {
            example: '7638417db6d59f3c431d3e1f261cc637155684cd',
            type: 'string',
          },
          url: {
            example:
              'https://api.github.com/repos/octocat/Hello-World/commits/7638417db6d59f3c431d3e1f261cc637155684cd',
            format: 'uri',
            type: 'string',
          },
        },
        required: ['sha', 'url'],
        type: 'object',
      },
      type: 'array',
    },
    sha: {
      example: '6dcb09b5b57875f334f61aebed695e2e4193db5e',
      type: 'string',
    },
    stats: {
      properties: {
        additions: {
          type: 'integer',
        },
        deletions: {
          type: 'integer',
        },
        total: {
          type: 'integer',
        },
      },
      type: 'object',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'sha', 'node_id', 'html_url', 'comments_url', 'commit', 'author', 'committer', 'parents'],
  title: 'Commit',
  type: 'object',
} as const;

export const commit_activitySchema = {
  description: 'Commit Activity',
  properties: {
    days: {
      example: [0, 3, 26, 20, 39, 1, 0],
      items: {
        type: 'integer',
      },
      type: 'array',
    },
    total: {
      example: 89,
      type: 'integer',
    },
    week: {
      example: 1336280400,
      type: 'integer',
    },
  },
  required: ['days', 'total', 'week'],
  title: 'Commit Activity',
  type: 'object',
} as const;

export const commit_commentSchema = {
  description: 'Commit Comment',
  properties: {
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      type: 'string',
    },
    commit_id: {
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    line: {
      nullable: true,
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    path: {
      nullable: true,
      type: 'string',
    },
    position: {
      nullable: true,
      type: 'integer',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    'url',
    'html_url',
    'id',
    'node_id',
    'user',
    'position',
    'line',
    'path',
    'commit_id',
    'body',
    'author_association',
    'created_at',
    'updated_at',
  ],
  title: 'Commit Comment',
  type: 'object',
} as const;

export const commit_comparisonSchema = {
  description: 'Commit Comparison',
  properties: {
    ahead_by: {
      example: 4,
      type: 'integer',
    },
    base_commit: {
      $ref: '#/components/schemas/commit',
    },
    behind_by: {
      example: 5,
      type: 'integer',
    },
    commits: {
      items: {
        $ref: '#/components/schemas/commit',
      },
      type: 'array',
    },
    diff_url: {
      example: 'https://github.com/octocat/Hello-World/compare/master...topic.diff',
      format: 'uri',
      type: 'string',
    },
    files: {
      items: {
        $ref: '#/components/schemas/diff-entry',
      },
      type: 'array',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/compare/master...topic',
      format: 'uri',
      type: 'string',
    },
    merge_base_commit: {
      $ref: '#/components/schemas/commit',
    },
    patch_url: {
      example: 'https://github.com/octocat/Hello-World/compare/master...topic.patch',
      format: 'uri',
      type: 'string',
    },
    permalink_url: {
      example:
        'https://github.com/octocat/Hello-World/compare/octocat:bbcd538c8e72b8c175046e27cc8f907076331401...octocat:0328041d1152db8ae77652d1618a02e57f745f17',
      format: 'uri',
      type: 'string',
    },
    status: {
      enum: ['diverged', 'ahead', 'behind', 'identical'],
      example: 'ahead',
      type: 'string',
    },
    total_commits: {
      example: 6,
      type: 'integer',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/compare/master...topic',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'url',
    'html_url',
    'permalink_url',
    'diff_url',
    'patch_url',
    'base_commit',
    'merge_base_commit',
    'status',
    'ahead_by',
    'behind_by',
    'total_commits',
    'commits',
  ],
  title: 'Commit Comparison',
  type: 'object',
} as const;

export const commit_search_result_itemSchema = {
  description: 'Commit Search Result Item',
  properties: {
    author: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    comments_url: {
      format: 'uri',
      type: 'string',
    },
    commit: {
      properties: {
        author: {
          properties: {
            date: {
              format: 'date-time',
              type: 'string',
            },
            email: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
          },
          required: ['name', 'email', 'date'],
          type: 'object',
        },
        comment_count: {
          type: 'integer',
        },
        committer: {
          $ref: '#/components/schemas/nullable-git-user',
        },
        message: {
          type: 'string',
        },
        tree: {
          properties: {
            sha: {
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['sha', 'url'],
          type: 'object',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
        verification: {
          $ref: '#/components/schemas/verification',
        },
      },
      required: ['author', 'committer', 'comment_count', 'message', 'tree', 'url'],
      type: 'object',
    },
    committer: {
      $ref: '#/components/schemas/nullable-git-user',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    parents: {
      items: {
        properties: {
          html_url: {
            type: 'string',
          },
          sha: {
            type: 'string',
          },
          url: {
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    score: {
      type: 'number',
    },
    sha: {
      type: 'string',
    },
    text_matches: {
      $ref: '#/components/schemas/search-result-text-matches',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'sha',
    'node_id',
    'url',
    'html_url',
    'author',
    'committer',
    'parents',
    'comments_url',
    'commit',
    'repository',
    'score',
  ],
  title: 'Commit Search Result Item',
  type: 'object',
} as const;

export const community_profileSchema = {
  description: 'Community Profile',
  properties: {
    content_reports_enabled: {
      example: true,
      type: 'boolean',
    },
    description: {
      example: 'My first repository on GitHub!',
      nullable: true,
      type: 'string',
    },
    documentation: {
      example: 'example.com',
      nullable: true,
      type: 'string',
    },
    files: {
      properties: {
        code_of_conduct: {
          $ref: '#/components/schemas/nullable-code-of-conduct-simple',
        },
        code_of_conduct_file: {
          $ref: '#/components/schemas/nullable-community-health-file',
        },
        contributing: {
          $ref: '#/components/schemas/nullable-community-health-file',
        },
        issue_template: {
          $ref: '#/components/schemas/nullable-community-health-file',
        },
        license: {
          $ref: '#/components/schemas/nullable-license-simple',
        },
        pull_request_template: {
          $ref: '#/components/schemas/nullable-community-health-file',
        },
        readme: {
          $ref: '#/components/schemas/nullable-community-health-file',
        },
      },
      required: [
        'code_of_conduct',
        'code_of_conduct_file',
        'license',
        'contributing',
        'readme',
        'issue_template',
        'pull_request_template',
      ],
      type: 'object',
    },
    health_percentage: {
      example: 100,
      type: 'integer',
    },
    updated_at: {
      example: '2017-02-28T19:09:29Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
  },
  required: ['health_percentage', 'description', 'documentation', 'files', 'updated_at'],
  title: 'Community Profile',
  type: 'object',
} as const;

export const content_directorySchema = {
  description: 'A list of directory items',
  items: {
    properties: {
      _links: {
        properties: {
          git: {
            format: 'uri',
            nullable: true,
            type: 'string',
          },
          html: {
            format: 'uri',
            nullable: true,
            type: 'string',
          },
          self: {
            format: 'uri',
            type: 'string',
          },
        },
        required: ['git', 'html', 'self'],
        type: 'object',
      },
      content: {
        type: 'string',
      },
      download_url: {
        format: 'uri',
        nullable: true,
        type: 'string',
      },
      git_url: {
        format: 'uri',
        nullable: true,
        type: 'string',
      },
      html_url: {
        format: 'uri',
        nullable: true,
        type: 'string',
      },
      name: {
        type: 'string',
      },
      path: {
        type: 'string',
      },
      sha: {
        type: 'string',
      },
      size: {
        type: 'integer',
      },
      type: {
        enum: ['dir', 'file', 'submodule', 'symlink'],
        type: 'string',
      },
      url: {
        format: 'uri',
        type: 'string',
      },
    },
    required: ['_links', 'git_url', 'html_url', 'download_url', 'name', 'path', 'sha', 'size', 'type', 'url'],
    type: 'object',
  },
  title: 'Content Directory',
  type: 'array',
} as const;

export const content_fileSchema = {
  description: 'Content File',
  properties: {
    _links: {
      properties: {
        git: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        html: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        self: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['git', 'html', 'self'],
      type: 'object',
    },
    content: {
      type: 'string',
    },
    download_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    encoding: {
      type: 'string',
    },
    git_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    html_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      type: 'string',
    },
    path: {
      type: 'string',
    },
    sha: {
      type: 'string',
    },
    size: {
      type: 'integer',
    },
    submodule_git_url: {
      example: '"git://example.com/defunkt/dotjs.git"',
      type: 'string',
    },
    target: {
      example: '"actual/actual.md"',
      type: 'string',
    },
    type: {
      enum: ['file'],
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    '_links',
    'git_url',
    'html_url',
    'download_url',
    'name',
    'path',
    'sha',
    'size',
    'type',
    'url',
    'content',
    'encoding',
  ],
  title: 'Content File',
  type: 'object',
} as const;

export const content_submoduleSchema = {
  description: 'An object describing a submodule',
  properties: {
    _links: {
      properties: {
        git: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        html: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        self: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['git', 'html', 'self'],
      type: 'object',
    },
    download_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    git_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    html_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      type: 'string',
    },
    path: {
      type: 'string',
    },
    sha: {
      type: 'string',
    },
    size: {
      type: 'integer',
    },
    submodule_git_url: {
      format: 'uri',
      type: 'string',
    },
    type: {
      enum: ['submodule'],
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    '_links',
    'git_url',
    'html_url',
    'download_url',
    'name',
    'path',
    'sha',
    'size',
    'type',
    'url',
    'submodule_git_url',
  ],
  title: 'Submodule Content',
  type: 'object',
} as const;

export const content_symlinkSchema = {
  description: 'An object describing a symlink',
  properties: {
    _links: {
      properties: {
        git: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        html: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        self: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['git', 'html', 'self'],
      type: 'object',
    },
    download_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    git_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    html_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      type: 'string',
    },
    path: {
      type: 'string',
    },
    sha: {
      type: 'string',
    },
    size: {
      type: 'integer',
    },
    target: {
      type: 'string',
    },
    type: {
      enum: ['symlink'],
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['_links', 'git_url', 'html_url', 'download_url', 'name', 'path', 'sha', 'size', 'type', 'url', 'target'],
  title: 'Symlink Content',
  type: 'object',
} as const;

export const content_trafficSchema = {
  description: 'Content Traffic',
  properties: {
    count: {
      example: 3542,
      type: 'integer',
    },
    path: {
      example: '/github/hubot',
      type: 'string',
    },
    title: {
      example: 'github/hubot: A customizable life embetterment robot.',
      type: 'string',
    },
    uniques: {
      example: 2225,
      type: 'integer',
    },
  },
  required: ['path', 'title', 'uniques', 'count'],
  title: 'Content Traffic',
  type: 'object',
} as const;

export const content_treeSchema = {
  description: 'Content Tree',
  properties: {
    _links: {
      properties: {
        git: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        html: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        self: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['git', 'html', 'self'],
      type: 'object',
    },
    download_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    entries: {
      items: {
        properties: {
          _links: {
            properties: {
              git: {
                format: 'uri',
                nullable: true,
                type: 'string',
              },
              html: {
                format: 'uri',
                nullable: true,
                type: 'string',
              },
              self: {
                format: 'uri',
                type: 'string',
              },
            },
            required: ['git', 'html', 'self'],
            type: 'object',
          },
          content: {
            type: 'string',
          },
          download_url: {
            format: 'uri',
            nullable: true,
            type: 'string',
          },
          git_url: {
            format: 'uri',
            nullable: true,
            type: 'string',
          },
          html_url: {
            format: 'uri',
            nullable: true,
            type: 'string',
          },
          name: {
            type: 'string',
          },
          path: {
            type: 'string',
          },
          sha: {
            type: 'string',
          },
          size: {
            type: 'integer',
          },
          type: {
            type: 'string',
          },
          url: {
            format: 'uri',
            type: 'string',
          },
        },
        required: ['_links', 'git_url', 'html_url', 'download_url', 'name', 'path', 'sha', 'size', 'type', 'url'],
        type: 'object',
      },
      type: 'array',
    },
    git_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    html_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      type: 'string',
    },
    path: {
      type: 'string',
    },
    sha: {
      type: 'string',
    },
    size: {
      type: 'integer',
    },
    type: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    '_links',
    'git_url',
    'html_url',
    'download_url',
    'name',
    'path',
    'sha',
    'size',
    'type',
    'url',
    'content',
    'encoding',
  ],
  title: 'Content Tree',
  type: 'object',
} as const;

export const contributorSchema = {
  description: 'Contributor',
  properties: {
    avatar_url: {
      format: 'uri',
      type: 'string',
    },
    contributions: {
      type: 'integer',
    },
    email: {
      type: 'string',
    },
    events_url: {
      type: 'string',
    },
    followers_url: {
      format: 'uri',
      type: 'string',
    },
    following_url: {
      type: 'string',
    },
    gists_url: {
      type: 'string',
    },
    gravatar_id: {
      nullable: true,
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    login: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    organizations_url: {
      format: 'uri',
      type: 'string',
    },
    received_events_url: {
      format: 'uri',
      type: 'string',
    },
    repos_url: {
      format: 'uri',
      type: 'string',
    },
    site_admin: {
      type: 'boolean',
    },
    starred_url: {
      type: 'string',
    },
    subscriptions_url: {
      format: 'uri',
      type: 'string',
    },
    type: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['contributions', 'type'],
  title: 'Contributor',
  type: 'object',
} as const;

export const contributor_activitySchema = {
  description: 'Contributor Activity',
  properties: {
    author: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    total: {
      example: 135,
      type: 'integer',
    },
    weeks: {
      example: [
        {
          a: 6898,
          c: 10,
          d: 77,
          w: '1367712000',
        },
      ],
      items: {
        properties: {
          a: {
            type: 'integer',
          },
          c: {
            type: 'integer',
          },
          d: {
            type: 'integer',
          },
          w: {
            type: 'integer',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
  },
  required: ['author', 'total', 'weeks'],
  title: 'Contributor Activity',
  type: 'object',
} as const;

export const converted_note_to_issue_issue_eventSchema = {
  description: 'Converted Note to Issue Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/integration',
    },
    project_card: {
      properties: {
        column_name: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        previous_column_name: {
          type: 'string',
        },
        project_id: {
          type: 'integer',
        },
        project_url: {
          format: 'uri',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['id', 'url', 'project_id', 'project_url', 'column_name'],
      type: 'object',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Converted Note to Issue Issue Event',
  type: 'object',
} as const;

export const demilestoned_issue_eventSchema = {
  description: 'Demilestoned Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    milestone: {
      properties: {
        title: {
          type: 'string',
        },
      },
      required: ['title'],
      type: 'object',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'milestone',
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Demilestoned Issue Event',
  type: 'object',
} as const;

export const dependabot_alertSchema = {
  additionalProperties: false,
  description: 'A Dependabot alert.',
  properties: {
    created_at: {
      $ref: '#/components/schemas/alert-created-at',
    },
    dependency: {
      description: 'Details for the vulnerable dependency.',
      properties: {
        manifest_path: {
          description: 'The full path to the dependency manifest file, relative to the root of the repository.',
          readOnly: true,
          type: 'string',
        },
        package: {
          $ref: '#/components/schemas/dependabot-alert-package',
        },
        scope: {
          description: 'The execution scope of the vulnerable dependency.',
          enum: ['development', 'runtime'],
          nullable: true,
          readOnly: true,
          type: 'string',
        },
      },
      readOnly: true,
      type: 'object',
    },
    dismissed_at: {
      $ref: '#/components/schemas/alert-dismissed-at',
    },
    dismissed_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    dismissed_comment: {
      description: "An optional comment associated with the alert's dismissal.",
      maxLength: 280,
      nullable: true,
      type: 'string',
    },
    dismissed_reason: {
      description: 'The reason that the alert was dismissed.',
      enum: ['fix_started', 'inaccurate', 'no_bandwidth', 'not_used', 'tolerable_risk'],
      nullable: true,
      type: 'string',
    },
    fixed_at: {
      $ref: '#/components/schemas/alert-fixed-at',
    },
    html_url: {
      $ref: '#/components/schemas/alert-html-url',
    },
    number: {
      $ref: '#/components/schemas/alert-number',
    },
    security_advisory: {
      $ref: '#/components/schemas/dependabot-alert-security-advisory',
    },
    security_vulnerability: {
      $ref: '#/components/schemas/dependabot-alert-security-vulnerability',
    },
    state: {
      description: 'The state of the Dependabot alert.',
      enum: ['dismissed', 'fixed', 'open'],
      readOnly: true,
      type: 'string',
    },
    updated_at: {
      $ref: '#/components/schemas/alert-updated-at',
    },
    url: {
      $ref: '#/components/schemas/alert-url',
    },
  },
  required: [
    'number',
    'state',
    'dependency',
    'security_advisory',
    'security_vulnerability',
    'url',
    'html_url',
    'created_at',
    'updated_at',
    'dismissed_at',
    'dismissed_by',
    'dismissed_reason',
    'dismissed_comment',
    'fixed_at',
  ],
  type: 'object',
} as const;

export const dependabot_alert_packageSchema = {
  additionalProperties: false,
  description: 'Details for the vulnerable package.',
  properties: {
    ecosystem: {
      description: "The package's language or package management ecosystem.",
      readOnly: true,
      type: 'string',
    },
    name: {
      description: 'The unique package name within its ecosystem.',
      readOnly: true,
      type: 'string',
    },
  },
  readOnly: true,
  required: ['ecosystem', 'name'],
  type: 'object',
} as const;

export const dependabot_alert_security_advisorySchema = {
  additionalProperties: false,
  description: 'Details for the GitHub Security Advisory.',
  properties: {
    cve_id: {
      description: 'The unique CVE ID assigned to the advisory.',
      nullable: true,
      readOnly: true,
      type: 'string',
    },
    cvss: {
      additionalProperties: false,
      description: 'Details for the advisory pertaining to the Common Vulnerability Scoring System.',
      properties: {
        score: {
          description: 'The overall CVSS score of the advisory.',
          maximum: 10,
          minimum: 0,
          readOnly: true,
          type: 'number',
        },
        vector_string: {
          description: 'The full CVSS vector string for the advisory.',
          nullable: true,
          readOnly: true,
          type: 'string',
        },
      },
      readOnly: true,
      required: ['score', 'vector_string'],
      type: 'object',
    },
    cwes: {
      description: 'Details for the advisory pertaining to Common Weakness Enumeration.',
      items: {
        additionalProperties: false,
        description: 'A CWE weakness assigned to the advisory.',
        properties: {
          cwe_id: {
            description: 'The unique CWE ID.',
            readOnly: true,
            type: 'string',
          },
          name: {
            description: 'The short, plain text name of the CWE.',
            readOnly: true,
            type: 'string',
          },
        },
        readOnly: true,
        required: ['cwe_id', 'name'],
        type: 'object',
      },
      readOnly: true,
      type: 'array',
    },
    description: {
      description: 'A long-form Markdown-supported description of the advisory.',
      readOnly: true,
      type: 'string',
    },
    ghsa_id: {
      description: 'The unique GitHub Security Advisory ID assigned to the advisory.',
      readOnly: true,
      type: 'string',
    },
    identifiers: {
      description: 'Values that identify this advisory among security information sources.',
      items: {
        additionalProperties: false,
        description: 'An advisory identifier.',
        properties: {
          type: {
            description: 'The type of advisory identifier.',
            enum: ['CVE', 'GHSA'],
            readOnly: true,
            type: 'string',
          },
          value: {
            description: 'The value of the advisory identifer.',
            readOnly: true,
            type: 'string',
          },
        },
        readOnly: true,
        required: ['value', 'type'],
        type: 'object',
      },
      readOnly: true,
      type: 'array',
    },
    published_at: {
      description: 'The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
      format: 'date-time',
      readOnly: true,
      type: 'string',
    },
    references: {
      description: 'Links to additional advisory information.',
      items: {
        additionalProperties: false,
        description: 'A link to additional advisory information.',
        properties: {
          url: {
            description: 'The URL of the reference.',
            format: 'uri',
            readOnly: true,
            type: 'string',
          },
        },
        readOnly: true,
        required: ['url'],
        type: 'object',
      },
      readOnly: true,
      type: 'array',
    },
    severity: {
      description: 'The severity of the advisory.',
      enum: ['low', 'medium', 'high', 'critical'],
      readOnly: true,
      type: 'string',
    },
    summary: {
      description: 'A short, plain text summary of the advisory.',
      maxLength: 1024,
      readOnly: true,
      type: 'string',
    },
    updated_at: {
      description: 'The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
      format: 'date-time',
      readOnly: true,
      type: 'string',
    },
    vulnerabilities: {
      description: 'Vulnerable version range information for the advisory.',
      items: {
        $ref: '#/components/schemas/dependabot-alert-security-vulnerability',
      },
      readOnly: true,
      type: 'array',
    },
    withdrawn_at: {
      description: 'The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
      format: 'date-time',
      nullable: true,
      readOnly: true,
      type: 'string',
    },
  },
  readOnly: true,
  required: [
    'ghsa_id',
    'cve_id',
    'summary',
    'description',
    'vulnerabilities',
    'severity',
    'cvss',
    'cwes',
    'identifiers',
    'references',
    'published_at',
    'updated_at',
    'withdrawn_at',
  ],
  type: 'object',
} as const;

export const dependabot_alert_security_vulnerabilitySchema = {
  additionalProperties: false,
  description: 'Details pertaining to one vulnerable version range for the advisory.',
  properties: {
    first_patched_version: {
      additionalProperties: false,
      description: 'Details pertaining to the package version that patches this vulnerability.',
      nullable: true,
      properties: {
        identifier: {
          description: 'The package version that patches this vulnerability.',
          readOnly: true,
          type: 'string',
        },
      },
      readOnly: true,
      required: ['identifier'],
      type: 'object',
    },
    package: {
      $ref: '#/components/schemas/dependabot-alert-package',
    },
    severity: {
      description: 'The severity of the vulnerability.',
      enum: ['low', 'medium', 'high', 'critical'],
      readOnly: true,
      type: 'string',
    },
    vulnerable_version_range: {
      description: "Conditions that identify vulnerable versions of this vulnerability's package.",
      readOnly: true,
      type: 'string',
    },
  },
  readOnly: true,
  required: ['package', 'severity', 'vulnerable_version_range', 'first_patched_version'],
  type: 'object',
} as const;

export const dependabot_alert_with_repositorySchema = {
  additionalProperties: false,
  description: 'A Dependabot alert.',
  properties: {
    created_at: {
      $ref: '#/components/schemas/alert-created-at',
    },
    dependency: {
      description: 'Details for the vulnerable dependency.',
      properties: {
        manifest_path: {
          description: 'The full path to the dependency manifest file, relative to the root of the repository.',
          readOnly: true,
          type: 'string',
        },
        package: {
          $ref: '#/components/schemas/dependabot-alert-package',
        },
        scope: {
          description: 'The execution scope of the vulnerable dependency.',
          enum: ['development', 'runtime'],
          nullable: true,
          readOnly: true,
          type: 'string',
        },
      },
      readOnly: true,
      type: 'object',
    },
    dismissed_at: {
      $ref: '#/components/schemas/alert-dismissed-at',
    },
    dismissed_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    dismissed_comment: {
      description: "An optional comment associated with the alert's dismissal.",
      maxLength: 280,
      nullable: true,
      type: 'string',
    },
    dismissed_reason: {
      description: 'The reason that the alert was dismissed.',
      enum: ['fix_started', 'inaccurate', 'no_bandwidth', 'not_used', 'tolerable_risk'],
      nullable: true,
      type: 'string',
    },
    fixed_at: {
      $ref: '#/components/schemas/alert-fixed-at',
    },
    html_url: {
      $ref: '#/components/schemas/alert-html-url',
    },
    number: {
      $ref: '#/components/schemas/alert-number',
    },
    repository: {
      $ref: '#/components/schemas/simple-repository',
    },
    security_advisory: {
      $ref: '#/components/schemas/dependabot-alert-security-advisory',
    },
    security_vulnerability: {
      $ref: '#/components/schemas/dependabot-alert-security-vulnerability',
    },
    state: {
      description: 'The state of the Dependabot alert.',
      enum: ['dismissed', 'fixed', 'open'],
      readOnly: true,
      type: 'string',
    },
    updated_at: {
      $ref: '#/components/schemas/alert-updated-at',
    },
    url: {
      $ref: '#/components/schemas/alert-url',
    },
  },
  required: [
    'number',
    'state',
    'dependency',
    'security_advisory',
    'security_vulnerability',
    'url',
    'html_url',
    'created_at',
    'updated_at',
    'dismissed_at',
    'dismissed_by',
    'dismissed_reason',
    'dismissed_comment',
    'fixed_at',
    'repository',
  ],
  type: 'object',
} as const;

export const dependabot_public_keySchema = {
  description: 'The public key used for setting Dependabot Secrets.',
  properties: {
    key: {
      description: 'The Base64 encoded public key.',
      example: 'hBT5WZEj8ZoOv6TYJsfWq7MxTEQopZO5/IT3ZCVQPzs=',
      type: 'string',
    },
    key_id: {
      description: 'The identifier for the key.',
      example: '1234567',
      type: 'string',
    },
  },
  required: ['key_id', 'key'],
  title: 'DependabotPublicKey',
  type: 'object',
} as const;

export const dependabot_secretSchema = {
  description: 'Set secrets for Dependabot.',
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    name: {
      description: 'The name of the secret.',
      example: 'MY_ARTIFACTORY_PASSWORD',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
  },
  required: ['name', 'created_at', 'updated_at'],
  title: 'Dependabot Secret',
  type: 'object',
} as const;

export const dependencySchema = {
  additionalProperties: false,
  properties: {
    dependencies: {
      description: 'Array of package-url (PURLs) of direct child dependencies.',
      example: '@actions/http-client',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    metadata: {
      $ref: '#/components/schemas/metadata',
    },
    package_url: {
      description: 'Package-url (PURL) of dependency. See https://github.com/package-url/purl-spec for more details.',
      example: 'pkg:/npm/%40actions/http-client@1.0.11',
      pattern: '^pkg',
      type: 'string',
    },
    relationship: {
      description:
        'A notation of whether a dependency is requested directly by this manifest or is a dependency of another dependency.',
      enum: ['direct', 'indirect'],
      example: 'direct',
      type: 'string',
    },
    scope: {
      description:
        'A notation of whether the dependency is required for the primary build artifact (runtime) or is only used for development. Future versions of this specification may allow for more granular scopes.',
      enum: ['runtime', 'development'],
      example: 'runtime',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const dependency_graph_diffSchema = {
  description: 'A diff of the dependencies between two commits.',
  items: {
    properties: {
      change_type: {
        enum: ['added', 'removed'],
        type: 'string',
      },
      ecosystem: {
        example: 'npm',
        type: 'string',
      },
      license: {
        example: 'MIT',
        nullable: true,
        type: 'string',
      },
      manifest: {
        example: 'path/to/package-lock.json',
        type: 'string',
      },
      name: {
        example: '@actions/core',
        type: 'string',
      },
      package_url: {
        example: 'pkg:/npm/%40actions/core@1.1.0',
        nullable: true,
        type: 'string',
      },
      scope: {
        description:
          'Where the dependency is utilized. `development` means that the dependency is only utilized in the development environment. `runtime` means that the dependency is utilized at runtime and in the development environment.',
        enum: ['unknown', 'runtime', 'development'],
        type: 'string',
      },
      source_repository_url: {
        example: 'https://github.com/github/actions',
        nullable: true,
        type: 'string',
      },
      version: {
        example: '1.0.0',
        type: 'string',
      },
      vulnerabilities: {
        items: {
          properties: {
            advisory_ghsa_id: {
              example: 'GHSA-rf4j-j272-fj86',
              type: 'string',
            },
            advisory_summary: {
              example: 'A summary of the advisory.',
              type: 'string',
            },
            advisory_url: {
              example: 'https://github.com/advisories/GHSA-rf4j-j272-fj86',
              type: 'string',
            },
            severity: {
              example: 'critical',
              type: 'string',
            },
          },
          required: ['severity', 'advisory_ghsa_id', 'advisory_summary', 'advisory_url'],
          type: 'object',
        },
        type: 'array',
      },
    },
    required: [
      'change_type',
      'manifest',
      'ecosystem',
      'name',
      'version',
      'package_url',
      'license',
      'source_repository_url',
      'vulnerabilities',
      'scope',
    ],
    type: 'object',
  },
  title: 'Dependency Graph Diff',
  type: 'array',
} as const;

export const deploy_keySchema = {
  description: 'An SSH key granting access to a single repository.',
  properties: {
    added_by: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    key: {
      type: 'string',
    },
    last_used: {
      nullable: true,
      type: 'string',
    },
    read_only: {
      type: 'boolean',
    },
    title: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
    verified: {
      type: 'boolean',
    },
  },
  required: ['id', 'key', 'url', 'title', 'verified', 'created_at', 'read_only'],
  title: 'Deploy Key',
  type: 'object',
} as const;

export const deploymentSchema = {
  description: 'A request for a specific ref(branch,sha,tag) to be deployed',
  properties: {
    created_at: {
      example: '2012-07-20T01:19:13Z',
      format: 'date-time',
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    description: {
      example: 'Deploy request from hubot',
      nullable: true,
      type: 'string',
    },
    environment: {
      description: 'Name for the target deployment environment.',
      example: 'production',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the deployment',
      example: 42,
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOkRlcGxveW1lbnQx',
      type: 'string',
    },
    original_environment: {
      example: 'staging',
      type: 'string',
    },
    payload: {
      oneOf: [
        {
          additionalProperties: true,
          type: 'object',
        },
        {
          type: 'string',
        },
      ],
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    production_environment: {
      description: 'Specifies if the given environment is one that end-users directly interact with. Default: false.',
      example: true,
      type: 'boolean',
    },
    ref: {
      description: 'The ref to deploy. This can be a branch, tag, or sha.',
      example: 'topic-branch',
      type: 'string',
    },
    repository_url: {
      example: 'https://api.github.com/repos/octocat/example',
      format: 'uri',
      type: 'string',
    },
    sha: {
      example: 'a84d88e7554fc1fa21bcbc4efae3c782a70d2b9d',
      type: 'string',
    },
    statuses_url: {
      example: 'https://api.github.com/repos/octocat/example/deployments/1/statuses',
      format: 'uri',
      type: 'string',
    },
    task: {
      description: 'Parameter to specify a task to execute',
      example: 'deploy',
      type: 'string',
    },
    transient_environment: {
      description:
        'Specifies if the given environment is will no longer exist at some point in the future. Default: false.',
      example: true,
      type: 'boolean',
    },
    updated_at: {
      example: '2012-07-20T01:19:13Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/example/deployments/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'sha',
    'ref',
    'task',
    'environment',
    'creator',
    'payload',
    'description',
    'statuses_url',
    'repository_url',
    'url',
    'created_at',
    'updated_at',
  ],
  title: 'Deployment',
  type: 'object',
} as const;

export const deployment_branch_policySchema = {
  description: 'Details of a deployment branch policy.',
  properties: {
    id: {
      description: 'The unique identifier of the branch policy.',
      example: 361471,
      type: 'integer',
    },
    name: {
      description: 'The name pattern that branches must match in order to deploy to the environment.',
      example: 'release/*',
      type: 'string',
    },
    node_id: {
      example: 'MDE2OkdhdGVCcmFuY2hQb2xpY3kzNjE0NzE=',
      type: 'string',
    },
  },
  title: 'Deployment branch policy',
  type: 'object',
} as const;

export const deployment_branch_policy_name_patternSchema = {
  properties: {
    name: {
      description: `The name pattern that branches must match in order to deploy to the environment.

Wildcard characters will not match \`/\`. For example, to match branches that begin with \`release/\` and contain an additional single slash, use \`release/*/*\`.
For more information about pattern matching syntax, see the [Ruby File.fnmatch documentation](https://ruby-doc.org/core-2.5.1/File.html#method-c-fnmatch).`,
      example: 'release/*',
      type: 'string',
    },
  },
  required: ['name'],
  title: 'Deployment branch policy name pattern',
  type: 'object',
} as const;

export const deployment_branch_policy_settingsSchema = {
  description:
    'The type of deployment branch policy for this environment. To allow all branches to deploy, set to `null`.',
  nullable: true,
  properties: {
    custom_branch_policies: {
      description:
        'Whether only branches that match the specified name patterns can deploy to this environment.  If `custom_branch_policies` is `true`, `protected_branches` must be `false`; if `custom_branch_policies` is `false`, `protected_branches` must be `true`.',
      type: 'boolean',
    },
    protected_branches: {
      description:
        'Whether only branches with branch protection rules can deploy to this environment. If `protected_branches` is `true`, `custom_branch_policies` must be `false`; if `protected_branches` is `false`, `custom_branch_policies` must be `true`.',
      type: 'boolean',
    },
  },
  required: ['protected_branches', 'custom_branch_policies'],
  type: 'object',
} as const;

export const deployment_reviewer_typeSchema = {
  description: 'The type of reviewer.',
  enum: ['User', 'Team'],
  example: 'User',
  type: 'string',
} as const;

export const deployment_simpleSchema = {
  description:
    'A deployment created as the result of an Actions check run from a workflow that references an environment',
  properties: {
    created_at: {
      example: '2012-07-20T01:19:13Z',
      format: 'date-time',
      type: 'string',
    },
    description: {
      example: 'Deploy request from hubot',
      nullable: true,
      type: 'string',
    },
    environment: {
      description: 'Name for the target deployment environment.',
      example: 'production',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the deployment',
      example: 42,
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOkRlcGxveW1lbnQx',
      type: 'string',
    },
    original_environment: {
      example: 'staging',
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    production_environment: {
      description: 'Specifies if the given environment is one that end-users directly interact with. Default: false.',
      example: true,
      type: 'boolean',
    },
    repository_url: {
      example: 'https://api.github.com/repos/octocat/example',
      format: 'uri',
      type: 'string',
    },
    statuses_url: {
      example: 'https://api.github.com/repos/octocat/example/deployments/1/statuses',
      format: 'uri',
      type: 'string',
    },
    task: {
      description: 'Parameter to specify a task to execute',
      example: 'deploy',
      type: 'string',
    },
    transient_environment: {
      description:
        'Specifies if the given environment is will no longer exist at some point in the future. Default: false.',
      example: true,
      type: 'boolean',
    },
    updated_at: {
      example: '2012-07-20T01:19:13Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/example/deployments/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'task',
    'environment',
    'description',
    'statuses_url',
    'repository_url',
    'url',
    'created_at',
    'updated_at',
  ],
  title: 'Deployment',
  type: 'object',
} as const;

export const deployment_statusSchema = {
  description: 'The status of a deployment.',
  properties: {
    created_at: {
      example: '2012-07-20T01:19:13Z',
      format: 'date-time',
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    deployment_url: {
      example: 'https://api.github.com/repos/octocat/example/deployments/42',
      format: 'uri',
      type: 'string',
    },
    description: {
      default: '',
      description: 'A short description of the status.',
      example: 'Deployment finished successfully.',
      maxLength: 140,
      type: 'string',
    },
    environment: {
      default: '',
      description: 'The environment of the deployment that the status is for.',
      example: 'production',
      type: 'string',
    },
    environment_url: {
      default: '',
      description: 'The URL for accessing your environment.',
      example: 'https://staging.example.com/',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    log_url: {
      default: '',
      description: 'The URL to associate with this status.',
      example: 'https://example.com/deployment/42/output',
      format: 'uri',
      type: 'string',
    },
    node_id: {
      example: 'MDE2OkRlcGxveW1lbnRTdGF0dXMx',
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    repository_url: {
      example: 'https://api.github.com/repos/octocat/example',
      format: 'uri',
      type: 'string',
    },
    state: {
      description: 'The state of the status.',
      enum: ['error', 'failure', 'inactive', 'pending', 'success', 'queued', 'in_progress'],
      example: 'success',
      type: 'string',
    },
    target_url: {
      default: '',
      description: 'Deprecated: the URL to associate with this status.',
      example: 'https://example.com/deployment/42/output',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      example: '2012-07-20T01:19:13Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/example/deployments/42/statuses/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'state',
    'creator',
    'description',
    'deployment_url',
    'target_url',
    'repository_url',
    'url',
    'created_at',
    'updated_at',
  ],
  title: 'Deployment Status',
  type: 'object',
} as const;

export const diff_entrySchema = {
  description: 'Diff Entry',
  properties: {
    additions: {
      example: 103,
      type: 'integer',
    },
    blob_url: {
      example: 'https://github.com/octocat/Hello-World/blob/6dcb09b5b57875f334f61aebed695e2e4193db5e/file1.txt',
      format: 'uri',
      type: 'string',
    },
    changes: {
      example: 124,
      type: 'integer',
    },
    contents_url: {
      example:
        'https://api.github.com/repos/octocat/Hello-World/contents/file1.txt?ref=6dcb09b5b57875f334f61aebed695e2e4193db5e',
      format: 'uri',
      type: 'string',
    },
    deletions: {
      example: 21,
      type: 'integer',
    },
    filename: {
      example: 'file1.txt',
      type: 'string',
    },
    patch: {
      example: '@@ -132,7 +132,7 @@ module Test @@ -1000,7 +1000,7 @@ module Test',
      type: 'string',
    },
    previous_filename: {
      example: 'file.txt',
      type: 'string',
    },
    raw_url: {
      example: 'https://github.com/octocat/Hello-World/raw/6dcb09b5b57875f334f61aebed695e2e4193db5e/file1.txt',
      format: 'uri',
      type: 'string',
    },
    sha: {
      example: 'bbcd538c8e72b8c175046e27cc8f907076331401',
      type: 'string',
    },
    status: {
      enum: ['added', 'removed', 'modified', 'renamed', 'copied', 'changed', 'unchanged'],
      example: 'added',
      type: 'string',
    },
  },
  required: ['additions', 'blob_url', 'changes', 'contents_url', 'deletions', 'filename', 'raw_url', 'sha', 'status'],
  title: 'Diff Entry',
  type: 'object',
} as const;

export const discussionSchema = {
  description: 'A Discussion in a repository.',
  properties: {
    active_lock_reason: {
      nullable: true,
      type: 'string',
    },
    answer_chosen_at: {
      nullable: true,
      type: 'string',
    },
    answer_chosen_by: {
      nullable: true,
      properties: {
        avatar_url: {
          format: 'uri',
          type: 'string',
        },
        deleted: {
          type: 'boolean',
        },
        email: {
          nullable: true,
          type: 'string',
        },
        events_url: {
          format: 'uri-template',
          type: 'string',
        },
        followers_url: {
          format: 'uri',
          type: 'string',
        },
        following_url: {
          format: 'uri-template',
          type: 'string',
        },
        gists_url: {
          format: 'uri-template',
          type: 'string',
        },
        gravatar_id: {
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        login: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        organizations_url: {
          format: 'uri',
          type: 'string',
        },
        received_events_url: {
          format: 'uri',
          type: 'string',
        },
        repos_url: {
          format: 'uri',
          type: 'string',
        },
        site_admin: {
          type: 'boolean',
        },
        starred_url: {
          format: 'uri-template',
          type: 'string',
        },
        subscriptions_url: {
          format: 'uri',
          type: 'string',
        },
        type: {
          enum: ['Bot', 'User', 'Organization'],
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['login', 'id'],
      title: 'User',
      type: 'object',
    },
    answer_html_url: {
      nullable: true,
      type: 'string',
    },
    author_association: {
      description: 'How the author is associated with the repository.',
      enum: [
        'COLLABORATOR',
        'CONTRIBUTOR',
        'FIRST_TIMER',
        'FIRST_TIME_CONTRIBUTOR',
        'MANNEQUIN',
        'MEMBER',
        'NONE',
        'OWNER',
      ],
      title: 'AuthorAssociation',
      type: 'string',
    },
    body: {
      type: 'string',
    },
    category: {
      properties: {
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        description: {
          type: 'string',
        },
        emoji: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        is_answerable: {
          type: 'boolean',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        repository_id: {
          type: 'integer',
        },
        slug: {
          type: 'string',
        },
        updated_at: {
          type: 'string',
        },
      },
      required: [
        'id',
        'repository_id',
        'emoji',
        'name',
        'description',
        'created_at',
        'updated_at',
        'slug',
        'is_answerable',
      ],
      type: 'object',
    },
    comments: {
      type: 'integer',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    html_url: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    locked: {
      type: 'boolean',
    },
    node_id: {
      type: 'string',
    },
    number: {
      type: 'integer',
    },
    reactions: {
      properties: {
        '+1': {
          type: 'integer',
        },
        '-1': {
          type: 'integer',
        },
        confused: {
          type: 'integer',
        },
        eyes: {
          type: 'integer',
        },
        heart: {
          type: 'integer',
        },
        hooray: {
          type: 'integer',
        },
        laugh: {
          type: 'integer',
        },
        rocket: {
          type: 'integer',
        },
        total_count: {
          type: 'integer',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
      title: 'Reactions',
      type: 'object',
    },
    repository_url: {
      type: 'string',
    },
    state: {
      description: `The current state of the discussion.
\`converting\` means that the discussion is being converted from an issue.
\`transferring\` means that the discussion is being transferred from another repository.`,
      enum: ['open', 'locked', 'converting', 'transferring'],
      type: 'string',
    },
    timeline_url: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    user: {
      nullable: true,
      properties: {
        avatar_url: {
          format: 'uri',
          type: 'string',
        },
        deleted: {
          type: 'boolean',
        },
        email: {
          nullable: true,
          type: 'string',
        },
        events_url: {
          format: 'uri-template',
          type: 'string',
        },
        followers_url: {
          format: 'uri',
          type: 'string',
        },
        following_url: {
          format: 'uri-template',
          type: 'string',
        },
        gists_url: {
          format: 'uri-template',
          type: 'string',
        },
        gravatar_id: {
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        login: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        organizations_url: {
          format: 'uri',
          type: 'string',
        },
        received_events_url: {
          format: 'uri',
          type: 'string',
        },
        repos_url: {
          format: 'uri',
          type: 'string',
        },
        site_admin: {
          type: 'boolean',
        },
        starred_url: {
          format: 'uri-template',
          type: 'string',
        },
        subscriptions_url: {
          format: 'uri',
          type: 'string',
        },
        type: {
          enum: ['Bot', 'User', 'Organization'],
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['login', 'id'],
      title: 'User',
      type: 'object',
    },
  },
  required: [
    'repository_url',
    'category',
    'answer_html_url',
    'answer_chosen_at',
    'answer_chosen_by',
    'html_url',
    'id',
    'node_id',
    'number',
    'title',
    'user',
    'state',
    'locked',
    'comments',
    'created_at',
    'updated_at',
    'author_association',
    'active_lock_reason',
    'body',
  ],
  title: 'Discussion',
  type: 'object',
} as const;

export const emailSchema = {
  description: 'Email',
  properties: {
    email: {
      example: 'octocat@github.com',
      format: 'email',
      type: 'string',
    },
    primary: {
      example: true,
      type: 'boolean',
    },
    verified: {
      example: true,
      type: 'boolean',
    },
    visibility: {
      example: 'public',
      nullable: true,
      type: 'string',
    },
  },
  required: ['email', 'primary', 'verified', 'visibility'],
  title: 'Email',
  type: 'object',
} as const;

export const empty_objectSchema = {
  additionalProperties: false,
  description: 'An object without any properties.',
  properties: {},
  title: 'Empty Object',
  type: 'object',
} as const;

export const enabled_repositoriesSchema = {
  description: 'The policy that controls the repositories in the organization that are allowed to run GitHub Actions.',
  enum: ['all', 'none', 'selected'],
  type: 'string',
} as const;

export const enterpriseSchema = {
  description: 'An enterprise on GitHub.',
  properties: {
    avatar_url: {
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2019-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    description: {
      description: 'A short description of the enterprise.',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/enterprises/octo-business',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the enterprise',
      example: 42,
      type: 'integer',
    },
    name: {
      description: 'The name of the enterprise.',
      example: 'Octo Business',
      type: 'string',
    },
    node_id: {
      example: 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5',
      type: 'string',
    },
    slug: {
      description: 'The slug url identifier for the enterprise.',
      example: 'octo-business',
      type: 'string',
    },
    updated_at: {
      example: '2019-01-26T19:14:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    website_url: {
      description: "The enterprise's website URL.",
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  required: ['id', 'node_id', 'name', 'slug', 'html_url', 'created_at', 'updated_at', 'avatar_url'],
  title: 'Enterprise',
  type: 'object',
} as const;

export const environmentSchema = {
  description: 'Details of a deployment environment',
  properties: {
    created_at: {
      description: 'The time that the environment was created, in ISO 8601 format.',
      example: '2020-11-23T22:00:40Z',
      format: 'date-time',
      type: 'string',
    },
    deployment_branch_policy: {
      $ref: '#/components/schemas/deployment-branch-policy-settings',
    },
    html_url: {
      example: 'https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging',
      type: 'string',
    },
    id: {
      description: 'The id of the environment.',
      example: 56780428,
      type: 'integer',
    },
    name: {
      description: 'The name of the environment.',
      example: 'staging',
      type: 'string',
    },
    node_id: {
      example: 'MDExOkVudmlyb25tZW50NTY3ODA0Mjg=',
      type: 'string',
    },
    protection_rules: {
      items: {
        anyOf: [
          {
            properties: {
              id: {
                example: 3515,
                type: 'integer',
              },
              node_id: {
                example: 'MDQ6R2F0ZTM1MTU=',
                type: 'string',
              },
              type: {
                example: 'wait_timer',
                type: 'string',
              },
              wait_timer: {
                $ref: '#/components/schemas/wait-timer',
              },
            },
            required: ['id', 'node_id', 'type'],
            type: 'object',
          },
          {
            properties: {
              id: {
                example: 3755,
                type: 'integer',
              },
              node_id: {
                example: 'MDQ6R2F0ZTM3NTU=',
                type: 'string',
              },
              reviewers: {
                description:
                  'The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.',
                items: {
                  properties: {
                    reviewer: {
                      anyOf: [
                        {
                          $ref: '#/components/schemas/simple-user',
                        },
                        {
                          $ref: '#/components/schemas/team',
                        },
                      ],
                    },
                    type: {
                      $ref: '#/components/schemas/deployment-reviewer-type',
                    },
                  },
                  type: 'object',
                },
                type: 'array',
              },
              type: {
                example: 'required_reviewers',
                type: 'string',
              },
            },
            required: ['id', 'node_id', 'type'],
            type: 'object',
          },
          {
            properties: {
              id: {
                example: 3515,
                type: 'integer',
              },
              node_id: {
                example: 'MDQ6R2F0ZTM1MTU=',
                type: 'string',
              },
              type: {
                example: 'branch_policy',
                type: 'string',
              },
            },
            required: ['id', 'node_id', 'type'],
            type: 'object',
          },
        ],
      },
      type: 'array',
    },
    updated_at: {
      description: 'The time that the environment was last updated, in ISO 8601 format.',
      example: '2020-11-23T22:00:40Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/github/hello-world/environments/staging',
      type: 'string',
    },
  },
  required: ['id', 'node_id', 'name', 'url', 'html_url', 'created_at', 'updated_at'],
  title: 'Environment',
  type: 'object',
} as const;

export const environment_approvalsSchema = {
  description: 'An entry in the reviews log for environment deployments',
  properties: {
    comment: {
      description: 'The comment submitted with the deployment review',
      example: 'Ship it!',
      type: 'string',
    },
    environments: {
      description: 'The list of environments that were approved or rejected',
      items: {
        properties: {
          created_at: {
            description: 'The time that the environment was created, in ISO 8601 format.',
            example: '2020-11-23T22:00:40Z',
            format: 'date-time',
            type: 'string',
          },
          html_url: {
            example: 'https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging',
            type: 'string',
          },
          id: {
            description: 'The id of the environment.',
            example: 56780428,
            type: 'integer',
          },
          name: {
            description: 'The name of the environment.',
            example: 'staging',
            type: 'string',
          },
          node_id: {
            example: 'MDExOkVudmlyb25tZW50NTY3ODA0Mjg=',
            type: 'string',
          },
          updated_at: {
            description: 'The time that the environment was last updated, in ISO 8601 format.',
            example: '2020-11-23T22:00:40Z',
            format: 'date-time',
            type: 'string',
          },
          url: {
            example: 'https://api.github.com/repos/github/hello-world/environments/staging',
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    state: {
      description: 'Whether deployment to the environment(s) was approved or rejected or pending (with comments)',
      enum: ['approved', 'rejected', 'pending'],
      example: 'approved',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['environments', 'state', 'user', 'comment'],
  title: 'Environment Approval',
  type: 'object',
} as const;

export const eventSchema = {
  description: 'Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/actor',
    },
    created_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'string',
    },
    org: {
      $ref: '#/components/schemas/actor',
    },
    payload: {
      properties: {
        action: {
          type: 'string',
        },
        comment: {
          $ref: '#/components/schemas/issue-comment',
        },
        issue: {
          $ref: '#/components/schemas/issue',
        },
        pages: {
          items: {
            properties: {
              action: {
                type: 'string',
              },
              html_url: {
                type: 'string',
              },
              page_name: {
                type: 'string',
              },
              sha: {
                type: 'string',
              },
              summary: {
                nullable: true,
                type: 'string',
              },
              title: {
                type: 'string',
              },
            },
            type: 'object',
          },
          type: 'array',
        },
      },
      type: 'object',
    },
    public: {
      type: 'boolean',
    },
    repo: {
      properties: {
        id: {
          type: 'integer',
        },
        name: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['id', 'name', 'url'],
      type: 'object',
    },
    type: {
      nullable: true,
      type: 'string',
    },
  },
  required: ['id', 'type', 'actor', 'repo', 'payload', 'public', 'created_at'],
  title: 'Event',
  type: 'object',
} as const;

export const feedSchema = {
  description: 'Feed',
  properties: {
    _links: {
      properties: {
        current_user: {
          $ref: '#/components/schemas/link-with-type',
        },
        current_user_actor: {
          $ref: '#/components/schemas/link-with-type',
        },
        current_user_organization: {
          $ref: '#/components/schemas/link-with-type',
        },
        current_user_organizations: {
          items: {
            $ref: '#/components/schemas/link-with-type',
          },
          type: 'array',
        },
        current_user_public: {
          $ref: '#/components/schemas/link-with-type',
        },
        repository_discussions: {
          $ref: '#/components/schemas/link-with-type',
        },
        repository_discussions_category: {
          $ref: '#/components/schemas/link-with-type',
        },
        security_advisories: {
          $ref: '#/components/schemas/link-with-type',
        },
        timeline: {
          $ref: '#/components/schemas/link-with-type',
        },
        user: {
          $ref: '#/components/schemas/link-with-type',
        },
      },
      required: ['timeline', 'user'],
      type: 'object',
    },
    current_user_actor_url: {
      example: 'https://github.com/octocat.private.actor?token=abc123',
      type: 'string',
    },
    current_user_organization_url: {
      example: 'https://github.com/octocat-org',
      type: 'string',
    },
    current_user_organization_urls: {
      example: ['https://github.com/organizations/github/octocat.private.atom?token=abc123'],
      items: {
        format: 'uri',
        type: 'string',
      },
      type: 'array',
    },
    current_user_public_url: {
      example: 'https://github.com/octocat',
      type: 'string',
    },
    current_user_url: {
      example: 'https://github.com/octocat.private?token=abc123',
      type: 'string',
    },
    repository_discussions_category_url: {
      description: 'A feed of discussions for a given repository and category.',
      example: 'https://github.com/{user}/{repo}/discussions/categories/{category}',
      type: 'string',
    },
    repository_discussions_url: {
      description: 'A feed of discussions for a given repository.',
      example: 'https://github.com/{user}/{repo}/discussions',
      type: 'string',
    },
    security_advisories_url: {
      example: 'https://github.com/security-advisories',
      type: 'string',
    },
    timeline_url: {
      example: 'https://github.com/timeline',
      type: 'string',
    },
    user_url: {
      example: 'https://github.com/{user}',
      type: 'string',
    },
  },
  required: ['_links', 'timeline_url', 'user_url'],
  title: 'Feed',
  type: 'object',
} as const;

export const file_commitSchema = {
  description: 'File Commit',
  properties: {
    commit: {
      properties: {
        author: {
          properties: {
            date: {
              type: 'string',
            },
            email: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
          },
          type: 'object',
        },
        committer: {
          properties: {
            date: {
              type: 'string',
            },
            email: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
          },
          type: 'object',
        },
        html_url: {
          type: 'string',
        },
        message: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        parents: {
          items: {
            properties: {
              html_url: {
                type: 'string',
              },
              sha: {
                type: 'string',
              },
              url: {
                type: 'string',
              },
            },
            type: 'object',
          },
          type: 'array',
        },
        sha: {
          type: 'string',
        },
        tree: {
          properties: {
            sha: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          type: 'object',
        },
        url: {
          type: 'string',
        },
        verification: {
          properties: {
            payload: {
              nullable: true,
              type: 'string',
            },
            reason: {
              type: 'string',
            },
            signature: {
              nullable: true,
              type: 'string',
            },
            verified: {
              type: 'boolean',
            },
          },
          type: 'object',
        },
      },
      type: 'object',
    },
    content: {
      nullable: true,
      properties: {
        _links: {
          properties: {
            git: {
              type: 'string',
            },
            html: {
              type: 'string',
            },
            self: {
              type: 'string',
            },
          },
          type: 'object',
        },
        download_url: {
          type: 'string',
        },
        git_url: {
          type: 'string',
        },
        html_url: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        path: {
          type: 'string',
        },
        sha: {
          type: 'string',
        },
        size: {
          type: 'integer',
        },
        type: {
          type: 'string',
        },
        url: {
          type: 'string',
        },
      },
      type: 'object',
    },
  },
  required: ['content', 'commit'],
  title: 'File Commit',
  type: 'object',
} as const;

export const full_repositorySchema = {
  description: 'Full Repository',
  properties: {
    allow_auto_merge: {
      example: false,
      type: 'boolean',
    },
    allow_forking: {
      example: true,
      type: 'boolean',
    },
    allow_merge_commit: {
      example: true,
      type: 'boolean',
    },
    allow_rebase_merge: {
      example: true,
      type: 'boolean',
    },
    allow_squash_merge: {
      example: true,
      type: 'boolean',
    },
    allow_update_branch: {
      example: true,
      type: 'boolean',
    },
    anonymous_access_enabled: {
      default: true,
      description: 'Whether anonymous git access is allowed.',
      type: 'boolean',
    },
    archive_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}',
      type: 'string',
    },
    archived: {
      type: 'boolean',
    },
    assignees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/assignees{/user}',
      type: 'string',
    },
    blobs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}',
      type: 'string',
    },
    branches_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/branches{/branch}',
      type: 'string',
    },
    clone_url: {
      example: 'https://github.com/octocat/Hello-World.git',
      type: 'string',
    },
    code_of_conduct: {
      $ref: '#/components/schemas/code-of-conduct-simple',
    },
    collaborators_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}',
      type: 'string',
    },
    comments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/comments{/number}',
      type: 'string',
    },
    commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/commits{/sha}',
      type: 'string',
    },
    compare_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}',
      type: 'string',
    },
    contents_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contents/{+path}',
      type: 'string',
    },
    contributors_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contributors',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    default_branch: {
      example: 'master',
      type: 'string',
    },
    delete_branch_on_merge: {
      example: false,
      type: 'boolean',
    },
    deployments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/deployments',
      format: 'uri',
      type: 'string',
    },
    description: {
      example: 'This your first repo!',
      nullable: true,
      type: 'string',
    },
    disabled: {
      description: 'Returns whether or not this repository disabled.',
      type: 'boolean',
    },
    downloads_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/downloads',
      format: 'uri',
      type: 'string',
    },
    events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/events',
      format: 'uri',
      type: 'string',
    },
    fork: {
      type: 'boolean',
    },
    forks: {
      type: 'integer',
    },
    forks_count: {
      example: 9,
      type: 'integer',
    },
    forks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/forks',
      format: 'uri',
      type: 'string',
    },
    full_name: {
      example: 'octocat/Hello-World',
      type: 'string',
    },
    git_commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}',
      type: 'string',
    },
    git_refs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}',
      type: 'string',
    },
    git_tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}',
      type: 'string',
    },
    git_url: {
      example: 'git:github.com/octocat/Hello-World.git',
      type: 'string',
    },
    has_discussions: {
      example: true,
      type: 'boolean',
    },
    has_downloads: {
      example: true,
      type: 'boolean',
    },
    has_issues: {
      example: true,
      type: 'boolean',
    },
    has_pages: {
      type: 'boolean',
    },
    has_projects: {
      example: true,
      type: 'boolean',
    },
    has_wiki: {
      example: true,
      type: 'boolean',
    },
    homepage: {
      example: 'https://github.com',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    hooks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/hooks',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1296269,
      type: 'integer',
    },
    is_template: {
      example: true,
      type: 'boolean',
    },
    issue_comment_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}',
      type: 'string',
    },
    issue_events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/events{/number}',
      type: 'string',
    },
    issues_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues{/number}',
      type: 'string',
    },
    keys_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/keys{/key_id}',
      type: 'string',
    },
    labels_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/labels{/name}',
      type: 'string',
    },
    language: {
      nullable: true,
      type: 'string',
    },
    languages_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/languages',
      format: 'uri',
      type: 'string',
    },
    license: {
      $ref: '#/components/schemas/nullable-license-simple',
    },
    master_branch: {
      type: 'string',
    },
    merge_commit_message: {
      description: `The default value for a merge commit message.

- \`PR_TITLE\` - default to the pull request's title.
- \`PR_BODY\` - default to the pull request's body.
- \`BLANK\` - default to a blank commit message.`,
      enum: ['PR_BODY', 'PR_TITLE', 'BLANK'],
      example: 'PR_BODY',
      type: 'string',
    },
    merge_commit_title: {
      description: `The default value for a merge commit title.

  - \`PR_TITLE\` - default to the pull request's title.
  - \`MERGE_MESSAGE\` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).`,
      enum: ['PR_TITLE', 'MERGE_MESSAGE'],
      example: 'PR_TITLE',
      type: 'string',
    },
    merges_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/merges',
      format: 'uri',
      type: 'string',
    },
    milestones_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/milestones{/number}',
      type: 'string',
    },
    mirror_url: {
      example: 'git:git.example.com/octocat/Hello-World',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      example: 'Hello-World',
      type: 'string',
    },
    network_count: {
      example: 0,
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5',
      type: 'string',
    },
    notifications_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}',
      type: 'string',
    },
    open_issues: {
      type: 'integer',
    },
    open_issues_count: {
      example: 0,
      type: 'integer',
    },
    organization: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    parent: {
      $ref: '#/components/schemas/repository',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      required: ['admin', 'pull', 'push'],
      type: 'object',
    },
    private: {
      type: 'boolean',
    },
    pulls_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/pulls{/number}',
      type: 'string',
    },
    pushed_at: {
      example: '2011-01-26T19:06:43Z',
      format: 'date-time',
      type: 'string',
    },
    releases_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/releases{/id}',
      type: 'string',
    },
    security_and_analysis: {
      $ref: '#/components/schemas/security-and-analysis',
    },
    size: {
      description:
        'The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.',
      example: 108,
      type: 'integer',
    },
    source: {
      $ref: '#/components/schemas/repository',
    },
    squash_merge_commit_message: {
      description: `The default value for a squash merge commit message:

- \`PR_BODY\` - default to the pull request's body.
- \`COMMIT_MESSAGES\` - default to the branch's commit messages.
- \`BLANK\` - default to a blank commit message.`,
      enum: ['PR_BODY', 'COMMIT_MESSAGES', 'BLANK'],
      example: 'PR_BODY',
      type: 'string',
    },
    squash_merge_commit_title: {
      description: `The default value for a squash merge commit title:

- \`PR_TITLE\` - default to the pull request's title.
- \`COMMIT_OR_PR_TITLE\` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).`,
      enum: ['PR_TITLE', 'COMMIT_OR_PR_TITLE'],
      example: 'PR_TITLE',
      type: 'string',
    },
    ssh_url: {
      example: 'git@github.com:octocat/Hello-World.git',
      type: 'string',
    },
    stargazers_count: {
      example: 80,
      type: 'integer',
    },
    stargazers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/stargazers',
      format: 'uri',
      type: 'string',
    },
    statuses_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/statuses/{sha}',
      type: 'string',
    },
    subscribers_count: {
      example: 42,
      type: 'integer',
    },
    subscribers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscribers',
      format: 'uri',
      type: 'string',
    },
    subscription_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscription',
      format: 'uri',
      type: 'string',
    },
    svn_url: {
      example: 'https://svn.github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/tags',
      format: 'uri',
      type: 'string',
    },
    teams_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/teams',
      format: 'uri',
      type: 'string',
    },
    temp_clone_token: {
      nullable: true,
      type: 'string',
    },
    template_repository: {
      $ref: '#/components/schemas/nullable-repository',
    },
    topics: {
      example: ['octocat', 'atom', 'electron', 'API'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    trees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:14:43Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    use_squash_pr_title_as_default: {
      example: false,
      type: 'boolean',
    },
    visibility: {
      description: 'The repository visibility: public, private, or internal.',
      example: 'public',
      type: 'string',
    },
    watchers: {
      type: 'integer',
    },
    watchers_count: {
      example: 80,
      type: 'integer',
    },
    web_commit_signoff_required: {
      example: false,
      type: 'boolean',
    },
  },
  required: [
    'archive_url',
    'assignees_url',
    'blobs_url',
    'branches_url',
    'collaborators_url',
    'comments_url',
    'commits_url',
    'compare_url',
    'contents_url',
    'contributors_url',
    'deployments_url',
    'description',
    'downloads_url',
    'events_url',
    'fork',
    'forks_url',
    'full_name',
    'git_commits_url',
    'git_refs_url',
    'git_tags_url',
    'hooks_url',
    'html_url',
    'id',
    'node_id',
    'issue_comment_url',
    'issue_events_url',
    'issues_url',
    'keys_url',
    'labels_url',
    'languages_url',
    'merges_url',
    'milestones_url',
    'name',
    'notifications_url',
    'owner',
    'private',
    'pulls_url',
    'releases_url',
    'stargazers_url',
    'statuses_url',
    'subscribers_url',
    'subscription_url',
    'tags_url',
    'teams_url',
    'trees_url',
    'url',
    'clone_url',
    'default_branch',
    'forks',
    'forks_count',
    'git_url',
    'has_downloads',
    'has_issues',
    'has_projects',
    'has_wiki',
    'has_pages',
    'has_discussions',
    'homepage',
    'language',
    'archived',
    'disabled',
    'mirror_url',
    'open_issues',
    'open_issues_count',
    'license',
    'pushed_at',
    'size',
    'ssh_url',
    'stargazers_count',
    'svn_url',
    'watchers',
    'watchers_count',
    'created_at',
    'updated_at',
    'network_count',
    'subscribers_count',
  ],
  title: 'Full Repository',
  type: 'object',
} as const;

export const gist_commentSchema = {
  description: 'A comment made to a gist.',
  properties: {
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      description: 'The comment text.',
      example: 'Body of the attachment',
      maxLength: 65535,
      type: 'string',
    },
    created_at: {
      example: '2011-04-18T23:23:56Z',
      format: 'date-time',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    node_id: {
      example: 'MDExOkdpc3RDb21tZW50MQ==',
      type: 'string',
    },
    updated_at: {
      example: '2011-04-18T23:23:56Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/gists/a6db0bec360bb87e9418/comments/1',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: ['url', 'id', 'node_id', 'user', 'body', 'author_association', 'created_at', 'updated_at'],
  title: 'Gist Comment',
  type: 'object',
} as const;

export const gist_commitSchema = {
  description: 'Gist Commit',
  properties: {
    change_status: {
      properties: {
        additions: {
          type: 'integer',
        },
        deletions: {
          type: 'integer',
        },
        total: {
          type: 'integer',
        },
      },
      type: 'object',
    },
    committed_at: {
      example: '2010-04-14T02:15:15Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/gists/aa5a315d61ae9438b18d/57a7f021a713b1c5a6a199b54cc514735d2d462f',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    version: {
      example: '57a7f021a713b1c5a6a199b54cc514735d2d462f',
      type: 'string',
    },
  },
  required: ['url', 'user', 'version', 'committed_at', 'change_status'],
  title: 'Gist Commit',
  type: 'object',
} as const;

export const gist_historySchema = {
  description: 'Gist History',
  properties: {
    change_status: {
      properties: {
        additions: {
          type: 'integer',
        },
        deletions: {
          type: 'integer',
        },
        total: {
          type: 'integer',
        },
      },
      type: 'object',
    },
    committed_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    version: {
      type: 'string',
    },
  },
  title: 'Gist History',
  type: 'object',
} as const;

export const gist_simpleSchema = {
  description: 'Gist Simple',
  properties: {
    comments: {
      type: 'integer',
    },
    comments_url: {
      type: 'string',
    },
    commits_url: {
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    description: {
      nullable: true,
      type: 'string',
    },
    files: {
      additionalProperties: {
        nullable: true,
        properties: {
          content: {
            type: 'string',
          },
          filename: {
            type: 'string',
          },
          language: {
            type: 'string',
          },
          raw_url: {
            type: 'string',
          },
          size: {
            type: 'integer',
          },
          truncated: {
            type: 'boolean',
          },
          type: {
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'object',
    },
    fork_of: {
      description: 'Gist',
      nullable: true,
      properties: {
        comments: {
          type: 'integer',
        },
        comments_url: {
          format: 'uri',
          type: 'string',
        },
        commits_url: {
          format: 'uri',
          type: 'string',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        description: {
          nullable: true,
          type: 'string',
        },
        files: {
          additionalProperties: {
            properties: {
              filename: {
                type: 'string',
              },
              language: {
                type: 'string',
              },
              raw_url: {
                type: 'string',
              },
              size: {
                type: 'integer',
              },
              type: {
                type: 'string',
              },
            },
            type: 'object',
          },
          type: 'object',
        },
        forks: {
          items: {},
          type: 'array',
        },
        forks_url: {
          format: 'uri',
          type: 'string',
        },
        git_pull_url: {
          format: 'uri',
          type: 'string',
        },
        git_push_url: {
          format: 'uri',
          type: 'string',
        },
        history: {
          items: {},
          type: 'array',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        owner: {
          $ref: '#/components/schemas/nullable-simple-user',
        },
        public: {
          type: 'boolean',
        },
        truncated: {
          type: 'boolean',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
        user: {
          $ref: '#/components/schemas/nullable-simple-user',
        },
      },
      required: [
        'id',
        'node_id',
        'url',
        'forks_url',
        'commits_url',
        'git_pull_url',
        'git_push_url',
        'html_url',
        'comments_url',
        'public',
        'description',
        'comments',
        'user',
        'files',
        'created_at',
        'updated_at',
      ],
      title: 'Gist',
      type: 'object',
    },
    forks: {
      deprecated: true,
      items: {
        properties: {
          created_at: {
            format: 'date-time',
            type: 'string',
          },
          id: {
            type: 'string',
          },
          updated_at: {
            format: 'date-time',
            type: 'string',
          },
          url: {
            format: 'uri',
            type: 'string',
          },
          user: {
            $ref: '#/components/schemas/public-user',
          },
        },
        type: 'object',
      },
      nullable: true,
      type: 'array',
    },
    forks_url: {
      type: 'string',
    },
    git_pull_url: {
      type: 'string',
    },
    git_push_url: {
      type: 'string',
    },
    history: {
      deprecated: true,
      items: {
        $ref: '#/components/schemas/gist-history',
      },
      nullable: true,
      type: 'array',
    },
    html_url: {
      type: 'string',
    },
    id: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    public: {
      type: 'boolean',
    },
    truncated: {
      type: 'boolean',
    },
    updated_at: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
    user: {
      nullable: true,
      type: 'string',
    },
  },
  title: 'Gist Simple',
  type: 'object',
} as const;

export const git_commitSchema = {
  description: 'Low-level Git commit operations within a repository',
  properties: {
    author: {
      description: 'Identifying information for the git-user',
      properties: {
        date: {
          description: 'Timestamp of the commit',
          example: '2014-08-09T08:02:04+12:00',
          format: 'date-time',
          type: 'string',
        },
        email: {
          description: 'Git email address of the user',
          example: 'monalisa.octocat@example.com',
          type: 'string',
        },
        name: {
          description: 'Name of the git user',
          example: 'Monalisa Octocat',
          type: 'string',
        },
      },
      required: ['email', 'name', 'date'],
      type: 'object',
    },
    committer: {
      description: 'Identifying information for the git-user',
      properties: {
        date: {
          description: 'Timestamp of the commit',
          example: '2014-08-09T08:02:04+12:00',
          format: 'date-time',
          type: 'string',
        },
        email: {
          description: 'Git email address of the user',
          example: 'monalisa.octocat@example.com',
          type: 'string',
        },
        name: {
          description: 'Name of the git user',
          example: 'Monalisa Octocat',
          type: 'string',
        },
      },
      required: ['email', 'name', 'date'],
      type: 'object',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    message: {
      description: 'Message describing the purpose of the commit',
      example: 'Fix #42',
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    parents: {
      items: {
        properties: {
          html_url: {
            format: 'uri',
            type: 'string',
          },
          sha: {
            description: 'SHA for the commit',
            example: '7638417db6d59f3c431d3e1f261cc637155684cd',
            type: 'string',
          },
          url: {
            format: 'uri',
            type: 'string',
          },
        },
        required: ['sha', 'url', 'html_url'],
        type: 'object',
      },
      type: 'array',
    },
    sha: {
      description: 'SHA for the commit',
      example: '7638417db6d59f3c431d3e1f261cc637155684cd',
      type: 'string',
    },
    tree: {
      properties: {
        sha: {
          description: 'SHA for the commit',
          example: '7638417db6d59f3c431d3e1f261cc637155684cd',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['sha', 'url'],
      type: 'object',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    verification: {
      properties: {
        payload: {
          nullable: true,
          type: 'string',
        },
        reason: {
          type: 'string',
        },
        signature: {
          nullable: true,
          type: 'string',
        },
        verified: {
          type: 'boolean',
        },
      },
      required: ['verified', 'reason', 'signature', 'payload'],
      type: 'object',
    },
  },
  required: ['sha', 'node_id', 'url', 'html_url', 'author', 'committer', 'tree', 'message', 'parents', 'verification'],
  title: 'Git Commit',
  type: 'object',
} as const;

export const git_refSchema = {
  description: 'Git references within a repository',
  properties: {
    node_id: {
      type: 'string',
    },
    object: {
      properties: {
        sha: {
          description: 'SHA for the reference',
          example: '7638417db6d59f3c431d3e1f261cc637155684cd',
          maxLength: 40,
          minLength: 40,
          type: 'string',
        },
        type: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['type', 'sha', 'url'],
      type: 'object',
    },
    ref: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['ref', 'node_id', 'url', 'object'],
  title: 'Git Reference',
  type: 'object',
} as const;

export const git_tagSchema = {
  description: 'Metadata for a Git tag',
  properties: {
    message: {
      description: 'Message describing the purpose of the tag',
      example: 'Initial public release',
      type: 'string',
    },
    node_id: {
      example: 'MDM6VGFnOTQwYmQzMzYyNDhlZmFlMGY5ZWU1YmM3YjJkNWM5ODU4ODdiMTZhYw==',
      type: 'string',
    },
    object: {
      properties: {
        sha: {
          type: 'string',
        },
        type: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['sha', 'type', 'url'],
      type: 'object',
    },
    sha: {
      example: '940bd336248efae0f9ee5bc7b2d5c985887b16ac',
      type: 'string',
    },
    tag: {
      description: 'Name of the tag',
      example: 'v0.0.1',
      type: 'string',
    },
    tagger: {
      properties: {
        date: {
          type: 'string',
        },
        email: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
      },
      required: ['date', 'email', 'name'],
      type: 'object',
    },
    url: {
      description: 'URL for the tag',
      example: 'https://api.github.com/repositories/42/git/tags/940bd336248efae0f9ee5bc7b2d5c985887b16ac',
      format: 'uri',
      type: 'string',
    },
    verification: {
      $ref: '#/components/schemas/verification',
    },
  },
  required: ['sha', 'url', 'node_id', 'tagger', 'object', 'tag', 'message'],
  title: 'Git Tag',
  type: 'object',
} as const;

export const git_treeSchema = {
  description: 'The hierarchy between files in a Git repository.',
  properties: {
    sha: {
      type: 'string',
    },
    tree: {
      description: 'Objects specifying a tree structure',
      example: [
        {
          mode: '100644',
          path: 'file.rb',
          properties: {
            mode: {
              type: 'string',
            },
            path: {
              type: 'string',
            },
            sha: {
              type: 'string',
            },
            size: {
              type: 'integer',
            },
            type: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          required: ['path', 'mode', 'type', 'sha', 'url', 'size'],
          sha: '44b4fc6d56897b048c772eb4087f854f46256132',
          size: 30,
          type: 'blob',
          url: 'https://api.github.com/repos/octocat/Hello-World/git/blobs/44b4fc6d56897b048c772eb4087f854f46256132',
        },
      ],
      items: {
        properties: {
          mode: {
            example: '040000',
            type: 'string',
          },
          path: {
            example: 'test/file.rb',
            type: 'string',
          },
          sha: {
            example: '23f6827669e43831def8a7ad935069c8bd418261',
            type: 'string',
          },
          size: {
            example: 12,
            type: 'integer',
          },
          type: {
            example: 'tree',
            type: 'string',
          },
          url: {
            example:
              'https://api.github.com/repos/owner-482f3203ecf01f67e9deb18e/BBB_Private_Repo/git/blobs/23f6827669e43831def8a7ad935069c8bd418261',
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    truncated: {
      type: 'boolean',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['sha', 'url', 'tree', 'truncated'],
  title: 'Git Tree',
  type: 'object',
} as const;

export const gitignore_templateSchema = {
  description: 'Gitignore Template',
  properties: {
    name: {
      example: 'C',
      type: 'string',
    },
    source: {
      example: `# Object files
*.o

# Libraries
*.lib
*.a

# Shared objects (inc. Windows DLLs)
*.dll
*.so
*.so.*
*.dylib

# Executables
*.exe
*.out
*.app
`,
      type: 'string',
    },
  },
  required: ['name', 'source'],
  title: 'Gitignore Template',
  type: 'object',
} as const;

export const gpg_keySchema = {
  description: 'A unique encryption key',
  properties: {
    can_certify: {
      example: true,
      type: 'boolean',
    },
    can_encrypt_comms: {
      type: 'boolean',
    },
    can_encrypt_storage: {
      type: 'boolean',
    },
    can_sign: {
      example: true,
      type: 'boolean',
    },
    created_at: {
      example: '2016-03-24T11:31:04-06:00',
      format: 'date-time',
      type: 'string',
    },
    emails: {
      example: [
        {
          email: 'octocat@users.noreply.github.com',
          verified: true,
        },
      ],
      items: {
        properties: {
          email: {
            type: 'string',
          },
          verified: {
            type: 'boolean',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    expires_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    id: {
      example: 3,
      type: 'integer',
    },
    key_id: {
      example: '3262EFF25BA0D270',
      type: 'string',
    },
    name: {
      example: "Octocat's GPG Key",
      nullable: true,
      type: 'string',
    },
    primary_key_id: {
      nullable: true,
      type: 'integer',
    },
    public_key: {
      example: 'xsBNBFayYZ...',
      type: 'string',
    },
    raw_key: {
      nullable: true,
      type: 'string',
    },
    revoked: {
      example: true,
      type: 'boolean',
    },
    subkeys: {
      example: [
        {
          can_certify: false,
          can_encrypt_comms: true,
          can_encrypt_storage: true,
          can_sign: false,
          created_at: '2016-03-24T11:31:04-06:00',
          emails: [],
          expires_at: null,
          id: 4,
          key_id: '4A595D4C72EE49C7',
          primary_key_id: 3,
          public_key: 'zsBNBFayYZ...',
          revoked: false,
          subkeys: [],
        },
      ],
      items: {
        properties: {
          can_certify: {
            type: 'boolean',
          },
          can_encrypt_comms: {
            type: 'boolean',
          },
          can_encrypt_storage: {
            type: 'boolean',
          },
          can_sign: {
            type: 'boolean',
          },
          created_at: {
            type: 'string',
          },
          emails: {
            items: {},
            type: 'array',
          },
          expires_at: {
            nullable: true,
            type: 'string',
          },
          id: {
            type: 'integer',
          },
          key_id: {
            type: 'string',
          },
          primary_key_id: {
            type: 'integer',
          },
          public_key: {
            type: 'string',
          },
          raw_key: {
            nullable: true,
            type: 'string',
          },
          revoked: {
            type: 'boolean',
          },
          subkeys: {
            items: {},
            type: 'array',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
  },
  required: [
    'id',
    'primary_key_id',
    'key_id',
    'raw_key',
    'public_key',
    'created_at',
    'expires_at',
    'can_sign',
    'can_encrypt_comms',
    'can_encrypt_storage',
    'can_certify',
    'emails',
    'subkeys',
    'revoked',
  ],
  title: 'GPG Key',
  type: 'object',
} as const;

export const hookSchema = {
  description: 'Webhooks for repositories.',
  properties: {
    active: {
      description: 'Determines whether the hook is actually triggered on pushes.',
      example: true,
      type: 'boolean',
    },
    config: {
      properties: {
        content_type: {
          $ref: '#/components/schemas/webhook-config-content-type',
        },
        digest: {
          example: '"sha256"',
          type: 'string',
        },
        email: {
          example: '"foo@bar.com"',
          type: 'string',
        },
        insecure_ssl: {
          $ref: '#/components/schemas/webhook-config-insecure-ssl',
        },
        password: {
          example: '"foo"',
          type: 'string',
        },
        room: {
          example: '"roomer"',
          type: 'string',
        },
        secret: {
          $ref: '#/components/schemas/webhook-config-secret',
        },
        subdomain: {
          example: '"foo"',
          type: 'string',
        },
        token: {
          example: '"abc"',
          type: 'string',
        },
        url: {
          $ref: '#/components/schemas/webhook-config-url',
        },
      },
      type: 'object',
    },
    created_at: {
      example: '2011-09-06T17:26:27Z',
      format: 'date-time',
      type: 'string',
    },
    deliveries_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/hooks/1/deliveries',
      format: 'uri',
      type: 'string',
    },
    events: {
      description: "Determines what events the hook is triggered for. Default: ['push'].",
      example: ['push', 'pull_request'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    id: {
      description: 'Unique identifier of the webhook.',
      example: 42,
      type: 'integer',
    },
    last_response: {
      $ref: '#/components/schemas/hook-response',
    },
    name: {
      description: "The name of a valid service, use 'web' for a webhook.",
      example: 'web',
      type: 'string',
    },
    ping_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/hooks/1/pings',
      format: 'uri',
      type: 'string',
    },
    test_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/hooks/1/test',
      format: 'uri',
      type: 'string',
    },
    type: {
      type: 'string',
    },
    updated_at: {
      example: '2011-09-06T20:39:23Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/hooks/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'url',
    'type',
    'name',
    'active',
    'events',
    'config',
    'ping_url',
    'created_at',
    'updated_at',
    'last_response',
    'test_url',
  ],
  title: 'Webhook',
  type: 'object',
} as const;

export const hook_deliverySchema = {
  description: 'Delivery made by a webhook.',
  properties: {
    action: {
      description: 'The type of activity for the event that triggered the delivery.',
      example: 'opened',
      nullable: true,
      type: 'string',
    },
    delivered_at: {
      description: 'Time when the delivery was delivered.',
      example: '2021-05-12T20:33:44Z',
      format: 'date-time',
      type: 'string',
    },
    duration: {
      description: 'Time spent delivering.',
      example: 0.03,
      type: 'number',
    },
    event: {
      description: 'The event that triggered the delivery.',
      example: 'issues',
      type: 'string',
    },
    guid: {
      description:
        'Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).',
      example: '58474f00-b361-11eb-836d-0e4f3503ccbe',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the delivery.',
      example: 42,
      type: 'integer',
    },
    installation_id: {
      description: 'The id of the GitHub App installation associated with this event.',
      example: 123,
      nullable: true,
      type: 'integer',
    },
    redelivery: {
      description: 'Whether the delivery is a redelivery.',
      example: false,
      type: 'boolean',
    },
    repository_id: {
      description: 'The id of the repository associated with this event.',
      example: 123,
      nullable: true,
      type: 'integer',
    },
    request: {
      properties: {
        headers: {
          additionalProperties: true,
          description: 'The request headers sent with the webhook delivery.',
          nullable: true,
          type: 'object',
        },
        payload: {
          additionalProperties: true,
          description: 'The webhook payload.',
          nullable: true,
          type: 'object',
        },
      },
      required: ['headers', 'payload'],
      type: 'object',
    },
    response: {
      properties: {
        headers: {
          additionalProperties: true,
          description: 'The response headers received when the delivery was made.',
          nullable: true,
          type: 'object',
        },
        payload: {
          additionalProperties: true,
          description: 'The response payload received.',
          nullable: true,
          type: 'string',
        },
      },
      required: ['headers', 'payload'],
      type: 'object',
    },
    status: {
      description: 'Description of the status of the attempted delivery',
      example: 'failed to connect',
      type: 'string',
    },
    status_code: {
      description: 'Status code received when delivery was made.',
      example: 502,
      type: 'integer',
    },
    url: {
      description: 'The URL target of the delivery.',
      example: 'https://www.example.com',
      type: 'string',
    },
  },
  required: [
    'id',
    'guid',
    'delivered_at',
    'redelivery',
    'duration',
    'status',
    'status_code',
    'event',
    'action',
    'installation_id',
    'repository_id',
    'request',
    'response',
  ],
  title: 'Webhook delivery',
  type: 'object',
} as const;

export const hook_delivery_itemSchema = {
  description: 'Delivery made by a webhook, without request and response information.',
  properties: {
    action: {
      description: 'The type of activity for the event that triggered the delivery.',
      example: 'opened',
      nullable: true,
      type: 'string',
    },
    delivered_at: {
      description: 'Time when the webhook delivery occurred.',
      example: '2021-05-12T20:33:44Z',
      format: 'date-time',
      type: 'string',
    },
    duration: {
      description: 'Time spent delivering.',
      example: 0.03,
      type: 'number',
    },
    event: {
      description: 'The event that triggered the delivery.',
      example: 'issues',
      type: 'string',
    },
    guid: {
      description:
        'Unique identifier for the event (shared with all deliveries for all webhooks that subscribe to this event).',
      example: '58474f00-b361-11eb-836d-0e4f3503ccbe',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the webhook delivery.',
      example: 42,
      type: 'integer',
    },
    installation_id: {
      description: 'The id of the GitHub App installation associated with this event.',
      example: 123,
      nullable: true,
      type: 'integer',
    },
    redelivery: {
      description: 'Whether the webhook delivery is a redelivery.',
      example: false,
      type: 'boolean',
    },
    repository_id: {
      description: 'The id of the repository associated with this event.',
      example: 123,
      nullable: true,
      type: 'integer',
    },
    status: {
      description: 'Describes the response returned after attempting the delivery.',
      example: 'failed to connect',
      type: 'string',
    },
    status_code: {
      description: 'Status code received when delivery was made.',
      example: 502,
      type: 'integer',
    },
  },
  required: [
    'id',
    'guid',
    'delivered_at',
    'redelivery',
    'duration',
    'status',
    'status_code',
    'event',
    'action',
    'installation_id',
    'repository_id',
  ],
  title: 'Simple webhook delivery',
  type: 'object',
} as const;

export const hook_responseSchema = {
  properties: {
    code: {
      nullable: true,
      type: 'integer',
    },
    message: {
      nullable: true,
      type: 'string',
    },
    status: {
      nullable: true,
      type: 'string',
    },
  },
  required: ['code', 'status', 'message'],
  title: 'Hook Response',
  type: 'object',
} as const;

export const hovercardSchema = {
  description: 'Hovercard',
  properties: {
    contexts: {
      items: {
        properties: {
          message: {
            type: 'string',
          },
          octicon: {
            type: 'string',
          },
        },
        required: ['message', 'octicon'],
        type: 'object',
      },
      type: 'array',
    },
  },
  required: ['contexts'],
  title: 'Hovercard',
  type: 'object',
} as const;

export const importSchema = {
  description: 'A repository import from an external source.',
  properties: {
    authors_count: {
      nullable: true,
      type: 'integer',
    },
    authors_url: {
      format: 'uri',
      type: 'string',
    },
    commit_count: {
      nullable: true,
      type: 'integer',
    },
    error_message: {
      nullable: true,
      type: 'string',
    },
    failed_step: {
      nullable: true,
      type: 'string',
    },
    has_large_files: {
      type: 'boolean',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    import_percent: {
      nullable: true,
      type: 'integer',
    },
    large_files_count: {
      type: 'integer',
    },
    large_files_size: {
      type: 'integer',
    },
    message: {
      type: 'string',
    },
    project_choices: {
      items: {
        properties: {
          human_name: {
            type: 'string',
          },
          tfvc_project: {
            type: 'string',
          },
          vcs: {
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    push_percent: {
      nullable: true,
      type: 'integer',
    },
    repository_url: {
      format: 'uri',
      type: 'string',
    },
    status: {
      enum: [
        'auth',
        'error',
        'none',
        'detecting',
        'choose',
        'auth_failed',
        'importing',
        'mapping',
        'waiting_to_push',
        'pushing',
        'complete',
        'setup',
        'unknown',
        'detection_found_multiple',
        'detection_found_nothing',
        'detection_needs_auth',
      ],
      type: 'string',
    },
    status_text: {
      nullable: true,
      type: 'string',
    },
    svc_root: {
      type: 'string',
    },
    svn_root: {
      type: 'string',
    },
    tfvc_project: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    use_lfs: {
      type: 'boolean',
    },
    vcs: {
      nullable: true,
      type: 'string',
    },
    vcs_url: {
      description: 'The URL of the originating repository.',
      type: 'string',
    },
  },
  required: ['vcs', 'vcs_url', 'status', 'url', 'repository_url', 'html_url', 'authors_url'],
  title: 'Import',
  type: 'object',
} as const;

export const installationSchema = {
  description: 'Installation',
  properties: {
    access_tokens_url: {
      example: 'https://api.github.com/installations/1/access_tokens',
      format: 'uri',
      type: 'string',
    },
    account: {
      anyOf: [
        {
          $ref: '#/components/schemas/simple-user',
        },
        {
          $ref: '#/components/schemas/enterprise',
        },
      ],
      nullable: true,
    },
    app_id: {
      example: 1,
      type: 'integer',
    },
    app_slug: {
      example: 'github-actions',
      type: 'string',
    },
    contact_email: {
      example: '"test_13f1e99741e3e004@d7e1eb0bc0a1ba12.com"',
      nullable: true,
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    events: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    has_multiple_single_files: {
      example: true,
      type: 'boolean',
    },
    html_url: {
      example: 'https://github.com/organizations/github/settings/installations/1',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'The ID of the installation.',
      example: 1,
      type: 'integer',
    },
    permissions: {
      $ref: '#/components/schemas/app-permissions',
    },
    repositories_url: {
      example: 'https://api.github.com/installation/repositories',
      format: 'uri',
      type: 'string',
    },
    repository_selection: {
      description: "Describe whether all repositories have been selected or there's a selection involved",
      enum: ['all', 'selected'],
      type: 'string',
    },
    single_file_name: {
      example: 'config.yaml',
      nullable: true,
      type: 'string',
    },
    single_file_paths: {
      example: ['config.yml', '.github/issue_TEMPLATE.md'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    suspended_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    suspended_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    target_id: {
      description: 'The ID of the user or organization this token is being scoped to.',
      type: 'integer',
    },
    target_type: {
      example: 'Organization',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
  },
  required: [
    'id',
    'app_id',
    'app_slug',
    'target_id',
    'target_type',
    'single_file_name',
    'repository_selection',
    'access_tokens_url',
    'html_url',
    'repositories_url',
    'events',
    'account',
    'permissions',
    'created_at',
    'updated_at',
    'suspended_by',
    'suspended_at',
  ],
  title: 'Installation',
  type: 'object',
} as const;

export const installation_tokenSchema = {
  description: 'Authentication token for a GitHub App installed on a user or org.',
  properties: {
    expires_at: {
      type: 'string',
    },
    has_multiple_single_files: {
      example: true,
      type: 'boolean',
    },
    permissions: {
      $ref: '#/components/schemas/app-permissions',
    },
    repositories: {
      items: {
        $ref: '#/components/schemas/repository',
      },
      type: 'array',
    },
    repository_selection: {
      enum: ['all', 'selected'],
      type: 'string',
    },
    single_file: {
      example: 'README.md',
      type: 'string',
    },
    single_file_paths: {
      example: ['config.yml', '.github/issue_TEMPLATE.md'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    token: {
      type: 'string',
    },
  },
  required: ['token', 'expires_at'],
  title: 'Installation Token',
  type: 'object',
} as const;

export const integrationSchema = {
  description:
    'GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.',
  properties: {
    client_id: {
      example: '"Iv1.25b5d1e65ffc4022"',
      type: 'string',
    },
    client_secret: {
      example: '"1d4b2097ac622ba702d19de498f005747a8b21d3"',
      type: 'string',
    },
    created_at: {
      example: '2017-07-08T16:18:44-04:00',
      format: 'date-time',
      type: 'string',
    },
    description: {
      example: 'The description of the app.',
      nullable: true,
      type: 'string',
    },
    events: {
      description: 'The list of events for the GitHub app',
      example: ['label', 'deployment'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    external_url: {
      example: 'https://example.com',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/apps/super-ci',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the GitHub app',
      example: 37,
      type: 'integer',
    },
    installations_count: {
      description: 'The number of installations associated with the GitHub app',
      example: 5,
      type: 'integer',
    },
    name: {
      description: 'The name of the GitHub app',
      example: 'Probot Owners',
      type: 'string',
    },
    node_id: {
      example: 'MDExOkludGVncmF0aW9uMQ==',
      type: 'string',
    },
    owner: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    pem: {
      example:
        '"-----BEGIN RSA PRIVATE KEY-----\\nMIIEogIBAAKCAQEArYxrNYD/iT5CZVpRJu4rBKmmze3PVmT/gCo2ATUvDvZTPTey\\nxcGJ3vvrJXazKk06pN05TN29o98jrYz4cengG3YGsXPNEpKsIrEl8NhbnxapEnM9\\nJCMRe0P5JcPsfZlX6hmiT7136GRWiGOUba2X9+HKh8QJVLG5rM007TBER9/z9mWm\\nrJuNh+m5l320oBQY/Qq3A7wzdEfZw8qm/mIN0FCeoXH1L6B8xXWaAYBwhTEh6SSn\\nZHlO1Xu1JWDmAvBCi0RO5aRSKM8q9QEkvvHP4yweAtK3N8+aAbZ7ovaDhyGz8r6r\\nzhU1b8Uo0Z2ysf503WqzQgIajr7Fry7/kUwpgQIDAQABAoIBADwJp80Ko1xHPZDy\\nfcCKBDfIuPvkmSW6KumbsLMaQv1aGdHDwwTGv3t0ixSay8CGlxMRtRDyZPib6SvQ\\n6OH/lpfpbMdW2ErkksgtoIKBVrDilfrcAvrNZu7NxRNbhCSvN8q0s4ICecjbbVQh\\nnueSdlA6vGXbW58BHMq68uRbHkP+k+mM9U0mDJ1HMch67wlg5GbayVRt63H7R2+r\\nVxcna7B80J/lCEjIYZznawgiTvp3MSanTglqAYi+m1EcSsP14bJIB9vgaxS79kTu\\noiSo93leJbBvuGo8QEiUqTwMw4tDksmkLsoqNKQ1q9P7LZ9DGcujtPy4EZsamSJT\\ny8OJt0ECgYEA2lxOxJsQk2kI325JgKFjo92mQeUObIvPfSNWUIZQDTjniOI6Gv63\\nGLWVFrZcvQBWjMEQraJA9xjPbblV8PtfO87MiJGLWCHFxmPz2dzoedN+2Coxom8m\\nV95CLz8QUShuao6u/RYcvUaZEoYs5bHcTmy5sBK80JyEmafJPtCQVxMCgYEAy3ar\\nZr3yv4xRPEPMat4rseswmuMooSaK3SKub19WFI5IAtB/e7qR1Rj9JhOGcZz+OQrl\\nT78O2OFYlgOIkJPvRMrPpK5V9lslc7tz1FSh3BZMRGq5jSyD7ETSOQ0c8T2O/s7v\\nbeEPbVbDe4mwvM24XByH0GnWveVxaDl51ABD65sCgYB3ZAspUkOA5egVCh8kNpnd\\nSd6SnuQBE3ySRlT2WEnCwP9Ph6oPgn+oAfiPX4xbRqkL8q/k0BdHQ4h+zNwhk7+h\\nWtPYRAP1Xxnc/F+jGjb+DVaIaKGU18MWPg7f+FI6nampl3Q0KvfxwX0GdNhtio8T\\nTj1E+SnFwh56SRQuxSh2gwKBgHKjlIO5NtNSflsUYFM+hyQiPiqnHzddfhSG+/3o\\nm5nNaSmczJesUYreH5San7/YEy2UxAugvP7aSY2MxB+iGsiJ9WD2kZzTUlDZJ7RV\\nUzWsoqBR+eZfVJ2FUWWvy8TpSG6trh4dFxImNtKejCR1TREpSiTV3Zb1dmahK9GV\\nrK9NAoGAbBxRLoC01xfxCTgt5BDiBcFVh4fp5yYKwavJPLzHSpuDOrrI9jDn1oKN\\nonq5sDU1i391zfQvdrbX4Ova48BN+B7p63FocP/MK5tyyBoT8zQEk2+vWDOw7H/Z\\nu5dTCPxTIsoIwUw1I+7yIxqJzLPFgR2gVBwY1ra/8iAqCj+zeBw=\\n-----END RSA PRIVATE KEY-----\\n"',
      type: 'string',
    },
    permissions: {
      additionalProperties: {
        type: 'string',
      },
      description: 'The set of permissions for the GitHub app',
      example: {
        deployments: 'write',
        issues: 'read',
      },
      properties: {
        checks: {
          type: 'string',
        },
        contents: {
          type: 'string',
        },
        deployments: {
          type: 'string',
        },
        issues: {
          type: 'string',
        },
        metadata: {
          type: 'string',
        },
      },
      type: 'object',
    },
    slug: {
      description: 'The slug name of the GitHub app',
      example: 'probot-owners',
      type: 'string',
    },
    updated_at: {
      example: '2017-07-08T16:18:44-04:00',
      format: 'date-time',
      type: 'string',
    },
    webhook_secret: {
      example: '"6fba8f2fc8a7e8f2cca5577eddd82ca7586b3b6b"',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'owner',
    'name',
    'description',
    'external_url',
    'html_url',
    'created_at',
    'updated_at',
    'permissions',
    'events',
  ],
  title: 'GitHub app',
  type: 'object',
} as const;

export const interaction_expirySchema = {
  description: 'The duration of the interaction restriction. Default: `one_day`.',
  enum: ['one_day', 'three_days', 'one_week', 'one_month', 'six_months'],
  example: 'one_month',
  type: 'string',
} as const;

export const interaction_groupSchema = {
  description:
    'The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect.',
  enum: ['existing_users', 'contributors_only', 'collaborators_only'],
  example: 'collaborators_only',
  type: 'string',
} as const;

export const interaction_limitSchema = {
  description: 'Limit interactions to a specific type of user for a specified duration',
  properties: {
    expiry: {
      $ref: '#/components/schemas/interaction-expiry',
    },
    limit: {
      $ref: '#/components/schemas/interaction-group',
    },
  },
  required: ['limit'],
  title: 'Interaction Restrictions',
  type: 'object',
} as const;

export const interaction_limit_responseSchema = {
  description: 'Interaction limit settings.',
  properties: {
    expires_at: {
      example: '2018-08-17T04:18:39Z',
      format: 'date-time',
      type: 'string',
    },
    limit: {
      $ref: '#/components/schemas/interaction-group',
    },
    origin: {
      example: 'repository',
      type: 'string',
    },
  },
  required: ['limit', 'origin', 'expires_at'],
  title: 'Interaction Limits',
  type: 'object',
} as const;

export const issueSchema = {
  description: 'Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.',
  properties: {
    active_lock_reason: {
      nullable: true,
      type: 'string',
    },
    assignee: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    assignees: {
      items: {
        $ref: '#/components/schemas/simple-user',
      },
      nullable: true,
      type: 'array',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      description: 'Contents of the issue',
      example:
        'It looks like the new widget form is broken on Safari. When I try and create the widget, Safari crashes. This is reproducible on 10.8, but not 10.9. Maybe a browser bug?',
      nullable: true,
      type: 'string',
    },
    body_html: {
      type: 'string',
    },
    body_text: {
      type: 'string',
    },
    closed_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    closed_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    comments: {
      type: 'integer',
    },
    comments_url: {
      format: 'uri',
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    draft: {
      type: 'boolean',
    },
    events_url: {
      format: 'uri',
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    labels: {
      description:
        'Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository',
      example: ['bug', 'registration'],
      items: {
        oneOf: [
          {
            type: 'string',
          },
          {
            properties: {
              color: {
                nullable: true,
                type: 'string',
              },
              default: {
                type: 'boolean',
              },
              description: {
                nullable: true,
                type: 'string',
              },
              id: {
                format: 'int64',
                type: 'integer',
              },
              name: {
                type: 'string',
              },
              node_id: {
                type: 'string',
              },
              url: {
                format: 'uri',
                type: 'string',
              },
            },
            type: 'object',
          },
        ],
      },
      type: 'array',
    },
    labels_url: {
      type: 'string',
    },
    locked: {
      type: 'boolean',
    },
    milestone: {
      $ref: '#/components/schemas/nullable-milestone',
    },
    node_id: {
      type: 'string',
    },
    number: {
      description: 'Number uniquely identifying the issue within its repository',
      example: 42,
      type: 'integer',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    pull_request: {
      properties: {
        diff_url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        html_url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        merged_at: {
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        patch_url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
      },
      required: ['diff_url', 'html_url', 'patch_url', 'url'],
      type: 'object',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    repository_url: {
      format: 'uri',
      type: 'string',
    },
    state: {
      description: "State of the issue; either 'open' or 'closed'",
      example: 'open',
      type: 'string',
    },
    state_reason: {
      description: 'The reason for the current state',
      enum: ['completed', 'reopened', 'not_planned'],
      example: 'not_planned',
      nullable: true,
      type: 'string',
    },
    timeline_url: {
      format: 'uri',
      type: 'string',
    },
    title: {
      description: 'Title of the issue',
      example: 'Widget creation fails in Safari on OS X 10.8',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      description: 'URL for the issue',
      example: 'https://api.github.com/repositories/42/issues/1',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    'assignee',
    'closed_at',
    'comments',
    'comments_url',
    'events_url',
    'html_url',
    'id',
    'node_id',
    'labels',
    'labels_url',
    'milestone',
    'number',
    'repository_url',
    'state',
    'locked',
    'title',
    'url',
    'user',
    'author_association',
    'created_at',
    'updated_at',
  ],
  title: 'Issue',
  type: 'object',
} as const;

export const issue_commentSchema = {
  description: 'Comments provide a way for people to collaborate on an issue.',
  properties: {
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      description: 'Contents of the issue comment',
      example: 'What version of Safari were you using when you observed this bug?',
      type: 'string',
    },
    body_html: {
      type: 'string',
    },
    body_text: {
      type: 'string',
    },
    created_at: {
      example: '2011-04-14T16:00:49Z',
      format: 'date-time',
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the issue comment',
      example: 42,
      type: 'integer',
    },
    issue_url: {
      format: 'uri',
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    updated_at: {
      example: '2011-04-14T16:00:49Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      description: 'URL for the issue comment',
      example: 'https://api.github.com/repositories/42/issues/comments/1',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: ['id', 'node_id', 'html_url', 'issue_url', 'author_association', 'user', 'url', 'created_at', 'updated_at'],
  title: 'Issue Comment',
  type: 'object',
} as const;

export const issue_eventSchema = {
  description: 'Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    assignee: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    assigner: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    commit_id: {
      example: '6dcb09b5b57875f334f61aebed695e2e4193db5e',
      nullable: true,
      type: 'string',
    },
    commit_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/commits/6dcb09b5b57875f334f61aebed695e2e4193db5e',
      nullable: true,
      type: 'string',
    },
    created_at: {
      example: '2011-04-14T16:00:49Z',
      format: 'date-time',
      type: 'string',
    },
    dismissed_review: {
      $ref: '#/components/schemas/issue-event-dismissed-review',
    },
    event: {
      example: 'closed',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    issue: {
      $ref: '#/components/schemas/nullable-issue',
    },
    label: {
      $ref: '#/components/schemas/issue-event-label',
    },
    lock_reason: {
      nullable: true,
      type: 'string',
    },
    milestone: {
      $ref: '#/components/schemas/issue-event-milestone',
    },
    node_id: {
      example: 'MDEwOklzc3VlRXZlbnQx',
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    project_card: {
      $ref: '#/components/schemas/issue-event-project-card',
    },
    rename: {
      $ref: '#/components/schemas/issue-event-rename',
    },
    requested_reviewer: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    requested_team: {
      $ref: '#/components/schemas/team',
    },
    review_requester: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/events/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['id', 'node_id', 'url', 'actor', 'event', 'commit_id', 'commit_url', 'created_at'],
  title: 'Issue Event',
  type: 'object',
} as const;

export const issue_event_dismissed_reviewSchema = {
  properties: {
    dismissal_commit_id: {
      nullable: true,
      type: 'string',
    },
    dismissal_message: {
      nullable: true,
      type: 'string',
    },
    review_id: {
      type: 'integer',
    },
    state: {
      type: 'string',
    },
  },
  required: ['state', 'review_id', 'dismissal_message'],
  title: 'Issue Event Dismissed Review',
  type: 'object',
} as const;

export const issue_event_for_issueSchema = {
  anyOf: [
    {
      $ref: '#/components/schemas/labeled-issue-event',
    },
    {
      $ref: '#/components/schemas/unlabeled-issue-event',
    },
    {
      $ref: '#/components/schemas/assigned-issue-event',
    },
    {
      $ref: '#/components/schemas/unassigned-issue-event',
    },
    {
      $ref: '#/components/schemas/milestoned-issue-event',
    },
    {
      $ref: '#/components/schemas/demilestoned-issue-event',
    },
    {
      $ref: '#/components/schemas/renamed-issue-event',
    },
    {
      $ref: '#/components/schemas/review-requested-issue-event',
    },
    {
      $ref: '#/components/schemas/review-request-removed-issue-event',
    },
    {
      $ref: '#/components/schemas/review-dismissed-issue-event',
    },
    {
      $ref: '#/components/schemas/locked-issue-event',
    },
    {
      $ref: '#/components/schemas/added-to-project-issue-event',
    },
    {
      $ref: '#/components/schemas/moved-column-in-project-issue-event',
    },
    {
      $ref: '#/components/schemas/removed-from-project-issue-event',
    },
    {
      $ref: '#/components/schemas/converted-note-to-issue-issue-event',
    },
  ],
  description: 'Issue Event for Issue',
  title: 'Issue Event for Issue',
} as const;

export const issue_event_labelSchema = {
  description: 'Issue Event Label',
  properties: {
    color: {
      nullable: true,
      type: 'string',
    },
    name: {
      nullable: true,
      type: 'string',
    },
  },
  required: ['name', 'color'],
  title: 'Issue Event Label',
  type: 'object',
} as const;

export const issue_event_milestoneSchema = {
  description: 'Issue Event Milestone',
  properties: {
    title: {
      type: 'string',
    },
  },
  required: ['title'],
  title: 'Issue Event Milestone',
  type: 'object',
} as const;

export const issue_event_project_cardSchema = {
  description: 'Issue Event Project Card',
  properties: {
    column_name: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    previous_column_name: {
      type: 'string',
    },
    project_id: {
      type: 'integer',
    },
    project_url: {
      format: 'uri',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'id', 'project_url', 'project_id', 'column_name'],
  title: 'Issue Event Project Card',
  type: 'object',
} as const;

export const issue_event_renameSchema = {
  description: 'Issue Event Rename',
  properties: {
    from: {
      type: 'string',
    },
    to: {
      type: 'string',
    },
  },
  required: ['from', 'to'],
  title: 'Issue Event Rename',
  type: 'object',
} as const;

export const issue_search_result_itemSchema = {
  description: 'Issue Search Result Item',
  properties: {
    active_lock_reason: {
      nullable: true,
      type: 'string',
    },
    assignee: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    assignees: {
      items: {
        $ref: '#/components/schemas/simple-user',
      },
      nullable: true,
      type: 'array',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      type: 'string',
    },
    body_html: {
      type: 'string',
    },
    body_text: {
      type: 'string',
    },
    closed_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    comments: {
      type: 'integer',
    },
    comments_url: {
      format: 'uri',
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    draft: {
      type: 'boolean',
    },
    events_url: {
      format: 'uri',
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    labels: {
      items: {
        properties: {
          color: {
            type: 'string',
          },
          default: {
            type: 'boolean',
          },
          description: {
            nullable: true,
            type: 'string',
          },
          id: {
            format: 'int64',
            type: 'integer',
          },
          name: {
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          url: {
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    labels_url: {
      type: 'string',
    },
    locked: {
      type: 'boolean',
    },
    milestone: {
      $ref: '#/components/schemas/nullable-milestone',
    },
    node_id: {
      type: 'string',
    },
    number: {
      type: 'integer',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    pull_request: {
      properties: {
        diff_url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        html_url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        merged_at: {
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        patch_url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
      },
      required: ['diff_url', 'html_url', 'patch_url', 'url'],
      type: 'object',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    repository_url: {
      format: 'uri',
      type: 'string',
    },
    score: {
      type: 'number',
    },
    state: {
      type: 'string',
    },
    state_reason: {
      nullable: true,
      type: 'string',
    },
    text_matches: {
      $ref: '#/components/schemas/search-result-text-matches',
    },
    timeline_url: {
      format: 'uri',
      type: 'string',
    },
    title: {
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    'assignee',
    'closed_at',
    'comments',
    'comments_url',
    'events_url',
    'html_url',
    'id',
    'node_id',
    'labels',
    'labels_url',
    'milestone',
    'number',
    'repository_url',
    'state',
    'locked',
    'title',
    'url',
    'user',
    'author_association',
    'created_at',
    'updated_at',
    'score',
  ],
  title: 'Issue Search Result Item',
  type: 'object',
} as const;

export const jobSchema = {
  description: 'Information of a job execution in a workflow run',
  properties: {
    check_run_url: {
      example: 'https://api.github.com/repos/github/hello-world/check-runs/4',
      type: 'string',
    },
    completed_at: {
      description: 'The time that the job finished, in ISO 8601 format.',
      example: '2019-08-08T08:00:00-07:00',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    conclusion: {
      description: 'The outcome of the job.',
      enum: ['success', 'failure', 'neutral', 'cancelled', 'skipped', 'timed_out', 'action_required'],
      example: 'success',
      nullable: true,
      type: 'string',
    },
    head_branch: {
      description: 'The name of the current branch.',
      example: 'main',
      nullable: true,
      type: 'string',
    },
    head_sha: {
      description: 'The SHA of the commit that is being run.',
      example: '009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/github/hello-world/runs/4',
      nullable: true,
      type: 'string',
    },
    id: {
      description: 'The id of the job.',
      example: 21,
      type: 'integer',
    },
    labels: {
      description: `Labels for the workflow job. Specified by the "runs_on" attribute in the action's workflow file.`,
      example: ['self-hosted', 'foo', 'bar'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    name: {
      description: 'The name of the job.',
      example: 'test-coverage',
      type: 'string',
    },
    node_id: {
      example: 'MDg6Q2hlY2tSdW40',
      type: 'string',
    },
    run_attempt: {
      description:
        'Attempt number of the associated workflow run, 1 for first attempt and higher if the workflow was re-run.',
      example: 1,
      type: 'integer',
    },
    run_id: {
      description: 'The id of the associated workflow run.',
      example: 5,
      type: 'integer',
    },
    run_url: {
      example: 'https://api.github.com/repos/github/hello-world/actions/runs/5',
      type: 'string',
    },
    runner_group_id: {
      description:
        "The ID of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
      example: 2,
      nullable: true,
      type: 'integer',
    },
    runner_group_name: {
      description:
        "The name of the runner group to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
      example: 'my runner group',
      nullable: true,
      type: 'string',
    },
    runner_id: {
      description:
        "The ID of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
      example: 1,
      nullable: true,
      type: 'integer',
    },
    runner_name: {
      description:
        "The name of the runner to which this job has been assigned. (If a runner hasn't yet been assigned, this will be null.)",
      example: 'my runner',
      nullable: true,
      type: 'string',
    },
    started_at: {
      description: 'The time that the job started, in ISO 8601 format.',
      example: '2019-08-08T08:00:00-07:00',
      format: 'date-time',
      type: 'string',
    },
    status: {
      description: 'The phase of the lifecycle that the job is currently in.',
      enum: ['queued', 'in_progress', 'completed'],
      example: 'queued',
      type: 'string',
    },
    steps: {
      description: 'Steps in this job.',
      items: {
        properties: {
          completed_at: {
            description: 'The time that the job finished, in ISO 8601 format.',
            example: '2019-08-08T08:00:00-07:00',
            format: 'date-time',
            nullable: true,
            type: 'string',
          },
          conclusion: {
            description: 'The outcome of the job.',
            example: 'success',
            nullable: true,
            type: 'string',
          },
          name: {
            description: 'The name of the job.',
            example: 'test-coverage',
            type: 'string',
          },
          number: {
            example: 1,
            type: 'integer',
          },
          started_at: {
            description: 'The time that the step started, in ISO 8601 format.',
            example: '2019-08-08T08:00:00-07:00',
            format: 'date-time',
            nullable: true,
            type: 'string',
          },
          status: {
            description: 'The phase of the lifecycle that the job is currently in.',
            enum: ['queued', 'in_progress', 'completed'],
            example: 'queued',
            type: 'string',
          },
        },
        required: ['name', 'status', 'conclusion', 'number'],
        type: 'object',
      },
      type: 'array',
    },
    url: {
      example: 'https://api.github.com/repos/github/hello-world/actions/jobs/21',
      type: 'string',
    },
    workflow_name: {
      description: 'The name of the workflow.',
      example: 'Build',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'run_id',
    'run_url',
    'head_sha',
    'workflow_name',
    'head_branch',
    'name',
    'url',
    'html_url',
    'status',
    'conclusion',
    'started_at',
    'completed_at',
    'check_run_url',
    'labels',
    'runner_id',
    'runner_name',
    'runner_group_id',
    'runner_group_name',
  ],
  title: 'Job',
  type: 'object',
} as const;

export const keySchema = {
  description: 'Key',
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    key: {
      type: 'string',
    },
    read_only: {
      type: 'boolean',
    },
    title: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
    verified: {
      type: 'boolean',
    },
  },
  required: ['key', 'id', 'url', 'title', 'created_at', 'verified', 'read_only'],
  title: 'Key',
  type: 'object',
} as const;

export const key_simpleSchema = {
  description: 'Key Simple',
  properties: {
    id: {
      type: 'integer',
    },
    key: {
      type: 'string',
    },
  },
  required: ['key', 'id'],
  title: 'Key Simple',
  type: 'object',
} as const;

export const labelSchema = {
  description: 'Color-coded labels help you categorize and filter your issues (just like labels in Gmail).',
  properties: {
    color: {
      description: '6-character hex code, without the leading #, identifying the color',
      example: 'FFFFFF',
      type: 'string',
    },
    default: {
      example: true,
      type: 'boolean',
    },
    description: {
      example: "Something isn't working",
      nullable: true,
      type: 'string',
    },
    id: {
      example: 208045946,
      format: 'int64',
      type: 'integer',
    },
    name: {
      description: 'The name of the label.',
      example: 'bug',
      type: 'string',
    },
    node_id: {
      example: 'MDU6TGFiZWwyMDgwNDU5NDY=',
      type: 'string',
    },
    url: {
      description: 'URL for the label',
      example: 'https://api.github.com/repositories/42/labels/bug',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['id', 'node_id', 'url', 'name', 'description', 'color', 'default'],
  title: 'Label',
  type: 'object',
} as const;

export const label_search_result_itemSchema = {
  description: 'Label Search Result Item',
  properties: {
    color: {
      type: 'string',
    },
    default: {
      type: 'boolean',
    },
    description: {
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    name: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    score: {
      type: 'number',
    },
    text_matches: {
      $ref: '#/components/schemas/search-result-text-matches',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['id', 'node_id', 'url', 'name', 'color', 'default', 'description', 'score'],
  title: 'Label Search Result Item',
  type: 'object',
} as const;

export const labeled_issue_eventSchema = {
  description: 'Labeled Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    label: {
      properties: {
        color: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
      },
      required: ['name', 'color'],
      type: 'object',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'label',
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Labeled Issue Event',
  type: 'object',
} as const;

export const languageSchema = {
  additionalProperties: {
    type: 'integer',
  },
  description: 'Language',
  title: 'Language',
  type: 'object',
} as const;

export const licenseSchema = {
  description: 'License',
  properties: {
    body: {
      example: `

The MIT License (MIT)

Copyright (c) [year] [fullname]

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
`,
      type: 'string',
    },
    conditions: {
      example: ['include-copyright'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    description: {
      example:
        'A permissive license that is short and to the point. It lets people do anything with your code with proper attribution and without warranty.',
      type: 'string',
    },
    featured: {
      example: true,
      type: 'boolean',
    },
    html_url: {
      example: 'http://choosealicense.com/licenses/mit/',
      format: 'uri',
      type: 'string',
    },
    implementation: {
      example:
        'Create a text file (typically named LICENSE or LICENSE.txt) in the root of your source code and copy the text of the license into the file. Replace [year] with the current year and [fullname] with the name (or names) of the copyright holders.',
      type: 'string',
    },
    key: {
      example: 'mit',
      type: 'string',
    },
    limitations: {
      example: ['no-liability'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    name: {
      example: 'MIT License',
      type: 'string',
    },
    node_id: {
      example: 'MDc6TGljZW5zZW1pdA==',
      type: 'string',
    },
    permissions: {
      example: ['commercial-use', 'modifications', 'distribution', 'sublicense', 'private-use'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    spdx_id: {
      example: 'MIT',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/licenses/mit',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'key',
    'name',
    'url',
    'spdx_id',
    'node_id',
    'html_url',
    'description',
    'implementation',
    'permissions',
    'conditions',
    'limitations',
    'body',
    'featured',
  ],
  title: 'License',
  type: 'object',
} as const;

export const license_contentSchema = {
  description: 'License Content',
  properties: {
    _links: {
      properties: {
        git: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        html: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        self: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['git', 'html', 'self'],
      type: 'object',
    },
    content: {
      type: 'string',
    },
    download_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    encoding: {
      type: 'string',
    },
    git_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    html_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    license: {
      $ref: '#/components/schemas/nullable-license-simple',
    },
    name: {
      type: 'string',
    },
    path: {
      type: 'string',
    },
    sha: {
      type: 'string',
    },
    size: {
      type: 'integer',
    },
    type: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    '_links',
    'git_url',
    'html_url',
    'download_url',
    'name',
    'path',
    'sha',
    'size',
    'type',
    'url',
    'content',
    'encoding',
    'license',
  ],
  title: 'License Content',
  type: 'object',
} as const;

export const license_simpleSchema = {
  description: 'License Simple',
  properties: {
    html_url: {
      format: 'uri',
      type: 'string',
    },
    key: {
      example: 'mit',
      type: 'string',
    },
    name: {
      example: 'MIT License',
      type: 'string',
    },
    node_id: {
      example: 'MDc6TGljZW5zZW1pdA==',
      type: 'string',
    },
    spdx_id: {
      example: 'MIT',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/licenses/mit',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  required: ['key', 'name', 'url', 'spdx_id', 'node_id'],
  title: 'License Simple',
  type: 'object',
} as const;

export const linkSchema = {
  description: 'Hypermedia Link',
  properties: {
    href: {
      type: 'string',
    },
  },
  required: ['href'],
  title: 'Link',
  type: 'object',
} as const;

export const link_with_typeSchema = {
  description: 'Hypermedia Link with Type',
  properties: {
    href: {
      type: 'string',
    },
    type: {
      type: 'string',
    },
  },
  required: ['href', 'type'],
  title: 'Link With Type',
  type: 'object',
} as const;

export const locked_issue_eventSchema = {
  description: 'Locked Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    lock_reason: {
      example: '"off-topic"',
      nullable: true,
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'lock_reason',
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Locked Issue Event',
  type: 'object',
} as const;

export const manifestSchema = {
  additionalProperties: false,
  properties: {
    file: {
      additionalProperties: false,
      properties: {
        source_location: {
          description: 'The path of the manifest file relative to the root of the Git repository.',
          example: '/src/build/package-lock.json',
          type: 'string',
        },
      },
      type: 'object',
    },
    metadata: {
      $ref: '#/components/schemas/metadata',
    },
    name: {
      description: 'The name of the manifest.',
      example: 'package-lock.json',
      type: 'string',
    },
    resolved: {
      additionalProperties: {
        $ref: '#/components/schemas/dependency',
      },
      description: 'A collection of resolved package dependencies.',
      type: 'object',
    },
  },
  required: ['name'],
  type: 'object',
} as const;

export const marketplace_accountSchema = {
  properties: {
    email: {
      format: 'email',
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    login: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    organization_billing_email: {
      format: 'email',
      nullable: true,
      type: 'string',
    },
    type: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'id', 'type', 'login'],
  title: 'Marketplace Account',
  type: 'object',
} as const;

export const marketplace_listing_planSchema = {
  description: 'Marketplace Listing Plan',
  properties: {
    accounts_url: {
      example: 'https://api.github.com/marketplace_listing/plans/1313/accounts',
      format: 'uri',
      type: 'string',
    },
    bullets: {
      example: ['Up to 25 private repositories', '11 concurrent builds'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    description: {
      example: 'A professional-grade CI solution',
      type: 'string',
    },
    has_free_trial: {
      example: true,
      type: 'boolean',
    },
    id: {
      example: 1313,
      type: 'integer',
    },
    monthly_price_in_cents: {
      example: 1099,
      type: 'integer',
    },
    name: {
      example: 'Pro',
      type: 'string',
    },
    number: {
      example: 3,
      type: 'integer',
    },
    price_model: {
      enum: ['FREE', 'FLAT_RATE', 'PER_UNIT'],
      example: 'FLAT_RATE',
      type: 'string',
    },
    state: {
      example: 'published',
      type: 'string',
    },
    unit_name: {
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/marketplace_listing/plans/1313',
      format: 'uri',
      type: 'string',
    },
    yearly_price_in_cents: {
      example: 11870,
      type: 'integer',
    },
  },
  required: [
    'url',
    'accounts_url',
    'id',
    'number',
    'name',
    'description',
    'has_free_trial',
    'price_model',
    'unit_name',
    'monthly_price_in_cents',
    'state',
    'yearly_price_in_cents',
    'bullets',
  ],
  title: 'Marketplace Listing Plan',
  type: 'object',
} as const;

export const marketplace_purchaseSchema = {
  description: 'Marketplace Purchase',
  properties: {
    email: {
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    login: {
      type: 'string',
    },
    marketplace_pending_change: {
      nullable: true,
      properties: {
        effective_date: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        is_installed: {
          type: 'boolean',
        },
        plan: {
          $ref: '#/components/schemas/marketplace-listing-plan',
        },
        unit_count: {
          nullable: true,
          type: 'integer',
        },
      },
      type: 'object',
    },
    marketplace_purchase: {
      properties: {
        billing_cycle: {
          type: 'string',
        },
        free_trial_ends_on: {
          nullable: true,
          type: 'string',
        },
        is_installed: {
          type: 'boolean',
        },
        next_billing_date: {
          nullable: true,
          type: 'string',
        },
        on_free_trial: {
          type: 'boolean',
        },
        plan: {
          $ref: '#/components/schemas/marketplace-listing-plan',
        },
        unit_count: {
          nullable: true,
          type: 'integer',
        },
        updated_at: {
          type: 'string',
        },
      },
      type: 'object',
    },
    organization_billing_email: {
      type: 'string',
    },
    type: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
  },
  required: ['url', 'id', 'type', 'login', 'marketplace_purchase'],
  title: 'Marketplace Purchase',
  type: 'object',
} as const;

export const merged_upstreamSchema = {
  description: 'Results of a successful merge upstream request',
  properties: {
    base_branch: {
      type: 'string',
    },
    merge_type: {
      enum: ['merge', 'fast-forward', 'none'],
      type: 'string',
    },
    message: {
      type: 'string',
    },
  },
  title: 'Merged upstream',
  type: 'object',
} as const;

export const metadataSchema = {
  additionalProperties: {
    anyOf: [
      {
        type: 'string',
      },
      {
        type: 'number',
      },
      {
        type: 'boolean',
      },
    ],
    nullable: true,
  },
  description: 'User-defined metadata to store domain-specific information limited to 8 keys with scalar values.',
  maxProperties: 8,
  title: 'metadata',
  type: 'object',
} as const;

export const migrationSchema = {
  description: 'A migration.',
  properties: {
    archive_url: {
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2015-07-06T15:33:38-07:00',
      format: 'date-time',
      type: 'string',
    },
    exclude: {
      items: {},
      type: 'array',
    },
    exclude_attachments: {
      type: 'boolean',
    },
    exclude_git_data: {
      type: 'boolean',
    },
    exclude_metadata: {
      type: 'boolean',
    },
    exclude_owner_projects: {
      type: 'boolean',
    },
    exclude_releases: {
      type: 'boolean',
    },
    guid: {
      example: '0b989ba4-242f-11e5-81e1-c7b6966d2516',
      type: 'string',
    },
    id: {
      example: 79,
      type: 'integer',
    },
    lock_repositories: {
      example: true,
      type: 'boolean',
    },
    node_id: {
      type: 'string',
    },
    org_metadata_only: {
      type: 'boolean',
    },
    owner: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    repositories: {
      description: 'The repositories included in the migration. Only returned for export migrations.',
      items: {
        $ref: '#/components/schemas/repository',
      },
      type: 'array',
    },
    state: {
      example: 'pending',
      type: 'string',
    },
    updated_at: {
      example: '2015-07-06T15:33:38-07:00',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/orgs/octo-org/migrations/79',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'owner',
    'guid',
    'state',
    'lock_repositories',
    'exclude_metadata',
    'exclude_git_data',
    'exclude_attachments',
    'exclude_releases',
    'exclude_owner_projects',
    'org_metadata_only',
    'repositories',
    'url',
    'created_at',
    'updated_at',
  ],
  title: 'Migration',
  type: 'object',
} as const;

export const milestoneSchema = {
  description: 'A collection of related issues and pull requests.',
  properties: {
    closed_at: {
      example: '2013-02-12T13:22:01Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    closed_issues: {
      example: 8,
      type: 'integer',
    },
    created_at: {
      example: '2011-04-10T20:09:31Z',
      format: 'date-time',
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    description: {
      example: 'Tracking milestone for version 1.0',
      nullable: true,
      type: 'string',
    },
    due_on: {
      example: '2012-10-09T23:39:01Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/milestones/v1.0',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1002604,
      type: 'integer',
    },
    labels_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/milestones/1/labels',
      format: 'uri',
      type: 'string',
    },
    node_id: {
      example: 'MDk6TWlsZXN0b25lMTAwMjYwNA==',
      type: 'string',
    },
    number: {
      description: 'The number of the milestone.',
      example: 42,
      type: 'integer',
    },
    open_issues: {
      example: 4,
      type: 'integer',
    },
    state: {
      default: 'open',
      description: 'The state of the milestone.',
      enum: ['open', 'closed'],
      example: 'open',
      type: 'string',
    },
    title: {
      description: 'The title of the milestone.',
      example: 'v1.0',
      type: 'string',
    },
    updated_at: {
      example: '2014-03-03T18:58:10Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/milestones/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'closed_issues',
    'creator',
    'description',
    'due_on',
    'closed_at',
    'id',
    'node_id',
    'labels_url',
    'html_url',
    'number',
    'open_issues',
    'state',
    'title',
    'url',
    'created_at',
    'updated_at',
  ],
  title: 'Milestone',
  type: 'object',
} as const;

export const milestoned_issue_eventSchema = {
  description: 'Milestoned Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    milestone: {
      properties: {
        title: {
          type: 'string',
        },
      },
      required: ['title'],
      type: 'object',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'milestone',
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Milestoned Issue Event',
  type: 'object',
} as const;

export const minimal_repositorySchema = {
  description: 'Minimal Repository',
  properties: {
    allow_forking: {
      type: 'boolean',
    },
    archive_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}',
      type: 'string',
    },
    archived: {
      type: 'boolean',
    },
    assignees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/assignees{/user}',
      type: 'string',
    },
    blobs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}',
      type: 'string',
    },
    branches_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/branches{/branch}',
      type: 'string',
    },
    clone_url: {
      type: 'string',
    },
    code_of_conduct: {
      $ref: '#/components/schemas/code-of-conduct',
    },
    collaborators_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}',
      type: 'string',
    },
    comments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/comments{/number}',
      type: 'string',
    },
    commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/commits{/sha}',
      type: 'string',
    },
    compare_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}',
      type: 'string',
    },
    contents_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contents/{+path}',
      type: 'string',
    },
    contributors_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contributors',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    default_branch: {
      type: 'string',
    },
    delete_branch_on_merge: {
      type: 'boolean',
    },
    deployments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/deployments',
      format: 'uri',
      type: 'string',
    },
    description: {
      example: 'This your first repo!',
      nullable: true,
      type: 'string',
    },
    disabled: {
      type: 'boolean',
    },
    downloads_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/downloads',
      format: 'uri',
      type: 'string',
    },
    events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/events',
      format: 'uri',
      type: 'string',
    },
    fork: {
      type: 'boolean',
    },
    forks: {
      example: 0,
      type: 'integer',
    },
    forks_count: {
      type: 'integer',
    },
    forks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/forks',
      format: 'uri',
      type: 'string',
    },
    full_name: {
      example: 'octocat/Hello-World',
      type: 'string',
    },
    git_commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}',
      type: 'string',
    },
    git_refs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}',
      type: 'string',
    },
    git_tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}',
      type: 'string',
    },
    git_url: {
      type: 'string',
    },
    has_discussions: {
      type: 'boolean',
    },
    has_downloads: {
      type: 'boolean',
    },
    has_issues: {
      type: 'boolean',
    },
    has_pages: {
      type: 'boolean',
    },
    has_projects: {
      type: 'boolean',
    },
    has_wiki: {
      type: 'boolean',
    },
    homepage: {
      nullable: true,
      type: 'string',
    },
    hooks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/hooks',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1296269,
      type: 'integer',
    },
    is_template: {
      type: 'boolean',
    },
    issue_comment_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}',
      type: 'string',
    },
    issue_events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/events{/number}',
      type: 'string',
    },
    issues_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues{/number}',
      type: 'string',
    },
    keys_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/keys{/key_id}',
      type: 'string',
    },
    labels_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/labels{/name}',
      type: 'string',
    },
    language: {
      nullable: true,
      type: 'string',
    },
    languages_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/languages',
      format: 'uri',
      type: 'string',
    },
    license: {
      nullable: true,
      properties: {
        key: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        spdx_id: {
          type: 'string',
        },
        url: {
          type: 'string',
        },
      },
      type: 'object',
    },
    merges_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/merges',
      format: 'uri',
      type: 'string',
    },
    milestones_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/milestones{/number}',
      type: 'string',
    },
    mirror_url: {
      nullable: true,
      type: 'string',
    },
    name: {
      example: 'Hello-World',
      type: 'string',
    },
    network_count: {
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5',
      type: 'string',
    },
    notifications_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}',
      type: 'string',
    },
    open_issues: {
      example: 0,
      type: 'integer',
    },
    open_issues_count: {
      type: 'integer',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    private: {
      type: 'boolean',
    },
    pulls_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/pulls{/number}',
      type: 'string',
    },
    pushed_at: {
      example: '2011-01-26T19:06:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    releases_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/releases{/id}',
      type: 'string',
    },
    role_name: {
      example: 'admin',
      type: 'string',
    },
    security_and_analysis: {
      $ref: '#/components/schemas/security-and-analysis',
    },
    size: {
      description:
        'The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.',
      type: 'integer',
    },
    ssh_url: {
      type: 'string',
    },
    stargazers_count: {
      type: 'integer',
    },
    stargazers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/stargazers',
      format: 'uri',
      type: 'string',
    },
    statuses_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/statuses/{sha}',
      type: 'string',
    },
    subscribers_count: {
      type: 'integer',
    },
    subscribers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscribers',
      format: 'uri',
      type: 'string',
    },
    subscription_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscription',
      format: 'uri',
      type: 'string',
    },
    svn_url: {
      type: 'string',
    },
    tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/tags',
      format: 'uri',
      type: 'string',
    },
    teams_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/teams',
      format: 'uri',
      type: 'string',
    },
    temp_clone_token: {
      type: 'string',
    },
    topics: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    trees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:14:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    visibility: {
      type: 'string',
    },
    watchers: {
      example: 0,
      type: 'integer',
    },
    watchers_count: {
      type: 'integer',
    },
    web_commit_signoff_required: {
      example: false,
      type: 'boolean',
    },
  },
  required: [
    'archive_url',
    'assignees_url',
    'blobs_url',
    'branches_url',
    'collaborators_url',
    'comments_url',
    'commits_url',
    'compare_url',
    'contents_url',
    'contributors_url',
    'deployments_url',
    'description',
    'downloads_url',
    'events_url',
    'fork',
    'forks_url',
    'full_name',
    'git_commits_url',
    'git_refs_url',
    'git_tags_url',
    'hooks_url',
    'html_url',
    'id',
    'node_id',
    'issue_comment_url',
    'issue_events_url',
    'issues_url',
    'keys_url',
    'labels_url',
    'languages_url',
    'merges_url',
    'milestones_url',
    'name',
    'notifications_url',
    'owner',
    'private',
    'pulls_url',
    'releases_url',
    'stargazers_url',
    'statuses_url',
    'subscribers_url',
    'subscription_url',
    'tags_url',
    'teams_url',
    'trees_url',
    'url',
  ],
  title: 'Minimal Repository',
  type: 'object',
} as const;

export const moved_column_in_project_issue_eventSchema = {
  description: 'Moved Column in Project Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    project_card: {
      properties: {
        column_name: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        previous_column_name: {
          type: 'string',
        },
        project_id: {
          type: 'integer',
        },
        project_url: {
          format: 'uri',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['id', 'url', 'project_id', 'project_url', 'column_name'],
      type: 'object',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Moved Column in Project Issue Event',
  type: 'object',
} as const;

export const nullable_alert_updated_atSchema = {
  description: 'The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
  format: 'date-time',
  nullable: true,
  readOnly: true,
  type: 'string',
} as const;

export const nullable_code_of_conduct_simpleSchema = {
  description: 'Code of Conduct Simple',
  nullable: true,
  properties: {
    html_url: {
      example: 'https://github.com/github/docs/blob/main/CODE_OF_CONDUCT.md',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    key: {
      example: 'citizen_code_of_conduct',
      type: 'string',
    },
    name: {
      example: 'Citizen Code of Conduct',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/github/docs/community/code_of_conduct',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'key', 'name', 'html_url'],
  title: 'Code Of Conduct Simple',
  type: 'object',
} as const;

export const nullable_codespace_machineSchema = {
  description: 'A description of the machine powering a codespace.',
  nullable: true,
  properties: {
    cpus: {
      description: 'How many cores are available to the codespace.',
      example: 4,
      type: 'integer',
    },
    display_name: {
      description: 'The display name of the machine includes cores, memory, and storage.',
      example: '4 cores, 8 GB RAM, 64 GB storage',
      type: 'string',
    },
    memory_in_bytes: {
      description: 'How much memory is available to the codespace.',
      example: 8589934592,
      type: 'integer',
    },
    name: {
      description: 'The name of the machine.',
      example: 'standardLinux',
      type: 'string',
    },
    operating_system: {
      description: 'The operating system of the machine.',
      example: 'linux',
      type: 'string',
    },
    prebuild_availability: {
      description:
        'Whether a prebuild is currently available when creating a codespace for this machine and repository. If a branch was not specified as a ref, the default branch will be assumed. Value will be "null" if prebuilds are not supported or prebuild availability could not be determined. Value will be "none" if no prebuild is available. Latest values "ready" and "in_progress" indicate the prebuild availability status.',
      enum: ['none', 'ready', 'in_progress'],
      example: 'ready',
      nullable: true,
      type: 'string',
    },
    storage_in_bytes: {
      description: 'How much storage is available to the codespace.',
      example: 68719476736,
      type: 'integer',
    },
  },
  required: [
    'name',
    'display_name',
    'operating_system',
    'storage_in_bytes',
    'memory_in_bytes',
    'cpus',
    'prebuild_availability',
  ],
  title: 'Codespace machine',
  type: 'object',
} as const;

export const nullable_collaboratorSchema = {
  description: 'Collaborator',
  nullable: true,
  properties: {
    avatar_url: {
      example: 'https://github.com/images/error/octocat_happy.gif',
      format: 'uri',
      type: 'string',
    },
    email: {
      nullable: true,
      type: 'string',
    },
    events_url: {
      example: 'https://api.github.com/users/octocat/events{/privacy}',
      type: 'string',
    },
    followers_url: {
      example: 'https://api.github.com/users/octocat/followers',
      format: 'uri',
      type: 'string',
    },
    following_url: {
      example: 'https://api.github.com/users/octocat/following{/other_user}',
      type: 'string',
    },
    gists_url: {
      example: 'https://api.github.com/users/octocat/gists{/gist_id}',
      type: 'string',
    },
    gravatar_id: {
      example: '41d064eb2195891e12d0413f63227ea7',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    login: {
      example: 'octocat',
      type: 'string',
    },
    name: {
      nullable: true,
      type: 'string',
    },
    node_id: {
      example: 'MDQ6VXNlcjE=',
      type: 'string',
    },
    organizations_url: {
      example: 'https://api.github.com/users/octocat/orgs',
      format: 'uri',
      type: 'string',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      required: ['pull', 'push', 'admin'],
      type: 'object',
    },
    received_events_url: {
      example: 'https://api.github.com/users/octocat/received_events',
      format: 'uri',
      type: 'string',
    },
    repos_url: {
      example: 'https://api.github.com/users/octocat/repos',
      format: 'uri',
      type: 'string',
    },
    role_name: {
      example: 'admin',
      type: 'string',
    },
    site_admin: {
      type: 'boolean',
    },
    starred_url: {
      example: 'https://api.github.com/users/octocat/starred{/owner}{/repo}',
      type: 'string',
    },
    subscriptions_url: {
      example: 'https://api.github.com/users/octocat/subscriptions',
      format: 'uri',
      type: 'string',
    },
    type: {
      example: 'User',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/users/octocat',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'avatar_url',
    'events_url',
    'followers_url',
    'following_url',
    'gists_url',
    'gravatar_id',
    'html_url',
    'id',
    'node_id',
    'login',
    'organizations_url',
    'received_events_url',
    'repos_url',
    'site_admin',
    'starred_url',
    'subscriptions_url',
    'type',
    'url',
    'role_name',
  ],
  title: 'Collaborator',
  type: 'object',
} as const;

export const nullable_community_health_fileSchema = {
  nullable: true,
  properties: {
    html_url: {
      format: 'uri',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'html_url'],
  title: 'Community Health File',
  type: 'object',
} as const;

export const nullable_git_userSchema = {
  description: 'Metaproperties for Git author/committer information.',
  nullable: true,
  properties: {
    date: {
      example: '"2007-10-29T02:42:39.000-07:00"',
      type: 'string',
    },
    email: {
      example: '"chris@ozmm.org"',
      type: 'string',
    },
    name: {
      example: '"Chris Wanstrath"',
      type: 'string',
    },
  },
  title: 'Git User',
  type: 'object',
} as const;

export const nullable_integrationSchema = {
  description:
    'GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.',
  nullable: true,
  properties: {
    client_id: {
      example: '"Iv1.25b5d1e65ffc4022"',
      type: 'string',
    },
    client_secret: {
      example: '"1d4b2097ac622ba702d19de498f005747a8b21d3"',
      type: 'string',
    },
    created_at: {
      example: '2017-07-08T16:18:44-04:00',
      format: 'date-time',
      type: 'string',
    },
    description: {
      example: 'The description of the app.',
      nullable: true,
      type: 'string',
    },
    events: {
      description: 'The list of events for the GitHub app',
      example: ['label', 'deployment'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    external_url: {
      example: 'https://example.com',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/apps/super-ci',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the GitHub app',
      example: 37,
      type: 'integer',
    },
    installations_count: {
      description: 'The number of installations associated with the GitHub app',
      example: 5,
      type: 'integer',
    },
    name: {
      description: 'The name of the GitHub app',
      example: 'Probot Owners',
      type: 'string',
    },
    node_id: {
      example: 'MDExOkludGVncmF0aW9uMQ==',
      type: 'string',
    },
    owner: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    pem: {
      example:
        '"-----BEGIN RSA PRIVATE KEY-----\\nMIIEogIBAAKCAQEArYxrNYD/iT5CZVpRJu4rBKmmze3PVmT/gCo2ATUvDvZTPTey\\nxcGJ3vvrJXazKk06pN05TN29o98jrYz4cengG3YGsXPNEpKsIrEl8NhbnxapEnM9\\nJCMRe0P5JcPsfZlX6hmiT7136GRWiGOUba2X9+HKh8QJVLG5rM007TBER9/z9mWm\\nrJuNh+m5l320oBQY/Qq3A7wzdEfZw8qm/mIN0FCeoXH1L6B8xXWaAYBwhTEh6SSn\\nZHlO1Xu1JWDmAvBCi0RO5aRSKM8q9QEkvvHP4yweAtK3N8+aAbZ7ovaDhyGz8r6r\\nzhU1b8Uo0Z2ysf503WqzQgIajr7Fry7/kUwpgQIDAQABAoIBADwJp80Ko1xHPZDy\\nfcCKBDfIuPvkmSW6KumbsLMaQv1aGdHDwwTGv3t0ixSay8CGlxMRtRDyZPib6SvQ\\n6OH/lpfpbMdW2ErkksgtoIKBVrDilfrcAvrNZu7NxRNbhCSvN8q0s4ICecjbbVQh\\nnueSdlA6vGXbW58BHMq68uRbHkP+k+mM9U0mDJ1HMch67wlg5GbayVRt63H7R2+r\\nVxcna7B80J/lCEjIYZznawgiTvp3MSanTglqAYi+m1EcSsP14bJIB9vgaxS79kTu\\noiSo93leJbBvuGo8QEiUqTwMw4tDksmkLsoqNKQ1q9P7LZ9DGcujtPy4EZsamSJT\\ny8OJt0ECgYEA2lxOxJsQk2kI325JgKFjo92mQeUObIvPfSNWUIZQDTjniOI6Gv63\\nGLWVFrZcvQBWjMEQraJA9xjPbblV8PtfO87MiJGLWCHFxmPz2dzoedN+2Coxom8m\\nV95CLz8QUShuao6u/RYcvUaZEoYs5bHcTmy5sBK80JyEmafJPtCQVxMCgYEAy3ar\\nZr3yv4xRPEPMat4rseswmuMooSaK3SKub19WFI5IAtB/e7qR1Rj9JhOGcZz+OQrl\\nT78O2OFYlgOIkJPvRMrPpK5V9lslc7tz1FSh3BZMRGq5jSyD7ETSOQ0c8T2O/s7v\\nbeEPbVbDe4mwvM24XByH0GnWveVxaDl51ABD65sCgYB3ZAspUkOA5egVCh8kNpnd\\nSd6SnuQBE3ySRlT2WEnCwP9Ph6oPgn+oAfiPX4xbRqkL8q/k0BdHQ4h+zNwhk7+h\\nWtPYRAP1Xxnc/F+jGjb+DVaIaKGU18MWPg7f+FI6nampl3Q0KvfxwX0GdNhtio8T\\nTj1E+SnFwh56SRQuxSh2gwKBgHKjlIO5NtNSflsUYFM+hyQiPiqnHzddfhSG+/3o\\nm5nNaSmczJesUYreH5San7/YEy2UxAugvP7aSY2MxB+iGsiJ9WD2kZzTUlDZJ7RV\\nUzWsoqBR+eZfVJ2FUWWvy8TpSG6trh4dFxImNtKejCR1TREpSiTV3Zb1dmahK9GV\\nrK9NAoGAbBxRLoC01xfxCTgt5BDiBcFVh4fp5yYKwavJPLzHSpuDOrrI9jDn1oKN\\nonq5sDU1i391zfQvdrbX4Ova48BN+B7p63FocP/MK5tyyBoT8zQEk2+vWDOw7H/Z\\nu5dTCPxTIsoIwUw1I+7yIxqJzLPFgR2gVBwY1ra/8iAqCj+zeBw=\\n-----END RSA PRIVATE KEY-----\\n"',
      type: 'string',
    },
    permissions: {
      additionalProperties: {
        type: 'string',
      },
      description: 'The set of permissions for the GitHub app',
      example: {
        deployments: 'write',
        issues: 'read',
      },
      properties: {
        checks: {
          type: 'string',
        },
        contents: {
          type: 'string',
        },
        deployments: {
          type: 'string',
        },
        issues: {
          type: 'string',
        },
        metadata: {
          type: 'string',
        },
      },
      type: 'object',
    },
    slug: {
      description: 'The slug name of the GitHub app',
      example: 'probot-owners',
      type: 'string',
    },
    updated_at: {
      example: '2017-07-08T16:18:44-04:00',
      format: 'date-time',
      type: 'string',
    },
    webhook_secret: {
      example: '"6fba8f2fc8a7e8f2cca5577eddd82ca7586b3b6b"',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'owner',
    'name',
    'description',
    'external_url',
    'html_url',
    'created_at',
    'updated_at',
    'permissions',
    'events',
  ],
  title: 'GitHub app',
  type: 'object',
} as const;

export const nullable_issueSchema = {
  description: 'Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.',
  nullable: true,
  properties: {
    active_lock_reason: {
      nullable: true,
      type: 'string',
    },
    assignee: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    assignees: {
      items: {
        $ref: '#/components/schemas/simple-user',
      },
      nullable: true,
      type: 'array',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      description: 'Contents of the issue',
      example:
        'It looks like the new widget form is broken on Safari. When I try and create the widget, Safari crashes. This is reproducible on 10.8, but not 10.9. Maybe a browser bug?',
      nullable: true,
      type: 'string',
    },
    body_html: {
      type: 'string',
    },
    body_text: {
      type: 'string',
    },
    closed_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    closed_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    comments: {
      type: 'integer',
    },
    comments_url: {
      format: 'uri',
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    draft: {
      type: 'boolean',
    },
    events_url: {
      format: 'uri',
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    labels: {
      description:
        'Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository',
      example: ['bug', 'registration'],
      items: {
        oneOf: [
          {
            type: 'string',
          },
          {
            properties: {
              color: {
                nullable: true,
                type: 'string',
              },
              default: {
                type: 'boolean',
              },
              description: {
                nullable: true,
                type: 'string',
              },
              id: {
                format: 'int64',
                type: 'integer',
              },
              name: {
                type: 'string',
              },
              node_id: {
                type: 'string',
              },
              url: {
                format: 'uri',
                type: 'string',
              },
            },
            type: 'object',
          },
        ],
      },
      type: 'array',
    },
    labels_url: {
      type: 'string',
    },
    locked: {
      type: 'boolean',
    },
    milestone: {
      $ref: '#/components/schemas/nullable-milestone',
    },
    node_id: {
      type: 'string',
    },
    number: {
      description: 'Number uniquely identifying the issue within its repository',
      example: 42,
      type: 'integer',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    pull_request: {
      properties: {
        diff_url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        html_url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        merged_at: {
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        patch_url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
        url: {
          format: 'uri',
          nullable: true,
          type: 'string',
        },
      },
      required: ['diff_url', 'html_url', 'patch_url', 'url'],
      type: 'object',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    repository_url: {
      format: 'uri',
      type: 'string',
    },
    state: {
      description: "State of the issue; either 'open' or 'closed'",
      example: 'open',
      type: 'string',
    },
    state_reason: {
      description: 'The reason for the current state',
      enum: ['completed', 'reopened', 'not_planned'],
      example: 'not_planned',
      nullable: true,
      type: 'string',
    },
    timeline_url: {
      format: 'uri',
      type: 'string',
    },
    title: {
      description: 'Title of the issue',
      example: 'Widget creation fails in Safari on OS X 10.8',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      description: 'URL for the issue',
      example: 'https://api.github.com/repositories/42/issues/1',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    'assignee',
    'closed_at',
    'comments',
    'comments_url',
    'events_url',
    'html_url',
    'id',
    'node_id',
    'labels',
    'labels_url',
    'milestone',
    'number',
    'repository_url',
    'state',
    'locked',
    'title',
    'url',
    'user',
    'author_association',
    'created_at',
    'updated_at',
  ],
  title: 'Issue',
  type: 'object',
} as const;

export const nullable_license_simpleSchema = {
  description: 'License Simple',
  nullable: true,
  properties: {
    html_url: {
      format: 'uri',
      type: 'string',
    },
    key: {
      example: 'mit',
      type: 'string',
    },
    name: {
      example: 'MIT License',
      type: 'string',
    },
    node_id: {
      example: 'MDc6TGljZW5zZW1pdA==',
      type: 'string',
    },
    spdx_id: {
      example: 'MIT',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/licenses/mit',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  required: ['key', 'name', 'url', 'spdx_id', 'node_id'],
  title: 'License Simple',
  type: 'object',
} as const;

export const nullable_milestoneSchema = {
  description: 'A collection of related issues and pull requests.',
  nullable: true,
  properties: {
    closed_at: {
      example: '2013-02-12T13:22:01Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    closed_issues: {
      example: 8,
      type: 'integer',
    },
    created_at: {
      example: '2011-04-10T20:09:31Z',
      format: 'date-time',
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    description: {
      example: 'Tracking milestone for version 1.0',
      nullable: true,
      type: 'string',
    },
    due_on: {
      example: '2012-10-09T23:39:01Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/milestones/v1.0',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1002604,
      type: 'integer',
    },
    labels_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/milestones/1/labels',
      format: 'uri',
      type: 'string',
    },
    node_id: {
      example: 'MDk6TWlsZXN0b25lMTAwMjYwNA==',
      type: 'string',
    },
    number: {
      description: 'The number of the milestone.',
      example: 42,
      type: 'integer',
    },
    open_issues: {
      example: 4,
      type: 'integer',
    },
    state: {
      default: 'open',
      description: 'The state of the milestone.',
      enum: ['open', 'closed'],
      example: 'open',
      type: 'string',
    },
    title: {
      description: 'The title of the milestone.',
      example: 'v1.0',
      type: 'string',
    },
    updated_at: {
      example: '2014-03-03T18:58:10Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/milestones/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'closed_issues',
    'creator',
    'description',
    'due_on',
    'closed_at',
    'id',
    'node_id',
    'labels_url',
    'html_url',
    'number',
    'open_issues',
    'state',
    'title',
    'url',
    'created_at',
    'updated_at',
  ],
  title: 'Milestone',
  type: 'object',
} as const;

export const nullable_minimal_repositorySchema = {
  description: 'Minimal Repository',
  nullable: true,
  properties: {
    allow_forking: {
      type: 'boolean',
    },
    archive_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}',
      type: 'string',
    },
    archived: {
      type: 'boolean',
    },
    assignees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/assignees{/user}',
      type: 'string',
    },
    blobs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}',
      type: 'string',
    },
    branches_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/branches{/branch}',
      type: 'string',
    },
    clone_url: {
      type: 'string',
    },
    code_of_conduct: {
      $ref: '#/components/schemas/code-of-conduct',
    },
    collaborators_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}',
      type: 'string',
    },
    comments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/comments{/number}',
      type: 'string',
    },
    commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/commits{/sha}',
      type: 'string',
    },
    compare_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}',
      type: 'string',
    },
    contents_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contents/{+path}',
      type: 'string',
    },
    contributors_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contributors',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    default_branch: {
      type: 'string',
    },
    delete_branch_on_merge: {
      type: 'boolean',
    },
    deployments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/deployments',
      format: 'uri',
      type: 'string',
    },
    description: {
      example: 'This your first repo!',
      nullable: true,
      type: 'string',
    },
    disabled: {
      type: 'boolean',
    },
    downloads_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/downloads',
      format: 'uri',
      type: 'string',
    },
    events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/events',
      format: 'uri',
      type: 'string',
    },
    fork: {
      type: 'boolean',
    },
    forks: {
      example: 0,
      type: 'integer',
    },
    forks_count: {
      type: 'integer',
    },
    forks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/forks',
      format: 'uri',
      type: 'string',
    },
    full_name: {
      example: 'octocat/Hello-World',
      type: 'string',
    },
    git_commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}',
      type: 'string',
    },
    git_refs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}',
      type: 'string',
    },
    git_tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}',
      type: 'string',
    },
    git_url: {
      type: 'string',
    },
    has_discussions: {
      type: 'boolean',
    },
    has_downloads: {
      type: 'boolean',
    },
    has_issues: {
      type: 'boolean',
    },
    has_pages: {
      type: 'boolean',
    },
    has_projects: {
      type: 'boolean',
    },
    has_wiki: {
      type: 'boolean',
    },
    homepage: {
      nullable: true,
      type: 'string',
    },
    hooks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/hooks',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1296269,
      type: 'integer',
    },
    is_template: {
      type: 'boolean',
    },
    issue_comment_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}',
      type: 'string',
    },
    issue_events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/events{/number}',
      type: 'string',
    },
    issues_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues{/number}',
      type: 'string',
    },
    keys_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/keys{/key_id}',
      type: 'string',
    },
    labels_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/labels{/name}',
      type: 'string',
    },
    language: {
      nullable: true,
      type: 'string',
    },
    languages_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/languages',
      format: 'uri',
      type: 'string',
    },
    license: {
      nullable: true,
      properties: {
        key: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        spdx_id: {
          type: 'string',
        },
        url: {
          type: 'string',
        },
      },
      type: 'object',
    },
    merges_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/merges',
      format: 'uri',
      type: 'string',
    },
    milestones_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/milestones{/number}',
      type: 'string',
    },
    mirror_url: {
      nullable: true,
      type: 'string',
    },
    name: {
      example: 'Hello-World',
      type: 'string',
    },
    network_count: {
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5',
      type: 'string',
    },
    notifications_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}',
      type: 'string',
    },
    open_issues: {
      example: 0,
      type: 'integer',
    },
    open_issues_count: {
      type: 'integer',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    private: {
      type: 'boolean',
    },
    pulls_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/pulls{/number}',
      type: 'string',
    },
    pushed_at: {
      example: '2011-01-26T19:06:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    releases_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/releases{/id}',
      type: 'string',
    },
    role_name: {
      example: 'admin',
      type: 'string',
    },
    security_and_analysis: {
      $ref: '#/components/schemas/security-and-analysis',
    },
    size: {
      description:
        'The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.',
      type: 'integer',
    },
    ssh_url: {
      type: 'string',
    },
    stargazers_count: {
      type: 'integer',
    },
    stargazers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/stargazers',
      format: 'uri',
      type: 'string',
    },
    statuses_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/statuses/{sha}',
      type: 'string',
    },
    subscribers_count: {
      type: 'integer',
    },
    subscribers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscribers',
      format: 'uri',
      type: 'string',
    },
    subscription_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscription',
      format: 'uri',
      type: 'string',
    },
    svn_url: {
      type: 'string',
    },
    tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/tags',
      format: 'uri',
      type: 'string',
    },
    teams_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/teams',
      format: 'uri',
      type: 'string',
    },
    temp_clone_token: {
      type: 'string',
    },
    topics: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    trees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:14:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    visibility: {
      type: 'string',
    },
    watchers: {
      example: 0,
      type: 'integer',
    },
    watchers_count: {
      type: 'integer',
    },
    web_commit_signoff_required: {
      example: false,
      type: 'boolean',
    },
  },
  required: [
    'archive_url',
    'assignees_url',
    'blobs_url',
    'branches_url',
    'collaborators_url',
    'comments_url',
    'commits_url',
    'compare_url',
    'contents_url',
    'contributors_url',
    'deployments_url',
    'description',
    'downloads_url',
    'events_url',
    'fork',
    'forks_url',
    'full_name',
    'git_commits_url',
    'git_refs_url',
    'git_tags_url',
    'hooks_url',
    'html_url',
    'id',
    'node_id',
    'issue_comment_url',
    'issue_events_url',
    'issues_url',
    'keys_url',
    'labels_url',
    'languages_url',
    'merges_url',
    'milestones_url',
    'name',
    'notifications_url',
    'owner',
    'private',
    'pulls_url',
    'releases_url',
    'stargazers_url',
    'statuses_url',
    'subscribers_url',
    'subscription_url',
    'tags_url',
    'teams_url',
    'trees_url',
    'url',
  ],
  title: 'Minimal Repository',
  type: 'object',
} as const;

export const nullable_repositorySchema = {
  description: 'A repository on GitHub.',
  nullable: true,
  properties: {
    allow_auto_merge: {
      default: false,
      description: 'Whether to allow Auto-merge to be used on pull requests.',
      example: false,
      type: 'boolean',
    },
    allow_forking: {
      description: 'Whether to allow forking this repo',
      type: 'boolean',
    },
    allow_merge_commit: {
      default: true,
      description: 'Whether to allow merge commits for pull requests.',
      example: true,
      type: 'boolean',
    },
    allow_rebase_merge: {
      default: true,
      description: 'Whether to allow rebase merges for pull requests.',
      example: true,
      type: 'boolean',
    },
    allow_squash_merge: {
      default: true,
      description: 'Whether to allow squash merges for pull requests.',
      example: true,
      type: 'boolean',
    },
    allow_update_branch: {
      default: false,
      description:
        'Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.',
      example: false,
      type: 'boolean',
    },
    anonymous_access_enabled: {
      description: 'Whether anonymous git access is enabled for this repository',
      type: 'boolean',
    },
    archive_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}',
      type: 'string',
    },
    archived: {
      default: false,
      description: 'Whether the repository is archived.',
      type: 'boolean',
    },
    assignees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/assignees{/user}',
      type: 'string',
    },
    blobs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}',
      type: 'string',
    },
    branches_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/branches{/branch}',
      type: 'string',
    },
    clone_url: {
      example: 'https://github.com/octocat/Hello-World.git',
      type: 'string',
    },
    collaborators_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}',
      type: 'string',
    },
    comments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/comments{/number}',
      type: 'string',
    },
    commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/commits{/sha}',
      type: 'string',
    },
    compare_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}',
      type: 'string',
    },
    contents_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contents/{+path}',
      type: 'string',
    },
    contributors_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contributors',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    default_branch: {
      description: 'The default branch of the repository.',
      example: 'master',
      type: 'string',
    },
    delete_branch_on_merge: {
      default: false,
      description: 'Whether to delete head branches when pull requests are merged',
      example: false,
      type: 'boolean',
    },
    deployments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/deployments',
      format: 'uri',
      type: 'string',
    },
    description: {
      example: 'This your first repo!',
      nullable: true,
      type: 'string',
    },
    disabled: {
      description: 'Returns whether or not this repository disabled.',
      type: 'boolean',
    },
    downloads_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/downloads',
      format: 'uri',
      type: 'string',
    },
    events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/events',
      format: 'uri',
      type: 'string',
    },
    fork: {
      type: 'boolean',
    },
    forks: {
      type: 'integer',
    },
    forks_count: {
      example: 9,
      type: 'integer',
    },
    forks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/forks',
      format: 'uri',
      type: 'string',
    },
    full_name: {
      example: 'octocat/Hello-World',
      type: 'string',
    },
    git_commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}',
      type: 'string',
    },
    git_refs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}',
      type: 'string',
    },
    git_tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}',
      type: 'string',
    },
    git_url: {
      example: 'git:github.com/octocat/Hello-World.git',
      type: 'string',
    },
    has_discussions: {
      default: false,
      description: 'Whether discussions are enabled.',
      example: true,
      type: 'boolean',
    },
    has_downloads: {
      default: true,
      description: 'Whether downloads are enabled.',
      example: true,
      type: 'boolean',
    },
    has_issues: {
      default: true,
      description: 'Whether issues are enabled.',
      example: true,
      type: 'boolean',
    },
    has_pages: {
      type: 'boolean',
    },
    has_projects: {
      default: true,
      description: 'Whether projects are enabled.',
      example: true,
      type: 'boolean',
    },
    has_wiki: {
      default: true,
      description: 'Whether the wiki is enabled.',
      example: true,
      type: 'boolean',
    },
    homepage: {
      example: 'https://github.com',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    hooks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/hooks',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the repository',
      example: 42,
      type: 'integer',
    },
    is_template: {
      default: false,
      description: 'Whether this repository acts as a template that can be used to generate new repositories.',
      example: true,
      type: 'boolean',
    },
    issue_comment_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}',
      type: 'string',
    },
    issue_events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/events{/number}',
      type: 'string',
    },
    issues_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues{/number}',
      type: 'string',
    },
    keys_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/keys{/key_id}',
      type: 'string',
    },
    labels_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/labels{/name}',
      type: 'string',
    },
    language: {
      nullable: true,
      type: 'string',
    },
    languages_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/languages',
      format: 'uri',
      type: 'string',
    },
    license: {
      $ref: '#/components/schemas/nullable-license-simple',
    },
    master_branch: {
      type: 'string',
    },
    merge_commit_message: {
      description: `The default value for a merge commit message.

- \`PR_TITLE\` - default to the pull request's title.
- \`PR_BODY\` - default to the pull request's body.
- \`BLANK\` - default to a blank commit message.`,
      enum: ['PR_BODY', 'PR_TITLE', 'BLANK'],
      type: 'string',
    },
    merge_commit_title: {
      description: `The default value for a merge commit title.

- \`PR_TITLE\` - default to the pull request's title.
- \`MERGE_MESSAGE\` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).`,
      enum: ['PR_TITLE', 'MERGE_MESSAGE'],
      type: 'string',
    },
    merges_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/merges',
      format: 'uri',
      type: 'string',
    },
    milestones_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/milestones{/number}',
      type: 'string',
    },
    mirror_url: {
      example: 'git:git.example.com/octocat/Hello-World',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      description: 'The name of the repository.',
      example: 'Team Environment',
      type: 'string',
    },
    network_count: {
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5',
      type: 'string',
    },
    notifications_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}',
      type: 'string',
    },
    open_issues: {
      type: 'integer',
    },
    open_issues_count: {
      example: 0,
      type: 'integer',
    },
    organization: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      required: ['admin', 'pull', 'push'],
      type: 'object',
    },
    private: {
      default: false,
      description: 'Whether the repository is private or public.',
      type: 'boolean',
    },
    pulls_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/pulls{/number}',
      type: 'string',
    },
    pushed_at: {
      example: '2011-01-26T19:06:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    releases_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/releases{/id}',
      type: 'string',
    },
    size: {
      description:
        'The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.',
      example: 108,
      type: 'integer',
    },
    squash_merge_commit_message: {
      description: `The default value for a squash merge commit message:

- \`PR_BODY\` - default to the pull request's body.
- \`COMMIT_MESSAGES\` - default to the branch's commit messages.
- \`BLANK\` - default to a blank commit message.`,
      enum: ['PR_BODY', 'COMMIT_MESSAGES', 'BLANK'],
      type: 'string',
    },
    squash_merge_commit_title: {
      description: `The default value for a squash merge commit title:

- \`PR_TITLE\` - default to the pull request's title.
- \`COMMIT_OR_PR_TITLE\` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).`,
      enum: ['PR_TITLE', 'COMMIT_OR_PR_TITLE'],
      type: 'string',
    },
    ssh_url: {
      example: 'git@github.com:octocat/Hello-World.git',
      type: 'string',
    },
    stargazers_count: {
      example: 80,
      type: 'integer',
    },
    stargazers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/stargazers',
      format: 'uri',
      type: 'string',
    },
    starred_at: {
      example: '"2020-07-09T00:17:42Z"',
      type: 'string',
    },
    statuses_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/statuses/{sha}',
      type: 'string',
    },
    subscribers_count: {
      type: 'integer',
    },
    subscribers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscribers',
      format: 'uri',
      type: 'string',
    },
    subscription_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscription',
      format: 'uri',
      type: 'string',
    },
    svn_url: {
      example: 'https://svn.github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/tags',
      format: 'uri',
      type: 'string',
    },
    teams_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/teams',
      format: 'uri',
      type: 'string',
    },
    temp_clone_token: {
      type: 'string',
    },
    template_repository: {
      nullable: true,
      properties: {
        allow_auto_merge: {
          type: 'boolean',
        },
        allow_merge_commit: {
          type: 'boolean',
        },
        allow_rebase_merge: {
          type: 'boolean',
        },
        allow_squash_merge: {
          type: 'boolean',
        },
        allow_update_branch: {
          type: 'boolean',
        },
        archive_url: {
          type: 'string',
        },
        archived: {
          type: 'boolean',
        },
        assignees_url: {
          type: 'string',
        },
        blobs_url: {
          type: 'string',
        },
        branches_url: {
          type: 'string',
        },
        clone_url: {
          type: 'string',
        },
        collaborators_url: {
          type: 'string',
        },
        comments_url: {
          type: 'string',
        },
        commits_url: {
          type: 'string',
        },
        compare_url: {
          type: 'string',
        },
        contents_url: {
          type: 'string',
        },
        contributors_url: {
          type: 'string',
        },
        created_at: {
          type: 'string',
        },
        default_branch: {
          type: 'string',
        },
        delete_branch_on_merge: {
          type: 'boolean',
        },
        deployments_url: {
          type: 'string',
        },
        description: {
          type: 'string',
        },
        disabled: {
          type: 'boolean',
        },
        downloads_url: {
          type: 'string',
        },
        events_url: {
          type: 'string',
        },
        fork: {
          type: 'boolean',
        },
        forks_count: {
          type: 'integer',
        },
        forks_url: {
          type: 'string',
        },
        full_name: {
          type: 'string',
        },
        git_commits_url: {
          type: 'string',
        },
        git_refs_url: {
          type: 'string',
        },
        git_tags_url: {
          type: 'string',
        },
        git_url: {
          type: 'string',
        },
        has_downloads: {
          type: 'boolean',
        },
        has_issues: {
          type: 'boolean',
        },
        has_pages: {
          type: 'boolean',
        },
        has_projects: {
          type: 'boolean',
        },
        has_wiki: {
          type: 'boolean',
        },
        homepage: {
          type: 'string',
        },
        hooks_url: {
          type: 'string',
        },
        html_url: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        is_template: {
          type: 'boolean',
        },
        issue_comment_url: {
          type: 'string',
        },
        issue_events_url: {
          type: 'string',
        },
        issues_url: {
          type: 'string',
        },
        keys_url: {
          type: 'string',
        },
        labels_url: {
          type: 'string',
        },
        language: {
          type: 'string',
        },
        languages_url: {
          type: 'string',
        },
        merge_commit_message: {
          description: `The default value for a merge commit message.

- \`PR_TITLE\` - default to the pull request's title.
- \`PR_BODY\` - default to the pull request's body.
- \`BLANK\` - default to a blank commit message.`,
          enum: ['PR_BODY', 'PR_TITLE', 'BLANK'],
          type: 'string',
        },
        merge_commit_title: {
          description: `The default value for a merge commit title.

- \`PR_TITLE\` - default to the pull request's title.
- \`MERGE_MESSAGE\` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).`,
          enum: ['PR_TITLE', 'MERGE_MESSAGE'],
          type: 'string',
        },
        merges_url: {
          type: 'string',
        },
        milestones_url: {
          type: 'string',
        },
        mirror_url: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        network_count: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        notifications_url: {
          type: 'string',
        },
        open_issues_count: {
          type: 'integer',
        },
        owner: {
          properties: {
            avatar_url: {
              type: 'string',
            },
            events_url: {
              type: 'string',
            },
            followers_url: {
              type: 'string',
            },
            following_url: {
              type: 'string',
            },
            gists_url: {
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              type: 'string',
            },
            received_events_url: {
              type: 'string',
            },
            repos_url: {
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              type: 'string',
            },
            subscriptions_url: {
              type: 'string',
            },
            type: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          type: 'object',
        },
        permissions: {
          properties: {
            admin: {
              type: 'boolean',
            },
            maintain: {
              type: 'boolean',
            },
            pull: {
              type: 'boolean',
            },
            push: {
              type: 'boolean',
            },
            triage: {
              type: 'boolean',
            },
          },
          type: 'object',
        },
        private: {
          type: 'boolean',
        },
        pulls_url: {
          type: 'string',
        },
        pushed_at: {
          type: 'string',
        },
        releases_url: {
          type: 'string',
        },
        size: {
          type: 'integer',
        },
        squash_merge_commit_message: {
          description: `The default value for a squash merge commit message:

- \`PR_BODY\` - default to the pull request's body.
- \`COMMIT_MESSAGES\` - default to the branch's commit messages.
- \`BLANK\` - default to a blank commit message.`,
          enum: ['PR_BODY', 'COMMIT_MESSAGES', 'BLANK'],
          type: 'string',
        },
        squash_merge_commit_title: {
          description: `The default value for a squash merge commit title:

- \`PR_TITLE\` - default to the pull request's title.
- \`COMMIT_OR_PR_TITLE\` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).`,
          enum: ['PR_TITLE', 'COMMIT_OR_PR_TITLE'],
          type: 'string',
        },
        ssh_url: {
          type: 'string',
        },
        stargazers_count: {
          type: 'integer',
        },
        stargazers_url: {
          type: 'string',
        },
        statuses_url: {
          type: 'string',
        },
        subscribers_count: {
          type: 'integer',
        },
        subscribers_url: {
          type: 'string',
        },
        subscription_url: {
          type: 'string',
        },
        svn_url: {
          type: 'string',
        },
        tags_url: {
          type: 'string',
        },
        teams_url: {
          type: 'string',
        },
        temp_clone_token: {
          type: 'string',
        },
        topics: {
          items: {
            type: 'string',
          },
          type: 'array',
        },
        trees_url: {
          type: 'string',
        },
        updated_at: {
          type: 'string',
        },
        url: {
          type: 'string',
        },
        use_squash_pr_title_as_default: {
          type: 'boolean',
        },
        visibility: {
          type: 'string',
        },
        watchers_count: {
          type: 'integer',
        },
      },
      type: 'object',
    },
    topics: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    trees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:14:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    use_squash_pr_title_as_default: {
      default: false,
      deprecated: true,
      description:
        'Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.',
      type: 'boolean',
    },
    visibility: {
      default: 'public',
      description: 'The repository visibility: public, private, or internal.',
      type: 'string',
    },
    watchers: {
      type: 'integer',
    },
    watchers_count: {
      example: 80,
      type: 'integer',
    },
    web_commit_signoff_required: {
      default: false,
      description: 'Whether to require contributors to sign off on web-based commits',
      type: 'boolean',
    },
  },
  required: [
    'archive_url',
    'assignees_url',
    'blobs_url',
    'branches_url',
    'collaborators_url',
    'comments_url',
    'commits_url',
    'compare_url',
    'contents_url',
    'contributors_url',
    'deployments_url',
    'description',
    'downloads_url',
    'events_url',
    'fork',
    'forks_url',
    'full_name',
    'git_commits_url',
    'git_refs_url',
    'git_tags_url',
    'hooks_url',
    'html_url',
    'id',
    'node_id',
    'issue_comment_url',
    'issue_events_url',
    'issues_url',
    'keys_url',
    'labels_url',
    'languages_url',
    'merges_url',
    'milestones_url',
    'name',
    'notifications_url',
    'owner',
    'private',
    'pulls_url',
    'releases_url',
    'stargazers_url',
    'statuses_url',
    'subscribers_url',
    'subscription_url',
    'tags_url',
    'teams_url',
    'trees_url',
    'url',
    'clone_url',
    'default_branch',
    'forks',
    'forks_count',
    'git_url',
    'has_downloads',
    'has_issues',
    'has_projects',
    'has_wiki',
    'has_pages',
    'homepage',
    'language',
    'archived',
    'disabled',
    'mirror_url',
    'open_issues',
    'open_issues_count',
    'license',
    'pushed_at',
    'size',
    'ssh_url',
    'stargazers_count',
    'svn_url',
    'watchers',
    'watchers_count',
    'created_at',
    'updated_at',
  ],
  title: 'Repository',
  type: 'object',
} as const;

export const nullable_scoped_installationSchema = {
  nullable: true,
  properties: {
    account: {
      $ref: '#/components/schemas/simple-user',
    },
    has_multiple_single_files: {
      example: true,
      type: 'boolean',
    },
    permissions: {
      $ref: '#/components/schemas/app-permissions',
    },
    repositories_url: {
      example: 'https://api.github.com/users/octocat/repos',
      format: 'uri',
      type: 'string',
    },
    repository_selection: {
      description: "Describe whether all repositories have been selected or there's a selection involved",
      enum: ['all', 'selected'],
      type: 'string',
    },
    single_file_name: {
      example: 'config.yaml',
      nullable: true,
      type: 'string',
    },
    single_file_paths: {
      example: ['config.yml', '.github/issue_TEMPLATE.md'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['permissions', 'repository_selection', 'single_file_name', 'repositories_url', 'account'],
  title: 'Scoped Installation',
  type: 'object',
} as const;

export const nullable_simple_commitSchema = {
  description: 'A commit.',
  nullable: true,
  properties: {
    author: {
      nullable: true,
      properties: {
        email: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
      },
      required: ['name', 'email'],
      type: 'object',
    },
    committer: {
      nullable: true,
      properties: {
        email: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
      },
      required: ['name', 'email'],
      type: 'object',
    },
    id: {
      type: 'string',
    },
    message: {
      type: 'string',
    },
    timestamp: {
      format: 'date-time',
      type: 'string',
    },
    tree_id: {
      type: 'string',
    },
  },
  required: ['id', 'tree_id', 'message', 'timestamp', 'author', 'committer'],
  title: 'Simple Commit',
  type: 'object',
} as const;

export const nullable_simple_userSchema = {
  description: 'A GitHub user.',
  nullable: true,
  properties: {
    avatar_url: {
      example: 'https://github.com/images/error/octocat_happy.gif',
      format: 'uri',
      type: 'string',
    },
    email: {
      nullable: true,
      type: 'string',
    },
    events_url: {
      example: 'https://api.github.com/users/octocat/events{/privacy}',
      type: 'string',
    },
    followers_url: {
      example: 'https://api.github.com/users/octocat/followers',
      format: 'uri',
      type: 'string',
    },
    following_url: {
      example: 'https://api.github.com/users/octocat/following{/other_user}',
      type: 'string',
    },
    gists_url: {
      example: 'https://api.github.com/users/octocat/gists{/gist_id}',
      type: 'string',
    },
    gravatar_id: {
      example: '41d064eb2195891e12d0413f63227ea7',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    login: {
      example: 'octocat',
      type: 'string',
    },
    name: {
      nullable: true,
      type: 'string',
    },
    node_id: {
      example: 'MDQ6VXNlcjE=',
      type: 'string',
    },
    organizations_url: {
      example: 'https://api.github.com/users/octocat/orgs',
      format: 'uri',
      type: 'string',
    },
    received_events_url: {
      example: 'https://api.github.com/users/octocat/received_events',
      format: 'uri',
      type: 'string',
    },
    repos_url: {
      example: 'https://api.github.com/users/octocat/repos',
      format: 'uri',
      type: 'string',
    },
    site_admin: {
      type: 'boolean',
    },
    starred_at: {
      example: '"2020-07-09T00:17:55Z"',
      type: 'string',
    },
    starred_url: {
      example: 'https://api.github.com/users/octocat/starred{/owner}{/repo}',
      type: 'string',
    },
    subscriptions_url: {
      example: 'https://api.github.com/users/octocat/subscriptions',
      format: 'uri',
      type: 'string',
    },
    type: {
      example: 'User',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/users/octocat',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'avatar_url',
    'events_url',
    'followers_url',
    'following_url',
    'gists_url',
    'gravatar_id',
    'html_url',
    'id',
    'node_id',
    'login',
    'organizations_url',
    'received_events_url',
    'repos_url',
    'site_admin',
    'starred_url',
    'subscriptions_url',
    'type',
    'url',
  ],
  title: 'Simple User',
  type: 'object',
} as const;

export const nullable_team_simpleSchema = {
  description: 'Groups of organization members that gives permissions on specified repositories.',
  nullable: true,
  properties: {
    description: {
      description: 'Description of the team',
      example: 'A great team.',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/orgs/rails/teams/core',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the team',
      example: 1,
      type: 'integer',
    },
    ldap_dn: {
      description: 'Distinguished Name (DN) that team maps to within LDAP environment',
      example: 'uid=example,ou=users,dc=github,dc=com',
      type: 'string',
    },
    members_url: {
      example: 'https://api.github.com/organizations/1/team/1/members{/member}',
      type: 'string',
    },
    name: {
      description: 'Name of the team',
      example: 'Justice League',
      type: 'string',
    },
    node_id: {
      example: 'MDQ6VGVhbTE=',
      type: 'string',
    },
    permission: {
      description: 'Permission that the team will have for its repositories',
      example: 'admin',
      type: 'string',
    },
    privacy: {
      description: 'The level of privacy this team should have',
      example: 'closed',
      type: 'string',
    },
    repositories_url: {
      example: 'https://api.github.com/organizations/1/team/1/repos',
      format: 'uri',
      type: 'string',
    },
    slug: {
      example: 'justice-league',
      type: 'string',
    },
    url: {
      description: 'URL for the team',
      example: 'https://api.github.com/organizations/1/team/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'members_url',
    'name',
    'description',
    'permission',
    'html_url',
    'repositories_url',
    'slug',
  ],
  title: 'Team Simple',
  type: 'object',
} as const;

export const oidc_custom_subSchema = {
  description: 'Actions OIDC Subject customization',
  properties: {
    include_claim_keys: {
      description: 'Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['include_claim_keys'],
  title: 'Actions OIDC Subject customization',
  type: 'object',
} as const;

export const oidc_custom_sub_repoSchema = {
  description: 'Actions OIDC subject customization for a repository',
  properties: {
    include_claim_keys: {
      description: 'Array of unique strings. Each claim key can only contain alphanumeric characters and underscores.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    use_default: {
      description: 'Whether to use the default template or not. If `true`, the `include_claim_keys` field is ignored.',
      type: 'boolean',
    },
  },
  required: ['use_default'],
  title: 'Actions OIDC subject customization for a repository',
  type: 'object',
} as const;

export const org_hookSchema = {
  description: 'Org Hook',
  properties: {
    active: {
      example: true,
      type: 'boolean',
    },
    config: {
      properties: {
        content_type: {
          example: '"form"',
          type: 'string',
        },
        insecure_ssl: {
          example: '"0"',
          type: 'string',
        },
        secret: {
          example: '"********"',
          type: 'string',
        },
        url: {
          example: '"http://example.com/2"',
          type: 'string',
        },
      },
      type: 'object',
    },
    created_at: {
      example: '2011-09-06T17:26:27Z',
      format: 'date-time',
      type: 'string',
    },
    deliveries_url: {
      example: 'https://api.github.com/orgs/octocat/hooks/1/deliveries',
      format: 'uri',
      type: 'string',
    },
    events: {
      example: ['push', 'pull_request'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    name: {
      example: 'web',
      type: 'string',
    },
    ping_url: {
      example: 'https://api.github.com/orgs/octocat/hooks/1/pings',
      format: 'uri',
      type: 'string',
    },
    type: {
      type: 'string',
    },
    updated_at: {
      example: '2011-09-06T20:39:23Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/orgs/octocat/hooks/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['id', 'url', 'type', 'name', 'active', 'events', 'config', 'ping_url', 'created_at', 'updated_at'],
  title: 'Org Hook',
  type: 'object',
} as const;

export const org_membershipSchema = {
  description: 'Org Membership',
  properties: {
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    organization_url: {
      example: 'https://api.github.com/orgs/octocat',
      format: 'uri',
      type: 'string',
    },
    permissions: {
      properties: {
        can_create_repository: {
          type: 'boolean',
        },
      },
      required: ['can_create_repository'],
      type: 'object',
    },
    role: {
      description: "The user's membership type in the organization.",
      enum: ['admin', 'member', 'billing_manager'],
      example: 'admin',
      type: 'string',
    },
    state: {
      description:
        'The state of the member in the organization. The `pending` state indicates the user has not yet accepted an invitation.',
      enum: ['active', 'pending'],
      example: 'active',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/orgs/octocat/memberships/defunkt',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: ['state', 'role', 'organization_url', 'url', 'organization', 'user'],
  title: 'Org Membership',
  type: 'object',
} as const;

export const organization_actions_secretSchema = {
  description: 'Secrets for GitHub Actions for an organization.',
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    name: {
      description: 'The name of the secret.',
      example: 'SECRET_TOKEN',
      type: 'string',
    },
    selected_repositories_url: {
      example: 'https://api.github.com/organizations/org/secrets/my_secret/repositories',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    visibility: {
      description: 'Visibility of a secret',
      enum: ['all', 'private', 'selected'],
      type: 'string',
    },
  },
  required: ['name', 'created_at', 'updated_at', 'visibility'],
  title: 'Actions Secret for an Organization',
  type: 'object',
} as const;

export const organization_actions_variableSchema = {
  description: 'Organization variable for GitHub Actions.',
  properties: {
    created_at: {
      description: "The date and time at which the variable was created, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      example: '2019-01-24T22:45:36.000Z',
      format: 'date-time',
      type: 'string',
    },
    name: {
      description: 'The name of the variable.',
      example: 'USERNAME',
      type: 'string',
    },
    selected_repositories_url: {
      example: 'https://api.github.com/organizations/org/variables/USERNAME/repositories',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      description:
        "The date and time at which the variable was last updated, in ISO 8601 format':' YYYY-MM-DDTHH:MM:SSZ.",
      example: '2019-01-24T22:45:36.000Z',
      format: 'date-time',
      type: 'string',
    },
    value: {
      description: 'The value of the variable.',
      example: 'octocat',
      type: 'string',
    },
    visibility: {
      description: 'Visibility of a variable',
      enum: ['all', 'private', 'selected'],
      type: 'string',
    },
  },
  required: ['name', 'value', 'created_at', 'updated_at', 'visibility'],
  title: 'Actions Variable for an Organization',
  type: 'object',
} as const;

export const organization_dependabot_secretSchema = {
  description: 'Secrets for GitHub Dependabot for an organization.',
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    name: {
      description: 'The name of the secret.',
      example: 'SECRET_TOKEN',
      type: 'string',
    },
    selected_repositories_url: {
      example: 'https://api.github.com/organizations/org/dependabot/secrets/my_secret/repositories',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    visibility: {
      description: 'Visibility of a secret',
      enum: ['all', 'private', 'selected'],
      type: 'string',
    },
  },
  required: ['name', 'created_at', 'updated_at', 'visibility'],
  title: 'Dependabot Secret for an Organization',
  type: 'object',
} as const;

export const organization_fullSchema = {
  description: 'Organization Full',
  properties: {
    advanced_security_enabled_for_new_repositories: {
      description: `Whether GitHub Advanced Security is enabled for new repositories and repositories transferred to this organization.

This field is only visible to organization owners or members of a team with the security manager role.`,
      example: false,
      type: 'boolean',
    },
    avatar_url: {
      example: 'https://github.com/images/error/octocat_happy.gif',
      type: 'string',
    },
    billing_email: {
      example: 'org@example.com',
      format: 'email',
      nullable: true,
      type: 'string',
    },
    blog: {
      example: 'https://github.com/blog',
      format: 'uri',
      type: 'string',
    },
    collaborators: {
      example: 8,
      nullable: true,
      type: 'integer',
    },
    company: {
      example: 'GitHub',
      type: 'string',
    },
    created_at: {
      example: '2008-01-14T04:33:35Z',
      format: 'date-time',
      type: 'string',
    },
    default_repository_permission: {
      nullable: true,
      type: 'string',
    },
    dependabot_alerts_enabled_for_new_repositories: {
      description: `Whether GitHub Advanced Security is automatically enabled for new repositories and repositories transferred to
this organization.

This field is only visible to organization owners or members of a team with the security manager role.`,
      example: false,
      type: 'boolean',
    },
    dependabot_security_updates_enabled_for_new_repositories: {
      description: `Whether dependabot security updates are automatically enabled for new repositories and repositories transferred
to this organization.

This field is only visible to organization owners or members of a team with the security manager role.`,
      example: false,
      type: 'boolean',
    },
    dependency_graph_enabled_for_new_repositories: {
      description: `Whether dependency graph is automatically enabled for new repositories and repositories transferred to this
organization.

This field is only visible to organization owners or members of a team with the security manager role.`,
      example: false,
      type: 'boolean',
    },
    description: {
      example: 'A great organization',
      nullable: true,
      type: 'string',
    },
    disk_usage: {
      example: 10000,
      nullable: true,
      type: 'integer',
    },
    email: {
      example: 'octocat@github.com',
      format: 'email',
      type: 'string',
    },
    events_url: {
      example: 'https://api.github.com/orgs/github/events',
      format: 'uri',
      type: 'string',
    },
    followers: {
      example: 20,
      type: 'integer',
    },
    following: {
      example: 0,
      type: 'integer',
    },
    has_organization_projects: {
      example: true,
      type: 'boolean',
    },
    has_repository_projects: {
      example: true,
      type: 'boolean',
    },
    hooks_url: {
      example: 'https://api.github.com/orgs/github/hooks',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    is_verified: {
      example: true,
      type: 'boolean',
    },
    issues_url: {
      example: 'https://api.github.com/orgs/github/issues',
      type: 'string',
    },
    location: {
      example: 'San Francisco',
      type: 'string',
    },
    login: {
      example: 'github',
      type: 'string',
    },
    members_allowed_repository_creation_type: {
      example: 'all',
      type: 'string',
    },
    members_can_create_internal_repositories: {
      example: true,
      type: 'boolean',
    },
    members_can_create_pages: {
      example: true,
      type: 'boolean',
    },
    members_can_create_private_pages: {
      example: true,
      type: 'boolean',
    },
    members_can_create_private_repositories: {
      example: true,
      type: 'boolean',
    },
    members_can_create_public_pages: {
      example: true,
      type: 'boolean',
    },
    members_can_create_public_repositories: {
      example: true,
      type: 'boolean',
    },
    members_can_create_repositories: {
      example: true,
      nullable: true,
      type: 'boolean',
    },
    members_can_fork_private_repositories: {
      example: false,
      nullable: true,
      type: 'boolean',
    },
    members_url: {
      example: 'https://api.github.com/orgs/github/members{/member}',
      type: 'string',
    },
    name: {
      example: 'github',
      type: 'string',
    },
    node_id: {
      example: 'MDEyOk9yZ2FuaXphdGlvbjE=',
      type: 'string',
    },
    owned_private_repos: {
      example: 100,
      type: 'integer',
    },
    plan: {
      properties: {
        filled_seats: {
          type: 'integer',
        },
        name: {
          type: 'string',
        },
        private_repos: {
          type: 'integer',
        },
        seats: {
          type: 'integer',
        },
        space: {
          type: 'integer',
        },
      },
      required: ['name', 'space', 'private_repos'],
      type: 'object',
    },
    private_gists: {
      example: 81,
      nullable: true,
      type: 'integer',
    },
    public_gists: {
      example: 1,
      type: 'integer',
    },
    public_members_url: {
      example: 'https://api.github.com/orgs/github/public_members{/member}',
      type: 'string',
    },
    public_repos: {
      example: 2,
      type: 'integer',
    },
    repos_url: {
      example: 'https://api.github.com/orgs/github/repos',
      format: 'uri',
      type: 'string',
    },
    secret_scanning_enabled_for_new_repositories: {
      description: `Whether secret scanning is automatically enabled for new repositories and repositories transferred to this
organization.

This field is only visible to organization owners or members of a team with the security manager role.`,
      example: false,
      type: 'boolean',
    },
    secret_scanning_push_protection_custom_link: {
      description: 'An optional URL string to display to contributors who are blocked from pushing a secret.',
      example: 'https://github.com/test-org/test-repo/blob/main/README.md',
      nullable: true,
      type: 'string',
    },
    secret_scanning_push_protection_custom_link_enabled: {
      description:
        'Whether a custom link is shown to contributors who are blocked from pushing a secret by push protection.',
      example: false,
      type: 'boolean',
    },
    secret_scanning_push_protection_enabled_for_new_repositories: {
      description: `Whether secret scanning push protection is automatically enabled for new repositories and repositories
transferred to this organization.

This field is only visible to organization owners or members of a team with the security manager role.`,
      example: false,
      type: 'boolean',
    },
    total_private_repos: {
      example: 100,
      type: 'integer',
    },
    twitter_username: {
      example: 'github',
      nullable: true,
      type: 'string',
    },
    two_factor_requirement_enabled: {
      example: true,
      nullable: true,
      type: 'boolean',
    },
    type: {
      example: 'Organization',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/orgs/github',
      format: 'uri',
      type: 'string',
    },
    web_commit_signoff_required: {
      example: false,
      type: 'boolean',
    },
  },
  required: [
    'login',
    'url',
    'id',
    'node_id',
    'repos_url',
    'events_url',
    'hooks_url',
    'issues_url',
    'members_url',
    'public_members_url',
    'avatar_url',
    'description',
    'html_url',
    'has_organization_projects',
    'has_repository_projects',
    'public_repos',
    'public_gists',
    'followers',
    'following',
    'type',
    'created_at',
    'updated_at',
  ],
  title: 'Organization Full',
  type: 'object',
} as const;

export const organization_invitationSchema = {
  description: 'Organization Invitation',
  properties: {
    created_at: {
      type: 'string',
    },
    email: {
      nullable: true,
      type: 'string',
    },
    failed_at: {
      nullable: true,
      type: 'string',
    },
    failed_reason: {
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    invitation_source: {
      example: '"member"',
      type: 'string',
    },
    invitation_teams_url: {
      example: '"https://api.github.com/organizations/16/invitations/1/teams"',
      type: 'string',
    },
    inviter: {
      $ref: '#/components/schemas/simple-user',
    },
    login: {
      nullable: true,
      type: 'string',
    },
    node_id: {
      example: '"MDIyOk9yZ2FuaXphdGlvbkludml0YXRpb24x"',
      type: 'string',
    },
    role: {
      type: 'string',
    },
    team_count: {
      type: 'integer',
    },
  },
  required: ['id', 'login', 'email', 'role', 'created_at', 'inviter', 'team_count', 'invitation_teams_url', 'node_id'],
  title: 'Organization Invitation',
  type: 'object',
} as const;

export const organization_secret_scanning_alertSchema = {
  properties: {
    created_at: {
      $ref: '#/components/schemas/alert-created-at',
    },
    html_url: {
      $ref: '#/components/schemas/alert-html-url',
    },
    locations_url: {
      description: 'The REST API URL of the code locations for this alert.',
      format: 'uri',
      type: 'string',
    },
    number: {
      $ref: '#/components/schemas/alert-number',
    },
    push_protection_bypassed: {
      description: 'Whether push protection was bypassed for the detected secret.',
      nullable: true,
      type: 'boolean',
    },
    push_protection_bypassed_at: {
      description: 'The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    push_protection_bypassed_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    repository: {
      $ref: '#/components/schemas/simple-repository',
    },
    resolution: {
      $ref: '#/components/schemas/secret-scanning-alert-resolution',
    },
    resolution_comment: {
      description: 'The comment that was optionally added when this alert was closed',
      nullable: true,
      type: 'string',
    },
    resolved_at: {
      description: 'The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    resolved_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    secret: {
      description: 'The secret that was detected.',
      type: 'string',
    },
    secret_type: {
      description: 'The type of secret that secret scanning detected.',
      type: 'string',
    },
    secret_type_display_name: {
      description: `User-friendly name for the detected secret, matching the \`secret_type\`.
For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."`,
      type: 'string',
    },
    state: {
      $ref: '#/components/schemas/secret-scanning-alert-state',
    },
    updated_at: {
      $ref: '#/components/schemas/nullable-alert-updated-at',
    },
    url: {
      $ref: '#/components/schemas/alert-url',
    },
  },
  type: 'object',
} as const;

export const organization_simpleSchema = {
  description: 'A GitHub organization.',
  properties: {
    avatar_url: {
      example: 'https://github.com/images/error/octocat_happy.gif',
      type: 'string',
    },
    description: {
      example: 'A great organization',
      nullable: true,
      type: 'string',
    },
    events_url: {
      example: 'https://api.github.com/orgs/github/events',
      format: 'uri',
      type: 'string',
    },
    hooks_url: {
      example: 'https://api.github.com/orgs/github/hooks',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    issues_url: {
      example: 'https://api.github.com/orgs/github/issues',
      type: 'string',
    },
    login: {
      example: 'github',
      type: 'string',
    },
    members_url: {
      example: 'https://api.github.com/orgs/github/members{/member}',
      type: 'string',
    },
    node_id: {
      example: 'MDEyOk9yZ2FuaXphdGlvbjE=',
      type: 'string',
    },
    public_members_url: {
      example: 'https://api.github.com/orgs/github/public_members{/member}',
      type: 'string',
    },
    repos_url: {
      example: 'https://api.github.com/orgs/github/repos',
      format: 'uri',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/orgs/github',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'login',
    'url',
    'id',
    'node_id',
    'repos_url',
    'events_url',
    'hooks_url',
    'issues_url',
    'members_url',
    'public_members_url',
    'avatar_url',
    'description',
  ],
  title: 'Organization Simple',
  type: 'object',
} as const;

export const packageSchema = {
  description: 'A software package',
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/orgs/github/packages/container/package/super-linter',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the package.',
      example: 1,
      type: 'integer',
    },
    name: {
      description: 'The name of the package.',
      example: 'super-linter',
      type: 'string',
    },
    owner: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    package_type: {
      enum: ['npm', 'maven', 'rubygems', 'docker', 'nuget', 'container'],
      example: 'docker',
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/nullable-minimal-repository',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/orgs/github/packages/container/super-linter',
      type: 'string',
    },
    version_count: {
      description: 'The number of versions of the package.',
      example: 1,
      type: 'integer',
    },
    visibility: {
      enum: ['private', 'public'],
      example: 'private',
      type: 'string',
    },
  },
  required: [
    'id',
    'name',
    'package_type',
    'visibility',
    'url',
    'html_url',
    'version_count',
    'created_at',
    'updated_at',
  ],
  title: 'Package',
  type: 'object',
} as const;

export const package_versionSchema = {
  description: 'A version of a software package',
  properties: {
    created_at: {
      example: '2011-04-10T20:09:31Z',
      format: 'date-time',
      type: 'string',
    },
    deleted_at: {
      example: '2014-03-03T18:58:10Z',
      format: 'date-time',
      type: 'string',
    },
    description: {
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/orgs/github/packages/container/super-linter/786068',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the package version.',
      example: 1,
      type: 'integer',
    },
    license: {
      example: 'MIT',
      type: 'string',
    },
    metadata: {
      properties: {
        container: {
          properties: {
            tags: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
          },
          required: ['tags'],
          title: 'Container Metadata',
          type: 'object',
        },
        docker: {
          properties: {
            tag: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
          },
          required: ['tags'],
          title: 'Docker Metadata',
          type: 'object',
        },
        package_type: {
          enum: ['npm', 'maven', 'rubygems', 'docker', 'nuget', 'container'],
          example: 'docker',
          type: 'string',
        },
      },
      required: ['package_type'],
      title: 'Package Version Metadata',
      type: 'object',
    },
    name: {
      description: 'The name of the package version.',
      example: 'latest',
      type: 'string',
    },
    package_html_url: {
      example: 'https://github.com/orgs/github/packages/container/package/super-linter',
      type: 'string',
    },
    updated_at: {
      example: '2014-03-03T18:58:10Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/orgs/github/packages/container/super-linter/versions/786068',
      type: 'string',
    },
  },
  required: ['id', 'name', 'url', 'package_html_url', 'created_at', 'updated_at'],
  title: 'Package Version',
  type: 'object',
} as const;

export const packages_billing_usageSchema = {
  properties: {
    included_gigabytes_bandwidth: {
      description: 'Free storage space (GB) for GitHub Packages.',
      type: 'integer',
    },
    total_gigabytes_bandwidth_used: {
      description: 'Sum of the free and paid storage space (GB) for GitHuub Packages.',
      type: 'integer',
    },
    total_paid_gigabytes_bandwidth_used: {
      description: 'Total paid storage space (GB) for GitHuub Packages.',
      type: 'integer',
    },
  },
  required: ['total_gigabytes_bandwidth_used', 'total_paid_gigabytes_bandwidth_used', 'included_gigabytes_bandwidth'],
  type: 'object',
} as const;

export const pageSchema = {
  description: 'The configuration for GitHub Pages for a repository.',
  properties: {
    build_type: {
      description: 'The process in which the Page will be built.',
      enum: ['legacy', 'workflow'],
      example: 'legacy',
      nullable: true,
      type: 'string',
    },
    cname: {
      description: "The Pages site's custom domain",
      example: 'example.com',
      nullable: true,
      type: 'string',
    },
    custom_404: {
      default: false,
      description: 'Whether the Page has a custom 404 page.',
      example: false,
      type: 'boolean',
    },
    html_url: {
      description: 'The web address the Page can be accessed from.',
      example: 'https://example.com',
      format: 'uri',
      type: 'string',
    },
    https_certificate: {
      $ref: '#/components/schemas/pages-https-certificate',
    },
    https_enforced: {
      description: 'Whether https is enabled on the domain',
      example: true,
      type: 'boolean',
    },
    pending_domain_unverified_at: {
      description: 'The timestamp when a pending domain becomes unverified.',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    protected_domain_state: {
      description: 'The state if the domain is verified',
      enum: ['pending', 'verified', 'unverified'],
      example: 'pending',
      nullable: true,
      type: 'string',
    },
    public: {
      description:
        'Whether the GitHub Pages site is publicly visible. If set to `true`, the site is accessible to anyone on the internet. If set to `false`, the site will only be accessible to users who have at least `read` access to the repository that published the site.',
      example: true,
      type: 'boolean',
    },
    source: {
      $ref: '#/components/schemas/pages-source-hash',
    },
    status: {
      description: 'The status of the most recent build of the Page.',
      enum: ['built', 'building', 'errored'],
      example: 'built',
      nullable: true,
      type: 'string',
    },
    url: {
      description: 'The API address for accessing this Page resource.',
      example: 'https://api.github.com/repos/github/hello-world/pages',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'status', 'cname', 'custom_404', 'public'],
  title: 'GitHub Pages',
  type: 'object',
} as const;

export const page_buildSchema = {
  description: 'Page Build',
  properties: {
    commit: {
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    duration: {
      type: 'integer',
    },
    error: {
      properties: {
        message: {
          nullable: true,
          type: 'string',
        },
      },
      required: ['message'],
      type: 'object',
    },
    pusher: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    status: {
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'status', 'error', 'pusher', 'commit', 'duration', 'created_at', 'updated_at'],
  title: 'Page Build',
  type: 'object',
} as const;

export const page_build_statusSchema = {
  description: 'Page Build Status',
  properties: {
    status: {
      example: 'queued',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/github/hello-world/pages/builds/latest',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'status'],
  title: 'Page Build Status',
  type: 'object',
} as const;

export const page_deploymentSchema = {
  description: 'The GitHub Pages deployment status.',
  properties: {
    page_url: {
      description: 'The URI to the deployed GitHub Pages.',
      example: 'hello-world.github.io',
      format: 'uri',
      type: 'string',
    },
    preview_url: {
      description: 'The URI to the deployed GitHub Pages preview.',
      example: 'monalisa-1231a2312sa32-23sda74.drafts.github.io',
      format: 'uri',
      type: 'string',
    },
    status_url: {
      description: 'The URI to monitor GitHub Pages deployment status.',
      example:
        'https://api.github.com/repos/github/hello-world/pages/deployments/4fd754f7e594640989b406850d0bc8f06a121251/status',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['status_url', 'page_url'],
  title: 'GitHub Pages',
  type: 'object',
} as const;

export const pages_health_checkSchema = {
  description: 'Pages Health Check Status',
  properties: {
    alt_domain: {
      nullable: true,
      properties: {
        caa_error: {
          nullable: true,
          type: 'string',
        },
        dns_resolves: {
          type: 'boolean',
        },
        enforces_https: {
          type: 'boolean',
        },
        has_cname_record: {
          nullable: true,
          type: 'boolean',
        },
        has_mx_records_present: {
          nullable: true,
          type: 'boolean',
        },
        host: {
          type: 'string',
        },
        https_error: {
          nullable: true,
          type: 'string',
        },
        is_a_record: {
          nullable: true,
          type: 'boolean',
        },
        is_apex_domain: {
          type: 'boolean',
        },
        is_cloudflare_ip: {
          nullable: true,
          type: 'boolean',
        },
        is_cname_to_fastly: {
          nullable: true,
          type: 'boolean',
        },
        is_cname_to_github_user_domain: {
          nullable: true,
          type: 'boolean',
        },
        is_cname_to_pages_dot_github_dot_com: {
          nullable: true,
          type: 'boolean',
        },
        is_fastly_ip: {
          nullable: true,
          type: 'boolean',
        },
        is_https_eligible: {
          nullable: true,
          type: 'boolean',
        },
        is_non_github_pages_ip_present: {
          nullable: true,
          type: 'boolean',
        },
        is_old_ip_address: {
          nullable: true,
          type: 'boolean',
        },
        is_pages_domain: {
          type: 'boolean',
        },
        is_pointed_to_github_pages_ip: {
          nullable: true,
          type: 'boolean',
        },
        is_proxied: {
          nullable: true,
          type: 'boolean',
        },
        is_served_by_pages: {
          nullable: true,
          type: 'boolean',
        },
        is_valid: {
          type: 'boolean',
        },
        is_valid_domain: {
          type: 'boolean',
        },
        nameservers: {
          type: 'string',
        },
        reason: {
          nullable: true,
          type: 'string',
        },
        responds_to_https: {
          type: 'boolean',
        },
        should_be_a_record: {
          nullable: true,
          type: 'boolean',
        },
        uri: {
          type: 'string',
        },
      },
      type: 'object',
    },
    domain: {
      properties: {
        caa_error: {
          nullable: true,
          type: 'string',
        },
        dns_resolves: {
          type: 'boolean',
        },
        enforces_https: {
          type: 'boolean',
        },
        has_cname_record: {
          nullable: true,
          type: 'boolean',
        },
        has_mx_records_present: {
          nullable: true,
          type: 'boolean',
        },
        host: {
          type: 'string',
        },
        https_error: {
          nullable: true,
          type: 'string',
        },
        is_a_record: {
          nullable: true,
          type: 'boolean',
        },
        is_apex_domain: {
          type: 'boolean',
        },
        is_cloudflare_ip: {
          nullable: true,
          type: 'boolean',
        },
        is_cname_to_fastly: {
          nullable: true,
          type: 'boolean',
        },
        is_cname_to_github_user_domain: {
          nullable: true,
          type: 'boolean',
        },
        is_cname_to_pages_dot_github_dot_com: {
          nullable: true,
          type: 'boolean',
        },
        is_fastly_ip: {
          nullable: true,
          type: 'boolean',
        },
        is_https_eligible: {
          nullable: true,
          type: 'boolean',
        },
        is_non_github_pages_ip_present: {
          nullable: true,
          type: 'boolean',
        },
        is_old_ip_address: {
          nullable: true,
          type: 'boolean',
        },
        is_pages_domain: {
          type: 'boolean',
        },
        is_pointed_to_github_pages_ip: {
          nullable: true,
          type: 'boolean',
        },
        is_proxied: {
          nullable: true,
          type: 'boolean',
        },
        is_served_by_pages: {
          nullable: true,
          type: 'boolean',
        },
        is_valid: {
          type: 'boolean',
        },
        is_valid_domain: {
          type: 'boolean',
        },
        nameservers: {
          type: 'string',
        },
        reason: {
          nullable: true,
          type: 'string',
        },
        responds_to_https: {
          type: 'boolean',
        },
        should_be_a_record: {
          nullable: true,
          type: 'boolean',
        },
        uri: {
          type: 'string',
        },
      },
      type: 'object',
    },
  },
  title: 'Pages Health Check Status',
  type: 'object',
} as const;

export const pages_https_certificateSchema = {
  properties: {
    description: {
      example: 'Certificate is approved',
      type: 'string',
    },
    domains: {
      description: 'Array of the domain set and its alternate name (if it is configured)',
      example: ['example.com', 'www.example.com'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    expires_at: {
      format: 'date',
      type: 'string',
    },
    state: {
      enum: [
        'new',
        'authorization_created',
        'authorization_pending',
        'authorized',
        'authorization_revoked',
        'issued',
        'uploaded',
        'approved',
        'errored',
        'bad_authz',
        'destroy_pending',
        'dns_changed',
      ],
      example: 'approved',
      type: 'string',
    },
  },
  required: ['state', 'description', 'domains'],
  title: 'Pages Https Certificate',
  type: 'object',
} as const;

export const pages_source_hashSchema = {
  properties: {
    branch: {
      type: 'string',
    },
    path: {
      type: 'string',
    },
  },
  required: ['branch', 'path'],
  title: 'Pages Source Hash',
  type: 'object',
} as const;

export const participation_statsSchema = {
  properties: {
    all: {
      items: {
        type: 'integer',
      },
      type: 'array',
    },
    owner: {
      items: {
        type: 'integer',
      },
      type: 'array',
    },
  },
  required: ['all', 'owner'],
  title: 'Participation Stats',
  type: 'object',
} as const;

export const pending_deploymentSchema = {
  description: 'Details of a deployment that is waiting for protection rules to pass',
  properties: {
    current_user_can_approve: {
      description: 'Whether the currently authenticated user can approve the deployment',
      example: true,
      type: 'boolean',
    },
    environment: {
      properties: {
        html_url: {
          example: 'https://github.com/github/hello-world/deployments/activity_log?environments_filter=staging',
          type: 'string',
        },
        id: {
          description: 'The id of the environment.',
          example: 56780428,
          type: 'integer',
        },
        name: {
          description: 'The name of the environment.',
          example: 'staging',
          type: 'string',
        },
        node_id: {
          example: 'MDExOkVudmlyb25tZW50NTY3ODA0Mjg=',
          type: 'string',
        },
        url: {
          example: 'https://api.github.com/repos/github/hello-world/environments/staging',
          type: 'string',
        },
      },
      type: 'object',
    },
    reviewers: {
      description:
        'The people or teams that may approve jobs that reference the environment. You can list up to six users or teams as reviewers. The reviewers must have at least read access to the repository. Only one of the required reviewers needs to approve the job for it to proceed.',
      items: {
        properties: {
          reviewer: {
            anyOf: [
              {
                $ref: '#/components/schemas/simple-user',
              },
              {
                $ref: '#/components/schemas/team',
              },
            ],
          },
          type: {
            $ref: '#/components/schemas/deployment-reviewer-type',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    wait_timer: {
      description: 'The set duration of the wait timer',
      example: 30,
      type: 'integer',
    },
    wait_timer_started_at: {
      description: 'The time that the wait timer began.',
      example: '2020-11-23T22:00:40Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
  },
  required: ['environment', 'wait_timer', 'wait_timer_started_at', 'current_user_can_approve', 'reviewers'],
  title: 'Pending Deployment',
  type: 'object',
} as const;

export const porter_authorSchema = {
  description: 'Porter Author',
  properties: {
    email: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    import_url: {
      format: 'uri',
      type: 'string',
    },
    name: {
      type: 'string',
    },
    remote_id: {
      type: 'string',
    },
    remote_name: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['id', 'remote_id', 'remote_name', 'email', 'name', 'url', 'import_url'],
  title: 'Porter Author',
  type: 'object',
} as const;

export const porter_large_fileSchema = {
  description: 'Porter Large File',
  properties: {
    oid: {
      type: 'string',
    },
    path: {
      type: 'string',
    },
    ref_name: {
      type: 'string',
    },
    size: {
      type: 'integer',
    },
  },
  required: ['oid', 'path', 'ref_name', 'size'],
  title: 'Porter Large File',
  type: 'object',
} as const;

export const private_userSchema = {
  description: 'Private User',
  properties: {
    avatar_url: {
      example: 'https://github.com/images/error/octocat_happy.gif',
      format: 'uri',
      type: 'string',
    },
    bio: {
      example: 'There once was...',
      nullable: true,
      type: 'string',
    },
    blog: {
      example: 'https://github.com/blog',
      nullable: true,
      type: 'string',
    },
    business_plus: {
      type: 'boolean',
    },
    collaborators: {
      example: 8,
      type: 'integer',
    },
    company: {
      example: 'GitHub',
      nullable: true,
      type: 'string',
    },
    created_at: {
      example: '2008-01-14T04:33:35Z',
      format: 'date-time',
      type: 'string',
    },
    disk_usage: {
      example: 10000,
      type: 'integer',
    },
    email: {
      example: 'octocat@github.com',
      format: 'email',
      nullable: true,
      type: 'string',
    },
    events_url: {
      example: 'https://api.github.com/users/octocat/events{/privacy}',
      type: 'string',
    },
    followers: {
      example: 20,
      type: 'integer',
    },
    followers_url: {
      example: 'https://api.github.com/users/octocat/followers',
      format: 'uri',
      type: 'string',
    },
    following: {
      example: 0,
      type: 'integer',
    },
    following_url: {
      example: 'https://api.github.com/users/octocat/following{/other_user}',
      type: 'string',
    },
    gists_url: {
      example: 'https://api.github.com/users/octocat/gists{/gist_id}',
      type: 'string',
    },
    gravatar_id: {
      example: '41d064eb2195891e12d0413f63227ea7',
      nullable: true,
      type: 'string',
    },
    hireable: {
      nullable: true,
      type: 'boolean',
    },
    html_url: {
      example: 'https://github.com/octocat',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    ldap_dn: {
      type: 'string',
    },
    location: {
      example: 'San Francisco',
      nullable: true,
      type: 'string',
    },
    login: {
      example: 'octocat',
      type: 'string',
    },
    name: {
      example: 'monalisa octocat',
      nullable: true,
      type: 'string',
    },
    node_id: {
      example: 'MDQ6VXNlcjE=',
      type: 'string',
    },
    organizations_url: {
      example: 'https://api.github.com/users/octocat/orgs',
      format: 'uri',
      type: 'string',
    },
    owned_private_repos: {
      example: 100,
      type: 'integer',
    },
    plan: {
      properties: {
        collaborators: {
          type: 'integer',
        },
        name: {
          type: 'string',
        },
        private_repos: {
          type: 'integer',
        },
        space: {
          type: 'integer',
        },
      },
      required: ['collaborators', 'name', 'space', 'private_repos'],
      type: 'object',
    },
    private_gists: {
      example: 81,
      type: 'integer',
    },
    public_gists: {
      example: 1,
      type: 'integer',
    },
    public_repos: {
      example: 2,
      type: 'integer',
    },
    received_events_url: {
      example: 'https://api.github.com/users/octocat/received_events',
      format: 'uri',
      type: 'string',
    },
    repos_url: {
      example: 'https://api.github.com/users/octocat/repos',
      format: 'uri',
      type: 'string',
    },
    site_admin: {
      type: 'boolean',
    },
    starred_url: {
      example: 'https://api.github.com/users/octocat/starred{/owner}{/repo}',
      type: 'string',
    },
    subscriptions_url: {
      example: 'https://api.github.com/users/octocat/subscriptions',
      format: 'uri',
      type: 'string',
    },
    suspended_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    total_private_repos: {
      example: 100,
      type: 'integer',
    },
    twitter_username: {
      example: 'monalisa',
      nullable: true,
      type: 'string',
    },
    two_factor_authentication: {
      example: true,
      type: 'boolean',
    },
    type: {
      example: 'User',
      type: 'string',
    },
    updated_at: {
      example: '2008-01-14T04:33:35Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/users/octocat',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'avatar_url',
    'events_url',
    'followers_url',
    'following_url',
    'gists_url',
    'gravatar_id',
    'html_url',
    'id',
    'node_id',
    'login',
    'organizations_url',
    'received_events_url',
    'repos_url',
    'site_admin',
    'starred_url',
    'subscriptions_url',
    'type',
    'url',
    'bio',
    'blog',
    'company',
    'email',
    'followers',
    'following',
    'hireable',
    'location',
    'name',
    'public_gists',
    'public_repos',
    'created_at',
    'updated_at',
    'collaborators',
    'disk_usage',
    'owned_private_repos',
    'private_gists',
    'total_private_repos',
    'two_factor_authentication',
  ],
  title: 'Private User',
  type: 'object',
} as const;

export const projectSchema = {
  description: 'Projects are a way to organize columns and cards of work.',
  properties: {
    body: {
      description: 'Body of the project',
      example: 'This project represents the sprint of the first week in January',
      nullable: true,
      type: 'string',
    },
    columns_url: {
      example: 'https://api.github.com/projects/1002604/columns',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2011-04-10T20:09:31Z',
      format: 'date-time',
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    html_url: {
      example: 'https://github.com/api-playground/projects-test/projects/12',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1002604,
      type: 'integer',
    },
    name: {
      description: 'Name of the project',
      example: 'Week One Sprint',
      type: 'string',
    },
    node_id: {
      example: 'MDc6UHJvamVjdDEwMDI2MDQ=',
      type: 'string',
    },
    number: {
      example: 1,
      type: 'integer',
    },
    organization_permission: {
      description:
        'The baseline permission that all organization members have on this project. Only present if owner is an organization.',
      enum: ['read', 'write', 'admin', 'none'],
      type: 'string',
    },
    owner_url: {
      example: 'https://api.github.com/repos/api-playground/projects-test',
      format: 'uri',
      type: 'string',
    },
    private: {
      description: 'Whether or not this project can be seen by everyone. Only present if owner is an organization.',
      type: 'boolean',
    },
    state: {
      description: "State of the project; either 'open' or 'closed'",
      example: 'open',
      type: 'string',
    },
    updated_at: {
      example: '2014-03-03T18:58:10Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/projects/1002604',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'number',
    'name',
    'body',
    'state',
    'url',
    'html_url',
    'owner_url',
    'creator',
    'columns_url',
    'created_at',
    'updated_at',
  ],
  title: 'Project',
  type: 'object',
} as const;

export const project_cardSchema = {
  description: 'Project cards represent a scope of work.',
  properties: {
    archived: {
      description: 'Whether or not the card is archived',
      example: false,
      type: 'boolean',
    },
    column_name: {
      type: 'string',
    },
    column_url: {
      example: 'https://api.github.com/projects/columns/367',
      format: 'uri',
      type: 'string',
    },
    content_url: {
      example: 'https://api.github.com/repos/api-playground/projects-test/issues/3',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2016-09-05T14:21:06Z',
      format: 'date-time',
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    id: {
      description: "The project card's ID",
      example: 42,
      type: 'integer',
    },
    node_id: {
      example: 'MDExOlByb2plY3RDYXJkMTQ3OA==',
      type: 'string',
    },
    note: {
      example: 'Add payload for delete Project column',
      nullable: true,
      type: 'string',
    },
    project_id: {
      type: 'string',
    },
    project_url: {
      example: 'https://api.github.com/projects/120',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      example: '2016-09-05T14:20:22Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/projects/columns/cards/1478',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['id', 'node_id', 'note', 'url', 'column_url', 'project_url', 'creator', 'created_at', 'updated_at'],
  title: 'Project Card',
  type: 'object',
} as const;

export const project_collaborator_permissionSchema = {
  description: 'Project Collaborator Permission',
  properties: {
    permission: {
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: ['permission', 'user'],
  title: 'Project Collaborator Permission',
  type: 'object',
} as const;

export const project_columnSchema = {
  description: 'Project columns contain cards of work.',
  properties: {
    cards_url: {
      example: 'https://api.github.com/projects/columns/367/cards',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2016-09-05T14:18:44Z',
      format: 'date-time',
      type: 'string',
    },
    id: {
      description: 'The unique identifier of the project column',
      example: 42,
      type: 'integer',
    },
    name: {
      description: 'Name of the project column',
      example: 'Remaining tasks',
      type: 'string',
    },
    node_id: {
      example: 'MDEzOlByb2plY3RDb2x1bW4zNjc=',
      type: 'string',
    },
    project_url: {
      example: 'https://api.github.com/projects/120',
      format: 'uri',
      type: 'string',
    },
    updated_at: {
      example: '2016-09-05T14:22:28Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/projects/columns/367',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['id', 'node_id', 'url', 'project_url', 'cards_url', 'name', 'created_at', 'updated_at'],
  title: 'Project Column',
  type: 'object',
} as const;

export const projects_v2Schema = {
  description: 'A projects v2 project',
  properties: {
    closed_at: {
      example: '2022-04-28T12:00:00Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    created_at: {
      example: '2022-04-28T12:00:00Z',
      format: 'date-time',
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/simple-user',
    },
    deleted_at: {
      example: '2022-04-28T12:00:00Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    deleted_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    description: {
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'number',
    },
    node_id: {
      type: 'string',
    },
    number: {
      type: 'integer',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    public: {
      type: 'boolean',
    },
    short_description: {
      nullable: true,
      type: 'string',
    },
    title: {
      type: 'string',
    },
    updated_at: {
      example: '2022-04-28T12:00:00Z',
      format: 'date-time',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'owner',
    'creator',
    'title',
    'description',
    'public',
    'closed_at',
    'created_at',
    'updated_at',
    'number',
    'short_description',
    'deleted_at',
    'deleted_by',
  ],
  title: 'Projects v2 Project',
  type: 'object',
} as const;

export const projects_v2_itemSchema = {
  description: 'An item belonging to a project',
  properties: {
    archived_at: {
      example: '2022-04-28T12:00:00Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    content_node_id: {
      type: 'string',
    },
    content_type: {
      $ref: '#/components/schemas/projects-v2-item-content-type',
    },
    created_at: {
      example: '2022-04-28T12:00:00Z',
      format: 'date-time',
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/simple-user',
    },
    id: {
      type: 'number',
    },
    node_id: {
      type: 'string',
    },
    project_node_id: {
      type: 'string',
    },
    updated_at: {
      example: '2022-04-28T12:00:00Z',
      format: 'date-time',
      type: 'string',
    },
  },
  required: ['id', 'content_node_id', 'content_type', 'created_at', 'updated_at', 'archived_at'],
  title: 'Projects v2 Item',
  type: 'object',
} as const;

export const projects_v2_item_content_typeSchema = {
  description: 'The type of content tracked in a project item',
  enum: ['Issue', 'PullRequest', 'DraftIssue'],
  title: 'Projects v2 Item Content Type',
  type: 'string',
} as const;

export const protected_branchSchema = {
  description: 'Branch protections protect branches',
  properties: {
    allow_deletions: {
      additionalProperties: false,
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      required: ['enabled'],
      type: 'object',
    },
    allow_force_pushes: {
      additionalProperties: false,
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      required: ['enabled'],
      type: 'object',
    },
    allow_fork_syncing: {
      additionalProperties: false,
      description:
        'Whether users can pull changes from upstream when the branch is locked. Set to `true` to allow fork syncing. Set to `false` to prevent fork syncing.',
      properties: {
        enabled: {
          default: false,
          type: 'boolean',
        },
      },
      type: 'object',
    },
    block_creations: {
      additionalProperties: false,
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      required: ['enabled'],
      type: 'object',
    },
    enforce_admins: {
      additionalProperties: false,
      properties: {
        enabled: {
          type: 'boolean',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['url', 'enabled'],
      type: 'object',
    },
    lock_branch: {
      additionalProperties: false,
      description:
        'Whether to set the branch as read-only. If this is true, users will not be able to push to the branch.',
      properties: {
        enabled: {
          default: false,
          type: 'boolean',
        },
      },
      type: 'object',
    },
    required_conversation_resolution: {
      additionalProperties: false,
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      type: 'object',
    },
    required_linear_history: {
      additionalProperties: false,
      properties: {
        enabled: {
          type: 'boolean',
        },
      },
      required: ['enabled'],
      type: 'object',
    },
    required_pull_request_reviews: {
      properties: {
        bypass_pull_request_allowances: {
          properties: {
            apps: {
              items: {
                $ref: '#/components/schemas/integration',
              },
              type: 'array',
            },
            teams: {
              items: {
                $ref: '#/components/schemas/team',
              },
              type: 'array',
            },
            users: {
              items: {
                $ref: '#/components/schemas/simple-user',
              },
              type: 'array',
            },
          },
          required: ['users', 'teams'],
          type: 'object',
        },
        dismiss_stale_reviews: {
          type: 'boolean',
        },
        dismissal_restrictions: {
          properties: {
            apps: {
              items: {
                $ref: '#/components/schemas/integration',
              },
              type: 'array',
            },
            teams: {
              items: {
                $ref: '#/components/schemas/team',
              },
              type: 'array',
            },
            teams_url: {
              format: 'uri',
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
            users: {
              items: {
                $ref: '#/components/schemas/simple-user',
              },
              type: 'array',
            },
            users_url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['url', 'users_url', 'teams_url', 'users', 'teams'],
          type: 'object',
        },
        require_code_owner_reviews: {
          type: 'boolean',
        },
        require_last_push_approval: {
          default: false,
          description: 'Whether the most recent push must be approved by someone other than the person who pushed it.',
          type: 'boolean',
        },
        required_approving_review_count: {
          type: 'integer',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['url'],
      type: 'object',
    },
    required_signatures: {
      properties: {
        enabled: {
          example: true,
          type: 'boolean',
        },
        url: {
          example: 'https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_signatures',
          format: 'uri',
          type: 'string',
        },
      },
      required: ['url', 'enabled'],
      type: 'object',
    },
    required_status_checks: {
      $ref: '#/components/schemas/status-check-policy',
    },
    restrictions: {
      $ref: '#/components/schemas/branch-restriction-policy',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url'],
  title: 'Protected Branch',
  type: 'object',
} as const;

export const protected_branch_admin_enforcedSchema = {
  description: 'Protected Branch Admin Enforced',
  properties: {
    enabled: {
      example: true,
      type: 'boolean',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/branches/master/protection/enforce_admins',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'enabled'],
  title: 'Protected Branch Admin Enforced',
  type: 'object',
} as const;

export const protected_branch_pull_request_reviewSchema = {
  description: 'Protected Branch Pull Request Review',
  properties: {
    bypass_pull_request_allowances: {
      description: 'Allow specific users, teams, or apps to bypass pull request requirements.',
      properties: {
        apps: {
          description: 'The list of apps allowed to bypass pull request requirements.',
          items: {
            $ref: '#/components/schemas/integration',
          },
          type: 'array',
        },
        teams: {
          description: 'The list of teams allowed to bypass pull request requirements.',
          items: {
            $ref: '#/components/schemas/team',
          },
          type: 'array',
        },
        users: {
          description: 'The list of users allowed to bypass pull request requirements.',
          items: {
            $ref: '#/components/schemas/simple-user',
          },
          type: 'array',
        },
      },
      type: 'object',
    },
    dismiss_stale_reviews: {
      example: true,
      type: 'boolean',
    },
    dismissal_restrictions: {
      properties: {
        apps: {
          description: 'The list of apps with review dismissal access.',
          items: {
            $ref: '#/components/schemas/integration',
          },
          type: 'array',
        },
        teams: {
          description: 'The list of teams with review dismissal access.',
          items: {
            $ref: '#/components/schemas/team',
          },
          type: 'array',
        },
        teams_url: {
          example:
            '"https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions/teams"',
          type: 'string',
        },
        url: {
          example:
            '"https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions"',
          type: 'string',
        },
        users: {
          description: 'The list of users with review dismissal access.',
          items: {
            $ref: '#/components/schemas/simple-user',
          },
          type: 'array',
        },
        users_url: {
          example:
            '"https://api.github.com/repos/the-org/an-org-repo/branches/master/protection/dismissal_restrictions/users"',
          type: 'string',
        },
      },
      type: 'object',
    },
    require_code_owner_reviews: {
      example: true,
      type: 'boolean',
    },
    require_last_push_approval: {
      default: false,
      description: 'Whether the most recent push must be approved by someone other than the person who pushed it.',
      example: true,
      type: 'boolean',
    },
    required_approving_review_count: {
      example: 2,
      maximum: 6,
      minimum: 0,
      type: 'integer',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/branches/master/protection/dismissal_restrictions',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['dismiss_stale_reviews', 'require_code_owner_reviews'],
  title: 'Protected Branch Pull Request Review',
  type: 'object',
} as const;

export const protected_branch_required_status_checkSchema = {
  description: 'Protected Branch Required Status Check',
  properties: {
    checks: {
      items: {
        properties: {
          app_id: {
            nullable: true,
            type: 'integer',
          },
          context: {
            type: 'string',
          },
        },
        required: ['context', 'app_id'],
        type: 'object',
      },
      type: 'array',
    },
    contexts: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    contexts_url: {
      type: 'string',
    },
    enforcement_level: {
      type: 'string',
    },
    strict: {
      type: 'boolean',
    },
    url: {
      type: 'string',
    },
  },
  required: ['contexts', 'checks'],
  title: 'Protected Branch Required Status Check',
  type: 'object',
} as const;

export const public_userSchema = {
  additionalProperties: false,
  description: 'Public User',
  properties: {
    avatar_url: {
      format: 'uri',
      type: 'string',
    },
    bio: {
      nullable: true,
      type: 'string',
    },
    blog: {
      nullable: true,
      type: 'string',
    },
    collaborators: {
      example: 3,
      type: 'integer',
    },
    company: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    disk_usage: {
      example: 1,
      type: 'integer',
    },
    email: {
      format: 'email',
      nullable: true,
      type: 'string',
    },
    events_url: {
      type: 'string',
    },
    followers: {
      type: 'integer',
    },
    followers_url: {
      format: 'uri',
      type: 'string',
    },
    following: {
      type: 'integer',
    },
    following_url: {
      type: 'string',
    },
    gists_url: {
      type: 'string',
    },
    gravatar_id: {
      nullable: true,
      type: 'string',
    },
    hireable: {
      nullable: true,
      type: 'boolean',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    location: {
      nullable: true,
      type: 'string',
    },
    login: {
      type: 'string',
    },
    name: {
      nullable: true,
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    organizations_url: {
      format: 'uri',
      type: 'string',
    },
    owned_private_repos: {
      example: 2,
      type: 'integer',
    },
    plan: {
      properties: {
        collaborators: {
          type: 'integer',
        },
        name: {
          type: 'string',
        },
        private_repos: {
          type: 'integer',
        },
        space: {
          type: 'integer',
        },
      },
      required: ['collaborators', 'name', 'space', 'private_repos'],
      type: 'object',
    },
    private_gists: {
      example: 1,
      type: 'integer',
    },
    public_gists: {
      type: 'integer',
    },
    public_repos: {
      type: 'integer',
    },
    received_events_url: {
      format: 'uri',
      type: 'string',
    },
    repos_url: {
      format: 'uri',
      type: 'string',
    },
    site_admin: {
      type: 'boolean',
    },
    starred_url: {
      type: 'string',
    },
    subscriptions_url: {
      format: 'uri',
      type: 'string',
    },
    suspended_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    total_private_repos: {
      example: 2,
      type: 'integer',
    },
    twitter_username: {
      nullable: true,
      type: 'string',
    },
    type: {
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'avatar_url',
    'events_url',
    'followers_url',
    'following_url',
    'gists_url',
    'gravatar_id',
    'html_url',
    'id',
    'node_id',
    'login',
    'organizations_url',
    'received_events_url',
    'repos_url',
    'site_admin',
    'starred_url',
    'subscriptions_url',
    'type',
    'url',
    'bio',
    'blog',
    'company',
    'email',
    'followers',
    'following',
    'hireable',
    'location',
    'name',
    'public_gists',
    'public_repos',
    'created_at',
    'updated_at',
  ],
  title: 'Public User',
  type: 'object',
} as const;

export const pull_requestSchema = {
  description:
    "Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.",
  properties: {
    _links: {
      properties: {
        comments: {
          $ref: '#/components/schemas/link',
        },
        commits: {
          $ref: '#/components/schemas/link',
        },
        html: {
          $ref: '#/components/schemas/link',
        },
        issue: {
          $ref: '#/components/schemas/link',
        },
        review_comment: {
          $ref: '#/components/schemas/link',
        },
        review_comments: {
          $ref: '#/components/schemas/link',
        },
        self: {
          $ref: '#/components/schemas/link',
        },
        statuses: {
          $ref: '#/components/schemas/link',
        },
      },
      required: ['comments', 'commits', 'statuses', 'html', 'issue', 'review_comments', 'review_comment', 'self'],
      type: 'object',
    },
    active_lock_reason: {
      example: 'too heated',
      nullable: true,
      type: 'string',
    },
    additions: {
      example: 100,
      type: 'integer',
    },
    assignee: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    assignees: {
      items: {
        $ref: '#/components/schemas/simple-user',
      },
      nullable: true,
      type: 'array',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    auto_merge: {
      $ref: '#/components/schemas/auto-merge',
    },
    base: {
      properties: {
        label: {
          type: 'string',
        },
        ref: {
          type: 'string',
        },
        repo: {
          properties: {
            allow_forking: {
              type: 'boolean',
            },
            allow_merge_commit: {
              type: 'boolean',
            },
            allow_rebase_merge: {
              type: 'boolean',
            },
            allow_squash_merge: {
              type: 'boolean',
            },
            archive_url: {
              type: 'string',
            },
            archived: {
              type: 'boolean',
            },
            assignees_url: {
              type: 'string',
            },
            blobs_url: {
              type: 'string',
            },
            branches_url: {
              type: 'string',
            },
            clone_url: {
              type: 'string',
            },
            collaborators_url: {
              type: 'string',
            },
            comments_url: {
              type: 'string',
            },
            commits_url: {
              type: 'string',
            },
            compare_url: {
              type: 'string',
            },
            contents_url: {
              type: 'string',
            },
            contributors_url: {
              format: 'uri',
              type: 'string',
            },
            created_at: {
              format: 'date-time',
              type: 'string',
            },
            default_branch: {
              type: 'string',
            },
            deployments_url: {
              format: 'uri',
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            disabled: {
              type: 'boolean',
            },
            downloads_url: {
              format: 'uri',
              type: 'string',
            },
            events_url: {
              format: 'uri',
              type: 'string',
            },
            fork: {
              type: 'boolean',
            },
            forks: {
              type: 'integer',
            },
            forks_count: {
              type: 'integer',
            },
            forks_url: {
              format: 'uri',
              type: 'string',
            },
            full_name: {
              type: 'string',
            },
            git_commits_url: {
              type: 'string',
            },
            git_refs_url: {
              type: 'string',
            },
            git_tags_url: {
              type: 'string',
            },
            git_url: {
              type: 'string',
            },
            has_discussions: {
              type: 'boolean',
            },
            has_downloads: {
              type: 'boolean',
            },
            has_issues: {
              type: 'boolean',
            },
            has_pages: {
              type: 'boolean',
            },
            has_projects: {
              type: 'boolean',
            },
            has_wiki: {
              type: 'boolean',
            },
            homepage: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            hooks_url: {
              format: 'uri',
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            is_template: {
              type: 'boolean',
            },
            issue_comment_url: {
              type: 'string',
            },
            issue_events_url: {
              type: 'string',
            },
            issues_url: {
              type: 'string',
            },
            keys_url: {
              type: 'string',
            },
            labels_url: {
              type: 'string',
            },
            language: {
              nullable: true,
              type: 'string',
            },
            languages_url: {
              format: 'uri',
              type: 'string',
            },
            license: {
              $ref: '#/components/schemas/nullable-license-simple',
            },
            master_branch: {
              type: 'string',
            },
            merges_url: {
              format: 'uri',
              type: 'string',
            },
            milestones_url: {
              type: 'string',
            },
            mirror_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            notifications_url: {
              type: 'string',
            },
            open_issues: {
              type: 'integer',
            },
            open_issues_count: {
              type: 'integer',
            },
            owner: {
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                events_url: {
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  type: 'string',
                },
                gists_url: {
                  type: 'string',
                },
                gravatar_id: {
                  nullable: true,
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: [
                'avatar_url',
                'events_url',
                'followers_url',
                'following_url',
                'gists_url',
                'gravatar_id',
                'html_url',
                'id',
                'node_id',
                'login',
                'organizations_url',
                'received_events_url',
                'repos_url',
                'site_admin',
                'starred_url',
                'subscriptions_url',
                'type',
                'url',
              ],
              type: 'object',
            },
            permissions: {
              properties: {
                admin: {
                  type: 'boolean',
                },
                maintain: {
                  type: 'boolean',
                },
                pull: {
                  type: 'boolean',
                },
                push: {
                  type: 'boolean',
                },
                triage: {
                  type: 'boolean',
                },
              },
              required: ['admin', 'pull', 'push'],
              type: 'object',
            },
            private: {
              type: 'boolean',
            },
            pulls_url: {
              type: 'string',
            },
            pushed_at: {
              format: 'date-time',
              type: 'string',
            },
            releases_url: {
              type: 'string',
            },
            size: {
              type: 'integer',
            },
            ssh_url: {
              type: 'string',
            },
            stargazers_count: {
              type: 'integer',
            },
            stargazers_url: {
              format: 'uri',
              type: 'string',
            },
            statuses_url: {
              type: 'string',
            },
            subscribers_url: {
              format: 'uri',
              type: 'string',
            },
            subscription_url: {
              format: 'uri',
              type: 'string',
            },
            svn_url: {
              format: 'uri',
              type: 'string',
            },
            tags_url: {
              format: 'uri',
              type: 'string',
            },
            teams_url: {
              format: 'uri',
              type: 'string',
            },
            temp_clone_token: {
              type: 'string',
            },
            topics: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            trees_url: {
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
            visibility: {
              description: 'The repository visibility: public, private, or internal.',
              type: 'string',
            },
            watchers: {
              type: 'integer',
            },
            watchers_count: {
              type: 'integer',
            },
            web_commit_signoff_required: {
              type: 'boolean',
            },
          },
          required: [
            'archive_url',
            'assignees_url',
            'blobs_url',
            'branches_url',
            'collaborators_url',
            'comments_url',
            'commits_url',
            'compare_url',
            'contents_url',
            'contributors_url',
            'deployments_url',
            'description',
            'downloads_url',
            'events_url',
            'fork',
            'forks_url',
            'full_name',
            'git_commits_url',
            'git_refs_url',
            'git_tags_url',
            'hooks_url',
            'html_url',
            'id',
            'node_id',
            'issue_comment_url',
            'issue_events_url',
            'issues_url',
            'keys_url',
            'labels_url',
            'languages_url',
            'merges_url',
            'milestones_url',
            'name',
            'notifications_url',
            'owner',
            'private',
            'pulls_url',
            'releases_url',
            'stargazers_url',
            'statuses_url',
            'subscribers_url',
            'subscription_url',
            'tags_url',
            'teams_url',
            'trees_url',
            'url',
            'clone_url',
            'default_branch',
            'forks',
            'forks_count',
            'git_url',
            'has_downloads',
            'has_issues',
            'has_projects',
            'has_wiki',
            'has_pages',
            'has_discussions',
            'homepage',
            'language',
            'archived',
            'disabled',
            'mirror_url',
            'open_issues',
            'open_issues_count',
            'license',
            'pushed_at',
            'size',
            'ssh_url',
            'stargazers_count',
            'svn_url',
            'watchers',
            'watchers_count',
            'created_at',
            'updated_at',
          ],
          type: 'object',
        },
        sha: {
          type: 'string',
        },
        user: {
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            events_url: {
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              type: 'string',
            },
            gists_url: {
              type: 'string',
            },
            gravatar_id: {
              nullable: true,
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: [
            'avatar_url',
            'events_url',
            'followers_url',
            'following_url',
            'gists_url',
            'gravatar_id',
            'html_url',
            'id',
            'node_id',
            'login',
            'organizations_url',
            'received_events_url',
            'repos_url',
            'site_admin',
            'starred_url',
            'subscriptions_url',
            'type',
            'url',
          ],
          type: 'object',
        },
      },
      required: ['label', 'ref', 'repo', 'sha', 'user'],
      type: 'object',
    },
    body: {
      example: 'Please pull these awesome changes',
      nullable: true,
      type: 'string',
    },
    changed_files: {
      example: 5,
      type: 'integer',
    },
    closed_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    comments: {
      example: 10,
      type: 'integer',
    },
    comments_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/1347/comments',
      format: 'uri',
      type: 'string',
    },
    commits: {
      example: 3,
      type: 'integer',
    },
    commits_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/1347/commits',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    deletions: {
      example: 3,
      type: 'integer',
    },
    diff_url: {
      example: 'https://github.com/octocat/Hello-World/pull/1347.diff',
      format: 'uri',
      type: 'string',
    },
    draft: {
      description: 'Indicates whether or not the pull request is a draft.',
      example: false,
      type: 'boolean',
    },
    head: {
      properties: {
        label: {
          type: 'string',
        },
        ref: {
          type: 'string',
        },
        repo: {
          nullable: true,
          properties: {
            allow_forking: {
              type: 'boolean',
            },
            allow_merge_commit: {
              type: 'boolean',
            },
            allow_rebase_merge: {
              type: 'boolean',
            },
            allow_squash_merge: {
              type: 'boolean',
            },
            archive_url: {
              type: 'string',
            },
            archived: {
              type: 'boolean',
            },
            assignees_url: {
              type: 'string',
            },
            blobs_url: {
              type: 'string',
            },
            branches_url: {
              type: 'string',
            },
            clone_url: {
              type: 'string',
            },
            collaborators_url: {
              type: 'string',
            },
            comments_url: {
              type: 'string',
            },
            commits_url: {
              type: 'string',
            },
            compare_url: {
              type: 'string',
            },
            contents_url: {
              type: 'string',
            },
            contributors_url: {
              format: 'uri',
              type: 'string',
            },
            created_at: {
              format: 'date-time',
              type: 'string',
            },
            default_branch: {
              type: 'string',
            },
            deployments_url: {
              format: 'uri',
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            disabled: {
              type: 'boolean',
            },
            downloads_url: {
              format: 'uri',
              type: 'string',
            },
            events_url: {
              format: 'uri',
              type: 'string',
            },
            fork: {
              type: 'boolean',
            },
            forks: {
              type: 'integer',
            },
            forks_count: {
              type: 'integer',
            },
            forks_url: {
              format: 'uri',
              type: 'string',
            },
            full_name: {
              type: 'string',
            },
            git_commits_url: {
              type: 'string',
            },
            git_refs_url: {
              type: 'string',
            },
            git_tags_url: {
              type: 'string',
            },
            git_url: {
              type: 'string',
            },
            has_discussions: {
              type: 'boolean',
            },
            has_downloads: {
              type: 'boolean',
            },
            has_issues: {
              type: 'boolean',
            },
            has_pages: {
              type: 'boolean',
            },
            has_projects: {
              type: 'boolean',
            },
            has_wiki: {
              type: 'boolean',
            },
            homepage: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            hooks_url: {
              format: 'uri',
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            is_template: {
              type: 'boolean',
            },
            issue_comment_url: {
              type: 'string',
            },
            issue_events_url: {
              type: 'string',
            },
            issues_url: {
              type: 'string',
            },
            keys_url: {
              type: 'string',
            },
            labels_url: {
              type: 'string',
            },
            language: {
              nullable: true,
              type: 'string',
            },
            languages_url: {
              format: 'uri',
              type: 'string',
            },
            license: {
              nullable: true,
              properties: {
                key: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                spdx_id: {
                  nullable: true,
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  nullable: true,
                  type: 'string',
                },
              },
              required: ['key', 'name', 'url', 'spdx_id', 'node_id'],
              type: 'object',
            },
            master_branch: {
              type: 'string',
            },
            merges_url: {
              format: 'uri',
              type: 'string',
            },
            milestones_url: {
              type: 'string',
            },
            mirror_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            notifications_url: {
              type: 'string',
            },
            open_issues: {
              type: 'integer',
            },
            open_issues_count: {
              type: 'integer',
            },
            owner: {
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                events_url: {
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  type: 'string',
                },
                gists_url: {
                  type: 'string',
                },
                gravatar_id: {
                  nullable: true,
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: [
                'avatar_url',
                'events_url',
                'followers_url',
                'following_url',
                'gists_url',
                'gravatar_id',
                'html_url',
                'id',
                'node_id',
                'login',
                'organizations_url',
                'received_events_url',
                'repos_url',
                'site_admin',
                'starred_url',
                'subscriptions_url',
                'type',
                'url',
              ],
              type: 'object',
            },
            permissions: {
              properties: {
                admin: {
                  type: 'boolean',
                },
                maintain: {
                  type: 'boolean',
                },
                pull: {
                  type: 'boolean',
                },
                push: {
                  type: 'boolean',
                },
                triage: {
                  type: 'boolean',
                },
              },
              required: ['admin', 'pull', 'push'],
              type: 'object',
            },
            private: {
              type: 'boolean',
            },
            pulls_url: {
              type: 'string',
            },
            pushed_at: {
              format: 'date-time',
              type: 'string',
            },
            releases_url: {
              type: 'string',
            },
            size: {
              type: 'integer',
            },
            ssh_url: {
              type: 'string',
            },
            stargazers_count: {
              type: 'integer',
            },
            stargazers_url: {
              format: 'uri',
              type: 'string',
            },
            statuses_url: {
              type: 'string',
            },
            subscribers_url: {
              format: 'uri',
              type: 'string',
            },
            subscription_url: {
              format: 'uri',
              type: 'string',
            },
            svn_url: {
              format: 'uri',
              type: 'string',
            },
            tags_url: {
              format: 'uri',
              type: 'string',
            },
            teams_url: {
              format: 'uri',
              type: 'string',
            },
            temp_clone_token: {
              type: 'string',
            },
            topics: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            trees_url: {
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
            visibility: {
              description: 'The repository visibility: public, private, or internal.',
              type: 'string',
            },
            watchers: {
              type: 'integer',
            },
            watchers_count: {
              type: 'integer',
            },
            web_commit_signoff_required: {
              type: 'boolean',
            },
          },
          required: [
            'archive_url',
            'assignees_url',
            'blobs_url',
            'branches_url',
            'collaborators_url',
            'comments_url',
            'commits_url',
            'compare_url',
            'contents_url',
            'contributors_url',
            'deployments_url',
            'description',
            'downloads_url',
            'events_url',
            'fork',
            'forks_url',
            'full_name',
            'git_commits_url',
            'git_refs_url',
            'git_tags_url',
            'hooks_url',
            'html_url',
            'id',
            'node_id',
            'issue_comment_url',
            'issue_events_url',
            'issues_url',
            'keys_url',
            'labels_url',
            'languages_url',
            'merges_url',
            'milestones_url',
            'name',
            'notifications_url',
            'owner',
            'private',
            'pulls_url',
            'releases_url',
            'stargazers_url',
            'statuses_url',
            'subscribers_url',
            'subscription_url',
            'tags_url',
            'teams_url',
            'trees_url',
            'url',
            'clone_url',
            'default_branch',
            'forks',
            'forks_count',
            'git_url',
            'has_downloads',
            'has_issues',
            'has_projects',
            'has_wiki',
            'has_pages',
            'has_discussions',
            'homepage',
            'language',
            'archived',
            'disabled',
            'mirror_url',
            'open_issues',
            'open_issues_count',
            'license',
            'pushed_at',
            'size',
            'ssh_url',
            'stargazers_count',
            'svn_url',
            'watchers',
            'watchers_count',
            'created_at',
            'updated_at',
          ],
          type: 'object',
        },
        sha: {
          type: 'string',
        },
        user: {
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            events_url: {
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              type: 'string',
            },
            gists_url: {
              type: 'string',
            },
            gravatar_id: {
              nullable: true,
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: [
            'avatar_url',
            'events_url',
            'followers_url',
            'following_url',
            'gists_url',
            'gravatar_id',
            'html_url',
            'id',
            'node_id',
            'login',
            'organizations_url',
            'received_events_url',
            'repos_url',
            'site_admin',
            'starred_url',
            'subscriptions_url',
            'type',
            'url',
          ],
          type: 'object',
        },
      },
      required: ['label', 'ref', 'repo', 'sha', 'user'],
      type: 'object',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/pull/1347',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    issue_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/1347',
      format: 'uri',
      type: 'string',
    },
    labels: {
      items: {
        properties: {
          color: {
            type: 'string',
          },
          default: {
            type: 'boolean',
          },
          description: {
            nullable: true,
            type: 'string',
          },
          id: {
            format: 'int64',
            type: 'integer',
          },
          name: {
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          url: {
            type: 'string',
          },
        },
        required: ['id', 'node_id', 'url', 'name', 'description', 'color', 'default'],
        type: 'object',
      },
      type: 'array',
    },
    locked: {
      example: true,
      type: 'boolean',
    },
    maintainer_can_modify: {
      description: 'Indicates whether maintainers can modify the pull request.',
      example: true,
      type: 'boolean',
    },
    merge_commit_sha: {
      example: 'e5bd3914e2e596debea16f433f57875b5b90bcd6',
      nullable: true,
      type: 'string',
    },
    mergeable: {
      example: true,
      nullable: true,
      type: 'boolean',
    },
    mergeable_state: {
      example: 'clean',
      type: 'string',
    },
    merged: {
      type: 'boolean',
    },
    merged_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    merged_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    milestone: {
      $ref: '#/components/schemas/nullable-milestone',
    },
    node_id: {
      example: 'MDExOlB1bGxSZXF1ZXN0MQ==',
      type: 'string',
    },
    number: {
      description: 'Number uniquely identifying the pull request within its repository.',
      example: 42,
      type: 'integer',
    },
    patch_url: {
      example: 'https://github.com/octocat/Hello-World/pull/1347.patch',
      format: 'uri',
      type: 'string',
    },
    rebaseable: {
      example: true,
      nullable: true,
      type: 'boolean',
    },
    requested_reviewers: {
      items: {
        $ref: '#/components/schemas/simple-user',
      },
      nullable: true,
      type: 'array',
    },
    requested_teams: {
      items: {
        $ref: '#/components/schemas/team-simple',
      },
      nullable: true,
      type: 'array',
    },
    review_comment_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/comments{/number}',
      type: 'string',
    },
    review_comments: {
      example: 0,
      type: 'integer',
    },
    review_comments_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/1347/comments',
      format: 'uri',
      type: 'string',
    },
    state: {
      description: 'State of this Pull Request. Either `open` or `closed`.',
      enum: ['open', 'closed'],
      example: 'open',
      type: 'string',
    },
    statuses_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/statuses/6dcb09b5b57875f334f61aebed695e2e4193db5e',
      format: 'uri',
      type: 'string',
    },
    title: {
      description: 'The title of the pull request.',
      example: 'Amazing new feature',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/1347',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    '_links',
    'assignee',
    'labels',
    'base',
    'body',
    'closed_at',
    'comments_url',
    'commits_url',
    'created_at',
    'diff_url',
    'head',
    'html_url',
    'id',
    'node_id',
    'issue_url',
    'merge_commit_sha',
    'merged_at',
    'milestone',
    'number',
    'patch_url',
    'review_comment_url',
    'review_comments_url',
    'statuses_url',
    'state',
    'locked',
    'title',
    'updated_at',
    'url',
    'user',
    'author_association',
    'auto_merge',
    'additions',
    'changed_files',
    'comments',
    'commits',
    'deletions',
    'mergeable',
    'mergeable_state',
    'merged',
    'maintainer_can_modify',
    'merged_by',
    'review_comments',
  ],
  title: 'Pull Request',
  type: 'object',
} as const;

export const pull_request_merge_resultSchema = {
  description: 'Pull Request Merge Result',
  properties: {
    merged: {
      type: 'boolean',
    },
    message: {
      type: 'string',
    },
    sha: {
      type: 'string',
    },
  },
  required: ['merged', 'message', 'sha'],
  title: 'Pull Request Merge Result',
  type: 'object',
} as const;

export const pull_request_minimalSchema = {
  properties: {
    base: {
      properties: {
        ref: {
          type: 'string',
        },
        repo: {
          properties: {
            id: {
              type: 'integer',
            },
            name: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          required: ['id', 'url', 'name'],
          type: 'object',
        },
        sha: {
          type: 'string',
        },
      },
      required: ['ref', 'sha', 'repo'],
      type: 'object',
    },
    head: {
      properties: {
        ref: {
          type: 'string',
        },
        repo: {
          properties: {
            id: {
              type: 'integer',
            },
            name: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          required: ['id', 'url', 'name'],
          type: 'object',
        },
        sha: {
          type: 'string',
        },
      },
      required: ['ref', 'sha', 'repo'],
      type: 'object',
    },
    id: {
      type: 'integer',
    },
    number: {
      type: 'integer',
    },
    url: {
      type: 'string',
    },
  },
  required: ['id', 'number', 'url', 'head', 'base'],
  title: 'Pull Request Minimal',
  type: 'object',
} as const;

export const pull_request_reviewSchema = {
  description: 'Pull Request Reviews are reviews on pull requests.',
  properties: {
    _links: {
      properties: {
        html: {
          properties: {
            href: {
              type: 'string',
            },
          },
          required: ['href'],
          type: 'object',
        },
        pull_request: {
          properties: {
            href: {
              type: 'string',
            },
          },
          required: ['href'],
          type: 'object',
        },
      },
      required: ['html', 'pull_request'],
      type: 'object',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      description: 'The text of the review.',
      example: 'This looks great.',
      type: 'string',
    },
    body_html: {
      type: 'string',
    },
    body_text: {
      type: 'string',
    },
    commit_id: {
      description:
        'A commit SHA for the review. If the commit object was garbage collected or forcibly deleted, then it no longer exists in Git and this value will be `null`.',
      example: '54bb654c9e6025347f57900a4a5c2313a96b8035',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/pull/12#pullrequestreview-80',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the review',
      example: 42,
      type: 'integer',
    },
    node_id: {
      example: 'MDE3OlB1bGxSZXF1ZXN0UmV2aWV3ODA=',
      type: 'string',
    },
    pull_request_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/12',
      format: 'uri',
      type: 'string',
    },
    state: {
      example: 'CHANGES_REQUESTED',
      type: 'string',
    },
    submitted_at: {
      format: 'date-time',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    'id',
    'node_id',
    'user',
    'body',
    'state',
    'commit_id',
    'html_url',
    'pull_request_url',
    '_links',
    'author_association',
  ],
  title: 'Pull Request Review',
  type: 'object',
} as const;

export const pull_request_review_commentSchema = {
  description: "Pull Request Review Comments are comments on a portion of the Pull Request's diff.",
  properties: {
    _links: {
      properties: {
        html: {
          properties: {
            href: {
              example: 'https://github.com/octocat/Hello-World/pull/1#discussion-diff-1',
              format: 'uri',
              type: 'string',
            },
          },
          required: ['href'],
          type: 'object',
        },
        pull_request: {
          properties: {
            href: {
              example: 'https://api.github.com/repos/octocat/Hello-World/pulls/1',
              format: 'uri',
              type: 'string',
            },
          },
          required: ['href'],
          type: 'object',
        },
        self: {
          properties: {
            href: {
              example: 'https://api.github.com/repos/octocat/Hello-World/pulls/comments/1',
              format: 'uri',
              type: 'string',
            },
          },
          required: ['href'],
          type: 'object',
        },
      },
      required: ['self', 'html', 'pull_request'],
      type: 'object',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      description: 'The text of the comment.',
      example: 'We should probably include a check for null values here.',
      type: 'string',
    },
    body_html: {
      example: '"<p>comment body</p>"',
      type: 'string',
    },
    body_text: {
      example: '"comment body"',
      type: 'string',
    },
    commit_id: {
      description: 'The SHA of the commit to which the comment applies.',
      example: '6dcb09b5b57875f334f61aebed695e2e4193db5e',
      type: 'string',
    },
    created_at: {
      example: '2011-04-14T16:00:49Z',
      format: 'date-time',
      type: 'string',
    },
    diff_hunk: {
      description: 'The diff of the line that the comment refers to.',
      example: '@@ -16,33 +16,40 @@ public class Connection : IConnection...',
      type: 'string',
    },
    html_url: {
      description: 'HTML URL for the pull request review comment.',
      example: 'https://github.com/octocat/Hello-World/pull/1#discussion-diff-1',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'The ID of the pull request review comment.',
      example: 1,
      type: 'integer',
    },
    in_reply_to_id: {
      description: 'The comment ID to reply to.',
      example: 8,
      type: 'integer',
    },
    line: {
      description:
        'The line of the blob to which the comment applies. The last line of the range for a multi-line comment',
      example: 2,
      type: 'integer',
    },
    node_id: {
      description: 'The node ID of the pull request review comment.',
      example: 'MDI0OlB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDEw',
      type: 'string',
    },
    original_commit_id: {
      description: 'The SHA of the original commit to which the comment applies.',
      example: '9c48853fa3dc5c1c3d6f1f1cd1f2743e72652840',
      type: 'string',
    },
    original_line: {
      description:
        'The line of the blob to which the comment applies. The last line of the range for a multi-line comment',
      example: 2,
      type: 'integer',
    },
    original_position: {
      description:
        'The index of the original line in the diff to which the comment applies. This field is deprecated; use `original_line` instead.',
      example: 4,
      type: 'integer',
    },
    original_start_line: {
      description: 'The first line of the range for a multi-line comment.',
      example: 2,
      nullable: true,
      type: 'integer',
    },
    path: {
      description: 'The relative path of the file to which the comment applies.',
      example: 'config/database.yaml',
      type: 'string',
    },
    position: {
      description:
        'The line index in the diff to which the comment applies. This field is deprecated; use `line` instead.',
      example: 1,
      type: 'integer',
    },
    pull_request_review_id: {
      description: 'The ID of the pull request review to which the comment belongs.',
      example: 42,
      nullable: true,
      type: 'integer',
    },
    pull_request_url: {
      description: 'URL for the pull request that the review comment belongs to.',
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/1',
      format: 'uri',
      type: 'string',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    side: {
      default: 'RIGHT',
      description:
        'The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment',
      enum: ['LEFT', 'RIGHT'],
      type: 'string',
    },
    start_line: {
      description: 'The first line of the range for a multi-line comment.',
      example: 2,
      nullable: true,
      type: 'integer',
    },
    start_side: {
      default: 'RIGHT',
      description: 'The side of the first line of the range for a multi-line comment.',
      enum: ['LEFT', 'RIGHT'],
      nullable: true,
      type: 'string',
    },
    updated_at: {
      example: '2011-04-14T16:00:49Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      description: 'URL for the pull request review comment',
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/comments/1',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: [
    'url',
    'id',
    'node_id',
    'pull_request_review_id',
    'diff_hunk',
    'path',
    'position',
    'original_position',
    'commit_id',
    'original_commit_id',
    'user',
    'body',
    'created_at',
    'updated_at',
    'html_url',
    'pull_request_url',
    'author_association',
    '_links',
  ],
  title: 'Pull Request Review Comment',
  type: 'object',
} as const;

export const pull_request_review_requestSchema = {
  description: 'Pull Request Review Request',
  properties: {
    teams: {
      items: {
        $ref: '#/components/schemas/team',
      },
      type: 'array',
    },
    users: {
      items: {
        $ref: '#/components/schemas/simple-user',
      },
      type: 'array',
    },
  },
  required: ['users', 'teams'],
  title: 'Pull Request Review Request',
  type: 'object',
} as const;

export const pull_request_simpleSchema = {
  description: 'Pull Request Simple',
  properties: {
    _links: {
      properties: {
        comments: {
          $ref: '#/components/schemas/link',
        },
        commits: {
          $ref: '#/components/schemas/link',
        },
        html: {
          $ref: '#/components/schemas/link',
        },
        issue: {
          $ref: '#/components/schemas/link',
        },
        review_comment: {
          $ref: '#/components/schemas/link',
        },
        review_comments: {
          $ref: '#/components/schemas/link',
        },
        self: {
          $ref: '#/components/schemas/link',
        },
        statuses: {
          $ref: '#/components/schemas/link',
        },
      },
      required: ['comments', 'commits', 'statuses', 'html', 'issue', 'review_comments', 'review_comment', 'self'],
      type: 'object',
    },
    active_lock_reason: {
      example: 'too heated',
      nullable: true,
      type: 'string',
    },
    assignee: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    assignees: {
      items: {
        $ref: '#/components/schemas/simple-user',
      },
      nullable: true,
      type: 'array',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    auto_merge: {
      $ref: '#/components/schemas/auto-merge',
    },
    base: {
      properties: {
        label: {
          type: 'string',
        },
        ref: {
          type: 'string',
        },
        repo: {
          $ref: '#/components/schemas/repository',
        },
        sha: {
          type: 'string',
        },
        user: {
          $ref: '#/components/schemas/nullable-simple-user',
        },
      },
      required: ['label', 'ref', 'repo', 'sha', 'user'],
      type: 'object',
    },
    body: {
      example: 'Please pull these awesome changes',
      nullable: true,
      type: 'string',
    },
    closed_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    comments_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/1347/comments',
      format: 'uri',
      type: 'string',
    },
    commits_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/1347/commits',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    diff_url: {
      example: 'https://github.com/octocat/Hello-World/pull/1347.diff',
      format: 'uri',
      type: 'string',
    },
    draft: {
      description: 'Indicates whether or not the pull request is a draft.',
      example: false,
      type: 'boolean',
    },
    head: {
      properties: {
        label: {
          type: 'string',
        },
        ref: {
          type: 'string',
        },
        repo: {
          $ref: '#/components/schemas/repository',
        },
        sha: {
          type: 'string',
        },
        user: {
          $ref: '#/components/schemas/nullable-simple-user',
        },
      },
      required: ['label', 'ref', 'repo', 'sha', 'user'],
      type: 'object',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/pull/1347',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    issue_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/1347',
      format: 'uri',
      type: 'string',
    },
    labels: {
      items: {
        properties: {
          color: {
            type: 'string',
          },
          default: {
            type: 'boolean',
          },
          description: {
            type: 'string',
          },
          id: {
            format: 'int64',
            type: 'integer',
          },
          name: {
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          url: {
            type: 'string',
          },
        },
        required: ['id', 'node_id', 'url', 'name', 'description', 'color', 'default'],
        type: 'object',
      },
      type: 'array',
    },
    locked: {
      example: true,
      type: 'boolean',
    },
    merge_commit_sha: {
      example: 'e5bd3914e2e596debea16f433f57875b5b90bcd6',
      nullable: true,
      type: 'string',
    },
    merged_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    milestone: {
      $ref: '#/components/schemas/nullable-milestone',
    },
    node_id: {
      example: 'MDExOlB1bGxSZXF1ZXN0MQ==',
      type: 'string',
    },
    number: {
      example: 1347,
      type: 'integer',
    },
    patch_url: {
      example: 'https://github.com/octocat/Hello-World/pull/1347.patch',
      format: 'uri',
      type: 'string',
    },
    requested_reviewers: {
      items: {
        $ref: '#/components/schemas/simple-user',
      },
      nullable: true,
      type: 'array',
    },
    requested_teams: {
      items: {
        $ref: '#/components/schemas/team',
      },
      nullable: true,
      type: 'array',
    },
    review_comment_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/comments{/number}',
      type: 'string',
    },
    review_comments_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/1347/comments',
      format: 'uri',
      type: 'string',
    },
    state: {
      example: 'open',
      type: 'string',
    },
    statuses_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/statuses/6dcb09b5b57875f334f61aebed695e2e4193db5e',
      format: 'uri',
      type: 'string',
    },
    title: {
      example: 'new-feature',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/1347',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    '_links',
    'assignee',
    'labels',
    'base',
    'body',
    'closed_at',
    'comments_url',
    'commits_url',
    'created_at',
    'diff_url',
    'head',
    'html_url',
    'id',
    'node_id',
    'issue_url',
    'merge_commit_sha',
    'merged_at',
    'milestone',
    'number',
    'patch_url',
    'review_comment_url',
    'review_comments_url',
    'statuses_url',
    'state',
    'locked',
    'title',
    'updated_at',
    'url',
    'user',
    'author_association',
    'auto_merge',
  ],
  title: 'Pull Request Simple',
  type: 'object',
} as const;

export const rate_limitSchema = {
  properties: {
    limit: {
      type: 'integer',
    },
    remaining: {
      type: 'integer',
    },
    reset: {
      type: 'integer',
    },
    used: {
      type: 'integer',
    },
  },
  required: ['limit', 'remaining', 'reset', 'used'],
  title: 'Rate Limit',
  type: 'object',
} as const;

export const rate_limit_overviewSchema = {
  description: 'Rate Limit Overview',
  properties: {
    rate: {
      $ref: '#/components/schemas/rate-limit',
    },
    resources: {
      properties: {
        actions_runner_registration: {
          $ref: '#/components/schemas/rate-limit',
        },
        code_scanning_upload: {
          $ref: '#/components/schemas/rate-limit',
        },
        core: {
          $ref: '#/components/schemas/rate-limit',
        },
        dependency_snapshots: {
          $ref: '#/components/schemas/rate-limit',
        },
        graphql: {
          $ref: '#/components/schemas/rate-limit',
        },
        integration_manifest: {
          $ref: '#/components/schemas/rate-limit',
        },
        scim: {
          $ref: '#/components/schemas/rate-limit',
        },
        search: {
          $ref: '#/components/schemas/rate-limit',
        },
        source_import: {
          $ref: '#/components/schemas/rate-limit',
        },
      },
      required: ['core', 'search'],
      type: 'object',
    },
  },
  required: ['rate', 'resources'],
  title: 'Rate Limit Overview',
  type: 'object',
} as const;

export const reactionSchema = {
  description:
    'Reactions to conversations provide a way to help people express their feelings more simply and effectively.',
  properties: {
    content: {
      description: 'The reaction to use',
      enum: ['+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'rocket', 'eyes'],
      example: 'heart',
      type: 'string',
    },
    created_at: {
      example: '2016-05-20T20:09:31Z',
      format: 'date-time',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    node_id: {
      example: 'MDg6UmVhY3Rpb24x',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: ['id', 'node_id', 'user', 'content', 'created_at'],
  title: 'Reaction',
  type: 'object',
} as const;

export const reaction_rollupSchema = {
  properties: {
    '+1': {
      type: 'integer',
    },
    '-1': {
      type: 'integer',
    },
    confused: {
      type: 'integer',
    },
    eyes: {
      type: 'integer',
    },
    heart: {
      type: 'integer',
    },
    hooray: {
      type: 'integer',
    },
    laugh: {
      type: 'integer',
    },
    rocket: {
      type: 'integer',
    },
    total_count: {
      type: 'integer',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
  title: 'Reaction Rollup',
  type: 'object',
} as const;

export const referenced_workflowSchema = {
  description: 'A workflow referenced/reused by the initial caller workflow',
  properties: {
    path: {
      type: 'string',
    },
    ref: {
      type: 'string',
    },
    sha: {
      type: 'string',
    },
  },
  required: ['path', 'sha'],
  title: 'Referenced workflow',
  type: 'object',
} as const;

export const referrer_trafficSchema = {
  description: 'Referrer Traffic',
  properties: {
    count: {
      example: 4,
      type: 'integer',
    },
    referrer: {
      example: 'Google',
      type: 'string',
    },
    uniques: {
      example: 3,
      type: 'integer',
    },
  },
  required: ['referrer', 'uniques', 'count'],
  title: 'Referrer Traffic',
  type: 'object',
} as const;

export const releaseSchema = {
  description: 'A release.',
  properties: {
    assets: {
      items: {
        $ref: '#/components/schemas/release-asset',
      },
      type: 'array',
    },
    assets_url: {
      format: 'uri',
      type: 'string',
    },
    author: {
      $ref: '#/components/schemas/simple-user',
    },
    body: {
      nullable: true,
      type: 'string',
    },
    body_html: {
      type: 'string',
    },
    body_text: {
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    discussion_url: {
      description: 'The URL of the release discussion.',
      format: 'uri',
      type: 'string',
    },
    draft: {
      description: 'true to create a draft (unpublished) release, false to create a published one.',
      example: false,
      type: 'boolean',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    mentions_count: {
      type: 'integer',
    },
    name: {
      nullable: true,
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    prerelease: {
      description: 'Whether to identify the release as a prerelease or a full release.',
      example: false,
      type: 'boolean',
    },
    published_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    tag_name: {
      description: 'The name of the tag.',
      example: 'v1.0.0',
      type: 'string',
    },
    tarball_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    target_commitish: {
      description: 'Specifies the commitish value that determines where the Git tag is created from.',
      example: 'master',
      type: 'string',
    },
    upload_url: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    zipball_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'assets_url',
    'upload_url',
    'tarball_url',
    'zipball_url',
    'created_at',
    'published_at',
    'draft',
    'id',
    'node_id',
    'author',
    'html_url',
    'name',
    'prerelease',
    'tag_name',
    'target_commitish',
    'assets',
    'url',
  ],
  title: 'Release',
  type: 'object',
} as const;

export const release_assetSchema = {
  description: 'Data related to a release.',
  properties: {
    browser_download_url: {
      format: 'uri',
      type: 'string',
    },
    content_type: {
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    download_count: {
      type: 'integer',
    },
    id: {
      type: 'integer',
    },
    label: {
      nullable: true,
      type: 'string',
    },
    name: {
      description: 'The file name of the asset.',
      example: 'Team Environment',
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    size: {
      type: 'integer',
    },
    state: {
      description: 'State of the release asset.',
      enum: ['uploaded', 'open'],
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    uploader: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'name',
    'content_type',
    'size',
    'state',
    'url',
    'node_id',
    'download_count',
    'label',
    'uploader',
    'browser_download_url',
    'created_at',
    'updated_at',
  ],
  title: 'Release Asset',
  type: 'object',
} as const;

export const release_notes_contentSchema = {
  description: 'Generated name and body describing a release',
  properties: {
    body: {
      description: 'The generated body describing the contents of the release supporting markdown formatting',
      type: 'string',
    },
    name: {
      description: 'The generated name of the release',
      example: 'Release v1.0.0 is now available!',
      type: 'string',
    },
  },
  required: ['name', 'body'],
  title: 'Generated Release Notes Content',
  type: 'object',
} as const;

export const removed_from_project_issue_eventSchema = {
  description: 'Removed from Project Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    project_card: {
      properties: {
        column_name: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        previous_column_name: {
          type: 'string',
        },
        project_id: {
          type: 'integer',
        },
        project_url: {
          format: 'uri',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['id', 'url', 'project_id', 'project_url', 'column_name'],
      type: 'object',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Removed from Project Issue Event',
  type: 'object',
} as const;

export const renamed_issue_eventSchema = {
  description: 'Renamed Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    rename: {
      properties: {
        from: {
          type: 'string',
        },
        to: {
          type: 'string',
        },
      },
      required: ['from', 'to'],
      type: 'object',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'rename',
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Renamed Issue Event',
  type: 'object',
} as const;

export const repo_codespaces_secretSchema = {
  description: 'Set repository secrets for GitHub Codespaces.',
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    name: {
      description: 'The name of the secret.',
      example: 'SECRET_TOKEN',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
  },
  required: ['name', 'created_at', 'updated_at'],
  title: 'Codespaces Secret',
  type: 'object',
} as const;

export const repo_required_workflowSchema = {
  description: 'A GitHub Actions required workflow',
  properties: {
    badge_url: {
      example:
        'https://github.com/sample-org/sample-repo/workflows/required/sample-org/source-repo/.github/workflows/required_ci.yaml/badge.svg',
      type: 'string',
    },
    created_at: {
      example: '2019-12-06T14:20:20.000Z',
      format: 'date-time',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/sample-org/source-repo/blob/main/.github/workflows/required_ci.yaml',
      type: 'string',
    },
    id: {
      example: 5,
      type: 'integer',
    },
    name: {
      example: 'Required CI',
      type: 'string',
    },
    node_id: {
      example: 'MDg6V29ya2Zsb3cxMg==',
      type: 'string',
    },
    path: {
      example: '.github/workflows/required_ci.yaml',
      type: 'string',
    },
    source_repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    state: {
      enum: ['active', 'deleted'],
      example: 'active',
      type: 'string',
    },
    updated_at: {
      example: '2019-12-06T14:20:20.000Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/sample-org/sample-repo/actions/required_workflows/5',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'name',
    'path',
    'state',
    'source_repository',
    'url',
    'html_url',
    'badge_url',
    'created_at',
    'updated_at',
  ],
  title: 'Required workflow',
  type: 'object',
} as const;

export const repo_search_result_itemSchema = {
  description: 'Repo Search Result Item',
  properties: {
    allow_auto_merge: {
      type: 'boolean',
    },
    allow_forking: {
      type: 'boolean',
    },
    allow_merge_commit: {
      type: 'boolean',
    },
    allow_rebase_merge: {
      type: 'boolean',
    },
    allow_squash_merge: {
      type: 'boolean',
    },
    archive_url: {
      type: 'string',
    },
    archived: {
      type: 'boolean',
    },
    assignees_url: {
      type: 'string',
    },
    blobs_url: {
      type: 'string',
    },
    branches_url: {
      type: 'string',
    },
    clone_url: {
      type: 'string',
    },
    collaborators_url: {
      type: 'string',
    },
    comments_url: {
      type: 'string',
    },
    commits_url: {
      type: 'string',
    },
    compare_url: {
      type: 'string',
    },
    contents_url: {
      type: 'string',
    },
    contributors_url: {
      format: 'uri',
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    default_branch: {
      type: 'string',
    },
    delete_branch_on_merge: {
      type: 'boolean',
    },
    deployments_url: {
      format: 'uri',
      type: 'string',
    },
    description: {
      nullable: true,
      type: 'string',
    },
    disabled: {
      description: 'Returns whether or not this repository disabled.',
      type: 'boolean',
    },
    downloads_url: {
      format: 'uri',
      type: 'string',
    },
    events_url: {
      format: 'uri',
      type: 'string',
    },
    fork: {
      type: 'boolean',
    },
    forks: {
      type: 'integer',
    },
    forks_count: {
      type: 'integer',
    },
    forks_url: {
      format: 'uri',
      type: 'string',
    },
    full_name: {
      type: 'string',
    },
    git_commits_url: {
      type: 'string',
    },
    git_refs_url: {
      type: 'string',
    },
    git_tags_url: {
      type: 'string',
    },
    git_url: {
      type: 'string',
    },
    has_discussions: {
      type: 'boolean',
    },
    has_downloads: {
      type: 'boolean',
    },
    has_issues: {
      type: 'boolean',
    },
    has_pages: {
      type: 'boolean',
    },
    has_projects: {
      type: 'boolean',
    },
    has_wiki: {
      type: 'boolean',
    },
    homepage: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    hooks_url: {
      format: 'uri',
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    is_template: {
      type: 'boolean',
    },
    issue_comment_url: {
      type: 'string',
    },
    issue_events_url: {
      type: 'string',
    },
    issues_url: {
      type: 'string',
    },
    keys_url: {
      type: 'string',
    },
    labels_url: {
      type: 'string',
    },
    language: {
      nullable: true,
      type: 'string',
    },
    languages_url: {
      format: 'uri',
      type: 'string',
    },
    license: {
      $ref: '#/components/schemas/nullable-license-simple',
    },
    master_branch: {
      type: 'string',
    },
    merges_url: {
      format: 'uri',
      type: 'string',
    },
    milestones_url: {
      type: 'string',
    },
    mirror_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    notifications_url: {
      type: 'string',
    },
    open_issues: {
      type: 'integer',
    },
    open_issues_count: {
      type: 'integer',
    },
    owner: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      required: ['admin', 'pull', 'push'],
      type: 'object',
    },
    private: {
      type: 'boolean',
    },
    pulls_url: {
      type: 'string',
    },
    pushed_at: {
      format: 'date-time',
      type: 'string',
    },
    releases_url: {
      type: 'string',
    },
    score: {
      type: 'number',
    },
    size: {
      type: 'integer',
    },
    ssh_url: {
      type: 'string',
    },
    stargazers_count: {
      type: 'integer',
    },
    stargazers_url: {
      format: 'uri',
      type: 'string',
    },
    statuses_url: {
      type: 'string',
    },
    subscribers_url: {
      format: 'uri',
      type: 'string',
    },
    subscription_url: {
      format: 'uri',
      type: 'string',
    },
    svn_url: {
      format: 'uri',
      type: 'string',
    },
    tags_url: {
      format: 'uri',
      type: 'string',
    },
    teams_url: {
      format: 'uri',
      type: 'string',
    },
    temp_clone_token: {
      type: 'string',
    },
    text_matches: {
      $ref: '#/components/schemas/search-result-text-matches',
    },
    topics: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    trees_url: {
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    visibility: {
      description: 'The repository visibility: public, private, or internal.',
      type: 'string',
    },
    watchers: {
      type: 'integer',
    },
    watchers_count: {
      type: 'integer',
    },
    web_commit_signoff_required: {
      example: false,
      type: 'boolean',
    },
  },
  required: [
    'archive_url',
    'assignees_url',
    'blobs_url',
    'branches_url',
    'collaborators_url',
    'comments_url',
    'commits_url',
    'compare_url',
    'contents_url',
    'contributors_url',
    'deployments_url',
    'description',
    'downloads_url',
    'events_url',
    'fork',
    'forks_url',
    'full_name',
    'git_commits_url',
    'git_refs_url',
    'git_tags_url',
    'hooks_url',
    'html_url',
    'id',
    'node_id',
    'issue_comment_url',
    'issue_events_url',
    'issues_url',
    'keys_url',
    'labels_url',
    'languages_url',
    'merges_url',
    'milestones_url',
    'name',
    'notifications_url',
    'owner',
    'private',
    'pulls_url',
    'releases_url',
    'stargazers_url',
    'statuses_url',
    'subscribers_url',
    'subscription_url',
    'tags_url',
    'teams_url',
    'trees_url',
    'url',
    'clone_url',
    'default_branch',
    'forks',
    'forks_count',
    'git_url',
    'has_downloads',
    'has_issues',
    'has_projects',
    'has_wiki',
    'has_pages',
    'homepage',
    'language',
    'archived',
    'disabled',
    'mirror_url',
    'open_issues',
    'open_issues_count',
    'license',
    'pushed_at',
    'size',
    'ssh_url',
    'stargazers_count',
    'svn_url',
    'watchers',
    'watchers_count',
    'created_at',
    'updated_at',
    'score',
  ],
  title: 'Repo Search Result Item',
  type: 'object',
} as const;

export const repositorySchema = {
  description: 'A repository on GitHub.',
  properties: {
    allow_auto_merge: {
      default: false,
      description: 'Whether to allow Auto-merge to be used on pull requests.',
      example: false,
      type: 'boolean',
    },
    allow_forking: {
      description: 'Whether to allow forking this repo',
      type: 'boolean',
    },
    allow_merge_commit: {
      default: true,
      description: 'Whether to allow merge commits for pull requests.',
      example: true,
      type: 'boolean',
    },
    allow_rebase_merge: {
      default: true,
      description: 'Whether to allow rebase merges for pull requests.',
      example: true,
      type: 'boolean',
    },
    allow_squash_merge: {
      default: true,
      description: 'Whether to allow squash merges for pull requests.',
      example: true,
      type: 'boolean',
    },
    allow_update_branch: {
      default: false,
      description:
        'Whether or not a pull request head branch that is behind its base branch can always be updated even if it is not required to be up to date before merging.',
      example: false,
      type: 'boolean',
    },
    anonymous_access_enabled: {
      description: 'Whether anonymous git access is enabled for this repository',
      type: 'boolean',
    },
    archive_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}',
      type: 'string',
    },
    archived: {
      default: false,
      description: 'Whether the repository is archived.',
      type: 'boolean',
    },
    assignees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/assignees{/user}',
      type: 'string',
    },
    blobs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}',
      type: 'string',
    },
    branches_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/branches{/branch}',
      type: 'string',
    },
    clone_url: {
      example: 'https://github.com/octocat/Hello-World.git',
      type: 'string',
    },
    collaborators_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}',
      type: 'string',
    },
    comments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/comments{/number}',
      type: 'string',
    },
    commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/commits{/sha}',
      type: 'string',
    },
    compare_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}',
      type: 'string',
    },
    contents_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contents/{+path}',
      type: 'string',
    },
    contributors_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contributors',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    default_branch: {
      description: 'The default branch of the repository.',
      example: 'master',
      type: 'string',
    },
    delete_branch_on_merge: {
      default: false,
      description: 'Whether to delete head branches when pull requests are merged',
      example: false,
      type: 'boolean',
    },
    deployments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/deployments',
      format: 'uri',
      type: 'string',
    },
    description: {
      example: 'This your first repo!',
      nullable: true,
      type: 'string',
    },
    disabled: {
      description: 'Returns whether or not this repository disabled.',
      type: 'boolean',
    },
    downloads_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/downloads',
      format: 'uri',
      type: 'string',
    },
    events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/events',
      format: 'uri',
      type: 'string',
    },
    fork: {
      type: 'boolean',
    },
    forks: {
      type: 'integer',
    },
    forks_count: {
      example: 9,
      type: 'integer',
    },
    forks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/forks',
      format: 'uri',
      type: 'string',
    },
    full_name: {
      example: 'octocat/Hello-World',
      type: 'string',
    },
    git_commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}',
      type: 'string',
    },
    git_refs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}',
      type: 'string',
    },
    git_tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}',
      type: 'string',
    },
    git_url: {
      example: 'git:github.com/octocat/Hello-World.git',
      type: 'string',
    },
    has_discussions: {
      default: false,
      description: 'Whether discussions are enabled.',
      example: true,
      type: 'boolean',
    },
    has_downloads: {
      default: true,
      description: 'Whether downloads are enabled.',
      example: true,
      type: 'boolean',
    },
    has_issues: {
      default: true,
      description: 'Whether issues are enabled.',
      example: true,
      type: 'boolean',
    },
    has_pages: {
      type: 'boolean',
    },
    has_projects: {
      default: true,
      description: 'Whether projects are enabled.',
      example: true,
      type: 'boolean',
    },
    has_wiki: {
      default: true,
      description: 'Whether the wiki is enabled.',
      example: true,
      type: 'boolean',
    },
    homepage: {
      example: 'https://github.com',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    hooks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/hooks',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the repository',
      example: 42,
      type: 'integer',
    },
    is_template: {
      default: false,
      description: 'Whether this repository acts as a template that can be used to generate new repositories.',
      example: true,
      type: 'boolean',
    },
    issue_comment_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}',
      type: 'string',
    },
    issue_events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/events{/number}',
      type: 'string',
    },
    issues_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues{/number}',
      type: 'string',
    },
    keys_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/keys{/key_id}',
      type: 'string',
    },
    labels_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/labels{/name}',
      type: 'string',
    },
    language: {
      nullable: true,
      type: 'string',
    },
    languages_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/languages',
      format: 'uri',
      type: 'string',
    },
    license: {
      $ref: '#/components/schemas/nullable-license-simple',
    },
    master_branch: {
      type: 'string',
    },
    merge_commit_message: {
      description: `The default value for a merge commit message.

- \`PR_TITLE\` - default to the pull request's title.
- \`PR_BODY\` - default to the pull request's body.
- \`BLANK\` - default to a blank commit message.`,
      enum: ['PR_BODY', 'PR_TITLE', 'BLANK'],
      type: 'string',
    },
    merge_commit_title: {
      description: `The default value for a merge commit title.

- \`PR_TITLE\` - default to the pull request's title.
- \`MERGE_MESSAGE\` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).`,
      enum: ['PR_TITLE', 'MERGE_MESSAGE'],
      type: 'string',
    },
    merges_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/merges',
      format: 'uri',
      type: 'string',
    },
    milestones_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/milestones{/number}',
      type: 'string',
    },
    mirror_url: {
      example: 'git:git.example.com/octocat/Hello-World',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      description: 'The name of the repository.',
      example: 'Team Environment',
      type: 'string',
    },
    network_count: {
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5',
      type: 'string',
    },
    notifications_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}',
      type: 'string',
    },
    open_issues: {
      type: 'integer',
    },
    open_issues_count: {
      example: 0,
      type: 'integer',
    },
    organization: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      required: ['admin', 'pull', 'push'],
      type: 'object',
    },
    private: {
      default: false,
      description: 'Whether the repository is private or public.',
      type: 'boolean',
    },
    pulls_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/pulls{/number}',
      type: 'string',
    },
    pushed_at: {
      example: '2011-01-26T19:06:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    releases_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/releases{/id}',
      type: 'string',
    },
    size: {
      description:
        'The size of the repository. Size is calculated hourly. When a repository is initially created, the size is 0.',
      example: 108,
      type: 'integer',
    },
    squash_merge_commit_message: {
      description: `The default value for a squash merge commit message:

- \`PR_BODY\` - default to the pull request's body.
- \`COMMIT_MESSAGES\` - default to the branch's commit messages.
- \`BLANK\` - default to a blank commit message.`,
      enum: ['PR_BODY', 'COMMIT_MESSAGES', 'BLANK'],
      type: 'string',
    },
    squash_merge_commit_title: {
      description: `The default value for a squash merge commit title:

- \`PR_TITLE\` - default to the pull request's title.
- \`COMMIT_OR_PR_TITLE\` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).`,
      enum: ['PR_TITLE', 'COMMIT_OR_PR_TITLE'],
      type: 'string',
    },
    ssh_url: {
      example: 'git@github.com:octocat/Hello-World.git',
      type: 'string',
    },
    stargazers_count: {
      example: 80,
      type: 'integer',
    },
    stargazers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/stargazers',
      format: 'uri',
      type: 'string',
    },
    starred_at: {
      example: '"2020-07-09T00:17:42Z"',
      type: 'string',
    },
    statuses_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/statuses/{sha}',
      type: 'string',
    },
    subscribers_count: {
      type: 'integer',
    },
    subscribers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscribers',
      format: 'uri',
      type: 'string',
    },
    subscription_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscription',
      format: 'uri',
      type: 'string',
    },
    svn_url: {
      example: 'https://svn.github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/tags',
      format: 'uri',
      type: 'string',
    },
    teams_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/teams',
      format: 'uri',
      type: 'string',
    },
    temp_clone_token: {
      type: 'string',
    },
    template_repository: {
      nullable: true,
      properties: {
        allow_auto_merge: {
          type: 'boolean',
        },
        allow_merge_commit: {
          type: 'boolean',
        },
        allow_rebase_merge: {
          type: 'boolean',
        },
        allow_squash_merge: {
          type: 'boolean',
        },
        allow_update_branch: {
          type: 'boolean',
        },
        archive_url: {
          type: 'string',
        },
        archived: {
          type: 'boolean',
        },
        assignees_url: {
          type: 'string',
        },
        blobs_url: {
          type: 'string',
        },
        branches_url: {
          type: 'string',
        },
        clone_url: {
          type: 'string',
        },
        collaborators_url: {
          type: 'string',
        },
        comments_url: {
          type: 'string',
        },
        commits_url: {
          type: 'string',
        },
        compare_url: {
          type: 'string',
        },
        contents_url: {
          type: 'string',
        },
        contributors_url: {
          type: 'string',
        },
        created_at: {
          type: 'string',
        },
        default_branch: {
          type: 'string',
        },
        delete_branch_on_merge: {
          type: 'boolean',
        },
        deployments_url: {
          type: 'string',
        },
        description: {
          type: 'string',
        },
        disabled: {
          type: 'boolean',
        },
        downloads_url: {
          type: 'string',
        },
        events_url: {
          type: 'string',
        },
        fork: {
          type: 'boolean',
        },
        forks_count: {
          type: 'integer',
        },
        forks_url: {
          type: 'string',
        },
        full_name: {
          type: 'string',
        },
        git_commits_url: {
          type: 'string',
        },
        git_refs_url: {
          type: 'string',
        },
        git_tags_url: {
          type: 'string',
        },
        git_url: {
          type: 'string',
        },
        has_downloads: {
          type: 'boolean',
        },
        has_issues: {
          type: 'boolean',
        },
        has_pages: {
          type: 'boolean',
        },
        has_projects: {
          type: 'boolean',
        },
        has_wiki: {
          type: 'boolean',
        },
        homepage: {
          type: 'string',
        },
        hooks_url: {
          type: 'string',
        },
        html_url: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        is_template: {
          type: 'boolean',
        },
        issue_comment_url: {
          type: 'string',
        },
        issue_events_url: {
          type: 'string',
        },
        issues_url: {
          type: 'string',
        },
        keys_url: {
          type: 'string',
        },
        labels_url: {
          type: 'string',
        },
        language: {
          type: 'string',
        },
        languages_url: {
          type: 'string',
        },
        merge_commit_message: {
          description: `The default value for a merge commit message.

- \`PR_TITLE\` - default to the pull request's title.
- \`PR_BODY\` - default to the pull request's body.
- \`BLANK\` - default to a blank commit message.`,
          enum: ['PR_BODY', 'PR_TITLE', 'BLANK'],
          type: 'string',
        },
        merge_commit_title: {
          description: `The default value for a merge commit title.

- \`PR_TITLE\` - default to the pull request's title.
- \`MERGE_MESSAGE\` - default to the classic title for a merge message (e.g., Merge pull request #123 from branch-name).`,
          enum: ['PR_TITLE', 'MERGE_MESSAGE'],
          type: 'string',
        },
        merges_url: {
          type: 'string',
        },
        milestones_url: {
          type: 'string',
        },
        mirror_url: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        network_count: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        notifications_url: {
          type: 'string',
        },
        open_issues_count: {
          type: 'integer',
        },
        owner: {
          properties: {
            avatar_url: {
              type: 'string',
            },
            events_url: {
              type: 'string',
            },
            followers_url: {
              type: 'string',
            },
            following_url: {
              type: 'string',
            },
            gists_url: {
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              type: 'string',
            },
            received_events_url: {
              type: 'string',
            },
            repos_url: {
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              type: 'string',
            },
            subscriptions_url: {
              type: 'string',
            },
            type: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          type: 'object',
        },
        permissions: {
          properties: {
            admin: {
              type: 'boolean',
            },
            maintain: {
              type: 'boolean',
            },
            pull: {
              type: 'boolean',
            },
            push: {
              type: 'boolean',
            },
            triage: {
              type: 'boolean',
            },
          },
          type: 'object',
        },
        private: {
          type: 'boolean',
        },
        pulls_url: {
          type: 'string',
        },
        pushed_at: {
          type: 'string',
        },
        releases_url: {
          type: 'string',
        },
        size: {
          type: 'integer',
        },
        squash_merge_commit_message: {
          description: `The default value for a squash merge commit message:

- \`PR_BODY\` - default to the pull request's body.
- \`COMMIT_MESSAGES\` - default to the branch's commit messages.
- \`BLANK\` - default to a blank commit message.`,
          enum: ['PR_BODY', 'COMMIT_MESSAGES', 'BLANK'],
          type: 'string',
        },
        squash_merge_commit_title: {
          description: `The default value for a squash merge commit title:

- \`PR_TITLE\` - default to the pull request's title.
- \`COMMIT_OR_PR_TITLE\` - default to the commit's title (if only one commit) or the pull request's title (when more than one commit).`,
          enum: ['PR_TITLE', 'COMMIT_OR_PR_TITLE'],
          type: 'string',
        },
        ssh_url: {
          type: 'string',
        },
        stargazers_count: {
          type: 'integer',
        },
        stargazers_url: {
          type: 'string',
        },
        statuses_url: {
          type: 'string',
        },
        subscribers_count: {
          type: 'integer',
        },
        subscribers_url: {
          type: 'string',
        },
        subscription_url: {
          type: 'string',
        },
        svn_url: {
          type: 'string',
        },
        tags_url: {
          type: 'string',
        },
        teams_url: {
          type: 'string',
        },
        temp_clone_token: {
          type: 'string',
        },
        topics: {
          items: {
            type: 'string',
          },
          type: 'array',
        },
        trees_url: {
          type: 'string',
        },
        updated_at: {
          type: 'string',
        },
        url: {
          type: 'string',
        },
        use_squash_pr_title_as_default: {
          type: 'boolean',
        },
        visibility: {
          type: 'string',
        },
        watchers_count: {
          type: 'integer',
        },
      },
      type: 'object',
    },
    topics: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    trees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:14:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    use_squash_pr_title_as_default: {
      default: false,
      deprecated: true,
      description:
        'Whether a squash merge commit can use the pull request title as default. **This property has been deprecated. Please use `squash_merge_commit_title` instead.',
      type: 'boolean',
    },
    visibility: {
      default: 'public',
      description: 'The repository visibility: public, private, or internal.',
      type: 'string',
    },
    watchers: {
      type: 'integer',
    },
    watchers_count: {
      example: 80,
      type: 'integer',
    },
    web_commit_signoff_required: {
      default: false,
      description: 'Whether to require contributors to sign off on web-based commits',
      type: 'boolean',
    },
  },
  required: [
    'archive_url',
    'assignees_url',
    'blobs_url',
    'branches_url',
    'collaborators_url',
    'comments_url',
    'commits_url',
    'compare_url',
    'contents_url',
    'contributors_url',
    'deployments_url',
    'description',
    'downloads_url',
    'events_url',
    'fork',
    'forks_url',
    'full_name',
    'git_commits_url',
    'git_refs_url',
    'git_tags_url',
    'hooks_url',
    'html_url',
    'id',
    'node_id',
    'issue_comment_url',
    'issue_events_url',
    'issues_url',
    'keys_url',
    'labels_url',
    'languages_url',
    'merges_url',
    'milestones_url',
    'name',
    'notifications_url',
    'owner',
    'private',
    'pulls_url',
    'releases_url',
    'stargazers_url',
    'statuses_url',
    'subscribers_url',
    'subscription_url',
    'tags_url',
    'teams_url',
    'trees_url',
    'url',
    'clone_url',
    'default_branch',
    'forks',
    'forks_count',
    'git_url',
    'has_downloads',
    'has_issues',
    'has_projects',
    'has_wiki',
    'has_pages',
    'homepage',
    'language',
    'archived',
    'disabled',
    'mirror_url',
    'open_issues',
    'open_issues_count',
    'license',
    'pushed_at',
    'size',
    'ssh_url',
    'stargazers_count',
    'svn_url',
    'watchers',
    'watchers_count',
    'created_at',
    'updated_at',
  ],
  title: 'Repository',
  type: 'object',
} as const;

export const repository_collaborator_permissionSchema = {
  description: 'Repository Collaborator Permission',
  properties: {
    permission: {
      type: 'string',
    },
    role_name: {
      example: 'admin',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-collaborator',
    },
  },
  required: ['permission', 'role_name', 'user'],
  title: 'Repository Collaborator Permission',
  type: 'object',
} as const;

export const repository_invitationSchema = {
  description: 'Repository invitations let you manage who you collaborate with.',
  properties: {
    created_at: {
      example: '2016-06-13T14:52:50-05:00',
      format: 'date-time',
      type: 'string',
    },
    expired: {
      description: 'Whether or not the invitation has expired',
      type: 'boolean',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/invitations',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the repository invitation.',
      example: 42,
      type: 'integer',
    },
    invitee: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    inviter: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    node_id: {
      type: 'string',
    },
    permissions: {
      description: 'The permission associated with the invitation.',
      enum: ['read', 'write', 'admin', 'triage', 'maintain'],
      example: 'read',
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    url: {
      description: 'URL for the repository invitation',
      example: 'https://api.github.com/user/repository-invitations/1',
      type: 'string',
    },
  },
  required: ['id', 'node_id', 'permissions', 'inviter', 'invitee', 'repository', 'url', 'html_url', 'created_at'],
  title: 'Repository Invitation',
  type: 'object',
} as const;

export const repository_subscriptionSchema = {
  description: 'Repository invitations let you manage who you collaborate with.',
  properties: {
    created_at: {
      example: '2012-10-06T21:34:12Z',
      format: 'date-time',
      type: 'string',
    },
    ignored: {
      description: 'Determines if all notifications should be blocked from this repository.',
      type: 'boolean',
    },
    reason: {
      nullable: true,
      type: 'string',
    },
    repository_url: {
      example: 'https://api.github.com/repos/octocat/example',
      format: 'uri',
      type: 'string',
    },
    subscribed: {
      description: 'Determines if notifications should be received from this repository.',
      example: true,
      type: 'boolean',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/example/subscription',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['created_at', 'ignored', 'reason', 'subscribed', 'url', 'repository_url'],
  title: 'Repository Invitation',
  type: 'object',
} as const;

export const required_workflowSchema = {
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    id: {
      description: 'Unique identifier for a required workflow',
      type: 'number',
    },
    name: {
      description: 'Name present in the workflow file',
      type: 'string',
    },
    path: {
      description: 'Path of the workflow file',
      type: 'string',
    },
    ref: {
      description: 'Ref at which the workflow file will be selected',
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    scope: {
      description: 'Scope of the required workflow',
      enum: ['all', 'selected'],
      type: 'string',
    },
    selected_repositories_url: {
      example: 'https://api.github.com/organizations/org/actions/required_workflows/1/repositories',
      format: 'uri',
      type: 'string',
    },
    state: {
      description: 'State of the required workflow',
      enum: ['active', 'deleted'],
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
  },
  required: ['id', 'name', 'path', 'scope', 'ref', 'state', 'created_at', 'updated_at', 'repository'],
  type: 'object',
} as const;

export const review_commentSchema = {
  description: 'Legacy Review Comment',
  properties: {
    _links: {
      properties: {
        html: {
          $ref: '#/components/schemas/link',
        },
        pull_request: {
          $ref: '#/components/schemas/link',
        },
        self: {
          $ref: '#/components/schemas/link',
        },
      },
      required: ['self', 'html', 'pull_request'],
      type: 'object',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      example: 'Great stuff',
      type: 'string',
    },
    body_html: {
      type: 'string',
    },
    body_text: {
      type: 'string',
    },
    commit_id: {
      example: '6dcb09b5b57875f334f61aebed695e2e4193db5e',
      type: 'string',
    },
    created_at: {
      example: '2011-04-14T16:00:49Z',
      format: 'date-time',
      type: 'string',
    },
    diff_hunk: {
      example: '@@ -16,33 +16,40 @@ public class Connection : IConnection...',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/pull/1#discussion-diff-1',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 10,
      type: 'integer',
    },
    in_reply_to_id: {
      example: 8,
      type: 'integer',
    },
    line: {
      description:
        'The line of the blob to which the comment applies. The last line of the range for a multi-line comment',
      example: 2,
      type: 'integer',
    },
    node_id: {
      example: 'MDI0OlB1bGxSZXF1ZXN0UmV2aWV3Q29tbWVudDEw',
      type: 'string',
    },
    original_commit_id: {
      example: '9c48853fa3dc5c1c3d6f1f1cd1f2743e72652840',
      type: 'string',
    },
    original_line: {
      description:
        'The original line of the blob to which the comment applies. The last line of the range for a multi-line comment',
      example: 2,
      type: 'integer',
    },
    original_position: {
      example: 4,
      type: 'integer',
    },
    original_start_line: {
      description: 'The original first line of the range for a multi-line comment.',
      example: 2,
      nullable: true,
      type: 'integer',
    },
    path: {
      example: 'file1.txt',
      type: 'string',
    },
    position: {
      example: 1,
      nullable: true,
      type: 'integer',
    },
    pull_request_review_id: {
      example: 42,
      nullable: true,
      type: 'integer',
    },
    pull_request_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/1',
      format: 'uri',
      type: 'string',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    side: {
      default: 'RIGHT',
      description: 'The side of the first line of the range for a multi-line comment.',
      enum: ['LEFT', 'RIGHT'],
      type: 'string',
    },
    start_line: {
      description: 'The first line of the range for a multi-line comment.',
      example: 2,
      nullable: true,
      type: 'integer',
    },
    start_side: {
      default: 'RIGHT',
      description: 'The side of the first line of the range for a multi-line comment.',
      enum: ['LEFT', 'RIGHT'],
      nullable: true,
      type: 'string',
    },
    updated_at: {
      example: '2011-04-14T16:00:49Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/comments/1',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'body',
    'diff_hunk',
    'path',
    'position',
    'original_position',
    'commit_id',
    'original_commit_id',
    'user',
    'pull_request_review_id',
    'html_url',
    'pull_request_url',
    '_links',
    'author_association',
    'created_at',
    'updated_at',
  ],
  title: 'Legacy Review Comment',
  type: 'object',
} as const;

export const review_dismissed_issue_eventSchema = {
  description: 'Review Dismissed Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    dismissed_review: {
      properties: {
        dismissal_commit_id: {
          type: 'string',
        },
        dismissal_message: {
          nullable: true,
          type: 'string',
        },
        review_id: {
          type: 'integer',
        },
        state: {
          type: 'string',
        },
      },
      required: ['state', 'review_id', 'dismissal_message'],
      type: 'object',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'dismissed_review',
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Review Dismissed Issue Event',
  type: 'object',
} as const;

export const review_request_removed_issue_eventSchema = {
  description: 'Review Request Removed Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    requested_reviewer: {
      $ref: '#/components/schemas/simple-user',
    },
    requested_team: {
      $ref: '#/components/schemas/team',
    },
    review_requester: {
      $ref: '#/components/schemas/simple-user',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'review_requester',
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Review Request Removed Issue Event',
  type: 'object',
} as const;

export const review_requested_issue_eventSchema = {
  description: 'Review Requested Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    requested_reviewer: {
      $ref: '#/components/schemas/simple-user',
    },
    requested_team: {
      $ref: '#/components/schemas/team',
    },
    review_requester: {
      $ref: '#/components/schemas/simple-user',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'review_requester',
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Review Requested Issue Event',
  type: 'object',
} as const;

export const rootSchema = {
  properties: {
    authorizations_url: {
      format: 'uri-template',
      type: 'string',
    },
    code_search_url: {
      format: 'uri-template',
      type: 'string',
    },
    commit_search_url: {
      format: 'uri-template',
      type: 'string',
    },
    current_user_authorizations_html_url: {
      format: 'uri-template',
      type: 'string',
    },
    current_user_repositories_url: {
      format: 'uri-template',
      type: 'string',
    },
    current_user_url: {
      format: 'uri-template',
      type: 'string',
    },
    emails_url: {
      format: 'uri-template',
      type: 'string',
    },
    emojis_url: {
      format: 'uri-template',
      type: 'string',
    },
    events_url: {
      format: 'uri-template',
      type: 'string',
    },
    feeds_url: {
      format: 'uri-template',
      type: 'string',
    },
    followers_url: {
      format: 'uri-template',
      type: 'string',
    },
    following_url: {
      format: 'uri-template',
      type: 'string',
    },
    gists_url: {
      format: 'uri-template',
      type: 'string',
    },
    hub_url: {
      format: 'uri-template',
      type: 'string',
    },
    issue_search_url: {
      format: 'uri-template',
      type: 'string',
    },
    issues_url: {
      format: 'uri-template',
      type: 'string',
    },
    keys_url: {
      format: 'uri-template',
      type: 'string',
    },
    label_search_url: {
      format: 'uri-template',
      type: 'string',
    },
    notifications_url: {
      format: 'uri-template',
      type: 'string',
    },
    organization_repositories_url: {
      format: 'uri-template',
      type: 'string',
    },
    organization_teams_url: {
      format: 'uri-template',
      type: 'string',
    },
    organization_url: {
      format: 'uri-template',
      type: 'string',
    },
    public_gists_url: {
      format: 'uri-template',
      type: 'string',
    },
    rate_limit_url: {
      format: 'uri-template',
      type: 'string',
    },
    repository_search_url: {
      format: 'uri-template',
      type: 'string',
    },
    repository_url: {
      format: 'uri-template',
      type: 'string',
    },
    starred_gists_url: {
      format: 'uri-template',
      type: 'string',
    },
    starred_url: {
      format: 'uri-template',
      type: 'string',
    },
    topic_search_url: {
      format: 'uri-template',
      type: 'string',
    },
    user_organizations_url: {
      format: 'uri-template',
      type: 'string',
    },
    user_repositories_url: {
      format: 'uri-template',
      type: 'string',
    },
    user_search_url: {
      format: 'uri-template',
      type: 'string',
    },
    user_url: {
      format: 'uri-template',
      type: 'string',
    },
  },
  required: [
    'current_user_url',
    'current_user_authorizations_html_url',
    'authorizations_url',
    'code_search_url',
    'commit_search_url',
    'emails_url',
    'emojis_url',
    'events_url',
    'feeds_url',
    'followers_url',
    'following_url',
    'gists_url',
    'hub_url',
    'issue_search_url',
    'issues_url',
    'keys_url',
    'label_search_url',
    'notifications_url',
    'organization_url',
    'organization_repositories_url',
    'organization_teams_url',
    'public_gists_url',
    'rate_limit_url',
    'repository_url',
    'repository_search_url',
    'current_user_repositories_url',
    'starred_url',
    'starred_gists_url',
    'user_url',
    'user_organizations_url',
    'user_repositories_url',
    'user_search_url',
  ],
  type: 'object',
} as const;

export const runnerSchema = {
  description: 'A self hosted runner',
  properties: {
    busy: {
      type: 'boolean',
    },
    id: {
      description: 'The id of the runner.',
      example: 5,
      type: 'integer',
    },
    labels: {
      items: {
        $ref: '#/components/schemas/runner-label',
      },
      type: 'array',
    },
    name: {
      description: 'The name of the runner.',
      example: 'iMac',
      type: 'string',
    },
    os: {
      description: 'The Operating System of the runner.',
      example: 'macos',
      type: 'string',
    },
    status: {
      description: 'The status of the runner.',
      example: 'online',
      type: 'string',
    },
  },
  required: ['id', 'name', 'os', 'status', 'busy', 'labels'],
  title: 'Self hosted runners',
  type: 'object',
} as const;

export const runner_applicationSchema = {
  description: 'Runner Application',
  properties: {
    architecture: {
      type: 'string',
    },
    download_url: {
      type: 'string',
    },
    filename: {
      type: 'string',
    },
    os: {
      type: 'string',
    },
    sha256_checksum: {
      type: 'string',
    },
    temp_download_token: {
      description: 'A short lived bearer token used to download the runner, if needed.',
      type: 'string',
    },
  },
  required: ['os', 'architecture', 'download_url', 'filename'],
  title: 'Runner Application',
  type: 'object',
} as const;

export const runner_labelSchema = {
  description: 'A label for a self hosted runner',
  properties: {
    id: {
      description: 'Unique identifier of the label.',
      type: 'integer',
    },
    name: {
      description: 'Name of the label.',
      type: 'string',
    },
    type: {
      description: 'The type of label. Read-only labels are applied automatically when the runner is configured.',
      enum: ['read-only', 'custom'],
      type: 'string',
    },
  },
  required: ['name'],
  title: 'Self hosted runner label',
  type: 'object',
} as const;

export const scim_errorSchema = {
  description: 'Scim Error',
  properties: {
    detail: {
      nullable: true,
      type: 'string',
    },
    documentation_url: {
      nullable: true,
      type: 'string',
    },
    message: {
      nullable: true,
      type: 'string',
    },
    schemas: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    scimType: {
      nullable: true,
      type: 'string',
    },
    status: {
      type: 'integer',
    },
  },
  title: 'Scim Error',
  type: 'object',
} as const;

export const search_result_text_matchesSchema = {
  items: {
    properties: {
      fragment: {
        type: 'string',
      },
      matches: {
        items: {
          properties: {
            indices: {
              items: {
                type: 'integer',
              },
              type: 'array',
            },
            text: {
              type: 'string',
            },
          },
          type: 'object',
        },
        type: 'array',
      },
      object_type: {
        nullable: true,
        type: 'string',
      },
      object_url: {
        type: 'string',
      },
      property: {
        type: 'string',
      },
    },
    type: 'object',
  },
  title: 'Search Result Text Matches',
  type: 'array',
} as const;

export const secret_scanning_alertSchema = {
  properties: {
    created_at: {
      $ref: '#/components/schemas/alert-created-at',
    },
    html_url: {
      $ref: '#/components/schemas/alert-html-url',
    },
    locations_url: {
      description: 'The REST API URL of the code locations for this alert.',
      format: 'uri',
      type: 'string',
    },
    number: {
      $ref: '#/components/schemas/alert-number',
    },
    push_protection_bypassed: {
      description: 'Whether push protection was bypassed for the detected secret.',
      nullable: true,
      type: 'boolean',
    },
    push_protection_bypassed_at: {
      description: 'The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    push_protection_bypassed_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    resolution: {
      $ref: '#/components/schemas/secret-scanning-alert-resolution',
    },
    resolution_comment: {
      description: 'An optional comment to resolve an alert.',
      nullable: true,
      type: 'string',
    },
    resolved_at: {
      description: 'The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    resolved_by: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    secret: {
      description: 'The secret that was detected.',
      type: 'string',
    },
    secret_type: {
      description: 'The type of secret that secret scanning detected.',
      type: 'string',
    },
    secret_type_display_name: {
      description: `User-friendly name for the detected secret, matching the \`secret_type\`.
For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."`,
      type: 'string',
    },
    state: {
      $ref: '#/components/schemas/secret-scanning-alert-state',
    },
    updated_at: {
      $ref: '#/components/schemas/nullable-alert-updated-at',
    },
    url: {
      $ref: '#/components/schemas/alert-url',
    },
  },
  type: 'object',
} as const;

export const secret_scanning_alert_resolutionSchema = {
  description: '**Required when the `state` is `resolved`.** The reason for resolving the alert.',
  enum: [null, 'false_positive', 'wont_fix', 'revoked', 'used_in_tests'],
  nullable: true,
  type: 'string',
} as const;

export const secret_scanning_alert_resolution_commentSchema = {
  description:
    'An optional comment when closing an alert. Cannot be updated or deleted. Must be `null` when changing `state` to `open`.',
  nullable: true,
  type: 'string',
} as const;

export const secret_scanning_alert_stateSchema = {
  description:
    'Sets the state of the secret scanning alert. You must provide `resolution` when you set the state to `resolved`.',
  enum: ['open', 'resolved'],
  type: 'string',
} as const;

export const secret_scanning_locationSchema = {
  properties: {
    details: {
      oneOf: [
        {
          $ref: '#/components/schemas/secret-scanning-location-commit',
        },
        {
          $ref: '#/components/schemas/secret-scanning-location-issue-title',
        },
        {
          $ref: '#/components/schemas/secret-scanning-location-issue-body',
        },
        {
          $ref: '#/components/schemas/secret-scanning-location-issue-comment',
        },
      ],
    },
    type: {
      description:
        'The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.',
      enum: ['commit', 'issue_title', 'issue_body', 'issue_comment'],
      example: 'commit',
      type: 'string',
    },
  },
  required: ['type', 'details'],
  type: 'object',
} as const;

export const secret_scanning_location_commitSchema = {
  description:
    "Represents a 'commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository.",
  properties: {
    blob_sha: {
      description: 'SHA-1 hash ID of the associated blob',
      example: 'af5626b4a114abcb82d63db7c8082c3c4756e51b',
      type: 'string',
    },
    blob_url: {
      description: 'The API URL to get the associated blob resource',
      type: 'string',
    },
    commit_sha: {
      description: 'SHA-1 hash ID of the associated commit',
      example: 'af5626b4a114abcb82d63db7c8082c3c4756e51b',
      type: 'string',
    },
    commit_url: {
      description: 'The API URL to get the associated commit resource',
      type: 'string',
    },
    end_column: {
      description: 'The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII',
      type: 'number',
    },
    end_line: {
      description: 'Line number at which the secret ends in the file',
      type: 'number',
    },
    path: {
      description: 'The file path in the repository',
      example: '/example/secrets.txt',
      type: 'string',
    },
    start_column: {
      description:
        'The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII',
      type: 'number',
    },
    start_line: {
      description: 'Line number at which the secret starts in the file',
      type: 'number',
    },
  },
  required: [
    'path',
    'start_line',
    'end_line',
    'start_column',
    'end_column',
    'blob_sha',
    'blob_url',
    'commit_sha',
    'commit_url',
  ],
  type: 'object',
} as const;

export const secret_scanning_location_issue_bodySchema = {
  description:
    "Represents an 'issue_body' secret scanning location type. This location type shows that a secret was detected in the body of an issue.",
  properties: {
    issue_body_url: {
      description: 'The API URL to get the issue where the secret was detected.',
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/1347',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['issue_body_url'],
  type: 'object',
} as const;

export const secret_scanning_location_issue_commentSchema = {
  description:
    "Represents an 'issue_comment' secret scanning location type. This location type shows that a secret was detected in a comment on an issue.",
  properties: {
    issue_comment_url: {
      description: 'The API URL to get the issue comment where the secret was detected.',
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/comments/1081119451',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['issue_comment_url'],
  type: 'object',
} as const;

export const secret_scanning_location_issue_titleSchema = {
  description:
    "Represents an 'issue_title' secret scanning location type. This location type shows that a secret was detected in the title of an issue.",
  properties: {
    issue_title_url: {
      description: 'The API URL to get the issue where the secret was detected.',
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/1347',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['issue_title_url'],
  type: 'object',
} as const;

export const security_and_analysisSchema = {
  nullable: true,
  properties: {
    advanced_security: {
      properties: {
        status: {
          enum: ['enabled', 'disabled'],
          type: 'string',
        },
      },
      type: 'object',
    },
    secret_scanning: {
      properties: {
        status: {
          enum: ['enabled', 'disabled'],
          type: 'string',
        },
      },
      type: 'object',
    },
    secret_scanning_push_protection: {
      properties: {
        status: {
          enum: ['enabled', 'disabled'],
          type: 'string',
        },
      },
      type: 'object',
    },
  },
  type: 'object',
} as const;

export const selected_actionsSchema = {
  properties: {
    github_owned_allowed: {
      description:
        'Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.',
      type: 'boolean',
    },
    patterns_allowed: {
      description: `Specifies a list of string-matching patterns to allow specific action(s) and reusable workflow(s). Wildcards, tags, and SHAs are allowed. For example, \`monalisa/octocat@*\`, \`monalisa/octocat@v2\`, \`monalisa/*\`.

**Note**: The \`patterns_allowed\` setting only applies to public repositories.`,
      items: {
        type: 'string',
      },
      type: 'array',
    },
    verified_allowed: {
      description:
        'Whether actions from GitHub Marketplace verified creators are allowed. Set to `true` to allow all actions by GitHub Marketplace verified creators.',
      type: 'boolean',
    },
  },
  type: 'object',
} as const;

export const selected_actions_urlSchema = {
  description:
    'The API URL to use to get or set the actions and reusable workflows that are allowed to run, when `allowed_actions` is set to `selected`.',
  type: 'string',
} as const;

export const short_blobSchema = {
  description: 'Short Blob',
  properties: {
    sha: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
  },
  required: ['url', 'sha'],
  title: 'Short Blob',
  type: 'object',
} as const;

export const short_branchSchema = {
  description: 'Short Branch',
  properties: {
    commit: {
      properties: {
        sha: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['sha', 'url'],
      type: 'object',
    },
    name: {
      type: 'string',
    },
    protected: {
      type: 'boolean',
    },
    protection: {
      $ref: '#/components/schemas/branch-protection',
    },
    protection_url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['name', 'commit', 'protected'],
  title: 'Short Branch',
  type: 'object',
} as const;

export const simple_check_suiteSchema = {
  description: 'A suite of checks performed on the code of a given code change',
  properties: {
    after: {
      example: 'd6fde92930d4715a2b49857d24b940956b26d2d3',
      nullable: true,
      type: 'string',
    },
    app: {
      $ref: '#/components/schemas/integration',
    },
    before: {
      example: '146e867f55c26428e5f9fade55a9bbf5e95a7912',
      nullable: true,
      type: 'string',
    },
    conclusion: {
      enum: [
        'success',
        'failure',
        'neutral',
        'cancelled',
        'skipped',
        'timed_out',
        'action_required',
        'stale',
        'startup_failure',
      ],
      example: 'neutral',
      nullable: true,
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    head_branch: {
      example: 'master',
      nullable: true,
      type: 'string',
    },
    head_sha: {
      description: 'The SHA of the head commit that is being checked.',
      example: '009b8a3a9ccbb128af87f9b1c0f4c62e8a304f6d',
      type: 'string',
    },
    id: {
      example: 5,
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOkNoZWNrU3VpdGU1',
      type: 'string',
    },
    pull_requests: {
      items: {
        $ref: '#/components/schemas/pull-request-minimal',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    status: {
      enum: ['queued', 'in_progress', 'completed', 'pending', 'waiting'],
      example: 'completed',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/github/hello-world/check-suites/5',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const simple_commitSchema = {
  description: 'A commit.',
  properties: {
    author: {
      nullable: true,
      properties: {
        email: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
      },
      required: ['name', 'email'],
      type: 'object',
    },
    committer: {
      nullable: true,
      properties: {
        email: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
      },
      required: ['name', 'email'],
      type: 'object',
    },
    id: {
      type: 'string',
    },
    message: {
      type: 'string',
    },
    timestamp: {
      format: 'date-time',
      type: 'string',
    },
    tree_id: {
      type: 'string',
    },
  },
  required: ['id', 'tree_id', 'message', 'timestamp', 'author', 'committer'],
  title: 'Simple Commit',
  type: 'object',
} as const;

export const simple_commit_statusSchema = {
  properties: {
    avatar_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    context: {
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    description: {
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    required: {
      nullable: true,
      type: 'boolean',
    },
    state: {
      type: 'string',
    },
    target_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'description',
    'id',
    'node_id',
    'state',
    'context',
    'target_url',
    'avatar_url',
    'url',
    'created_at',
    'updated_at',
  ],
  title: 'Simple Commit Status',
  type: 'object',
} as const;

export const simple_installationSchema = {
  description:
    'The GitHub App installation. This property is included when the event is configured for and sent to a GitHub App.',
  properties: {
    id: {
      description: 'The ID of the installation.',
      example: 1,
      type: 'integer',
    },
    node_id: {
      description: 'The global node ID of the installation.',
      example: 'MDQ6VXNlcjU4MzIzMQ==',
      type: 'string',
    },
  },
  required: ['id', 'node_id'],
  title: 'Simple Installation',
  type: 'object',
} as const;

export const simple_repositorySchema = {
  description: 'A GitHub repository.',
  properties: {
    archive_url: {
      description: 'A template for the API URL to download the repository as an archive.',
      example: 'https://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}',
      type: 'string',
    },
    assignees_url: {
      description: 'A template for the API URL to list the available assignees for issues in the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/assignees{/user}',
      type: 'string',
    },
    blobs_url: {
      description: 'A template for the API URL to create or retrieve a raw Git blob in the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}',
      type: 'string',
    },
    branches_url: {
      description: 'A template for the API URL to get information about branches in the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/branches{/branch}',
      type: 'string',
    },
    collaborators_url: {
      description: 'A template for the API URL to get information about collaborators of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}',
      type: 'string',
    },
    comments_url: {
      description: 'A template for the API URL to get information about comments on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/comments{/number}',
      type: 'string',
    },
    commits_url: {
      description: 'A template for the API URL to get information about commits on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/commits{/sha}',
      type: 'string',
    },
    compare_url: {
      description: 'A template for the API URL to compare two commits or refs.',
      example: 'https://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}',
      type: 'string',
    },
    contents_url: {
      description: 'A template for the API URL to get the contents of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/contents/{+path}',
      type: 'string',
    },
    contributors_url: {
      description: 'A template for the API URL to list the contributors to the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/contributors',
      format: 'uri',
      type: 'string',
    },
    deployments_url: {
      description: 'The API URL to list the deployments of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/deployments',
      format: 'uri',
      type: 'string',
    },
    description: {
      description: 'The repository description.',
      example: 'This your first repo!',
      nullable: true,
      type: 'string',
    },
    downloads_url: {
      description: 'The API URL to list the downloads on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/downloads',
      format: 'uri',
      type: 'string',
    },
    events_url: {
      description: 'The API URL to list the events of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/events',
      format: 'uri',
      type: 'string',
    },
    fork: {
      description: 'Whether the repository is a fork.',
      type: 'boolean',
    },
    forks_url: {
      description: 'The API URL to list the forks of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/forks',
      format: 'uri',
      type: 'string',
    },
    full_name: {
      description: 'The full, globally unique, name of the repository.',
      example: 'octocat/Hello-World',
      type: 'string',
    },
    git_commits_url: {
      description: 'A template for the API URL to get information about Git commits of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/git/commits{/sha}',
      type: 'string',
    },
    git_refs_url: {
      description: 'A template for the API URL to get information about Git refs of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/git/refs{/sha}',
      type: 'string',
    },
    git_tags_url: {
      description: 'A template for the API URL to get information about Git tags of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/git/tags{/sha}',
      type: 'string',
    },
    hooks_url: {
      description: 'The API URL to list the hooks on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/hooks',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      description: 'The URL to view the repository on GitHub.com.',
      example: 'https://github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'A unique identifier of the repository.',
      example: 1296269,
      type: 'integer',
    },
    issue_comment_url: {
      description: 'A template for the API URL to get information about issue comments on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/comments{/number}',
      type: 'string',
    },
    issue_events_url: {
      description: 'A template for the API URL to get information about issue events on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/issues/events{/number}',
      type: 'string',
    },
    issues_url: {
      description: 'A template for the API URL to get information about issues on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/issues{/number}',
      type: 'string',
    },
    keys_url: {
      description: 'A template for the API URL to get information about deploy keys on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/keys{/key_id}',
      type: 'string',
    },
    labels_url: {
      description: 'A template for the API URL to get information about labels of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/labels{/name}',
      type: 'string',
    },
    languages_url: {
      description: 'The API URL to get information about the languages of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/languages',
      format: 'uri',
      type: 'string',
    },
    merges_url: {
      description: 'The API URL to merge branches in the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/merges',
      format: 'uri',
      type: 'string',
    },
    milestones_url: {
      description: 'A template for the API URL to get information about milestones of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/milestones{/number}',
      type: 'string',
    },
    name: {
      description: 'The name of the repository.',
      example: 'Hello-World',
      type: 'string',
    },
    node_id: {
      description: 'The GraphQL identifier of the repository.',
      example: 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5',
      type: 'string',
    },
    notifications_url: {
      description: 'A template for the API URL to get information about notifications on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}',
      type: 'string',
    },
    owner: {
      $ref: '#/components/schemas/simple-user',
    },
    private: {
      description: 'Whether the repository is private.',
      type: 'boolean',
    },
    pulls_url: {
      description: 'A template for the API URL to get information about pull requests on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls{/number}',
      type: 'string',
    },
    releases_url: {
      description: 'A template for the API URL to get information about releases on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/releases{/id}',
      type: 'string',
    },
    stargazers_url: {
      description: 'The API URL to list the stargazers on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/stargazers',
      format: 'uri',
      type: 'string',
    },
    statuses_url: {
      description: 'A template for the API URL to get information about statuses of a commit.',
      example: 'https://api.github.com/repos/octocat/Hello-World/statuses/{sha}',
      type: 'string',
    },
    subscribers_url: {
      description: 'The API URL to list the subscribers on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/subscribers',
      format: 'uri',
      type: 'string',
    },
    subscription_url: {
      description: 'The API URL to subscribe to notifications for this repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/subscription',
      format: 'uri',
      type: 'string',
    },
    tags_url: {
      description: 'The API URL to get information about tags on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/tags',
      format: 'uri',
      type: 'string',
    },
    teams_url: {
      description: 'The API URL to list the teams on the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/teams',
      format: 'uri',
      type: 'string',
    },
    trees_url: {
      description: 'A template for the API URL to create or retrieve a raw Git tree of the repository.',
      example: 'https://api.github.com/repos/octocat/Hello-World/git/trees{/sha}',
      type: 'string',
    },
    url: {
      description: 'The URL to get more information about the repository from the GitHub API.',
      example: 'https://api.github.com/repos/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'archive_url',
    'assignees_url',
    'blobs_url',
    'branches_url',
    'collaborators_url',
    'comments_url',
    'commits_url',
    'compare_url',
    'contents_url',
    'contributors_url',
    'deployments_url',
    'description',
    'downloads_url',
    'events_url',
    'fork',
    'forks_url',
    'full_name',
    'git_commits_url',
    'git_refs_url',
    'git_tags_url',
    'hooks_url',
    'html_url',
    'id',
    'node_id',
    'issue_comment_url',
    'issue_events_url',
    'issues_url',
    'keys_url',
    'labels_url',
    'languages_url',
    'merges_url',
    'milestones_url',
    'name',
    'notifications_url',
    'owner',
    'private',
    'pulls_url',
    'releases_url',
    'stargazers_url',
    'statuses_url',
    'subscribers_url',
    'subscription_url',
    'tags_url',
    'teams_url',
    'trees_url',
    'url',
  ],
  title: 'Simple Repository',
  type: 'object',
} as const;

export const simple_userSchema = {
  description: 'A GitHub user.',
  properties: {
    avatar_url: {
      example: 'https://github.com/images/error/octocat_happy.gif',
      format: 'uri',
      type: 'string',
    },
    email: {
      nullable: true,
      type: 'string',
    },
    events_url: {
      example: 'https://api.github.com/users/octocat/events{/privacy}',
      type: 'string',
    },
    followers_url: {
      example: 'https://api.github.com/users/octocat/followers',
      format: 'uri',
      type: 'string',
    },
    following_url: {
      example: 'https://api.github.com/users/octocat/following{/other_user}',
      type: 'string',
    },
    gists_url: {
      example: 'https://api.github.com/users/octocat/gists{/gist_id}',
      type: 'string',
    },
    gravatar_id: {
      example: '41d064eb2195891e12d0413f63227ea7',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    login: {
      example: 'octocat',
      type: 'string',
    },
    name: {
      nullable: true,
      type: 'string',
    },
    node_id: {
      example: 'MDQ6VXNlcjE=',
      type: 'string',
    },
    organizations_url: {
      example: 'https://api.github.com/users/octocat/orgs',
      format: 'uri',
      type: 'string',
    },
    received_events_url: {
      example: 'https://api.github.com/users/octocat/received_events',
      format: 'uri',
      type: 'string',
    },
    repos_url: {
      example: 'https://api.github.com/users/octocat/repos',
      format: 'uri',
      type: 'string',
    },
    site_admin: {
      type: 'boolean',
    },
    starred_at: {
      example: '"2020-07-09T00:17:55Z"',
      type: 'string',
    },
    starred_url: {
      example: 'https://api.github.com/users/octocat/starred{/owner}{/repo}',
      type: 'string',
    },
    subscriptions_url: {
      example: 'https://api.github.com/users/octocat/subscriptions',
      format: 'uri',
      type: 'string',
    },
    type: {
      example: 'User',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/users/octocat',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'avatar_url',
    'events_url',
    'followers_url',
    'following_url',
    'gists_url',
    'gravatar_id',
    'html_url',
    'id',
    'node_id',
    'login',
    'organizations_url',
    'received_events_url',
    'repos_url',
    'site_admin',
    'starred_url',
    'subscriptions_url',
    'type',
    'url',
  ],
  title: 'Simple User',
  type: 'object',
} as const;

export const snapshotSchema = {
  additionalProperties: false,
  description: "Create a new snapshot of a repository's dependencies.",
  properties: {
    detector: {
      additionalProperties: false,
      description: 'A description of the detector used.',
      properties: {
        name: {
          description: 'The name of the detector used.',
          example: 'docker buildtime detector',
          type: 'string',
        },
        url: {
          description: 'The url of the detector used.',
          example: 'http://example.com/docker-buildtimer-detector',
          type: 'string',
        },
        version: {
          description: 'The version of the detector used.',
          example: '1.0.0',
          type: 'string',
        },
      },
      required: ['name', 'version', 'url'],
      type: 'object',
    },
    job: {
      additionalProperties: false,
      properties: {
        correlator: {
          description: `Correlator provides a key that is used to group snapshots submitted over time. Only the "latest" submitted snapshot for a given combination of \`job.correlator\` and \`detector.name\` will be considered when calculating a repository's current dependencies. Correlator should be as unique as it takes to distinguish all detection runs for a given "wave" of CI workflow you run. If you're using GitHub Actions, a good default value for this could be the environment variables GITHUB_WORKFLOW and GITHUB_JOB concatenated together. If you're using a build matrix, then you'll also need to add additional key(s) to distinguish between each submission inside a matrix variation.`,
          example: 'yourworkflowname_yourjobname',
          type: 'string',
        },
        html_url: {
          description: 'The url for the job.',
          example: 'http://example.com/build',
          type: 'string',
        },
        id: {
          description: 'The external ID of the job.',
          example: '5622a2b0-63f6-4732-8c34-a1ab27e102a11',
          type: 'string',
        },
      },
      required: ['id', 'correlator'],
      type: 'object',
    },
    manifests: {
      additionalProperties: {
        $ref: '#/components/schemas/manifest',
      },
      description:
        'A collection of package manifests, which are a collection of related dependencies declared in a file or representing a logical group of dependencies.',
      type: 'object',
    },
    metadata: {
      $ref: '#/components/schemas/metadata',
    },
    ref: {
      description: 'The repository branch that triggered this snapshot.',
      example: 'refs/heads/main',
      pattern: '^refs/',
      type: 'string',
    },
    scanned: {
      description: 'The time at which the snapshot was scanned.',
      example: '2020-06-13T14:52:50-05:00',
      format: 'date-time',
      type: 'string',
    },
    sha: {
      description: 'The commit SHA associated with this dependency snapshot. Maximum length: 40 characters.',
      example: 'ddc951f4b1293222421f2c8df679786153acf689',
      maxLength: 40,
      minLength: 40,
      type: 'string',
    },
    version: {
      description: 'The version of the repository snapshot submission.',
      type: 'integer',
    },
  },
  required: ['detector', 'version', 'ref', 'sha', 'job', 'scanned'],
  title: 'snapshot',
  type: 'object',
} as const;

export const ssh_signing_keySchema = {
  description: 'A public SSH key used to sign Git commits',
  properties: {
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    key: {
      type: 'string',
    },
    title: {
      type: 'string',
    },
  },
  required: ['key', 'id', 'title', 'created_at'],
  title: 'SSH Signing Key',
  type: 'object',
} as const;

export const stargazerSchema = {
  description: 'Stargazer',
  properties: {
    starred_at: {
      format: 'date-time',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
  },
  required: ['starred_at', 'user'],
  title: 'Stargazer',
  type: 'object',
} as const;

export const starred_repositorySchema = {
  description: 'Starred Repository',
  properties: {
    repo: {
      $ref: '#/components/schemas/repository',
    },
    starred_at: {
      format: 'date-time',
      type: 'string',
    },
  },
  required: ['starred_at', 'repo'],
  title: 'Starred Repository',
  type: 'object',
} as const;

export const state_change_issue_eventSchema = {
  description: 'State Change Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    state_reason: {
      nullable: true,
      type: 'string',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'State Change Issue Event',
  type: 'object',
} as const;

export const statusSchema = {
  description: 'The status of a commit.',
  properties: {
    avatar_url: {
      nullable: true,
      type: 'string',
    },
    context: {
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    description: {
      nullable: true,
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    state: {
      type: 'string',
    },
    target_url: {
      nullable: true,
      type: 'string',
    },
    updated_at: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'url',
    'avatar_url',
    'id',
    'node_id',
    'state',
    'description',
    'target_url',
    'context',
    'created_at',
    'updated_at',
    'creator',
  ],
  title: 'Status',
  type: 'object',
} as const;

export const status_check_policySchema = {
  description: 'Status Check Policy',
  properties: {
    checks: {
      items: {
        properties: {
          app_id: {
            nullable: true,
            type: 'integer',
          },
          context: {
            example: 'continuous-integration/travis-ci',
            type: 'string',
          },
        },
        required: ['context', 'app_id'],
        type: 'object',
      },
      type: 'array',
    },
    contexts: {
      example: ['continuous-integration/travis-ci'],
      items: {
        type: 'string',
      },
      type: 'array',
    },
    contexts_url: {
      example:
        'https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_status_checks/contexts',
      format: 'uri',
      type: 'string',
    },
    strict: {
      example: true,
      type: 'boolean',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/branches/master/protection/required_status_checks',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['url', 'contexts_url', 'strict', 'contexts', 'checks'],
  title: 'Status Check Policy',
  type: 'object',
} as const;

export const tagSchema = {
  description: 'Tag',
  properties: {
    commit: {
      properties: {
        sha: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['sha', 'url'],
      type: 'object',
    },
    name: {
      example: 'v0.1',
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    tarball_url: {
      example: 'https://github.com/octocat/Hello-World/tarball/v0.1',
      format: 'uri',
      type: 'string',
    },
    zipball_url: {
      example: 'https://github.com/octocat/Hello-World/zipball/v0.1',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['name', 'node_id', 'commit', 'zipball_url', 'tarball_url'],
  title: 'Tag',
  type: 'object',
} as const;

export const tag_protectionSchema = {
  description: 'Tag protection',
  properties: {
    created_at: {
      example: '2011-01-26T19:01:12Z',
      type: 'string',
    },
    enabled: {
      example: true,
      type: 'boolean',
    },
    id: {
      example: 2,
      type: 'integer',
    },
    pattern: {
      example: 'v1.*',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:01:12Z',
      type: 'string',
    },
  },
  required: ['pattern'],
  title: 'Tag protection',
  type: 'object',
} as const;

export const teamSchema = {
  description: 'Groups of organization members that gives permissions on specified repositories.',
  properties: {
    description: {
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/orgs/rails/teams/core',
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    members_url: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    parent: {
      $ref: '#/components/schemas/nullable-team-simple',
    },
    permission: {
      type: 'string',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      required: ['pull', 'triage', 'push', 'maintain', 'admin'],
      type: 'object',
    },
    privacy: {
      type: 'string',
    },
    repositories_url: {
      format: 'uri',
      type: 'string',
    },
    slug: {
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'members_url',
    'name',
    'description',
    'permission',
    'html_url',
    'repositories_url',
    'slug',
    'parent',
  ],
  title: 'Team',
  type: 'object',
} as const;

export const team_discussionSchema = {
  description: 'A team discussion is a persistent record of a free-form conversation within a team.',
  properties: {
    author: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    body: {
      description: 'The main text of the discussion.',
      example: 'Please suggest improvements to our workflow in comments.',
      type: 'string',
    },
    body_html: {
      example: '<p>Hi! This is an area for us to collaborate as a team</p>',
      type: 'string',
    },
    body_version: {
      description:
        'The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.',
      example: '0307116bbf7ced493b8d8a346c650b71',
      type: 'string',
    },
    comments_count: {
      example: 0,
      type: 'integer',
    },
    comments_url: {
      example: 'https://api.github.com/organizations/1/team/2343027/discussions/1/comments',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2018-01-25T18:56:31Z',
      format: 'date-time',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/orgs/github/teams/justice-league/discussions/1',
      format: 'uri',
      type: 'string',
    },
    last_edited_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    node_id: {
      example: 'MDE0OlRlYW1EaXNjdXNzaW9uMQ==',
      type: 'string',
    },
    number: {
      description: 'The unique sequence number of a team discussion.',
      example: 42,
      type: 'integer',
    },
    pinned: {
      description: 'Whether or not this discussion should be pinned for easy retrieval.',
      example: true,
      type: 'boolean',
    },
    private: {
      description:
        'Whether or not this discussion should be restricted to team members and organization administrators.',
      example: true,
      type: 'boolean',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    team_url: {
      example: 'https://api.github.com/organizations/1/team/2343027',
      format: 'uri',
      type: 'string',
    },
    title: {
      description: 'The title of the discussion.',
      example: 'How can we improve our workflow?',
      type: 'string',
    },
    updated_at: {
      example: '2018-01-25T18:56:31Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/organizations/1/team/2343027/discussions/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'author',
    'body',
    'body_html',
    'body_version',
    'comments_count',
    'comments_url',
    'created_at',
    'last_edited_at',
    'html_url',
    'pinned',
    'private',
    'node_id',
    'number',
    'team_url',
    'title',
    'updated_at',
    'url',
  ],
  title: 'Team Discussion',
  type: 'object',
} as const;

export const team_discussion_commentSchema = {
  description: 'A reply to a discussion within a team.',
  properties: {
    author: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    body: {
      description: 'The main text of the comment.',
      example: 'I agree with this suggestion.',
      type: 'string',
    },
    body_html: {
      example: '<p>Do you like apples?</p>',
      type: 'string',
    },
    body_version: {
      description:
        'The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.',
      example: '0307116bbf7ced493b8d8a346c650b71',
      type: 'string',
    },
    created_at: {
      example: '2018-01-15T23:53:58Z',
      format: 'date-time',
      type: 'string',
    },
    discussion_url: {
      example: 'https://api.github.com/organizations/1/team/2403582/discussions/1',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/orgs/github/teams/justice-league/discussions/1/comments/1',
      format: 'uri',
      type: 'string',
    },
    last_edited_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    node_id: {
      example: 'MDIxOlRlYW1EaXNjdXNzaW9uQ29tbWVudDE=',
      type: 'string',
    },
    number: {
      description: 'The unique sequence number of a team discussion comment.',
      example: 42,
      type: 'integer',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    updated_at: {
      example: '2018-01-15T23:53:58Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/organizations/1/team/2403582/discussions/1/comments/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'author',
    'body',
    'body_html',
    'body_version',
    'created_at',
    'last_edited_at',
    'discussion_url',
    'html_url',
    'node_id',
    'number',
    'updated_at',
    'url',
  ],
  title: 'Team Discussion Comment',
  type: 'object',
} as const;

export const team_fullSchema = {
  description: 'Groups of organization members that gives permissions on specified repositories.',
  properties: {
    created_at: {
      example: '2017-07-14T16:53:42Z',
      format: 'date-time',
      type: 'string',
    },
    description: {
      example: 'A great team.',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/orgs/rails/teams/core',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the team',
      example: 42,
      type: 'integer',
    },
    ldap_dn: {
      description: 'Distinguished Name (DN) that team maps to within LDAP environment',
      example: 'uid=example,ou=users,dc=github,dc=com',
      type: 'string',
    },
    members_count: {
      example: 3,
      type: 'integer',
    },
    members_url: {
      example: 'https://api.github.com/organizations/1/team/1/members{/member}',
      type: 'string',
    },
    name: {
      description: 'Name of the team',
      example: 'Developers',
      type: 'string',
    },
    node_id: {
      example: 'MDQ6VGVhbTE=',
      type: 'string',
    },
    organization: {
      $ref: '#/components/schemas/team-organization',
    },
    parent: {
      $ref: '#/components/schemas/nullable-team-simple',
    },
    permission: {
      description: 'Permission that the team will have for its repositories',
      example: 'push',
      type: 'string',
    },
    privacy: {
      description: 'The level of privacy this team should have',
      enum: ['closed', 'secret'],
      example: 'closed',
      type: 'string',
    },
    repos_count: {
      example: 10,
      type: 'integer',
    },
    repositories_url: {
      example: 'https://api.github.com/organizations/1/team/1/repos',
      format: 'uri',
      type: 'string',
    },
    slug: {
      example: 'justice-league',
      type: 'string',
    },
    updated_at: {
      example: '2017-08-17T12:37:15Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      description: 'URL for the team',
      example: 'https://api.github.com/organizations/1/team/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'members_url',
    'name',
    'description',
    'permission',
    'html_url',
    'repositories_url',
    'slug',
    'created_at',
    'updated_at',
    'members_count',
    'repos_count',
    'organization',
  ],
  title: 'Full Team',
  type: 'object',
} as const;

export const team_membershipSchema = {
  description: 'Team Membership',
  properties: {
    role: {
      default: 'member',
      description: 'The role of the user in the team.',
      enum: ['member', 'maintainer'],
      example: 'member',
      type: 'string',
    },
    state: {
      description: "The state of the user's membership in the team.",
      enum: ['active', 'pending'],
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: ['role', 'state', 'url'],
  title: 'Team Membership',
  type: 'object',
} as const;

export const team_organizationSchema = {
  description: 'Team Organization',
  properties: {
    avatar_url: {
      example: 'https://github.com/images/error/octocat_happy.gif',
      type: 'string',
    },
    billing_email: {
      example: 'org@example.com',
      format: 'email',
      nullable: true,
      type: 'string',
    },
    blog: {
      example: 'https://github.com/blog',
      format: 'uri',
      type: 'string',
    },
    collaborators: {
      example: 8,
      nullable: true,
      type: 'integer',
    },
    company: {
      example: 'GitHub',
      type: 'string',
    },
    created_at: {
      example: '2008-01-14T04:33:35Z',
      format: 'date-time',
      type: 'string',
    },
    default_repository_permission: {
      nullable: true,
      type: 'string',
    },
    description: {
      example: 'A great organization',
      nullable: true,
      type: 'string',
    },
    disk_usage: {
      example: 10000,
      nullable: true,
      type: 'integer',
    },
    email: {
      example: 'octocat@github.com',
      format: 'email',
      type: 'string',
    },
    events_url: {
      example: 'https://api.github.com/orgs/github/events',
      format: 'uri',
      type: 'string',
    },
    followers: {
      example: 20,
      type: 'integer',
    },
    following: {
      example: 0,
      type: 'integer',
    },
    has_organization_projects: {
      example: true,
      type: 'boolean',
    },
    has_repository_projects: {
      example: true,
      type: 'boolean',
    },
    hooks_url: {
      example: 'https://api.github.com/orgs/github/hooks',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat',
      format: 'uri',
      type: 'string',
    },
    id: {
      example: 1,
      type: 'integer',
    },
    is_verified: {
      example: true,
      type: 'boolean',
    },
    issues_url: {
      example: 'https://api.github.com/orgs/github/issues',
      type: 'string',
    },
    location: {
      example: 'San Francisco',
      type: 'string',
    },
    login: {
      example: 'github',
      type: 'string',
    },
    members_allowed_repository_creation_type: {
      example: 'all',
      type: 'string',
    },
    members_can_create_internal_repositories: {
      example: true,
      type: 'boolean',
    },
    members_can_create_pages: {
      example: true,
      type: 'boolean',
    },
    members_can_create_private_pages: {
      example: true,
      type: 'boolean',
    },
    members_can_create_private_repositories: {
      example: true,
      type: 'boolean',
    },
    members_can_create_public_pages: {
      example: true,
      type: 'boolean',
    },
    members_can_create_public_repositories: {
      example: true,
      type: 'boolean',
    },
    members_can_create_repositories: {
      example: true,
      nullable: true,
      type: 'boolean',
    },
    members_can_fork_private_repositories: {
      example: false,
      nullable: true,
      type: 'boolean',
    },
    members_url: {
      example: 'https://api.github.com/orgs/github/members{/member}',
      type: 'string',
    },
    name: {
      example: 'github',
      type: 'string',
    },
    node_id: {
      example: 'MDEyOk9yZ2FuaXphdGlvbjE=',
      type: 'string',
    },
    owned_private_repos: {
      example: 100,
      type: 'integer',
    },
    plan: {
      properties: {
        filled_seats: {
          type: 'integer',
        },
        name: {
          type: 'string',
        },
        private_repos: {
          type: 'integer',
        },
        seats: {
          type: 'integer',
        },
        space: {
          type: 'integer',
        },
      },
      required: ['name', 'space', 'private_repos'],
      type: 'object',
    },
    private_gists: {
      example: 81,
      nullable: true,
      type: 'integer',
    },
    public_gists: {
      example: 1,
      type: 'integer',
    },
    public_members_url: {
      example: 'https://api.github.com/orgs/github/public_members{/member}',
      type: 'string',
    },
    public_repos: {
      example: 2,
      type: 'integer',
    },
    repos_url: {
      example: 'https://api.github.com/orgs/github/repos',
      format: 'uri',
      type: 'string',
    },
    total_private_repos: {
      example: 100,
      type: 'integer',
    },
    twitter_username: {
      example: 'github',
      nullable: true,
      type: 'string',
    },
    two_factor_requirement_enabled: {
      example: true,
      nullable: true,
      type: 'boolean',
    },
    type: {
      example: 'Organization',
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/orgs/github',
      format: 'uri',
      type: 'string',
    },
    web_commit_signoff_required: {
      example: false,
      type: 'boolean',
    },
  },
  required: [
    'login',
    'url',
    'id',
    'node_id',
    'repos_url',
    'events_url',
    'hooks_url',
    'issues_url',
    'members_url',
    'public_members_url',
    'avatar_url',
    'description',
    'html_url',
    'has_organization_projects',
    'has_repository_projects',
    'public_repos',
    'public_gists',
    'followers',
    'following',
    'type',
    'created_at',
    'updated_at',
  ],
  title: 'Team Organization',
  type: 'object',
} as const;

export const team_projectSchema = {
  description: "A team's access to a project.",
  properties: {
    body: {
      nullable: true,
      type: 'string',
    },
    columns_url: {
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    creator: {
      $ref: '#/components/schemas/simple-user',
    },
    html_url: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    name: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    number: {
      type: 'integer',
    },
    organization_permission: {
      description: 'The organization permission for this project. Only present when owner is an organization.',
      type: 'string',
    },
    owner_url: {
      type: 'string',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        read: {
          type: 'boolean',
        },
        write: {
          type: 'boolean',
        },
      },
      required: ['read', 'write', 'admin'],
      type: 'object',
    },
    private: {
      description: 'Whether the project is private or not. Only present when owner is an organization.',
      type: 'boolean',
    },
    state: {
      type: 'string',
    },
    updated_at: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'owner_url',
    'url',
    'html_url',
    'columns_url',
    'id',
    'node_id',
    'name',
    'body',
    'number',
    'state',
    'creator',
    'created_at',
    'updated_at',
    'permissions',
  ],
  title: 'Team Project',
  type: 'object',
} as const;

export const team_repositorySchema = {
  description: "A team's access to a repository.",
  properties: {
    allow_auto_merge: {
      default: false,
      description: 'Whether to allow Auto-merge to be used on pull requests.',
      example: false,
      type: 'boolean',
    },
    allow_forking: {
      default: false,
      description: 'Whether to allow forking this repo',
      example: false,
      type: 'boolean',
    },
    allow_merge_commit: {
      default: true,
      description: 'Whether to allow merge commits for pull requests.',
      example: true,
      type: 'boolean',
    },
    allow_rebase_merge: {
      default: true,
      description: 'Whether to allow rebase merges for pull requests.',
      example: true,
      type: 'boolean',
    },
    allow_squash_merge: {
      default: true,
      description: 'Whether to allow squash merges for pull requests.',
      example: true,
      type: 'boolean',
    },
    archive_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/{archive_format}{/ref}',
      type: 'string',
    },
    archived: {
      default: false,
      description: 'Whether the repository is archived.',
      type: 'boolean',
    },
    assignees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/assignees{/user}',
      type: 'string',
    },
    blobs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/blobs{/sha}',
      type: 'string',
    },
    branches_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/branches{/branch}',
      type: 'string',
    },
    clone_url: {
      example: 'https://github.com/octocat/Hello-World.git',
      type: 'string',
    },
    collaborators_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/collaborators{/collaborator}',
      type: 'string',
    },
    comments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/comments{/number}',
      type: 'string',
    },
    commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/commits{/sha}',
      type: 'string',
    },
    compare_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/compare/{base}...{head}',
      type: 'string',
    },
    contents_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contents/{+path}',
      type: 'string',
    },
    contributors_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/contributors',
      format: 'uri',
      type: 'string',
    },
    created_at: {
      example: '2011-01-26T19:01:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    default_branch: {
      description: 'The default branch of the repository.',
      example: 'master',
      type: 'string',
    },
    delete_branch_on_merge: {
      default: false,
      description: 'Whether to delete head branches when pull requests are merged',
      example: false,
      type: 'boolean',
    },
    deployments_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/deployments',
      format: 'uri',
      type: 'string',
    },
    description: {
      example: 'This your first repo!',
      nullable: true,
      type: 'string',
    },
    disabled: {
      description: 'Returns whether or not this repository disabled.',
      type: 'boolean',
    },
    downloads_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/downloads',
      format: 'uri',
      type: 'string',
    },
    events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/events',
      format: 'uri',
      type: 'string',
    },
    fork: {
      type: 'boolean',
    },
    forks: {
      type: 'integer',
    },
    forks_count: {
      example: 9,
      type: 'integer',
    },
    forks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/forks',
      format: 'uri',
      type: 'string',
    },
    full_name: {
      example: 'octocat/Hello-World',
      type: 'string',
    },
    git_commits_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/commits{/sha}',
      type: 'string',
    },
    git_refs_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/refs{/sha}',
      type: 'string',
    },
    git_tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/tags{/sha}',
      type: 'string',
    },
    git_url: {
      example: 'git:github.com/octocat/Hello-World.git',
      type: 'string',
    },
    has_downloads: {
      default: true,
      description: 'Whether downloads are enabled.',
      example: true,
      type: 'boolean',
    },
    has_issues: {
      default: true,
      description: 'Whether issues are enabled.',
      example: true,
      type: 'boolean',
    },
    has_pages: {
      type: 'boolean',
    },
    has_projects: {
      default: true,
      description: 'Whether projects are enabled.',
      example: true,
      type: 'boolean',
    },
    has_wiki: {
      default: true,
      description: 'Whether the wiki is enabled.',
      example: true,
      type: 'boolean',
    },
    homepage: {
      example: 'https://github.com',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    hooks_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/hooks',
      format: 'uri',
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the repository',
      example: 42,
      type: 'integer',
    },
    is_template: {
      default: false,
      description: 'Whether this repository acts as a template that can be used to generate new repositories.',
      example: true,
      type: 'boolean',
    },
    issue_comment_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/comments{/number}',
      type: 'string',
    },
    issue_events_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues/events{/number}',
      type: 'string',
    },
    issues_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/issues{/number}',
      type: 'string',
    },
    keys_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/keys{/key_id}',
      type: 'string',
    },
    labels_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/labels{/name}',
      type: 'string',
    },
    language: {
      nullable: true,
      type: 'string',
    },
    languages_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/languages',
      format: 'uri',
      type: 'string',
    },
    license: {
      $ref: '#/components/schemas/nullable-license-simple',
    },
    master_branch: {
      type: 'string',
    },
    merges_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/merges',
      format: 'uri',
      type: 'string',
    },
    milestones_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/milestones{/number}',
      type: 'string',
    },
    mirror_url: {
      example: 'git:git.example.com/octocat/Hello-World',
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      description: 'The name of the repository.',
      example: 'Team Environment',
      type: 'string',
    },
    network_count: {
      type: 'integer',
    },
    node_id: {
      example: 'MDEwOlJlcG9zaXRvcnkxMjk2MjY5',
      type: 'string',
    },
    notifications_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/notifications{?since,all,participating}',
      type: 'string',
    },
    open_issues: {
      type: 'integer',
    },
    open_issues_count: {
      example: 0,
      type: 'integer',
    },
    owner: {
      $ref: '#/components/schemas/nullable-simple-user',
    },
    permissions: {
      properties: {
        admin: {
          type: 'boolean',
        },
        maintain: {
          type: 'boolean',
        },
        pull: {
          type: 'boolean',
        },
        push: {
          type: 'boolean',
        },
        triage: {
          type: 'boolean',
        },
      },
      required: ['admin', 'pull', 'push'],
      type: 'object',
    },
    private: {
      default: false,
      description: 'Whether the repository is private or public.',
      type: 'boolean',
    },
    pulls_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/pulls{/number}',
      type: 'string',
    },
    pushed_at: {
      example: '2011-01-26T19:06:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    releases_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/releases{/id}',
      type: 'string',
    },
    role_name: {
      example: 'admin',
      type: 'string',
    },
    size: {
      example: 108,
      type: 'integer',
    },
    ssh_url: {
      example: 'git@github.com:octocat/Hello-World.git',
      type: 'string',
    },
    stargazers_count: {
      example: 80,
      type: 'integer',
    },
    stargazers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/stargazers',
      format: 'uri',
      type: 'string',
    },
    statuses_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/statuses/{sha}',
      type: 'string',
    },
    subscribers_count: {
      type: 'integer',
    },
    subscribers_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscribers',
      format: 'uri',
      type: 'string',
    },
    subscription_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/subscription',
      format: 'uri',
      type: 'string',
    },
    svn_url: {
      example: 'https://svn.github.com/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    tags_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/tags',
      format: 'uri',
      type: 'string',
    },
    teams_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/teams',
      format: 'uri',
      type: 'string',
    },
    temp_clone_token: {
      type: 'string',
    },
    template_repository: {
      $ref: '#/components/schemas/nullable-repository',
    },
    topics: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    trees_url: {
      example: 'http://api.github.com/repos/octocat/Hello-World/git/trees{/sha}',
      type: 'string',
    },
    updated_at: {
      example: '2011-01-26T19:14:43Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/repos/octocat/Hello-World',
      format: 'uri',
      type: 'string',
    },
    visibility: {
      default: 'public',
      description: 'The repository visibility: public, private, or internal.',
      type: 'string',
    },
    watchers: {
      type: 'integer',
    },
    watchers_count: {
      example: 80,
      type: 'integer',
    },
    web_commit_signoff_required: {
      default: false,
      description: 'Whether to require contributors to sign off on web-based commits',
      example: false,
      type: 'boolean',
    },
  },
  required: [
    'archive_url',
    'assignees_url',
    'blobs_url',
    'branches_url',
    'collaborators_url',
    'comments_url',
    'commits_url',
    'compare_url',
    'contents_url',
    'contributors_url',
    'deployments_url',
    'description',
    'downloads_url',
    'events_url',
    'fork',
    'forks_url',
    'full_name',
    'git_commits_url',
    'git_refs_url',
    'git_tags_url',
    'hooks_url',
    'html_url',
    'id',
    'node_id',
    'issue_comment_url',
    'issue_events_url',
    'issues_url',
    'keys_url',
    'labels_url',
    'languages_url',
    'merges_url',
    'milestones_url',
    'name',
    'notifications_url',
    'owner',
    'private',
    'pulls_url',
    'releases_url',
    'stargazers_url',
    'statuses_url',
    'subscribers_url',
    'subscription_url',
    'tags_url',
    'teams_url',
    'trees_url',
    'url',
    'clone_url',
    'default_branch',
    'forks',
    'forks_count',
    'git_url',
    'has_downloads',
    'has_issues',
    'has_projects',
    'has_wiki',
    'has_pages',
    'homepage',
    'language',
    'archived',
    'disabled',
    'mirror_url',
    'open_issues',
    'open_issues_count',
    'license',
    'pushed_at',
    'size',
    'ssh_url',
    'stargazers_count',
    'svn_url',
    'watchers',
    'watchers_count',
    'created_at',
    'updated_at',
  ],
  title: 'Team Repository',
  type: 'object',
} as const;

export const team_simpleSchema = {
  description: 'Groups of organization members that gives permissions on specified repositories.',
  properties: {
    description: {
      description: 'Description of the team',
      example: 'A great team.',
      nullable: true,
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/orgs/rails/teams/core',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the team',
      example: 1,
      type: 'integer',
    },
    ldap_dn: {
      description: 'Distinguished Name (DN) that team maps to within LDAP environment',
      example: 'uid=example,ou=users,dc=github,dc=com',
      type: 'string',
    },
    members_url: {
      example: 'https://api.github.com/organizations/1/team/1/members{/member}',
      type: 'string',
    },
    name: {
      description: 'Name of the team',
      example: 'Justice League',
      type: 'string',
    },
    node_id: {
      example: 'MDQ6VGVhbTE=',
      type: 'string',
    },
    permission: {
      description: 'Permission that the team will have for its repositories',
      example: 'admin',
      type: 'string',
    },
    privacy: {
      description: 'The level of privacy this team should have',
      example: 'closed',
      type: 'string',
    },
    repositories_url: {
      example: 'https://api.github.com/organizations/1/team/1/repos',
      format: 'uri',
      type: 'string',
    },
    slug: {
      example: 'justice-league',
      type: 'string',
    },
    url: {
      description: 'URL for the team',
      example: 'https://api.github.com/organizations/1/team/1',
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'members_url',
    'name',
    'description',
    'permission',
    'html_url',
    'repositories_url',
    'slug',
  ],
  title: 'Team Simple',
  type: 'object',
} as const;

export const threadSchema = {
  description: 'Thread',
  properties: {
    id: {
      type: 'string',
    },
    last_read_at: {
      nullable: true,
      type: 'string',
    },
    reason: {
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/minimal-repository',
    },
    subject: {
      properties: {
        latest_comment_url: {
          type: 'string',
        },
        title: {
          type: 'string',
        },
        type: {
          type: 'string',
        },
        url: {
          type: 'string',
        },
      },
      required: ['title', 'url', 'latest_comment_url', 'type'],
      type: 'object',
    },
    subscription_url: {
      example: 'https://api.github.com/notifications/threads/2/subscription',
      type: 'string',
    },
    unread: {
      type: 'boolean',
    },
    updated_at: {
      type: 'string',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'unread',
    'reason',
    'updated_at',
    'last_read_at',
    'subject',
    'repository',
    'url',
    'subscription_url',
  ],
  title: 'Thread',
  type: 'object',
} as const;

export const thread_subscriptionSchema = {
  description: 'Thread Subscription',
  properties: {
    created_at: {
      example: '2012-10-06T21:34:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    ignored: {
      type: 'boolean',
    },
    reason: {
      nullable: true,
      type: 'string',
    },
    repository_url: {
      example: 'https://api.github.com/repos/1',
      format: 'uri',
      type: 'string',
    },
    subscribed: {
      example: true,
      type: 'boolean',
    },
    thread_url: {
      example: 'https://api.github.com/notifications/threads/1',
      format: 'uri',
      type: 'string',
    },
    url: {
      example: 'https://api.github.com/notifications/threads/1/subscription',
      format: 'uri',
      type: 'string',
    },
  },
  required: ['created_at', 'ignored', 'reason', 'url', 'subscribed'],
  title: 'Thread Subscription',
  type: 'object',
} as const;

export const timeline_assigned_issue_eventSchema = {
  description: 'Timeline Assigned Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    assignee: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
    'assignee',
  ],
  title: 'Timeline Assigned Issue Event',
  type: 'object',
} as const;

export const timeline_comment_eventSchema = {
  description: 'Timeline Comment Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      description: 'Contents of the issue comment',
      example: 'What version of Safari were you using when you observed this bug?',
      type: 'string',
    },
    body_html: {
      type: 'string',
    },
    body_text: {
      type: 'string',
    },
    created_at: {
      example: '2011-04-14T16:00:49Z',
      format: 'date-time',
      type: 'string',
    },
    event: {
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the issue comment',
      example: 42,
      type: 'integer',
    },
    issue_url: {
      format: 'uri',
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    reactions: {
      $ref: '#/components/schemas/reaction-rollup',
    },
    updated_at: {
      example: '2011-04-14T16:00:49Z',
      format: 'date-time',
      type: 'string',
    },
    url: {
      description: 'URL for the issue comment',
      example: 'https://api.github.com/repositories/42/issues/comments/1',
      format: 'uri',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: [
    'event',
    'actor',
    'id',
    'node_id',
    'html_url',
    'issue_url',
    'author_association',
    'user',
    'url',
    'created_at',
    'updated_at',
  ],
  title: 'Timeline Comment Event',
  type: 'object',
} as const;

export const timeline_commit_commented_eventSchema = {
  description: 'Timeline Commit Commented Event',
  properties: {
    comments: {
      items: {
        $ref: '#/components/schemas/commit-comment',
      },
      type: 'array',
    },
    commit_id: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
  },
  title: 'Timeline Commit Commented Event',
  type: 'object',
} as const;

export const timeline_committed_eventSchema = {
  description: 'Timeline Committed Event',
  properties: {
    author: {
      description: 'Identifying information for the git-user',
      properties: {
        date: {
          description: 'Timestamp of the commit',
          example: '2014-08-09T08:02:04+12:00',
          format: 'date-time',
          type: 'string',
        },
        email: {
          description: 'Git email address of the user',
          example: 'monalisa.octocat@example.com',
          type: 'string',
        },
        name: {
          description: 'Name of the git user',
          example: 'Monalisa Octocat',
          type: 'string',
        },
      },
      required: ['email', 'name', 'date'],
      type: 'object',
    },
    committer: {
      description: 'Identifying information for the git-user',
      properties: {
        date: {
          description: 'Timestamp of the commit',
          example: '2014-08-09T08:02:04+12:00',
          format: 'date-time',
          type: 'string',
        },
        email: {
          description: 'Git email address of the user',
          example: 'monalisa.octocat@example.com',
          type: 'string',
        },
        name: {
          description: 'Name of the git user',
          example: 'Monalisa Octocat',
          type: 'string',
        },
      },
      required: ['email', 'name', 'date'],
      type: 'object',
    },
    event: {
      type: 'string',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    message: {
      description: 'Message describing the purpose of the commit',
      example: 'Fix #42',
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    parents: {
      items: {
        properties: {
          html_url: {
            format: 'uri',
            type: 'string',
          },
          sha: {
            description: 'SHA for the commit',
            example: '7638417db6d59f3c431d3e1f261cc637155684cd',
            type: 'string',
          },
          url: {
            format: 'uri',
            type: 'string',
          },
        },
        required: ['sha', 'url', 'html_url'],
        type: 'object',
      },
      type: 'array',
    },
    sha: {
      description: 'SHA for the commit',
      example: '7638417db6d59f3c431d3e1f261cc637155684cd',
      type: 'string',
    },
    tree: {
      properties: {
        sha: {
          description: 'SHA for the commit',
          example: '7638417db6d59f3c431d3e1f261cc637155684cd',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['sha', 'url'],
      type: 'object',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
    verification: {
      properties: {
        payload: {
          nullable: true,
          type: 'string',
        },
        reason: {
          type: 'string',
        },
        signature: {
          nullable: true,
          type: 'string',
        },
        verified: {
          type: 'boolean',
        },
      },
      required: ['verified', 'reason', 'signature', 'payload'],
      type: 'object',
    },
  },
  required: ['sha', 'node_id', 'url', 'html_url', 'author', 'committer', 'tree', 'message', 'parents', 'verification'],
  title: 'Timeline Committed Event',
  type: 'object',
} as const;

export const timeline_cross_referenced_eventSchema = {
  description: 'Timeline Cross Referenced Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    event: {
      type: 'string',
    },
    source: {
      properties: {
        issue: {
          $ref: '#/components/schemas/issue',
        },
        type: {
          type: 'string',
        },
      },
      type: 'object',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
  },
  required: ['event', 'created_at', 'updated_at', 'source'],
  title: 'Timeline Cross Referenced Event',
  type: 'object',
} as const;

export const timeline_issue_eventsSchema = {
  anyOf: [
    {
      $ref: '#/components/schemas/labeled-issue-event',
    },
    {
      $ref: '#/components/schemas/unlabeled-issue-event',
    },
    {
      $ref: '#/components/schemas/milestoned-issue-event',
    },
    {
      $ref: '#/components/schemas/demilestoned-issue-event',
    },
    {
      $ref: '#/components/schemas/renamed-issue-event',
    },
    {
      $ref: '#/components/schemas/review-requested-issue-event',
    },
    {
      $ref: '#/components/schemas/review-request-removed-issue-event',
    },
    {
      $ref: '#/components/schemas/review-dismissed-issue-event',
    },
    {
      $ref: '#/components/schemas/locked-issue-event',
    },
    {
      $ref: '#/components/schemas/added-to-project-issue-event',
    },
    {
      $ref: '#/components/schemas/moved-column-in-project-issue-event',
    },
    {
      $ref: '#/components/schemas/removed-from-project-issue-event',
    },
    {
      $ref: '#/components/schemas/converted-note-to-issue-issue-event',
    },
    {
      $ref: '#/components/schemas/timeline-comment-event',
    },
    {
      $ref: '#/components/schemas/timeline-cross-referenced-event',
    },
    {
      $ref: '#/components/schemas/timeline-committed-event',
    },
    {
      $ref: '#/components/schemas/timeline-reviewed-event',
    },
    {
      $ref: '#/components/schemas/timeline-line-commented-event',
    },
    {
      $ref: '#/components/schemas/timeline-commit-commented-event',
    },
    {
      $ref: '#/components/schemas/timeline-assigned-issue-event',
    },
    {
      $ref: '#/components/schemas/timeline-unassigned-issue-event',
    },
    {
      $ref: '#/components/schemas/state-change-issue-event',
    },
  ],
  description: 'Timeline Event',
  title: 'Timeline Event',
  type: 'object',
} as const;

export const timeline_line_commented_eventSchema = {
  description: 'Timeline Line Commented Event',
  properties: {
    comments: {
      items: {
        $ref: '#/components/schemas/pull-request-review-comment',
      },
      type: 'array',
    },
    event: {
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
  },
  title: 'Timeline Line Commented Event',
  type: 'object',
} as const;

export const timeline_reviewed_eventSchema = {
  description: 'Timeline Reviewed Event',
  properties: {
    _links: {
      properties: {
        html: {
          properties: {
            href: {
              type: 'string',
            },
          },
          required: ['href'],
          type: 'object',
        },
        pull_request: {
          properties: {
            href: {
              type: 'string',
            },
          },
          required: ['href'],
          type: 'object',
        },
      },
      required: ['html', 'pull_request'],
      type: 'object',
    },
    author_association: {
      $ref: '#/components/schemas/author-association',
    },
    body: {
      description: 'The text of the review.',
      example: 'This looks great.',
      nullable: true,
      type: 'string',
    },
    body_html: {
      type: 'string',
    },
    body_text: {
      type: 'string',
    },
    commit_id: {
      description: 'A commit SHA for the review.',
      example: '54bb654c9e6025347f57900a4a5c2313a96b8035',
      type: 'string',
    },
    event: {
      type: 'string',
    },
    html_url: {
      example: 'https://github.com/octocat/Hello-World/pull/12#pullrequestreview-80',
      format: 'uri',
      type: 'string',
    },
    id: {
      description: 'Unique identifier of the review',
      example: 42,
      type: 'integer',
    },
    node_id: {
      example: 'MDE3OlB1bGxSZXF1ZXN0UmV2aWV3ODA=',
      type: 'string',
    },
    pull_request_url: {
      example: 'https://api.github.com/repos/octocat/Hello-World/pulls/12',
      format: 'uri',
      type: 'string',
    },
    state: {
      example: 'CHANGES_REQUESTED',
      type: 'string',
    },
    submitted_at: {
      format: 'date-time',
      type: 'string',
    },
    user: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: [
    'event',
    'id',
    'node_id',
    'user',
    'body',
    'state',
    'commit_id',
    'html_url',
    'pull_request_url',
    '_links',
    'author_association',
  ],
  title: 'Timeline Reviewed Event',
  type: 'object',
} as const;

export const timeline_unassigned_issue_eventSchema = {
  description: 'Timeline Unassigned Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    assignee: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
    'assignee',
  ],
  title: 'Timeline Unassigned Issue Event',
  type: 'object',
} as const;

export const topicSchema = {
  description: 'A topic aggregates entities that are related to a subject.',
  properties: {
    names: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  required: ['names'],
  title: 'Topic',
  type: 'object',
} as const;

export const topic_search_result_itemSchema = {
  description: 'Topic Search Result Item',
  properties: {
    aliases: {
      items: {
        properties: {
          topic_relation: {
            properties: {
              id: {
                type: 'integer',
              },
              name: {
                type: 'string',
              },
              relation_type: {
                type: 'string',
              },
              topic_id: {
                type: 'integer',
              },
            },
            type: 'object',
          },
        },
        type: 'object',
      },
      nullable: true,
      type: 'array',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    created_by: {
      nullable: true,
      type: 'string',
    },
    curated: {
      type: 'boolean',
    },
    description: {
      nullable: true,
      type: 'string',
    },
    display_name: {
      nullable: true,
      type: 'string',
    },
    featured: {
      type: 'boolean',
    },
    logo_url: {
      format: 'uri',
      nullable: true,
      type: 'string',
    },
    name: {
      type: 'string',
    },
    related: {
      items: {
        properties: {
          topic_relation: {
            properties: {
              id: {
                type: 'integer',
              },
              name: {
                type: 'string',
              },
              relation_type: {
                type: 'string',
              },
              topic_id: {
                type: 'integer',
              },
            },
            type: 'object',
          },
        },
        type: 'object',
      },
      nullable: true,
      type: 'array',
    },
    released: {
      nullable: true,
      type: 'string',
    },
    repository_count: {
      nullable: true,
      type: 'integer',
    },
    score: {
      type: 'number',
    },
    short_description: {
      nullable: true,
      type: 'string',
    },
    text_matches: {
      $ref: '#/components/schemas/search-result-text-matches',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
  },
  required: [
    'name',
    'display_name',
    'short_description',
    'description',
    'created_by',
    'released',
    'created_at',
    'updated_at',
    'featured',
    'curated',
    'score',
  ],
  title: 'Topic Search Result Item',
  type: 'object',
} as const;

export const trafficSchema = {
  properties: {
    count: {
      type: 'integer',
    },
    timestamp: {
      format: 'date-time',
      type: 'string',
    },
    uniques: {
      type: 'integer',
    },
  },
  required: ['timestamp', 'uniques', 'count'],
  title: 'Traffic',
  type: 'object',
} as const;

export const unassigned_issue_eventSchema = {
  description: 'Unassigned Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    assignee: {
      $ref: '#/components/schemas/simple-user',
    },
    assigner: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
    'assignee',
    'assigner',
  ],
  title: 'Unassigned Issue Event',
  type: 'object',
} as const;

export const unlabeled_issue_eventSchema = {
  description: 'Unlabeled Issue Event',
  properties: {
    actor: {
      $ref: '#/components/schemas/simple-user',
    },
    commit_id: {
      nullable: true,
      type: 'string',
    },
    commit_url: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      type: 'string',
    },
    event: {
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    label: {
      properties: {
        color: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
      },
      required: ['name', 'color'],
      type: 'object',
    },
    node_id: {
      type: 'string',
    },
    performed_via_github_app: {
      $ref: '#/components/schemas/nullable-integration',
    },
    url: {
      type: 'string',
    },
  },
  required: [
    'label',
    'id',
    'node_id',
    'url',
    'actor',
    'event',
    'commit_id',
    'commit_url',
    'created_at',
    'performed_via_github_app',
  ],
  title: 'Unlabeled Issue Event',
  type: 'object',
} as const;

export const user_marketplace_purchaseSchema = {
  description: 'User Marketplace Purchase',
  properties: {
    account: {
      $ref: '#/components/schemas/marketplace-account',
    },
    billing_cycle: {
      example: 'monthly',
      type: 'string',
    },
    free_trial_ends_on: {
      example: '2017-11-11T00:00:00Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    next_billing_date: {
      example: '2017-11-11T00:00:00Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    on_free_trial: {
      example: true,
      type: 'boolean',
    },
    plan: {
      $ref: '#/components/schemas/marketplace-listing-plan',
    },
    unit_count: {
      nullable: true,
      type: 'integer',
    },
    updated_at: {
      example: '2017-11-02T01:12:12Z',
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
  },
  required: [
    'billing_cycle',
    'next_billing_date',
    'unit_count',
    'updated_at',
    'on_free_trial',
    'free_trial_ends_on',
    'account',
    'plan',
  ],
  title: 'User Marketplace Purchase',
  type: 'object',
} as const;

export const user_search_result_itemSchema = {
  description: 'User Search Result Item',
  properties: {
    avatar_url: {
      format: 'uri',
      type: 'string',
    },
    bio: {
      nullable: true,
      type: 'string',
    },
    blog: {
      nullable: true,
      type: 'string',
    },
    company: {
      nullable: true,
      type: 'string',
    },
    created_at: {
      format: 'date-time',
      type: 'string',
    },
    email: {
      format: 'email',
      nullable: true,
      type: 'string',
    },
    events_url: {
      type: 'string',
    },
    followers: {
      type: 'integer',
    },
    followers_url: {
      format: 'uri',
      type: 'string',
    },
    following: {
      type: 'integer',
    },
    following_url: {
      type: 'string',
    },
    gists_url: {
      type: 'string',
    },
    gravatar_id: {
      nullable: true,
      type: 'string',
    },
    hireable: {
      nullable: true,
      type: 'boolean',
    },
    html_url: {
      format: 'uri',
      type: 'string',
    },
    id: {
      type: 'integer',
    },
    location: {
      nullable: true,
      type: 'string',
    },
    login: {
      type: 'string',
    },
    name: {
      nullable: true,
      type: 'string',
    },
    node_id: {
      type: 'string',
    },
    organizations_url: {
      format: 'uri',
      type: 'string',
    },
    public_gists: {
      type: 'integer',
    },
    public_repos: {
      type: 'integer',
    },
    received_events_url: {
      format: 'uri',
      type: 'string',
    },
    repos_url: {
      format: 'uri',
      type: 'string',
    },
    score: {
      type: 'number',
    },
    site_admin: {
      type: 'boolean',
    },
    starred_url: {
      type: 'string',
    },
    subscriptions_url: {
      format: 'uri',
      type: 'string',
    },
    suspended_at: {
      format: 'date-time',
      nullable: true,
      type: 'string',
    },
    text_matches: {
      $ref: '#/components/schemas/search-result-text-matches',
    },
    type: {
      type: 'string',
    },
    updated_at: {
      format: 'date-time',
      type: 'string',
    },
    url: {
      format: 'uri',
      type: 'string',
    },
  },
  required: [
    'avatar_url',
    'events_url',
    'followers_url',
    'following_url',
    'gists_url',
    'gravatar_id',
    'html_url',
    'id',
    'node_id',
    'login',
    'organizations_url',
    'received_events_url',
    'repos_url',
    'site_admin',
    'starred_url',
    'subscriptions_url',
    'type',
    'url',
    'score',
  ],
  title: 'User Search Result Item',
  type: 'object',
} as const;

export const validation_errorSchema = {
  description: 'Validation Error',
  properties: {
    documentation_url: {
      type: 'string',
    },
    errors: {
      items: {
        properties: {
          code: {
            type: 'string',
          },
          field: {
            type: 'string',
          },
          index: {
            type: 'integer',
          },
          message: {
            type: 'string',
          },
          resource: {
            type: 'string',
          },
          value: {
            oneOf: [
              {
                nullable: true,
                type: 'string',
              },
              {
                nullable: true,
                type: 'integer',
              },
              {
                items: {
                  type: 'string',
                },
                nullable: true,
                type: 'array',
              },
            ],
          },
        },
        required: ['code'],
        type: 'object',
      },
      type: 'array',
    },
    message: {
      type: 'string',
    },
  },
  required: ['message', 'documentation_url'],
  title: 'Validation Error',
  type: 'object',
} as const;

export const validation_error_simpleSchema = {
  description: 'Validation Error Simple',
  properties: {
    documentation_url: {
      type: 'string',
    },
    errors: {
      items: {
        type: 'string',
      },
      type: 'array',
    },
    message: {
      type: 'string',
    },
  },
  required: ['message', 'documentation_url'],
  title: 'Validation Error Simple',
  type: 'object',
} as const;

export const verificationSchema = {
  properties: {
    payload: {
      nullable: true,
      type: 'string',
    },
    reason: {
      type: 'string',
    },
    signature: {
      nullable: true,
      type: 'string',
    },
    verified: {
      type: 'boolean',
    },
  },
  required: ['verified', 'reason', 'payload', 'signature'],
  title: 'Verification',
  type: 'object',
} as const;

export const view_trafficSchema = {
  description: 'View Traffic',
  properties: {
    count: {
      example: 14850,
      type: 'integer',
    },
    uniques: {
      example: 3782,
      type: 'integer',
    },
    views: {
      items: {
        $ref: '#/components/schemas/traffic',
      },
      type: 'array',
    },
  },
  required: ['uniques', 'count', 'views'],
  title: 'View Traffic',
  type: 'object',
} as const;

export const wait_timerSchema = {
  description:
    'The amount of time to delay a job after the job is initially triggered. The time (in minutes) must be an integer between 0 and 43,200 (30 days).',
  example: 30,
  type: 'integer',
} as const;

export const webhook_branch_protection_rule_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    rule: {
      description:
        'The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.',
      properties: {
        admin_enforced: {
          type: 'boolean',
        },
        allow_deletions_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        allow_force_pushes_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        authorized_actor_names: {
          items: {
            type: 'string',
          },
          type: 'array',
        },
        authorized_actors_only: {
          type: 'boolean',
        },
        authorized_dismissal_actors_only: {
          type: 'boolean',
        },
        create_protected: {
          type: 'boolean',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        dismiss_stale_reviews_on_push: {
          type: 'boolean',
        },
        id: {
          type: 'integer',
        },
        ignore_approvals_from_contributors: {
          type: 'boolean',
        },
        linear_history_requirement_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        merge_queue_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        name: {
          type: 'string',
        },
        pull_request_reviews_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        repository_id: {
          type: 'integer',
        },
        require_code_owner_review: {
          type: 'boolean',
        },
        required_approving_review_count: {
          type: 'integer',
        },
        required_conversation_resolution_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        required_deployments_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        required_status_checks: {
          items: {
            type: 'string',
          },
          type: 'array',
        },
        required_status_checks_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        signature_requirement_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        strict_required_status_checks_policy: {
          type: 'boolean',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
      },
      required: [
        'id',
        'repository_id',
        'name',
        'created_at',
        'updated_at',
        'pull_request_reviews_enforcement_level',
        'required_approving_review_count',
        'dismiss_stale_reviews_on_push',
        'require_code_owner_review',
        'authorized_dismissal_actors_only',
        'ignore_approvals_from_contributors',
        'required_status_checks',
        'required_status_checks_enforcement_level',
        'strict_required_status_checks_policy',
        'signature_requirement_enforcement_level',
        'linear_history_requirement_enforcement_level',
        'admin_enforced',
        'allow_force_pushes_enforcement_level',
        'allow_deletions_enforcement_level',
        'merge_queue_enforcement_level',
        'required_deployments_enforcement_level',
        'required_conversation_resolution_level',
        'authorized_actors_only',
        'authorized_actor_names',
      ],
      title: 'branch protection rule',
      type: 'object',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'rule', 'repository', 'sender'],
  title: 'branch protection rule created event',
  type: 'object',
} as const;

export const webhook_branch_protection_rule_deletedSchema = {
  properties: {
    action: {
      enum: ['deleted'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    rule: {
      description:
        'The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.',
      properties: {
        admin_enforced: {
          type: 'boolean',
        },
        allow_deletions_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        allow_force_pushes_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        authorized_actor_names: {
          items: {
            type: 'string',
          },
          type: 'array',
        },
        authorized_actors_only: {
          type: 'boolean',
        },
        authorized_dismissal_actors_only: {
          type: 'boolean',
        },
        create_protected: {
          type: 'boolean',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        dismiss_stale_reviews_on_push: {
          type: 'boolean',
        },
        id: {
          type: 'integer',
        },
        ignore_approvals_from_contributors: {
          type: 'boolean',
        },
        linear_history_requirement_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        merge_queue_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        name: {
          type: 'string',
        },
        pull_request_reviews_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        repository_id: {
          type: 'integer',
        },
        require_code_owner_review: {
          type: 'boolean',
        },
        required_approving_review_count: {
          type: 'integer',
        },
        required_conversation_resolution_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        required_deployments_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        required_status_checks: {
          items: {
            type: 'string',
          },
          type: 'array',
        },
        required_status_checks_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        signature_requirement_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        strict_required_status_checks_policy: {
          type: 'boolean',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
      },
      required: [
        'id',
        'repository_id',
        'name',
        'created_at',
        'updated_at',
        'pull_request_reviews_enforcement_level',
        'required_approving_review_count',
        'dismiss_stale_reviews_on_push',
        'require_code_owner_review',
        'authorized_dismissal_actors_only',
        'ignore_approvals_from_contributors',
        'required_status_checks',
        'required_status_checks_enforcement_level',
        'strict_required_status_checks_policy',
        'signature_requirement_enforcement_level',
        'linear_history_requirement_enforcement_level',
        'admin_enforced',
        'allow_force_pushes_enforcement_level',
        'allow_deletions_enforcement_level',
        'merge_queue_enforcement_level',
        'required_deployments_enforcement_level',
        'required_conversation_resolution_level',
        'authorized_actors_only',
        'authorized_actor_names',
      ],
      title: 'branch protection rule',
      type: 'object',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'rule', 'repository', 'sender'],
  title: 'branch protection rule deleted event',
  type: 'object',
} as const;

export const webhook_branch_protection_rule_editedSchema = {
  properties: {
    action: {
      enum: ['edited'],
      type: 'string',
    },
    changes: {
      description: 'If the action was `edited`, the changes to the rule.',
      properties: {
        admin_enforced: {
          properties: {
            from: {
              nullable: true,
              type: 'boolean',
            },
          },
          required: ['from'],
          type: 'object',
        },
        authorized_actor_names: {
          properties: {
            from: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
          },
          required: ['from'],
          type: 'object',
        },
        authorized_actors_only: {
          properties: {
            from: {
              nullable: true,
              type: 'boolean',
            },
          },
          required: ['from'],
          type: 'object',
        },
        authorized_dismissal_actors_only: {
          properties: {
            from: {
              nullable: true,
              type: 'boolean',
            },
          },
          required: ['from'],
          type: 'object',
        },
        linear_history_requirement_enforcement_level: {
          properties: {
            from: {
              enum: ['off', 'non_admins', 'everyone'],
              type: 'string',
            },
          },
          required: ['from'],
          type: 'object',
        },
        required_status_checks: {
          properties: {
            from: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
          },
          required: ['from'],
          type: 'object',
        },
        required_status_checks_enforcement_level: {
          properties: {
            from: {
              enum: ['off', 'non_admins', 'everyone'],
              type: 'string',
            },
          },
          required: ['from'],
          type: 'object',
        },
      },
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    rule: {
      description:
        'The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.',
      properties: {
        admin_enforced: {
          type: 'boolean',
        },
        allow_deletions_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        allow_force_pushes_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        authorized_actor_names: {
          items: {
            type: 'string',
          },
          type: 'array',
        },
        authorized_actors_only: {
          type: 'boolean',
        },
        authorized_dismissal_actors_only: {
          type: 'boolean',
        },
        create_protected: {
          type: 'boolean',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        dismiss_stale_reviews_on_push: {
          type: 'boolean',
        },
        id: {
          type: 'integer',
        },
        ignore_approvals_from_contributors: {
          type: 'boolean',
        },
        linear_history_requirement_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        merge_queue_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        name: {
          type: 'string',
        },
        pull_request_reviews_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        repository_id: {
          type: 'integer',
        },
        require_code_owner_review: {
          type: 'boolean',
        },
        required_approving_review_count: {
          type: 'integer',
        },
        required_conversation_resolution_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        required_deployments_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        required_status_checks: {
          items: {
            type: 'string',
          },
          type: 'array',
        },
        required_status_checks_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        signature_requirement_enforcement_level: {
          enum: ['off', 'non_admins', 'everyone'],
          type: 'string',
        },
        strict_required_status_checks_policy: {
          type: 'boolean',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
      },
      required: [
        'id',
        'repository_id',
        'name',
        'created_at',
        'updated_at',
        'pull_request_reviews_enforcement_level',
        'required_approving_review_count',
        'dismiss_stale_reviews_on_push',
        'require_code_owner_review',
        'authorized_dismissal_actors_only',
        'ignore_approvals_from_contributors',
        'required_status_checks',
        'required_status_checks_enforcement_level',
        'strict_required_status_checks_policy',
        'signature_requirement_enforcement_level',
        'linear_history_requirement_enforcement_level',
        'admin_enforced',
        'allow_force_pushes_enforcement_level',
        'allow_deletions_enforcement_level',
        'merge_queue_enforcement_level',
        'required_deployments_enforcement_level',
        'required_conversation_resolution_level',
        'authorized_actors_only',
        'authorized_actor_names',
      ],
      title: 'branch protection rule',
      type: 'object',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'rule', 'repository', 'sender'],
  title: 'branch protection rule edited event',
  type: 'object',
} as const;

export const webhook_check_run_completedSchema = {
  properties: {
    action: {
      enum: ['completed'],
      type: 'string',
    },
    check_run: {
      $ref: '#/components/schemas/check-run-with-simple-check-suite',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['check_run', 'repository', 'sender'],
  title: 'Check Run Completed Event',
  type: 'object',
} as const;

export const webhook_check_run_completed_form_encodedSchema = {
  description: 'The check_run.completed webhook encoded with URL encoding',
  properties: {
    payload: {
      description:
        'A URL-encoded string of the check_run.completed JSON payload. The decoded payload is a JSON object.',
      type: 'string',
    },
  },
  required: ['payload'],
  title: 'Check Run Completed Event',
  type: 'object',
} as const;

export const webhook_check_run_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    check_run: {
      $ref: '#/components/schemas/check-run-with-simple-check-suite',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['check_run', 'repository', 'sender'],
  title: 'Check Run Created Event',
  type: 'object',
} as const;

export const webhook_check_run_created_form_encodedSchema = {
  description: 'The check_run.created webhook encoded with URL encoding',
  properties: {
    payload: {
      description: 'A URL-encoded string of the check_run.created JSON payload. The decoded payload is a JSON object.',
      type: 'string',
    },
  },
  required: ['payload'],
  title: 'Check Run Created Event',
  type: 'object',
} as const;

export const webhook_check_run_requested_actionSchema = {
  properties: {
    action: {
      enum: ['requested_action'],
      type: 'string',
    },
    check_run: {
      $ref: '#/components/schemas/check-run-with-simple-check-suite',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    requested_action: {
      description: 'The action requested by the user.',
      properties: {
        identifier: {
          description: 'The integrator reference of the action requested by the user.',
          type: 'string',
        },
      },
      type: 'object',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'check_run', 'repository', 'sender'],
  title: 'Check Run Requested Action Event',
  type: 'object',
} as const;

export const webhook_check_run_requested_action_form_encodedSchema = {
  description: 'The check_run.requested_action webhook encoded with URL encoding',
  properties: {
    payload: {
      description:
        'A URL-encoded string of the check_run.requested_action JSON payload. The decoded payload is a JSON object.',
      type: 'string',
    },
  },
  required: ['payload'],
  title: 'Check Run Requested Action Event',
  type: 'object',
} as const;

export const webhook_check_run_rerequestedSchema = {
  properties: {
    action: {
      enum: ['rerequested'],
      type: 'string',
    },
    check_run: {
      $ref: '#/components/schemas/check-run-with-simple-check-suite',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['check_run', 'repository', 'sender'],
  title: 'Check Run Re-Requested Event',
  type: 'object',
} as const;

export const webhook_check_run_rerequested_form_encodedSchema = {
  description: 'The check_run.rerequested webhook encoded with URL encoding',
  properties: {
    payload: {
      description:
        'A URL-encoded string of the check_run.rerequested JSON payload. The decoded payload is a JSON object.',
      type: 'string',
    },
  },
  required: ['payload'],
  title: 'Check Run Re-Requested Event',
  type: 'object',
} as const;

export const webhook_check_suite_completedSchema = {
  properties: {
    action: {
      enum: ['completed'],
      type: 'string',
    },
    actions_meta: {
      nullable: true,
      type: 'object',
    },
    check_suite: {
      description: 'The [check_suite](https://docs.github.com/rest/reference/checks#suites).',
      properties: {
        after: {
          nullable: true,
          type: 'string',
        },
        app: {
          description:
            'GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.',
          properties: {
            created_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            events: {
              description: 'The list of events for the GitHub app',
              items: {
                enum: [
                  'branch_protection_rule',
                  'check_run',
                  'check_suite',
                  'code_scanning_alert',
                  'commit_comment',
                  'content_reference',
                  'create',
                  'delete',
                  'deployment',
                  'deployment_review',
                  'deployment_status',
                  'deploy_key',
                  'discussion',
                  'discussion_comment',
                  'fork',
                  'gollum',
                  'issues',
                  'issue_comment',
                  'label',
                  'member',
                  'membership',
                  'milestone',
                  'organization',
                  'org_block',
                  'page_build',
                  'project',
                  'project_card',
                  'project_column',
                  'public',
                  'pull_request',
                  'pull_request_review',
                  'pull_request_review_comment',
                  'push',
                  'registry_package',
                  'release',
                  'repository',
                  'repository_dispatch',
                  'secret_scanning_alert',
                  'star',
                  'status',
                  'team',
                  'team_add',
                  'watch',
                  'workflow_dispatch',
                  'workflow_run',
                  'merge_group',
                  'pull_request_review_thread',
                  'workflow_job',
                  'merge_queue_entry',
                  'security_and_analysis',
                  'projects_v2_item',
                  'secret_scanning_alert_location',
                ],
                type: 'string',
              },
              type: 'array',
            },
            external_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              description: 'Unique identifier of the GitHub app',
              nullable: true,
              type: 'integer',
            },
            name: {
              description: 'The name of the GitHub app',
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            owner: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            permissions: {
              description: 'The set of permissions for the GitHub app',
              properties: {
                actions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                checks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                content_references: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                contents: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                deployments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                emails: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                environments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                issues: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                keys: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                members: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                metadata: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_plan: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_projects: {
                  enum: ['read', 'write', 'admin'],
                  type: 'string',
                },
                organization_secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_self_hosted_runners: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_user_blocking: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pull_requests: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_projects: {
                  enum: ['read', 'write', 'admin'],
                  type: 'string',
                },
                secret_scanning_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_events: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_scanning_alert: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                single_file: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                statuses: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                team_discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                vulnerability_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                workflows: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
              },
              type: 'object',
            },
            slug: {
              description: 'The slug name of the GitHub app',
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
          },
          required: [
            'id',
            'node_id',
            'owner',
            'name',
            'description',
            'external_url',
            'html_url',
            'created_at',
            'updated_at',
          ],
          title: 'App',
          type: 'object',
        },
        before: {
          nullable: true,
          type: 'string',
        },
        check_runs_url: {
          format: 'uri',
          type: 'string',
        },
        conclusion: {
          description:
            'The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.',
          enum: [
            'success',
            'failure',
            'neutral',
            'cancelled',
            'timed_out',
            'action_required',
            'stale',
            null,
            'skipped',
            'startup_failure',
          ],
          nullable: true,
          type: 'string',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        head_branch: {
          description: 'The head branch name the changes are on.',
          nullable: true,
          type: 'string',
        },
        head_commit: {
          properties: {
            author: {
              description: 'Metaproperties for Git author/committer information.',
              properties: {
                date: {
                  format: 'date-time',
                  type: 'string',
                },
                email: {
                  format: 'email',
                  nullable: true,
                  type: 'string',
                },
                name: {
                  description: "The git author's name.",
                  type: 'string',
                },
                username: {
                  type: 'string',
                },
              },
              required: ['email', 'name'],
              title: 'Committer',
              type: 'object',
            },
            committer: {
              description: 'Metaproperties for Git author/committer information.',
              properties: {
                date: {
                  format: 'date-time',
                  type: 'string',
                },
                email: {
                  format: 'email',
                  nullable: true,
                  type: 'string',
                },
                name: {
                  description: "The git author's name.",
                  type: 'string',
                },
                username: {
                  type: 'string',
                },
              },
              required: ['email', 'name'],
              title: 'Committer',
              type: 'object',
            },
            id: {
              type: 'string',
            },
            message: {
              type: 'string',
            },
            timestamp: {
              type: 'string',
            },
            tree_id: {
              type: 'string',
            },
          },
          required: ['id', 'tree_id', 'message', 'timestamp', 'author', 'committer'],
          title: 'SimpleCommit',
          type: 'object',
        },
        head_sha: {
          description: 'The SHA of the head commit that is being checked.',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        latest_check_runs_count: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        pull_requests: {
          description:
            "An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
          items: {
            properties: {
              base: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              head: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              id: {
                type: 'integer',
              },
              number: {
                type: 'integer',
              },
              url: {
                format: 'uri',
                type: 'string',
              },
            },
            required: ['url', 'id', 'number', 'head', 'base'],
            title: 'Check Run Pull Request',
            type: 'object',
          },
          type: 'array',
        },
        rerequestable: {
          type: 'boolean',
        },
        runs_rerequestable: {
          type: 'boolean',
        },
        status: {
          description:
            'The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.',
          enum: ['requested', 'in_progress', 'completed', 'queued', null, 'pending'],
          nullable: true,
          type: 'string',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        url: {
          description: 'URL that points to the check suite API resource.',
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'id',
        'node_id',
        'head_branch',
        'head_sha',
        'status',
        'conclusion',
        'url',
        'before',
        'after',
        'pull_requests',
        'app',
        'created_at',
        'updated_at',
        'latest_check_runs_count',
        'check_runs_url',
        'head_commit',
      ],
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'check_suite', 'repository', 'sender'],
  title: 'check_suite completed event',
  type: 'object',
} as const;

export const webhook_check_suite_requestedSchema = {
  properties: {
    action: {
      enum: ['requested'],
      type: 'string',
    },
    actions_meta: {
      nullable: true,
      type: 'object',
    },
    check_suite: {
      description: 'The [check_suite](https://docs.github.com/rest/reference/checks#suites).',
      properties: {
        after: {
          nullable: true,
          type: 'string',
        },
        app: {
          description:
            'GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.',
          properties: {
            created_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            events: {
              description: 'The list of events for the GitHub app',
              items: {
                enum: [
                  'branch_protection_rule',
                  'check_run',
                  'check_suite',
                  'code_scanning_alert',
                  'commit_comment',
                  'content_reference',
                  'create',
                  'delete',
                  'deployment',
                  'deployment_review',
                  'deployment_status',
                  'deploy_key',
                  'discussion',
                  'discussion_comment',
                  'fork',
                  'gollum',
                  'issues',
                  'issue_comment',
                  'label',
                  'member',
                  'membership',
                  'milestone',
                  'organization',
                  'org_block',
                  'page_build',
                  'project',
                  'project_card',
                  'project_column',
                  'public',
                  'pull_request',
                  'pull_request_review',
                  'pull_request_review_comment',
                  'push',
                  'registry_package',
                  'release',
                  'repository',
                  'repository_dispatch',
                  'secret_scanning_alert',
                  'star',
                  'status',
                  'team',
                  'team_add',
                  'watch',
                  'workflow_dispatch',
                  'workflow_run',
                  'pull_request_review_thread',
                  'workflow_job',
                  'merge_queue_entry',
                  'security_and_analysis',
                  'secret_scanning_alert_location',
                  'projects_v2_item',
                  'merge_group',
                  'repository_import',
                ],
                type: 'string',
              },
              type: 'array',
            },
            external_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              description: 'Unique identifier of the GitHub app',
              nullable: true,
              type: 'integer',
            },
            name: {
              description: 'The name of the GitHub app',
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            owner: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            permissions: {
              description: 'The set of permissions for the GitHub app',
              properties: {
                actions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                checks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                content_references: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                contents: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                deployments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                emails: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                environments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                issues: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                keys: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                members: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                metadata: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_plan: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_projects: {
                  enum: ['read', 'write', 'admin'],
                  type: 'string',
                },
                organization_secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_self_hosted_runners: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_user_blocking: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pull_requests: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_projects: {
                  enum: ['read', 'write', 'admin'],
                  type: 'string',
                },
                secret_scanning_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_events: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_scanning_alert: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                single_file: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                statuses: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                team_discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                vulnerability_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                workflows: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
              },
              type: 'object',
            },
            slug: {
              description: 'The slug name of the GitHub app',
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
          },
          required: [
            'id',
            'node_id',
            'owner',
            'name',
            'description',
            'external_url',
            'html_url',
            'created_at',
            'updated_at',
          ],
          title: 'App',
          type: 'object',
        },
        before: {
          nullable: true,
          type: 'string',
        },
        check_runs_url: {
          format: 'uri',
          type: 'string',
        },
        conclusion: {
          description:
            'The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.',
          enum: [
            'success',
            'failure',
            'neutral',
            'cancelled',
            'timed_out',
            'action_required',
            'stale',
            null,
            'skipped',
          ],
          nullable: true,
          type: 'string',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        head_branch: {
          description: 'The head branch name the changes are on.',
          nullable: true,
          type: 'string',
        },
        head_commit: {
          properties: {
            author: {
              description: 'Metaproperties for Git author/committer information.',
              properties: {
                date: {
                  format: 'date-time',
                  type: 'string',
                },
                email: {
                  format: 'email',
                  nullable: true,
                  type: 'string',
                },
                name: {
                  description: "The git author's name.",
                  type: 'string',
                },
                username: {
                  type: 'string',
                },
              },
              required: ['email', 'name'],
              title: 'Committer',
              type: 'object',
            },
            committer: {
              description: 'Metaproperties for Git author/committer information.',
              properties: {
                date: {
                  format: 'date-time',
                  type: 'string',
                },
                email: {
                  format: 'email',
                  nullable: true,
                  type: 'string',
                },
                name: {
                  description: "The git author's name.",
                  type: 'string',
                },
                username: {
                  type: 'string',
                },
              },
              required: ['email', 'name'],
              title: 'Committer',
              type: 'object',
            },
            id: {
              type: 'string',
            },
            message: {
              type: 'string',
            },
            timestamp: {
              type: 'string',
            },
            tree_id: {
              type: 'string',
            },
          },
          required: ['id', 'tree_id', 'message', 'timestamp', 'author', 'committer'],
          title: 'SimpleCommit',
          type: 'object',
        },
        head_sha: {
          description: 'The SHA of the head commit that is being checked.',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        latest_check_runs_count: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        pull_requests: {
          description:
            "An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
          items: {
            properties: {
              base: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              head: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              id: {
                type: 'integer',
              },
              number: {
                type: 'integer',
              },
              url: {
                format: 'uri',
                type: 'string',
              },
            },
            required: ['url', 'id', 'number', 'head', 'base'],
            title: 'Check Run Pull Request',
            type: 'object',
          },
          type: 'array',
        },
        rerequestable: {
          type: 'boolean',
        },
        runs_rerequestable: {
          type: 'boolean',
        },
        status: {
          description:
            'The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.',
          enum: ['requested', 'in_progress', 'completed', 'queued', null],
          nullable: true,
          type: 'string',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        url: {
          description: 'URL that points to the check suite API resource.',
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'id',
        'node_id',
        'head_branch',
        'head_sha',
        'status',
        'conclusion',
        'url',
        'before',
        'after',
        'pull_requests',
        'app',
        'created_at',
        'updated_at',
        'latest_check_runs_count',
        'check_runs_url',
        'head_commit',
      ],
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'check_suite', 'repository', 'sender'],
  title: 'check_suite requested event',
  type: 'object',
} as const;

export const webhook_check_suite_rerequestedSchema = {
  properties: {
    action: {
      enum: ['rerequested'],
      type: 'string',
    },
    actions_meta: {
      nullable: true,
      properties: {
        rerun_info: {
          properties: {
            job_ids: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            plan_id: {
              type: 'string',
            },
          },
          type: 'object',
        },
      },
      type: 'object',
    },
    check_suite: {
      description: 'The [check_suite](https://docs.github.com/rest/reference/checks#suites).',
      properties: {
        after: {
          nullable: true,
          type: 'string',
        },
        app: {
          description:
            'GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.',
          properties: {
            created_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            events: {
              description: 'The list of events for the GitHub app',
              items: {
                enum: [
                  'branch_protection_rule',
                  'check_run',
                  'check_suite',
                  'code_scanning_alert',
                  'commit_comment',
                  'content_reference',
                  'create',
                  'delete',
                  'deployment',
                  'deployment_review',
                  'deployment_status',
                  'deploy_key',
                  'discussion',
                  'discussion_comment',
                  'fork',
                  'gollum',
                  'issues',
                  'issue_comment',
                  'label',
                  'member',
                  'membership',
                  'milestone',
                  'organization',
                  'org_block',
                  'page_build',
                  'project',
                  'project_card',
                  'project_column',
                  'public',
                  'pull_request',
                  'pull_request_review',
                  'pull_request_review_comment',
                  'push',
                  'registry_package',
                  'release',
                  'repository',
                  'repository_dispatch',
                  'secret_scanning_alert',
                  'star',
                  'status',
                  'team',
                  'team_add',
                  'watch',
                  'workflow_dispatch',
                  'workflow_run',
                  'pull_request_review_thread',
                  'merge_queue_entry',
                  'workflow_job',
                ],
                type: 'string',
              },
              type: 'array',
            },
            external_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              description: 'Unique identifier of the GitHub app',
              nullable: true,
              type: 'integer',
            },
            name: {
              description: 'The name of the GitHub app',
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            owner: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            permissions: {
              description: 'The set of permissions for the GitHub app',
              properties: {
                actions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                checks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                content_references: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                contents: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                deployments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                emails: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                environments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                issues: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                keys: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                members: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                metadata: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_plan: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_projects: {
                  enum: ['read', 'write', 'admin'],
                  type: 'string',
                },
                organization_secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_self_hosted_runners: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_user_blocking: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pull_requests: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_projects: {
                  enum: ['read', 'write', 'admin'],
                  type: 'string',
                },
                secret_scanning_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_events: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_scanning_alert: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                single_file: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                statuses: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                team_discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                vulnerability_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                workflows: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
              },
              type: 'object',
            },
            slug: {
              description: 'The slug name of the GitHub app',
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
          },
          required: [
            'id',
            'node_id',
            'owner',
            'name',
            'description',
            'external_url',
            'html_url',
            'created_at',
            'updated_at',
          ],
          title: 'App',
          type: 'object',
        },
        before: {
          nullable: true,
          type: 'string',
        },
        check_runs_url: {
          format: 'uri',
          type: 'string',
        },
        conclusion: {
          description:
            'The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.',
          enum: ['success', 'failure', 'neutral', 'cancelled', 'timed_out', 'action_required', 'stale', null],
          nullable: true,
          type: 'string',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        head_branch: {
          description: 'The head branch name the changes are on.',
          nullable: true,
          type: 'string',
        },
        head_commit: {
          properties: {
            author: {
              description: 'Metaproperties for Git author/committer information.',
              properties: {
                date: {
                  format: 'date-time',
                  type: 'string',
                },
                email: {
                  format: 'email',
                  nullable: true,
                  type: 'string',
                },
                name: {
                  description: "The git author's name.",
                  type: 'string',
                },
                username: {
                  type: 'string',
                },
              },
              required: ['email', 'name'],
              title: 'Committer',
              type: 'object',
            },
            committer: {
              description: 'Metaproperties for Git author/committer information.',
              properties: {
                date: {
                  format: 'date-time',
                  type: 'string',
                },
                email: {
                  format: 'email',
                  nullable: true,
                  type: 'string',
                },
                name: {
                  description: "The git author's name.",
                  type: 'string',
                },
                username: {
                  type: 'string',
                },
              },
              required: ['email', 'name'],
              title: 'Committer',
              type: 'object',
            },
            id: {
              type: 'string',
            },
            message: {
              type: 'string',
            },
            timestamp: {
              type: 'string',
            },
            tree_id: {
              type: 'string',
            },
          },
          required: ['id', 'tree_id', 'message', 'timestamp', 'author', 'committer'],
          title: 'SimpleCommit',
          type: 'object',
        },
        head_sha: {
          description: 'The SHA of the head commit that is being checked.',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        latest_check_runs_count: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        pull_requests: {
          description:
            "An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.",
          items: {
            properties: {
              base: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              head: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              id: {
                type: 'integer',
              },
              number: {
                type: 'integer',
              },
              url: {
                format: 'uri',
                type: 'string',
              },
            },
            required: ['url', 'id', 'number', 'head', 'base'],
            title: 'Check Run Pull Request',
            type: 'object',
          },
          type: 'array',
        },
        rerequestable: {
          type: 'boolean',
        },
        runs_rerequestable: {
          type: 'boolean',
        },
        status: {
          description:
            'The summary status for all check runs that are part of the check suite. Can be `requested`, `in_progress`, or `completed`.',
          enum: ['requested', 'in_progress', 'completed', 'queued', null],
          nullable: true,
          type: 'string',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        url: {
          description: 'URL that points to the check suite API resource.',
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'id',
        'node_id',
        'head_branch',
        'head_sha',
        'status',
        'conclusion',
        'url',
        'before',
        'after',
        'pull_requests',
        'app',
        'created_at',
        'updated_at',
        'latest_check_runs_count',
        'check_runs_url',
        'head_commit',
      ],
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'check_suite', 'repository', 'sender'],
  title: 'check_suite rerequested event',
  type: 'object',
} as const;

export const webhook_code_scanning_alert_appeared_in_branchSchema = {
  properties: {
    action: {
      enum: ['appeared_in_branch'],
      type: 'string',
    },
    alert: {
      description: 'The code scanning alert involved in the event.',
      properties: {
        created_at: {
          description: 'The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`',
          format: 'date-time',
          type: 'string',
        },
        dismissed_at: {
          description: 'The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        dismissed_by: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        dismissed_reason: {
          description:
            "The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
          enum: ['false positive', "won't fix", 'used in tests', null],
          nullable: true,
          type: 'string',
        },
        html_url: {
          description: 'The GitHub URL of the alert resource.',
          format: 'uri',
          type: 'string',
        },
        most_recent_instance: {
          nullable: true,
          properties: {
            analysis_key: {
              description:
                'Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.',
              type: 'string',
            },
            classifications: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            commit_sha: {
              type: 'string',
            },
            environment: {
              description:
                'Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.',
              type: 'string',
            },
            location: {
              properties: {
                end_column: {
                  type: 'integer',
                },
                end_line: {
                  type: 'integer',
                },
                path: {
                  type: 'string',
                },
                start_column: {
                  type: 'integer',
                },
                start_line: {
                  type: 'integer',
                },
              },
              type: 'object',
            },
            message: {
              properties: {
                text: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            ref: {
              description: 'The full Git reference, formatted as `refs/heads/<branch name>`.',
              type: 'string',
            },
            state: {
              description: 'State of a code scanning alert.',
              enum: ['open', 'dismissed', 'fixed'],
              type: 'string',
            },
          },
          required: ['ref', 'analysis_key', 'environment', 'state'],
          title: 'Alert Instance',
          type: 'object',
        },
        number: {
          description: 'The code scanning alert number.',
          type: 'integer',
        },
        rule: {
          properties: {
            description: {
              description: 'A short description of the rule used to detect the alert.',
              type: 'string',
            },
            id: {
              description: 'A unique identifier for the rule used to detect the alert.',
              type: 'string',
            },
            severity: {
              description: 'The severity of the alert.',
              enum: ['none', 'note', 'warning', 'error', null],
              nullable: true,
              type: 'string',
            },
          },
          required: ['id', 'severity', 'description'],
          type: 'object',
        },
        state: {
          description: 'State of a code scanning alert.',
          enum: ['open', 'dismissed', 'fixed'],
          type: 'string',
        },
        tool: {
          properties: {
            name: {
              description: 'The name of the tool used to generate the code scanning analysis alert.',
              type: 'string',
            },
            version: {
              description: 'The version of the tool used to detect the alert.',
              nullable: true,
              type: 'string',
            },
          },
          required: ['name', 'version'],
          type: 'object',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'number',
        'created_at',
        'url',
        'html_url',
        'state',
        'dismissed_by',
        'dismissed_at',
        'dismissed_reason',
        'rule',
        'tool',
      ],
      type: 'object',
    },
    commit_oid: {
      description:
        'The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    ref: {
      description:
        'The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'ref', 'commit_oid', 'repository', 'sender'],
  title: 'code_scanning_alert appeared_in_branch event',
  type: 'object',
} as const;

export const webhook_code_scanning_alert_closed_by_userSchema = {
  properties: {
    action: {
      enum: ['closed_by_user'],
      type: 'string',
    },
    alert: {
      description: 'The code scanning alert involved in the event.',
      properties: {
        created_at: {
          description: 'The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`',
          format: 'date-time',
          type: 'string',
        },
        dismissed_at: {
          description: 'The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
          format: 'date-time',
          type: 'string',
        },
        dismissed_by: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        dismissed_reason: {
          description:
            "The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
          enum: ['false positive', "won't fix", 'used in tests', null],
          nullable: true,
          type: 'string',
        },
        html_url: {
          description: 'The GitHub URL of the alert resource.',
          format: 'uri',
          type: 'string',
        },
        most_recent_instance: {
          nullable: true,
          properties: {
            analysis_key: {
              description:
                'Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.',
              type: 'string',
            },
            classifications: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            commit_sha: {
              type: 'string',
            },
            environment: {
              description:
                'Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.',
              type: 'string',
            },
            location: {
              properties: {
                end_column: {
                  type: 'integer',
                },
                end_line: {
                  type: 'integer',
                },
                path: {
                  type: 'string',
                },
                start_column: {
                  type: 'integer',
                },
                start_line: {
                  type: 'integer',
                },
              },
              type: 'object',
            },
            message: {
              properties: {
                text: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            ref: {
              description: 'The full Git reference, formatted as `refs/heads/<branch name>`.',
              type: 'string',
            },
            state: {
              description: 'State of a code scanning alert.',
              enum: ['open', 'dismissed', 'fixed'],
              type: 'string',
            },
          },
          required: ['ref', 'analysis_key', 'environment', 'state'],
          title: 'Alert Instance',
          type: 'object',
        },
        number: {
          description: 'The code scanning alert number.',
          type: 'integer',
        },
        rule: {
          properties: {
            description: {
              description: 'A short description of the rule used to detect the alert.',
              type: 'string',
            },
            full_description: {
              type: 'string',
            },
            help: {
              nullable: true,
              type: 'string',
            },
            help_uri: {
              description: 'A link to the documentation for the rule used to detect the alert.',
              nullable: true,
              type: 'string',
            },
            id: {
              description: 'A unique identifier for the rule used to detect the alert.',
              type: 'string',
            },
            name: {
              type: 'string',
            },
            severity: {
              description: 'The severity of the alert.',
              enum: ['none', 'note', 'warning', 'error', null],
              nullable: true,
              type: 'string',
            },
            tags: {
              items: {
                type: 'string',
              },
              nullable: true,
              type: 'array',
            },
          },
          required: ['id', 'severity', 'description'],
          type: 'object',
        },
        state: {
          description: 'State of a code scanning alert.',
          enum: ['dismissed', 'fixed'],
          type: 'string',
        },
        tool: {
          properties: {
            guid: {
              nullable: true,
              type: 'string',
            },
            name: {
              description: 'The name of the tool used to generate the code scanning analysis alert.',
              type: 'string',
            },
            version: {
              description: 'The version of the tool used to detect the alert.',
              nullable: true,
              type: 'string',
            },
          },
          required: ['name', 'version'],
          type: 'object',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'number',
        'created_at',
        'url',
        'html_url',
        'state',
        'dismissed_by',
        'dismissed_at',
        'dismissed_reason',
        'rule',
        'tool',
      ],
      type: 'object',
    },
    commit_oid: {
      description:
        'The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    ref: {
      description:
        'The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'ref', 'commit_oid', 'repository', 'sender'],
  title: 'code_scanning_alert closed_by_user event',
  type: 'object',
} as const;

export const webhook_code_scanning_alert_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    alert: {
      description: 'The code scanning alert involved in the event.',
      properties: {
        created_at: {
          description: 'The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`',
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        dismissed_at: {
          description: 'The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
          nullable: true,
        },
        dismissed_by: {
          nullable: true,
        },
        dismissed_comment: {
          $ref: '#/components/schemas/code-scanning-alert-dismissed-comment',
        },
        dismissed_reason: {
          description:
            "The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
          nullable: true,
        },
        fixed_at: {
          nullable: true,
        },
        html_url: {
          description: 'The GitHub URL of the alert resource.',
          format: 'uri',
          type: 'string',
        },
        instances_url: {
          type: 'string',
        },
        most_recent_instance: {
          nullable: true,
          properties: {
            analysis_key: {
              description:
                'Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.',
              type: 'string',
            },
            classifications: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            commit_sha: {
              type: 'string',
            },
            environment: {
              description:
                'Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.',
              type: 'string',
            },
            location: {
              properties: {
                end_column: {
                  type: 'integer',
                },
                end_line: {
                  type: 'integer',
                },
                path: {
                  type: 'string',
                },
                start_column: {
                  type: 'integer',
                },
                start_line: {
                  type: 'integer',
                },
              },
              type: 'object',
            },
            message: {
              properties: {
                text: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            ref: {
              description: 'The full Git reference, formatted as `refs/heads/<branch name>`.',
              type: 'string',
            },
            state: {
              description: 'State of a code scanning alert.',
              enum: ['open', 'dismissed', 'fixed'],
              type: 'string',
            },
          },
          required: ['ref', 'analysis_key', 'environment', 'state'],
          title: 'Alert Instance',
          type: 'object',
        },
        number: {
          description: 'The code scanning alert number.',
          type: 'integer',
        },
        rule: {
          properties: {
            description: {
              description: 'A short description of the rule used to detect the alert.',
              type: 'string',
            },
            full_description: {
              type: 'string',
            },
            help: {
              nullable: true,
              type: 'string',
            },
            help_uri: {
              description: 'A link to the documentation for the rule used to detect the alert.',
              nullable: true,
              type: 'string',
            },
            id: {
              description: 'A unique identifier for the rule used to detect the alert.',
              type: 'string',
            },
            name: {
              type: 'string',
            },
            severity: {
              description: 'The severity of the alert.',
              enum: ['none', 'note', 'warning', 'error', null],
              nullable: true,
              type: 'string',
            },
            tags: {
              items: {
                type: 'string',
              },
              nullable: true,
              type: 'array',
            },
          },
          required: ['id', 'severity', 'description'],
          type: 'object',
        },
        state: {
          description: 'State of a code scanning alert.',
          enum: ['open', 'dismissed'],
          type: 'string',
        },
        tool: {
          nullable: true,
          properties: {
            guid: {
              nullable: true,
              type: 'string',
            },
            name: {
              description: 'The name of the tool used to generate the code scanning analysis alert.',
              type: 'string',
            },
            version: {
              description: 'The version of the tool used to detect the alert.',
              nullable: true,
              type: 'string',
            },
          },
          required: ['name', 'version'],
          type: 'object',
        },
        updated_at: {
          nullable: true,
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'number',
        'created_at',
        'url',
        'html_url',
        'state',
        'dismissed_by',
        'dismissed_at',
        'dismissed_reason',
        'rule',
        'tool',
      ],
      type: 'object',
    },
    commit_oid: {
      description:
        'The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    ref: {
      description:
        'The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'ref', 'commit_oid', 'repository', 'sender'],
  title: 'code_scanning_alert created event',
  type: 'object',
} as const;

export const webhook_code_scanning_alert_fixedSchema = {
  properties: {
    action: {
      enum: ['fixed'],
      type: 'string',
    },
    alert: {
      description: 'The code scanning alert involved in the event.',
      properties: {
        created_at: {
          description: 'The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`',
          format: 'date-time',
          type: 'string',
        },
        dismissed_at: {
          description: 'The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        dismissed_by: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        dismissed_reason: {
          description:
            "The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
          enum: ['false positive', "won't fix", 'used in tests', null],
          nullable: true,
          type: 'string',
        },
        html_url: {
          description: 'The GitHub URL of the alert resource.',
          format: 'uri',
          type: 'string',
        },
        instances_url: {
          format: 'uri',
          type: 'string',
        },
        most_recent_instance: {
          nullable: true,
          properties: {
            analysis_key: {
              description:
                'Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.',
              type: 'string',
            },
            classifications: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            commit_sha: {
              type: 'string',
            },
            environment: {
              description:
                'Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.',
              type: 'string',
            },
            location: {
              properties: {
                end_column: {
                  type: 'integer',
                },
                end_line: {
                  type: 'integer',
                },
                path: {
                  type: 'string',
                },
                start_column: {
                  type: 'integer',
                },
                start_line: {
                  type: 'integer',
                },
              },
              type: 'object',
            },
            message: {
              properties: {
                text: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            ref: {
              description: 'The full Git reference, formatted as `refs/heads/<branch name>`.',
              type: 'string',
            },
            state: {
              description: 'State of a code scanning alert.',
              enum: ['open', 'dismissed', 'fixed'],
              type: 'string',
            },
          },
          required: ['ref', 'analysis_key', 'environment', 'state'],
          title: 'Alert Instance',
          type: 'object',
        },
        number: {
          description: 'The code scanning alert number.',
          type: 'integer',
        },
        rule: {
          properties: {
            description: {
              description: 'A short description of the rule used to detect the alert.',
              type: 'string',
            },
            full_description: {
              type: 'string',
            },
            help: {
              nullable: true,
              type: 'string',
            },
            help_uri: {
              description: 'A link to the documentation for the rule used to detect the alert.',
              nullable: true,
              type: 'string',
            },
            id: {
              description: 'A unique identifier for the rule used to detect the alert.',
              type: 'string',
            },
            name: {
              type: 'string',
            },
            severity: {
              description: 'The severity of the alert.',
              enum: ['none', 'note', 'warning', 'error', null],
              nullable: true,
              type: 'string',
            },
            tags: {
              items: {
                type: 'string',
              },
              nullable: true,
              type: 'array',
            },
          },
          required: ['id', 'severity', 'description'],
          type: 'object',
        },
        state: {
          description: 'State of a code scanning alert.',
          enum: ['fixed'],
          type: 'string',
        },
        tool: {
          properties: {
            guid: {
              nullable: true,
              type: 'string',
            },
            name: {
              description: 'The name of the tool used to generate the code scanning analysis alert.',
              type: 'string',
            },
            version: {
              description: 'The version of the tool used to detect the alert.',
              nullable: true,
              type: 'string',
            },
          },
          required: ['name', 'version'],
          type: 'object',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'number',
        'created_at',
        'url',
        'html_url',
        'state',
        'dismissed_by',
        'dismissed_at',
        'dismissed_reason',
        'rule',
        'tool',
      ],
      type: 'object',
    },
    commit_oid: {
      description:
        'The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    ref: {
      description:
        'The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'ref', 'commit_oid', 'repository', 'sender'],
  title: 'code_scanning_alert fixed event',
  type: 'object',
} as const;

export const webhook_code_scanning_alert_reopenedSchema = {
  properties: {
    action: {
      enum: ['reopened'],
      type: 'string',
    },
    alert: {
      description: 'The code scanning alert involved in the event.',
      nullable: true,
      properties: {
        created_at: {
          description: 'The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`',
          format: 'date-time',
          type: 'string',
        },
        dismissed_at: {
          description: 'The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
          nullable: true,
          type: 'string',
        },
        dismissed_by: {
          nullable: true,
          type: 'object',
        },
        dismissed_reason: {
          description:
            "The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
          nullable: true,
          type: 'string',
        },
        html_url: {
          description: 'The GitHub URL of the alert resource.',
          format: 'uri',
          type: 'string',
        },
        most_recent_instance: {
          nullable: true,
          properties: {
            analysis_key: {
              description:
                'Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.',
              type: 'string',
            },
            classifications: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            commit_sha: {
              type: 'string',
            },
            environment: {
              description:
                'Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.',
              type: 'string',
            },
            location: {
              properties: {
                end_column: {
                  type: 'integer',
                },
                end_line: {
                  type: 'integer',
                },
                path: {
                  type: 'string',
                },
                start_column: {
                  type: 'integer',
                },
                start_line: {
                  type: 'integer',
                },
              },
              type: 'object',
            },
            message: {
              properties: {
                text: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            ref: {
              description: 'The full Git reference, formatted as `refs/heads/<branch name>`.',
              type: 'string',
            },
            state: {
              description: 'State of a code scanning alert.',
              enum: ['open', 'dismissed', 'fixed'],
              type: 'string',
            },
          },
          required: ['ref', 'analysis_key', 'environment', 'state'],
          title: 'Alert Instance',
          type: 'object',
        },
        number: {
          description: 'The code scanning alert number.',
          type: 'integer',
        },
        rule: {
          properties: {
            description: {
              description: 'A short description of the rule used to detect the alert.',
              type: 'string',
            },
            full_description: {
              type: 'string',
            },
            help: {
              nullable: true,
              type: 'string',
            },
            help_uri: {
              description: 'A link to the documentation for the rule used to detect the alert.',
              nullable: true,
              type: 'string',
            },
            id: {
              description: 'A unique identifier for the rule used to detect the alert.',
              type: 'string',
            },
            name: {
              type: 'string',
            },
            severity: {
              description: 'The severity of the alert.',
              enum: ['none', 'note', 'warning', 'error', null],
              nullable: true,
              type: 'string',
            },
            tags: {
              items: {
                type: 'string',
              },
              nullable: true,
              type: 'array',
            },
          },
          required: ['id', 'severity', 'description'],
          type: 'object',
        },
        state: {
          description: 'State of a code scanning alert.',
          enum: ['open', 'dismissed', 'fixed'],
          type: 'string',
        },
        tool: {
          properties: {
            guid: {
              nullable: true,
              type: 'string',
            },
            name: {
              description: 'The name of the tool used to generate the code scanning analysis alert.',
              type: 'string',
            },
            version: {
              description: 'The version of the tool used to detect the alert.',
              nullable: true,
              type: 'string',
            },
          },
          required: ['name', 'version'],
          type: 'object',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'number',
        'created_at',
        'url',
        'html_url',
        'state',
        'dismissed_by',
        'dismissed_at',
        'dismissed_reason',
        'rule',
        'tool',
      ],
      type: 'object',
    },
    commit_oid: {
      description:
        'The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      nullable: true,
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    ref: {
      description:
        'The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      nullable: true,
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'ref', 'commit_oid', 'repository', 'sender'],
  title: 'code_scanning_alert reopened event',
  type: 'object',
} as const;

export const webhook_code_scanning_alert_reopened_by_userSchema = {
  properties: {
    action: {
      enum: ['reopened_by_user'],
      type: 'string',
    },
    alert: {
      description: 'The code scanning alert involved in the event.',
      properties: {
        created_at: {
          description: 'The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`',
          format: 'date-time',
          type: 'string',
        },
        dismissed_at: {
          description: 'The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.',
          nullable: true,
        },
        dismissed_by: {
          nullable: true,
        },
        dismissed_reason: {
          description:
            "The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.",
          nullable: true,
        },
        html_url: {
          description: 'The GitHub URL of the alert resource.',
          format: 'uri',
          type: 'string',
        },
        most_recent_instance: {
          nullable: true,
          properties: {
            analysis_key: {
              description:
                'Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.',
              type: 'string',
            },
            classifications: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            commit_sha: {
              type: 'string',
            },
            environment: {
              description:
                'Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.',
              type: 'string',
            },
            location: {
              properties: {
                end_column: {
                  type: 'integer',
                },
                end_line: {
                  type: 'integer',
                },
                path: {
                  type: 'string',
                },
                start_column: {
                  type: 'integer',
                },
                start_line: {
                  type: 'integer',
                },
              },
              type: 'object',
            },
            message: {
              properties: {
                text: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            ref: {
              description: 'The full Git reference, formatted as `refs/heads/<branch name>`.',
              type: 'string',
            },
            state: {
              description: 'State of a code scanning alert.',
              enum: ['open', 'dismissed', 'fixed'],
              type: 'string',
            },
          },
          required: ['ref', 'analysis_key', 'environment', 'state'],
          title: 'Alert Instance',
          type: 'object',
        },
        number: {
          description: 'The code scanning alert number.',
          type: 'integer',
        },
        rule: {
          properties: {
            description: {
              description: 'A short description of the rule used to detect the alert.',
              type: 'string',
            },
            id: {
              description: 'A unique identifier for the rule used to detect the alert.',
              type: 'string',
            },
            severity: {
              description: 'The severity of the alert.',
              enum: ['none', 'note', 'warning', 'error', null],
              nullable: true,
              type: 'string',
            },
          },
          required: ['id', 'severity', 'description'],
          type: 'object',
        },
        state: {
          description: 'State of a code scanning alert.',
          enum: ['open', 'fixed'],
          type: 'string',
        },
        tool: {
          properties: {
            name: {
              description: 'The name of the tool used to generate the code scanning analysis alert.',
              type: 'string',
            },
            version: {
              description: 'The version of the tool used to detect the alert.',
              nullable: true,
              type: 'string',
            },
          },
          required: ['name', 'version'],
          type: 'object',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'number',
        'created_at',
        'url',
        'html_url',
        'state',
        'dismissed_by',
        'dismissed_at',
        'dismissed_reason',
        'rule',
        'tool',
      ],
      type: 'object',
    },
    commit_oid: {
      description:
        'The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    ref: {
      description:
        'The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.',
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'ref', 'commit_oid', 'repository', 'sender'],
  title: 'code_scanning_alert reopened_by_user event',
  type: 'object',
} as const;

export const webhook_commit_comment_createdSchema = {
  properties: {
    action: {
      description: 'The action performed. Can be `created`.',
      enum: ['created'],
      type: 'string',
    },
    comment: {
      description: 'The [commit comment](https://docs.github.com/rest/reference/repos#get-a-commit-comment) resource.',
      properties: {
        author_association: {
          description: 'How the author is associated with the repository.',
          enum: [
            'COLLABORATOR',
            'CONTRIBUTOR',
            'FIRST_TIMER',
            'FIRST_TIME_CONTRIBUTOR',
            'MANNEQUIN',
            'MEMBER',
            'NONE',
            'OWNER',
          ],
          title: 'AuthorAssociation',
          type: 'string',
        },
        body: {
          description: 'The text of the comment.',
          type: 'string',
        },
        commit_id: {
          description: 'The SHA of the commit to which the comment applies.',
          type: 'string',
        },
        created_at: {
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          description: 'The ID of the commit comment.',
          type: 'integer',
        },
        line: {
          description:
            'The line of the blob to which the comment applies. The last line of the range for a multi-line comment',
          nullable: true,
          type: 'integer',
        },
        node_id: {
          description: 'The node ID of the commit comment.',
          type: 'string',
        },
        path: {
          description: 'The relative path of the file to which the comment applies.',
          nullable: true,
          type: 'string',
        },
        position: {
          description: 'The line index in the diff to which the comment applies.',
          nullable: true,
          type: 'integer',
        },
        reactions: {
          properties: {
            '+1': {
              type: 'integer',
            },
            '-1': {
              type: 'integer',
            },
            confused: {
              type: 'integer',
            },
            eyes: {
              type: 'integer',
            },
            heart: {
              type: 'integer',
            },
            hooray: {
              type: 'integer',
            },
            laugh: {
              type: 'integer',
            },
            rocket: {
              type: 'integer',
            },
            total_count: {
              type: 'integer',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
          title: 'Reactions',
          type: 'object',
        },
        updated_at: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
        user: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
      },
      required: [
        'url',
        'html_url',
        'id',
        'node_id',
        'user',
        'position',
        'line',
        'path',
        'commit_id',
        'created_at',
        'updated_at',
        'author_association',
        'body',
      ],
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'comment', 'repository', 'sender'],
  title: 'commit_comment created event',
  type: 'object',
} as const;

export const webhook_configSchema = {
  description: 'Configuration object of the webhook',
  properties: {
    content_type: {
      $ref: '#/components/schemas/webhook-config-content-type',
    },
    insecure_ssl: {
      $ref: '#/components/schemas/webhook-config-insecure-ssl',
    },
    secret: {
      $ref: '#/components/schemas/webhook-config-secret',
    },
    url: {
      $ref: '#/components/schemas/webhook-config-url',
    },
  },
  title: 'Webhook Configuration',
  type: 'object',
} as const;

export const webhook_config_content_typeSchema = {
  description:
    'The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.',
  example: '"json"',
  type: 'string',
} as const;

export const webhook_config_insecure_sslSchema = {
  oneOf: [
    {
      description:
        'Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**',
      example: '"0"',
      type: 'string',
    },
    {
      type: 'number',
    },
  ],
} as const;

export const webhook_config_secretSchema = {
  description:
    'If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).',
  example: '"********"',
  type: 'string',
} as const;

export const webhook_config_urlSchema = {
  description: 'The URL to which the payloads will be delivered.',
  example: 'https://example.com/webhook',
  format: 'uri',
  type: 'string',
} as const;

export const webhook_createSchema = {
  properties: {
    description: {
      description: "The repository's current description.",
      nullable: true,
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    master_branch: {
      description: "The name of the repository's default branch (usually `main`).",
      type: 'string',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    pusher_type: {
      description: 'The pusher type for the event. Can be either `user` or a deploy key.',
      type: 'string',
    },
    ref: {
      description: 'The [`git ref`](https://docs.github.com/rest/reference/git#get-a-reference) resource.',
      type: 'string',
    },
    ref_type: {
      description: 'The type of Git ref object created in the repository.',
      enum: ['tag', 'branch'],
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['ref', 'ref_type', 'master_branch', 'description', 'pusher_type', 'repository', 'sender'],
  title: 'create event',
  type: 'object',
} as const;

export const webhook_deleteSchema = {
  properties: {
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    pusher_type: {
      description: 'The pusher type for the event. Can be either `user` or a deploy key.',
      type: 'string',
    },
    ref: {
      description: 'The [`git ref`](https://docs.github.com/rest/reference/git#get-a-reference) resource.',
      type: 'string',
    },
    ref_type: {
      description: 'The type of Git ref object deleted in the repository.',
      enum: ['tag', 'branch'],
      type: 'string',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['ref', 'ref_type', 'pusher_type', 'repository', 'sender'],
  title: 'delete event',
  type: 'object',
} as const;

export const webhook_dependabot_alert_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    alert: {
      $ref: '#/components/schemas/dependabot-alert',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'repository', 'sender'],
  title: 'Dependabot alert created event',
  type: 'object',
} as const;

export const webhook_dependabot_alert_dismissedSchema = {
  properties: {
    action: {
      enum: ['dismissed'],
      type: 'string',
    },
    alert: {
      $ref: '#/components/schemas/dependabot-alert',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'repository', 'sender'],
  title: 'Dependabot alert dismissed event',
  type: 'object',
} as const;

export const webhook_dependabot_alert_fixedSchema = {
  properties: {
    action: {
      enum: ['fixed'],
      type: 'string',
    },
    alert: {
      $ref: '#/components/schemas/dependabot-alert',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'repository', 'sender'],
  title: 'Dependabot alert fixed event',
  type: 'object',
} as const;

export const webhook_dependabot_alert_reintroducedSchema = {
  properties: {
    action: {
      enum: ['reintroduced'],
      type: 'string',
    },
    alert: {
      $ref: '#/components/schemas/dependabot-alert',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'repository', 'sender'],
  title: 'Dependabot alert reintroduced event',
  type: 'object',
} as const;

export const webhook_dependabot_alert_reopenedSchema = {
  properties: {
    action: {
      enum: ['reopened'],
      type: 'string',
    },
    alert: {
      $ref: '#/components/schemas/dependabot-alert',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'alert', 'repository', 'sender'],
  title: 'Dependabot alert reopened event',
  type: 'object',
} as const;

export const webhook_deploy_key_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    key: {
      description: 'The [`deploy key`](https://docs.github.com/rest/reference/deployments#get-a-deploy-key) resource.',
      properties: {
        added_by: {
          nullable: true,
          type: 'string',
        },
        created_at: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        key: {
          type: 'string',
        },
        last_used: {
          nullable: true,
          type: 'string',
        },
        read_only: {
          type: 'boolean',
        },
        title: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
        verified: {
          type: 'boolean',
        },
      },
      required: ['id', 'key', 'url', 'title', 'verified', 'created_at', 'read_only'],
      type: 'object',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'key', 'repository', 'sender'],
  title: 'deploy_key created event',
  type: 'object',
} as const;

export const webhook_deploy_key_deletedSchema = {
  properties: {
    action: {
      enum: ['deleted'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    key: {
      description: 'The [`deploy key`](https://docs.github.com/rest/reference/deployments#get-a-deploy-key) resource.',
      properties: {
        added_by: {
          nullable: true,
          type: 'string',
        },
        created_at: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        key: {
          type: 'string',
        },
        last_used: {
          nullable: true,
          type: 'string',
        },
        read_only: {
          type: 'boolean',
        },
        title: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
        verified: {
          type: 'boolean',
        },
      },
      required: ['id', 'key', 'url', 'title', 'verified', 'created_at', 'read_only'],
      type: 'object',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'key', 'repository', 'sender'],
  title: 'deploy_key deleted event',
  type: 'object',
} as const;

export const webhook_deployment_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    deployment: {
      description: 'The [deployment](https://docs.github.com/rest/reference/deployments#list-deployments).',
      properties: {
        created_at: {
          type: 'string',
        },
        creator: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        description: {
          nullable: true,
          type: 'string',
        },
        environment: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        original_environment: {
          type: 'string',
        },
        payload: {
          oneOf: [
            {
              type: 'object',
            },
            {
              type: 'string',
            },
          ],
        },
        performed_via_github_app: {
          description:
            'GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.',
          nullable: true,
          properties: {
            created_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            events: {
              description: 'The list of events for the GitHub app',
              items: {
                enum: [
                  'branch_protection_rule',
                  'check_run',
                  'check_suite',
                  'code_scanning_alert',
                  'commit_comment',
                  'content_reference',
                  'create',
                  'delete',
                  'deployment',
                  'deployment_review',
                  'deployment_status',
                  'deploy_key',
                  'discussion',
                  'discussion_comment',
                  'fork',
                  'gollum',
                  'issues',
                  'issue_comment',
                  'label',
                  'member',
                  'membership',
                  'milestone',
                  'organization',
                  'org_block',
                  'page_build',
                  'project',
                  'project_card',
                  'project_column',
                  'public',
                  'pull_request',
                  'pull_request_review',
                  'pull_request_review_comment',
                  'push',
                  'registry_package',
                  'release',
                  'repository',
                  'repository_dispatch',
                  'secret_scanning_alert',
                  'star',
                  'status',
                  'team',
                  'team_add',
                  'watch',
                  'workflow_dispatch',
                  'workflow_run',
                  'workflow_job',
                  'pull_request_review_thread',
                  'merge_queue_entry',
                  'secret_scanning_alert_location',
                  'merge_group',
                ],
                type: 'string',
              },
              type: 'array',
            },
            external_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              description: 'Unique identifier of the GitHub app',
              nullable: true,
              type: 'integer',
            },
            name: {
              description: 'The name of the GitHub app',
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            owner: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            permissions: {
              description: 'The set of permissions for the GitHub app',
              properties: {
                actions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                checks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                content_references: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                contents: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                deployments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                emails: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                environments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                issues: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                keys: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                members: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                metadata: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_plan: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_projects: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_self_hosted_runners: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_user_blocking: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pull_requests: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_projects: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                secret_scanning_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_events: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_scanning_alert: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                single_file: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                statuses: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                team_discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                vulnerability_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                workflows: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
              },
              type: 'object',
            },
            slug: {
              description: 'The slug name of the GitHub app',
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
          },
          required: [
            'id',
            'node_id',
            'owner',
            'name',
            'description',
            'external_url',
            'html_url',
            'created_at',
            'updated_at',
          ],
          title: 'App',
          type: 'object',
        },
        production_environment: {
          type: 'boolean',
        },
        ref: {
          type: 'string',
        },
        repository_url: {
          format: 'uri',
          type: 'string',
        },
        sha: {
          type: 'string',
        },
        statuses_url: {
          format: 'uri',
          type: 'string',
        },
        task: {
          type: 'string',
        },
        transient_environment: {
          type: 'boolean',
        },
        updated_at: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'url',
        'id',
        'node_id',
        'sha',
        'ref',
        'task',
        'payload',
        'original_environment',
        'environment',
        'description',
        'creator',
        'created_at',
        'updated_at',
        'statuses_url',
        'repository_url',
      ],
      title: 'Deployment',
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
    workflow: {
      nullable: true,
      properties: {
        badge_url: {
          format: 'uri',
          type: 'string',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        path: {
          type: 'string',
        },
        state: {
          type: 'string',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['badge_url', 'created_at', 'html_url', 'id', 'name', 'node_id', 'path', 'state', 'updated_at', 'url'],
      title: 'Workflow',
      type: 'object',
    },
    workflow_run: {
      nullable: true,
      properties: {
        actor: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        artifacts_url: {
          type: 'string',
        },
        cancel_url: {
          type: 'string',
        },
        check_suite_id: {
          type: 'integer',
        },
        check_suite_node_id: {
          type: 'string',
        },
        check_suite_url: {
          type: 'string',
        },
        conclusion: {
          enum: ['success', 'failure', 'neutral', 'cancelled', 'timed_out', 'action_required', 'stale', null],
          nullable: true,
          type: 'string',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        display_title: {
          type: 'string',
        },
        event: {
          type: 'string',
        },
        head_branch: {
          type: 'string',
        },
        head_commit: {
          nullable: true,
        },
        head_repository: {
          properties: {
            archive_url: {
              type: 'string',
            },
            assignees_url: {
              type: 'string',
            },
            blobs_url: {
              type: 'string',
            },
            branches_url: {
              type: 'string',
            },
            collaborators_url: {
              type: 'string',
            },
            comments_url: {
              type: 'string',
            },
            commits_url: {
              type: 'string',
            },
            compare_url: {
              type: 'string',
            },
            contents_url: {
              type: 'string',
            },
            contributors_url: {
              type: 'string',
            },
            deployments_url: {
              type: 'string',
            },
            description: {
              nullable: true,
            },
            downloads_url: {
              type: 'string',
            },
            events_url: {
              type: 'string',
            },
            fork: {
              type: 'boolean',
            },
            forks_url: {
              type: 'string',
            },
            full_name: {
              type: 'string',
            },
            git_commits_url: {
              type: 'string',
            },
            git_refs_url: {
              type: 'string',
            },
            git_tags_url: {
              type: 'string',
            },
            hooks_url: {
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            issue_comment_url: {
              type: 'string',
            },
            issue_events_url: {
              type: 'string',
            },
            issues_url: {
              type: 'string',
            },
            keys_url: {
              type: 'string',
            },
            labels_url: {
              type: 'string',
            },
            languages_url: {
              type: 'string',
            },
            merges_url: {
              type: 'string',
            },
            milestones_url: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            notifications_url: {
              type: 'string',
            },
            owner: {
              properties: {
                avatar_url: {
                  type: 'string',
                },
                events_url: {
                  type: 'string',
                },
                followers_url: {
                  type: 'string',
                },
                following_url: {
                  type: 'string',
                },
                gists_url: {
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  type: 'string',
                },
                received_events_url: {
                  type: 'string',
                },
                repos_url: {
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  type: 'string',
                },
                subscriptions_url: {
                  type: 'string',
                },
                type: {
                  type: 'string',
                },
                url: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            private: {
              type: 'boolean',
            },
            pulls_url: {
              type: 'string',
            },
            releases_url: {
              type: 'string',
            },
            stargazers_url: {
              type: 'string',
            },
            statuses_url: {
              type: 'string',
            },
            subscribers_url: {
              type: 'string',
            },
            subscription_url: {
              type: 'string',
            },
            tags_url: {
              type: 'string',
            },
            teams_url: {
              type: 'string',
            },
            trees_url: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          type: 'object',
        },
        head_sha: {
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        jobs_url: {
          type: 'string',
        },
        logs_url: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        path: {
          type: 'string',
        },
        previous_attempt_url: {
          nullable: true,
        },
        pull_requests: {
          items: {
            properties: {
              base: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              head: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              id: {
                type: 'integer',
              },
              number: {
                type: 'integer',
              },
              url: {
                format: 'uri',
                type: 'string',
              },
            },
            required: ['url', 'id', 'number', 'head', 'base'],
            title: 'Check Run Pull Request',
            type: 'object',
          },
          type: 'array',
        },
        referenced_workflows: {
          items: {
            properties: {
              path: {
                type: 'string',
              },
              ref: {
                type: 'string',
              },
              sha: {
                type: 'string',
              },
            },
            required: ['path', 'sha'],
            type: 'object',
          },
          nullable: true,
          type: 'array',
        },
        repository: {
          properties: {
            archive_url: {
              type: 'string',
            },
            assignees_url: {
              type: 'string',
            },
            blobs_url: {
              type: 'string',
            },
            branches_url: {
              type: 'string',
            },
            collaborators_url: {
              type: 'string',
            },
            comments_url: {
              type: 'string',
            },
            commits_url: {
              type: 'string',
            },
            compare_url: {
              type: 'string',
            },
            contents_url: {
              type: 'string',
            },
            contributors_url: {
              type: 'string',
            },
            deployments_url: {
              type: 'string',
            },
            description: {
              nullable: true,
            },
            downloads_url: {
              type: 'string',
            },
            events_url: {
              type: 'string',
            },
            fork: {
              type: 'boolean',
            },
            forks_url: {
              type: 'string',
            },
            full_name: {
              type: 'string',
            },
            git_commits_url: {
              type: 'string',
            },
            git_refs_url: {
              type: 'string',
            },
            git_tags_url: {
              type: 'string',
            },
            hooks_url: {
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            issue_comment_url: {
              type: 'string',
            },
            issue_events_url: {
              type: 'string',
            },
            issues_url: {
              type: 'string',
            },
            keys_url: {
              type: 'string',
            },
            labels_url: {
              type: 'string',
            },
            languages_url: {
              type: 'string',
            },
            merges_url: {
              type: 'string',
            },
            milestones_url: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            notifications_url: {
              type: 'string',
            },
            owner: {
              properties: {
                avatar_url: {
                  type: 'string',
                },
                events_url: {
                  type: 'string',
                },
                followers_url: {
                  type: 'string',
                },
                following_url: {
                  type: 'string',
                },
                gists_url: {
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  type: 'string',
                },
                received_events_url: {
                  type: 'string',
                },
                repos_url: {
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  type: 'string',
                },
                subscriptions_url: {
                  type: 'string',
                },
                type: {
                  type: 'string',
                },
                url: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            private: {
              type: 'boolean',
            },
            pulls_url: {
              type: 'string',
            },
            releases_url: {
              type: 'string',
            },
            stargazers_url: {
              type: 'string',
            },
            statuses_url: {
              type: 'string',
            },
            subscribers_url: {
              type: 'string',
            },
            subscription_url: {
              type: 'string',
            },
            tags_url: {
              type: 'string',
            },
            teams_url: {
              type: 'string',
            },
            trees_url: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          type: 'object',
        },
        rerun_url: {
          type: 'string',
        },
        run_attempt: {
          type: 'integer',
        },
        run_number: {
          type: 'integer',
        },
        run_started_at: {
          format: 'date-time',
          type: 'string',
        },
        status: {
          enum: ['requested', 'in_progress', 'completed', 'queued', 'waiting', 'pending'],
          type: 'string',
        },
        triggering_actor: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
        workflow_id: {
          type: 'integer',
        },
        workflow_url: {
          type: 'string',
        },
      },
      required: [
        'id',
        'name',
        'node_id',
        'head_branch',
        'head_sha',
        'run_number',
        'event',
        'status',
        'conclusion',
        'workflow_id',
        'check_suite_id',
        'check_suite_node_id',
        'url',
        'html_url',
        'path',
        'pull_requests',
        'created_at',
        'updated_at',
        'actor',
        'run_attempt',
        'run_started_at',
        'display_title',
      ],
      title: 'Deployment Workflow Run',
      type: 'object',
    },
  },
  required: ['action', 'deployment', 'workflow', 'workflow_run', 'repository', 'sender'],
  title: 'deployment created event',
  type: 'object',
} as const;

export const webhook_deployment_status_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    check_run: {
      nullable: true,
      properties: {
        completed_at: {
          format: 'date-time',
          nullable: true,
          type: 'string',
        },
        conclusion: {
          description:
            'The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.',
          enum: [
            'success',
            'failure',
            'neutral',
            'cancelled',
            'timed_out',
            'action_required',
            'stale',
            'skipped',
            null,
          ],
          nullable: true,
          type: 'string',
        },
        details_url: {
          format: 'uri',
          type: 'string',
        },
        external_id: {
          type: 'string',
        },
        head_sha: {
          description: 'The SHA of the commit that is being checked.',
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          description: 'The id of the check.',
          type: 'integer',
        },
        name: {
          description: 'The name of the check run.',
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        started_at: {
          format: 'date-time',
          type: 'string',
        },
        status: {
          description: 'The current status of the check run. Can be `queued`, `in_progress`, or `completed`.',
          enum: ['queued', 'in_progress', 'completed', 'waiting', 'pending'],
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'id',
        'name',
        'node_id',
        'head_sha',
        'external_id',
        'url',
        'html_url',
        'details_url',
        'status',
        'conclusion',
        'started_at',
        'completed_at',
      ],
      type: 'object',
    },
    deployment: {
      description: 'The [deployment](https://docs.github.com/rest/reference/deployments#list-deployments).',
      properties: {
        created_at: {
          type: 'string',
        },
        creator: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        description: {
          nullable: true,
          type: 'string',
        },
        environment: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        original_environment: {
          type: 'string',
        },
        payload: {
          nullable: true,
          oneOf: [
            {
              type: 'string',
            },
            {
              type: 'object',
            },
          ],
        },
        performed_via_github_app: {
          description:
            'GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.',
          nullable: true,
          properties: {
            created_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            events: {
              description: 'The list of events for the GitHub app',
              items: {
                enum: [
                  'branch_protection_rule',
                  'check_run',
                  'check_suite',
                  'code_scanning_alert',
                  'commit_comment',
                  'content_reference',
                  'create',
                  'delete',
                  'deployment',
                  'deployment_review',
                  'deployment_status',
                  'deploy_key',
                  'discussion',
                  'discussion_comment',
                  'fork',
                  'gollum',
                  'issues',
                  'issue_comment',
                  'label',
                  'member',
                  'membership',
                  'milestone',
                  'organization',
                  'org_block',
                  'page_build',
                  'project',
                  'project_card',
                  'project_column',
                  'public',
                  'pull_request',
                  'pull_request_review',
                  'pull_request_review_comment',
                  'push',
                  'registry_package',
                  'release',
                  'repository',
                  'repository_dispatch',
                  'secret_scanning_alert',
                  'star',
                  'status',
                  'team',
                  'team_add',
                  'watch',
                  'workflow_dispatch',
                  'workflow_run',
                  'merge_queue_entry',
                  'workflow_job',
                  'pull_request_review_thread',
                  'secret_scanning_alert_location',
                  'merge_group',
                ],
                type: 'string',
              },
              type: 'array',
            },
            external_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              description: 'Unique identifier of the GitHub app',
              nullable: true,
              type: 'integer',
            },
            name: {
              description: 'The name of the GitHub app',
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            owner: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            permissions: {
              description: 'The set of permissions for the GitHub app',
              properties: {
                actions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                checks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                content_references: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                contents: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                deployments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                emails: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                environments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                issues: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                keys: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                members: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                metadata: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_plan: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_projects: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_self_hosted_runners: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_user_blocking: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pull_requests: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_projects: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                secret_scanning_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_events: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_scanning_alert: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                single_file: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                statuses: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                team_discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                vulnerability_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                workflows: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
              },
              type: 'object',
            },
            slug: {
              description: 'The slug name of the GitHub app',
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
          },
          required: [
            'id',
            'node_id',
            'owner',
            'name',
            'description',
            'external_url',
            'html_url',
            'created_at',
            'updated_at',
          ],
          title: 'App',
          type: 'object',
        },
        production_environment: {
          type: 'boolean',
        },
        ref: {
          type: 'string',
        },
        repository_url: {
          format: 'uri',
          type: 'string',
        },
        sha: {
          type: 'string',
        },
        statuses_url: {
          format: 'uri',
          type: 'string',
        },
        task: {
          type: 'string',
        },
        transient_environment: {
          type: 'boolean',
        },
        updated_at: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'url',
        'id',
        'node_id',
        'sha',
        'ref',
        'task',
        'payload',
        'original_environment',
        'environment',
        'description',
        'creator',
        'created_at',
        'updated_at',
        'statuses_url',
        'repository_url',
      ],
      title: 'Deployment',
      type: 'object',
    },
    deployment_status: {
      description:
        'The [deployment status](https://docs.github.com/rest/reference/deployments#list-deployment-statuses).',
      properties: {
        created_at: {
          type: 'string',
        },
        creator: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        deployment_url: {
          format: 'uri',
          type: 'string',
        },
        description: {
          description: 'The optional human-readable description added to the status.',
          type: 'string',
        },
        environment: {
          type: 'string',
        },
        environment_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        log_url: {
          format: 'uri',
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        performed_via_github_app: {
          description:
            'GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.',
          nullable: true,
          properties: {
            created_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            events: {
              description: 'The list of events for the GitHub app',
              items: {
                enum: [
                  'branch_protection_rule',
                  'check_run',
                  'check_suite',
                  'code_scanning_alert',
                  'commit_comment',
                  'content_reference',
                  'create',
                  'delete',
                  'deployment',
                  'deployment_review',
                  'deployment_status',
                  'deploy_key',
                  'discussion',
                  'discussion_comment',
                  'fork',
                  'gollum',
                  'issues',
                  'issue_comment',
                  'label',
                  'member',
                  'membership',
                  'milestone',
                  'organization',
                  'org_block',
                  'page_build',
                  'project',
                  'project_card',
                  'project_column',
                  'public',
                  'pull_request',
                  'pull_request_review',
                  'pull_request_review_comment',
                  'push',
                  'registry_package',
                  'release',
                  'repository',
                  'repository_dispatch',
                  'secret_scanning_alert',
                  'star',
                  'status',
                  'team',
                  'team_add',
                  'watch',
                  'workflow_dispatch',
                  'workflow_run',
                  'pull_request_review_thread',
                  'merge_queue_entry',
                  'workflow_job',
                  'merge_group',
                  'secret_scanning_alert_location',
                ],
                type: 'string',
              },
              type: 'array',
            },
            external_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              description: 'Unique identifier of the GitHub app',
              nullable: true,
              type: 'integer',
            },
            name: {
              description: 'The name of the GitHub app',
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            owner: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            permissions: {
              description: 'The set of permissions for the GitHub app',
              properties: {
                actions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                checks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                content_references: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                contents: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                deployments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                emails: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                environments: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                issues: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                keys: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                members: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                metadata: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_administration: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_plan: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_projects: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_self_hosted_runners: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                organization_user_blocking: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                packages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pages: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                pull_requests: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_hooks: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                repository_projects: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                secret_scanning_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                secrets: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_events: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                security_scanning_alert: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                single_file: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                statuses: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                team_discussions: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                vulnerability_alerts: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
                workflows: {
                  enum: ['read', 'write'],
                  type: 'string',
                },
              },
              type: 'object',
            },
            slug: {
              description: 'The slug name of the GitHub app',
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              nullable: true,
              type: 'string',
            },
          },
          required: [
            'id',
            'node_id',
            'owner',
            'name',
            'description',
            'external_url',
            'html_url',
            'created_at',
            'updated_at',
          ],
          title: 'App',
          type: 'object',
        },
        repository_url: {
          format: 'uri',
          type: 'string',
        },
        state: {
          description: 'The new state. Can be `pending`, `success`, `failure`, or `error`.',
          type: 'string',
        },
        target_url: {
          description: 'The optional link added to the status.',
          type: 'string',
        },
        updated_at: {
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: [
        'url',
        'id',
        'node_id',
        'state',
        'creator',
        'description',
        'environment',
        'target_url',
        'created_at',
        'updated_at',
        'deployment_url',
        'repository_url',
      ],
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
    workflow: {
      nullable: true,
      properties: {
        badge_url: {
          format: 'uri',
          type: 'string',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        path: {
          type: 'string',
        },
        state: {
          type: 'string',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['badge_url', 'created_at', 'html_url', 'id', 'name', 'node_id', 'path', 'state', 'updated_at', 'url'],
      title: 'Workflow',
      type: 'object',
    },
    workflow_run: {
      nullable: true,
      properties: {
        actor: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        artifacts_url: {
          type: 'string',
        },
        cancel_url: {
          type: 'string',
        },
        check_suite_id: {
          type: 'integer',
        },
        check_suite_node_id: {
          type: 'string',
        },
        check_suite_url: {
          type: 'string',
        },
        conclusion: {
          enum: [
            'success',
            'failure',
            'neutral',
            'cancelled',
            'timed_out',
            'action_required',
            'stale',
            null,
            'startup_failure',
          ],
          nullable: true,
          type: 'string',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        display_title: {
          type: 'string',
        },
        event: {
          type: 'string',
        },
        head_branch: {
          type: 'string',
        },
        head_commit: {
          nullable: true,
        },
        head_repository: {
          properties: {
            archive_url: {
              type: 'string',
            },
            assignees_url: {
              type: 'string',
            },
            blobs_url: {
              type: 'string',
            },
            branches_url: {
              type: 'string',
            },
            collaborators_url: {
              type: 'string',
            },
            comments_url: {
              type: 'string',
            },
            commits_url: {
              type: 'string',
            },
            compare_url: {
              type: 'string',
            },
            contents_url: {
              type: 'string',
            },
            contributors_url: {
              type: 'string',
            },
            deployments_url: {
              type: 'string',
            },
            description: {
              nullable: true,
            },
            downloads_url: {
              type: 'string',
            },
            events_url: {
              type: 'string',
            },
            fork: {
              type: 'boolean',
            },
            forks_url: {
              type: 'string',
            },
            full_name: {
              type: 'string',
            },
            git_commits_url: {
              type: 'string',
            },
            git_refs_url: {
              type: 'string',
            },
            git_tags_url: {
              type: 'string',
            },
            hooks_url: {
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            issue_comment_url: {
              type: 'string',
            },
            issue_events_url: {
              type: 'string',
            },
            issues_url: {
              type: 'string',
            },
            keys_url: {
              type: 'string',
            },
            labels_url: {
              type: 'string',
            },
            languages_url: {
              type: 'string',
            },
            merges_url: {
              type: 'string',
            },
            milestones_url: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            notifications_url: {
              type: 'string',
            },
            owner: {
              properties: {
                avatar_url: {
                  type: 'string',
                },
                events_url: {
                  type: 'string',
                },
                followers_url: {
                  type: 'string',
                },
                following_url: {
                  type: 'string',
                },
                gists_url: {
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  type: 'string',
                },
                received_events_url: {
                  type: 'string',
                },
                repos_url: {
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  type: 'string',
                },
                subscriptions_url: {
                  type: 'string',
                },
                type: {
                  type: 'string',
                },
                url: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            private: {
              type: 'boolean',
            },
            pulls_url: {
              type: 'string',
            },
            releases_url: {
              type: 'string',
            },
            stargazers_url: {
              type: 'string',
            },
            statuses_url: {
              type: 'string',
            },
            subscribers_url: {
              type: 'string',
            },
            subscription_url: {
              type: 'string',
            },
            tags_url: {
              type: 'string',
            },
            teams_url: {
              type: 'string',
            },
            trees_url: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          type: 'object',
        },
        head_sha: {
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        jobs_url: {
          type: 'string',
        },
        logs_url: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        path: {
          type: 'string',
        },
        previous_attempt_url: {
          nullable: true,
        },
        pull_requests: {
          items: {
            properties: {
              base: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              head: {
                properties: {
                  ref: {
                    type: 'string',
                  },
                  repo: {
                    properties: {
                      id: {
                        type: 'integer',
                      },
                      name: {
                        type: 'string',
                      },
                      url: {
                        format: 'uri',
                        type: 'string',
                      },
                    },
                    required: ['id', 'url', 'name'],
                    title: 'Repo Ref',
                    type: 'object',
                  },
                  sha: {
                    type: 'string',
                  },
                },
                required: ['ref', 'sha', 'repo'],
                type: 'object',
              },
              id: {
                type: 'integer',
              },
              number: {
                type: 'integer',
              },
              url: {
                format: 'uri',
                type: 'string',
              },
            },
            required: ['url', 'id', 'number', 'head', 'base'],
            title: 'Check Run Pull Request',
            type: 'object',
          },
          type: 'array',
        },
        referenced_workflows: {
          items: {
            properties: {
              path: {
                type: 'string',
              },
              ref: {
                type: 'string',
              },
              sha: {
                type: 'string',
              },
            },
            required: ['path', 'sha'],
            type: 'object',
          },
          nullable: true,
          type: 'array',
        },
        repository: {
          properties: {
            archive_url: {
              type: 'string',
            },
            assignees_url: {
              type: 'string',
            },
            blobs_url: {
              type: 'string',
            },
            branches_url: {
              type: 'string',
            },
            collaborators_url: {
              type: 'string',
            },
            comments_url: {
              type: 'string',
            },
            commits_url: {
              type: 'string',
            },
            compare_url: {
              type: 'string',
            },
            contents_url: {
              type: 'string',
            },
            contributors_url: {
              type: 'string',
            },
            deployments_url: {
              type: 'string',
            },
            description: {
              nullable: true,
            },
            downloads_url: {
              type: 'string',
            },
            events_url: {
              type: 'string',
            },
            fork: {
              type: 'boolean',
            },
            forks_url: {
              type: 'string',
            },
            full_name: {
              type: 'string',
            },
            git_commits_url: {
              type: 'string',
            },
            git_refs_url: {
              type: 'string',
            },
            git_tags_url: {
              type: 'string',
            },
            hooks_url: {
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            issue_comment_url: {
              type: 'string',
            },
            issue_events_url: {
              type: 'string',
            },
            issues_url: {
              type: 'string',
            },
            keys_url: {
              type: 'string',
            },
            labels_url: {
              type: 'string',
            },
            languages_url: {
              type: 'string',
            },
            merges_url: {
              type: 'string',
            },
            milestones_url: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            notifications_url: {
              type: 'string',
            },
            owner: {
              properties: {
                avatar_url: {
                  type: 'string',
                },
                events_url: {
                  type: 'string',
                },
                followers_url: {
                  type: 'string',
                },
                following_url: {
                  type: 'string',
                },
                gists_url: {
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  type: 'string',
                },
                received_events_url: {
                  type: 'string',
                },
                repos_url: {
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  type: 'string',
                },
                subscriptions_url: {
                  type: 'string',
                },
                type: {
                  type: 'string',
                },
                url: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            private: {
              type: 'boolean',
            },
            pulls_url: {
              type: 'string',
            },
            releases_url: {
              type: 'string',
            },
            stargazers_url: {
              type: 'string',
            },
            statuses_url: {
              type: 'string',
            },
            subscribers_url: {
              type: 'string',
            },
            subscription_url: {
              type: 'string',
            },
            tags_url: {
              type: 'string',
            },
            teams_url: {
              type: 'string',
            },
            trees_url: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
          },
          type: 'object',
        },
        rerun_url: {
          type: 'string',
        },
        run_attempt: {
          type: 'integer',
        },
        run_number: {
          type: 'integer',
        },
        run_started_at: {
          format: 'date-time',
          type: 'string',
        },
        status: {
          enum: ['requested', 'in_progress', 'completed', 'queued', 'waiting', 'pending'],
          type: 'string',
        },
        triggering_actor: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
        workflow_id: {
          type: 'integer',
        },
        workflow_url: {
          type: 'string',
        },
      },
      required: [
        'id',
        'name',
        'node_id',
        'head_branch',
        'head_sha',
        'run_number',
        'event',
        'status',
        'conclusion',
        'workflow_id',
        'check_suite_id',
        'check_suite_node_id',
        'url',
        'html_url',
        'path',
        'pull_requests',
        'created_at',
        'updated_at',
        'actor',
        'triggering_actor',
        'run_attempt',
        'run_started_at',
        'display_title',
      ],
      title: 'Deployment Workflow Run',
      type: 'object',
    },
  },
  required: ['action', 'deployment_status', 'deployment', 'repository', 'sender'],
  title: 'deployment_status created event',
  type: 'object',
} as const;

export const webhook_discussion_answeredSchema = {
  properties: {
    action: {
      enum: ['answered'],
      type: 'string',
    },
    answer: {
      properties: {
        author_association: {
          description: 'How the author is associated with the repository.',
          enum: [
            'COLLABORATOR',
            'CONTRIBUTOR',
            'FIRST_TIMER',
            'FIRST_TIME_CONTRIBUTOR',
            'MANNEQUIN',
            'MEMBER',
            'NONE',
            'OWNER',
          ],
          title: 'AuthorAssociation',
          type: 'string',
        },
        body: {
          type: 'string',
        },
        child_comment_count: {
          type: 'integer',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        discussion_id: {
          type: 'integer',
        },
        html_url: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        parent_id: {
          nullable: true,
        },
        reactions: {
          properties: {
            '+1': {
              type: 'integer',
            },
            '-1': {
              type: 'integer',
            },
            confused: {
              type: 'integer',
            },
            eyes: {
              type: 'integer',
            },
            heart: {
              type: 'integer',
            },
            hooray: {
              type: 'integer',
            },
            laugh: {
              type: 'integer',
            },
            rocket: {
              type: 'integer',
            },
            total_count: {
              type: 'integer',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
          title: 'Reactions',
          type: 'object',
        },
        repository_url: {
          type: 'string',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        user: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
      },
      required: [
        'id',
        'node_id',
        'html_url',
        'parent_id',
        'child_comment_count',
        'repository_url',
        'discussion_id',
        'author_association',
        'user',
        'created_at',
        'updated_at',
        'body',
      ],
      type: 'object',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'answer', 'repository', 'sender'],
  title: 'discussion answered event',
  type: 'object',
} as const;

export const webhook_discussion_category_changedSchema = {
  properties: {
    action: {
      enum: ['category_changed'],
      type: 'string',
    },
    changes: {
      properties: {
        category: {
          properties: {
            from: {
              properties: {
                created_at: {
                  format: 'date-time',
                  type: 'string',
                },
                description: {
                  type: 'string',
                },
                emoji: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                is_answerable: {
                  type: 'boolean',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                repository_id: {
                  type: 'integer',
                },
                slug: {
                  type: 'string',
                },
                updated_at: {
                  type: 'string',
                },
              },
              required: [
                'id',
                'repository_id',
                'emoji',
                'name',
                'description',
                'created_at',
                'updated_at',
                'slug',
                'is_answerable',
              ],
              type: 'object',
            },
          },
          required: ['from'],
          type: 'object',
        },
      },
      required: ['category'],
      type: 'object',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'changes', 'discussion', 'repository', 'sender'],
  title: 'discussion category changed event',
  type: 'object',
} as const;

export const webhook_discussion_comment_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    comment: {
      properties: {
        author_association: {
          description: 'How the author is associated with the repository.',
          enum: [
            'COLLABORATOR',
            'CONTRIBUTOR',
            'FIRST_TIMER',
            'FIRST_TIME_CONTRIBUTOR',
            'MANNEQUIN',
            'MEMBER',
            'NONE',
            'OWNER',
          ],
          title: 'AuthorAssociation',
          type: 'string',
        },
        body: {
          type: 'string',
        },
        child_comment_count: {
          type: 'integer',
        },
        created_at: {
          type: 'string',
        },
        discussion_id: {
          type: 'integer',
        },
        html_url: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        parent_id: {
          nullable: true,
          type: 'integer',
        },
        reactions: {
          properties: {
            '+1': {
              type: 'integer',
            },
            '-1': {
              type: 'integer',
            },
            confused: {
              type: 'integer',
            },
            eyes: {
              type: 'integer',
            },
            heart: {
              type: 'integer',
            },
            hooray: {
              type: 'integer',
            },
            laugh: {
              type: 'integer',
            },
            rocket: {
              type: 'integer',
            },
            total_count: {
              type: 'integer',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
          title: 'Reactions',
          type: 'object',
        },
        repository_url: {
          type: 'string',
        },
        updated_at: {
          type: 'string',
        },
        user: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
      },
      required: [
        'id',
        'node_id',
        'html_url',
        'parent_id',
        'child_comment_count',
        'repository_url',
        'discussion_id',
        'author_association',
        'user',
        'created_at',
        'updated_at',
        'body',
        'reactions',
      ],
      type: 'object',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'comment', 'discussion', 'repository', 'sender'],
  title: 'discussion_comment created event',
  type: 'object',
} as const;

export const webhook_discussion_comment_deletedSchema = {
  properties: {
    action: {
      enum: ['deleted'],
      type: 'string',
    },
    comment: {
      properties: {
        author_association: {
          description: 'How the author is associated with the repository.',
          enum: [
            'COLLABORATOR',
            'CONTRIBUTOR',
            'FIRST_TIMER',
            'FIRST_TIME_CONTRIBUTOR',
            'MANNEQUIN',
            'MEMBER',
            'NONE',
            'OWNER',
          ],
          title: 'AuthorAssociation',
          type: 'string',
        },
        body: {
          type: 'string',
        },
        child_comment_count: {
          type: 'integer',
        },
        created_at: {
          type: 'string',
        },
        discussion_id: {
          type: 'integer',
        },
        html_url: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        parent_id: {
          nullable: true,
          type: 'integer',
        },
        reactions: {
          properties: {
            '+1': {
              type: 'integer',
            },
            '-1': {
              type: 'integer',
            },
            confused: {
              type: 'integer',
            },
            eyes: {
              type: 'integer',
            },
            heart: {
              type: 'integer',
            },
            hooray: {
              type: 'integer',
            },
            laugh: {
              type: 'integer',
            },
            rocket: {
              type: 'integer',
            },
            total_count: {
              type: 'integer',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
          title: 'Reactions',
          type: 'object',
        },
        repository_url: {
          type: 'string',
        },
        updated_at: {
          type: 'string',
        },
        user: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
      },
      required: [
        'id',
        'node_id',
        'html_url',
        'parent_id',
        'child_comment_count',
        'repository_url',
        'discussion_id',
        'author_association',
        'user',
        'created_at',
        'updated_at',
        'body',
        'reactions',
      ],
      type: 'object',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'comment', 'discussion', 'repository', 'sender'],
  title: 'discussion_comment deleted event',
  type: 'object',
} as const;

export const webhook_discussion_comment_editedSchema = {
  properties: {
    action: {
      enum: ['edited'],
      type: 'string',
    },
    changes: {
      properties: {
        body: {
          properties: {
            from: {
              type: 'string',
            },
          },
          required: ['from'],
          type: 'object',
        },
      },
      required: ['body'],
      type: 'object',
    },
    comment: {
      properties: {
        author_association: {
          description: 'How the author is associated with the repository.',
          enum: [
            'COLLABORATOR',
            'CONTRIBUTOR',
            'FIRST_TIMER',
            'FIRST_TIME_CONTRIBUTOR',
            'MANNEQUIN',
            'MEMBER',
            'NONE',
            'OWNER',
          ],
          title: 'AuthorAssociation',
          type: 'string',
        },
        body: {
          type: 'string',
        },
        child_comment_count: {
          type: 'integer',
        },
        created_at: {
          type: 'string',
        },
        discussion_id: {
          type: 'integer',
        },
        html_url: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        parent_id: {
          nullable: true,
          type: 'integer',
        },
        reactions: {
          properties: {
            '+1': {
              type: 'integer',
            },
            '-1': {
              type: 'integer',
            },
            confused: {
              type: 'integer',
            },
            eyes: {
              type: 'integer',
            },
            heart: {
              type: 'integer',
            },
            hooray: {
              type: 'integer',
            },
            laugh: {
              type: 'integer',
            },
            rocket: {
              type: 'integer',
            },
            total_count: {
              type: 'integer',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
          title: 'Reactions',
          type: 'object',
        },
        repository_url: {
          type: 'string',
        },
        updated_at: {
          type: 'string',
        },
        user: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
      },
      required: [
        'id',
        'node_id',
        'html_url',
        'parent_id',
        'child_comment_count',
        'repository_url',
        'discussion_id',
        'author_association',
        'user',
        'created_at',
        'updated_at',
        'body',
        'reactions',
      ],
      type: 'object',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'changes', 'comment', 'discussion', 'repository', 'sender'],
  title: 'discussion_comment edited event',
  type: 'object',
} as const;

export const webhook_discussion_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    discussion: {
      allOf: [
        {
          properties: {
            active_lock_reason: {
              nullable: true,
              type: 'string',
            },
            answer_chosen_at: {
              nullable: true,
              type: 'string',
            },
            answer_chosen_by: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            answer_html_url: {
              nullable: true,
              type: 'string',
            },
            author_association: {
              description: 'How the author is associated with the repository.',
              enum: [
                'COLLABORATOR',
                'CONTRIBUTOR',
                'FIRST_TIMER',
                'FIRST_TIME_CONTRIBUTOR',
                'MANNEQUIN',
                'MEMBER',
                'NONE',
                'OWNER',
              ],
              title: 'AuthorAssociation',
              type: 'string',
            },
            body: {
              nullable: true,
              type: 'string',
            },
            category: {
              properties: {
                created_at: {
                  format: 'date-time',
                  type: 'string',
                },
                description: {
                  type: 'string',
                },
                emoji: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                is_answerable: {
                  type: 'boolean',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                repository_id: {
                  type: 'integer',
                },
                slug: {
                  type: 'string',
                },
                updated_at: {
                  type: 'string',
                },
              },
              required: [
                'id',
                'repository_id',
                'emoji',
                'name',
                'description',
                'created_at',
                'updated_at',
                'slug',
                'is_answerable',
              ],
              type: 'object',
            },
            comments: {
              type: 'integer',
            },
            created_at: {
              format: 'date-time',
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            locked: {
              type: 'boolean',
            },
            node_id: {
              type: 'string',
            },
            number: {
              type: 'integer',
            },
            reactions: {
              properties: {
                '+1': {
                  type: 'integer',
                },
                '-1': {
                  type: 'integer',
                },
                confused: {
                  type: 'integer',
                },
                eyes: {
                  type: 'integer',
                },
                heart: {
                  type: 'integer',
                },
                hooray: {
                  type: 'integer',
                },
                laugh: {
                  type: 'integer',
                },
                rocket: {
                  type: 'integer',
                },
                total_count: {
                  type: 'integer',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
              title: 'Reactions',
              type: 'object',
            },
            repository_url: {
              type: 'string',
            },
            state: {
              enum: ['open', 'locked', 'converting', 'transferring'],
              type: 'string',
            },
            timeline_url: {
              type: 'string',
            },
            title: {
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              type: 'string',
            },
            user: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
          },
          required: [
            'repository_url',
            'category',
            'answer_html_url',
            'answer_chosen_at',
            'answer_chosen_by',
            'html_url',
            'id',
            'node_id',
            'number',
            'title',
            'user',
            'state',
            'locked',
            'comments',
            'created_at',
            'updated_at',
            'author_association',
            'active_lock_reason',
            'body',
          ],
          title: 'Discussion',
          type: 'object',
        },
        {
          properties: {
            active_lock_reason: {
              nullable: true,
            },
            answer_chosen_at: {
              nullable: true,
            },
            answer_chosen_by: {
              nullable: true,
            },
            answer_html_url: {
              nullable: true,
              type: 'string',
            },
            author_association: {
              type: 'string',
            },
            body: {
              nullable: true,
              type: 'string',
            },
            category: {
              properties: {
                created_at: {
                  type: 'string',
                },
                description: {
                  type: 'string',
                },
                emoji: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                is_answerable: {
                  type: 'boolean',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                repository_id: {
                  type: 'integer',
                },
                slug: {
                  type: 'string',
                },
                updated_at: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            comments: {
              type: 'integer',
            },
            created_at: {
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            locked: {
              enum: [false],
              type: 'boolean',
            },
            node_id: {
              type: 'string',
            },
            number: {
              type: 'integer',
            },
            reactions: {
              properties: {
                '+1': {
                  type: 'integer',
                },
                '-1': {
                  type: 'integer',
                },
                confused: {
                  type: 'integer',
                },
                eyes: {
                  type: 'integer',
                },
                heart: {
                  type: 'integer',
                },
                hooray: {
                  type: 'integer',
                },
                laugh: {
                  type: 'integer',
                },
                rocket: {
                  type: 'integer',
                },
                total_count: {
                  type: 'integer',
                },
                url: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            repository_url: {
              type: 'string',
            },
            state: {
              enum: ['open', 'converting', 'transferring'],
              type: 'string',
            },
            timeline_url: {
              type: 'string',
            },
            title: {
              type: 'string',
            },
            updated_at: {
              type: 'string',
            },
            user: {
              properties: {
                avatar_url: {
                  type: 'string',
                },
                events_url: {
                  type: 'string',
                },
                followers_url: {
                  type: 'string',
                },
                following_url: {
                  type: 'string',
                },
                gists_url: {
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  type: 'string',
                },
                received_events_url: {
                  type: 'string',
                },
                repos_url: {
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  type: 'string',
                },
                subscriptions_url: {
                  type: 'string',
                },
                type: {
                  type: 'string',
                },
                url: {
                  type: 'string',
                },
              },
              type: 'object',
            },
          },
          required: ['state', 'locked', 'answer_html_url', 'answer_chosen_at', 'answer_chosen_by'],
          type: 'object',
        },
      ],
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'repository', 'sender'],
  title: 'discussion created event',
  type: 'object',
} as const;

export const webhook_discussion_deletedSchema = {
  properties: {
    action: {
      enum: ['deleted'],
      type: 'string',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'repository', 'sender'],
  title: 'discussion deleted event',
  type: 'object',
} as const;

export const webhook_discussion_editedSchema = {
  properties: {
    action: {
      enum: ['edited'],
      type: 'string',
    },
    changes: {
      properties: {
        body: {
          properties: {
            from: {
              type: 'string',
            },
          },
          required: ['from'],
          type: 'object',
        },
        title: {
          properties: {
            from: {
              type: 'string',
            },
          },
          required: ['from'],
          type: 'object',
        },
      },
      type: 'object',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'repository', 'sender'],
  title: 'discussion edited event',
  type: 'object',
} as const;

export const webhook_discussion_labeledSchema = {
  properties: {
    action: {
      enum: ['labeled'],
      type: 'string',
    },
    discussion: {
      properties: {
        active_lock_reason: {
          nullable: true,
          type: 'string',
        },
        answer_chosen_at: {
          nullable: true,
          type: 'string',
        },
        answer_chosen_by: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
        answer_html_url: {
          nullable: true,
          type: 'string',
        },
        author_association: {
          description: 'How the author is associated with the repository.',
          enum: [
            'COLLABORATOR',
            'CONTRIBUTOR',
            'FIRST_TIMER',
            'FIRST_TIME_CONTRIBUTOR',
            'MANNEQUIN',
            'MEMBER',
            'NONE',
            'OWNER',
          ],
          title: 'AuthorAssociation',
          type: 'string',
        },
        body: {
          nullable: true,
          type: 'string',
        },
        category: {
          properties: {
            created_at: {
              format: 'date-time',
              type: 'string',
            },
            description: {
              type: 'string',
            },
            emoji: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            is_answerable: {
              type: 'boolean',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            repository_id: {
              type: 'integer',
            },
            slug: {
              type: 'string',
            },
            updated_at: {
              type: 'string',
            },
          },
          required: [
            'id',
            'repository_id',
            'emoji',
            'name',
            'description',
            'created_at',
            'updated_at',
            'slug',
            'is_answerable',
          ],
          type: 'object',
        },
        comments: {
          type: 'integer',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        html_url: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        locked: {
          type: 'boolean',
        },
        node_id: {
          type: 'string',
        },
        number: {
          type: 'integer',
        },
        reactions: {
          properties: {
            '+1': {
              type: 'integer',
            },
            '-1': {
              type: 'integer',
            },
            confused: {
              type: 'integer',
            },
            eyes: {
              type: 'integer',
            },
            heart: {
              type: 'integer',
            },
            hooray: {
              type: 'integer',
            },
            laugh: {
              type: 'integer',
            },
            rocket: {
              type: 'integer',
            },
            total_count: {
              type: 'integer',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
          title: 'Reactions',
          type: 'object',
        },
        repository_url: {
          type: 'string',
        },
        state: {
          enum: ['open', 'locked', 'converting', 'transferring'],
          type: 'string',
        },
        timeline_url: {
          type: 'string',
        },
        title: {
          type: 'string',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        user: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
      },
      required: [
        'repository_url',
        'category',
        'answer_html_url',
        'answer_chosen_at',
        'answer_chosen_by',
        'html_url',
        'id',
        'node_id',
        'number',
        'title',
        'user',
        'state',
        'locked',
        'comments',
        'created_at',
        'updated_at',
        'author_association',
        'active_lock_reason',
        'body',
      ],
      title: 'Discussion',
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    label: {
      properties: {
        color: {
          description: '6-character hex code, without the leading #, identifying the color',
          type: 'string',
        },
        default: {
          type: 'boolean',
        },
        description: {
          nullable: true,
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        name: {
          description: 'The name of the label.',
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        url: {
          description: 'URL for the label',
          format: 'uri',
          type: 'string',
        },
      },
      required: ['id', 'node_id', 'url', 'name', 'color', 'default', 'description'],
      title: 'Label',
      type: 'object',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'label', 'repository', 'sender'],
  title: 'discussion labeled event',
  type: 'object',
} as const;

export const webhook_discussion_lockedSchema = {
  properties: {
    action: {
      enum: ['locked'],
      type: 'string',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'repository', 'sender'],
  title: 'discussion locked event',
  type: 'object',
} as const;

export const webhook_discussion_pinnedSchema = {
  properties: {
    action: {
      enum: ['pinned'],
      type: 'string',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'repository', 'sender'],
  title: 'discussion pinned event',
  type: 'object',
} as const;

export const webhook_discussion_transferredSchema = {
  properties: {
    action: {
      enum: ['transferred'],
      type: 'string',
    },
    changes: {
      properties: {
        new_discussion: {
          properties: {
            active_lock_reason: {
              nullable: true,
              type: 'string',
            },
            answer_chosen_at: {
              nullable: true,
              type: 'string',
            },
            answer_chosen_by: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            answer_html_url: {
              nullable: true,
              type: 'string',
            },
            author_association: {
              description: 'How the author is associated with the repository.',
              enum: [
                'COLLABORATOR',
                'CONTRIBUTOR',
                'FIRST_TIMER',
                'FIRST_TIME_CONTRIBUTOR',
                'MANNEQUIN',
                'MEMBER',
                'NONE',
                'OWNER',
              ],
              title: 'AuthorAssociation',
              type: 'string',
            },
            body: {
              type: 'string',
            },
            category: {
              properties: {
                created_at: {
                  format: 'date-time',
                  type: 'string',
                },
                description: {
                  type: 'string',
                },
                emoji: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                is_answerable: {
                  type: 'boolean',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                repository_id: {
                  type: 'integer',
                },
                slug: {
                  type: 'string',
                },
                updated_at: {
                  type: 'string',
                },
              },
              required: [
                'id',
                'repository_id',
                'emoji',
                'name',
                'description',
                'created_at',
                'updated_at',
                'slug',
                'is_answerable',
              ],
              type: 'object',
            },
            comments: {
              type: 'integer',
            },
            created_at: {
              format: 'date-time',
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            locked: {
              type: 'boolean',
            },
            node_id: {
              type: 'string',
            },
            number: {
              type: 'integer',
            },
            reactions: {
              properties: {
                '+1': {
                  type: 'integer',
                },
                '-1': {
                  type: 'integer',
                },
                confused: {
                  type: 'integer',
                },
                eyes: {
                  type: 'integer',
                },
                heart: {
                  type: 'integer',
                },
                hooray: {
                  type: 'integer',
                },
                laugh: {
                  type: 'integer',
                },
                rocket: {
                  type: 'integer',
                },
                total_count: {
                  type: 'integer',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
              title: 'Reactions',
              type: 'object',
            },
            repository_url: {
              type: 'string',
            },
            state: {
              enum: ['open', 'locked', 'converting', 'transferring'],
              type: 'string',
            },
            timeline_url: {
              type: 'string',
            },
            title: {
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              type: 'string',
            },
            user: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
          },
          required: [
            'repository_url',
            'category',
            'answer_html_url',
            'answer_chosen_at',
            'answer_chosen_by',
            'html_url',
            'id',
            'node_id',
            'number',
            'title',
            'user',
            'state',
            'locked',
            'comments',
            'created_at',
            'updated_at',
            'author_association',
            'active_lock_reason',
            'body',
          ],
          title: 'Discussion',
          type: 'object',
        },
        new_repository: {
          description: 'A git repository',
          properties: {
            allow_auto_merge: {
              default: false,
              description: 'Whether to allow auto-merge for pull requests.',
              type: 'boolean',
            },
            allow_forking: {
              description: 'Whether to allow private forks',
              type: 'boolean',
            },
            allow_merge_commit: {
              default: true,
              description: 'Whether to allow merge commits for pull requests.',
              type: 'boolean',
            },
            allow_rebase_merge: {
              default: true,
              description: 'Whether to allow rebase merges for pull requests.',
              type: 'boolean',
            },
            allow_squash_merge: {
              default: true,
              description: 'Whether to allow squash merges for pull requests.',
              type: 'boolean',
            },
            allow_update_branch: {
              type: 'boolean',
            },
            archive_url: {
              format: 'uri-template',
              type: 'string',
            },
            archived: {
              default: false,
              description: 'Whether the repository is archived.',
              type: 'boolean',
            },
            assignees_url: {
              format: 'uri-template',
              type: 'string',
            },
            blobs_url: {
              format: 'uri-template',
              type: 'string',
            },
            branches_url: {
              format: 'uri-template',
              type: 'string',
            },
            clone_url: {
              format: 'uri',
              type: 'string',
            },
            collaborators_url: {
              format: 'uri-template',
              type: 'string',
            },
            comments_url: {
              format: 'uri-template',
              type: 'string',
            },
            commits_url: {
              format: 'uri-template',
              type: 'string',
            },
            compare_url: {
              format: 'uri-template',
              type: 'string',
            },
            contents_url: {
              format: 'uri-template',
              type: 'string',
            },
            contributors_url: {
              format: 'uri',
              type: 'string',
            },
            created_at: {
              oneOf: [
                {
                  type: 'integer',
                },
                {
                  format: 'date-time',
                  type: 'string',
                },
              ],
            },
            default_branch: {
              description: 'The default branch of the repository.',
              type: 'string',
            },
            delete_branch_on_merge: {
              default: false,
              description: 'Whether to delete head branches when pull requests are merged',
              type: 'boolean',
            },
            deployments_url: {
              format: 'uri',
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            disabled: {
              description: 'Returns whether or not this repository is disabled.',
              type: 'boolean',
            },
            downloads_url: {
              format: 'uri',
              type: 'string',
            },
            events_url: {
              format: 'uri',
              type: 'string',
            },
            fork: {
              type: 'boolean',
            },
            forks: {
              type: 'integer',
            },
            forks_count: {
              type: 'integer',
            },
            forks_url: {
              format: 'uri',
              type: 'string',
            },
            full_name: {
              type: 'string',
            },
            git_commits_url: {
              format: 'uri-template',
              type: 'string',
            },
            git_refs_url: {
              format: 'uri-template',
              type: 'string',
            },
            git_tags_url: {
              format: 'uri-template',
              type: 'string',
            },
            git_url: {
              format: 'uri',
              type: 'string',
            },
            has_discussions: {
              default: false,
              description: 'Whether discussions are enabled.',
              type: 'boolean',
            },
            has_downloads: {
              default: true,
              description: 'Whether downloads are enabled.',
              type: 'boolean',
            },
            has_issues: {
              default: true,
              description: 'Whether issues are enabled.',
              type: 'boolean',
            },
            has_pages: {
              type: 'boolean',
            },
            has_projects: {
              default: true,
              description: 'Whether projects are enabled.',
              type: 'boolean',
            },
            has_wiki: {
              default: true,
              description: 'Whether the wiki is enabled.',
              type: 'boolean',
            },
            homepage: {
              nullable: true,
              type: 'string',
            },
            hooks_url: {
              format: 'uri',
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              description: 'Unique identifier of the repository',
              type: 'integer',
            },
            is_template: {
              type: 'boolean',
            },
            issue_comment_url: {
              format: 'uri-template',
              type: 'string',
            },
            issue_events_url: {
              format: 'uri-template',
              type: 'string',
            },
            issues_url: {
              format: 'uri-template',
              type: 'string',
            },
            keys_url: {
              format: 'uri-template',
              type: 'string',
            },
            labels_url: {
              format: 'uri-template',
              type: 'string',
            },
            language: {
              nullable: true,
              type: 'string',
            },
            languages_url: {
              format: 'uri',
              type: 'string',
            },
            license: {
              nullable: true,
              properties: {
                key: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                spdx_id: {
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  nullable: true,
                  type: 'string',
                },
              },
              required: ['key', 'name', 'spdx_id', 'url', 'node_id'],
              title: 'License',
              type: 'object',
            },
            master_branch: {
              type: 'string',
            },
            merges_url: {
              format: 'uri',
              type: 'string',
            },
            milestones_url: {
              format: 'uri-template',
              type: 'string',
            },
            mirror_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            name: {
              description: 'The name of the repository.',
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            notifications_url: {
              format: 'uri-template',
              type: 'string',
            },
            open_issues: {
              type: 'integer',
            },
            open_issues_count: {
              type: 'integer',
            },
            organization: {
              type: 'string',
            },
            owner: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            permissions: {
              properties: {
                admin: {
                  type: 'boolean',
                },
                maintain: {
                  type: 'boolean',
                },
                pull: {
                  type: 'boolean',
                },
                push: {
                  type: 'boolean',
                },
                triage: {
                  type: 'boolean',
                },
              },
              required: ['pull', 'push', 'admin'],
              type: 'object',
            },
            private: {
              description: 'Whether the repository is private or public.',
              type: 'boolean',
            },
            public: {
              type: 'boolean',
            },
            pulls_url: {
              format: 'uri-template',
              type: 'string',
            },
            pushed_at: {
              nullable: true,
              oneOf: [
                {
                  type: 'integer',
                },
                {
                  format: 'date-time',
                  type: 'string',
                },
              ],
            },
            releases_url: {
              format: 'uri-template',
              type: 'string',
            },
            role_name: {
              nullable: true,
              type: 'string',
            },
            size: {
              type: 'integer',
            },
            ssh_url: {
              type: 'string',
            },
            stargazers: {
              type: 'integer',
            },
            stargazers_count: {
              type: 'integer',
            },
            stargazers_url: {
              format: 'uri',
              type: 'string',
            },
            statuses_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscribers_url: {
              format: 'uri',
              type: 'string',
            },
            subscription_url: {
              format: 'uri',
              type: 'string',
            },
            svn_url: {
              format: 'uri',
              type: 'string',
            },
            tags_url: {
              format: 'uri',
              type: 'string',
            },
            teams_url: {
              format: 'uri',
              type: 'string',
            },
            topics: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            trees_url: {
              format: 'uri-template',
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
            visibility: {
              enum: ['public', 'private', 'internal'],
              type: 'string',
            },
            watchers: {
              type: 'integer',
            },
            watchers_count: {
              type: 'integer',
            },
            web_commit_signoff_required: {
              description: 'Whether to require contributors to sign off on web-based commits',
              type: 'boolean',
            },
          },
          required: [
            'id',
            'node_id',
            'name',
            'full_name',
            'private',
            'owner',
            'html_url',
            'description',
            'fork',
            'url',
            'forks_url',
            'keys_url',
            'collaborators_url',
            'teams_url',
            'hooks_url',
            'issue_events_url',
            'events_url',
            'assignees_url',
            'branches_url',
            'tags_url',
            'blobs_url',
            'git_tags_url',
            'git_refs_url',
            'trees_url',
            'statuses_url',
            'languages_url',
            'stargazers_url',
            'contributors_url',
            'subscribers_url',
            'subscription_url',
            'commits_url',
            'git_commits_url',
            'comments_url',
            'issue_comment_url',
            'contents_url',
            'compare_url',
            'merges_url',
            'archive_url',
            'downloads_url',
            'issues_url',
            'pulls_url',
            'milestones_url',
            'notifications_url',
            'labels_url',
            'releases_url',
            'deployments_url',
            'created_at',
            'updated_at',
            'pushed_at',
            'git_url',
            'ssh_url',
            'clone_url',
            'svn_url',
            'homepage',
            'size',
            'stargazers_count',
            'watchers_count',
            'language',
            'has_issues',
            'has_projects',
            'has_downloads',
            'has_wiki',
            'has_pages',
            'has_discussions',
            'forks_count',
            'mirror_url',
            'archived',
            'open_issues_count',
            'license',
            'forks',
            'open_issues',
            'watchers',
            'default_branch',
            'topics',
            'visibility',
          ],
          title: 'Repository',
          type: 'object',
        },
      },
      required: ['new_discussion', 'new_repository'],
      type: 'object',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'changes', 'discussion', 'repository', 'sender'],
  title: 'discussion transferred event',
  type: 'object',
} as const;

export const webhook_discussion_unansweredSchema = {
  properties: {
    action: {
      enum: ['unanswered'],
      type: 'string',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    old_answer: {
      properties: {
        author_association: {
          description: 'How the author is associated with the repository.',
          enum: [
            'COLLABORATOR',
            'CONTRIBUTOR',
            'FIRST_TIMER',
            'FIRST_TIME_CONTRIBUTOR',
            'MANNEQUIN',
            'MEMBER',
            'NONE',
            'OWNER',
          ],
          title: 'AuthorAssociation',
          type: 'string',
        },
        body: {
          type: 'string',
        },
        child_comment_count: {
          type: 'integer',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        discussion_id: {
          type: 'integer',
        },
        html_url: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        node_id: {
          type: 'string',
        },
        parent_id: {
          nullable: true,
        },
        reactions: {
          properties: {
            '+1': {
              type: 'integer',
            },
            '-1': {
              type: 'integer',
            },
            confused: {
              type: 'integer',
            },
            eyes: {
              type: 'integer',
            },
            heart: {
              type: 'integer',
            },
            hooray: {
              type: 'integer',
            },
            laugh: {
              type: 'integer',
            },
            rocket: {
              type: 'integer',
            },
            total_count: {
              type: 'integer',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
          title: 'Reactions',
          type: 'object',
        },
        repository_url: {
          type: 'string',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        user: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
      },
      required: [
        'id',
        'node_id',
        'html_url',
        'parent_id',
        'child_comment_count',
        'repository_url',
        'discussion_id',
        'author_association',
        'user',
        'created_at',
        'updated_at',
        'body',
      ],
      type: 'object',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'old_answer', 'repository'],
  title: 'discussion unanswered event',
  type: 'object',
} as const;

export const webhook_discussion_unlabeledSchema = {
  properties: {
    action: {
      enum: ['unlabeled'],
      type: 'string',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    label: {
      properties: {
        color: {
          description: '6-character hex code, without the leading #, identifying the color',
          type: 'string',
        },
        default: {
          type: 'boolean',
        },
        description: {
          nullable: true,
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        name: {
          description: 'The name of the label.',
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        url: {
          description: 'URL for the label',
          format: 'uri',
          type: 'string',
        },
      },
      required: ['id', 'node_id', 'url', 'name', 'color', 'default', 'description'],
      title: 'Label',
      type: 'object',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'label', 'repository', 'sender'],
  title: 'discussion unlabeled event',
  type: 'object',
} as const;

export const webhook_discussion_unlockedSchema = {
  properties: {
    action: {
      enum: ['unlocked'],
      type: 'string',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'repository', 'sender'],
  title: 'discussion unlocked event',
  type: 'object',
} as const;

export const webhook_discussion_unpinnedSchema = {
  properties: {
    action: {
      enum: ['unpinned'],
      type: 'string',
    },
    discussion: {
      $ref: '#/components/schemas/discussion',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'discussion', 'repository', 'sender'],
  title: 'discussion unpinned event',
  type: 'object',
} as const;

export const webhook_forkSchema = {
  description: 'A user forks a repository.',
  properties: {
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    forkee: {
      allOf: [
        {
          description: 'A git repository',
          properties: {
            allow_auto_merge: {
              default: false,
              description: 'Whether to allow auto-merge for pull requests.',
              type: 'boolean',
            },
            allow_forking: {
              description: 'Whether to allow private forks',
              type: 'boolean',
            },
            allow_merge_commit: {
              default: true,
              description: 'Whether to allow merge commits for pull requests.',
              type: 'boolean',
            },
            allow_rebase_merge: {
              default: true,
              description: 'Whether to allow rebase merges for pull requests.',
              type: 'boolean',
            },
            allow_squash_merge: {
              default: true,
              description: 'Whether to allow squash merges for pull requests.',
              type: 'boolean',
            },
            allow_update_branch: {
              type: 'boolean',
            },
            archive_url: {
              format: 'uri-template',
              type: 'string',
            },
            archived: {
              default: false,
              description: 'Whether the repository is archived.',
              type: 'boolean',
            },
            assignees_url: {
              format: 'uri-template',
              type: 'string',
            },
            blobs_url: {
              format: 'uri-template',
              type: 'string',
            },
            branches_url: {
              format: 'uri-template',
              type: 'string',
            },
            clone_url: {
              format: 'uri',
              type: 'string',
            },
            collaborators_url: {
              format: 'uri-template',
              type: 'string',
            },
            comments_url: {
              format: 'uri-template',
              type: 'string',
            },
            commits_url: {
              format: 'uri-template',
              type: 'string',
            },
            compare_url: {
              format: 'uri-template',
              type: 'string',
            },
            contents_url: {
              format: 'uri-template',
              type: 'string',
            },
            contributors_url: {
              format: 'uri',
              type: 'string',
            },
            created_at: {
              oneOf: [
                {
                  type: 'integer',
                },
                {
                  format: 'date-time',
                  type: 'string',
                },
              ],
            },
            default_branch: {
              description: 'The default branch of the repository.',
              type: 'string',
            },
            delete_branch_on_merge: {
              default: false,
              description: 'Whether to delete head branches when pull requests are merged',
              type: 'boolean',
            },
            deployments_url: {
              format: 'uri',
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            disabled: {
              description: 'Returns whether or not this repository is disabled.',
              type: 'boolean',
            },
            downloads_url: {
              format: 'uri',
              type: 'string',
            },
            events_url: {
              format: 'uri',
              type: 'string',
            },
            fork: {
              type: 'boolean',
            },
            forks: {
              type: 'integer',
            },
            forks_count: {
              type: 'integer',
            },
            forks_url: {
              format: 'uri',
              type: 'string',
            },
            full_name: {
              type: 'string',
            },
            git_commits_url: {
              format: 'uri-template',
              type: 'string',
            },
            git_refs_url: {
              format: 'uri-template',
              type: 'string',
            },
            git_tags_url: {
              format: 'uri-template',
              type: 'string',
            },
            git_url: {
              format: 'uri',
              type: 'string',
            },
            has_downloads: {
              default: true,
              description: 'Whether downloads are enabled.',
              type: 'boolean',
            },
            has_issues: {
              default: true,
              description: 'Whether issues are enabled.',
              type: 'boolean',
            },
            has_pages: {
              type: 'boolean',
            },
            has_projects: {
              default: true,
              description: 'Whether projects are enabled.',
              type: 'boolean',
            },
            has_wiki: {
              default: true,
              description: 'Whether the wiki is enabled.',
              type: 'boolean',
            },
            homepage: {
              nullable: true,
              type: 'string',
            },
            hooks_url: {
              format: 'uri',
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              description: 'Unique identifier of the repository',
              type: 'integer',
            },
            is_template: {
              type: 'boolean',
            },
            issue_comment_url: {
              format: 'uri-template',
              type: 'string',
            },
            issue_events_url: {
              format: 'uri-template',
              type: 'string',
            },
            issues_url: {
              format: 'uri-template',
              type: 'string',
            },
            keys_url: {
              format: 'uri-template',
              type: 'string',
            },
            labels_url: {
              format: 'uri-template',
              type: 'string',
            },
            language: {
              nullable: true,
              type: 'string',
            },
            languages_url: {
              format: 'uri',
              type: 'string',
            },
            license: {
              nullable: true,
              properties: {
                key: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                spdx_id: {
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  nullable: true,
                  type: 'string',
                },
              },
              required: ['key', 'name', 'spdx_id', 'url', 'node_id'],
              title: 'License',
              type: 'object',
            },
            master_branch: {
              type: 'string',
            },
            merges_url: {
              format: 'uri',
              type: 'string',
            },
            milestones_url: {
              format: 'uri-template',
              type: 'string',
            },
            mirror_url: {
              format: 'uri',
              nullable: true,
              type: 'string',
            },
            name: {
              description: 'The name of the repository.',
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            notifications_url: {
              format: 'uri-template',
              type: 'string',
            },
            open_issues: {
              type: 'integer',
            },
            open_issues_count: {
              type: 'integer',
            },
            organization: {
              type: 'string',
            },
            owner: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  format: 'uri',
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                name: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  format: 'uri',
                  type: 'string',
                },
                received_events_url: {
                  format: 'uri',
                  type: 'string',
                },
                repos_url: {
                  format: 'uri',
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                subscriptions_url: {
                  format: 'uri',
                  type: 'string',
                },
                type: {
                  enum: ['Bot', 'User', 'Organization'],
                  type: 'string',
                },
                url: {
                  format: 'uri',
                  type: 'string',
                },
              },
              required: ['login', 'id'],
              title: 'User',
              type: 'object',
            },
            permissions: {
              properties: {
                admin: {
                  type: 'boolean',
                },
                maintain: {
                  type: 'boolean',
                },
                pull: {
                  type: 'boolean',
                },
                push: {
                  type: 'boolean',
                },
                triage: {
                  type: 'boolean',
                },
              },
              required: ['pull', 'push', 'admin'],
              type: 'object',
            },
            private: {
              description: 'Whether the repository is private or public.',
              type: 'boolean',
            },
            public: {
              type: 'boolean',
            },
            pulls_url: {
              format: 'uri-template',
              type: 'string',
            },
            pushed_at: {
              nullable: true,
              oneOf: [
                {
                  type: 'integer',
                },
                {
                  format: 'date-time',
                  type: 'string',
                },
              ],
            },
            releases_url: {
              format: 'uri-template',
              type: 'string',
            },
            role_name: {
              nullable: true,
              type: 'string',
            },
            size: {
              type: 'integer',
            },
            ssh_url: {
              type: 'string',
            },
            stargazers: {
              type: 'integer',
            },
            stargazers_count: {
              type: 'integer',
            },
            stargazers_url: {
              format: 'uri',
              type: 'string',
            },
            statuses_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscribers_url: {
              format: 'uri',
              type: 'string',
            },
            subscription_url: {
              format: 'uri',
              type: 'string',
            },
            svn_url: {
              format: 'uri',
              type: 'string',
            },
            tags_url: {
              format: 'uri',
              type: 'string',
            },
            teams_url: {
              format: 'uri',
              type: 'string',
            },
            topics: {
              items: {
                type: 'string',
              },
              type: 'array',
            },
            trees_url: {
              format: 'uri-template',
              type: 'string',
            },
            updated_at: {
              format: 'date-time',
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
            visibility: {
              enum: ['public', 'private', 'internal'],
              type: 'string',
            },
            watchers: {
              type: 'integer',
            },
            watchers_count: {
              type: 'integer',
            },
            web_commit_signoff_required: {
              description: 'Whether to require contributors to sign off on web-based commits',
              type: 'boolean',
            },
          },
          required: [
            'id',
            'node_id',
            'name',
            'full_name',
            'private',
            'owner',
            'html_url',
            'description',
            'fork',
            'url',
            'forks_url',
            'keys_url',
            'collaborators_url',
            'teams_url',
            'hooks_url',
            'issue_events_url',
            'events_url',
            'assignees_url',
            'branches_url',
            'tags_url',
            'blobs_url',
            'git_tags_url',
            'git_refs_url',
            'trees_url',
            'statuses_url',
            'languages_url',
            'stargazers_url',
            'contributors_url',
            'subscribers_url',
            'subscription_url',
            'commits_url',
            'git_commits_url',
            'comments_url',
            'issue_comment_url',
            'contents_url',
            'compare_url',
            'merges_url',
            'archive_url',
            'downloads_url',
            'issues_url',
            'pulls_url',
            'milestones_url',
            'notifications_url',
            'labels_url',
            'releases_url',
            'deployments_url',
            'created_at',
            'updated_at',
            'pushed_at',
            'git_url',
            'ssh_url',
            'clone_url',
            'svn_url',
            'homepage',
            'size',
            'stargazers_count',
            'watchers_count',
            'language',
            'has_issues',
            'has_projects',
            'has_downloads',
            'has_wiki',
            'has_pages',
            'forks_count',
            'mirror_url',
            'archived',
            'open_issues_count',
            'license',
            'forks',
            'open_issues',
            'watchers',
            'default_branch',
            'topics',
            'visibility',
          ],
          title: 'Repository',
          type: 'object',
        },
        {
          properties: {
            allow_forking: {
              type: 'boolean',
            },
            archive_url: {
              type: 'string',
            },
            archived: {
              type: 'boolean',
            },
            assignees_url: {
              type: 'string',
            },
            blobs_url: {
              type: 'string',
            },
            branches_url: {
              type: 'string',
            },
            clone_url: {
              type: 'string',
            },
            collaborators_url: {
              type: 'string',
            },
            comments_url: {
              type: 'string',
            },
            commits_url: {
              type: 'string',
            },
            compare_url: {
              type: 'string',
            },
            contents_url: {
              type: 'string',
            },
            contributors_url: {
              type: 'string',
            },
            created_at: {
              type: 'string',
            },
            default_branch: {
              type: 'string',
            },
            deployments_url: {
              type: 'string',
            },
            description: {
              nullable: true,
              type: 'string',
            },
            disabled: {
              type: 'boolean',
            },
            downloads_url: {
              type: 'string',
            },
            events_url: {
              type: 'string',
            },
            fork: {
              enum: [true],
              type: 'boolean',
            },
            forks: {
              type: 'integer',
            },
            forks_count: {
              type: 'integer',
            },
            forks_url: {
              type: 'string',
            },
            full_name: {
              type: 'string',
            },
            git_commits_url: {
              type: 'string',
            },
            git_refs_url: {
              type: 'string',
            },
            git_tags_url: {
              type: 'string',
            },
            git_url: {
              type: 'string',
            },
            has_downloads: {
              type: 'boolean',
            },
            has_issues: {
              type: 'boolean',
            },
            has_pages: {
              type: 'boolean',
            },
            has_projects: {
              type: 'boolean',
            },
            has_wiki: {
              type: 'boolean',
            },
            homepage: {
              nullable: true,
              type: 'string',
            },
            hooks_url: {
              type: 'string',
            },
            html_url: {
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            is_template: {
              type: 'boolean',
            },
            issue_comment_url: {
              type: 'string',
            },
            issue_events_url: {
              type: 'string',
            },
            issues_url: {
              type: 'string',
            },
            keys_url: {
              type: 'string',
            },
            labels_url: {
              type: 'string',
            },
            language: {
              nullable: true,
            },
            languages_url: {
              type: 'string',
            },
            license: {
              nullable: true,
              type: 'object',
            },
            merges_url: {
              type: 'string',
            },
            milestones_url: {
              type: 'string',
            },
            mirror_url: {
              nullable: true,
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            notifications_url: {
              type: 'string',
            },
            open_issues: {
              type: 'integer',
            },
            open_issues_count: {
              type: 'integer',
            },
            owner: {
              properties: {
                avatar_url: {
                  type: 'string',
                },
                events_url: {
                  type: 'string',
                },
                followers_url: {
                  type: 'string',
                },
                following_url: {
                  type: 'string',
                },
                gists_url: {
                  type: 'string',
                },
                gravatar_id: {
                  type: 'string',
                },
                html_url: {
                  type: 'string',
                },
                id: {
                  type: 'integer',
                },
                login: {
                  type: 'string',
                },
                node_id: {
                  type: 'string',
                },
                organizations_url: {
                  type: 'string',
                },
                received_events_url: {
                  type: 'string',
                },
                repos_url: {
                  type: 'string',
                },
                site_admin: {
                  type: 'boolean',
                },
                starred_url: {
                  type: 'string',
                },
                subscriptions_url: {
                  type: 'string',
                },
                type: {
                  type: 'string',
                },
                url: {
                  type: 'string',
                },
              },
              type: 'object',
            },
            private: {
              type: 'boolean',
            },
            public: {
              type: 'boolean',
            },
            pulls_url: {
              type: 'string',
            },
            pushed_at: {
              type: 'string',
            },
            releases_url: {
              type: 'string',
            },
            size: {
              type: 'integer',
            },
            ssh_url: {
              type: 'string',
            },
            stargazers_count: {
              type: 'integer',
            },
            stargazers_url: {
              type: 'string',
            },
            statuses_url: {
              type: 'string',
            },
            subscribers_url: {
              type: 'string',
            },
            subscription_url: {
              type: 'string',
            },
            svn_url: {
              type: 'string',
            },
            tags_url: {
              type: 'string',
            },
            teams_url: {
              type: 'string',
            },
            topics: {
              items: {
                nullable: true,
              },
              type: 'array',
            },
            trees_url: {
              type: 'string',
            },
            updated_at: {
              type: 'string',
            },
            url: {
              type: 'string',
            },
            visibility: {
              type: 'string',
            },
            watchers: {
              type: 'integer',
            },
            watchers_count: {
              type: 'integer',
            },
          },
          type: 'object',
        },
      ],
      description:
        'The created [`repository`](https://docs.github.com/rest/reference/repos#get-a-repository) resource.',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['forkee', 'repository', 'sender'],
  title: 'fork event',
  type: 'object',
} as const;

export const webhook_github_app_authorization_revokedSchema = {
  properties: {
    action: {
      enum: ['revoked'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'sender'],
  title: 'github_app_authorization revoked event',
  type: 'object',
} as const;

export const webhook_gollumSchema = {
  properties: {
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    pages: {
      description: 'The pages that were updated.',
      items: {
        properties: {
          action: {
            description: 'The action that was performed on the page. Can be `created` or `edited`.',
            enum: ['created', 'edited'],
            type: 'string',
          },
          html_url: {
            description: 'Points to the HTML wiki page.',
            format: 'uri',
            type: 'string',
          },
          page_name: {
            description: 'The name of the page.',
            type: 'string',
          },
          sha: {
            description: 'The latest commit SHA of the page.',
            type: 'string',
          },
          summary: {
            nullable: true,
            type: 'string',
          },
          title: {
            description: 'The current page title.',
            type: 'string',
          },
        },
        required: ['page_name', 'title', 'summary', 'action', 'sha', 'html_url'],
        type: 'object',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['pages', 'repository', 'sender'],
  title: 'gollum event',
  type: 'object',
} as const;

export const webhook_installation_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repositories: {
      description: 'An array of repository objects that the installation can access.',
      items: {
        properties: {
          full_name: {
            type: 'string',
          },
          id: {
            description: 'Unique identifier of the repository',
            type: 'integer',
          },
          name: {
            description: 'The name of the repository.',
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          private: {
            description: 'Whether the repository is private or public.',
            type: 'boolean',
          },
        },
        required: ['id', 'node_id', 'name', 'full_name', 'private'],
        type: 'object',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    requester: {
      nullable: true,
      properties: {
        avatar_url: {
          format: 'uri',
          type: 'string',
        },
        deleted: {
          type: 'boolean',
        },
        email: {
          nullable: true,
          type: 'string',
        },
        events_url: {
          format: 'uri-template',
          type: 'string',
        },
        followers_url: {
          format: 'uri',
          type: 'string',
        },
        following_url: {
          format: 'uri-template',
          type: 'string',
        },
        gists_url: {
          format: 'uri-template',
          type: 'string',
        },
        gravatar_id: {
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        login: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        organizations_url: {
          format: 'uri',
          type: 'string',
        },
        received_events_url: {
          format: 'uri',
          type: 'string',
        },
        repos_url: {
          format: 'uri',
          type: 'string',
        },
        site_admin: {
          type: 'boolean',
        },
        starred_url: {
          format: 'uri-template',
          type: 'string',
        },
        subscriptions_url: {
          format: 'uri',
          type: 'string',
        },
        type: {
          enum: ['Bot', 'User', 'Organization'],
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['login', 'id'],
      title: 'User',
      type: 'object',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'installation', 'sender'],
  title: 'installation created event',
  type: 'object',
} as const;

export const webhook_installation_deletedSchema = {
  properties: {
    action: {
      enum: ['deleted'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repositories: {
      description: 'An array of repository objects that the installation can access.',
      items: {
        properties: {
          full_name: {
            type: 'string',
          },
          id: {
            description: 'Unique identifier of the repository',
            type: 'integer',
          },
          name: {
            description: 'The name of the repository.',
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          private: {
            description: 'Whether the repository is private or public.',
            type: 'boolean',
          },
        },
        required: ['id', 'node_id', 'name', 'full_name', 'private'],
        type: 'object',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    requester: {
      nullable: true,
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'installation', 'sender'],
  title: 'installation deleted event',
  type: 'object',
} as const;

export const webhook_installation_new_permissions_acceptedSchema = {
  properties: {
    action: {
      enum: ['new_permissions_accepted'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repositories: {
      description: 'An array of repository objects that the installation can access.',
      items: {
        properties: {
          full_name: {
            type: 'string',
          },
          id: {
            description: 'Unique identifier of the repository',
            type: 'integer',
          },
          name: {
            description: 'The name of the repository.',
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          private: {
            description: 'Whether the repository is private or public.',
            type: 'boolean',
          },
        },
        required: ['id', 'node_id', 'name', 'full_name', 'private'],
        type: 'object',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    requester: {
      nullable: true,
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'installation', 'sender'],
  title: 'installation new_permissions_accepted event',
  type: 'object',
} as const;

export const webhook_installation_repositories_addedSchema = {
  properties: {
    action: {
      enum: ['added'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repositories_added: {
      description: 'An array of repository objects, which were added to the installation.',
      items: {
        properties: {
          full_name: {
            type: 'string',
          },
          id: {
            description: 'Unique identifier of the repository',
            type: 'integer',
          },
          name: {
            description: 'The name of the repository.',
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          private: {
            description: 'Whether the repository is private or public.',
            type: 'boolean',
          },
        },
        required: ['id', 'node_id', 'name', 'full_name', 'private'],
        type: 'object',
      },
      type: 'array',
    },
    repositories_removed: {
      description: 'An array of repository objects, which were removed from the installation.',
      items: {
        properties: {
          full_name: {
            type: 'string',
          },
          id: {
            description: 'Unique identifier of the repository',
            type: 'integer',
          },
          name: {
            description: 'The name of the repository.',
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          private: {
            description: 'Whether the repository is private or public.',
            type: 'boolean',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    repository_selection: {
      description: "Describe whether all repositories have been selected or there's a selection involved",
      enum: ['all', 'selected'],
      type: 'string',
    },
    requester: {
      nullable: true,
      properties: {
        avatar_url: {
          format: 'uri',
          type: 'string',
        },
        deleted: {
          type: 'boolean',
        },
        email: {
          nullable: true,
          type: 'string',
        },
        events_url: {
          format: 'uri-template',
          type: 'string',
        },
        followers_url: {
          format: 'uri',
          type: 'string',
        },
        following_url: {
          format: 'uri-template',
          type: 'string',
        },
        gists_url: {
          format: 'uri-template',
          type: 'string',
        },
        gravatar_id: {
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        login: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        organizations_url: {
          format: 'uri',
          type: 'string',
        },
        received_events_url: {
          format: 'uri',
          type: 'string',
        },
        repos_url: {
          format: 'uri',
          type: 'string',
        },
        site_admin: {
          type: 'boolean',
        },
        starred_url: {
          format: 'uri-template',
          type: 'string',
        },
        subscriptions_url: {
          format: 'uri',
          type: 'string',
        },
        type: {
          enum: ['Bot', 'User', 'Organization'],
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['login', 'id'],
      title: 'User',
      type: 'object',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: [
    'action',
    'installation',
    'repository_selection',
    'repositories_added',
    'repositories_removed',
    'requester',
    'sender',
  ],
  title: 'installation_repositories added event',
  type: 'object',
} as const;

export const webhook_installation_repositories_removedSchema = {
  properties: {
    action: {
      enum: ['removed'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repositories_added: {
      description: 'An array of repository objects, which were added to the installation.',
      items: {
        properties: {
          full_name: {
            type: 'string',
          },
          id: {
            description: 'Unique identifier of the repository',
            type: 'integer',
          },
          name: {
            description: 'The name of the repository.',
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          private: {
            description: 'Whether the repository is private or public.',
            type: 'boolean',
          },
        },
        required: ['id', 'node_id', 'name', 'full_name', 'private'],
        type: 'object',
      },
      type: 'array',
    },
    repositories_removed: {
      description: 'An array of repository objects, which were removed from the installation.',
      items: {
        properties: {
          full_name: {
            type: 'string',
          },
          id: {
            description: 'Unique identifier of the repository',
            type: 'integer',
          },
          name: {
            description: 'The name of the repository.',
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          private: {
            description: 'Whether the repository is private or public.',
            type: 'boolean',
          },
        },
        required: ['id', 'node_id', 'name', 'full_name', 'private'],
        type: 'object',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    repository_selection: {
      description: "Describe whether all repositories have been selected or there's a selection involved",
      enum: ['all', 'selected'],
      type: 'string',
    },
    requester: {
      nullable: true,
      properties: {
        avatar_url: {
          format: 'uri',
          type: 'string',
        },
        deleted: {
          type: 'boolean',
        },
        email: {
          nullable: true,
          type: 'string',
        },
        events_url: {
          format: 'uri-template',
          type: 'string',
        },
        followers_url: {
          format: 'uri',
          type: 'string',
        },
        following_url: {
          format: 'uri-template',
          type: 'string',
        },
        gists_url: {
          format: 'uri-template',
          type: 'string',
        },
        gravatar_id: {
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        login: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        organizations_url: {
          format: 'uri',
          type: 'string',
        },
        received_events_url: {
          format: 'uri',
          type: 'string',
        },
        repos_url: {
          format: 'uri',
          type: 'string',
        },
        site_admin: {
          type: 'boolean',
        },
        starred_url: {
          format: 'uri-template',
          type: 'string',
        },
        subscriptions_url: {
          format: 'uri',
          type: 'string',
        },
        type: {
          enum: ['Bot', 'User', 'Organization'],
          type: 'string',
        },
        url: {
          format: 'uri',
          type: 'string',
        },
      },
      required: ['login', 'id'],
      title: 'User',
      type: 'object',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: [
    'action',
    'installation',
    'repository_selection',
    'repositories_added',
    'repositories_removed',
    'requester',
    'sender',
  ],
  title: 'installation_repositories removed event',
  type: 'object',
} as const;

export const webhook_installation_suspendSchema = {
  properties: {
    action: {
      enum: ['suspend'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repositories: {
      description: 'An array of repository objects that the installation can access.',
      items: {
        properties: {
          full_name: {
            type: 'string',
          },
          id: {
            description: 'Unique identifier of the repository',
            type: 'integer',
          },
          name: {
            description: 'The name of the repository.',
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          private: {
            description: 'Whether the repository is private or public.',
            type: 'boolean',
          },
        },
        required: ['id', 'node_id', 'name', 'full_name', 'private'],
        type: 'object',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    requester: {
      nullable: true,
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'installation', 'sender'],
  title: 'installation suspend event',
  type: 'object',
} as const;

export const webhook_installation_target_renamedSchema = {
  properties: {
    account: {
      properties: {
        avatar_url: {
          type: 'string',
        },
        created_at: {
          type: 'string',
        },
        description: {
          nullable: true,
        },
        events_url: {
          type: 'string',
        },
        followers: {
          type: 'integer',
        },
        followers_url: {
          type: 'string',
        },
        following: {
          type: 'integer',
        },
        following_url: {
          type: 'string',
        },
        gists_url: {
          type: 'string',
        },
        gravatar_id: {
          type: 'string',
        },
        has_organization_projects: {
          type: 'boolean',
        },
        has_repository_projects: {
          type: 'boolean',
        },
        hooks_url: {
          type: 'string',
        },
        html_url: {
          type: 'string',
        },
        id: {
          type: 'integer',
        },
        is_verified: {
          type: 'boolean',
        },
        issues_url: {
          type: 'string',
        },
        login: {
          type: 'string',
        },
        members_url: {
          type: 'string',
        },
        name: {
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        organizations_url: {
          type: 'string',
        },
        public_gists: {
          type: 'integer',
        },
        public_members_url: {
          type: 'string',
        },
        public_repos: {
          type: 'integer',
        },
        received_events_url: {
          type: 'string',
        },
        repos_url: {
          type: 'string',
        },
        site_admin: {
          type: 'boolean',
        },
        slug: {
          type: 'string',
        },
        starred_url: {
          type: 'string',
        },
        subscriptions_url: {
          type: 'string',
        },
        type: {
          type: 'string',
        },
        updated_at: {
          type: 'string',
        },
        url: {
          type: 'string',
        },
        website_url: {
          nullable: true,
        },
      },
      required: ['id', 'node_id', 'avatar_url', 'html_url'],
      type: 'object',
    },
    action: {
      type: 'string',
    },
    changes: {
      properties: {
        login: {
          properties: {
            from: {
              type: 'string',
            },
          },
          required: ['from'],
          type: 'object',
        },
        slug: {
          properties: {
            from: {
              type: 'string',
            },
          },
          required: ['from'],
          type: 'object',
        },
      },
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
    target_type: {
      type: 'string',
    },
  },
  required: ['action', 'target_type', 'account', 'changes', 'installation'],
  type: 'object',
} as const;

export const webhook_installation_unsuspendSchema = {
  properties: {
    action: {
      enum: ['unsuspend'],
      type: 'string',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/installation',
    },
    organization: {
      $ref: '#/components/schemas/organization-simple',
    },
    repositories: {
      description: 'An array of repository objects that the installation can access.',
      items: {
        properties: {
          full_name: {
            type: 'string',
          },
          id: {
            description: 'Unique identifier of the repository',
            type: 'integer',
          },
          name: {
            description: 'The name of the repository.',
            type: 'string',
          },
          node_id: {
            type: 'string',
          },
          private: {
            description: 'Whether the repository is private or public.',
            type: 'boolean',
          },
        },
        required: ['id', 'node_id', 'name', 'full_name', 'private'],
        type: 'object',
      },
      type: 'array',
    },
    repository: {
      $ref: '#/components/schemas/repository',
    },
    requester: {
      nullable: true,
    },
    sender: {
      $ref: '#/components/schemas/simple-user',
    },
  },
  required: ['action', 'installation', 'sender'],
  title: 'installation unsuspend event',
  type: 'object',
} as const;

export const webhook_issue_comment_createdSchema = {
  properties: {
    action: {
      enum: ['created'],
      type: 'string',
    },
    comment: {
      description: 'The [comment](https://docs.github.com/rest/reference/issues#comments) itself.',
      properties: {
        author_association: {
          description: 'How the author is associated with the repository.',
          enum: [
            'COLLABORATOR',
            'CONTRIBUTOR',
            'FIRST_TIMER',
            'FIRST_TIME_CONTRIBUTOR',
            'MANNEQUIN',
            'MEMBER',
            'NONE',
            'OWNER',
          ],
          title: 'AuthorAssociation',
          type: 'string',
        },
        body: {
          description: 'Contents of the issue comment',
          type: 'string',
        },
        created_at: {
          format: 'date-time',
          type: 'string',
        },
        html_url: {
          format: 'uri',
          type: 'string',
        },
        id: {
          description: 'Unique identifier of the issue comment',
          type: 'integer',
        },
        issue_url: {
          format: 'uri',
          type: 'string',
        },
        node_id: {
          type: 'string',
        },
        performed_via_github_app: {
          $ref: '#/components/schemas/nullable-integration',
        },
        reactions: {
          properties: {
            '+1': {
              type: 'integer',
            },
            '-1': {
              type: 'integer',
            },
            confused: {
              type: 'integer',
            },
            eyes: {
              type: 'integer',
            },
            heart: {
              type: 'integer',
            },
            hooray: {
              type: 'integer',
            },
            laugh: {
              type: 'integer',
            },
            rocket: {
              type: 'integer',
            },
            total_count: {
              type: 'integer',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['url', 'total_count', '+1', '-1', 'laugh', 'confused', 'heart', 'hooray', 'eyes', 'rocket'],
          title: 'Reactions',
          type: 'object',
        },
        updated_at: {
          format: 'date-time',
          type: 'string',
        },
        url: {
          description: 'URL for the issue comment',
          format: 'uri',
          type: 'string',
        },
        user: {
          nullable: true,
          properties: {
            avatar_url: {
              format: 'uri',
              type: 'string',
            },
            deleted: {
              type: 'boolean',
            },
            email: {
              nullable: true,
              type: 'string',
            },
            events_url: {
              format: 'uri-template',
              type: 'string',
            },
            followers_url: {
              format: 'uri',
              type: 'string',
            },
            following_url: {
              format: 'uri-template',
              type: 'string',
            },
            gists_url: {
              format: 'uri-template',
              type: 'string',
            },
            gravatar_id: {
              type: 'string',
            },
            html_url: {
              format: 'uri',
              type: 'string',
            },
            id: {
              type: 'integer',
            },
            login: {
              type: 'string',
            },
            name: {
              type: 'string',
            },
            node_id: {
              type: 'string',
            },
            organizations_url: {
              format: 'uri',
              type: 'string',
            },
            received_events_url: {
              format: 'uri',
              type: 'string',
            },
            repos_url: {
              format: 'uri',
              type: 'string',
            },
            site_admin: {
              type: 'boolean',
            },
            starred_url: {
              format: 'uri-template',
              type: 'string',
            },
            subscriptions_url: {
              format: 'uri',
              type: 'string',
            },
            type: {
              enum: ['Bot', 'User', 'Organization'],
              type: 'string',
            },
            url: {
              format: 'uri',
              type: 'string',
            },
          },
          required: ['login', 'id'],
          title: 'User',
          type: 'object',
        },
      },
      required: [
        'url',
        'html_url',
        'issue_url',
        'id',
        'node_id',
        'user',
        'created_at',
        'updated_at',
        'author_association',
        'performed_via_github_app',
        'body',
        'reactions',
      ],
      title: 'issue comment',
      type: 'object',
    },
    enterprise: {
      $ref: '#/components/schemas/enterprise',
    },
    installation: {
      $ref: '#/components/schemas/simple-installation',
    },
    issue: {
      allOf: [
        {
          description: 'The [issue](https://docs.github.com/rest/reference/issues) itself.',
          properties: {
            active_lock_reason: {
              enum: ['resolved', 'off-topic', 'too heated', 'spam', null],
              nullable: true,
              type: 'string',
            },
            assignee: {
              nullable: true,
              properties: {
                avatar_url: {
                  format: 'uri',
                  type: 'string',
                },
                deleted: {
                  type: 'boolean',
                },
                email: {
                  nullable: true,
                  type: 'string',
                },
                events_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                followers_url: {
                  format: 'uri',
                  type: 'string',
                },
                following_url: {
                  format: 'uri-template',
                  type: 'string',
                },
                gists_url: {
                  format: 'uri-template',
                  type: 'string',
                },
      