// Generated by ts-to-zod
import { z } from 'zod';

export const crawlResponseSchema = z.object({
  success: z.boolean().optional(),
  id: z.string().optional(),
  url: z.string().optional(),
});

export const crawlStatusResponseObjSchema = z.object({
  status: z.string().optional(),
  total: z.number().optional(),
  completed: z.number().optional(),
  creditsUsed: z.number().optional(),
  expiresAt: z.string().optional(),
  next: z.string().optional().nullable(),
  data: z
    .array(
      z.object({
        markdown: z.string().optional(),
        html: z.string().optional().nullable(),
        rawHtml: z.string().optional().nullable(),
        links: z.array(z.string()).optional(),
        screenshot: z.string().optional().nullable(),
        metadata: z
          .object({
            title: z.string().optional(),
            description: z.string().optional(),
            language: z.string().optional().nullable(),
            sourceURL: z.string().optional(),
            '<any other metadata> ': z.string().optional(),
            statusCode: z.number().optional(),
            error: z.string().optional().nullable(),
          })
          .optional(),
      }),
    )
    .optional(),
});

export const mapResponseSchema = z.object({
  success: z.boolean().optional(),
  links: z.array(z.string()).optional(),
});

export const scrapeResponseSchema = z.object({
  success: z.boolean().optional(),
  data: z
    .object({
      markdown: z.string().optional(),
      html: z.string().optional().nullable(),
      rawHtml: z.string().optional().nullable(),
      screenshot: z.string().optional().nullable(),
      links: z.array(z.string()).optional(),
      actions: z
        .object({
          screenshots: z.array(z.string()).optional(),
        })
        .optional()
        .nullable(),
      metadata: z
        .object({
          title: z.string().optional(),
          description: z.string().optional(),
          language: z.string().optional().nullable(),
          sourceURL: z.string().optional(),
          '<any other metadata> ': z.string().optional(),
          statusCode: z.number().optional(),
          error: z.string().optional().nullable(),
        })
        .optional(),
      llm_extraction: z.record(z.unknown()).optional().nullable(),
      warning: z.string().optional().nullable(),
    })
    .optional(),
});

export const scrapeAndExtractFromUrlDataSchema = z.object({
  body: z.object({
    url: z.string(),
    formats: z
      .array(
        z.union([
          z.literal('markdown'),
          z.literal('html'),
          z.literal('rawHtml'),
          z.literal('links'),
          z.literal('screenshot'),
          z.literal('extract'),
          z.literal('screenshot@fullPage'),
        ]),
      )
      .optional(),
    onlyMainContent: z.boolean().optional(),
    includeTags: z.array(z.string()).optional(),
    excludeTags: z.array(z.string()).optional(),
    headers: z.record(z.unknown()).optional(),
    waitFor: z.number().optional(),
    timeout: z.number().optional(),
    extract: z
      .object({
        schema: z.record(z.unknown()).optional(),
        systemPrompt: z.string().optional(),
        prompt: z.string().optional(),
      })
      .optional(),
    actions: z
      .array(
        z.union([
          z.object({
            type: z.literal('wait'),
            milliseconds: z.number(),
          }),
          z.object({
            type: z.literal('screenshot'),
            fullPage: z.boolean().optional(),
          }),
          z.object({
            type: z.literal('click'),
            selector: z.string(),
          }),
          z.object({
            type: z.literal('write'),
            text: z.string(),
            selector: z.string(),
          }),
          z.object({
            type: z.literal('press'),
            key: z.string(),
          }),
          z.object({
            type: z.literal('scroll'),
            direction: z.union([z.literal('up'), z.literal('down')]),
            amount: z.number().optional(),
          }),
        ]),
      )
      .optional(),
  }),
});

export const scrapeAndExtractFromUrlResponseSchema = scrapeResponseSchema;

export const scrapeAndExtractFromUrlErrorSchema = z.object({
  error: z.string().optional(),
});

export const getCrawlStatusDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getCrawlStatusResponseSchema = crawlStatusResponseObjSchema;

export const getCrawlStatusErrorSchema = z.object({
  error: z.string().optional(),
});

export const cancelCrawlDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const cancelCrawlResponseSchema = z.object({
  success: z.boolean().optional(),
  message: z.string().optional(),
});

export const cancelCrawlErrorSchema = z.object({
  error: z.string().optional(),
});

export const crawlUrlsDataSchema = z.object({
  body: z.object({
    url: z.string(),
    excludePaths: z.array(z.string()).optional(),
    includePaths: z.array(z.string()).optional(),
    maxDepth: z.number().optional(),
    ignoreSitemap: z.boolean().optional(),
    limit: z.number().optional(),
    allowBackwardLinks: z.boolean().optional(),
    allowExternalLinks: z.boolean().optional(),
    webhook: z.string().optional(),
    scrapeOptions: z
      .object({
        formats: z
          .array(
            z.union([
              z.literal('markdown'),
              z.literal('html'),
              z.literal('rawHtml'),
              z.literal('links'),
              z.literal('screenshot'),
            ]),
          )
          .optional(),
        headers: z.record(z.unknown()).optional(),
        includeTags: z.array(z.string()).optional(),
        excludeTags: z.array(z.string()).optional(),
        onlyMainContent: z.boolean().optional(),
        waitFor: z.number().optional(),
      })
      .optional(),
  }),
});

export const crawlUrlsResponseSchema = crawlResponseSchema;

export const crawlUrlsErrorSchema = z.object({
  error: z.string().optional(),
});

export const mapUrlsDataSchema = z.object({
  body: z.object({
    url: z.string(),
    search: z.string().optional(),
    ignoreSitemap: z.boolean().optional(),
    includeSubdomains: z.boolean().optional(),
    limit: z.number().optional(),
  }),
});

export const mapUrlsResponseSchema = mapResponseSchema;

export const mapUrlsErrorSchema = z.object({
  error: z.string().optional(),
});
