// This file is auto-generated by @hey-api/openapi-ts

export type CrawlResponse = {
  success?: boolean;
  id?: string;
  url?: string;
};

export type CrawlStatusResponseObj = {
  /**
   * The current status of the crawl. Can be `scraping`, `completed`, or `failed`.
   */
  status?: string;
  /**
   * The total number of pages that were attempted to be crawled.
   */
  total?: number;
  /**
   * The number of pages that have been successfully crawled.
   */
  completed?: number;
  /**
   * The number of credits used for the crawl.
   */
  creditsUsed?: number;
  /**
   * The date and time when the crawl will expire.
   */
  expiresAt?: string;
  /**
   * The URL to retrieve the next 10MB of data. Returned if the crawl is not completed or if the response is larger than 10MB.
   */
  next?: string | null;
  /**
   * The data of the crawl.
   */
  data?: Array<{
    markdown?: string;
    /**
     * HTML version of the content on page if `includeHtml`  is true
     */
    html?: string | null;
    /**
     * Raw HTML content of the page if `includeRawHtml`  is true
     */
    rawHtml?: string | null;
    /**
     * List of links on the page if `includeLinks` is true
     */
    links?: Array<string>;
    /**
     * Screenshot of the page if `includeScreenshot` is true
     */
    screenshot?: string | null;
    metadata?: {
      title?: string;
      description?: string;
      language?: string | null;
      sourceURL?: string;
      '<any other metadata> '?: string;
      /**
       * The status code of the page
       */
      statusCode?: number;
      /**
       * The error message of the page
       */
      error?: string | null;
    };
  }>;
};

export type MapResponse = {
  success?: boolean;
  links?: Array<string>;
};

export type ScrapeResponse = {
  success?: boolean;
  data?: {
    markdown?: string;
    /**
     * HTML version of the content on page if `html` is in `formats`
     */
    html?: string | null;
    /**
     * Raw HTML content of the page if `rawHtml` is in `formats`
     */
    rawHtml?: string | null;
    /**
     * Screenshot of the page if `screenshot` is in `formats`
     */
    screenshot?: string | null;
    /**
     * List of links on the page if `links` is in `formats`
     */
    links?: Array<string>;
    /**
     * Results of the actions specified in the `actions` parameter. Only present if the `actions` parameter was provided in the request
     */
    actions?: {
      /**
       * Screenshot URLs, in the same order as the screenshot actions provided.
       */
      screenshots?: Array<string>;
    } | null;
    metadata?: {
      title?: string;
      description?: string;
      language?: string | null;
      sourceURL?: string;
      '<any other metadata> '?: string;
      /**
       * The status code of the page
       */
      statusCode?: number;
      /**
       * The error message of the page
       */
      error?: string | null;
    };
    /**
     * Displayed when using LLM Extraction. Extracted data from the page following the schema defined.
     */
    llm_extraction?: {
      [key: string]: unknown;
    } | null;
    /**
     * Can be displayed when using LLM Extraction. Warning message will let you know any issues with the extraction.
     */
    warning?: string | null;
  };
};

export type ScrapeAndExtractFromUrlData = {
  body: {
    /**
     * The URL to scrape
     */
    url: string;
    /**
     * Formats to include in the output.
     */
    formats?: Array<'markdown' | 'html' | 'rawHtml' | 'links' | 'screenshot' | 'extract' | 'screenshot@fullPage'>;
    /**
     * Only return the main content of the page excluding headers, navs, footers, etc.
     */
    onlyMainContent?: boolean;
    /**
     * Tags to include in the output.
     */
    includeTags?: Array<string>;
    /**
     * Tags to exclude from the output.
     */
    excludeTags?: Array<string>;
    /**
     * Headers to send with the request. Can be used to send cookies, user-agent, etc.
     */
    headers?: {
      [key: string]: unknown;
    };
    /**
     * Specify a delay in milliseconds before fetching the content, allowing the page sufficient time to load.
     */
    waitFor?: number;
    /**
     * Timeout in milliseconds for the request
     */
    timeout?: number;
    /**
     * Extract object
     */
    extract?: {
      /**
       * The schema to use for the extraction (Optional)
       */
      schema?: {
        [key: string]: unknown;
      };
      /**
       * The system prompt to use for the extraction (Optional)
       */
      systemPrompt?: string;
      /**
       * The prompt to use for the extraction without a schema (Optional)
       */
      prompt?: string;
    };
    /**
     * Actions to perform on the page before grabbing the content
     */
    actions?: Array<
      | {
          /**
           * Wait for a specified amount of milliseconds
           */
          type: 'wait';
          /**
           * Number of milliseconds to wait
           */
          milliseconds: number;
        }
      | {
          /**
           * Take a screenshot
           */
          type: 'screenshot';
          /**
           * Should the screenshot be full-page or viewport sized?
           */
          fullPage?: boolean;
        }
      | {
          /**
           * Click on an element
           */
          type: 'click';
          /**
           * Query selector to find the element by
           */
          selector: string;
        }
      | {
          /**
           * Write text into an input field
           */
          type: 'write';
          /**
           * Text to type
           */
          text: string;
          /**
           * Query selector for the input field
           */
          selector: string;
        }
      | {
          /**
           * Press a key on the page
           */
          type: 'press';
          /**
           * Key to press
           */
          key: string;
        }
      | {
          /**
           * Scroll the page
           */
          type: 'scroll';
          /**
           * Direction to scroll
           */
          direction: 'up' | 'down';
          /**
           * Amount to scroll in pixels
           */
          amount?: number;
        }
    >;
  };
};

export type ScrapeAndExtractFromUrlResponse = ScrapeResponse;

export type ScrapeAndExtractFromUrlError = {
  error?: string;
};

export type GetCrawlStatusData = {
  path: {
    /**
     * The ID of the crawl job
     */
    id: string;
  };
};

export type GetCrawlStatusResponse = CrawlStatusResponseObj;

export type GetCrawlStatusError = {
  error?: string;
};

export type CancelCrawlData = {
  path: {
    /**
     * The ID of the crawl job
     */
    id: string;
  };
};

export type CancelCrawlResponse = {
  success?: boolean;
  message?: string;
};

export type CancelCrawlError = {
  error?: string;
};

export type CrawlUrlsData = {
  body: {
    /**
     * The base URL to start crawling from
     */
    url: string;
    /**
     * Specifies URL patterns to exclude from the crawl by comparing website paths against the provided regex patterns. For example, if you set "excludePaths": ["blog*"] for the base URL firecrawl.dev, any results matching that pattern will be excluded, such as https://www.firecrawl.dev/blog/firecrawl-launch-week-1-recap.
     */
    excludePaths?: Array<string>;
    /**
     * Specifies URL patterns to include in the crawl by comparing website paths against the provided regex patterns. Only the paths that match the specified patterns will be included in the response. For example, if you set "includePaths": ["blog*"] for the base URL firecrawl.dev, only results matching that pattern will be included, such as https://www.firecrawl.dev/blog/firecrawl-launch-week-1-recap.
     */
    includePaths?: Array<string>;
    /**
     * Maximum depth to crawl relative to the entered URL.
     */
    maxDepth?: number;
    /**
     * Ignore the website sitemap when crawling
     */
    ignoreSitemap?: boolean;
    /**
     * Maximum number of pages to crawl. Default limit is 10000.
     */
    limit?: number;
    /**
     * Enables the crawler to navigate from a specific URL to previously linked pages.
     */
    allowBackwardLinks?: boolean;
    /**
     * Allows the crawler to follow links to external websites.
     */
    allowExternalLinks?: boolean;
    /**
     * The URL to send the webhook to. This will trigger for crawl started (crawl.started) ,every page crawled (crawl.page) and when the crawl is completed (crawl.completed or crawl.failed). The response will be the same as the `/scrape` endpoint.
     */
    webhook?: string;
    scrapeOptions?: {
      /**
       * Formats to include in the output.
       */
      formats?: Array<'markdown' | 'html' | 'rawHtml' | 'links' | 'screenshot'>;
      /**
       * Headers to send with the request. Can be used to send cookies, user-agent, etc.
       */
      headers?: {
        [key: string]: unknown;
      };
      /**
       * Tags to include in the output.
       */
      includeTags?: Array<string>;
      /**
       * Tags to exclude from the output.
       */
      excludeTags?: Array<string>;
      /**
       * Only return the main content of the page excluding headers, navs, footers, etc.
       */
      onlyMainContent?: boolean;
      /**
       * Wait x amount of milliseconds for the page to load to fetch content
       */
      waitFor?: number;
    };
  };
};

export type CrawlUrlsResponse = CrawlResponse;

export type CrawlUrlsError = {
  error?: string;
};

export type MapUrlsData = {
  body: {
    /**
     * The base URL to start crawling from
     */
    url: string;
    /**
     * Search query to use for mapping. During the Alpha phase, the 'smart' part of the search functionality is limited to 1000 search results. However, if map finds more results, there is no limit applied.
     */
    search?: string;
    /**
     * Ignore the website sitemap when crawling
     */
    ignoreSitemap?: boolean;
    /**
     * Include subdomains of the website
     */
    includeSubdomains?: boolean;
    /**
     * Maximum number of links to return
     */
    limit?: number;
  };
};

export type MapUrlsResponse = MapResponse;

export type MapUrlsError = {
  error?: string;
};
