// This file is auto-generated by @hey-api/openapi-ts

export const ScrapeResponseSchema = {
  type: 'object',
  properties: {
    success: {
      type: 'boolean',
    },
    data: {
      type: 'object',
      properties: {
        markdown: {
          type: 'string',
        },
        html: {
          type: 'string',
          nullable: true,
          description: 'HTML version of the content on page if `html` is in `formats`',
        },
        rawHtml: {
          type: 'string',
          nullable: true,
          description: 'Raw HTML content of the page if `rawHtml` is in `formats`',
        },
        screenshot: {
          type: 'string',
          nullable: true,
          description: 'Screenshot of the page if `screenshot` is in `formats`',
        },
        links: {
          type: 'array',
          items: {
            type: 'string',
          },
          description: 'List of links on the page if `links` is in `formats`',
        },
        actions: {
          type: 'object',
          nullable: true,
          description:
            'Results of the actions specified in the `actions` parameter. Only present if the `actions` parameter was provided in the request',
          properties: {
            screenshots: {
              type: 'array',
              description: 'Screenshot URLs, in the same order as the screenshot actions provided.',
              items: {
                type: 'string',
                format: 'url',
              },
            },
          },
        },
        metadata: {
          type: 'object',
          properties: {
            title: {
              type: 'string',
            },
            description: {
              type: 'string',
            },
            language: {
              type: 'string',
              nullable: true,
            },
            sourceURL: {
              type: 'string',
              format: 'uri',
            },
            '<any other metadata> ': {
              type: 'string',
            },
            statusCode: {
              type: 'integer',
              description: 'The status code of the page',
            },
            error: {
              type: 'string',
              nullable: true,
              description: 'The error message of the page',
            },
          },
        },
        llm_extraction: {
          type: 'object',
          description:
            'Displayed when using LLM Extraction. Extracted data from the page following the schema defined.',
          nullable: true,
        },
        warning: {
          type: 'string',
          nullable: true,
          description:
            'Can be displayed when using LLM Extraction. Warning message will let you know any issues with the extraction.',
        },
      },
    },
  },
} as const;

export const CrawlStatusResponseObjSchema = {
  type: 'object',
  properties: {
    status: {
      type: 'string',
      description: 'The current status of the crawl. Can be `scraping`, `completed`, or `failed`.',
    },
    total: {
      type: 'integer',
      description: 'The total number of pages that were attempted to be crawled.',
    },
    completed: {
      type: 'integer',
      description: 'The number of pages that have been successfully crawled.',
    },
    creditsUsed: {
      type: 'integer',
      description: 'The number of credits used for the crawl.',
    },
    expiresAt: {
      type: 'string',
      format: 'date-time',
      description: 'The date and time when the crawl will expire.',
    },
    next: {
      type: 'string',
      nullable: true,
      description:
        'The URL to retrieve the next 10MB of data. Returned if the crawl is not completed or if the response is larger than 10MB.',
    },
    data: {
      type: 'array',
      description: 'The data of the crawl.',
      items: {
        type: 'object',
        properties: {
          markdown: {
            type: 'string',
          },
          html: {
            type: 'string',
            nullable: true,
            description: 'HTML version of the content on page if `includeHtml`  is true',
          },
          rawHtml: {
            type: 'string',
            nullable: true,
            description: 'Raw HTML content of the page if `includeRawHtml`  is true',
          },
          links: {
            type: 'array',
            items: {
              type: 'string',
            },
            description: 'List of links on the page if `includeLinks` is true',
          },
          screenshot: {
            type: 'string',
            nullable: true,
            description: 'Screenshot of the page if `includeScreenshot` is true',
          },
          metadata: {
            type: 'object',
            properties: {
              title: {
                type: 'string',
              },
              description: {
                type: 'string',
              },
              language: {
                type: 'string',
                nullable: true,
              },
              sourceURL: {
                type: 'string',
                format: 'uri',
              },
              '<any other metadata> ': {
                type: 'string',
              },
              statusCode: {
                type: 'integer',
                description: 'The status code of the page',
              },
              error: {
                type: 'string',
                nullable: true,
                description: 'The error message of the page',
              },
            },
          },
        },
      },
    },
  },
} as const;

export const CrawlResponseSchema = {
  type: 'object',
  properties: {
    success: {
      type: 'boolean',
    },
    id: {
      type: 'string',
    },
    url: {
      type: 'string',
      format: 'uri',
    },
  },
} as const;

export const MapResponseSchema = {
  type: 'object',
  properties: {
    success: {
      type: 'boolean',
    },
    links: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
  },
} as const;
