// Generated by ts-to-zod
import { z } from 'zod';

export const projectResponseModelSchema = z.object({
  title: z.string(),
  project_id: z.string(),
  name: z.string(),
  create_date_unix: z.number(),
  default_title_voice_id: z.string(),
  default_paragraph_voice_id: z.string(),
  default_model_id: z.string(),
  last_conversion_date_unix: z.number(),
  can_be_downloaded: z.boolean(),
  author: z.string(),
  isbn_number: z.string(),
  volume_normalization: z.boolean(),
  state: z.union([z.literal('default'), z.literal('converting')]),
});

export const addPronunciationDictionaryResponseModelSchema = z.object({
  description: z.string().optional(),
  id: z.string(),
  name: z.string(),
  created_by: z.string(),
  creation_time_unix: z.number(),
  version_id: z.string(),
});

export const addPronunciationDictionaryRulesResponseModelSchema = z.object({
  id: z.string(),
  version_id: z.string(),
});

export const addVoiceResponseModelSchema = z.object({
  voice_id: z.string(),
});

export const audioNativeCreateProjectResponseModelSchema = z.object({
  project_id: z.string(),
  converting: z.boolean(),
  html_snippet: z.string(),
});

export const pronunciationDictionaryAliasRuleRequestModelSchema = z.object({
  type: z.literal('alias'),
  string_to_replace: z.string(),
  alias: z.string(),
});

export const pronunciationDictionaryPhonemeRuleRequestModelSchema = z.object({
  type: z.literal('phoneme'),
  string_to_replace: z.string(),
  phoneme: z.string(),
  alphabet: z.string(),
});

export const bodyAddSharingVoiceV1VoicesAddPublicUserIdVoiceIdPostSchema = z.object({
  new_name: z.string(),
});

export const bodyCreateAPreviouslyGeneratedVoiceV1VoiceGenerationCreateVoicePostSchema = z.object({
  voice_name: z.string(),
  voice_description: z.string(),
  generated_voice_id: z.string(),
  labels: z.record(z.string()).optional(),
});

export const bodyDownloadHistoryItemsV1HistoryDownloadPostSchema = z.object({
  history_item_ids: z.array(z.string()),
  output_format: z.string().optional(),
});

export const bodyGenerateARandomVoiceV1VoiceGenerationGenerateVoicePostSchema = z.object({
  gender: z.union([z.literal('female'), z.literal('male')]),
  accent: z.string(),
  age: z.union([z.literal('young'), z.literal('middle_aged'), z.literal('old')]),
  accent_strength: z.number(),
  text: z.string(),
});

export const genderSchema = z.union([z.literal('female'), z.literal('male')]);

export const ageSchema = z.union([z.literal('young'), z.literal('middle_aged'), z.literal('old')]);

export const bodyRemoveRulesFromThePronunciationDictionaryV1PronunciationDictionariesPronunciationDictionaryIdRemoveRulesPostSchema =
  z.object({
    rule_strings: z.array(z.string()),
  });

export const bodyStreamChapterAudioV1ProjectsProjectIdChaptersChapterIdSnapshotsChapterSnapshotIdStreamPostSchema =
  z.object({
    convert_to_mpeg: z.boolean().optional(),
  });

export const bodyStreamProjectAudioV1ProjectsProjectIdSnapshotsProjectSnapshotIdStreamPostSchema = z.object({
  convert_to_mpeg: z.boolean().optional(),
});

export const voiceSettingsResponseModelSchema = z.object({
  stability: z.number(),
  similarity_boost: z.number(),
  style: z.number().optional(),
  use_speaker_boost: z.boolean().optional(),
});

export const pronunciationDictionaryVersionLocatorDBModelSchema = z.object({
  pronunciation_dictionary_id: z.string(),
  version_id: z.string(),
});

export const bodyTextToSpeechV1TextToSpeechVoiceIdStreamPostSchema = z.object({
  text: z.string(),
  model_id: z.string().optional(),
  voice_settings: voiceSettingsResponseModelSchema.optional(),
  pronunciation_dictionary_locators: z.array(pronunciationDictionaryVersionLocatorDBModelSchema).optional(),
});

export const bodyUpdatePronunciationDictionariesV1ProjectsProjectIdUpdatePronunciationDictionariesPostSchema = z.object(
  {
    pronunciation_dictionary_locators: z.array(pronunciationDictionaryVersionLocatorDBModelSchema),
  },
);

export const chapterStatisticsResponseModelSchema = z.object({
  characters_unconverted: z.number(),
  characters_converted: z.number(),
  paragraphs_converted: z.number(),
  paragraphs_unconverted: z.number(),
});

export const stateSchema = z.union([z.literal('default'), z.literal('converting')]);

export const chapterSnapshotResponseModelSchema = z.object({
  chapter_snapshot_id: z.string(),
  project_id: z.string(),
  chapter_id: z.string(),
  created_at_unix: z.number(),
  name: z.string(),
});

export const chapterSnapshotsResponseModelSchema = z.object({
  snapshots: z.array(chapterSnapshotResponseModelSchema),
});

export const doDubbingResponseModelSchema = z.object({
  dubbing_id: z.string(),
  expected_duration_sec: z.number(),
});

export const dubbingDeleteProjectResponseSchema = z.record(z.unknown());

export const dubbingMetadataResponseSchema = z.object({
  dubbing_id: z.string(),
  name: z.string(),
  status: z.string(),
  error: z.string(),
  target_languages: z.array(z.string()),
});

export const invoiceResponseModelSchema = z.object({
  amount_due_cents: z.number(),
  next_payment_attempt_unix: z.number(),
});

export const currencySchema = z.union([z.literal('usd'), z.literal('eur')]);

export const statusSchema = z.union([
  z.literal('trialing'),
  z.literal('active'),
  z.literal('incomplete'),
  z.literal('incomplete_expired'),
  z.literal('past_due'),
  z.literal('canceled'),
  z.literal('unpaid'),
  z.literal('free'),
]);

export const billingPeriodSchema = z.union([z.literal('monthly_period'), z.literal('annual_period')]);

export const feedbackResponseModelSchema = z.object({
  thumbs_up: z.boolean(),
  feedback: z.string(),
  emotions: z.boolean(),
  inaccurate_clone: z.boolean(),
  glitches: z.boolean(),
  audio_quality: z.boolean(),
  other: z.boolean(),
  review_status: z.string().optional(),
});

export const finetuningStateSchema = z.union([
  z.literal('not_started'),
  z.literal('queued'),
  z.literal('fine_tuning'),
  z.literal('fine_tuned'),
  z.literal('failed'),
  z.literal('delayed'),
]);

export const chapterResponseModelSchema = z.object({
  chapter_id: z.string(),
  name: z.string(),
  last_conversion_date_unix: z.number(),
  conversion_progress: z.number(),
  can_be_downloaded: z.boolean(),
  state: z.union([z.literal('default'), z.literal('converting')]),
  statistics: chapterStatisticsResponseModelSchema,
});

export const libraryVoiceResponseModelSchema = z.object({
  description: z.string(),
  public_owner_id: z.string(),
  voice_id: z.string(),
  date_unix: z.number(),
  name: z.string(),
  accent: z.string(),
  gender: z.string(),
  age: z.string(),
  descriptive: z.string(),
  use_case: z.string(),
  category: z.string(),
  language: z.string(),
  preview_url: z.string(),
  usage_character_count_1y: z.number(),
  usage_character_count_7d: z.number(),
  cloned_by_count: z.number(),
  rate: z.number(),
  free_users_allowed: z.boolean(),
  live_moderation_enabled: z.boolean(),
  featured: z.boolean(),
  notice_period: z.number().optional(),
  instagram_username: z.string().optional(),
  twitter_username: z.string().optional(),
  youtube_username: z.string().optional(),
  tiktok_username: z.string().optional(),
});

export const getProjectsResponseModelSchema = z.object({
  projects: z.array(projectResponseModelSchema),
});

export const getPronunciationDictionaryMetadataResponseModelSchema = z.object({
  description: z.string().optional(),
  id: z.string(),
  latest_version_id: z.string(),
  name: z.string(),
  created_by: z.string(),
  creation_time_unix: z.number(),
});

export const speechHistoryItemResponseModelSchema = z.object({
  history_item_id: z.string(),
  request_id: z.string(),
  voice_id: z.string(),
  model_id: z.string(),
  voice_name: z.string(),
  voice_category: z.union([
    z.literal('premade'),
    z.literal('cloned'),
    z.literal('generated'),
    z.literal('professional'),
  ]),
  text: z.string(),
  date_unix: z.number(),
  character_count_change_from: z.number(),
  character_count_change_to: z.number(),
  content_type: z.string(),
  state: z.union([z.literal('created'), z.literal('deleted'), z.literal('processing')]),
  settings: z.record(z.unknown()),
  feedback: feedbackResponseModelSchema,
  share_link_id: z.string(),
  source: z.union([z.literal('TTS'), z.literal('STS')]),
});

export const validationErrorSchema = z.object({
  loc: z.array(z.union([z.string(), z.number()])),
  msg: z.string(),
  type: z.string(),
});

export const languageResponseModelSchema = z.object({
  language_id: z.string(),
  name: z.string(),
});

export const manualVerificationFileResponseModelSchema = z.object({
  file_id: z.string(),
  file_name: z.string(),
  mime_type: z.string(),
  size_bytes: z.number(),
  upload_date_unix: z.number(),
});

export const manualVerificationResponseModelSchema = z.object({
  extra_text: z.string(),
  request_time_unix: z.number(),
  files: z.array(manualVerificationFileResponseModelSchema),
});

export const modelResponseModelSchema = z.object({
  description: z.string(),
  model_id: z.string(),
  name: z.string(),
  can_be_finetuned: z.boolean(),
  can_do_text_to_speech: z.boolean(),
  can_do_voice_conversion: z.boolean(),
  can_use_style: z.boolean(),
  can_use_speaker_boost: z.boolean(),
  serves_pro_voices: z.boolean(),
  token_cost_factor: z.number(),
  requires_alpha_access: z.boolean(),
  max_characters_request_free_user: z.number(),
  max_characters_request_subscribed_user: z.number(),
  languages: z.array(languageResponseModelSchema),
});

export const modelsListAvailableModelsResponseSchema = z.array(modelResponseModelSchema);

export const projectExtendedResponseModelSchema = z.object({
  project_id: z.string(),
  name: z.string(),
  create_date_unix: z.number(),
  default_title_voice_id: z.string(),
  default_paragraph_voice_id: z.string(),
  default_model_id: z.string(),
  last_conversion_date_unix: z.number(),
  can_be_downloaded: z.boolean(),
  state: z.union([z.literal('default'), z.literal('converting'), z.literal('in_queue')]),
  chapters: z.array(chapterResponseModelSchema),
});

export const state2Schema = z.union([z.literal('default'), z.literal('converting'), z.literal('in_queue')]);

export const projectsDeleteByIdResponseSchema = z.record(z.unknown());

export const projectsDeleteChapterByIdResponseSchema = z.record(z.unknown());

export const projectSnapshotResponseModelSchema = z.object({
  project_snapshot_id: z.string(),
  project_id: z.string(),
  created_at_unix: z.number(),
  name: z.string(),
});

export const projectSnapshotsResponseModelSchema = z.object({
  snapshots: z.array(projectSnapshotResponseModelSchema),
});

export const projectsStartChapterConversionResponseSchema = z.record(z.unknown());

export const projectsStartConversionResponseSchema = z.record(z.unknown());

export const projectsUpdatePronunciationDictionariesResponseSchema = z.record(z.unknown());

export const typeSchema = z.literal('alias');

export const type2Schema = z.literal('phoneme');

export const pronunciationDictionaryVersionDownloadResponseSchema = z.record(z.unknown());

export const recordingResponseModelSchema = z.object({
  recording_id: z.string(),
  mime_type: z.string(),
  size_bytes: z.number(),
  upload_date_unix: z.number(),
  transcription: z.string(),
});

export const redirectToMintlifyDocsGetResponseSchema = z.record(z.unknown());

export const removePronunciationDictionaryRulesResponseModelSchema = z.object({
  id: z.string(),
  version_id: z.string(),
});

export const sampleResponseModelSchema = z.object({
  sample_id: z.string(),
  file_name: z.string(),
  mime_type: z.string(),
  size_bytes: z.number(),
  hash: z.string(),
});

export const samplesRemoveByIdResponseSchema = z.record(z.unknown());

export const speechhistoryDeleteHistoryItemByIdResponseSchema = z.record(z.unknown());

export const voiceCategorySchema = z.union([
  z.literal('premade'),
  z.literal('cloned'),
  z.literal('generated'),
  z.literal('professional'),
]);

export const state3Schema = z.union([z.literal('created'), z.literal('deleted'), z.literal('processing')]);

export const sourceSchema = z.union([z.literal('TTS'), z.literal('STS')]);

export const ssoProviderDBModelSchema = z.object({
  provider_type: z.union([z.literal('saml'), z.literal('oidc')]),
  provider_id: z.string(),
  domains: z.array(z.string()),
});

export const providerTypeSchema = z.union([z.literal('saml'), z.literal('oidc')]);

export const subscriptionResponseModelSchema = z.object({
  tier: z.string(),
  character_count: z.number(),
  character_limit: z.number(),
  can_extend_character_limit: z.boolean(),
  allowed_to_extend_character_limit: z.boolean(),
  next_character_count_reset_unix: z.number(),
  voice_limit: z.number(),
  max_voice_add_edits: z.number(),
  voice_add_edit_counter: z.number(),
  professional_voice_limit: z.number(),
  can_extend_voice_limit: z.boolean(),
  can_use_instant_voice_cloning: z.boolean(),
  can_use_professional_voice_cloning: z.boolean(),
  currency: z.union([z.literal('usd'), z.literal('eur')]),
  status: z.union([
    z.literal('trialing'),
    z.literal('active'),
    z.literal('incomplete'),
    z.literal('incomplete_expired'),
    z.literal('past_due'),
    z.literal('canceled'),
    z.literal('unpaid'),
    z.literal('free'),
  ]),
  billing_period: z.union([z.literal('monthly_period'), z.literal('annual_period')]),
});

export const userResponseModelSchema = z.object({
  subscription: subscriptionResponseModelSchema,
  is_new_user: z.boolean(),
  xi_api_key: z.string(),
  can_use_delayed_payment_methods: z.boolean(),
  is_onboarding_completed: z.boolean(),
  first_name: z.string().optional(),
});

export const verificationAttemptResponseModelSchema = z.object({
  text: z.string(),
  date_unix: z.number(),
  accepted: z.boolean(),
  similarity: z.number(),
  levenshtein_distance: z.number(),
  recording: recordingResponseModelSchema.optional(),
});

export const voiceGenerationParameterOptionResponseModelSchema = z.object({
  name: z.string(),
  code: z.string(),
});

export const voiceGenerationParameterResponseModelSchema = z.object({
  genders: z.array(voiceGenerationParameterOptionResponseModelSchema),
  accents: z.array(voiceGenerationParameterOptionResponseModelSchema),
  ages: z.array(voiceGenerationParameterOptionResponseModelSchema),
  minimum_characters: z.number(),
  maximum_characters: z.number(),
  minimum_accent_strength: z.number(),
  maximum_accent_strength: z.number(),
});

export const fineTuningResponseModelSchema = z.object({
  is_allowed_to_fine_tune: z.boolean(),
  finetuning_state: z.union([
    z.literal('not_started'),
    z.literal('queued'),
    z.literal('fine_tuning'),
    z.literal('fine_tuned'),
    z.literal('failed'),
    z.literal('delayed'),
  ]),
  verification_failures: z.array(z.string()),
  verification_attempts_count: z.number(),
  manual_verification_requested: z.boolean(),
  language: z.string().optional(),
  finetuning_progress: z.record(z.number()).optional(),
  message: z.string().optional(),
  dataset_duration_seconds: z.number().optional(),
  verification_attempts: z.array(verificationAttemptResponseModelSchema).optional(),
  slice_ids: z.array(z.string()).optional(),
  manual_verification: manualVerificationResponseModelSchema.optional(),
});

export const voiceSharingResponseModelSchema = z.object({
  description: z.string(),
  status: z.union([z.literal('enabled'), z.literal('disabled'), z.literal('copied'), z.literal('copied_disabled')]),
  history_item_sample_id: z.string(),
  date_unix: z.number(),
  whitelisted_emails: z.array(z.string()),
  public_owner_id: z.string(),
  original_voice_id: z.string(),
  financial_rewards_enabled: z.boolean(),
  free_users_allowed: z.boolean(),
  live_moderation_enabled: z.boolean(),
  rate: z.number(),
  notice_period: z.number(),
  disable_at_unix: z.number(),
  voice_mixing_allowed: z.boolean(),
  featured: z.boolean(),
  category: z.union([z.literal('generated'), z.literal('professional'), z.literal('high_quality')]),
  reader_app_enabled: z.boolean(),
  ban_reason: z.string(),
  liked_by_count: z.number(),
  cloned_by_count: z.number(),
  name: z.string(),
  labels: z.record(z.string()),
  review_status: z.union([
    z.literal('not_requested'),
    z.literal('pending'),
    z.literal('declined'),
    z.literal('allowed'),
    z.literal('allowed_with_changes'),
  ]),
  review_message: z.string(),
  enabled_in_library: z.boolean(),
  instagram_username: z.string().optional(),
  twitter_username: z.string().optional(),
  youtube_username: z.string().optional(),
  tiktok_username: z.string().optional(),
});

export const voiceVerificationResponseModelSchema = z.object({
  requires_verification: z.boolean(),
  is_verified: z.boolean(),
  verification_failures: z.array(z.string()),
  verification_attempts_count: z.number(),
  language: z.string().optional(),
  verification_attempts: z.array(verificationAttemptResponseModelSchema).optional(),
});

export const safetyControlSchema = z.union([
  z.literal('NONE'),
  z.literal('BAN'),
  z.literal('CAPTCHA'),
  z.literal('CAPTCHA_AND_MODERATION'),
]);

export const voicesDeleteByIdResponseSchema = z.record(z.unknown());

export const voicesEditSettingsPostResponseSchema = z.record(z.unknown());

export const status2Schema = z.union([
  z.literal('enabled'),
  z.literal('disabled'),
  z.literal('copied'),
  z.literal('copied_disabled'),
]);

export const categorySchema = z.union([z.literal('generated'), z.literal('professional'), z.literal('high_quality')]);

export const reviewStatusSchema = z.union([
  z.literal('not_requested'),
  z.literal('pending'),
  z.literal('declined'),
  z.literal('allowed'),
  z.literal('allowed_with_changes'),
]);

export const voicesUpdateVoiceByIdResponseSchema = z.record(z.unknown());

export const speechhistoryGetGeneratedAudioMetadataDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      page_size: z.number().optional(),
      start_after_history_item_id: z.string().optional(),
      voice_id: z.string().optional(),
    })
    .optional(),
});

export const getSpeechHistoryResponseModelSchema = z.object({
  history: z.array(speechHistoryItemResponseModelSchema),
  last_history_item_id: z.string(),
  has_more: z.boolean(),
});

export const hTTPValidationErrorSchema = z.object({
  detail: z.array(validationErrorSchema).optional(),
});

export const speechhistoryGetHistoryItemByIdDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    history_item_id: z.string(),
  }),
});

export const speechhistoryGetHistoryItemByIdResponseSchema = speechHistoryItemResponseModelSchema;

export const speechhistoryGetHistoryItemByIdErrorSchema = hTTPValidationErrorSchema;

export const speechhistoryDeleteHistoryItemByIdDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    history_item_id: z.string(),
  }),
});

export const speechhistoryDeleteHistoryItemByIdResponse2Schema = speechhistoryDeleteHistoryItemByIdResponseSchema;

export const speechhistoryDeleteHistoryItemByIdErrorSchema = hTTPValidationErrorSchema;

export const speechhistoryGetHistoryItemAudioDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    history_item_id: z.string(),
  }),
});

export const speechhistoryGetHistoryItemAudioResponseSchema = z.unknown();

export const speechhistoryGetHistoryItemAudioErrorSchema = hTTPValidationErrorSchema;

export const speechhistoryDownloadHistoryItemsDataSchema = z.object({
  body: bodyDownloadHistoryItemsV1HistoryDownloadPostSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
});

export const speechhistoryDownloadHistoryItemsResponseSchema = z.unknown();

export const speechhistoryDownloadHistoryItemsErrorSchema = hTTPValidationErrorSchema;

export const samplesRemoveByIdDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    sample_id: z.string(),
    voice_id: z.string(),
  }),
});

export const samplesRemoveByIdResponse2Schema = samplesRemoveByIdResponseSchema;

export const samplesRemoveByIdErrorSchema = hTTPValidationErrorSchema;

export const samplesGetAudioFromSampleDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    sample_id: z.string(),
    voice_id: z.string(),
  }),
});

export const samplesGetAudioFromSampleResponseSchema = z.unknown();

export const samplesGetAudioFromSampleErrorSchema = hTTPValidationErrorSchema;

export const bodyTextToSpeechV1TextToSpeechVoiceIdPostSchema = z.object({
  text: z.string(),
  model_id: z.string().optional(),
  voice_settings: voiceSettingsResponseModelSchema.optional(),
  pronunciation_dictionary_locators: z.array(pronunciationDictionaryVersionLocatorDBModelSchema).optional(),
});

export const texttospeechConvertTextToSpeechResponseSchema = z.unknown();

export const texttospeechConvertTextToSpeechErrorSchema = hTTPValidationErrorSchema;

export const texttospeechConvertTextToSpeechStreamDataSchema = z.object({
  body: bodyTextToSpeechV1TextToSpeechVoiceIdStreamPostSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    voice_id: z.string(),
  }),
  query: z
    .object({
      optimize_streaming_latency: z.number().optional(),
      output_format: z.string().optional(),
    })
    .optional(),
});

export const texttospeechConvertTextToSpeechStreamResponseSchema = z.unknown();

export const texttospeechConvertTextToSpeechStreamErrorSchema = hTTPValidationErrorSchema;

export const speechtospeechCreateWithVoiceResponseSchema = z.unknown();

export const speechtospeechCreateWithVoiceErrorSchema = hTTPValidationErrorSchema;

export const speechtospeechCreateWithVoice1ResponseSchema = z.unknown();

export const speechtospeechCreateWithVoice1ErrorSchema = hTTPValidationErrorSchema;

export const voicegenerationGetVoiceGenerationParametersResponseSchema = voiceGenerationParameterResponseModelSchema;

export const voicegenerationGetVoiceGenerationParametersErrorSchema = z.unknown();

export const voicegenerationGenerateRandomVoiceDataSchema = z.object({
  body: bodyGenerateARandomVoiceV1VoiceGenerationGenerateVoicePostSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
});

export const voicegenerationGenerateRandomVoiceResponseSchema = z.unknown();

export const voicegenerationGenerateRandomVoiceErrorSchema = hTTPValidationErrorSchema;

export const voicegenerationCreateVoiceDataSchema = z.object({
  body: bodyCreateAPreviouslyGeneratedVoiceV1VoiceGenerationCreateVoicePostSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
});

export const voiceResponseModelSchema = z.object({
  description: z.string(),
  voice_id: z.string(),
  name: z.string(),
  samples: z.array(sampleResponseModelSchema),
  category: z.string(),
  fine_tuning: fineTuningResponseModelSchema,
  labels: z.record(z.string()),
  preview_url: z.string(),
  available_for_tiers: z.array(z.string()),
  settings: voiceSettingsResponseModelSchema,
  sharing: voiceSharingResponseModelSchema,
  high_quality_base_model_ids: z.array(z.string()),
  safety_control: z
    .union([z.literal('NONE'), z.literal('BAN'), z.literal('CAPTCHA'), z.literal('CAPTCHA_AND_MODERATION')])
    .optional(),
  voice_verification: voiceVerificationResponseModelSchema.optional(),
  owner_id: z.string().optional(),
  permission_on_resource: z.string().optional(),
});

export const voicegenerationCreateVoiceErrorSchema = hTTPValidationErrorSchema;

export const userGetSubscriptionInfoDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
});

export const extendedSubscriptionResponseModelSchema = z.object({
  tier: z.string(),
  character_count: z.number(),
  character_limit: z.number(),
  can_extend_character_limit: z.boolean(),
  allowed_to_extend_character_limit: z.boolean(),
  next_character_count_reset_unix: z.number(),
  voice_limit: z.number(),
  max_voice_add_edits: z.number(),
  voice_add_edit_counter: z.number(),
  professional_voice_limit: z.number(),
  can_extend_voice_limit: z.boolean(),
  can_use_instant_voice_cloning: z.boolean(),
  can_use_professional_voice_cloning: z.boolean(),
  currency: z.union([z.literal('usd'), z.literal('eur')]),
  status: z.union([
    z.literal('trialing'),
    z.literal('active'),
    z.literal('incomplete'),
    z.literal('incomplete_expired'),
    z.literal('past_due'),
    z.literal('canceled'),
    z.literal('unpaid'),
    z.literal('free'),
  ]),
  billing_period: z.union([z.literal('monthly_period'), z.literal('annual_period')]),
  next_invoice: invoiceResponseModelSchema,
  has_open_invoices: z.boolean(),
});

export const userGetSubscriptionInfoErrorSchema = hTTPValidationErrorSchema;

export const userGetInfoDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
});

export const userGetInfoResponseSchema = userResponseModelSchema;

export const userGetInfoErrorSchema = hTTPValidationErrorSchema;

export const voicesListAllVoicesDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
});

export const getVoicesResponseModelSchema = z.object({
  voices: z.array(voiceResponseModelSchema),
});

export const voicesListAllVoicesErrorSchema = hTTPValidationErrorSchema;

export const voicesGetDefaultVoiceSettingsResponseSchema = voiceSettingsResponseModelSchema;

export const voicesGetDefaultVoiceSettingsErrorSchema = z.unknown();

export const voicesGetSettingsDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    voice_id: z.string(),
  }),
});

export const voicesGetSettingsResponseSchema = voiceSettingsResponseModelSchema;

export const voicesGetSettingsErrorSchema = hTTPValidationErrorSchema;

export const voicesGetVoiceMetadataDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    voice_id: z.string(),
  }),
  query: z
    .object({
      with_settings: z.boolean().optional(),
    })
    .optional(),
});

export const voicesGetVoiceMetadataResponseSchema = voiceResponseModelSchema;

export const voicesGetVoiceMetadataErrorSchema = hTTPValidationErrorSchema;

export const voicesDeleteByIdDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    voice_id: z.string(),
  }),
});

export const voicesDeleteByIdResponse2Schema = voicesDeleteByIdResponseSchema;

export const voicesDeleteByIdErrorSchema = hTTPValidationErrorSchema;

export const voicesEditSettingsPostDataSchema = z.object({
  body: voiceSettingsResponseModelSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    voice_id: z.string(),
  }),
});

export const voicesEditSettingsPostResponse2Schema = voicesEditSettingsPostResponseSchema;

export const voicesEditSettingsPostErrorSchema = hTTPValidationErrorSchema;

export const voicesAddVoiceToCollectionResponseSchema = addVoiceResponseModelSchema;

export const voicesAddVoiceToCollectionErrorSchema = hTTPValidationErrorSchema;

export const voicesUpdateVoiceByIdResponse2Schema = voicesUpdateVoiceByIdResponseSchema;

export const voicesUpdateVoiceByIdErrorSchema = hTTPValidationErrorSchema;

export const voicesAddToCollectionDataSchema = z.object({
  body: bodyAddSharingVoiceV1VoicesAddPublicUserIdVoiceIdPostSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    public_user_id: z.string(),
    voice_id: z.string(),
  }),
});

export const voicesAddToCollectionResponseSchema = addVoiceResponseModelSchema;

export const voicesAddToCollectionErrorSchema = hTTPValidationErrorSchema;

export const projectsGetAllProjectsDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
});

export const projectsGetAllProjectsResponseSchema = getProjectsResponseModelSchema;

export const projectsGetAllProjectsErrorSchema = hTTPValidationErrorSchema;

export const addProjectResponseModelSchema = z.object({
  project: projectResponseModelSchema,
});

export const projectsCreateNewProjectErrorSchema = hTTPValidationErrorSchema;

export const projectsGetByIdDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    project_id: z.string(),
  }),
});

export const projectsGetByIdResponseSchema = projectExtendedResponseModelSchema;

export const projectsGetByIdErrorSchema = hTTPValidationErrorSchema;

export const projectsDeleteByIdDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    project_id: z.string(),
  }),
});

export const projectsDeleteByIdResponse2Schema = projectsDeleteByIdResponseSchema;

export const projectsDeleteByIdErrorSchema = hTTPValidationErrorSchema;

export const projectsStartConversionDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    project_id: z.string(),
  }),
});

export const projectsStartConversionResponse2Schema = projectsStartConversionResponseSchema;

export const projectsStartConversionErrorSchema = hTTPValidationErrorSchema;

export const projectsListSnapshotsDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    project_id: z.string(),
  }),
});

export const projectsListSnapshotsResponseSchema = projectSnapshotsResponseModelSchema;

export const projectsListSnapshotsErrorSchema = hTTPValidationErrorSchema;

export const projectsStreamAudioFromSnapshotDataSchema = z.object({
  body: bodyStreamProjectAudioV1ProjectsProjectIdSnapshotsProjectSnapshotIdStreamPostSchema.optional(),
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    project_id: z.string(),
    project_snapshot_id: z.string(),
  }),
});

export const projectsStreamAudioFromSnapshotResponseSchema = z.unknown();

export const projectsStreamAudioFromSnapshotErrorSchema = hTTPValidationErrorSchema;

export const projectsStreamArchiveWithAudioDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    project_id: z.string(),
    project_snapshot_id: z.string(),
  }),
});

export const projectsStreamArchiveWithAudioResponseSchema = z.unknown();

export const projectsStreamArchiveWithAudioErrorSchema = hTTPValidationErrorSchema;

export const projectsListChaptersDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    project_id: z.string(),
  }),
});

export const getChaptersResponseModelSchema = z.object({
  chapters: z.array(chapterResponseModelSchema),
});

export const projectsListChaptersErrorSchema = hTTPValidationErrorSchema;

export const projectsGetChapterByIdDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    chapter_id: z.string(),
    project_id: z.string(),
  }),
});

export const projectsGetChapterByIdResponseSchema = chapterResponseModelSchema;

export const projectsGetChapterByIdErrorSchema = hTTPValidationErrorSchema;

export const projectsDeleteChapterByIdDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    chapter_id: z.string(),
    project_id: z.string(),
  }),
});

export const projectsDeleteChapterByIdResponse2Schema = projectsDeleteChapterByIdResponseSchema;

export const projectsDeleteChapterByIdErrorSchema = hTTPValidationErrorSchema;

export const projectsStartChapterConversionDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    chapter_id: z.string(),
    project_id: z.string(),
  }),
});

export const projectsStartChapterConversionResponse2Schema = projectsStartChapterConversionResponseSchema;

export const projectsStartChapterConversionErrorSchema = hTTPValidationErrorSchema;

export const projectsGetChapterSnapshotsDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    chapter_id: z.string(),
    project_id: z.string(),
  }),
});

export const projectsGetChapterSnapshotsResponseSchema = chapterSnapshotsResponseModelSchema;

export const projectsGetChapterSnapshotsErrorSchema = hTTPValidationErrorSchema;

export const projectsStreamAudioFromSnapshotPostDataSchema = z.object({
  body: bodyStreamChapterAudioV1ProjectsProjectIdChaptersChapterIdSnapshotsChapterSnapshotIdStreamPostSchema.optional(),
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    chapter_id: z.string(),
    chapter_snapshot_id: z.string(),
    project_id: z.string(),
  }),
});

export const projectsStreamAudioFromSnapshotPostResponseSchema = z.unknown();

export const projectsStreamAudioFromSnapshotPostErrorSchema = hTTPValidationErrorSchema;

export const projectsUpdatePronunciationDictionariesDataSchema = z.object({
  body: bodyUpdatePronunciationDictionariesV1ProjectsProjectIdUpdatePronunciationDictionariesPostSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    project_id: z.string(),
  }),
});

export const projectsUpdatePronunciationDictionariesResponse2Schema =
  projectsUpdatePronunciationDictionariesResponseSchema;

export const projectsUpdatePronunciationDictionariesErrorSchema = hTTPValidationErrorSchema;

export const dubbingFileInLanguageResponseSchema = doDubbingResponseModelSchema;

export const dubbingFileInLanguageErrorSchema = hTTPValidationErrorSchema;

export const dubbingGetProjectMetadataDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    dubbing_id: z.string(),
  }),
});

export const dubbingGetProjectMetadataResponseSchema = dubbingMetadataResponseSchema;

export const dubbingGetProjectMetadataErrorSchema = hTTPValidationErrorSchema;

export const dubbingDeleteProjectDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    dubbing_id: z.string(),
  }),
});

export const dubbingDeleteProjectResponse2Schema = dubbingDeleteProjectResponseSchema;

export const dubbingDeleteProjectErrorSchema = hTTPValidationErrorSchema;

export const dubbingGetFileDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    dubbing_id: z.string(),
    language_code: z.string(),
  }),
});

export const dubbingGetFileResponseSchema = z.unknown();

export const dubbingGetFileErrorSchema = hTTPValidationErrorSchema;

export const workspaceGetSsoProviderAdminDataSchema = z.object({
  query: z.object({
    workspace_id: z.string(),
  }),
});

export const workspaceGetSsoProviderAdminResponseSchema = ssoProviderDBModelSchema;

export const workspaceGetSsoProviderAdminErrorSchema = hTTPValidationErrorSchema;

export const modelsListAvailableModelsDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
});

export const modelsListAvailableModelsResponse2Schema = modelsListAvailableModelsResponseSchema;

export const modelsListAvailableModelsErrorSchema = hTTPValidationErrorSchema;

export const audionativeCreateProjectWithEmbeddableHtmlResponseSchema = audioNativeCreateProjectResponseModelSchema;

export const audionativeCreateProjectWithEmbeddableHtmlErrorSchema = hTTPValidationErrorSchema;

export const voicesGetSharedVoicesDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      accent: z.string().optional(),
      age: z.string().optional(),
      category: z.string().optional(),
      descriptives: z.array(z.string()).optional(),
      featured: z.boolean().optional(),
      gender: z.string().optional(),
      language: z.string().optional(),
      owner_id: z.string().optional(),
      page: z.number().optional(),
      page_size: z.number().optional(),
      reader_app_enabled: z.boolean().optional(),
      search: z.string().optional(),
      sort: z.string().optional(),
      use_cases: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getLibraryVoicesResponseModelSchema = z.object({
  voices: z.array(libraryVoiceResponseModelSchema),
  has_more: z.boolean(),
  last_sort_id: z.string().optional(),
});

export const voicesGetSharedVoicesErrorSchema = hTTPValidationErrorSchema;

export const pronunciationDictionaryCreateFromFileResponseSchema = addPronunciationDictionaryResponseModelSchema;

export const pronunciationDictionaryCreateFromFileErrorSchema = hTTPValidationErrorSchema;

export const bodyAddRulesToThePronunciationDictionaryV1PronunciationDictionariesPronunciationDictionaryIdAddRulesPostSchema =
  z.object({
    rules: z.array(
      z.union([
        pronunciationDictionaryAliasRuleRequestModelSchema,
        pronunciationDictionaryPhonemeRuleRequestModelSchema,
      ]),
    ),
  });

export const pronunciationDictionaryAddRulesResponseSchema = addPronunciationDictionaryRulesResponseModelSchema;

export const pronunciationDictionaryAddRulesErrorSchema = hTTPValidationErrorSchema;

export const pronunciationDictionaryRemoveRulesDataSchema = z.object({
  body: bodyRemoveRulesFromThePronunciationDictionaryV1PronunciationDictionariesPronunciationDictionaryIdRemoveRulesPostSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    pronunciation_dictionary_id: z.string(),
  }),
});

export const pronunciationDictionaryRemoveRulesResponseSchema = removePronunciationDictionaryRulesResponseModelSchema;

export const pronunciationDictionaryRemoveRulesErrorSchema = hTTPValidationErrorSchema;

export const pronunciationDictionaryVersionDownloadDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    dictionary_id: z.string(),
    version_id: z.string(),
  }),
});

export const pronunciationDictionaryVersionDownloadResponse2Schema =
  pronunciationDictionaryVersionDownloadResponseSchema;

export const pronunciationDictionaryVersionDownloadErrorSchema = hTTPValidationErrorSchema;

export const redirectToMintlifyDocsGetResponse2Schema = redirectToMintlifyDocsGetResponseSchema;

export const redirectToMintlifyDocsGetErrorSchema = z.unknown();

export const pronunciationDictionaryGetMetadataDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    pronunciation_dictionary_id: z.string(),
  }),
});

export const pronunciationDictionaryGetMetadataResponseSchema = getPronunciationDictionaryMetadataResponseModelSchema;

export const pronunciationDictionaryGetMetadataErrorSchema = hTTPValidationErrorSchema;

export const pronunciationDictionaryListDictionariesDataSchema = z.object({
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  query: z
    .object({
      cursor: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getPronunciationDictionariesMetadataResponseModelSchema = z.object({
  pronunciation_dictionaries: z.array(getPronunciationDictionaryMetadataResponseModelSchema),
  next_cursor: z.string(),
  has_more: z.boolean(),
});

export const pronunciationDictionaryListDictionariesErrorSchema = hTTPValidationErrorSchema;

export const speechhistoryGetGeneratedAudioMetadataResponseSchema = getSpeechHistoryResponseModelSchema;

export const speechhistoryGetGeneratedAudioMetadataErrorSchema = hTTPValidationErrorSchema;

export const texttospeechConvertTextToSpeechDataSchema = z.object({
  body: bodyTextToSpeechV1TextToSpeechVoiceIdPostSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    voice_id: z.string(),
  }),
  query: z
    .object({
      optimize_streaming_latency: z.number().optional(),
      output_format: z.string().optional(),
    })
    .optional(),
});

export const voicegenerationCreateVoiceResponseSchema = voiceResponseModelSchema;

export const userGetSubscriptionInfoResponseSchema = extendedSubscriptionResponseModelSchema;

export const voicesListAllVoicesResponseSchema = getVoicesResponseModelSchema;

export const projectsCreateNewProjectResponseSchema = addProjectResponseModelSchema;

export const projectsListChaptersResponseSchema = getChaptersResponseModelSchema;

export const voicesGetSharedVoicesResponseSchema = getLibraryVoicesResponseModelSchema;

export const pronunciationDictionaryAddRulesDataSchema = z.object({
  body: bodyAddRulesToThePronunciationDictionaryV1PronunciationDictionariesPronunciationDictionaryIdAddRulesPostSchema,
  headers: z
    .object({
      'xi-api-key': z.string().optional(),
    })
    .optional(),
  path: z.object({
    pronunciation_dictionary_id: z.string(),
  }),
});

export const pronunciationDictionaryListDictionariesResponseSchema =
  getPronunciationDictionariesMetadataResponseModelSchema;
