// This file is auto-generated by @hey-api/openapi-ts

export type AddProjectResponseModel = {
  project: ProjectResponseModel;
};

export type AddPronunciationDictionaryResponseModel = {
  description?: string;
  id: string;
  name: string;
  created_by: string;
  creation_time_unix: number;
  version_id: string;
};

export type AddPronunciationDictionaryRulesResponseModel = {
  id: string;
  version_id: string;
};

export type AddVoiceResponseModel = {
  voice_id: string;
};

export type AudioNativeCreateProjectResponseModel = {
  project_id: string;
  converting: boolean;
  html_snippet: string;
};

export type Body_Add_a_pronunciation_dictionary_v1_pronunciation_dictionaries_add_from_file_post = {
  /**
   * A description of the pronunciation dictionary, used for identification only.
   */
  description?: string;
  /**
   * A lexicon .pls file which we will use to initialize the project with.
   */
  file?: Blob | File;
  /**
   * The name of the pronunciation dictionary, used for identification only.
   */
  name: string;
};

export type Body_Add_project_v1_projects_add_post = {
  /**
   * An optional name of the author of the project, this will be added as metadata to the mp3 file on project / chapter download.
   */
  title?: string;
  /**
   * The name of the project, used for identification only.
   */
  name: string;
  /**
   * An optional URL from which we will extract content to initialize the project. If this is set, 'from_url' must be null. If neither 'from_url' or 'from_document' are provided we will initialize the project as blank.
   */
  from_url?: string;
  /**
   * An optional .epub, .pdf, .txt or similar file can be provided. If provided, we will initialize the project with its content. If this is set, 'from_url' must be null.  If neither 'from_url' or 'from_document' are provided we will initialize the project as blank.
   */
  from_document?: Blob | File;
  /**
   * The voice_id that corresponds to the default voice used for new titles.
   */
  default_title_voice_id: string;
  /**
   * The voice_id that corresponds to the default voice used for new paragraphs.
   */
  default_paragraph_voice_id: string;
  /**
   * The model_id of the model to be used for this project, you can query GET https://api.elevenlabs.io/v1/models to list all available models.
   */
  default_model_id: string;
  /**
   * Output quality of the generated audio. Must be one of:
   * standard - standard output format, 128kbps with 44.1kHz sample rate.
   * high - high quality output format, 192kbps with 44.1kHz sample rate and major improvements on our side. Using this setting increases the character cost by 20%.
   * ultra - ultra quality output format, 192kbps with 44.1kHz sample rate and highest improvements on our side. Using this setting increases the character cost by 50%.
   * ultra lossless - ultra quality output format, 705.6kbps with 44.1kHz sample rate and highest improvements on our side in a fully lossless format. Using this setting increases the character cost by 100%.
   *
   */
  quality_preset?: string;
  /**
   * An optional name of the author of the project, this will be added as metadata to the mp3 file on project / chapter download.
   */
  author?: string;
  /**
   * An optional ISBN number of the project you want to create, this will be added as metadata to the mp3 file on project / chapter download.
   */
  isbn_number?: string;
  /**
   * [Deprecated] When the project is downloaded, should the returned audio have postprocessing in order to make it compliant with audiobook normalized volume requirements
   */
  acx_volume_normalization?: boolean;
  /**
   * When the project is downloaded, should the returned audio have postprocessing in order to make it compliant with audiobook normalized volume requirements
   */
  volume_normalization?: boolean;
  /**
   * A list of pronunciation dictionary locators (id, version_id) encoded as a list of JSON strings for pronunciation dictionaries to be applied to the text.  A list of json encoded strings is required as adding projects may occur through formData as opposed to jsonBody
   */
  pronunciation_dictionary_locators: Array<string>;
  /**
   * A url that will be called by our service when the project is converted with a json containing the status of the conversion
   */
  callback_url?: string;
};

export type Body_Add_rules_to_the_pronunciation_dictionary_v1_pronunciation_dictionaries__pronunciation_dictionary_id__add_rules_post =
  {
    /**
     * List of pronunciation rules. Rule can be either:
     * an alias rule: {'string_to_replace': 'a', 'type': 'alias', 'alias': 'b', }
     * or a phoneme rule: {'string_to_replace': 'a', 'type': 'phoneme', 'phoneme': 'b', 'alphabet': 'ipa' }
     */
    rules: Array<PronunciationDictionaryAliasRuleRequestModel | PronunciationDictionaryPhonemeRuleRequestModel>;
  };

export type Body_Add_sharing_voice_v1_voices_add__public_user_id___voice_id__post = {
  /**
   * The name that identifies this voice. This will be displayed in the dropdown of the website.
   */
  new_name: string;
};

export type Body_Add_voice_v1_voices_add_post = {
  /**
   * How would you describe the voice?
   */
  description?: string;
  /**
   * The name that identifies this voice. This will be displayed in the dropdown of the website.
   */
  name: string;
  /**
   * One or more audio files to clone the voice from
   */
  files: Array<Blob | File>;
  /**
   * Serialized labels dictionary for the voice.
   */
  labels?: string;
};

export type Body_Create_a_previously_generated_voice_v1_voice_generation_create_voice_post = {
  /**
   * Name to use for the created voice.
   */
  voice_name: string;
  /**
   * Description to use for the created voice.
   */
  voice_description: string;
  /**
   * The generated_voice_id to create, call POST /v1/voice-generation/generate-voice and fetch the generated_voice_id from the response header if don't have one yet.
   */
  generated_voice_id: string;
  /**
   * Optional, metadata to add to the created voice. Defaults to None.
   */
  labels?: {
    [key: string]: string;
  };
};

export type Body_Creates_AudioNative_enabled_project__v1_audio_native_post = {
  /**
   * Title used in the player and inserted at the top of the uploaded article. If not provided, the default title set in the Player settings is used.
   */
  title?: string;
  /**
   * Project name.
   */
  name: string;
  /**
   * Image URL used in the player. If not provided, default image set in the Player settings is used.
   */
  image?: string;
  /**
   * Author used in the player and inserted at the start of the uploaded article. If not provided, the default author set in the Player settings is used.
   */
  author?: string;
  /**
   * Whether to use small player or not. If not provided, default value set in the Player settings is used.
   */
  small?: boolean;
  /**
   * Text color used in the player. If not provided, default text color set in the Player settings is used.
   */
  text_color?: string;
  /**
   * Background color used in the player. If not provided, default background color set in the Player settings is used.
   */
  background_color?: string;
  /**
   * Specifies for how many minutes to persist the session across page reloads. If not provided, default sessionization set in the Player settings is used.
   */
  sessionization?: number;
  /**
   * Voice ID used to voice the content. If not provided, default voice ID set in the Player settings is used.
   */
  voice_id?: string;
  /**
   * TTS Model ID used in the player. If not provided, default model ID set in the Player settings is used.
   */
  model_id?: string;
  /**
   * Either txt or HTML input file containing the article content. HTML should be formatted as follows '&lt;html&gt;&lt;body&gt;&lt;div&gt;&lt;p&gt;Your content&lt;/p&gt;&lt;h5&gt;More of your content&lt;/h5&gt;&lt;p&gt;Some more of your content&lt;/p&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;'
   */
  file: Blob | File;
  /**
   * Whether to auto convert the project to audio or not.
   */
  auto_convert?: boolean;
};

export type Body_Download_history_items_v1_history_download_post = {
  /**
   * A list of history items to download, you can get IDs of history items and other metadata using the GET https://api.elevenlabs.io/v1/history endpoint.
   */
  history_item_ids: Array<string>;
  /**
   * Output format to transcode the audio file, can be wav or default.
   */
  output_format?: string;
};

export type Body_Dub_a_video_or_an_audio_file_v1_dubbing_post = {
  /**
   * automatic or manual.
   */
  mode?: string;
  /**
   * One or more audio files to clone the voice from
   */
  file?: Blob | File;
  /**
   * CSV file containing transcription/translation metadata
   */
  csv_file?: Blob | File;
  /**
   * For use only with csv input
   */
  foreground_audio_file?: Blob | File;
  /**
   * For use only with csv input
   */
  background_audio_file?: Blob | File;
  /**
   * Name of the dubbing project.
   */
  name?: string;
  /**
   * URL of the source video/audio file.
   */
  source_url?: string;
  /**
   * Source language.
   */
  source_lang?: string;
  /**
   * The Target language to dub the content into. Can be none if dubbing studio editor is enabled and running manual mode
   */
  target_lang?: string;
  /**
   * Number of speakers to use for the dubbing.
   */
  num_speakers?: number;
  /**
   * Whether to apply watermark to the output video.
   */
  watermark?: boolean;
  /**
   * Start time of the source video/audio file.
   */
  start_time?: number;
  /**
   * End time of the source video/audio file.
   */
  end_time?: number;
  /**
   * Whether to use the highest resolution available.
   */
  highest_resolution?: boolean;
  /**
   * Whether to prepare dub for edits in dubbing studio.
   */
  dubbing_studio?: boolean;
};

export type Body_Edit_voice_v1_voices__voice_id__edit_post = {
  /**
   * How would you describe the voice?
   */
  description?: string;
  /**
   * The name that identifies this voice. This will be displayed in the dropdown of the website.
   */
  name: string;
  /**
   * Audio files to add to the voice
   */
  files?: Array<Blob | File>;
  /**
   * Serialized labels dictionary for the voice.
   */
  labels?: string;
};

export type Body_Generate_a_random_voice_v1_voice_generation_generate_voice_post = {
  /**
   * Category code corresponding to the gender of the generated voice. Possible values: female, male.
   */
  gender: 'female' | 'male';
  /**
   * Category code corresponding to the accent of the generated voice. Possible values: american, british, african, australian, indian.
   */
  accent: string;
  /**
   * Category code corresponding to the age of the generated voice. Possible values: young, middle_aged, old.
   */
  age: 'young' | 'middle_aged' | 'old';
  /**
   * The strength of the accent of the generated voice. Has to be between 0.3 and 2.0.
   */
  accent_strength: number;
  /**
   * Text to generate, text length has to be between 100 and 1000.
   */
  text: string;
};

/**
 * Category code corresponding to the gender of the generated voice. Possible values: female, male.
 */
export type gender = 'female' | 'male';

/**
 * Category code corresponding to the age of the generated voice. Possible values: young, middle_aged, old.
 */
export type age = 'young' | 'middle_aged' | 'old';

export type Body_Remove_rules_from_the_pronunciation_dictionary_v1_pronunciation_dictionaries__pronunciation_dictionary_id__remove_rules_post =
  {
    /**
     * List of strings to remove from the pronunciation dictionary.
     */
    rule_strings: Array<string>;
  };

export type Body_Speech_to_Speech_Streaming_v1_speech_to_speech__voice_id__stream_post = {
  /**
   * The audio file which holds the content and emotion that will control the generated speech.
   */
  audio: Blob | File;
  /**
   * Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for speech to speech, you can check this using the can_do_voice_conversion property.
   */
  model_id?: string;
  /**
   * Voice settings overriding stored setttings for the given voice. They are applied only on the given request. Needs to be send as a JSON encoded string.
   */
  voice_settings?: string;
};

export type Body_Speech_to_Speech_v1_speech_to_speech__voice_id__post = {
  /**
   * The audio file which holds the content and emotion that will control the generated speech.
   */
  audio: Blob | File;
  /**
   * Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for speech to speech, you can check this using the can_do_voice_conversion property.
   */
  model_id?: string;
  /**
   * Voice settings overriding stored setttings for the given voice. They are applied only on the given request. Needs to be send as a JSON encoded string.
   */
  voice_settings?: string;
};

export type Body_Stream_chapter_audio_v1_projects__project_id__chapters__chapter_id__snapshots__chapter_snapshot_id__stream_post =
  {
    /**
     * Whether to convert the audio to mpeg format.
     */
    convert_to_mpeg?: boolean;
  };

export type Body_Stream_project_audio_v1_projects__project_id__snapshots__project_snapshot_id__stream_post = {
  /**
   * Whether to convert the audio to mpeg format.
   */
  convert_to_mpeg?: boolean;
};

export type Body_Text_to_speech_v1_text_to_speech__voice_id__post = {
  /**
   * The text that will get converted into speech.
   */
  text: string;
  /**
   * Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for text to speech, you can check this using the can_do_text_to_speech property.
   */
  model_id?: string;
  voice_settings?: VoiceSettingsResponseModel;
  /**
   * A list of pronunciation dictionary locators (id, version_id) to be applied to the text. They will be applied in order. You may have up to 3 locators per request
   */
  pronunciation_dictionary_locators?: Array<PronunciationDictionaryVersionLocatorDBModel>;
};

export type Body_Text_to_speech_v1_text_to_speech__voice_id__stream_post = {
  /**
   * The text that will get converted into speech.
   */
  text: string;
  /**
   * Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for text to speech, you can check this using the can_do_text_to_speech property.
   */
  model_id?: string;
  voice_settings?: VoiceSettingsResponseModel;
  /**
   * A list of pronunciation dictionary locators (id, version_id) to be applied to the text. They will be applied in order. You may have up to 3 locators per request
   */
  pronunciation_dictionary_locators?: Array<PronunciationDictionaryVersionLocatorDBModel>;
};

export type Body_Update_Pronunciation_Dictionaries_v1_projects__project_id__update_pronunciation_dictionaries_post = {
  /**
   * A list of pronunciation dictionary locators (id, version_id) encoded as a list of JSON strings for pronunciation dictionaries to be applied to the text.  A list of json encoded strings is required as adding projects may occur through formData as opposed to jsonBody
   */
  pronunciation_dictionary_locators: Array<PronunciationDictionaryVersionLocatorDBModel>;
};

export type ChapterResponseModel = {
  chapter_id: string;
  name: string;
  last_conversion_date_unix: number;
  conversion_progress: number;
  can_be_downloaded: boolean;
  state: 'default' | 'converting';
  statistics: ChapterStatisticsResponseModel;
};

export type state = 'default' | 'converting';

export type ChapterSnapshotResponseModel = {
  chapter_snapshot_id: string;
  project_id: string;
  chapter_id: string;
  created_at_unix: number;
  name: string;
};

export type ChapterSnapshotsResponseModel = {
  snapshots: Array<ChapterSnapshotResponseModel>;
};

export type ChapterStatisticsResponseModel = {
  characters_unconverted: number;
  characters_converted: number;
  paragraphs_converted: number;
  paragraphs_unconverted: number;
};

export type DoDubbingResponseModel = {
  dubbing_id: string;
  expected_duration_sec: number;
};

export type DubbingDeleteProjectResponse = {
  [key: string]: unknown;
};

export type DubbingMetadataResponse = {
  dubbing_id: string;
  name: string;
  status: string;
  error: string;
  target_languages: Array<string>;
};

export type ExtendedSubscriptionResponseModel = {
  tier: string;
  character_count: number;
  character_limit: number;
  can_extend_character_limit: boolean;
  allowed_to_extend_character_limit: boolean;
  next_character_count_reset_unix: number;
  voice_limit: number;
  max_voice_add_edits: number;
  voice_add_edit_counter: number;
  professional_voice_limit: number;
  can_extend_voice_limit: boolean;
  can_use_instant_voice_cloning: boolean;
  can_use_professional_voice_cloning: boolean;
  currency: 'usd' | 'eur';
  status: 'trialing' | 'active' | 'incomplete' | 'incomplete_expired' | 'past_due' | 'canceled' | 'unpaid' | 'free';
  billing_period: 'monthly_period' | 'annual_period';
  next_invoice: InvoiceResponseModel;
  has_open_invoices: boolean;
};

export type currency = 'usd' | 'eur';

export type status =
  | 'trialing'
  | 'active'
  | 'incomplete'
  | 'incomplete_expired'
  | 'past_due'
  | 'canceled'
  | 'unpaid'
  | 'free';

export type billing_period = 'monthly_period' | 'annual_period';

export type FeedbackResponseModel = {
  thumbs_up: boolean;
  feedback: string;
  emotions: boolean;
  inaccurate_clone: boolean;
  glitches: boolean;
  audio_quality: boolean;
  other: boolean;
  review_status?: string;
};

export type FineTuningResponseModel = {
  is_allowed_to_fine_tune: boolean;
  finetuning_state: 'not_started' | 'queued' | 'fine_tuning' | 'fine_tuned' | 'failed' | 'delayed';
  verification_failures: Array<string>;
  verification_attempts_count: number;
  manual_verification_requested: boolean;
  language?: string;
  finetuning_progress?: {
    [key: string]: number;
  };
  message?: string;
  dataset_duration_seconds?: number;
  verification_attempts?: Array<VerificationAttemptResponseModel>;
  slice_ids?: Array<string>;
  manual_verification?: ManualVerificationResponseModel;
};

export type finetuning_state = 'not_started' | 'queued' | 'fine_tuning' | 'fine_tuned' | 'failed' | 'delayed';

export type GetChaptersResponseModel = {
  chapters: Array<ChapterResponseModel>;
};

export type GetLibraryVoicesResponseModel = {
  voices: Array<LibraryVoiceResponseModel>;
  has_more: boolean;
  last_sort_id?: string;
};

export type GetProjectsResponseModel = {
  projects: Array<ProjectResponseModel>;
};

export type GetPronunciationDictionariesMetadataResponseModel = {
  pronunciation_dictionaries: Array<GetPronunciationDictionaryMetadataResponseModel>;
  next_cursor: string;
  has_more: boolean;
};

export type GetPronunciationDictionaryMetadataResponseModel = {
  description?: string;
  id: string;
  latest_version_id: string;
  name: string;
  created_by: string;
  creation_time_unix: number;
};

export type GetSpeechHistoryResponseModel = {
  history: Array<SpeechHistoryItemResponseModel>;
  last_history_item_id: string;
  has_more: boolean;
};

export type GetVoicesResponseModel = {
  voices: Array<VoiceResponseModel>;
};

export type HTTPValidationError = {
  detail?: Array<ValidationError>;
};

export type InvoiceResponseModel = {
  amount_due_cents: number;
  next_payment_attempt_unix: number;
};

export type LanguageResponseModel = {
  language_id: string;
  name: string;
};

export type LibraryVoiceResponseModel = {
  description: string;
  public_owner_id: string;
  voice_id: string;
  date_unix: number;
  name: string;
  accent: string;
  gender: string;
  age: string;
  descriptive: string;
  use_case: string;
  category: string;
  language: string;
  preview_url: string;
  usage_character_count_1y: number;
  usage_character_count_7d: number;
  cloned_by_count: number;
  rate: number;
  free_users_allowed: boolean;
  live_moderation_enabled: boolean;
  featured: boolean;
  notice_period?: number;
  instagram_username?: string;
  twitter_username?: string;
  youtube_username?: string;
  tiktok_username?: string;
};

export type ManualVerificationFileResponseModel = {
  file_id: string;
  file_name: string;
  mime_type: string;
  size_bytes: number;
  upload_date_unix: number;
};

export type ManualVerificationResponseModel = {
  extra_text: string;
  request_time_unix: number;
  files: Array<ManualVerificationFileResponseModel>;
};

export type ModelResponseModel = {
  description: string;
  model_id: string;
  name: string;
  can_be_finetuned: boolean;
  can_do_text_to_speech: boolean;
  can_do_voice_conversion: boolean;
  can_use_style: boolean;
  can_use_speaker_boost: boolean;
  serves_pro_voices: boolean;
  token_cost_factor: number;
  requires_alpha_access: boolean;
  max_characters_request_free_user: number;
  max_characters_request_subscribed_user: number;
  languages: Array<LanguageResponseModel>;
};

export type ModelsListAvailableModelsResponse = Array<ModelResponseModel>;

export type ProjectExtendedResponseModel = {
  project_id: string;
  name: string;
  create_date_unix: number;
  default_title_voice_id: string;
  default_paragraph_voice_id: string;
  default_model_id: string;
  last_conversion_date_unix: number;
  can_be_downloaded: boolean;
  state: 'default' | 'converting' | 'in_queue';
  chapters: Array<ChapterResponseModel>;
};

export type state2 = 'default' | 'converting' | 'in_queue';

export type ProjectResponseModel = {
  title: string;
  project_id: string;
  name: string;
  create_date_unix: number;
  default_title_voice_id: string;
  default_paragraph_voice_id: string;
  default_model_id: string;
  last_conversion_date_unix: number;
  can_be_downloaded: boolean;
  author: string;
  isbn_number: string;
  volume_normalization: boolean;
  state: 'default' | 'converting';
};

export type ProjectsDeleteByIdResponse = {
  [key: string]: unknown;
};

export type ProjectsDeleteChapterByIdResponse = {
  [key: string]: unknown;
};

export type ProjectSnapshotResponseModel = {
  project_snapshot_id: string;
  project_id: string;
  created_at_unix: number;
  name: string;
};

export type ProjectSnapshotsResponseModel = {
  snapshots: Array<ProjectSnapshotResponseModel>;
};

export type ProjectsStartChapterConversionResponse = {
  [key: string]: unknown;
};

export type ProjectsStartConversionResponse = {
  [key: string]: unknown;
};

export type ProjectsUpdatePronunciationDictionariesResponse = {
  [key: string]: unknown;
};

export type PronunciationDictionaryAliasRuleRequestModel = {
  type: 'alias';
  string_to_replace: string;
  alias: string;
};

export type type = 'alias';

export type PronunciationDictionaryPhonemeRuleRequestModel = {
  type: 'phoneme';
  string_to_replace: string;
  phoneme: string;
  alphabet: string;
};

export type type2 = 'phoneme';

export type PronunciationDictionaryVersionDownloadResponse = {
  [key: string]: unknown;
};

export type PronunciationDictionaryVersionLocatorDBModel = {
  pronunciation_dictionary_id: string;
  version_id: string;
};

export type RecordingResponseModel = {
  recording_id: string;
  mime_type: string;
  size_bytes: number;
  upload_date_unix: number;
  transcription: string;
};

export type RedirectToMintlifyDocsGetResponse = {
  [key: string]: unknown;
};

export type RemovePronunciationDictionaryRulesResponseModel = {
  id: string;
  version_id: string;
};

export type SampleResponseModel = {
  sample_id: string;
  file_name: string;
  mime_type: string;
  size_bytes: number;
  hash: string;
};

export type SamplesRemoveByIdResponse = {
  [key: string]: unknown;
};

export type SpeechhistoryDeleteHistoryItemByIdResponse = {
  [key: string]: unknown;
};

export type SpeechHistoryItemResponseModel = {
  history_item_id: string;
  request_id: string;
  voice_id: string;
  model_id: string;
  voice_name: string;
  voice_category: 'premade' | 'cloned' | 'generated' | 'professional';
  text: string;
  date_unix: number;
  character_count_change_from: number;
  character_count_change_to: number;
  content_type: string;
  state: 'created' | 'deleted' | 'processing';
  settings: {
    [key: string]: unknown;
  };
  feedback: FeedbackResponseModel;
  share_link_id: string;
  source: 'TTS' | 'STS';
};

export type voice_category = 'premade' | 'cloned' | 'generated' | 'professional';

export type state3 = 'created' | 'deleted' | 'processing';

export type source = 'TTS' | 'STS';

export type SsoProviderDBModel = {
  provider_type: 'saml' | 'oidc';
  provider_id: string;
  domains: Array<string>;
};

export type provider_type = 'saml' | 'oidc';

export type SubscriptionResponseModel = {
  tier: string;
  character_count: number;
  character_limit: number;
  can_extend_character_limit: boolean;
  allowed_to_extend_character_limit: boolean;
  next_character_count_reset_unix: number;
  voice_limit: number;
  max_voice_add_edits: number;
  voice_add_edit_counter: number;
  professional_voice_limit: number;
  can_extend_voice_limit: boolean;
  can_use_instant_voice_cloning: boolean;
  can_use_professional_voice_cloning: boolean;
  currency: 'usd' | 'eur';
  status: 'trialing' | 'active' | 'incomplete' | 'incomplete_expired' | 'past_due' | 'canceled' | 'unpaid' | 'free';
  billing_period: 'monthly_period' | 'annual_period';
};

export type UserResponseModel = {
  subscription: SubscriptionResponseModel;
  is_new_user: boolean;
  xi_api_key: string;
  can_use_delayed_payment_methods: boolean;
  is_onboarding_completed: boolean;
  first_name?: string;
};

export type ValidationError = {
  loc: Array<string | number>;
  msg: string;
  type: string;
};

export type VerificationAttemptResponseModel = {
  text: string;
  date_unix: number;
  accepted: boolean;
  similarity: number;
  levenshtein_distance: number;
  recording?: RecordingResponseModel;
};

export type VoiceGenerationParameterOptionResponseModel = {
  name: string;
  code: string;
};

export type VoiceGenerationParameterResponseModel = {
  genders: Array<VoiceGenerationParameterOptionResponseModel>;
  accents: Array<VoiceGenerationParameterOptionResponseModel>;
  ages: Array<VoiceGenerationParameterOptionResponseModel>;
  minimum_characters: number;
  maximum_characters: number;
  minimum_accent_strength: number;
  maximum_accent_strength: number;
};

export type VoiceResponseModel = {
  description: string;
  voice_id: string;
  name: string;
  samples: Array<SampleResponseModel>;
  category: string;
  fine_tuning: FineTuningResponseModel;
  labels: {
    [key: string]: string;
  };
  preview_url: string;
  available_for_tiers: Array<string>;
  settings: VoiceSettingsResponseModel;
  sharing: VoiceSharingResponseModel;
  high_quality_base_model_ids: Array<string>;
  safety_control?: 'NONE' | 'BAN' | 'CAPTCHA' | 'CAPTCHA_AND_MODERATION';
  voice_verification?: VoiceVerificationResponseModel;
  owner_id?: string;
  permission_on_resource?: string;
};

export type safety_control = 'NONE' | 'BAN' | 'CAPTCHA' | 'CAPTCHA_AND_MODERATION';

export type VoicesDeleteByIdResponse = {
  [key: string]: unknown;
};

export type VoicesEditSettingsPostResponse = {
  [key: string]: unknown;
};

export type VoiceSettingsResponseModel = {
  stability: number;
  similarity_boost: number;
  style?: number;
  use_speaker_boost?: boolean;
};

export type VoiceSharingResponseModel = {
  description: string;
  status: 'enabled' | 'disabled' | 'copied' | 'copied_disabled';
  history_item_sample_id: string;
  date_unix: number;
  whitelisted_emails: Array<string>;
  public_owner_id: string;
  original_voice_id: string;
  financial_rewards_enabled: boolean;
  free_users_allowed: boolean;
  live_moderation_enabled: boolean;
  rate: number;
  notice_period: number;
  disable_at_unix: number;
  voice_mixing_allowed: boolean;
  featured: boolean;
  category: 'generated' | 'professional' | 'high_quality';
  reader_app_enabled: boolean;
  ban_reason: string;
  liked_by_count: number;
  cloned_by_count: number;
  name: string;
  labels: {
    [key: string]: string;
  };
  review_status: 'not_requested' | 'pending' | 'declined' | 'allowed' | 'allowed_with_changes';
  review_message: string;
  enabled_in_library: boolean;
  instagram_username?: string;
  twitter_username?: string;
  youtube_username?: string;
  tiktok_username?: string;
};

export type status2 = 'enabled' | 'disabled' | 'copied' | 'copied_disabled';

export type category = 'generated' | 'professional' | 'high_quality';

export type review_status = 'not_requested' | 'pending' | 'declined' | 'allowed' | 'allowed_with_changes';

export type VoicesUpdateVoiceByIdResponse = {
  [key: string]: unknown;
};

export type VoiceVerificationResponseModel = {
  requires_verification: boolean;
  is_verified: boolean;
  verification_failures: Array<string>;
  verification_attempts_count: number;
  language?: string;
  verification_attempts?: Array<VerificationAttemptResponseModel>;
};

export type SpeechhistoryGetGeneratedAudioMetadataData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  query?: {
    /**
     * How many history items to return at maximum. Can not exceed 1000, defaults to 100.
     */
    page_size?: number;
    /**
     * After which ID to start fetching, use this parameter to paginate across a large collection of history items. In case this parameter is not provided history items will be fetched starting from the most recently created one ordered descending by their creation date.
     */
    start_after_history_item_id?: string;
    /**
     * Voice ID to be filtered for, you can use GET https://api.elevenlabs.io/v1/voices to receive a list of voices and their IDs.
     */
    voice_id?: string;
  };
};

export type SpeechhistoryGetGeneratedAudioMetadataResponse = GetSpeechHistoryResponseModel;

export type SpeechhistoryGetGeneratedAudioMetadataError = HTTPValidationError;

export type SpeechhistoryGetHistoryItemByIdData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * History item ID to be used, you can use GET https://api.elevenlabs.io/v1/history to receive a list of history items and their IDs.
     */
    history_item_id: string;
  };
};

export type SpeechhistoryGetHistoryItemByIdResponse = SpeechHistoryItemResponseModel;

export type SpeechhistoryGetHistoryItemByIdError = HTTPValidationError;

export type SpeechhistoryDeleteHistoryItemByIdData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * History item ID to be used, you can use GET https://api.elevenlabs.io/v1/history to receive a list of history items and their IDs.
     */
    history_item_id: string;
  };
};

export type SpeechhistoryDeleteHistoryItemByIdResponse2 = SpeechhistoryDeleteHistoryItemByIdResponse;

export type SpeechhistoryDeleteHistoryItemByIdError = HTTPValidationError;

export type SpeechhistoryGetHistoryItemAudioData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * History item ID to be used, you can use GET https://api.elevenlabs.io/v1/history to receive a list of history items and their IDs.
     */
    history_item_id: string;
  };
};

export type SpeechhistoryGetHistoryItemAudioResponse = unknown;

export type SpeechhistoryGetHistoryItemAudioError = HTTPValidationError;

export type SpeechhistoryDownloadHistoryItemsData = {
  body: Body_Download_history_items_v1_history_download_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type SpeechhistoryDownloadHistoryItemsResponse = unknown;

export type SpeechhistoryDownloadHistoryItemsError = HTTPValidationError;

export type SamplesRemoveByIdData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Sample ID to be used, you can use GET https://api.elevenlabs.io/v1/voices/{voice_id} to list all the available samples for a voice.
     */
    sample_id: string;
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
};

export type SamplesRemoveByIdResponse2 = SamplesRemoveByIdResponse;

export type SamplesRemoveByIdError = HTTPValidationError;

export type SamplesGetAudioFromSampleData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Sample ID to be used, you can use GET https://api.elevenlabs.io/v1/voices/{voice_id} to list all the available samples for a voice.
     */
    sample_id: string;
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
};

export type SamplesGetAudioFromSampleResponse = unknown;

export type SamplesGetAudioFromSampleError = HTTPValidationError;

export type TexttospeechConvertTextToSpeechData = {
  body: Body_Text_to_speech_v1_text_to_speech__voice_id__post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
  query?: {
    /**
     * You can turn on latency optimizations at some cost of quality. The best possible final latency varies by model. Possible values:
     * 0 - default mode (no latency optimizations)
     * 1 - normal latency optimizations (about 50% of possible latency improvement of option 3)
     * 2 - strong latency optimizations (about 75% of possible latency improvement of option 3)
     * 3 - max latency optimizations
     * 4 - max latency optimizations, but also with text normalizer turned off for even more latency savings (best latency, but can mispronounce eg numbers and dates).
     *
     * Defaults to 0.
     *
     */
    optimize_streaming_latency?: number;
    /**
     * Output format of the generated audio. Must be one of:
     * mp3_22050_32 - output format, mp3 with 22.05kHz sample rate at 32kbps.
     * mp3_44100_32 - output format, mp3 with 44.1kHz sample rate at 32kbps.
     * mp3_44100_64 - output format, mp3 with 44.1kHz sample rate at 64kbps.
     * mp3_44100_96 - output format, mp3 with 44.1kHz sample rate at 96kbps.
     * mp3_44100_128 - default output format, mp3 with 44.1kHz sample rate at 128kbps.
     * mp3_44100_192 - output format, mp3 with 44.1kHz sample rate at 192kbps. Requires you to be subscribed to Creator tier or above.
     * pcm_16000 - PCM format (S16LE) with 16kHz sample rate.
     * pcm_22050 - PCM format (S16LE) with 22.05kHz sample rate.
     * pcm_24000 - PCM format (S16LE) with 24kHz sample rate.
     * pcm_44100 - PCM format (S16LE) with 44.1kHz sample rate. Requires you to be subscribed to Pro tier or above.
     * ulaw_8000 - μ-law format (sometimes written mu-law, often approximated as u-law) with 8kHz sample rate. Note that this format is commonly used for Twilio audio inputs.
     *
     */
    output_format?: string;
  };
};

export type TexttospeechConvertTextToSpeechResponse = unknown;

export type TexttospeechConvertTextToSpeechError = HTTPValidationError;

export type TexttospeechConvertTextToSpeechStreamData = {
  body: Body_Text_to_speech_v1_text_to_speech__voice_id__stream_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
  query?: {
    /**
     * You can turn on latency optimizations at some cost of quality. The best possible final latency varies by model. Possible values:
     * 0 - default mode (no latency optimizations)
     * 1 - normal latency optimizations (about 50% of possible latency improvement of option 3)
     * 2 - strong latency optimizations (about 75% of possible latency improvement of option 3)
     * 3 - max latency optimizations
     * 4 - max latency optimizations, but also with text normalizer turned off for even more latency savings (best latency, but can mispronounce eg numbers and dates).
     *
     * Defaults to 0.
     *
     */
    optimize_streaming_latency?: number;
    /**
     * Output format of the generated audio. Must be one of:
     * mp3_22050_32 - output format, mp3 with 22.05kHz sample rate at 32kbps.
     * mp3_44100_32 - output format, mp3 with 44.1kHz sample rate at 32kbps.
     * mp3_44100_64 - output format, mp3 with 44.1kHz sample rate at 64kbps.
     * mp3_44100_96 - output format, mp3 with 44.1kHz sample rate at 96kbps.
     * mp3_44100_128 - default output format, mp3 with 44.1kHz sample rate at 128kbps.
     * mp3_44100_192 - output format, mp3 with 44.1kHz sample rate at 192kbps. Requires you to be subscribed to Creator tier or above.
     * pcm_16000 - PCM format (S16LE) with 16kHz sample rate.
     * pcm_22050 - PCM format (S16LE) with 22.05kHz sample rate.
     * pcm_24000 - PCM format (S16LE) with 24kHz sample rate.
     * pcm_44100 - PCM format (S16LE) with 44.1kHz sample rate. Requires you to be subscribed to Pro tier or above.
     * ulaw_8000 - μ-law format (sometimes written mu-law, often approximated as u-law) with 8kHz sample rate. Note that this format is commonly used for Twilio audio inputs.
     *
     */
    output_format?: string;
  };
};

export type TexttospeechConvertTextToSpeechStreamResponse = unknown;

export type TexttospeechConvertTextToSpeechStreamError = HTTPValidationError;

export type SpeechtospeechCreateWithVoiceData = {
  body: Body_Speech_to_Speech_v1_speech_to_speech__voice_id__post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
  query?: {
    /**
     * You can turn on latency optimizations at some cost of quality. The best possible final latency varies by model. Possible values:
     * 0 - default mode (no latency optimizations)
     * 1 - normal latency optimizations (about 50% of possible latency improvement of option 3)
     * 2 - strong latency optimizations (about 75% of possible latency improvement of option 3)
     * 3 - max latency optimizations
     * 4 - max latency optimizations, but also with text normalizer turned off for even more latency savings (best latency, but can mispronounce eg numbers and dates).
     *
     * Defaults to 0.
     *
     */
    optimize_streaming_latency?: number;
    /**
     * Output format of the generated audio. Must be one of:
     * mp3_22050_32 - output format, mp3 with 22.05kHz sample rate at 32kbps.
     * mp3_44100_32 - output format, mp3 with 44.1kHz sample rate at 32kbps.
     * mp3_44100_64 - output format, mp3 with 44.1kHz sample rate at 64kbps.
     * mp3_44100_96 - output format, mp3 with 44.1kHz sample rate at 96kbps.
     * mp3_44100_128 - default output format, mp3 with 44.1kHz sample rate at 128kbps.
     * mp3_44100_192 - output format, mp3 with 44.1kHz sample rate at 192kbps. Requires you to be subscribed to Creator tier or above.
     * pcm_16000 - PCM format (S16LE) with 16kHz sample rate.
     * pcm_22050 - PCM format (S16LE) with 22.05kHz sample rate.
     * pcm_24000 - PCM format (S16LE) with 24kHz sample rate.
     * pcm_44100 - PCM format (S16LE) with 44.1kHz sample rate. Requires you to be subscribed to Pro tier or above.
     * ulaw_8000 - μ-law format (sometimes written mu-law, often approximated as u-law) with 8kHz sample rate. Note that this format is commonly used for Twilio audio inputs.
     *
     */
    output_format?: string;
  };
};

export type SpeechtospeechCreateWithVoiceResponse = unknown;

export type SpeechtospeechCreateWithVoiceError = HTTPValidationError;

export type SpeechtospeechCreateWithVoice1Data = {
  body: Body_Speech_to_Speech_Streaming_v1_speech_to_speech__voice_id__stream_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
  query?: {
    /**
     * You can turn on latency optimizations at some cost of quality. The best possible final latency varies by model. Possible values:
     * 0 - default mode (no latency optimizations)
     * 1 - normal latency optimizations (about 50% of possible latency improvement of option 3)
     * 2 - strong latency optimizations (about 75% of possible latency improvement of option 3)
     * 3 - max latency optimizations
     * 4 - max latency optimizations, but also with text normalizer turned off for even more latency savings (best latency, but can mispronounce eg numbers and dates).
     *
     * Defaults to 0.
     *
     */
    optimize_streaming_latency?: number;
    /**
     * Output format of the generated audio. Must be one of:
     * mp3_22050_32 - output format, mp3 with 22.05kHz sample rate at 32kbps.
     * mp3_44100_32 - output format, mp3 with 44.1kHz sample rate at 32kbps.
     * mp3_44100_64 - output format, mp3 with 44.1kHz sample rate at 64kbps.
     * mp3_44100_96 - output format, mp3 with 44.1kHz sample rate at 96kbps.
     * mp3_44100_128 - default output format, mp3 with 44.1kHz sample rate at 128kbps.
     * mp3_44100_192 - output format, mp3 with 44.1kHz sample rate at 192kbps. Requires you to be subscribed to Creator tier or above.
     * pcm_16000 - PCM format (S16LE) with 16kHz sample rate.
     * pcm_22050 - PCM format (S16LE) with 22.05kHz sample rate.
     * pcm_24000 - PCM format (S16LE) with 24kHz sample rate.
     * pcm_44100 - PCM format (S16LE) with 44.1kHz sample rate. Requires you to be subscribed to Pro tier or above.
     * ulaw_8000 - μ-law format (sometimes written mu-law, often approximated as u-law) with 8kHz sample rate. Note that this format is commonly used for Twilio audio inputs.
     *
     */
    output_format?: string;
  };
};

export type SpeechtospeechCreateWithVoice1Response = unknown;

export type SpeechtospeechCreateWithVoice1Error = HTTPValidationError;

export type VoicegenerationGetVoiceGenerationParametersResponse = VoiceGenerationParameterResponseModel;

export type VoicegenerationGetVoiceGenerationParametersError = unknown;

export type VoicegenerationGenerateRandomVoiceData = {
  body: Body_Generate_a_random_voice_v1_voice_generation_generate_voice_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type VoicegenerationGenerateRandomVoiceResponse = unknown;

export type VoicegenerationGenerateRandomVoiceError = HTTPValidationError;

export type VoicegenerationCreateVoiceData = {
  body: Body_Create_a_previously_generated_voice_v1_voice_generation_create_voice_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type VoicegenerationCreateVoiceResponse = VoiceResponseModel;

export type VoicegenerationCreateVoiceError = HTTPValidationError;

export type UserGetSubscriptionInfoData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type UserGetSubscriptionInfoResponse = ExtendedSubscriptionResponseModel;

export type UserGetSubscriptionInfoError = HTTPValidationError;

export type UserGetInfoData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type UserGetInfoResponse = UserResponseModel;

export type UserGetInfoError = HTTPValidationError;

export type VoicesListAllVoicesData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type VoicesListAllVoicesResponse = GetVoicesResponseModel;

export type VoicesListAllVoicesError = HTTPValidationError;

export type VoicesGetDefaultVoiceSettingsResponse = VoiceSettingsResponseModel;

export type VoicesGetDefaultVoiceSettingsError = unknown;

export type VoicesGetSettingsData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
};

export type VoicesGetSettingsResponse = VoiceSettingsResponseModel;

export type VoicesGetSettingsError = HTTPValidationError;

export type VoicesGetVoiceMetadataData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
  query?: {
    /**
     * If set will return settings information corresponding to the voice, requires authorization.
     */
    with_settings?: boolean;
  };
};

export type VoicesGetVoiceMetadataResponse = VoiceResponseModel;

export type VoicesGetVoiceMetadataError = HTTPValidationError;

export type VoicesDeleteByIdData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
};

export type VoicesDeleteByIdResponse2 = VoicesDeleteByIdResponse;

export type VoicesDeleteByIdError = HTTPValidationError;

export type VoicesEditSettingsPostData = {
  body: VoiceSettingsResponseModel;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
};

export type VoicesEditSettingsPostResponse2 = VoicesEditSettingsPostResponse;

export type VoicesEditSettingsPostError = HTTPValidationError;

export type VoicesAddVoiceToCollectionData = {
  body: Body_Add_voice_v1_voices_add_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type VoicesAddVoiceToCollectionResponse = AddVoiceResponseModel;

export type VoicesAddVoiceToCollectionError = HTTPValidationError;

export type VoicesUpdateVoiceByIdData = {
  body: Body_Edit_voice_v1_voices__voice_id__edit_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
};

export type VoicesUpdateVoiceByIdResponse2 = VoicesUpdateVoiceByIdResponse;

export type VoicesUpdateVoiceByIdError = HTTPValidationError;

export type VoicesAddToCollectionData = {
  body: Body_Add_sharing_voice_v1_voices_add__public_user_id___voice_id__post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * Public user ID used to publicly identify ElevenLabs users.
     */
    public_user_id: string;
    /**
     * Voice ID to be used, you can use https://api.elevenlabs.io/v1/voices to list all the available voices.
     */
    voice_id: string;
  };
};

export type VoicesAddToCollectionResponse = AddVoiceResponseModel;

export type VoicesAddToCollectionError = HTTPValidationError;

export type ProjectsGetAllProjectsData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type ProjectsGetAllProjectsResponse = GetProjectsResponseModel;

export type ProjectsGetAllProjectsError = HTTPValidationError;

export type ProjectsCreateNewProjectData = {
  body: Body_Add_project_v1_projects_add_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type ProjectsCreateNewProjectResponse = AddProjectResponseModel;

export type ProjectsCreateNewProjectError = HTTPValidationError;

export type ProjectsGetByIdData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsGetByIdResponse = ProjectExtendedResponseModel;

export type ProjectsGetByIdError = HTTPValidationError;

export type ProjectsDeleteByIdData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsDeleteByIdResponse2 = ProjectsDeleteByIdResponse;

export type ProjectsDeleteByIdError = HTTPValidationError;

export type ProjectsStartConversionData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsStartConversionResponse2 = ProjectsStartConversionResponse;

export type ProjectsStartConversionError = HTTPValidationError;

export type ProjectsListSnapshotsData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsListSnapshotsResponse = ProjectSnapshotsResponseModel;

export type ProjectsListSnapshotsError = HTTPValidationError;

export type ProjectsStreamAudioFromSnapshotData = {
  body?: Body_Stream_project_audio_v1_projects__project_id__snapshots__project_snapshot_id__stream_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
    /**
     * The project_snapshot_id of the project snapshot. You can query GET /v1/projects/{project_id}/snapshots to list all available snapshots for a project.
     */
    project_snapshot_id: string;
  };
};

export type ProjectsStreamAudioFromSnapshotResponse = unknown;

export type ProjectsStreamAudioFromSnapshotError = HTTPValidationError;

export type ProjectsStreamArchiveWithAudioData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
    /**
     * The project_snapshot_id of the project snapshot. You can query GET /v1/projects/{project_id}/snapshots to list all available snapshots for a project.
     */
    project_snapshot_id: string;
  };
};

export type ProjectsStreamArchiveWithAudioResponse = unknown;

export type ProjectsStreamArchiveWithAudioError = HTTPValidationError;

export type ProjectsListChaptersData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsListChaptersResponse = GetChaptersResponseModel;

export type ProjectsListChaptersError = HTTPValidationError;

export type ProjectsGetChapterByIdData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The chapter_id of the chapter. You can query GET https://api.elevenlabs.io/v1/projects/{project_id}/chapters to list all available chapters for a project.
     */
    chapter_id: string;
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsGetChapterByIdResponse = ChapterResponseModel;

export type ProjectsGetChapterByIdError = HTTPValidationError;

export type ProjectsDeleteChapterByIdData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The chapter_id of the chapter. You can query GET https://api.elevenlabs.io/v1/projects/{project_id}/chapters to list all available chapters for a project.
     */
    chapter_id: string;
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsDeleteChapterByIdResponse2 = ProjectsDeleteChapterByIdResponse;

export type ProjectsDeleteChapterByIdError = HTTPValidationError;

export type ProjectsStartChapterConversionData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The chapter_id of the chapter. You can query GET https://api.elevenlabs.io/v1/projects/{project_id}/chapters to list all available chapters for a project.
     */
    chapter_id: string;
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsStartChapterConversionResponse2 = ProjectsStartChapterConversionResponse;

export type ProjectsStartChapterConversionError = HTTPValidationError;

export type ProjectsGetChapterSnapshotsData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The chapter_id of the chapter. You can query GET https://api.elevenlabs.io/v1/projects/{project_id}/chapters to list all available chapters for a project.
     */
    chapter_id: string;
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsGetChapterSnapshotsResponse = ChapterSnapshotsResponseModel;

export type ProjectsGetChapterSnapshotsError = HTTPValidationError;

export type ProjectsStreamAudioFromSnapshotPostData = {
  body?: Body_Stream_chapter_audio_v1_projects__project_id__chapters__chapter_id__snapshots__chapter_snapshot_id__stream_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The chapter_id of the chapter. You can query GET https://api.elevenlabs.io/v1/projects/{project_id}/chapters to list all available chapters for a project.
     */
    chapter_id: string;
    /**
     * The chapter_snapshot_id of the chapter snapshot. You can query GET /v1/projects/{project_id}/chapters/{chapter_id}/snapshots to the all available snapshots for a chapter.
     */
    chapter_snapshot_id: string;
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsStreamAudioFromSnapshotPostResponse = unknown;

export type ProjectsStreamAudioFromSnapshotPostError = HTTPValidationError;

export type ProjectsUpdatePronunciationDictionariesData = {
  body: Body_Update_Pronunciation_Dictionaries_v1_projects__project_id__update_pronunciation_dictionaries_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The project_id of the project, you can query GET https://api.elevenlabs.io/v1/projects to list all available projects.
     */
    project_id: string;
  };
};

export type ProjectsUpdatePronunciationDictionariesResponse2 = ProjectsUpdatePronunciationDictionariesResponse;

export type ProjectsUpdatePronunciationDictionariesError = HTTPValidationError;

export type DubbingFileInLanguageData = {
  body?: Body_Dub_a_video_or_an_audio_file_v1_dubbing_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type DubbingFileInLanguageResponse = DoDubbingResponseModel;

export type DubbingFileInLanguageError = HTTPValidationError;

export type DubbingGetProjectMetadataData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * ID of the dubbing project.
     */
    dubbing_id: string;
  };
};

export type DubbingGetProjectMetadataResponse = DubbingMetadataResponse;

export type DubbingGetProjectMetadataError = HTTPValidationError;

export type DubbingDeleteProjectData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * ID of the dubbing project.
     */
    dubbing_id: string;
  };
};

export type DubbingDeleteProjectResponse2 = DubbingDeleteProjectResponse;

export type DubbingDeleteProjectError = HTTPValidationError;

export type DubbingGetFileData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * ID of the dubbing project.
     */
    dubbing_id: string;
    /**
     * ID of the language.
     */
    language_code: string;
  };
};

export type DubbingGetFileResponse = unknown;

export type DubbingGetFileError = HTTPValidationError;

export type WorkspaceGetSsoProviderAdminData = {
  query: {
    workspace_id: string;
  };
};

export type WorkspaceGetSsoProviderAdminResponse = SsoProviderDBModel;

export type WorkspaceGetSsoProviderAdminError = HTTPValidationError;

export type ModelsListAvailableModelsData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type ModelsListAvailableModelsResponse2 = ModelsListAvailableModelsResponse;

export type ModelsListAvailableModelsError = HTTPValidationError;

export type AudionativeCreateProjectWithEmbeddableHtmlData = {
  body: Body_Creates_AudioNative_enabled_project__v1_audio_native_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type AudionativeCreateProjectWithEmbeddableHtmlResponse = AudioNativeCreateProjectResponseModel;

export type AudionativeCreateProjectWithEmbeddableHtmlError = HTTPValidationError;

export type VoicesGetSharedVoicesData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  query?: {
    /**
     * accent used for filtering
     */
    accent?: string;
    /**
     * age used for filtering
     */
    age?: string;
    /**
     * voice category used for filtering
     */
    category?: string;
    /**
     * search term used for filtering
     */
    descriptives?: Array<string>;
    /**
     * Filter featured voices
     */
    featured?: boolean;
    /**
     * gender used for filtering
     */
    gender?: string;
    /**
     * language used for filtering
     */
    language?: string;
    /**
     * Filter voices by public owner ID
     */
    owner_id?: string;
    page?: number;
    /**
     * How many shared voices to return at maximum. Can not exceed 100, defaults to 30.
     */
    page_size?: number;
    /**
     * Filter voices that are enabled for the reader app
     */
    reader_app_enabled?: boolean;
    /**
     * search term used for filtering
     */
    search?: string;
    /**
     * sort criteria
     */
    sort?: string;
    /**
     * use-case used for filtering
     */
    use_cases?: Array<string>;
  };
};

export type VoicesGetSharedVoicesResponse = GetLibraryVoicesResponseModel;

export type VoicesGetSharedVoicesError = HTTPValidationError;

export type PronunciationDictionaryCreateFromFileData = {
  body: Body_Add_a_pronunciation_dictionary_v1_pronunciation_dictionaries_add_from_file_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
};

export type PronunciationDictionaryCreateFromFileResponse = AddPronunciationDictionaryResponseModel;

export type PronunciationDictionaryCreateFromFileError = HTTPValidationError;

export type PronunciationDictionaryAddRulesData = {
  body: Body_Add_rules_to_the_pronunciation_dictionary_v1_pronunciation_dictionaries__pronunciation_dictionary_id__add_rules_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The id of the pronunciation dictionary
     */
    pronunciation_dictionary_id: string;
  };
};

export type PronunciationDictionaryAddRulesResponse = AddPronunciationDictionaryRulesResponseModel;

export type PronunciationDictionaryAddRulesError = HTTPValidationError;

export type PronunciationDictionaryRemoveRulesData = {
  body: Body_Remove_rules_from_the_pronunciation_dictionary_v1_pronunciation_dictionaries__pronunciation_dictionary_id__remove_rules_post;
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The id of the pronunciation dictionary
     */
    pronunciation_dictionary_id: string;
  };
};

export type PronunciationDictionaryRemoveRulesResponse = RemovePronunciationDictionaryRulesResponseModel;

export type PronunciationDictionaryRemoveRulesError = HTTPValidationError;

export type PronunciationDictionaryVersionDownloadData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The id of the pronunciation dictionary
     */
    dictionary_id: string;
    /**
     * The id of the version of the pronunciation dictionary
     */
    version_id: string;
  };
};

export type PronunciationDictionaryVersionDownloadResponse2 = PronunciationDictionaryVersionDownloadResponse;

export type PronunciationDictionaryVersionDownloadError = HTTPValidationError;

export type RedirectToMintlifyDocsGetResponse2 = RedirectToMintlifyDocsGetResponse;

export type RedirectToMintlifyDocsGetError = unknown;

export type PronunciationDictionaryGetMetadataData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  path: {
    /**
     * The id of the pronunciation dictionary
     */
    pronunciation_dictionary_id: string;
  };
};

export type PronunciationDictionaryGetMetadataResponse = GetPronunciationDictionaryMetadataResponseModel;

export type PronunciationDictionaryGetMetadataError = HTTPValidationError;

export type PronunciationDictionaryListDictionariesData = {
  headers?: {
    /**
     * Your API key. This is required by most endpoints to access our API programatically. You can view your xi-api-key using the 'Profile' tab on the website.
     */
    'xi-api-key'?: string;
  };
  query?: {
    /**
     * Used for fetching next page. Cursor is returned in the response.
     */
    cursor?: string;
    /**
     * How many pronunciation dictionaries to return at maximum. Can not exceed 100, defaults to 30.
     */
    page_size?: number;
  };
};

export type PronunciationDictionaryListDictionariesResponse = GetPronunciationDictionariesMetadataResponseModel;

export type PronunciationDictionaryListDictionariesError = HTTPValidationError;
