// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, formDataBodySerializer } from '@hey-api/client-fetch';

import type {
  SpeechhistoryGetGeneratedAudioMetadataData,
  SpeechhistoryGetGeneratedAudioMetadataError,
  SpeechhistoryGetGeneratedAudioMetadataResponse,
  SpeechhistoryGetHistoryItemByIdData,
  SpeechhistoryGetHistoryItemByIdError,
  SpeechhistoryGetHistoryItemByIdResponse,
  SpeechhistoryDeleteHistoryItemByIdData,
  SpeechhistoryDeleteHistoryItemByIdError,
  SpeechhistoryDeleteHistoryItemByIdResponse2,
  SpeechhistoryGetHistoryItemAudioData,
  SpeechhistoryGetHistoryItemAudioError,
  SpeechhistoryGetHistoryItemAudioResponse,
  SpeechhistoryDownloadHistoryItemsData,
  SpeechhistoryDownloadHistoryItemsError,
  SpeechhistoryDownloadHistoryItemsResponse,
  SamplesRemoveByIdData,
  SamplesRemoveByIdError,
  SamplesRemoveByIdResponse2,
  SamplesGetAudioFromSampleData,
  SamplesGetAudioFromSampleError,
  SamplesGetAudioFromSampleResponse,
  TexttospeechConvertTextToSpeechData,
  TexttospeechConvertTextToSpeechError,
  TexttospeechConvertTextToSpeechResponse,
  TexttospeechConvertTextToSpeechStreamData,
  TexttospeechConvertTextToSpeechStreamError,
  TexttospeechConvertTextToSpeechStreamResponse,
  SpeechtospeechCreateWithVoiceData,
  SpeechtospeechCreateWithVoiceError,
  SpeechtospeechCreateWithVoiceResponse,
  SpeechtospeechCreateWithVoice1Data,
  SpeechtospeechCreateWithVoice1Error,
  SpeechtospeechCreateWithVoice1Response,
  VoicegenerationGetVoiceGenerationParametersError,
  VoicegenerationGetVoiceGenerationParametersResponse,
  VoicegenerationGenerateRandomVoiceData,
  VoicegenerationGenerateRandomVoiceError,
  VoicegenerationGenerateRandomVoiceResponse,
  VoicegenerationCreateVoiceData,
  VoicegenerationCreateVoiceError,
  VoicegenerationCreateVoiceResponse,
  UserGetSubscriptionInfoData,
  UserGetSubscriptionInfoError,
  UserGetSubscriptionInfoResponse,
  UserGetInfoData,
  UserGetInfoError,
  UserGetInfoResponse,
  VoicesListAllVoicesData,
  VoicesListAllVoicesError,
  VoicesListAllVoicesResponse,
  VoicesGetDefaultVoiceSettingsError,
  VoicesGetDefaultVoiceSettingsResponse,
  VoicesGetSettingsData,
  VoicesGetSettingsError,
  VoicesGetSettingsResponse,
  VoicesGetVoiceMetadataData,
  VoicesGetVoiceMetadataError,
  VoicesGetVoiceMetadataResponse,
  VoicesDeleteByIdData,
  VoicesDeleteByIdError,
  VoicesDeleteByIdResponse2,
  VoicesEditSettingsPostData,
  VoicesEditSettingsPostError,
  VoicesEditSettingsPostResponse2,
  VoicesAddVoiceToCollectionData,
  VoicesAddVoiceToCollectionError,
  VoicesAddVoiceToCollectionResponse,
  VoicesUpdateVoiceByIdData,
  VoicesUpdateVoiceByIdError,
  VoicesUpdateVoiceByIdResponse2,
  VoicesAddToCollectionData,
  VoicesAddToCollectionError,
  VoicesAddToCollectionResponse,
  ProjectsGetAllProjectsData,
  ProjectsGetAllProjectsError,
  ProjectsGetAllProjectsResponse,
  ProjectsCreateNewProjectData,
  ProjectsCreateNewProjectError,
  ProjectsCreateNewProjectResponse,
  ProjectsGetByIdData,
  ProjectsGetByIdError,
  ProjectsGetByIdResponse,
  ProjectsDeleteByIdData,
  ProjectsDeleteByIdError,
  ProjectsDeleteByIdResponse2,
  ProjectsStartConversionData,
  ProjectsStartConversionError,
  ProjectsStartConversionResponse2,
  ProjectsListSnapshotsData,
  ProjectsListSnapshotsError,
  ProjectsListSnapshotsResponse,
  ProjectsStreamAudioFromSnapshotData,
  ProjectsStreamAudioFromSnapshotError,
  ProjectsStreamAudioFromSnapshotResponse,
  ProjectsStreamArchiveWithAudioData,
  ProjectsStreamArchiveWithAudioError,
  ProjectsStreamArchiveWithAudioResponse,
  ProjectsListChaptersData,
  ProjectsListChaptersError,
  ProjectsListChaptersResponse,
  ProjectsGetChapterByIdData,
  ProjectsGetChapterByIdError,
  ProjectsGetChapterByIdResponse,
  ProjectsDeleteChapterByIdData,
  ProjectsDeleteChapterByIdError,
  ProjectsDeleteChapterByIdResponse2,
  ProjectsStartChapterConversionData,
  ProjectsStartChapterConversionError,
  ProjectsStartChapterConversionResponse2,
  ProjectsGetChapterSnapshotsData,
  ProjectsGetChapterSnapshotsError,
  ProjectsGetChapterSnapshotsResponse,
  ProjectsStreamAudioFromSnapshotPostData,
  ProjectsStreamAudioFromSnapshotPostError,
  ProjectsStreamAudioFromSnapshotPostResponse,
  ProjectsUpdatePronunciationDictionariesData,
  ProjectsUpdatePronunciationDictionariesError,
  ProjectsUpdatePronunciationDictionariesResponse2,
  DubbingFileInLanguageData,
  DubbingFileInLanguageError,
  DubbingFileInLanguageResponse,
  DubbingGetProjectMetadataData,
  DubbingGetProjectMetadataError,
  DubbingGetProjectMetadataResponse,
  DubbingDeleteProjectData,
  DubbingDeleteProjectError,
  DubbingDeleteProjectResponse2,
  DubbingGetFileData,
  DubbingGetFileError,
  DubbingGetFileResponse,
  WorkspaceGetSsoProviderAdminData,
  WorkspaceGetSsoProviderAdminError,
  WorkspaceGetSsoProviderAdminResponse,
  ModelsListAvailableModelsData,
  ModelsListAvailableModelsError,
  ModelsListAvailableModelsResponse2,
  AudionativeCreateProjectWithEmbeddableHtmlData,
  AudionativeCreateProjectWithEmbeddableHtmlError,
  AudionativeCreateProjectWithEmbeddableHtmlResponse,
  VoicesGetSharedVoicesData,
  VoicesGetSharedVoicesError,
  VoicesGetSharedVoicesResponse,
  PronunciationDictionaryCreateFromFileData,
  PronunciationDictionaryCreateFromFileError,
  PronunciationDictionaryCreateFromFileResponse,
  PronunciationDictionaryAddRulesData,
  PronunciationDictionaryAddRulesError,
  PronunciationDictionaryAddRulesResponse,
  PronunciationDictionaryRemoveRulesData,
  PronunciationDictionaryRemoveRulesError,
  PronunciationDictionaryRemoveRulesResponse,
  PronunciationDictionaryVersionDownloadData,
  PronunciationDictionaryVersionDownloadError,
  PronunciationDictionaryVersionDownloadResponse2,
  RedirectToMintlifyDocsGetError,
  RedirectToMintlifyDocsGetResponse2,
  PronunciationDictionaryGetMetadataData,
  PronunciationDictionaryGetMetadataError,
  PronunciationDictionaryGetMetadataResponse,
  PronunciationDictionaryListDictionariesData,
  PronunciationDictionaryListDictionariesError,
  PronunciationDictionaryListDictionariesResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Get Generated Items
 * Returns metadata about all your generated audio.
 */
export const speechhistoryGetGeneratedAudioMetadata = <ThrowOnError extends boolean = false>(
  options?: Options<SpeechhistoryGetGeneratedAudioMetadataData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SpeechhistoryGetGeneratedAudioMetadataResponse,
    SpeechhistoryGetGeneratedAudioMetadataError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/history',
  });
};

/**
 * Get History Item By Id
 * Returns information about an history item by its ID.
 */
export const speechhistoryGetHistoryItemById = <ThrowOnError extends boolean = false>(
  options: Options<SpeechhistoryGetHistoryItemByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SpeechhistoryGetHistoryItemByIdResponse,
    SpeechhistoryGetHistoryItemByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/history/{history_item_id}',
  });
};

/**
 * Delete History Item
 * Delete a history item by its ID
 */
export const speechhistoryDeleteHistoryItemById = <ThrowOnError extends boolean = false>(
  options: Options<SpeechhistoryDeleteHistoryItemByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    SpeechhistoryDeleteHistoryItemByIdResponse2,
    SpeechhistoryDeleteHistoryItemByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/history/{history_item_id}',
  });
};

/**
 * Get Audio From History Item
 * Returns the audio of an history item.
 */
export const speechhistoryGetHistoryItemAudio = <ThrowOnError extends boolean = false>(
  options: Options<SpeechhistoryGetHistoryItemAudioData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SpeechhistoryGetHistoryItemAudioResponse,
    SpeechhistoryGetHistoryItemAudioError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/history/{history_item_id}/audio',
  });
};

/**
 * Download History Items
 * Download one or more history items. If one history item ID is provided, we will return a single audio file. If more than one history item IDs are provided, we will provide the history items packed into a .zip file.
 */
export const speechhistoryDownloadHistoryItems = <ThrowOnError extends boolean = false>(
  options: Options<SpeechhistoryDownloadHistoryItemsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SpeechhistoryDownloadHistoryItemsResponse,
    SpeechhistoryDownloadHistoryItemsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/history/download',
  });
};

/**
 * Delete Sample
 * Removes a sample by its ID.
 */
export const samplesRemoveById = <ThrowOnError extends boolean = false>(
  options: Options<SamplesRemoveByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<SamplesRemoveByIdResponse2, SamplesRemoveByIdError, ThrowOnError>({
    ...options,
    url: '/v1/voices/{voice_id}/samples/{sample_id}',
  });
};

/**
 * Get Audio From Sample
 * Returns the audio corresponding to a sample attached to a voice.
 */
export const samplesGetAudioFromSample = <ThrowOnError extends boolean = false>(
  options: Options<SamplesGetAudioFromSampleData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SamplesGetAudioFromSampleResponse,
    SamplesGetAudioFromSampleError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/voices/{voice_id}/samples/{sample_id}/audio',
  });
};

/**
 * Text To Speech
 * Converts text into speech using a voice of your choice and returns audio.
 */
export const texttospeechConvertTextToSpeech = <ThrowOnError extends boolean = false>(
  options: Options<TexttospeechConvertTextToSpeechData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    TexttospeechConvertTextToSpeechResponse,
    TexttospeechConvertTextToSpeechError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/text-to-speech/{voice_id}',
  });
};

/**
 * Text To Speech
 * Converts text into speech using a voice of your choice and returns audio as an audio stream.
 */
export const texttospeechConvertTextToSpeechStream = <ThrowOnError extends boolean = false>(
  options: Options<TexttospeechConvertTextToSpeechStreamData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    TexttospeechConvertTextToSpeechStreamResponse,
    TexttospeechConvertTextToSpeechStreamError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/text-to-speech/{voice_id}/stream',
  });
};

/**
 * Speech To Speech
 * Create speech by combining the content and emotion of the uploaded audio with a voice of your choice.
 */
export const speechtospeechCreateWithVoice = <ThrowOnError extends boolean = false>(
  options: Options<SpeechtospeechCreateWithVoiceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SpeechtospeechCreateWithVoiceResponse,
    SpeechtospeechCreateWithVoiceError,
    ThrowOnError
  >({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v1/speech-to-speech/{voice_id}',
  });
};

/**
 * Speech To Speech Streaming
 * Create speech by combining the content and emotion of the uploaded audio with a voice of your choice and returns an audio stream.
 */
export const speechtospeechCreateWithVoice1 = <ThrowOnError extends boolean = false>(
  options: Options<SpeechtospeechCreateWithVoice1Data, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SpeechtospeechCreateWithVoice1Response,
    SpeechtospeechCreateWithVoice1Error,
    ThrowOnError
  >({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v1/speech-to-speech/{voice_id}/stream',
  });
};

/**
 * Voice Generation Parameters
 * Get possible parameters for the /v1/voice-generation/generate-voice endpoint.
 */
export const voicegenerationGetVoiceGenerationParameters = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    VoicegenerationGetVoiceGenerationParametersResponse,
    VoicegenerationGetVoiceGenerationParametersError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/voice-generation/generate-voice/parameters',
  });
};

/**
 * Generate A Random Voice
 * Generate a random voice based on parameters. This method returns a generated_voice_id in the response header, and a sample of the voice in the body. If you like the generated voice call /v1/voice-generation/create-voice with the generated_voice_id to create the voice.
 */
export const voicegenerationGenerateRandomVoice = <ThrowOnError extends boolean = false>(
  options: Options<VoicegenerationGenerateRandomVoiceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    VoicegenerationGenerateRandomVoiceResponse,
    VoicegenerationGenerateRandomVoiceError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/voice-generation/generate-voice',
  });
};

/**
 * Create A Previously Generated Voice
 * Create a previously generated voice. This endpoint should be called after you fetched a generated_voice_id using /v1/voice-generation/generate-voice.
 */
export const voicegenerationCreateVoice = <ThrowOnError extends boolean = false>(
  options: Options<VoicegenerationCreateVoiceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    VoicegenerationCreateVoiceResponse,
    VoicegenerationCreateVoiceError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/voice-generation/create-voice',
  });
};

/**
 * Get User Subscription Info
 * Gets extended information about the users subscription
 */
export const userGetSubscriptionInfo = <ThrowOnError extends boolean = false>(
  options?: Options<UserGetSubscriptionInfoData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserGetSubscriptionInfoResponse, UserGetSubscriptionInfoError, ThrowOnError>({
    ...options,
    url: '/v1/user/subscription',
  });
};

/**
 * Get User Info
 * Gets information about the user
 */
export const userGetInfo = <ThrowOnError extends boolean = false>(options?: Options<UserGetInfoData, ThrowOnError>) => {
  return (options?.client ?? client).get<UserGetInfoResponse, UserGetInfoError, ThrowOnError>({
    ...options,
    url: '/v1/user',
  });
};

/**
 * Get Voices
 * Gets a list of all available voices for a user.
 */
export const voicesListAllVoices = <ThrowOnError extends boolean = false>(
  options?: Options<VoicesListAllVoicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<VoicesListAllVoicesResponse, VoicesListAllVoicesError, ThrowOnError>({
    ...options,
    url: '/v1/voices',
  });
};

/**
 * Get Default Voice Settings.
 * Gets the default settings for voices. "similarity_boost" corresponds to"Clarity + Similarity Enhancement" in the web app and "stability" corresponds to "Stability" slider in the web app.
 */
export const voicesGetDefaultVoiceSettings = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    VoicesGetDefaultVoiceSettingsResponse,
    VoicesGetDefaultVoiceSettingsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/voices/settings/default',
  });
};

/**
 * Get Voice Settings
 * Returns the settings for a specific voice. "similarity_boost" corresponds to"Clarity + Similarity Enhancement" in the web app and "stability" corresponds to "Stability" slider in the web app.
 */
export const voicesGetSettings = <ThrowOnError extends boolean = false>(
  options: Options<VoicesGetSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<VoicesGetSettingsResponse, VoicesGetSettingsError, ThrowOnError>({
    ...options,
    url: '/v1/voices/{voice_id}/settings',
  });
};

/**
 * Get Voice
 * Returns metadata about a specific voice.
 */
export const voicesGetVoiceMetadata = <ThrowOnError extends boolean = false>(
  options: Options<VoicesGetVoiceMetadataData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<VoicesGetVoiceMetadataResponse, VoicesGetVoiceMetadataError, ThrowOnError>({
    ...options,
    url: '/v1/voices/{voice_id}',
  });
};

/**
 * Delete Voice
 * Deletes a voice by its ID.
 */
export const voicesDeleteById = <ThrowOnError extends boolean = false>(
  options: Options<VoicesDeleteByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<VoicesDeleteByIdResponse2, VoicesDeleteByIdError, ThrowOnError>({
    ...options,
    url: '/v1/voices/{voice_id}',
  });
};

/**
 * Edit Voice Settings
 * Edit your settings for a specific voice. "similarity_boost" corresponds to"Clarity + Similarity Enhancement" in the web app and "stability" corresponds to "Stability" slider in the web app.
 */
export const voicesEditSettingsPost = <ThrowOnError extends boolean = false>(
  options: Options<VoicesEditSettingsPostData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<VoicesEditSettingsPostResponse2, VoicesEditSettingsPostError, ThrowOnError>({
    ...options,
    url: '/v1/voices/{voice_id}/settings/edit',
  });
};

/**
 * Add Voice
 * Add a new voice to your collection of voices in VoiceLab.
 */
export const voicesAddVoiceToCollection = <ThrowOnError extends boolean = false>(
  options: Options<VoicesAddVoiceToCollectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    VoicesAddVoiceToCollectionResponse,
    VoicesAddVoiceToCollectionError,
    ThrowOnError
  >({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v1/voices/add',
  });
};

/**
 * Edit Voice
 * Edit a voice created by you.
 */
export const voicesUpdateVoiceById = <ThrowOnError extends boolean = false>(
  options: Options<VoicesUpdateVoiceByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<VoicesUpdateVoiceByIdResponse2, VoicesUpdateVoiceByIdError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v1/voices/{voice_id}/edit',
  });
};

/**
 * Add Sharing Voice
 * Add a sharing voice to your collection of voices in VoiceLab.
 */
export const voicesAddToCollection = <ThrowOnError extends boolean = false>(
  options: Options<VoicesAddToCollectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<VoicesAddToCollectionResponse, VoicesAddToCollectionError, ThrowOnError>({
    ...options,
    url: '/v1/voices/add/{public_user_id}/{voice_id}',
  });
};

/**
 * Get Projects
 * Returns a list of your projects together and its metadata.
 */
export const projectsGetAllProjects = <ThrowOnError extends boolean = false>(
  options?: Options<ProjectsGetAllProjectsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ProjectsGetAllProjectsResponse, ProjectsGetAllProjectsError, ThrowOnError>({
    ...options,
    url: '/v1/projects',
  });
};

/**
 * Add Project
 * Creates a new project, it can be either initialized as blank, from a document or from a URL.
 */
export const projectsCreateNewProject = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsCreateNewProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ProjectsCreateNewProjectResponse,
    ProjectsCreateNewProjectError,
    ThrowOnError
  >({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v1/projects/add',
  });
};

/**
 * Get Project By Id
 * Returns information about a specific project. This endpoint returns more detailed information about a project than GET api.elevenlabs.io/v1/projects.
 */
export const projectsGetById = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsGetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ProjectsGetByIdResponse, ProjectsGetByIdError, ThrowOnError>({
    ...options,
    url: '/v1/projects/{project_id}',
  });
};

/**
 * Delete Project
 * Delete a project by its project_id.
 */
export const projectsDeleteById = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsDeleteByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<ProjectsDeleteByIdResponse2, ProjectsDeleteByIdError, ThrowOnError>({
    ...options,
    url: '/v1/projects/{project_id}',
  });
};

/**
 * Convert Project
 * Starts conversion of a project and all of its chapters.
 */
export const projectsStartConversion = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsStartConversionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ProjectsStartConversionResponse2, ProjectsStartConversionError, ThrowOnError>(
    {
      ...options,
      url: '/v1/projects/{project_id}/convert',
    },
  );
};

/**
 * Get Project Snapshots
 * Gets the snapshots of a project.
 */
export const projectsListSnapshots = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsListSnapshotsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ProjectsListSnapshotsResponse, ProjectsListSnapshotsError, ThrowOnError>({
    ...options,
    url: '/v1/projects/{project_id}/snapshots',
  });
};

/**
 * Stream Project Audio
 * Stream the audio from a project snapshot.
 */
export const projectsStreamAudioFromSnapshot = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsStreamAudioFromSnapshotData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ProjectsStreamAudioFromSnapshotResponse,
    ProjectsStreamAudioFromSnapshotError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/projects/{project_id}/snapshots/{project_snapshot_id}/stream',
  });
};

/**
 * Streams Archive With Project Audio
 * Streams archive with project audio.
 */
export const projectsStreamArchiveWithAudio = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsStreamArchiveWithAudioData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ProjectsStreamArchiveWithAudioResponse,
    ProjectsStreamArchiveWithAudioError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/projects/{project_id}/snapshots/{project_snapshot_id}/archive',
  });
};

/**
 * Get Chapters
 * Returns a list of your chapters for a project together and its metadata.
 */
export const projectsListChapters = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsListChaptersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ProjectsListChaptersResponse, ProjectsListChaptersError, ThrowOnError>({
    ...options,
    url: '/v1/projects/{project_id}/chapters',
  });
};

/**
 * Get Chapter By Id
 * Returns information about a specific chapter.
 */
export const projectsGetChapterById = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsGetChapterByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ProjectsGetChapterByIdResponse, ProjectsGetChapterByIdError, ThrowOnError>({
    ...options,
    url: '/v1/projects/{project_id}/chapters/{chapter_id}',
  });
};

/**
 * Delete Chapter
 * Delete a chapter by its chapter_id.
 */
export const projectsDeleteChapterById = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsDeleteChapterByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    ProjectsDeleteChapterByIdResponse2,
    ProjectsDeleteChapterByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/projects/{project_id}/chapters/{chapter_id}',
  });
};

/**
 * Convert Chapter
 * Starts conversion of a specific chapter.
 */
export const projectsStartChapterConversion = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsStartChapterConversionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ProjectsStartChapterConversionResponse2,
    ProjectsStartChapterConversionError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/projects/{project_id}/chapters/{chapter_id}/convert',
  });
};

/**
 * Get Chapter Snapshots
 * Gets information about all the snapshots of a chapter, each snapshot corresponds can be downloaded as audio. Whenever a chapter is converted a snapshot will be automatically created.
 */
export const projectsGetChapterSnapshots = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsGetChapterSnapshotsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ProjectsGetChapterSnapshotsResponse,
    ProjectsGetChapterSnapshotsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/projects/{project_id}/chapters/{chapter_id}/snapshots',
  });
};

/**
 * Stream Chapter Audio
 * Stream the audio from a chapter snapshot. Use `GET /v1/projects/{project_id}/chapters/{chapter_id}/snapshots` to return the chapter snapshots of a chapter.
 */
export const projectsStreamAudioFromSnapshotPost = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsStreamAudioFromSnapshotPostData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ProjectsStreamAudioFromSnapshotPostResponse,
    ProjectsStreamAudioFromSnapshotPostError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/projects/{project_id}/chapters/{chapter_id}/snapshots/{chapter_snapshot_id}/stream',
  });
};

/**
 * Update Pronunciation Dictionaries
 * Updates the set of pronunciation dictionaries acting on a project. This will automatically mark text within this project as requiring reconverting where the new dictionary would apply or the old one no longer does.
 */
export const projectsUpdatePronunciationDictionaries = <ThrowOnError extends boolean = false>(
  options: Options<ProjectsUpdatePronunciationDictionariesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ProjectsUpdatePronunciationDictionariesResponse2,
    ProjectsUpdatePronunciationDictionariesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/projects/{project_id}/update-pronunciation-dictionaries',
  });
};

/**
 * Dub A Video Or An Audio File
 * Dubs provided audio or video file into given language.
 */
export const dubbingFileInLanguage = <ThrowOnError extends boolean = false>(
  options?: Options<DubbingFileInLanguageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DubbingFileInLanguageResponse, DubbingFileInLanguageError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v1/dubbing',
  });
};

/**
 * Get Dubbing Project Metadata
 * Returns metadata about a dubbing project, including whether it's still in progress or not
 */
export const dubbingGetProjectMetadata = <ThrowOnError extends boolean = false>(
  options: Options<DubbingGetProjectMetadataData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DubbingGetProjectMetadataResponse,
    DubbingGetProjectMetadataError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/dubbing/{dubbing_id}',
  });
};

/**
 * Delete Dubbing Project
 * Deletes a dubbing project.
 */
export const dubbingDeleteProject = <ThrowOnError extends boolean = false>(
  options: Options<DubbingDeleteProjectData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DubbingDeleteProjectResponse2, DubbingDeleteProjectError, ThrowOnError>({
    ...options,
    url: '/v1/dubbing/{dubbing_id}',
  });
};

/**
 * Get Dubbed File
 * Returns dubbed file as a streamed file. Videos will be returned in MP4 format and audio only dubs will be returned in MP3.
 */
export const dubbingGetFile = <ThrowOnError extends boolean = false>(
  options: Options<DubbingGetFileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DubbingGetFileResponse, DubbingGetFileError, ThrowOnError>({
    ...options,
    url: '/v1/dubbing/{dubbing_id}/audio/{language_code}',
  });
};

/**
 * Get Sso Provider Admin
 */
export const workspaceGetSsoProviderAdmin = <ThrowOnError extends boolean = false>(
  options: Options<WorkspaceGetSsoProviderAdminData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    WorkspaceGetSsoProviderAdminResponse,
    WorkspaceGetSsoProviderAdminError,
    ThrowOnError
  >({
    ...options,
    url: '/admin/{admin_url_prefix}/sso-provider',
  });
};

/**
 * Get Models
 * Gets a list of available models.
 */
export const modelsListAvailableModels = <ThrowOnError extends boolean = false>(
  options?: Options<ModelsListAvailableModelsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ModelsListAvailableModelsResponse2,
    ModelsListAvailableModelsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/models',
  });
};

/**
 * Creates Audionative Enabled Project.
 * Creates AudioNative enabled project, optionally starts conversion and returns project id and embeddable html snippet.
 */
export const audionativeCreateProjectWithEmbeddableHtml = <ThrowOnError extends boolean = false>(
  options: Options<AudionativeCreateProjectWithEmbeddableHtmlData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AudionativeCreateProjectWithEmbeddableHtmlResponse,
    AudionativeCreateProjectWithEmbeddableHtmlError,
    ThrowOnError
  >({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v1/audio-native',
  });
};

/**
 * Get Voices
 * Gets a list of shared voices.
 */
export const voicesGetSharedVoices = <ThrowOnError extends boolean = false>(
  options?: Options<VoicesGetSharedVoicesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<VoicesGetSharedVoicesResponse, VoicesGetSharedVoicesError, ThrowOnError>({
    ...options,
    url: '/v1/shared-voices',
  });
};

/**
 * Add A Pronunciation Dictionary
 * Creates a new pronunciation dictionary from a lexicon .PLS file
 */
export const pronunciationDictionaryCreateFromFile = <ThrowOnError extends boolean = false>(
  options: Options<PronunciationDictionaryCreateFromFileData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PronunciationDictionaryCreateFromFileResponse,
    PronunciationDictionaryCreateFromFileError,
    ThrowOnError
  >({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/v1/pronunciation-dictionaries/add-from-file',
  });
};

/**
 * Add Rules To The Pronunciation Dictionary
 * Add rules to the pronunciation dictionary
 */
export const pronunciationDictionaryAddRules = <ThrowOnError extends boolean = false>(
  options: Options<PronunciationDictionaryAddRulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PronunciationDictionaryAddRulesResponse,
    PronunciationDictionaryAddRulesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/pronunciation-dictionaries/{pronunciation_dictionary_id}/add-rules',
  });
};

/**
 * Remove Rules From The Pronunciation Dictionary
 * Remove rules from the pronunciation dictionary
 */
export const pronunciationDictionaryRemoveRules = <ThrowOnError extends boolean = false>(
  options: Options<PronunciationDictionaryRemoveRulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PronunciationDictionaryRemoveRulesResponse,
    PronunciationDictionaryRemoveRulesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/pronunciation-dictionaries/{pronunciation_dictionary_id}/remove-rules',
  });
};

/**
 * Get Pls File With A Pronunciation Dictionary Version Rules
 * Get PLS file with a pronunciation dictionary version rules
 */
export const pronunciationDictionaryVersionDownload = <ThrowOnError extends boolean = false>(
  options: Options<PronunciationDictionaryVersionDownloadData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    PronunciationDictionaryVersionDownloadResponse2,
    PronunciationDictionaryVersionDownloadError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/pronunciation-dictionaries/{dictionary_id}/{version_id}/download',
  });
};

/**
 * Redirect To Mintlify
 */
export const redirectToMintlifyDocsGet = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    RedirectToMintlifyDocsGetResponse2,
    RedirectToMintlifyDocsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/docs',
  });
};

/**
 * Get Metadata For A Pronunciation Dictionary
 * Get metadata for a pronunciation dictionary
 */
export const pronunciationDictionaryGetMetadata = <ThrowOnError extends boolean = false>(
  options: Options<PronunciationDictionaryGetMetadataData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    PronunciationDictionaryGetMetadataResponse,
    PronunciationDictionaryGetMetadataError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/pronunciation-dictionaries/{pronunciation_dictionary_id}',
  });
};

/**
 * Get Pronunciation Dictionaries
 * Get a list of the pronunciation dictionaries you have access to and their metadata
 */
export const pronunciationDictionaryListDictionaries = <ThrowOnError extends boolean = false>(
  options?: Options<PronunciationDictionaryListDictionariesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    PronunciationDictionaryListDictionariesResponse,
    PronunciationDictionaryListDictionariesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/pronunciation-dictionaries',
  });
};
