// This file is auto-generated by @hey-api/openapi-ts

export const AddProjectResponseModelSchema = {
  title: 'AddProjectResponseModel',
  properties: {
    project: {
      $ref: '#/components/schemas/ProjectResponseModel',
    },
  },
  type: 'object',
  required: ['project'],
} as const;

export const AddPronunciationDictionaryResponseModelSchema = {
  title: 'AddPronunciationDictionaryResponseModel',
  properties: {
    description: {
      title: 'Description',
      type: 'string',
    },
    id: {
      title: 'Id',
      type: 'string',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    created_by: {
      title: 'Created By',
      type: 'string',
    },
    creation_time_unix: {
      title: 'Creation Time Unix',
      type: 'integer',
    },
    version_id: {
      title: 'Version Id',
      type: 'string',
    },
  },
  type: 'object',
  required: ['id', 'name', 'created_by', 'creation_time_unix', 'version_id'],
} as const;

export const AddPronunciationDictionaryRulesResponseModelSchema = {
  title: 'AddPronunciationDictionaryRulesResponseModel',
  properties: {
    id: {
      title: 'Id',
      type: 'string',
    },
    version_id: {
      title: 'Version Id',
      type: 'string',
    },
  },
  type: 'object',
  required: ['id', 'version_id'],
} as const;

export const AddVoiceResponseModelSchema = {
  title: 'AddVoiceResponseModel',
  properties: {
    voice_id: {
      title: 'Voice Id',
      type: 'string',
    },
  },
  type: 'object',
  required: ['voice_id'],
} as const;

export const AudioNativeCreateProjectResponseModelSchema = {
  title: 'AudioNativeCreateProjectResponseModel',
  properties: {
    project_id: {
      title: 'Project Id',
      type: 'string',
    },
    converting: {
      title: 'Converting',
      type: 'boolean',
    },
    html_snippet: {
      title: 'Html Snippet',
      type: 'string',
    },
  },
  type: 'object',
  required: ['project_id', 'converting', 'html_snippet'],
} as const;

export const Body_Add_a_pronunciation_dictionary_v1_pronunciation_dictionaries_add_from_file_postSchema = {
  title: 'Body_Add_a_pronunciation_dictionary_v1_pronunciation_dictionaries_add_from_file_post',
  properties: {
    description: {
      title: 'Description',
      description: 'A description of the pronunciation dictionary, used for identification only.',
      type: 'string',
    },
    file: {
      title: 'File',
      description: 'A lexicon .pls file which we will use to initialize the project with.',
      type: 'string',
      format: 'binary',
    },
    name: {
      title: 'Name',
      description: 'The name of the pronunciation dictionary, used for identification only.',
      type: 'string',
    },
  },
  type: 'object',
  required: ['name'],
} as const;

export const Body_Add_project_v1_projects_add_postSchema = {
  title: 'Body_Add_project_v1_projects_add_post',
  properties: {
    title: {
      title: 'Title',
      description:
        'An optional name of the author of the project, this will be added as metadata to the mp3 file on project / chapter download.',
      type: 'string',
    },
    name: {
      title: 'Name',
      description: 'The name of the project, used for identification only.',
      type: 'string',
    },
    from_url: {
      title: 'From Url',
      description:
        "An optional URL from which we will extract content to initialize the project. If this is set, 'from_url' must be null. If neither 'from_url' or 'from_document' are provided we will initialize the project as blank.",
      type: 'string',
    },
    from_document: {
      title: 'From Document',
      description:
        "An optional .epub, .pdf, .txt or similar file can be provided. If provided, we will initialize the project with its content. If this is set, 'from_url' must be null.  If neither 'from_url' or 'from_document' are provided we will initialize the project as blank.",
      type: 'string',
      format: 'binary',
    },
    default_title_voice_id: {
      title: 'Default Title Voice Id',
      description: 'The voice_id that corresponds to the default voice used for new titles.',
      type: 'string',
    },
    default_paragraph_voice_id: {
      title: 'Default Paragraph Voice Id',
      description: 'The voice_id that corresponds to the default voice used for new paragraphs.',
      type: 'string',
    },
    default_model_id: {
      title: 'Default Model Id',
      description:
        'The model_id of the model to be used for this project, you can query GET https://api.elevenlabs.io/v1/models to list all available models.',
      type: 'string',
    },
    quality_preset: {
      title: 'Quality of the generated audio.',
      description: `Output quality of the generated audio. Must be one of:
standard - standard output format, 128kbps with 44.1kHz sample rate.
high - high quality output format, 192kbps with 44.1kHz sample rate and major improvements on our side. Using this setting increases the character cost by 20%.
ultra - ultra quality output format, 192kbps with 44.1kHz sample rate and highest improvements on our side. Using this setting increases the character cost by 50%.
ultra lossless - ultra quality output format, 705.6kbps with 44.1kHz sample rate and highest improvements on our side in a fully lossless format. Using this setting increases the character cost by 100%.
`,
      type: 'string',
      default: 'standard',
      include_in_schema: true,
    },
    author: {
      title: 'Author',
      description:
        'An optional name of the author of the project, this will be added as metadata to the mp3 file on project / chapter download.',
      type: 'string',
    },
    isbn_number: {
      title: 'Isbn Number',
      description:
        'An optional ISBN number of the project you want to create, this will be added as metadata to the mp3 file on project / chapter download.',
      type: 'string',
    },
    acx_volume_normalization: {
      title: 'Acx Volume Normalization',
      description:
        '[Deprecated] When the project is downloaded, should the returned audio have postprocessing in order to make it compliant with audiobook normalized volume requirements',
      type: 'boolean',
      default: false,
      include_in_schema: false,
    },
    volume_normalization: {
      title: 'Volume Normalization',
      description:
        'When the project is downloaded, should the returned audio have postprocessing in order to make it compliant with audiobook normalized volume requirements',
      type: 'boolean',
      default: false,
    },
    pronunciation_dictionary_locators: {
      title: 'Pronunciation Dictionary Locators',
      description:
        'A list of pronunciation dictionary locators (id, version_id) encoded as a list of JSON strings for pronunciation dictionaries to be applied to the text.  A list of json encoded strings is required as adding projects may occur through formData as opposed to jsonBody',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    callback_url: {
      title: 'Callback Url',
      description:
        'A url that will be called by our service when the project is converted with a json containing the status of the conversion',
      type: 'string',
      include_in_schema: false,
    },
  },
  type: 'object',
  required: [
    'name',
    'default_title_voice_id',
    'default_paragraph_voice_id',
    'default_model_id',
    'pronunciation_dictionary_locators',
  ],
} as const;

export const Body_Add_rules_to_the_pronunciation_dictionary_v1_pronunciation_dictionaries__pronunciation_dictionary_id__add_rules_postSchema =
  {
    title:
      'Body_Add_rules_to_the_pronunciation_dictionary_v1_pronunciation_dictionaries__pronunciation_dictionary_id__add_rules_post',
    properties: {
      rules: {
        title: 'Rules',
        description: `List of pronunciation rules. Rule can be either:
    an alias rule: {'string_to_replace': 'a', 'type': 'alias', 'alias': 'b', }
    or a phoneme rule: {'string_to_replace': 'a', 'type': 'phoneme', 'phoneme': 'b', 'alphabet': 'ipa' }`,
        items: {
          anyOf: [
            {
              $ref: '#/components/schemas/PronunciationDictionaryAliasRuleRequestModel',
            },
            {
              $ref: '#/components/schemas/PronunciationDictionaryPhonemeRuleRequestModel',
            },
          ],
        },
        type: 'array',
      },
    },
    type: 'object',
    required: ['rules'],
  } as const;

export const Body_Add_sharing_voice_v1_voices_add__public_user_id___voice_id__postSchema = {
  title: 'Body_Add_sharing_voice_v1_voices_add__public_user_id___voice_id__post',
  properties: {
    new_name: {
      title: 'New Name',
      description: 'The name that identifies this voice. This will be displayed in the dropdown of the website.',
      type: 'string',
    },
  },
  type: 'object',
  required: ['new_name'],
} as const;

export const Body_Add_voice_v1_voices_add_postSchema = {
  title: 'Body_Add_voice_v1_voices_add_post',
  properties: {
    description: {
      title: 'Description',
      description: 'How would you describe the voice?',
      type: 'string',
    },
    name: {
      title: 'Name',
      description: 'The name that identifies this voice. This will be displayed in the dropdown of the website.',
      type: 'string',
    },
    files: {
      title: 'Files',
      description: 'One or more audio files to clone the voice from',
      items: {
        type: 'string',
        format: 'binary',
      },
      type: 'array',
    },
    labels: {
      title: 'Labels',
      description: 'Serialized labels dictionary for the voice.',
      type: 'string',
    },
  },
  type: 'object',
  required: ['name', 'files'],
} as const;

export const Body_Create_a_previously_generated_voice_v1_voice_generation_create_voice_postSchema = {
  title: 'Body_Create_a_previously_generated_voice_v1_voice_generation_create_voice_post',
  properties: {
    voice_name: {
      title: 'Voice Name',
      description: 'Name to use for the created voice.',
      type: 'string',
    },
    voice_description: {
      title: 'Voice Description',
      description: 'Description to use for the created voice.',
      type: 'string',
    },
    generated_voice_id: {
      title: 'Generated Voice Id',
      description:
        "The generated_voice_id to create, call POST /v1/voice-generation/generate-voice and fetch the generated_voice_id from the response header if don't have one yet.",
      type: 'string',
    },
    labels: {
      title: 'Labels',
      description: 'Optional, metadata to add to the created voice. Defaults to None.',
      additionalProperties: {
        type: 'string',
      },
      type: 'object',
      name: 'Voice metadata',
    },
  },
  type: 'object',
  required: ['voice_name', 'voice_description', 'generated_voice_id'],
} as const;

export const Body_Creates_AudioNative_enabled_project__v1_audio_native_postSchema = {
  title: 'Body_Creates_AudioNative_enabled_project__v1_audio_native_post',
  properties: {
    title: {
      title: 'Title',
      description:
        'Title used in the player and inserted at the top of the uploaded article. If not provided, the default title set in the Player settings is used.',
      type: 'string',
    },
    name: {
      title: 'Name',
      description: 'Project name.',
      type: 'string',
    },
    image: {
      title: 'Image',
      description: 'Image URL used in the player. If not provided, default image set in the Player settings is used.',
      type: 'string',
    },
    author: {
      title: 'Author',
      description:
        'Author used in the player and inserted at the start of the uploaded article. If not provided, the default author set in the Player settings is used.',
      type: 'string',
    },
    small: {
      title: 'Small',
      description:
        'Whether to use small player or not. If not provided, default value set in the Player settings is used.',
      type: 'boolean',
      default: false,
    },
    text_color: {
      title: 'Text Color',
      description:
        'Text color used in the player. If not provided, default text color set in the Player settings is used.',
      type: 'string',
    },
    background_color: {
      title: 'Background Color',
      description:
        'Background color used in the player. If not provided, default background color set in the Player settings is used.',
      type: 'string',
    },
    sessionization: {
      title: 'Sessionization',
      description:
        'Specifies for how many minutes to persist the session across page reloads. If not provided, default sessionization set in the Player settings is used.',
      type: 'integer',
      default: 0,
    },
    voice_id: {
      title: 'Voice Id',
      description:
        'Voice ID used to voice the content. If not provided, default voice ID set in the Player settings is used.',
      type: 'string',
    },
    model_id: {
      title: 'Model Id',
      description:
        'TTS Model ID used in the player. If not provided, default model ID set in the Player settings is used.',
      type: 'string',
    },
    file: {
      title: 'File',
      description:
        "Either txt or HTML input file containing the article content. HTML should be formatted as follows '&lt;html&gt;&lt;body&gt;&lt;div&gt;&lt;p&gt;Your content&lt;/p&gt;&lt;h5&gt;More of your content&lt;/h5&gt;&lt;p&gt;Some more of your content&lt;/p&gt;&lt;/div&gt;&lt;/body&gt;&lt;/html&gt;'",
      type: 'string',
      format: 'binary',
    },
    auto_convert: {
      title: 'Auto Convert',
      description: 'Whether to auto convert the project to audio or not.',
      type: 'boolean',
      default: false,
    },
  },
  type: 'object',
  required: ['name', 'file'],
} as const;

export const Body_Download_history_items_v1_history_download_postSchema = {
  title: 'Body_Download_history_items_v1_history_download_post',
  properties: {
    history_item_ids: {
      title: 'History Item Ids',
      description:
        'A list of history items to download, you can get IDs of history items and other metadata using the GET https://api.elevenlabs.io/v1/history endpoint.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    output_format: {
      title: 'Output Format',
      description: 'Output format to transcode the audio file, can be wav or default.',
      type: 'string',
    },
  },
  type: 'object',
  required: ['history_item_ids'],
} as const;

export const Body_Dub_a_video_or_an_audio_file_v1_dubbing_postSchema = {
  title: 'Body_Dub_a_video_or_an_audio_file_v1_dubbing_post',
  properties: {
    mode: {
      title: 'Mode',
      description: 'automatic or manual.',
      type: 'string',
    },
    file: {
      title: 'File',
      description: 'One or more audio files to clone the voice from',
      type: 'string',
      format: 'binary',
    },
    csv_file: {
      title: 'Csv File',
      description: 'CSV file containing transcription/translation metadata',
      type: 'string',
      format: 'binary',
    },
    foreground_audio_file: {
      title: 'Foreground Audio File',
      description: 'For use only with csv input',
      type: 'string',
      format: 'binary',
    },
    background_audio_file: {
      title: 'Background Audio File',
      description: 'For use only with csv input',
      type: 'string',
      format: 'binary',
    },
    name: {
      title: 'Name',
      description: 'Name of the dubbing project.',
      type: 'string',
    },
    source_url: {
      title: 'Source Url',
      description: 'URL of the source video/audio file.',
      type: 'string',
    },
    source_lang: {
      title: 'Source Lang',
      description: 'Source language.',
      type: 'string',
      default: 'auto',
    },
    target_lang: {
      title: 'Target Lang',
      description:
        'The Target language to dub the content into. Can be none if dubbing studio editor is enabled and running manual mode',
      type: 'string',
    },
    num_speakers: {
      title: 'Num Speakers',
      description: 'Number of speakers to use for the dubbing.',
      type: 'integer',
      default: 0,
    },
    watermark: {
      title: 'Watermark',
      description: 'Whether to apply watermark to the output video.',
      type: 'boolean',
      default: false,
    },
    start_time: {
      title: 'Start Time',
      description: 'Start time of the source video/audio file.',
      type: 'integer',
    },
    end_time: {
      title: 'End Time',
      description: 'End time of the source video/audio file.',
      type: 'integer',
    },
    highest_resolution: {
      title: 'Highest Resolution',
      description: 'Whether to use the highest resolution available.',
      type: 'boolean',
      default: false,
    },
    dubbing_studio: {
      title: 'Dubbing Studio',
      description: 'Whether to prepare dub for edits in dubbing studio.',
      type: 'boolean',
      default: false,
    },
  },
  type: 'object',
} as const;

export const Body_Edit_voice_v1_voices__voice_id__edit_postSchema = {
  title: 'Body_Edit_voice_v1_voices__voice_id__edit_post',
  properties: {
    description: {
      title: 'Description',
      description: 'How would you describe the voice?',
      type: 'string',
    },
    name: {
      title: 'Name',
      description: 'The name that identifies this voice. This will be displayed in the dropdown of the website.',
      type: 'string',
    },
    files: {
      title: 'Files',
      description: 'Audio files to add to the voice',
      items: {
        type: 'string',
        format: 'binary',
      },
      type: 'array',
    },
    labels: {
      title: 'Labels',
      description: 'Serialized labels dictionary for the voice.',
      type: 'string',
    },
  },
  type: 'object',
  required: ['name'],
} as const;

export const Body_Generate_a_random_voice_v1_voice_generation_generate_voice_postSchema = {
  title: 'Body_Generate_a_random_voice_v1_voice_generation_generate_voice_post',
  properties: {
    gender: {
      title: 'Gender',
      description: 'Category code corresponding to the gender of the generated voice. Possible values: female, male.',
      type: 'string',
      enum: ['female', 'male'],
    },
    accent: {
      title: 'Accent',
      description:
        'Category code corresponding to the accent of the generated voice. Possible values: american, british, african, australian, indian.',
      type: 'string',
    },
    age: {
      title: 'Age',
      description:
        'Category code corresponding to the age of the generated voice. Possible values: young, middle_aged, old.',
      type: 'string',
      enum: ['young', 'middle_aged', 'old'],
    },
    accent_strength: {
      title: 'Accent Strength',
      description: 'The strength of the accent of the generated voice. Has to be between 0.3 and 2.0.',
      type: 'number',
    },
    text: {
      title: 'Text',
      description: 'Text to generate, text length has to be between 100 and 1000.',
      type: 'string',
    },
  },
  type: 'object',
  required: ['gender', 'accent', 'age', 'accent_strength', 'text'],
} as const;

export const Body_Remove_rules_from_the_pronunciation_dictionary_v1_pronunciation_dictionaries__pronunciation_dictionary_id__remove_rules_postSchema =
  {
    title:
      'Body_Remove_rules_from_the_pronunciation_dictionary_v1_pronunciation_dictionaries__pronunciation_dictionary_id__remove_rules_post',
    properties: {
      rule_strings: {
        title: 'Rule Strings',
        description: 'List of strings to remove from the pronunciation dictionary.',
        items: {
          type: 'string',
        },
        type: 'array',
      },
    },
    type: 'object',
    required: ['rule_strings'],
  } as const;

export const Body_Speech_to_Speech_Streaming_v1_speech_to_speech__voice_id__stream_postSchema = {
  title: 'Body_Speech_to_Speech_Streaming_v1_speech_to_speech__voice_id__stream_post',
  properties: {
    audio: {
      title: 'Audio',
      description: 'The audio file which holds the content and emotion that will control the generated speech.',
      type: 'string',
      format: 'binary',
    },
    model_id: {
      title: 'Model Id',
      description:
        'Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for speech to speech, you can check this using the can_do_voice_conversion property.',
      type: 'string',
      default: 'eleven_english_sts_v2',
    },
    voice_settings: {
      title: 'Voice Settings',
      description:
        'Voice settings overriding stored setttings for the given voice. They are applied only on the given request. Needs to be send as a JSON encoded string.',
      type: 'string',
    },
  },
  type: 'object',
  required: ['audio'],
} as const;

export const Body_Speech_to_Speech_v1_speech_to_speech__voice_id__postSchema = {
  title: 'Body_Speech_to_Speech_v1_speech_to_speech__voice_id__post',
  properties: {
    audio: {
      title: 'Audio',
      description: 'The audio file which holds the content and emotion that will control the generated speech.',
      type: 'string',
      format: 'binary',
    },
    model_id: {
      title: 'Model Id',
      description:
        'Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for speech to speech, you can check this using the can_do_voice_conversion property.',
      type: 'string',
      default: 'eleven_english_sts_v2',
    },
    voice_settings: {
      title: 'Voice Settings',
      description:
        'Voice settings overriding stored setttings for the given voice. They are applied only on the given request. Needs to be send as a JSON encoded string.',
      type: 'string',
    },
  },
  type: 'object',
  required: ['audio'],
} as const;

export const Body_Stream_chapter_audio_v1_projects__project_id__chapters__chapter_id__snapshots__chapter_snapshot_id__stream_postSchema =
  {
    title:
      'Body_Stream_chapter_audio_v1_projects__project_id__chapters__chapter_id__snapshots__chapter_snapshot_id__stream_post',
    properties: {
      convert_to_mpeg: {
        title: 'Convert To Mpeg',
        description: 'Whether to convert the audio to mpeg format.',
        type: 'boolean',
        default: false,
      },
    },
    type: 'object',
  } as const;

export const Body_Stream_project_audio_v1_projects__project_id__snapshots__project_snapshot_id__stream_postSchema = {
  title: 'Body_Stream_project_audio_v1_projects__project_id__snapshots__project_snapshot_id__stream_post',
  properties: {
    convert_to_mpeg: {
      title: 'Convert To Mpeg',
      description: 'Whether to convert the audio to mpeg format.',
      type: 'boolean',
      default: false,
    },
  },
  type: 'object',
} as const;

export const Body_Text_to_speech_v1_text_to_speech__voice_id__postSchema = {
  title: 'Body_Text_to_speech_v1_text_to_speech__voice_id__post',
  properties: {
    text: {
      title: 'Text',
      description: 'The text that will get converted into speech.',
      type: 'string',
    },
    model_id: {
      title: 'Model Id',
      description:
        'Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for text to speech, you can check this using the can_do_text_to_speech property.',
      type: 'string',
      default: 'eleven_monolingual_v1',
    },
    voice_settings: {
      $ref: '#/components/schemas/VoiceSettingsResponseModel',
    },
    pronunciation_dictionary_locators: {
      title: 'Pronunciation Dictionary Locators',
      description:
        'A list of pronunciation dictionary locators (id, version_id) to be applied to the text. They will be applied in order. You may have up to 3 locators per request',
      items: {
        $ref: '#/components/schemas/PronunciationDictionaryVersionLocatorDBModel',
      },
      type: 'array',
      default: [],
    },
  },
  type: 'object',
  required: ['text'],
  'x-konfig-properties': {
    voice_settings: {
      title: 'Voice Settings',
      description:
        'Voice settings overriding stored setttings for the given voice. They are applied only on the given request.',
    },
  },
} as const;

export const Body_Text_to_speech_v1_text_to_speech__voice_id__stream_postSchema = {
  title: 'Body_Text_to_speech_v1_text_to_speech__voice_id__stream_post',
  properties: {
    text: {
      title: 'Text',
      description: 'The text that will get converted into speech.',
      type: 'string',
    },
    model_id: {
      title: 'Model Id',
      description:
        'Identifier of the model that will be used, you can query them using GET /v1/models. The model needs to have support for text to speech, you can check this using the can_do_text_to_speech property.',
      type: 'string',
      default: 'eleven_monolingual_v1',
    },
    voice_settings: {
      $ref: '#/components/schemas/VoiceSettingsResponseModel',
    },
    pronunciation_dictionary_locators: {
      title: 'Pronunciation Dictionary Locators',
      description:
        'A list of pronunciation dictionary locators (id, version_id) to be applied to the text. They will be applied in order. You may have up to 3 locators per request',
      items: {
        $ref: '#/components/schemas/PronunciationDictionaryVersionLocatorDBModel',
      },
      type: 'array',
      default: [],
    },
  },
  type: 'object',
  required: ['text'],
  'x-konfig-properties': {
    voice_settings: {
      title: 'Voice Settings',
      description:
        'Voice settings overriding stored setttings for the given voice. They are applied only on the given request.',
    },
  },
} as const;

export const Body_Update_Pronunciation_Dictionaries_v1_projects__project_id__update_pronunciation_dictionaries_postSchema =
  {
    title: 'Body_Update_Pronunciation_Dictionaries_v1_projects__project_id__update_pronunciation_dictionaries_post',
    properties: {
      pronunciation_dictionary_locators: {
        title: 'Pronunciation Dictionary Locators',
        description:
          'A list of pronunciation dictionary locators (id, version_id) encoded as a list of JSON strings for pronunciation dictionaries to be applied to the text.  A list of json encoded strings is required as adding projects may occur through formData as opposed to jsonBody',
        items: {
          $ref: '#/components/schemas/PronunciationDictionaryVersionLocatorDBModel',
        },
        type: 'array',
      },
    },
    type: 'object',
    required: ['pronunciation_dictionary_locators'],
  } as const;

export const ChapterResponseModelSchema = {
  title: 'ChapterResponseModel',
  properties: {
    chapter_id: {
      title: 'Chapter Id',
      type: 'string',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    last_conversion_date_unix: {
      title: 'Last Conversion Date Unix',
      type: 'integer',
    },
    conversion_progress: {
      title: 'Conversion Progress',
      type: 'number',
    },
    can_be_downloaded: {
      title: 'Can Be Downloaded',
      type: 'boolean',
    },
    state: {
      title: 'State',
      type: 'string',
      enum: ['default', 'converting'],
    },
    statistics: {
      $ref: '#/components/schemas/ChapterStatisticsResponseModel',
    },
  },
  type: 'object',
  required: [
    'chapter_id',
    'name',
    'last_conversion_date_unix',
    'conversion_progress',
    'can_be_downloaded',
    'state',
    'statistics',
  ],
} as const;

export const ChapterSnapshotResponseModelSchema = {
  title: 'ChapterSnapshotResponseModel',
  properties: {
    chapter_snapshot_id: {
      title: 'Chapter Snapshot Id',
      type: 'string',
    },
    project_id: {
      title: 'Project Id',
      type: 'string',
    },
    chapter_id: {
      title: 'Chapter Id',
      type: 'string',
    },
    created_at_unix: {
      title: 'Created At Unix',
      type: 'integer',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
  },
  type: 'object',
  required: ['chapter_snapshot_id', 'project_id', 'chapter_id', 'created_at_unix', 'name'],
} as const;

export const ChapterSnapshotsResponseModelSchema = {
  title: 'ChapterSnapshotsResponseModel',
  properties: {
    snapshots: {
      title: 'Snapshots',
      items: {
        $ref: '#/components/schemas/ChapterSnapshotResponseModel',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: ['snapshots'],
} as const;

export const ChapterStatisticsResponseModelSchema = {
  title: 'ChapterStatisticsResponseModel',
  properties: {
    characters_unconverted: {
      title: 'Characters Unconverted',
      type: 'integer',
    },
    characters_converted: {
      title: 'Characters Converted',
      type: 'integer',
    },
    paragraphs_converted: {
      title: 'Paragraphs Converted',
      type: 'integer',
    },
    paragraphs_unconverted: {
      title: 'Paragraphs Unconverted',
      type: 'integer',
    },
  },
  type: 'object',
  required: ['characters_unconverted', 'characters_converted', 'paragraphs_converted', 'paragraphs_unconverted'],
} as const;

export const DoDubbingResponseModelSchema = {
  title: 'DoDubbingResponseModel',
  properties: {
    dubbing_id: {
      title: 'Dubbing Id',
      type: 'string',
    },
    expected_duration_sec: {
      title: 'Expected Duration Sec',
      type: 'number',
    },
  },
  type: 'object',
  required: ['dubbing_id', 'expected_duration_sec'],
} as const;

export const DubbingMetadataResponseSchema = {
  title: 'DubbingMetadataResponse',
  properties: {
    dubbing_id: {
      title: 'Dubbing Id',
      type: 'string',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    status: {
      title: 'Status',
      type: 'string',
    },
    error: {
      title: 'Error',
      type: 'string',
    },
    target_languages: {
      title: 'Target Languages',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: ['dubbing_id', 'name', 'status', 'error', 'target_languages'],
} as const;

export const ExtendedSubscriptionResponseModelSchema = {
  title: 'ExtendedSubscriptionResponseModel',
  properties: {
    tier: {
      title: 'Tier',
      type: 'string',
    },
    character_count: {
      title: 'Character Count',
      type: 'integer',
    },
    character_limit: {
      title: 'Character Limit',
      type: 'integer',
    },
    can_extend_character_limit: {
      title: 'Can Extend Character Limit',
      type: 'boolean',
    },
    allowed_to_extend_character_limit: {
      title: 'Allowed To Extend Character Limit',
      type: 'boolean',
    },
    next_character_count_reset_unix: {
      title: 'Next Character Count Reset Unix',
      type: 'integer',
    },
    voice_limit: {
      title: 'Voice Limit',
      type: 'integer',
    },
    max_voice_add_edits: {
      title: 'Max Voice Add Edits',
      type: 'integer',
    },
    voice_add_edit_counter: {
      title: 'Voice Add Edit Counter',
      type: 'integer',
    },
    professional_voice_limit: {
      title: 'Professional Voice Limit',
      type: 'integer',
    },
    can_extend_voice_limit: {
      title: 'Can Extend Voice Limit',
      type: 'boolean',
    },
    can_use_instant_voice_cloning: {
      title: 'Can Use Instant Voice Cloning',
      type: 'boolean',
    },
    can_use_professional_voice_cloning: {
      title: 'Can Use Professional Voice Cloning',
      type: 'boolean',
    },
    currency: {
      title: 'Currency',
      type: 'string',
      enum: ['usd', 'eur'],
    },
    status: {
      title: 'Status',
      type: 'string',
      enum: ['trialing', 'active', 'incomplete', 'incomplete_expired', 'past_due', 'canceled', 'unpaid', 'free'],
    },
    billing_period: {
      title: 'Billing Period',
      type: 'string',
      enum: ['monthly_period', 'annual_period'],
    },
    next_invoice: {
      $ref: '#/components/schemas/InvoiceResponseModel',
    },
    has_open_invoices: {
      title: 'Has Open Invoices',
      type: 'boolean',
    },
  },
  type: 'object',
  required: [
    'tier',
    'character_count',
    'character_limit',
    'can_extend_character_limit',
    'allowed_to_extend_character_limit',
    'next_character_count_reset_unix',
    'voice_limit',
    'max_voice_add_edits',
    'voice_add_edit_counter',
    'professional_voice_limit',
    'can_extend_voice_limit',
    'can_use_instant_voice_cloning',
    'can_use_professional_voice_cloning',
    'currency',
    'status',
    'billing_period',
    'next_invoice',
    'has_open_invoices',
  ],
} as const;

export const FeedbackResponseModelSchema = {
  title: 'FeedbackResponseModel',
  properties: {
    thumbs_up: {
      title: 'Thumbs Up',
      type: 'boolean',
    },
    feedback: {
      title: 'Feedback',
      type: 'string',
    },
    emotions: {
      title: 'Emotions',
      type: 'boolean',
    },
    inaccurate_clone: {
      title: 'Inaccurate Clone',
      type: 'boolean',
    },
    glitches: {
      title: 'Glitches',
      type: 'boolean',
    },
    audio_quality: {
      title: 'Audio Quality',
      type: 'boolean',
    },
    other: {
      title: 'Other',
      type: 'boolean',
    },
    review_status: {
      title: 'Review Status',
      type: 'string',
      default: 'not_reviewed',
    },
  },
  type: 'object',
  required: ['thumbs_up', 'feedback', 'emotions', 'inaccurate_clone', 'glitches', 'audio_quality', 'other'],
} as const;

export const FineTuningResponseModelSchema = {
  title: 'FineTuningResponseModel',
  properties: {
    is_allowed_to_fine_tune: {
      title: 'Is Allowed To Fine Tune',
      type: 'boolean',
    },
    finetuning_state: {
      title: 'Finetuning State',
      type: 'string',
      enum: ['not_started', 'queued', 'fine_tuning', 'fine_tuned', 'failed', 'delayed'],
    },
    verification_failures: {
      title: 'Verification Failures',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    verification_attempts_count: {
      title: 'Verification Attempts Count',
      type: 'integer',
    },
    manual_verification_requested: {
      title: 'Manual Verification Requested',
      type: 'boolean',
    },
    language: {
      title: 'Language',
      type: 'string',
    },
    finetuning_progress: {
      title: 'Finetuning Progress',
      additionalProperties: {
        type: 'number',
      },
      type: 'object',
    },
    message: {
      title: 'Message',
      type: 'string',
    },
    dataset_duration_seconds: {
      title: 'Dataset Duration Seconds',
      type: 'number',
    },
    verification_attempts: {
      title: 'Verification Attempts',
      items: {
        $ref: '#/components/schemas/VerificationAttemptResponseModel',
      },
      type: 'array',
    },
    slice_ids: {
      title: 'Slice Ids',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    manual_verification: {
      $ref: '#/components/schemas/ManualVerificationResponseModel',
    },
  },
  type: 'object',
  required: [
    'is_allowed_to_fine_tune',
    'finetuning_state',
    'verification_failures',
    'verification_attempts_count',
    'manual_verification_requested',
  ],
} as const;

export const GetChaptersResponseModelSchema = {
  title: 'GetChaptersResponseModel',
  properties: {
    chapters: {
      title: 'Chapters',
      items: {
        $ref: '#/components/schemas/ChapterResponseModel',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: ['chapters'],
} as const;

export const GetLibraryVoicesResponseModelSchema = {
  title: 'GetLibraryVoicesResponseModel',
  properties: {
    voices: {
      title: 'Voices',
      items: {
        $ref: '#/components/schemas/LibraryVoiceResponseModel',
      },
      type: 'array',
    },
    has_more: {
      title: 'Has More',
      type: 'boolean',
    },
    last_sort_id: {
      title: 'Last Sort Id',
      type: 'string',
    },
  },
  type: 'object',
  required: ['voices', 'has_more'],
} as const;

export const GetProjectsResponseModelSchema = {
  title: 'GetProjectsResponseModel',
  properties: {
    projects: {
      title: 'Projects',
      items: {
        $ref: '#/components/schemas/ProjectResponseModel',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: ['projects'],
} as const;

export const GetPronunciationDictionariesMetadataResponseModelSchema = {
  title: 'GetPronunciationDictionariesMetadataResponseModel',
  properties: {
    pronunciation_dictionaries: {
      title: 'Pronunciation Dictionaries',
      items: {
        $ref: '#/components/schemas/GetPronunciationDictionaryMetadataResponseModel',
      },
      type: 'array',
    },
    next_cursor: {
      title: 'Next Cursor',
      type: 'string',
    },
    has_more: {
      title: 'Has More',
      type: 'boolean',
    },
  },
  type: 'object',
  required: ['pronunciation_dictionaries', 'next_cursor', 'has_more'],
} as const;

export const GetPronunciationDictionaryMetadataResponseModelSchema = {
  title: 'GetPronunciationDictionaryMetadataResponseModel',
  properties: {
    description: {
      title: 'Description',
      type: 'string',
    },
    id: {
      title: 'Id',
      type: 'string',
    },
    latest_version_id: {
      title: 'Latest Version Id',
      type: 'string',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    created_by: {
      title: 'Created By',
      type: 'string',
    },
    creation_time_unix: {
      title: 'Creation Time Unix',
      type: 'integer',
    },
  },
  type: 'object',
  required: ['id', 'latest_version_id', 'name', 'created_by', 'creation_time_unix'],
} as const;

export const GetSpeechHistoryResponseModelSchema = {
  title: 'GetSpeechHistoryResponseModel',
  properties: {
    history: {
      title: 'History',
      items: {
        $ref: '#/components/schemas/SpeechHistoryItemResponseModel',
      },
      type: 'array',
    },
    last_history_item_id: {
      title: 'Last History Item Id',
      type: 'string',
    },
    has_more: {
      title: 'Has More',
      type: 'boolean',
    },
  },
  type: 'object',
  required: ['history', 'last_history_item_id', 'has_more'],
} as const;

export const GetVoicesResponseModelSchema = {
  title: 'GetVoicesResponseModel',
  properties: {
    voices: {
      title: 'Voices',
      items: {
        $ref: '#/components/schemas/VoiceResponseModel',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: ['voices'],
} as const;

export const HTTPValidationErrorSchema = {
  title: 'HTTPValidationError',
  properties: {
    detail: {
      title: 'Detail',
      items: {
        $ref: '#/components/schemas/ValidationError',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const InvoiceResponseModelSchema = {
  title: 'InvoiceResponseModel',
  properties: {
    amount_due_cents: {
      title: 'Amount Due Cents',
      type: 'integer',
    },
    next_payment_attempt_unix: {
      title: 'Next Payment Attempt Unix',
      type: 'integer',
    },
  },
  type: 'object',
  required: ['amount_due_cents', 'next_payment_attempt_unix'],
} as const;

export const LanguageResponseModelSchema = {
  title: 'LanguageResponseModel',
  properties: {
    language_id: {
      title: 'Language Id',
      type: 'string',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
  },
  type: 'object',
  required: ['language_id', 'name'],
} as const;

export const LibraryVoiceResponseModelSchema = {
  title: 'LibraryVoiceResponseModel',
  properties: {
    description: {
      title: 'Description',
      type: 'string',
    },
    public_owner_id: {
      title: 'Public Owner Id',
      type: 'string',
    },
    voice_id: {
      title: 'Voice Id',
      type: 'string',
    },
    date_unix: {
      title: 'Date Unix',
      type: 'integer',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    accent: {
      title: 'Accent',
      type: 'string',
    },
    gender: {
      title: 'Gender',
      type: 'string',
    },
    age: {
      title: 'Age',
      type: 'string',
    },
    descriptive: {
      title: 'Descriptive',
      type: 'string',
    },
    use_case: {
      title: 'Use Case',
      type: 'string',
    },
    category: {
      title: 'Category',
      type: 'string',
    },
    language: {
      title: 'Language',
      type: 'string',
    },
    preview_url: {
      title: 'Preview Url',
      type: 'string',
    },
    usage_character_count_1y: {
      title: 'Usage Character Count 1Y',
      type: 'integer',
    },
    usage_character_count_7d: {
      title: 'Usage Character Count 7D',
      type: 'integer',
    },
    cloned_by_count: {
      title: 'Cloned By Count',
      type: 'integer',
    },
    rate: {
      title: 'Rate',
      type: 'number',
    },
    free_users_allowed: {
      title: 'Free Users Allowed',
      type: 'boolean',
    },
    live_moderation_enabled: {
      title: 'Live Moderation Enabled',
      type: 'boolean',
    },
    featured: {
      title: 'Featured',
      type: 'boolean',
    },
    notice_period: {
      title: 'Notice Period',
      type: 'integer',
    },
    instagram_username: {
      title: 'Instagram Username',
      type: 'string',
    },
    twitter_username: {
      title: 'Twitter Username',
      type: 'string',
    },
    youtube_username: {
      title: 'Youtube Username',
      type: 'string',
    },
    tiktok_username: {
      title: 'Tiktok Username',
      type: 'string',
    },
  },
  type: 'object',
  required: [
    'public_owner_id',
    'voice_id',
    'date_unix',
    'name',
    'accent',
    'gender',
    'age',
    'descriptive',
    'use_case',
    'category',
    'language',
    'description',
    'preview_url',
    'usage_character_count_1y',
    'usage_character_count_7d',
    'cloned_by_count',
    'rate',
    'free_users_allowed',
    'live_moderation_enabled',
    'featured',
  ],
} as const;

export const ManualVerificationFileResponseModelSchema = {
  title: 'ManualVerificationFileResponseModel',
  properties: {
    file_id: {
      title: 'File Id',
      type: 'string',
    },
    file_name: {
      title: 'File Name',
      type: 'string',
    },
    mime_type: {
      title: 'Mime Type',
      type: 'string',
    },
    size_bytes: {
      title: 'Size Bytes',
      type: 'integer',
    },
    upload_date_unix: {
      title: 'Upload Date Unix',
      type: 'integer',
    },
  },
  type: 'object',
  required: ['file_id', 'file_name', 'mime_type', 'size_bytes', 'upload_date_unix'],
} as const;

export const ManualVerificationResponseModelSchema = {
  title: 'ManualVerificationResponseModel',
  properties: {
    extra_text: {
      title: 'Extra Text',
      type: 'string',
    },
    request_time_unix: {
      title: 'Request Time Unix',
      type: 'integer',
    },
    files: {
      title: 'Files',
      items: {
        $ref: '#/components/schemas/ManualVerificationFileResponseModel',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: ['extra_text', 'request_time_unix', 'files'],
} as const;

export const ModelResponseModelSchema = {
  title: 'ModelResponseModel',
  properties: {
    description: {
      title: 'Description',
      type: 'string',
    },
    model_id: {
      title: 'Model Id',
      type: 'string',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    can_be_finetuned: {
      title: 'Can Be Finetuned',
      type: 'boolean',
    },
    can_do_text_to_speech: {
      title: 'Can Do Text To Speech',
      type: 'boolean',
    },
    can_do_voice_conversion: {
      title: 'Can Do Voice Conversion',
      type: 'boolean',
    },
    can_use_style: {
      title: 'Can Use Style',
      type: 'boolean',
    },
    can_use_speaker_boost: {
      title: 'Can Use Speaker Boost',
      type: 'boolean',
    },
    serves_pro_voices: {
      title: 'Serves Pro Voices',
      type: 'boolean',
    },
    token_cost_factor: {
      title: 'Token Cost Factor',
      type: 'number',
    },
    requires_alpha_access: {
      title: 'Requires Alpha Access',
      type: 'boolean',
    },
    max_characters_request_free_user: {
      title: 'Max Characters Request Free User',
      type: 'integer',
    },
    max_characters_request_subscribed_user: {
      title: 'Max Characters Request Subscribed User',
      type: 'integer',
    },
    languages: {
      title: 'Languages',
      items: {
        $ref: '#/components/schemas/LanguageResponseModel',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: [
    'model_id',
    'name',
    'can_be_finetuned',
    'can_do_text_to_speech',
    'can_do_voice_conversion',
    'can_use_style',
    'can_use_speaker_boost',
    'serves_pro_voices',
    'token_cost_factor',
    'description',
    'requires_alpha_access',
    'max_characters_request_free_user',
    'max_characters_request_subscribed_user',
    'languages',
  ],
} as const;

export const ProjectExtendedResponseModelSchema = {
  title: 'ProjectExtendedResponseModel',
  properties: {
    project_id: {
      title: 'Project Id',
      type: 'string',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    create_date_unix: {
      title: 'Create Date Unix',
      type: 'integer',
    },
    default_title_voice_id: {
      title: 'Default Title Voice Id',
      type: 'string',
    },
    default_paragraph_voice_id: {
      title: 'Default Paragraph Voice Id',
      type: 'string',
    },
    default_model_id: {
      title: 'Default Model Id',
      type: 'string',
    },
    last_conversion_date_unix: {
      title: 'Last Conversion Date Unix',
      type: 'integer',
    },
    can_be_downloaded: {
      title: 'Can Be Downloaded',
      type: 'boolean',
    },
    state: {
      title: 'State',
      type: 'string',
      enum: ['default', 'converting', 'in_queue'],
    },
    chapters: {
      title: 'Chapters',
      items: {
        $ref: '#/components/schemas/ChapterResponseModel',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: [
    'project_id',
    'name',
    'create_date_unix',
    'default_title_voice_id',
    'default_paragraph_voice_id',
    'default_model_id',
    'last_conversion_date_unix',
    'can_be_downloaded',
    'state',
    'chapters',
  ],
} as const;

export const ProjectResponseModelSchema = {
  title: 'ProjectResponseModel',
  properties: {
    title: {
      title: 'Title',
      type: 'string',
    },
    project_id: {
      title: 'Project Id',
      type: 'string',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    create_date_unix: {
      title: 'Create Date Unix',
      type: 'integer',
    },
    default_title_voice_id: {
      title: 'Default Title Voice Id',
      type: 'string',
    },
    default_paragraph_voice_id: {
      title: 'Default Paragraph Voice Id',
      type: 'string',
    },
    default_model_id: {
      title: 'Default Model Id',
      type: 'string',
    },
    last_conversion_date_unix: {
      title: 'Last Conversion Date Unix',
      type: 'integer',
    },
    can_be_downloaded: {
      title: 'Can Be Downloaded',
      type: 'boolean',
    },
    author: {
      title: 'Author',
      type: 'string',
    },
    isbn_number: {
      title: 'Isbn Number',
      type: 'string',
    },
    volume_normalization: {
      title: 'Volume Normalization',
      type: 'boolean',
    },
    state: {
      title: 'State',
      type: 'string',
      enum: ['default', 'converting'],
    },
  },
  type: 'object',
  required: [
    'project_id',
    'name',
    'create_date_unix',
    'default_title_voice_id',
    'default_paragraph_voice_id',
    'default_model_id',
    'last_conversion_date_unix',
    'can_be_downloaded',
    'title',
    'author',
    'isbn_number',
    'volume_normalization',
    'state',
  ],
} as const;

export const ProjectSnapshotResponseModelSchema = {
  title: 'ProjectSnapshotResponseModel',
  properties: {
    project_snapshot_id: {
      title: 'Project Snapshot Id',
      type: 'string',
    },
    project_id: {
      title: 'Project Id',
      type: 'string',
    },
    created_at_unix: {
      title: 'Created At Unix',
      type: 'integer',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
  },
  type: 'object',
  required: ['project_snapshot_id', 'project_id', 'created_at_unix', 'name'],
} as const;

export const ProjectSnapshotsResponseModelSchema = {
  title: 'ProjectSnapshotsResponseModel',
  properties: {
    snapshots: {
      title: 'Snapshots',
      items: {
        $ref: '#/components/schemas/ProjectSnapshotResponseModel',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: ['snapshots'],
} as const;

export const PronunciationDictionaryAliasRuleRequestModelSchema = {
  title: 'PronunciationDictionaryAliasRuleRequestModel',
  properties: {
    type: {
      title: 'Type',
      type: 'string',
      enum: ['alias'],
    },
    string_to_replace: {
      title: 'String To Replace',
      type: 'string',
    },
    alias: {
      title: 'Alias',
      type: 'string',
    },
  },
  type: 'object',
  required: ['type', 'string_to_replace', 'alias'],
} as const;

export const PronunciationDictionaryPhonemeRuleRequestModelSchema = {
  title: 'PronunciationDictionaryPhonemeRuleRequestModel',
  properties: {
    type: {
      title: 'Type',
      type: 'string',
      enum: ['phoneme'],
    },
    string_to_replace: {
      title: 'String To Replace',
      type: 'string',
    },
    phoneme: {
      title: 'Phoneme',
      type: 'string',
    },
    alphabet: {
      title: 'Alphabet',
      type: 'string',
    },
  },
  type: 'object',
  required: ['type', 'string_to_replace', 'phoneme', 'alphabet'],
} as const;

export const PronunciationDictionaryVersionLocatorDBModelSchema = {
  title: 'PronunciationDictionaryVersionLocatorDBModel',
  properties: {
    pronunciation_dictionary_id: {
      title: 'Pronunciation Dictionary Id',
      type: 'string',
    },
    version_id: {
      title: 'Version Id',
      type: 'string',
    },
  },
  type: 'object',
  required: ['pronunciation_dictionary_id', 'version_id'],
} as const;

export const RecordingResponseModelSchema = {
  title: 'RecordingResponseModel',
  properties: {
    recording_id: {
      title: 'Recording Id',
      type: 'string',
    },
    mime_type: {
      title: 'Mime Type',
      type: 'string',
    },
    size_bytes: {
      title: 'Size Bytes',
      type: 'integer',
    },
    upload_date_unix: {
      title: 'Upload Date Unix',
      type: 'integer',
    },
    transcription: {
      title: 'Transcription',
      type: 'string',
    },
  },
  type: 'object',
  required: ['recording_id', 'mime_type', 'size_bytes', 'upload_date_unix', 'transcription'],
} as const;

export const RemovePronunciationDictionaryRulesResponseModelSchema = {
  title: 'RemovePronunciationDictionaryRulesResponseModel',
  properties: {
    id: {
      title: 'Id',
      type: 'string',
    },
    version_id: {
      title: 'Version Id',
      type: 'string',
    },
  },
  type: 'object',
  required: ['id', 'version_id'],
} as const;

export const SampleResponseModelSchema = {
  title: 'SampleResponseModel',
  properties: {
    sample_id: {
      title: 'Sample Id',
      type: 'string',
    },
    file_name: {
      title: 'File Name',
      type: 'string',
    },
    mime_type: {
      title: 'Mime Type',
      type: 'string',
    },
    size_bytes: {
      title: 'Size Bytes',
      type: 'integer',
    },
    hash: {
      title: 'Hash',
      type: 'string',
    },
  },
  type: 'object',
  required: ['sample_id', 'file_name', 'mime_type', 'size_bytes', 'hash'],
} as const;

export const SpeechHistoryItemResponseModelSchema = {
  title: 'SpeechHistoryItemResponseModel',
  properties: {
    history_item_id: {
      title: 'History Item Id',
      type: 'string',
    },
    request_id: {
      title: 'Request Id',
      type: 'string',
    },
    voice_id: {
      title: 'Voice Id',
      type: 'string',
    },
    model_id: {
      title: 'Model Id',
      type: 'string',
    },
    voice_name: {
      title: 'Voice Name',
      type: 'string',
    },
    voice_category: {
      title: 'Voice Category',
      type: 'string',
      enum: ['premade', 'cloned', 'generated', 'professional'],
    },
    text: {
      title: 'Text',
      type: 'string',
    },
    date_unix: {
      title: 'Date Unix',
      type: 'integer',
    },
    character_count_change_from: {
      title: 'Character Count Change From',
      type: 'integer',
    },
    character_count_change_to: {
      title: 'Character Count Change To',
      type: 'integer',
    },
    content_type: {
      title: 'Content Type',
      type: 'string',
    },
    state: {
      title: 'State',
      type: 'string',
      enum: ['created', 'deleted', 'processing'],
    },
    settings: {
      title: 'Settings',
      type: 'object',
    },
    feedback: {
      $ref: '#/components/schemas/FeedbackResponseModel',
    },
    share_link_id: {
      title: 'Share Link Id',
      type: 'string',
    },
    source: {
      title: 'Source',
      type: 'string',
      enum: ['TTS', 'STS'],
    },
  },
  type: 'object',
  required: [
    'history_item_id',
    'request_id',
    'voice_id',
    'model_id',
    'voice_name',
    'voice_category',
    'text',
    'date_unix',
    'character_count_change_from',
    'character_count_change_to',
    'content_type',
    'state',
    'settings',
    'feedback',
    'share_link_id',
    'source',
  ],
} as const;

export const SsoProviderDBModelSchema = {
  title: 'SsoProviderDBModel',
  properties: {
    provider_type: {
      title: 'Provider Type',
      type: 'string',
      enum: ['saml', 'oidc'],
    },
    provider_id: {
      title: 'Provider Id',
      type: 'string',
    },
    domains: {
      title: 'Domains',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: ['provider_type', 'provider_id', 'domains'],
} as const;

export const SubscriptionResponseModelSchema = {
  title: 'SubscriptionResponseModel',
  properties: {
    tier: {
      title: 'Tier',
      type: 'string',
    },
    character_count: {
      title: 'Character Count',
      type: 'integer',
    },
    character_limit: {
      title: 'Character Limit',
      type: 'integer',
    },
    can_extend_character_limit: {
      title: 'Can Extend Character Limit',
      type: 'boolean',
    },
    allowed_to_extend_character_limit: {
      title: 'Allowed To Extend Character Limit',
      type: 'boolean',
    },
    next_character_count_reset_unix: {
      title: 'Next Character Count Reset Unix',
      type: 'integer',
    },
    voice_limit: {
      title: 'Voice Limit',
      type: 'integer',
    },
    max_voice_add_edits: {
      title: 'Max Voice Add Edits',
      type: 'integer',
    },
    voice_add_edit_counter: {
      title: 'Voice Add Edit Counter',
      type: 'integer',
    },
    professional_voice_limit: {
      title: 'Professional Voice Limit',
      type: 'integer',
    },
    can_extend_voice_limit: {
      title: 'Can Extend Voice Limit',
      type: 'boolean',
    },
    can_use_instant_voice_cloning: {
      title: 'Can Use Instant Voice Cloning',
      type: 'boolean',
    },
    can_use_professional_voice_cloning: {
      title: 'Can Use Professional Voice Cloning',
      type: 'boolean',
    },
    currency: {
      title: 'Currency',
      type: 'string',
      enum: ['usd', 'eur'],
    },
    status: {
      title: 'Status',
      type: 'string',
      enum: ['trialing', 'active', 'incomplete', 'incomplete_expired', 'past_due', 'canceled', 'unpaid', 'free'],
    },
    billing_period: {
      title: 'Billing Period',
      type: 'string',
      enum: ['monthly_period', 'annual_period'],
    },
  },
  type: 'object',
  required: [
    'tier',
    'character_count',
    'character_limit',
    'can_extend_character_limit',
    'allowed_to_extend_character_limit',
    'next_character_count_reset_unix',
    'voice_limit',
    'max_voice_add_edits',
    'voice_add_edit_counter',
    'professional_voice_limit',
    'can_extend_voice_limit',
    'can_use_instant_voice_cloning',
    'can_use_professional_voice_cloning',
    'currency',
    'status',
    'billing_period',
  ],
} as const;

export const UserResponseModelSchema = {
  title: 'UserResponseModel',
  properties: {
    subscription: {
      $ref: '#/components/schemas/SubscriptionResponseModel',
    },
    is_new_user: {
      title: 'Is New User',
      type: 'boolean',
    },
    xi_api_key: {
      title: 'Xi Api Key',
      type: 'string',
    },
    can_use_delayed_payment_methods: {
      title: 'Can Use Delayed Payment Methods',
      type: 'boolean',
    },
    is_onboarding_completed: {
      title: 'Is Onboarding Completed',
      type: 'boolean',
    },
    first_name: {
      title: 'First Name',
      type: 'string',
    },
  },
  type: 'object',
  required: ['subscription', 'is_new_user', 'xi_api_key', 'can_use_delayed_payment_methods', 'is_onboarding_completed'],
} as const;

export const ValidationErrorSchema = {
  title: 'ValidationError',
  properties: {
    loc: {
      title: 'Location',
      items: {
        anyOf: [
          {
            type: 'string',
          },
          {
            type: 'integer',
          },
        ],
      },
      type: 'array',
    },
    msg: {
      title: 'Message',
      type: 'string',
    },
    type: {
      title: 'Error Type',
      type: 'string',
    },
  },
  type: 'object',
  required: ['loc', 'msg', 'type'],
} as const;

export const VerificationAttemptResponseModelSchema = {
  title: 'VerificationAttemptResponseModel',
  properties: {
    text: {
      title: 'Text',
      type: 'string',
    },
    date_unix: {
      title: 'Date Unix',
      type: 'integer',
    },
    accepted: {
      title: 'Accepted',
      type: 'boolean',
    },
    similarity: {
      title: 'Similarity',
      type: 'number',
    },
    levenshtein_distance: {
      title: 'Levenshtein Distance',
      type: 'number',
    },
    recording: {
      $ref: '#/components/schemas/RecordingResponseModel',
    },
  },
  type: 'object',
  required: ['text', 'date_unix', 'accepted', 'similarity', 'levenshtein_distance'],
} as const;

export const VoiceGenerationParameterOptionResponseModelSchema = {
  title: 'VoiceGenerationParameterOptionResponseModel',
  properties: {
    name: {
      title: 'Name',
      type: 'string',
    },
    code: {
      title: 'Code',
      type: 'string',
    },
  },
  type: 'object',
  required: ['name', 'code'],
} as const;

export const VoiceGenerationParameterResponseModelSchema = {
  title: 'VoiceGenerationParameterResponseModel',
  properties: {
    genders: {
      title: 'Genders',
      items: {
        $ref: '#/components/schemas/VoiceGenerationParameterOptionResponseModel',
      },
      type: 'array',
    },
    accents: {
      title: 'Accents',
      items: {
        $ref: '#/components/schemas/VoiceGenerationParameterOptionResponseModel',
      },
      type: 'array',
    },
    ages: {
      title: 'Ages',
      items: {
        $ref: '#/components/schemas/VoiceGenerationParameterOptionResponseModel',
      },
      type: 'array',
    },
    minimum_characters: {
      title: 'Minimum Characters',
      type: 'integer',
    },
    maximum_characters: {
      title: 'Maximum Characters',
      type: 'integer',
    },
    minimum_accent_strength: {
      title: 'Minimum Accent Strength',
      type: 'number',
    },
    maximum_accent_strength: {
      title: 'Maximum Accent Strength',
      type: 'number',
    },
  },
  type: 'object',
  required: [
    'genders',
    'accents',
    'ages',
    'minimum_characters',
    'maximum_characters',
    'minimum_accent_strength',
    'maximum_accent_strength',
  ],
} as const;

export const VoiceResponseModelSchema = {
  title: 'VoiceResponseModel',
  properties: {
    description: {
      title: 'Description',
      type: 'string',
    },
    voice_id: {
      title: 'Voice Id',
      type: 'string',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    samples: {
      title: 'Samples',
      items: {
        $ref: '#/components/schemas/SampleResponseModel',
      },
      type: 'array',
    },
    category: {
      title: 'Category',
      type: 'string',
    },
    fine_tuning: {
      $ref: '#/components/schemas/FineTuningResponseModel',
    },
    labels: {
      title: 'Labels',
      additionalProperties: {
        type: 'string',
      },
      type: 'object',
    },
    preview_url: {
      title: 'Preview Url',
      type: 'string',
    },
    available_for_tiers: {
      title: 'Available For Tiers',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    settings: {
      $ref: '#/components/schemas/VoiceSettingsResponseModel',
    },
    sharing: {
      $ref: '#/components/schemas/VoiceSharingResponseModel',
    },
    high_quality_base_model_ids: {
      title: 'High Quality Base Model Ids',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    safety_control: {
      title: 'Safety Control',
      type: 'string',
      enum: ['NONE', 'BAN', 'CAPTCHA', 'CAPTCHA_AND_MODERATION'],
    },
    voice_verification: {
      $ref: '#/components/schemas/VoiceVerificationResponseModel',
    },
    owner_id: {
      title: 'Owner Id',
      type: 'string',
    },
    permission_on_resource: {
      title: 'Permission On Resource',
      type: 'string',
    },
  },
  type: 'object',
  required: [
    'voice_id',
    'name',
    'samples',
    'category',
    'fine_tuning',
    'labels',
    'description',
    'preview_url',
    'available_for_tiers',
    'settings',
    'sharing',
    'high_quality_base_model_ids',
  ],
} as const;

export const VoiceSettingsResponseModelSchema = {
  title: 'VoiceSettingsResponseModel',
  properties: {
    stability: {
      title: 'Stability',
      type: 'number',
    },
    similarity_boost: {
      title: 'Similarity Boost',
      type: 'number',
    },
    style: {
      title: 'Style',
      type: 'number',
      default: 0,
    },
    use_speaker_boost: {
      title: 'Use Speaker Boost',
      type: 'boolean',
      default: true,
    },
  },
  type: 'object',
  required: ['stability', 'similarity_boost'],
} as const;

export const VoiceSharingResponseModelSchema = {
  title: 'VoiceSharingResponseModel',
  properties: {
    description: {
      title: 'Description',
      type: 'string',
    },
    status: {
      title: 'Status',
      type: 'string',
      enum: ['enabled', 'disabled', 'copied', 'copied_disabled'],
    },
    history_item_sample_id: {
      title: 'History Item Sample Id',
      type: 'string',
    },
    date_unix: {
      title: 'Date Unix',
      type: 'integer',
    },
    whitelisted_emails: {
      title: 'Whitelisted Emails',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    public_owner_id: {
      title: 'Public Owner Id',
      type: 'string',
    },
    original_voice_id: {
      title: 'Original Voice Id',
      type: 'string',
    },
    financial_rewards_enabled: {
      title: 'Financial Rewards Enabled',
      type: 'boolean',
    },
    free_users_allowed: {
      title: 'Free Users Allowed',
      type: 'boolean',
    },
    live_moderation_enabled: {
      title: 'Live Moderation Enabled',
      type: 'boolean',
    },
    rate: {
      title: 'Rate',
      type: 'number',
    },
    notice_period: {
      title: 'Notice Period',
      type: 'integer',
    },
    disable_at_unix: {
      title: 'Disable At Unix',
      type: 'integer',
    },
    voice_mixing_allowed: {
      title: 'Voice Mixing Allowed',
      type: 'boolean',
    },
    featured: {
      title: 'Featured',
      type: 'boolean',
    },
    category: {
      title: 'Category',
      type: 'string',
      enum: ['generated', 'professional', 'high_quality'],
    },
    reader_app_enabled: {
      title: 'Reader App Enabled',
      type: 'boolean',
    },
    ban_reason: {
      title: 'Ban Reason',
      type: 'string',
    },
    liked_by_count: {
      title: 'Liked By Count',
      type: 'integer',
    },
    cloned_by_count: {
      title: 'Cloned By Count',
      type: 'integer',
    },
    name: {
      title: 'Name',
      type: 'string',
    },
    labels: {
      title: 'Labels',
      additionalProperties: {
        type: 'string',
      },
      type: 'object',
    },
    review_status: {
      title: 'Review Status',
      type: 'string',
      enum: ['not_requested', 'pending', 'declined', 'allowed', 'allowed_with_changes'],
    },
    review_message: {
      title: 'Review Message',
      type: 'string',
    },
    enabled_in_library: {
      title: 'Enabled In Library',
      type: 'boolean',
    },
    instagram_username: {
      title: 'Instagram Username',
      type: 'string',
    },
    twitter_username: {
      title: 'Twitter Username',
      type: 'string',
    },
    youtube_username: {
      title: 'Youtube Username',
      type: 'string',
    },
    tiktok_username: {
      title: 'Tiktok Username',
      type: 'string',
    },
  },
  type: 'object',
  required: [
    'status',
    'history_item_sample_id',
    'date_unix',
    'whitelisted_emails',
    'public_owner_id',
    'original_voice_id',
    'financial_rewards_enabled',
    'free_users_allowed',
    'live_moderation_enabled',
    'rate',
    'notice_period',
    'disable_at_unix',
    'voice_mixing_allowed',
    'featured',
    'category',
    'reader_app_enabled',
    'ban_reason',
    'liked_by_count',
    'cloned_by_count',
    'name',
    'description',
    'labels',
    'review_status',
    'review_message',
    'enabled_in_library',
  ],
} as const;

export const VoiceVerificationResponseModelSchema = {
  title: 'VoiceVerificationResponseModel',
  properties: {
    requires_verification: {
      title: 'Requires Verification',
      type: 'boolean',
    },
    is_verified: {
      title: 'Is Verified',
      type: 'boolean',
    },
    verification_failures: {
      title: 'Verification Failures',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    verification_attempts_count: {
      title: 'Verification Attempts Count',
      type: 'integer',
    },
    language: {
      title: 'Language',
      type: 'string',
    },
    verification_attempts: {
      title: 'Verification Attempts',
      items: {
        $ref: '#/components/schemas/VerificationAttemptResponseModel',
      },
      type: 'array',
    },
  },
  type: 'object',
  required: ['requires_verification', 'is_verified', 'verification_failures', 'verification_attempts_count'],
} as const;

export const SpeechhistoryDeleteHistoryItemByIdResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const SamplesRemoveByIdResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const VoicesDeleteByIdResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const VoicesEditSettingsPostResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const VoicesUpdateVoiceByIdResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const ProjectsDeleteByIdResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const ProjectsStartConversionResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const ProjectsDeleteChapterByIdResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const ProjectsStartChapterConversionResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const ProjectsUpdatePronunciationDictionariesResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const DubbingDeleteProjectResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const ModelsListAvailableModelsResponseSchema = {
  title: 'Response Get Models V1 Models Get',
  items: {
    $ref: '#/components/schemas/ModelResponseModel',
  },
  type: 'array',
} as const;

export const PronunciationDictionaryVersionDownloadResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;

export const RedirectToMintlifyDocsGetResponseSchema = {
  type: 'object',
  properties: {},
  example: {},
} as const;
