// Generated by ts-to-zod
import { z } from 'zod';

export const accessTypeSchema = z.union([
  z.literal('readonly'),
  z.literal('write'),
  z.literal('comment'),
  z.literal('none'),
]);

export const accessTypeNotNoneSchema = z.union([z.literal('readonly'), z.literal('write'), z.literal('comment')]);

export const nextPageTokenSchema = z.string();

export const nextPageLinkSchema = z.string();

export const aclMetadataSchema = z.object({
  canShare: z.boolean(),
  canShareWithWorkspace: z.boolean(),
  canShareWithOrg: z.boolean(),
  canCopy: z.boolean(),
});

export const aclSettingsSchema = z.object({
  allowEditorsToChangePermissions: z.boolean(),
  allowCopying: z.boolean(),
  allowViewersToRequestEditing: z.boolean(),
});

export const addCustomDocDomainRequestSchema = z.object({
  customDocDomain: z.string(),
});

export const addCustomDocDomainResponseSchema = z.record(z.unknown());

export const addedAnyonePrincipalSchema = z.object({
  type: z.literal('anyone'),
});

export const addedDomainPrincipalSchema = z.object({
  type: z.literal('domain'),
  domain: z.string(),
});

export const addedEmailPrincipalSchema = z.object({
  type: z.literal('email'),
  email: z.string(),
});

export const addedGroupPrincipalSchema = z.object({
  type: z.literal('group'),
  groupId: z.string(),
});

export const addedWorkspacePrincipalSchema = z.object({
  type: z.literal('workspace'),
  workspaceId: z.string(),
});

export const addPackCategoryRequestSchema = z.object({
  categoryName: z.string(),
});

export const addPackCategoryResponseSchema = z.record(z.unknown());

export const addPackMakerRequestSchema = z.object({
  loginId: z.string(),
});

export const addPackMakerResponseSchema = z.record(z.unknown());

export const packAccessTypeSchema = z.union([
  z.literal('view'),
  z.literal('test'),
  z.literal('edit'),
  z.literal('admin'),
]);

export const addPackPermissionResponseSchema = z.object({
  permissionId: z.string(),
});

export const addedPrincipalSchema = z.union([
  addedEmailPrincipalSchema,
  addedGroupPrincipalSchema,
  addedDomainPrincipalSchema,
  addedWorkspacePrincipalSchema,
  addedAnyonePrincipalSchema,
]);

export const addPermissionResultSchema = z.record(z.unknown());

export const analyticsLastUpdatedResponseSchema = z.object({
  docAnalyticsLastUpdated: z.string(),
  packAnalyticsLastUpdated: z.string(),
  packFormulaAnalyticsLastUpdated: z.string(),
});

export const analyticsScaleSchema = z.union([z.literal('daily'), z.literal('cumulative')]);

export const anyonePrincipalSchema = z.object({
  type: z.literal('anyone'),
});

export const typeSchema = z.union([
  z.literal('aclMetadata'),
  z.literal('aclPermissions'),
  z.literal('aclSettings'),
  z.literal('analyticsLastUpdated'),
  z.literal('apiLink'),
  z.literal('automation'),
  z.literal('column'),
  z.literal('control'),
  z.literal('doc'),
  z.literal('customDocDomain'),
  z.literal('customDocDomainProvider'),
  z.literal('docAnalytics'),
  z.literal('docAnalyticsSummary'),
  z.literal('docAnalyticsV2'),
  z.literal('folder'),
  z.literal('formula'),
  z.literal('mutationStatus'),
  z.literal('pack'),
  z.literal('packAclPermissions'),
  z.literal('packAnalytics'),
  z.literal('packAnalyticsSummary'),
  z.literal('packAsset'),
  z.literal('packCategory'),
  z.literal('packConfigurationSchema'),
  z.literal('packFeaturedDocs'),
  z.literal('packFormulaAnalytics'),
  z.literal('packLog'),
  z.literal('packMaker'),
  z.literal('packOauthConfig'),
  z.literal('packRelease'),
  z.literal('packSourceCode'),
  z.literal('packSystemConnection'),
  z.literal('packVersion'),
  z.literal('page'),
  z.literal('pageContentExport'),
  z.literal('pageContentExportStatus'),
  z.literal('principal'),
  z.literal('row'),
  z.literal('table'),
  z.literal('user'),
  z.literal('workspace'),
]);

export const apiLinkResolvedResourceSchema = z.object({
  type: typeSchema,
  id: z.string(),
  name: z.string().optional(),
  href: z.string(),
});

export const pageContentOutputFormatSchema = z.union([z.literal('html'), z.literal('markdown')]);

export const beginPageContentExportResponseSchema = z.object({
  id: z.string(),
  status: z.string(),
  href: z.string(),
});

export const paidFeatureSetSchema = z.union([z.literal('Pro'), z.literal('Team'), z.literal('Enterprise')]);

export const type2Schema = z.literal('BundledWithTier');

export const simpleColumnFormatSchema = z.object({
  type: z.literal('other'),
  isArray: z.boolean(),
});

export const workspaceUserRoleSchema = z.union([z.literal('Admin'), z.literal('DocMaker'), z.literal('Editor')]);

export const changeRoleResultSchema = z.object({
  roleChangedAt: z.string(),
});

export const checkboxDisplayTypeSchema = z.union([z.literal('toggle'), z.literal('check')]);

export const type3Schema = z.literal('column');

export const buttonColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    label: z.string().optional(),
    disableIf: z.string().optional(),
    action: z.string().optional(),
  }),
);

export const checkboxColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    displayType: checkboxDisplayTypeSchema,
  }),
);

export const dateColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    format: z.string().optional(),
  }),
);

export const dateTimeColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    dateFormat: z.string().optional(),
    timeFormat: z.string().optional(),
  }),
);

export const numericColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    precision: z.number().optional(),
    useThousandsSeparator: z.boolean().optional(),
  }),
);

export const selectColumnFormatSchema = simpleColumnFormatSchema.and(z.record(z.unknown()));

export const timeColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    format: z.string().optional(),
  }),
);

export const columnFormatTypeSchema = z.union([
  z.literal('text'),
  z.literal('person'),
  z.literal('lookup'),
  z.literal('number'),
  z.literal('percent'),
  z.literal('currency'),
  z.literal('date'),
  z.literal('dateTime'),
  z.literal('time'),
  z.literal('duration'),
  z.literal('email'),
  z.literal('link'),
  z.literal('slider'),
  z.literal('scale'),
  z.literal('image'),
  z.literal('imageReference'),
  z.literal('attachments'),
  z.literal('button'),
  z.literal('checkbox'),
  z.literal('select'),
  z.literal('packObject'),
  z.literal('reaction'),
  z.literal('canvas'),
  z.literal('other'),
]);

export const columnReferenceSchema = z.object({
  id: z.string(),
  type: z.literal('column'),
  href: z.string(),
});

export const pageReferenceSchema = z.object({
  id: z.string(),
  type: z.literal('page'),
  href: z.string(),
  browserLink: z.string(),
  name: z.string(),
});

export const controlTypeSchema = z.union([
  z.literal('button'),
  z.literal('checkbox'),
  z.literal('datePicker'),
  z.literal('dateRangePicker'),
  z.literal('dateTimePicker'),
  z.literal('lookup'),
  z.literal('multiselect'),
  z.literal('select'),
  z.literal('scale'),
  z.literal('slider'),
  z.literal('reaction'),
  z.literal('textbox'),
  z.literal('timePicker'),
]);

export const type4Schema = z.literal('control');

export const controlReferenceSchema = z.object({
  id: z.string(),
  type: z.literal('control'),
  href: z.string(),
  name: z.string(),
  parent: pageReferenceSchema.optional(),
});

export const createPackReleaseRequestSchema = z.object({
  packVersion: z.string(),
  releaseNotes: z.string().optional(),
});

export const createPackRequestSchema = z.object({
  workspaceId: z.string().optional(),
  name: z.string().optional(),
  description: z.string().optional(),
  sourcePackId: z.number().optional().nullable(),
});

export const createPackResponseSchema = z.object({
  packId: z.number(),
});

export const packSourceSchema = z.union([z.literal('web'), z.literal('cli')]);

export const validationErrorSchema = z.object({
  path: z.string(),
  message: z.string(),
});

export const currencyAmountSchema = z.union([z.string(), z.number()]);

export const currencyFormatTypeSchema = z.union([
  z.literal('currency'),
  z.literal('accounting'),
  z.literal('financial'),
]);

export const customDocDomainSetupStatusSchema = z.union([
  z.literal('pending'),
  z.literal('succeeded'),
  z.literal('failed'),
]);

export const customDomainConnectedStatusSchema = z.union([z.literal('connected'), z.literal('notConnected')]);

export const customDocDomainSchema = z.object({
  customDocDomain: z.string(),
  hasCertificate: z.boolean(),
  hasDnsDocId: z.boolean(),
  setupStatus: customDocDomainSetupStatusSchema,
  domainStatus: customDomainConnectedStatusSchema,
  lastVerifiedTimestamp: z.string().optional(),
});

export const customDocDomainProviderSchema = z.union([
  z.literal('GoDaddy'),
  z.literal('Namecheap'),
  z.literal('Hover (Tucows)'),
  z.literal('Network Solutions'),
  z.literal('Google Domains'),
  z.literal('Other'),
]);

export const customDocDomainProviderResponseSchema = z.object({
  provider: customDocDomainProviderSchema,
});

export const deleteCustomDocDomainResponseSchema = z.record(z.unknown());

export const deletePackCategoryResponseSchema = z.record(z.unknown());

export const deletePackMakerResponseSchema = z.record(z.unknown());

export const deletePackPermissionResponseSchema = z.record(z.unknown());

export const deletePackResponseSchema = z.record(z.unknown());

export const deletePermissionResultSchema = z.record(z.unknown());

export const iconSchema = z.object({
  name: z.string(),
  type: z.string(),
  browserLink: z.string(),
});

export const docSizeSchema = z.object({
  totalRowCount: z.number(),
  tableAndViewCount: z.number(),
  pageCount: z.number(),
  overApiSizeLimit: z.boolean(),
});

export const docReferenceSchema = z.object({
  id: z.string(),
  type: z.literal('doc'),
  href: z.string(),
  browserLink: z.string(),
});

export const folderReferenceSchema = z.object({
  id: z.string(),
  type: z.literal('folder'),
  browserLink: z.string(),
  name: z.string().optional(),
});

export const workspaceReferenceSchema = z.object({
  id: z.string(),
  type: z.literal('workspace'),
  organizationId: z.string().optional(),
  browserLink: z.string(),
  name: z.string().optional(),
});

export const type5Schema = z.literal('doc');

export const docAnalyticsDetailsSchema = docReferenceSchema.and(
  z.object({
    title: z.string(),
    icon: iconSchema.optional(),
    createdAt: z.string(),
    publishedAt: z.string().optional(),
  }),
);

export const docAnalyticsMetricsSchema = z.object({
  date: z.string(),
  views: z.number(),
  copies: z.number(),
  likes: z.number(),
  sessionsMobile: z.number(),
  sessionsDesktop: z.number(),
  sessionsOther: z.number(),
  totalSessions: z.number(),
  aiCreditsChat: z.number().optional(),
  aiCreditsBlock: z.number().optional(),
  aiCreditsColumn: z.number().optional(),
  aiCreditsAssistant: z.number().optional(),
  aiCreditsReviewer: z.number().optional(),
  aiCredits: z.number().optional(),
});

export const docAnalyticsOrderBySchema = z.union([
  z.literal('date'),
  z.literal('docId'),
  z.literal('title'),
  z.literal('createdAt'),
  z.literal('publishedAt'),
  z.literal('likes'),
  z.literal('copies'),
  z.literal('views'),
  z.literal('sessionsDesktop'),
  z.literal('sessionsMobile'),
  z.literal('sessionsOther'),
  z.literal('totalSessions'),
  z.literal('aiCreditsChat'),
  z.literal('aiCreditsBlock'),
  z.literal('aiCreditsColumn'),
  z.literal('aiCreditsAssistant'),
  z.literal('aiCreditsReviewer'),
  z.literal('aiCredits'),
]);

export const docAnalyticsSummarySchema = z.object({
  totalSessions: z.number(),
});

export const docCategorySchema = z.object({
  name: z.string(),
});

export const docCategoryListSchema = z.object({
  items: z.array(docCategorySchema),
});

export const docDeleteSchema = z.record(z.unknown());

export const docPublishModeSchema = z.union([z.literal('view'), z.literal('play'), z.literal('edit')]);

export const docPublishedSchema = z.object({
  description: z.string().optional(),
  browserLink: z.string(),
  imageLink: z.string().optional(),
  discoverable: z.boolean(),
  earnCredit: z.boolean(),
  mode: docPublishModeSchema,
  categories: z.array(docCategorySchema),
});

export const documentCreationResultSchema = z.object({
  id: z.string(),
  type: z.literal('doc'),
  href: z.string(),
  browserLink: z.string(),
  icon: iconSchema.optional(),
  name: z.string(),
  owner: z.string(),
  ownerName: z.string(),
  docSize: docSizeSchema.optional(),
  sourceDoc: z.record(z.unknown()).and(docReferenceSchema).optional(),
  createdAt: z.string(),
  updatedAt: z.string(),
  published: docPublishedSchema.optional(),
  folder: folderReferenceSchema,
  workspace: workspaceReferenceSchema,
  workspaceId: z.string(),
  folderId: z.string(),
  requestId: z.string().optional(),
});

export const documentMutateResponseSchema = z.object({
  requestId: z.string(),
});

export const docUpdateSchema = z.object({
  title: z.string().optional(),
  iconName: z.string().optional(),
});

export const docUpdateResultSchema = z.record(z.unknown());

export const domainPrincipalSchema = z.object({
  type: z.literal('domain'),
  domain: z.string(),
});

export const durationUnitSchema = z.union([
  z.literal('days'),
  z.literal('hours'),
  z.literal('minutes'),
  z.literal('seconds'),
]);

export const emailDisplayTypeSchema = z.union([
  z.literal('iconAndEmail'),
  z.literal('iconOnly'),
  z.literal('emailOnly'),
]);

export const emailPrincipalSchema = z.object({
  type: z.literal('email'),
  email: z.string(),
});

export const featuredDocStatusSchema = z.union([
  z.literal('docInaccessibleOrDoesNotExist'),
  z.literal('invalidPublishedDocUrl'),
]);

export const featureSetSchema = z.union([
  z.literal('Basic'),
  z.literal('Pro'),
  z.literal('Team'),
  z.literal('Enterprise'),
]);

export const type6Schema = z.literal('folder');

export const type7Schema = z.literal('formula');

export const formulaDetailSchema = z.object({
  valid: z.boolean(),
  isVolatile: z.boolean().optional(),
  hasUserFormula: z.boolean().optional(),
  hasTodayFormula: z.boolean().optional(),
  hasNowFormula: z.boolean().optional(),
});

export const formulaReferenceSchema = z.object({
  id: z.string(),
  type: z.literal('formula'),
  href: z.string(),
  name: z.string(),
  parent: pageReferenceSchema.optional(),
});

export const freePackPlanPricingSchema = z.object({
  type: z.literal('Free'),
});

export const type8Schema = z.literal('Free');

export const getNextPackVersionRequestSchema = z.object({
  proposedMetadata: z.string(),
  sdkVersion: z.string().optional(),
});

export const getPackConfigurationJsonSchemaResponseSchema = z.record(z.unknown());

export const workspaceRoleActivitySchema = z.object({
  month: z.string(),
  activeAdminCount: z.number(),
  activeDocMakerCount: z.number(),
  activeEditorCount: z.number(),
  inactiveAdminCount: z.number(),
  inactiveDocMakerCount: z.number(),
  inactiveEditorCount: z.number(),
});

export const groupPrincipalSchema = z.object({
  type: z.literal('group'),
  groupId: z.string(),
  groupName: z.string(),
});

export const iconSetSchema = z.union([
  z.literal('star'),
  z.literal('circle'),
  z.literal('fire'),
  z.literal('bug'),
  z.literal('diamond'),
  z.literal('bell'),
  z.literal('thumbsup'),
  z.literal('heart'),
  z.literal('chili'),
  z.literal('smiley'),
  z.literal('lightning'),
  z.literal('currency'),
  z.literal('coffee'),
  z.literal('person'),
  z.literal('battery'),
  z.literal('cocktail'),
  z.literal('cloud'),
  z.literal('sun'),
  z.literal('checkmark'),
  z.literal('lightbulb'),
]);

export const imageSchema = z.object({
  browserLink: z.string(),
  type: z.string().optional(),
  width: z.number().optional(),
  height: z.number().optional(),
});

export const numberOrNumberFormulaSchema = z.union([z.number(), z.string()]);

export const imageShapeStyleSchema = z.union([z.literal('auto'), z.literal('circle')]);

export const imageStatusSchema = z.union([z.literal('live'), z.literal('deleted'), z.literal('failed')]);

export const ingestionExecutionContextSchema = z.object({
  ingestionName: z.string().nullable(),
  csbIngestionExecutionId: z.string(),
  creationTimestamp: z.number(),
  parentItemId: z.string().nullable(),
});

export const ingestionExecutionsListSchema = z.object({
  items: z.array(ingestionExecutionContextSchema),
  nextPageToken: nextPageTokenSchema.optional(),
});

export const ingestionPackReleaseChannelSchema = z.union([z.literal('LIVE'), z.literal('LATEST')]);

export const layoutSchema = z.union([
  z.literal('default'),
  z.literal('areaChart'),
  z.literal('barChart'),
  z.literal('bubbleChart'),
  z.literal('calendar'),
  z.literal('card'),
  z.literal('detail'),
  z.literal('form'),
  z.literal('ganttChart'),
  z.literal('lineChart'),
  z.literal('masterDetail'),
  z.literal('pieChart'),
  z.literal('scatterChart'),
  z.literal('slide'),
  z.literal('wordCloud'),
]);

export const linkDisplayTypeSchema = z.union([
  z.literal('iconOnly'),
  z.literal('url'),
  z.literal('title'),
  z.literal('card'),
  z.literal('embed'),
]);

export const linkedDataTypeSchema = z.union([
  z.literal('ImageObject'),
  z.literal('MonetaryAmount'),
  z.literal('Person'),
  z.literal('WebPage'),
  z.literal('StructuredValue'),
]);

export const publishingCategorySchema = z.object({
  categoryId: z.string(),
  categoryName: z.string(),
  categorySlug: z.string().optional(),
});

export const makerSchema = z.object({
  name: z.string(),
  pictureLink: z.string().optional(),
  slug: z.string().optional(),
  jobTitle: z.string().optional(),
  employer: z.string().optional(),
  description: z.string().optional(),
  loginId: z.string(),
});

export const logLevelSchema = z.union([
  z.literal('error'),
  z.literal('warn'),
  z.literal('info'),
  z.literal('debug'),
  z.literal('trace'),
  z.literal('unknown'),
]);

export const makerSummarySchema = z.object({
  name: z.string(),
  pictureLink: z.string().optional(),
  slug: z.string().optional(),
  jobTitle: z.string().optional(),
  employer: z.string().optional(),
  description: z.string().optional(),
});

export const packPlanCurrencySchema = z.literal('USD');

export const type9Schema = z.literal('MonthlyDocMaker');

export const mutationStatusSchema = z.object({
  completed: z.boolean(),
  warning: z.string().optional(),
});

export const nextPackVersionInfoSchema = z.object({
  nextVersion: z.string(),
  findings: z.array(z.string()),
});

export const nextSyncTokenSchema = z.string();

export const packImageFileSchema = z.object({
  filename: z.string(),
  imageUrl: z.string(),
  assetId: z.string(),
  altText: z.string().optional(),
  mimeType: z.string().optional(),
});

export const packSourceCodeVisibilitySchema = z.union([z.literal('private'), z.literal('shared')]);

export const packRateLimitSchema = z.object({
  intervalSeconds: z.number(),
  operationsPerInterval: z.number(),
});

export const packAccessTypesSchema = z.array(packAccessTypeSchema);

export const packAnalyticsDetailsSchema = z.object({
  id: z.number(),
  name: z.string(),
  logoUrl: z.string().optional(),
  createdAt: z.string(),
});

export const packAnalyticsMetricsSchema = z.object({
  date: z.string(),
  docInstalls: z.number(),
  workspaceInstalls: z.number(),
  numFormulaInvocations: z.number(),
  numActionInvocations: z.number(),
  numSyncInvocations: z.number(),
  numMetadataInvocations: z.number(),
  docsActivelyUsing: z.number(),
  docsActivelyUsing7Day: z.number(),
  docsActivelyUsing30Day: z.number(),
  docsActivelyUsing90Day: z.number(),
  docsActivelyUsingAllTime: z.number(),
  workspacesActivelyUsing: z.number(),
  workspacesActivelyUsing7Day: z.number(),
  workspacesActivelyUsing30Day: z.number(),
  workspacesActivelyUsing90Day: z.number(),
  workspacesActivelyUsingAllTime: z.number(),
  workspacesActivelyTrialing: z.number(),
  workspacesActivelyTrialing7Day: z.number(),
  workspacesActivelyTrialing30Day: z.number(),
  workspacesActivelyTrialing90Day: z.number(),
  workspacesActivelyTrialingAllTime: z.number(),
  workspacesNewlySubscribed: z.number(),
  workspacesWithActiveSubscriptions: z.number(),
  workspacesWithSuccessfulTrials: z.number(),
  revenueUsd: z.string(),
});

export const packAnalyticsOrderBySchema = z.union([
  z.literal('date'),
  z.literal('packId'),
  z.literal('name'),
  z.literal('createdAt'),
  z.literal('docInstalls'),
  z.literal('workspaceInstalls'),
  z.literal('numFormulaInvocations'),
  z.literal('numActionInvocations'),
  z.literal('numSyncInvocations'),
  z.literal('numMetadataInvocations'),
  z.literal('docsActivelyUsing'),
  z.literal('docsActivelyUsing7Day'),
  z.literal('docsActivelyUsing30Day'),
  z.literal('docsActivelyUsing90Day'),
  z.literal('docsActivelyUsingAllTime'),
  z.literal('workspacesActivelyUsing'),
  z.literal('workspacesActivelyUsing7Day'),
  z.literal('workspacesActivelyUsing30Day'),
  z.literal('workspacesActivelyUsing90Day'),
  z.literal('workspacesActivelyUsingAllTime'),
  z.literal('workspacesWithActiveSubscriptions'),
  z.literal('workspacesWithSuccessfulTrials'),
  z.literal('revenueUsd'),
]);

export const packAnalyticsSummarySchema = z.object({
  totalDocInstalls: z.number(),
  totalWorkspaceInstalls: z.number(),
  totalInvocations: z.number(),
});

export const packAssetTypeSchema = z.union([z.literal('logo'), z.literal('cover'), z.literal('exampleImage')]);

export const packAssetUploadCompleteRequestSchema = z.object({
  packAssetType: packAssetTypeSchema,
});

export const packAssetUploadCompleteResponseSchema = z.object({
  requestId: z.string(),
  assetId: z.string(),
});

export const packAssetUploadInfoSchema = z.object({
  uploadUrl: z.string(),
  packAssetUploadedPathName: z.string(),
  headers: z.record(z.string()),
});

export const packConfigurationEntrySchema = z.object({
  configurationId: z.string(),
  name: z.string(),
  policy: z.record(z.unknown()).optional(),
});

export const packConnectionCustomCredentialsSchema = z.object({
  type: z.literal('custom'),
  params: z.array(
    z.object({
      key: z.string(),
      value: z.string(),
    }),
  ),
});

export const packConnectionCustomMetadataSchema = z.object({
  type: z.literal('custom'),
  params: z.array(
    z.object({
      key: z.string(),
      maskedValue: z.string(),
    }),
  ),
  domain: z.string(),
  presetKeys: z.array(z.string()),
});

export const packConnectionCustomPatchSchema = z.object({
  type: z.literal('custom'),
  paramsToPatch: z
    .array(
      z.object({
        key: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
});

export const packConnectionGoogleServiceAccountCredentialsSchema = z.object({
  type: z.literal('googleServiceAccount'),
  serviceAccountKey: z.string(),
});

export const packConnectionGoogleServiceAccountMetadataSchema = z.object({
  type: z.literal('googleServiceAccount'),
  maskedServiceAccountKey: z.string(),
});

export const packConnectionGoogleServiceAccountPatchSchema = z.object({
  type: z.literal('googleServiceAccount'),
  serviceAccountKey: z.string().optional(),
});

export const packConnectionHeaderCredentialsSchema = z.object({
  type: z.literal('header'),
  token: z.string(),
});

export const packConnectionHeaderMetadataSchema = z.object({
  type: z.literal('header'),
  maskedToken: z.string().optional(),
  headerName: z.string(),
  tokenPrefix: z.string(),
});

export const packConnectionHeaderPatchSchema = z.object({
  type: z.literal('header'),
  token: z.string().optional(),
});

export const packConnectionHttpBasicCredentialsSchema = z.object({
  type: z.literal('httpBasic'),
  username: z.string(),
  password: z.string().optional(),
});

export const packConnectionHttpBasicMetadataSchema = z.object({
  type: z.literal('httpBasic'),
  maskedUsername: z.string().optional(),
  maskedPassword: z.string().optional(),
});

export const packConnectionHttpBasicPatchSchema = z.object({
  type: z.literal('httpBasic'),
  username: z.string().optional(),
  password: z.string().optional(),
});

export const packConnectionMultiHeaderCredentialsSchema = z.object({
  type: z.literal('multiHeader'),
  tokens: z.array(
    z.object({
      key: z.string(),
      value: z.string(),
    }),
  ),
});

export const packConnectionMultiHeaderMetadataSchema = z.object({
  type: z.literal('multiHeader'),
  headers: z.array(
    z.object({
      headerName: z.string(),
      maskedToken: z.string(),
      tokenPrefix: z.string().optional(),
    }),
  ),
  presets: z.array(
    z.object({
      headerName: z.string(),
      tokenPrefix: z.string().optional(),
    }),
  ),
});

export const packConnectionMultiHeaderPatchSchema = z.object({
  type: z.literal('multiHeader'),
  tokensToPatch: z
    .array(
      z.object({
        key: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
});

export const packConnectionOauth2ClientCredentialsSchema = z.object({
  type: z.literal('oauth2ClientCredentials'),
  clientId: z.string(),
  clientSecret: z.string(),
});

export const packOAuth2ClientCredentialsLocationSchema = z.union([
  z.literal('automatic'),
  z.literal('body'),
  z.literal('header'),
]);

export const packConnectionOauth2ClientCredentialsPatchSchema = z.object({
  type: z.literal('oauth2ClientCredentials'),
  clientId: z.string().optional(),
  clientSecret: z.string().optional(),
});

export const packConnectionTypeSchema = z.union([
  z.literal('header'),
  z.literal('multiHeader'),
  z.literal('urlParam'),
  z.literal('httpBasic'),
  z.literal('custom'),
  z.literal('oauth2ClientCredentials'),
  z.literal('googleServiceAccount'),
]);

export const packConnectionUrlParamCredentialsSchema = z.object({
  type: z.literal('urlParam'),
  params: z.array(
    z.object({
      key: z.string(),
      value: z.string(),
    }),
  ),
});

export const packConnectionUrlParamMetadataSchema = z.object({
  type: z.literal('urlParam'),
  params: z.array(
    z.object({
      key: z.string(),
      maskedValue: z.string(),
    }),
  ),
  domain: z.string(),
  presetKeys: z.array(z.string()),
});

export const packConnectionUrlParamPatchSchema = z.object({
  type: z.literal('urlParam'),
  paramsToPatch: z
    .array(
      z.object({
        key: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
});

export const packDiscoverabilitySchema = z.union([z.literal('public'), z.literal('workspace'), z.literal('private')]);

export const packFeaturedDocSchema = z.object({
  doc: docReferenceSchema,
  isPinned: z.boolean(),
  docStatus: featuredDocStatusSchema.optional(),
  publishedUrl: z.string().optional(),
});

export const packFeaturedDocRequestItemSchema = z.object({
  url: z.string(),
  isPinned: z.boolean().optional(),
});

export const packFeaturedDocsResponseSchema = z.object({
  items: z.array(packFeaturedDocSchema),
});

export const methodSchema = z.union([
  z.literal('GET'),
  z.literal('POST'),
  z.literal('PUT'),
  z.literal('DELETE'),
  z.literal('PATCH'),
  z.literal('HEAD'),
]);

export const packFormulaAnalyticsMetricsSchema = z.object({
  date: z.string(),
  formulaInvocations: z.number(),
  errors: z.number(),
  medianLatencyMs: z.number().optional(),
  medianResponseSizeBytes: z.number().optional(),
  docsActivelyUsing: z.number(),
  docsActivelyUsing7Day: z.number(),
  docsActivelyUsing30Day: z.number(),
  docsActivelyUsing90Day: z.number(),
  docsActivelyUsingAllTime: z.number(),
  workspacesActivelyUsing: z.number(),
  workspacesActivelyUsing7Day: z.number(),
  workspacesActivelyUsing30Day: z.number(),
  workspacesActivelyUsing90Day: z.number(),
  workspacesActivelyUsingAllTime: z.number(),
  workspacesActivelyTrialing: z.number().optional(),
  workspacesActivelyTrialing7Day: z.number().optional(),
  workspacesActivelyTrialing30Day: z.number().optional(),
  workspacesActivelyTrialing90Day: z.number().optional(),
  workspacesActivelyTrialingAllTime: z.number().optional(),
  workspacesNewlySubscribed: z.number().optional(),
  workspacesWithActiveSubscriptions: z.number().optional(),
  workspacesWithSuccessfulTrials: z.number().optional(),
  revenueUsd: z.string().optional(),
});

export const packFormulaAnalyticsOrderBySchema = z.union([
  z.literal('date'),
  z.literal('formulaName'),
  z.literal('formulaType'),
  z.literal('formulaInvocations'),
  z.literal('medianLatencyMs'),
  z.literal('medianResponseSizeBytes'),
  z.literal('errors'),
  z.literal('docsActivelyUsing'),
  z.literal('docsActivelyUsing7Day'),
  z.literal('docsActivelyUsing30Day'),
  z.literal('docsActivelyUsing90Day'),
  z.literal('docsActivelyUsingAllTime'),
  z.literal('workspacesActivelyUsing'),
  z.literal('workspacesActivelyUsing7Day'),
  z.literal('workspacesActivelyUsing30Day'),
  z.literal('workspacesActivelyUsing90Day'),
  z.literal('workspacesActivelyUsingAllTime'),
]);

export const packFormulaTypeSchema = z.union([
  z.literal('action'),
  z.literal('formula'),
  z.literal('sync'),
  z.literal('metadata'),
]);

export const packGlobalPrincipalSchema = z.object({
  type: z.literal('global'),
});

export const packListingInstallContextTypeSchema = z.union([z.literal('workspace'), z.literal('doc')]);

export const packListingsSortBySchema = z.union([
  z.literal('packId'),
  z.literal('name'),
  z.literal('packVersion'),
  z.literal('packVersionModifiedAt'),
]);

export const packLogRequestTypeSchema = z.union([
  z.literal('unknown'),
  z.literal('connectionNameMetadataRequest'),
  z.literal('parameterAutocompleteMetadataRequest'),
  z.literal('postAuthSetupMetadataRequest'),
  z.literal('propertyOptionsMetadataRequest'),
  z.literal('getSyncTableSchemaMetadataRequest'),
  z.literal('getDynamicSyncTableNameMetadataRequest'),
  z.literal('listSyncTableDynamicUrlsMetadataRequest'),
  z.literal('searchSyncTableDynamicUrlsMetadataRequest'),
  z.literal('getDynamicSyncTableDisplayUrlMetadataRequest'),
  z.literal('getIdentifiersForConnectionRequest'),
  z.literal('invokeFormulaRequest'),
  z.literal('invokeSyncFormulaRequest'),
  z.literal('invokeSyncUpdateFormulaRequest'),
]);

export const packLogTypeSchema = z.union([
  z.literal('custom'),
  z.literal('fetcher'),
  z.literal('invocation'),
  z.literal('internal'),
  z.literal('auth'),
  z.literal('ingestionLifecycle'),
  z.literal('ingestionDebug'),
]);

export const packOauthConfigMetadataSchema = z.object({
  maskedClientId: z.string(),
  maskedClientSecret: z.string(),
  authorizationUrl: z.string(),
  tokenUrl: z.string(),
  tokenPrefix: z.string().optional(),
  scopes: z.string().optional(),
  redirectUri: z.string(),
});

export const packOrganizationAccessForCodaBrainSchema = z.object({
  canRequestAccess: z.boolean(),
  hasRequestedAccess: z.boolean(),
  requiresConfiguration: z.boolean(),
  allowedConfigurations: z.array(packConfigurationEntrySchema).optional(),
});

export const userSummarySchema = z.object({
  name: z.string(),
  loginId: z.string(),
  type: z.literal('user'),
  pictureLink: z.string().optional(),
});

export const packPlanPricingTypeSchema = z.union([
  z.literal('Free'),
  z.literal('MonthlyDocMaker'),
  z.literal('BundledWithTier'),
]);

export const packUserPrincipalSchema = z.object({
  type: z.literal('user'),
  email: z.string(),
});

export const packWorkspacePrincipalSchema = z.object({
  type: z.literal('workspace'),
  workspaceId: z.string(),
});

export const packPrincipalTypeSchema = z.union([z.literal('user'), z.literal('workspace'), z.literal('worldwide')]);

export const packReleaseSchema = z.object({
  packId: z.number(),
  releaseNotes: z.string(),
  createdAt: z.string(),
  releaseId: z.number(),
  packVersion: z.string(),
  sdkVersion: z.string(),
});

export const packReleaseListSchema = z.object({
  items: z.array(packReleaseSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const packSourceCodeSchema = z.object({
  filename: z.string(),
  url: z.string(),
});

export const packSourceCodeInfoSchema = z.object({
  files: z.array(packSourceCodeSchema),
});

export const packSourceCodeUploadCompleteRequestSchema = z.object({
  filename: z.string(),
  codeHash: z.string(),
});

export const packSourceCodeUploadCompleteResponseSchema = z.object({
  requestId: z.string(),
});

export const packSourceCodeUploadInfoSchema = z.object({
  uploadUrl: z.string(),
  uploadedPathName: z.string(),
  headers: z.record(z.string()),
});

export const packsSortBySchema = z.union([z.literal('title'), z.literal('createdAt'), z.literal('updatedAt')]);

export const packSummarySchema = z.object({
  id: z.number(),
  logoUrl: z.string().optional(),
  coverUrl: z.string().optional(),
  exampleImages: z.array(packImageFileSchema).optional(),
  workspaceId: z.string(),
  categories: z.array(publishingCategorySchema),
  certified: z.boolean().optional(),
  sourceCodeVisibility: packSourceCodeVisibilitySchema.optional(),
  name: z.string(),
  description: z.string(),
  shortDescription: z.string(),
  supportEmail: z.string().optional(),
  termsOfServiceUrl: z.string().optional(),
  privacyPolicyUrl: z.string().optional(),
});

export const packSummaryListSchema = z.object({
  items: z.array(packSummarySchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const packSystemConnectionCredentialsSchema = z.union([
  packConnectionHeaderCredentialsSchema,
  packConnectionMultiHeaderCredentialsSchema,
  packConnectionUrlParamCredentialsSchema,
  packConnectionHttpBasicCredentialsSchema,
  packConnectionCustomCredentialsSchema,
  packConnectionOauth2ClientCredentialsSchema,
  packConnectionGoogleServiceAccountCredentialsSchema,
]);

export const packConnectionOauth2ClientCredentialsMetadataSchema = z.object({
  type: z.literal('oauth2ClientCredentials'),
  location: packOAuth2ClientCredentialsLocationSchema,
  maskedClientId: z.string(),
  maskedClientSecret: z.string(),
});

export const packVersionSchema = z.object({
  packId: z.number(),
  buildNotes: z.string(),
  createdAt: z.string(),
  creationUserLoginId: z.string(),
  releaseId: z.number().optional(),
  packVersion: z.string(),
  sdkVersion: z.string().optional(),
  source: packSourceSchema.optional(),
});

export const packVersionDiffsSchema = z.object({
  findings: z.array(z.string()),
});

export const packVersionListSchema = z.object({
  items: z.array(packVersionSchema),
  creationUsers: z.array(userSummarySchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const packVersionUploadInfoSchema = z.object({
  uploadUrl: z.string(),
  headers: z.record(z.string()),
});

export const pageTypeSchema = z.union([z.literal('canvas'), z.literal('embed'), z.literal('syncPage')]);

export const type10Schema = z.literal('page');

export const pageAnalyticsDetailsSchema = z.object({
  id: z.string(),
  name: z.string(),
  icon: iconSchema.optional(),
});

export const pageAnalyticsMetricsSchema = z.object({
  date: z.string(),
  views: z.number(),
  sessions: z.number(),
  users: z.number(),
  averageSecondsViewed: z.number(),
  medianSecondsViewed: z.number(),
  tabs: z.number(),
});

export const pageContentFormatSchema = z.union([z.literal('html'), z.literal('markdown')]);

export const pageContentExportStatusSchema = z.union([
  z.literal('inProgress'),
  z.literal('failed'),
  z.literal('complete'),
]);

export const pageContentExportStatusResponseSchema = z.object({
  id: z.string(),
  status: z.string(),
  href: z.string(),
  downloadLink: z.string().optional(),
  error: z.string().optional(),
});

export const pageContentInsertionModeSchema = z.union([z.literal('append'), z.literal('replace')]);

export const pageContentSchema = z.object({
  format: pageContentFormatSchema,
  content: z.string(),
});

export const pageEmbedRenderMethodSchema = z.union([z.literal('compatibility'), z.literal('standard')]);

export const type11Schema = z.literal('canvas');

export const modeSchema = z.literal('page');

export const pageCreateResultSchema = documentMutateResponseSchema.and(
  z.object({
    id: z.string(),
  }),
);

export const pageDeleteResultSchema = documentMutateResponseSchema.and(
  z.object({
    id: z.string(),
  }),
);

export const pageContentUpdateSchema = z.object({
  insertionMode: pageContentInsertionModeSchema,
  canvasContent: pageContentSchema,
});

export const pageUpdateResultSchema = documentMutateResponseSchema.and(
  z.object({
    id: z.string(),
  }),
);

export const parameterbasePackVersionSchema = z.string();

export const parametercategoryNameSchema = z.string();

export const parametercolumnIdOrNameSchema = z.string();

export const parametercontrolIdOrNameSchema = z.string();

export const parametercustomDocDomainSchema = z.string();

export const sortDirectionSchema = z.union([z.literal('ascending'), z.literal('descending')]);

export const parameterdocAnalyticsOrderBySchema = docAnalyticsOrderBySchema;

export const parameterdocIdSchema = z.string();

export const parameterdocIdsSchema = z.array(z.string());

export const parameterexcludeIndividualAclsSchema = z.boolean();

export const parameterexcludePublicPacksSchema = z.boolean();

export const parameterexcludeWorkspaceAclsSchema = z.boolean();

export const parameterformulaIdOrNameSchema = z.string();

export const parameterincludedRolesSchema = z.array(workspaceUserRoleSchema);

export const parameteringestionExecutionIdSchema = z.string();

export const parameterisOwnerSchema = z.boolean();

export const parameterisPublishedSchema = z.boolean();

export const parameterisPublishedNoDefaultSchema = z.boolean();

export const parameterlimitSchema = z.number();

export const parameterloginIdSchema = z.string();

export const parameteronlyWorkspaceIdSchema = z.string();

export const parameterorganizationIdSchema = z.string();

export const parameterpackAccessTypesSchema = packAccessTypesSchema;

export const parameterpackAnalyticsOrderBySchema = packAnalyticsOrderBySchema;

export const parameterpackAssetIdSchema = z.string();

export const parameterpackAssetTypeSchema = packAssetTypeSchema;

export const parameterpackFormulaAnalyticsOrderBySchema = packFormulaAnalyticsOrderBySchema;

export const parameterpackIdSchema = z.number();

export const parameterpackIdsSchema = z.array(z.number());

export const parameterpackReleaseIdSchema = z.number();

export const parameterpackVersionSchema = z.string();

export const parameterpageIdOrNameSchema = z.string();

export const parameterpageTokenSchema = z.string();

export const parameterparentWorkspaceIdsSchema = z.array(z.string());

export const parameterpermissionIdSchema = z.string();

export const parameterquerySchema = z.string();

export const parameterrequestIdSchema = z.string();

export const parameterrootIngestionIdSchema = z.string();

export const parameterrowIdOrNameSchema = z.string();

export const parameterruleIdSchema = z.string();

export const parameterscaleSchema = analyticsScaleSchema;

export const parametersinceDateSchema = z.string();

export const sortBySchema = z.literal('name');

export const parametersyncTokenSchema = z.string();

export const parametertableIdOrNameSchema = z.string();

export const tableTypeSchema = z.union([z.literal('table'), z.literal('view')]);

export const parametertargetPackVersionSchema = z.string();

export const parameteruntilDateSchema = z.string();

export const parameteruseColumnNamesSchema = z.boolean();

export const parameterviewIdOrNameSchema = z.string();

export const parameterworkspaceIdSchema = z.string();

export const parameterworkspaceIdInQuerySchema = z.string();

export const patchPackSystemConnectionRequestSchema = z.union([
  packConnectionHeaderPatchSchema,
  packConnectionMultiHeaderPatchSchema,
  packConnectionUrlParamPatchSchema,
  packConnectionHttpBasicPatchSchema,
  packConnectionCustomPatchSchema,
  packConnectionOauth2ClientCredentialsPatchSchema,
  packConnectionGoogleServiceAccountPatchSchema,
]);

export const linkedDataObjectSchema = z.object({
  '@context': z.string(),
  '@type': linkedDataTypeSchema,
  additionalType: z.string().optional(),
});

export const workspacePrincipalSchema = z.object({
  type: z.literal('workspace'),
  workspaceId: z.string(),
});

export const principalTypeSchema = z.union([
  z.literal('email'),
  z.literal('group'),
  z.literal('domain'),
  z.literal('workspace'),
  z.literal('anyone'),
]);

export const publishResultSchema = documentMutateResponseSchema.and(z.record(z.unknown()));

export const pushButtonResultSchema = documentMutateResponseSchema.and(
  z.object({
    rowId: z.string(),
    columnId: z.string(),
  }),
);

export const tableReferenceSchema = z.object({
  id: z.string(),
  type: z.literal('table'),
  tableType: tableTypeSchema,
  href: z.string(),
  browserLink: z.string(),
  name: z.string(),
  parent: pageReferenceSchema.optional(),
});

export const registerPackVersionRequestSchema = z.object({
  bundleHash: z.string(),
});

export const scalarValueSchema = z.union([z.string(), z.number(), z.boolean()]);

export const currencyValueSchema = linkedDataObjectSchema.and(
  z.object({
    currency: z.string(),
    amount: currencyAmountSchema,
  }),
);

export const imageUrlValueSchema = linkedDataObjectSchema.and(
  z.object({
    name: z.string().optional(),
    url: z.string().optional(),
    height: z.number().optional(),
    width: z.number().optional(),
    status: imageStatusSchema.optional(),
  }),
);

export const personValueSchema = linkedDataObjectSchema.and(
  z.object({
    name: z.string(),
    email: z.string(),
  }),
);

export const urlValueSchema = linkedDataObjectSchema.and(
  z.object({
    name: z.string().optional(),
    url: z.string(),
  }),
);

export const rowValueSchema = linkedDataObjectSchema.and(
  z.object({
    name: z.string(),
    url: z.string(),
    tableId: z.string(),
    rowId: z.string(),
    tableUrl: z.string(),
    additionalType: z.literal('row'),
  }),
);

export const richSingleValueSchema = z.union([
  scalarValueSchema,
  currencyValueSchema,
  imageUrlValueSchema,
  personValueSchema,
  urlValueSchema,
  rowValueSchema,
]);

export const type12Schema = z.literal('row');

export const rowDeleteResultSchema = documentMutateResponseSchema.and(
  z.object({
    id: z.string(),
  }),
);

export const rowsDeleteSchema = z.object({
  rowIds: z.array(z.string()),
});

export const rowsDeleteResultSchema = documentMutateResponseSchema.and(
  z.object({
    rowIds: z.array(z.string()),
  }),
);

export const rowsSortBySchema = z.union([z.literal('createdAt'), z.literal('natural'), z.literal('updatedAt')]);

export const rowsUpsertResultSchema = documentMutateResponseSchema.and(
  z.object({
    addedRowIds: z.array(z.string()).optional(),
  }),
);

export const rowUpdateResultSchema = documentMutateResponseSchema.and(
  z.object({
    id: z.string(),
  }),
);

export const additionalTypeSchema = z.literal('row');

export const scaleColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    maximum: z.number(),
    icon: z.unknown().and(iconSetSchema),
  }),
);

export const searchPrincipalsResponseSchema = z.object({
  users: z.array(userSummarySchema),
  groups: z.array(groupPrincipalSchema),
});

export const selectOptionSchema = z.object({
  name: z.string(),
  backgroundColor: z.string().optional(),
  foregroundColor: z.string().optional(),
});

export const setPackOauthConfigRequestSchema = z.object({
  clientId: z.string().optional(),
  clientSecret: z.string().optional(),
  redirectUri: z.string().optional(),
});

export const setPackSystemConnectionRequestSchema = z.object({
  credentials: packSystemConnectionCredentialsSchema,
});

export const sliderDisplayTypeSchema = z.union([z.literal('slider'), z.literal('progress')]);

export const sortSchema = z.object({
  column: columnReferenceSchema,
  direction: sortDirectionSchema,
});

export const monthlyDocMakerPackPlanPricingSchema = z.object({
  type: z.literal('MonthlyDocMaker'),
  amount: z.number(),
  currency: packPlanCurrencySchema,
});

export const syncPageTypeSchema = z.union([z.literal('page'), z.literal('document')]);

export const tableSchema = z.object({
  id: z.string(),
  type: z.literal('table'),
  tableType: tableTypeSchema,
  href: z.string(),
  browserLink: z.string(),
  name: z.string(),
  parent: pageReferenceSchema,
  parentTable: tableReferenceSchema.optional(),
  displayColumn: columnReferenceSchema,
  rowCount: z.number(),
  sorts: z.array(sortSchema),
  layout: layoutSchema,
  filter: z.unknown().and(formulaDetailSchema).optional(),
  createdAt: z.string(),
  updatedAt: z.string(),
});

export const type13Schema = z.literal('table');

export const tableListSchema = z.object({
  items: z.array(tableReferenceSchema),
  href: z.string().optional(),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const unpublishResultSchema = z.record(z.unknown());

export const updateAclSettingsRequestSchema = z.object({
  allowEditorsToChangePermissions: z.boolean().optional(),
  allowCopying: z.boolean().optional(),
  allowViewersToRequestEditing: z.boolean().optional(),
});

export const updateCustomDocDomainRequestSchema = z.record(z.unknown());

export const updateCustomDocDomainResponseSchema = z.record(z.unknown());

export const updatePackFeaturedDocsRequestSchema = z.object({
  items: z.array(packFeaturedDocRequestItemSchema),
});

export const updatePackFeaturedDocsResponseSchema = z.record(z.unknown());

export const updatePackReleaseRequestSchema = z.object({
  releaseNotes: z.string().optional(),
});

export const updatePackRequestSchema = z.object({
  overallRateLimit: z
    .object({
      intervalSeconds: z.number(),
      operationsPerInterval: z.number(),
    })
    .optional()
    .nullable(),
  perConnectionRateLimit: z
    .object({
      intervalSeconds: z.number(),
      operationsPerInterval: z.number(),
    })
    .optional()
    .nullable(),
  logoAssetId: z.string().optional().nullable(),
  coverAssetId: z.string().optional().nullable(),
  exampleImages: z
    .array(
      z.object({
        assetId: z.string(),
        filename: z.string(),
        mimeType: z.string().optional(),
      }),
    )
    .optional()
    .nullable(),
  sourceCodeVisibility: packSourceCodeVisibilitySchema.optional().nullable(),
  name: z.string().optional(),
  description: z.string().optional(),
  shortDescription: z.string().optional(),
  supportEmail: z.string().optional(),
  termsOfServiceUrl: z.string().optional(),
  privacyPolicyUrl: z.string().optional(),
});

export const uploadPackAssetRequestSchema = z.object({
  packAssetType: packAssetTypeSchema,
  imageHash: z.string(),
  mimeType: z.string(),
  filename: z.string(),
});

export const uploadPackSourceCodeRequestSchema = z.object({
  payloadHash: z.string(),
  filename: z.string(),
  packVersion: z.string().optional(),
});

export const userSchema = z.object({
  name: z.string(),
  loginId: z.string(),
  type: z.literal('user'),
  pictureLink: z.string().optional(),
  scoped: z.boolean(),
  tokenName: z.string(),
  href: z.string(),
  workspace: workspaceReferenceSchema,
});

export const type14Schema = z.literal('user');

export const valueSchema = z.union([
  scalarValueSchema,
  z.array(z.union([scalarValueSchema, z.array(scalarValueSchema)])),
]);

export const valueFormatSchema = z.union([z.literal('simple'), z.literal('simpleWithArrays'), z.literal('rich')]);

export const webhookTriggerPayloadSchema = z.record(z.unknown());

export const webhookTriggerResultSchema = documentMutateResponseSchema.and(z.record(z.unknown()));

export const workspaceSchema = z.object({
  id: z.string(),
  type: z.literal('workspace'),
  organizationId: z.string().optional(),
  browserLink: z.string(),
  name: z.string(),
  description: z.string().optional(),
});

export const type15Schema = z.literal('workspace');

export const workspaceUserSchema = z.object({
  email: z.string(),
  name: z.string(),
  role: workspaceUserRoleSchema,
  pictureUrl: z.string().optional(),
  registeredAt: z.string(),
  roleChangedAt: z.string().optional(),
  lastActiveAt: z.string().optional(),
  ownedDocs: z.number().optional(),
  docsLastActiveAt: z.string().optional(),
  docCollaboratorCount: z.number().optional(),
  totalDocs: z.number().optional(),
  totalDocsLastActiveAt: z.string().optional(),
  totalDocCollaboratorsLast90Days: z.number().optional(),
});

export const listCategoriesResponseSchema = docCategoryListSchema;

export const listCategoriesErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listDocsDataSchema = z.object({
  query: z
    .object({
      folderId: z.string().optional(),
      inGallery: z.boolean().optional(),
      isOwner: z.boolean().optional(),
      isPublished: z.boolean().optional(),
      isStarred: z.boolean().optional(),
      limit: z.number().optional(),
      pageToken: z.string().optional(),
      query: z.string().optional(),
      sourceDoc: z.string().optional(),
      workspaceId: z.string().optional(),
    })
    .optional(),
});

export const listDocsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const createDocResponseSchema = documentCreationResultSchema;

export const createDocErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getDocDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
});

export const docSchema = z.object({
  id: z.string(),
  type: z.literal('doc'),
  href: z.string(),
  browserLink: z.string(),
  icon: iconSchema.optional(),
  name: z.string(),
  owner: z.string(),
  ownerName: z.string(),
  docSize: docSizeSchema.optional(),
  sourceDoc: z.record(z.unknown()).and(docReferenceSchema).optional(),
  createdAt: z.string(),
  updatedAt: z.string(),
  published: docPublishedSchema.optional(),
  folder: folderReferenceSchema,
  workspace: workspaceReferenceSchema,
  workspaceId: z.string(),
  folderId: z.string(),
});

export const getDocErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const deleteDocDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
});

export const deleteDocResponseSchema = docDeleteSchema;

export const deleteDocErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const updateDocDataSchema = z.object({
  body: docUpdateSchema,
  path: z.object({
    docId: z.string(),
  }),
});

export const updateDocResponseSchema = docUpdateResultSchema;

export const updateDocErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getSharingMetadataDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
});

export const getSharingMetadataResponseSchema = aclMetadataSchema;

export const getSharingMetadataErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getPermissionsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
    })
    .optional(),
});

export const getPermissionsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const addPermissionRequestSchema = z.object({
  access: accessTypeNotNoneSchema,
  principal: addedPrincipalSchema,
  suppressEmail: z.boolean().optional(),
});

export const addPermissionResponseSchema = addPermissionResultSchema;

export const addPermissionErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const deletePermissionDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    permissionId: z.string(),
  }),
});

export const deletePermissionResponseSchema = deletePermissionResultSchema;

export const deletePermissionErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const searchPrincipalsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
  query: z
    .object({
      query: z.string().optional(),
    })
    .optional(),
});

export const searchPrincipalsResponse2Schema = searchPrincipalsResponseSchema;

export const searchPrincipalsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getAclSettingsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
});

export const getAclSettingsResponseSchema = aclSettingsSchema;

export const getAclSettingsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const updateAclSettingsDataSchema = z.object({
  body: updateAclSettingsRequestSchema,
  path: z.object({
    docId: z.string(),
  }),
});

export const updateAclSettingsResponseSchema = aclSettingsSchema;

export const updateAclSettingsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const docPublishSchema = z.object({
  slug: z.string().optional(),
  discoverable: z.boolean().optional(),
  earnCredit: z.boolean().optional(),
  categoryNames: z.array(z.string()).optional(),
  mode: docPublishModeSchema.optional(),
});

export const publishDocResponseSchema = publishResultSchema;

export const publishDocErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const unpublishDocDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
});

export const unpublishDocResponseSchema = unpublishResultSchema;

export const unpublishDocErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listPagesDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
    })
    .optional(),
});

export const listPagesErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const createPageResponseSchema = pageCreateResultSchema;

export const createPageErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getPageDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    pageIdOrName: z.string(),
  }),
});

export const pageSchema = z.object({
  id: z.string(),
  type: z.literal('page'),
  href: z.string(),
  browserLink: z.string(),
  name: z.string(),
  subtitle: z.string().optional(),
  icon: iconSchema.optional(),
  image: imageSchema.optional(),
  contentType: pageTypeSchema,
  isHidden: z.boolean(),
  isEffectivelyHidden: z.boolean(),
  parent: pageReferenceSchema.optional(),
  children: z.array(pageReferenceSchema),
  authors: z.array(personValueSchema).optional(),
  createdAt: z.string().optional(),
  createdBy: personValueSchema.optional(),
  updatedAt: z.string().optional(),
  updatedBy: personValueSchema.optional(),
});

export const getPageErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const pageUpdateSchema = z.object({
  name: z.string().optional(),
  subtitle: z.string().optional(),
  iconName: z.string().optional(),
  imageUrl: z.string().optional(),
  isHidden: z.boolean().optional(),
  contentUpdate: z.record(z.unknown()).and(pageContentUpdateSchema).optional(),
});

export const updatePageResponseSchema = pageUpdateResultSchema;

export const updatePageErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const deletePageDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    pageIdOrName: z.string(),
  }),
});

export const deletePageResponseSchema = pageDeleteResultSchema;

export const deletePageErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const beginPageContentExportRequestSchema = z.object({
  outputFormat: pageContentOutputFormatSchema,
});

export const beginPageContentExportResponse2Schema = beginPageContentExportResponseSchema;

export const beginPageContentExportErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getPageContentExportStatusDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    pageIdOrName: z.string(),
    requestId: z.string(),
  }),
});

export const getPageContentExportStatusResponseSchema = pageContentExportStatusResponseSchema;

export const getPageContentExportStatusErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listTablesDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
      sortBy: sortBySchema.optional(),
      tableTypes: z.array(tableTypeSchema).optional(),
    })
    .optional(),
});

export const listTablesResponseSchema = tableListSchema;

export const listTablesErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getTableDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    tableIdOrName: z.string(),
  }),
  query: z
    .object({
      useUpdatedTableLayouts: z.boolean().optional(),
    })
    .optional(),
});

export const getTableResponseSchema = tableSchema;

export const getTableErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listColumnsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    tableIdOrName: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
      visibleOnly: z.boolean().optional(),
    })
    .optional(),
});

export const listColumnsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listRowsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    tableIdOrName: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
      query: z.string().optional(),
      sortBy: rowsSortBySchema.optional(),
      syncToken: z.string().optional(),
      useColumnNames: z.boolean().optional(),
      valueFormat: valueFormatSchema.optional(),
      visibleOnly: z.boolean().optional(),
    })
    .optional(),
});

export const listRowsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const upsertRowsResponseSchema = rowsUpsertResultSchema;

export const upsertRowsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const deleteRowsDataSchema = z.object({
  body: rowsDeleteSchema,
  path: z.object({
    docId: z.string(),
    tableIdOrName: z.string(),
  }),
});

export const deleteRowsResponseSchema = rowsDeleteResultSchema;

export const deleteRowsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getRowDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    rowIdOrName: z.string(),
    tableIdOrName: z.string(),
  }),
  query: z
    .object({
      useColumnNames: z.boolean().optional(),
      valueFormat: valueFormatSchema.optional(),
    })
    .optional(),
});

export const getRowErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const updateRowResponseSchema = rowUpdateResultSchema;

export const updateRowErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const deleteRowDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    rowIdOrName: z.string(),
    tableIdOrName: z.string(),
  }),
});

export const deleteRowResponseSchema = rowDeleteResultSchema;

export const deleteRowErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const pushButtonDataSchema = z.object({
  path: z.object({
    columnIdOrName: z.string(),
    docId: z.string(),
    rowIdOrName: z.string(),
    tableIdOrName: z.string(),
  }),
});

export const pushButtonResponseSchema = pushButtonResultSchema;

export const pushButtonErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getColumnDataSchema = z.object({
  path: z.object({
    columnIdOrName: z.string(),
    docId: z.string(),
    tableIdOrName: z.string(),
  }),
});

export const getColumnErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listFormulasDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
      sortBy: sortBySchema.optional(),
    })
    .optional(),
});

export const formulaListSchema = z.object({
  items: z.array(formulaReferenceSchema),
  href: z.string().optional(),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const listFormulasErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getFormulaDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    formulaIdOrName: z.string(),
  }),
});

export const formulaSchema = z.object({
  id: z.string(),
  type: z.literal('formula'),
  href: z.string(),
  name: z.string(),
  parent: pageReferenceSchema.optional(),
  value: valueSchema,
});

export const getFormulaErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listControlsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
      sortBy: sortBySchema.optional(),
    })
    .optional(),
});

export const controlListSchema = z.object({
  items: z.array(controlReferenceSchema),
  href: z.string().optional(),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const listControlsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getControlDataSchema = z.object({
  path: z.object({
    controlIdOrName: z.string(),
    docId: z.string(),
  }),
});

export const controlSchema = z.object({
  id: z.string(),
  type: z.literal('control'),
  href: z.string(),
  name: z.string(),
  parent: pageReferenceSchema.optional(),
  controlType: controlTypeSchema,
  value: valueSchema,
});

export const getControlErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listCustomDocDomainsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
});

export const customDocDomainListSchema = z.object({
  customDocDomains: z.array(customDocDomainSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const listCustomDocDomainsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const addCustomDocDomainDataSchema = z.object({
  body: addCustomDocDomainRequestSchema,
  path: z.object({
    docId: z.string(),
  }),
});

export const addCustomDocDomainResponse2Schema = addCustomDocDomainResponseSchema;

export const addCustomDocDomainErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const deleteCustomDocDomainDataSchema = z.object({
  path: z.object({
    customDocDomain: z.string(),
    docId: z.string(),
  }),
});

export const deleteCustomDocDomainResponse2Schema = deleteCustomDocDomainResponseSchema;

export const deleteCustomDocDomainErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const updateCustomDocDomainDataSchema = z.object({
  body: updateCustomDocDomainRequestSchema,
  path: z.object({
    customDocDomain: z.string(),
    docId: z.string(),
  }),
});

export const updateCustomDocDomainResponse2Schema = updateCustomDocDomainResponseSchema;

export const updateCustomDocDomainErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getCustomDocDomainProviderDataSchema = z.object({
  path: z.object({
    customDocDomain: z.string(),
  }),
});

export const getCustomDocDomainProviderResponseSchema = customDocDomainProviderResponseSchema;

export const getCustomDocDomainProviderErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const whoamiResponseSchema = userSchema;

export const whoamiErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const resolveBrowserLinkDataSchema = z.object({
  query: z.object({
    degradeGracefully: z.boolean().optional(),
    url: z.string(),
  }),
});

export const apiLinkSchema = z.object({
  type: z.literal('apiLink'),
  href: z.string(),
  browserLink: z.string().optional(),
  resource: apiLinkResolvedResourceSchema,
});

export const resolveBrowserLinkErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getMutationStatusDataSchema = z.object({
  path: z.object({
    requestId: z.string(),
  }),
});

export const getMutationStatusResponseSchema = mutationStatusSchema;

export const getMutationStatusErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const triggerWebhookAutomationDataSchema = z.object({
  body: webhookTriggerPayloadSchema.optional(),
  path: z.object({
    docId: z.string(),
    ruleId: z.string(),
  }),
});

export const triggerWebhookAutomationResponseSchema = webhookTriggerResultSchema;

export const triggerWebhookAutomationErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listDocAnalyticsDataSchema = z.object({
  query: z
    .object({
      direction: sortDirectionSchema.optional(),
      docIds: z.array(z.string()).optional(),
      isPublished: z.boolean().optional(),
      limit: z.number().optional(),
      orderBy: docAnalyticsOrderBySchema.optional(),
      pageToken: z.string().optional(),
      query: z.string().optional(),
      scale: analyticsScaleSchema.optional(),
      sinceDate: z.string().optional(),
      untilDate: z.string().optional(),
      workspaceId: z.string().optional(),
    })
    .optional(),
});

export const listDocAnalyticsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listPageAnalyticsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
      sinceDate: z.string().optional(),
      untilDate: z.string().optional(),
    })
    .optional(),
});

export const listPageAnalyticsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listDocAnalyticsSummaryDataSchema = z.object({
  query: z
    .object({
      isPublished: z.boolean().optional(),
      sinceDate: z.string().optional(),
      untilDate: z.string().optional(),
      workspaceId: z.string().optional(),
    })
    .optional(),
});

export const listDocAnalyticsSummaryResponseSchema = docAnalyticsSummarySchema;

export const listDocAnalyticsSummaryErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listPackAnalyticsDataSchema = z.object({
  query: z
    .object({
      direction: sortDirectionSchema.optional(),
      isPublished: z.boolean().optional(),
      limit: z.number().optional(),
      orderBy: packAnalyticsOrderBySchema.optional(),
      packIds: z.array(z.number()).optional(),
      pageToken: z.string().optional(),
      query: z.string().optional(),
      scale: analyticsScaleSchema.optional(),
      sinceDate: z.string().optional(),
      untilDate: z.string().optional(),
      workspaceId: z.string().optional(),
    })
    .optional(),
});

export const listPackAnalyticsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listPackAnalyticsSummaryDataSchema = z.object({
  query: z
    .object({
      isPublished: z.boolean().optional(),
      packIds: z.array(z.number()).optional(),
      sinceDate: z.string().optional(),
      untilDate: z.string().optional(),
      workspaceId: z.string().optional(),
    })
    .optional(),
});

export const listPackAnalyticsSummaryResponseSchema = packAnalyticsSummarySchema;

export const listPackAnalyticsSummaryErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listPackFormulaAnalyticsDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
  query: z
    .object({
      direction: sortDirectionSchema.optional(),
      limit: z.number().optional(),
      orderBy: packFormulaAnalyticsOrderBySchema.optional(),
      packFormulaNames: z.array(z.string()).optional(),
      packFormulaTypes: z.array(packFormulaTypeSchema).optional(),
      pageToken: z.string().optional(),
      scale: analyticsScaleSchema.optional(),
      sinceDate: z.string().optional(),
      untilDate: z.string().optional(),
    })
    .optional(),
});

export const listPackFormulaAnalyticsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getAnalyticsLastUpdatedResponseSchema = analyticsLastUpdatedResponseSchema;

export const getAnalyticsLastUpdatedErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listWorkspaceMembersDataSchema = z.object({
  path: z.object({
    workspaceId: z.string(),
  }),
  query: z
    .object({
      includedRoles: z.array(workspaceUserRoleSchema).optional(),
      pageToken: z.string().optional(),
    })
    .optional(),
});

export const workspaceMembersListSchema = z.object({
  items: z.array(workspaceUserSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const listWorkspaceMembersErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const changeRoleSchema = z.object({
  email: z.string(),
  newRole: workspaceUserRoleSchema,
});

export const changeUserRoleResponseSchema = changeRoleResultSchema;

export const changeUserRoleErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listWorkspaceRoleActivityDataSchema = z.object({
  path: z.object({
    workspaceId: z.string(),
  }),
});

export const getWorkspaceRoleActivitySchema = z.object({
  items: z.array(workspaceRoleActivitySchema),
});

export const listWorkspaceRoleActivityErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const listPacksDataSchema = z.object({
  query: z
    .object({
      accessType: packAccessTypeSchema.optional(),
      accessTypes: z.array(packAccessTypeSchema).optional(),
      direction: sortDirectionSchema.optional(),
      excludeIndividualAcls: z.boolean().optional(),
      excludePublicPacks: z.boolean().optional(),
      excludeWorkspaceAcls: z.boolean().optional(),
      limit: z.number().optional(),
      onlyWorkspaceId: z.string().optional(),
      pageToken: z.string().optional(),
      parentWorkspaceIds: z.array(z.string()).optional(),
      sortBy: packsSortBySchema.optional(),
    })
    .optional(),
});

export const listPacksResponseSchema = packSummaryListSchema;

export const listPacksErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const createPackDataSchema = z.object({
  body: createPackRequestSchema,
});

export const createPackResponse2Schema = createPackResponseSchema;

export const createPackErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getPackDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
});

export const packSchema = z.object({
  id: z.number(),
  logoUrl: z.string().optional(),
  coverUrl: z.string().optional(),
  exampleImages: z.array(packImageFileSchema).optional(),
  workspaceId: z.string(),
  categories: z.array(publishingCategorySchema),
  certified: z.boolean().optional(),
  sourceCodeVisibility: packSourceCodeVisibilitySchema.optional(),
  name: z.string(),
  description: z.string(),
  shortDescription: z.string(),
  supportEmail: z.string().optional(),
  termsOfServiceUrl: z.string().optional(),
  privacyPolicyUrl: z.string().optional(),
  overallRateLimit: packRateLimitSchema.optional(),
  perConnectionRateLimit: packRateLimitSchema.optional(),
  featuredDocStatus: featuredDocStatusSchema.optional(),
});

export const getPackErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const updatePackDataSchema = z.object({
  body: updatePackRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const updatePackResponseSchema = packSchema;

export const updatePackErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const deletePackDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
});

export const deletePackResponse2Schema = deletePackResponseSchema;

export const deletePackErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const getPackConfigurationSchemaDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
});

export const getPackConfigurationSchemaResponseSchema = getPackConfigurationJsonSchemaResponseSchema;

export const getPackConfigurationSchemaErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listPackVersionsDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
    })
    .optional(),
});

export const listPackVersionsResponseSchema = packVersionListSchema;

export const listPackVersionsErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const getNextPackVersionDataSchema = z.object({
  body: getNextPackVersionRequestSchema.optional(),
  path: z.object({
    packId: z.number(),
  }),
});

export const getNextPackVersionResponseSchema = nextPackVersionInfoSchema;

export const getNextPackVersionErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const getPackVersionDiffsDataSchema = z.object({
  path: z.object({
    basePackVersion: z.string(),
    packId: z.number(),
    targetPackVersion: z.string(),
  }),
});

export const getPackVersionDiffsResponseSchema = packVersionDiffsSchema;

export const getPackVersionDiffsErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const registerPackVersionDataSchema = z.object({
  body: registerPackVersionRequestSchema,
  path: z.object({
    packId: z.number(),
    packVersion: z.string(),
  }),
});

export const registerPackVersionResponseSchema = packVersionUploadInfoSchema;

export const registerPackVersionErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const createPackVersionRequestSchema = z.object({
  notes: z.string().optional(),
  source: packSourceSchema.optional(),
  allowOlderSdkVersion: z.boolean().optional(),
});

export const createPackVersionResponseSchema = z.object({
  deprecationWarnings: z.array(validationErrorSchema).optional(),
});

export const packVersionUploadCompleteErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const createPackReleaseDataSchema = z.object({
  body: createPackReleaseRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const createPackReleaseResponseSchema = packReleaseSchema;

export const createPackReleaseErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listPackReleasesDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
  query: z
    .object({
      limit: z.number().optional(),
      pageToken: z.string().optional(),
    })
    .optional(),
});

export const listPackReleasesResponseSchema = packReleaseListSchema;

export const listPackReleasesErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const updatePackReleaseDataSchema = z.object({
  body: updatePackReleaseRequestSchema,
  path: z.object({
    packId: z.number(),
    packReleaseId: z.number(),
  }),
});

export const updatePackReleaseResponseSchema = packReleaseSchema;

export const updatePackReleaseErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const setPackOauthConfigDataSchema = z.object({
  body: setPackOauthConfigRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const setPackOauthConfigResponseSchema = packOauthConfigMetadataSchema;

export const setPackOauthConfigErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const getPackOauthConfigDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
});

export const getPackOauthConfigResponseSchema = packOauthConfigMetadataSchema;

export const getPackOauthConfigErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const setPackSystemConnectionDataSchema = z.object({
  body: setPackSystemConnectionRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const packSystemConnectionMetadataSchema = z.union([
  packConnectionHeaderMetadataSchema,
  packConnectionMultiHeaderMetadataSchema,
  packConnectionUrlParamMetadataSchema,
  packConnectionHttpBasicMetadataSchema,
  packConnectionCustomMetadataSchema,
  packConnectionOauth2ClientCredentialsMetadataSchema,
  packConnectionGoogleServiceAccountMetadataSchema,
]);

export const setPackSystemConnectionErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const patchPackSystemConnectionDataSchema = z.object({
  body: patchPackSystemConnectionRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const patchPackSystemConnectionResponseSchema = packSystemConnectionMetadataSchema;

export const patchPackSystemConnectionErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const getPackSystemConnectionDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
});

export const getPackSystemConnectionResponseSchema = packSystemConnectionMetadataSchema;

export const getPackSystemConnectionErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const getPackPermissionsDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
});

export const getPackPermissionsErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const addPackPermissionResponse2Schema = addPackPermissionResponseSchema;

export const addPackPermissionErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const deletePackPermissionDataSchema = z.object({
  path: z.object({
    packId: z.number(),
    permissionId: z.string(),
  }),
});

export const deletePackPermissionResponse2Schema = deletePackPermissionResponseSchema;

export const deletePackPermissionErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listPackMakersDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
});

export const listPackMakersResponseSchema = z.object({
  makers: z.array(makerSchema),
});

export const listPackMakersErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const addPackMakerDataSchema = z.object({
  body: addPackMakerRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const addPackMakerResponse2Schema = addPackMakerResponseSchema;

export const addPackMakerErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const deletePackMakerDataSchema = z.object({
  path: z.object({
    loginId: z.string(),
    packId: z.number(),
  }),
});

export const deletePackMakerResponse2Schema = deletePackMakerResponseSchema;

export const deletePackMakerErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listPackCategoriesDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
});

export const listPackCategoriesResponseSchema = z.object({
  categories: z.array(publishingCategorySchema),
});

export const listPackCategoriesErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const addPackCategoryDataSchema = z.object({
  body: addPackCategoryRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const addPackCategoryResponse2Schema = addPackCategoryResponseSchema;

export const addPackCategoryErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const deletePackCategoryDataSchema = z.object({
  path: z.object({
    categoryName: z.string(),
    packId: z.number(),
  }),
});

export const deletePackCategoryResponse2Schema = deletePackCategoryResponseSchema;

export const deletePackCategoryErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const uploadPackAssetDataSchema = z.object({
  body: uploadPackAssetRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const uploadPackAssetResponseSchema = packAssetUploadInfoSchema;

export const uploadPackAssetErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const uploadPackSourceCodeDataSchema = z.object({
  body: uploadPackSourceCodeRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const uploadPackSourceCodeResponseSchema = packSourceCodeUploadInfoSchema;

export const uploadPackSourceCodeErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const packAssetUploadCompleteDataSchema = z.object({
  path: z.object({
    packAssetId: z.string(),
    packAssetType: packAssetTypeSchema,
    packId: z.number(),
  }),
});

export const packAssetUploadCompleteResponse2Schema = packAssetUploadCompleteResponseSchema;

export const packAssetUploadCompleteErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const packSourceCodeUploadCompleteDataSchema = z.object({
  body: packSourceCodeUploadCompleteRequestSchema,
  path: z.object({
    packId: z.number(),
    packVersion: z.string(),
  }),
});

export const packSourceCodeUploadCompleteResponse2Schema = packSourceCodeUploadCompleteResponseSchema;

export const packSourceCodeUploadCompleteErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const getPackSourceCodeDataSchema = z.object({
  path: z.object({
    packId: z.number(),
    packVersion: z.string(),
  }),
});

export const getPackSourceCodeResponseSchema = packSourceCodeInfoSchema;

export const getPackSourceCodeErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listPackListingsDataSchema = z.object({
  query: z
    .object({
      direction: sortDirectionSchema.optional(),
      excludeIndividualAcls: z.boolean().optional(),
      excludePublicPacks: z.boolean().optional(),
      excludeWorkspaceAcls: z.boolean().optional(),
      installContext: packListingInstallContextTypeSchema.optional(),
      limit: z.number().optional(),
      onlyWorkspaceId: z.string().optional(),
      orderBy: packListingsSortBySchema.optional(),
      packAccessTypes: packAccessTypesSchema.optional(),
      packIds: z.array(z.number()).optional(),
      pageToken: z.string().optional(),
      parentWorkspaceIds: z.array(z.string()).optional(),
      sortBy: packListingsSortBySchema.optional(),
    })
    .optional(),
});

export const listPackListingsErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const getPackListingDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
  query: z
    .object({
      docId: z.string().optional(),
      installContext: packListingInstallContextTypeSchema.optional(),
      releaseChannel: ingestionPackReleaseChannelSchema.optional(),
      workspaceId: z.string().optional(),
    })
    .optional(),
});

export const getPackListingErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listPackLogsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    packId: z.number(),
  }),
  query: z
    .object({
      afterTimestamp: z.string().optional(),
      beforeTimestamp: z.string().optional(),
      limit: z.number().optional(),
      logTypes: z.array(packLogTypeSchema).optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
      pageToken: z.string().optional(),
      q: z.string().optional(),
      requestIds: z.array(z.string()).optional(),
    })
    .optional(),
});

export const listPackLogsErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listIngestionLogsDataSchema = z.object({
  path: z.object({
    organizationId: z.string(),
    packId: z.number(),
    rootIngestionId: z.string(),
  }),
  query: z
    .object({
      afterTimestamp: z.string().optional(),
      beforeTimestamp: z.string().optional(),
      ingestionExecutionId: z.string().optional(),
      limit: z.number().optional(),
      logTypes: z.array(packLogTypeSchema).optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
      pageToken: z.string().optional(),
      q: z.string().optional(),
      requestIds: z.array(z.string()).optional(),
    })
    .optional(),
});

export const listIngestionLogsErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listGroupedPackLogsDataSchema = z.object({
  path: z.object({
    docId: z.string(),
    packId: z.number(),
  }),
  query: z
    .object({
      afterTimestamp: z.string().optional(),
      beforeTimestamp: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
      pageToken: z.string().optional(),
      q: z.string().optional(),
    })
    .optional(),
});

export const listGroupedPackLogsErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listGroupedIngestionLogsDataSchema = z.object({
  path: z.object({
    ingestionExecutionId: z.string(),
    organizationId: z.string(),
    packId: z.number(),
    rootIngestionId: z.string(),
  }),
  query: z
    .object({
      afterTimestamp: z.string().optional(),
      beforeTimestamp: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
      pageToken: z.string().optional(),
      q: z.string().optional(),
    })
    .optional(),
});

export const listGroupedIngestionLogsErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listIngestionExecutionsDataSchema = z.object({
  path: z.object({
    organizationId: z.string(),
    packId: z.number(),
    rootIngestionId: z.string(),
  }),
  query: z
    .object({
      afterTimestamp: z.string().optional(),
      beforeTimestamp: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
      pageToken: z.string().optional(),
      q: z.string().optional(),
    })
    .optional(),
});

export const listIngestionExecutionsResponseSchema = ingestionExecutionsListSchema;

export const listIngestionExecutionsErrorSchema = z.union([
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
    codaDetail: z
      .object({
        validationErrors: z.array(validationErrorSchema).optional(),
      })
      .optional(),
  }),
  z.object({
    statusCode: z.number(),
    statusMessage: z.string(),
    message: z.string(),
  }),
]);

export const listPackFeaturedDocsDataSchema = z.object({
  path: z.object({
    packId: z.number(),
  }),
});

export const listPackFeaturedDocsResponseSchema = packFeaturedDocsResponseSchema;

export const listPackFeaturedDocsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const updatePackFeaturedDocsDataSchema = z.object({
  body: updatePackFeaturedDocsRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const updatePackFeaturedDocsResponse2Schema = updatePackFeaturedDocsResponseSchema;

export const updatePackFeaturedDocsErrorSchema = z.object({
  statusCode: z.number(),
  statusMessage: z.string(),
  message: z.string(),
});

export const packPrincipalSchema = z.union([
  packUserPrincipalSchema,
  packWorkspacePrincipalSchema,
  packGlobalPrincipalSchema,
]);

export const bundledPackPlanPricingSchema = z.object({
  type: z.literal('BundledWithTier'),
  minimumFeatureSet: paidFeatureSetSchema,
});

export const cellEditSchema = z.object({
  column: z.string(),
  value: valueSchema,
});

export const richValueSchema = z.union([
  richSingleValueSchema,
  z.array(z.union([richSingleValueSchema, z.array(richSingleValueSchema)])),
]);

export const durationColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    precision: z.number().optional(),
    maxUnit: z.unknown().and(durationUnitSchema).optional(),
  }),
);

export const emailColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    display: emailDisplayTypeSchema.optional(),
    autocomplete: z.boolean().optional(),
  }),
);

export const linkColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    display: linkDisplayTypeSchema.optional(),
    force: z.boolean().optional(),
  }),
);

export const currencyColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    currencyCode: z.string().optional(),
    precision: z.number().optional(),
    format: currencyFormatTypeSchema.optional(),
  }),
);

export const imageReferenceColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    width: z.unknown().and(numberOrNumberFormulaSchema),
    height: z.unknown().and(numberOrNumberFormulaSchema),
    style: imageShapeStyleSchema,
  }),
);

export const referenceColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    table: z.unknown().and(tableReferenceSchema),
  }),
);

export const sliderColumnFormatSchema = simpleColumnFormatSchema.and(
  z.object({
    minimum: z.unknown().and(numberOrNumberFormulaSchema).optional(),
    maximum: z.unknown().and(numberOrNumberFormulaSchema).optional(),
    step: z.unknown().and(numberOrNumberFormulaSchema).optional(),
    displayType: sliderDisplayTypeSchema.optional(),
    showValue: z.boolean().optional(),
  }),
);

export const docAnalyticsItemSchema = z.object({
  doc: docAnalyticsDetailsSchema,
  metrics: z.array(docAnalyticsMetricsSchema),
});

export const docListSchema = z.object({
  items: z.array(docSchema),
  href: z.string().optional(),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const packAnalyticsItemSchema = z.object({
  pack: packAnalyticsDetailsSchema,
  metrics: z.array(packAnalyticsMetricsSchema),
});

export const packLogContextSchema = z.object({
  docId: z.string(),
  packId: z.string(),
  packVersion: z.string(),
  formulaName: z.string(),
  userId: z.string(),
  connectionId: z.string(),
  requestId: z.string(),
  requestType: packLogRequestTypeSchema,
  createdAt: z.string(),
  logId: z.string(),
  docObjectId: z.string().optional(),
  docRowId: z.string().optional(),
  docColumnId: z.string().optional(),
  isSyncTable: z.boolean().optional(),
  isContinuedSyncTable: z.boolean().optional(),
  autocompleteParameterName: z.string().optional(),
  invocationSource: z.string().optional(),
  detailsKey: z.string(),
  ingestionId: z.string().optional(),
  rootIngestionId: z.string().optional(),
  ingestionExecutionId: z.string().optional(),
});

export const packCustomLogSchema = z.object({
  type: z.literal('custom'),
  context: packLogContextSchema,
  message: z.string(),
  level: logLevelSchema,
});

export const packFetcherLogSchema = z.object({
  type: z.literal('invocation'),
  context: packLogContextSchema,
  requestSizeBytes: z.number().optional(),
  responseCode: z.number().optional(),
  responseSizeBytes: z.number().optional(),
  method: z
    .union([
      z.literal('GET'),
      z.literal('POST'),
      z.literal('PUT'),
      z.literal('DELETE'),
      z.literal('PATCH'),
      z.literal('HEAD'),
    ])
    .optional(),
  baseUrl: z.string().optional(),
  cacheHit: z.boolean().optional(),
  duration: z.number().optional(),
});

export const packFormulaIdentifierSchema = z.object({
  name: z.string(),
  type: packFormulaTypeSchema,
});

export const packIngestionDebugLogSchema = z.object({
  type: z.literal('ingestionDebug'),
  context: packLogContextSchema,
  message: z.string(),
  level: logLevelSchema,
});

export const packIngestionLifecycleLogSchema = z.object({
  type: z.literal('ingestionLifecycle'),
  context: packLogContextSchema,
  message: z.string(),
  level: logLevelSchema,
});

export const packInternalLogSchema = z.object({
  type: z.literal('internal'),
  context: packLogContextSchema,
  message: z.string(),
  level: logLevelSchema,
});

export const packInvocationLogSchema = z.object({
  type: z.literal('fetcher'),
  context: packLogContextSchema,
  cacheHit: z.boolean().optional(),
  duration: z.number().optional(),
  error: z
    .object({
      message: z.string(),
      stack: z.string().optional(),
    })
    .optional(),
});

export const standardPackPlanSchema = z.object({
  packPlanId: z.string(),
  packId: z.number(),
  pricing: z.union([freePackPlanPricingSchema, monthlyDocMakerPackPlanPricingSchema]),
  createdAt: z.string(),
});

export const bundledPackPlanSchema = z.object({
  packPlanId: z.string(),
  packId: z.number(),
  pricing: bundledPackPlanPricingSchema,
  createdAt: z.string(),
});

export const packListingSchema = z.object({
  packId: z.number(),
  packVersion: z.string(),
  releaseId: z.number().optional(),
  lastReleasedAt: z.string().optional(),
  logoUrl: z.string(),
  coverUrl: z.string().optional(),
  exampleImages: z.array(packImageFileSchema).optional(),
  name: z.string(),
  description: z.string(),
  shortDescription: z.string(),
  supportEmail: z.string().optional(),
  termsOfServiceUrl: z.string().optional(),
  privacyPolicyUrl: z.string().optional(),
  categories: z.array(publishingCategorySchema),
  makers: z.array(makerSummarySchema),
  certified: z.boolean().optional(),
  minimumFeatureSet: featureSetSchema.optional(),
  unrestrictedFeatureSet: featureSetSchema.optional(),
  externalMetadataUrl: z.string(),
  standardPackPlan: standardPackPlanSchema.optional(),
  bundledPackPlan: bundledPackPlanSchema.optional(),
  sourceCodeVisibility: packSourceCodeVisibilitySchema.optional(),
  sdkVersion: z.string(),
});

export const packAuthLogSchema = z.object({
  type: z.literal('auth'),
  context: packLogContextSchema,
  path: z.string(),
  errorMessage: z.string().optional(),
  errorStack: z.string().optional(),
});

export const packLogSchema = z.union([
  packCustomLogSchema,
  packInvocationLogSchema,
  packFetcherLogSchema,
  packInternalLogSchema,
  packAuthLogSchema,
  packIngestionLifecycleLogSchema,
  packIngestionDebugLogSchema,
]);

export const packPermissionSchema = z.object({
  id: z.string(),
  principal: packPrincipalSchema,
  access: packAccessTypeSchema,
});

export const packPermissionListSchema = z.object({
  items: z.array(packPermissionSchema),
  permissionUsers: z.array(userSummarySchema),
});

export const pageAnalyticsItemSchema = z.object({
  page: pageAnalyticsDetailsSchema,
  metrics: z.array(pageAnalyticsMetricsSchema),
});

export const pageCreateContentSchema = z.union([
  z.object({
    type: z.literal('canvas'),
    canvasContent: pageContentSchema,
  }),
  z.object({
    type: z.literal('embed'),
    url: z.string(),
    renderMethod: pageEmbedRenderMethodSchema.optional(),
  }),
  z.object({
    type: z.literal('syncPage'),
    mode: z.literal('page'),
    includeSubpages: z.boolean(),
    sourcePageId: z.string(),
    sourceDocId: z.string(),
  }),
  z.object({
    type: z.literal('syncPage'),
    mode: z.literal('document'),
    sourceDocId: z.string(),
  }),
]);

export const pageListSchema = z.object({
  items: z.array(pageSchema),
  href: z.string().optional(),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const parameterdirectionSchema = sortDirectionSchema;

export const parametersortBySchema = sortBySchema;

export const parametertableTypesSchema = z.array(tableTypeSchema);

export const principalSchema = z.union([
  emailPrincipalSchema,
  groupPrincipalSchema,
  domainPrincipalSchema,
  workspacePrincipalSchema,
  anyonePrincipalSchema,
]);

export const rowEditSchema = z.object({
  cells: z.array(cellEditSchema),
});

export const rowsUpsertSchema = z.object({
  rows: z.array(rowEditSchema),
  keyColumns: z.array(z.string()).optional(),
});

export const rowUpdateSchema = z.object({
  row: rowEditSchema,
});

export const listDocsResponseSchema = docListSchema;

export const getDocResponseSchema = docSchema;

export const addPermissionDataSchema = z.object({
  body: addPermissionRequestSchema,
  path: z.object({
    docId: z.string(),
  }),
});

export const publishDocDataSchema = z.object({
  body: docPublishSchema,
  path: z.object({
    docId: z.string(),
  }),
});

export const listPagesResponseSchema = pageListSchema;

export const pageCreateSchema = z.object({
  name: z.string().optional(),
  subtitle: z.string().optional(),
  iconName: z.string().optional(),
  imageUrl: z.string().optional(),
  parentPageId: z.string().optional(),
  pageContent: pageCreateContentSchema.optional(),
});

export const getPageResponseSchema = pageSchema;

export const updatePageDataSchema = z.object({
  body: pageUpdateSchema,
  path: z.object({
    docId: z.string(),
    pageIdOrName: z.string(),
  }),
});

export const beginPageContentExportDataSchema = z.object({
  body: beginPageContentExportRequestSchema,
  path: z.object({
    docId: z.string(),
    pageIdOrName: z.string(),
  }),
});

export const upsertRowsDataSchema = z.object({
  body: rowsUpsertSchema,
  path: z.object({
    docId: z.string(),
    tableIdOrName: z.string(),
  }),
  query: z
    .object({
      disableParsing: z.boolean().optional(),
    })
    .optional(),
});

export const updateRowDataSchema = z.object({
  body: rowUpdateSchema,
  path: z.object({
    docId: z.string(),
    rowIdOrName: z.string(),
    tableIdOrName: z.string(),
  }),
  query: z
    .object({
      disableParsing: z.boolean().optional(),
    })
    .optional(),
});

export const listFormulasResponseSchema = formulaListSchema;

export const getFormulaResponseSchema = formulaSchema;

export const listControlsResponseSchema = controlListSchema;

export const getControlResponseSchema = controlSchema;

export const listCustomDocDomainsResponseSchema = customDocDomainListSchema;

export const resolveBrowserLinkResponseSchema = apiLinkSchema;

export const docAnalyticsCollectionSchema = z.object({
  items: z.array(docAnalyticsItemSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const pageAnalyticsCollectionSchema = z.object({
  items: z.array(pageAnalyticsItemSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const packAnalyticsCollectionSchema = z.object({
  items: z.array(packAnalyticsItemSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const listWorkspaceMembersResponseSchema = workspaceMembersListSchema;

export const changeUserRoleDataSchema = z.object({
  body: changeRoleSchema,
  path: z.object({
    workspaceId: z.string(),
  }),
});

export const listWorkspaceRoleActivityResponseSchema = getWorkspaceRoleActivitySchema;

export const getPackResponseSchema = packSchema;

export const packVersionUploadCompleteDataSchema = z.object({
  body: createPackVersionRequestSchema,
  path: z.object({
    packId: z.number(),
    packVersion: z.string(),
  }),
});

export const packVersionUploadCompleteResponseSchema = createPackVersionResponseSchema;

export const setPackSystemConnectionResponseSchema = packSystemConnectionMetadataSchema;

export const getPackPermissionsResponseSchema = packPermissionListSchema;

export const addPackPermissionRequestSchema = z.object({
  principal: packPrincipalSchema,
  access: packAccessTypeSchema,
});

export const listPackMakersResponse2Schema = listPackMakersResponseSchema;

export const listPackCategoriesResponse2Schema = listPackCategoriesResponseSchema;

export const packListingListSchema = z.object({
  items: z.array(packListingSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const packLogsListSchema = z.object({
  items: z.array(packLogSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const listIngestionLogsResponseSchema = packLogsListSchema;

export const permissionSchema = z.object({
  principal: principalSchema,
  id: z.string(),
  access: accessTypeSchema,
});

export const cellValueSchema = z.union([valueSchema, richValueSchema]);

export const columnFormatSchema = z.union([
  buttonColumnFormatSchema,
  checkboxColumnFormatSchema,
  dateColumnFormatSchema,
  dateTimeColumnFormatSchema,
  durationColumnFormatSchema,
  emailColumnFormatSchema,
  linkColumnFormatSchema,
  currencyColumnFormatSchema,
  imageReferenceColumnFormatSchema,
  numericColumnFormatSchema,
  referenceColumnFormatSchema,
  selectColumnFormatSchema,
  simpleColumnFormatSchema,
  scaleColumnFormatSchema,
  sliderColumnFormatSchema,
  timeColumnFormatSchema,
]);

export const columnDetailSchema = z.object({
  id: z.string(),
  type: z.literal('column'),
  href: z.string(),
  name: z.string(),
  display: z.boolean().optional(),
  calculated: z.boolean().optional(),
  formula: z.string().optional(),
  defaultValue: z.string().optional(),
  format: columnFormatSchema,
  parent: tableReferenceSchema,
});

export const columnSchema = z.object({
  id: z.string(),
  type: z.literal('column'),
  href: z.string(),
  name: z.string(),
  display: z.boolean().optional(),
  calculated: z.boolean().optional(),
  formula: z.string().optional(),
  defaultValue: z.string().optional(),
  format: columnFormatSchema,
});

export const docCreateSchema = z.object({
  title: z.string().optional(),
  sourceDoc: z.string().optional(),
  timezone: z.string().optional(),
  folderId: z.string().optional(),
  initialPage: z.record(z.unknown()).and(pageCreateSchema).optional(),
});

export const groupedPackAuthLogSchema = z.object({
  type: z.literal('auth'),
  authLog: packAuthLogSchema,
  relatedLogs: z.array(packLogSchema),
});

export const groupedPackInvocationLogSchema = z.object({
  type: z.literal('invocation'),
  invocationLog: packInvocationLogSchema,
  relatedLogs: z.array(packLogSchema),
});

export const groupedPackLogSchema = z.union([groupedPackInvocationLogSchema, groupedPackAuthLogSchema]);

export const groupedPackLogsListSchema = z.object({
  items: z.array(groupedPackLogSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
  incompleteRelatedLogs: z.boolean(),
});

export const packFormulaAnalyticsItemSchema = z.object({
  formula: packFormulaIdentifierSchema,
  metrics: z.array(packFormulaAnalyticsMetricsSchema),
});

export const packOrganizationAccessForDocsSchema = z.object({
  canRequestAccess: z.boolean(),
  hasRequestedAccess: z.boolean(),
  requiresConfiguration: z.boolean(),
  allowedConfigurations: z.array(packConfigurationEntrySchema).optional(),
  incompatibleDocPermissions: z.array(permissionSchema).optional(),
  incompatibleDocOwner: userSummarySchema.optional(),
  incompatibleDocFolder: folderReferenceSchema.optional(),
});

export const packUserAccessSchema = z.object({
  canEdit: z.boolean(),
  canTest: z.boolean(),
  canView: z.boolean(),
  canInstall: z.boolean(),
  canPurchase: z.boolean(),
  requiresTrial: z.boolean(),
  canConnectAccount: z.boolean(),
  organization: z.union([packOrganizationAccessForDocsSchema, packOrganizationAccessForCodaBrainSchema]).optional(),
});

export const rowSchema = z.object({
  id: z.string(),
  type: z.literal('row'),
  href: z.string(),
  name: z.string(),
  index: z.number(),
  browserLink: z.string(),
  createdAt: z.string(),
  updatedAt: z.string(),
  values: z.record(cellValueSchema),
});

export const rowDetailSchema = z.object({
  id: z.string(),
  type: z.literal('row'),
  href: z.string(),
  name: z.string(),
  index: z.number(),
  browserLink: z.string(),
  createdAt: z.string(),
  updatedAt: z.string(),
  values: z.record(cellValueSchema),
  parent: tableReferenceSchema,
});

export const rowListSchema = z.object({
  items: z.array(rowSchema),
  href: z.string().optional(),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
  nextSyncToken: nextSyncTokenSchema.optional(),
});

export const createDocDataSchema = z.object({
  body: docCreateSchema,
});

export const aclSchema = z.object({
  items: z.array(permissionSchema),
  href: z.string(),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const createPageDataSchema = z.object({
  body: pageCreateSchema,
  path: z.object({
    docId: z.string(),
  }),
});

export const columnListSchema = z.object({
  items: z.array(columnSchema),
  href: z.string().optional(),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const listRowsResponseSchema = rowListSchema;

export const getRowResponseSchema = rowDetailSchema;

export const getColumnResponseSchema = columnDetailSchema;

export const listDocAnalyticsResponseSchema = docAnalyticsCollectionSchema;

export const listPageAnalyticsResponseSchema = pageAnalyticsCollectionSchema;

export const listPackAnalyticsResponseSchema = packAnalyticsCollectionSchema;

export const packFormulaAnalyticsCollectionSchema = z.object({
  items: z.array(packFormulaAnalyticsItemSchema),
  nextPageToken: nextPageTokenSchema.optional(),
  nextPageLink: nextPageLinkSchema.and(z.string()).optional(),
});

export const addPackPermissionDataSchema = z.object({
  body: addPackPermissionRequestSchema,
  path: z.object({
    packId: z.number(),
  }),
});

export const listPackListingsResponseSchema = packListingListSchema;

export const packListingDetailSchema = z.object({
  packId: z.number(),
  packVersion: z.string(),
  releaseId: z.number().optional(),
  lastReleasedAt: z.string().optional(),
  logoUrl: z.string(),
  coverUrl: z.string().optional(),
  exampleImages: z.array(packImageFileSchema).optional(),
  name: z.string(),
  description: z.string(),
  shortDescription: z.string(),
  supportEmail: z.string().optional(),
  termsOfServiceUrl: z.string().optional(),
  privacyPolicyUrl: z.string().optional(),
  categories: z.array(publishingCategorySchema),
  makers: z.array(makerSummarySchema),
  certified: z.boolean().optional(),
  minimumFeatureSet: featureSetSchema.optional(),
  unrestrictedFeatureSet: featureSetSchema.optional(),
  externalMetadataUrl: z.string(),
  standardPackPlan: standardPackPlanSchema.optional(),
  bundledPackPlan: bundledPackPlanSchema.optional(),
  sourceCodeVisibility: packSourceCodeVisibilitySchema.optional(),
  sdkVersion: z.string(),
  discoverability: packDiscoverabilitySchema,
  userAccess: packUserAccessSchema,
  codaHelpCenterUrl: z.string().optional(),
  configuration: packConfigurationEntrySchema.optional(),
});

export const listPackLogsResponseSchema = packLogsListSchema;

export const listGroupedPackLogsResponseSchema = groupedPackLogsListSchema;

export const listGroupedIngestionLogsResponseSchema = groupedPackLogsListSchema;

export const getPermissionsResponseSchema = aclSchema;

export const listColumnsResponseSchema = columnListSchema;

export const listPackFormulaAnalyticsResponseSchema = packFormulaAnalyticsCollectionSchema;

export const getPackListingResponseSchema = packListingDetailSchema;
