// This file is auto-generated by @hey-api/openapi-ts

/**
 * Type of access.
 */
export type AccessType = 'readonly' | 'write' | 'comment' | 'none';

/**
 * Type of access (excluding none).
 */
export type AccessTypeNotNone = 'readonly' | 'write' | 'comment';

/**
 * List of Permissions.
 */
export type Acl = {
  items: Array<Permission>;
  /**
   * API link to these results
   */
  href: string;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Doc level metadata associated with ACL.
 */
export type AclMetadata = {
  /**
   * When true, the user of the api can share
   */
  canShare: boolean;
  /**
   * When true, the user of the api can share with the workspace
   */
  canShareWithWorkspace: boolean;
  /**
   * When true, the user of the api can share with the org
   */
  canShareWithOrg: boolean;
  /**
   * When true, the user of the api can copy the doc
   */
  canCopy: boolean;
};

/**
 * Sharing settings for the doc.
 */
export type AclSettings = {
  /**
   * When true, allows editors to change doc permissions. When false, only doc owner can change doc permissions.
   *
   */
  allowEditorsToChangePermissions: boolean;
  /**
   * When true, allows doc viewers to copy the doc.
   */
  allowCopying: boolean;
  /**
   * When true, allows doc viewers to request editing permissions.
   */
  allowViewersToRequestEditing: boolean;
};

/**
 * Payload for adding a custom published doc domain.
 */
export type AddCustomDocDomainRequest = {
  /**
   * The custom domain.
   */
  customDocDomain: string;
};

/**
 * The result of adding a custom domain to a published doc.
 */
export type AddCustomDocDomainResponse = {
  [key: string]: unknown;
};

export type AddedAnyonePrincipal = {
  /**
   * The type of this principal.
   */
  type: 'anyone';
};

export type AddedDomainPrincipal = {
  /**
   * The type of this principal.
   */
  type: 'domain';
  /**
   * Domain for the principal.
   */
  domain: string;
};

export type AddedEmailPrincipal = {
  /**
   * The type of this principal.
   */
  type: 'email';
  /**
   * Email for the principal.
   */
  email: string;
};

export type AddedGroupPrincipal = {
  /**
   * The type of this principal.
   */
  type: 'group';
  /**
   * Group ID for the principal.
   */
  groupId: string;
};

/**
 * Metadata about a principal to add to a doc.
 */
export type AddedPrincipal =
  | AddedEmailPrincipal
  | AddedGroupPrincipal
  | AddedDomainPrincipal
  | AddedWorkspacePrincipal
  | AddedAnyonePrincipal;

export type AddedWorkspacePrincipal = {
  /**
   * The type of this principal.
   */
  type: 'workspace';
  /**
   * WorkspaceId for the principal.
   */
  workspaceId: string;
};

/**
 * Payload for adding a Pack Category.
 */
export type AddPackCategoryRequest = {
  /**
   * Name of the publishing category.
   */
  categoryName: string;
};

/**
 * Confirmation of successfully adding a Pack category.
 */
export type AddPackCategoryResponse = {
  [key: string]: unknown;
};

/**
 * Payload for adding a Pack maker.
 */
export type AddPackMakerRequest = {
  /**
   * The email of the Pack maker.
   */
  loginId: string;
};

/**
 * Confirmation of successfully adding a Pack maker.
 */
export type AddPackMakerResponse = {
  [key: string]: unknown;
};

/**
 * Payload for upserting a Pack permission.
 */
export type AddPackPermissionRequest = {
  principal: PackPrincipal;
  access: PackAccessType;
};

/**
 * Confirmation of successfully upserting a Pack permission.
 */
export type AddPackPermissionResponse = {
  /**
   * The ID of the permission created or updated.
   */
  permissionId: string;
};

/**
 * Payload for granting a new permission.
 */
export type AddPermissionRequest = {
  access: AccessTypeNotNone;
  principal: AddedPrincipal;
  /**
   * When true suppresses email notification
   */
  suppressEmail?: boolean;
};

/**
 * The result of sharing a doc.
 */
export type AddPermissionResult = {
  [key: string]: unknown;
};

/**
 * Response representing the last day analytics were updated.
 */
export type AnalyticsLastUpdatedResponse = {
  /**
   * Date that doc analytics were last updated.
   */
  docAnalyticsLastUpdated: string;
  /**
   * Date that Pack analytics were last updated.
   */
  packAnalyticsLastUpdated: string;
  /**
   * Date that Pack formula analytics were last updated.
   */
  packFormulaAnalyticsLastUpdated: string;
};

/**
 * Quantization period over which to view analytics.
 */
export type AnalyticsScale = 'daily' | 'cumulative';

export type AnyonePrincipal = {
  /**
   * The type of this principal.
   */
  type: 'anyone';
};

/**
 * Info about a resolved link to an API resource.
 */
export type ApiLink = {
  /**
   * The type of this resource.
   */
  type: 'apiLink';
  /**
   * Self link to this query.
   */
  href: string;
  /**
   * Canonical browser-friendly link to the resolved resource.
   */
  browserLink?: string;
  resource: ApiLinkResolvedResource;
};

/**
 * The type of this resource.
 */
export type type = 'apiLink';

/**
 * Reference to the resolved resource.
 */
export type ApiLinkResolvedResource = {
  type: Type;
  /**
   * ID of the resolved resource.
   */
  id: string;
  /**
   * Name of the resource.
   */
  name?: string;
  /**
   * API link to the resolved resource that can be queried to get further information.
   */
  href: string;
};

/**
 * Request for beginning an export of page content.
 */
export type BeginPageContentExportRequest = {
  outputFormat: PageContentOutputFormat;
};

/**
 * Response when beginning an export of page content.
 */
export type BeginPageContentExportResponse = {
  /**
   * The identifier of this export request.
   */
  id: string;
  /**
   * The status of this export.
   */
  status: string;
  /**
   * The URL that reports the status of this export. Poll this URL to get the content URL when the export has completed.
   */
  href: string;
};

/**
 * The Pack plan to show the Pack can be accessed if the workspace is at least the given tier.
 */
export type BundledPackPlan = {
  packPlanId: string;
  packId: number;
  pricing: BundledPackPlanPricing;
  /**
   * Timestamp for when the Pack plan was created.
   */
  createdAt: string;
};

/**
 * Pricing used when workspaces have access to the Pack for free if their workspace is at least the given tier.
 */
export type BundledPackPlanPricing = {
  type: 'BundledWithTier';
  minimumFeatureSet: PaidFeatureSet;
};

export type type2 = 'BundledWithTier';

/**
 * Format of a button column.
 */
export type ButtonColumnFormat = SimpleColumnFormat & {
  /**
   * Label formula for the button.
   */
  label?: string;
  /**
   * DisableIf formula for the button.
   */
  disableIf?: string;
  /**
   * Action formula for the button.
   */
  action?: string;
};

/**
 * An edit made to a particular cell in a row.
 */
export type CellEdit = {
  /**
   * Column ID, URL, or name (fragile and discouraged) associated with this edit.
   */
  column: string;
  value: Value;
};

/**
 * All values that a row cell can contain.
 */
export type CellValue = Value | RichValue;

/**
 * Parameters for changing a workspace user role.
 */
export type ChangeRole = {
  /**
   * Email of the user.
   */
  email: string;
  newRole: WorkspaceUserRole;
};

/**
 * The result of changing a user's workspace user role.
 */
export type ChangeRoleResult = {
  /**
   * Timestamp for when the user's role last changed in this workspace.
   */
  roleChangedAt: string;
};

/**
 * Format of a checkbox column.
 */
export type CheckboxColumnFormat = SimpleColumnFormat & {
  displayType: CheckboxDisplayType;
};

/**
 * How a checkbox should be displayed.
 */
export type CheckboxDisplayType = 'toggle' | 'check';

/**
 * Info about a column.
 */
export type Column = {
  /**
   * ID of the column.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'column';
  /**
   * API link to the column.
   */
  href: string;
  /**
   * Name of the column.
   */
  name: string;
  /**
   * Whether the column is the display column.
   */
  display?: boolean;
  /**
   * Whether the column has a formula set on it.
   */
  calculated?: boolean;
  /**
   * Formula on the column.
   */
  formula?: string;
  /**
   * Default value formula for the column.
   */
  defaultValue?: string;
  format: ColumnFormat;
};

/**
 * The type of this resource.
 */
export type type3 = 'column';

/**
 * Info about a column.
 */
export type ColumnDetail = {
  /**
   * ID of the column.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'column';
  /**
   * API link to the column.
   */
  href: string;
  /**
   * Name of the column.
   */
  name: string;
  /**
   * Whether the column is the display column.
   */
  display?: boolean;
  /**
   * Whether the column has a formula set on it.
   */
  calculated?: boolean;
  /**
   * Formula on the column.
   */
  formula?: string;
  /**
   * Default value formula for the column.
   */
  defaultValue?: string;
  format: ColumnFormat;
  parent: TableReference;
};

/**
 * Format of a column.
 */
export type ColumnFormat =
  | ButtonColumnFormat
  | CheckboxColumnFormat
  | DateColumnFormat
  | DateTimeColumnFormat
  | DurationColumnFormat
  | EmailColumnFormat
  | LinkColumnFormat
  | CurrencyColumnFormat
  | ImageReferenceColumnFormat
  | NumericColumnFormat
  | ReferenceColumnFormat
  | SelectColumnFormat
  | SimpleColumnFormat
  | ScaleColumnFormat
  | SliderColumnFormat
  | TimeColumnFormat;

/**
 * Format type of the column
 */
export type ColumnFormatType =
  | 'text'
  | 'person'
  | 'lookup'
  | 'number'
  | 'percent'
  | 'currency'
  | 'date'
  | 'dateTime'
  | 'time'
  | 'duration'
  | 'email'
  | 'link'
  | 'slider'
  | 'scale'
  | 'image'
  | 'imageReference'
  | 'attachments'
  | 'button'
  | 'checkbox'
  | 'select'
  | 'packObject'
  | 'reaction'
  | 'canvas'
  | 'other';

/**
 * List of columns.
 */
export type ColumnList = {
  items: Array<Column>;
  /**
   * API link to these results
   */
  href?: string;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Reference to a column.
 */
export type ColumnReference = {
  /**
   * ID of the column.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'column';
  /**
   * API link to the column.
   */
  href: string;
};

/**
 * Details about a control.
 */
export type Control = {
  /**
   * ID of the control.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'control';
  /**
   * API link to the control.
   */
  href: string;
  /**
   * Name of the control.
   */
  name: string;
  parent?: PageReference;
  controlType: ControlType;
  value: Value;
};

/**
 * The type of this resource.
 */
export type type4 = 'control';

/**
 * List of controls.
 */
export type ControlList = {
  items: Array<ControlReference>;
  /**
   * API link to these results
   */
  href?: string;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Reference to a control.
 */
export type ControlReference = {
  /**
   * ID of the control.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'control';
  /**
   * API link to the control.
   */
  href: string;
  /**
   * Name of the control.
   */
  name: string;
  parent?: PageReference;
};

/**
 * Type of the control.
 */
export type ControlType =
  | 'button'
  | 'checkbox'
  | 'datePicker'
  | 'dateRangePicker'
  | 'dateTimePicker'
  | 'lookup'
  | 'multiselect'
  | 'select'
  | 'scale'
  | 'slider'
  | 'reaction'
  | 'textbox'
  | 'timePicker';

/**
 * Payload for creating a new Pack release.
 */
export type CreatePackReleaseRequest = {
  /**
   * Which semantic pack version that the release will be created on.
   */
  packVersion: string;
  /**
   * Developers notes.
   */
  releaseNotes?: string;
};

/**
 * Payload for creating a Pack.
 */
export type CreatePackRequest = {
  /**
   * The parent workspace for the Pack. If unspecified, the user's default workspace will be used.
   */
  workspaceId?: string;
  /**
   * The name for the Pack.
   */
  name?: string;
  /**
   * A brief description of the Pack.
   */
  description?: string;
  /**
   * The ID of the new Pack's source, if this new Pack was forked.
   */
  sourcePackId?: number | null;
};

/**
 * Info about a Pack that was just created.
 */
export type CreatePackResponse = {
  /**
   * The ID assigned to the newly-created Pack.
   */
  packId: number;
};

/**
 * Payload for Pack version upload complete.
 */
export type CreatePackVersionRequest = {
  /**
   * Developer notes of the new Pack version.
   */
  notes?: string;
  source?: PackSource;
  /**
   * Bypass Coda's protection against SDK version regression when multiple makers build versions.
   */
  allowOlderSdkVersion?: boolean;
};

/**
 * Confirmation of successful Pack version creation.
 */
export type CreatePackVersionResponse = {
  deprecationWarnings?: Array<ValidationError>;
};

/**
 * A numeric monetary amount as a string or number.
 */
export type CurrencyAmount = string | number;

/**
 * Format of a currency column.
 */
export type CurrencyColumnFormat = SimpleColumnFormat & {
  /**
   * The currency symbol
   */
  currencyCode?: string;
  /**
   * The decimal precision.
   */
  precision?: number;
  format?: CurrencyFormatType;
};

/**
 * How the numeric value should be formatted (with or without symbol, negative numbers in parens).
 */
export type CurrencyFormatType = 'currency' | 'accounting' | 'financial';

/**
 * A monetary value with its associated currency code.
 */
export type CurrencyValue = LinkedDataObject & {
  /**
   * The 3-letter currency code.
   */
  currency: string;
  amount: CurrencyAmount;
};

/**
 * The custom domain added to a published doc.
 */
export type CustomDocDomain = {
  /**
   * The custom domain.
   */
  customDocDomain: string;
  /**
   * Whether the domain has a certificate
   */
  hasCertificate: boolean;
  /**
   * Whether the domain DNS points back to this doc.
   */
  hasDnsDocId: boolean;
  setupStatus: CustomDocDomainSetupStatus;
  domainStatus: CustomDomainConnectedStatus;
  /**
   * When the domain DNS settings were last checked.
   */
  lastVerifiedTimestamp?: string;
};

/**
 * List of all custom domains added to a published doc.
 */
export type CustomDocDomainList = {
  /**
   * Custom domains for the published doc.
   */
  customDocDomains: Array<CustomDocDomain>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

export type CustomDocDomainProvider =
  | 'GoDaddy'
  | 'Namecheap'
  | 'Hover (Tucows)'
  | 'Network Solutions'
  | 'Google Domains'
  | 'Other';

/**
 * The result of determining the domain provider for a custom doc domain.
 */
export type CustomDocDomainProviderResponse = {
  provider: CustomDocDomainProvider;
};

export type CustomDocDomainSetupStatus = 'pending' | 'succeeded' | 'failed';

export type CustomDomainConnectedStatus = 'connected' | 'notConnected';

/**
 * Format of a date column.
 */
export type DateColumnFormat = SimpleColumnFormat & {
  /**
   * A format string using Moment syntax: https://momentjs.com/docs/#/displaying/
   */
  format?: string;
};

/**
 * Format of a date column.
 */
export type DateTimeColumnFormat = SimpleColumnFormat & {
  /**
   * A format string using Moment syntax: https://momentjs.com/docs/#/displaying/
   */
  dateFormat?: string;
  /**
   * A format string using Moment syntax: https://momentjs.com/docs/#/displaying/
   */
  timeFormat?: string;
};

/**
 * The result of deleting a custom domain from a published doc.
 */
export type DeleteCustomDocDomainResponse = {
  [key: string]: unknown;
};

/**
 * Confirmation of successfully deleting a Pack category.
 */
export type DeletePackCategoryResponse = {
  [key: string]: unknown;
};

/**
 * Confirmation of successfully deleting a Pack maker.
 */
export type DeletePackMakerResponse = {
  [key: string]: unknown;
};

/**
 * Confirmation of successfully deleting a Pack permission.
 */
export type DeletePackPermissionResponse = {
  [key: string]: unknown;
};

/**
 * Confirmation of successful Pack deletion.
 */
export type DeletePackResponse = {
  [key: string]: unknown;
};

/**
 * The result of deleting a permission.
 */
export type DeletePermissionResult = {
  [key: string]: unknown;
};

/**
 * Metadata about a Coda doc.
 */
export type Doc = {
  /**
   * ID of the Coda doc.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'doc';
  /**
   * API link to the Coda doc.
   */
  href: string;
  /**
   * Browser-friendly link to the Coda doc.
   */
  browserLink: string;
  icon?: Icon;
  /**
   * Name of the doc.
   */
  name: string;
  /**
   * Email address of the doc owner.
   */
  owner: string;
  /**
   * Name of the doc owner.
   */
  ownerName: string;
  docSize?: DocSize;
  sourceDoc?: {
    [key: string]: unknown;
  } & DocReference;
  /**
   * Timestamp for when the doc was created.
   */
  createdAt: string;
  /**
   * Timestamp for when the doc was last modified.
   */
  updatedAt: string;
  published?: DocPublished;
  folder: FolderReference;
  workspace: WorkspaceReference;
  /**
   * ID of the Coda workspace containing this doc.
   * @deprecated
   */
  workspaceId: string;
  /**
   * ID of the Coda folder containing this doc.
   * @deprecated
   */
  folderId: string;
};

/**
 * The type of this resource.
 */
export type type5 = 'doc';

/**
 * List of analytics for Coda docs over a date range.
 */
export type DocAnalyticsCollection = {
  items: Array<DocAnalyticsItem>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

export type DocAnalyticsDetails = DocReference & {
  /**
   * The name of the doc.
   */
  title: string;
  icon?: Icon;
  /**
   * Creation time of the doc.
   */
  createdAt: string;
  /**
   * Published time of the doc.
   */
  publishedAt?: string;
};

/**
 * Analytics data for a Coda doc.
 */
export type DocAnalyticsItem = {
  doc: DocAnalyticsDetails;
  metrics: Array<DocAnalyticsMetrics>;
};

/**
 * Analytics metrics for a Coda Doc.
 */
export type DocAnalyticsMetrics = {
  /**
   * Date of the analytics data.
   */
  date: string;
  /**
   * Number of times the doc was viewed.
   */
  views: number;
  /**
   * Number of times the doc was copied.
   */
  copies: number;
  /**
   * Number of times the doc was liked.
   */
  likes: number;
  /**
   * Number of unique visitors to this doc from a mobile device.
   */
  sessionsMobile: number;
  /**
   * Number of unique visitors to this doc from a desktop device.
   */
  sessionsDesktop: number;
  /**
   * Number of unique visitors to this doc from an unknown device type.
   */
  sessionsOther: number;
  /**
   * Sum of the total sessions from any device.
   */
  totalSessions: number;
  /**
   * Number of credits used for AI chat.
   */
  aiCreditsChat?: number;
  /**
   * Number of credits used for AI block.
   */
  aiCreditsBlock?: number;
  /**
   * Number of credits used for AI column.
   */
  aiCreditsColumn?: number;
  /**
   * Number of credits used for AI assistant.
   */
  aiCreditsAssistant?: number;
  /**
   * Number of credits used for AI reviewer.
   */
  aiCreditsReviewer?: number;
  /**
   * Total number of AI credits used.
   */
  aiCredits?: number;
};

/**
 * Determines how the Doc analytics returned are sorted.
 */
export type DocAnalyticsOrderBy =
  | 'date'
  | 'docId'
  | 'title'
  | 'createdAt'
  | 'publishedAt'
  | 'likes'
  | 'copies'
  | 'views'
  | 'sessionsDesktop'
  | 'sessionsMobile'
  | 'sessionsOther'
  | 'totalSessions'
  | 'aiCreditsChat'
  | 'aiCreditsBlock'
  | 'aiCreditsColumn'
  | 'aiCreditsAssistant'
  | 'aiCreditsReviewer'
  | 'aiCredits';

/**
 * Summarized metrics for Coda docs.
 */
export type DocAnalyticsSummary = {
  /**
   * Total number of sessions across all docs.
   */
  totalSessions: number;
};

/**
 * The category applied to a doc.
 */
export type DocCategory = {
  /**
   * Name of the category.
   */
  name: string;
};

/**
 * A list of categories that can be applied to a doc.
 */
export type DocCategoryList = {
  /**
   * Categories for the doc.
   */
  items: Array<DocCategory>;
};

/**
 * Payload for creating a new doc.
 */
export type DocCreate = {
  /**
   * Title of the new doc. Defaults to 'Untitled'.
   */
  title?: string;
  /**
   * An optional doc ID from which to create a copy.
   */
  sourceDoc?: string;
  /**
   * The timezone to use for the newly created doc.
   */
  timezone?: string;
  /**
   * The ID of the folder within which to create this doc. Defaults to your "My docs" folder in the oldest workspace you joined; this is subject to change. You can get this ID by opening the folder in the docs list on your computer and grabbing the `folderId` query parameter.
   *
   */
  folderId?: string;
  initialPage?: {
    [key: string]: unknown;
  } & PageCreate;
};

/**
 * The result of a doc deletion.
 */
export type DocDelete = {
  [key: string]: unknown;
};

/**
 * List of Coda docs.
 */
export type DocList = {
  items: Array<Doc>;
  /**
   * API link to these results
   */
  href?: string;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Payload for publishing a doc or or updating its publishing information.
 */
export type DocPublish = {
  /**
   * Slug for the published doc.
   */
  slug?: string;
  /**
   * If true, indicates that the doc is discoverable.
   */
  discoverable?: boolean;
  /**
   * If true, new users may be required to sign in to view content within this document. You will receive Coda credit for each user who signs up via your doc.
   *
   */
  earnCredit?: boolean;
  /**
   * The names of categories to apply to the document.
   */
  categoryNames?: Array<string>;
  mode?: DocPublishMode;
};

/**
 * Information about the publishing state of the document.
 */
export type DocPublished = {
  /**
   * Description of the published doc.
   */
  description?: string;
  /**
   * URL to the published doc.
   */
  browserLink: string;
  /**
   * URL to the cover image for the published doc.
   */
  imageLink?: string;
  /**
   * If true, indicates that the doc is discoverable.
   */
  discoverable: boolean;
  /**
   * If true, new users may be required to sign in to view content within this document. You will receive Coda credit for each user who signs up via your doc.
   *
   */
  earnCredit: boolean;
  mode: DocPublishMode;
  /**
   * Categories applied to the doc.
   */
  categories: Array<DocCategory>;
};

/**
 * Which interaction mode the published doc should use.
 */
export type DocPublishMode = 'view' | 'play' | 'edit';

/**
 * Reference to a Coda doc.
 */
export type DocReference = {
  /**
   * ID of the Coda doc.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'doc';
  /**
   * API link to the Coda doc.
   */
  href: string;
  /**
   * Browser-friendly link to the Coda doc.
   */
  browserLink: string;
};

/**
 * The number of components within a Coda doc.
 */
export type DocSize = {
  /**
   * The number of rows contained within all tables of the doc.
   */
  totalRowCount: number;
  /**
   * The total number of tables and views contained within the doc.
   */
  tableAndViewCount: number;
  /**
   * The total number of page contained within the doc.
   */
  pageCount: number;
  /**
   * If true, indicates that the doc is over the API size limit.
   */
  overApiSizeLimit: boolean;
};

/**
 * The result of a doc creation.
 */
export type DocumentCreationResult = {
  /**
   * ID of the Coda doc.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'doc';
  /**
   * API link to the Coda doc.
   */
  href: string;
  /**
   * Browser-friendly link to the Coda doc.
   */
  browserLink: string;
  icon?: Icon;
  /**
   * Name of the doc.
   */
  name: string;
  /**
   * Email address of the doc owner.
   */
  owner: string;
  /**
   * Name of the doc owner.
   */
  ownerName: string;
  docSize?: DocSize;
  sourceDoc?: {
    [key: string]: unknown;
  } & DocReference;
  /**
   * Timestamp for when the doc was created.
   */
  createdAt: string;
  /**
   * Timestamp for when the doc was last modified.
   */
  updatedAt: string;
  published?: DocPublished;
  folder: FolderReference;
  workspace: WorkspaceReference;
  /**
   * ID of the Coda workspace containing this doc.
   * @deprecated
   */
  workspaceId: string;
  /**
   * ID of the Coda folder containing this doc.
   * @deprecated
   */
  folderId: string;
  /**
   * An arbitrary unique identifier for this request.
   */
  requestId?: string;
};

/**
 * Base response type for an operation that mutates a document.
 */
export type DocumentMutateResponse = {
  /**
   * An arbitrary unique identifier for this request.
   */
  requestId: string;
};

/**
 * Payload for updating a doc.
 */
export type DocUpdate = {
  /**
   * Title of the doc.
   */
  title?: string;
  /**
   * Name of the icon.
   */
  iconName?: string;
};

/**
 * The result of a doc update
 */
export type DocUpdateResult = {
  [key: string]: unknown;
};

export type DomainPrincipal = {
  /**
   * The type of this principal.
   */
  type: 'domain';
  /**
   * Domain for the principal.
   */
  domain: string;
};

/**
 * Format of a duration column.
 */
export type DurationColumnFormat = SimpleColumnFormat & {
  precision?: number;
  maxUnit?: unknown & DurationUnit;
};

/**
 * A time unit used as part of a duration value.
 */
export type DurationUnit = 'days' | 'hours' | 'minutes' | 'seconds';

/**
 * Format of an email column.
 */
export type EmailColumnFormat = SimpleColumnFormat & {
  display?: EmailDisplayType;
  autocomplete?: boolean;
};

/**
 * How an email address should be displayed in the user interface.
 */
export type EmailDisplayType = 'iconAndEmail' | 'iconOnly' | 'emailOnly';

export type EmailPrincipal = {
  /**
   * The type of this principal.
   */
  type: 'email';
  /**
   * Email for the principal.
   */
  email: string;
};

/**
 * Status of featured doc in pack listing.
 */
export type FeaturedDocStatus = 'docInaccessibleOrDoesNotExist' | 'invalidPublishedDocUrl';

/**
 * Only relevant for original Coda packs.
 * @deprecated
 */
export type FeatureSet = 'Basic' | 'Pro' | 'Team' | 'Enterprise';

/**
 * Reference to a Coda folder.
 */
export type FolderReference = {
  /**
   * ID of the Coda folder.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'folder';
  /**
   * Browser-friendly link to the folder.
   */
  browserLink: string;
  /**
   * Name of the folder; included if the user has access to the folder.
   */
  name?: string;
};

/**
 * The type of this resource.
 */
export type type6 = 'folder';

/**
 * Details about a formula.
 */
export type Formula = {
  /**
   * ID of the formula.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'formula';
  /**
   * API link to the formula.
   */
  href: string;
  /**
   * Name of the formula.
   */
  name: string;
  parent?: PageReference;
  value: Value;
};

/**
 * The type of this resource.
 */
export type type7 = 'formula';

/**
 * Detailed information about a formula.
 */
export type FormulaDetail = {
  /**
   * Returns whether or not the given formula is valid.
   */
  valid: boolean;
  /**
   * Returns whether or not the given formula can return different results in different contexts (for example, for different users).
   *
   */
  isVolatile?: boolean;
  /**
   * Returns whether or not the given formula has a User() formula within it.
   */
  hasUserFormula?: boolean;
  /**
   * Returns whether or not the given formula has a Today() formula within it.
   */
  hasTodayFormula?: boolean;
  /**
   * Returns whether or not the given formula has a Now() formula within it.
   */
  hasNowFormula?: boolean;
};

/**
 * List of formulas.
 */
export type FormulaList = {
  items: Array<FormulaReference>;
  /**
   * API link to these results
   */
  href?: string;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Reference to a formula.
 */
export type FormulaReference = {
  /**
   * ID of the formula.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'formula';
  /**
   * API link to the formula.
   */
  href: string;
  /**
   * Name of the formula.
   */
  name: string;
  parent?: PageReference;
};

/**
 * Pricing used when workspaces can subscribe to the Pack for free.
 */
export type FreePackPlanPricing = {
  type: 'Free';
};

export type type8 = 'Free';

/**
 * Payload for getting the next version of a Pack.
 */
export type GetNextPackVersionRequest = {
  /**
   * The metadata for the next version of the Pack.
   */
  proposedMetadata: string;
  /**
   * The SDK version the metadata was built on.
   */
  sdkVersion?: string;
};

/**
 * JSON schema response.
 */
export type GetPackConfigurationJsonSchemaResponse = {
  [key: string]: unknown;
};

/**
 * Response for getting workspace role activity.
 */
export type GetWorkspaceRoleActivity = {
  items: Array<WorkspaceRoleActivity>;
};

/**
 * Grouped logs of the Pack's auth requests.
 */
export type GroupedPackAuthLog = {
  type: 'auth';
  authLog: PackAuthLog;
  relatedLogs: Array<PackLog>;
};

/**
 * Grouped logs of the invocations of the Pack.
 */
export type GroupedPackInvocationLog = {
  type: 'invocation';
  invocationLog: PackInvocationLog;
  relatedLogs: Array<PackLog>;
};

/**
 * A record of grouped Pack log.
 */
export type GroupedPackLog = GroupedPackInvocationLog | GroupedPackAuthLog;

/**
 * List of grouped Pack logs.
 */
export type GroupedPackLogsList = {
  items: Array<GroupedPackLog>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
  /**
   * This flag will be set to true if the result doens't include all the related logs.
   */
  incompleteRelatedLogs: boolean;
};

export type GroupPrincipal = {
  /**
   * The type of this principal.
   */
  type: 'group';
  /**
   * Group ID for the principal.
   */
  groupId: string;
  /**
   * Name of the group.
   */
  groupName: string;
};

/**
 * Info about the icon.
 */
export type Icon = {
  /**
   * Name of the icon.
   */
  name: string;
  /**
   * MIME type of the icon
   */
  type: string;
  /**
   * Browser-friendly link to an icon.
   */
  browserLink: string;
};

/**
 * List of available icon sets.
 */
export type IconSet =
  | 'star'
  | 'circle'
  | 'fire'
  | 'bug'
  | 'diamond'
  | 'bell'
  | 'thumbsup'
  | 'heart'
  | 'chili'
  | 'smiley'
  | 'lightning'
  | 'currency'
  | 'coffee'
  | 'person'
  | 'battery'
  | 'cocktail'
  | 'cloud'
  | 'sun'
  | 'checkmark'
  | 'lightbulb';

/**
 * Info about the image.
 */
export type Image = {
  /**
   * Browser-friendly link to an image.
   */
  browserLink: string;
  /**
   * MIME type of the image.
   */
  type?: string;
  /**
   * The width in pixels of the image.
   */
  width?: number;
  /**
   * The height in pixels of the image.
   */
  height?: number;
};

/**
 * Format of an image reference column.
 */
export type ImageReferenceColumnFormat = SimpleColumnFormat & {
  width: unknown & NumberOrNumberFormula;
  height: unknown & NumberOrNumberFormula;
  style: ImageShapeStyle;
};

/**
 * How an image should be displayed.
 */
export type ImageShapeStyle = 'auto' | 'circle';

/**
 * The status values that an image object can have.
 */
export type ImageStatus = 'live' | 'deleted' | 'failed';

/**
 * A named url of an image along with metadata.
 */
export type ImageUrlValue = LinkedDataObject & {
  /**
   * The name of the image.
   */
  name?: string;
  /**
   * The url of the image.
   */
  url?: string;
  /**
   * The height of the image in pixels.
   */
  height?: number;
  /**
   * The width of the image in pixels.
   */
  width?: number;
  status?: ImageStatus;
};

/**
 * Context that comes with a ingestion execution.
 */
export type IngestionExecutionContext = {
  ingestionName: string | null;
  csbIngestionExecutionId: string;
  /**
   * Creation time of the ingestion execution in seconds since epoch.
   */
  creationTimestamp: number;
  parentItemId: string | null;
};

/**
 * List of Ingestion Executions.
 */
export type IngestionExecutionsList = {
  items: Array<IngestionExecutionContext>;
  nextPageToken?: nextPageToken;
};

/**
 * Live or Latest version of pack
 */
export type IngestionPackReleaseChannel = 'LIVE' | 'LATEST';

/**
 * Layout type of the table or view.
 */
export type Layout =
  | 'default'
  | 'areaChart'
  | 'barChart'
  | 'bubbleChart'
  | 'calendar'
  | 'card'
  | 'detail'
  | 'form'
  | 'ganttChart'
  | 'lineChart'
  | 'masterDetail'
  | 'pieChart'
  | 'scatterChart'
  | 'slide'
  | 'wordCloud';

/**
 * Format of a link column.
 */
export type LinkColumnFormat = SimpleColumnFormat & {
  display?: LinkDisplayType;
  /**
   * Force embeds to render on the client instead of the server (for sites that require user login).
   */
  force?: boolean;
};

/**
 * How a link should be displayed in the user interface.
 */
export type LinkDisplayType = 'iconOnly' | 'url' | 'title' | 'card' | 'embed';

/**
 * Base type for a JSON-LD (Linked Data) object.
 */
export type LinkedDataObject = {
  /**
   * A url describing the schema context for this object, typically "http://schema.org/".
   */
  '@context': string;
  '@type': LinkedDataType;
  /**
   * An identifier of additional type info specific to Coda that may not be present in a schema.org taxonomy,
   *
   */
  additionalType?: string;
};

/**
 * A schema.org identifier for the object.
 */
export type LinkedDataType = 'ImageObject' | 'MonetaryAmount' | 'Person' | 'WebPage' | 'StructuredValue';

/**
 * Confirmation of successfully retrieving Pack categories.
 */
export type ListPackCategoriesResponse = {
  /**
   * The names of categories associated with a Pack.
   */
  categories: Array<PublishingCategory>;
};

/**
 * Confirmation of successfully retrieving Pack makers.
 */
export type ListPackMakersResponse = {
  makers: Array<Maker>;
};

export type LogLevel = 'error' | 'warn' | 'info' | 'debug' | 'trace' | 'unknown';

/**
 * Info about the maker
 */
export type Maker = {
  /**
   * Name of the maker.
   */
  name: string;
  /**
   * Browser-friendly link to the maker's avatar image.
   */
  pictureLink?: string;
  /**
   * Maker profile identifier for the maker.
   */
  slug?: string;
  /**
   * Job title for maker.
   */
  jobTitle?: string;
  /**
   * Employer for maker.
   */
  employer?: string;
  /**
   * Description for the maker.
   */
  description?: string;
  /**
   * Email address of the user.
   */
  loginId: string;
};

/**
 * Summary about a maker
 */
export type MakerSummary = {
  /**
   * Name of the maker.
   */
  name: string;
  /**
   * Browser-friendly link to the maker's avatar image.
   */
  pictureLink?: string;
  /**
   * Maker profile identifier for the maker.
   */
  slug?: string;
  /**
   * Job title for maker.
   */
  jobTitle?: string;
  /**
   * Employer for maker.
   */
  employer?: string;
  /**
   * Description for the maker.
   */
  description?: string;
};

/**
 * Pricing used when workspaces can subscribe to the Pack for a monthly cost per Doc Maker.
 */
export type MonthlyDocMakerPackPlanPricing = {
  type: 'MonthlyDocMaker';
  /**
   * The monthly cost of the Pack per Doc Maker.
   */
  amount: number;
  currency: PackPlanCurrency;
};

export type type9 = 'MonthlyDocMaker';

/**
 * The status of an asynchronous mutation.
 */
export type MutationStatus = {
  /**
   * Returns whether the mutation has completed.
   */
  completed: boolean;
  /**
   * A warning if the mutation completed but with caveats.
   */
  warning?: string;
};

/**
 * Information indicating the next Pack version definition.
 */
export type NextPackVersionInfo = {
  /**
   * The next valid version for the Pack.
   */
  nextVersion: string;
  /**
   * List of changes from the previous version.
   */
  findings: Array<string>;
};

/**
 * If specified, a link that can be used to fetch the next page of results.
 */
export type nextPageLink = string;

/**
 * If specified, an opaque token used to fetch the next page of results.
 */
export type nextPageToken = string;

/**
 * If specified, an opaque token that can be passed back later to retrieve new results that match the parameters specified when the sync token was created.
 *
 */
export type nextSyncToken = string;

/**
 * A number or a string representing a formula that evaluates to a number.
 */
export type NumberOrNumberFormula = number | string;

/**
 * Format of a numeric column.
 */
export type NumericColumnFormat = SimpleColumnFormat & {
  /**
   * The decimal precision.
   */
  precision?: number;
  /**
   * Whether to use a thousands separator (like ",") to format the numeric value.
   */
  useThousandsSeparator?: boolean;
};

/**
 * Details about a Pack.
 */
export type Pack = {
  /**
   * ID of the Pack.
   */
  id: number;
  /**
   * The link to the logo of the Pack.
   */
  logoUrl?: string;
  /**
   * The link to the cover photo of the Pack.
   */
  coverUrl?: string;
  /**
   * The example images for the Pack.
   */
  exampleImages?: Array<PackImageFile>;
  /**
   * The parent workspace for the Pack.
   */
  workspaceId: string;
  /**
   * Publishing categories associated with this Pack.
   */
  categories: Array<PublishingCategory>;
  /**
   * Denotes if the pack is certified by Coda.
   */
  certified?: boolean;
  sourceCodeVisibility?: PackSourceCodeVisibility;
  /**
   * The name of the Pack.
   */
  name: string;
  /**
   * The full description of the Pack.
   */
  description: string;
  /**
   * A short version of the description of the Pack.
   */
  shortDescription: string;
  /**
   * A contact email for the Pack.
   */
  supportEmail?: string;
  /**
   * A Terms of Service URL for the Pack.
   */
  termsOfServiceUrl?: string;
  /**
   * A Privacy Policy URL for the Pack.
   */
  privacyPolicyUrl?: string;
  overallRateLimit?: PackRateLimit;
  perConnectionRateLimit?: PackRateLimit;
  featuredDocStatus?: FeaturedDocStatus;
};

export type PackAccessType = 'view' | 'test' | 'edit' | 'admin';

/**
 * Access types for a Pack.
 */
export type PackAccessTypes = Array<PackAccessType>;

/**
 * List of analytics for Coda Packs over a date range.
 */
export type PackAnalyticsCollection = {
  items: Array<PackAnalyticsItem>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Metadata about a Pack relevant to analytics.
 */
export type PackAnalyticsDetails = {
  /**
   * ID of the Pack.
   */
  id: number;
  /**
   * The name of the Pack.
   */
  name: string;
  /**
   * The link to the logo of the Pack.
   */
  logoUrl?: string;
  /**
   * Creation time of the Pack.
   */
  createdAt: string;
};

/**
 * Analytics data for a Coda Pack.
 */
export type PackAnalyticsItem = {
  pack: PackAnalyticsDetails;
  metrics: Array<PackAnalyticsMetrics>;
};

/**
 * Analytics metrics for a Coda Pack.
 */
export type PackAnalyticsMetrics = {
  /**
   * Date of the analytics data.
   */
  date: string;
  /**
   * Number of unique documents that have installed this Pack.
   */
  docInstalls: number;
  /**
   * Number of unique workspaces that have installed this Pack.
   */
  workspaceInstalls: number;
  /**
   * Number of times regular formulas have been called.
   */
  numFormulaInvocations: number;
  /**
   * Number of times action formulas have been called.
   */
  numActionInvocations: number;
  /**
   * Number of times sync table formulas have been called.
   */
  numSyncInvocations: number;
  /**
   * Number of times metadata formulas have been called.
   */
  numMetadataInvocations: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack in the past day.
   */
  docsActivelyUsing: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack in the past 7 days.
   */
  docsActivelyUsing7Day: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack in the past 30 days.
   */
  docsActivelyUsing30Day: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack in the past 90 days.
   */
  docsActivelyUsing90Day: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack ever.
   */
  docsActivelyUsingAllTime: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack in the past day.
   */
  workspacesActivelyUsing: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack in the past 7 days.
   */
  workspacesActivelyUsing7Day: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack in the past 30 days.
   */
  workspacesActivelyUsing30Day: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack in the past 90 days.
   */
  workspacesActivelyUsing90Day: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack ever.
   */
  workspacesActivelyUsingAllTime: number;
  /**
   * Number of unique workspaces that are currently involved in a trial.
   */
  workspacesActivelyTrialing: number;
  /**
   * Number of unique workspaces that have been involved in a trial in the last 7 days.
   */
  workspacesActivelyTrialing7Day: number;
  /**
   * Number of unique workspaces that have been involved in a trial in the last 30 days.
   */
  workspacesActivelyTrialing30Day: number;
  /**
   * Number of unique workspaces that have been involved in a trial in the last 90 days.
   */
  workspacesActivelyTrialing90Day: number;
  /**
   * Number of unique workspaces that have been involved in a trial ever.
   */
  workspacesActivelyTrialingAllTime: number;
  /**
   * Number of unique workspaces that have recently subscribed to the Pack.
   */
  workspacesNewlySubscribed: number;
  /**
   * Number of unique workspaces that are currently subscribed to the Pack.
   */
  workspacesWithActiveSubscriptions: number;
  /**
   * Number of unique workspaces that subscribed after undertaking a Pack trial.
   */
  workspacesWithSuccessfulTrials: number;
  /**
   * Amount of revenue (in USD) that the Pack has produced.
   */
  revenueUsd: string;
};

/**
 * Determines how the Pack analytics returned are sorted.
 */
export type PackAnalyticsOrderBy =
  | 'date'
  | 'packId'
  | 'name'
  | 'createdAt'
  | 'docInstalls'
  | 'workspaceInstalls'
  | 'numFormulaInvocations'
  | 'numActionInvocations'
  | 'numSyncInvocations'
  | 'numMetadataInvocations'
  | 'docsActivelyUsing'
  | 'docsActivelyUsing7Day'
  | 'docsActivelyUsing30Day'
  | 'docsActivelyUsing90Day'
  | 'docsActivelyUsingAllTime'
  | 'workspacesActivelyUsing'
  | 'workspacesActivelyUsing7Day'
  | 'workspacesActivelyUsing30Day'
  | 'workspacesActivelyUsing90Day'
  | 'workspacesActivelyUsingAllTime'
  | 'workspacesWithActiveSubscriptions'
  | 'workspacesWithSuccessfulTrials'
  | 'revenueUsd';

/**
 * Summary analytics for Packs.
 */
export type PackAnalyticsSummary = {
  /**
   * The number of times this Pack was installed in docs.
   */
  totalDocInstalls: number;
  /**
   * The number of times this Pack was installed in workspaces.
   */
  totalWorkspaceInstalls: number;
  /**
   * The number of times formulas in this Pack were invoked.
   */
  totalInvocations: number;
};

export type PackAssetType = 'logo' | 'cover' | 'exampleImage';

/**
 * Payload for noting a Pack asset upload is complete.
 */
export type PackAssetUploadCompleteRequest = {
  packAssetType: PackAssetType;
};

/**
 * Response for noting a Pack asset upload is complete.
 */
export type PackAssetUploadCompleteResponse = {
  /**
   * An arbitrary unique identifier for this request.
   */
  requestId: string;
  /**
   * An identifier of this uploaded asset.
   */
  assetId: string;
};

/**
 * Information indicating where to upload the Pack asset, and an endpoint to mark the upload as complete.
 */
export type PackAssetUploadInfo = {
  /**
   * A signed URL to be used for uploading a Pack asset.
   */
  uploadUrl: string;
  /**
   * An endpoint to mark the upload as complete.
   */
  packAssetUploadedPathName: string;
  /**
   * Key-value pairs of authorization headers to include in the upload request.
   */
  headers: {
    [key: string]: string;
  };
};

/**
 * System logs of Pack authentication requests.
 */
export type PackAuthLog = {
  type: 'auth';
  context: PackLogContext;
  /**
   * The request path.
   */
  path: string;
  /**
   * The error message.
   */
  errorMessage?: string;
  /**
   * The error stacktrace (internal only).
   */
  errorStack?: string;
};

/**
 * Basic details about a configuration that can be used in conjunction with a pack
 */
export type PackConfigurationEntry = {
  configurationId: string;
  /**
   * Name of the configuration
   */
  name: string;
  /**
   * Policy associated with the configuration
   */
  policy?: {
    [key: string]: unknown;
  };
};

export type PackConnectionCustomCredentials = {
  type: 'custom';
  params: Array<{
    key: string;
    value: string;
  }>;
};

export type PackConnectionCustomMetadata = {
  type: 'custom';
  /**
   * An array of objects containing the parameter key and masked value.
   */
  params: Array<{
    key: string;
    maskedValue: string;
  }>;
  /**
   * The domain corresponding to the pre-authorized network domain in the pack.
   */
  domain: string;
  /**
   * An array containing the keys of parameters specified by the authentication config.
   */
  presetKeys: Array<string>;
};

export type PackConnectionCustomPatch = {
  type: 'custom';
  paramsToPatch?: Array<{
    key: string;
    value: string;
  }>;
};

export type PackConnectionGoogleServiceAccountCredentials = {
  type: 'googleServiceAccount';
  serviceAccountKey: string;
};

export type PackConnectionGoogleServiceAccountMetadata = {
  type: 'googleServiceAccount';
  maskedServiceAccountKey: string;
};

export type PackConnectionGoogleServiceAccountPatch = {
  type: 'googleServiceAccount';
  serviceAccountKey?: string;
};

export type PackConnectionHeaderCredentials = {
  type: 'header';
  token: string;
};

export type PackConnectionHeaderMetadata = {
  type: 'header';
  maskedToken?: string;
  headerName: string;
  tokenPrefix: string;
};

export type PackConnectionHeaderPatch = {
  type: 'header';
  token?: string;
};

export type PackConnectionHttpBasicCredentials = {
  type: 'httpBasic';
  username: string;
  password?: string;
};

export type PackConnectionHttpBasicMetadata = {
  type: 'httpBasic';
  maskedUsername?: string;
  maskedPassword?: string;
};

export type PackConnectionHttpBasicPatch = {
  type: 'httpBasic';
  username?: string;
  password?: string;
};

export type PackConnectionMultiHeaderCredentials = {
  type: 'multiHeader';
  tokens: Array<{
    key: string;
    value: string;
  }>;
};

export type PackConnectionMultiHeaderMetadata = {
  type: 'multiHeader';
  headers: Array<{
    headerName: string;
    maskedToken: string;
    tokenPrefix?: string;
  }>;
  presets: Array<{
    headerName: string;
    tokenPrefix?: string;
  }>;
};

export type PackConnectionMultiHeaderPatch = {
  type: 'multiHeader';
  tokensToPatch?: Array<{
    key: string;
    value: string;
  }>;
};

export type PackConnectionOauth2ClientCredentials = {
  type: 'oauth2ClientCredentials';
  clientId: string;
  clientSecret: string;
};

export type PackConnectionOauth2ClientCredentialsMetadata = {
  type: 'oauth2ClientCredentials';
  location: PackOAuth2ClientCredentialsLocation;
  maskedClientId: string;
  maskedClientSecret: string;
};

export type PackConnectionOauth2ClientCredentialsPatch = {
  type: 'oauth2ClientCredentials';
  clientId?: string;
  clientSecret?: string;
};

/**
 * Type of Pack connections.
 */
export type PackConnectionType =
  | 'header'
  | 'multiHeader'
  | 'urlParam'
  | 'httpBasic'
  | 'custom'
  | 'oauth2ClientCredentials'
  | 'googleServiceAccount';

export type PackConnectionUrlParamCredentials = {
  type: 'urlParam';
  params: Array<{
    key: string;
    value: string;
  }>;
};

export type PackConnectionUrlParamMetadata = {
  type: 'urlParam';
  params: Array<{
    key: string;
    maskedValue: string;
  }>;
  domain: string;
  presetKeys: Array<string>;
};

export type PackConnectionUrlParamPatch = {
  type: 'urlParam';
  paramsToPatch?: Array<{
    key: string;
    value: string;
  }>;
};

/**
 * Pack log generated by developer's custom logging with context.logger.
 */
export type PackCustomLog = {
  type: 'custom';
  context: PackLogContext;
  /**
   * The message that's passed into context.logger.
   */
  message: string;
  level: LogLevel;
};

/**
 * Widest principal a Pack is available to.
 */
export type PackDiscoverability = 'public' | 'workspace' | 'private';

/**
 * A Pack's featured doc.
 */
export type PackFeaturedDoc = {
  doc: DocReference;
  /**
   * Whether or not this featured doc is pinned.
   */
  isPinned: boolean;
  docStatus?: FeaturedDocStatus;
  /**
   * The URL of the published doc, if available.
   */
  publishedUrl?: string;
};

/**
 * Item representing a featured doc in the update Pack featured docs request.
 */
export type PackFeaturedDocRequestItem = {
  /**
   * A URL to a doc.
   */
  url: string;
  /**
   * Whether or not the current doc should be pinned.
   */
  isPinned?: boolean;
};

/**
 * List of a Pack's featured docs.
 */
export type PackFeaturedDocsResponse = {
  /**
   * A list of featured docs for the Pack.
   */
  items: Array<PackFeaturedDoc>;
};

/**
 * System logs of Pack calls to context.fetcher.
 */
export type PackFetcherLog = {
  type: 'invocation';
  context: PackLogContext;
  /**
   * The number of bytes in the HTTP request sent
   */
  requestSizeBytes?: number;
  responseCode?: number;
  /**
   * The number of bytes in the HTTP response received
   */
  responseSizeBytes?: number;
  method?: 'GET' | 'POST' | 'PUT' | 'DELETE' | 'PATCH' | 'HEAD';
  /**
   * base URL of the fetcher request, with all query parameters stripped off.
   */
  baseUrl?: string;
  /**
   * true if the fetcher request hits catche instead of actually requesting the remote service.
   */
  cacheHit?: boolean;
  /**
   * Duration of the fetcher request in miliseconds.
   */
  duration?: number;
};

export type method = 'GET' | 'POST' | 'PUT' | 'DELETE' | 'PATCH' | 'HEAD';

/**
 * A collection of analytics for Coda Packs formulas over a date range.
 */
export type PackFormulaAnalyticsCollection = {
  items: Array<PackFormulaAnalyticsItem>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Analytics data for a Coda Pack formula.
 */
export type PackFormulaAnalyticsItem = {
  formula: PackFormulaIdentifier;
  metrics: Array<PackFormulaAnalyticsMetrics>;
};

/**
 * Analytics metrics for a Coda Pack formula.
 */
export type PackFormulaAnalyticsMetrics = {
  /**
   * Date of the analytics data.
   */
  date: string;
  /**
   * Number of times this formula has been invoked.
   */
  formulaInvocations: number;
  /**
   * Number of errors from invocations.
   */
  errors: number;
  /**
   * Median latency of an invocation in milliseconds. Only present for daily metrics.
   */
  medianLatencyMs?: number;
  /**
   * Median response size in bytes. Only present for daily metrics.
   */
  medianResponseSizeBytes?: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack in the past day.
   */
  docsActivelyUsing: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack in the past 7 days.
   */
  docsActivelyUsing7Day: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack in the past 30 days.
   */
  docsActivelyUsing30Day: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack in the past 90 days.
   */
  docsActivelyUsing90Day: number;
  /**
   * Number of unique docs that have invoked a formula from this Pack ever.
   */
  docsActivelyUsingAllTime: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack in the past day.
   */
  workspacesActivelyUsing: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack in the past 7 days.
   */
  workspacesActivelyUsing7Day: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack in the past 30 days.
   */
  workspacesActivelyUsing30Day: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack in the past 90 days.
   */
  workspacesActivelyUsing90Day: number;
  /**
   * Number of unique workspaces that have invoked a formula from this Pack ever.
   */
  workspacesActivelyUsingAllTime: number;
  /**
   * Number of unique workspaces that are currently involved in a trial.
   */
  workspacesActivelyTrialing?: number;
  /**
   * Number of unique workspaces that have been involved in a trial in the last 7 days.
   */
  workspacesActivelyTrialing7Day?: number;
  /**
   * Number of unique workspaces that have been involved in a trial in the last 30 days.
   */
  workspacesActivelyTrialing30Day?: number;
  /**
   * Number of unique workspaces that have been involved in a trial in the last 90 days.
   */
  workspacesActivelyTrialing90Day?: number;
  /**
   * Number of unique workspaces that have been involved in a trial ever.
   */
  workspacesActivelyTrialingAllTime?: number;
  /**
   * Number of unique workspaces that have recently subscribed to the Pack.
   */
  workspacesNewlySubscribed?: number;
  /**
   * Number of unique workspaces that are currently subscribed to the Pack.
   */
  workspacesWithActiveSubscriptions?: number;
  /**
   * Number of unique workspaces that subscribed after undertaking a Pack trial.
   */
  workspacesWithSuccessfulTrials?: number;
  /**
   * Amount of revenue (in USD) that the Pack has produced.
   */
  revenueUsd?: string;
};

/**
 * Determines how the Pack formula analytics returned are sorted.
 */
export type PackFormulaAnalyticsOrderBy =
  | 'date'
  | 'formulaName'
  | 'formulaType'
  | 'formulaInvocations'
  | 'medianLatencyMs'
  | 'medianResponseSizeBytes'
  | 'errors'
  | 'docsActivelyUsing'
  | 'docsActivelyUsing7Day'
  | 'docsActivelyUsing30Day'
  | 'docsActivelyUsing90Day'
  | 'docsActivelyUsingAllTime'
  | 'workspacesActivelyUsing'
  | 'workspacesActivelyUsing7Day'
  | 'workspacesActivelyUsing30Day'
  | 'workspacesActivelyUsing90Day'
  | 'workspacesActivelyUsingAllTime';

export type PackFormulaIdentifier = {
  /**
   * The Pack formula name.
   */
  name: string;
  type: PackFormulaType;
};

export type PackFormulaType = 'action' | 'formula' | 'sync' | 'metadata';

export type PackGlobalPrincipal = {
  type: 'global';
};

/**
 * A Pack image file.
 */
export type PackImageFile = {
  /**
   * The name of the image file.
   */
  filename: string;
  /**
   * The URL to the image file.
   */
  imageUrl: string;
  /**
   * The asset id of the Pack's image.
   */
  assetId: string;
  /**
   * The alt text for the image.
   */
  altText?: string;
  /**
   * The media type of the image.
   */
  mimeType?: string;
};

/**
 * Pack log generated by an executing ingestion. Contains metadata helpful for debugging
 */
export type PackIngestionDebugLog = {
  type: 'ingestionDebug';
  context: PackLogContext;
  /**
   * The message that's passed into context.logger.
   */
  message: string;
  level: LogLevel;
};

/**
 * Pack log generated by an executing ingestion.
 */
export type PackIngestionLifecycleLog = {
  type: 'ingestionLifecycle';
  context: PackLogContext;
  /**
   * The message that's passed into context.logger.
   */
  message: string;
  level: LogLevel;
};

/**
 * Coda internal logs from the packs infrastructure. Only visible to Codans.
 */
export type PackInternalLog = {
  type: 'internal';
  context: PackLogContext;
  /**
   * The log message.
   */
  message: string;
  level: LogLevel;
};

/**
 * System logs of the invocations of the Pack.
 */
export type PackInvocationLog = {
  type: 'fetcher';
  context: PackLogContext;
  /**
   * True if the formula returned a prior result without executing.
   */
  cacheHit?: boolean;
  /**
   * Duration of the formula exeuction in miliseconds.
   */
  duration?: number;
  /**
   * Error info if this invocation resulted in an error.
   */
  error?: {
    message: string;
    stack?: string;
  };
};

/**
 * A Pack listing.
 */
export type PackListing = {
  /**
   * ID of the Pack.
   */
  packId: number;
  /**
   * The version of the Pack.
   */
  packVersion: string;
  /**
   * The current release number of the Pack if released, otherwise undefined.
   */
  releaseId?: number;
  /**
   * The timestamp of the latest release of this Pack.
   */
  lastReleasedAt?: string;
  /**
   * The link to the logo of the Pack.
   */
  logoUrl: string;
  /**
   * The link to the cover photo of the Pack.
   */
  coverUrl?: string;
  /**
   * The example images for the Pack.
   */
  exampleImages?: Array<PackImageFile>;
  /**
   * The name of the Pack.
   */
  name: string;
  /**
   * The full description of the Pack.
   */
  description: string;
  /**
   * A short version of the description of the Pack.
   */
  shortDescription: string;
  /**
   * A contact email for the Pack.
   */
  supportEmail?: string;
  /**
   * A Terms of Service URL for the Pack.
   */
  termsOfServiceUrl?: string;
  /**
   * A Privacy Policy URL for the Pack.
   */
  privacyPolicyUrl?: string;
  /**
   * Publishing Categories associated with this Pack.
   */
  categories: Array<PublishingCategory>;
  /**
   * Makers associated with this Pack.
   */
  makers: Array<MakerSummary>;
  /**
   * Denotes if the pack is certified by Coda.
   */
  certified?: boolean;
  minimumFeatureSet?: FeatureSet;
  unrestrictedFeatureSet?: FeatureSet;
  /**
   * The URL where complete metadata about the contents of the Pack version can be downloaded.
   */
  externalMetadataUrl: string;
  standardPackPlan?: StandardPackPlan;
  bundledPackPlan?: BundledPackPlan;
  sourceCodeVisibility?: PackSourceCodeVisibility;
  /**
   * What Packs SDK version was this version built on.
   */
  sdkVersion: string;
};

/**
 * A detailed Pack listing.
 */
export type PackListingDetail = {
  /**
   * ID of the Pack.
   */
  packId: number;
  /**
   * The version of the Pack.
   */
  packVersion: string;
  /**
   * The current release number of the Pack if released, otherwise undefined.
   */
  releaseId?: number;
  /**
   * The timestamp of the latest release of this Pack.
   */
  lastReleasedAt?: string;
  /**
   * The link to the logo of the Pack.
   */
  logoUrl: string;
  /**
   * The link to the cover photo of the Pack.
   */
  coverUrl?: string;
  /**
   * The example images for the Pack.
   */
  exampleImages?: Array<PackImageFile>;
  /**
   * The name of the Pack.
   */
  name: string;
  /**
   * The full description of the Pack.
   */
  description: string;
  /**
   * A short version of the description of the Pack.
   */
  shortDescription: string;
  /**
   * A contact email for the Pack.
   */
  supportEmail?: string;
  /**
   * A Terms of Service URL for the Pack.
   */
  termsOfServiceUrl?: string;
  /**
   * A Privacy Policy URL for the Pack.
   */
  privacyPolicyUrl?: string;
  /**
   * Publishing Categories associated with this Pack.
   */
  categories: Array<PublishingCategory>;
  /**
   * Makers associated with this Pack.
   */
  makers: Array<MakerSummary>;
  /**
   * Denotes if the pack is certified by Coda.
   */
  certified?: boolean;
  minimumFeatureSet?: FeatureSet;
  unrestrictedFeatureSet?: FeatureSet;
  /**
   * The URL where complete metadata about the contents of the Pack version can be downloaded.
   */
  externalMetadataUrl: string;
  standardPackPlan?: StandardPackPlan;
  bundledPackPlan?: BundledPackPlan;
  sourceCodeVisibility?: PackSourceCodeVisibility;
  /**
   * What Packs SDK version was this version built on.
   */
  sdkVersion: string;
  discoverability: PackDiscoverability;
  userAccess: PackUserAccess;
  /**
   * The URL of a Coda Help Center article with documentation about the Pack. This will only exist for select Coda-authored Packs.
   */
  codaHelpCenterUrl?: string;
  configuration?: PackConfigurationEntry;
};

/**
 * Type of context in which a Pack is being installed.
 */
export type PackListingInstallContextType = 'workspace' | 'doc';

/**
 * A list of Pack listings.
 */
export type PackListingList = {
  items: Array<PackListing>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Determines how the Pack listings returned are sorted.
 */
export type PackListingsSortBy = 'packId' | 'name' | 'packVersion' | 'packVersionModifiedAt';

/**
 * A record of Pack log.
 */
export type PackLog =
  | PackCustomLog
  | PackInvocationLog
  | PackFetcherLog
  | PackInternalLog
  | PackAuthLog
  | PackIngestionLifecycleLog
  | PackIngestionDebugLog;

/**
 * Logging context that comes with a Pack log.
 */
export type PackLogContext = {
  docId: string;
  packId: string;
  packVersion: string;
  formulaName: string;
  userId: string;
  connectionId: string;
  /**
   * A unique identifier of the Pack invocation that can be used to associate all log types generated in one call of a Pack formula.
   *
   */
  requestId: string;
  requestType: PackLogRequestType;
  /**
   * Creation time of the log.
   */
  createdAt: string;
  /**
   * Unique identifier of this log record.
   */
  logId: string;
  /**
   * Doc canvas object id where the formula was fired from.
   */
  docObjectId?: string;
  /**
   * Doc canvas row id where the formula was fired from.
   */
  docRowId?: string;
  /**
   * Doc canvas column id where the formula was fired from.
   */
  docColumnId?: string;
  /**
   * True if this is a formula invocation loading a page of a sync table, or metadata for a sync table (like creating a dynamic schema).
   */
  isSyncTable?: boolean;
  /**
   * True if this is an execution of a sync table which received a pagination parameter.
   */
  isContinuedSyncTable?: boolean;
  /**
   * If this formula invocation was for a parameter auto-complete, this names the parameter.
   */
  autocompleteParameterName?: string;
  /**
   * If this formula was invoked by something other than a user action, this should say what that was.
   */
  invocationSource?: string;
  /**
   * Key to be used in fetching log details.
   */
  detailsKey: string;
  /**
   * Unique identifier of the ingestion that triggered this log.
   */
  ingestionId?: string;
  /**
   * Unique identifier of the root ingestion that triggered this log.
   */
  rootIngestionId?: string;
  /**
   * Unique identifier of the ingestion execution that triggered this log.
   */
  ingestionExecutionId?: string;
};

/**
 * The context request type where a Pack log is generated.
 */
export type PackLogRequestType =
  | 'unknown'
  | 'connectionNameMetadataRequest'
  | 'parameterAutocompleteMetadataRequest'
  | 'postAuthSetupMetadataRequest'
  | 'propertyOptionsMetadataRequest'
  | 'getSyncTableSchemaMetadataRequest'
  | 'getDynamicSyncTableNameMetadataRequest'
  | 'listSyncTableDynamicUrlsMetadataRequest'
  | 'searchSyncTableDynamicUrlsMetadataRequest'
  | 'getDynamicSyncTableDisplayUrlMetadataRequest'
  | 'getIdentifiersForConnectionRequest'
  | 'invokeFormulaRequest'
  | 'invokeSyncFormulaRequest'
  | 'invokeSyncUpdateFormulaRequest';

/**
 * List of Pack logs.
 */
export type PackLogsList = {
  items: Array<PackLog>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

export type PackLogType =
  | 'custom'
  | 'fetcher'
  | 'invocation'
  | 'internal'
  | 'auth'
  | 'ingestionLifecycle'
  | 'ingestionDebug';

/**
 * Location of including OAuth2 client credentials in a request.
 */
export type PackOAuth2ClientCredentialsLocation = 'automatic' | 'body' | 'header';

/**
 * The Pack OAuth configuration metadata.
 */
export type PackOauthConfigMetadata = {
  /**
   * Masked OAuth client id. If not set, empty string will be returned.
   */
  maskedClientId: string;
  /**
   * Masked OAuth client secret. If not set, empty string will be returned.
   */
  maskedClientSecret: string;
  /**
   * Authorization URL of the OAuth provider.
   */
  authorizationUrl: string;
  /**
   * Token URL of the OAuth provider.
   */
  tokenUrl: string;
  /**
   * Optional token prefix that's used to make the API request.
   */
  tokenPrefix?: string;
  /**
   * Optional scopes of the OAuth client.
   */
  scopes?: string;
  /**
   * Redirect URI of the Pack.
   */
  redirectUri: string;
};

/**
 * Describes restrictions that a user's organization has placed on a pack for Coda Brain ingestions
 */
export type PackOrganizationAccessForCodaBrain = {
  canRequestAccess: boolean;
  hasRequestedAccess: boolean;
  requiresConfiguration: boolean;
  allowedConfigurations?: Array<PackConfigurationEntry>;
};

/**
 * Describes restrictions that a user's organization has placed on a pack
 */
export type PackOrganizationAccessForDocs = {
  canRequestAccess: boolean;
  hasRequestedAccess: boolean;
  requiresConfiguration: boolean;
  allowedConfigurations?: Array<PackConfigurationEntry>;
  incompatibleDocPermissions?: Array<Permission>;
  incompatibleDocOwner?: UserSummary;
  incompatibleDocFolder?: FolderReference;
};

/**
 * Metadata about a Pack permission.
 */
export type PackPermission = {
  /**
   * Id for the Permission
   */
  id: string;
  principal: PackPrincipal;
  access: PackAccessType;
};

/**
 * List of Pack permissions.
 */
export type PackPermissionList = {
  items: Array<PackPermission>;
  permissionUsers: Array<UserSummary>;
};

/**
 * Currency needed to subscribe to the Pack.
 */
export type PackPlanCurrency = 'USD';

/**
 * Type of pricing used to subscribe to a Pack.
 */
export type PackPlanPricingType = 'Free' | 'MonthlyDocMaker' | 'BundledWithTier';

/**
 * Metadata about a Pack principal.
 */
export type PackPrincipal = PackUserPrincipal | PackWorkspacePrincipal | PackGlobalPrincipal;

/**
 * Type of Pack permissions.
 */
export type PackPrincipalType = 'user' | 'workspace' | 'worldwide';

/**
 * Rate limit in Pack settings.
 */
export type PackRateLimit = {
  /**
   * The rate limit interval in seconds.
   */
  intervalSeconds: number;
  /**
   * The maximum number of Pack operations that can be performed in a given interval.
   */
  operationsPerInterval: number;
};

/**
 * Details about a Pack release.
 */
export type PackRelease = {
  /**
   * ID of the Packs.
   */
  packId: number;
  /**
   * Developer notes.
   */
  releaseNotes: string;
  /**
   * Timestamp for when the release was created.
   */
  createdAt: string;
  /**
   * The release number of the Pack version if it has one.
   */
  releaseId: number;
  /**
   * The semantic format of the Pack version.
   */
  packVersion: string;
  /**
   * What Packs SDK version was this version built on.
   */
  sdkVersion: string;
};

/**
 * List of Pack releases.
 */
export type PackReleaseList = {
  items: Array<PackRelease>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

export type PackSource = 'web' | 'cli';

/**
 * Details about a Pack's source code.
 */
export type PackSourceCode = {
  /**
   * name of the file
   */
  filename: string;
  /**
   * The URL to download the source code from
   */
  url: string;
};

/**
 * Information indicating where to upload the Pack source code, and an endpoint to mark the upload as complete.
 */
export type PackSourceCodeInfo = {
  files: Array<PackSourceCode>;
};

/**
 * Payload for noting a Pack source code upload is complete.
 */
export type PackSourceCodeUploadCompleteRequest = {
  filename: string;
  /**
   * A SHA-256 hash of the source code used to identify duplicate uploads.
   */
  codeHash: string;
};

/**
 * Response for noting a Pack source code upload is complete.
 */
export type PackSourceCodeUploadCompleteResponse = {
  /**
   * An arbitrary unique identifier for this request.
   */
  requestId: string;
};

/**
 * Information indicating where to upload the Pack source code, and an endpoint to mark the upload as complete.
 */
export type PackSourceCodeUploadInfo = {
  /**
   * A signed URL to be used for uploading a Pack source code.
   */
  uploadUrl: string;
  /**
   * An endpoint to mark the upload as complete.
   */
  uploadedPathName: string;
  /**
   * Key-value pairs of authorization headers to include in the upload request.
   */
  headers: {
    [key: string]: string;
  };
};

/**
 * Visibility of a pack's source code.
 */
export type PackSourceCodeVisibility = 'private' | 'shared';

/**
 * Determines how the Packs returned are sorted.
 */
export type PacksSortBy = 'title' | 'createdAt' | 'updatedAt';

/**
 * Summary of a Pack.
 */
export type PackSummary = {
  /**
   * ID of the Pack.
   */
  id: number;
  /**
   * The link to the logo of the Pack.
   */
  logoUrl?: string;
  /**
   * The link to the cover photo of the Pack.
   */
  coverUrl?: string;
  /**
   * The example images for the Pack.
   */
  exampleImages?: Array<PackImageFile>;
  /**
   * The parent workspace for the Pack.
   */
  workspaceId: string;
  /**
   * Publishing categories associated with this Pack.
   */
  categories: Array<PublishingCategory>;
  /**
   * Denotes if the pack is certified by Coda.
   */
  certified?: boolean;
  sourceCodeVisibility?: PackSourceCodeVisibility;
  /**
   * The name of the Pack.
   */
  name: string;
  /**
   * The full description of the Pack.
   */
  description: string;
  /**
   * A short version of the description of the Pack.
   */
  shortDescription: string;
  /**
   * A contact email for the Pack.
   */
  supportEmail?: string;
  /**
   * A Terms of Service URL for the Pack.
   */
  termsOfServiceUrl?: string;
  /**
   * A Privacy Policy URL for the Pack.
   */
  privacyPolicyUrl?: string;
};

/**
 * List of Pack summaries.
 */
export type PackSummaryList = {
  items: Array<PackSummary>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Credentials of a Pack connection.
 */
export type PackSystemConnectionCredentials =
  | PackConnectionHeaderCredentials
  | PackConnectionMultiHeaderCredentials
  | PackConnectionUrlParamCredentials
  | PackConnectionHttpBasicCredentials
  | PackConnectionCustomCredentials
  | PackConnectionOauth2ClientCredentials
  | PackConnectionGoogleServiceAccountCredentials;

/**
 * Metadata of a Pack system connection.
 */
export type PackSystemConnectionMetadata =
  | PackConnectionHeaderMetadata
  | PackConnectionMultiHeaderMetadata
  | PackConnectionUrlParamMetadata
  | PackConnectionHttpBasicMetadata
  | PackConnectionCustomMetadata
  | PackConnectionOauth2ClientCredentialsMetadata
  | PackConnectionGoogleServiceAccountMetadata;

/**
 * The access capabilities the current user has for this Pack.
 */
export type PackUserAccess = {
  canEdit: boolean;
  canTest: boolean;
  canView: boolean;
  canInstall: boolean;
  canPurchase: boolean;
  requiresTrial: boolean;
  canConnectAccount: boolean;
  organization?: PackOrganizationAccessForDocs | PackOrganizationAccessForCodaBrain;
};

export type PackUserPrincipal = {
  type: 'user';
  email: string;
};

/**
 * Details about a Pack version.
 */
export type PackVersion = {
  /**
   * ID of the Pack.
   */
  packId: number;
  /**
   * Developer notes.
   */
  buildNotes: string;
  /**
   * Timestamp for when the version was created.
   */
  createdAt: string;
  /**
   * The login ID of creation user of the Pack version.
   */
  creationUserLoginId: string;
  /**
   * The release number of the Pack version if it has one.
   */
  releaseId?: number;
  /**
   * The semantic format of the Pack version.
   */
  packVersion: string;
  /**
   * What Packs SDK version was this version built on.
   */
  sdkVersion?: string;
  source?: PackSource;
};

/**
 * Info about the diff between two Pack versions.
 */
export type PackVersionDiffs = {
  /**
   * List of changes from the previous version to the next version.
   */
  findings: Array<string>;
};

/**
 * List of Pack versions.
 */
export type PackVersionList = {
  items: Array<PackVersion>;
  creationUsers: Array<UserSummary>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Information indicating where to upload the Pack version definition.
 */
export type PackVersionUploadInfo = {
  /**
   * A URL to be used for uploading a Pack version definition.
   */
  uploadUrl: string;
  /**
   * Key-value pairs of authorization headers to include in the upload request.
   */
  headers: {
    [key: string]: string;
  };
};

export type PackWorkspacePrincipal = {
  type: 'workspace';
  workspaceId: string;
};

/**
 * Metadata about a page.
 */
export type Page = {
  /**
   * ID of the page.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'page';
  /**
   * API link to the page.
   */
  href: string;
  /**
   * Browser-friendly link to the page.
   */
  browserLink: string;
  /**
   * Name of the page.
   */
  name: string;
  /**
   * Subtitle of the page.
   */
  subtitle?: string;
  icon?: Icon;
  image?: Image;
  contentType: PageType;
  /**
   * Whether the page is hidden in the UI.
   */
  isHidden: boolean;
  /**
   * Whether the page or any of its parents is hidden in the UI.
   */
  isEffectivelyHidden: boolean;
  parent?: PageReference;
  children: Array<PageReference>;
  /**
   * Authors of the page
   */
  authors?: Array<PersonValue>;
  /**
   * Timestamp for when the page was created.
   */
  createdAt?: string;
  createdBy?: PersonValue;
  /**
   * Timestamp for when page content was last modified.
   */
  updatedAt?: string;
  updatedBy?: PersonValue;
};

/**
 * The type of this resource.
 */
export type type10 = 'page';

/**
 * List of analytics for pages within a Coda doc over a date range.
 */
export type PageAnalyticsCollection = {
  items: Array<PageAnalyticsItem>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Metadata about a page relevant to analytics.
 */
export type PageAnalyticsDetails = {
  /**
   * ID of the page.
   */
  id: string;
  /**
   * Name of the page.
   */
  name: string;
  icon?: Icon;
};

/**
 * Analytics data for a page within a Coda doc.
 */
export type PageAnalyticsItem = {
  page: PageAnalyticsDetails;
  metrics: Array<PageAnalyticsMetrics>;
};

/**
 * Analytics metrics for a page within a Coda doc.
 */
export type PageAnalyticsMetrics = {
  /**
   * Date of the analytics data.
   */
  date: string;
  /**
   * Number of times the page was viewed within the given day.
   */
  views: number;
  /**
   * Number of unique browsers that viewed the page on the given day.
   */
  sessions: number;
  /**
   * Number of unique Coda users that viewed the page on the given day.
   */
  users: number;
  /**
   * Average number of seconds that the page was viewed on the given day.
   */
  averageSecondsViewed: number;
  /**
   * Median number of seconds that the page was viewed on the given day.
   */
  medianSecondsViewed: number;
  /**
   * Number of unique tabs that opened the doc on the given day.
   */
  tabs: number;
};

/**
 * Content for a page (canvas).
 */
export type PageContent = {
  format: PageContentFormat;
  /**
   * The actual page content.
   */
  content: string;
};

/**
 * Status of a page content export.
 */
export type PageContentExportStatus = 'inProgress' | 'failed' | 'complete';

/**
 * Response when requesting the status of a page content export.
 */
export type PageContentExportStatusResponse = {
  /**
   * The identifier of this export request.
   */
  id: string;
  /**
   * The status of this export.
   */
  status: string;
  /**
   * The URL that reports the status of this export.
   */
  href: string;
  /**
   * Once the export completes, the location where the resulting export file can be downloaded; this link typically expires after a short time.  Call this method again to get a fresh link.
   */
  downloadLink?: string;
  /**
   * Message describing an error, if this export failed.
   */
  error?: string;
};

/**
 * Supported content types for page (canvas) content.
 */
export type PageContentFormat = 'html' | 'markdown';

/**
 * Mode for inserting content into an existing page.
 */
export type PageContentInsertionMode = 'append' | 'replace';

/**
 * Supported output content formats that can be requested for getting content for an existing page.
 */
export type PageContentOutputFormat = 'html' | 'markdown';

/**
 * Payload for updating the content of an existing page.
 */
export type PageContentUpdate = {
  insertionMode: PageContentInsertionMode;
  canvasContent: PageContent;
};

/**
 * Payload for creating a new page in a doc.
 */
export type PageCreate = {
  /**
   * Name of the page.
   */
  name?: string;
  /**
   * Subtitle of the page.
   */
  subtitle?: string;
  /**
   * Name of the icon.
   */
  iconName?: string;
  /**
   * Url of the cover image to use.
   */
  imageUrl?: string;
  /**
   * The ID of this new page's parent, if creating a subpage.
   */
  parentPageId?: string;
  pageContent?: PageCreateContent;
};

/**
 * Content that can be added to a page at creation time, either text (or rich text) or a URL to create a full-page embed.
 */
export type PageCreateContent =
  | {
      /**
       * Indicates a page containing canvas content.
       */
      type: 'canvas';
      canvasContent: PageContent;
    }
  | {
      /**
       * Indicates a page that embeds other content.
       */
      type: 'embed';
      /**
       * The URL of the content to embed.
       */
      url: string;
      renderMethod?: PageEmbedRenderMethod;
    }
  | {
      /**
       * Indicates a page that embeds other Coda content.
       */
      type: 'syncPage';
      /**
       * Indicates a single-page sync page.
       */
      mode: 'page';
      /**
       * Include subpages in the sync page.
       */
      includeSubpages: boolean;
      /**
       * The page id to insert as a sync page.
       */
      sourcePageId: string;
      /**
       * The id of the document to insert as a sync page.
       */
      sourceDocId: string;
    }
  | {
      /**
       * Indicates a page that embeds other content.
       */
      type: 'syncPage';
      /**
       * Indicates a full doc sync page.
       */
      mode: 'document';
      /**
       * The id of the document to insert as a sync page.
       */
      sourceDocId: string;
    };

/**
 * Indicates a page containing canvas content.
 */
export type type11 = 'canvas';

/**
 * Indicates a single-page sync page.
 */
export type mode = 'page';

/**
 * The result of a page creation.
 */
export type PageCreateResult = DocumentMutateResponse & {
  /**
   * ID of the created page.
   */
  id: string;
};

/**
 * The result of a page deletion.
 */
export type PageDeleteResult = DocumentMutateResponse & {
  /**
   * ID of the page to be deleted.
   */
  id: string;
};

/**
 * Render mode for a page using the Embed page type.
 */
export type PageEmbedRenderMethod = 'compatibility' | 'standard';

/**
 * List of pages.
 */
export type PageList = {
  items: Array<Page>;
  /**
   * API link to these results
   */
  href?: string;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Reference to a page.
 */
export type PageReference = {
  /**
   * ID of the page.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'page';
  /**
   * API link to the page.
   */
  href: string;
  /**
   * Browser-friendly link to the page.
   */
  browserLink: string;
  /**
   * Name of the page.
   */
  name: string;
};

/**
 * The type of a page in a doc.
 */
export type PageType = 'canvas' | 'embed' | 'syncPage';

/**
 * Payload for updating a page.
 */
export type PageUpdate = {
  /**
   * Name of the page.
   */
  name?: string;
  /**
   * Subtitle of the page.
   */
  subtitle?: string;
  /**
   * Name of the icon.
   */
  iconName?: string;
  /**
   * Url of the cover image to use.
   */
  imageUrl?: string;
  /**
   * Whether the page is hidden or not. Note that for pages that cannot be hidden, like the sole top-level page in a doc, this will be ignored.
   */
  isHidden?: boolean;
  contentUpdate?: {
    [key: string]: unknown;
  } & PageContentUpdate;
};

/**
 * The result of a page update.
 */
export type PageUpdateResult = DocumentMutateResponse & {
  /**
   * ID of the updated page.
   */
  id: string;
};

/**
 * Workspace feature set excluding free.
 */
export type PaidFeatureSet = 'Pro' | 'Team' | 'Enterprise';

/**
 * Semantic version of the previous Pack version.
 */
export type ParameterbasePackVersion = string;

/**
 * Name of a publishing category
 */
export type ParametercategoryName = string;

/**
 * ID or name of the column. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
 */
export type ParametercolumnIdOrName = string;

/**
 * ID or name of the control. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
 */
export type ParametercontrolIdOrName = string;

/**
 * A custom domain for a published doc.
 */
export type ParametercustomDocDomain = string;

/**
 * Direction to sort results in.
 */
export type Parameterdirection = SortDirection;

/**
 * Use this parameter to order the doc analytics returned.
 */
export type ParameterdocAnalyticsOrderBy = DocAnalyticsOrderBy;

/**
 * ID of the doc.
 */
export type ParameterdocId = string;

/**
 * List of docIds to fetch.
 */
export type ParameterdocIds = Array<string>;

/**
 * Do not include Packs that are only shared with the user individually.
 */
export type ParameterexcludeIndividualAcls = boolean;

/**
 * Only get Packs shared with users/workspaces, not publicly.
 */
export type ParameterexcludePublicPacks = boolean;

/**
 * Do not include Packs that are only shared with workspaces.
 */
export type ParameterexcludeWorkspaceAcls = boolean;

/**
 * ID or name of the formula. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
 */
export type ParameterformulaIdOrName = string;

/**
 * Show only members that have the included roles specified in a comma-separated list.
 */
export type ParameterincludedRoles = Array<WorkspaceUserRole>;

/**
 * ID of the ingestion execution.
 */
export type ParameteringestionExecutionId = string;

/**
 * Show only docs owned by the user.
 */
export type ParameterisOwner = boolean;

/**
 * Limit results to only published items.
 */
export type ParameterisPublished = boolean;

/**
 * Limit results to only published items. If false or unspecified, returns all items including published ones.
 *
 */
export type ParameterisPublishedNoDefault = boolean;

/**
 * Maximum number of results to return in this query.
 */
export type Parameterlimit = number;

/**
 * Email of a Coda user.
 */
export type ParameterloginId = string;

/**
 * Use only this workspace (not all of a user's workspaces) to check for Packs shared via workspace ACL.
 */
export type ParameteronlyWorkspaceId = string;

/**
 * ID of the organization.
 */
export type ParameterorganizationId = string;

/**
 * Pack access types.
 */
export type ParameterpackAccessTypes = PackAccessTypes;

/**
 * Use this parameter to order the Pack analytics returned.
 */
export type ParameterpackAnalyticsOrderBy = PackAnalyticsOrderBy;

/**
 * Unique identifier for a Pack asset.
 */
export type ParameterpackAssetId = string;

/**
 * Pack asset type.
 */
export type ParameterpackAssetType = PackAssetType;

/**
 * Use this parameter to order the Pack formula analytics returned.
 */
export type ParameterpackFormulaAnalyticsOrderBy = PackFormulaAnalyticsOrderBy;

/**
 * ID of a Pack
 */
export type ParameterpackId = number;

/**
 * Which Pack IDs to fetch.
 */
export type ParameterpackIds = Array<number>;

/**
 * ID of a Pack release
 */
export type ParameterpackReleaseId = number;

/**
 * Semantic version of a Pack
 */
export type ParameterpackVersion = string;

/**
 * ID or name of the page. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If you provide a name and there are multiple pages with the same name, an arbitrary one will be selected.
 *
 */
export type ParameterpageIdOrName = string;

/**
 * An opaque token used to fetch the next page of results.
 */
export type ParameterpageToken = string;

/**
 * Filter to only Packs whose parent workspace is one of the given IDs.
 */
export type ParameterparentWorkspaceIds = Array<string>;

/**
 * ID of a permission on a doc.
 */
export type ParameterpermissionId = string;

/**
 * Search term used to filter down results.
 */
export type Parameterquery = string;

/**
 * ID of the request.
 */
export type ParameterrequestId = string;

/**
 * ID of the root ingestion.
 */
export type ParameterrootIngestionId = string;

/**
 * ID or name of the row. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If there are multiple rows with the same value in the identifying column, an arbitrary one will be selected.
 *
 */
export type ParameterrowIdOrName = string;

/**
 * ID of the automation rule.
 */
export type ParameterruleId = string;

/**
 * Quantization period over which to view analytics. Defaults to daily.
 */
export type Parameterscale = AnalyticsScale;

/**
 * Limit results to activity on or after this date.
 */
export type ParametersinceDate = string;

/**
 * Determines how to sort the given objects.
 */
export type ParametersortBy = SortBy;

/**
 * An opaque token returned from a previous call that can be used to return results that are relevant to the query since the call where the syncToken was generated.
 *
 */
export type ParametersyncToken = string;

/**
 * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
 */
export type ParametertableIdOrName = string;

/**
 * Comma-separated list of table types to include in results. If omitted, includes both tables and views.
 */
export type ParametertableTypes = Array<TableType>;

/**
 * Semantic version of the new Pack version.
 */
export type ParametertargetPackVersion = string;

/**
 * Limit results to activity on or before this date.
 */
export type ParameteruntilDate = string;

/**
 * Use column names instead of column IDs in the returned output. This is generally discouraged as it is fragile. If columns are renamed, code using original names may throw errors.
 *
 */
export type ParameteruseColumnNames = boolean;

/**
 * ID or name of the view. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
 */
export type ParameterviewIdOrName = string;

/**
 * ID of the workspace.
 */
export type ParameterworkspaceId = string;

/**
 * ID of the workspace.
 */
export type ParameterworkspaceIdInQuery = string;

/**
 * The request to patch pack system connection credentials.
 */
export type PatchPackSystemConnectionRequest =
  | PackConnectionHeaderPatch
  | PackConnectionMultiHeaderPatch
  | PackConnectionUrlParamPatch
  | PackConnectionHttpBasicPatch
  | PackConnectionCustomPatch
  | PackConnectionOauth2ClientCredentialsPatch
  | PackConnectionGoogleServiceAccountPatch;

/**
 * A specific permission granted to a principal.
 */
export type Permission = {
  principal: Principal;
  /**
   * Id for the Permission
   */
  id: string;
  access: AccessType;
};

/**
 * A named reference to a person, where the person is identified by email address.
 */
export type PersonValue = LinkedDataObject & {
  /**
   * The full name of the person.
   */
  name: string;
  /**
   * The email address of the person.
   */
  email: string;
};

/**
 * Metadata about a principal.
 */
export type Principal = EmailPrincipal | GroupPrincipal | DomainPrincipal | WorkspacePrincipal | AnyonePrincipal;

/**
 * Type of principal.
 */
export type PrincipalType = 'email' | 'group' | 'domain' | 'workspace' | 'anyone';

/**
 * Info about a publishing category
 */
export type PublishingCategory = {
  /**
   * The ID for this category.
   */
  categoryId: string;
  /**
   * The name of the category.
   */
  categoryName: string;
  /**
   * The URL identifier of the category.
   */
  categorySlug?: string;
};

/**
 * The result of publishing a doc.
 */
export type PublishResult = DocumentMutateResponse & {
  [key: string]: unknown;
};

/**
 * The result of a push button.
 */
export type PushButtonResult = DocumentMutateResponse & {
  /**
   * ID of the row where the button exists.
   */
  rowId: string;
  /**
   * ID of the column where the button exists.
   */
  columnId: string;
};

/**
 * Format of a column that refers to another table.
 */
export type ReferenceColumnFormat = SimpleColumnFormat & {
  table: unknown & TableReference;
};

/**
 * Payload for registering a Pack version.
 */
export type RegisterPackVersionRequest = {
  /**
   * The SHA-256 hash of the file to be uploaded.
   */
  bundleHash: string;
};

/**
 * A value that contains rich structured data. Cell values are composed of these values or arrays of these values.
 *
 */
export type RichSingleValue = ScalarValue | CurrencyValue | ImageUrlValue | PersonValue | UrlValue | RowValue;

/**
 * A cell value that contains rich structured data.
 */
export type RichValue = RichSingleValue | Array<RichSingleValue | Array<RichSingleValue>>;

/**
 * Info about a row.
 */
export type Row = {
  /**
   * ID of the row.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'row';
  /**
   * API link to the row.
   */
  href: string;
  /**
   * The display name of the row, based on its identifying column.
   */
  name: string;
  /**
   * Index of the row within the table.
   */
  index: number;
  /**
   * Browser-friendly link to the row.
   */
  browserLink: string;
  /**
   * Timestamp for when the row was created.
   */
  createdAt: string;
  /**
   * Timestamp for when the row was last modified.
   */
  updatedAt: string;
  /**
   * Values for a specific row, represented as a hash of column IDs (or names with `useColumnNames`) to values.
   *
   */
  values: {
    [key: string]: CellValue;
  };
};

/**
 * The type of this resource.
 */
export type type12 = 'row';

/**
 * The result of a row deletion.
 */
export type RowDeleteResult = DocumentMutateResponse & {
  /**
   * ID of the row to be deleted.
   */
  id: string;
};

/**
 * Details about a row.
 */
export type RowDetail = {
  /**
   * ID of the row.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'row';
  /**
   * API link to the row.
   */
  href: string;
  /**
   * The display name of the row, based on its identifying column.
   */
  name: string;
  /**
   * Index of the row within the table.
   */
  index: number;
  /**
   * Browser-friendly link to the row.
   */
  browserLink: string;
  /**
   * Timestamp for when the row was created.
   */
  createdAt: string;
  /**
   * Timestamp for when the row was last modified.
   */
  updatedAt: string;
  /**
   * Values for a specific row, represented as a hash of column IDs (or names with `useColumnNames`) to values.
   *
   */
  values: {
    [key: string]: CellValue;
  };
  parent: TableReference;
};

/**
 * An edit made to a particular row.
 */
export type RowEdit = {
  cells: Array<CellEdit>;
};

/**
 * List of rows.
 */
export type RowList = {
  items: Array<Row>;
  /**
   * API link to these results
   */
  href?: string;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
  nextSyncToken?: nextSyncToken;
};

/**
 * Payload for deleting rows from a table.
 */
export type RowsDelete = {
  /**
   * Row IDs to delete.
   *
   */
  rowIds: Array<string>;
};

/**
 * The result of a rows delete operation.
 */
export type RowsDeleteResult = DocumentMutateResponse & {
  /**
   * Row IDs to delete.
   */
  rowIds: Array<string>;
};

/**
 * Determines how the rows returned are sorted
 */
export type RowsSortBy = 'createdAt' | 'natural' | 'updatedAt';

/**
 * Payload for upserting rows in a table.
 */
export type RowsUpsert = {
  rows: Array<RowEdit>;
  /**
   * Optional column IDs, URLs, or names (fragile and discouraged), specifying columns to be used as upsert keys.
   */
  keyColumns?: Array<string>;
};

/**
 * The result of a rows insert/upsert operation.
 */
export type RowsUpsertResult = DocumentMutateResponse & {
  /**
   * Row IDs for rows that will be added. Only applicable when keyColumns is not set or empty.
   */
  addedRowIds?: Array<string>;
};

/**
 * Payload for updating a row in a table.
 */
export type RowUpdate = {
  row: RowEdit;
};

/**
 * The result of a row update.
 */
export type RowUpdateResult = DocumentMutateResponse & {
  /**
   * ID of the updated row.
   */
  id: string;
};

/**
 * A value representing a Coda row.
 */
export type RowValue = LinkedDataObject & {
  /**
   * The display name of the row, based on its identifying column.
   */
  name: string;
  /**
   * The url of the row.
   */
  url: string;
  /**
   * The ID of the table
   */
  tableId: string;
  /**
   * The ID of the table
   */
  rowId: string;
  /**
   * The url of the table.
   */
  tableUrl: string;
  /**
   * The type of this resource.
   */
  additionalType: 'row';
};

/**
 * The type of this resource.
 */
export type additionalType = 'row';

/**
 * A Coda result or entity expressed as a primitive type.
 */
export type ScalarValue = string | number | boolean;

/**
 * Format of a numeric column that renders as a scale, like star ratings.
 */
export type ScaleColumnFormat = SimpleColumnFormat & {
  /**
   * The maximum number allowed for this scale.
   */
  maximum: number;
  icon: unknown & IconSet;
};

/**
 * Metadata about the principals that match the given query.
 */
export type SearchPrincipalsResponse = {
  users: Array<UserSummary>;
  groups: Array<GroupPrincipal>;
};

/**
 * Format of a select column.
 */
export type SelectColumnFormat = SimpleColumnFormat & {
  [key: string]: unknown;
};

/**
 * An option for a select column.
 */
export type SelectOption = {
  /**
   * The name of the option.
   */
  name: string;
  /**
   * The background color of the option.
   */
  backgroundColor?: string;
  /**
   * The foreground color of the option.
   */
  foregroundColor?: string;
};

/**
 * Request to set the Pack OAuth configuration.
 */
export type SetPackOauthConfigRequest = {
  clientId?: string;
  clientSecret?: string;
  redirectUri?: string;
};

/**
 * The request to set pack system connection credentials.
 */
export type SetPackSystemConnectionRequest = {
  credentials: PackSystemConnectionCredentials;
};

/**
 * Format of a simple column.
 */
export type SimpleColumnFormat = {
  type: 'other';
  /**
   * Whether or not this column is an array.
   */
  isArray: boolean;
};

/**
 * Format of a numeric column that renders as a slider.
 */
export type SliderColumnFormat = SimpleColumnFormat & {
  minimum?: unknown & NumberOrNumberFormula;
  maximum?: unknown & NumberOrNumberFormula;
  step?: unknown & NumberOrNumberFormula;
  displayType?: SliderDisplayType;
  /**
   * Whether the underyling numeric value is also displayed.
   */
  showValue?: boolean;
};

/**
 * How the slider should be rendered.
 */
export type SliderDisplayType = 'slider' | 'progress';

/**
 * A sort applied to a table or view.
 */
export type Sort = {
  column: ColumnReference;
  direction: SortDirection;
};

/**
 * Determines how the objects returned are sorted
 */
export type SortBy = 'name';

/**
 * Direction of a sort for a table or view.
 */
export type SortDirection = 'ascending' | 'descending';

/**
 * The Pack plan to show the Pack can be subscribed to at a monthly cost per Doc Maker or for free.
 */
export type StandardPackPlan = {
  packPlanId: string;
  packId: number;
  /**
   * Pricing to show how workspaces can subscribe to the Pack.
   */
  pricing: FreePackPlanPricing | MonthlyDocMakerPackPlanPricing;
  /**
   * Timestamp for when the Pack plan was created.
   */
  createdAt: string;
};

/**
 * The type of sync page in a doc
 */
export type SyncPageType = 'page' | 'document';

/**
 * Metadata about a table.
 */
export type Table = {
  /**
   * ID of the table.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'table';
  tableType: TableType;
  /**
   * API link to the table.
   */
  href: string;
  /**
   * Browser-friendly link to the table.
   */
  browserLink: string;
  /**
   * Name of the table.
   */
  name: string;
  parent: PageReference;
  parentTable?: TableReference;
  displayColumn: ColumnReference;
  /**
   * Total number of rows in the table.
   */
  rowCount: number;
  /**
   * Any sorts applied to the table.
   */
  sorts: Array<Sort>;
  layout: Layout;
  filter?: unknown & FormulaDetail;
  /**
   * Timestamp for when the table was created.
   */
  createdAt: string;
  /**
   * Timestamp for when the table was last modified.
   */
  updatedAt: string;
};

/**
 * The type of this resource.
 */
export type type13 = 'table';

/**
 * List of tables.
 */
export type TableList = {
  items: Array<TableReference>;
  /**
   * API link to these results
   */
  href?: string;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

/**
 * Reference to a table or view.
 */
export type TableReference = {
  /**
   * ID of the table.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'table';
  tableType: TableType;
  /**
   * API link to the table.
   */
  href: string;
  /**
   * Browser-friendly link to the table.
   */
  browserLink: string;
  /**
   * Name of the table.
   */
  name: string;
  parent?: PageReference;
};

export type TableType = 'table' | 'view';

/**
 * Format of a time column.
 */
export type TimeColumnFormat = SimpleColumnFormat & {
  /**
   * A format string using Moment syntax: https://momentjs.com/docs/#/displaying/
   */
  format?: string;
};

/**
 * A constant identifying the type of the resource.
 */
export type Type =
  | 'aclMetadata'
  | 'aclPermissions'
  | 'aclSettings'
  | 'analyticsLastUpdated'
  | 'apiLink'
  | 'automation'
  | 'column'
  | 'control'
  | 'doc'
  | 'customDocDomain'
  | 'customDocDomainProvider'
  | 'docAnalytics'
  | 'docAnalyticsSummary'
  | 'docAnalyticsV2'
  | 'folder'
  | 'formula'
  | 'mutationStatus'
  | 'pack'
  | 'packAclPermissions'
  | 'packAnalytics'
  | 'packAnalyticsSummary'
  | 'packAsset'
  | 'packCategory'
  | 'packConfigurationSchema'
  | 'packFeaturedDocs'
  | 'packFormulaAnalytics'
  | 'packLog'
  | 'packMaker'
  | 'packOauthConfig'
  | 'packRelease'
  | 'packSourceCode'
  | 'packSystemConnection'
  | 'packVersion'
  | 'page'
  | 'pageContentExport'
  | 'pageContentExportStatus'
  | 'principal'
  | 'row'
  | 'table'
  | 'user'
  | 'workspace';

/**
 * The result of unpublishing a doc.
 */
export type UnpublishResult = {
  [key: string]: unknown;
};

/**
 * Request to update ACL settings for a doc.
 */
export type UpdateAclSettingsRequest = {
  /**
   * When true, allows editors to change doc permissions. When false, only doc owner can change doc permissions.
   *
   */
  allowEditorsToChangePermissions?: boolean;
  /**
   * When true, allows doc viewers to copy the doc.
   */
  allowCopying?: boolean;
  /**
   * When true, allows doc viewers to request editing permissions.
   */
  allowViewersToRequestEditing?: boolean;
};

/**
 * Payload for updating the properties of a custom published doc domain.
 */
export type UpdateCustomDocDomainRequest = {
  [key: string]: unknown;
};

/**
 * The result of updating a custom domain for a published doc.
 */
export type UpdateCustomDocDomainResponse = {
  [key: string]: unknown;
};

/**
 * Payload for updating featured docs for a Pack.
 */
export type UpdatePackFeaturedDocsRequest = {
  /**
   * A list of docs to set as the featured docs for a Pack.
   */
  items: Array<PackFeaturedDocRequestItem>;
};

/**
 * Confirmation of successful Pack featured docs update.
 */
export type UpdatePackFeaturedDocsResponse = {
  [key: string]: unknown;
};

/**
 * Payload for updating a new Pack release.
 */
export type UpdatePackReleaseRequest = {
  /**
   * Notes about key features or changes in this release that the Pack maker wants to communicate to users.
   */
  releaseNotes?: string;
};

/**
 * Payload for updating a Pack.
 */
export type UpdatePackRequest = {
  /**
   * Rate limit in Pack settings.
   */
  overallRateLimit?: {
    /**
     * The rate limit interval in seconds.
     */
    intervalSeconds: number;
    /**
     * The maximum number of Pack operations that can be performed in a given interval.
     */
    operationsPerInterval: number;
  } | null;
  /**
   * Rate limit in Pack settings.
   */
  perConnectionRateLimit?: {
    /**
     * The rate limit interval in seconds.
     */
    intervalSeconds: number;
    /**
     * The maximum number of Pack operations that can be performed in a given interval.
     */
    operationsPerInterval: number;
  } | null;
  /**
   * The asset id of the Pack's logo, returned by [`#PackAssetUploadComplete`](#operation/packAssetUploadComplete) endpoint.
   */
  logoAssetId?: string | null;
  /**
   * The asset id of the Pack's cover image, returned by [`#PackAssetUploadComplete`](#operation/packAssetUploadComplete) endpoint.
   */
  coverAssetId?: string | null;
  /**
   * The example images for the Pack.
   */
  exampleImages?: Array<{
    /**
     * The asset id of the Pack's example image, returned by [`#PackAssetUploadComplete`](#operation/packAssetUploadComplete) endpoint.
     */
    assetId: string;
    /**
     * The filename for the image.
     */
    filename: string;
    /**
     * The media type of the image being sent.
     */
    mimeType?: string;
  }> | null;
  sourceCodeVisibility?: PackSourceCodeVisibility | null;
  /**
   * The name of the Pack.
   */
  name?: string;
  /**
   * The full description of the Pack.
   */
  description?: string;
  /**
   * A short version of the description of the Pack.
   */
  shortDescription?: string;
  /**
   * A contact email for the Pack.
   */
  supportEmail?: string;
  /**
   * A Terms of Service URL for the Pack.
   */
  termsOfServiceUrl?: string;
  /**
   * A Privacy Policy URL for the Pack.
   */
  privacyPolicyUrl?: string;
};

/**
 * Payload for a Pack asset upload.
 */
export type UploadPackAssetRequest = {
  packAssetType: PackAssetType;
  /**
   * The SHA-256 hash of the image to be uploaded.
   */
  imageHash: string;
  /**
   * The media type of the image being sent.
   */
  mimeType: string;
  filename: string;
};

/**
 * Payload for a Pack asset upload.
 */
export type UploadPackSourceCodeRequest = {
  /**
   * The SHA-256 hash of the image to be uploaded.
   */
  payloadHash: string;
  filename: string;
  packVersion?: string;
};

/**
 * A named hyperlink to an arbitrary url.
 */
export type UrlValue = LinkedDataObject & {
  /**
   * The user-visible text of the hyperlink.
   */
  name?: string;
  /**
   * The url of the hyperlink.
   */
  url: string;
};

/**
 * Info about the user.
 */
export type User = {
  /**
   * Name of the user.
   */
  name: string;
  /**
   * Email address of the user.
   */
  loginId: string;
  /**
   * The type of this resource.
   */
  type: 'user';
  /**
   * Browser-friendly link to the user's avatar image.
   */
  pictureLink?: string;
  /**
   * True if the token used to make this request has restricted/scoped access to the API.
   */
  scoped: boolean;
  /**
   * Returns the name of the token used for this request.
   */
  tokenName: string;
  /**
   * API link to the user.
   */
  href: string;
  workspace: WorkspaceReference;
};

/**
 * The type of this resource.
 */
export type type14 = 'user';

/**
 * Summary about the user.
 */
export type UserSummary = {
  /**
   * Name of the user.
   */
  name: string;
  /**
   * Email address of the user.
   */
  loginId: string;
  /**
   * The type of this resource.
   */
  type: 'user';
  /**
   * Browser-friendly link to the user's avatar image.
   */
  pictureLink?: string;
};

/**
 * Detail about why a particular field failed request validation.
 */
export type ValidationError = {
  /**
   * A path indicating the affected field, in OGNL notation.
   */
  path: string;
  /**
   * An error message.
   */
  message: string;
};

/**
 * A Coda result or entity expressed as a primitive type, or array of primitive types.
 */
export type Value = ScalarValue | Array<ScalarValue | Array<ScalarValue>>;

/**
 * The format that cell values are returned as.
 */
export type ValueFormat = 'simple' | 'simpleWithArrays' | 'rich';

/**
 * Payload for webhook trigger
 */
export type WebhookTriggerPayload = {
  [key: string]: unknown;
};

/**
 * The result of triggering a webhook
 */
export type WebhookTriggerResult = DocumentMutateResponse & {
  [key: string]: unknown;
};

/**
 * Metadata about a Coda workspace.
 */
export type Workspace = {
  /**
   * ID of the Coda workspace.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'workspace';
  /**
   * ID of the organization bound to this workspace, if any.
   */
  organizationId?: string;
  /**
   * Browser-friendly link to the Coda workspace.
   */
  browserLink: string;
  /**
   * Name of the workspace.
   */
  name: string;
  /**
   * Description of the workspace.
   */
  description?: string;
};

/**
 * The type of this resource.
 */
export type type15 = 'workspace';

/**
 * Response for listing workspace users.
 */
export type WorkspaceMembersList = {
  items: Array<WorkspaceUser>;
  nextPageToken?: nextPageToken;
  nextPageLink?: nextPageLink & string;
};

export type WorkspacePrincipal = {
  /**
   * The type of this principal.
   */
  type: 'workspace';
  /**
   * WorkspaceId for the principal.
   */
  workspaceId: string;
};

/**
 * Reference to a Coda workspace.
 */
export type WorkspaceReference = {
  /**
   * ID of the Coda workspace.
   */
  id: string;
  /**
   * The type of this resource.
   */
  type: 'workspace';
  /**
   * ID of the organization bound to this workspace, if any.
   */
  organizationId?: string;
  /**
   * Browser-friendly link to the Coda workspace.
   */
  browserLink: string;
  /**
   * Name of the workspace; included if the user has access to the workspace.
   */
  name?: string;
};

/**
 * Metadata for workspace role activity.
 */
export type WorkspaceRoleActivity = {
  /**
   * Month corresponding to the data.
   */
  month: string;
  /**
   * Number of active Admins.
   */
  activeAdminCount: number;
  /**
   * Number of active Doc Makers.
   */
  activeDocMakerCount: number;
  /**
   * Number of active Editors.
   */
  activeEditorCount: number;
  /**
   * Number of inactive Admins.
   */
  inactiveAdminCount: number;
  /**
   * Number of inactive Doc Makers.
   */
  inactiveDocMakerCount: number;
  /**
   * Number of inactive Editor users.
   */
  inactiveEditorCount: number;
};

/**
 * Metadata of a workspace user.
 */
export type WorkspaceUser = {
  /**
   * Email of the user.
   */
  email: string;
  /**
   * Name of the user.
   */
  name: string;
  role: WorkspaceUserRole;
  /**
   * Picture url of the user.
   */
  pictureUrl?: string;
  /**
   * Timestamp for when the user registered in this workspace
   */
  registeredAt: string;
  /**
   * Timestamp for when the user's role last changed in this workspace.
   */
  roleChangedAt?: string;
  /**
   * Date when the user last took an action in any workspace.
   */
  lastActiveAt?: string;
  /**
   * Number of docs the user owns in this workspace.
   */
  ownedDocs?: number;
  /**
   * Date when anyone last accessed a doc that the user owns in this workspace.
   */
  docsLastActiveAt?: string;
  /**
   * Number of collaborators that have interacted with docs owned by the user in the last 90 days.
   */
  docCollaboratorCount?: number;
  /**
   * Number of docs the user owns, manages, or to which they have added pages in the last 90 days.
   */
  totalDocs?: number;
  /**
   * Date when anyone last accessed a doc the member owns or contributed to.
   */
  totalDocsLastActiveAt?: string;
  /**
   * Number of unique users that have viewed any doc the user owns, manages, or has added pages to in the last 90 days.
   */
  totalDocCollaboratorsLast90Days?: number;
};

export type WorkspaceUserRole = 'Admin' | 'DocMaker' | 'Editor';

export type ListCategoriesResponse = DocCategoryList;

export type ListCategoriesError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListDocsData = {
  query?: {
    /**
     * Show only docs belonging to the given folder.
     */
    folderId?: string;
    /**
     * Show only docs visible within the gallery.
     */
    inGallery?: boolean;
    /**
     * Show only docs owned by the user.
     */
    isOwner?: boolean;
    /**
     * Show only published docs.
     */
    isPublished?: boolean;
    /**
     * If true, returns docs that are starred. If false, returns docs that are not starred.
     */
    isStarred?: boolean;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Search term used to filter down results.
     */
    query?: string;
    /**
     * Show only docs copied from the specified doc ID.
     */
    sourceDoc?: string;
    /**
     * Show only docs belonging to the given workspace.
     */
    workspaceId?: string;
  };
};

export type ListDocsResponse = DocList;

export type ListDocsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type CreateDocData = {
  /**
   * Parameters for creating the doc.
   */
  body: DocCreate;
};

export type CreateDocResponse = DocumentCreationResult;

export type CreateDocError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetDocData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type GetDocResponse = Doc;

export type GetDocError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type DeleteDocData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type DeleteDocResponse = DocDelete;

export type DeleteDocError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type UpdateDocData = {
  /**
   * Parameters for updating the doc.
   */
  body: DocUpdate;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type UpdateDocResponse = DocUpdateResult;

export type UpdateDocError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetSharingMetadataData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type GetSharingMetadataResponse = AclMetadata;

export type GetSharingMetadataError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetPermissionsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
  };
};

export type GetPermissionsResponse = Acl;

export type GetPermissionsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type AddPermissionData = {
  /**
   * Parameters for adding the new permission.
   */
  body: AddPermissionRequest;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type AddPermissionResponse = AddPermissionResult;

export type AddPermissionError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type DeletePermissionData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID of a permission on a doc.
     */
    permissionId: string;
  };
};

export type DeletePermissionResponse = DeletePermissionResult;

export type DeletePermissionError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type SearchPrincipalsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
  query?: {
    /**
     * Search term used to filter down results.
     */
    query?: string;
  };
};

export type SearchPrincipalsResponse2 = SearchPrincipalsResponse;

export type SearchPrincipalsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetAclSettingsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type GetAclSettingsResponse = AclSettings;

export type GetAclSettingsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type UpdateAclSettingsData = {
  /**
   * Parameters for updating the ACL settings.
   */
  body: UpdateAclSettingsRequest;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type UpdateAclSettingsResponse = AclSettings;

export type UpdateAclSettingsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type PublishDocData = {
  /**
   * Parameters for changing publish settings.
   */
  body: DocPublish;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type PublishDocResponse = PublishResult;

export type PublishDocError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type UnpublishDocData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type UnpublishDocResponse = UnpublishResult;

export type UnpublishDocError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListPagesData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
  };
};

export type ListPagesResponse = PageList;

export type ListPagesError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type CreatePageData = {
  /**
   * Parameters for creating a page.
   */
  body: PageCreate;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type CreatePageResponse = PageCreateResult;

export type CreatePageError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetPageData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the page. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If you provide a name and there are multiple pages with the same name, an arbitrary one will be selected.
     *
     */
    pageIdOrName: string;
  };
};

export type GetPageResponse = Page;

export type GetPageError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type UpdatePageData = {
  /**
   * Parameters for updating a page.
   */
  body: PageUpdate;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the page. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If you provide a name and there are multiple pages with the same name, an arbitrary one will be selected.
     *
     */
    pageIdOrName: string;
  };
};

export type UpdatePageResponse = PageUpdateResult;

export type UpdatePageError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type DeletePageData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the page. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If you provide a name and there are multiple pages with the same name, an arbitrary one will be selected.
     *
     */
    pageIdOrName: string;
  };
};

export type DeletePageResponse = PageDeleteResult;

export type DeletePageError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type BeginPageContentExportData = {
  /**
   * Parameters for requesting a page content export.
   */
  body: BeginPageContentExportRequest;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the page. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If you provide a name and there are multiple pages with the same name, an arbitrary one will be selected.
     *
     */
    pageIdOrName: string;
  };
};

export type BeginPageContentExportResponse2 = BeginPageContentExportResponse;

export type BeginPageContentExportError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetPageContentExportStatusData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the page. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If you provide a name and there are multiple pages with the same name, an arbitrary one will be selected.
     *
     */
    pageIdOrName: string;
    /**
     * ID of the request.
     */
    requestId: string;
  };
};

export type GetPageContentExportStatusResponse = PageContentExportStatusResponse;

export type GetPageContentExportStatusError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListTablesData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Determines how to sort the given objects.
     */
    sortBy?: SortBy;
    /**
     * Comma-separated list of table types to include in results. If omitted, includes both tables and views.
     */
    tableTypes?: Array<TableType>;
  };
};

export type ListTablesResponse = TableList;

export type ListTablesError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetTableData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
  query?: {
    /**
     * Return "detail" and "form" for the `layout` field of detail and form layouts respectively (instead of "masterDetail" for both)
     */
    useUpdatedTableLayouts?: boolean;
  };
};

export type GetTableResponse = Table;

export type GetTableError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListColumnsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * If true, returns only visible columns for the table. This parameter only applies to base tables, and not views.
     */
    visibleOnly?: boolean;
  };
};

export type ListColumnsResponse = ColumnList;

export type ListColumnsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListRowsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Query used to filter returned rows, specified as `<column_id_or_name>:<value>`. If you'd like to use a column name instead of an ID, you must quote it (e.g., `"My Column":123`). Also note that `value` is a JSON value; if you'd like to use a string, you must surround it in quotes (e.g., `"groceries"`).
     *
     */
    query?: string;
    /**
     * Specifies the sort order of the rows returned. If left unspecified, rows are returned by creation time ascending. "UpdatedAt" sort ordering is the order of rows based upon when they were last updated. This does not include updates to calculated values. "Natural" sort ordering is the order that the rows appear in the table view in the application. This ordering is only meaningfully defined for rows that are visible (unfiltered). Because of this, using this sort order will imply visibleOnly=true, that is, to only return visible rows. If you pass sortBy=natural and visibleOnly=false explicitly, this will result in a Bad Request error as this condition cannot be satisfied.
     *
     */
    sortBy?: RowsSortBy;
    /**
     * An opaque token returned from a previous call that can be used to return results that are relevant to the query since the call where the syncToken was generated.
     *
     */
    syncToken?: string;
    /**
     * Use column names instead of column IDs in the returned output. This is generally discouraged as it is fragile. If columns are renamed, code using original names may throw errors.
     *
     */
    useColumnNames?: boolean;
    /**
     * The format that cell values are returned as.
     */
    valueFormat?: ValueFormat;
    /**
     * If true, returns only visible rows and columns for the table.
     */
    visibleOnly?: boolean;
  };
};

export type ListRowsResponse = RowList;

export type ListRowsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type UpsertRowsData = {
  /**
   * Rows to insert or upsert.
   */
  body: RowsUpsert;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
  query?: {
    /**
     * If true, the API will not attempt to parse the data in any way.
     */
    disableParsing?: boolean;
  };
};

export type UpsertRowsResponse = RowsUpsertResult;

export type UpsertRowsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type DeleteRowsData = {
  /**
   * Rows to delete.
   */
  body: RowsDelete;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
};

export type DeleteRowsResponse = RowsDeleteResult;

export type DeleteRowsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetRowData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the row. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If there are multiple rows with the same value in the identifying column, an arbitrary one will be selected.
     *
     */
    rowIdOrName: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
  query?: {
    /**
     * Use column names instead of column IDs in the returned output. This is generally discouraged as it is fragile. If columns are renamed, code using original names may throw errors.
     *
     */
    useColumnNames?: boolean;
    /**
     * The format that cell values are returned as.
     */
    valueFormat?: ValueFormat;
  };
};

export type GetRowResponse = RowDetail;

export type GetRowError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type UpdateRowData = {
  /**
   * Row update.
   */
  body: RowUpdate;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the row. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If there are multiple rows with the same value in the identifying column, an arbitrary one will be selected.
     *
     */
    rowIdOrName: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
  query?: {
    /**
     * If true, the API will not attempt to parse the data in any way.
     */
    disableParsing?: boolean;
  };
};

export type UpdateRowResponse = RowUpdateResult;

export type UpdateRowError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type DeleteRowData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the row. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If there are multiple rows with the same value in the identifying column, an arbitrary one will be selected.
     *
     */
    rowIdOrName: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
};

export type DeleteRowResponse = RowDeleteResult;

export type DeleteRowError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type PushButtonData = {
  path: {
    /**
     * ID or name of the column. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    columnIdOrName: string;
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the row. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it. If there are multiple rows with the same value in the identifying column, an arbitrary one will be selected.
     *
     */
    rowIdOrName: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
};

export type PushButtonResponse = PushButtonResult;

export type PushButtonError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetColumnData = {
  path: {
    /**
     * ID or name of the column. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    columnIdOrName: string;
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the table. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    tableIdOrName: string;
  };
};

export type GetColumnResponse = ColumnDetail;

export type GetColumnError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListFormulasData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Determines how to sort the given objects.
     */
    sortBy?: SortBy;
  };
};

export type ListFormulasResponse = FormulaList;

export type ListFormulasError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetFormulaData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID or name of the formula. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    formulaIdOrName: string;
  };
};

export type GetFormulaResponse = Formula;

export type GetFormulaError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListControlsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Determines how to sort the given objects.
     */
    sortBy?: SortBy;
  };
};

export type ListControlsResponse = ControlList;

export type ListControlsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetControlData = {
  path: {
    /**
     * ID or name of the control. Names are discouraged because they're easily prone to being changed by users. If you're using a name, be sure to URI-encode it.
     */
    controlIdOrName: string;
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type GetControlResponse = Control;

export type GetControlError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListCustomDocDomainsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type ListCustomDocDomainsResponse = CustomDocDomainList;

export type ListCustomDocDomainsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type AddCustomDocDomainData = {
  /**
   * Parameters for adding a custom domain to a published doc.
   */
  body: AddCustomDocDomainRequest;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type AddCustomDocDomainResponse2 = AddCustomDocDomainResponse;

export type AddCustomDocDomainError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type DeleteCustomDocDomainData = {
  path: {
    /**
     * A custom domain for a published doc.
     */
    customDocDomain: string;
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type DeleteCustomDocDomainResponse2 = DeleteCustomDocDomainResponse;

export type DeleteCustomDocDomainError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type UpdateCustomDocDomainData = {
  /**
   * Properties of a custom domain to update.
   */
  body: UpdateCustomDocDomainRequest;
  path: {
    /**
     * A custom domain for a published doc.
     */
    customDocDomain: string;
    /**
     * ID of the doc.
     */
    docId: string;
  };
};

export type UpdateCustomDocDomainResponse2 = UpdateCustomDocDomainResponse;

export type UpdateCustomDocDomainError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetCustomDocDomainProviderData = {
  path: {
    /**
     * A custom domain for a published doc.
     */
    customDocDomain: string;
  };
};

export type GetCustomDocDomainProviderResponse = CustomDocDomainProviderResponse;

export type GetCustomDocDomainProviderError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type WhoamiResponse = User;

export type WhoamiError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ResolveBrowserLinkData = {
  query: {
    /**
     * By default, attempting to resolve the Coda URL of a deleted object will result in an error. If this flag is set, the next-available object, all the way up to the doc itself, will be resolved.
     *
     */
    degradeGracefully?: boolean;
    /**
     * The browser link to try to resolve.
     */
    url: string;
  };
};

export type ResolveBrowserLinkResponse = ApiLink;

export type ResolveBrowserLinkError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetMutationStatusData = {
  path: {
    /**
     * ID of the request.
     */
    requestId: string;
  };
};

export type GetMutationStatusResponse = MutationStatus;

export type GetMutationStatusError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type TriggerWebhookAutomationData = {
  /**
   * Payload for webhook
   */
  body?: WebhookTriggerPayload;
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID of the automation rule.
     */
    ruleId: string;
  };
};

export type TriggerWebhookAutomationResponse = WebhookTriggerResult;

export type TriggerWebhookAutomationError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListDocAnalyticsData = {
  query?: {
    /**
     * Direction to sort results in.
     */
    direction?: SortDirection;
    /**
     * List of docIds to fetch.
     */
    docIds?: Array<string>;
    /**
     * Limit results to only published items.
     */
    isPublished?: boolean;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Use this parameter to order the doc analytics returned.
     */
    orderBy?: DocAnalyticsOrderBy;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Search term used to filter down results.
     */
    query?: string;
    /**
     * Quantization period over which to view analytics. Defaults to daily.
     */
    scale?: AnalyticsScale;
    /**
     * Limit results to activity on or after this date.
     */
    sinceDate?: string;
    /**
     * Limit results to activity on or before this date.
     */
    untilDate?: string;
    /**
     * ID of the workspace.
     */
    workspaceId?: string;
  };
};

export type ListDocAnalyticsResponse = DocAnalyticsCollection;

export type ListDocAnalyticsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListPageAnalyticsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Limit results to activity on or after this date.
     */
    sinceDate?: string;
    /**
     * Limit results to activity on or before this date.
     */
    untilDate?: string;
  };
};

export type ListPageAnalyticsResponse = PageAnalyticsCollection;

export type ListPageAnalyticsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListDocAnalyticsSummaryData = {
  query?: {
    /**
     * Limit results to only published items.
     */
    isPublished?: boolean;
    /**
     * Limit results to activity on or after this date.
     */
    sinceDate?: string;
    /**
     * Limit results to activity on or before this date.
     */
    untilDate?: string;
    /**
     * ID of the workspace.
     */
    workspaceId?: string;
  };
};

export type ListDocAnalyticsSummaryResponse = DocAnalyticsSummary;

export type ListDocAnalyticsSummaryError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListPackAnalyticsData = {
  query?: {
    /**
     * Direction to sort results in.
     */
    direction?: SortDirection;
    /**
     * Limit results to only published items. If false or unspecified, returns all items including published ones.
     *
     */
    isPublished?: boolean;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Use this parameter to order the Pack analytics returned.
     */
    orderBy?: PackAnalyticsOrderBy;
    /**
     * Which Pack IDs to fetch.
     */
    packIds?: Array<number>;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Search term used to filter down results.
     */
    query?: string;
    /**
     * Quantization period over which to view analytics. Defaults to daily.
     */
    scale?: AnalyticsScale;
    /**
     * Limit results to activity on or after this date.
     */
    sinceDate?: string;
    /**
     * Limit results to activity on or before this date.
     */
    untilDate?: string;
    /**
     * ID of the workspace.
     */
    workspaceId?: string;
  };
};

export type ListPackAnalyticsResponse = PackAnalyticsCollection;

export type ListPackAnalyticsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListPackAnalyticsSummaryData = {
  query?: {
    /**
     * Limit results to only published items. If false or unspecified, returns all items including published ones.
     *
     */
    isPublished?: boolean;
    /**
     * Which Pack IDs to fetch.
     */
    packIds?: Array<number>;
    /**
     * Limit results to activity on or after this date.
     */
    sinceDate?: string;
    /**
     * Limit results to activity on or before this date.
     */
    untilDate?: string;
    /**
     * ID of the workspace.
     */
    workspaceId?: string;
  };
};

export type ListPackAnalyticsSummaryResponse = PackAnalyticsSummary;

export type ListPackAnalyticsSummaryError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListPackFormulaAnalyticsData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
  query?: {
    /**
     * Direction to sort results in.
     */
    direction?: SortDirection;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Use this parameter to order the Pack formula analytics returned.
     */
    orderBy?: PackFormulaAnalyticsOrderBy;
    /**
     * A list of Pack formula names (case-sensitive) for which to retrieve analytics.
     */
    packFormulaNames?: Array<string>;
    /**
     * A list of Pack formula types corresponding to the `packFormulaNames`. If specified, this must have the same length as `packFormulaNames`.
     */
    packFormulaTypes?: Array<PackFormulaType>;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Quantization period over which to view analytics. Defaults to daily.
     */
    scale?: AnalyticsScale;
    /**
     * Limit results to activity on or after this date.
     */
    sinceDate?: string;
    /**
     * Limit results to activity on or before this date.
     */
    untilDate?: string;
  };
};

export type ListPackFormulaAnalyticsResponse = PackFormulaAnalyticsCollection;

export type ListPackFormulaAnalyticsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetAnalyticsLastUpdatedResponse = AnalyticsLastUpdatedResponse;

export type GetAnalyticsLastUpdatedError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListWorkspaceMembersData = {
  path: {
    /**
     * ID of the workspace.
     */
    workspaceId: string;
  };
  query?: {
    /**
     * Show only the members that match the included roles. Multiple roles can be specified with a comma-delimited list.
     */
    includedRoles?: Array<WorkspaceUserRole>;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
  };
};

export type ListWorkspaceMembersResponse = WorkspaceMembersList;

export type ListWorkspaceMembersError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ChangeUserRoleData = {
  /**
   * Parameters for changing the user role.
   */
  body: ChangeRole;
  path: {
    /**
     * ID of the workspace.
     */
    workspaceId: string;
  };
};

export type ChangeUserRoleResponse = ChangeRoleResult;

export type ChangeUserRoleError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListWorkspaceRoleActivityData = {
  path: {
    /**
     * ID of the workspace.
     */
    workspaceId: string;
  };
};

export type ListWorkspaceRoleActivityResponse = GetWorkspaceRoleActivity;

export type ListWorkspaceRoleActivityError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type ListPacksData = {
  query?: {
    /**
     * Deprecated, use accessTypes instead. Filter to only return the Packs for which the current user has this access type
     */
    accessType?: PackAccessType;
    /**
     * Filter to only return the Packs for which the current user has these access types.
     */
    accessTypes?: Array<PackAccessType>;
    /**
     * Direction to sort results in.
     */
    direction?: SortDirection;
    /**
     * Do not include Packs that are only shared with the user individually.
     */
    excludeIndividualAcls?: boolean;
    /**
     * Only get Packs shared with users/workspaces, not publicly.
     */
    excludePublicPacks?: boolean;
    /**
     * Do not include Packs that are only shared with workspaces.
     */
    excludeWorkspaceAcls?: boolean;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Use only this workspace (not all of a user's workspaces) to check for Packs shared via workspace ACL.
     */
    onlyWorkspaceId?: string;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Filter to only Packs whose parent workspace is one of the given IDs.
     */
    parentWorkspaceIds?: Array<string>;
    /**
     * The sort order of the Packs returned.
     */
    sortBy?: PacksSortBy;
  };
};

export type ListPacksResponse = PackSummaryList;

export type ListPacksError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type CreatePackData = {
  /**
   * Parameters for creating the Pack.
   */
  body: CreatePackRequest;
};

export type CreatePackResponse2 = CreatePackResponse;

export type CreatePackError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetPackData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type GetPackResponse = Pack;

export type GetPackError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type UpdatePackData = {
  /**
   * Parameters for updating the Pack.
   */
  body: UpdatePackRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type UpdatePackResponse = Pack;

export type UpdatePackError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type DeletePackData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type DeletePackResponse2 = DeletePackResponse;

export type DeletePackError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type GetPackConfigurationSchemaData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type GetPackConfigurationSchemaResponse = GetPackConfigurationJsonSchemaResponse;

export type GetPackConfigurationSchemaError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListPackVersionsData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
  };
};

export type ListPackVersionsResponse = PackVersionList;

export type ListPackVersionsError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type GetNextPackVersionData = {
  body?: GetNextPackVersionRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type GetNextPackVersionResponse = NextPackVersionInfo;

export type GetNextPackVersionError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type GetPackVersionDiffsData = {
  path: {
    /**
     * Semantic version of the previous Pack version.
     */
    basePackVersion: string;
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * Semantic version of the new Pack version.
     */
    targetPackVersion: string;
  };
};

export type GetPackVersionDiffsResponse = PackVersionDiffs;

export type GetPackVersionDiffsError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type RegisterPackVersionData = {
  /**
   * Parameters for registering the Pack.
   */
  body: RegisterPackVersionRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * Semantic version of a Pack
     */
    packVersion: string;
  };
};

export type RegisterPackVersionResponse = PackVersionUploadInfo;

export type RegisterPackVersionError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type PackVersionUploadCompleteData = {
  /**
   * Parameters for Pack version upload complete.
   */
  body: CreatePackVersionRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * Semantic version of a Pack
     */
    packVersion: string;
  };
};

export type PackVersionUploadCompleteResponse = CreatePackVersionResponse;

export type PackVersionUploadCompleteError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type CreatePackReleaseData = {
  /**
   * Parameters to create the Pack release.
   */
  body: CreatePackReleaseRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type CreatePackReleaseResponse = PackRelease;

export type CreatePackReleaseError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListPackReleasesData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
  query?: {
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
  };
};

export type ListPackReleasesResponse = PackReleaseList;

export type ListPackReleasesError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type UpdatePackReleaseData = {
  /**
   * Parameters to update the Pack release.
   */
  body: UpdatePackReleaseRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * ID of a Pack release
     */
    packReleaseId: number;
  };
};

export type UpdatePackReleaseResponse = PackRelease;

export type UpdatePackReleaseError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type SetPackOauthConfigData = {
  /**
   * Parameters to set the Pack OAuth configuration.
   */
  body: SetPackOauthConfigRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type SetPackOauthConfigResponse = PackOauthConfigMetadata;

export type SetPackOauthConfigError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type GetPackOauthConfigData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type GetPackOauthConfigResponse = PackOauthConfigMetadata;

export type GetPackOauthConfigError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type SetPackSystemConnectionData = {
  /**
   * Parameters to set the Pack system connection credentials.
   */
  body: SetPackSystemConnectionRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type SetPackSystemConnectionResponse = PackSystemConnectionMetadata;

export type SetPackSystemConnectionError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type PatchPackSystemConnectionData = {
  /**
   * Parameters to patch the Pack system connection credentials.
   */
  body: PatchPackSystemConnectionRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type PatchPackSystemConnectionResponse = PackSystemConnectionMetadata;

export type PatchPackSystemConnectionError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type GetPackSystemConnectionData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type GetPackSystemConnectionResponse = PackSystemConnectionMetadata;

export type GetPackSystemConnectionError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type GetPackPermissionsData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type GetPackPermissionsResponse = PackPermissionList;

export type GetPackPermissionsError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type AddPackPermissionData = {
  /**
   * Parameters for creating/updating Pack permissions.
   */
  body: AddPackPermissionRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type AddPackPermissionResponse2 = AddPackPermissionResponse;

export type AddPackPermissionError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type DeletePackPermissionData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * ID of a permission on a doc.
     */
    permissionId: string;
  };
};

export type DeletePackPermissionResponse2 = DeletePackPermissionResponse;

export type DeletePackPermissionError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListPackMakersData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type ListPackMakersResponse2 = ListPackMakersResponse;

export type ListPackMakersError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type AddPackMakerData = {
  /**
   * Payload for adding a Pack maker.
   */
  body: AddPackMakerRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type AddPackMakerResponse2 = AddPackMakerResponse;

export type AddPackMakerError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type DeletePackMakerData = {
  path: {
    /**
     * Email of a Coda user.
     */
    loginId: string;
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type DeletePackMakerResponse2 = DeletePackMakerResponse;

export type DeletePackMakerError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListPackCategoriesData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type ListPackCategoriesResponse2 = ListPackCategoriesResponse;

export type ListPackCategoriesError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type AddPackCategoryData = {
  /**
   * Payload for adding a Pack category.
   */
  body: AddPackCategoryRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type AddPackCategoryResponse2 = AddPackCategoryResponse;

export type AddPackCategoryError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type DeletePackCategoryData = {
  path: {
    /**
     * Name of a publishing category
     */
    categoryName: string;
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type DeletePackCategoryResponse2 = DeletePackCategoryResponse;

export type DeletePackCategoryError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type UploadPackAssetData = {
  /**
   * Parameters to specify the asset being uploaded.
   */
  body: UploadPackAssetRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type UploadPackAssetResponse = PackAssetUploadInfo;

export type UploadPackAssetError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type UploadPackSourceCodeData = {
  /**
   * Parameters to specify the source code being uploaded.
   */
  body: UploadPackSourceCodeRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type UploadPackSourceCodeResponse = PackSourceCodeUploadInfo;

export type UploadPackSourceCodeError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type PackAssetUploadCompleteData = {
  path: {
    /**
     * Unique identifier for a Pack asset.
     */
    packAssetId: string;
    /**
     * Pack asset type.
     */
    packAssetType: PackAssetType;
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type PackAssetUploadCompleteResponse2 = PackAssetUploadCompleteResponse;

export type PackAssetUploadCompleteError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type PackSourceCodeUploadCompleteData = {
  /**
   * Parameters to specify the source code being uploaded.
   */
  body: PackSourceCodeUploadCompleteRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * Semantic version of a Pack
     */
    packVersion: string;
  };
};

export type PackSourceCodeUploadCompleteResponse2 = PackSourceCodeUploadCompleteResponse;

export type PackSourceCodeUploadCompleteError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type GetPackSourceCodeData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * Semantic version of a Pack
     */
    packVersion: string;
  };
};

export type GetPackSourceCodeResponse = PackSourceCodeInfo;

export type GetPackSourceCodeError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListPackListingsData = {
  query?: {
    /**
     * Direction to sort results in.
     */
    direction?: SortDirection;
    /**
     * Do not include Packs that are only shared with the user individually.
     */
    excludeIndividualAcls?: boolean;
    /**
     * Only get Packs shared with users/workspaces, not publicly.
     */
    excludePublicPacks?: boolean;
    /**
     * Do not include Packs that are only shared with workspaces.
     */
    excludeWorkspaceAcls?: boolean;
    /**
     * Type of installation context for which Pack information is being requested.
     */
    installContext?: PackListingInstallContextType;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Use only this workspace (not all of a user's workspaces) to check for Packs shared via workspace ACL.
     */
    onlyWorkspaceId?: string;
    /**
     * Deprecated: use sortBy instead.
     */
    orderBy?: PackListingsSortBy;
    /**
     * Pack access types.
     */
    packAccessTypes?: PackAccessTypes;
    /**
     * Which Pack IDs to fetch.
     */
    packIds?: Array<number>;
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * Filter to only Packs whose parent workspace is one of the given IDs.
     */
    parentWorkspaceIds?: Array<string>;
    /**
     * Specify a sort order for the returned Pack listings returned.
     */
    sortBy?: PackListingsSortBy;
  };
};

export type ListPackListingsResponse = PackListingList;

export type ListPackListingsError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type GetPackListingData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
  query?: {
    /**
     * ID of the target document for checking installation privileges
     */
    docId?: string;
    /**
     * Type of installation context for which Pack information is being requested.
     */
    installContext?: PackListingInstallContextType;
    /**
     * Release channel for which Pack information is being requested.
     */
    releaseChannel?: IngestionPackReleaseChannel;
    /**
     * ID of the target workspace (if applicable) for checking installation privileges.
     */
    workspaceId?: string;
  };
};

export type GetPackListingResponse = PackListingDetail;

export type GetPackListingError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListPackLogsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID of a Pack
     */
    packId: number;
  };
  query?: {
    /**
     * Only return logs after the given time (non-inclusive).
     *
     */
    afterTimestamp?: string;
    /**
     * Only return logs before the given time (non-inclusive).
     *
     */
    beforeTimestamp?: string;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Only return logs of the given types.
     */
    logTypes?: Array<PackLogType>;
    /**
     * Specifies if the logs will be returned in time desc or asc. Default is desc.
     *
     */
    order?: 'asc' | 'desc';
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * A search query that follows Lucene syntax.
     *
     */
    q?: string;
    /**
     * Only return logs matching provided request IDs.
     */
    requestIds?: Array<string>;
  };
};

export type ListPackLogsResponse = PackLogsList;

export type ListPackLogsError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListIngestionLogsData = {
  path: {
    /**
     * ID of the organization.
     */
    organizationId: string;
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * ID of the root ingestion.
     */
    rootIngestionId: string;
  };
  query?: {
    /**
     * Only return logs after the given time (non-inclusive).
     *
     */
    afterTimestamp?: string;
    /**
     * Only return logs before the given time (non-inclusive).
     *
     */
    beforeTimestamp?: string;
    /**
     * ID of the ingestion execution.
     */
    ingestionExecutionId?: string;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Only return logs of the given types.
     */
    logTypes?: Array<PackLogType>;
    /**
     * Specifies if the logs will be returned in time desc or asc. Default is desc.
     *
     */
    order?: 'asc' | 'desc';
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * A search query that follows Lucene syntax.
     *
     */
    q?: string;
    /**
     * Only return logs matching provided request IDs.
     */
    requestIds?: Array<string>;
  };
};

export type ListIngestionLogsResponse = PackLogsList;

export type ListIngestionLogsError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListGroupedPackLogsData = {
  path: {
    /**
     * ID of the doc.
     */
    docId: string;
    /**
     * ID of a Pack
     */
    packId: number;
  };
  query?: {
    /**
     * Only return logs after the given time (non-inclusive).
     *
     */
    afterTimestamp?: string;
    /**
     * Only return logs before the given time (non-inclusive).
     *
     */
    beforeTimestamp?: string;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Specifies if the logs will be returned in time desc or asc. Default is desc.
     *
     */
    order?: 'asc' | 'desc';
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * A search query that follows Lucene syntax.
     *
     */
    q?: string;
  };
};

export type ListGroupedPackLogsResponse = GroupedPackLogsList;

export type ListGroupedPackLogsError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListGroupedIngestionLogsData = {
  path: {
    /**
     * ID of the ingestion execution.
     */
    ingestionExecutionId: string;
    /**
     * ID of the organization.
     */
    organizationId: string;
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * ID of the root ingestion.
     */
    rootIngestionId: string;
  };
  query?: {
    /**
     * Only return logs after the given time (non-inclusive).
     *
     */
    afterTimestamp?: string;
    /**
     * Only return logs before the given time (non-inclusive).
     *
     */
    beforeTimestamp?: string;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Specifies if the logs will be returned in time desc or asc. Default is desc.
     *
     */
    order?: 'asc' | 'desc';
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * A search query that follows Lucene syntax.
     *
     */
    q?: string;
  };
};

export type ListGroupedIngestionLogsResponse = GroupedPackLogsList;

export type ListGroupedIngestionLogsError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListIngestionExecutionsData = {
  path: {
    /**
     * ID of the organization.
     */
    organizationId: string;
    /**
     * ID of a Pack
     */
    packId: number;
    /**
     * ID of the root ingestion.
     */
    rootIngestionId: string;
  };
  query?: {
    /**
     * Only return logs after the given time (non-inclusive).
     *
     */
    afterTimestamp?: string;
    /**
     * Only return logs before the given time (non-inclusive).
     *
     */
    beforeTimestamp?: string;
    /**
     * Maximum number of results to return in this query.
     */
    limit?: number;
    /**
     * Specifies if the logs will be returned in time desc or asc. Default is desc.
     *
     */
    order?: 'asc' | 'desc';
    /**
     * An opaque token used to fetch the next page of results.
     */
    pageToken?: string;
    /**
     * A search query that follows Lucene syntax.
     *
     */
    q?: string;
  };
};

export type ListIngestionExecutionsResponse = IngestionExecutionsList;

export type ListIngestionExecutionsError =
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
      /**
       * Detail about why this request was rejected.
       */
      codaDetail?: {
        validationErrors?: Array<ValidationError>;
      };
    }
  | {
      /**
       * HTTP status code of the error.
       */
      statusCode: number;
      /**
       * HTTP status message of the error.
       */
      statusMessage: string;
      /**
       * Any additional context on the error, or the same as `statusMessage` otherwise.
       */
      message: string;
    };

export type ListPackFeaturedDocsData = {
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type ListPackFeaturedDocsResponse = PackFeaturedDocsResponse;

export type ListPackFeaturedDocsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};

export type UpdatePackFeaturedDocsData = {
  /**
   * Parameters for updating the Pack's featured docs.
   */
  body: UpdatePackFeaturedDocsRequest;
  path: {
    /**
     * ID of a Pack
     */
    packId: number;
  };
};

export type UpdatePackFeaturedDocsResponse2 = UpdatePackFeaturedDocsResponse;

export type UpdatePackFeaturedDocsError = {
  /**
   * HTTP status code of the error.
   */
  statusCode: number;
  /**
   * HTTP status message of the error.
   */
  statusMessage: string;
  /**
   * Any additional context on the error, or the same as `statusMessage` otherwise.
   */
  message: string;
};
