// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  ListCategoriesError,
  ListCategoriesResponse,
  ListDocsData,
  ListDocsError,
  ListDocsResponse,
  CreateDocData,
  CreateDocError,
  CreateDocResponse,
  GetDocData,
  GetDocError,
  GetDocResponse,
  DeleteDocData,
  DeleteDocError,
  DeleteDocResponse,
  UpdateDocData,
  UpdateDocError,
  UpdateDocResponse,
  GetSharingMetadataData,
  GetSharingMetadataError,
  GetSharingMetadataResponse,
  GetPermissionsData,
  GetPermissionsError,
  GetPermissionsResponse,
  AddPermissionData,
  AddPermissionError,
  AddPermissionResponse,
  DeletePermissionData,
  DeletePermissionError,
  DeletePermissionResponse,
  SearchPrincipalsData,
  SearchPrincipalsError,
  SearchPrincipalsResponse2,
  GetAclSettingsData,
  GetAclSettingsError,
  GetAclSettingsResponse,
  UpdateAclSettingsData,
  UpdateAclSettingsError,
  UpdateAclSettingsResponse,
  PublishDocData,
  PublishDocError,
  PublishDocResponse,
  UnpublishDocData,
  UnpublishDocError,
  UnpublishDocResponse,
  ListPagesData,
  ListPagesError,
  ListPagesResponse,
  CreatePageData,
  CreatePageError,
  CreatePageResponse,
  GetPageData,
  GetPageError,
  GetPageResponse,
  UpdatePageData,
  UpdatePageError,
  UpdatePageResponse,
  DeletePageData,
  DeletePageError,
  DeletePageResponse,
  BeginPageContentExportData,
  BeginPageContentExportError,
  BeginPageContentExportResponse2,
  GetPageContentExportStatusData,
  GetPageContentExportStatusError,
  GetPageContentExportStatusResponse,
  ListTablesData,
  ListTablesError,
  ListTablesResponse,
  GetTableData,
  GetTableError,
  GetTableResponse,
  ListColumnsData,
  ListColumnsError,
  ListColumnsResponse,
  ListRowsData,
  ListRowsError,
  ListRowsResponse,
  UpsertRowsData,
  UpsertRowsError,
  UpsertRowsResponse,
  DeleteRowsData,
  DeleteRowsError,
  DeleteRowsResponse,
  GetRowData,
  GetRowError,
  GetRowResponse,
  UpdateRowData,
  UpdateRowError,
  UpdateRowResponse,
  DeleteRowData,
  DeleteRowError,
  DeleteRowResponse,
  PushButtonData,
  PushButtonError,
  PushButtonResponse,
  GetColumnData,
  GetColumnError,
  GetColumnResponse,
  ListFormulasData,
  ListFormulasError,
  ListFormulasResponse,
  GetFormulaData,
  GetFormulaError,
  GetFormulaResponse,
  ListControlsData,
  ListControlsError,
  ListControlsResponse,
  GetControlData,
  GetControlError,
  GetControlResponse,
  ListCustomDocDomainsData,
  ListCustomDocDomainsError,
  ListCustomDocDomainsResponse,
  AddCustomDocDomainData,
  AddCustomDocDomainError,
  AddCustomDocDomainResponse2,
  DeleteCustomDocDomainData,
  DeleteCustomDocDomainError,
  DeleteCustomDocDomainResponse2,
  UpdateCustomDocDomainData,
  UpdateCustomDocDomainError,
  UpdateCustomDocDomainResponse2,
  GetCustomDocDomainProviderData,
  GetCustomDocDomainProviderError,
  GetCustomDocDomainProviderResponse,
  WhoamiError,
  WhoamiResponse,
  ResolveBrowserLinkData,
  ResolveBrowserLinkError,
  ResolveBrowserLinkResponse,
  GetMutationStatusData,
  GetMutationStatusError,
  GetMutationStatusResponse,
  TriggerWebhookAutomationData,
  TriggerWebhookAutomationError,
  TriggerWebhookAutomationResponse,
  ListDocAnalyticsData,
  ListDocAnalyticsError,
  ListDocAnalyticsResponse,
  ListPageAnalyticsData,
  ListPageAnalyticsError,
  ListPageAnalyticsResponse,
  ListDocAnalyticsSummaryData,
  ListDocAnalyticsSummaryError,
  ListDocAnalyticsSummaryResponse,
  ListPackAnalyticsData,
  ListPackAnalyticsError,
  ListPackAnalyticsResponse,
  ListPackAnalyticsSummaryData,
  ListPackAnalyticsSummaryError,
  ListPackAnalyticsSummaryResponse,
  ListPackFormulaAnalyticsData,
  ListPackFormulaAnalyticsError,
  ListPackFormulaAnalyticsResponse,
  GetAnalyticsLastUpdatedError,
  GetAnalyticsLastUpdatedResponse,
  ListWorkspaceMembersData,
  ListWorkspaceMembersError,
  ListWorkspaceMembersResponse,
  ChangeUserRoleData,
  ChangeUserRoleError,
  ChangeUserRoleResponse,
  ListWorkspaceRoleActivityData,
  ListWorkspaceRoleActivityError,
  ListWorkspaceRoleActivityResponse,
  ListPacksData,
  ListPacksError,
  ListPacksResponse,
  CreatePackData,
  CreatePackError,
  CreatePackResponse2,
  GetPackData,
  GetPackError,
  GetPackResponse,
  UpdatePackData,
  UpdatePackError,
  UpdatePackResponse,
  DeletePackData,
  DeletePackError,
  DeletePackResponse2,
  GetPackConfigurationSchemaData,
  GetPackConfigurationSchemaError,
  GetPackConfigurationSchemaResponse,
  ListPackVersionsData,
  ListPackVersionsError,
  ListPackVersionsResponse,
  GetNextPackVersionData,
  GetNextPackVersionError,
  GetNextPackVersionResponse,
  GetPackVersionDiffsData,
  GetPackVersionDiffsError,
  GetPackVersionDiffsResponse,
  RegisterPackVersionData,
  RegisterPackVersionError,
  RegisterPackVersionResponse,
  PackVersionUploadCompleteData,
  PackVersionUploadCompleteError,
  PackVersionUploadCompleteResponse,
  CreatePackReleaseData,
  CreatePackReleaseError,
  CreatePackReleaseResponse,
  ListPackReleasesData,
  ListPackReleasesError,
  ListPackReleasesResponse,
  UpdatePackReleaseData,
  UpdatePackReleaseError,
  UpdatePackReleaseResponse,
  SetPackOauthConfigData,
  SetPackOauthConfigError,
  SetPackOauthConfigResponse,
  GetPackOauthConfigData,
  GetPackOauthConfigError,
  GetPackOauthConfigResponse,
  SetPackSystemConnectionData,
  SetPackSystemConnectionError,
  SetPackSystemConnectionResponse,
  PatchPackSystemConnectionData,
  PatchPackSystemConnectionError,
  PatchPackSystemConnectionResponse,
  GetPackSystemConnectionData,
  GetPackSystemConnectionError,
  GetPackSystemConnectionResponse,
  GetPackPermissionsData,
  GetPackPermissionsError,
  GetPackPermissionsResponse,
  AddPackPermissionData,
  AddPackPermissionError,
  AddPackPermissionResponse2,
  DeletePackPermissionData,
  DeletePackPermissionError,
  DeletePackPermissionResponse2,
  ListPackMakersData,
  ListPackMakersError,
  ListPackMakersResponse2,
  AddPackMakerData,
  AddPackMakerError,
  AddPackMakerResponse2,
  DeletePackMakerData,
  DeletePackMakerError,
  DeletePackMakerResponse2,
  ListPackCategoriesData,
  ListPackCategoriesError,
  ListPackCategoriesResponse2,
  AddPackCategoryData,
  AddPackCategoryError,
  AddPackCategoryResponse2,
  DeletePackCategoryData,
  DeletePackCategoryError,
  DeletePackCategoryResponse2,
  UploadPackAssetData,
  UploadPackAssetError,
  UploadPackAssetResponse,
  UploadPackSourceCodeData,
  UploadPackSourceCodeError,
  UploadPackSourceCodeResponse,
  PackAssetUploadCompleteData,
  PackAssetUploadCompleteError,
  PackAssetUploadCompleteResponse2,
  PackSourceCodeUploadCompleteData,
  PackSourceCodeUploadCompleteError,
  PackSourceCodeUploadCompleteResponse2,
  GetPackSourceCodeData,
  GetPackSourceCodeError,
  GetPackSourceCodeResponse,
  ListPackListingsData,
  ListPackListingsError,
  ListPackListingsResponse,
  GetPackListingData,
  GetPackListingError,
  GetPackListingResponse,
  ListPackLogsData,
  ListPackLogsError,
  ListPackLogsResponse,
  ListIngestionLogsData,
  ListIngestionLogsError,
  ListIngestionLogsResponse,
  ListGroupedPackLogsData,
  ListGroupedPackLogsError,
  ListGroupedPackLogsResponse,
  ListGroupedIngestionLogsData,
  ListGroupedIngestionLogsError,
  ListGroupedIngestionLogsResponse,
  ListIngestionExecutionsData,
  ListIngestionExecutionsError,
  ListIngestionExecutionsResponse,
  ListPackFeaturedDocsData,
  ListPackFeaturedDocsError,
  ListPackFeaturedDocsResponse,
  UpdatePackFeaturedDocsData,
  UpdatePackFeaturedDocsError,
  UpdatePackFeaturedDocsResponse2,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Get doc categories
 * Gets all available doc categories.
 */
export const listCategories = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<ListCategoriesResponse, ListCategoriesError, ThrowOnError>({
    ...options,
    url: '/categories',
  });
};

/**
 * List available docs
 * Returns a list of Coda docs accessible by the user. These are returned in the same order as on the docs page: reverse chronological by the latest event relevant to the user (last viewed, edited, or shared).
 *
 */
export const listDocs = <ThrowOnError extends boolean = false>(options?: Options<ListDocsData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListDocsResponse, ListDocsError, ThrowOnError>({
    ...options,
    url: '/docs',
  });
};

/**
 * Create doc
 * Creates a new Coda doc, optionally copying an existing doc. Note that creating a doc requires you to be a Doc Maker in the applicable workspace (or be auto-promoted to one).
 *
 */
export const createDoc = <ThrowOnError extends boolean = false>(options: Options<CreateDocData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateDocResponse, CreateDocError, ThrowOnError>({
    ...options,
    url: '/docs',
  });
};

/**
 * Get info about a doc
 * Returns metadata for the specified doc.
 */
export const getDoc = <ThrowOnError extends boolean = false>(options: Options<GetDocData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetDocResponse, GetDocError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}',
  });
};

/**
 * Delete doc
 * Deletes a doc.
 */
export const deleteDoc = <ThrowOnError extends boolean = false>(options: Options<DeleteDocData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteDocResponse, DeleteDocError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}',
  });
};

/**
 * Update doc
 * Updates metadata for a doc. Note that updating a doc title requires you to be a Doc Maker in the applicable workspace.
 */
export const updateDoc = <ThrowOnError extends boolean = false>(options: Options<UpdateDocData, ThrowOnError>) => {
  return (options?.client ?? client).patch<UpdateDocResponse, UpdateDocError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}',
  });
};

/**
 * Get sharing metadata
 * Returns metadata associated with sharing for this Coda doc.
 */
export const getSharingMetadata = <ThrowOnError extends boolean = false>(
  options: Options<GetSharingMetadataData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetSharingMetadataResponse, GetSharingMetadataError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/acl/metadata',
  });
};

/**
 * List permissions
 * Returns a list of permissions for this Coda doc.
 */
export const getPermissions = <ThrowOnError extends boolean = false>(
  options: Options<GetPermissionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPermissionsResponse, GetPermissionsError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/acl/permissions',
  });
};

/**
 * Add permission
 * Adds a new permission to the doc.
 *
 */
export const addPermission = <ThrowOnError extends boolean = false>(
  options: Options<AddPermissionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddPermissionResponse, AddPermissionError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/acl/permissions',
  });
};

/**
 * Delete permission
 * Deletes an existing permission.
 *
 */
export const deletePermission = <ThrowOnError extends boolean = false>(
  options: Options<DeletePermissionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeletePermissionResponse, DeletePermissionError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/acl/permissions/{permissionId}',
  });
};

/**
 * Search principals
 * Searches for user and group principals matching the query that this doc can be shared with.
 * At most 20 results will be returned for both users and groups. If no query is given then no results are returned.
 *
 */
export const searchPrincipals = <ThrowOnError extends boolean = false>(
  options: Options<SearchPrincipalsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchPrincipalsResponse2, SearchPrincipalsError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/acl/principals/search',
  });
};

/**
 * Get ACL settings
 * Returns settings associated with ACLs for this Coda doc.
 */
export const getAclSettings = <ThrowOnError extends boolean = false>(
  options: Options<GetAclSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAclSettingsResponse, GetAclSettingsError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/acl/settings',
  });
};

/**
 * Update ACL settings
 * Update settings associated with ACLs for this Coda doc.
 */
export const updateAclSettings = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAclSettingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateAclSettingsResponse, UpdateAclSettingsError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/acl/settings',
  });
};

/**
 * Publish doc
 * Update publish settings for a doc.
 */
export const publishDoc = <ThrowOnError extends boolean = false>(options: Options<PublishDocData, ThrowOnError>) => {
  return (options?.client ?? client).put<PublishDocResponse, PublishDocError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/publish',
  });
};

/**
 * Unpublish doc
 * Unpublishes a doc.
 */
export const unpublishDoc = <ThrowOnError extends boolean = false>(
  options: Options<UnpublishDocData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UnpublishDocResponse, UnpublishDocError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/publish',
  });
};

/**
 * List pages
 * Returns a list of pages in a Coda doc.
 */
export const listPages = <ThrowOnError extends boolean = false>(options: Options<ListPagesData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListPagesResponse, ListPagesError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/pages',
  });
};

/**
 * Create a page
 * Create a new page in a doc. Note that creating a page requires you to be a Doc Maker in the applicable workspace.
 *
 */
export const createPage = <ThrowOnError extends boolean = false>(options: Options<CreatePageData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreatePageResponse, CreatePageError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/pages',
  });
};

/**
 * Get a page
 * Returns details about a page.
 */
export const getPage = <ThrowOnError extends boolean = false>(options: Options<GetPageData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetPageResponse, GetPageError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/pages/{pageIdOrName}',
  });
};

/**
 * Update a page
 * Update properties for a page. Note that updating a page title or icon requires you to be a Doc Maker in the applicable workspace.
 *
 */
export const updatePage = <ThrowOnError extends boolean = false>(options: Options<UpdatePageData, ThrowOnError>) => {
  return (options?.client ?? client).put<UpdatePageResponse, UpdatePageError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/pages/{pageIdOrName}',
  });
};

/**
 * Delete a page
 * Deletes the specified page.
 */
export const deletePage = <ThrowOnError extends boolean = false>(options: Options<DeletePageData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeletePageResponse, DeletePageError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/pages/{pageIdOrName}',
  });
};

/**
 * Begin content export
 * Initiate an export of content for the given page.
 */
export const beginPageContentExport = <ThrowOnError extends boolean = false>(
  options: Options<BeginPageContentExportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<BeginPageContentExportResponse2, BeginPageContentExportError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/pages/{pageIdOrName}/export',
  });
};

/**
 * Content export status
 * Check the status of a page content export
 */
export const getPageContentExportStatus = <ThrowOnError extends boolean = false>(
  options: Options<GetPageContentExportStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetPageContentExportStatusResponse,
    GetPageContentExportStatusError,
    ThrowOnError
  >({
    ...options,
    url: '/docs/{docId}/pages/{pageIdOrName}/export/{requestId}',
  });
};

/**
 * List tables
 * Returns a list of tables in a Coda doc.
 */
export const listTables = <ThrowOnError extends boolean = false>(options: Options<ListTablesData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListTablesResponse, ListTablesError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables',
  });
};

/**
 * Get a table
 * Returns details about a specific table or view.
 */
export const getTable = <ThrowOnError extends boolean = false>(options: Options<GetTableData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTableResponse, GetTableError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}',
  });
};

/**
 * List columns
 * Returns a list of columns in a table.
 */
export const listColumns = <ThrowOnError extends boolean = false>(options: Options<ListColumnsData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListColumnsResponse, ListColumnsError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}/columns',
  });
};

/**
 * List table rows
 * Returns a list of rows in a table.
 * ### Value results
 * The `valueFormat` parameter dictates in what format the API should return values for individual cells.
 * * `simple` (default): Returns cell values as the following JSON values: `string`, `number`, or `boolean`. Array values (like multiselects) are returned as comma-delimited strings.
 * * `simpleWithArrays`: Singleton values are returned as `simple`. Array values are returned as JSON arrays and the values within are `simple` values (including nested arrays).
 * * `rich`: If applicable, returns many values with further encoding, allowing API users to have lossless access to data in Coda.
 * * For `text` values, returns data in Markdown syntax. If the text field is simple text (e.g. has no formatting),
 * the field will be fully escaped with triple-ticks. E.g
 * `
 * ```This is plain text```
 * `
 * * For `currency`, `lookup`, `image`, `person` and `hyperlink` values, the value will be encoded in [JSON-LD](https://json-ld.org/) format.
 *
 * ```
 * // Currency
 * {
 * "@context": "http://schema.org",
 * "@type": "MonetaryAmount",
 * "currency": "USD",
 * "amount": 42.42
 * }
 *
 * // Lookup
 * {
 * "@context": "http://schema.org",
 * "@type": "StructuredValue",
 * "additionalType": "row",
 * "name": "Row Name",
 * "rowId": "i-123456789",
 * "tableId": "grid-123456789",
 * "tableUrl": "https://coda.io/d/_d123456789/grid-123456789",
 * "url": "https://coda.io/d/_d123456789/grid-123456789#_r42",
 * }
 *
 * // Hyperlink
 * {
 * "@context": "http://schema.org",
 * "@type": "WebPage",
 * "name": "Coda",
 * "url": "https://coda.io"
 * }
 *
 * // Image
 * {
 * "@context": "http://schema.org",
 * "@type": "ImageObject",
 * "name": "Coda logo",
 * "url": "https://coda.io/logo.jpg"
 * }
 *
 * // People
 * {
 * "@context": "http://schema.org",
 * "@type": "Person",
 * "name": "Art Vandalay",
 * "email": "art@vandalayindustries.com"
 * }
 * ```
 *
 */
export const listRows = <ThrowOnError extends boolean = false>(options: Options<ListRowsData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListRowsResponse, ListRowsError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}/rows',
  });
};

/**
 * Insert/upsert rows
 * Inserts rows into a table, optionally updating existing rows if any upsert key columns are provided. This endpoint will always return a 202, so long as the doc and table exist and are accessible (and the update is structurally valid). Row inserts/upserts are generally processed within several seconds. Note: this endpoint only works for base tables, not views.
 * When upserting, if multiple rows match the specified key column(s), they will all be updated with the specified value.
 *
 */
export const upsertRows = <ThrowOnError extends boolean = false>(options: Options<UpsertRowsData, ThrowOnError>) => {
  return (options?.client ?? client).post<UpsertRowsResponse, UpsertRowsError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}/rows',
  });
};

/**
 * Delete multiple rows
 * Deletes the specified rows from the table or view. This endpoint will always return a 202. Row deletions are generally processed within several seconds.
 *
 */
export const deleteRows = <ThrowOnError extends boolean = false>(options: Options<DeleteRowsData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteRowsResponse, DeleteRowsError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}/rows',
  });
};

/**
 * Get a row
 * Returns details about a row in a table.
 */
export const getRow = <ThrowOnError extends boolean = false>(options: Options<GetRowData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetRowResponse, GetRowError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}/rows/{rowIdOrName}',
  });
};

/**
 * Update row
 * Updates the specified row in the table. This endpoint will always return a 202, so long as the row exists and is accessible (and the update is structurally valid). Row updates are generally processed within several seconds. When updating using a name as opposed to an ID, an arbitrary row will be affected.
 *
 */
export const updateRow = <ThrowOnError extends boolean = false>(options: Options<UpdateRowData, ThrowOnError>) => {
  return (options?.client ?? client).put<UpdateRowResponse, UpdateRowError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}/rows/{rowIdOrName}',
  });
};

/**
 * Delete row
 * Deletes the specified row from the table or view. This endpoint will always return a 202, so long as the row exists and is accessible (and the update is structurally valid). Row deletions are generally processed within several seconds. When deleting using a name as opposed to an ID, an arbitrary row will be removed.
 *
 */
export const deleteRow = <ThrowOnError extends boolean = false>(options: Options<DeleteRowData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteRowResponse, DeleteRowError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}/rows/{rowIdOrName}',
  });
};

/**
 * Push a button
 * Pushes a button on a row in a table.
 * Authorization note: This action is available to API tokens that are authorized to write to the table. However, the underlying button can perform any action on the document, including writing to other tables and performing Pack actions.
 *
 */
export const pushButton = <ThrowOnError extends boolean = false>(options: Options<PushButtonData, ThrowOnError>) => {
  return (options?.client ?? client).post<PushButtonResponse, PushButtonError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}/rows/{rowIdOrName}/buttons/{columnIdOrName}',
  });
};

/**
 * Get a column
 * Returns details about a column in a table.
 */
export const getColumn = <ThrowOnError extends boolean = false>(options: Options<GetColumnData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetColumnResponse, GetColumnError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/tables/{tableIdOrName}/columns/{columnIdOrName}',
  });
};

/**
 * List formulas
 * Returns a list of named formulas in a Coda doc.
 */
export const listFormulas = <ThrowOnError extends boolean = false>(
  options: Options<ListFormulasData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListFormulasResponse, ListFormulasError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/formulas',
  });
};

/**
 * Get a formula
 * Returns info on a formula.
 */
export const getFormula = <ThrowOnError extends boolean = false>(options: Options<GetFormulaData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetFormulaResponse, GetFormulaError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/formulas/{formulaIdOrName}',
  });
};

/**
 * List controls
 * Returns a list of controls in a Coda doc.
 */
export const listControls = <ThrowOnError extends boolean = false>(
  options: Options<ListControlsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListControlsResponse, ListControlsError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/controls',
  });
};

/**
 * Get a control
 * Returns info on a control.
 */
export const getControl = <ThrowOnError extends boolean = false>(options: Options<GetControlData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetControlResponse, GetControlError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/controls/{controlIdOrName}',
  });
};

/**
 * List custom doc domains
 * List all custom domains for a published doc.
 */
export const listCustomDocDomains = <ThrowOnError extends boolean = false>(
  options: Options<ListCustomDocDomainsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListCustomDocDomainsResponse, ListCustomDocDomainsError, ThrowOnError>({
    ...options,
    url: '/docs/${docId}/domains',
  });
};

/**
 * Add custom domain
 * Add a custom domain to a published doc.
 */
export const addCustomDocDomain = <ThrowOnError extends boolean = false>(
  options: Options<AddCustomDocDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddCustomDocDomainResponse2, AddCustomDocDomainError, ThrowOnError>({
    ...options,
    url: '/docs/${docId}/domains',
  });
};

/**
 * Deletes a custom domain
 * Deletes a custom domain from a published doc.
 */
export const deleteCustomDocDomain = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCustomDocDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCustomDocDomainResponse2, DeleteCustomDocDomainError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/domains/{customDocDomain}',
  });
};

/**
 * Updates a custom domain
 * Updates properties of a document's custom domain.
 */
export const updateCustomDocDomain = <ThrowOnError extends boolean = false>(
  options: Options<UpdateCustomDocDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateCustomDocDomainResponse2, UpdateCustomDocDomainError, ThrowOnError>({
    ...options,
    url: '/docs/{docId}/domains/{customDocDomain}',
  });
};

/**
 * Gets custom doc domains providers
 * Gets the provider (ie. GoDaddy) of a custom domain.
 */
export const getCustomDocDomainProvider = <ThrowOnError extends boolean = false>(
  options: Options<GetCustomDocDomainProviderData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetCustomDocDomainProviderResponse,
    GetCustomDocDomainProviderError,
    ThrowOnError
  >({
    ...options,
    url: '/domains/provider/{customDocDomain}',
  });
};

/**
 * Get user info
 * Returns basic info about the current user.
 */
export const whoami = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<WhoamiResponse, WhoamiError, ThrowOnError>({
    ...options,
    url: '/whoami',
  });
};

/**
 * Resolve browser link
 * Given a browser link to a Coda object, attempts to find it and return metadata that can be used to get more info on it. Returns a 400 if the URL does not appear to be a Coda URL or a 404 if the resource cannot be located with the current credentials.
 *
 */
export const resolveBrowserLink = <ThrowOnError extends boolean = false>(
  options: Options<ResolveBrowserLinkData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ResolveBrowserLinkResponse, ResolveBrowserLinkError, ThrowOnError>({
    ...options,
    url: '/resolveBrowserLink',
  });
};

/**
 * Get mutation status
 * Get the status for an asynchronous mutation to know whether or not it has been completed. Each API endpoint that mutates a document will return a request id that you can pass to this endpoint to check the completion status. Status information is not guaranteed to be available for more than one day after the mutation was completed. It is intended to be used shortly after the request was made.
 *
 */
export const getMutationStatus = <ThrowOnError extends boolean = false>(
  options: Options<GetMutationStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetMutationStatusResponse, GetMutationStatusError, ThrowOnError>({
    ...options,
    url: '/mutationStatus/{requestId}',
  });
};

/**
 * Trigger automation
 * Triggers webhook-invoked automation
 */
export const triggerWebhookAutomation = <ThrowOnError extends boolean = false>(
  options: Options<TriggerWebhookAutomationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    TriggerWebhookAutomationResponse,
    TriggerWebhookAutomationError,
    ThrowOnError
  >({
    ...options,
    url: '/docs/{docId}/hooks/automation/{ruleId}',
  });
};

/**
 * List doc analytics
 * Returns analytics data for available docs per day.
 *
 */
export const listDocAnalytics = <ThrowOnError extends boolean = false>(
  options?: Options<ListDocAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListDocAnalyticsResponse, ListDocAnalyticsError, ThrowOnError>({
    ...options,
    url: '/analytics/docs',
  });
};

/**
 * List page analytics
 * Returns analytics data for a given doc within the day.
 * This method will return a 401 if the given doc is not in an Enterprise workspace.
 *
 */
export const listPageAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<ListPageAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPageAnalyticsResponse, ListPageAnalyticsError, ThrowOnError>({
    ...options,
    url: '/analytics/docs/{docId}/pages',
  });
};

/**
 * Get doc analytics summary
 * Returns summarized analytics data for available docs.
 *
 */
export const listDocAnalyticsSummary = <ThrowOnError extends boolean = false>(
  options?: Options<ListDocAnalyticsSummaryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListDocAnalyticsSummaryResponse, ListDocAnalyticsSummaryError, ThrowOnError>({
    ...options,
    url: '/analytics/docs/summary',
  });
};

/**
 * List Pack analytics
 * Returns analytics data for Packs the user can edit.
 *
 */
export const listPackAnalytics = <ThrowOnError extends boolean = false>(
  options?: Options<ListPackAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackAnalyticsResponse, ListPackAnalyticsError, ThrowOnError>({
    ...options,
    url: '/analytics/packs',
  });
};

/**
 * Get Pack analytics summary
 * Returns summarized analytics data for Packs the user can edit.
 *
 */
export const listPackAnalyticsSummary = <ThrowOnError extends boolean = false>(
  options?: Options<ListPackAnalyticsSummaryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackAnalyticsSummaryResponse, ListPackAnalyticsSummaryError, ThrowOnError>(
    {
      ...options,
      url: '/analytics/packs/summary',
    },
  );
};

/**
 * List Pack formula analytics
 * Returns analytics data for Pack formulas.
 *
 */
export const listPackFormulaAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<ListPackFormulaAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackFormulaAnalyticsResponse, ListPackFormulaAnalyticsError, ThrowOnError>(
    {
      ...options,
      url: '/analytics/packs/{packId}/formulas',
    },
  );
};

/**
 * Get analytics last updated day
 * Returns days based on Pacific Standard Time when analytics were last updated.
 *
 */
export const getAnalyticsLastUpdated = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAnalyticsLastUpdatedResponse, GetAnalyticsLastUpdatedError, ThrowOnError>({
    ...options,
    url: '/analytics/updated',
  });
};

/**
 * List workspace users
 * Returns a list of members in the given workspace. This list will be ordered with the requesting user first and then ordered by role.
 *
 */
export const listWorkspaceMembers = <ThrowOnError extends boolean = false>(
  options: Options<ListWorkspaceMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListWorkspaceMembersResponse, ListWorkspaceMembersError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspaceId}/users',
  });
};

/**
 * Updates user role
 * Updates the workspace user role of a user that matches the parameters. Only succeeds if the requesting user has admin permissions in the workspace.
 *
 */
export const changeUserRole = <ThrowOnError extends boolean = false>(
  options: Options<ChangeUserRoleData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ChangeUserRoleResponse, ChangeUserRoleError, ThrowOnError>({
    ...options,
    url: '/workspaces/{workspaceId}/users/role',
  });
};

/**
 * List workspace roles
 * Returns a list of the counts of users over time by role for the workspace.
 *
 */
export const listWorkspaceRoleActivity = <ThrowOnError extends boolean = false>(
  options: Options<ListWorkspaceRoleActivityData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListWorkspaceRoleActivityResponse,
    ListWorkspaceRoleActivityError,
    ThrowOnError
  >({
    ...options,
    url: '/workspaces/{workspaceId}/roles',
  });
};

/**
 * List Packs
 * Get the list of accessible Packs.
 *
 */
export const listPacks = <ThrowOnError extends boolean = false>(options?: Options<ListPacksData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListPacksResponse, ListPacksError, ThrowOnError>({
    ...options,
    url: '/packs',
  });
};

/**
 * Create Pack
 * Creates a new Pack, essentially registering a new Pack ID. The contents of the Pack will be uploaded separately.
 *
 */
export const createPack = <ThrowOnError extends boolean = false>(options: Options<CreatePackData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreatePackResponse2, CreatePackError, ThrowOnError>({
    ...options,
    url: '/packs',
  });
};

/**
 * Get a single Pack
 * Returns a single Pack.
 *
 */
export const getPack = <ThrowOnError extends boolean = false>(options: Options<GetPackData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetPackResponse, GetPackError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}',
  });
};

/**
 * Update Pack
 * Update an existing Pack for non-versioned fields.
 *
 */
export const updatePack = <ThrowOnError extends boolean = false>(options: Options<UpdatePackData, ThrowOnError>) => {
  return (options?.client ?? client).patch<UpdatePackResponse, UpdatePackError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}',
  });
};

/**
 * Delete Pack
 * Delete a given Pack.
 *
 */
export const deletePack = <ThrowOnError extends boolean = false>(options: Options<DeletePackData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeletePackResponse2, DeletePackError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}',
  });
};

/**
 * Gets the JSON Schema for Pack configuration.
 * Returns a JSON Schema applicable for customizing the pack using Pack configurations.
 *
 */
export const getPackConfigurationSchema = <ThrowOnError extends boolean = false>(
  options: Options<GetPackConfigurationSchemaData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetPackConfigurationSchemaResponse,
    GetPackConfigurationSchemaError,
    ThrowOnError
  >({
    ...options,
    url: '/packs/{packId}/configurations/schema',
  });
};

/**
 * List the versions for a Pack.
 * Get the list of versions of a Pack.
 *
 */
export const listPackVersions = <ThrowOnError extends boolean = false>(
  options: Options<ListPackVersionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackVersionsResponse, ListPackVersionsError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/versions',
  });
};

/**
 * Get the next valid version for a Pack.
 * Get the next valid version based on the proposed metadata.
 *
 */
export const getNextPackVersion = <ThrowOnError extends boolean = false>(
  options: Options<GetNextPackVersionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GetNextPackVersionResponse, GetNextPackVersionError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/nextVersion',
  });
};

/**
 * Get the difference between two pack versions.
 * Gets information about the difference between the specified previous version and next version of a Pack.
 *
 */
export const getPackVersionDiffs = <ThrowOnError extends boolean = false>(
  options: Options<GetPackVersionDiffsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPackVersionDiffsResponse, GetPackVersionDiffsError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/versions/{basePackVersion}/diff/{targetPackVersion}',
  });
};

/**
 * Register Pack version
 * Registers a new Pack version. This simply returns a signed URL to use for uploading the Pack version definition. Following the completion of the upload, POST to /apis/v1/packs/{packId}/versions/{packVersion} trigger the rest of the creation process.
 *
 */
export const registerPackVersion = <ThrowOnError extends boolean = false>(
  options: Options<RegisterPackVersionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RegisterPackVersionResponse, RegisterPackVersionError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/versions/{packVersion}/register',
  });
};

/**
 * Pack version upload complete
 * Note the completion of the upload of a Pack version bundle in order to create that Pack version.
 *
 */
export const packVersionUploadComplete = <ThrowOnError extends boolean = false>(
  options: Options<PackVersionUploadCompleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PackVersionUploadCompleteResponse,
    PackVersionUploadCompleteError,
    ThrowOnError
  >({
    ...options,
    url: '/packs/{packId}/versions/{packVersion}/uploadComplete',
  });
};

/**
 * Create a new Pack release.
 * Creates a new Pack release based on an existing Pack version.
 *
 */
export const createPackRelease = <ThrowOnError extends boolean = false>(
  options: Options<CreatePackReleaseData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreatePackReleaseResponse, CreatePackReleaseError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/releases',
  });
};

/**
 * List the releases for a Pack.
 * Get the list of releases of a Pack.
 *
 */
export const listPackReleases = <ThrowOnError extends boolean = false>(
  options: Options<ListPackReleasesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackReleasesResponse, ListPackReleasesError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/releases',
  });
};

/**
 * Update an existing Pack release.
 * Update details of a Pack release.
 *
 */
export const updatePackRelease = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePackReleaseData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdatePackReleaseResponse, UpdatePackReleaseError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/releases/{packReleaseId}',
  });
};

/**
 * Set the OAuth configurations of the Pack.
 * Set the OAuth configurations of the Pack, including client id and secret.
 *
 */
export const setPackOauthConfig = <ThrowOnError extends boolean = false>(
  options: Options<SetPackOauthConfigData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SetPackOauthConfigResponse, SetPackOauthConfigError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/oauthConfig',
  });
};

/**
 * Retrieve the OAuth configuration of the Pack.
 * Retrieve the OAuth configuration of the Pack for display purpose. Secrets will be returned with masks.
 *
 */
export const getPackOauthConfig = <ThrowOnError extends boolean = false>(
  options: Options<GetPackOauthConfigData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPackOauthConfigResponse, GetPackOauthConfigError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/oauthConfig',
  });
};

/**
 * Set the system connection credentials of the Pack.
 * Set the system connection credentials of the Pack.
 *
 */
export const setPackSystemConnection = <ThrowOnError extends boolean = false>(
  options: Options<SetPackSystemConnectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SetPackSystemConnectionResponse, SetPackSystemConnectionError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/systemConnection',
  });
};

/**
 * Patch the system connection credentials of the Pack.
 * Patch the system connection credentials of the Pack.
 *
 */
export const patchPackSystemConnection = <ThrowOnError extends boolean = false>(
  options: Options<PatchPackSystemConnectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchPackSystemConnectionResponse,
    PatchPackSystemConnectionError,
    ThrowOnError
  >({
    ...options,
    url: '/packs/{packId}/systemConnection',
  });
};

/**
 * Retrieve the system connection metadata of the Pack.
 * Retrieve the system connection metadata of the Pack.
 *
 */
export const getPackSystemConnection = <ThrowOnError extends boolean = false>(
  options: Options<GetPackSystemConnectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPackSystemConnectionResponse, GetPackSystemConnectionError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/systemConnection',
  });
};

/**
 * List permissions for a Pack
 * Get user, workspace, and/or global permissions for a given Pack.
 *
 */
export const getPackPermissions = <ThrowOnError extends boolean = false>(
  options: Options<GetPackPermissionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPackPermissionsResponse, GetPackPermissionsError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/permissions',
  });
};

/**
 * Add a permission for Pack
 * Create or modify user, workspace, or global permissions for a given Pack.
 *
 */
export const addPackPermission = <ThrowOnError extends boolean = false>(
  options: Options<AddPackPermissionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddPackPermissionResponse2, AddPackPermissionError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/permissions',
  });
};

/**
 * Delete a permission for Pack
 * Delete user, workspace, or global permissions for a given Pack.
 *
 */
export const deletePackPermission = <ThrowOnError extends boolean = false>(
  options: Options<DeletePackPermissionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeletePackPermissionResponse2, DeletePackPermissionError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/permissions/{permissionId}',
  });
};

/**
 * List makers for Pack
 * List makers for a given pack.
 *
 */
export const listPackMakers = <ThrowOnError extends boolean = false>(
  options: Options<ListPackMakersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackMakersResponse2, ListPackMakersError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/makers',
  });
};

/**
 * Add a maker for Pack
 * Set a maker for a given Pack. Used to display makers for a pack in the corresponding packs page.
 *
 */
export const addPackMaker = <ThrowOnError extends boolean = false>(
  options: Options<AddPackMakerData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddPackMakerResponse2, AddPackMakerError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/maker',
  });
};

/**
 * Delete a maker for Pack
 * Delete a maker for a given Pack, who will not be displayed in the corresponding packs page.
 *
 */
export const deletePackMaker = <ThrowOnError extends boolean = false>(
  options: Options<DeletePackMakerData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeletePackMakerResponse2, DeletePackMakerError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/maker/{loginId}',
  });
};

/**
 * List categories for Pack
 * List publishing categories for a given pack.
 *
 */
export const listPackCategories = <ThrowOnError extends boolean = false>(
  options: Options<ListPackCategoriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackCategoriesResponse2, ListPackCategoriesError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/categories',
  });
};

/**
 * Add a category for Pack
 * Add a publishing category for a given pack.
 *
 */
export const addPackCategory = <ThrowOnError extends boolean = false>(
  options: Options<AddPackCategoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AddPackCategoryResponse2, AddPackCategoryError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/category',
  });
};

/**
 * Delete a category for Pack
 * Delete a publishing category for a given pack.
 *
 */
export const deletePackCategory = <ThrowOnError extends boolean = false>(
  options: Options<DeletePackCategoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeletePackCategoryResponse2, DeletePackCategoryError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/category/{categoryName}',
  });
};

/**
 * Upload a Pack asset.
 * Request a signed s3 URL to upload your Pack asset.
 *
 */
export const uploadPackAsset = <ThrowOnError extends boolean = false>(
  options: Options<UploadPackAssetData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UploadPackAssetResponse, UploadPackAssetError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/uploadAsset',
  });
};

/**
 * Upload Pack source code.
 * Request a signed s3 URL to upload your Pack source code.
 *
 */
export const uploadPackSourceCode = <ThrowOnError extends boolean = false>(
  options: Options<UploadPackSourceCodeData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UploadPackSourceCodeResponse, UploadPackSourceCodeError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/uploadSourceCode',
  });
};

/**
 * Pack asset upload complete
 * Note the completion of the upload of a Pack asset.
 *
 */
export const packAssetUploadComplete = <ThrowOnError extends boolean = false>(
  options: Options<PackAssetUploadCompleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PackAssetUploadCompleteResponse2, PackAssetUploadCompleteError, ThrowOnError>(
    {
      ...options,
      url: '/packs/{packId}/assets/{packAssetId}/assetType/{packAssetType}/uploadComplete',
    },
  );
};

/**
 * Pack source code upload complete
 * Note the completion of the upload of a Pack source code.
 *
 */
export const packSourceCodeUploadComplete = <ThrowOnError extends boolean = false>(
  options: Options<PackSourceCodeUploadCompleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PackSourceCodeUploadCompleteResponse2,
    PackSourceCodeUploadCompleteError,
    ThrowOnError
  >({
    ...options,
    url: '/packs/{packId}/versions/{packVersion}/sourceCode/uploadComplete',
  });
};

/**
 * get the source code for a Pack version.
 * Get temporary links used to download the source code for the given packId and version
 *
 */
export const getPackSourceCode = <ThrowOnError extends boolean = false>(
  options: Options<GetPackSourceCodeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPackSourceCodeResponse, GetPackSourceCodeError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/versions/{packVersion}/sourceCode',
  });
};

/**
 * List the Pack listings accessible to a user.
 * Get listings of public Packs and Packs created by you.
 *
 */
export const listPackListings = <ThrowOnError extends boolean = false>(
  options?: Options<ListPackListingsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackListingsResponse, ListPackListingsError, ThrowOnError>({
    ...options,
    url: '/packs/listings',
  });
};

/**
 * Get detailed listing information for a Pack.
 * Get detailed listing information for a Pack.
 *
 */
export const getPackListing = <ThrowOnError extends boolean = false>(
  options: Options<GetPackListingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPackListingResponse, GetPackListingError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/listing',
  });
};

/**
 * Retrieve the logs of a Pack.
 * Retrieve the logs of a Pack for debugging purpose.
 *
 */
export const listPackLogs = <ThrowOnError extends boolean = false>(
  options: Options<ListPackLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackLogsResponse, ListPackLogsError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/docs/{docId}/logs',
  });
};

/**
 * Retrieve the logs of a Ingestion.
 * Retrieve the logs of a Ingestion for debugging purpose.
 */
export const listIngestionLogs = <ThrowOnError extends boolean = false>(
  options: Options<ListIngestionLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListIngestionLogsResponse, ListIngestionLogsError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/organizationId/{organizationId}/rootIngestionId/{rootIngestionId}/logs',
  });
};

/**
 * Retrieve the grouped logs of a Pack.
 * Retrieve the grouped logs of a Pack for debugging purpose.
 *
 */
export const listGroupedPackLogs = <ThrowOnError extends boolean = false>(
  options: Options<ListGroupedPackLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGroupedPackLogsResponse, ListGroupedPackLogsError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/docs/{docId}/groupedLogs',
  });
};

/**
 * Retrieve the grouped logs of a Pack for a specific ingestionExecutionId.
 * Retrieve the grouped logs of a Pack for debugging purpose.
 *
 */
export const listGroupedIngestionLogs = <ThrowOnError extends boolean = false>(
  options: Options<ListGroupedIngestionLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListGroupedIngestionLogsResponse, ListGroupedIngestionLogsError, ThrowOnError>(
    {
      ...options,
      url: '/packs/{packId}/organizationId/{organizationId}/rootIngestionId/{rootIngestionId}/ingestionExecutionId/{ingestionExecutionId}/groupedLogs',
    },
  );
};

/**
 * Retrieve a list of ingestion execution ids for the given root ingestion id.
 * Retrieve the ingestion execution ids of a root ingestion for debugging purpose.
 *
 */
export const listIngestionExecutions = <ThrowOnError extends boolean = false>(
  options: Options<ListIngestionExecutionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListIngestionExecutionsResponse, ListIngestionExecutionsError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/organizationId/{organizationId}/rootIngestionId/{rootIngestionId}/ingestionExecutions',
  });
};

/**
 * List featured docs for a Pack
 * Returns a list of featured doc ids for a Pack.
 *
 */
export const listPackFeaturedDocs = <ThrowOnError extends boolean = false>(
  options: Options<ListPackFeaturedDocsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListPackFeaturedDocsResponse, ListPackFeaturedDocsError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/featuredDocs',
  });
};

/**
 * Update featured docs for a Pack
 * Create or replace the featured docs for a Pack.
 *
 */
export const updatePackFeaturedDocs = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePackFeaturedDocsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdatePackFeaturedDocsResponse2, UpdatePackFeaturedDocsError, ThrowOnError>({
    ...options,
    url: '/packs/{packId}/featuredDocs',
  });
};
