// Generated by ts-to-zod
import { z } from 'zod';

import {
  type BatchMessageRequest,
  type CreateMessageRequest,
  type Block,
  type ToolResultBlock,
  type ContentBlockStartEvent,
  type CreateMessageBatchRequest,
  type Message,
  type MessageStartEvent,
  type MessageStreamEvent,
  type CreateMessageData,
  type CreateMessageResponse,
  type CreateMessageBatchData,
} from './types.gen';

export const textBlockDeltaSchema = z.object({
  text: z.string(),
  type: z.literal('text_delta'),
});

export const inputJsonBlockDeltaSchema = z.object({
  partial_json: z.string().optional(),
  type: z.literal('input_json_delta'),
});

export const cacheControlEphemeralSchema = z.object({
  type: z.literal('ephemeral').optional(),
});

export const typeSchema = z.literal('ephemeral');

export const blockDeltaSchema = z.union([textBlockDeltaSchema, inputJsonBlockDeltaSchema]);

export const contentBlockStopEventSchema = z.object({
  index: z.number(),
  type: z.literal('content_block_stop'),
});

export const createMessageRequestMetadataSchema = z.object({
  user_id: z.string().optional(),
});

export const errorSchema = z.object({
  type: z.string(),
  message: z.string(),
});

export const errorEventSchema = z.object({
  type: z.literal('error'),
  error: errorSchema,
});

export const imageBlockSourceSchema = z.object({
  data: z.string(),
  media_type: z.union([
    z.literal('image/jpeg'),
    z.literal('image/png'),
    z.literal('image/gif'),
    z.literal('image/webp'),
  ]),
  type: z.literal('base64'),
});

export const mediaTypeSchema = z.union([
  z.literal('image/jpeg'),
  z.literal('image/png'),
  z.literal('image/gif'),
  z.literal('image/webp'),
]);

export const type2Schema = z.literal('base64');

export const messageRoleSchema = z.union([z.literal('user'), z.literal('assistant')]);

export const stopReasonSchema = z.union([
  z.literal('end_turn'),
  z.literal('max_tokens'),
  z.literal('stop_sequence'),
  z.literal('tool_use'),
]);

export const usageSchema = z.object({
  input_tokens: z.number(),
  output_tokens: z.number(),
  cache_creation_input_tokens: z.number().optional(),
  cache_read_input_tokens: z.number().optional(),
});

export const messageBatchRequestCountsSchema = z.object({
  processing: z.number(),
  succeeded: z.number(),
  errored: z.number(),
  canceled: z.number(),
  expired: z.number(),
});

export const processingStatusSchema = z.union([z.literal('in_progress'), z.literal('canceling'), z.literal('ended')]);

export const type3Schema = z.literal('message_batch');

export const messageDeltaSchema = z.object({
  stop_reason: stopReasonSchema.optional(),
  stop_sequence: z.string().optional(),
});

export const messageDeltaUsageSchema = z.object({
  output_tokens: z.number(),
});

export const messageStopEventSchema = z.object({
  type: z.literal('message_stop'),
});

export const messageDeltaEventSchema = z.object({
  delta: messageDeltaSchema,
  type: z.literal('message_delta'),
  usage: messageDeltaUsageSchema,
});

export const contentBlockDeltaEventSchema = z.object({
  delta: blockDeltaSchema,
  index: z.number(),
  type: z.literal('content_block_delta'),
});

export const pingEventSchema = z.object({
  type: z.literal('ping'),
});

export const messageStreamEventTypeSchema = z.union([
  z.literal('message_start'),
  z.literal('message_delta'),
  z.literal('message_stop'),
  z.literal('content_block_start'),
  z.literal('content_block_delta'),
  z.literal('content_block_stop'),
  z.literal('ping'),
  z.literal('error'),
]);

export const textBlockSchema = z.object({
  text: z.string(),
  type: z.literal('text').optional(),
  cache_control: cacheControlEphemeralSchema.optional(),
});

export const toolCustomSchema = z.object({
  type: z.literal('ToolCustom').optional(),
  name: z.string(),
  description: z.string().optional(),
  input_schema: z.record(z.unknown()),
});

export const toolComputerUseSchema = z.object({
  type: z.literal('ToolComputerUse').optional(),
  name: z.string().optional(),
  cache_control: cacheControlEphemeralSchema.optional(),
  display_width_px: z.number(),
  display_height_px: z.number(),
  display_number: z.number().optional().nullable(),
});

export const toolTextEditorSchema = z.object({
  type: z.literal('ToolTextEditor').optional(),
  name: z.string().optional(),
  cache_control: cacheControlEphemeralSchema.optional(),
});

export const toolBashSchema = z.object({
  type: z.literal('ToolBash').optional(),
  name: z.string().optional(),
  cache_control: cacheControlEphemeralSchema.optional(),
});

export const toolChoiceTypeSchema = z.union([z.literal('auto'), z.literal('any'), z.literal('tool')]);

export const toolUseBlockSchema = z.object({
  id: z.string(),
  name: z.string(),
  input: z.record(z.unknown()),
  type: z.literal('tool_use').optional(),
  cache_control: cacheControlEphemeralSchema.optional(),
});

export const createMessageErrorSchema = z.unknown();

export const messageBatchSchema = z.object({
  id: z.string(),
  created_at: z.string(),
  expires_at: z.string(),
  processing_status: z.union([z.literal('in_progress'), z.literal('canceling'), z.literal('ended')]),
  request_counts: messageBatchRequestCountsSchema,
  results_url: z.string().optional().nullable(),
  type: z.literal('message_batch'),
});

export const createMessageBatchErrorSchema = z.unknown();

export const retrieveMessageBatchDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const retrieveMessageBatchResponseSchema = messageBatchSchema;

export const retrieveMessageBatchErrorSchema = z.unknown();

export const imageBlockSchema = z.object({
  source: imageBlockSourceSchema,
  type: z.literal('image').optional(),
  cache_control: cacheControlEphemeralSchema.optional(),
});

export const toolChoiceSchema = z.object({
  type: toolChoiceTypeSchema,
  name: z.string().optional(),
  disable_parallel_tool_use: z.boolean().optional(),
});

export const toolSchema = z.union([toolCustomSchema, toolComputerUseSchema, toolTextEditorSchema, toolBashSchema]);

export const createMessageBatchResponseSchema = messageBatchSchema;

export const batchMessageRequestSchema: z.ZodSchema<BatchMessageRequest> = z.lazy(() =>
  z.object({
    custom_id: z.string(),
    params: createMessageRequestSchema,
  }),
);

export const createMessageRequestSchema: z.ZodSchema<CreateMessageRequest> = z.lazy(() =>
  z.object({
    model: z.union([
      z.string(),
      z.literal('claude-3-5-sonnet-latest'),
      z.literal('claude-3-5-sonnet-20241022'),
      z.literal('claude-3-5-sonnet-20240620'),
      z.literal('claude-3-opus-latest'),
      z.literal('claude-3-opus-20240229'),
      z.literal('claude-3-sonnet-20240229'),
      z.literal('claude-3-haiku-20240307'),
      z.literal('claude-2.1'),
      z.literal('claude-2.0'),
      z.literal('claude-instant-1.2'),
    ]),
    messages: z.array(messageSchema),
    max_tokens: z.number(),
    metadata: createMessageRequestMetadataSchema.optional(),
    stop_sequences: z.array(z.string()).optional(),
    system: z.union([z.string(), z.array(blockSchema)]).optional(),
    temperature: z.number().optional(),
    tool_choice: toolChoiceSchema.optional(),
    tools: z.array(toolSchema).optional(),
    top_k: z.number().optional(),
    top_p: z.number().optional(),
    stream: z.boolean().optional(),
  }),
);

export const blockSchema: z.ZodSchema<Block> = z.lazy(() =>
  z.union([textBlockSchema, imageBlockSchema, toolUseBlockSchema, toolResultBlockSchema]),
);

export const toolResultBlockSchema: z.ZodSchema<ToolResultBlock> = z.lazy(() =>
  z.object({
    tool_use_id: z.string(),
    content: z.union([z.string(), z.array(blockSchema)]),
    is_error: z.boolean().optional(),
    type: z.literal('tool_result').optional(),
    cache_control: cacheControlEphemeralSchema.optional(),
  }),
);

export const contentBlockStartEventSchema: z.ZodSchema<ContentBlockStartEvent> = z.lazy(() =>
  z.object({
    content_block: blockSchema,
    index: z.number(),
    type: z.literal('content_block_start'),
  }),
);

export const createMessageBatchRequestSchema: z.ZodSchema<CreateMessageBatchRequest> = z.lazy(() =>
  z.object({
    requests: z.array(batchMessageRequestSchema),
  }),
);

export const messageSchema: z.ZodSchema<Message> = z.lazy(() =>
  z.object({
    id: z.string().optional(),
    content: z.union([z.string(), z.array(blockSchema)]),
    role: messageRoleSchema,
    model: z.string().optional(),
    stop_reason: stopReasonSchema.optional(),
    stop_sequence: z.string().optional(),
    type: z.string().optional(),
    usage: usageSchema.optional(),
  }),
);

export const messageStartEventSchema: z.ZodSchema<MessageStartEvent> = z.lazy(() =>
  z.object({
    message: messageSchema,
    type: z.literal('message_start'),
  }),
);

export const messageStreamEventSchema: z.ZodSchema<MessageStreamEvent> = z.lazy(() =>
  z.union([
    messageStartEventSchema,
    messageDeltaEventSchema,
    messageStopEventSchema,
    contentBlockStartEventSchema,
    contentBlockDeltaEventSchema,
    contentBlockStopEventSchema,
    pingEventSchema,
    errorEventSchema,
  ]),
);

export const createMessageDataSchema: z.ZodSchema<CreateMessageData> = z.lazy(() =>
  z.object({
    body: createMessageRequestSchema,
  }),
);

export const createMessageResponseSchema: z.ZodSchema<CreateMessageResponse> = z.lazy(() => messageSchema);

export const createMessageBatchDataSchema: z.ZodSchema<CreateMessageBatchData> = z.lazy(() =>
  z.object({
    body: createMessageBatchRequestSchema,
  }),
);
