// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  CreateMessageData,
  CreateMessageError,
  CreateMessageResponse,
  CreateMessageBatchData,
  CreateMessageBatchError,
  CreateMessageBatchResponse,
  RetrieveMessageBatchData,
  RetrieveMessageBatchError,
  RetrieveMessageBatchResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Create a Message
 * Send a structured list of input messages with text and/or image content, and the
 * model will generate the next message in the conversation.
 *
 * The Messages API can be used for either single queries or stateless multi-turn
 * conversations.
 *
 */
export const createMessage = <ThrowOnError extends boolean = false>(
  options: Options<CreateMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateMessageResponse, CreateMessageError, ThrowOnError>({
    ...options,
    url: '/messages',
  });
};

/**
 * Create a Message Batch
 * Send a batch of Message creation requests.
 */
export const createMessageBatch = <ThrowOnError extends boolean = false>(
  options: Options<CreateMessageBatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateMessageBatchResponse, CreateMessageBatchError, ThrowOnError>({
    ...options,
    url: '/messages/batches',
  });
};

/**
 * Retrieve a Message Batch
 * This endpoint is idempotent and can be used to poll for Message Batch
 * completion. To access the results of a Message Batch, make a request to the
 * `results_url` field in the response.
 *
 */
export const retrieveMessageBatch = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveMessageBatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveMessageBatchResponse, RetrieveMessageBatchError, ThrowOnError>({
    ...options,
    url: '/messages/batches/{id}',
  });
};
