// This file is auto-generated by @hey-api/openapi-ts

export const CreateMessageRequestSchema = {
  required: ['model', 'messages', 'max_tokens'],
  type: 'object',
  properties: {
    model: {
      title: 'Model',
      anyOf: [
        {
          type: 'string',
          description: 'The ID of the model to use for this request.',
        },
        {
          title: 'Models',
          enum: [
            'claude-3-5-sonnet-latest',
            'claude-3-5-sonnet-20241022',
            'claude-3-5-sonnet-20240620',
            'claude-3-opus-latest',
            'claude-3-opus-20240229',
            'claude-3-sonnet-20240229',
            'claude-3-haiku-20240307',
            'claude-2.1',
            'claude-2.0',
            'claude-instant-1.2',
          ],
          type: 'string',
          description: `Available models. Mind that the list may not be exhaustive nor up-to-date.
`,
        },
      ],
      description: `The model that will complete your prompt.

See [models](https://docs.anthropic.com/en/docs/models-overview) for additional
details and options.
`,
      example: 'claude-3-5-sonnet-20241022',
    },
    messages: {
      minItems: 1,
      type: 'array',
      items: {
        $ref: '#/components/schemas/Message',
      },
      description: `Input messages.

Our models are trained to operate on alternating \`user\` and \`assistant\`
conversational turns. When creating a new \`Message\`, you specify the prior
conversational turns with the \`messages\` parameter, and the model then generates
the next \`Message\` in the conversation.

Each input message must be an object with a \`role\` and \`content\`. You can
specify a single \`user\`-role message, or you can include multiple \`user\` and
\`assistant\` messages. The first message must always use the \`user\` role.

If the final message uses the \`assistant\` role, the response content will
continue immediately from the content in that message. This can be used to
constrain part of the model's response.

See [message content](https://docs.anthropic.com/en/api/messages-content) for
details on how to construct valid message objects.

Example with a single \`user\` message:

\`\`\`json
[{ "role": "user", "content": "Hello, Claude" }]
\`\`\`

Example with multiple conversational turns:

\`\`\`json
[
  { "role": "user", "content": "Hello there." },
  { "role": "assistant", "content": "Hi, I'm Claude. How can I help you?" },
  { "role": "user", "content": "Can you explain LLMs in plain English?" }
]
\`\`\`

Example with a partially-filled response from Claude:

\`\`\`json
[
  {
    "role": "user",
    "content": "What's the Greek name for Sun? (A) Sol (B) Helios (C) Sun"
  },
  { "role": "assistant", "content": "The best answer is (" }
]
\`\`\`

Each input message \`content\` may be either a single \`string\` or an array of
content blocks, where each block has a specific \`type\`. Using a \`string\` for
\`content\` is shorthand for an array of one content block of type \`"text"\`. The
following input messages are equivalent:

\`\`\`json
{ "role": "user", "content": "Hello, Claude" }
\`\`\`

\`\`\`json
{ "role": "user", "content": [{ "type": "text", "text": "Hello, Claude" }] }
\`\`\`

Starting with Claude 3 models, you can also send image content blocks:

\`\`\`json
{
  "role": "user",
  "content": [
    {
      "type": "image",
      "source": {
        "type": "base64",
        "media_type": "image/jpeg",
        "data": "/9j/4AAQSkZJRg..."
      }
    },
    { "type": "text", "text": "What is in this image?" }
  ]
}
\`\`\`

We currently support the \`base64\` source type for images, and the \`image/jpeg\`,
\`image/png\`, \`image/gif\`, and \`image/webp\` media types.

See [examples](https://docs.anthropic.com/en/api/messages-examples) for more
input examples.

Note that if you want to include a
[system prompt](https://docs.anthropic.com/en/docs/system-prompts), you can use
the top-level \`system\` parameter — there is no \`"system"\` role for input
messages in the Messages API.
`,
    },
    max_tokens: {
      type: 'integer',
      description: `The maximum number of tokens to generate before stopping.

Note that our models may stop _before_ reaching this maximum. This parameter
only specifies the absolute maximum number of tokens to generate.

Different models have different maximum values for this parameter. See
[models](https://docs.anthropic.com/en/docs/models-overview) for details.
`,
    },
    metadata: {
      $ref: '#/components/schemas/CreateMessageRequestMetadata',
    },
    stop_sequences: {
      type: 'array',
      items: {
        type: 'string',
      },
      description: `Custom text sequences that will cause the model to stop generating.

Our models will normally stop when they have naturally completed their turn,
which will result in a response \`stop_reason\` of \`"end_turn"\`.

If you want the model to stop generating when it encounters custom strings of
text, you can use the \`stop_sequences\` parameter. If the model encounters one of
the custom sequences, the response \`stop_reason\` value will be \`"stop_sequence"\`
and the response \`stop_sequence\` value will contain the matched stop sequence.
`,
    },
    system: {
      type: 'string',
      oneOf: [
        {
          type: 'string',
          description: 'A single text block.',
        },
        {
          type: 'array',
          items: {
            $ref: '#/components/schemas/Block',
          },
          description: 'An array of content blocks.',
        },
      ],
      description: `System prompt.

A system prompt is a way of providing context and instructions to Claude, such
as specifying a particular goal or role. See our
[guide to system prompts](https://docs.anthropic.com/en/docs/system-prompts).
`,
    },
    temperature: {
      type: 'number',
      description: `Amount of randomness injected into the response.

Defaults to \`1.0\`. Ranges from \`0.0\` to \`1.0\`. Use \`temperature\` closer to \`0.0\`
for analytical / multiple choice, and closer to \`1.0\` for creative and
generative tasks.

Note that even with \`temperature\` of \`0.0\`, the results will not be fully
deterministic.
`,
    },
    tool_choice: {
      $ref: '#/components/schemas/ToolChoice',
    },
    tools: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Tool',
      },
      description: `Definitions of tools that the model may use.

If you include \`tools\` in your API request, the model may return \`tool_use\`
content blocks that represent the model's use of those tools. You can then run
those tools using the tool input generated by the model and then optionally
return results back to the model using \`tool_result\` content blocks.

Each tool definition includes:

- \`name\`: Name of the tool.
- \`description\`: Optional, but strongly-recommended description of the tool.
- \`input_schema\`: [JSON schema](https://json-schema.org/) for the tool \`input\`
  shape that the model will produce in \`tool_use\` output content blocks.

For example, if you defined \`tools\` as:

\`\`\`json
[
  {
    "name": "get_stock_price",
    "description": "Get the current stock price for a given ticker symbol.",
    "input_schema": {
      "type": "object",
      "properties": {
        "ticker": {
          "type": "string",
          "description": "The stock ticker symbol, e.g. AAPL for Apple Inc."
        }
      },
      "required": ["ticker"]
    }
  }
]
\`\`\`

And then asked the model "What's the S&P 500 at today?", the model might produce
\`tool_use\` content blocks in the response like this:

\`\`\`json
[
  {
    "type": "tool_use",
    "id": "toolu_01D7FLrfh4GYq7yT1ULFeyMV",
    "name": "get_stock_price",
    "input": { "ticker": "^GSPC" }
  }
]
\`\`\`

You might then run your \`get_stock_price\` tool with \`{"ticker": "^GSPC"}\` as an
input, and return the following back to the model in a subsequent \`user\`
message:

\`\`\`json
[
  {
    "type": "tool_result",
    "tool_use_id": "toolu_01D7FLrfh4GYq7yT1ULFeyMV",
    "content": "259.75 USD"
  }
]
\`\`\`

Tools can be used for workflows that include running client-side tools and
functions, or more generally whenever you want the model to produce a particular
JSON structure of output.

See our [guide](https://docs.anthropic.com/en/docs/tool-use) for more details.
`,
    },
    top_k: {
      type: 'integer',
      description: `Only sample from the top K options for each subsequent token.

Used to remove "long tail" low probability responses.
[Learn more technical details here](https://towardsdatascience.com/how-to-sample-from-language-models-682bceb97277).

Recommended for advanced use cases only. You usually only need to use
\`temperature\`.
`,
    },
    top_p: {
      type: 'number',
      description: `Use nucleus sampling.

In nucleus sampling, we compute the cumulative distribution over all the options
for each subsequent token in decreasing probability order and cut it off once it
reaches a particular probability specified by \`top_p\`. You should either alter
\`temperature\` or \`top_p\`, but not both.

Recommended for advanced use cases only. You usually only need to use
\`temperature\`.
`,
    },
    stream: {
      type: 'boolean',
      description: `Whether to incrementally stream the response using server-sent events.

See [streaming](https://docs.anthropic.com/en/api/messages-streaming) for
details.
`,
      default: false,
    },
  },
  description: 'The request parameters for creating a message.',
} as const;

export const CreateMessageRequestMetadataSchema = {
  type: 'object',
  properties: {
    user_id: {
      type: 'string',
      description: `An external identifier for the user who is associated with the request.

This should be a uuid, hash value, or other opaque identifier. Anthropic may use
this id to help detect abuse. Do not include any identifying information such as
name, email address, or phone number.
`,
    },
  },
  description: 'An object describing metadata about the request.',
} as const;

export const ToolChoiceSchema = {
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/ToolChoiceType',
    },
    name: {
      type: 'string',
      description: 'The name of the tool to use.',
    },
    disable_parallel_tool_use: {
      type: 'boolean',
      description: 'Whether to disable parallel tool use.',
    },
  },
  description: `How the model should use the provided tools. The model can use a specific tool, 
any available tool, or decide by itself.

- \`auto\`: allows Claude to decide whether to call any provided tools or not. This is the default value.
- \`any\`: tells Claude that it must use one of the provided tools, but doesn’t force a particular tool.
- \`tool\`: allows us to force Claude to always use a particular tool specified in the \`name\` field.
`,
} as const;

export const ToolChoiceTypeSchema = {
  enum: ['auto', 'any', 'tool'],
  type: 'string',
  description: `How the model should use the provided tools. The model can use a specific tool, 
any available tool, or decide by itself.

- \`auto\`: allows Claude to decide whether to call any provided tools or not. This is the default value.
- \`any\`: tells Claude that it must use one of the provided tools, but doesn't force a particular tool.
- \`tool\`: allows us to force Claude to always use a particular tool specified in the \`name\` field.
`,
} as const;

export const MessageSchema = {
  required: ['content', 'role'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: `Unique object identifier.

The format and length of IDs may change over time.
`,
    },
    content: {
      oneOf: [
        {
          type: 'string',
          description: 'A single text block.',
        },
        {
          type: 'array',
          items: {
            $ref: '#/components/schemas/Block',
          },
          description: 'An array of content blocks.',
        },
      ],
      description: 'The content of the message.',
    },
    role: {
      $ref: '#/components/schemas/MessageRole',
    },
    model: {
      type: 'string',
      description: 'The model that handled the request.',
    },
    stop_reason: {
      $ref: '#/components/schemas/StopReason',
    },
    stop_sequence: {
      type: 'string',
      description: `Which custom stop sequence was generated, if any.

This value will be a non-null string if one of your custom stop sequences was
generated.
`,
    },
    type: {
      type: 'string',
      description: `Object type.

For Messages, this is always \`"message"\`.
`,
    },
    usage: {
      $ref: '#/components/schemas/Usage',
    },
  },
  description: 'A message in a chat conversation.',
} as const;

export const MessageRoleSchema = {
  enum: ['user', 'assistant'],
  type: 'string',
  description: 'The role of the messages author.',
} as const;

export const ToolSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/ToolCustom',
    },
    {
      $ref: '#/components/schemas/ToolComputerUse',
    },
    {
      $ref: '#/components/schemas/ToolTextEditor',
    },
    {
      $ref: '#/components/schemas/ToolBash',
    },
  ],
  description: 'A tool the model may use.',
  discriminator: {
    propertyName: 'type',
  },
} as const;

export const ToolCustomSchema = {
  required: ['name', 'input_schema'],
  type: 'object',
  properties: {
    type: {
      type: 'string',
      description: 'The type of tool.',
      default: null,
    },
    name: {
      type: 'string',
      description: 'The name of the tool. Must match the regex `^[a-zA-Z0-9_-]{1,64}$`.',
    },
    description: {
      type: 'string',
      description: `Description of what this tool does.

Tool descriptions should be as detailed as possible. The more information that
the model has about what the tool is and how to use it, the better it will
perform. You can use natural language descriptions to reinforce important
aspects of the tool input JSON schema.
`,
    },
    input_schema: {
      type: 'object',
      description: `[JSON schema](https://json-schema.org/) for this tool's input.

This defines the shape of the \`input\` that your tool accepts and that the model
will produce.
`,
    },
  },
  description: 'A custom tool the model may use.',
} as const;

export const ToolComputerUseSchema = {
  required: ['display_width_px', 'display_height_px'],
  type: 'object',
  properties: {
    type: {
      type: 'string',
      description: 'The type of tool.',
      default: 'computer_20241022',
    },
    name: {
      type: 'string',
      description: 'The name of the tool.',
      default: 'computer',
    },
    cache_control: {
      $ref: '#/components/schemas/CacheControlEphemeral',
    },
    display_width_px: {
      type: 'integer',
      description: 'The width of the display in pixels.',
    },
    display_height_px: {
      type: 'integer',
      description: 'The height of the display in pixels.',
    },
    display_number: {
      type: 'integer',
      description: 'The number of the display to use.',
      nullable: true,
    },
  },
  description: 'A tool that uses a mouse and keyboard to interact with a computer, and take screenshots.',
} as const;

export const ToolTextEditorSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'string',
      description: 'The type of tool.',
      default: 'text_editor_20241022',
    },
    name: {
      type: 'string',
      description: 'The name of the tool.',
      default: 'str_replace_editor',
    },
    cache_control: {
      $ref: '#/components/schemas/CacheControlEphemeral',
    },
  },
  description: 'A tool for viewing, creating and editing files.',
} as const;

export const ToolBashSchema = {
  type: 'object',
  properties: {
    type: {
      type: 'string',
      description: 'The type of tool.',
      default: 'bash_20241022',
    },
    name: {
      type: 'string',
      description: 'The name of the tool.',
      default: 'bash',
    },
    cache_control: {
      $ref: '#/components/schemas/CacheControlEphemeral',
    },
  },
  description: 'A tool for running commands in a bash shell.',
} as const;

export const BlockSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/TextBlock',
    },
    {
      $ref: '#/components/schemas/ImageBlock',
    },
    {
      $ref: '#/components/schemas/ToolUseBlock',
    },
    {
      $ref: '#/components/schemas/ToolResultBlock',
    },
  ],
  description: 'A block of content in a message.',
  discriminator: {
    propertyName: 'type',
    mapping: {
      text: '#/components/schemas/TextBlock',
      image: '#/components/schemas/ImageBlock',
      tool_use: '#/components/schemas/ToolUseBlock',
      tool_result: '#/components/schemas/ToolResultBlock',
    },
  },
} as const;

export const TextBlockSchema = {
  required: ['text'],
  type: 'object',
  properties: {
    text: {
      type: 'string',
      description: 'The text content.',
    },
    type: {
      type: 'string',
      description: 'The type of content block.',
      default: 'text',
    },
    cache_control: {
      $ref: '#/components/schemas/CacheControlEphemeral',
    },
  },
  description: 'A block of text content.',
} as const;

export const ImageBlockSchema = {
  required: ['source'],
  type: 'object',
  properties: {
    source: {
      $ref: '#/components/schemas/ImageBlockSource',
    },
    type: {
      type: 'string',
      description: 'The type of content block.',
      default: 'image',
    },
    cache_control: {
      $ref: '#/components/schemas/CacheControlEphemeral',
    },
  },
  description: 'A block of image content.',
} as const;

export const ImageBlockSourceSchema = {
  required: ['data', 'media_type', 'type'],
  type: 'object',
  properties: {
    data: {
      type: 'string',
      description: 'The base64-encoded image data.',
    },
    media_type: {
      enum: ['image/jpeg', 'image/png', 'image/gif', 'image/webp'],
      type: 'string',
      description: 'The media type of the image.',
    },
    type: {
      enum: ['base64'],
      type: 'string',
      description: 'The type of image source.',
    },
  },
  description: 'The source of an image block.',
} as const;

export const ToolUseBlockSchema = {
  required: ['id', 'name', 'input'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: `A unique identifier for this particular tool use block. 
This will be used to match up the tool results later.
`,
      example: 'toolu_01A09q90qw90lq917835lq9',
    },
    name: {
      type: 'string',
      description: 'The name of the tool being used.',
      example: 'get_weather',
    },
    input: {
      type: 'object',
      description: "An object containing the input being passed to the tool, conforming to the tool's `input_schema`.",
    },
    type: {
      type: 'string',
      description: 'The type of content block.',
      default: 'tool_use',
    },
    cache_control: {
      $ref: '#/components/schemas/CacheControlEphemeral',
    },
  },
  description: 'The tool the model wants to use.',
} as const;

export const ToolResultBlockSchema = {
  required: ['tool_use_id', 'content'],
  type: 'object',
  properties: {
    tool_use_id: {
      type: 'string',
      description: 'The `id` of the tool use request this is a result for.',
    },
    content: {
      oneOf: [
        {
          type: 'string',
          description: 'A single text block.',
        },
        {
          type: 'array',
          items: {
            $ref: '#/components/schemas/Block',
          },
          description: 'An array of content blocks.',
        },
      ],
      description: `The result of the tool, as a string (e.g. \`"content": "15 degrees"\`) 
or list of nested content blocks (e.g. \`"content": [{"type": "text", "text": "15 degrees"}]\`). 
These content blocks can use the text or image types.
`,
    },
    is_error: {
      type: 'boolean',
      description: 'Set to `true` if the tool execution resulted in an error.',
    },
    type: {
      type: 'string',
      description: 'The type of content block.',
      default: 'tool_result',
    },
    cache_control: {
      $ref: '#/components/schemas/CacheControlEphemeral',
    },
  },
  description: 'The result of using a tool.',
} as const;

export const CacheControlEphemeralSchema = {
  type: 'object',
  properties: {
    type: {
      enum: ['ephemeral'],
      type: 'string',
      default: 'ephemeral',
    },
  },
  description: 'The cache control settings.',
} as const;

export const StopReasonSchema = {
  enum: ['end_turn', 'max_tokens', 'stop_sequence', 'tool_use'],
  type: 'string',
  description: `The reason that we stopped.

This may be one the following values:

- \`"end_turn"\`: the model reached a natural stopping point
- \`"max_tokens"\`: we exceeded the requested \`max_tokens\` or the model's maximum
- \`"stop_sequence"\`: one of your provided custom \`stop_sequences\` was generated
- \`"tool_use"\`: the model invoked one or more tools

In non-streaming mode this value is always non-null. In streaming mode, it is
null in the \`message_start\` event and non-null otherwise.
`,
  nullable: true,
} as const;

export const UsageSchema = {
  required: ['input_tokens', 'output_tokens'],
  type: 'object',
  properties: {
    input_tokens: {
      type: 'integer',
      description: 'The number of input tokens which were used.',
    },
    output_tokens: {
      type: 'integer',
      description: 'The number of output tokens which were used.',
    },
    cache_creation_input_tokens: {
      type: 'integer',
      description: 'The number of input tokens read from the cache.',
    },
    cache_read_input_tokens: {
      type: 'integer',
      description: 'The number of input tokens used to create the cache entry.',
    },
  },
  description: `Billing and rate-limit usage.

Anthropic's API bills and rate-limits by token counts, as tokens represent the
underlying cost to our systems.

Under the hood, the API transforms requests into a format suitable for the
model. The model's output then goes through a parsing stage before becoming an
API response. As a result, the token counts in \`usage\` will not match one-to-one
with the exact visible content of an API request or response.

For example, \`output_tokens\` will be non-zero, even for an empty string response
from Claude.
`,
} as const;

export const CreateMessageBatchRequestSchema = {
  required: ['requests'],
  type: 'object',
  properties: {
    requests: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/BatchMessageRequest',
      },
      description: 'List of requests for prompt completion. Each is an individual request to create a Message.',
    },
  },
  description: 'The request parameters for creating a message batch.',
} as const;

export const BatchMessageRequestSchema = {
  required: ['custom_id', 'params'],
  type: 'object',
  properties: {
    custom_id: {
      type: 'string',
      description: `Developer-provided ID created for each request in a Message Batch. Useful for
matching results to requests, as results may be given out of request order.

Must be unique for each request within the Message Batch.
`,
    },
    params: {
      $ref: '#/components/schemas/CreateMessageRequest',
    },
  },
  description: 'An individual message request within a batch.',
} as const;

export const MessageBatchSchema = {
  required: ['id', 'created_at', 'expires_at', 'processing_status', 'request_counts', 'type'],
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'Unique object identifier for the message batch.',
    },
    created_at: {
      type: 'string',
      description: 'RFC 3339 datetime string representing the time at which the Message Batch was created.',
      format: 'date-time',
    },
    expires_at: {
      type: 'string',
      description:
        'RFC 3339 datetime string representing the time at which the Message Batch will expire and end processing, which is 24 hours after creation.',
      format: 'date-time',
    },
    processing_status: {
      enum: ['in_progress', 'canceling', 'ended'],
      type: 'string',
      description: 'Processing status of the Message Batch.',
    },
    request_counts: {
      $ref: '#/components/schemas/MessageBatchRequestCounts',
    },
    results_url: {
      type: 'string',
      description:
        'URL to a `.jsonl` file containing the results of the Message Batch requests. Specified only once processing ends.',
      nullable: true,
    },
    type: {
      enum: ['message_batch'],
      type: 'string',
      description: 'Object type. For Message Batches, this is always `"message_batch"`.',
    },
  },
  description: 'A batch of message requests.',
} as const;

export const MessageBatchRequestCountsSchema = {
  required: ['processing', 'succeeded', 'errored', 'canceled', 'expired'],
  type: 'object',
  properties: {
    processing: {
      type: 'integer',
      description: 'Number of requests in the Message Batch that are processing.',
    },
    succeeded: {
      type: 'integer',
      description: 'Number of requests in the Message Batch that have completed successfully.',
    },
    errored: {
      type: 'integer',
      description: 'Number of requests in the Message Batch that encountered an error.',
    },
    canceled: {
      type: 'integer',
      description: 'Number of requests in the Message Batch that have been canceled.',
    },
    expired: {
      type: 'integer',
      description: 'Number of requests in the Message Batch that have expired.',
    },
  },
  description: 'Tallies requests within the Message Batch, categorized by their status.',
} as const;

export const MessageStreamEventSchema = {
  type: 'object',
  oneOf: [
    {
      $ref: '#/components/schemas/MessageStartEvent',
    },
    {
      $ref: '#/components/schemas/MessageDeltaEvent',
    },
    {
      $ref: '#/components/schemas/MessageStopEvent',
    },
    {
      $ref: '#/components/schemas/ContentBlockStartEvent',
    },
    {
      $ref: '#/components/schemas/ContentBlockDeltaEvent',
    },
    {
      $ref: '#/components/schemas/ContentBlockStopEvent',
    },
    {
      $ref: '#/components/schemas/PingEvent',
    },
    {
      $ref: '#/components/schemas/ErrorEvent',
    },
  ],
  description: 'A event in a streaming conversation.',
  discriminator: {
    propertyName: 'type',
    mapping: {
      message_start: '#/components/schemas/MessageStartEvent',
      message_delta: '#/components/schemas/MessageDeltaEvent',
      message_stop: '#/components/schemas/MessageStopEvent',
      content_block_start: '#/components/schemas/ContentBlockStartEvent',
      content_block_delta: '#/components/schemas/ContentBlockDeltaEvent',
      content_block_stop: '#/components/schemas/ContentBlockStopEvent',
      ping: '#/components/schemas/PingEvent',
      error: '#/components/schemas/ErrorEvent',
    },
  },
} as const;

export const MessageStreamEventTypeSchema = {
  enum: [
    'message_start',
    'message_delta',
    'message_stop',
    'content_block_start',
    'content_block_delta',
    'content_block_stop',
    'ping',
    'error',
  ],
  type: 'string',
  description: 'The type of a streaming event.',
} as const;

export const MessageStartEventSchema = {
  required: ['message', 'type'],
  type: 'object',
  properties: {
    message: {
      $ref: '#/components/schemas/Message',
    },
    type: {
      $ref: '#/components/schemas/MessageStreamEventType',
    },
  },
  description: 'A start event in a streaming conversation.',
} as const;

export const MessageDeltaEventSchema = {
  required: ['delta', 'type', 'usage'],
  type: 'object',
  properties: {
    delta: {
      $ref: '#/components/schemas/MessageDelta',
    },
    type: {
      $ref: '#/components/schemas/MessageStreamEventType',
    },
    usage: {
      $ref: '#/components/schemas/MessageDeltaUsage',
    },
  },
  description: 'A delta event in a streaming conversation.',
} as const;

export const MessageDeltaSchema = {
  type: 'object',
  properties: {
    stop_reason: {
      $ref: '#/components/schemas/StopReason',
    },
    stop_sequence: {
      type: 'string',
      description: `Which custom stop sequence was generated, if any.

This value will be a non-null string if one of your custom stop sequences was
generated.
`,
    },
  },
  description: 'A delta in a streaming message.',
} as const;

export const MessageDeltaUsageSchema = {
  required: ['output_tokens'],
  type: 'object',
  properties: {
    output_tokens: {
      type: 'integer',
      description: 'The cumulative number of output tokens which were used.',
    },
  },
  description: `Billing and rate-limit usage.

Anthropic's API bills and rate-limits by token counts, as tokens represent the
underlying cost to our systems.

Under the hood, the API transforms requests into a format suitable for the
model. The model's output then goes through a parsing stage before becoming an
API response. As a result, the token counts in \`usage\` will not match one-to-one
with the exact visible content of an API request or response.

For example, \`output_tokens\` will be non-zero, even for an empty string response
from Claude.
`,
} as const;

export const MessageStopEventSchema = {
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/MessageStreamEventType',
    },
  },
  description: 'A stop event in a streaming conversation.',
} as const;

export const ContentBlockStartEventSchema = {
  required: ['content_block', 'index', 'type'],
  type: 'object',
  properties: {
    content_block: {
      $ref: '#/components/schemas/Block',
    },
    index: {
      type: 'integer',
      description: 'The index of the content block.',
    },
    type: {
      $ref: '#/components/schemas/MessageStreamEventType',
    },
  },
  description: 'A start event in a streaming content block.',
} as const;

export const ContentBlockDeltaEventSchema = {
  required: ['delta', 'index', 'type'],
  type: 'object',
  properties: {
    delta: {
      $ref: '#/components/schemas/BlockDelta',
    },
    index: {
      type: 'integer',
      description: 'The index of the content block.',
    },
    type: {
      $ref: '#/components/schemas/MessageStreamEventType',
    },
  },
  description: 'A delta event in a streaming content block.',
} as const;

export const BlockDeltaSchema = {
  oneOf: [
    {
      $ref: '#/components/schemas/TextBlockDelta',
    },
    {
      $ref: '#/components/schemas/InputJsonBlockDelta',
    },
  ],
  description: 'A delta in a streaming message.',
  discriminator: {
    propertyName: 'type',
    mapping: {
      text_delta: '#/components/schemas/TextBlockDelta',
      input_json_delta: '#/components/schemas/InputJsonBlockDelta',
    },
  },
} as const;

export const TextBlockDeltaSchema = {
  required: ['text', 'type'],
  type: 'object',
  properties: {
    text: {
      type: 'string',
      description: 'The text delta.',
    },
    type: {
      type: 'string',
      description: 'The type of content block.',
      default: 'text_delta',
    },
  },
  description: 'A delta in a streaming text block.',
} as const;

export const InputJsonBlockDeltaSchema = {
  required: ['text', 'type'],
  type: 'object',
  properties: {
    partial_json: {
      type: 'string',
      description: 'The partial JSON delta.',
    },
    type: {
      type: 'string',
      description: 'The type of content block.',
      default: 'input_json_delta',
    },
  },
  description: 'A delta in a streaming input JSON.',
} as const;

export const ContentBlockStopEventSchema = {
  required: ['index', 'type'],
  type: 'object',
  properties: {
    index: {
      type: 'integer',
      description: 'The index of the content block.',
    },
    type: {
      $ref: '#/components/schemas/MessageStreamEventType',
    },
  },
  description: 'A stop event in a streaming content block.',
} as const;

export const PingEventSchema = {
  required: ['type'],
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/MessageStreamEventType',
    },
  },
  description: 'A ping event in a streaming conversation.',
} as const;

export const ErrorEventSchema = {
  required: ['type', 'error'],
  type: 'object',
  properties: {
    type: {
      $ref: '#/components/schemas/MessageStreamEventType',
    },
    error: {
      $ref: '#/components/schemas/Error',
    },
  },
  description: 'An error event in a streaming conversation.',
} as const;

export const ErrorSchema = {
  required: ['type', 'message'],
  type: 'object',
  properties: {
    type: {
      type: 'string',
      description: 'The type of error.',
    },
    message: {
      type: 'string',
      description: 'A human-readable error message.',
    },
  },
  description: 'An error object.',
} as const;
