// Generated by ts-to-zod
import { z } from 'zod';

export const apiKeyGetInfoRequestSchema = z.record(z.unknown());

export const statusSchema = z.union([
  z.literal('Hired'),
  z.literal('Archived'),
  z.literal('Active'),
  z.literal('Lead'),
]);

export const entityTypeSchema = z.literal('offer');

export const entityType2Schema = z.literal('Offer');

export const archiveReasonListRequestSchema = z.object({
  includeArchived: z.boolean().optional(),
});

export const assessmentPartnerStartResponseSchema = z.union([
  z.record(z.unknown()),
  z.object({
    success: z.boolean(),
    results: z.object({
      assessment_id: z.string(),
      _comment: z.string(),
      update_request: z.object({
        timestamp: z.number(),
        assessment_id: z.string(),
        assessment_profile_url: z.object({
          identifier: z.string(),
          type: z.string(),
          label: z.string(),
          value: z.string(),
        }),
        assessment_status: z.object({
          identifier: z.string(),
          type: z.string(),
          label: z.string(),
          value: z.string(),
        }),
      }),
      metadata: z.array(
        z.object({
          identifier: z.string().optional(),
          type: z.string().optional(),
          label: z.string().optional(),
          value: z.string().optional(),
        }),
      ),
    }),
  }),
]);

export const candidateAddTagRequestSchema = z.object({
  candidateId: z.string(),
  tagId: z.string(),
});

export const candidateCreateNoteRequestSchema = z.object({
  candidateId: z.string(),
  note: z.union([
    z.string(),
    z.object({
      type: z.union([z.literal('text/plain'), z.literal('text/html')]),
      value: z.string(),
    }),
  ]),
  sendNotifications: z.boolean().optional(),
});

export const typeSchema = z.union([z.literal('text/plain'), z.literal('text/html')]);

export const candidateListAllRequestSchema = z.object({
  cursor: z.string().optional(),
  syncToken: z.string().optional(),
  limit: z.number().optional(),
});

export const candidateGetByIdRequestSchema = z.union([
  z.object({
    id: z.string(),
  }),
  z.object({
    externalMappingId: z.string(),
  }),
]);

export const candidateSearchByEmailAndNameRequestSchema = z.object({
  email: z.string().optional(),
  name: z.string().optional(),
});

export const candidateTagCreateNewTagRequestSchema = z.object({
  title: z.string(),
});

export const candidateTagListAllRequestSchema = z.object({
  includeArchived: z.boolean().optional(),
});

export const customFieldCreateNewFieldRequestSchema = z.object({
  title: z.string(),
  description: z.string().optional(),
  fieldType: z.union([
    z.literal('Boolean'),
    z.literal('Date'),
    z.literal('MultiValueSelect'),
    z.literal('Number'),
    z.literal('String'),
    z.literal('ValueSelect'),
  ]),
  objectType: z.union([
    z.literal('Application'),
    z.literal('Candidate'),
    z.literal('Job'),
    z.literal('Employee'),
    z.literal('Talent_Project'),
    z.literal('Opening_Version'),
    z.literal('Offer_Version'),
  ]),
  selectableValues: z
    .array(
      z.object({
        label: z.string(),
        value: z.string(),
      }),
    )
    .optional(),
  isDateOnlyField: z.boolean().optional(),
  isExposableToCandidate: z.boolean().optional(),
});

export const fieldTypeSchema = z.union([
  z.literal('Boolean'),
  z.literal('Date'),
  z.literal('MultiValueSelect'),
  z.literal('Number'),
  z.literal('String'),
  z.literal('ValueSelect'),
]);

export const objectTypeSchema = z.union([
  z.literal('Application'),
  z.literal('Candidate'),
  z.literal('Job'),
  z.literal('Employee'),
  z.literal('Talent_Project'),
  z.literal('Opening_Version'),
  z.literal('Offer_Version'),
]);

export const objectType2Schema = z.union([
  z.literal('Application'),
  z.literal('Offer'),
  z.literal('Candidate'),
  z.literal('Job'),
]);

export const fieldType2Schema = z.union([
  z.literal('MultiValueSelect'),
  z.literal('NumberRange'),
  z.literal('String'),
  z.literal('Date'),
  z.literal('ValueSelect'),
  z.literal('Number'),
  z.literal('Currency'),
  z.literal('Boolean'),
]);

export const objectType3Schema = z.union([z.literal('Application'), z.literal('Candidate'), z.literal('Job')]);

export const departmentGetAllDepartmentsRequestSchema = z.object({
  includeArchived: z.boolean().optional(),
});

export const departmentTeamCreateNewDepartmentRequestSchema = z.object({
  name: z.string(),
  parentId: z.string().optional(),
});

export const fileGetUrlCandidateRequestSchema = z.object({
  fileHandle: z.string(),
});

export const hiringTeamRoleListRolesRequestSchema = z.object({
  namesOnly: z.boolean().optional(),
});

export const jobPostingGetAllPublishedRequestSchema = z.object({
  location: z.string().optional(),
  department: z.string().optional(),
  listedOnly: z.boolean().optional(),
});

export const type2Schema = z.literal('text/html');

export const jobSearchByTitleRequestSchema = z.object({
  title: z.string(),
});

export const locationCreateHierarchyRequestSchema = z.object({
  name: z.string(),
  type: z.union([z.literal('Location'), z.literal('LocationHierarchy')]),
  address: z
    .object({
      postalAddress: z
        .object({
          addressCountry: z.string().optional(),
          addressRegion: z.string().optional(),
          addressLocality: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  parentLocationId: z.string().optional(),
  isRemote: z.boolean().optional(),
});

export const type3Schema = z.union([z.literal('Location'), z.literal('LocationHierarchy')]);

export const status2Schema = z.union([
  z.literal('WaitingOnOfferCreation'),
  z.literal('WaitingOnApprovalStart'),
  z.literal('WaitingOnOfferApproval'),
  z.literal('WaitingOnCandidateResponse'),
  z.literal('CandidateAccepted'),
  z.literal('CandidateRejected'),
  z.literal('OfferCancelled'),
]);

export const openingsAddJobActionRequestSchema = z.object({
  openingId: z.string(),
  jobId: z.string(),
});

export const openingsCreateInstanceRequestSchema = z.object({
  description: z.string().optional(),
  identifier: z.string().optional(),
  teamId: z.string().optional(),
  locationIds: z.array(z.string()).optional(),
  jobIds: z.array(z.string()).optional(),
  targetHireDate: z.string().optional(),
  targetStartDate: z.string().optional(),
  isBackfill: z.boolean().optional(),
  employmentType: z
    .union([
      z.literal('FullTime'),
      z.literal('PartTime'),
      z.literal('Intern'),
      z.literal('Contract'),
      z.literal('Temporary'),
      z.literal(''),
    ])
    .optional(),
  openingState: z.union([z.literal('Draft'), z.literal('Approved'), z.literal('Open'), z.literal('Closed')]).optional(),
});

export const employmentTypeSchema = z.union([
  z.literal('FullTime'),
  z.literal('PartTime'),
  z.literal('Intern'),
  z.literal('Contract'),
  z.literal('Temporary'),
  z.literal(''),
]);

export const openingStateSchema = z.union([
  z.literal('Draft'),
  z.literal('Approved'),
  z.literal('Open'),
  z.literal('Closed'),
]);

export const openingsGetByUuidRequestSchema = z.object({
  openingId: z.string(),
});

export const openingState2Schema = z.union([
  z.literal('Approved'),
  z.literal('Closed'),
  z.literal('Draft'),
  z.literal('Filled'),
  z.literal('Open'),
]);

export const openingsGetListRequestSchema = z.object({
  cursor: z.string().optional(),
  syncToken: z.string().optional(),
});

export const openingsRemoveJobRequestSchema = z.object({
  openingId: z.string(),
  jobId: z.string(),
});

export const openingsSearchByIdentifierRequestSchema = z.object({
  identifier: z.string(),
});

export const openingsSetArchivedRequestSchema = z.object({
  openingId: z.string().optional(),
  archive: z.boolean().optional(),
});

export const openingsSetStateRequestSchema = z.object({
  openingId: z.string().optional(),
  openingState: z.union([z.literal('Draft'), z.literal('Approved'), z.literal('Open'), z.literal('Closed')]).optional(),
  closeReasonId: z.string().optional(),
});

export const openingsUpdateOpeningRequestSchema = z.object({
  description: z.string().optional(),
  openingId: z.string().optional(),
  identifier: z.string().optional(),
  teamId: z.string().optional(),
  targetHireDate: z.string().optional(),
  targetStartDate: z.string().optional(),
  isBackfill: z.boolean().optional(),
  employmentType: z
    .union([
      z.literal('FullTime'),
      z.literal('PartTime'),
      z.literal('Intern'),
      z.literal('Contract'),
      z.literal('Temporary'),
      z.literal(''),
    ])
    .optional(),
});

export const sourceGetAllRequestSchema = z.object({
  includeArchived: z.boolean().optional(),
});

export const surveySubmissionListBySurveyTypeRequestSchema = z
  .object({
    surveyType: z.union([
      z.literal('CandidateDataConsent'),
      z.literal('CandidateExperience'),
      z.literal('Diversity'),
      z.literal('EEOC'),
      z.literal('Questionnaire'),
    ]),
  })
  .and(candidateListAllRequestSchema);

export const surveyTypeSchema = z.union([
  z.literal('CandidateDataConsent'),
  z.literal('CandidateExperience'),
  z.literal('Diversity'),
  z.literal('EEOC'),
  z.literal('Questionnaire'),
]);

export const userGetAshbyUsersRequestSchema = candidateListAllRequestSchema.and(
  z.object({
    includeDeactivated: z.boolean().optional(),
  }),
);

export const globalRoleSchema = z.union([
  z.literal('Organization Admin'),
  z.literal('Elevated Access'),
  z.literal('Limited Access'),
  z.literal('External Recruiter'),
]);

export const userSearchByEmailRequestSchema = z.object({
  email: z.string(),
});

export const webhookCreateSettingRequestSchema = z.object({
  webhookType: z.union([
    z.literal('applicationSubmit'),
    z.literal('applicationUpdate'),
    z.literal('candidateHire'),
    z.literal('candidateStageChange'),
    z.literal('candidateDelete'),
    z.literal('candidateMerge'),
    z.literal('interviewPlanTransition'),
    z.literal('interviewScheduleCreate'),
    z.literal('interviewScheduleUpdate'),
    z.literal('jobPostingUpdate'),
    z.literal('jobPostingPublish'),
    z.literal('jobPostingUnpublish'),
    z.literal('offerCreate'),
    z.literal('offerUpdate'),
    z.literal('offerDelete'),
    z.literal('pushToHRIS'),
    z.literal('surveySubmit'),
  ]),
  requestUrl: z.string(),
  secretToken: z.string(),
});

export const webhookTypeSchema = z.union([
  z.literal('applicationSubmit'),
  z.literal('applicationUpdate'),
  z.literal('candidateHire'),
  z.literal('candidateStageChange'),
  z.literal('candidateDelete'),
  z.literal('candidateMerge'),
  z.literal('interviewPlanTransition'),
  z.literal('interviewScheduleCreate'),
  z.literal('interviewScheduleUpdate'),
  z.literal('jobPostingUpdate'),
  z.literal('jobPostingPublish'),
  z.literal('jobPostingUnpublish'),
  z.literal('offerCreate'),
  z.literal('offerUpdate'),
  z.literal('offerDelete'),
  z.literal('pushToHRIS'),
  z.literal('surveySubmit'),
]);

export const apiKeyGetInfoDataSchema = z.object({
  body: apiKeyGetInfoRequestSchema.optional(),
});

export const apiKeyGetInfoErrorSchema = z.unknown();

export const applicationChangeSourceErrorSchema = z.unknown();

export const applicationChangeStageErrorSchema = z.unknown();

export const applicationConsiderCandidateErrorSchema = z.unknown();

export const applicationGetDetailsErrorSchema = z.unknown();

export const applicationGetAllSchedulesErrorSchema = z.unknown();

export const applicationFeedbackListAllErrorSchema = z.unknown();

export const applicationFeedbackSubmitFeedbackErrorSchema = z.unknown();

export const applicationFormSubmitFormErrorSchema = z.unknown();

export const approvalDefinitionUpdateEntityScopeErrorSchema = z.unknown();

export const archiveReasonListDataSchema = z.object({
  body: archiveReasonListRequestSchema.optional(),
});

export const archiveReasonListErrorSchema = z.unknown();

export const assessmentAddCompletedToCandidateErrorSchema = z.unknown();

export const assessmentPartnerStartResponse2Schema = assessmentPartnerStartResponseSchema;

export const assessmentListPartnerSupportErrorSchema = z.unknown();

export const assessmentUpdateStatusErrorSchema = z.unknown();

export const assessmentCancelPartnerAssessmentErrorSchema = z.unknown();

export const candidateAddTagDataSchema = z.object({
  body: candidateAddTagRequestSchema.optional(),
});

export const candidateAddTagErrorSchema = z.unknown();

export const candidateAnonymizeCandidateErrorSchema = z.unknown();

export const candidateCreateNewCandidateErrorSchema = z.unknown();

export const candidateCreateNoteDataSchema = z.object({
  body: candidateCreateNoteRequestSchema.optional(),
});

export const candidateCreateNoteErrorSchema = z.unknown();

export const candidateGetByIdDataSchema = z.object({
  body: candidateGetByIdRequestSchema,
});

export const candidateGetByIdErrorSchema = z.unknown();

export const candidateListAllDataSchema = z.object({
  body: candidateListAllRequestSchema.optional(),
});

export const candidateListAllErrorSchema = z.unknown();

export const candidateGetAllNotesErrorSchema = z.unknown();

export const candidateSearchByEmailAndNameDataSchema = z.object({
  body: candidateSearchByEmailAndNameRequestSchema.optional(),
});

export const candidateSearchByEmailAndNameErrorSchema = z.unknown();

export const candidateUpdateExistingCandidateErrorSchema = z.unknown();

export const candidateAttachFileErrorSchema = z.unknown();

export const candidateUploadResumeDataErrorSchema = z.unknown();

export const candidateTagCreateNewTagDataSchema = z.object({
  body: candidateTagCreateNewTagRequestSchema.optional(),
});

export const candidateTagCreateNewTagErrorSchema = z.unknown();

export const candidateTagListAllDataSchema = z.object({
  body: candidateTagListAllRequestSchema.optional(),
});

export const candidateTagListAllErrorSchema = z.unknown();

export const customFieldCreateNewFieldDataSchema = z.object({
  body: customFieldCreateNewFieldRequestSchema.optional(),
});

export const customFieldCreateNewFieldErrorSchema = z.unknown();

export const customFieldGetAllDataSchema = z.object({
  body: candidateListAllRequestSchema.optional(),
});

export const customFieldGetAllErrorSchema = z.unknown();

export const customFieldSetValueErrorSchema = z.unknown();

export const departmentTeamCreateNewDepartmentDataSchema = z.object({
  body: departmentTeamCreateNewDepartmentRequestSchema.optional(),
});

export const departmentTeamCreateNewDepartmentErrorSchema = z.unknown();

export const departmentGetByIdErrorSchema = z.unknown();

export const departmentGetAllDepartmentsDataSchema = z.object({
  body: departmentGetAllDepartmentsRequestSchema.optional(),
});

export const departmentGetAllDepartmentsErrorSchema = z.unknown();

export const fileGetUrlCandidateDataSchema = z.object({
  body: fileGetUrlCandidateRequestSchema.optional(),
});

export const fileGetUrlCandidateErrorSchema = z.unknown();

export const feedbackFormDefinitionGetByIdErrorSchema = z.unknown();

export const feedbackFormDefinitionListAllErrorSchema = z.unknown();

export const hiringTeamAddMemberErrorSchema = z.unknown();

export const hiringTeamRoleListRolesDataSchema = z.object({
  body: hiringTeamRoleListRolesRequestSchema.optional(),
});

export const hiringTeamRoleListRolesErrorSchema = z.unknown();

export const interviewGetByIdErrorSchema = z.unknown();

export const interviewGetAllErrorSchema = z.unknown();

export const interviewEventListAssociatedEventsErrorSchema = z.unknown();

export const interviewPlanGetAllErrorSchema = z.unknown();

export const interviewScheduleCancelByIdErrorSchema = z.unknown();

export const interviewScheduleCreateScheduledInterviewErrorSchema = z.unknown();

export const interviewScheduleGetAllSchedulesErrorSchema = z.unknown();

export const interviewScheduleUpdateEventErrorSchema = z.unknown();

export const interviewStageListAllInOrderErrorSchema = z.unknown();

export const interviewStageGetByIdErrorSchema = z.unknown();

export const jobNewCreateErrorSchema = z.unknown();

export const jobGetByIdErrorSchema = z.unknown();

export const jobGetListErrorSchema = z.unknown();

export const jobSetStatusByIdErrorSchema = z.unknown();

export const jobUpdateExistingErrorSchema = z.unknown();

export const jobSearchByTitleDataSchema = z.object({
  body: jobSearchByTitleRequestSchema.optional(),
});

export const jobSearchByTitleErrorSchema = z.unknown();

export const jobInterviewPlanGetInfoErrorSchema = z.unknown();

export const jobPostingGetIndividualErrorSchema = z.unknown();

export const jobPostingGetAllPublishedDataSchema = z.object({
  body: jobPostingGetAllPublishedRequestSchema.optional(),
});

export const jobPostingGetAllPublishedErrorSchema = z.unknown();

export const jobPostingUpdateExistingErrorSchema = z.unknown();

export const locationCreateHierarchyDataSchema = z.object({
  body: locationCreateHierarchyRequestSchema.optional(),
});

export const locationCreateHierarchyErrorSchema = z.unknown();

export const locationDetailsByIdErrorSchema = z.unknown();

export const locationGetListErrorSchema = z.unknown();

export const offerCreateNewErrorSchema = z.unknown();

export const offerGetDetailsByIdErrorSchema = z.unknown();

export const offerGetListErrorSchema = z.unknown();

export const offerStartCreationInstanceErrorSchema = z.unknown();

export const offerProcessStartProcessForCandidateErrorSchema = z.unknown();

export const openingsGetByUuidDataSchema = z.object({
  body: openingsGetByUuidRequestSchema.optional(),
});

export const openingsGetByUuidErrorSchema = z.unknown();

export const openingsGetListDataSchema = z.object({
  body: openingsGetListRequestSchema.optional(),
});

export const openingsGetListErrorSchema = z.unknown();

export const openingsSearchByIdentifierDataSchema = z.object({
  body: openingsSearchByIdentifierRequestSchema.optional(),
});

export const openingsSearchByIdentifierErrorSchema = z.unknown();

export const openingsCreateInstanceDataSchema = z.object({
  body: openingsCreateInstanceRequestSchema.optional(),
});

export const openingsCreateInstanceErrorSchema = z.unknown();

export const openingsAddJobActionDataSchema = z.object({
  body: openingsAddJobActionRequestSchema.optional(),
});

export const openingsAddJobActionErrorSchema = z.unknown();

export const openingsRemoveJobDataSchema = z.object({
  body: openingsRemoveJobRequestSchema.optional(),
});

export const openingsRemoveJobErrorSchema = z.unknown();

export const openingsSetStateDataSchema = z.object({
  body: openingsSetStateRequestSchema.optional(),
});

export const openingsSetStateErrorSchema = z.unknown();

export const openingsSetArchivedDataSchema = z.object({
  body: openingsSetArchivedRequestSchema.optional(),
});

export const openingsSetArchivedErrorSchema = z.unknown();

export const openingsUpdateOpeningDataSchema = z.object({
  body: openingsUpdateOpeningRequestSchema.optional(),
});

export const openingsUpdateOpeningErrorSchema = z.unknown();

export const referralCreateNewErrorSchema = z.unknown();

export const referralFormGetDefaultFormErrorSchema = z.unknown();

export const sourceGetAllDataSchema = z.object({
  body: sourceGetAllRequestSchema.optional(),
});

export const sourceGetAllErrorSchema = z.unknown();

export const surveyFormDefinitionGetDetailsByIdErrorSchema = z.unknown();

export const surveyFormDefinitionGetAllDataSchema = z.object({
  body: candidateListAllRequestSchema.optional(),
});

export const surveyFormDefinitionGetAllErrorSchema = z.unknown();

export const surveyRequestGenerateUrlErrorSchema = z.unknown();

export const surveySubmissionListBySurveyTypeDataSchema = z.object({
  body: surveySubmissionListBySurveyTypeRequestSchema.optional(),
});

export const surveySubmissionListBySurveyTypeErrorSchema = z.unknown();

export const userGetByIdErrorSchema = z.unknown();

export const userGetAshbyUsersDataSchema = z.object({
  body: userGetAshbyUsersRequestSchema.optional(),
});

export const userGetAshbyUsersErrorSchema = z.unknown();

export const userSearchByEmailDataSchema = z.object({
  body: userSearchByEmailRequestSchema.optional(),
});

export const userSearchByEmailErrorSchema = z.unknown();

export const webhookCreateSettingDataSchema = z.object({
  body: webhookCreateSettingRequestSchema.optional(),
});

export const webhookCreateSettingErrorSchema = z.unknown();

export const webhookUpdateSettingErrorSchema = z.unknown();

export const webhookRemoveSettingErrorSchema = z.unknown();
