// This file is auto-generated by @hey-api/openapi-ts

export type ApiResponse<T> =
  | {
      success: true;
      results: T;
    }
  | {
      success: false;
      errors: string[];
    };

export type ApiResponseWithMoreData<T> =
  | {
      success: true;
      results: Array<T>;
      moreDataAvailable: boolean;
      nextCursor?: string;
      syncToken?: string;
    }
  | {
      success: false;
      errors: string[];
    };

export type CustomFieldValue =
  | boolean
  | { value?: number; currencyCode?: string }
  | Date
  | string
  | string[]
  | number
  | { required?: string; type?: string; minValue?: number; maxValue?: number }
  | {
      required?: string;
      type?: string;
      minValue?: number;
      maxValue?: number;
      currencyCode?: string;
      interval?:
        | 'NONE'
        | '1 TIME'
        | '1 HOUR'
        | '1 DAY'
        | '1 WEEK'
        | '2 WEEK'
        | '1 MONTH'
        | '2 MONTH'
        | '1 YEAR'
        | '6 MONTH'
        | '0.5 MONTH'
        | '3 MONTH';
    };

export type CustomField = {
  id: string;
  isPrivate?: boolean;
  title: string;
  value: CustomFieldValue;
};

export type Source = {
  id: string;
  title: string;
  isArchived: boolean;
  sourceType?: {
    id: string;
    title: string;
    isArchived: boolean;
  };
};

export type User = {
  id: string;
  firstName: string;
  lastName: string;
  email?: string;
  globalRole: globalRole;
  isEnabled: boolean;
  updatedAt: string;
};

export type ApiKeyGetInfoRequest = {
  [key: string]: unknown;
};

export type ApiKeyGetInfoResponse = ApiResponse<{
  title?: string;
  createdAt?: string;
}>;

export type ApplicationChangeSourceRequest = {
  applicationId: string;
  sourceId: string;
};

export type ApplicationData = {
  id: string;
  createdAt: string;
  updatedAt: string;
  status: status;
  customFields: Array<CustomField>;
  candidate: Pick<CandidateGetById, 'id' | 'name' | 'primaryEmailAddress' | 'primaryPhoneNumber'>;
  currentInterviewStage: {
    id: string;
    title: string;
    type: string;
    orderInInterviewPlan: number;
    interviewStageGroupId?: string;
    interviewPlanId: string;
  };
  source?: Source;
  archiveReason?: {
    id: string;
    text: string;
    reasonType: string;
    isArchived: boolean;
  };
  archivedAt?: string;
  job: {
    id: string;
    title: string;
    locationId?: string;
    departmentId?: string;
  };
  creditedToUser?: User;
  hiringTeam: Array<{
    email: string;
    firstName: string;
    lastName: string;
    role: string;
    userId: string;
  }>;
  appliedViaJobPostingId?: string;
};

export type ApplicationChangeSourceResponse = ApiResponse<ApplicationData>;

export type ApplicationChangeStageRequest = {
  applicationId: string;
  interviewStageId: string;
  archiveReasonId?: string;
};

export type ApplicationChangeStageResponse = ApiResponse<ApplicationData>;

export type ApplicationConsiderCandidateRequest = {
  candidateId: string;
  jobId: string;
  interviewPlanId?: string;
  interviewStageId?: string;
  sourceId?: string;
  creditedToUserId?: string;
};

export type ApplicationConsiderCandidateResponse = ApiResponse<ApplicationData>;

export type ApplicationFeedbackListAllRequest = Pick<
  ApplicationGetAllSchedulesRequest,
  'createdAfter' | 'cursor' | 'syncToken' | 'limit'
> & {
  applicationId?: string;
};

export type ApplicationFeedbackListAllResponse = ApiResponseWithMoreData<
  SubmittedFormInstance & {
    submittedByUser: User;
    interviewId?: string;
    feedbackFormDefinitionId?: string;
    applicationHistoryId?: string;
    applicationId: string;
    submittedAt?: string;
  }
>;

export type SubmittedFormInstance = {
  id: string;
  formDefinition: {
    title?: string;
    descriptionHtml?: string;
    descriptionPlain?: string;
    fields?: Array<{
      isRequired?: boolean;
      descriptionHtml?: string;
      descriptionPlain?: string;
      field?: {
        id?: string;
        type?: string;
        path?: string;
        humanReadablePath?: string;
        title?: string;
        isNullable?: boolean;
        selectableValues?: {
          label: string;
          value: string;
        };
      };
    }>;
  };
  submittedValues: {
    [key: string]: unknown;
  };
};

export type ApplicationFeedbackSubmitFeedbackResponse = ApiResponse<{
  submittedFormInstance: SubmittedFormInstance;
}>;

export type ApplicationFeedbackSubmitFeedbackRequest =
  | {
      feedbackForm: {
        fieldSubmissions: Array<{
          path: string;
          value: string;
        }>;
      };
      formDefinitionId: string;
      applicationId: string;
      userId?: string;
    }
  | {
      feedbackForm: {
        fieldSubmissions: Array<{
          path: string;
          value: string;
        }>;
      };
      formDefinitionId: string;
      applicationId: string;
      userId: string;
      interviewEventId: string;
    };

export type ApplicationFormSubmitFormRequest = {
  jobPostingId: string;
  applicationForm: {
    fieldSubmissions: Array<{
      path: string;
      value: string;
    }>;
  };
  utmData?: {
    utm_source?: string;
    utm_campaign?: string;
    utm_medium?: string;
    utm_term?: string;
    utm_content?: string;
  };
  /**
   * Any file referenced  in the `applicationForm`.   The name of this field must exactly match the `value` on the `fieldSubmission` that references this file.
   */
  '<file  key>'?: Blob | File;
  tagIds?: Array<string>;
};

export type ApplicationFormSubmitFormResponse = ApiResponse<{
  submittedFormInstance: SubmittedFormInstance;
  formMessages: {
    blockMessageForCandidateHtml?: string;
  };
}>;

export type ApplicationGetAllSchedulesRequest = {
  /**
   * The API will return data after this date, which is the time since the unix epoch in milliseconds
   */
  createdAfter?: number;
  cursor?: CandidateListAllRequest['cursor'];
  syncToken?: CandidateListAllRequest['syncToken'];
  limit?: CandidateListAllRequest['limit'];
} & {
  /**
   * Choose to expand the result and include additional data for related objects.
   *
   */
  expand?: Array<'openings'>;
  status?: status;
  jobId?: CandidateCreateNoteRequest['candidateId'];
};

export type status = 'Hired' | 'Archived' | 'Active' | 'Lead';

export type ApplicationGetAllSchedulesResponse = ApiResponseWithMoreData<ApplicationData>;

export type ApplicationGetDetailsRequest =
  | {
      applicationId: string;
      /**
       * Choose to expand the result and include additional data for related objects.
       *
       */
      expand?: Array<'openings' | 'applicationFormSubmissions'>;
    }
  | {
      submittedFormInstanceId: string;
      /**
       * Choose to expand the result and include additional data for related objects.
       *
       */
      expand?: Array<'openings' | 'applicationFormSubmissions'>;
    };

export type ApplicationGetDetailsResponse = ApiResponse<
  ApplicationData & {
    /**
     * The openings array will only be included if the `openings` expand parameter is included when the request is made.
     */
    openings?: Array<OpeningsGetByUuid>;
    applicationHistory?: Array<{
      title: string;
      id: string;
      stageId: string;
      enteredStageAt: string;
      leftStageAt?: string;
      stageNumber: number;
      allowedActions: Array<string>;
      actorId?: string;
    }>;
    /**
     * Application form submissions. These match the response from the `applicationForm.submit` endpoint. Use of the expand parameter is required to fetch.
     */
    applicationFormSubmissions?: Array<SubmittedFormInstance>;
    referrals?: Array<{
      user?: User;
      referredAt?: string;
    }>;
  }
>;

export type ApprovalDefinitionUpdateEntityScopeRequest = {
  entityType: 'offer';
  entityId: string;
  /**
   * An ordered list of approval steps that describes the number of required approvers at each step, as well as who is an approver at each step.
   */
  approvalStepDefinitions: Array<{
    /**
     * The number of approvers required to approve this step, before the approval moves on to the next step. The number of approvers must be non-zero and no more than the number of approvers in this step.
     */
    approvalsRequired: number;
    /**
     * An unordered list of who can approve this step.
     */
    approvers: Array<{
      userId: string;
      type: 'user';
    }>;
  }>;
  submitApprovalRequest?: boolean;
};

export type entityType = 'offer';

export type ApprovalDefinitionUpdateEntityScopeResponse = ApiResponse<{
  id?: string;
  entityType: 'Offer';
  entityId: string;
  approvalStepDefinitions: ApprovalDefinitionUpdateEntityScopeRequest['approvalStepDefinitions'];
}>;

export type entityType2 = 'Offer';

export type ArchiveReasonListRequest = {
  /**
   * When true, includes archived interview plans
   */
  includeArchived?: boolean;
};

export type ArchiveReasonListResponse = ApiResponse<{
  id: string;
  text: string;
  reasonType: 'RejectedByCandidate' | 'RejectedByOrg' | 'Other';
  isArchived: boolean;
}>;

export type AssessmentAddCompletedToCandidateRequest = {
  candidateId: string;
  partnerId: string;
  /**
   * The completed assessment
   */
  assessment: {
    assessmentTypeId: string;
    assessmentId: string;
    /**
     * The name of the assessment that was taken that will be displayed in the UI
     */
    assessmentName: string;
    result: AssessmentUpdateStatusRequest['metadata'];
    /**
     * An array of metadata associated with this completed assessment
     */
    metadata: Array<AssessmentUpdateStatusRequest['metadata']>;
  };
  timestamp: AssessmentUpdateStatusRequest['timestamp'];
};

export type AssessmentAddCompletedToCandidateResponse = ApiResponse<{
  applicationId?: string;
  assessmentId: string;
  assessmentName: string;
  assessmentTypeId: string;
  candidateId: string;
  metadata: Array<AssessmentUpdateStatusRequest['metadata']>;
  result?: AssessmentUpdateStatusRequest['metadata'];
}>;

export type AssessmentCancelPartnerAssessmentRequest = {
  assessment_id: string;
};

export type AssessmentCancelPartnerAssessmentResponse = ApiResponse<{
  assessment_id: string;
  update_request?: AssessmentUpdateStatusRequest & {
    assessment_result?: AssessmentUpdateStatusRequest['metadata'];
  };
}>;

export type AssessmentListPartnerSupportResponse = ApiResponse<
  Array<{
    description?: string;
    assessment_type_id?: string;
    name?: string;
  }>
>;

export type AssessmentPartnerStart409Response = {
  [key: string]: unknown;
};

export type AssessmentPartnerStartRequest = {
  assessment_type_id: string;
  candidate: {
    ashby_id: string;
    first_name: string;
    last_name: string;
    email: string;
    ashby_profile_url: string;
  };
  application: {
    ashby_id: string;
    status: status;
  };
  job: {
    ashby_id: string;
    name: string;
    req_id?: string;
    ashby_job_url: string;
    hiringTeam?: Array<HiringTeamMember>;
  };
};

export type AssessmentPartnerStartResponse = ApiResponse<{
  assessment_id: string;
  update_request: {
    timestamp: number;
    assessment_id: string;
    assessment_profile_url: {
      identifier: string;
      type: string;
      label: string;
      value: string;
    };
    assessment_status: {
      identifier: string;
      type: string;
      label: string;
      value: string;
    };
  };
  metadata: Array<{
    identifier?: string;
    type?: string;
    label?: string;
    value?: string;
  }>;
}>;

export type AssessmentUpdateStatusRequest = {
  assessment_id: string;
  assessment_status: AssessmentUpdateStatusRequest['metadata'];
  assessment_profile_url?: AssessmentUpdateStatusRequest['metadata'];
  /**
   * Any other metadata about the assessment (e.g. ETA until complete). All assessment data should have unique identifiers.
   */
  metadata?: Array<{
    /**
     * Description of the assessment metadata, which may be displayed in the UI
     */
    description?: string;
    /**
     * Uniquely identifies this field, for this partner
     */
    identifier: string;
    /**
     * Label for the assessment metadata to be displayed in the UI
     */
    label: string;
    /**
     * The type of the value. Please reach out if you'd like us to support a new type!
     */
    type: 'numeric_score' | 'numeric_duration_minutes' | 'url' | 'string' | 'boolean_success';
    value: (string | number | boolean) & unknown;
  }>;
  /**
   * The timestamp in milliseconds since the unix epoch, when the update occurred
   */
  timestamp: number;
};

export type AssessmentUpdateStatusResponse = {
  [key: string]: unknown;
};

export type CandidateAddTagRequest = {
  /**
   * The unique id of the candidate to add the tag to.
   */
  candidateId: string;
  /**
   * The unique id of the tag to add to the candidate.
   */
  tagId: string;
};

export type CandidateAddTagResponse = ApiResponse<CandidateGetById>;

export type CandidateAnonymizeCandidateRequest = {
  candidateId: string;
};

export type CandidateAnonymizeCandidateResponse = ApiResponse<CandidateGetById>;

export type CandidateAttachFileRequest = {
  candidateId: string;
  /**
   * The file to upload to the candidate's profile
   */
  file: Blob | File;
};

export type CandidateAttachFileResponse = ApiResponse<CandidateGetById>;

export type CandidateCreateNewCandidateRequest = {
  /**
   * The first and last name of the candidate to be created.
   */
  name: string;
  email?: string;
  phoneNumber?: string;
  /**
   * Url to the candidate's LinkedIn profile. Must be a valid Url.
   */
  linkedInUrl?: string;
  /**
   * Url to the candidate's Github profile. Must be a valid Url.
   */
  githubUrl?: string;
  /**
   * Url of the candidate's website. Must be a valid Url.
   */
  website?: string;
  /**
   * Array of alternate email address to add to the candidate's profile.
   */
  alternateEmailAddresses?: Array<string>;
  sourceId?: string;
  creditedToUserId?: string;
  location?: {
    city?: string;
    region?: string;
    country?: string;
  };
  createdAt?: string;
};

export type CandidateCreateNewCandidateResponse = ApiResponse<CandidateGetById>;

export type CandidateCreateNoteRequest = {
  candidateId: string;
  note:
    | string
    | {
        /**
         * The content type of the note. For notes submitted with a type of text/html we support the elements listed below. Any unsupported elements will be stripped out of the note's content before posting.
         * - Bold `<b>`
         * - Italic `<i>`
         * - Underline `<u>`
         * - Links `<a>`
         * - Bulleted Lists - `<ul>`, `<li>`
         * - Ordered Lists - `<ol>`, `<li>`
         * - Code - `<code>`
         * - Code Block - `<pre>`
         *
         */
        type: 'text/plain' | 'text/html';
        value: string;
      };
  /**
   * Whether or not users who are subscribed to the candidate should be notified that the note was posted.
   */
  sendNotifications?: boolean;
};

/**
 * The content type of the note. For notes submitted with a type of text/html we support the elements listed below. Any unsupported elements will be stripped out of the note's content before posting.
 * - Bold `<b>`
 * - Italic `<i>`
 * - Underline `<u>`
 * - Links `<a>`
 * - Bulleted Lists - `<ul>`, `<li>`
 * - Ordered Lists - `<ol>`, `<li>`
 * - Code - `<code>`
 * - Code Block - `<pre>`
 *
 */
export type type = 'text/plain' | 'text/html';

export type CandidateCreateNoteResponse = ApiResponse<{
  id: string;
  createdAt: string;
  content?: string;
  author: {
    id: string;
    firstName: string;
    lastName: string;
    email?: string;
  };
}>;

export type CandidateGetAllNotesRequest = {
  candidateId?: string;
} & CandidateListAllRequest;

export type CandidateGetAllNotesResponse = ApiResponseWithMoreData<{
  id: string;
  createdAt: string;
  content: string;
  author: {
    id: string;
    firstName: string;
    lastName: string;
    email?: string;
  };
}>;

export type CandidateGetByIdRequest =
  | {
      /**
       * The id of the candidate to fetch
       */
      id: string;
    }
  | {
      /**
       * An id assigned to a candidate outside of Ashby.
       * Used to associate Ashby candidates with their profiles in external systems (BambooHR, Rippling, Gusto, etc.)
       *
       */
      externalMappingId: string;
    };

export type CandidateGetById = {
  id: string;
  createdAt?: string;
  updatedAt?: string;
  name: string;
  primaryEmailAddress?: {
    value: string;
    type: string;
    isPrimary: boolean;
  };
  primaryPhoneNumber?: {
    value: string;
    type: string;
    isPrimary: boolean;
  };
  emailAddresses: Array<{
    value: string;
    type: string;
    isPrimary: boolean;
  }>;
  phoneNumbers: Array<{
    value: string;
    type: string;
    isPrimary: boolean;
  }>;
  socialLinks: Array<{
    url: string;
    type: string;
  }>;
  tags: Array<{
    id: string;
    title: string;
    isArchived: boolean;
  }>;
  position?: string;
  company?: string;
  school?: string;
  applicationIds: Array<string>;
  resumeFileHandle?: {
    id: string;
    name: string;
    handle: string;
  };
  fileHandles: Array<{
    id: string;
    name: string;
    handle: string;
  }>;
  customFields?: Array<CustomField>;
  profileUrl: string;
  source: Source;
  creditedToUser?: User;
  timezone: string;
  primaryLocation?: {
    id: string;
    locationSummary: string;
    locationComponents: Array<{
      type: 'Country' | 'Region' | 'City';
      name: string;
    }>;
  };
};

export type CandidateGetByIdResponse = ApiResponse<CandidateGetById>;

export type CandidateListAllRequest = {
  /**
   * Opaque cursor indicating which page of results to fetch
   */
  cursor?: string;
  /**
   * An opaque token representing the last time the data was successfully synced from the API. A new, updated one is returned after successfully fetching the last page of data.
   *
   */
  syncToken?: string;
  /**
   * The maximum number of items to return. The maximum and default value is 100.
   */
  limit?: number;
};

export type CandidateListAllResponse = ApiResponseWithMoreData<CandidateGetById>;

export type CandidateSearchByEmailAndNameRequest = {
  /**
   * The candidate's email
   */
  email?: string;
  /**
   * The candidate's name
   */
  name?: string;
};

export type CandidateSearchByEmailAndNameResponse = ApiResponseWithMoreData<CandidateGetById>;

export type CandidateTagCreateNewTagRequest = {
  /**
   * The tag's title. If a tag already exists with that title, the existing tag will be returned.
   */
  title: string;
};

export type CandidateTagCreateNewTagResponse = ApiResponse<{
  title: string;
  /**
   * The tag's unique id
   */
  id: string;
  isArchived: boolean;
}>;

export type CandidateTagListAllRequest = {
  /**
   * Whether archived candidate tags should be included in the response
   */
  includeArchived?: boolean;
  cursor?: string;
  syncToken?: string;
  limit?: number;
};

export type CandidateTagListAllResponse = ApiResponseWithMoreData<{
  title: string;
  /**
   * The tag's unique id
   */
  id: string;
  isArchived: boolean;
}>;

export type CandidateUpdateExistingCandidateRequest = {
  candidateId: string;
  /**
   * The first and last name of the candidate to update.
   */
  name?: string;
  email?: string;
  phoneNumber?: string;
  linkedInUrl?: string;
  githubUrl?: string;
  websiteUrl?: string;
  /**
   * An alternate email address to add to the candidate's profile.
   */
  alternateEmail?: string;
  /**
   * An array of social links to set on the candidate. This value replaces existing socialLinks that have been set on the candidate.
   * If this value is submitted along with linkedInUrl, gitHubUrl or websiteUrl fields, those values will be ignored.
   *
   */
  socialLinks?: Array<{
    type: 'LinkedIn' | 'GitHub' | 'Twitter' | 'Medium' | 'StackOverflow' | 'Website';
    url: string;
  }>;
  sourceId?: string;
  creditedToUserId?: string;
  sendNotifications?: boolean;
  location?: {
    city?: string;
    region?: string;
    country?: string;
  };
};

export type CandidateUpdateExistingCandidateResponse = ApiResponse<CandidateGetById>;

export type CandidateUploadResumeDataRequest = {
  candidateId: string;
  /**
   * The resume to upload to the candidate's profile
   */
  resume: Blob | File;
};

export type CandidateUploadResumeDataResponse = ApiResponse<CandidateGetById>;

export type CustomFieldCreateNewFieldRequest = {
  /**
   * The name of the field
   */
  title: string;
  /**
   * A description for the field
   */
  description?: string;
  /**
   * The type of field being created. This value is case-sensitive.
   */
  fieldType: fieldType;
  /**
   * The type of object the field can be associated with.
   */
  objectType: objectType;
  /**
   * Required when the field type is ValueSelect or MultiValueSelect. An array of selectable values for the field.
   */
  selectableValues?: Array<{
    label: string;
    value: string;
  }>;
  /**
   * Only applies to fields with an objectType of Date. Whether or not the field includes content other than a date
   */
  isDateOnlyField?: boolean;
  /**
   * Determines whether the field can be exposed to a candidate in certain contexts. In order for a custom field to be available in an email template this value must be true.
   */
  isExposableToCandidate?: boolean;
};

/**
 * The type of field being created. This value is case-sensitive.
 */
export type fieldType = 'Boolean' | 'Date' | 'MultiValueSelect' | 'Number' | 'String' | 'ValueSelect';

/**
 * The type of object the field can be associated with.
 */
export type objectType =
  | 'Application'
  | 'Candidate'
  | 'Job'
  | 'Employee'
  | 'Talent_Project'
  | 'Opening_Version'
  | 'Offer_Version';

export type CustomFieldType = {
  title: string;
  id: string;
  /**
   * The type of object in Ashby the custom field is associated with
   */
  objectType: 'Application' | 'Offer' | 'Candidate' | 'Job' | 'Employee' | 'Opening' | 'Talent_Project';
  isArchived: boolean;
  /**
   * The type of data stored in the custom field
   */
  fieldType:
    | 'MultiValueSelect'
    | 'NumberRange'
    | 'String'
    | 'Date'
    | 'ValueSelect'
    | 'Number'
    | 'Currency'
    | 'Boolean'
    | 'LongText'
    | 'CompensationRange';
  /**
   * An array of values that can be selected for custom fields with a fieldType of MultiValueSelect.
   * If the fieldType is not MultiValueSelect, `selectableValues` will not be present in the response
   *
   */
  selectableValues?: Array<{
    label?: string;
    value?: string;
    isArchived?: boolean;
  }>;
  isPrivate?: boolean;
};

export type CustomFieldCreateNewFieldResponse = ApiResponse<CustomFieldType>;

/**
 * The type of object in Ashby the custom field is associated with
 */
export type objectType2 = 'Application' | 'Offer' | 'Candidate' | 'Job';

/**
 * The type of data stored in the custom field
 */
export type fieldType2 =
  | 'MultiValueSelect'
  | 'NumberRange'
  | 'String'
  | 'Date'
  | 'ValueSelect'
  | 'Number'
  | 'Currency'
  | 'Boolean';

export type CustomFieldGetAllResponse = ApiResponseWithMoreData<CustomFieldType>;

export type CustomFieldSetValueRequest = {
  objectId: string;
  /**
   * The type of object the field is associated with.
   */
  objectType: 'Application' | 'Candidate' | 'Job' | 'Opening';
  fieldId: string;
  /**
   * The value to store in the field
   */
  fieldValue: boolean | string | Array<string> | number;
};

/**
 * The type of object the field is associated with.
 */
export type objectType3 = 'Application' | 'Candidate' | 'Job';

export type CustomFieldSetValueResponse = ApiResponse<CustomField>;

export type DepartmentGetAllDepartmentsRequest = {
  /**
   * Whether archived departments should be included in the response
   */
  includeArchived?: boolean;
};

export type DepartmentGetAllDepartmentsResponse = ApiResponse<Array<Department>>;

export type DepartmentGetByIdRequest = {
  departmentId: string;
};

export type Department = {
  id: string;
  name: string;
  isArchived: boolean;
  parentId?: string;
};

export type DepartmentGetByIdResponse = ApiResponse<Department>;

export type DepartmentTeamCreateNewDepartmentRequest = {
  /**
   * The name of the department
   */
  name: string;
  /**
   * The id of the department's parent department
   */
  parentId?: string;
};

export type DepartmentTeamCreateNewDepartmentResponse = ApiResponse<Department>;

export type FeedbackFormDefinitionGetByIdRequest = {
  feedbackFormDefinitionId: string;
};

export type FeedbackFormDefinition = {
  id: string;
  title: string;
  isArchived: boolean;
  organizationId: string;
  isDefaultForm: boolean;
  interviewId?: string;
  formDefinition: {
    sections: Array<SubmittedFormInstance['formDefinition']>;
  };
};

export type FeedbackFormDefinitionGetByIdResponse = ApiResponse<FeedbackFormDefinition>;

export type FeedbackFormDefinitionListAllRequest = {
  includeArchived?: boolean;
  cursor?: string;
  syncToken?: string;
  limit?: string;
};

export type FeedbackFormDefinitionListAllResponse = ApiResponseWithMoreData<FeedbackFormDefinition>;

export type FileGetUrlCandidateRequest = {
  /**
   * A file handle retrieved from the public API
   */
  fileHandle: string;
};

export type FileGetUrlCandidateResponse = ApiResponse<{
  /**
   * The url of the file
   */
  url: string;
}>;

export type HiringTeamAddMemberRequest =
  | {
      applicationId: string;
      teamMemberId: string;
      roleId: string;
    }
  | {
      jobId: string;
      teamMemberId: string;
      roleId: string;
    }
  | {
      openingId: string;
      teamMemberId: string;
      roleId: string;
    };

export type HiringTeamMember = {
  email: string;
  firstName: string;
  lastName: string;
  role: string;
  userId: string;
};

export type HiringTeamAddMemberResponse = ApiResponse<HiringTeamMember>;

export type HiringTeamRoleListRolesRequest = {
  /**
   * When set to true (the default), an array of role titles is returned. When set to false, an array of objects that include the id and title of the role is returned.
   */
  namesOnly?: boolean;
};

export type HiringTeamRoleListRolesResponse = ApiResponse<Array<string | { id: string; title: string }>>;

export type InterviewEventListAssociatedEventsRequest = {
  interviewScheduleId: string;
  expand?: Array<'interview'>;
};

export type InterviewEvent = {
  id: string;
  interviewId: string;
  interviewScheduleId: string;
  interviewerUserIds: Array<string>;
  createdAt: string;
  startTime: string;
  endTime: string;
  /**
   * The link to submit feedback for the interview event
   */
  feedbackLink: string;
  /**
   * The location of the interview
   */
  location?: string;
  /**
   * A link to the virtual meeting (if the interview is being hosted virtually)
   */
  meetingLink?: string;
  hasSubmittedFeedback: boolean;
  interview?: Interview;
};

export type InterviewEventListAssociatedEventsResponse = ApiResponse<Array<InterviewEvent>>;

export type InterviewGetAllRequest = CandidateListAllRequest & {
  includeArchived?: boolean;
  /**
   * If true, interviews that are associated with specific jobs will be included in the response.
   * Shared interviews that are not associated with a specific job can be scheduled for applications to any job.
   * Interviews that are not shared can only be scheduled for applications to the job they are associated with.
   *
   */
  includeNonSharedInterviews?: boolean;
  syncToken?: string;
  limit?: number;
  cursor?: string;
};

export type InterviewGetAllResponse = ApiResponseWithMoreData<Interview>;

export type InterviewGetByIdRequest = {
  id: string;
};

export type Interview = {
  /**
   * The interview's title
   */
  title: string;
  id: string;
  isArchived: boolean;
  isDebrief?: boolean;
  /**
   * An HTML version of the interview's description
   */
  instructionsHtml?: string;
  /**
   * A plaintext version of the interview's description
   */
  instructionsPlain?: string;
  jobId?: string;
  feedbackFormDefinitionId: string;
};

export type InterviewGetByIdResponse = ApiResponse<Interview>;

export type InterviewPlanGetAllRequest = {
  includeArchived?: boolean;
};

export type InterviewPlanGetAllResponse = ApiResponseWithMoreData<{
  id: string;
  title: string;
  isArchived: boolean;
}>;

export type InterviewScheduleCancelByIdRequest = {
  id: string;
  /**
   * Whether or not this interview schedule can be rescheduled.
   */
  allowReschedule?: boolean;
};

export type InterviewSchedule = {
  id: string;
  status:
    | 'NeedsScheduling'
    | 'WaitingOnCandidateBooking'
    | 'WaitingOnCandidateAvailability'
    | 'CandidateAvailabilitySubmitted'
    | 'Scheduled'
    | 'WaitingOnFeedback'
    | 'Complete'
    | 'Cancelled';
  applicationId: string;
  interviewStageId: string;
  interviewEvents?: Array<InterviewEvent>;
};

export type InterviewScheduleCancelByIdResponse = ApiResponse<InterviewSchedule>;

export type InterviewScheduleCreateScheduledInterviewRequest = {
  applicationId: string;
  /**
   * The list of events that make up this interview schedule
   */
  interviewEvents: Array<{
    /**
     * The start time of this event
     */
    startTime: string;
    /**
     * The end time of this event
     */
    endTime: string;
    /**
     * The interviewers for this event
     */
    interviewers: Array<{
      /**
       * The email address of the user in Ashby
       */
      email: string;
      /**
       * Whether this interviewer is required to provide feedback
       */
      feedbackRequired?: boolean;
    }>;
    interviewId?: string;
  }>;
};

export type InterviewScheduleCreateScheduledInterviewResponse = ApiResponse<InterviewSchedule>;

export type InterviewScheduleGetAllSchedulesRequest = {
  createdAfter?: number;
  cursor?: string;
  syncToken?: string;
  limit?: number;
  applicationId?: string;
  interviewStageId?: string;
};

export type InterviewScheduleGetAllSchedulesResponse = ApiResponseWithMoreData<InterviewSchedule>;

export type InterviewScheduleUpdateEventRequest =
  | {
      interviewScheduleId: string;
      interviewEvent: {
        startTime: string;
        endTime: string;
        interviewers: Array<{
          email: string;
          feedbackRequired?: boolean;
        }>;
        interviewId?: string;
        interviewEventId?: string;
      };
    }
  | {
      interviewScheduleId: string;
      interviewEventIdToCancel: string;
      /**
       * By default, we do not allow interview events with submitted feedback to be canceled because canceling an event causes its associated feedback to be deleted. If you want to allow events with submitted feedback to be canceled, this flag can be passed in and set to `true`. In this case, events with feedback will be canceled, and any associated feedback will be deleted.
       */
      allowFeedbackDeletion?: boolean;
    };

export type InterviewScheduleUpdateEventResponse = ApiResponse<InterviewSchedule>;

export type InterviewStageGetByIdRequest = {
  interviewStageId: string;
};

export type InterviewStage = {
  title: string;
  id: string;
  type: string;
  orderInInterviewPlan: number;
  interviewStageGroupId?: string;
  interviewPlanId: string;
};

export type InterviewStageGetByIdResponse = ApiResponse<InterviewStage>;

export type InterviewStageListAllInOrderRequest = {
  interviewPlanId: string;
};

export type InterviewStageListAllInOrderResponse = ApiResponseWithMoreData<InterviewStage>;

export type JobGetByIdRequest = {
  id: string;
  /**
   * Choose to expand the result and include additional data for related objects.
   *
   */
  expand?: Array<'location' | 'openings'>;
  includeUnpublishedJobPostingsIds?: boolean;
};

export type Job = {
  id: string;
  title: string;
  confidential: boolean;
  status: 'Draft' | 'Open' | 'Closed' | 'Archived';
  employmentType: string;
  locationId?: string;
  departmentId?: string;
  defaultInterviewPlanId?: string;
  interviewPlanIds?: Array<string>;
  customFields?: Array<CustomField>;
  jobPostingIds?: Array<string>;
  customRequisitionId?: string;
  brandId?: string;
  hiringTeam: Array<HiringTeamMember>;
  author: {
    id: string;
    firstName: string;
    lastName: string;
    email?: string;
    globalRole: globalRole;
    isEnabled: boolean;
    updatedAt: string;
  };
  createdAt?: string;
  updatedAt: string;
  openedAt?: string;
  closedAt?: string;
  location?: {
    id: string;
    name: string;
    isArchived: boolean;
    address?: {
      postalAddress?: {
        addressCountry?: string;
        addressRegion?: string;
        addressLocality?: string;
      };
    };
    isRemote?: boolean;
    parentLocationId?: string;
    type?: 'Location' | 'LocationHierarchy';
  };
  openings: Array<OpeningsGetByUuid>;
};

export type JobGetByIdResponse = ApiResponse<Job>;

export type JobGetListRequest = CandidateListAllRequest & {
  /**
   * When supplied, only jobs with the provided status(es) will be returned.
   */
  status?: Array<Job['status']>;
  /**
   * Return jobs opened after this date, which is the time since the unix epoch in milliseconds
   */
  openedAfter?: number;
  /**
   * Return jobs opened before this date, which is the time since the unix epoch in milliseconds
   */
  openedBefore?: number;
  /**
   * Return jobs closed after this date, which is the time since the unix epoch in milliseconds
   */
  closedAfter?: number;
  /**
   * Return jobs closed before this date, which is the time since the unix epoch in milliseconds
   */
  closedBefore?: number;
  expand?: 'location' | 'openings';
  includeUnpublishedJobPostingsIds?: boolean;
};

export type JobGetListResponse = ApiResponseWithMoreData<Job>;

export type JobInterviewPlanGetInfoRequest = {
  jobId: string;
};

export type JobInterviewPlanGetInfoResponse = ApiResponse<{
  jobId: string;
  interviewPlanId: string;
  stages: Array<
    InterviewStage & {
      activities: Array<{
        title?: string;
        id: string;
        interviews: Array<{
          title?: string;
          id?: string;
          interviewId?: string;
          interviewDurationMinutes?: number;
          isSchedulable?: boolean;
        }>;
      }>;
    }
  >;
}>;

export type JobNewCreateRequest = {
  /**
   * The title of the job.
   */
  title: string;
  teamId: string;
  locationId: string;
  defaultInterviewPlanId?: string;
  jobTemplateId?: string;
  brandId?: string;
};

export type JobNewCreateResponse = ApiResponse<Job>;

export type JobPostingGetAllPublishedRequest = {
  /**
   * filter by location name (case sensitive)
   */
  location?: string;
  /**
   * filter by department name (case sensitive)
   */
  department?: string;
  /**
   * If true, filter out unlisted job postings.
   */
  listedOnly?: boolean;
  /**
   * If provided, only returns the job postings on the specified job board.
   * If omitted, this API will return the job postings on the primary external job board.
   */
  jobBoardId?: string;
};

export type JobPosting = {
  /**
   * The job posting's title
   */
  title: string;
  id: string;
  /**
   * A plaintext version of the job posting's description
   */
  descriptionPlain: string;
  /**
   * An HTML version of the job posting's description
   */
  descriptionHtml: string;
  /**
   * A shortened job posting description displayed when shared on social media, limited to 200 characters.
   */
  descriptionSocial?: string;
  /**
   * The above description broken down into the actual description on the job, and the Job Post Description Opening and Closing that is set by the admin in Ashby's Job Boards → Theme → Messaging settings.
   */
  descriptionParts: {
    descriptionOpening?: {
      /**
       * An HTML version of the Job Post Description Opening theme settings
       */
      html?: unknown;
      /**
       * A plaintext version of the Job Post Description Opening theme settings
       */
      plain?: unknown;
    };
    descriptionBody?: {
      /**
       * An HTML version of the description set on the job posting
       */
      html?: unknown;
      /**
       * An plaintext version of the description set on the job posting
       */
      plain?: unknown;
    };
    descriptionClosing?: {
      /**
       * An HTML version of the Job Post Description Closing theme settings
       */
      html?: unknown;
      /**
       * A plaintext version of the Job Post Description Closing theme settings
       */
      plain?: unknown;
    };
  };
  /**
   * The name of the department associated with the job posting
   */
  departmentName: string;
  /**
   * The name of the team associated with the job posting
   */
  teamName: string;
  jobId: string;
  /**
   * The name of the primary location associated with the job posting
   */
  locationName: string;
  locationIds: {
    primaryLocationId: string;
    secondaryLocationIds?: Array<string>;
  };
  /**
   * An object that can be used to populate "rich results" in search engines. (https://developers.google.com/search/docs/data-types/job-posting)
   */
  linkedData: {
    title?: string;
    description?: string;
    '@context'?: string;
    '@type'?: string;
    identifier?: {
      '@type'?: string;
      name?: string;
      value?: string;
    };
    datePosted?: string;
    hiringOrganization?: {
      '@type'?: string;
      name?: string;
      sameAs?: string;
    };
    jobLocation?: {
      '@type'?: string;
      address?: {
        '@type'?: string;
      };
    };
    employmentType?: string;
  };
  /**
   * The date the job posting was published
   */
  publishedDate: string;
  /**
   * The date and time when applications will no longer be accepted
   */
  applicationDeadline?: string;
  address?: {
    postalAddress?: {
      addressCountry?: string;
      addressRegion?: string;
      addressLocality?: string;
    };
  };
  isRemote?: boolean;
  employmentType: employmentType;
  applicationFormDefinition?: {
    sections: Array<SubmittedFormInstance['formDefinition']>;
  };
  /**
   * Whether or not the job posting is listed
   */
  isListed: boolean;
  /**
   * The external link to the job posting
   */
  externalLink: string;
  /**
   * The external link to the job posting
   */
  applyLink: string;
  /**
   * The link to apply to the job posting. Will be to the public job board if the job posting is on an external job board, or to the internal job board if the job posting is on an internal job board.
   */
  compensation: {
    /**
     * A summary of *all* the job posting's valid `compensationTiers` in the same format shown on
     * Ashby-hosted Job Boards
     *
     */
    compensationTierSummary?: string;
    /**
     * The maximum and minimum compensation ranges across *all* the posting's `compensationTiers`
     * that make up `compensationTierSummary`
     *
     */
    summaryComponents?: Array<{
      /**
       * The summary of this component in the same format shown on Ashby-hosted Job Boards
       */
      summary: string;
      /**
       * The type of compensation this component represents
       *
       */
      compensationType: 'Salary' | 'EquityPercentage' | 'EquityCashValue' | 'Commission' | 'Bonus';
      /**
       * The frequency at which this compensation is given
       */
      interval:
        | 'NONE'
        | '1 TIME'
        | '1 HOUR'
        | '1 DAY'
        | '1 WEEK'
        | '2 WEEK'
        | '1 MONTH'
        | '1 YEAR'
        | '6 MONTH'
        | '0.5 MONTH'
        | '3 MONTH';
      /**
       * For non `EquityPercentage` components, the [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)
       * currency code of the compensation range
       *
       */
      currencyCode?: string;
      /**
       * An optional label that describes this compensation range to applicants
       */
      label?: string;
      /**
       * The lower end of the compensation range
       */
      minValue?: number;
      /**
       * The higher end of the compensation range
       */
      maxValue?: number;
    }>;
    /**
     * The compensation ranges that can be offered to applicants for this posting
     */
    compensationTiers: Array<{
      /**
       * The individual components that make up this compensation range
       */
      components: Array<{
        /**
         * The component's unique id
         */
        id: string;
        /**
         * The summary of this component in the same format shown on Ashby-hosted Job Boards
         */
        summary: string;
        /**
         * The type of compensation this component represents
         *
         */
        compensationType: 'Salary' | 'EquityPercentage' | 'EquityCashValue' | 'Commission' | 'Bonus';
        /**
         * The frequency at which this compensation is given
         */
        interval:
          | 'NONE'
          | '1 TIME'
          | '1 HOUR'
          | '1 DAY'
          | '1 WEEK'
          | '2 WEEK'
          | '1 MONTH'
          | '1 YEAR'
          | '6 MONTH'
          | '0.5 MONTH'
          | '3 MONTH';
        /**
         * For non `EquityPercentage` components, the [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)
         * currency code of the compensation range
         *
         */
        currencyCode?: string;
        /**
         * An optional label that describes this compensation range to applicants
         */
        label?: string;
        /**
         * The lower end of the compensation range
         */
        minValue?: number;
        /**
         * The higher end of the compensation range
         */
        maxValue?: number;
      }>;
      /**
       * A label that describes the entire range to applicants
       */
      title?: string;
      id: string;
      /**
       * Supplementary information about the compensation
       */
      additionalInformation?: string;
      /**
       * A summary of the tiers's components in the same format shown on Ashby-hosted Job Boards
       *
       */
      tierSummary: string;
    }>;
    /**
     * Whether the job posting's settings specify that compensation should be shown to applicants
     *
     */
    shouldDisplayCompensationOnJobBoard: boolean;
  };
  updatedAt: string;
  /**
   * An HTML version of any communication you would like to show to applicants about the application limit for this job posting
   */
  applicationLimitCalloutHtml?: string;
};

export type JobPostingGetAllPublishedResponse = ApiResponse<
  Array<{
    id: string;
    title: string;
    jobId: string;
    departmentName: string;
    teamName: string;
    locationName: string;
    locationIds: {
      primaryLocationId: string;
      secondaryLocationIds?: Array<string>;
    };
    employmentType: employmentType;
    isListed: boolean;
    publishedDate: string;
    applicationDeadline?: string;
    externalLink?: string;
    applyLink: string;
    compensationTierSummary?: string;
    shouldDisplayCompensationOnJobBoard: boolean;
    updatedAt: string;
  }>
>;

export type JobPostingGetIndividualRequest = {
  jobPostingId: string;
  expand?: Array<'job'>;
};

export type JobPostingGetIndividualResponse = ApiResponse<JobPosting>;

export type JobPostingUpdateExistingRequest = {
  /**
   * A new title for the job posting.
   */
  title?: string;
  /**
   * An HTML block of the job posting description. Please see below for supported tags.
   *
   * **Note**: The `descriptionHtml` field returned in `jobPosting.info` may contain content that is not modifiable through the API. Only the content of the `descriptionParts.descriptionBody` field of the `jobPosting.info` endpoint is modifiable through this call.
   *
   */
  description?: {
    type: 'text/html';
    /**
     * The HTML content of the Job Posting. The following tags will accept updates. Updates to any other tags will be stripped out or not applied.
     * - Headings - `<h[1-6]>`
     * - Bold - `<b>`
     * - Italic - `<i>`
     * - Underline - `<u>`
     * - Links - `<a>`
     * - Bulleted Lists - `<ul>`, `<li>`
     * - Ordered Lists - `<ol>`, `<li>`
     * - Code - `<code>`
     * - Code blocks - `<pre>`
     *
     */
    content: string;
  };
  jobPostingId: string;
};

export type type2 = 'text/html';

export type JobPostingUpdateExistingResponse = ApiResponse<JobPosting>;

export type JobSearchByTitleRequest = {
  /**
   * The title of the job to search for
   */
  title: string;
};

export type JobSearchByTitleResponse = ApiResponse<Array<Job>>;

export type JobSetStatusByIdRequest = {
  jobId: string;
  status: Job['status'];
};

export type JobSetStatusByIdResponse = ApiResponse<Job>;

export type JobUpdateExistingRequest = {
  /**
   * A new title for the job.
   */
  title?: string;
  jobId: string;
  teamId?: string;
  locationId?: string;
  defaultInterviewPlanId?: string;
  customRequisitionId?: string;
};

export type JobUpdateExistingResponse = ApiResponse<Job>;

export type LocationCreateHierarchyRequest = {
  /**
   * The name of the location
   */
  name: string;
  /**
   * A Location represents an actual location that jobs and employees can be associated with. A Location Hierarchy is a grouping of locations or other location hierarchies.
   */
  type: LocationType;
  /**
   * The address of the location
   */
  address?: {
    postalAddress?: {
      /**
       * The country the location is in. Must be a valid country name or two-letter country code.
       */
      addressCountry?: string;
      /**
       * The region the location is in (for instance, a state or province)
       */
      addressRegion?: string;
      /**
       * The city or town of the location
       */
      addressLocality?: string;
    };
  };
  /**
   * The id of the location's parent
   */
  parentLocationId?: string;
  /**
   * Whether the location should be labeled as remote. LocationHierarchies cannot be labeled as remote.
   */
  isRemote?: boolean;
};

/**
 * A Location represents an actual location that jobs and employees can be associated with. A Location Hierarchy is a grouping of locations or other location hierarchies.
 */
export type LocationType = 'Location' | 'LocationHierarchy';

export type LocationCreateHierarchyResponse = ApiResponse<LocationDetails>;

export type LocationDetailsByIdRequest = {
  locationId: string;
};

export type LocationDetails = {
  id: string;
  name: string;
  isArchived: boolean;
  address?: {
    postalAddress?: {
      addressCountry?: string;
      addressRegion?: string;
      addressLocality?: string;
    };
  };
  isRemote: boolean;
  parentLocationId: string;
  type: LocationType;
};

export type LocationDetailsByIdResponse = ApiResponse<LocationDetails>;

export type LocationGetListRequest = {
  includeArchived?: boolean;
};

export type LocationGetListResponse = ApiResponseWithMoreData<LocationDetails>;

export type OfferCreateNewRequest = {
  offerProcessId: string;
  offerFormId: string;
  offerForm: {
    fieldSubmissions: Array<{
      /**
       * The form field's "path" value
       */
      path: string;
      /**
       * This is often a primitive but the value depends on the type of field being submitted. See the description above for details on the values accepted in this field.
       */
      value: string;
    }>;
  };
};

export type OfferCreateNewResponse = ApiResponse<OfferDetails>;

export type OfferDetailsVersion = {
  id: string;
  startDate?: string;
  salary?: {
    currencyCode?: string;
    value?: number;
  };
  createdAt: string;
  customFields?: Array<CustomField>;
  fileHandles?: {
    id: string;
    name: string;
    handle: string;
  };
  author?: {
    id: string;
    firstName: string;
    lastName: string;
    email?: string;
    globalRole: globalRole;
    isEnabled: boolean;
    updatedAt: string;
  };
};

export type OfferDetails = {
  id: string;
  decidedAt?: string;
  applicationId: string;
  acceptanceStatus: 'Accepted' | 'Declined' | 'Pending' | 'Created' | 'Cancelled';
  offerStatus: OfferStatus;
  latestVersion: OfferDetailsVersion;
  versions: Array<OfferDetailsVersion>;
};

export type OfferGetDetailsByIdRequest = {
  offerId: string;
};

export type OfferGetDetailsByIdResponse = ApiResponse<OfferDetails>;

export type OfferGetListRequest = CandidateListAllRequest & {
  applicationId?: string;
};

export type OfferGetListResponse = ApiResponseWithMoreData<OfferDetails>;

export type OfferProcessStartProcessForCandidateRequest = {
  applicationId: string;
};

export type OfferProcessStartProcessForCandidateResponse = ApiResponse<{
  id: string;
  applicationId: string;
  status: OfferStatus;
}>;

/**
 * The status of the offer process
 */
export type OfferStatus =
  | 'WaitingOnOfferCreation'
  | 'WaitingOnApprovalStart'
  | 'WaitingOnOfferApproval'
  | 'WaitingOnCandidateResponse'
  | 'CandidateAccepted'
  | 'CandidateRejected'
  | 'OfferCancelled';

export type OfferStartCreationInstanceRequest = {
  offerProcessId: string;
};

export type OfferStartCreationInstanceResponse = ApiResponse<{
  id?: string;
  formDefinition?: {
    sections: Array<SubmittedFormInstance['formDefinition']>;
  };
}>;

export type OpeningsAddJobActionRequest = {
  /**
   * The id of the opening
   */
  openingId: string;
  /**
   * The id of the job to add
   */
  jobId: string;
};

export type OpeningsAddJobActionResponse = ApiResponse<OpeningsGetByUuid>;

export type OpeningsCreateInstanceRequest = {
  description?: string;
  /**
   * jobIds,     targetHireDate,     targetStartDate,     isBackfill,     employmentType,
   */
  identifier?: string;
  /**
   * The id of the department or team associated with the opening.
   */
  teamId?: string;
  /**
   * The ids of the locations associated with the opening.
   */
  locationIds?: Array<string>;
  /**
   * The ids of the jobs associated with the opening
   */
  jobIds?: Array<string>;
  /**
   * The date (in YYYY-MM-DD format) by which you intend to hire against this opening.
   */
  targetHireDate?: string;
  /**
   * The date (in YYYY-MM-DD format) by which you intend someone hired against this opening will start employment.
   */
  targetStartDate?: string;
  /**
   * Whether this opening is intended to backfill a previous employee
   */
  isBackfill?: boolean;
  /**
   * The employment type for this opening
   */
  employmentType?: 'FullTime' | 'PartTime' | 'Intern' | 'Contract' | 'Temporary' | '';
  /**
   * The state the opening should be created in.
   */
  openingState?: 'Draft' | 'Approved' | 'Open' | 'Closed';
};

/**
 * The employment type for this opening
 */
export type employmentType = 'FullTime' | 'PartTime' | 'Intern' | 'Contract' | 'Temporary' | '';

/**
 * The state the opening should be created in.
 */
export type openingState = 'Draft' | 'Approved' | 'Open' | 'Closed';

export type OpeningsCreateInstanceResponse = ApiResponse<OpeningsGetByUuid>;

export type OpeningsGetByUuidRequest = {
  /**
   * The id of the opening
   */
  openingId: string;
};

export type OpeningsGetByUuid = {
  id: string;
  openedAt?: string;
  closedAt?: string;
  isArchived: boolean;
  archivedAt?: string;
  openingState: openingState2;
  latestVersion?: {
    description: string;
    id: string;
    identifier: string;
    authorId: string;
    createdAt: string;
    teamId?: string;
    jobIds: Array<string>;
    targetHireDate?: string;
    targetStartDate?: string;
    isBackfill: boolean;
    employmentType: employmentType;
    locationIds: Array<string>;
    hiringTeam: Array<HiringTeamMember>;
    customFields: Array<CustomField>;
  };
};

export type OpeningsGetByUuidResponse = ApiResponse<OpeningsGetByUuid>;

export type openingState2 = 'Approved' | 'Closed' | 'Draft' | 'Filled' | 'Open';

export type OpeningsGetListRequest = {
  /**
   * Opaque cursor indicating which page of results to fetch
   */
  cursor?: string;
  /**
   * Opaque token representing the last time a full set of results was fetched.
   */
  syncToken?: string;
};

export type OpeningsGetListResponse = ApiResponse<Array<OpeningsGetByUuid>>;

export type OpeningsRemoveJobRequest = {
  /**
   * The id of the opening
   */
  openingId: string;
  /**
   * The id of the job to remove from the opening.
   */
  jobId: string;
};

export type OpeningsRemoveJobResponse = ApiResponse<OpeningsGetByUuid>;

export type OpeningsSearchByIdentifierRequest = {
  /**
   * The identifier of the opening you want to search for
   */
  identifier: string;
};

export type OpeningsSearchByIdentifierResponse = ApiResponse<OpeningsGetByUuid>;

export type OpeningsSetArchivedRequest = {
  /**
   * The id of the opening you want to archive
   */
  openingId?: string;
  /**
   * The new archived state you want to update the opening to
   */
  archive?: boolean;
};

export type OpeningsSetArchivedResponse = ApiResponse<OpeningsGetByUuid>;

export type OpeningsSetStateRequest = {
  /**
   * The id of the opening you want to update
   */
  openingId?: string;
  /**
   * The new state you want to update the opening to
   */
  openingState?: 'Draft' | 'Approved' | 'Open' | 'Closed';
  /**
   * The id of the close reason if you are setting the state to closed
   */
  closeReasonId?: string;
};

export type OpeningsSetStateResponse = ApiResponse<OpeningsGetByUuid>;

export type OpeningsUpdateOpeningRequest = {
  description?: string;
  /**
   * The openingId of the opening you want to update.
   */
  openingId?: string;
  /**
   * jobIds,     targetHireDate,     targetStartDate,     isBackfill,     employmentType,
   */
  identifier?: string;
  /**
   * The id of the department or team associated with the opening.
   */
  teamId?: string;
  /**
   * The date (in YYYY-MM-DD format) by which you intend to hire against this opening.
   */
  targetHireDate?: string;
  /**
   * The date (in YYYY-MM-DD format) by which you intend someone hired against this opening will start employment.
   */
  targetStartDate?: string;
  /**
   * Whether this opening is intended to backfill a previous employee
   */
  isBackfill?: boolean;
  /**
   * The employment type for this opening
   */
  employmentType?: 'FullTime' | 'PartTime' | 'Intern' | 'Contract' | 'Temporary' | '';
};

export type OpeningsUpdateOpeningResponse = ApiResponse<OpeningsGetByUuid>;

export type ReferralCreateNewRequest = {
  id: string;
  creditedToUserId: string;
  fieldSubmissions: Array<{
    /**
     * The form field's "path" value
     */
    path: string;
    /**
     * This is often a primitive but for a referral job, it should be { title: job.title, value: job.id }
     *
     */
    value: string;
  }>;
  createdAt?: string;
};

export type ReferralCreateNewResponse = ApiResponse<{
  id: string;
  createdAt: string;
  updatedAt: string;
  status: status;
  customFields?: Array<CustomField>;
  candidate: Pick<CandidateGetById, 'id' | 'name' | 'primaryEmailAddress' | 'primaryPhoneNumber'>;
  currentInterviewStage: InterviewStage;
  source?: Source;
  archiveReason: ApplicationData['archiveReason'];
  archivedAt: string;
  job: Pick<Job, 'id' | 'title' | 'locationId' | 'departmentId'>;
  creditedToUser?: User;
  hiringTeam: Array<HiringTeamMember>;
  appliedViaJobPostingId?: string;
}>;

export type ReferralFormGetDefaultFormResponse = ApiResponse<{
  id: string;
  title: string;
  isArchived: boolean;
  formDefinition: {
    sections: Array<SubmittedFormInstance['formDefinition']>;
  };
  organizationId: string;
  isDefaultForm: boolean;
}>;

export type SourceGetAllRequest = {
  /**
   * When true, includes archived items
   */
  includeArchived?: boolean;
};

export type SourceGetAllResponse = ApiResponseWithMoreData<{
  title: string;
  id: string;
  isArchived: boolean;
  sourceType?: Source['sourceType'];
}>;

export type SurveyFormDefinitionGetAllResponse = ApiResponseWithMoreData<SurveyFormDefinitionGetDetails>;

export type SurveyFormDefinitionGetDetailsByIdRequest = {
  surveyFormDefinitionId: string;
};

export type SurveyFormDefinitionGetDetails = {
  id: string;
  title: string;
  isArchived: boolean;
  formDefinition: {
    sections: Array<SubmittedFormInstance['formDefinition']>;
  };
  surveyType: surveyType;
};

export type SurveyFormDefinitionGetDetailsByIdResponse = ApiResponse<SurveyFormDefinitionGetDetails>;

export type SurveyRequestGenerateUrlRequest = {
  candidateId: string;
  applicationId: string;
  surveyFormDefinitionId: string;
};

export type SurveyRequestGenerateUrlResponse = ApiResponse<{
  id: string;
  candidateId: string;
  applicationId: string;
  surveyFormDefinitionId: string;
  /**
   * The URL that the candidate can visit to take the survey.
   *
   */
  surveyUrl: string;
}>;

export type SurveySubmissionListBySurveyTypeRequest = {
  surveyType: 'CandidateDataConsent' | 'CandidateExperience' | 'Diversity' | 'EEOC' | 'Questionnaire';
} & CandidateListAllRequest;

export type surveyType = 'CandidateDataConsent' | 'CandidateExperience' | 'Diversity' | 'EEOC' | 'Questionnaire';

export type SurveySubmissionListBySurveyTypeResponse = ApiResponseWithMoreData<{
  id: string;
  submittedAt: string;
  candidateId: string;
  applicationId?: string;
  surveyType: surveyType;
  formDefinition: {
    sections: Array<SubmittedFormInstance['formDefinition']>;
  };
  submittedValues: SubmittedFormInstance['submittedValues'];
}>;

export type UserGetAshbyUsersRequest = CandidateListAllRequest & {
  /**
   * If set to true, deactivated users are included in the response.
   * By default, deactivated users are not included.
   *
   */
  includeDeactivated?: boolean;
};

export type UserGetAshbyUsersResponse = ApiResponseWithMoreData<User>;

export type UserGetByIdRequest = {
  userId: string;
};

export type UserGetByIdResponse = ApiResponse<User>;

export type globalRole = 'Organization Admin' | 'Elevated Access' | 'Limited Access' | 'External Recruiter';

export type UserSearchByEmailRequest = {
  /**
   * The email to use to search for the user
   */
  email: string;
};

export type UserSearchByEmailResponse = ApiResponse<Array<User>>;

export type WebhookCreateSettingRequest = {
  webhookType: webhookType;
  /**
   * The URL the webhook will send requests to.
   */
  requestUrl: string;
  /**
   * The secret token used to sign the webhook request. See our documentation [here](https://developers.ashbyhq.com/docs/authenticating-webhooks) for more information.
   *
   */
  secretToken: string;
};

export type webhookType =
  | 'applicationSubmit'
  | 'applicationUpdate'
  | 'candidateHire'
  | 'candidateStageChange'
  | 'candidateDelete'
  | 'candidateMerge'
  | 'interviewPlanTransition'
  | 'interviewScheduleCreate'
  | 'interviewScheduleUpdate'
  | 'jobPostingUpdate'
  | 'jobPostingPublish'
  | 'jobPostingUnpublish'
  | 'offerCreate'
  | 'offerUpdate'
  | 'offerDelete'
  | 'pushToHRIS'
  | 'surveySubmit';

export type WebhookCreateSettingResponse = ApiResponse<{
  id: string;
  /**
   * Whether or not the webhook setting is enabled.
   */
  enabled: boolean;
  /**
   * The URL the webhook will send requests to.
   */
  requestUrl: string;
  /**
   * The secret token used to sign the webhook request. See our documentation [here](https://developers.ashbyhq.com/docs/authenticating-webhooks) for more information.
   *
   */
  secretToken: string;
  /**
   * The type of webhook.
   */
  webhookType: webhookType;
}>;

export type WebhookRemoveSettingRequest = {
  webhookId: string;
};

export type WebhookRemoveSettingResponse = ApiResponse<{
  webhookId?: string;
}>;

export type WebhookUpdateSettingRequest = {
  webhookId: string;
  /**
   * Whether or not the webhook is enabled.
   */
  enabled?: boolean;
  /**
   * The URL the webhook will send requests to.
   */
  requestUrl?: string;
  /**
   * The secret token used to sign the webhook request. See our documentation [here](https://developers.ashbyhq.com/docs/authenticating-webhooks) for more information.
   *
   */
  secretToken?: string;
};

export type WebhookUpdateSettingResponse = ApiResponse<{
  id: string;
  /**
   * Whether or not the webhook setting is enabled.
   */
  enabled: boolean;
  /**
   * The URL the webhook will send requests to.
   */
  requestUrl: string;
  /**
   * The secret token used to sign the webhook request. See our documentation [here](https://developers.ashbyhq.com/docs/authenticating-webhooks) for more information.
   *
   */
  secretToken: string;
  /**
   * The type of webhook.
   */
  webhookType: webhookType;
}>;

export type ApiKeyGetInfoData = {
  body?: ApiKeyGetInfoRequest;
};

export type ApiKeyGetInfoResponse2 = ApiKeyGetInfoResponse;

export type ApiKeyGetInfoError = unknown;

export type ApplicationChangeSourceData = {
  body?: ApplicationChangeSourceRequest;
};

export type ApplicationChangeSourceResponse2 = ApplicationChangeSourceResponse;

export type ApplicationChangeSourceError = unknown;

export type ApplicationChangeStageData = {
  body?: ApplicationChangeStageRequest;
};

export type ApplicationChangeStageResponse2 = ApplicationChangeStageResponse;

export type ApplicationChangeStageError = unknown;

export type ApplicationConsiderCandidateData = {
  body?: ApplicationConsiderCandidateRequest;
};

export type ApplicationConsiderCandidateResponse2 = ApplicationConsiderCandidateResponse;

export type ApplicationConsiderCandidateError = unknown;

export type ApplicationGetDetailsData = {
  body?: ApplicationGetDetailsRequest;
};

export type ApplicationGetDetailsResponse2 = ApplicationGetDetailsResponse;

export type ApplicationGetDetailsError = unknown;

export type ApplicationGetAllSchedulesData = {
  body?: ApplicationGetAllSchedulesRequest;
};

export type ApplicationGetAllSchedulesResponse2 = ApplicationGetAllSchedulesResponse;

export type ApplicationGetAllSchedulesError = unknown;

export type ApplicationFeedbackListAllData = {
  body?: ApplicationFeedbackListAllRequest;
};

export type ApplicationFeedbackListAllResponse2 = ApplicationFeedbackListAllResponse;

export type ApplicationFeedbackListAllError = unknown;

export type ApplicationFeedbackSubmitFeedbackData = {
  body?: ApplicationFeedbackSubmitFeedbackRequest;
};

export type ApplicationFeedbackSubmitFeedbackResponse2 = ApplicationFeedbackSubmitFeedbackResponse;

export type ApplicationFeedbackSubmitFeedbackError = unknown;

export type ApplicationFormSubmitFormData = {
  body?: ApplicationFormSubmitFormRequest;
};

export type ApplicationFormSubmitFormResponse2 = ApplicationFormSubmitFormResponse;

export type ApplicationFormSubmitFormError = unknown;

export type ApprovalDefinitionUpdateEntityScopeData = {
  body?: ApprovalDefinitionUpdateEntityScopeRequest;
};

export type ApprovalDefinitionUpdateEntityScopeResponse2 = ApprovalDefinitionUpdateEntityScopeResponse;

export type ApprovalDefinitionUpdateEntityScopeError = unknown;

export type ArchiveReasonListData = {
  body?: ArchiveReasonListRequest;
};

export type ArchiveReasonListResponse2 = ArchiveReasonListResponse;

export type ArchiveReasonListError = unknown;

export type AssessmentAddCompletedToCandidateData = {
  body?: AssessmentAddCompletedToCandidateRequest;
};

export type AssessmentAddCompletedToCandidateResponse2 = AssessmentAddCompletedToCandidateResponse;

export type AssessmentAddCompletedToCandidateError = unknown;

export type AssessmentPartnerStartData = {
  body?: AssessmentPartnerStartRequest;
};

export type AssessmentPartnerStartResponse2 = AssessmentPartnerStartResponse;

export type AssessmentPartnerStartError = AssessmentPartnerStart409Response;

export type AssessmentListPartnerSupportResponse2 = AssessmentListPartnerSupportResponse;

export type AssessmentListPartnerSupportError = unknown;

export type AssessmentUpdateStatusData = {
  body?: AssessmentUpdateStatusRequest;
};

export type AssessmentUpdateStatusResponse2 = AssessmentUpdateStatusResponse;

export type AssessmentUpdateStatusError = unknown;

export type AssessmentCancelPartnerAssessmentData = {
  body?: AssessmentCancelPartnerAssessmentRequest;
};

export type AssessmentCancelPartnerAssessmentResponse2 = AssessmentCancelPartnerAssessmentResponse;

export type AssessmentCancelPartnerAssessmentError = unknown;

export type CandidateAddTagData = {
  body?: CandidateAddTagRequest;
};

export type CandidateAddTagResponse2 = CandidateAddTagResponse;

export type CandidateAddTagError = unknown;

export type CandidateAnonymizeCandidateData = {
  body?: CandidateAnonymizeCandidateRequest;
};

export type CandidateAnonymizeCandidateResponse2 = CandidateAnonymizeCandidateResponse;

export type CandidateAnonymizeCandidateError = unknown;

export type CandidateCreateNewCandidateData = {
  body?: CandidateCreateNewCandidateRequest;
};

export type CandidateCreateNewCandidateResponse2 = CandidateCreateNewCandidateResponse;

export type CandidateCreateNewCandidateError = unknown;

export type CandidateCreateNoteData = {
  body?: CandidateCreateNoteRequest;
};

export type CandidateCreateNoteResponse2 = CandidateCreateNoteResponse;

export type CandidateCreateNoteError = unknown;

export type CandidateGetByIdData = {
  body: CandidateGetByIdRequest;
};

export type CandidateGetByIdResponse2 = CandidateGetByIdResponse;

export type CandidateGetByIdError = unknown;

export type CandidateListAllData = {
  body?: CandidateListAllRequest;
};

export type CandidateListAllResponse2 = CandidateListAllResponse;

export type CandidateListAllError = unknown;

export type CandidateGetAllNotesData = {
  body?: CandidateGetAllNotesRequest;
};

export type CandidateGetAllNotesResponse2 = CandidateGetAllNotesResponse;

export type CandidateGetAllNotesError = unknown;

export type CandidateSearchByEmailAndNameData = {
  body?: CandidateSearchByEmailAndNameRequest;
};

export type CandidateSearchByEmailAndNameResponse2 = CandidateSearchByEmailAndNameResponse;

export type CandidateSearchByEmailAndNameError = unknown;

export type CandidateUpdateExistingCandidateData = {
  body?: CandidateUpdateExistingCandidateRequest;
};

export type CandidateUpdateExistingCandidateResponse2 = CandidateUpdateExistingCandidateResponse;

export type CandidateUpdateExistingCandidateError = unknown;

export type CandidateAttachFileData = {
  body: CandidateAttachFileRequest;
};

export type CandidateAttachFileResponse2 = CandidateAttachFileResponse;

export type CandidateAttachFileError = unknown;

export type CandidateUploadResumeDataData = {
  body: CandidateUploadResumeDataRequest;
};

export type CandidateUploadResumeDataResponse2 = CandidateUploadResumeDataResponse;

export type CandidateUploadResumeDataError = unknown;

export type CandidateTagCreateNewTagData = {
  body?: CandidateTagCreateNewTagRequest;
};

export type CandidateTagCreateNewTagResponse2 = CandidateTagCreateNewTagResponse;

export type CandidateTagCreateNewTagError = unknown;

export type CandidateTagListAllData = {
  body?: CandidateTagListAllRequest;
};

export type CandidateTagListAllResponse2 = CandidateTagListAllResponse;

export type CandidateTagListAllError = unknown;

export type CustomFieldCreateNewFieldData = {
  body?: CustomFieldCreateNewFieldRequest;
};

export type CustomFieldCreateNewFieldResponse2 = CustomFieldCreateNewFieldResponse;

export type CustomFieldCreateNewFieldError = unknown;

export type CustomFieldGetAllData = {
  body?: CandidateListAllRequest;
};

export type CustomFieldGetAllResponse2 = CustomFieldGetAllResponse;

export type CustomFieldGetAllError = unknown;

export type CustomFieldSetValueData = {
  body?: CustomFieldSetValueRequest;
};

export type CustomFieldSetValueResponse2 = CustomFieldSetValueResponse;

export type CustomFieldSetValueError = unknown;

export type DepartmentTeamCreateNewDepartmentData = {
  body?: DepartmentTeamCreateNewDepartmentRequest;
};

export type DepartmentTeamCreateNewDepartmentResponse2 = DepartmentTeamCreateNewDepartmentResponse;

export type DepartmentTeamCreateNewDepartmentError = unknown;

export type DepartmentGetByIdData = {
  body?: DepartmentGetByIdRequest;
};

export type DepartmentGetByIdResponse2 = DepartmentGetByIdResponse;

export type DepartmentGetByIdError = unknown;

export type DepartmentGetAllDepartmentsData = {
  body?: DepartmentGetAllDepartmentsRequest;
};

export type DepartmentGetAllDepartmentsResponse2 = DepartmentGetAllDepartmentsResponse;

export type DepartmentGetAllDepartmentsError = unknown;

export type FileGetUrlCandidateData = {
  body?: FileGetUrlCandidateRequest;
};

export type FileGetUrlCandidateResponse2 = FileGetUrlCandidateResponse;

export type FileGetUrlCandidateError = unknown;

export type FeedbackFormDefinitionGetByIdData = {
  body?: FeedbackFormDefinitionGetByIdRequest;
};

export type FeedbackFormDefinitionGetByIdResponse2 = FeedbackFormDefinitionGetByIdResponse;

export type FeedbackFormDefinitionGetByIdError = unknown;

export type FeedbackFormDefinitionListAllData = {
  body?: FeedbackFormDefinitionListAllRequest;
};

export type FeedbackFormDefinitionListAllResponse2 = FeedbackFormDefinitionListAllResponse;

export type FeedbackFormDefinitionListAllError = unknown;

export type HiringTeamAddMemberData = {
  body?: HiringTeamAddMemberRequest;
};

export type HiringTeamAddMemberResponse2 = HiringTeamAddMemberResponse;

export type HiringTeamAddMemberError = unknown;

export type HiringTeamRoleListRolesData = {
  body?: HiringTeamRoleListRolesRequest;
};

export type HiringTeamRoleListRolesResponse2 = HiringTeamRoleListRolesResponse;

export type HiringTeamRoleListRolesError = unknown;

export type InterviewGetByIdData = {
  body?: InterviewGetByIdRequest;
};

export type InterviewGetByIdResponse2 = InterviewGetByIdResponse;

export type InterviewGetByIdError = unknown;

export type InterviewGetAllData = {
  body?: InterviewGetAllRequest;
};

export type InterviewGetAllResponse2 = InterviewGetAllResponse;

export type InterviewGetAllError = unknown;

export type InterviewEventListAssociatedEventsData = {
  body?: InterviewEventListAssociatedEventsRequest;
};

export type InterviewEventListAssociatedEventsResponse2 = InterviewEventListAssociatedEventsResponse;

export type InterviewEventListAssociatedEventsError = unknown;

export type InterviewPlanGetAllData = {
  body?: InterviewPlanGetAllRequest;
};

export type InterviewPlanGetAllResponse2 = InterviewPlanGetAllResponse;

export type InterviewPlanGetAllError = unknown;

export type InterviewScheduleCancelByIdData = {
  body?: InterviewScheduleCancelByIdRequest;
};

export type InterviewScheduleCancelByIdResponse2 = InterviewScheduleCancelByIdResponse;

export type InterviewScheduleCancelByIdError = unknown;

export type InterviewScheduleCreateScheduledInterviewData = {
  body?: InterviewScheduleCreateScheduledInterviewRequest;
};

export type InterviewScheduleCreateScheduledInterviewResponse2 = InterviewScheduleCreateScheduledInterviewResponse;

export type InterviewScheduleCreateScheduledInterviewError = unknown;

export type InterviewScheduleGetAllSchedulesData = {
  body?: InterviewScheduleGetAllSchedulesRequest;
};

export type InterviewScheduleGetAllSchedulesResponse2 = InterviewScheduleGetAllSchedulesResponse;

export type InterviewScheduleGetAllSchedulesError = unknown;

export type InterviewScheduleUpdateEventData = {
  body?: InterviewScheduleUpdateEventRequest;
};

export type InterviewScheduleUpdateEventResponse2 = InterviewScheduleUpdateEventResponse;

export type InterviewScheduleUpdateEventError = unknown;

export type InterviewStageListAllInOrderData = {
  body?: InterviewStageListAllInOrderRequest;
};

export type InterviewStageListAllInOrderResponse2 = InterviewStageListAllInOrderResponse;

export type InterviewStageListAllInOrderError = unknown;

export type InterviewStageGetByIdData = {
  body?: InterviewStageGetByIdRequest;
};

export type InterviewStageGetByIdResponse2 = InterviewStageGetByIdResponse;

export type InterviewStageGetByIdError = unknown;

export type JobNewCreateData = {
  body?: JobNewCreateRequest;
};

export type JobNewCreateResponse2 = JobNewCreateResponse;

export type JobNewCreateError = unknown;

export type JobGetByIdData = {
  body?: JobGetByIdRequest;
};

export type JobGetByIdResponse2 = JobGetByIdResponse;

export type JobGetByIdError = unknown;

export type JobGetListData = {
  body?: JobGetListRequest;
};

export type JobGetListResponse2 = JobGetListResponse;

export type JobGetListError = unknown;

export type JobSetStatusByIdData = {
  body?: JobSetStatusByIdRequest;
};

export type JobSetStatusByIdResponse2 = JobSetStatusByIdResponse;

export type JobSetStatusByIdError = unknown;

export type JobUpdateExistingData = {
  body?: JobUpdateExistingRequest;
};

export type JobUpdateExistingResponse2 = JobUpdateExistingResponse;

export type JobUpdateExistingError = unknown;

export type JobSearchByTitleData = {
  body?: JobSearchByTitleRequest;
};

export type JobSearchByTitleResponse2 = JobSearchByTitleResponse;

export type JobSearchByTitleError = unknown;

export type JobInterviewPlanGetInfoData = {
  body?: JobInterviewPlanGetInfoRequest;
};

export type JobInterviewPlanGetInfoResponse2 = JobInterviewPlanGetInfoResponse;

export type JobInterviewPlanGetInfoError = unknown;

export type JobPostingGetIndividualData = {
  body?: JobPostingGetIndividualRequest;
};

export type JobPostingGetIndividualResponse2 = JobPostingGetIndividualResponse;

export type JobPostingGetIndividualError = unknown;

export type JobPostingGetAllPublishedData = {
  body?: JobPostingGetAllPublishedRequest;
};

export type JobPostingGetAllPublishedResponse2 = JobPostingGetAllPublishedResponse;

export type JobPostingGetAllPublishedError = unknown;

export type JobPostingUpdateExistingData = {
  body?: JobPostingUpdateExistingRequest;
};

export type JobPostingUpdateExistingResponse2 = JobPostingUpdateExistingResponse;

export type JobPostingUpdateExistingError = unknown;

export type LocationCreateHierarchyData = {
  body?: LocationCreateHierarchyRequest;
};

export type LocationCreateHierarchyResponse2 = LocationCreateHierarchyResponse;

export type LocationCreateHierarchyError = unknown;

export type LocationDetailsByIdData = {
  body?: LocationDetailsByIdRequest;
};

export type LocationDetailsByIdResponse2 = LocationDetailsByIdResponse;

export type LocationDetailsByIdError = unknown;

export type LocationGetListData = {
  body?: LocationGetListRequest;
};

export type LocationGetListResponse2 = LocationGetListResponse;

export type LocationGetListError = unknown;

export type OfferCreateNewData = {
  body?: OfferCreateNewRequest;
};

export type OfferCreateNewResponse2 = OfferCreateNewResponse;

export type OfferCreateNewError = unknown;

export type OfferGetDetailsByIdData = {
  body?: OfferGetDetailsByIdRequest;
};

export type OfferGetDetailsByIdResponse2 = OfferGetDetailsByIdResponse;

export type OfferGetDetailsByIdError = unknown;

export type OfferGetListData = {
  body?: OfferGetListRequest;
};

export type OfferGetListResponse2 = OfferGetListResponse;

export type OfferGetListError = unknown;

export type OfferStartCreationInstanceData = {
  body?: OfferStartCreationInstanceRequest;
};

export type OfferStartCreationInstanceResponse2 = OfferStartCreationInstanceResponse;

export type OfferStartCreationInstanceError = unknown;

export type OfferProcessStartProcessForCandidateData = {
  body?: OfferProcessStartProcessForCandidateRequest;
};

export type OfferProcessStartProcessForCandidateResponse2 = OfferProcessStartProcessForCandidateResponse;

export type OfferProcessStartProcessForCandidateError = unknown;

export type OpeningsGetByUuidData = {
  body?: OpeningsGetByUuidRequest;
};

export type OpeningsGetByUuidResponse2 = OpeningsGetByUuidResponse;

export type OpeningsGetByUuidError = unknown;

export type OpeningsGetListData = {
  body?: OpeningsGetListRequest;
};

export type OpeningsGetListResponse2 = OpeningsGetListResponse;

export type OpeningsGetListError = unknown;

export type OpeningsSearchByIdentifierData = {
  body?: OpeningsSearchByIdentifierRequest;
};

export type OpeningsSearchByIdentifierResponse2 = OpeningsSearchByIdentifierResponse;

export type OpeningsSearchByIdentifierError = unknown;

export type OpeningsCreateInstanceData = {
  body?: OpeningsCreateInstanceRequest;
};

export type OpeningsCreateInstanceResponse2 = OpeningsCreateInstanceResponse;

export type OpeningsCreateInstanceError = unknown;

export type OpeningsAddJobActionData = {
  body?: OpeningsAddJobActionRequest;
};

export type OpeningsAddJobActionResponse2 = OpeningsAddJobActionResponse;

export type OpeningsAddJobActionError = unknown;

export type OpeningsRemoveJobData = {
  body?: OpeningsRemoveJobRequest;
};

export type OpeningsRemoveJobResponse2 = OpeningsRemoveJobResponse;

export type OpeningsRemoveJobError = unknown;

export type OpeningsSetStateData = {
  body?: OpeningsSetStateRequest;
};

export type OpeningsSetStateResponse2 = OpeningsSetStateResponse;

export type OpeningsSetStateError = unknown;

export type OpeningsSetArchivedData = {
  body?: OpeningsSetArchivedRequest;
};

export type OpeningsSetArchivedResponse2 = OpeningsSetArchivedResponse;

export type OpeningsSetArchivedError = unknown;

export type OpeningsUpdateOpeningData = {
  body?: OpeningsUpdateOpeningRequest;
};

export type OpeningsUpdateOpeningResponse2 = OpeningsUpdateOpeningResponse;

export type OpeningsUpdateOpeningError = unknown;

export type ReferralCreateNewData = {
  body?: ReferralCreateNewRequest;
};

export type ReferralCreateNewResponse2 = ReferralCreateNewResponse;

export type ReferralCreateNewError = unknown;

export type ReferralFormGetDefaultFormResponse2 = ReferralFormGetDefaultFormResponse;

export type ReferralFormGetDefaultFormError = unknown;

export type SourceGetAllData = {
  body?: SourceGetAllRequest;
};

export type SourceGetAllResponse2 = SourceGetAllResponse;

export type SourceGetAllError = unknown;

export type SurveyFormDefinitionGetDetailsByIdData = {
  body?: SurveyFormDefinitionGetDetailsByIdRequest;
};

export type SurveyFormDefinitionGetDetailsByIdResponse2 = SurveyFormDefinitionGetDetailsByIdResponse;

export type SurveyFormDefinitionGetDetailsByIdError = unknown;

export type SurveyFormDefinitionGetAllData = {
  body?: CandidateListAllRequest;
};

export type SurveyFormDefinitionGetAllResponse2 = SurveyFormDefinitionGetAllResponse;

export type SurveyFormDefinitionGetAllError = unknown;

export type SurveyRequestGenerateUrlData = {
  body?: SurveyRequestGenerateUrlRequest;
};

export type SurveyRequestGenerateUrlResponse2 = SurveyRequestGenerateUrlResponse;

export type SurveyRequestGenerateUrlError = unknown;

export type SurveySubmissionListBySurveyTypeData = {
  body?: SurveySubmissionListBySurveyTypeRequest;
};

export type SurveySubmissionListBySurveyTypeResponse2 = SurveySubmissionListBySurveyTypeResponse;

export type SurveySubmissionListBySurveyTypeError = unknown;

export type UserGetByIdData = {
  body?: UserGetByIdRequest;
};

export type UserGetByIdResponse2 = UserGetByIdResponse;

export type UserGetByIdError = unknown;

export type UserGetAshbyUsersData = {
  body?: UserGetAshbyUsersRequest;
};

export type UserGetAshbyUsersResponse2 = UserGetAshbyUsersResponse;

export type UserGetAshbyUsersError = unknown;

export type UserSearchByEmailData = {
  body?: UserSearchByEmailRequest;
};

export type UserSearchByEmailResponse2 = UserSearchByEmailResponse;

export type UserSearchByEmailError = unknown;

export type WebhookCreateSettingData = {
  body?: WebhookCreateSettingRequest;
};

export type WebhookCreateSettingResponse2 = WebhookCreateSettingResponse;

export type WebhookCreateSettingError = unknown;

export type WebhookUpdateSettingData = {
  body?: WebhookUpdateSettingRequest;
};

export type WebhookUpdateSettingResponse2 = WebhookUpdateSettingResponse;

export type WebhookUpdateSettingError = unknown;

export type WebhookRemoveSettingData = {
  body?: WebhookRemoveSettingRequest;
};

export type WebhookRemoveSettingResponse2 = WebhookRemoveSettingResponse;

export type WebhookRemoveSettingError = unknown;
