// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, formDataBodySerializer } from '@hey-api/client-fetch';

import type {
  ApiKeyGetInfoData,
  ApiKeyGetInfoError,
  ApiKeyGetInfoResponse2,
  ApplicationChangeSourceData,
  ApplicationChangeSourceError,
  ApplicationChangeSourceResponse2,
  ApplicationChangeStageData,
  ApplicationChangeStageError,
  ApplicationChangeStageResponse2,
  ApplicationConsiderCandidateData,
  ApplicationConsiderCandidateError,
  ApplicationConsiderCandidateResponse2,
  ApplicationGetDetailsData,
  ApplicationGetDetailsError,
  ApplicationGetDetailsResponse2,
  ApplicationGetAllSchedulesData,
  ApplicationGetAllSchedulesError,
  ApplicationGetAllSchedulesResponse2,
  ApplicationFeedbackListAllData,
  ApplicationFeedbackListAllError,
  ApplicationFeedbackListAllResponse2,
  ApplicationFeedbackSubmitFeedbackData,
  ApplicationFeedbackSubmitFeedbackError,
  ApplicationFeedbackSubmitFeedbackResponse2,
  ApplicationFormSubmitFormData,
  ApplicationFormSubmitFormError,
  ApplicationFormSubmitFormResponse2,
  ApprovalDefinitionUpdateEntityScopeData,
  ApprovalDefinitionUpdateEntityScopeError,
  ApprovalDefinitionUpdateEntityScopeResponse2,
  ArchiveReasonListData,
  ArchiveReasonListError,
  ArchiveReasonListResponse2,
  AssessmentAddCompletedToCandidateData,
  AssessmentAddCompletedToCandidateError,
  AssessmentAddCompletedToCandidateResponse2,
  AssessmentPartnerStartData,
  AssessmentPartnerStartError,
  AssessmentPartnerStartResponse2,
  AssessmentListPartnerSupportError,
  AssessmentListPartnerSupportResponse2,
  AssessmentUpdateStatusData,
  AssessmentUpdateStatusError,
  AssessmentUpdateStatusResponse2,
  AssessmentCancelPartnerAssessmentData,
  AssessmentCancelPartnerAssessmentError,
  AssessmentCancelPartnerAssessmentResponse2,
  CandidateAddTagData,
  CandidateAddTagError,
  CandidateAddTagResponse2,
  CandidateAnonymizeCandidateData,
  CandidateAnonymizeCandidateError,
  CandidateAnonymizeCandidateResponse2,
  CandidateCreateNewCandidateData,
  CandidateCreateNewCandidateError,
  CandidateCreateNewCandidateResponse2,
  CandidateCreateNoteData,
  CandidateCreateNoteError,
  CandidateCreateNoteResponse2,
  CandidateGetByIdData,
  CandidateGetByIdError,
  CandidateGetByIdResponse2,
  CandidateListAllData,
  CandidateListAllError,
  CandidateListAllResponse2,
  CandidateGetAllNotesData,
  CandidateGetAllNotesError,
  CandidateGetAllNotesResponse2,
  CandidateSearchByEmailAndNameData,
  CandidateSearchByEmailAndNameError,
  CandidateSearchByEmailAndNameResponse2,
  CandidateUpdateExistingCandidateData,
  CandidateUpdateExistingCandidateError,
  CandidateUpdateExistingCandidateResponse2,
  CandidateAttachFileData,
  CandidateAttachFileError,
  CandidateAttachFileResponse2,
  CandidateUploadResumeDataData,
  CandidateUploadResumeDataError,
  CandidateUploadResumeDataResponse2,
  CandidateTagCreateNewTagData,
  CandidateTagCreateNewTagError,
  CandidateTagCreateNewTagResponse2,
  CandidateTagListAllData,
  CandidateTagListAllError,
  CandidateTagListAllResponse2,
  CustomFieldCreateNewFieldData,
  CustomFieldCreateNewFieldError,
  CustomFieldCreateNewFieldResponse2,
  CustomFieldGetAllData,
  CustomFieldGetAllError,
  CustomFieldGetAllResponse2,
  CustomFieldSetValueData,
  CustomFieldSetValueError,
  CustomFieldSetValueResponse2,
  DepartmentTeamCreateNewDepartmentData,
  DepartmentTeamCreateNewDepartmentError,
  DepartmentTeamCreateNewDepartmentResponse2,
  DepartmentGetByIdData,
  DepartmentGetByIdError,
  DepartmentGetByIdResponse2,
  DepartmentGetAllDepartmentsData,
  DepartmentGetAllDepartmentsError,
  DepartmentGetAllDepartmentsResponse2,
  FileGetUrlCandidateData,
  FileGetUrlCandidateError,
  FileGetUrlCandidateResponse2,
  FeedbackFormDefinitionGetByIdData,
  FeedbackFormDefinitionGetByIdError,
  FeedbackFormDefinitionGetByIdResponse2,
  FeedbackFormDefinitionListAllData,
  FeedbackFormDefinitionListAllError,
  FeedbackFormDefinitionListAllResponse2,
  HiringTeamAddMemberData,
  HiringTeamAddMemberError,
  HiringTeamAddMemberResponse2,
  HiringTeamRoleListRolesData,
  HiringTeamRoleListRolesError,
  HiringTeamRoleListRolesResponse2,
  InterviewGetByIdData,
  InterviewGetByIdError,
  InterviewGetByIdResponse2,
  InterviewGetAllData,
  InterviewGetAllError,
  InterviewGetAllResponse2,
  InterviewEventListAssociatedEventsData,
  InterviewEventListAssociatedEventsError,
  InterviewEventListAssociatedEventsResponse2,
  InterviewPlanGetAllData,
  InterviewPlanGetAllError,
  InterviewPlanGetAllResponse2,
  InterviewScheduleCancelByIdData,
  InterviewScheduleCancelByIdError,
  InterviewScheduleCancelByIdResponse2,
  InterviewScheduleCreateScheduledInterviewData,
  InterviewScheduleCreateScheduledInterviewError,
  InterviewScheduleCreateScheduledInterviewResponse2,
  InterviewScheduleGetAllSchedulesData,
  InterviewScheduleGetAllSchedulesError,
  InterviewScheduleGetAllSchedulesResponse2,
  InterviewScheduleUpdateEventData,
  InterviewScheduleUpdateEventError,
  InterviewScheduleUpdateEventResponse2,
  InterviewStageListAllInOrderData,
  InterviewStageListAllInOrderError,
  InterviewStageListAllInOrderResponse2,
  InterviewStageGetByIdData,
  InterviewStageGetByIdError,
  InterviewStageGetByIdResponse2,
  JobNewCreateData,
  JobNewCreateError,
  JobNewCreateResponse2,
  JobGetByIdData,
  JobGetByIdError,
  JobGetByIdResponse2,
  JobGetListData,
  JobGetListError,
  JobGetListResponse2,
  JobSetStatusByIdData,
  JobSetStatusByIdError,
  JobSetStatusByIdResponse2,
  JobUpdateExistingData,
  JobUpdateExistingError,
  JobUpdateExistingResponse2,
  JobSearchByTitleData,
  JobSearchByTitleError,
  JobSearchByTitleResponse2,
  JobInterviewPlanGetInfoData,
  JobInterviewPlanGetInfoError,
  JobInterviewPlanGetInfoResponse2,
  JobPostingGetIndividualData,
  JobPostingGetIndividualError,
  JobPostingGetIndividualResponse2,
  JobPostingGetAllPublishedData,
  JobPostingGetAllPublishedError,
  JobPostingGetAllPublishedResponse2,
  JobPostingUpdateExistingData,
  JobPostingUpdateExistingError,
  JobPostingUpdateExistingResponse2,
  LocationCreateHierarchyData,
  LocationCreateHierarchyError,
  LocationCreateHierarchyResponse2,
  LocationDetailsByIdData,
  LocationDetailsByIdError,
  LocationDetailsByIdResponse2,
  LocationGetListData,
  LocationGetListError,
  LocationGetListResponse2,
  OfferCreateNewData,
  OfferCreateNewError,
  OfferCreateNewResponse2,
  OfferGetDetailsByIdData,
  OfferGetDetailsByIdError,
  OfferGetDetailsByIdResponse2,
  OfferGetListData,
  OfferGetListError,
  OfferGetListResponse2,
  OfferStartCreationInstanceData,
  OfferStartCreationInstanceError,
  OfferStartCreationInstanceResponse2,
  OfferProcessStartProcessForCandidateData,
  OfferProcessStartProcessForCandidateError,
  OfferProcessStartProcessForCandidateResponse2,
  OpeningsGetByUuidData,
  OpeningsGetByUuidError,
  OpeningsGetByUuidResponse2,
  OpeningsGetListData,
  OpeningsGetListError,
  OpeningsGetListResponse2,
  OpeningsSearchByIdentifierData,
  OpeningsSearchByIdentifierError,
  OpeningsSearchByIdentifierResponse2,
  OpeningsCreateInstanceData,
  OpeningsCreateInstanceError,
  OpeningsCreateInstanceResponse2,
  OpeningsAddJobActionData,
  OpeningsAddJobActionError,
  OpeningsAddJobActionResponse2,
  OpeningsRemoveJobData,
  OpeningsRemoveJobError,
  OpeningsRemoveJobResponse2,
  OpeningsSetStateData,
  OpeningsSetStateError,
  OpeningsSetStateResponse2,
  OpeningsSetArchivedData,
  OpeningsSetArchivedError,
  OpeningsSetArchivedResponse2,
  OpeningsUpdateOpeningData,
  OpeningsUpdateOpeningError,
  OpeningsUpdateOpeningResponse2,
  ReferralCreateNewData,
  ReferralCreateNewError,
  ReferralCreateNewResponse2,
  ReferralFormGetDefaultFormError,
  ReferralFormGetDefaultFormResponse2,
  SourceGetAllData,
  SourceGetAllError,
  SourceGetAllResponse2,
  SurveyFormDefinitionGetDetailsByIdData,
  SurveyFormDefinitionGetDetailsByIdError,
  SurveyFormDefinitionGetDetailsByIdResponse2,
  SurveyFormDefinitionGetAllData,
  SurveyFormDefinitionGetAllError,
  SurveyFormDefinitionGetAllResponse2,
  SurveyRequestGenerateUrlData,
  SurveyRequestGenerateUrlError,
  SurveyRequestGenerateUrlResponse2,
  SurveySubmissionListBySurveyTypeData,
  SurveySubmissionListBySurveyTypeError,
  SurveySubmissionListBySurveyTypeResponse2,
  UserGetByIdData,
  UserGetByIdError,
  UserGetByIdResponse2,
  UserGetAshbyUsersData,
  UserGetAshbyUsersError,
  UserGetAshbyUsersResponse2,
  UserSearchByEmailData,
  UserSearchByEmailError,
  UserSearchByEmailResponse2,
  WebhookCreateSettingData,
  WebhookCreateSettingError,
  WebhookCreateSettingResponse2,
  WebhookUpdateSettingData,
  WebhookUpdateSettingError,
  WebhookUpdateSettingResponse2,
  WebhookRemoveSettingData,
  WebhookRemoveSettingError,
  WebhookRemoveSettingResponse2,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * apiKey.info
 * Retrieve information about the API key being used to make the request.
 *
 * **Requires the [`apiKeysRead`](authentication#permissions-apikeyinfo) permission.**
 *
 */
export const apiKeyGetInfo = <ThrowOnError extends boolean = false>(
  options?: Options<ApiKeyGetInfoData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ApiKeyGetInfoResponse2, ApiKeyGetInfoError, ThrowOnError>({
    ...options,
    url: '/apiKey.info',
  });
};

/**
 * application.changeSource
 * Change the source of an application.
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-applicationchangesource) permission.**
 *
 */
export const applicationChangeSource = <ThrowOnError extends boolean = false>(
  options?: Options<ApplicationChangeSourceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ApplicationChangeSourceResponse2, ApplicationChangeSourceError, ThrowOnError>(
    {
      ...options,
      url: '/application.change_source',
    },
  );
};

/**
 * application.changeStage
 * Change the stage of an application
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-applicationchangestage) permission.**
 *
 */
export const applicationChangeStage = <ThrowOnError extends boolean = false>(
  options?: Options<ApplicationChangeStageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ApplicationChangeStageResponse2, ApplicationChangeStageError, ThrowOnError>({
    ...options,
    url: '/application.change_stage',
  });
};

/**
 * application.create
 * Consider a candidate for a job
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-applicationcreate) permission.**
 *
 */
export const applicationConsiderCandidate = <ThrowOnError extends boolean = false>(
  options?: Options<ApplicationConsiderCandidateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ApplicationConsiderCandidateResponse2,
    ApplicationConsiderCandidateError,
    ThrowOnError
  >({
    ...options,
    url: '/application.create',
  });
};

/**
 * application.info
 * Fetch application details by application id or by submitted form instance id (which is return by the `applicationForm.submit` endpoint). If both applicationId and submittedFormInstanceId are provided, we will lookup by applicationId.
 *
 * **Requires the [`candidatesRead`](authentication#permissions-applicationinfo) permission.**
 *
 */
export const applicationGetDetails = <ThrowOnError extends boolean = false>(
  options?: Options<ApplicationGetDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ApplicationGetDetailsResponse2, ApplicationGetDetailsError, ThrowOnError>({
    ...options,
    url: '/application.info',
  });
};

/**
 * application.list
 * Gets all applications schedules in the organization.
 *
 * **Requires the [`candidatesRead`](authentication#permissions-applicationlist) permission.**
 *
 */
export const applicationGetAllSchedules = <ThrowOnError extends boolean = false>(
  options?: Options<ApplicationGetAllSchedulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ApplicationGetAllSchedulesResponse2,
    ApplicationGetAllSchedulesError,
    ThrowOnError
  >({
    ...options,
    url: '/application.list',
  });
};

/**
 * applicationFeedback.list
 * List all feedback associated with an application.
 *
 * **Requires the [`candidatesRead`](authentication#permissions-applicationfeedbacklist) permission.**
 *
 * The `submittedValues` field in the response contains the submitted feedback in an object where the key is the path of the field and the value is the value submitted for that field.
 *
 */
export const applicationFeedbackListAll = <ThrowOnError extends boolean = false>(
  options?: Options<ApplicationFeedbackListAllData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ApplicationFeedbackListAllResponse2,
    ApplicationFeedbackListAllError,
    ThrowOnError
  >({
    ...options,
    url: '/applicationFeedback.list',
  });
};

/**
 * applicationFeedback.submit
 * Application feedback forms support a variety of field types.
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-applicationfeedbacksubmit) permission.**
 *
 * The values accepted for each field depend on the type of field that's being filled out:                                                                                                                                                                                                                 |
 * - `Boolean` - A boolean value
 * - `Date` - A date string in the format YYYY-MM-DD
 * - `Email` - A valid email address
 * - `Number` - An integer
 * - `RichText` - We do not support submitting rich text documents via the API but we do support submitting plain text values for these fields. Plain text values must be submitted in the format `{ type: "PlainText", value: "A plain text string" }`
 * - `Score` - An integer between 1 and 4 submitted in the format `{ score: 4 }`
 * - `Phone`, `String` A string
 * - `ValueSelect` - A string that matches the value of one of the ValueSelect field's selectable options
 * - `MultiValueSelect` - An array of strings that exist in the MultiValueSelect field's selectable options
 *
 * The `submittedValues` field in the response contains the submitted feedback in an object where the key is the path of the field and the value is the value submitted for that field.
 *
 */
export const applicationFeedbackSubmitFeedback = <ThrowOnError extends boolean = false>(
  options?: Options<ApplicationFeedbackSubmitFeedbackData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ApplicationFeedbackSubmitFeedbackResponse2,
    ApplicationFeedbackSubmitFeedbackError,
    ThrowOnError
  >({
    ...options,
    url: '/applicationFeedback.submit',
  });
};

/**
 * applicationForm.submit
 * Submit an application for a job posting.
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-applicationformsubmit) permission.**
 *
 * The Content-Type of this request must be `multipart/form-data`.
 *
 * **Note: The requests generated from this documentation will not work for this endpoint.**
 *
 */
export const applicationFormSubmitForm = <ThrowOnError extends boolean = false>(
  options?: Options<ApplicationFormSubmitFormData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ApplicationFormSubmitFormResponse2,
    ApplicationFormSubmitFormError,
    ThrowOnError
  >({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/applicationForm.submit',
  });
};

/**
 * approvalDefinition.update
 * Create or update an approval definition for a specific entity that requires approval. The entity requiring approval must be within scope of an approval in Ashby that is marked as being managed by the API.
 *
 * **Requires the [`approvalsWrite`](authentication#permissions-approvaldefinitionupdate) permission.**
 *
 */
export const approvalDefinitionUpdateEntityScope = <ThrowOnError extends boolean = false>(
  options?: Options<ApprovalDefinitionUpdateEntityScopeData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ApprovalDefinitionUpdateEntityScopeResponse2,
    ApprovalDefinitionUpdateEntityScopeError,
    ThrowOnError
  >({
    ...options,
    url: '/approvalDefinition.update',
  });
};

/**
 * archiveReason.list
 * Lists archive reasons
 *
 * **Requires the [`hiringProcessMetadataRead`](authentication#permissions-archivereasonlist) permission.**
 *
 */
export const archiveReasonList = <ThrowOnError extends boolean = false>(
  options?: Options<ArchiveReasonListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ArchiveReasonListResponse2, ArchiveReasonListError, ThrowOnError>({
    ...options,
    url: '/archiveReason.list',
  });
};

/**
 * assessment.addCompletedToCandidate
 * Add a completed assessment to a candidate
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-assessmentaddcompletedtocandidate) permission.**
 *
 */
export const assessmentAddCompletedToCandidate = <ThrowOnError extends boolean = false>(
  options?: Options<AssessmentAddCompletedToCandidateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AssessmentAddCompletedToCandidateResponse2,
    AssessmentAddCompletedToCandidateError,
    ThrowOnError
  >({
    ...options,
    url: '/assessment.addCompletedToCandidate',
  });
};

/**
 * assessment.start (Implemented by Partner)
 * The API for starting an assessment—implemented by the partner, but called by Ashby
 *
 */
export const assessmentPartnerStart = <ThrowOnError extends boolean = false>(
  options?: Options<AssessmentPartnerStartData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AssessmentPartnerStartResponse2, AssessmentPartnerStartError, ThrowOnError>({
    ...options,
    url: '/assessment.start',
  });
};

/**
 * assessment.list (Implemented by Partner)
 * The API for listing assessments that the partner supports — implemented by the partner, but called by Ashby
 *
 */
export const assessmentListPartnerSupport = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AssessmentListPartnerSupportResponse2,
    AssessmentListPartnerSupportError,
    ThrowOnError
  >({
    ...options,
    url: '/assessment.list',
  });
};

/**
 * assessment.update
 * Update Ashby about the status of a started assessment
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-assessmentupdate) permission.**
 *
 */
export const assessmentUpdateStatus = <ThrowOnError extends boolean = false>(
  options?: Options<AssessmentUpdateStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AssessmentUpdateStatusResponse2, AssessmentUpdateStatusError, ThrowOnError>({
    ...options,
    url: '/assessment.update',
  });
};

/**
 * assessment.cancel (Implemented by Partner)
 * (Optional) Cancels an assessment— implemented by the partner, but called by Ashby
 *
 */
export const assessmentCancelPartnerAssessment = <ThrowOnError extends boolean = false>(
  options?: Options<AssessmentCancelPartnerAssessmentData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AssessmentCancelPartnerAssessmentResponse2,
    AssessmentCancelPartnerAssessmentError,
    ThrowOnError
  >({
    ...options,
    url: '/assessment.cancel',
  });
};

/**
 * candidate.addTag
 * Adds a tag to a candidate
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-candidateaddtag) permission.**
 *
 */
export const candidateAddTag = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateAddTagData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CandidateAddTagResponse2, CandidateAddTagError, ThrowOnError>({
    ...options,
    url: '/candidate.addTag',
  });
};

/**
 * candidate.anonymize
 * Anonymizes a candidate.
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-candidateanonymize) permission.**
 *
 * **Note**: this action cannot be reversed and requires all of a candidate's applications to be in the archived or hired state.
 *
 */
export const candidateAnonymizeCandidate = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateAnonymizeCandidateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CandidateAnonymizeCandidateResponse2,
    CandidateAnonymizeCandidateError,
    ThrowOnError
  >({
    ...options,
    url: '/canidate.anonymize',
  });
};

/**
 * candidate.create
 * Creates a new candidate
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-candidatecreate) permission.**
 *
 */
export const candidateCreateNewCandidate = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateCreateNewCandidateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CandidateCreateNewCandidateResponse2,
    CandidateCreateNewCandidateError,
    ThrowOnError
  >({
    ...options,
    url: '/candidate.create',
  });
};

/**
 * candidate.createNote
 * Creates a note on a candidate.
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-candidatecreatenote) permission.**
 *
 * For notes submitted with a type of `text/html`, we support the elements listed below. Any unsupported elements will be stripped out of the note's content before posting.
 * - Bold `<b>`
 * - Italic `<i>`
 * - Underline `<u>`
 * - Links `<a>`
 * - Bulleted Lists - `<ul>`, `<li>`
 * - Ordered Lists - `<ol>`, `<li>`
 * - Code - `<code>`
 * - Code Block - `<pre>`
 *
 */
export const candidateCreateNote = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateCreateNoteData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CandidateCreateNoteResponse2, CandidateCreateNoteError, ThrowOnError>({
    ...options,
    url: '/candidate.createNote',
  });
};

/**
 * candidate.info
 * Gets a single candidate by id.
 *
 * **Requires the [`candidatesRead`](authentication#permissions-candidateinfo) permission.**
 *
 */
export const candidateGetById = <ThrowOnError extends boolean = false>(
  options: Options<CandidateGetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CandidateGetByIdResponse2, CandidateGetByIdError, ThrowOnError>({
    ...options,
    url: '/candidate.info',
  });
};

/**
 * candidate.list
 * Lists all candidates in an organization
 *
 * **Requires the [`candidatesRead`](authentication#permissions-candidatelist) permission.**
 *
 */
export const candidateListAll = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateListAllData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CandidateListAllResponse2, CandidateListAllError, ThrowOnError>({
    ...options,
    url: '/candidate.list',
  });
};

/**
 * candidate.listNotes
 * Lists all notes on a candidate
 *
 * **Requires the [`candidatesRead`](authentication#permissions-candidatelistnotes) permission.**
 *
 */
export const candidateGetAllNotes = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateGetAllNotesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CandidateGetAllNotesResponse2, CandidateGetAllNotesError, ThrowOnError>({
    ...options,
    url: '/candidate.listNotes',
  });
};

/**
 * candidate.search
 * Search for candidates by email and / or name.
 *
 * **Requires the [`candidatesRead`](authentication#permissions-candidatesearch) permission.**
 *
 * Responses are limited to 100 results. Consider refining your search or using /candidate.list to paginate through all candidates, if you approach this limit. This API is for use cases where you intend operate on a final small set of candidates, like building a candidate autocomplete.
 *
 * Note: When multiple search parameters are provided, the parameters are combined with the `AND` operator.
 *
 */
export const candidateSearchByEmailAndName = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateSearchByEmailAndNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CandidateSearchByEmailAndNameResponse2,
    CandidateSearchByEmailAndNameError,
    ThrowOnError
  >({
    ...options,
    url: '/candidate.search',
  });
};

/**
 * candidate.update
 * Updates an existing candidate
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-candidateupdate) permission.**
 *
 */
export const candidateUpdateExistingCandidate = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateUpdateExistingCandidateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CandidateUpdateExistingCandidateResponse2,
    CandidateUpdateExistingCandidateError,
    ThrowOnError
  >({
    ...options,
    url: '/candidate.update',
  });
};

/**
 * candidate.uploadFile
 * Uploads a file to attach to the candidate's profile.
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-candidateuploadfile) permission.**
 *
 * The `Content-Type` of this request must be `multipart/form-data`.
 *
 */
export const candidateAttachFile = <ThrowOnError extends boolean = false>(
  options: Options<CandidateAttachFileData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CandidateAttachFileResponse2, CandidateAttachFileError, ThrowOnError>({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/candidate.uploadFile',
  });
};

/**
 * candidate.uploadResume
 * Uploads a candidate's resume, parses it, and updates their information.
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-candidateuploadresume) permission.**
 *
 * The `Content-Type` of this request must be `multipart/form-data`.
 *
 * Note: Existing candidate data always takes precedence over data found by parsing the resume. Resume data only populates candidate data, if it's data that was missing in the candidate model.
 *
 */
export const candidateUploadResumeData = <ThrowOnError extends boolean = false>(
  options: Options<CandidateUploadResumeDataData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CandidateUploadResumeDataResponse2,
    CandidateUploadResumeDataError,
    ThrowOnError
  >({
    ...options,
    ...formDataBodySerializer,
    headers: {
      'Content-Type': null,
      ...options?.headers,
    },
    url: '/candidate.uploadResume',
  });
};

/**
 * candidateTag.create
 * Creates a candidate tag.
 *
 * **Requires the [`hiringProcessMetadataWrite`](authentication#permissions-candidatetagcreate) permission.**
 *
 */
export const candidateTagCreateNewTag = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateTagCreateNewTagData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CandidateTagCreateNewTagResponse2,
    CandidateTagCreateNewTagError,
    ThrowOnError
  >({
    ...options,
    url: '/candidateTag.create',
  });
};

/**
 * candidateTag.list
 * Lists all candidate tags
 *
 * **Requires the [`hiringProcessMetadataRead`](authentication#permissions-candidatetaglist) permission.**
 *
 */
export const candidateTagListAll = <ThrowOnError extends boolean = false>(
  options?: Options<CandidateTagListAllData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CandidateTagListAllResponse2, CandidateTagListAllError, ThrowOnError>({
    ...options,
    url: '/candidateTag.list',
  });
};

/**
 * customField.create
 * Create a new custom field
 *
 * **Requires the [`hiringProcessMetadataWrite`](authentication#permissions-customfieldcreate) permission.**
 *
 */
export const customFieldCreateNewField = <ThrowOnError extends boolean = false>(
  options?: Options<CustomFieldCreateNewFieldData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CustomFieldCreateNewFieldResponse2,
    CustomFieldCreateNewFieldError,
    ThrowOnError
  >({
    ...options,
    url: '/customField.create',
  });
};

/**
 * customField.list
 * Lists all custom fields
 *
 * **Requires the [`hiringProcessMetadataRead`](authentication#permissions-customfieldlist) permission.**
 *
 */
export const customFieldGetAll = <ThrowOnError extends boolean = false>(
  options?: Options<CustomFieldGetAllData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CustomFieldGetAllResponse2, CustomFieldGetAllError, ThrowOnError>({
    ...options,
    url: '/customField.list',
  });
};

/**
 * customField.setValue
 * Set the value of a custom field
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-customfieldsetvalue) permission.**
 *
 * The values accepted in the `fieldValue` param depend on the type of field that's being updated. See below for more details:
 * - Boolean - A boolean value
 * - Date - An ISO Date string
 * - Email, LongText, Phone, String - String
 * - ValueSelect - A string that matches the value of one of the ValueSelect field's options
 * - MultiValueSelect - An array of strings that exist in the MultiValueSelect field's options
 * - Number - A number
 *
 */
export const customFieldSetValue = <ThrowOnError extends boolean = false>(
  options?: Options<CustomFieldSetValueData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CustomFieldSetValueResponse2, CustomFieldSetValueError, ThrowOnError>({
    ...options,
    url: '/customField.setValue',
  });
};

/**
 * department.create
 * Creates a department
 *
 * **Requires the [`organizationWrite`](authentication#permissions-departmentcreate) permission.**
 *
 */
export const departmentTeamCreateNewDepartment = <ThrowOnError extends boolean = false>(
  options?: Options<DepartmentTeamCreateNewDepartmentData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    DepartmentTeamCreateNewDepartmentResponse2,
    DepartmentTeamCreateNewDepartmentError,
    ThrowOnError
  >({
    ...options,
    url: '/department.create',
  });
};

/**
 * department.info
 * Fetch department details by id
 *
 * **Requires the [`organizationRead`](authentication#permissions-departmentinfo) permission.**
 *
 */
export const departmentGetById = <ThrowOnError extends boolean = false>(
  options?: Options<DepartmentGetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DepartmentGetByIdResponse2, DepartmentGetByIdError, ThrowOnError>({
    ...options,
    url: '/department.info',
  });
};

/**
 * department.list
 * Lists all departments
 *
 * **Requires the [`organizationRead`](authentication#permissions-departmentlist) permission.**
 *
 */
export const departmentGetAllDepartments = <ThrowOnError extends boolean = false>(
  options?: Options<DepartmentGetAllDepartmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    DepartmentGetAllDepartmentsResponse2,
    DepartmentGetAllDepartmentsError,
    ThrowOnError
  >({
    ...options,
    url: '/department.list',
  });
};

/**
 * file.info
 * Retrieve the url of a file associated with a candidate
 *
 * **Requires the [`candidatesRead`](authentication#permissions-fileinfo) permission.**
 *
 */
export const fileGetUrlCandidate = <ThrowOnError extends boolean = false>(
  options?: Options<FileGetUrlCandidateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<FileGetUrlCandidateResponse2, FileGetUrlCandidateError, ThrowOnError>({
    ...options,
    url: '/file.info',
  });
};

/**
 * feedbackFormDefinition.info
 * Returns a single feedback form by id
 *
 * **Requires the [`hiringProcessMetadataRead`](authentication#permissions-feedbackformdefinitioninfo) permission.**
 *
 */
export const feedbackFormDefinitionGetById = <ThrowOnError extends boolean = false>(
  options?: Options<FeedbackFormDefinitionGetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    FeedbackFormDefinitionGetByIdResponse2,
    FeedbackFormDefinitionGetByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/feedbackFormDefinition.info',
  });
};

/**
 * feedbackFormDefinition.list
 * Lists all feedback forms
 *
 * **Requires the [`hiringProcessMetadataRead`](authentication#permissions-feedbackformdefinitionlist) permission.**
 *
 */
export const feedbackFormDefinitionListAll = <ThrowOnError extends boolean = false>(
  options?: Options<FeedbackFormDefinitionListAllData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    FeedbackFormDefinitionListAllResponse2,
    FeedbackFormDefinitionListAllError,
    ThrowOnError
  >({
    ...options,
    url: '/feedbackFormDefinition.list',
  });
};

/**
 * hiringTeam.addMember
 * Adds an Ashby user to the hiring team at the application or job-level.
 *
 * **Requires the [`organizationWrite`](authentication#permissions-hiringteamaddmember) permission.**
 *
 * Hiring team members can be added to a hiring team at the application level or at the job level.
 *
 */
export const hiringTeamAddMember = <ThrowOnError extends boolean = false>(
  options?: Options<HiringTeamAddMemberData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<HiringTeamAddMemberResponse2, HiringTeamAddMemberError, ThrowOnError>({
    ...options,
    url: '/hiringTeam.addMember',
  });
};

/**
 * hiringTeamRole.list
 * Lists the possible hiring team roles in an organization
 *
 * **Requires the [`organizationRead`](authentication#permissions-hiringteamrolelist) permission.**
 *
 */
export const hiringTeamRoleListRoles = <ThrowOnError extends boolean = false>(
  options?: Options<HiringTeamRoleListRolesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<HiringTeamRoleListRolesResponse2, HiringTeamRoleListRolesError, ThrowOnError>(
    {
      ...options,
      url: '/hiringTeamRole.list',
    },
  );
};

/**
 * interview.info
 * Fetch interview details by id
 *
 * **Requires the [`interviewsRead`](authentication#permissions-interviewinfo) permission.**
 *
 */
export const interviewGetById = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewGetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<InterviewGetByIdResponse2, InterviewGetByIdError, ThrowOnError>({
    ...options,
    url: '/interview.info',
  });
};

/**
 * interview.list
 * List all interviews
 *
 * **Requires the [`interviewsRead`](authentication#permissions-interviewlist) permission.**
 *
 */
export const interviewGetAll = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewGetAllData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<InterviewGetAllResponse2, InterviewGetAllError, ThrowOnError>({
    ...options,
    url: '/interview.list',
  });
};

/**
 * interviewEvent.list
 * Lists interview events associated with an interview schedule
 *
 * **Requires the [`interviewsRead`](authentication#permissions-intervieweventlist) permission.**
 *
 */
export const interviewEventListAssociatedEvents = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewEventListAssociatedEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    InterviewEventListAssociatedEventsResponse2,
    InterviewEventListAssociatedEventsError,
    ThrowOnError
  >({
    ...options,
    url: '/interviewEvent.list',
  });
};

/**
 * interviewPlan.list
 * List all interview plans.
 *
 * **Requires the [`interviewsRead`](authentication#permissions-interviewplanlist) permission.**
 *
 */
export const interviewPlanGetAll = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewPlanGetAllData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<InterviewPlanGetAllResponse2, InterviewPlanGetAllError, ThrowOnError>({
    ...options,
    url: '/interviewPlan.list',
  });
};

/**
 * interviewSchedule.cancel
 * Cancel an interview schedule by id
 *
 * **Requires the [`interviewsWrite`](authentication#permissions-interviewschedulecancel) permission.**
 *
 */
export const interviewScheduleCancelById = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewScheduleCancelByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    InterviewScheduleCancelByIdResponse2,
    InterviewScheduleCancelByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/interviewSchedule.cancel',
  });
};

/**
 * interviewSchedule.create
 * Create a scheduled interview in Ashby
 *
 * **Requires the [`interviewsWrite`](authentication#permissions-interviewschedulecreate) permission.**
 *
 */
export const interviewScheduleCreateScheduledInterview = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewScheduleCreateScheduledInterviewData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    InterviewScheduleCreateScheduledInterviewResponse2,
    InterviewScheduleCreateScheduledInterviewError,
    ThrowOnError
  >({
    ...options,
    url: '/interviewSchedule.create',
  });
};

/**
 * interviewSchedule.list
 * Gets all interview schedules in the organization.
 *
 * **Requires the [`interviewsRead`](authentication#permissions-interviewschedulelist) permission.**
 *
 */
export const interviewScheduleGetAllSchedules = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewScheduleGetAllSchedulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    InterviewScheduleGetAllSchedulesResponse2,
    InterviewScheduleGetAllSchedulesError,
    ThrowOnError
  >({
    ...options,
    url: '/interviewSchedule.list',
  });
};

/**
 * interviewSchedule.update
 * Update an interview schedule. This endpoint allows you to add, cancel, or update interview events associated with an interview schedule.
 *
 * **Requires the [`interviewsWrite`](authentication#permissions-interviewscheduleupdate) permission.**
 *
 * In order to update an interview event on a schedule, the event's `interviewEventId` must be included when sending your request.
 * `interviewEventId`s are included in the response of the `interviewSchedule.create` endpoint.
 *
 */
export const interviewScheduleUpdateEvent = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewScheduleUpdateEventData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    InterviewScheduleUpdateEventResponse2,
    InterviewScheduleUpdateEventError,
    ThrowOnError
  >({
    ...options,
    url: '/interviewSchedule.update',
  });
};

/**
 * interviewStage.list
 * List all interview stages for an interview plan in order.
 *
 * **Requires the [`interviewsRead`](authentication#permissions-interviewstagelist) permission.**
 *
 */
export const interviewStageListAllInOrder = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewStageListAllInOrderData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    InterviewStageListAllInOrderResponse2,
    InterviewStageListAllInOrderError,
    ThrowOnError
  >({
    ...options,
    url: '/interviewStage.list',
  });
};

/**
 * interviewStage.info
 * Fetch interview stage details by id
 *
 * **Requires the [`interviewsRead`](authentication#permissions-interviewstageinfo) permission.**
 *
 */
export const interviewStageGetById = <ThrowOnError extends boolean = false>(
  options?: Options<InterviewStageGetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<InterviewStageGetByIdResponse2, InterviewStageGetByIdError, ThrowOnError>({
    ...options,
    url: '/interviewStage.info',
  });
};

/**
 * job.create
 * Creates a new job
 *
 * **Requires the [`jobsWrite`](authentication#permissions-jobcreate) permission.**
 *
 */
export const jobNewCreate = <ThrowOnError extends boolean = false>(
  options?: Options<JobNewCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<JobNewCreateResponse2, JobNewCreateError, ThrowOnError>({
    ...options,
    url: '/job.create',
  });
};

/**
 * job.info
 * Returns details about a single job by id
 *
 * **Requires the [`jobsRead`](authentication#permissions-jobinfo) permission.**
 *
 */
export const jobGetById = <ThrowOnError extends boolean = false>(options?: Options<JobGetByIdData, ThrowOnError>) => {
  return (options?.client ?? client).post<JobGetByIdResponse2, JobGetByIdError, ThrowOnError>({
    ...options,
    url: '/job.info',
  });
};

/**
 * job.list
 * List all open, closed, and archived jobs.
 *
 * **Requires the [`jobsRead`](authentication#permissions-joblist) permission.**
 *
 * To include draft jobs, `Draft` must be specified in the `status` param.
 *
 */
export const jobGetList = <ThrowOnError extends boolean = false>(options?: Options<JobGetListData, ThrowOnError>) => {
  return (options?.client ?? client).post<JobGetListResponse2, JobGetListError, ThrowOnError>({
    ...options,
    url: '/job.list',
  });
};

/**
 * job.setStatus
 * Sets the status on a job by id.
 *
 * **Requires the [`jobsWrite`](authentication#permissions-jobsetstatus) permission.**
 *
 * All jobs are drafts when they're first created. There are a few validations around the stages a job can be transitioned to:
 * - Drafts can be changed to Open or Archived
 * - Open jobs can be changed to Closed
 * - Closed jobs can be changed to Draft or Archived
 * - Archived jobs can be changed to a Draft
 *
 */
export const jobSetStatusById = <ThrowOnError extends boolean = false>(
  options?: Options<JobSetStatusByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<JobSetStatusByIdResponse2, JobSetStatusByIdError, ThrowOnError>({
    ...options,
    url: '/job.setStatus',
  });
};

/**
 * job.update
 * Updates an existing job
 *
 * **Requires the [`jobsWrite`](authentication#permissions-jobupdate) permission.**
 *
 */
export const jobUpdateExisting = <ThrowOnError extends boolean = false>(
  options?: Options<JobUpdateExistingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<JobUpdateExistingResponse2, JobUpdateExistingError, ThrowOnError>({
    ...options,
    url: '/job.update',
  });
};

/**
 * job.search
 * Searches for jobs by title
 *
 * **Requires the [`jobsRead`](authentication#permissions-jobsearch) permission.**
 *
 */
export const jobSearchByTitle = <ThrowOnError extends boolean = false>(
  options?: Options<JobSearchByTitleData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<JobSearchByTitleResponse2, JobSearchByTitleError, ThrowOnError>({
    ...options,
    url: '/job.search',
  });
};

/**
 * jobInterviewPlan.info
 * Returns a job's interview plan, including activities and interviews that need to be scheduled at each stage
 *
 * **Requires the [`jobsRead`](authentication#permissions-jobinterviewplaninfo) permission.**
 *
 */
export const jobInterviewPlanGetInfo = <ThrowOnError extends boolean = false>(
  options?: Options<JobInterviewPlanGetInfoData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<JobInterviewPlanGetInfoResponse2, JobInterviewPlanGetInfoError, ThrowOnError>(
    {
      ...options,
      url: '/jobInterviewPlan.info',
    },
  );
};

/**
 * jobPosting.info
 * Retrieve an individual job posting
 *
 * **Requires the [`jobsRead`](authentication#permissions-jobpostinginfo) permission.**
 *
 * Result fields:
 * - `linkedData` - Object that can be used to populate "rich results" in search engines. [See more info here](https://developers.google.com/search/docs/data-types/job-posting).
 * - `applicationFormDefinition` -	See the guide on [Creating a custom careers page](https://developers.ashbyhq.com/docs/creating-a-custom-careers-page).
 *
 */
export const jobPostingGetIndividual = <ThrowOnError extends boolean = false>(
  options?: Options<JobPostingGetIndividualData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<JobPostingGetIndividualResponse2, JobPostingGetIndividualError, ThrowOnError>(
    {
      ...options,
      url: '/jobPosting.info',
    },
  );
};

/**
 * jobPosting.list
 * Lists all published job postings
 *
 * **Requires the [`jobsRead`](authentication#permissions-jobpostinglist) permission.**
 *
 * **Important**: By default, this endpoint includes all listed and unlisted job postings. Unlisted job postings should not be displayed publicly.
 * If you are using the API to publicly expose job postings, set the `listedOnly` parameter to `true` when calling this API so that you only fetch listed job postings that can be displayed publicly.
 *
 */
export const jobPostingGetAllPublished = <ThrowOnError extends boolean = false>(
  options?: Options<JobPostingGetAllPublishedData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    JobPostingGetAllPublishedResponse2,
    JobPostingGetAllPublishedError,
    ThrowOnError
  >({
    ...options,
    url: '/jobPosting.list',
  });
};

/**
 * jobPosting.update
 * Updates an existing job posting.
 *
 * **Requires the [`jobsWrite`](authentication#permissions-jobpostingupdate) permission.**
 *
 * **Note on updating the description**: The `descriptionHtml` field returned in `jobPosting.info` may contain content that is not modifiable through the API. Only the content of the `descriptionParts.descriptionBody` field of the `jobPosting.info` endpoint is modifiable through this call.
 *
 */
export const jobPostingUpdateExisting = <ThrowOnError extends boolean = false>(
  options?: Options<JobPostingUpdateExistingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    JobPostingUpdateExistingResponse2,
    JobPostingUpdateExistingError,
    ThrowOnError
  >({
    ...options,
    url: '/jobPosting.update',
  });
};

/**
 * location.create
 * Creates a location or location hierarchy.
 *
 * **Requires the [`organizationWrite`](authentication#permissions-locationcreate) permission.**
 *
 */
export const locationCreateHierarchy = <ThrowOnError extends boolean = false>(
  options?: Options<LocationCreateHierarchyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<LocationCreateHierarchyResponse2, LocationCreateHierarchyError, ThrowOnError>(
    {
      ...options,
      url: '/location.create',
    },
  );
};

/**
 * location.info
 * Gets details for a single location by id.
 *
 * **Requires the [`organizationRead`](authentication#permissions-locationinfo) permission.**
 *
 */
export const locationDetailsById = <ThrowOnError extends boolean = false>(
  options?: Options<LocationDetailsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<LocationDetailsByIdResponse2, LocationDetailsByIdError, ThrowOnError>({
    ...options,
    url: '/location.info',
  });
};

/**
 * location.list
 * List all locations. Regions are not returned.
 *
 * **Requires the [`organizationRead`](authentication#permissions-locationlist) permission.**
 *
 */
export const locationGetList = <ThrowOnError extends boolean = false>(
  options?: Options<LocationGetListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<LocationGetListResponse2, LocationGetListError, ThrowOnError>({
    ...options,
    url: '/location.list',
  });
};

/**
 * offer.create
 * Creates a new Offer
 *
 * **Requires the [`offersWrite`](authentication#permissions-offercreate) permission.**
 *
 * Offer forms support a variety of field types. The values accepted for each field depend on the type of field that's being filled out:
 * - `Boolean` - A boolean value.
 * - `Currency` - An object in the format `{ currencyCode: "USD", value: 100000 }` where currencyCode is a valid ISO 4217 currency code and value is an integer.
 * - `Date` - A valid ISO Date string.
 * - `Number` - An integer.
 * - `String` - A string.
 * - `ValueSelect` - A string that matches the value of one of the ValueSelect field's selectable options.
 * - `MultiValueSelect` - An array of strings that exist in the MultiValueSelect field's selectable options.
 *
 */
export const offerCreateNew = <ThrowOnError extends boolean = false>(
  options?: Options<OfferCreateNewData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OfferCreateNewResponse2, OfferCreateNewError, ThrowOnError>({
    ...options,
    url: '/offer.create',
  });
};

/**
 * offer.info
 * Returns details about a single offer by id
 *
 * **Requires the [`offersRead`](authentication#permissions-offerinfo) permission.**
 *
 */
export const offerGetDetailsById = <ThrowOnError extends boolean = false>(
  options?: Options<OfferGetDetailsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OfferGetDetailsByIdResponse2, OfferGetDetailsByIdError, ThrowOnError>({
    ...options,
    url: '/offer.info',
  });
};

/**
 * offer.list
 * Get a list of all offers with their latest version
 *
 * **Requires the [`offersRead`](authentication#permissions-offerlist) permission.**
 *
 */
export const offerGetList = <ThrowOnError extends boolean = false>(
  options?: Options<OfferGetListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OfferGetListResponse2, OfferGetListError, ThrowOnError>({
    ...options,
    url: '/offer.list',
  });
};

/**
 * offer.start
 * The offer.start endpoint creates and returns an offer version instance that can be filled out and submitted
 * using the `offer.create` endpoint.
 *
 * **Requires the [`offersWrite`](authentication#permissions-offerstart) permission.**
 *
 * In order to create a new offer version for a candidate with an in-progress
 * offer process, you can call the `offer.start` endpoint and then call the `offer.create` endpoint to fill out the
 * newly created offer version form.
 *
 */
export const offerStartCreationInstance = <ThrowOnError extends boolean = false>(
  options?: Options<OfferStartCreationInstanceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    OfferStartCreationInstanceResponse2,
    OfferStartCreationInstanceError,
    ThrowOnError
  >({
    ...options,
    url: '/offer.start',
  });
};

/**
 * offerProcess.start
 * Starts an offer process for a candidate.
 *
 * **Requires the [`offersWrite`](authentication#permissions-offerprocessstart) permission.**
 *
 */
export const offerProcessStartProcessForCandidate = <ThrowOnError extends boolean = false>(
  options?: Options<OfferProcessStartProcessForCandidateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    OfferProcessStartProcessForCandidateResponse2,
    OfferProcessStartProcessForCandidateError,
    ThrowOnError
  >({
    ...options,
    url: '/offerProcess.start',
  });
};

/**
 * opening.info
 * Retrieves an opening by its UUID.
 *
 * **Requires the [`jobsRead`](authentication#permissions-openinginfo) permission.**
 */
export const openingsGetByUuid = <ThrowOnError extends boolean = false>(
  options?: Options<OpeningsGetByUuidData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OpeningsGetByUuidResponse2, OpeningsGetByUuidError, ThrowOnError>({
    ...options,
    url: '/opening.info',
  });
};

/**
 * opening.list
 * Lists openings.
 *
 * **Requires the [`jobsRead`](authentication#permissions-openinglist) permission.**
 */
export const openingsGetList = <ThrowOnError extends boolean = false>(
  options?: Options<OpeningsGetListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OpeningsGetListResponse2, OpeningsGetListError, ThrowOnError>({
    ...options,
    url: '/opening.list',
  });
};

/**
 * opening.search
 * Searches for openings by identifier.
 *
 * **Requires the [`jobsRead`](authentication#permissions-openingsearch) permission.**
 */
export const openingsSearchByIdentifier = <ThrowOnError extends boolean = false>(
  options?: Options<OpeningsSearchByIdentifierData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    OpeningsSearchByIdentifierResponse2,
    OpeningsSearchByIdentifierError,
    ThrowOnError
  >({
    ...options,
    url: '/opening.search',
  });
};

/**
 * opening.create
 * Creates an opening.
 *
 * **Requires the [`jobsWrite`](authentication#permissions-openingcreate) permission.**
 */
export const openingsCreateInstance = <ThrowOnError extends boolean = false>(
  options?: Options<OpeningsCreateInstanceData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OpeningsCreateInstanceResponse2, OpeningsCreateInstanceError, ThrowOnError>({
    ...options,
    url: '/opening.create',
  });
};

/**
 * opening.addJob
 * Adds a job to an opening.
 *
 * **Requires the [`jobsWrite`](authentication#permissions-openingaddjob) permission.**
 */
export const openingsAddJobAction = <ThrowOnError extends boolean = false>(
  options?: Options<OpeningsAddJobActionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OpeningsAddJobActionResponse2, OpeningsAddJobActionError, ThrowOnError>({
    ...options,
    url: '/opening.addJob',
  });
};

/**
 * opening.removeJob
 * Removes a job from an opening.
 *
 * **Requires the [`jobsWrite`](authentication#permissions-openingremovejob) permission.**
 */
export const openingsRemoveJob = <ThrowOnError extends boolean = false>(
  options?: Options<OpeningsRemoveJobData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OpeningsRemoveJobResponse2, OpeningsRemoveJobError, ThrowOnError>({
    ...options,
    url: '/opening.removeJob',
  });
};

/**
 * opening.setOpeningState
 * Sets the state of an opening.
 *
 * **Requires the [`jobsWrite`](authentication#permissions-openingsetopeningstate) permission.**
 */
export const openingsSetState = <ThrowOnError extends boolean = false>(
  options?: Options<OpeningsSetStateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OpeningsSetStateResponse2, OpeningsSetStateError, ThrowOnError>({
    ...options,
    url: '/opening.setOpeningState',
  });
};

/**
 * opening.setArchived
 * Sets the archived state of an opening.
 *
 * **Requires the [`jobsWrite`](authentication#permissions-openingsetarchived) permission.**
 */
export const openingsSetArchived = <ThrowOnError extends boolean = false>(
  options?: Options<OpeningsSetArchivedData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OpeningsSetArchivedResponse2, OpeningsSetArchivedError, ThrowOnError>({
    ...options,
    url: '/opening.setArchived',
  });
};

/**
 * opening.update
 * Updates an opening.
 *
 * **Requires the [`jobsWrite`](authentication#permissions-openingupdate) permission.**
 */
export const openingsUpdateOpening = <ThrowOnError extends boolean = false>(
  options?: Options<OpeningsUpdateOpeningData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<OpeningsUpdateOpeningResponse2, OpeningsUpdateOpeningError, ThrowOnError>({
    ...options,
    url: '/opening.update',
  });
};

/**
 * referral.create
 * Creates a referral
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-referralcreate) permission.**
 *
 */
export const referralCreateNew = <ThrowOnError extends boolean = false>(
  options?: Options<ReferralCreateNewData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ReferralCreateNewResponse2, ReferralCreateNewError, ThrowOnError>({
    ...options,
    url: '/referral.create',
  });
};

/**
 * referralForm.info
 * Fetches the default referral form or creates a default referral form if none exists.
 *
 * **Requires the [`hiringProcessMetadataRead`](authentication#permissions-referralforminfo) permission.**
 *
 */
export const referralFormGetDefaultForm = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ReferralFormGetDefaultFormResponse2,
    ReferralFormGetDefaultFormError,
    ThrowOnError
  >({
    ...options,
    url: '/referralForm.info',
  });
};

/**
 * source.list
 * List all sources
 *
 * **Requires the [`hiringProcessMetadataRead`](authentication#permissions-sourcelist) permission.**
 *
 */
export const sourceGetAll = <ThrowOnError extends boolean = false>(
  options?: Options<SourceGetAllData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SourceGetAllResponse2, SourceGetAllError, ThrowOnError>({
    ...options,
    url: '/source.list',
  });
};

/**
 * surveyFormDefinition.info
 * Returns details about a single survey form definition by id
 *
 * **Requires the [`hiringProcessMetadataRead`](authentication#permissions-surveyformdefinitioninfo) permission.**
 *
 */
export const surveyFormDefinitionGetDetailsById = <ThrowOnError extends boolean = false>(
  options?: Options<SurveyFormDefinitionGetDetailsByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SurveyFormDefinitionGetDetailsByIdResponse2,
    SurveyFormDefinitionGetDetailsByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/surveyFormDefinition.info',
  });
};

/**
 * surveyFormDefinition.list
 * Lists all survey form definitions.
 *
 * **Requires the [`hiringProcessMetadataRead`](authentication#permissions-surveyformdefinitionlist) permission.**
 *
 */
export const surveyFormDefinitionGetAll = <ThrowOnError extends boolean = false>(
  options?: Options<SurveyFormDefinitionGetAllData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SurveyFormDefinitionGetAllResponse2,
    SurveyFormDefinitionGetAllError,
    ThrowOnError
  >({
    ...options,
    url: '/surveyFormDefinition.list',
  });
};

/**
 * surveyRequest.create
 * This endpoint generates a survey request and returns a survey URL. You can send this URL to a candidate to allow them to complete a survey.
 *
 * **Requires the [`candidatesWrite`](authentication#permissions-surveyrequestcreate) permission.**
 *
 * **Note that calling this endpoint will not automatically email the survey to the candidate.** It simply creates the request and gives you a URL to share with a candidate.
 *
 */
export const surveyRequestGenerateUrl = <ThrowOnError extends boolean = false>(
  options?: Options<SurveyRequestGenerateUrlData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SurveyRequestGenerateUrlResponse2,
    SurveyRequestGenerateUrlError,
    ThrowOnError
  >({
    ...options,
    url: '/surveyRequest.create',
  });
};

/**
 * surveySubmission.list
 * Lists all survey submissions of a given `surveyType`.
 *
 * **Requires the [`candidatesRead`](authentication#permissions-surveySubmissionList) permission.**
 *
 */
export const surveySubmissionListBySurveyType = <ThrowOnError extends boolean = false>(
  options?: Options<SurveySubmissionListBySurveyTypeData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SurveySubmissionListBySurveyTypeResponse2,
    SurveySubmissionListBySurveyTypeError,
    ThrowOnError
  >({
    ...options,
    url: '/surveySubmission.list',
  });
};

/**
 * user.info
 * Get an Ashby user by id
 *
 * **Requires the [`organizationRead`](authentication#permissions-userinfo) permission.**
 *
 */
export const userGetById = <ThrowOnError extends boolean = false>(options?: Options<UserGetByIdData, ThrowOnError>) => {
  return (options?.client ?? client).post<UserGetByIdResponse2, UserGetByIdError, ThrowOnError>({
    ...options,
    url: '/user.info',
  });
};

/**
 * user.list
 * Get a list of all Ashby users
 *
 * **Requires the [`organizationRead`](authentication#permissions-userlist) permission.**
 *
 * The `globalRole` property in the response specifies the user's access level in Ashby.
 * For more details on the permissions granted with each role, see our [documentation here](https://ashbyhq.notion.site/Ashby-Permissions-a48eda7c07ad46f0bcd2b3f39301a9de#c64a4db5e7f4432bbe6691b91d3f0c62).
 *
 */
export const userGetAshbyUsers = <ThrowOnError extends boolean = false>(
  options?: Options<UserGetAshbyUsersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UserGetAshbyUsersResponse2, UserGetAshbyUsersError, ThrowOnError>({
    ...options,
    url: '/user.list',
  });
};

/**
 * user.search
 * Search for an Ashby user by email address
 *
 * **Requires the [`organizationRead`](authentication#permissions-usersearch) permission.**
 *
 */
export const userSearchByEmail = <ThrowOnError extends boolean = false>(
  options?: Options<UserSearchByEmailData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UserSearchByEmailResponse2, UserSearchByEmailError, ThrowOnError>({
    ...options,
    url: '/user.search',
  });
};

/**
 * webhook.create
 * Creates a webhook setting.
 *
 * **Requires the [`apiKeysWrite`](authentication#permissions-webhookcreate) scope.**
 *
 */
export const webhookCreateSetting = <ThrowOnError extends boolean = false>(
  options?: Options<WebhookCreateSettingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<WebhookCreateSettingResponse2, WebhookCreateSettingError, ThrowOnError>({
    ...options,
    url: '/webhook.create',
  });
};

/**
 * webhook.update
 * Updates a webhook setting. One of `enabled`, `requestUrl`, or `secretToken` must be provided.
 *
 * **Requires the [`apiKeysWrite`](authentication#permissions-webhookcreate) permission.**
 *
 */
export const webhookUpdateSetting = <ThrowOnError extends boolean = false>(
  options?: Options<WebhookUpdateSettingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<WebhookUpdateSettingResponse2, WebhookUpdateSettingError, ThrowOnError>({
    ...options,
    url: '/webhook.update',
  });
};

/**
 * webhook.delete
 * Deletes a webhook setting.
 *
 * **Requires the [`apiKeysWrite`](authentication#permissions-webhookcreate) permission.**
 *
 */
export const webhookRemoveSetting = <ThrowOnError extends boolean = false>(
  options?: Options<WebhookRemoveSettingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<WebhookRemoveSettingResponse2, WebhookRemoveSettingError, ThrowOnError>({
    ...options,
    url: '/webhook.delete',
  });
};
