// This file is auto-generated by @hey-api/openapi-ts

export const ApiKeyGetInfoRequestSchema = {
  type: 'object',
} as const;

export const ApplicationChangeSourceRequestSchema = {
  properties: {
    applicationId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the application to update the source of',
        },
      ],
    },
    sourceId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: "The source to set on the application. Pass null to unset an application's source.",
        },
      ],
    },
  },
  required: ['applicationId', 'sourceId'],
  example: {
    applicationId: '3ae2b801-19f6-41ef-ad28-214bd731948f',
    sourceId: '2c6991c5-c9e2-4af8-879e-29c5a9d26509',
  },
} as const;

export const ApplicationChangeStageRequestSchema = {
  properties: {
    applicationId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the application to update the stage of',
        },
      ],
    },
    interviewStageId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The interview stage to move the application to.',
        },
      ],
    },
    archiveReasonId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: `Archive Reason to set when moving to an Interview Stage with type: \`Archived\`. 
Note: You must pass this parameter when moving to an Interview Stage with type: \`Archived\`
`,
        },
      ],
    },
  },
  required: ['applicationId', 'interviewStageId'],
  example: {
    applicationId: '3ae2b801-19f6-41ef-ad28-214bd731948f',
    interviewStageId: '2c6991c5-c9e2-4af8-879e-29c5a9d26509',
  },
} as const;

export const ApplicationConsiderCandidateRequestSchema = {
  properties: {
    candidateId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the candidate to consider for a job',
        },
      ],
    },
    jobId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the job to consider the candidate for',
        },
      ],
    },
    interviewPlanId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: `The id of the interview plan to place the application in. If none is provided, the default interview plan is used.
`,
        },
      ],
    },
    interviewStageId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: `The interview stage of the interview plan (either default or provided) to place the application in. 
If none is provided, the application is placed in the first "Lead" stage. 
You can also supply the special string "FirstPreInterviewScreen", which will choose the first pre-interview-screen stage on the specified job's interview plan.
`,
        },
      ],
    },
    sourceId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The source to set on the application being created.',
        },
      ],
    },
    creditedToUserId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the user the application will be credited to.',
        },
      ],
    },
  },
  required: ['candidateId', 'jobId'],
  example: {
    candidateId: '3ae2b801-19f6-41ef-ad28-214bd731948f',
    jobId: '2c6991c5-c9e2-4af8-879e-29c5a9d26509',
  },
} as const;

export const ApplicationGetDetailsRequestSchema = {
  oneOf: [
    {
      type: 'object',
      properties: {
        applicationId: {
          allOf: [
            {
              description: 'The id of the application to fetch.',
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
        expand: {
          description: `Choose to expand the result and include additional data for related objects. 
`,
          type: 'array',
          items: {
            type: 'string',
            enum: ['openings', 'applicationFormSubmissions'],
          },
        },
      },
      required: ['applicationId'],
    },
    {
      type: 'object',
      properties: {
        submittedFormInstanceId: {
          allOf: [
            {
              description: "The id of the application's submitted form instance to fetch.",
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
        expand: {
          description: `Choose to expand the result and include additional data for related objects. 
`,
          type: 'array',
          items: {
            type: 'string',
            enum: ['openings', 'applicationFormSubmissions'],
          },
        },
      },
      required: ['submittedFormInstanceId'],
    },
  ],
} as const;

export const ApplicationGetAllSchedulesRequestSchema = {
  allOf: [
    {
      type: 'object',
      properties: {
        createdAfter: {
          description:
            'The API will return data after this date, which is the time since the unix epoch in milliseconds',
          type: 'integer',
          format: 'int64',
        },
        cursor: {
          $ref: '#/components/schemas/CandidateListAllRequest/properties/cursor',
        },
        syncToken: {
          $ref: '#/components/schemas/CandidateListAllRequest/properties/syncToken',
        },
        limit: {
          $ref: '#/components/schemas/CandidateListAllRequest/properties/limit',
        },
      },
      example: {
        createdAfter: 1659979196538,
        cursor: 'qA',
        syncToken: '6W05prn4d',
        limit: 25,
      },
    },
    {
      properties: {
        expand: {
          description: `Choose to expand the result and include additional data for related objects. 
`,
          type: 'array',
          items: {
            type: 'string',
            enum: ['openings'],
          },
        },
        status: {
          type: 'string',
          enum: ['Hired', 'Archived', 'Active', 'Lead'],
        },
        jobId: {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      },
    },
  ],
} as const;

export const ApplicationFeedbackListAllRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ApplicationGetAllSchedulesRequest/allOf/0',
    },
    {
      type: 'object',
      properties: {
        applicationId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: "The id of the application you'd like to fetch feedback for",
            },
          ],
        },
      },
    },
  ],
} as const;

export const ApplicationFeedbackSubmitFeedbackRequestSchema = {
  oneOf: [
    {
      type: 'object',
      required: ['feedbackForm', 'formDefinitionId', 'applicationId'],
      properties: {
        feedbackForm: {
          $ref: '#/components/schemas/OfferCreateNewRequest/properties/offerForm',
        },
        formDefinitionId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: 'The id of the feedback form definition associated with the form submission',
            },
          ],
        },
        applicationId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: "The id of the application you're submitting feedback for",
            },
          ],
        },
        userId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: `The id of the user the feedback will be credited to.
If a userId is not provided, the feedback will be credited to the API key user.
`,
            },
          ],
        },
      },
    },
    {
      type: 'object',
      required: ['feedbackForm', 'formDefinitionId', 'applicationId', 'userId', 'interviewEventId'],
      properties: {
        feedbackForm: {
          $ref: '#/components/schemas/OfferCreateNewRequest/properties/offerForm',
        },
        formDefinitionId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: 'The id of the feedback form definition associated with the form submission',
            },
          ],
        },
        applicationId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: "The id of the application you're submitting feedback for",
            },
          ],
        },
        userId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: `The id of the user the feedback will be credited to. 
The user must be an interviewer on the interview event that feedback is being submitted for.
`,
            },
          ],
        },
        interviewEventId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: `The id of the interview event you're submitting feedback for.
`,
            },
          ],
        },
      },
    },
  ],
} as const;

export const ApplicationFormSubmitFormRequestSchema = {
  type: 'object',
  required: ['jobPostingId', 'applicationForm'],
  properties: {
    jobPostingId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the job posting to submit an application for',
        },
      ],
    },
    applicationForm: {
      $ref: '#/components/schemas/OfferCreateNewRequest/properties/offerForm',
    },
    utmData: {
      type: 'object',
      properties: {
        utm_source: {
          type: 'string',
        },
        utm_campaign: {
          type: 'string',
        },
        utm_medium: {
          type: 'string',
        },
        utm_term: {
          type: 'string',
        },
        utm_content: {
          type: 'string',
        },
      },
    },
    '<file  key>': {
      description:
        'Any file referenced  in the `applicationForm`.   The name of this field must exactly match the `value` on the `fieldSubmission` that references this file.',
      type: 'string',
      format: 'binary',
    },
  },
} as const;

export const ApprovalDefinitionUpdateEntityScopeRequestSchema = {
  type: 'object',
  properties: {
    entityType: {
      type: 'string',
      enum: ['offer'],
    },
    entityId: {
      allOf: [
        {
          description: 'The id of the approval entity being updated (e.g. the id of the offer version).',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    approvalStepDefinitions: {
      description:
        'An ordered list of approval steps that describes the number of required approvers at each step, as well as who is an approver at each step.',
      type: 'array',
      items: {
        type: 'object',
        properties: {
          approvalsRequired: {
            description:
              'The number of approvers required to approve this step, before the approval moves on to the next step. The number of approvers must be non-zero and no more than the number of approvers in this step.',
            type: 'integer',
          },
          approvers: {
            description: 'An unordered list of who can approve this step.',
            type: 'array',
            items: {
              type: 'object',
              properties: {
                userId: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    {
                      description: 'The id of a user who is an approver for this step.',
                    },
                  ],
                },
                type: {
                  type: 'string',
                  enum: ['user'],
                },
              },
              required: ['userId', 'type'],
            },
          },
        },
        required: ['approvalsRequired', 'approvers'],
      },
    },
  },
  required: ['entityType', 'entityId', 'approvalStepDefinitions'],
} as const;

export const ArchiveReasonListRequestSchema = {
  type: 'object',
  properties: {
    includeArchived: {
      description: 'When true, includes archived interview plans',
      type: 'boolean',
      default: false,
    },
  },
} as const;

export const AssessmentAddCompletedToCandidateRequestSchema = {
  type: 'object',
  properties: {
    candidateId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the candidate, to whom to add the completed assessment',
        },
      ],
    },
    partnerId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the partner adding the assessment',
        },
      ],
    },
    assessment: {
      description: 'The completed assessment',
      type: 'object',
      required: ['assessmentTypeId', 'assessmentId', 'assessmentName', 'result', 'metadata'],
      properties: {
        assessmentTypeId: {
          allOf: [
            {
              description: 'An identifier that uniquely identifies the assessment type',
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
        assessmentId: {
          allOf: [
            {
              description: 'An identifier that uniquely identifies the completed assessment',
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
        assessmentName: {
          description: 'The name of the assessment that was taken that will be displayed in the UI',
          type: 'string',
          example: 'Node Assessment',
        },
        result: {
          allOf: [
            {
              description: "The assessment's result",
            },
            {
              $ref: '#/components/schemas/AssessmentUpdateStatusRequest/properties/metadata/items',
            },
          ],
        },
        metadata: {
          description: 'An array of metadata associated with this completed assessment',
          type: 'array',
          items: {
            $ref: '#/components/schemas/AssessmentUpdateStatusRequest/properties/metadata/items',
          },
        },
      },
    },
    timestamp: {
      allOf: [
        {
          description: 'The timestamp in milliseconds since the unix epoch, when the assessment was completed',
        },
        {
          $ref: '#/components/schemas/AssessmentUpdateStatusRequest/properties/timestamp',
        },
      ],
    },
  },
  required: ['candidateId', 'partnerId', 'assessment', 'timestamp'],
} as const;

export const AssessmentPartnerStartRequestSchema = {
  type: 'object',
  required: ['assessment_type_id', 'candidate', 'application', 'job'],
  properties: {
    assessment_type_id: {
      allOf: [
        {
          description: 'The id of the type of assessment to start (retrieved from calling /assessment.list)',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    candidate: {
      allOf: [
        {
          description: 'Identifier of the assessment being started',
        },
        {
          description: 'A description of the candidate',
          type: 'object',
          required: ['ashby_id', 'first_name', 'last_name', 'email', 'ashby_profile_url'],
          properties: {
            ashby_id: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The identifier of the candidate in Ashby',
                },
              ],
            },
            first_name: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The first name of the candidate being assessed',
                },
              ],
            },
            last_name: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The last name of the candidate being assessed',
                },
              ],
            },
            email: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The email of the candidate being assessed',
                },
              ],
            },
            ashby_profile_url: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The url back into Ashby of the candidate being assessed',
                },
              ],
            },
          },
        },
      ],
    },
    application: {
      allOf: [
        {
          description: 'The application for which the candidate is being assessed',
        },
        {
          description: 'The application for which the candidate is being assessed',
          type: 'object',
          required: ['ashby_id', 'status'],
          properties: {
            ashby_id: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The id of the application in Ashby',
                },
              ],
            },
            status: {
              allOf: [
                {
                  $ref: '#/components/schemas/ApplicationGetAllSchedulesRequest/allOf/1/properties/status',
                },
                {
                  description: 'The status of the application in Ashby',
                },
              ],
            },
          },
        },
      ],
    },
    job: {
      allOf: [
        {
          description: 'The job for which the candidate is being assessed',
        },
        {
          description: 'The job for which the candidate is being assessed',
          type: 'object',
          required: ['ashby_id', 'name', 'ashby_job_url'],
          properties: {
            ashby_id: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The id of the job in Ashby',
                },
              ],
            },
            name: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The name of the job in Ashby',
                },
              ],
            },
            req_id: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The customer-defined requisition id for the job',
                },
              ],
            },
            ashby_job_url: {
              allOf: [
                {
                  type: 'string',
                },
                {
                  description: 'The url of the job, internal to Ashby',
                },
              ],
            },
            hiringTeam: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/HiringTeamAddMemberResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
      ],
    },
  },
} as const;

export const AssessmentUpdateStatusRequestSchema = {
  type: 'object',
  required: ['assessment_id', 'assessment_status', 'timestamp'],
  properties: {
    assessment_id: {
      allOf: [
        {
          description: 'Identifier of the assessment being updated',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    assessment_status: {
      allOf: [
        {
          description:
            'The current status of the assessment. Setting this with a value of "Started" will signal Ashby to store the timestamp the assessment started.',
        },
        {
          $ref: '#/components/schemas/AssessmentUpdateStatusRequest/properties/metadata/items',
        },
      ],
    },
    assessment_profile_url: {
      allOf: [
        {
          description:
            "The url back to the assessment/candidate on the partner's website. This value should always be of type url. (required when assessment_result is set)",
        },
        {
          $ref: '#/components/schemas/AssessmentUpdateStatusRequest/properties/metadata/items',
        },
      ],
    },
    metadata: {
      description:
        'Any other metadata about the assessment (e.g. ETA until complete). All assessment data should have unique identifiers.',
      type: 'array',
      items: {
        type: 'object',
        properties: {
          description: {
            description: 'Description of the assessment metadata, which may be displayed in the UI',
            type: 'string',
            example: 'The maximum possible score for the assessment',
          },
          identifier: {
            description: 'Uniquely identifies this field, for this partner',
            type: 'string',
            example: 'result-max',
          },
          label: {
            description: 'Label for the assessment metadata to be displayed in the UI',
            type: 'string',
            example: 'Max Score',
          },
          type: {
            description: "The type of the value. Please reach out if you'd like us to support a new type!",
            type: 'string',
            enum: ['numeric_score', 'numeric_duration_minutes', 'url', 'string', 'boolean_success'],
          },
          value: {
            allOf: [
              {
                description: `The raw value — one of string, number, or boolean
`,
                oneOf: [
                  {
                    type: 'string',
                  },
                  {
                    type: 'number',
                  },
                  {
                    type: 'boolean',
                  },
                ],
              },
              {
                example: 10,
              },
            ],
          },
        },
        required: ['identifier', 'label', 'type', 'value'],
      },
    },
    timestamp: {
      description: 'The timestamp in milliseconds since the unix epoch, when the update occurred',
      type: 'integer',
      format: 'int64',
      example: 1665680638489,
    },
  },
} as const;

export const AssessmentCancelPartnerAssessmentRequestSchema = {
  type: 'object',
  required: ['assessment_id'],
  properties: {
    assessment_id: {
      allOf: [
        {
          description: 'The id of the started assessment to cancel',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
} as const;

export const CandidateAddTagRequestSchema = {
  type: 'object',
  required: ['candidateId', 'tagId'],
  properties: {
    candidateId: {
      description: 'The unique id of the candidate to add the tag to.',
      type: 'string',
      example: '5b591aed-88e3-4395-b9c6-7d529f93354a',
    },
    tagId: {
      description: 'The unique id of the tag to add to the candidate.',
      type: 'string',
      example: '38430ede-5bd2-41fc-b474-87591cb98cbc',
    },
  },
} as const;

export const CandidateAnonymizeCandidateRequestSchema = {
  type: 'object',
  required: ['candidateId'],
  properties: {
    candidateId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the candidate to anonymize.',
        },
      ],
    },
  },
} as const;

export const CandidateCreateNewCandidateRequestSchema = {
  type: 'object',
  properties: {
    name: {
      description: 'The first and last name of the candidate to be created.',
      type: 'string',
      example: 'Adam Hart',
    },
    email: {
      allOf: [
        {
          type: 'string',
          example: 'test@ashbyhq.com',
        },
        {
          description: 'Primary, personal email of the candidate to be created.',
        },
      ],
    },
    phoneNumber: {
      allOf: [
        {
          type: 'string',
          example: '555-555-5555',
        },
        {
          description: 'Primary, personal phone number of the candidate to be created.',
        },
      ],
    },
    linkedInUrl: {
      description: "Url to the candidate's LinkedIn profile. Must be a valid Url.",
      type: 'string',
      example: 'https://linkedin.com/in/user',
    },
    githubUrl: {
      description: "Url to the candidate's Github profile. Must be a valid Url.",
      type: 'string',
      example: 'https://github.com/user',
    },
    website: {
      description: "Url of the candidate's website. Must be a valid Url.",
      type: 'string',
      example: 'https://twitter.com/user',
    },
    alternateEmailAddresses: {
      description: "Array of alternate email address to add to the candidate's profile.",
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['test.email@ashbyhq.com'],
    },
    sourceId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The source to set on the candidate being created.',
        },
      ],
    },
    creditedToUserId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the user the candidate will be credited to.',
        },
      ],
    },
  },
  required: ['name'],
} as const;

export const CandidateCreateNoteRequestSchema = {
  type: 'object',
  properties: {
    candidateId: {
      type: 'string',
      format: 'uuid',
      example: 'e9ed20fd-d45f-4aad-8a00-a19bfba0083e',
    },
    note: {
      oneOf: [
        {
          description: 'The note to add to the candidate',
          type: 'string',
          example: 'Strong candidate, very interested in the company',
        },
        {
          description: 'Note content',
          type: 'object',
          properties: {
            type: {
              description: `The content type of the note. For notes submitted with a type of text/html we support the elements listed below. Any unsupported elements will be stripped out of the note's content before posting.
- Bold \`<b>\`
- Italic \`<i>\`
- Underline \`<u>\`
- Links \`<a>\`
- Bulleted Lists - \`<ul>\`, \`<li>\`
- Ordered Lists - \`<ol>\`, \`<li>\`
- Code - \`<code>\`
- Code Block - \`<pre>\`
`,
              type: 'string',
              enum: ['text/plain', 'text/html'],
            },
            value: {
              type: 'string',
            },
          },
          required: ['type', 'value'],
        },
      ],
    },
    sendNotifications: {
      description:
        'Whether or not users who are subscribed to the candidate should be notified that the note was posted.',
      type: 'boolean',
      default: false,
    },
  },
  required: ['candidateId', 'note'],
} as const;

export const CandidateGetByIdRequestSchema = {
  oneOf: [
    {
      type: 'object',
      properties: {
        id: {
          description: 'The id of the candidate to fetch',
          type: 'string',
          format: 'uuid',
        },
      },
      required: ['id'],
      example: {
        id: 'f9e52a51-a075-4116-a7b8-484deba69004',
      },
    },
    {
      type: 'object',
      properties: {
        externalMappingId: {
          description: `An id assigned to a candidate outside of Ashby. 
Used to associate Ashby candidates with their profiles in external systems (BambooHR, Rippling, Gusto, etc.)
`,
          type: 'string',
        },
      },
      required: ['externalMappingId'],
      example: {
        externalMappingId: 'f9e52a51-a075-4116-a7b8-484deba69004',
      },
    },
  ],
} as const;

export const CandidateListAllRequestSchema = {
  type: 'object',
  properties: {
    cursor: {
      description: 'Opaque cursor indicating which page of results to fetch',
      type: 'string',
      example: 'G8',
    },
    syncToken: {
      description: `An opaque token representing the last time the data was successfully synced from the API. A new, updated one is returned after successfully fetching the last page of data.
`,
      type: 'string',
      example: 'jYnEBmjzR',
    },
    limit: {
      description: 'The maximum number of items to return. The maximum and default value is 100.',
      type: 'number',
      example: 25,
    },
  },
  example: {
    syncToken: '6W05prn4d',
    cursor: 'qA',
    limit: 25,
  },
} as const;

export const CandidateGetAllNotesRequestSchema = {
  allOf: [
    {
      type: 'object',
      properties: {
        candidateId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: 'The id of the candidate to fetch notes for',
            },
          ],
        },
      },
    },
    {
      $ref: '#/components/schemas/CandidateListAllRequest',
    },
  ],
  required: ['candidateId'],
  example: {
    candidateId: 'f9e52a51-a075-4116-a7b8-484deba69004',
  },
} as const;

export const CandidateSearchByEmailAndNameRequestSchema = {
  type: 'object',
  properties: {
    email: {
      description: "The candidate's email",
      type: 'string',
    },
    name: {
      description: "The candidate's name",
      type: 'string',
    },
  },
  example: {
    email: 'test@ashbyhq.com',
    name: 'Adam Hart',
  },
} as const;

export const CandidateUpdateExistingCandidateRequestSchema = {
  type: 'object',
  properties: {
    candidateId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The unique id of the candidate to update.',
        },
      ],
    },
    name: {
      description: 'The first and last name of the candidate to update.',
      type: 'string',
      example: 'Adam Hart',
    },
    email: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNewCandidateRequest/properties/email/allOf/0',
        },
        {
          description: 'Primary, personal email of the candidate to update.',
        },
      ],
    },
    phoneNumber: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNewCandidateRequest/properties/phoneNumber/allOf/0',
        },
        {
          description: 'Primary, personal phone number of the candidate to update.',
        },
      ],
    },
    linkedInUrl: {
      $ref: '#/components/schemas/CandidateCreateNewCandidateRequest/properties/linkedInUrl',
    },
    githubUrl: {
      $ref: '#/components/schemas/CandidateCreateNewCandidateRequest/properties/githubUrl',
    },
    websiteUrl: {
      $ref: '#/components/schemas/CandidateCreateNewCandidateRequest/properties/website',
    },
    alternateEmail: {
      description: "An alternate email address to add to the candidate's profile.",
      type: 'string',
      example: 'test.email@ashbyhq.com',
    },
    socialLinks: {
      description: `An array of social links to set on the candidate. This value replaces existing socialLinks that have been set on the candidate. 
If this value is submitted along with linkedInUrl, gitHubUrl or websiteUrl fields, those values will be ignored.
`,
      type: 'array',
      items: {
        type: 'object',
        properties: {
          type: {
            enum: ['LinkedIn', 'GitHub', 'Twitter', 'Medium', 'StackOverflow', 'Website'],
            type: 'string',
          },
          url: {
            type: 'string',
          },
        },
        required: ['type', 'url'],
        example: {
          url: 'https://linkedin.com/in/user',
          type: 'LinkedIn',
        },
      },
    },
    sourceId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of source for this candidate.',
        },
      ],
    },
    creditedToUserId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the user the candidate will be credited to.',
        },
      ],
    },
  },
  required: ['candidateId'],
} as const;

export const CandidateAttachFileRequestSchema = {
  type: 'object',
  properties: {
    candidateId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the candidate',
        },
      ],
    },
    file: {
      description: "The file to upload to the candidate's profile",
      type: 'string',
      format: 'binary',
    },
  },
  required: ['candidateId', 'file'],
  example: {
    id: 'f9e52a51-a075-4116-a7b8-484deba69004X',
  },
} as const;

export const CandidateUploadResumeDataRequestSchema = {
  type: 'object',
  properties: {
    candidateId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the candidate',
        },
      ],
    },
    resume: {
      description: "The resume to upload to the candidate's profile",
      type: 'string',
      format: 'binary',
    },
  },
  required: ['candidateId', 'resume'],
  example: {
    id: 'f9e52a51-a075-4116-a7b8-484deba69004X',
  },
} as const;

export const CandidateTagCreateNewTagRequestSchema = {
  type: 'object',
  required: ['title'],
  properties: {
    title: {
      description: "The tag's title. If a tag already exists with that title, the existing tag will be returned.",
      type: 'string',
      example: 'Strong candidate',
    },
  },
} as const;

export const CandidateTagListAllRequestSchema = {
  allOf: [
    {
      type: 'object',
      properties: {
        includeArchived: {
          description: 'Whether archived candidate tags should be included in the response',
          type: 'boolean',
          default: false,
        },
      },
    },
  ],
} as const;

export const CustomFieldCreateNewFieldRequestSchema = {
  type: 'object',
  required: ['fieldType', 'objectType', 'title'],
  properties: {
    title: {
      description: 'The name of the field',
      type: 'string',
    },
    description: {
      description: 'A description for the field',
      type: 'string',
    },
    fieldType: {
      description: 'The type of field being created. This value is case-sensitive.',
      type: 'string',
      enum: ['Boolean', 'Date', 'MultiValueSelect', 'Number', 'String', 'ValueSelect'],
    },
    objectType: {
      description: 'The type of object the field can be associated with.',
      type: 'string',
      enum: ['Application', 'Candidate', 'Job', 'Employee', 'Talent_Project', 'Opening_Version', 'Offer_Version'],
    },
    selectableValues: {
      description:
        'Required when the field type is ValueSelect or MultiValueSelect. An array of selectable values for the field.',
      type: 'array',
      items: {
        properties: {
          label: {
            type: 'string',
          },
          value: {
            type: 'string',
          },
        },
        required: ['label', 'value'],
        type: 'object',
      },
    },
    isDateOnlyField: {
      description:
        'Only applies to fields with an objectType of Date. Whether or not the field includes content other than a date',
      type: 'boolean',
    },
    isExposableToCandidate: {
      description:
        'Determines whether the field can be exposed to a candidate in certain contexts. In order for a custom field to be available in an email template this value must be true.',
      type: 'boolean',
      default: false,
    },
  },
} as const;

export const CustomFieldSetValueRequestSchema = {
  type: 'object',
  required: ['objectId', 'objectType', 'fieldId', 'fieldValue'],
  properties: {
    objectId: {
      allOf: [
        {
          description: 'The id of the object the field value is being set on.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    objectType: {
      description: 'The type of object the field is associated with.',
      type: 'string',
      enum: ['Application', 'Candidate', 'Job'],
    },
    fieldId: {
      allOf: [
        {
          description: 'The unique id of the Custom Field definition for the field',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    fieldValue: {
      description: 'The value to store in the field',
      oneOf: [
        {
          title: 'Boolean',
          description: 'A boolean value',
          type: 'boolean',
        },
        {
          title: 'Date',
          description: 'An ISO Date string',
          type: 'string',
          format: 'date-time',
        },
        {
          title: 'String, Email, LongText, Phone',
          description: 'A string',
          type: 'string',
        },
        {
          title: 'MultiValueSelect',
          type: 'array',
          items: {
            description: "An array of strings that exist in the MultiValueSelect field's options",
            type: 'string',
          },
        },
        {
          title: 'Number',
          description: 'A number',
          type: 'number',
        },
        {
          title: 'ValueSelect',
          description: "A string that matches the value of one of the ValueSelect field's options",
          type: 'string',
        },
      ],
    },
  },
} as const;

export const DepartmentTeamCreateNewDepartmentRequestSchema = {
  type: 'object',
  required: ['name'],
  properties: {
    name: {
      description: 'The name of the department',
      type: 'string',
      example: 'Engineering',
    },
    parentId: {
      description: "The id of the department's parent department",
      type: 'string',
      format: 'uuid',
      example: '1be42b8e-cafd-4beb-8121-f4981eb20f42',
    },
  },
} as const;

export const DepartmentGetByIdRequestSchema = {
  properties: {
    departmentId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The unique id of the department whose details will be fetched',
        },
      ],
    },
  },
  required: ['departmentId'],
  example: {
    departmentId: '3ae2b801-19f6-41ef-ad28-214bd731948f',
  },
} as const;

export const DepartmentGetAllDepartmentsRequestSchema = {
  allOf: [
    {
      type: 'object',
      properties: {
        includeArchived: {
          description: 'Whether archived departments should be included in the response',
          type: 'boolean',
          default: false,
        },
      },
    },
  ],
} as const;

export const FileGetUrlCandidateRequestSchema = {
  type: 'object',
  properties: {
    fileHandle: {
      description: 'A file handle retrieved from the public API',
      type: 'string',
      example: `eyJoYW5kbGUiOnsidHlwZSI6IkNhbmRpZGF0ZUZpbGUiLCJmaWxlSWQiOiIxNTk1ZTRmYy04MTQwLTQ1NGUtYTI1ZC04NTNiOTQ3ZWNmYzgiLCJvd25lcklkIjoiYmY5NGZlNmMtMjU3MS00NzQ1LWE1OWEtNTA5MjE3ODI3MDVlIn0sInNpZ25hdHVyZSI6IkFqclpjT0VlTXUwdWxLZlRCS05iMWRkbDdHcjVIWFVmZzNrS0NPL1dWWjg9IiwidmVyc2lvbiI6IjEilQ
`,
    },
  },
  required: ['fileHandle'],
} as const;

export const FeedbackFormDefinitionGetByIdRequestSchema = {
  type: 'object',
  required: ['feedbackFormDefinitionId'],
  properties: {
    feedbackFormDefinitionId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: "The unique id of the feedback form you'd like to fetch.",
        },
        {
          example: '9b17887e-5add-49e8-9a03-ffffa669aa2f',
        },
      ],
    },
  },
} as const;

export const FeedbackFormDefinitionListAllRequestSchema = {
  type: 'object',
  properties: {
    includeArchived: {
      $ref: '#/components/schemas/SourceGetAllRequest/properties/includeArchived',
    },
    cursor: {
      $ref: '#/components/schemas/CandidateListAllRequest/properties/cursor',
    },
    syncToken: {
      $ref: '#/components/schemas/CandidateListAllRequest/properties/syncToken',
    },
    limit: {
      $ref: '#/components/schemas/CandidateListAllRequest/properties/limit',
    },
  },
  example: {
    includeArchived: false,
    cursor: 'qA',
    syncToken: '6W05prn4d',
    limit: 25,
  },
} as const;

export const HiringTeamAddMemberRequestSchema = {
  oneOf: [
    {
      title: 'Application-level',
      type: 'object',
      required: ['applicationId', 'teamMemberId', 'roleId'],
      properties: {
        applicationId: {
          allOf: [
            {
              description: 'The application to assign the user a role on.',
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
        teamMemberId: {
          allOf: [
            {
              description: 'The id of the user to assign the role to.',
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
        roleId: {
          allOf: [
            {
              description: 'The id of the hiring team role to assign.',
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
      },
    },
    {
      title: 'Job-level',
      type: 'object',
      required: ['jobId', 'teamMemberId', 'roleId'],
      properties: {
        jobId: {
          allOf: [
            {
              description: 'The job to assign the user a role on.',
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
        teamMemberId: {
          allOf: [
            {
              description: 'The id of the user to assign the role to.',
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
        roleId: {
          allOf: [
            {
              description: 'The id of the hiring team role to assign.',
            },
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
          ],
        },
      },
    },
  ],
} as const;

export const HiringTeamRoleListRolesRequestSchema = {
  type: 'object',
  properties: {
    namesOnly: {
      description:
        'When set to true (the default), an array of role titles is returned. When set to false, an array of objects that include the id and title of the role is returned.',
      type: 'boolean',
      default: true,
    },
  },
} as const;

export const InterviewGetByIdRequestSchema = {
  properties: {
    id: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The unique id of the interview whose details will be fetched',
        },
      ],
    },
  },
  required: ['id'],
  example: {
    id: '3ae2b801-19f6-41ef-ad28-214bd731948f',
  },
} as const;

export const InterviewGetAllRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/CandidateListAllRequest',
    },
    {
      type: 'object',
      properties: {
        includeArchived: {
          $ref: '#/components/schemas/SourceGetAllRequest/properties/includeArchived',
        },
        includeNonSharedInterviews: {
          description: `If true, interviews that are associated with specific jobs will be included in the response. 
Shared interviews that are not associated with a specific job can be scheduled for applications to any job.
Interviews that are not shared can only be scheduled for applications to the job they are associated with. 
`,
          type: 'boolean',
          default: false,
        },
      },
    },
  ],
} as const;

export const InterviewEventListAssociatedEventsRequestSchema = {
  properties: {
    interviewScheduleId: {
      allOf: [
        {
          description: 'The unique ID of the interview schedule, for which to list interview events',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['interviewScheduleId'],
} as const;

export const InterviewPlanGetAllRequestSchema = {
  properties: {
    includeArchived: {
      $ref: '#/components/schemas/SourceGetAllRequest/properties/includeArchived',
    },
  },
} as const;

export const InterviewScheduleCancelByIdRequestSchema = {
  properties: {
    id: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the interview schedule to cancel',
        },
      ],
    },
    allowReschedule: {
      description: 'Whether or not this interview schedule can be rescheduled.',
      type: 'boolean',
      default: false,
    },
  },
  required: ['id'],
  example: {
    id: '3ae2b801-19f6-41ef-ad28-214bd731948fX',
  },
} as const;

export const InterviewScheduleCreateScheduledInterviewRequestSchema = {
  properties: {
    applicationId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the application for this interview schedule',
        },
      ],
    },
    interviewEvents: {
      description: 'The list of events that make up this interview schedule',
      type: 'array',
      items: {
        type: 'object',
        required: ['startTime', 'endTime', 'interviewers'],
        properties: {
          startTime: {
            description: 'The start time of this event',
            type: 'string',
            example: '2023-01-30T15:00:00.000Z',
          },
          endTime: {
            description: 'The end time of this event',
            type: 'string',
            example: '2023-01-30T16:00:00.000Z',
          },
          interviewers: {
            description: 'The interviewers for this event',
            type: 'array',
            items: {
              type: 'object',
              required: ['email'],
              properties: {
                email: {
                  description: 'The email address of the user in Ashby',
                  type: 'string',
                  example: 'test@ashbyhq.com',
                },
                feedbackRequired: {
                  description: 'Whether this interviewer is required to provide feedback',
                  type: 'boolean',
                },
              },
            },
          },
          interviewId: {
            allOf: [
              {
                $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
              },
              {
                description:
                  "The id of the interview used in this event. If no value is provided, the organization's default interview will be used.",
              },
              {
                example: '46648e83-f28f-43c4-a2a0-58e0599cff41',
              },
            ],
          },
        },
      },
    },
  },
  required: ['applicationId', 'interviewEvents'],
} as const;

export const InterviewScheduleGetAllSchedulesRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/ApplicationGetAllSchedulesRequest/allOf/0',
    },
    {
      type: 'object',
      properties: {
        applicationId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: 'The id of the application, for which to fetch interview schedules',
            },
          ],
        },
        interviewStageId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: 'The id of the interview stage, for which to fetch interview schedules',
            },
          ],
        },
      },
    },
  ],
} as const;

export const InterviewScheduleUpdateEventRequestSchema = {
  oneOf: [
    {
      type: 'object',
      properties: {
        interviewScheduleId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: `The id of the interview schedule to update. 
Only interview schedules created using the API key making the request can be updated.
`,
            },
          ],
        },
        interviewEvent: {
          allOf: [
            {
              description: `An event on the interview schedule to create or update.
To update an event, the event's \`interviewEventId\` must be included in the request.
`,
            },
            {
              $ref: '#/components/schemas/InterviewScheduleCreateScheduledInterviewRequest/properties/interviewEvents/items',
            },
            {
              type: 'object',
              properties: {
                interviewEventId: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    {
                      description: `The id of an interview event to update. 
`,
                    },
                  ],
                },
              },
            },
          ],
        },
      },
      required: ['interviewScheduleId', 'interviewEvent'],
    },
    {
      type: 'object',
      properties: {
        interviewScheduleId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: `The id of the interview schedule to update. 
Only interview schedules created using the API key making the request can be updated.
`,
            },
          ],
        },
        interviewEventIdToCancel: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: `The id of an interview event to cancel.
`,
            },
          ],
        },
        allowFeedbackDeletion: {
          description:
            'By default, we do not allow interview events with submitted feedback to be canceled because canceling an event causes its associated feedback to be deleted. If you want to allow events with submitted feedback to be canceled, this flag can be passed in and set to `true`. In this case, events with feedback will be canceled, and any associated feedback will be deleted.',
          type: 'boolean',
          default: false,
        },
      },
      required: ['interviewScheduleId', 'interviewEventIdToCancel'],
    },
  ],
} as const;

export const InterviewStageListAllInOrderRequestSchema = {
  type: 'object',
  properties: {
    interviewPlanId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the interview plan to list stages for',
        },
      ],
    },
  },
  required: ['interviewPlanId'],
} as const;

export const InterviewStageGetByIdRequestSchema = {
  properties: {
    interviewStageId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The unique id of the interview stage whose details will be fetched',
        },
      ],
    },
  },
  required: ['interviewStageId'],
  example: {
    interviewStageId: '3ae2b801-19f6-41ef-ad28-214bd731948f',
  },
} as const;

export const JobNewCreateRequestSchema = {
  type: 'object',
  properties: {
    title: {
      description: 'The title of the job.',
      type: 'string',
      example: 'Software Engineer',
    },
    teamId: {
      allOf: [
        {
          description: 'The id of the department or team associated with the job',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    locationId: {
      allOf: [
        {
          description: 'The id of the location of the job',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    defaultInterviewPlanId: {
      allOf: [
        {
          description: `The id of the default interview plan for this job posting. 
A job cannot be opened without a default interview plan.
`,
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['title', 'teamId', 'locationId'],
} as const;

export const JobGetByIdRequestSchema = {
  type: 'object',
  properties: {
    id: {
      allOf: [
        {
          description: 'The id of the job to fetch',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    expand: {
      description: `Choose to expand the result and include additional data for related objects. 
`,
      type: 'array',
      items: {
        type: 'string',
        enum: ['location', 'openings'],
      },
    },
  },
  required: ['id'],
} as const;

export const JobGetListRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/CandidateListAllRequest',
    },
    {
      type: 'object',
      properties: {
        status: {
          description: 'When supplied, only jobs with the provided status(es) will be returned.',
          type: 'array',
          items: {
            $ref: '#/components/schemas/JobSetStatusByIdRequest/properties/status/allOf/1',
          },
        },
        openedAfter: {
          description: 'Return jobs opened after this date, which is the time since the unix epoch in milliseconds',
          type: 'integer',
          format: 'int64',
        },
        openedBefore: {
          description: 'Return jobs opened before this date, which is the time since the unix epoch in milliseconds',
          type: 'integer',
          format: 'int64',
        },
        closedAfter: {
          description: 'Return jobs closed after this date, which is the time since the unix epoch in milliseconds',
          type: 'integer',
          format: 'int64',
        },
        closedBefore: {
          description: 'Return jobs closed before this date, which is the time since the unix epoch in milliseconds',
          type: 'integer',
          format: 'int64',
        },
        expand: {
          $ref: '#/components/schemas/JobGetByIdRequest/properties/expand',
        },
      },
    },
  ],
} as const;

export const JobSetStatusByIdRequestSchema = {
  type: 'object',
  properties: {
    jobId: {
      allOf: [
        {
          description: 'The unique id of the job to set the status of.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    status: {
      allOf: [
        {
          description: 'The status to apply to the job.',
        },
        {
          type: 'string',
          enum: ['Draft', 'Open', 'Closed', 'Archived'],
        },
      ],
    },
  },
  required: ['jobId', 'status'],
} as const;

export const JobUpdateExistingRequestSchema = {
  type: 'object',
  properties: {
    title: {
      description: 'A new title for the job.',
      type: 'string',
      example: 'Software Engineer',
    },
    jobId: {
      allOf: [
        {
          description: 'The unique id of the job to update.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    teamId: {
      allOf: [
        {
          description: 'The new team to associate with the job.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    locationId: {
      allOf: [
        {
          description: 'The new location to associate with the job.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    defaultInterviewPlanId: {
      allOf: [
        {
          description: 'The new default interview plan to associate with the job.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    customRequisitionId: {
      allOf: [
        {
          description: 'The new default custom requisition id for the job.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['jobId'],
} as const;

export const JobSearchByTitleRequestSchema = {
  type: 'object',
  properties: {
    title: {
      description: 'The title of the job to search for',
      type: 'string',
      example: 'Software Engineer',
    },
  },
  required: ['title'],
} as const;

export const JobInterviewPlanGetInfoRequestSchema = {
  type: 'object',
  properties: {
    jobId: {
      allOf: [
        {
          description: 'The id of the job to fetch an interview plan for',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['jobId'],
} as const;

export const JobPostingGetIndividualRequestSchema = {
  type: 'object',
  properties: {
    jobPostingId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the job posting to return',
        },
      ],
    },
  },
  required: ['jobPostingId'],
} as const;

export const JobPostingGetAllPublishedRequestSchema = {
  type: 'object',
  properties: {
    location: {
      description: 'filter by location name (case sensitive)',
      type: 'string',
    },
    department: {
      description: 'filter by department name (case sensitive)',
      type: 'string',
    },
    listedOnly: {
      description: 'If true, filter out unlisted job postings.',
      type: 'boolean',
      default: false,
    },
  },
} as const;

export const JobPostingUpdateExistingRequestSchema = {
  type: 'object',
  properties: {
    title: {
      description: 'A new title for the job posting.',
      type: 'string',
      example: 'Software Engineer',
    },
    description: {
      description: `An HTML block of the job posting description. Please see below for supported tags.

**Note**: The \`descriptionHtml\` field returned in \`jobPosting.info\` may contain content that is not modifiable through the API. Only the content of the \`descriptionParts.descriptionBody\` field of the \`jobPosting.info\` endpoint is modifiable through this call.
`,
      type: 'object',
      properties: {
        type: {
          type: 'string',
          enum: ['text/html'],
        },
        content: {
          description: `The HTML content of the Job Posting. The following tags will accept updates. Updates to any other tags will be stripped out or not applied. 
- Headings - \`<h[1-6]>\`
- Bold - \`<b>\`
- Italic - \`<i>\`
- Underline - \`<u>\`
- Links - \`<a>\`
- Bulleted Lists - \`<ul>\`, \`<li>\`
- Ordered Lists - \`<ol>\`, \`<li>\`
- Code - \`<code>\`
- Code blocks - \`<pre>\`
`,
          type: 'string',
        },
      },
      required: ['type', 'content'],
    },
    jobPostingId: {
      allOf: [
        {
          description: 'The unique id of the job posting to update.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['jobPostingId'],
} as const;

export const LocationCreateHierarchyRequestSchema = {
  type: 'object',
  required: ['name', 'type'],
  properties: {
    name: {
      description: 'The name of the location',
      type: 'string',
    },
    type: {
      description:
        'A Location represents an actual location that jobs and employees can be associated with. A Location Hierarchy is a grouping of locations or other location hierarchies.',
      type: 'string',
      enum: ['Location', 'LocationHierarchy'],
    },
    address: {
      description: 'The address of the location',
      type: 'object',
      properties: {
        postalAddress: {
          type: 'object',
          properties: {
            addressCountry: {
              description: 'The country the location is in. Must be a valid country name or two-letter country code.',
              type: 'string',
            },
            addressRegion: {
              description: 'The region the location is in (for instance, a state or province)',
              type: 'string',
            },
            addressLocality: {
              description: 'The city or town of the location',
              type: 'string',
            },
          },
        },
      },
    },
    parentLocationId: {
      description: "The id of the location's parent",
      type: 'string',
    },
    isRemote: {
      description: 'Whether the location should be labeled as remote. LocationHierarchies cannot be labeled as remote.',
      type: 'boolean',
      default: false,
    },
  },
} as const;

export const LocationDetailsByIdRequestSchema = {
  type: 'object',
  properties: {
    locationId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the location to fetch',
        },
      ],
    },
  },
  required: ['locationId'],
} as const;

export const LocationGetListRequestSchema = {
  type: 'object',
  properties: {
    includeArchived: {
      $ref: '#/components/schemas/SourceGetAllRequest/properties/includeArchived',
    },
  },
} as const;

export const OfferCreateNewRequestSchema = {
  type: 'object',
  properties: {
    offerProcessId: {
      allOf: [
        {
          description: `The id of the offer process associated with the offer you're creating. 
This value is the id included in the response of the \`offerProcess.start\` API.
`,
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    offerFormId: {
      allOf: [
        {
          description: `The id of the form associated with the offer.
This value is the id included in the response of the \`offer.start\` API.
`,
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    offerForm: {
      type: 'object',
      properties: {
        fieldSubmissions: {
          type: 'array',
          items: {
            properties: {
              path: {
                description: `The form field's "path" value`,
                type: 'string',
              },
              value: {
                description:
                  'This is often a primitive but the value depends on the type of field being submitted. See the description above for details on the values accepted in this field.',
                type: 'string',
              },
            },
            required: ['path', 'value'],
          },
        },
      },
      required: ['fieldSubmissions'],
    },
  },
  required: ['offerProcessId', 'offerFormId', 'offerForm'],
} as const;

export const OfferGetDetailsByIdRequestSchema = {
  type: 'object',
  properties: {
    offerId: {
      allOf: [
        {
          description: 'The id of the offer to fetch',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['offerId'],
} as const;

export const OfferGetListRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/CandidateListAllRequest',
    },
    {
      type: 'object',
      properties: {
        applicationId: {
          allOf: [
            {
              $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
            },
            {
              description: 'If provided, only returns the offers for the application with the supplied id',
            },
          ],
        },
      },
    },
  ],
} as const;

export const OfferStartCreationInstanceRequestSchema = {
  type: 'object',
  properties: {
    offerProcessId: {
      allOf: [
        {
          description:
            'The ID of the offer process to start. This value is the id included in the response of the `offerProcess.start` API.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['offerProcessId'],
} as const;

export const OfferProcessStartProcessForCandidateRequestSchema = {
  type: 'object',
  properties: {
    applicationId: {
      allOf: [
        {
          description: 'The id of the application to start an offer process for',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['applicationId'],
} as const;

export const OpeningsGetByUuidRequestSchema = {
  type: 'object',
  required: ['openingId'],
  properties: {
    openingId: {
      description: 'The id of the opening',
      type: 'string',
    },
  },
} as const;

export const OpeningsGetListRequestSchema = {
  type: 'object',
  properties: {
    cursor: {
      description: 'Opaque cursor indicating which page of results to fetch',
      type: 'string',
    },
    syncToken: {
      description: 'Opaque token representing the last time a full set of results was fetched.',
      type: 'string',
    },
  },
} as const;

export const OpeningsSearchByIdentifierRequestSchema = {
  type: 'object',
  required: ['identifier'],
  properties: {
    identifier: {
      description: 'The identifier of the opening you want to search for',
      type: 'string',
    },
  },
} as const;

export const OpeningsCreateInstanceRequestSchema = {
  type: 'object',
  properties: {
    description: {
      type: 'string',
    },
    identifier: {
      description: 'jobIds,     targetHireDate,     targetStartDate,     isBackfill,     employmentType,',
      type: 'string',
    },
    teamId: {
      description: 'The id of the department or team associated with the opening.',
      type: 'string',
    },
    locationIds: {
      description: 'The ids of the locations associated with the opening.',
      type: 'array',
      items: {
        type: 'string',
      },
    },
    jobIds: {
      description: 'The ids of the jobs associated with the opening',
      type: 'array',
      items: {
        type: 'string',
      },
    },
    targetHireDate: {
      description: 'The date (in YYYY-MM-DD format) by which you intend to hire against this opening.',
      type: 'string',
    },
    targetStartDate: {
      description:
        'The date (in YYYY-MM-DD format) by which you intend someone hired against this opening will start employment.',
      type: 'string',
    },
    isBackfill: {
      description: 'Whether this opening is intended to backfill a previous employee',
      type: 'boolean',
      default: false,
    },
    employmentType: {
      description: 'The employment type for this opening',
      type: 'string',
      default: 'FullTime',
      enum: ['FullTime', 'PartTime', 'Intern', 'Contract', 'Temporary', ''],
    },
    openingState: {
      description: 'The state the opening should be created in.',
      type: 'string',
      enum: ['Draft', 'Approved', 'Open', 'Closed'],
    },
  },
} as const;

export const OpeningsAddJobActionRequestSchema = {
  type: 'object',
  required: ['openingId', 'jobId'],
  properties: {
    openingId: {
      description: 'The id of the opening',
      type: 'string',
    },
    jobId: {
      description: 'The id of the job to add',
      type: 'string',
    },
  },
} as const;

export const OpeningsRemoveJobRequestSchema = {
  type: 'object',
  required: ['openingId', 'jobId'],
  properties: {
    openingId: {
      description: 'The id of the opening',
      type: 'string',
    },
    jobId: {
      description: 'The id of the job to remove from the opening.',
      type: 'string',
    },
  },
} as const;

export const OpeningsSetStateRequestSchema = {
  type: 'object',
  properties: {
    openingId: {
      description: 'The id of the opening you want to update',
      type: 'string',
    },
    openingState: {
      description: 'The new state you want to update the opening to',
      type: 'string',
      enum: ['Draft', 'Approved', 'Open', 'Closed'],
    },
    closeReasonId: {
      description: 'The id of the close reason if you are setting the state to closed',
      type: 'string',
    },
  },
} as const;

export const OpeningsSetArchivedRequestSchema = {
  type: 'object',
  properties: {
    openingId: {
      description: 'The id of the opening you want to archive',
      type: 'string',
    },
    archive: {
      description: 'The new archived state you want to update the opening to',
      type: 'boolean',
    },
  },
} as const;

export const OpeningsUpdateOpeningRequestSchema = {
  type: 'object',
  properties: {
    description: {
      type: 'string',
    },
    openingId: {
      description: 'The openingId of the opening you want to update.',
      type: 'string',
    },
    identifier: {
      description: 'jobIds,     targetHireDate,     targetStartDate,     isBackfill,     employmentType,',
      type: 'string',
    },
    teamId: {
      description: 'The id of the department or team associated with the opening.',
      type: 'string',
    },
    targetHireDate: {
      description: 'The date (in YYYY-MM-DD format) by which you intend to hire against this opening.',
      type: 'string',
    },
    targetStartDate: {
      description:
        'The date (in YYYY-MM-DD format) by which you intend someone hired against this opening will start employment.',
      type: 'string',
    },
    isBackfill: {
      description: 'Whether this opening is intended to backfill a previous employee',
      type: 'boolean',
      default: false,
    },
    employmentType: {
      description: 'The employment type for this opening',
      type: 'string',
      default: 'FullTime',
      enum: ['FullTime', 'PartTime', 'Intern', 'Contract', 'Temporary', ''],
    },
  },
} as const;

export const ReferralCreateNewRequestSchema = {
  type: 'object',
  properties: {
    id: {
      allOf: [
        {
          description: 'The id of the referral form, from /referralForm.info',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    creditedToUserId: {
      allOf: [
        {
          description: 'The id of the user submitting the referral',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    fieldSubmissions: {
      type: 'array',
      items: {
        properties: {
          path: {
            description: `The form field's "path" value`,
            type: 'string',
          },
          value: {
            description: `This is often a primitive but for a referral job, it should be { title: job.title, value: job.id }
`,
            type: 'string',
          },
        },
        required: ['path', 'value'],
      },
    },
    createdAt: {
      allOf: [
        {
          description: `An ISO date string to set the referral's createdAt timestamp to. When this value isn't provided, the createdAt timestamp defaults to the time the referral was created.
`,
        },
        {
          type: 'string',
          example: '2022-08-12T20:29:56.964Z',
          format: 'date',
        },
      ],
    },
  },
  required: ['id', 'creditedToUserId', 'fieldSubmissions'],
} as const;

export const SourceGetAllRequestSchema = {
  type: 'object',
  properties: {
    includeArchived: {
      description: 'When true, includes archived items',
      type: 'boolean',
      default: false,
    },
  },
} as const;

export const SurveyFormDefinitionGetDetailsByIdRequestSchema = {
  type: 'object',
  properties: {
    surveyFormDefinitionId: {
      allOf: [
        {
          description: 'The id of the survey form to fetch',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['surveyFormDefinitionId'],
} as const;

export const SurveyRequestGenerateUrlRequestSchema = {
  type: 'object',
  required: ['candidateId', 'applicationId', 'surveyFormDefinitionId'],
  properties: {
    candidateId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the candidate to create a survey request for.',
        },
      ],
    },
    applicationId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id of the application to associate with the survey request.',
        },
      ],
    },
    surveyFormDefinitionId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: `The ID of the survey form that the candidate will see when they visit the URL returned in the \`surveyURL\` property of the API response. 
Survey forms IDs can be obtained using the \`surveyFormDefinition.list\` endpoint. 
`,
        },
      ],
    },
  },
} as const;

export const SurveySubmissionListBySurveyTypeRequestSchema = {
  allOf: [
    {
      description: `The type of survey submissions to fetch. 
`,
      type: 'object',
      properties: {
        surveyType: {
          type: 'string',
          enum: ['CandidateDataConsent', 'CandidateExperience', 'Diversity', 'EEOC', 'Questionnaire'],
        },
      },
      required: ['surveyType'],
    },
    {
      $ref: '#/components/schemas/CandidateListAllRequest',
    },
  ],
} as const;

export const UserGetByIdRequestSchema = {
  type: 'object',
  properties: {
    userId: {
      allOf: [
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
        {
          description: 'The id to lookup the user',
        },
      ],
    },
  },
  required: ['userId'],
} as const;

export const UserGetAshbyUsersRequestSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/CandidateListAllRequest',
    },
    {
      type: 'object',
      properties: {
        includeDeactivated: {
          description: `If set to true, deactivated users are included in the response. 
By default, deactivated users are not included.
`,
          type: 'boolean',
          default: false,
        },
      },
    },
  ],
} as const;

export const UserSearchByEmailRequestSchema = {
  type: 'object',
  properties: {
    email: {
      description: 'The email to use to search for the user',
      type: 'string',
      example: 'test@ashbyhq.com',
    },
  },
  required: ['email'],
} as const;

export const WebhookCreateSettingRequestSchema = {
  properties: {
    webhookType: {
      type: 'string',
      enum: [
        'applicationSubmit',
        'applicationUpdate',
        'candidateHire',
        'candidateStageChange',
        'candidateDelete',
        'candidateMerge',
        'interviewPlanTransition',
        'interviewScheduleCreate',
        'interviewScheduleUpdate',
        'jobPostingUpdate',
        'jobPostingPublish',
        'jobPostingUnpublish',
        'offerCreate',
        'offerUpdate',
        'offerDelete',
        'pushToHRIS',
        'surveySubmit',
      ],
    },
    requestUrl: {
      description: 'The URL the webhook will send requests to.',
      type: 'string',
    },
    secretToken: {
      description: `The secret token used to sign the webhook request. See our documentation [here](https://developers.ashbyhq.com/docs/authenticating-webhooks) for more information.
`,
      type: 'string',
    },
  },
  required: ['webhookType', 'requestUrl', 'secretToken'],
} as const;

export const WebhookUpdateSettingRequestSchema = {
  properties: {
    webhookId: {
      allOf: [
        {
          description: 'The id of the webhook setting to update.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
    enabled: {
      description: 'Whether or not the webhook is enabled.',
      type: 'boolean',
    },
    requestUrl: {
      description: 'The URL the webhook will send requests to.',
      type: 'string',
    },
    secretToken: {
      description: `The secret token used to sign the webhook request. See our documentation [here](https://developers.ashbyhq.com/docs/authenticating-webhooks) for more information.
`,
      type: 'string',
    },
  },
  required: ['webhookId'],
} as const;

export const WebhookRemoveSettingRequestSchema = {
  properties: {
    webhookId: {
      allOf: [
        {
          description: 'The id of the webhook setting to delete.',
        },
        {
          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
        },
      ],
    },
  },
  required: ['webhookId'],
} as const;

export const ApiKeyGetInfoResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                title: {
                  description: 'The name of the API key.',
                  type: 'string',
                  example: 'Custom Job Board API key',
                },
                createdAt: {
                  $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                },
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ApplicationChangeSourceResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ApplicationChangeStageResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ApplicationConsiderCandidateResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ApplicationGetDetailsResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              allOf: [
                {
                  $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application',
                },
                {
                  type: 'object',
                  properties: {
                    openings: {
                      description:
                        'The openings array will only be included if the `openings` expand parameter is included when the request is made.',
                      type: 'array',
                      items: {
                        $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
                      },
                    },
                  },
                },
                {
                  type: 'object',
                  properties: {
                    archivedAt: {
                      allOf: [
                        {
                          $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                        },
                        {
                          description: 'The timestamp an application was archived',
                        },
                      ],
                    },
                    applicationHistory: {
                      type: 'array',
                      items: {
                        type: 'object',
                        properties: {
                          title: {
                            title: 'Offer',
                            type: 'string',
                          },
                          id: {
                            $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                          },
                          stageId: {
                            $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                          },
                          enteredStageAt: {
                            $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                          },
                          leftStageAt: {
                            $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                          },
                        },
                        required: ['id', 'stageId', 'title', 'enteredStageAt'],
                      },
                    },
                    applicationFormSubmissions: {
                      description:
                        'Application form submissions. These match the response from the `applicationForm.submit` endpoint. Use of the expand parameter is required to fetch.',
                      type: 'array',
                      items: {
                        $ref: '#/components/schemas/ApplicationFormSubmitFormResponse/oneOf/0/allOf/2/properties/results/properties/submittedFormInstance',
                      },
                    },
                  },
                },
              ],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ApplicationGetAllSchedulesResponseSchema = {
  oneOf: [
    {
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                allOf: [
                  {
                    $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application',
                  },
                  {
                    $ref: '#/components/schemas/ApplicationGetDetailsResponse/oneOf/0/allOf/2/properties/results/allOf/1',
                  },
                ],
              },
            },
          },
        },
      ],
      required: ['results'],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ApplicationFeedbackListAllResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                allOf: [
                  {
                    type: 'object',
                    allOf: [
                      {
                        $ref: '#/components/schemas/ApplicationFormSubmitFormResponse/oneOf/0/allOf/2/properties/results/properties/submittedFormInstance',
                      },
                      {
                        type: 'object',
                        properties: {
                          submittedByUser: {
                            $ref: '#/components/schemas/UserGetByIdResponse/oneOf/0/allOf/1/properties/results',
                          },
                          interviewId: {
                            $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                          },
                          applicationHistoryId: {
                            $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                          },
                          submittedAt: {
                            $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                          },
                        },
                      },
                    ],
                    required: ['submittedByUser'],
                  },
                ],
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ApplicationFeedbackSubmitFeedbackResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                submittedFormInstance: {
                  $ref: '#/components/schemas/ApplicationFormSubmitFormResponse/oneOf/0/allOf/2/properties/results/properties/submittedFormInstance',
                },
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ApplicationFormSubmitFormResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                submittedFormInstance: {
                  type: 'object',
                  properties: {
                    id: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    formDefinition: {
                      $ref: '#/components/schemas/OfferStartCreationInstanceResponse/oneOf/0/allOf/1/properties/results/properties/formDefinition',
                    },
                    submittedValues: {
                      type: 'object',
                      example: {
                        _systemfield_name: 'Joe Smith',
                      },
                    },
                  },
                  required: ['id', 'formDefinition', 'submittedValues'],
                },
                formMessages: {
                  type: 'object',
                  properties: {
                    blockMessageForCandidateHtml: {
                      description:
                        'A message to display to the candidate if they been blocked from applying due to application limits',
                      type: 'string',
                      example: `<div><p>In order to give as many candidates as possible an opportunity to apply we have limiting the number of applications a single candidate may submit. Unfortunately we cannot, accept your application at this time.</p></div>
`,
                    },
                  },
                },
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ApprovalDefinitionUpdateEntityScopeResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  allOf: [
                    {
                      description: 'The id of the approval definition.',
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                entityType: {
                  type: 'string',
                  enum: ['Offer'],
                },
                entityId: {
                  allOf: [
                    {
                      description: 'The id of the approval entity (e.g. the id of the offer version).',
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                approvalStepDefinitions: {
                  $ref: '#/components/schemas/ApprovalDefinitionUpdateEntityScopeRequest/properties/approvalStepDefinitions',
                },
              },
              required: ['entityType', 'entityId', 'approvalStepDefinitions'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ArchiveReasonListResponseSchema = {
  oneOf: [
    {
      title: 'Success Response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                type: 'object',
                properties: {
                  id: {
                    $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                  },
                  text: {
                    type: 'string',
                    example: 'Too inexperienced',
                  },
                  reasonType: {
                    enum: ['RejectedByCandidate', 'RejectedByOrg', 'Other'],
                    example: 'RejectedByOrg',
                    type: 'string',
                  },
                  isArchived: {
                    $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                  },
                },
                required: ['id', 'text', 'reasonType', 'isArchived'],
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const AssessmentAddCompletedToCandidateResponseSchema = {
  oneOf: [
    {
      title: 'Success Response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'object',
              required: ['assessmentTypeId', 'assessmentId', 'assessmentName', 'candidateId', 'metadata'],
              properties: {
                applicationId: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                assessmentId: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                assessmentName: {
                  type: 'string',
                  example: 'test-assessment-name',
                },
                assessmentTypeId: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                candidateId: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                metadata: {
                  type: 'array',
                  items: {
                    $ref: '#/components/schemas/AssessmentUpdateStatusRequest/properties/metadata/items',
                  },
                },
                result: {
                  $ref: '#/components/schemas/AssessmentUpdateStatusRequest/properties/metadata/items',
                },
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const AssessmentPartnerStartResponseSchema = {
  oneOf: [
    {
      title: 'Success Response',
      type: 'object',
    },
    {
      type: 'object',
      required: ['success', 'results'],
      properties: {
        success: {
          type: 'boolean',
        },
        results: {
          required: ['assessment_id', '_comment', 'update_request', 'metadata'],
          properties: {
            assessment_id: {
              type: 'string',
            },
            _comment: {
              type: 'string',
            },
            update_request: {
              required: ['timestamp', 'assessment_id', 'assessment_profile_url', 'assessment_status'],
              properties: {
                timestamp: {
                  type: 'number',
                },
                assessment_id: {
                  type: 'string',
                },
                assessment_profile_url: {
                  required: ['identifier', 'type', 'label', 'value'],
                  properties: {
                    identifier: {
                      type: 'string',
                    },
                    type: {
                      type: 'string',
                    },
                    label: {
                      type: 'string',
                    },
                    value: {
                      type: 'string',
                    },
                  },
                  type: 'object',
                },
                assessment_status: {
                  required: ['identifier', 'type', 'label', 'value'],
                  properties: {
                    identifier: {
                      type: 'string',
                    },
                    type: {
                      type: 'string',
                    },
                    label: {
                      type: 'string',
                    },
                    value: {
                      type: 'string',
                    },
                  },
                  type: 'object',
                },
              },
              type: 'object',
            },
            metadata: {
              type: 'array',
              items: {
                type: 'object',
                properties: {
                  identifier: {
                    type: 'string',
                  },
                  type: {
                    type: 'string',
                  },
                  label: {
                    type: 'string',
                  },
                  value: {
                    type: 'string',
                  },
                },
              },
            },
          },
        },
      },
    },
  ],
} as const;

export const AssessmentPartnerStart409ResponseSchema = {
  oneOf: [
    {
      title: 'Error Response',
      type: 'object',
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const AssessmentListPartnerSupportResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                allOf: [
                  {
                    description: 'List of available assessments',
                    type: 'object',
                    properties: {
                      description: {
                        type: 'string',
                      },
                      assessment_type_id: {
                        allOf: [
                          {
                            $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                          },
                        ],
                      },
                      name: {
                        type: 'string',
                      },
                    },
                  },
                ],
              },
            },
          },
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const AssessmentUpdateStatusResponseSchema = {
  oneOf: [
    {
      title: 'Success Response',
      type: 'object',
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const AssessmentCancelPartnerAssessmentResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                properties: {
                  assessment_id: {
                    allOf: [
                      {
                        description: 'The id of the started assessment to cancel',
                      },
                      {
                        $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                      },
                    ],
                  },
                },
              },
            },
          },
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateAddTagResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/CandidateGetByIdResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateAnonymizeCandidateResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          description: 'The anonymized candidate',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/CandidateGetByIdResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateCreateNewCandidateResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/CandidateGetByIdResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateCreateNoteResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                createdAt: {
                  $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                },
                content: {
                  type: 'string',
                  example:
                    'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.',
                },
                author: {
                  type: 'object',
                  properties: {
                    id: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    firstName: {
                      type: 'string',
                      example: 'Joey',
                    },
                    lastName: {
                      type: 'string',
                      example: 'Joe',
                    },
                    email: {
                      $ref: '#/components/schemas/CandidateCreateNewCandidateRequest/properties/email/allOf/0',
                    },
                  },
                  required: ['id', 'firstName', 'lastName'],
                },
              },
              required: ['id', 'createdAt', 'author'],
            },
          },
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateGetByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                tags: {
                  type: 'array',
                  items: {
                    $ref: '#/components/schemas/CandidateTagCreateNewTagResponse/oneOf/0/allOf/2/properties/results',
                  },
                },
                id: {
                  description: 'The unique id of the candidate',
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                createdAt: {
                  $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                },
                name: {
                  description: "The candidate's name",
                  type: 'string',
                  example: 'Adam Hart',
                },
                primaryEmailAddress: {
                  $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application/properties/candidate/properties/primaryEmailAddress',
                },
                emailAddresses: {
                  type: 'array',
                  items: {
                    $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application/properties/candidate/properties/primaryEmailAddress',
                  },
                },
                primaryPhoneNumber: {
                  $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application/properties/candidate/properties/primaryEmailAddress',
                },
                phoneNumbers: {
                  type: 'array',
                  items: {
                    $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application/properties/candidate/properties/primaryEmailAddress',
                  },
                },
                socialLinks: {
                  type: 'array',
                  items: {
                    $ref: '#/components/schemas/CandidateUpdateExistingCandidateRequest/properties/socialLinks/items',
                  },
                },
                position: {
                  type: 'string',
                  example: 'Software Engineer',
                },
                company: {
                  type: 'string',
                  example: 'Auction.com',
                },
                school: {
                  type: 'string',
                  example: 'Princeton University',
                },
                applicationIds: {
                  description: 'The unique ids of all applications associated with the candidate',
                  type: 'array',
                  items: {
                    $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                  },
                },
                resumeFileHandle: {
                  description: "The id, name and handle for the candidate's resume",
                  $ref: '#/components/schemas/CandidateGetByIdResponse/oneOf/0/allOf/2/properties/results/properties/fileHandles/items',
                },
                fileHandles: {
                  description: 'The id, name and handle for each file associated with the candidate',
                  type: 'array',
                  items: {
                    type: 'object',
                    properties: {
                      id: {
                        type: 'string',
                      },
                      name: {
                        type: 'string',
                      },
                      handle: {
                        description:
                          "You can use the file handle to retrieve the file's URL by using the file.info endpoint.",
                        type: 'string',
                      },
                    },
                    required: ['id', 'name', 'handle'],
                    example: {
                      id: '15d2624d-0a81-4f94-a2ed-94980f430b3f',
                      name: 'resume.pdf',
                      handle: 'eyJoYW5kbGUiOnsidHlwZSI6IkNhbmRpZGF0ZUZpbGUiLCJm',
                    },
                  },
                },
                customFields: {
                  description: 'All custom field values associated with the candidate',
                  type: 'array',
                  items: {
                    $ref: '#/components/schemas/CustomFieldSetValueResponse/oneOf/0/allOf/2/properties/results',
                  },
                },
                profileUrl: {
                  description: "The url of the candidate's profile in Ashby",
                  type: 'string',
                },
                source: {
                  description: 'The source that created this candidate',
                  $ref: '#/components/schemas/SourceGetAllResponse/oneOf/0/allOf/2/properties/results/items',
                },
                creditedToUser: {
                  description: 'The user who receives credit for this user',
                  $ref: '#/components/schemas/UserGetByIdResponse/oneOf/0/allOf/1/properties/results',
                },
                timezone: {
                  description: 'The timezone of the candidate',
                  type: 'string',
                },
              },
              required: [
                'id',
                'name',
                'emailAddresses',
                'phoneNumbers',
                'socialLinks',
                'tags',
                'applicationIds',
                'fileHandles',
                'profileUrl',
              ],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateListAllResponseSchema = {
  oneOf: [
    {
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/CandidateGetByIdResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
      ],
      required: ['results'],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateGetAllNotesResponseSchema = {
  oneOf: [
    {
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/CandidateCreateNoteResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
      ],
      required: ['results'],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateSearchByEmailAndNameResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/CandidateGetByIdResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateUpdateExistingCandidateResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/CandidateGetByIdResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateAttachFileResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/CandidateGetByIdResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateUploadResumeDataResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/CandidateGetByIdResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateTagCreateNewTagResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              description: 'A tag applied to a candidate',
              type: 'object',
              properties: {
                title: {
                  type: 'string',
                  example: 'Senior Candidate',
                },
                id: {
                  description: "The tag's unique id",
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                isArchived: {
                  $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                },
              },
              required: ['id', 'title', 'isArchived'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CandidateTagListAllResponseSchema = {
  oneOf: [
    {
      title: 'Success Response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/CandidateTagCreateNewTagResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CustomFieldCreateNewFieldResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                title: {
                  type: 'string',
                  example: 'Preferred Teams',
                },
                id: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                objectType: {
                  description: 'The type of object in Ashby the custom field is associated with',
                  type: 'string',
                  enum: ['Application', 'Offer', 'Candidate', 'Job'],
                },
                isArchived: {
                  $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                },
                fieldType: {
                  description: 'The type of data stored in the custom field',
                  type: 'string',
                  enum: [
                    'MultiValueSelect',
                    'NumberRange',
                    'String',
                    'Date',
                    'ValueSelect',
                    'Number',
                    'Currency',
                    'Boolean',
                  ],
                },
                selectableValues: {
                  description: `An array of values that can be selected for custom fields with a fieldType of MultiValueSelect.
If the fieldType is not MultiValueSelect, \`selectableValues\` will not be present in the response
`,
                  type: 'array',
                  items: {
                    type: 'object',
                    properties: {
                      label: {
                        type: 'string',
                        example: 'Backend Engineering',
                      },
                      value: {
                        type: 'string',
                        example: 'Backend Engineering',
                      },
                      isArchived: {
                        $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                      },
                    },
                  },
                },
              },
              required: ['id', 'title', 'objectType', 'isArchived', 'fieldType'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CustomFieldGetAllResponseSchema = {
  oneOf: [
    {
      title: 'Success Response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/CustomFieldCreateNewFieldResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const CustomFieldSetValueResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                title: {
                  type: 'string',
                },
                id: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                value: {
                  oneOf: [
                    {
                      title: 'Boolean',
                      type: 'boolean',
                    },
                    {
                      title: 'Currency',
                      type: 'object',
                      properties: {
                        value: {
                          type: 'number',
                          example: 1000000,
                          format: 'currency',
                        },
                        currencyCode: {
                          type: 'string',
                          example: 'USD',
                        },
                      },
                    },
                    {
                      title: 'Date',
                      type: 'string',
                      format: 'date-time',
                    },
                    {
                      title: 'String',
                      type: 'string',
                    },
                    {
                      title: 'MultiValueSelect',
                      type: 'array',
                      items: {
                        type: 'string',
                      },
                    },
                    {
                      title: 'Number',
                      type: 'number',
                    },
                    {
                      title: 'NumberRange',
                      type: 'object',
                      properties: {
                        type: {
                          type: 'string',
                          example: 'number-range',
                        },
                        minValue: {
                          type: 'number',
                          example: 10000,
                        },
                        maxValue: {
                          type: 'number',
                          example: 100000,
                        },
                      },
                    },
                    {
                      title: 'ValueSelect',
                      type: 'string',
                    },
                  ],
                },
              },
              required: ['id', 'title', 'value'],
              example: {
                title: 'Expected start date',
                id: '650e5f74-32db-4a0a-b61b-b9afece05023',
                value: '2022-11-10T19:47:56.795Z',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const DepartmentTeamCreateNewDepartmentResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/DepartmentGetByIdResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const DepartmentGetByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                name: {
                  type: 'string',
                  example: 'Engineering',
                },
                isArchived: {
                  $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                },
                parentId: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
              },
              required: ['id', 'name', 'isArchived'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const DepartmentGetAllDepartmentsResponseSchema = {
  oneOf: [
    {
      title: 'Success Response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/DepartmentGetByIdResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const FileGetUrlCandidateResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                url: {
                  description: 'The url of the file',
                  type: 'string',
                  example: 'https://s3.amazonaws.com/...',
                },
              },
              required: ['url'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const FeedbackFormDefinitionGetByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success Response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              allOf: [
                {
                  $ref: '#/components/schemas/ReferralFormGetDefaultFormResponse/oneOf/0/allOf/1/properties/results/allOf/0',
                },
                {
                  type: 'object',
                  properties: {
                    organizationId: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    isDefaultForm: {
                      type: 'boolean',
                      example: true,
                    },
                    interviewId: {
                      allOf: [
                        {
                          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                        },
                        {
                          description: 'The id of the interview associated with the feedback form.',
                        },
                      ],
                    },
                  },
                },
              ],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const FeedbackFormDefinitionListAllResponseSchema = {
  oneOf: [
    {
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/FeedbackFormDefinitionGetByIdResponse/oneOf/0/allOf/1/properties/results',
              },
            },
          },
        },
      ],
      required: ['results'],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const HiringTeamAddMemberResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                email: {
                  $ref: '#/components/schemas/CandidateCreateNewCandidateRequest/properties/email/allOf/0',
                },
                firstName: {
                  type: 'string',
                  example: 'Joey',
                },
                lastName: {
                  type: 'string',
                  example: 'Joe',
                },
                role: {
                  type: 'string',
                  example: 'Hiring Manager',
                },
                userId: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
              },
              required: ['userId', 'firstName', 'lastName', 'email', 'role'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const HiringTeamRoleListRolesResponseSchema = {
  oneOf: [
    {
      title: 'namesOnly: true',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                type: 'string',
              },
              example: ['Recruiter'],
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      title: 'namesOnly: false',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                type: 'object',
                properties: {
                  title: {
                    type: 'string',
                    example: 'Recruiter',
                  },
                  id: {
                    $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                  },
                },
              },
            },
          },
        },
      ],
    },
  ],
} as const;

export const InterviewGetByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                title: {
                  description: "The interview's title",
                  type: 'string',
                  example: 'Technical Phone Interview',
                },
                id: {
                  allOf: [
                    {
                      description: "The interview's id",
                    },
                    {
                      example: '3ae2b801-19f6-41ef-ad28-214bd731948f',
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                isArchived: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                    },
                    {
                      description: 'Whether or not the interview is archived',
                    },
                  ],
                },
                instructionsHtml: {
                  description: "An HTML version of the interview's description",
                  type: 'string',
                  example: `<p>The technical phone interview consists of a 60-minute series of techincal questions</p>
`,
                },
                instructionsPlain: {
                  description: "A plaintext version of the interview's description",
                  type: 'string',
                  example: 'The technical phone interview consists of a 60-minute series of techincal questions',
                },
                jobId: {
                  allOf: [
                    {
                      description: `The id of the job the interview is associated with. If null, the interview is not associated with a specific job
and is a shared interview. Interviews that are associated with particular jobs can only be scheduled for applications
to those jobs.
`,
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                feedbackFormDefinitionId: {
                  allOf: [
                    {
                      description: `The id of the feedback form definition associated with the interview. 
`,
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
              },
              required: ['id', 'title', 'isArchived', 'feedbackFormDefinitionId'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const InterviewGetAllResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/InterviewGetByIdResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const InterviewEventListAssociatedEventsResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                type: 'object',
                properties: {
                  id: {
                    allOf: [
                      {
                        $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                      },
                      {
                        description: "The interview event's id",
                      },
                      {
                        example: '3ae2b801-19f6-41ef-ad28-214bd731948f',
                      },
                    ],
                  },
                  interviewId: {
                    allOf: [
                      {
                        $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                      },
                      {
                        description: "The interview's id",
                      },
                      {
                        example: 'ff6c7d9d-71e3-4c9c-88b1-28824980c276',
                      },
                    ],
                  },
                  interviewScheduleId: {
                    allOf: [
                      {
                        $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                      },
                      {
                        description: "The interview schedule's id",
                      },
                      {
                        example: '9d34f544-c150-4d70-91c4-e8b0b4a72846',
                      },
                    ],
                  },
                  interviewerUserIds: {
                    type: 'array',
                    items: {
                      allOf: [
                        {
                          $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                        },
                        {
                          description: 'An array of the ids of all interviewers',
                        },
                        {
                          example: 'caea4d97-331d-46b1-a8e3-6b821c2214ef',
                        },
                      ],
                    },
                  },
                  createdAt: {
                    allOf: [
                      {
                        description: 'The time the interview event was created',
                      },
                      {
                        $ref: '#/components/schemas/InterviewEventListAssociatedEventsResponse/oneOf/0/allOf/2/properties/results/items/properties/endTime/allOf/1',
                      },
                    ],
                    type: 'string',
                  },
                  startTime: {
                    allOf: [
                      {
                        description: 'The time the interview event is scheduled to start',
                      },
                      {
                        $ref: '#/components/schemas/InterviewEventListAssociatedEventsResponse/oneOf/0/allOf/2/properties/results/items/properties/endTime/allOf/1',
                      },
                    ],
                    type: 'string',
                  },
                  endTime: {
                    allOf: [
                      {
                        description: 'The time the interview event is scheduled to end',
                      },
                      {
                        type: 'string',
                        format: 'date-time',
                        example: '2022-07-21T17:32:28Z',
                      },
                    ],
                    type: 'string',
                  },
                  feedbackLink: {
                    description: 'The link to submit feedback for the interview event',
                    type: 'string',
                    format: 'uri',
                    example:
                      'https://app.ashbyhq.com/interview-briefings/4736b6d2-5c97-43a6-a7c6-0228bf079411/feedback',
                  },
                  location: {
                    description: 'The location of the interview',
                    type: 'string',
                    example: 'Google Meet',
                  },
                  meetingLink: {
                    description: 'A link to the virtual meeting (if the interview is being hosted virtually)',
                    type: 'string',
                    format: 'uri',
                  },
                },
                required: [
                  'id',
                  'interviewId',
                  'interviewScheduleId',
                  'interviewerUserIds',
                  'createdAt',
                  'startTime',
                  'endTime',
                  'feedbackLink',
                ],
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const InterviewPlanGetAllResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            moreDataAvailable: {
              $ref: '#/components/schemas/SourceGetAllResponse/oneOf/0/allOf/2/properties/moreDataAvailable',
            },
            results: {
              type: 'array',
              items: {
                type: 'object',
                properties: {
                  title: {
                    type: 'string',
                    example: 'Engineering Interview Plan',
                  },
                  id: {
                    $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                  },
                  isArchived: {
                    type: 'boolean',
                    example: false,
                  },
                },
                required: ['id', 'title', 'isArchived'],
              },
            },
          },
        },
        {
          required: ['results', 'moreDataAvailable'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const InterviewScheduleCancelByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/interviewScheduleCreate/post/requestBody/content/application~1json/schema/properties/data/properties/interviewSchedule',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const InterviewScheduleCreateScheduledInterviewResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/interviewScheduleCreate/post/requestBody/content/application~1json/schema/properties/data/properties/interviewSchedule',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const InterviewScheduleGetAllSchedulesResponseSchema = {
  oneOf: [
    {
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/webhooks/interviewScheduleCreate/post/requestBody/content/application~1json/schema/properties/data/properties/interviewSchedule',
              },
            },
          },
        },
      ],
      required: ['results'],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const InterviewScheduleUpdateEventResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/interviewScheduleCreate/post/requestBody/content/application~1json/schema/properties/data/properties/interviewSchedule',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const InterviewStageListAllInOrderResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/InterviewStageGetByIdResponse/oneOf/0/allOf/2/properties/results',
              },
            },
            moreDataAvailable: {
              $ref: '#/components/schemas/SourceGetAllResponse/oneOf/0/allOf/2/properties/moreDataAvailable',
            },
          },
        },
        {
          required: ['results', 'moreDataAvailable'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const InterviewStageGetByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              allOf: [
                {
                  type: 'object',
                  properties: {
                    title: {
                      type: 'string',
                      example: 'Offer',
                    },
                    id: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    type: {
                      type: 'string',
                      example: 'Offer',
                    },
                    orderInInterviewPlan: {
                      type: 'integer',
                      example: 1006,
                      default: 0,
                    },
                  },
                  required: ['id', 'title', 'type', 'orderInInterviewPlan'],
                },
                {
                  type: 'object',
                  properties: {
                    interviewPlanId: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  },
                  required: ['interviewPlanId'],
                },
              ],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const JobNewCreateResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/jobCreate/post/requestBody/content/application~1json/schema/properties/data/properties/job',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const JobGetByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          type: 'object',
          required: ['success'],
          properties: {
            success: {
              description: 'Whether the response is considered successful.',
              type: 'boolean',
            },
          },
        },
        {
          type: 'object',
          properties: {
            results: {
              allOf: [
                {
                  $ref: '#/webhooks/jobCreate/post/requestBody/content/application~1json/schema/properties/data/properties/job',
                },
                {
                  type: 'object',
                  properties: {
                    location: {
                      allOf: [
                        {
                          $ref: '#/components/schemas/LocationDetailsByIdResponse/oneOf/0/allOf/2/properties/results',
                        },
                        {
                          description:
                            'The location will only be included if the `location` expand parameter is included when the request is made.',
                        },
                      ],
                    },
                    openings: {
                      description:
                        'The openings array will only be included if the `openings` expand parameter is included when the request is made.',
                      type: 'array',
                      items: {
                        $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
                      },
                    },
                  },
                },
              ],
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          title: 'Error response',
        },
        {
          type: 'object',
          required: ['errors'],
          properties: {
            errors: {
              description: 'A list of error message strings.',
              type: 'array',
              items: {
                type: 'string',
              },
            },
          },
        },
      ],
      example: {
        success: false,
        errors: ['invalid_input'],
      },
    },
  ],
} as const;

export const JobGetListResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          allOf: [
            {
              $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
            },
            {
              title: 'Success response',
            },
            {
              type: 'object',
              properties: {
                moreDataAvailable: {
                  description: 'Whether the cursor can be used to fetch a subsequent page of data.',
                  type: 'boolean',
                },
                nextCursor: {
                  $ref: '#/components/schemas/CandidateListAllRequest/properties/cursor',
                },
                syncToken: {
                  $ref: '#/components/schemas/CandidateListAllRequest/properties/syncToken',
                },
              },
            },
          ],
        },
        {
          type: 'object',
          properties: {
            results: {
              type: 'array',
              items: {
                allOf: [
                  {
                    $ref: '#/webhooks/jobCreate/post/requestBody/content/application~1json/schema/properties/data/properties/job',
                  },
                  {
                    $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/1/properties/results/allOf/1',
                  },
                ],
              },
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const JobSetStatusByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/jobCreate/post/requestBody/content/application~1json/schema/properties/data/properties/job',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const JobUpdateExistingResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/jobCreate/post/requestBody/content/application~1json/schema/properties/data/properties/job',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const JobSearchByTitleResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/webhooks/jobCreate/post/requestBody/content/application~1json/schema/properties/data/properties/job',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const JobInterviewPlanGetInfoResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              description: 'A plan for conducting job interviews.',
              type: 'object',
              properties: {
                jobId: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                interviewPlanId: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                stages: {
                  type: 'array',
                  items: {
                    allOf: [
                      {
                        $ref: '#/components/schemas/InterviewStageGetByIdResponse/oneOf/0/allOf/2/properties/results/allOf/0',
                      },
                      {
                        type: 'object',
                        properties: {
                          activities: {
                            type: 'array',
                            items: {
                              type: 'object',
                              properties: {
                                title: {
                                  type: 'string',
                                  example: 'Onsite Schedule',
                                },
                                id: {
                                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                                },
                                interviews: {
                                  type: 'array',
                                  items: {
                                    type: 'object',
                                    properties: {
                                      title: {
                                        type: 'string',
                                        example: 'System Architecture',
                                      },
                                      id: {
                                        allOf: [
                                          {
                                            $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                                          },
                                        ],
                                      },
                                      interviewId: {
                                        allOf: [
                                          {
                                            description: 'The id of the interview to be scheduled',
                                          },
                                          {
                                            $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                                          },
                                        ],
                                      },
                                      interviewDurationMinutes: {
                                        type: 'number',
                                        example: 30,
                                      },
                                      isSchedulable: {
                                        type: 'boolean',
                                        example: true,
                                      },
                                    },
                                  },
                                },
                              },
                              required: ['id', 'interviews'],
                            },
                          },
                        },
                        required: ['activities'],
                      },
                    ],
                  },
                },
              },
              required: ['jobId', 'interviewPlanId', 'stages'],
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const JobPostingGetIndividualResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              properties: {
                title: {
                  description: "The job posting's title",
                  type: 'string',
                  example: 'Posting Title',
                },
                id: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    {
                      description: "The job posting's id",
                    },
                  ],
                },
                descriptionPlain: {
                  description: "A plaintext version of the job posting's description",
                  type: 'string',
                  example: `This example role will be part of an example team and will report to the example manager. The new hire plays a critical role in various example workflows.



REQUIREMENTS

 - Experience writing good example job descriptions

 - Other exemplary skills

 - 3-5 years prior experience in this role

 - Motivation

 - Great english language skills
   


ABOUT THE TEAM


Example org is a leading software company. Example org allows real-time collaboration on important example workflows. Founded in 2012 we have over 10,000 customers worldwide and are backed by fantastic investors such as Sequoia Capital.

`,
                },
                descriptionHtml: {
                  description: "An HTML version of the job posting's description",
                  type: 'string',
                  example:
                    '<p style="min-height:1.5em">This example role will be part of an example team and will report to the example manager. The new hire plays a critical role in various example workflows.</p><h1><br />Requirements</h1><ul style="min-height:1.5em"><li><p style="min-height:1.5em">Experience writing good example job descriptions</p></li><li><p style="min-height:1.5em">Other exemplary skills</p></li><li><p style="min-height:1.5em">3-5 years prior experience in this role</p></li><li><p style="min-height:1.5em">Motivation</p></li><li><p style="min-height:1.5em">Great english language skills<br /></p></li></ul><h1>About the Team</h1><p style="min-height:1.5em"><br />Example org is a leading software company. Example org allows real-time collaboration on important example workflows. Founded in 2012 we have over 10,000 customers worldwide and are backed by fantastic investors such as Sequoia Capital.</p><p style="min-height:1.5em"></p>',
                },
                descriptionSocial: {
                  description:
                    'A shortened job posting description displayed when shared on social media, limited to 200 characters.',
                  type: 'string',
                  example:
                    'Example org allows real-time collaboration on important example workflows. When you join as an example role, part of the example team, you will perform a critical role in various example workflows.',
                },
                descriptionParts: {
                  description:
                    "The above description broken down into the actual description on the job, and the Job Post Description Opening and Closing that is set by the admin in Ashby's Job Boards → Theme → Messaging settings.",
                  type: 'object',
                  properties: {
                    descriptionOpening: {
                      allOf: [
                        {
                          $ref: '#/components/schemas/JobPostingGetIndividualResponse/oneOf/0/allOf/2/properties/results/properties/descriptionParts/properties/descriptionBody/allOf/0',
                        },
                        {
                          description: 'The content set in the Job Post Description Opening theme settings',
                        },
                        {
                          properties: {
                            html: {
                              description: 'An HTML version of the Job Post Description Opening theme settings',
                              example: null,
                            },
                            plain: {
                              description: 'A plaintext version of the Job Post Description Opening theme settings',
                              example: null,
                            },
                          },
                        },
                      ],
                    },
                    descriptionBody: {
                      allOf: [
                        {
                          type: 'object',
                          properties: {
                            html: {
                              type: 'string',
                            },
                            plain: {
                              type: 'string',
                            },
                          },
                          required: ['html', 'plain'],
                        },
                        {
                          description: 'The description set on the job posting',
                        },
                        {
                          properties: {
                            html: {
                              description: 'An HTML version of the description set on the job posting',
                              example:
                                '<p style="min-height:1.5em">This example role will be part of an example team and will report to the example manager. The new hire plays a critical role in various example workflows.</p><h1><br />Requirements</h1><ul style="min-height:1.5em"><li><p style="min-height:1.5em">Experience writing good example job descriptions</p></li><li><p style="min-height:1.5em">Other exemplary skills</p></li><li><p style="min-height:1.5em">3-5 years prior experience in this role</p></li><li><p style="min-height:1.5em">Motivation</p></li><li><p style="min-height:1.5em">Great english language skills<br /></p></li></ul></p>',
                            },
                            plain: {
                              description: 'An plaintext version of the description set on the job posting',
                              example:
                                'This example role will be part of an example team and will report to the example manager. The new hire plays a critical role in various example workflows.\\n\\n\\n\\nREQUIREMENTS\\n\\n - Experience writing good example job descriptions\\n\\n - Other exemplary skills\\n\\n - 3-5 years prior experience in this role\\n\\n - Motivation\\n\\n - Great english language skills\\n',
                            },
                          },
                        },
                      ],
                    },
                    descriptionClosing: {
                      allOf: [
                        {
                          $ref: '#/components/schemas/JobPostingGetIndividualResponse/oneOf/0/allOf/2/properties/results/properties/descriptionParts/properties/descriptionBody/allOf/0',
                        },
                        {
                          description: 'The content set in the Job Post Description Closing theme settings',
                        },
                        {
                          properties: {
                            html: {
                              description: 'An HTML version of the Job Post Description Closing theme settings',
                              example:
                                '<h1>About the Team</h1><p style="min-height:1.5em"><br />Example org is a leading software company. Example org allows real-time collaboration on important example workflows. Founded in 2012 we have over 10,000 customers worldwide and are backed by fantastic investors such as Sequoia Capital.</p>',
                            },
                            plain: {
                              description: 'A plaintext version of the Job Post Description Closing theme settings',
                              example:
                                'ABOUT THE TEAM\\n\\n\\nExample org is a leading software company. Example org allows real-time collaboration on important example workflows. Founded in 2012 we have over 10,000 customers worldwide and are backed by fantastic investors such as Sequoia Capital.\\n\\n',
                            },
                          },
                        },
                      ],
                    },
                  },
                  required: ['description'],
                },
                departmentName: {
                  description: 'The name of the department associated with the job posting',
                  type: 'string',
                  example: 'Test Team',
                },
                teamName: {
                  description: 'The name of the team associated with the job posting',
                  type: 'string',
                  example: 'Test Team',
                },
                jobId: {
                  allOf: [
                    {
                      description: 'The id of the job associated with the job posting',
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                locationName: {
                  description: 'The name of the primary location associated with the job posting',
                  type: 'string',
                  example: 'Springfield',
                },
                locationIds: {
                  $ref: '#/webhooks/jobPostingUpdate/post/requestBody/content/application~1json/schema/properties/data/properties/jobPosting/properties/locationIds',
                },
                linkedData: {
                  description:
                    'An object that can be used to populate "rich results" in search engines. (https://developers.google.com/search/docs/data-types/job-posting)',
                  type: 'object',
                  properties: {
                    title: {
                      type: 'string',
                      example: 'Posting Title',
                    },
                    description: {
                      type: 'string',
                      example:
                        '<p style="min-height:1.5em">This example role will be part of an example team and will report to the example manager. The new hire plays a critical role in various example workflows.</p><h1><br />Requirements</h1><ul style="min-height:1.5em"><li><p style="min-height:1.5em">Experience writing good example job descriptions</p></li><li><p style="min-height:1.5em">Other exemplary skills</p></li><li><p style="min-height:1.5em">3-5 years prior experience in this role</p></li><li><p style="min-height:1.5em">Motivation</p></li><li><p style="min-height:1.5em">Great english language skills<br /></p></li></ul><h1>About the Team</h1><p style="min-height:1.5em"><br />Example org is a leading software company. Example org allows real-time collaboration on important example workflows. Founded in 2012 we have over 10,000 customers worldwide and are backed by fantastic investors such as Sequoia Capital.</p><p style="min-height:1.5em"></p>',
                    },
                    '@context': {
                      type: 'string',
                      example: 'https://schema.org/',
                    },
                    '@type': {
                      type: 'string',
                      example: 'JobPosting',
                    },
                    identifier: {
                      type: 'object',
                      properties: {
                        '@type': {
                          type: 'string',
                          example: 'PropertyValue',
                        },
                        name: {
                          type: 'string',
                          example: 'Posting Title',
                        },
                        value: {
                          type: 'string',
                          example: '4be0e8c0-9323-43a0-ab48-506789ab9c16',
                        },
                      },
                    },
                    datePosted: {
                      type: 'string',
                      example: '2022-07-22',
                    },
                    hiringOrganization: {
                      type: 'object',
                      properties: {
                        '@type': {
                          type: 'string',
                          example: 'Organization',
                        },
                        name: {
                          type: 'string',
                          example: 'Example org',
                        },
                        sameAs: {
                          type: 'string',
                          example: '34d7c77d-e9b2-5a09-a882-cb23a225f2ec.com',
                        },
                      },
                    },
                    jobLocation: {
                      type: 'object',
                      properties: {
                        '@type': {
                          type: 'string',
                          example: 'Place',
                        },
                        address: {
                          type: 'object',
                          properties: {
                            '@type': {
                              type: 'string',
                              example: 'PostalAddress',
                            },
                          },
                        },
                      },
                    },
                    employmentType: {
                      type: 'string',
                      example: 'FULL_TIME',
                    },
                  },
                },
                publishedDate: {
                  description: 'The date the job posting was published',
                  type: 'string',
                  example: '2022-07-22',
                },
                applicationDeadline: {
                  description: 'The date and time when applications will no longer be accepted',
                  type: 'string',
                  example: '2024-08-12T20:00:00.000Z',
                  format: 'date',
                },
                address: {
                  allOf: [
                    {
                      description: 'The address of the job posting',
                    },
                    {
                      $ref: '#/components/schemas/LocationDetailsByIdResponse/oneOf/0/allOf/2/properties/results/properties/address',
                    },
                  ],
                },
                isRemote: {
                  type: 'boolean',
                },
                employmentType: {
                  $ref: '#/webhooks/jobPostingUpdate/post/requestBody/content/application~1json/schema/properties/data/properties/jobPosting/properties/employmentType',
                },
                applicationFormDefinition: {
                  allOf: [
                    {
                      $ref: '#/components/schemas/OfferStartCreationInstanceResponse/oneOf/0/allOf/1/properties/results/properties/formDefinition',
                    },
                    {
                      description:
                        'See the guide on Creating a custom careers page (https://developers.ashbyhq.com/docs/creating-a-custom-careers-page)',
                    },
                  ],
                },
                isListed: {
                  description: 'Whether or not the job posting is listed',
                  type: 'boolean',
                  example: true,
                },
                externalLink: {
                  description: 'The external link to the job posting',
                  type: 'string',
                  example:
                    'https://jobs.ashbyhq.com/70b51cc4-7f34-5567-92bd-96f354f7439a/4be0e8c0-9323-43a0-ab48-506789ab9c16',
                },
                compensation: {
                  description: 'Compensation ranges associated with the job posting and related settings',
                  type: 'object',
                  required: ['compensationTiers', 'shouldDisplayCompensationOnJobBoard'],
                  properties: {
                    compensationTierSummary: {
                      description: `A summary of *all* the job posting's valid \`compensationTiers\` in the same format shown on
Ashby-hosted Job Boards
`,
                      type: 'string',
                      example: '$72K – $270K • 1% – 2.25% • Offers Bonus • Multiple Ranges',
                    },
                    summaryComponents: {
                      description: `The maximum and minimum compensation ranges across *all* the posting's \`compensationTiers\`
that make up \`compensationTierSummary\`
`,
                      type: 'array',
                      items: {
                        description: `A part of a compensation tier that represents one specific type of compensation, e.g. the "Salary"
or the "Bonus."
`,
                        type: 'object',
                        properties: {
                          summary: {
                            description:
                              'The summary of this component in the same format shown on Ashby-hosted Job Boards',
                            type: 'string',
                            example: '€72K – €100K',
                          },
                          compensationType: {
                            description: `The type of compensation this component represents
`,
                            type: 'string',
                            enum: ['Salary', 'EquityPercentage', 'EquityCashValue', 'Commission', 'Bonus'],
                            example: 'Salary',
                          },
                          interval: {
                            description: 'The frequency at which this compensation is given',
                            type: 'string',
                            enum: [
                              'NONE',
                              '1 TIME',
                              '1 HOUR',
                              '1 DAY',
                              '1 WEEK',
                              '2 WEEK',
                              '1 MONTH',
                              '1 YEAR',
                              '6 MONTH',
                              '0.5 MONTH',
                              '3 MONTH',
                            ],
                            example: '1 YEAR',
                          },
                          currencyCode: {
                            description: `For non \`EquityPercentage\` components, the [ISO 4217](https://en.wikipedia.org/wiki/ISO_4217)
currency code of the compensation range
`,
                            type: 'string',
                            example: 'EUR',
                          },
                          label: {
                            description: 'An optional label that describes this compensation range to applicants',
                            type: 'string',
                            example: 'Estimated Salary',
                          },
                          minValue: {
                            description: 'The lower end of the compensation range',
                            type: 'number',
                            example: 72000.1,
                          },
                          maxValue: {
                            description: 'The higher end of the compensation range',
                            type: 'number',
                            example: 100000,
                          },
                        },
                        required: ['compensationType', 'interval', 'summary'],
                      },
                      example: [
                        {
                          summary: '€72K – €270K',
                          componentType: 'Salary',
                          interval: '1 YEAR',
                          currencyCode: 'EUR',
                          minValue: 72023.45,
                          maxValue: 270450,
                        },
                        {
                          summary: '1% – 2.25%',
                          componentType: 'EquityPercentage',
                          interval: 'NONE',
                          minValue: 1,
                          maxValue: 2.25,
                        },
                        {
                          summary: 'Offers Bonus',
                          componentType: 'Bonus',
                          interval: '1 YEAR',
                          minValue: null,
                          maxValue: null,
                        },
                      ],
                    },
                    compensationTiers: {
                      description: 'The compensation ranges that can be offered to applicants for this posting',
                      type: 'array',
                      items: {
                        description: 'A compensation range that can be offered to candidates',
                        type: 'object',
                        properties: {
                          components: {
                            description: 'The individual components that make up this compensation range',
                            type: 'array',
                            items: {
                              description: `A part of a compensation tier that represents one specific type of compensation, e.g. the "Salary"
or the "Bonus."
`,
                              type: 'object',
                              properties: {
                                id: {
                                  allOf: [
                                    {
                                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                                    },
                                    {
                                      description: "The component's unique id",
                                    },
                                  ],
                                },
                              },
                              allOf: [
                                {
                                  $ref: '#/components/schemas/JobPostingGetIndividualResponse/oneOf/0/allOf/2/properties/results/properties/compensation/properties/summaryComponents/items',
                                },
                              ],
                              required: ['id'],
                            },
                            example: [
                              {
                                summary: '€72K – €100K',
                                id: 'fb8efeaa-bea1-4713-9012-cbd25fc3dc89',
                                componentType: 'Salary',
                                interval: '1 YEAR',
                                currencyCode: 'EUR',
                                minValue: 72023.45,
                                maxValue: 100000,
                              },
                              {
                                summary: '1% – 2.511%',
                                id: '93c62578-ed5d-42dd-8186-64ad5ba5603d',
                                componentType: 'EquityPercentage',
                                interval: 'NONE',
                                minValue: 1,
                                maxValue: 2.511,
                              },
                              {
                                summary: 'Offers Bonus',
                                id: null,
                                componentType: 'Bonus',
                                interval: '1 YEAR',
                                minValue: null,
                                maxValue: null,
                              },
                            ],
                          },
                          title: {
                            description: 'A label that describes the entire range to applicants',
                            type: 'string',
                            example: 'Zone A',
                          },
                          id: {
                            allOf: [
                              {
                                $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                              },
                              {
                                description: "The compensation tier's unique id",
                              },
                            ],
                          },
                          additionalInformation: {
                            description: 'Supplementary information about the compensation',
                            type: 'string',
                            example: 'Signing bonus available',
                          },
                          tierSummary: {
                            description: `A summary of the tiers's components in the same format shown on Ashby-hosted Job Boards
`,
                            type: 'string',
                            example: '€72K – €100K • 1% – 2.511% • Offers Bonus',
                          },
                        },
                        required: ['id', 'components', 'tierSummary'],
                      },
                      example: [
                        {
                          components: [
                            {
                              summary: '€72K – €100K',
                              id: 'fb8efeaa-bea1-4713-9012-cbd25fc3dc89X',
                              componentType: 'Salary',
                              interval: '1 YEAR',
                              currencyCode: 'EUR',
                              minValue: 72023.45,
                              maxValue: 100000,
                            },
                            {
                              summary: '1% – 1.4%',
                              id: '93c62578-ed5d-42dd-8186-64ad5ba5603dX',
                              componentType: 'EquityPercentage',
                              interval: 'NONE',
                              minValue: 1,
                              maxValue: 1.4,
                            },
                          ],
                          title: 'Zone A',
                          id: 'da53719f-a115-400b-9d30-9b875428f1e7',
                          additionalInformation: null,
                          tierSummary: '€72K – €100K • 1% – 1.4%',
                        },
                        {
                          components: [
                            {
                              summary: '€72K – €100K',
                              id: 'fb8efeaa-bea1-4713-9012-cbd25fc3dc89X',
                              componentType: 'Salary',
                              interval: '1 YEAR',
                              currencyCode: 'EUR',
                              minValue: 95010.12,
                              maxValue: 270450,
                            },
                            {
                              summary: '1.8% – 2.511%',
                              id: '93c62578-ed5d-42dd-8186-64ad5ba5603dX',
                              componentType: 'EquityPercentage',
                              interval: 'NONE',
                              minValue: 1.8,
                              maxValue: 2.511,
                            },
                            {
                              summary: 'Offers Bonus',
                              id: null,
                              componentType: 'Bonus',
                              interval: '1 YEAR',
                              minValue: null,
                              maxValue: null,
                            },
                          ],
                          title: 'Zone B',
                          id: '81362ab1-739e-44f5-88d9-dbc5c731624c',
                          additionalInformation: 'Commuter Benefits',
                          tierSummary: '€95K – €270K • 1.8% – 2.511% • Offers Bonus • Commuter Benefits',
                        },
                      ],
                    },
                    shouldDisplayCompensationOnJobBoard: {
                      description: `Whether the job posting's settings specify that compensation should be shown to applicants
`,
                      type: 'boolean',
                      example: true,
                    },
                  },
                },
                updatedAt: {
                  $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                },
                applicationLimitCalloutHtml: {
                  description:
                    'An HTML version of any communication you would like to show to applicants about the application limit for this job posting',
                  type: 'string',
                  example: `<div>
  <p>Please Note: we have set up limits for applications for this role. It is in the <strong>Product Limit </strong> group. The following limits apply to applications for all jobs within this group:</p>
  <ul>
    <li>
      <p>Candidates may not apply more than 1 time in any 60 day span for any job in the <strong>Product Limit </strong> Group.</p>
    </li>
  </ul>
</div>
`,
                },
              },
              required: [
                'id',
                'title',
                'descriptionPlain',
                'descriptionHtml',
                'descriptionParts',
                'departmentName',
                'teamName',
                'jobId',
                'locationName',
                'locationIds',
                'linkedData',
                'publishedDate',
                'employmentType',
                'applicationFormDefiniton',
                'isListed',
                'externalLink',
                'compensation',
                'updatedAt',
              ],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const JobPostingGetAllPublishedResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/webhooks/jobPostingUpdate/post/requestBody/content/application~1json/schema/properties/data/properties/jobPosting',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const JobPostingUpdateExistingResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/JobPostingGetIndividualResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const LocationCreateHierarchyResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/LocationDetailsByIdResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const LocationDetailsByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                name: {
                  type: 'string',
                  example: 'Bay Area Office',
                },
                isArchived: {
                  $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                },
                address: {
                  type: 'object',
                  properties: {
                    postalAddress: {
                      type: 'object',
                      properties: {
                        addressCountry: {
                          type: 'string',
                          example: 'United States',
                        },
                        addressRegion: {
                          type: 'string',
                          example: 'California',
                        },
                        addressLocality: {
                          type: 'string',
                          example: 'San Francisco',
                        },
                      },
                    },
                  },
                },
                isRemote: {
                  type: 'boolean',
                  example: false,
                },
              },
              required: ['id', 'name', 'isArchived', 'isRemote'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const LocationGetListResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/LocationDetailsByIdResponse/oneOf/0/allOf/2/properties/results',
              },
            },
            moreDataAvailable: {
              $ref: '#/components/schemas/SourceGetAllResponse/oneOf/0/allOf/2/properties/moreDataAvailable',
            },
          },
        },
        {
          required: ['results', 'moreDataAvailable'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OfferCreateNewResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/webhooks/offerCreate/post/requestBody/content/application~1json/schema/properties/data/properties/offer',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OfferGetDetailsByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              $ref: '#/webhooks/offerCreate/post/requestBody/content/application~1json/schema/properties/data/properties/offer',
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OfferGetListResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/webhooks/offerCreate/post/requestBody/content/application~1json/schema/properties/data/properties/offer',
              },
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OfferStartCreationInstanceResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                formDefinition: {
                  type: 'object',
                  properties: {
                    sections: {
                      type: 'array',
                      items: {
                        type: 'object',
                        properties: {
                          title: {
                            type: 'string',
                          },
                          descriptionHtml: {
                            type: 'string',
                          },
                          descriptionPlain: {
                            type: 'string',
                          },
                          fields: {
                            type: 'array',
                            items: {
                              type: 'object',
                              properties: {
                                isRequired: {
                                  type: 'boolean',
                                  example: true,
                                  default: true,
                                },
                                descriptionHtml: {
                                  type: 'string',
                                },
                                descriptionPlain: {
                                  type: 'string',
                                },
                                field: {
                                  type: 'object',
                                  properties: {
                                    title: {
                                      type: 'string',
                                      example: 'Name',
                                    },
                                    id: {
                                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                                    },
                                    type: {
                                      description: 'The type of the form definition field.',
                                      type: 'string',
                                      example: 'String',
                                    },
                                    path: {
                                      type: 'string',
                                      example: '_systemfield_name',
                                    },
                                    humanReadablePath: {
                                      type: 'string',
                                      example: 'Name',
                                    },
                                    isNullable: {
                                      type: 'boolean',
                                      example: false,
                                      default: true,
                                    },
                                    selectableValues: {
                                      type: 'object',
                                      properties: {
                                        label: {
                                          type: 'string',
                                        },
                                        value: {
                                          type: 'string',
                                        },
                                      },
                                      required: ['label', 'value'],
                                    },
                                  },
                                },
                              },
                            },
                          },
                        },
                      },
                    },
                  },
                },
              },
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OfferProcessStartProcessForCandidateResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  allOf: [
                    {
                      description: 'The id of the started offer process',
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                applicationId: {
                  allOf: [
                    {
                      description: 'The id of the application the offer process was started for',
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                status: {
                  description: 'The status of the offer process',
                  type: 'string',
                  enum: [
                    'WaitingOnOfferCreation',
                    'WaitingOnApprovalStart',
                    'WaitingOnOfferApproval',
                    'WaitingOnCandidateResponse',
                    'CandidateAccepted',
                    'CandidateRejected',
                    'OfferCancelled',
                  ],
                },
              },
              required: ['id', 'applicationId', 'status'],
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OpeningsGetByUuidResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                openedAt: {
                  $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                },
                closedAt: {
                  $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                },
                isArchived: {
                  $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                },
                archivedAt: {
                  $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                },
                openingState: {
                  type: 'string',
                  enum: ['Approved', 'Closed', 'Draft', 'Filled', 'Open'],
                },
                latestVersion: {
                  type: 'object',
                  properties: {
                    description: {
                      type: 'string',
                    },
                    id: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    identifier: {
                      type: 'string',
                    },
                    authorId: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    createdAt: {
                      $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                    },
                    teamId: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    jobIds: {
                      type: 'array',
                      items: {
                        $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                      },
                    },
                    targetHireDate: {
                      type: 'string',
                    },
                    targetStartDate: {
                      type: 'string',
                    },
                    isBackfill: {
                      type: 'boolean',
                    },
                    employmentType: {
                      $ref: '#/webhooks/jobPostingUpdate/post/requestBody/content/application~1json/schema/properties/data/properties/jobPosting/properties/employmentType',
                    },
                    locationIds: {
                      type: 'array',
                      items: {
                        $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                      },
                    },
                    hiringTeam: {
                      type: 'array',
                      items: {
                        $ref: '#/components/schemas/HiringTeamAddMemberResponse/oneOf/0/allOf/2/properties/results',
                      },
                    },
                  },
                  required: [
                    'id',
                    'identifier',
                    'description',
                    'authorId',
                    'createdAt',
                    'jobIds',
                    'isBackfill',
                    'employmentType',
                    'locationIds',
                    'hiringTeam',
                  ],
                },
              },
              required: ['id', 'isArchived', 'openingState'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OpeningsGetListResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OpeningsSearchByIdentifierResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OpeningsCreateInstanceResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OpeningsAddJobActionResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OpeningsRemoveJobResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OpeningsSetStateResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OpeningsSetArchivedResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const OpeningsUpdateOpeningResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/OpeningsGetByUuidResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ReferralCreateNewResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              $ref: '#/webhooks/pushToHRIS/post/requestBody/content/application~1json/schema/properties/data/properties/application',
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const ReferralFormGetDefaultFormResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              allOf: [
                {
                  type: 'object',
                  properties: {
                    title: {
                      description: 'The title of the form',
                      type: 'string',
                    },
                    id: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    isArchived: {
                      $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                    },
                    formDefinition: {
                      $ref: '#/components/schemas/OfferStartCreationInstanceResponse/oneOf/0/allOf/1/properties/results/properties/formDefinition',
                    },
                  },
                  required: ['id', 'organizationId', 'title', 'isArchived', 'isDefaultForm', 'formDefinition'],
                },
                {
                  type: 'object',
                  properties: {
                    organizationId: {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                    isDefaultForm: {
                      type: 'boolean',
                      example: true,
                    },
                  },
                },
              ],
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const SourceGetAllResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                type: 'object',
                properties: {
                  title: {
                    type: 'string',
                    example: 'Applied',
                  },
                  id: {
                    $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                  },
                  isArchived: {
                    $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                  },
                  sourceType: {
                    type: 'object',
                    properties: {
                      title: {
                        type: 'string',
                        example: 'Inbound',
                      },
                      id: {
                        $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                      },
                      isArchived: {
                        $ref: '#/components/schemas/InterviewPlanGetAllResponse/oneOf/0/allOf/2/properties/results/items/properties/isArchived',
                      },
                    },
                    required: ['id', 'title', 'isArchived'],
                  },
                },
                required: ['id', 'title', 'isArchived'],
              },
            },
            moreDataAvailable: {
              type: 'boolean',
              example: false,
            },
          },
        },
        {
          required: ['results', 'moreDataAvailable'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const SurveyFormDefinitionGetDetailsByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              allOf: [
                {
                  $ref: '#/components/schemas/ReferralFormGetDefaultFormResponse/oneOf/0/allOf/1/properties/results/allOf/0',
                },
                {
                  type: 'object',
                  properties: {
                    surveyType: {
                      $ref: '#/components/schemas/SurveySubmissionListBySurveyTypeRequest/allOf/0/properties/surveyType',
                    },
                  },
                },
              ],
              required: ['id', 'title', 'isArchived', 'formDefinition', 'surveyType'],
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const SurveyFormDefinitionGetAllResponseSchema = {
  oneOf: [
    {
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/SurveyFormDefinitionGetDetailsByIdResponse/oneOf/0/allOf/1/properties/results',
              },
            },
          },
        },
      ],
      required: ['results'],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const SurveyRequestGenerateUrlResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  allOf: [
                    {
                      description: `The id of the survey request
`,
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                candidateId: {
                  allOf: [
                    {
                      description: `The id of the candidate the survey request is for
`,
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                applicationId: {
                  allOf: [
                    {
                      description: `The id of the application associated with the survey request
`,
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                surveyFormDefinitionId: {
                  allOf: [
                    {
                      description: `The id of the survey form the candidate will fill out when they take the survey
`,
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
                surveyUrl: {
                  description: `The URL that the candidate can visit to take the survey.
`,
                  type: 'string',
                  example: 'https://you.ashbyhq.com/ashby/survey/3f20b73e-abec-4d62-ba6f-04f2f985f7dd',
                },
              },
              required: ['id', 'candidateId', 'applicationId', 'surveyFormDefinitionId', 'surveyUrl'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const SurveySubmissionListBySurveyTypeResponseSchema = {
  oneOf: [
    {
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/webhooks/surveySubmit/post/requestBody/content/application~1json/schema/properties/data/properties/surveySubmission',
              },
            },
          },
        },
      ],
      required: ['results'],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const UserGetByIdResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                firstName: {
                  type: 'string',
                  example: 'Test',
                },
                lastName: {
                  type: 'string',
                  example: 'User',
                },
                email: {
                  $ref: '#/components/schemas/CandidateCreateNewCandidateRequest/properties/email/allOf/0',
                },
                globalRole: {
                  type: 'string',
                  enum: ['Organization Admin', 'Elevated Access', 'Limited Access', 'External Recruiter'],
                },
                isEnabled: {
                  type: 'boolean',
                },
                updatedAt: {
                  $ref: '#/components/schemas/ReferralCreateNewRequest/properties/createdAt/allOf/1',
                },
              },
              required: ['id', 'firstName', 'lastName', 'globalRole', 'isEnabled', 'updatedAt'],
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const UserGetAshbyUsersResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetListResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/UserGetByIdResponse/oneOf/0/allOf/1/properties/results',
              },
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const UserSearchByEmailResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
          properties: {
            results: {
              type: 'array',
              items: {
                $ref: '#/components/schemas/UserGetByIdResponse/oneOf/0/allOf/1/properties/results',
              },
            },
          },
          required: ['results'],
        },
      ],
    },
    {
      title: 'Error response',
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const WebhookCreateSettingResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                id: {
                  $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                },
                enabled: {
                  description: 'Whether or not the webhook setting is enabled.',
                  type: 'boolean',
                },
                requestUrl: {
                  description: 'The URL the webhook will send requests to.',
                  type: 'string',
                  example: 'https://example.com/webhook',
                },
                secretToken: {
                  description: `The secret token used to sign the webhook request. See our documentation [here](https://developers.ashbyhq.com/docs/authenticating-webhooks) for more information.
`,
                  type: 'string',
                  example: '0c2f9463f87641919f8106a2c49d7a57',
                },
                webhookType: {
                  description: 'The type of webhook.',
                  type: 'string',
                  $ref: '#/components/schemas/WebhookCreateSettingRequest/properties/webhookType',
                },
              },
              required: ['id', 'enabled', 'requestUrl', 'secretToken', 'webhookType'],
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const WebhookUpdateSettingResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              $ref: '#/components/schemas/WebhookCreateSettingResponse/oneOf/0/allOf/2/properties/results',
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;

export const WebhookRemoveSettingResponseSchema = {
  oneOf: [
    {
      title: 'Success response',
      allOf: [
        {
          $ref: '#/components/schemas/JobGetByIdResponse/oneOf/0/allOf/0',
        },
        {
          type: 'object',
        },
        {
          properties: {
            results: {
              type: 'object',
              properties: {
                webhookId: {
                  allOf: [
                    {
                      description: 'The id of the webhook setting that was deleted.',
                    },
                    {
                      $ref: '#/components/schemas/CandidateCreateNoteRequest/properties/candidateId',
                    },
                  ],
                },
              },
            },
          },
        },
        {
          required: ['results'],
        },
      ],
    },
    {
      $ref: '#/components/schemas/JobGetByIdResponse/oneOf/1',
    },
  ],
} as const;
