// Generated by ts-to-zod
import { z } from 'zod';

export const contactSchema = z.record(z.union([z.union([z.unknown(), z.string()]), z.undefined()])).and(
  z.object({
    id: z.string(),
    first_name: z.string().optional(),
    last_name: z.string().optional(),
    name: z.string().optional(),
    linkedin_url: z.string().optional(),
    title: z.string().optional(),
    organization_name: z.string().optional(),
    organization_id: z.string().optional(),
    headline: z.string().optional(),
    photo_url: z.string().optional(),
    updated_at: z.string().optional(),
    label_ids: z.array(z.string()).optional(),
    email: z.string().optional(),
    phone_numbers: z.array(z.string()).optional(),
    emailer_campaign_ids: z.array(z.string()).optional(),
    contact_campaign_statuses: z.array(
      z.record(z.union([z.union([z.unknown(), z.string()]), z.undefined()])).and(
        z.object({
          id: z.string(),
          send_email_from_email_account_id: z.string(),
          emailer_campaign_id: z.string(),
        }),
      ),
    ),
  }),
);

export const emailAccountSchema = z.record(z.union([z.union([z.unknown(), z.string()]), z.undefined()])).and(
  z.object({
    id: z.string(),
    userId: z.unknown().optional(),
    email: z.unknown().optional(),
    createdAt: z.unknown().optional(),
    updatedAt: z.unknown().optional(),
    lastModifiedAt: z.unknown().optional(),
    isDeleted: z.unknown().optional(),
    rawData: z.unknown().optional(),
    isDisabled: z.unknown().optional(),
  }),
);

export const metricSchema = z.union([z.number(), z.literal('loading')]).nullable();

export const permissionsSchema = z.union([z.literal('team_can_use'), z.literal('team_can_view'), z.literal('private')]);

export const emailerStepTypeSchema = z.union([
  z.literal('auto_email'),
  z.literal('manual_email'),
  z.literal('call'),
  z.literal('action_item'),
  z.literal('linkedin_step_message'),
  z.literal('linkedin_step_connect'),
  z.literal('linkedin_step_view_profile'),
  z.literal('linkedin_step_interact_post'),
]);

export const emailerStepWaitModeSchema = z.union([
  z.literal('second'),
  z.literal('minute'),
  z.literal('hour'),
  z.literal('day'),
]);

export const emailerTemplateSchema = z.object({
  id: z.string(),
  name: z.string().optional().nullable(),
  user_id: z.string().optional().nullable(),
  subject: z.string().optional().nullable(),
  archived: z.boolean().optional().nullable(),
  created_at: z.string().optional().nullable(),
  global: z.boolean().optional().nullable(),
  body_text: z.string().optional().nullable(),
  folder_id: z.string().optional().nullable(),
  body_html: z.string().optional().nullable(),
  creation_type: z.string().optional().nullable(),
  label_ids: z.array(z.string()).optional().nullable(),
  prompt_id: z.string().optional().nullable(),
});

export const emailerTouchSchema = z.object({
  id: z.string(),
  emailer_step_id: z.string().optional().nullable(),
  emailer_template_id: z.string().optional().nullable(),
  emailer_template: emailerTemplateSchema.optional().nullable(),
  status: z.string().optional().nullable(),
  type: z
    .union([z.literal('reply_to_thread'), z.literal('new_thread')])
    .optional()
    .nullable(),
  include_signature: z.boolean().optional().nullable(),
  has_personalized_opener: z.boolean().optional().nullable(),
  personalized_opener_fallback_option: z.string().optional().nullable(),
  generic_personalized_opener: z.string().optional().nullable(),
  unique_scheduled: metricSchema.optional(),
  unique_delivered: metricSchema.optional(),
  unique_bounced: metricSchema.optional(),
  unique_opened: metricSchema.optional(),
  unique_replied: metricSchema.optional(),
  bounce_rate: metricSchema.optional(),
  open_rate: metricSchema.optional(),
  reply_rate: metricSchema.optional(),
  demo_rate: metricSchema.optional(),
  unique_demoed: metricSchema.optional(),
  unique_clicked: metricSchema.optional(),
  click_rate: metricSchema.optional(),
  unique_unsubscribed: metricSchema.optional(),
  opt_out_rate: metricSchema.optional(),
  unique_hard_bounced: metricSchema.optional(),
  unique_spam_blocked: metricSchema.optional(),
  hard_bounce_rate: metricSchema.optional(),
  spam_block_rate: metricSchema.optional(),
});

export const typeSchema = z.union([z.literal('reply_to_thread'), z.literal('new_thread')]);

export const getEmailerCampaignDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const emailerCampaignSchema = z.object({
  id: z.string(),
  name: z.string().optional().nullable(),
  created_at: z.string(),
  permissions: z.union([z.literal('team_can_use'), z.literal('team_can_view'), z.literal('private')]).optional(),
  active: z.boolean(),
  archived: z.boolean(),
  label_ids: z.array(z.string()),
  num_steps: z.number().optional().nullable(),
  user_id: z.string().optional().nullable(),
  unique_scheduled: metricSchema.optional(),
  unique_delivered: metricSchema.optional(),
  unique_bounced: metricSchema.optional(),
  unique_opened: metricSchema.optional(),
  unique_replied: metricSchema.optional(),
  unique_demoed: metricSchema.optional(),
  unique_clicked: metricSchema.optional(),
  unique_unsubscribed: metricSchema.optional(),
  bounce_rate: metricSchema.optional(),
  open_rate: metricSchema.optional(),
  click_rate: metricSchema.optional(),
  reply_rate: metricSchema.optional(),
  spam_blocked_rate: metricSchema.optional(),
  opt_out_rate: metricSchema.optional(),
  demo_rate: metricSchema.optional(),
});

export const emailerStepSchema = z.object({
  id: z.string(),
  emailer_campaign_id: z.string(),
  position: z.number().optional().nullable(),
  wait_time: z.number().optional().nullable(),
  type: emailerStepTypeSchema,
  wait_mode: emailerStepWaitModeSchema,
  note: z.string().optional().nullable(),
  max_emails_per_day: z.number().optional().nullable(),
  exact_datetime: z.string().optional().nullable(),
  priority: z.string().optional().nullable(),
  auto_skip_in_x_days: z.number().optional().nullable(),
  counts: z
    .object({
      active: z.number().optional().nullable(),
      paused: z.number().optional().nullable(),
      finished: z.number().optional().nullable(),
      bounced: z.number().optional().nullable(),
      spam_blocked: z.number().optional().nullable(),
      hard_bounced: z.number().optional().nullable(),
      not_sent: z.number().optional().nullable(),
    })
    .optional()
    .nullable(),
});

export const getEmailerCampaignErrorSchema = z.unknown();

export const createEmailerCampaignDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional().nullable(),
      permissions: z.union([z.literal('team_can_use'), z.literal('team_can_view'), z.literal('private')]).optional(),
      user_id: z.string().optional().nullable(),
      label_ids: z.array(z.string()).optional(),
      active: z.boolean().optional(),
    })
    .optional(),
});

export const createEmailerCampaignResponseSchema = z.object({
  emailer_campaign: emailerCampaignSchema,
  emailer_steps: z.array(emailerStepSchema).optional().nullable(),
  emailer_touches: z.array(emailerTouchSchema).optional().nullable(),
  emailer_templates: z.array(emailerTemplateSchema).optional().nullable(),
});

export const createEmailerCampaignErrorSchema = z.unknown();

export const addContactIdsToEmailerCampaignDataSchema = z.object({
  body: z
    .object({
      contact_ids: z.array(z.string()),
      emailer_campaign_id: z.string(),
      send_email_from_email_account_id: z.string(),
      userId: z.string().optional().nullable(),
      sequence_active_in_other_campaigns: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const addContactIdsToEmailerCampaignResponseSchema = z.object({
  contacts: z.array(contactSchema),
});

export const addContactIdsToEmailerCampaignErrorSchema = z.unknown();

export const createEmailerStepDataSchema = z.object({
  body: z
    .object({
      emailer_campaign_id: z.string(),
      priority: z.string().optional().nullable(),
      position: z.number().optional().nullable(),
      type: emailerStepTypeSchema,
      wait_mode: emailerStepWaitModeSchema,
      wait_time: z.number().optional().nullable(),
      exact_datetime: z.string().optional().nullable(),
      note: z.string().optional().nullable(),
    })
    .optional(),
});

export const createEmailerStepResponseSchema = z.object({
  emailer_step: emailerStepSchema,
  emailer_touch: emailerTouchSchema.optional().nullable(),
  emailer_template: emailerTemplateSchema.optional().nullable(),
});

export const createEmailerStepErrorSchema = z.unknown();

export const deleteEmailerStepDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteEmailerStepResponseSchema = z.object({
  emailer_step: z.object({
    id: z.string(),
    deleted: z.boolean(),
  }),
});

export const deleteEmailerStepErrorSchema = z.unknown();

export const updateEmailerTouchDataSchema = z.object({
  body: z
    .object({
      id: z.string(),
      emailer_step_id: z.string().optional().nullable(),
      emailer_template: emailerTemplateSchema.optional().nullable(),
      type: z
        .union([z.literal('reply_to_thread'), z.literal('new_thread')])
        .optional()
        .nullable(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const updateEmailerTouchResponseSchema = z.object({
  emailer_touch: emailerTouchSchema,
});

export const updateEmailerTouchErrorSchema = z.unknown();

export const getContactDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getContactResponseSchema = z.object({
  contact: contactSchema,
});

export const getContactErrorSchema = z.unknown();

export const searchContactsDataSchema = z.object({
  body: z
    .object({
      q_keywords: z.string().optional(),
      contact_stage_ids: z.array(z.string()).optional(),
      sort_by_field: z
        .union([
          z.literal('contact_last_activity_date'),
          z.literal('contact_email_last_opened_at'),
          z.literal('contact_email_last_clicked_at'),
          z.literal('contact_created_at'),
          z.literal('contact_updated_at'),
        ])
        .optional(),
      sort_ascending: z.boolean().optional(),
      page: z.number().optional(),
    })
    .optional(),
});

export const searchContactsResponseSchema = z.object({
  contacts: z.array(contactSchema),
  pagination: z.object({
    page: z.number(),
    per_page: z.number(),
    total_entries: z.number(),
    total_pages: z.number(),
  }),
});

export const searchContactsErrorSchema = z.unknown();

export const listEmailAccountsDataSchema = z.unknown();

export const listEmailAccountsResponseSchema = z.object({
  email_accounts: z.array(emailAccountSchema),
});

export const listEmailAccountsErrorSchema = z.unknown();

export const checkContactsDeployabilityDataSchema = z.object({
  body: z
    .object({
      contact_ids: z.array(z.string()),
      emailer_campaign_id: z.string().optional(),
    })
    .optional(),
});

export const checkContactsDeployabilityResponseSchema = z.object({
  num_active_in_other_campaigns: z.number(),
  num_finished_in_other_campaigns: z.number(),
  num_same_company: z.number(),
  num_no_email: z.number(),
  num_unverified_email: z.number(),
  num_without_ownership_permission: z.number(),
  num_with_job_change_contacts: z.number(),
  sample_active_in_other_campaigns_contacts: z.array(
    z.object({
      id: z.string(),
      name: z.string(),
    }),
  ),
  sample_finished_in_other_campaigns_contacts: z.array(z.unknown()),
  sample_same_company_contacts: z.array(z.unknown()),
  sample_no_email_contacts: z.array(z.unknown()),
  sample_unverified_email_contacts: z.array(z.unknown()),
  sample_without_ownership_permission: z.array(z.unknown()),
  sample_with_job_change_contacts: z.array(z.unknown()),
  show_warning: z.boolean(),
  num_total_dangerous_contacts: z.number(),
});

export const checkContactsDeployabilityErrorSchema = z.unknown();

export const getEmailerCampaignResponseSchema = z.object({
  emailer_campaign: emailerCampaignSchema,
  emailer_steps: z.array(emailerStepSchema).optional().nullable(),
  emailer_touches: z.array(emailerTouchSchema).optional().nullable(),
  emailer_templates: z.array(emailerTemplateSchema).optional().nullable(),
});
