// This file is auto-generated by @hey-api/openapi-ts

export type contact = {
  id: string;
  first_name?: string;
  last_name?: string;
  name?: string;
  linkedin_url?: string;
  title?: string;
  organization_name?: string;
  organization_id?: string;
  headline?: string;
  photo_url?: string;
  updated_at?: string;
  label_ids?: Array<string>;
  email?: string;
  /**
   * Need to test this out...
   */
  phone_numbers?: Array<string>;
  emailer_campaign_ids?: Array<string>;
  contact_campaign_statuses: Array<string>;
  [key: string]: (unknown | string) | undefined;
};

export type email_account = {
  id: string;
  userId?: unknown;
  email?: unknown;
  createdAt?: unknown;
  updatedAt?: unknown;
  lastModifiedAt?: unknown;
  isDeleted?: unknown;
  rawData?: unknown;
  isDisabled?: unknown;
  [key: string]: (unknown | string) | undefined;
};

export type emailer_campaign = {
  id: string;
  name?: string | null;
  created_at: string;
  permissions?: 'team_can_use' | 'team_can_view' | 'private';
  active: boolean;
  archived: boolean;
  label_ids: Array<string>;
  num_steps?: number | null;
  user_id?: string | null;
  unique_scheduled?: metric;
  unique_delivered?: metric;
  unique_bounced?: metric;
  unique_opened?: metric;
  unique_replied?: metric;
  unique_demoed?: metric;
  unique_clicked?: metric;
  unique_unsubscribed?: metric;
  bounce_rate?: metric;
  open_rate?: metric;
  click_rate?: metric;
  reply_rate?: metric;
  spam_blocked_rate?: metric;
  opt_out_rate?: metric;
  demo_rate?: metric;
};

export type permissions = 'team_can_use' | 'team_can_view' | 'private';

export type emailer_step = {
  id: string;
  emailer_campaign_id: string;
  position?: number | null;
  wait_time?: number | null;
  type: emailer_step_type;
  wait_mode: emailer_step_wait_mode;
  note?: string | null;
  max_emails_per_day?: number | null;
  exact_datetime?: string | null;
  priority?: string | null;
  auto_skip_in_x_days?: number | null;
  counts?: {
    active?: number | null;
    paused?: number | null;
    finished?: number | null;
    bounced?: number | null;
    spam_blocked?: number | null;
    hard_bounced?: number | null;
    not_sent?: number | null;
  } | null;
};

export type emailer_step_type =
  | 'auto_email'
  | 'manual_email'
  | 'call'
  | 'action_item'
  | 'linkedin_step_message'
  | 'linkedin_step_connect'
  | 'linkedin_step_view_profile'
  | 'linkedin_step_interact_post';

export type emailer_step_wait_mode = 'second' | 'minute' | 'hour' | 'day';

export type emailer_template = {
  id: string;
  name?: string | null;
  user_id?: string | null;
  subject?: string | null;
  archived?: boolean | null;
  created_at?: string | null;
  global?: boolean | null;
  body_text?: string | null;
  folder_id?: string | null;
  body_html?: string | null;
  creation_type?: string | null;
  label_ids?: Array<string> | null;
  prompt_id?: string | null;
};

export type emailer_touch = {
  id: string;
  emailer_step_id?: string | null;
  emailer_template_id?: string | null;
  emailer_template?: emailer_template | null;
  status?: string | null;
  type?: ('reply_to_thread' | 'new_thread') | null;
  include_signature?: boolean | null;
  has_personalized_opener?: boolean | null;
  personalized_opener_fallback_option?: string | null;
  generic_personalized_opener?: string | null;
  unique_scheduled?: metric;
  unique_delivered?: metric;
  unique_bounced?: metric;
  unique_opened?: metric;
  unique_replied?: metric;
  bounce_rate?: metric;
  open_rate?: metric;
  reply_rate?: metric;
  demo_rate?: metric;
  unique_demoed?: metric;
  unique_clicked?: metric;
  click_rate?: metric;
  unique_unsubscribed?: metric;
  opt_out_rate?: metric;
  unique_hard_bounced?: metric;
  unique_spam_blocked?: metric;
  hard_bounce_rate?: metric;
  spam_block_rate?: metric;
};

export type type = 'reply_to_thread' | 'new_thread';

export type metric = number | 'loading' | null;

export type GetEmailerCampaignData = {
  path: {
    id: string;
  };
};

export type GetEmailerCampaignResponse = {
  emailer_campaign: emailer_campaign;
  emailer_steps?: Array<string> | null;
  emailer_touches?: Array<string> | null;
  emailer_templates?: Array<string> | null;
};

export type GetEmailerCampaignError = unknown;

export type CreateEmailerCampaignData = {
  body?: {
    name?: string | null;
    permissions?: 'team_can_use' | 'team_can_view' | 'private';
    user_id?: string | null;
    label_ids?: Array<string>;
    active?: boolean;
  };
};

export type CreateEmailerCampaignResponse = {
  emailer_campaign: emailer_campaign;
  emailer_steps?: Array<string> | null;
  emailer_touches?: Array<string> | null;
  emailer_templates?: Array<string> | null;
};

export type CreateEmailerCampaignError = unknown;

export type AddContactIdsToEmailerCampaignData = {
  body?: {
    contact_ids: Array<string>;
    emailer_campaign_id: string;
    send_email_from_email_account_id: string;
    userId?: string | null;
    /**
     *
     * By default Apollo will not add contact to more than one sequence at a time. However if we pass "true"
     * to this field, it will add the contact to the sequence even if they are already in another sequence.
     *
     */
    sequence_active_in_other_campaigns?: boolean;
  };
  path: {
    id: string;
  };
};

export type AddContactIdsToEmailerCampaignResponse = {
  contacts: Array<string>;
};

export type AddContactIdsToEmailerCampaignError = unknown;

export type CreateEmailerStepData = {
  body?: {
    emailer_campaign_id: string;
    priority?: string | null;
    position?: number | null;
    type: emailer_step_type;
    wait_mode: emailer_step_wait_mode;
    wait_time?: number | null;
    exact_datetime?: string | null;
    note?: string | null;
  };
};

export type CreateEmailerStepResponse = {
  emailer_step: emailer_step;
  emailer_touch?: emailer_touch | null;
  emailer_template?: emailer_template | null;
};

export type CreateEmailerStepError = unknown;

export type DeleteEmailerStepData = {
  path: {
    id: string;
  };
};

export type DeleteEmailerStepResponse = {
  emailer_step: {
    id: string;
    deleted: boolean;
  };
};

export type DeleteEmailerStepError = unknown;

export type UpdateEmailerTouchData = {
  body?: {
    id: string;
    emailer_step_id?: string | null;
    emailer_template?: emailer_template | null;
    type?: ('reply_to_thread' | 'new_thread') | null;
  };
  path: {
    id: string;
  };
};

export type UpdateEmailerTouchResponse = {
  emailer_touch: emailer_touch;
};

export type UpdateEmailerTouchError = unknown;

export type GetContactData = {
  path: {
    id: string;
  };
};

export type GetContactResponse = {
  contact: contact;
};

export type GetContactError = unknown;

export type SearchContactsData = {
  body?: {
    /**
     * The contact's name, title, company, or email
     */
    q_keywords?: string;
    /**
     * An Array<string> of stage ids the contact must belong to. Refer to /contact_stages to get a list of possible stage ids.
     */
    contact_stage_ids?: Array<string>;
    /**
     * 	Possible values: "contact_last_activity_date", "contact_email_last_opened_at", "contact_email_last_clicked_at", "contact_created_at", or "contact_updated_at"
     */
    sort_by_field?:
      | 'contact_last_activity_date'
      | 'contact_email_last_opened_at'
      | 'contact_email_last_clicked_at'
      | 'contact_created_at'
      | 'contact_updated_at';
    /**
     * Possible values: true or false
     */
    sort_ascending?: boolean;
    /**
     * Which page to return. Defaults to 1
     */
    page?: number;
  };
};

export type SearchContactsResponse = {
  contacts: Array<string>;
  pagination: {
    page: number;
    per_page: number;
    total_entries: number;
    total_pages: number;
  };
};

export type SearchContactsError = unknown;

export type ListEmailAccountsData = unknown;

export type ListEmailAccountsResponse = {
  email_accounts: Array<string>;
};

export type ListEmailAccountsError = unknown;

export type CheckContactsDeployabilityData = {
  body?: {
    contact_ids: Array<string>;
    emailer_campaign_id?: string;
  };
};

export type CheckContactsDeployabilityResponse = {
  num_active_in_other_campaigns: number;
  num_finished_in_other_campaigns: number;
  num_same_company: number;
  num_no_email: number;
  num_unverified_email: number;
  num_without_ownership_permission: number;
  num_with_job_change_contacts: number;
  sample_active_in_other_campaigns_contacts: Array<string>;
  sample_finished_in_other_campaigns_contacts: Array<string>;
  sample_same_company_contacts: Array<string>;
  sample_no_email_contacts: Array<string>;
  sample_unverified_email_contacts: Array<string>;
  sample_without_ownership_permission: Array<string>;
  sample_with_job_change_contacts: Array<string>;
  show_warning: boolean;
  num_total_dangerous_contacts: number;
};

export type CheckContactsDeployabilityError = unknown;
