// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GetEmailerCampaignData,
  GetEmailerCampaignError,
  GetEmailerCampaignResponse,
  CreateEmailerCampaignData,
  CreateEmailerCampaignError,
  CreateEmailerCampaignResponse,
  AddContactIdsToEmailerCampaignData,
  AddContactIdsToEmailerCampaignError,
  AddContactIdsToEmailerCampaignResponse,
  CreateEmailerStepData,
  CreateEmailerStepError,
  CreateEmailerStepResponse,
  DeleteEmailerStepData,
  DeleteEmailerStepError,
  DeleteEmailerStepResponse,
  UpdateEmailerTouchData,
  UpdateEmailerTouchError,
  UpdateEmailerTouchResponse,
  GetContactData,
  GetContactError,
  GetContactResponse,
  SearchContactsData,
  SearchContactsError,
  SearchContactsResponse,
  ListEmailAccountsData,
  ListEmailAccountsError,
  ListEmailAccountsResponse,
  CheckContactsDeployabilityData,
  CheckContactsDeployabilityError,
  CheckContactsDeployabilityResponse,
} from './types.gen';

export const client = createClient(createConfig());

export const getEmailerCampaign = <ThrowOnError extends boolean = false>(
  options: Options<GetEmailerCampaignData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEmailerCampaignResponse, GetEmailerCampaignError, ThrowOnError>({
    ...options,
    url: '/v1/emailer_campaigns/{id}',
  });
};

export const createEmailerCampaign = <ThrowOnError extends boolean = false>(
  options?: Options<CreateEmailerCampaignData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateEmailerCampaignResponse, CreateEmailerCampaignError, ThrowOnError>({
    ...options,
    url: '/v1/emailer_campaigns',
  });
};

export const addContactIdsToEmailerCampaign = <ThrowOnError extends boolean = false>(
  options: Options<AddContactIdsToEmailerCampaignData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AddContactIdsToEmailerCampaignResponse,
    AddContactIdsToEmailerCampaignError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/emailer_campaigns/{id}/add_contact_ids',
  });
};

export const createEmailerStep = <ThrowOnError extends boolean = false>(
  options?: Options<CreateEmailerStepData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateEmailerStepResponse, CreateEmailerStepError, ThrowOnError>({
    ...options,
    url: '/v1/emailer_steps',
  });
};

export const deleteEmailerStep = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEmailerStepData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteEmailerStepResponse, DeleteEmailerStepError, ThrowOnError>({
    ...options,
    url: '/v1/emailer_steps/{id}',
  });
};

export const updateEmailerTouch = <ThrowOnError extends boolean = false>(
  options: Options<UpdateEmailerTouchData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateEmailerTouchResponse, UpdateEmailerTouchError, ThrowOnError>({
    ...options,
    url: '/v1/emailer_touches/{id}',
  });
};

export const getContact = <ThrowOnError extends boolean = false>(options: Options<GetContactData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetContactResponse, GetContactError, ThrowOnError>({
    ...options,
    url: '/v1/contacts/{id}',
  });
};

export const searchContacts = <ThrowOnError extends boolean = false>(
  options?: Options<SearchContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SearchContactsResponse, SearchContactsError, ThrowOnError>({
    ...options,
    url: '/v1/contacts/search',
  });
};

export const listEmailAccounts = <ThrowOnError extends boolean = false>(
  options?: Options<ListEmailAccountsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListEmailAccountsResponse, ListEmailAccountsError, ThrowOnError>({
    ...options,
    url: '/v1/email_accounts',
  });
};

/**
 * Check if contacts are deployable to a sequence, primarily used to check if contacts are already in another sequence.
 */
export const checkContactsDeployability = <ThrowOnError extends boolean = false>(
  options?: Options<CheckContactsDeployabilityData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CheckContactsDeployabilityResponse,
    CheckContactsDeployabilityError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/emailer_campaigns/check_contacts_deployability',
  });
};
