# Contributing to MastraAI

Welcome to the MastraAI developer community. Thanks for taking the time to contribute!

## Contributor Guidelines

Please read the guidance below about what to do if you:

- [Found a bug](#did-you-find-a-bug)
- [Fixed a bug](#did-you-write-a-patch-that-fixes-a-bug)
- [Want to add a new feature or change an existing one](#do-you-intend-to-add-a-new-feature-or-change-an-existing-one)

### Did you find a bug?

- Ensure that the bug was not already reported by searching on GitHub under the relevant issue tracker
- If you're unable to find an open issue addressing the problem, open a new one

Be sure to include a title and clear description, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

### Did you write a patch that fixes a bug?

- Open a new GitHub pull request with the patch
- Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable

### Do you intend to add a new feature or change an existing one?

- Say hello and suggest your change on the discussion channels for the [MastraAI community](https://discord.gg/J6Q2CfWX)
- Assuming you get positive feedback, raise a Pull Request against your fork/branch to track the development of the feature and discuss the implementation.

Then do your thing, write some code :)
