---
aliases:
  - /notes/oil-futures/
category: questions
description: In which I write about something that is definitely not computers
slug: finance-oil-futures-negative
tags:
  - finance
  - futures
title: Why did oil futures go negative in April 2020?
---
On April 20th 2020, oil futures fell to $-37.63 per barrel but how is that possible? That would suggest people are literally paying customers to take oil off their hands.

In a sense, that's exactly the case but perhaps not for quite the reasons you might expect.

## What are oil futures?

> with the pandemic bringing the economy to a standstill, there is so much unused oil sloshing around that American energy companies have run out of room to store it. And if there's no place to put the oil, no one wants a crude contract that is about to come due.

In reality, traders hold a contract that, generally after about 3 months, is translated into a physical delivery of oil.

For example, someone may pay $40 per barrel in January. Oil may be worth $60 in March so a trader might then sell the contract for a $20 profit, as I understand it anyway.

Futures are designed for people who actually want to purchase oil, or any future-able item like wheat, corn and so on.

That doesn't stop a whole portion of Wall Street who speculate on these futures however.

There are some funny stories about junior traders who have forgotten to sell their contract and have been required to take delivery of hundreds of physical barrels of oil.

## Receiving delivery

The city of [Cushing, Oklahoma](https://en.wikipedia.org/wiki/Cushing,_Oklahoma) is called the "Pipeline Crossroads of the World" and is where a great deal of oil is stored in the United States.

When it comes to oil futures, Cushing is also the one and only [designated delivery point](https://en.wikipedia.org/wiki/Cushing,_Oklahoma#Oil_futures_designated_delivery_point_in_the_US).

Normally, oil is stored there on behalf of those who lease between 50 - 80 million barrels worth of storage.

## Why did oil futures turn negative?

Given Coronavirus meant that most of the world was at home, oil producers had little option but to store their oil.

When it came time for those futures to convert into physical oil, there was no actual storage left for traders to purchase.

> With nowhere to store their oil, and the foreboding promise of exorbitant storage fees at the delivery site, the holders of oil delivery contracts were forced to pay buyers with oil storage contracts to take the product off their hands, upending the market and sending the entire industry into unknown, negative territory.

Faced with the horrifying idea of having to drive all the way to Cushing, Oklahoma to somehow receive thousands of barrels of oil, it became more appeals to just pay almost $40/barrel for someone else to take the future (and impending delivery) off of their hands

Storage may have been possible but at a time where it was in high demand, the excesses would have been astronomical.

Not to mention, there was already an overabundance of oil for the foreseeable future so it would take a long time to realise a profit, if at all.

## Sources

- [https://www.bloomberg.com/opinion/articles/2020-04-22/nobody-wants-much-oil-right-now](https://www.bloomberg.com/opinion/articles/2020-04-22/nobody-wants-much-oil-right-now)
- [https://www.bloomberg.com/opinion/articles/2020-04-28/oil-traders-not-sure-they-like-oil](https://www.bloomberg.com/opinion/articles/2020-04-28/oil-traders-not-sure-they-like-oil)
- [https://www.reuters.com/article/us-global-oil-usa-storage/no-vacancy-main-us-oil-storage-in-cushing-is-all-booked-idUSKCN22332W](https://www.reuters.com/article/us-global-oil-usa-storage/no-vacancy-main-us-oil-storage-in-cushing-is-all-booked-idUSKCN22332W)
- [https://www.cushingcitizen.com/news/oil-turns-red](https://www.cushingcitizen.com/news/oil-turns-red)

## Further reading

- [https://www.npr.org/sections/money/2016/08/26/491342091/planet-money-buys-oil](https://www.npr.org/sections/money/2016/08/26/491342091/planet-money-buys-oil)
