---
category: projects
description: An ongoing project of mine where I ask some meta-questions about documents that are redacted each year in New Zealand
maxwidth: true
ongoing: false
slug: meta-oia-requests
tags:
  - government
  - nz
  - oia
  - projects
title: Yearly review of OIAs redacted or declined by the NZ government
---
This one probably needs a bit of explanation, more than most of my projects.

The short version is that here in New Zealand, we have the [Official Information Act of 1982](https://en.wikipedia.org/wiki/Official_Information_Act_1982) or OIA for short.

It allows anyone in New Zealand, permanent or otherwise, to request almost any sort of information from members of government.

I once wrote a getting started guide that go through the background and all that [here](/blog/nz-oia-guide) so I can recommend that for extra context.

Anyway, in saying this, there are certain "grounds" that can be invoked to redact or retain secrets such as those that might affect the privacy of a person or cause economic troubles for example.

That got me thinking. While the contents of redacted OIAs may not be accessible to the public, metadata about those OIAs can be just as interesting and so that's what this project is about.

Each year, I make a request to the Prime Minister's Office and ask for a list of OIAs that have been redacted or denied each year.

Admittedly, a few years I've forgotten to explicitly request the particular date so half of my data set are just time ranges but generally, the titles and grounds for denial are the most interesting.

At some point, I may file a request to backfill some data prior to when this list started but I haven't had any plans to do much more than keep it updated yearly as of yet.

I'm due to file my next update sometime around August or September 2021

| Request Date | Subject                                                                                                                                              | Denied Under     |
| ------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------- |
| 09/02/2016   | Detention and deporation of New Zealanders from Australia                                                                                            | 6(a)             |
| 30/03/2016   | Prime Minister's recent visit to Sri Lanka                                                                                                           | 6(a)             |
| 06/04/2016   | Communications regarding the 2016 US Presidential Election                                                                                           | 6(a)             |
| 25/05/2016   | Britain possibly leaving the European Union                                                                                                          | 6(a)             |
| 07/06/2016   | Panama Papers                                                                                                                                        | 6(a)             |
| 16/08/2016   | Decision to extend New Zealand's training mission to Iraq                                                                                            | 6(a)             |
| 2016 - 2017  | Intelligence and advice to the NZ government related to the 9/11 event                                                                               | 6(a)             |
| 2016 - 2017  | Record of OIAs from February 2017                                                                                                                    | 6                |
| 2016 - 2017  | Preparation for Trump Administration                                                                                                                 | 6(a), 6(b)       |
| 2016 - 2017  | NSS handbook examples of 1080 and domestic incident                                                                                                  | 6(a)             |
| 2016 - 2017  | The steel industry and trade issues                                                                                                                  | 6(a)             |
| 2016 - 2017  | Meetings with Australian officials on social security                                                                                                | 6(a), 6(b)       |
| 2016 - 2017  | Interactions with United States Film Industry representatives                                                                                        | 6(a)             |
| 13/04/2018   | Advice relating to Labour Party summer schools                                                                                                       | 6(c)             |
| 18/04/2018   | Weekly reports provided to the Minister for National Security and Intelligence                                                                       | 6(a), 6(b)(i)    |
| 20/04/2018   | Correspondence with the Office of the President of the United States                                                                                 | 6(a)             |
| 18/05/2018   | Information including individual costs of gifts given during visit to Europe and the UK                                                              | 6(a)             |
| 28/06/2018   | Prime Minister's diary                                                                                                                               | 6(a)             |
| 03/07/2018   | Records of meeting with former President of the United States                                                                                        | 6(a)             |
| 13/07/2018   | Documents received as Minister for Arts, Culture & Heritage, Minister for Child Poverty Reduction and Minister for National Security & Intelligence  | 6(b)(i)          |
| 24/07/2018   | Records relating to visit to NZ by former US Secretary of State Hillary Clinton                                                                      | 6(a), 6(c)       |
| 30/07/2018   | Correspondence with the President of the United States                                                                                               | 6(a)             |
| 11/09/2018   | Inquiry into the appointment process for the Deputy Police Commissioner                                                                              | 6(c)             |
| 03/10/2018   | Phone calls to heads of state                                                                                                                        | 6(a)             |
| 2018 - 2019  | Request relating to F-16 Lease Arrangement ERD Papers 14 March 2000                                                                                  | 6(a)             |
| 2018 - 2019  | Request relating to information held by the Department of the Prime Minister and Cabinet concerning extending NZ Iraq deployment                     | 6(a)             |
| 2018 - 2019  | Request about the Government's desire for greater transparency regarding military deployments                                                        | 6(a)             |
| 2018 - 2019  | Request about the status of information that was subject to previous Official Information Act requests (that's me!)                                  | 6                |
| 2018 - 2019  | Request relating to discussions referred to in published Aide Memoire about possible NZDF contribution to counter-ISIS coalition                     | 6(a)             |
| 2018 - 2019  | Request for a Government report into the hijacking of Air New Zealand TE24                                                                           | 6(a)             |
| 2018 - 2019  | Request relating to telecommunication issues associated with Huawei between 1 October 2017 and 30 September 2018                                     | 6(a), 6(b)(i)    |
| 2018 - 2019  | Request relating to the Cyber Credentials Scheme                                                                                                     | 6(a)             |
| 2018 - 2019  | Request relating to discussions referred to in published Aide Memoire about possible NZDF contribution to counter-ISIS coalition (follow up request) | 6(a)             |
| 2018 - 2019  | Request for briefings provided to Attorney-General in relation to the Five Country Ministerial and Quintet Meeting                                   | 6(a), 6(b)       |
| 2018 - 2019  | Request for information relating to white nationalism, and meetings with the Islamic Women's Council                                                 | 6(a)             |
| 2018 - 2019  | Request relating to DPMC policy advice and the Policy Project                                                                                        | 6(a)             |
| 2018 - 2019  | Request on various matters relating to national security and counter-terrorism                                                                       | 6(a)             |
| 2018 - 2019  | Request relating to advice provided to the Prime Minister on camps in Xinjiang, China                                                                | 6(a)             |
| 2018 - 2019  | Request for the number of National Assessment Bureau Employees, the number who speak Mandarin and Cantonese and the number with a security clearance | 6(a)             |
| 2018 - 2019  | Request relating to the July inter-agency cyber meeting                                                                                              | 6(a)             |
| 2019 - 2020  | Request relating to Moonshot CVE                                                                                                                     | 6(a), 6(b)       |
| 2019 - 2020  | Request relating to Y2K                                                                                                                              | 6(a), 6(b)       |
| 2019 - 2020  | Request for information relating to the Whakaari/White Island eruption on 9 December 2019 and the subsequent recovery operation                      | 6(a)             |
| 2019 - 2020  | Request regarding Zoom conference clearance                                                                                                          | 6(a)             |
| 2019 - 2020  | Request for titles and dates of formal reports relating to COVID-19                                                                                  | 6(a)             |
| 2019 - 2020  | Request relating to women's involvement in Radical-extremist groups                                                                                  | 6(a)             |
| 2019 - 2020  | Request relating to Asian organised crime                                                                                                            | 6(a)             |
| 2019 - 2020  | Request relating to the Trans-Tasman bubble                                                                                                          | 6(a)             |
| 2020 - 2021  | Request relating to Five Country Ministerial meetings                                                                                                | 6(a), 6(b), 6(c) |
| 2020 - 2021  | Request relating to foreign interference in the 2020 New Zealand General Election                                                                    | 6(a)             |
| 2020 - 2021  | Request relating to counter terrorism and the Royal Commission of Inquiry into the Terrorist Attack on Christchurch mosques                          | 6(a), 6(b)(i)    |
| 2020 - 2021  | Request relating to the Arotake Report                                                                                                               | 6(a), 6(c)       |
| 2020 - 2021  | Request for a copy of a briefing relating to 5G Security                                                                                             | 6(a)             |
| 2020 - 2021  | Request for briefings relating to Cyber Ransom and strengthening NZ's resilience to disinformation                                                   | 6(a), 6(b)(i)    |
| 2020 - 2021  | Request relating to ODESC governance boards and sub committees                                                                                       | 6(a)             |
| 2020 - 2021  | Request relating to briefing papers prepared for the Prime Minister on the sources of a book                                                         | 6(a)             |
| 2020 - 2021  | Request relating to documents on the governments COVID-19 response in 2020                                                                           | 6(a), 6(c)       |
| 2020 - 2021  | Request for briefings and Cabinet papers relating to New Zealand's involvement in Afghanistan                                                        | 6(a)             |
| 2020 - 2021  | Request for information relating to the Whaakari Event                                                                                               | 6(a)             |
| 2020 - 2021  | Request for correspondence with COVID-19 advertisers                                                                                                 | 6(c)             |

**Sources**
- 2016 - 2017: [FOIA Sections S6 (a) and S (6) b (i) - fyi.govt.nz](https://fyi.org.nz/request/4578-foia-sections-s6-a-and-s-6-b-i)
- 2017 - 2018: [Withheld / Rejected OIA Filings - fyi.govt.nz](https://fyi.org.nz/request/6763-withheld-rejected-oia-filings)
- 2018 - 2019: [FOIA Sections S6(a) and S(6)b(i) - Oct 2018 - Oct 2019](https://fyi.org.nz/request/11587-foia-sections-s6-a-and-s-6-b-i-oct-2018-oct-2019)
- 2019 - 2020: [FOIA Sections S6(a) and S(6)b(i) - Nov 2019 - Aug 2020](https://fyi.org.nz/request/13527-foia-sections-s6-a-and-s-6-b-i-nov-2019-aug-2020)
- 2020 - 2021: [[DPMC] OIAs affected by Section 6 | Aug 2020 - Aug 2021](https://fyi.org.nz/request/16579-dpmc-oias-affected-by-section-6-aug-2020-aug-2021)

---

[Spotted something wrong with the table or just want a copy of the data?](https://github.com/marcus-crane/utf9k/blob/main/src/data/metaoia.yml)

Job opportunities recinded due to this project: **2**