---
aliases:
  - /blog/eoy24-stack
category: blog
date: 2024-12-31T18:10:00+13:00
description: Here are my app defaults that I'm bringing with me into 2025
lastmod: 2025-01-03T14:05:00+13:00
slug: app-defaults-entering-into-2025
tags:
- tools
title: App defaults entering into 2025
---

I had originally begun writing this post as a way to phone in a post so I could keep up with my regular goal only to discover the next day that I had accidentally stumbled into a trend.

In all likelihood, I had seen [a previous post](https://kevquirk.com/blog/my-default-apps-at-the-end-of-2023) around this time last year and forgotten about it but that makes this much easier then since I can just use the existing template [as everyone else](https://defaults.rknight.me/).

- 📨 **Mail Service**: [Fastmail](https://fastmail.com)
- 📮 **Mail Client**:
  - Fastmail Web (for desktop)
  - Fastmail iOS (for mobile)
- 📝 **Notes**: [Obsidian](https://obsidian.md)
- ✅ **To-Do**: [TickTick](https://ticktick.com)
- 📆 **Calendar**:
  - [Apple Calendar](https://en.wikipedia.org/wiki/Calendar_(Apple)) (macOS/iOS devices) via Fastmail [CalDAV](https://en.wikipedia.org/wiki/CalDAV)
  - Fastmail Web (Linux devices)
- 🙍🏻‍♂️ **Contacts**: [Apple Contacts](https://en.wikipedia.org/wiki/Contacts_(Apple)) via Fastmail CalDAV
- 📖 **RSS Service**: [NewsBlur](https://newsblur.com/) + [Kite by Kagi](https://kite.kagi.com/)
- 🗞️ **RSS Client**:
  - Newsblur Web (for desktop) or occasionally Newsblur Desktop if I remember to open it
  - Newsblur iOS (for mobile)
  - Newsblur Android (for tablet)
- ⌨️ **Launcher**: [Raycast](https://www.raycast.com/)
- ☁️ **Cloud Storage**:
  - iCloud
  - Synology NAS (SMB) over [Tailscale](https://tailscale.com/)
  - [Backblaze B2](https://www.backblaze.com/cloud-storage) for archive exports (ie; social media archives) + CDN storage for this site
  - [Bunny](https://bunny.net/) for storing this site's rendered files
- 🌅 **Photo Library**: iCloud + replicated to Synology NAS and B2 using [icloud_photos_downloader](https://github.com/icloud-photos-downloader/icloud_photos_downloader)
- 🌐 **Web Browser**: [Zen Browser](https://github.com/zen-browser/desktop) on desktop and mobile devices
- 💬 **Chat**:
  - Various social networks via [Beeper](https://www.beeper.com/)
  - iMessage
  - WhatsApp
- 🔖 **Bookmarks**:
  - [Pinboard](https://pinboard.in) via web
  - [Pins](https://get-pins.app/), a Pinboard client for iOS
  - Some common bookmarks surfaced via [Glance](https://github.com/glanceapp/glance)
- 📑 **Read Later**: [Readwise Reader](https://read.readwise.io)
- 📚 **Reading**:
  - [Daylight Computer](https://daylightcomputer.com/) at home, using Readwise Reader
  - [Boox Tab Mini C](https://shop.boox.com/products/tabminic) away from home, using Readwise Reader
- 📜 **Word Processing**: Probably Google Docs but I don't think I did any word processing this year outside of work
- 📈 **Spreadsheets**: MS Excel but I only ever view spreadsheets outside of work
- 📊 **Presentations**: [iA Presenter](https://ia.net/presenter)
- 🛒 **Shopping Lists**:
  - [Woolworths NZ](https://apps.apple.com/nz/app/woolworths-nz/id1278164689) iOS app
  - TickTick
- 💰 **Personal Finance**: I have a couple of Markdown tables in Obsidian that are out of date but I haven't used anything for personal finance this year
- 🎵 **Music**:
  - Spotify for streamable music
  - [Plexamp](https://www.plex.tv/plexamp/) for unstreamable music
- 🎤 **Podcasts**: [Spotify](https://spotify.com)
- 🔐 **Password Management**: [1Password](https://1password.com/)
- 🤦‍♂️ **Social Media**: [Instagram](https://www.instagram.com/) is probably the only social media I've properly used, besides a handful of direct tweets?
- 🌤️ **Weather**: Apple Weather
- 🔎 **Search**: [Kagi](https://kagi.com)
- 🧮 **Code Editor**:
  - [Visual Studio Code](https://code.visualstudio.com/) for larger projects
  - [Neovim](https://github.com/neovim/neovim) for smaller, quick edits 
- 🍱 **Nutrition Tracker**: [Cronometer](https://cronometer.com/)
- 🚌 **Transportation Tracker**: [Transit](https://transitapp.com/)
- 📚 **Book Tracker**:
  - Currently Reading is stored as a yml file in the repo for this website
  - [Book Tracker](https://booktrack.app/) for tracking my want-to-read list
  - [Hardcover](https://hardcover.app/) as a current experiment in using a Goodreads-style service again
- 🪪 **VPN**: [Tailscale](https://tailscale.com/) but no traditional VPN beyond that
- 🗺️ **Maps**:
  - Apple Maps for browsing
  - Google Maps for directions
- 👨‍🚀 **MITM Proxying**: [Proxyman](https://proxyman.io/)
- 🚨 **External Notifications**: [Pushover](https://pushover.net/)
- 🤖 **Default LLM**: [Kagi Assistant](https://kagi.com/assistant) using [Claude 3.5 Sonnet](https://en.wikipedia.org/wiki/Claude_(language_model))
- 🛫 **Flight Tracker**: [Flighty](https://flighty.com/)
- 💳 **Loyalty Card Wallet**: [Barcodes](https://apps.apple.com/us/app/barcodes-loyalty-card-wallet/id1610894014)
- 📦 **Package Tracker**: [Parcel](https://parcel.app/)

## Change prediction for 2025

I'm pretty comfortable with most of the things listed on this page but I can guess a few things that might look different this time next year.

## Raycast

I've used Raycast for a couple of years now on macOS but to be honest, I don't really use it beyond what Spotlight provides.

I can see myself ditching it and probably not even noticing.

## Zen Browser

I started recently using Zen Browser which has come a long way in quite a short amount of time.

I had actually used Brave, with almost all of the optional junk disabled for most of this year but eventually ran into the issue of [Lobsters](http://lobste.rs) blocking it which you can read about if you're interested. I can understand the reasoning behind it.

Aside from those two, I've been keeping an eye on [Orion](https://kagi.com/orion/) for quite some time as it's a native macOS browser that has built in support for Firefox AND Chrome extensions. There are some interesting Firefox extensions like AdNauseum and uBlock Origin that either work better or just straight up work at all when using Firefox.

While Orion is a little wonky, I only really have one main blocker which is extension support for Readwise Reader. That is: The extension loads but doesn't work but then it's a wonder any of this work at all. There is a [bug filed](https://orionfeedback.org/d/2578-readwise-highlighter-extension-both-chrome-and-firefox-doesnt-work/12) so it might get some action this year but I'd have to see what other extensions I use might also be in a similar state.

Most interesting of all though is that Orion for iOS is able to load Firefox and Chrome extensions too which no other iOS browser (to my knowledge) is able to achieve. I do wonder what's stopping them though if it is technically possible as proven by Orion.

## Beeper

Beeper is what I use to message people on various different platforms instead of having to juggle all sorts of social media apps.

I've used it in the background on and off but this past year was when I had gone all in and it's quite nice.

There are still a few bugs here and there, some of which turned out to be bugs in platforms themselves that I mistook for being Beeper's fault but it's nothing breaking.

Beeper actually got acquired by Automattic this year, which is probably the least worst acquirer out there (all drama featuring Matt Mullenweg aside).

Shortly after the deal, they announced [a roadmap](https://blog.beeper.com/2024/06/04/2024-beeper-roadmap/) which outlined rebuilding iOS app to use entirely local bridges for sending and receiving messages.

As I just found out while writing this, the iOS app is actually in TestFlight right now and it seems quite a lot smoother at first glance so I can see myself leaning into it even more.

## Pinboard

I've used Pinboard for quite some time and don't necessarily have any issues with it but as I found out, profiles are currently hidden due to excessive crawling from bots.

I only found this out when I went to go share my profile with someone the other day and couldn't, as it requires a login.

Given I already have a bunch of self-hosted services, I might be tempted to give [Linkding](https://linkding.link/) a try as I really don't need much in a bookmarking service.
