---
category: blog
date: 2024-09-02T22:00:00+10:00
description: Reflections on turning 30
slug: "30"
tags:
  - meta
title: "30"
---
It's been about two weeks since I turned 30 so it seems like a pretty fitting milestone to do some sort of retrospective in the vein of [25](https://utf9k.net/blog/25).

30 has always been the "big" milestone in my mind because I've considered it the time when you're meant to "have things figured out" in some sense.

Not necessarily that I felt like I needed to have a house with a white picket fence, nor have ever particularly felt drawn to that sort of dream but I think it's more just I've imagind a train of sorts where I can make a bunch of mistakes in my twenties but I should really have figured things out, met someone and so on or else I'll miss the doors when it comes time for depature.

I should be completely clear that this is a silly thing to think and I actively have known and believed that things don't work this way but knowing something and accepting it are entirely different things.

It's probably more accurate to say that consciously I don't believe that there are many time limits on life, besides the ultimate one, but subsciously I probably don't believe it or I'm scared enough to get hung up on it.

Anyway, this isn't meant to be a psychology post but I bring it up because these sorts of posts don't really help me right now but they're more aimed to be a thing I can point to newcomers down the track to say "I had no idea what I was doing so you shouldn't expected to either!".

I would say the big overarching theme underlying a lot of my goals and troubles for the past decade have been trying to speedrun a career.

The short version is that I was a hobbyist for the longest time who didn't gain university attendance and had kind of given up on anything big.

I worked retail for a few years but figuratively and to some degree, quite literally went insane at the prospect of doing that for the rest of my life so worked up the savings to attend a development bootcamp in the mid 2010s.

That got me a decent base, aided by my hobbyist tinkering but it still took a lot of side projects, short contract stints and other things before I got my actual foot in the door.

From there, it's been pretty much just grinding work and not being overly invested in much else life wise, largely out of fear of having to return to my old life but also just my internal story that it's what I enjoy with the prospect of going on long holidays and other outings being lots of energy and boring.

Suffice to say that isn't true! I have had a bit of a bad run with vacations lately (falling sick and so on) but I'm currently writing this while on vacation and it's been nothing but great.

There are some other underlying factors that I won't really talk about too much but suffice to say, life has been more bland than greatly enjoyable I think which seems kind of poised to change!

Particularly in the later part of my 20s, I've had a few run-ins with my mental health as well which have been pretty upsetting as I've written about earlier but there are a few things that I think have become clearer over time.

First is practicing proper self-care. Now, historically, I would have handwaved this way, not because I don't believe in it but because my answer would have been "What are you talking about? I'm not mean to myself so it's not that".

The more I thought about it, I realised that while I'm not self-negative, I'm not particularly self-positive either. I'd describe it as more self-neutral or observational perhaps? I'm not exactly waking up and being my own hype-man by any means, probably in part because I (somewhat incorrectly) associate over-optimism with naivety which is definitely something I don't want to get wrapped up in.

You might imagine though if every time you were feeling less than ideal, you told a friend and they were always dismissed saying "Sounds fine to me" or "It's probably nothing", it wouldn't be particularly encouraging. Nothing about those words are negative but they're not positive either so if your inner talk isn't encouraging or having your own back then I can imagine it causes some trouble subconsciously.

Another thing is being careful to not attribute meaning to physical sensations which needs a little bit of unpacking.

Historically, from about my teenage years onwards, I've had some level of appetite issues. I've never identified as having any sort of eating disorder to be clear but I've always been a bit of a picky, sometimes slow, eater.

It's one of those things where it just sort of started at some point and it became a life default so you don't really *know* why it is a thing or remember if there was any instigating event.

Anyway, that had a huge knock on effect from avoiding dinners with others (which also put me off dating for a long time), not bothering to practice cooking (because it was just a chore when you don't enjoy what you create due to bad assocations) and other things.

As part of that, I ended up building a bit of a shortcut in my brain where if my stomach felt anything less than solid, I would interpret that as "This isn't going to go well" when in fact, I had no evidence for that at all.

It's not like I was telling myself this mind you, it's all sort of subconscious stuff that happens super quickly and if you're not paying attention, you don't really consciously think about it.

Long story short, I've come to terms lately that I tend to erroneously connect thoughts and feelings to how I'm feeling physically.

Let's say I'm not paying attention and I end up eating a whole block of chocolate. Rather than just physically feeling bad, I would start to feel a bit unsure of myself like without any trigger, I would start to feel like something bad might happen or that things are actively bad. If I'm not careful, I might start to draw conclusions while in this wonky mental state.

30 minutes later, my stomach might lead me to the bathroom and then I realise "Oh, that's all it was".

Your mind and your gut are connected after all, particularly as a lot of research in recent years is discovering. I've run the experiment enough times to be pretty certain that some amount of my troubles in recent years have just been due to bad diet influencing my mood without my actively realising it.

It all seems very obvious in hindsight but when you're in an impaired mental state, you don't really feel that better things are possible so there's no real motivation to live healthier so it persists in a cycle. Everything feels like a chore, including the thought of being healthy so why bother when you can just enjoy things that are nice in the moment but not great when it comes to the bigger picture.

With all this in mind, the last 5 years have been a kind of a blur where I've done a lot but I also feel like I've barely done anything at the same time.

I haven't had much of a true morning routine for the longest time, partly because it gets boring pretty quickly, but I like to think that I would benefit from one.

Given my line of work, I'm historically pretty bad at defending my own time so first thing when I wake up is usually checking Slack and other types of requests which is something I aim to get better at.

It's easier when you have a larger goal to work towards but a lot of my time has really just been deal with the thing in front of me or trying to provide a good level of service at the expense of, I dunno, remembering to drink enough water in the morning probably.

Overall, I would say I've probably been playing a bit more on hard mode than I need to be so my main aim going forward towards 35 is just taking better care of myself.

That's enough for now but I have plenty of other topics in the original outline for this post so maybe I'll touch on some of that in future.

Oh yeah, I gave the original 25 post a skim and I found it pretty funny how it was all about technology and nothing about the human side of things. I guess now we're completely on the other end where I never seem to write about computers on this blog!