---
category: blog
date: 2024-03-20T22:10:00+13:00
description: Present me thinks it's neat. Past me had to actually do the work so it sucks to be them.
slug: beeminder-is-neat
tags:
  - productivity
  - motivation
  - incentive
title: Beeminder is neat
---
Since around October last year, I started trying out [Beeminder](https://beeminder.com) and now, months later, I'm effectively a convert.

For the uninitiated, Beeminder is a service that lets you define some goals and then helps you stay accountable in achieving them.

The only real requirement is that both your goal, and progress towards it, is able to be expressed as a number.

With that in mind, let's look at a goal that I set up last year around my reading backlog.

![A Beeminder graph showing time on the X axis and articles read on the Y axis. The graph starts in mid October and has a slow, descending trajectory down to 10 with the goal ending around the start of February 2024](https://www.beeminder.com/utf9k/reader.png)

On the left near the top, we can see my goal started out at 100 articles to read and on the bottom right, my goal was to hit 10 articles or less.

Each time that I read an article, progress would be recorded and as we see, I slowly burned through at least one or two articles each day until I hit my goal.

In reality, my goal started out at about 50 and I would continually lower it each time I got close to finishing.

Now that sounds great and all but you're probably thinking "My problem isn't setting goals, it's sticking with them!".

That's where Beeminder really shines.

Whenever you fail to stay on track with your goal, you get charged real money!

Perhaps that sounds like a horrible idea but stick with me for a bit.

When you start a goal, you choose a starting amount to pledge in the event that you derail.

It generally starts out at $5 and then increases exponentially each time you fall off.

Eventually, you'll presented with an amount that sufficiently incentives you to stay on track.

This might sound completely miserable on paper but a neat effect starts to occur.

![A screenshot of the Beeminder UI showing a step graph with datapoints entered every month or so. The goal is writing blog posts.](https://cdn.utf9k.net/blog/beeminder-is-neat/blog-goal.png)

Here we have the very goal that is causing me to write this blog post.

On any given day, I would probably say "I don't feel like writing" but when I think about what I want to accomplish on a longer time scale, I think "I should really write more blog posts" so I can improve my skill at writing.

Because this goal has a price tag, instead of thinking "I have to do this or I'll be charged!", an alternative approach is to think ["Hmm, would I like to write or would I be willing to pay $5 to make it go away?"](https://blog.beeminder.com/depunish).

The next time the goal comes around, the price is raises on and on until I think "Actually, that's quite a lot, I would rather progress towards this goal than be charged such an amount.".

In reality though, the idea of being charged at all is enough incentive to keep me on track, but in a way that would probably be described as [eustress](https://en.wikipedia.org/wiki/Eustress).

Put another way, it's sort of like being constantly chased in a way that's just challenging enough to be healthy but not so much that makes you feel exhausted or overwhelmed.

On the best of days, I actually find it quite satisfying having checked off my Beeminder goals, even if I don't particularly want to do them, because I can basically point to any given graph and say "Look, I made tangible progress towards this goal".

I don't feel any guilt lounging around because I know that I've made progress (as proven by the graphs shown) and I know when a goal comes due, I'll be sufficiently incentivised to do it.

On the flipside, it's good to have goals that are effectively anti-productivity as well, which I sometimes am quite bad at.

![A screenshot of the Beeminder UI showing a step graph with datapoints entered every few days. The goal is watching movies.](https://cdn.utf9k.net/blog/beeminder-is-neat/movies-goal.png)

Often times, I think about watching through a movie on my backlog but I get caught up in "Ahh, it takes too long" which is silly given how many multi-season TV series I'll happily watch instead.

With Beeminder sufficiently incentiving me, I've broken the curse of inaction and started making a decent dent which also doubles as nice and relaxing as well.

I even have a goal to book a vacation every so often because it's something that I will very easily postpone because of X or Y reason that isn't really a blocker as much as I might think it is.

Anyway, this brings us to the real reason I'm writing this post and what really made me appreciate Beeminder.

About a month or so ago, I got some news that was a bit of a gut punch.

Nothing to be worried about but the sort of stuff that makes you want to climb into bed and merge with your pillows into a big blob.

"Everything sucks and I want to stay inside" is what I thought and the very last thing on my mind is making progress towards my goals.

While my drive to make progress might depend on my mood, my drive to avoid being charged money is fairly universal and that actually helped a lot!

On that day, my goal for watching a movie came due so begrudgingly, I fired up a film and oh hey, that was actually kinda fun.

The next day, I had a step count goal come due so I went for a walk and "Ah! I feel much better!".

Another reasonable response might also be to just throw my goals out the window and crawl back into bed but none of the presentation is personal enough to make me want to lash out like that.

Beeminder is just sort of there, showing me the price of not doing business and it's up to me to decide. Better still, I can do literally nothing besides whatever goals are due for the day and I can take comfort knowing I've made tangible progress.

In this particular case, it was a little bit of a fluke but if you get the staggering just right, it can make a big difference when it counts.

Ironically, I once complained about how [software usually fails to account for the user taking a break](/blog/who-is-software-even-for) and here we have a surprising case of the opposite: Software not letting me take a break was actually helpful in the long run.

Now I should mention that if you're not careful, you could over-eagerly set an overwhelming amount of goals and completely crush yourself so [there's an art to being reasonable](https://blog.beeminder.com/calendial/) of course.

The further you get into Beeminder, you'll want to [browse through the Beeminder blog](https://blog.beeminder.com/) which is a treasure trove of advice and concepts to read through but that's a story for another time.

Anyway, if you've been trying to set some goals and strugging to care enough in the moment to stick to them, I recommend giving Beeminder a whirl!

You can also [check out my own goals](https://www.beeminder.com/utf9k) if you want an idea of how it all looks in practice.