---
category: blog
date: 2023-12-31T15:20:00+13:00
description: Maybe one sector's recession is another person's happy place?
slug: scooter-disliker
tags:
  - scooters
  - capitalism
  - venturecapital
  - funding
title: A small reprieve from poorly executed ideas
---
I've spend the latter half of this year trapped in one of [Auckland](https://en.wikipedia.org/wiki/Auckland)'s pleasant ~concrete hellscapes~ suburbs and with that has come one of my new-found hobbies: wandering to the local dairy to pick up a newspaper.

It's more like an excuse to buy [iced coffee](https://www.bosscoffeeanz.com/), which is effectively just slow acting poison for someone who has a sour relationship with milk products, but I can't help it because it tastes nice.

Anyway, I was browsing through today's copy of the [Herald on Sunday](https://en.wikipedia.org/wiki/The_New_Zealand_Herald#Herald_on_Sunday) and I spotted [the following letter](https://cdn.utf9k.net/blog/scooter-disliker/editorletter.jpeg) to the editor.

The letter read as following:

> **Scooter near miss**
>
> I recently walked out of a supermarket and I barely missed getting hit by a speeding scooter travelling fast on a
> narrow pedestrian path, oblivious to anyone walking.
>
> Where is the sanity in mixing walkers with speeding vehicles?
>
> That is a path for foot traffic, not dangerous, speeding scooters.
>
> If there is any more evidence needed that the fabric of society, the management of which ensures some degree of order
> and mutual caring, is unravelling, just observe the lunacy of scooters on footpaths, zigzagging between frightened
> pedestrians, and the council doing nothing about it.
>
> — R Riccola, Albany

I should mention right off the bat that I've noticed some percentage[^1] of letters to the editor are people engaging in [astroturfing](https://en.wikipedia.org/wiki/Astroturfing).

A few times you'll search someone's name and find many letters to various editors that all follow the same talking points but I don't think that's the case here.

The main thing that caught my interest was that I also dislike scooters! 

Well, more accurately I dislike the free flow of venture capital that allows bad ideas to be executed at scale. Scooters themselves are fine when handled responsibly.

So what the hell am I talking about? Let me see if I can weave a bit of a tale on how we got here, at least as far as I understand it.

---

For most of 2010s, interest rates were [very low](https://qz.com/725992/us-bond-yields-have-never-been-this-low-and-we-looked-at-data-going-back-to-1786). Like, historically low and possibly they'll never be that low again.

If you were looking to borrow money, it was great news because for every dollar you borrowed, you only had to pay back a very small amount in interest. For better or worse, this meant you could borrow well beyond your normal means.

Why not borrow a few million and get that big, shiny mansion? Well, nothing lasts forever and you're still paying interest back each month.

If those interest rates were to go back up, suddenly going to be making monthly interest payments that could well be larger than your entire income before expenses as some have found out the hard way. At that point, you're in an impossible situation and bank will probably reclaim your asset.

Of course, if too many people were to do this, it would be socially untenable which is when you get government intervention regardless of whether the decision to borrow at the time was a bad one but that's something for another time.

On the other hand, if you already had lots of money, this presented a bit of a problem. If your money is sitting in the bank, you're gaining very little return compared to if you were to invest in something more active like the sharemarket or a business.

For entrepreneurs, this climate highly encouraged you to start a new venture because you had a lot of different institutions willing to give you money to build out your business ideas. The expectation being that in the future, once you're big and successful, they'll see profits in return for their earlier investment.

There is still risk inherent in quitting your job to start a company of course but with fund desperate to put their money to work, you generally got a better deal such as their taking a smaller portion of ownership than normal.

For institutions, there was more money freely available to lend out than there were founders to invest in. There was also very little risk to investing because you could probably just borrow more at an extremely generous interest rate.

Put these two things together and you get a climate that encourages all sorts of businesses to sprout up, including some of the weirder and wackier ideas that would otherwise have struggled to take off.

Most critically, some of these new companies would never survive under normal circumstances because they would run out of money before finding any customers or before they could build out a network.

Uber was perhaps the [most infamous example](https://americanaffairsjournal.org/2019/05/ubers-path-of-destruction/) of this. It's very attractive to order an Uber when the cost of one is much cheaper than that of a taxi.

To the end user, it's not at all obvious that the price they were paying is only a portion of the actual cost. Your trip across town may have been $5 but in reality, it could have been $10 with the other $5 being offset by outside investment.

Such a thing is highly anti-competitive (because how do you compete with someone who loses money) but a great deal of companies were able to survive for longer than they should have by adopting this strategy.

If you've taken an Uber recently and noticed that it costs a lot more, you might have an inkling of why that's the case, now that cash is harder to come by.

---

For those interested in reading more, perhaps the most infamous contributor to this mess has been the [SoftBank Vision Fund](https://en.wikipedia.org/wiki/SoftBank_Vision_Fund), a venture capital fund with an [eccentric](https://en.wikipedia.org/wiki/Masayoshi_Son) founder.

The Vision Fund, equipped with billions to throw around, partly funded a bunch of [famous (and infamous)](https://en.wikipedia.org/wiki/SoftBank_Vision_Fund#Notable_investments) startups towards the end of the 2010s although they aren't the central cause by any means.

Alongside SoftBank, a huge chunk of the fund was [contributed by Saudi Arabia](https://www.bloomberg.com/news/articles/2018-10-05/saudi-crown-prince-discusses-trump-aramco-arrests-transcript), a country that has historically been dependent on oil but is looking to diversify as the world seemingly moves away from oil as a key energy source.

---

Anyway, what does this all have to do with scooters? I'm going to wrap this up because I'm getting bored of writing so there's a few threads I'm going to complete leap over here.

Scooters aren't new but their rise in popularity is probably an unfortunate side effect of some of the wackier business ideas that were funded over the last decade.

For those of us in New Zealand, we might have forgotten but before scooters, we had [OnzO bikes](https://thespinoff.co.nz/auckland/31-10-2017/what-are-all-those-black-and-yellow-bikes-doing-on-aucklands-bike-racks), which had initially popped up without a trading license.

This model of distribution, that is just dumping a bunch of shit on city streets and not caring out regulations, was a pretty popular model for bikes and scooters during the last decade and probably lead to a lot of adoption that otherwise wouldn't have happened.

In my mind, I've tended to draw a straight line between "Easy access to money for ideas" and "Companies engaging in reckless behaviour".

All this monetary business like interest rates tends to have a bit of delay and we've seen that a bit with numerous layoffs by [tech companies across 2022 and 2023](https://techcrunch.com/2023/12/21/tech-layoffs-2023-list/).

With all this in mind, reading that letter at the start made me wonder:

Now that things kind of suck a bit for companies again, we probably won't see any of the weirder companies but we also won't see as many of the riskier, more reckless companies for a while.

I don't know whether e-scooters are a viable industry. I guess they've already purchased the scooters so it's not like they're paying a recurring cost beyond repair and replacement but maybe it costs more than they make and they'll go under.

I wouldn't mind a nice quiet break from potentially being knocked over on the street.
