---
category: blog
date: 2023-04-11T19:00:00+13:00
description: Here are some things that have been bothering me
slug: i-dont-identify-as-anxious
tags:
  - health
  - longterm
  - selfcare
title: I don't identify as anxious
---
This is my [epic treatise](https://apenwarr.ca/log/20171213) on the things that have been troubling me for some time now.

Like all of my most personal blog posts, you can expect this one to be at times flippant, absurd and other big words that I have to Google just to double check that I have the meaning correct.

Admittedly, I thought I had written something a bit closer to home, as far as mental health but it turns out that my [previous attempts](https://utf9k.net/blog/let-your-streaks-end-naturally) were much more abstract than I remember.

On some level, I write this for myself with the naive thought that I can capture all these feelings in a bottle and discard them, not unlike a [camera stealing a soul](https://oxsci.org/can-a-camera-capture-your-soul/). Perhaps I'll read this in future but really, I take some small comfort that perhaps this will be a useful barrier break for anyone who has a false idea of me in their head.

Whatever I may have been able to live up to so far, this is hopefully proof enough that "success" by whatever means you define it is built on top of a great deal of well, whatever _this_ is, I don't enjoy it.

Anyway, that should be enough of a pretentious introduction to shoo away anyone with a short attention span.

As of late, I have had a handful of panic attacks. I don't think I use that word lightly. The feeling is that my entire body goes nuclear hot, where I'm borderline sweating. I might be shaking physically and usually I end up vomiting just due to the amount of nervous shaking upsets my stomach.

It's really not very nice! It kinda sucks!

This has only happened a few times in the past 6 months or so which is actually very rare but there's a bit of a catch.

From time to time, and today as I write this, I'll catch myself remembering those feelings. It's sort of like a mind virus. You can ever so slightly remember the feeling and then you can start to imagine yourself feeling it again. You feel a light flush. Oh no, it's back isn't it? It was always coming back. It was inevitable.

These are things that aren't true but the trick that I am still learning is to quieten those voices. I don't even think telling them to go away is the right approach. They're all valid things that are worth accepting while pushing back on the idea that they are set in stone.

It would perhaps be easy to "think positive" but so much of this all feels like it's subconscious as far as I can tell. Perhaps it's not but I just can't hear the voice that is causing all this. How can I "win" a battle when I can't even see the battlefield or my opponent. Well, again for the me 2 paragraphs ago, it isn't a battle is it.

These feelings are me and I am these feelings but I don't have to lay down and let them run rampant. It's easier to say that when you have a clear head.

Perhaps we should go over some specifics:

I'm 28 as I write this and I assume part of this stems from anxiety about turning 30. Turning 30 itself doesn't scare me but there are all these little things in my head that I think I associate with having "made it".

Already this is stupid. I have a good paying job and I'm (allegedly) respected at work. I have minimal to no debt and I can toot my horn about having gone the hard route of not getting a degree. What does making it even mean? I have very little to genuinely worry about each day.

I got my restricted drivers license (Stage 2 of 3) when I was about 16 but I put off my final test so I haven't driven for like 12 years. Part of me probably feels like I need to resolve all this so I can be self sufficient and all that. Successful people drive don'tcha know.

I'm single but I've always been happy with my own company. Haven't I? We had a lot of good times right? I never thought I minded but all of a sudden, it can get awfully lonely when you're going through all this. It's scary to live alone and you freak out at night. There's no one around to talk to. Minutes can feel like hours and hours like weeks. Sleeping it all off would be a wonder except your body is primed to the brim with adrenaline so cross that off the list. I got a little teary writing this.

I can only imagine that these things are all in there somewhere contributing to this troubling period. You'll be great and things are normal but suddenly you remember that you remember that you remember and it's the darkest few hours of your waking existence. Why is this happening again? If I can just find the answer, will it leave me alone?

The hardest answer, when I think over all the things that frighten me, is that I have to do all of this _waves hands_ for the next 70 years or more. I think that only to rebut myself in the same sentence with "What's so bad about that? There are so many things to see and do!". It's the feeling of dread persisting at its core, I'm sure.

I'm not an anxious person? I don't identify as such but factually, that might be correct? I don't know, is it anxiety? It's irrational for sure. It's like I'm scared that I'm scared and I don't know where it starts and ends.

I thought I'd tackle it normally. I had some more severe bouts that were exponentially worse back when I wrote [Ride the Curve](https://utf9k.net/blog/ride-the-curve). By all accounts, I've almost won, right? The symptoms are a whisper of what they were and the distance between them is ever shorter but when it pops up, I just want to give up.

Perhaps I'll ask my doctor if I can go back to [what helped break me out last time](https://en.wikipedia.org/wiki/Escitalopram). I don't take any pride in fighting mental illness on hard mode. I don't wish it on anyone.

I dunno, I'll go about my day and things are great. Great is a strong word. Things are fine. Maybe I need more novelty in my life. It's the remembering that this whole ordeal exists that opens the door ever so slightly for doubt to creep in. It could happen again so why wouldn't it, right?

I've been even stronger in reassuring myself that there are so many possibilities and that it's just my brain playing tricks but it's exhausting. Trying to self-monitor your own thoughts is exhausting. Your brain is effectively playing dual roles where you're watching yourself in third person.

Writing this has made me go up and down a bit where I'm a little jittery but who knows, that could just be the cold that's creeping in and I'm unintentionally feeding the nuclear fire with all these inputs that are unrelated. While things are quiet, I think I'll go to bed early. Napping is great. I wish I had more time this afternoon but I don't want to risk staying up. A thought crept in that today was going to be one of the very bad ones. Let's hope it isn't true.

If you read this far, I appreciate the effort. I'm sure I'll be fine in the long run. While all these emotions were fresh, I wanted to capture them down since they're hard to explain. I don't even know if any of this makes sense since I write these sorts of posts off the cuff with no editing.
