---
category: blog
date: 2022-06-03T23:35:00+13:00
description: In which we investigate whether the demo content loaded onto iPads is owned a single fictional person
slug: ipad-canonical-owner
tags:
  - apple
  - mystery
  - ipad
title: Do demo iPads have a canonical owner?
---
A few years ago, I ordered a 4th generation Apple iPad Air and the store I purchased it from accidentally sent me a demo unit.

It was a fully working iPad but it came preloaded with a number of dummy items such as a five calendars, a handful of documents and acres of photos.

You can see these in any store but generally, you never get a chance to spend any length of time with them so making the most of this opportunity, I took a full backup of the device before resetting it.

![A photo of an iPad Pro set up for display inside of a Noel Leeming store. Visible on the iPad is the Photos app set to the time period spanning 17 - 25th July 2019](https://cdn.utf9k.net/blog/ipad-canonical-owner/storedisplay.jpg)

A few days later, the store got in contact with me and requested that I return it back to them since it wasn't meant to be dispatched. They didn't have any other units on hand so I ended up getting a refund instead.

Anyway, I figured it might be of some interest to someone so I [uploaded a copy of the demo materials to the Internet Archive](https://archive.org/details/i-pad-demo-backup) and never got around to doing anything more until now.

Something that I had wondered was if any of the content in the device was actually intertwined or if it was just a random helping of documents.

The short answer is that it is mostly just random items but each category of item tends to have been created from the point of view of a single person which is kind of neat.

I'll be doing a brief rundown of what I found and what I could infer from the demo content about each fictional person as best as I can.

Some of the data is meaningless outside of the demo unit such as Photos which were grouped such as two images that were under the "Selfies" category but I can't recreate that information with the photos themselves so this post can't be as extensive as it could have been but ah well, I mainly want to get this post off of my project backlog once and for all!

## Calendars

We'll start with the juiciest of all the categories first since the rest are fairly light on detail. We can infer quite a bit from the calendar from the various locations attached to events.

![A screenshot of the macOS Calendar app visible on the author's computer. 11 events are visible across five different calendars.](https://cdn.utf9k.net/blog/ipad-canonical-owner/calendar.jpg)

Loaded onto the demo unit were 5 calendars which are available as [ICS](https://en.wikipedia.org/wiki/ICalendar) exports for browsing with any Calendar client.

As far as I can tell, the calendar events consist entirely of recurring events which makes sense for a demo unit which may sit around for a number of years.

The five calendars available are called `Kids`, `Personal`, `Recreation`, `Training` and `Work`.

I'll mention in advance that a number of locations are mentioned in the calendar entries which are mostly real places around California so I dig into those a little bit.

We'll work through them in order:

### Kids

![A screenshot of the macOS Calendar app visible on the author's computer. The Kids calendar is selected.](https://cdn.utf9k.net/blog/ipad-canonical-owner/kids.jpg)

There are only 3 events on the kids calendar which are as follows:

- Adam's Piano lesson from 3:30pm - 4:30pm every Tuesday
- Ellie's Soccer Game from 6:00pm - 8:00pm every Wednesday
- Adam's Soccer Game from 11:00am - 2:00pm on every 5th Saturday

We can infer that this person has two kids: Adam and Ellie. Both play Soccer and Adam plays the piano.

The description for `Ellie's Soccer Game` mentioned `At Mount Tiburon High School - back field on the left.` in the description for the event but as far as I can tell, there isn't a Mount Tiburon High School.

[Tiburon](https://en.wikipedia.org/wiki/Tiburon,_California) is a real town in California that has a Mount Tiburon Road but no high school.

Interestingly, Tiburon is apparently home to [St. Hilary School](https://en.wikipedia.org/wiki/Tiburon,_California#Schools) which is an [Apple Distinguished School](https://www.apple.com/nz/education/k12/apple-distinguished-schools/) but it's probably a coincidence.

### Personal

![A screenshot of the macOS Calendar app visible on the author's computer. The Personal calendar is selected.](https://cdn.utf9k.net/blog/ipad-canonical-owner/personal.jpg)

This calendar is home to a few generic events such as "Pay Bills" and "Doctor's Appointment".

There are a number of lunch and coffee catchups and they tend to be at real places:

- Lunch with Pablo at [Michael Mina](https://www.michaelmina.net/restaurants/) every 2 weeks
- Lunch with Becky at [Yank Sing](https://yanksing.com/) every 7 weeks
- Lunch with Mum at [Bistro - South Park](https://hoodline.com/2017/09/french-bistro-south-park-cafe-to-bid-adieu/) every 4 weeks

There are some other catchups but none of them feature any locations

### Recreation

![A screenshot of the macOS Calendar app visible on the author's computer. The Recreation calendar is selected.](https://cdn.utf9k.net/blog/ipad-canonical-owner/recreation.jpg)

This calendar is what it says on the tin and features a number of locations as well:

- Lunch with Lucy at [Yank Sing](https://yanksing.com/) every 3 weeks
- Bowling at Biltmore Lanes every month.
  - I couldn't find any information on Biltmore Lanes if that's a real place.
- Neighbourhood Council at Community Centre on the 4th month of every Sunday
  - The community centre in question is not named but perhaps you could triangulate one by cross-referencing the locations the calendar owner visits?
- Yoga at [2nd Street Gym](https://2ndstreetgym.com/) every 3 weeks
- Brunch with Mindy at [Zazie](https://www.zaziesf.com/) on the 1st Sunday of every month
- Tennis with Katy at the 4th Street Courts every 3 weeks

### Training

![A screenshot of the macOS Calendar app visible on the author's computer. The Training calendar is selected.](https://cdn.utf9k.net/blog/ipad-canonical-owner/training.jpg)

I expected this calendar to be full of gym sessions but instead it's a work calendar.

I'm not sure who the training is in reference to, or if this calendar is even accurately named since it seems like a bunch of business meetings more than anything.

We've got the following events:

- Design Team Staff Meeting: "To review designs for this week's exec meeting and discuss remaining designs needed."
- Review Graphic Design
- Review Presentation with Susan
- Project Planning Meeting: "To discuss project plan and review milestones and deliverables"

None of this appears to be training unless it's training for design team members perhaps?

From this, we can infer that this person is perhaps some sort of product manager?

### Work

![A screenshot of the macOS Calendar app visible on the author's computer. The Work calendar is selected.](https://cdn.utf9k.net/blog/ipad-canonical-owner/work.jpg)

This is definitely the fullest calendar with a number of business meetings and catchups.

We've got the following:

- Weekly Team Meeting: "To discuss project status and deliverables. Please bring status on each deliverable due this week."
- Conference Call with Exec Team
- Budget Review: "To review budget plans for upcoming projects"
- Design Review
- Team meeting
- Contract Review with Allison
- Executive Briefing
- Expense Review: "To review this expenses to date and discuss plans for the next phase of the project."
- Meeting with Sales Team

It's all very generic as to what this person's role is but of course, this is all stuff designed to be glanced at for a couple of seconds if at all.

There's also a monthly entry for "Pancake Breakfast" at "St. Mary's" but I couldn't find any such place in the [Bay Area](https://en.wikipedia.org/wiki/San_Francisco_Bay_Area).

## Contacts

There are 238 contact entries provided in two formats: [VCF](https://en.wikipedia.org/wiki/VCard) and [ABBU](https://fileinfo.com/extension/abbu)

![A screenshot of the macOS Contacts app visible on the author's computer. A contact entry for Shota Aoyagi is selected. They have an iCloud email and allegedly live in Rochester, New York. Their contact card has a stock photo.](https://cdn.utf9k.net/blog/ipad-canonical-owner/contacts.jpg)

The vast majority of contacts have addressed all across the United States of America with a handful that have addresses in Australia.

Given I live in New Zealand, I'm guessing that demo units have a handful of regionalised entries.

I couldn't determine any link between the contact entries and other categories ie; no one from the Contacts list appears in any of the Calendar entries or in the Summer Garden Party attendee list that we'll be covering later on.

That said, I did google a number of the names and they all appear to be Apple employees in some capacity but with stock avatars and made up contact details of course.

## Notes

These were loaded as [Apple Notes](<https://en.wikipedia.org/wiki/Notes_(Apple)>) but there's no standard format so they were all exported as PDFs. They're mostly intact but some formatting got mangled in the process.

![A screenshot of the macOS Preview app showing a PDF. The PDF is an exported Apple Note showing a sketch for a treehouse. The note is titled "Jake's treehouse!!"](https://cdn.utf9k.net/blog/ipad-canonical-owner/notes.jpg)

There's a note for `After-school activities for Jake` containing a checklist of sports so presumably this person is helping their son to decide on a sport. Interestingly, one of the entries is "Footy" which is a slang term for [Australian rules football](https://en.wikipedia.org/wiki/Australian_rules_football) so I guess this note is localised a little bit.

It seems this person is building a back porch based on the `Back porch dimensions` note with another title `Garden proposal from our architect` which details where to lay out plants around their "back patio". I would note that porch isn't really a term used in [Oceania](https://en.wikipedia.org/wiki/Oceania).

Keeping with the renovation theme, we also have notes for `Trees/Plants for front garden`, `Things to do for salsa garden`, `New dishwasher options`, `Living room remodel ideas`, `Kitchen` (renovation) and `Get at hardware store`.

While I noted before about the mention of "Footy", there are a few holiday planning notes that are all in America. The note `Ideas for US reunion w/ Dave and crew` has an entry for New York City that reads as follows:

> We all met here and we all love this city, but maybe not the best choice for a week of catching up over old times.

The use of the term "this" implies that the person writing these notes currently lives in New York City but a few notes contradict this idea because they feature measurements in centimetres. America is one of the few countries that [doesn't make use of the metric system](https://en.wikipedia.org/wiki/United_States_customary_units) so this doesn't quite add up.

A few holiday notes seem to center around California which definitely lines up with the general Apple-adjacent locations that appear through the demo unit.

A note titled `Soccer practise times`[^1] contains practice times for Zoe and Ella who, in addition to Jake, are presumably the three children of the author of these notes.

The practice times mentioned take place at [Santa Rita School](https://www.santaritaschool.org/santaritaes/6993-Address-Directions.html), [Covington School](https://www.covingtonschool.org/ces/4740-About.html) and [Rosita Park](https://www.losaltosca.gov/recreation/page/rosita-park) which are all real places in [Los Altos, California](https://www.losaltosca.gov/).

If you check on a map, Los Altos is a short drive from Cupertino, which is home to [Apple's donut headquarters](https://en.wikipedia.org/wiki/Apple_Park).

Beyond the above, most of the notes don't really tell us much about the author besides the fact that they have three kids it appears.

## Numbers

There is a planning spreadsheet for a Summer Garden Party available as a [Numbers](<https://en.wikipedia.org/wiki/Numbers_(spreadsheet)>) file.

![A screenshot of the macOS Preview app displaying a preview of a Number spreadsheet. Visible is a planning document for a garden party which lists a number of hosts and guests. A number of tasks are planned to be done between June and July. There are 4 sheets in total.](https://cdn.utf9k.net/blog/ipad-canonical-owner/numbers.jpg)

There isn't much to say about this other than it's a planning document for a party. I cross-referenced the names with the Contacts entries and while there were some shared names, I don't think they were the same people.

One thing I was able to infer was from a section on the "Budget" sheet titled "Useful Contacts".

It lists a number of party-related businesses such as "Joe the Juggler" and "True Cook" catering. All of the phone numbers feature area codes from around the New York area.

## Pages

This is a document on the [Leaning Tower of Pisa](https://en.wikipedia.org/wiki/Leaning_Tower_of_Pisa) created with [Pages](<https://en.wikipedia.org/wiki/Pages_(word_processor)>). It's available as a `.pages` file as well as a PDF export.

![A screenshot of the macOS Preview app displaying a preview of a Pages document. Visible is a page about the Leaning Tower of Pisa. It talks about the history of the tower and how it wasn't always leaning.](https://cdn.utf9k.net/blog/ipad-canonical-owner/pages.jpg)

It appears to be a school report since it's relatively accessible and light on details. The cover page says that it's by "Mariana Lin".

There is a "Mariana Lin" in the Contacts list but I can't say whether there's any relation since we know that the names features don't align with the contact details, being Apple employees.

## Slides

This is a presentation on [Yellowstone National Park](https://en.wikipedia.org/wiki/Yellowstone_National_Park) created with [Keynote](<https://en.wikipedia.org/wiki/Keynote_(presentation_software)>) and available as a `.key` file.

![A screenshot of the macOS Preview app displaying a preview of a Keynote slide. Visible is a picture of Old Faithful, a geyser at Yellowstone National Park. The slide talks about what makes geysers spew water.](https://cdn.utf9k.net/blog/ipad-canonical-owner/slides.jpg)

The presentation is attributed to Jamie Wong, Lauren Kerr and Greg Novick, none of whom appear in the Contacts listing.

I assume it's also meant to be a school presentation as it's pretty light on detail. I didn't check if there are any presenter notes but I'm guessing there probably aren't.

Interestingly, running [`strings`](<https://en.wikipedia.org/wiki/Strings_(Unix)>) across the file throws up a reference to `Data/GettyImages-451901451-8851.mov` so it might include a video which would explain the beefy 236.5MB file size. I couldn't tell where it features from using Preview and I don't currently have Keynote installed.

## Maps

The installed version of Apple Maps contained 25 locations saved which were exported as a [webloc](https://fileinfo.com/extension/webloc) file that can be imported into Apple Maps.

![A screenshot of the macOS Maps app. A map collection titled "iPad Demo Unit Places" is selected on the right. Visible in the main window is North America which depicts a number of bookmarked locations.](https://cdn.utf9k.net/blog/ipad-canonical-owner/maps.jpg)

You can actually view all of the locations on the web [here](https://guides.apple.com/?ug=CglNeSBQbGFjZXMSDgiuTRCvqe7D1Ny%2B0c8BEg0Irk0Qz%2FvZ4ZWbx9tBEg4Irk0Q07KFg%2F%2FQ%2BrnQARIOCK5NEMeAvZu8zOeUtwESDQiuTRDI4rigp6nsmwoSDgiuTRDo%2Fqe%2FvObuqOkBEg0Irk0Q5K%2FmsO64yJlxEg0Irk0Q8ayI64Pohv4OEg0Irk0Q09rW7Kq%2BiJhkEg4Irk0Q4IWIktWzuN%2FrARIOCK5NEN%2FqnrONnc3%2FtQESDQiuTRDDnK%2Ffxefylm4SDgiuTRDO%2BLmCgoX4hIkBEg0Irk0QlqLPz%2B%2FCqu8kEg4Irk0Qxqnl%2FNTUhb3KARINCK5NEOjYh9WIyM7IQBINCK5NEMWgq%2BbIqN%2FzBBINCK5NELWBwaT3lZ7lFRINCK5NEOa0h4ye9qb3IhIOCK5NEL3vkc6h0JrS4wESDQiuTRCJidXtgZHQ4gQSDgiuTRCl45zH%2F5%2BYqfwBEg0Irk0Qs6KWyKqUs94NEg0Irk0Qy47O5vuQt5BgEg4Irk0Q8tnK55HulOvfARIOCK5NELKK3MOW3YeIhgE%3D) which is the link contained by the `webloc` file.

## Photos

As mentioned at the start, there are a great deal of photos but a lot of useful metadata requires them to be loaded into Photos.

![A screenshot of the macOS Finder app. Visible is a photo of a dog with metadata about the photo visible on the right side.](https://cdn.utf9k.net/blog/ipad-canonical-owner/photos.jpg)

They all have their original metadata which is interesting since there are a range of iOS devices used to take photos, not that I could ever take photos that nice with my own phone.

There are 437 photos in total although upon a quick skim, there are actually a couple of [mov](https://en.wikipedia.org/wiki/QuickTime_File_Format) videos as well.

## Conclusion

Overall, this post wasn't particularly interesting to create but I figure it's useful to capture since the odds of getting a demo unit are probably not that great.

Each category of file tends to have been created from the point of view of a single person so it'd be interesting to know how much detail went into determining each persona in order to inform what the content should look like.

I also wonder what team would be in charge of preloading fake content onto a device. I guess it would fall into the realm of marketing?

That'd be kind funny telling your parents like "Yeah, I make fake content for iPads" or something.

Anyway, as mentioned, I'm glad to finally cross this project off my list and delete these files from my desktop so they'll stop judging me.

Once again, you can download all of the files referenced in this post [over on the Internet Archive](https://archive.org/details/i-pad-demo-backup).

Enjoy!

[^1]: The typo is part of the title
