---
category: blog
date: 2021-11-28T15:04:00+13:00
description: "It really is what it says on the tin: I have some thoughts about crypto"
slug: brief-thoughts-on-crypto
tags:
  - blockchain
  - cryptocurrency
  - nft
title: Brief thoughts on crypto
---
It shouldn't come as any surprise that I don't consider myself a fan of blockchain derivatives such as cryptocurrencies and NFTs.

In short because when 1 unit of a currency is worth $54,000 at the time of writing, that sounds more like an investment vehicle.

Sure, you could go around having conversations like "Thanks, that'll be 0.0000034 tokens for this loaf of bread" but at that point, it feels like the same problem as people who forget code, written in English, is for other humans and not for the computer.

My head would hurt having to append 5 decimal places to everything just to participate in basic economics.

Anyway, that isn't really what got me to sit in my chair for once and start typing away.

As far as I understand it, the promise of NFTs is that you can buy a token that certifies you as the authenticated owner of something unique. At the moment, it's primarily pieces of art that have been automatically generated but they're 100% unique.

No one has the exact same artwork as you do, unlike say; buying rare sneakers because even for businesses, the economics of producing physical things means a production run of just one probably isn't worth it.

Yes, there's the whole right clicker component but that has already done to death so let's just put that aside for a minute.

The thing that really confuses me is this uniqueness aspect. I mean, I _get it_ like the idea of being the sole owner of something is appealing to an extent but I don't know where it ends.

Like, ok, hundreds of people have generated thousands of images, all of them slightly different in their own way but what gives it any value?

It's more than just images though, it seems to be extending to just anything and everything from [memes](https://foundation.app/@DisasterGirl/~/25046) to [meals](https://twitter.com/McDonalds/status/1455174998264586243).

If we follow this down its logical path, why not sell individual atoms or points in history? None of these things have to actually be tangible or [reachable](https://www.moonestates.com/) to command a market price.

I guess I sort of get it, if I squint a bit, from a individualist, "I would be cool to own X" point of view but philosophically, it feels like an entirely pointless exercise.

If everything has a value, does anything have a value?

Probably this is just human behaviour as old as time in a new form though. It's not really any different than getting a trading card with your favourite sports player on it from your cereal box except it just so happens to be generated from scratch.

It's funny though like one segment is the idea of interactivity between games such that you could bring a character model (you would own the NFT of it as proof?) into any game.

I'm sure the coolest character model would cost like $200,000 but for a small fraction of that price, why not just hire an artist to create and rig a character model for you and issue yourself an NFT or whatever.

Anyway, it's all made up of course. Maybe I'll check myself into the virtual insane asylum down the line.

I'll end on a slightly related story from a few years ago where attended a bitcoin meetup back in like 2016 in [Wellington, New Zealand](https://en.wikipedia.org/wiki/Wellington). Some guy speaking was talking about how he was selling electricity back to the grid from his solar panels.

He went on to depict a future where everyone has their own solar panels and they buy electricity from their neighbours and everyone is an individual actor in the electricity market.

Sure but that sounds exhausting doing it for every facet (gas, water etc) of home living. Surely, you would be tempted to outsource it to someone really into those things to run for your town and then it becomes their day job to manage for everyone. You just pay them monthly and they provide electricity.

Fast forward though a few mergers, bankruptcies and so on and hold on a minute, we've just reinvented our existing infrastructure!

It all feels very silly like we're just reinventing everything but worse and more convoluted.

I'm going to have a nap.
