---
category: blog
date: 2021-10-27T12:01:00+13:00
description: Thoughts as I enter the third job of my career in the software industry
slug: day-two
tags:
  - career
  - reliability
title: Day Two
---
I've recently started as a Senior Site Reliability Engineer at [Lightspeed](https://lightspeedhq.com/) which means that it's time for the sequel to [Day One](/blog/day-one).

For the uninitiated, I write a new post summing up the excitement and concerns I have whenever I start a new job.

I'm not actually sure if I've ever explicitly noted that this is intended to be an ongoing series but yeah, ideally I write a new entry every time I start a new job going forward.

The idea is that I can look back and laugh at how much I did or didn't know. I realise that from the shoes of a beginner, it's easy to assume that long timers are magically gifted or Just Knew It All so in the event I make it somewhere interesting, this generally serves as proof that I had my doubts along the way.

I'm actually quite overdue with this entry since I'm a little over a week into my new job already. I'll probably keep it kind of brief as well since I keep staying up late[^1] but I did make a couple of quick notes that I'll try to address.

Anyway, let's get started.

## Interviewing

I actually don't mind interviewing so much these days but I do dread the idea of getting some overly technical, google-esque interview. I never took computer science[^1] so if you ask me about B-tree's or whatever then I'm out.

As a matter of fact, an interview prior to the ones with Lightspeed had me trying to write a sudoku solver. I gave it a crack but I didn't have much to show so 10 minutes before I end, I just ended it early to save myself the humiliation. That said, I pretty confidently said that I don't enjoy this stuff, I'm comfortable saying as much and it doesn't reflect what I do day to day anyway.

Thankfully, I got to show a bit of everything across the stack in the Lightspeed interview with even a bit of frontend polish just for kicks :)

It definitely wasn't required but I opted to spend a bit of time on it. It's good practice for sprucing up my website anyway.

## My first day

These posts don't generally show when I've started but it's probably a bit more appropriate (and relevant) of a timespan as my career progresses.

I had a poke around a bunch of Slack channels and was in two minds.

Firstly: wow, there's some really cool best practice stuff going on. Secondly: Ahh geez, everyone is definitely going to be smarter than me and doing well crafted stuff while I'm super rusty.

Thankfully everyone is really nice and the onboarding has been pretty comprehensive.

## SLOs

Funnily enough, I saw a bunch of SLO monitors and my eyes probably dilated a bit.

Back at [Xero](https://www.xero.com/nz/), my team helped push the introduction of SLOs and I was in the SLO space for the better part of a year and a half and I still feel like I've forgotten all of it in some capacity, haha.

It's really stupid like I've run 3 part workshops on SLOs + alerting, helped teams instrument their products and my brain is still like "I"m very unqualified in this space".

I'm sure this happens with most every domain anyway. Once I get back into it and brush up on source material again, I'm sure I'll remember all the niche details.

I still such at math, and by extension statistics and what not though.

Realistically, I'm probably just scared that people will ask me questions on the spot I won't have the answers to, as if that's how it would go down. I also have an entire team I'm part of so that's a dumb story to tell yourself.

## Work life balance

This time around, I'm definitely focusing on clocking in and out near enough on time.

That's not to say I dislike my job, quite the opposite in fact. Thinking that the more hours you do magically correlates to more productivity is a lie. Productivity in general is a lie anyway. I have enough green cubes on Github without even trying, thank you very much.

My thoughts on this currently would just be a regurgitation of [Four Thousand Weeks](https://www.oliverburkeman.com/books) by Oliver Burkeman.

It looks like a self help book but it's not. Just a reminder that always striving towards things, for the sake of "productivity", is not a good idea generally. It's worth a read!

## Job titles

It took me about a good week or so to put the "Senior" prefix in my bio and even then, I self-deprecatingly tacked "(allegedly)" on the end.

I think of myself as a Junior Senior, in that I just acquired this title but I guess it was bestowed upon me by passing a test so I guess I earned it?

I dunno, I feel the same and I often forget that I've quote unquote made it.

I try not to think about it and remember that there's a whole team I'm part of.

## The team

They're all really nice people that I can't fault or have any reservations about.

I've been trying to consciously be a little bit more myself by bringing the sillier aspects to work such as my [Kumamon](https://en.wikipedia.org/wiki/Kumamon) obsession.

As an example, I really enjoy Kumamon but even more, I find the contrast of "an industry professional" being a big fan of a cute Japanese bear even funnier. I imagine it's weirdly jarring but I also like that it forcefully breaks any illusion of being unapproachable or overly serious.

Ultimately, my less serious aspects like shitposting people (although never punching down or sideways) via DMs have ended up being helpful for bridging teams who don't communicate so easily. You can get to know individuals and figure out how to build ties with common elements.

Everyone can equally laugh at my Kumamon obsession while knowing that I'm in on the joke for example. Maybe it helps ultimately build a squillion dollar product that ultimately would have fallen apart if things were too serious.

I dunno, I just want to build useful software and learn things anyway. Getting too invested into any single business, that may ultimately collapse at the whim of a newly-installed post-IPO board, is a bit of a mistake waiting to happen so just enjoy it while it lasts :)

## Now what

I'm still onboarding and perhaps I'll have more to write about career stuff. I think I'll be pretty happy here for a while and I've got quite a bit to learn.

With lockdown again here in New Zealand and my [brief health issues earlier this year](/blog/ride-the-curve/), I had purposely decided not to think about work.

In fact, I was invited by the recruiter to interview so I never really plan to work here, it all came as quite a surprise!

The more technical posts I've written, such as [Conditionally setting your gitconfig](/blog/conditional-gitconfig/) and [Fixing a WSL2 VHD conversion issue](/blog/wsl2-vhd-issue/), continue to gain quite a bit of traffic which is interesting since I don't do very much promotion.

I have some vague intention to dig through manpages and what not to see what other niche things I can dig up. I don't intend to turn this site into some sort of "Top 5 Git Commands" hellhole.

Given that a few people reached out to me as a result, I'm aware that more than a few seem to have gotten real value out of problems that I was just solving for myself ultimately.

The [questions](/questions) section is still the place to go for brief, niche snippets but I would like to do some deep dives in future if anything useful comes out of them.

Whatever, I'm just rambling at this point.

Until next time, see ya.

[^1]: Unrelated to work, just doomscrolling Twitter too much.
[^2]: I was actually rejected from university, not that I really wanted to go anyway. I considered myself allergic to debt, at least on that scale.
