---
category: blog
date: 2021-05-22T10:40:00+13:00
description: A post from a darker time on how to better think about taking a break
slug: ride-the-curve
tags:
  - career
  - health
  - longterm
  - selfcare
title: Ride the curve
---
> [!info] 🚣‍♀️ It's rough seas out there!
>
> Not so long ago, I was struggling with instances of <a href="https://en.wikipedia.org/wiki/Depersonalization">something very unfamiliar</a> , which scared the shit out of me.
>
> As one of many distractions, I popped open a text editor and started writing about my life so far and this is what came out.
>
> I've strongly resisted the urge to make any edits, beyond adding links for context. All footnotes were already written inline with the draft.
>
> I haven't fully reread it nor do I really intend to. I also never got to the actual point of the title, which is what I started off with as a prompt.
>
> In short, I'm trying to relax more and look after myself. That doesn't mean stopping work but riding the momentum I already built up, whether I realise it or not.

Generally, I tend to worry a lot about what things might look like in the future.

If it all turns to custard, will I have transferrable skills that are sought after?

My tendency is to frame the tech industry as a sort of gold rush that sooner or later will dry up. I imagine that maybe it will hit market saturation or be dismissed due to intense distrust thanks to key/buzzwords like Surveillance and Algorithms that always seem poised to spiral out of control.

In ~~some~~ most ways, this is a ridiculous thing to worry about.

Firstly because an industry that can service other industries (see: accounting, consulting, compliance etc) rarely run out of business.

Secondly, most things are cyclical so a crash here will peak once again over there. We only have to look at various bubbles and crashes (see: [the dotcom boom](https://en.wikipedia.org/wiki/Dot-com_bubble), the [Global Financial Crisis](https://en.wikipedia.org/wiki/Financial_crisis_of_2007%E2%80%932008) or even the [Coronavirus Pandemic](https://en.wikipedia.org/wiki/COVID-19_recession) which is still ongoing)

Of course, the final and true answer is that no one can know the future. We can predict things, often with some accuracy but us humans are unpredictable so even sane assumptions can fall apart in an instant.

## Abandoning ship

When I was towards the end of my teenage years (I'm only 26!), I figured I had missed the boat when it came to "Computer Science".

I liked messing around with web pages and I thought the internet was fascinating despite only having a vague understanding of how it worked.

I remember trawling through forum posts for MMOs and absolutely loving the technical explanations of why Final Fantasy 14 developers [struggled to allocate more bag slots](https://www.reddit.com/r/ffxiv/comments/6h4129/yoshida_acknowledging_glamour_importance/divdh85/) or [the troubles with aspects](https://forum.square-enix.com/ffxiv/threads/125277-Triple-Monitor-Display?p=1631847&highlight=Minagawa#post1631847).[^openness]

Despite all this, and years of trawling [Hacker News](https://news.ycombinator.com) daily which built up a fairly solid vocabulary, I never actually properly started programming until what I thought was quite late.

While I considered myself a hobbyist and had dabbled in a bit of Python but I didn't "get" any of it for a long time, probably since I didn't have a mental model to hang any of it in a useful way.

I distinctly remember [some BBC article came out ranking the likelihood of job automation](https://www.bbc.com/news/technology-34066941) had came out in my third year of retail. It listed retail workers as having something like a 97% chance of being automated.

Nowadays, I think back on that and find it kind of funny. Due in part to being a technical hobbyist, I would daydream about automating parts of my job and thinking about how inefficient the systems seemed.

Probably for that reason, I thought I could "feel" it coming, like a rising tide that would swallow me up and that fear was a useful, although probably not healthy motivator.

Between that fear and a general sense of worthlessness and disappointment, I decided to throw my eggs in one basket and attend a web development bootcamp.

I'm sure for some, it was just a brief chance to dabble in a profession to see if they're interested but for me, at that time, I felt it was my last chance.

Saddled with the idea of spending the next 50+ years, pushing shopping carts and being derailed into conversations that amounted to "What if the store just simply made everything more efficient" for the 600th time, I honestly did not expect to live this long.

Anyway, as for how I came up with the funding: Doing a lot of saving coupled with a bank loan for a "cruise to Japan".

## Actually finding a job

Going to [a bootcamp](https://devacademy.co.nz/) was a step in the right direction and a chance to understand the industry but I will never claim you can attend one and instantly become a fully fledged developer.

Plenty of people were lucky and found side jobs or internships relatively quickly.

I was arguably unlucky in that I persisted for an extra year on minimal savings and spent what felt like the majority of every day pouring over crap, building side projects and doing tutorials, filling out job applications and probably trying to not cry a lot of the time.

On a side note, a man in his 40s or so moved into our flat at one point.

At first, he seemed fine but progressively shared some conspiratorial views until I found out he was literally a white supremacist. I'm not misusing the term literally here.

One of his friends once talked about beating me to death while I was in my room, with the lights of, pretending to be out of the house.

This inspired me to learn how to set up a [Discord](https://discord.com/) bot that would poll our router for connected devices and I could query to see if I felt safe to come home. Odds are, if he was home, he was in the lounge and would say Hello and draw me into a two hour, mostly one sided conversation where I would nod and say "H-hah, sure, I guess the UN could be trying to control the population".

In hindsight, I was probably pretty stressed during that time.

## Working to keep working

With going into too much detail, I had the good fortune to work at one of New Zealand's largest tech companies and at present, I work for one of the largest car companies. Ironic, given I don't drive.[^license]

Despite all that, I'm not sure if I relax enough. Actually, I'm not even sure if I know what that is exactly.

Don't get me wrong, I'm not a robot and unfortunately I'm not a machine either.

I like playing videogames but I'd dropped off a lot since I started working. Last year, I even got annoyed that I didn't game very much so I sold my gaming desktop.

I figured I'd double down on research and what not and try to do more productive things.

This is probably near enough the root of my troubles and why I'm writing it all down today.

I think I still have that driving fear that I'll be made redundant one day. I probably will and that's perfectly fine.

It's nowhere near strong enough as it was back then when it felt like a choice between life and death but it's still enough to make me hesitate between reading a book and playing a game.

Perhaps I overcorrected a lot. I like the idea that a to do list is better framed as a "things i could do" list since that sums it up nicely.

It's easy to imagine side projects and then see them tower up. More and more until you realise you could never achieve these in your lifetime. The mere thought of them becomes exhausting.

Thankfully my blog isn't quite like that. I have a couple of small goals buried somewhere but I don't feel bad about not posting.

For the most part, I just imagine no one reads this anyway. I heard once from a reader which was really cool and sometimes I peek at analytics to see a lot of people seem to get value from [my Windows 10 VHD post](https://utf9k.net/blog/wsl2-vhd-issue/). Beyond those technical things, I struggle to imagine anyone investing time into these.

## What's next?

I had been meaning to write a post about my intentions with my blog. I'm still active and I have things on my list but mostly it feels like something driven by guilt and fear.

A portfolio to say that I existed but not one with enough value to actually act as a portfolio!

My intention going forward is to encourage myself to post a bit more often but with less lengthy content.

Things that I find interesting and are worth sharing as well as a few larger, "original" posts.

I've got one that I'm particularly excited to get struck into that's a little quirky and is a bit of a fun investigation story.

I run into technical troubles from time to time and I'll generally still share those but they don't really come up often and admittedly, I don't find them hugely interesting unless some sort of a story.

I've also changed the structure of the site a little bit. You can see any drafts at [next.utf9k.net](https://next.utf9k.net) and I manually merge things into the live branch.

Given that there's a concept of "staging" where I can add things piecemeal, I might start managing longer posts as Github issues where I can make notes to myself and sort of "work out in the open".

This doesn't mean a story in the open is guaranteed to happen but adds a little bit more structure that might help with stories that are otherwise a bit overwhelming.

My tendency is to write them all in one sitting (like this post) with an optional review but it's probably a bit healthier to piece things out and not potentially feel so overwhelmed.

## Beyond the site

Of course, this was just an excuse to shoe horn in some thoughts about this site into an otherwise fairly personal post.

I don't feel that I've ever really shied away from talking about my feelings very much so I don't consider sharing this to be a huge effort.

Having said that, maybe there's some value for other people in reading these sorts of things?

I'm sure others can relate when I say I feel a bit paradoxical about a lot of things.

For example, the idea of [FOMO](https://en.wikipedia.org/wiki/Fear_of_missing_out) and ["Hustle culture"](https://www.nytimes.com/2019/01/26/business/against-hustle-culture-rise-and-grind-tgim.html) is stupid and unhealthy, yet at the same time I've clearly just described what is basically someone who struggles to ignore it.

I don't feel like I have to do anything but at the same time, I get a bit itchy when I'm away from something constructive for too long.

I think I would actually hate the idea of being retired on a beach.

I would like to be retired with [my videogame backlog](https://howlongtobeat.com/user/Sentry) however.

I've got some personal (and mental) struggles to deal with and perhaps I'll share some of those.

Anyway, I gotta head off now.

Until next time, happy travels!

[^openness]: MMO developers seem to have a tendency to be more open than most, probably because subscriptions from the fans directly keep them going rather than publisher deals.
[^license]: I have my restricted license but my flat is quite literally on a main road so we don't have any place to park.
