---
category: blog
date: 2021-04-18T13:21:00+13:00
description: A post in which I ramble about Starbucks and how if you squint, it's a place that some people treat as their second home.
slug: starbucks-rewards-third-place
tags:
  - apps
  - coffee
  - ecosystems
  - starbucks
title: "Starbucks Rewards or: Whether a Coffee Shop Can Be a Third Place"
---
Like all non-technical blog posts I write, the ones that get published are often a spur of the moment reaction to something I just saw or experienced. In this case, I was visiting a Starbucks location here in New Zealand and learned an annoying qualifier about the recently introduced Starbucks Rewards system.

For any international readers, Starbucks doesn't have a huge presence here in New Zealand. As of 2018, the total number of stores had dropped from [nearly 50 to 22](https://www.stuff.co.nz/business/industries/106769552/restaurant-brands-sells-starbucks-coffee-in-nz) with a majority of those being within key cities such as Auckland and Wellington.

While I'm not exactly a coffee connoisseur, I do know that they've struggled to carve out a portion of the market due to a [strong coffee culture](https://archive.is/pXeER) both here and across the ocean in Australia.

Taking into account the sale of Starbucks from Restaurant Brands to Tahua Partners, and the [recent renovation of their flagship Queen Street store](https://heartofthecity.co.nz/dining/coffee/starbucks-coffee) which I'm sitting in as I write this, it seems that they've started taking a different course than the prior owners who just sort of had it plodding along.

From the outside, it seems that they're attempting to take the high ground by giving off a premium, polished appearance rather than the budget, store-on-every-corner approach that found huge success in America. Most of my evidence of this is purely anecdotal in the form of "Well, all of the new stores look fancy" and "There seems to be a focus on giving the feeling and illusion of space, even if factually, that isn't true".

Before I get into the actual app rewards ecosystem, let's first take a bit of a detour into psychology and something that I've been meaning to write about for quite some time: the concept of a [third place](https://en.wikipedia.org/wiki/Third_place).

The short version is that in community building theory, there are concepts of "places", with the "first place" being your home and the "second place" being your workplace. In his probably seminal[^seminal] book ["The Great Good Place"](https://www.goodreads.com/book/show/4119.The_Great_Good_Place), Ray Oldenburg talks about the idea of a "third place", which compliments the first and second, and aids in the feeling of having a connection to society and all that.

While I won't go into it too much, nor am I particularly qualified to, there are a few key characteristics that you may or may not recognise in any number of places you go to such as coffee shops, libraries, bookstores, parks, churches and all sorts of non-work, communal settings.

A condensed version of those characteristics is roughly:

- **It should be neutral**: No one is required to be there for any reason. You can come and go as you like.
- **Status should not matter**: Whether you're an executive or a retail assistant, you get the same treatment.
- **The main activity is conversation**: Assuming you're with friends or feel comfortable meeting strangers, the primary activity you'll be doing is talking. Starbucks has a bit of an asterisk here as people also come to work in a solo capacity.
- **There tend to be regulars**: The presence of regulars sets the tone and their presence also attracts newcomers.
- **The location has a low profile**: It never feels intentionally pretentious or exclusive to any particular section of society.
- **It has a light tone**: There's never a sense of tension or extreme seriousness.
- **It feels like a second home**: You feel like you belong, or perhaps more accurately, like you're not unwanted given it is a business after all.

At this point, I've also forgotten what I was writing about in the first place but this is a long winded way of saying that I consider Starbucks to be a third place for some, whether they realise it or not.

I'm not a teenager, nor do I really know what teenagers in the city do in their downtime, but it seems like young people definitely do come to places like this to hang out and so it seems to fit the criteria of a third place.

For myself even, when I think of a place to come and work on my site, which is neither my job nor an aspect of my home, usually cafes with space tend to be a place to go. It started as a bit of a gag after seeing people with Macbooks in Starbucks but now I'm one of those people to some extent although I like to think without the pretentiousness.

Ah yes, but anyway, back to our main thread. Starbucks recently introduced their global [rewards system](https://www.starbucks.co.nz/rewards) to New Zealand. It's a system where you have a virtual card and you can load it up with money. If you install one of the mobile apps, you can pull up your barcode on screen, scan it and collect rewards points.

It's a good system, in that for Starbucks as a business, it establishes a sense of [FOMO](https://en.wikipedia.org/wiki/Fear_of_missing_out). If you don't pay using the in-app virtual card, you can't actually collect any points as I found out this morning. Given that, it allows Starbucks to compete for your attention outside of the bounds of its store.

There's an element of lock-in, where you wouldn't bother visiting other stores because the money you've already loaded onto your card is useless outside of it. That isn't any different than other customer rewards system I'm sure, although you generally can't pay for videogames or clothing in-store, via an app. At the risk of stating the obvious, there's no particular reason for me to go to one store or another since there's no differentiator.

There's also a double-lock in that while an asset is an asset, whether it's $20 in cash or $20 on a transport card, having $20 on a Starbucks card feels like a waste of money if you have it sitting there and you go somewhere else for coffee. I don't really think I get that feeling with transport because there aren't really any reasonable alternatives. A bus can't really compete with an Uber when it comes to speed but, for those who don't particular care like myself, all coffee seems mostly interchangeable. I also wouldn't come to Starbucks for coffee, if I cared about coffee that much I imagine.

Hmm, I was going to make some comparisons to how this could evolve into a consumer hell if everyone starts to follow this model but the more I think about it, it's not really a sensible forecasting of the future so I'm simply just not going to write about it.

I was also going to say that it's a horrible rewards system compared to the original "Get 9 stamps and your 10th visit gets you a free coffee" but after doing the numbers ($1 = 2 points), $250 gets you to gold status. If you visit Starbucks frequently, that actually not too bad of a deal compared to something like [Uber Rewards](https://www.uber.com/nz/en/u/rewards/).

I don't think I particularly achieved any meaningful insight with this whole thing other than "The third place is a thing", "Some people probably feel that Starbucks is a third place" and "I'm not sure if mobile app ecosystems make me feel better or worse about a third place" but in the grand scheme of things, it doesn't really matter since it's a business and I don't actually know or interact with anyone who works here in the first place[^pun].

It probably would be a third place if I came here with friends, but I don't, so until then it's just a convenient store that happens to have enough space to function as a work area (in which typing on my laptop is work) without the premium that comes with having to pay for a co-working space. The "co" part of co-working space is what I don't particularly want anyway. It's just nice being able to blend in and not having to feel like you should be networking or anything like that.

I guess it really is a third place then?

[^seminal]: While I've been aware of the idea of a "third place" for a few years now, I haven't actually read any literature on it besides Wikipedia. In this case, it just seems nice to cite a source even though I'm writing this off the cuff. Something something professionalism.
[^pun]: Pun intended
