---
category: blog
date: 2021-02-13T01:11:00+13:00
description: How many widgets can you fit on a mobile webpage? More than should be legal
slug: a-recently-horrible-iteration-of-google-search
tags:
  - google
  - media
  - search
title: Google recently surfaced awful results for movies and tv
---
I don't know about you but whenever I have just watched a movie, or tv series, I like to look it up on Wikipedia to read about the development behind the scenes and how it was received upon release.

Ok, I also have a pretty bad habit of reading the plot of a film while I'm also meant to be watching the film itself. Never in theatres of course!

I finally finished watching [The Sopranos](https://en.wikipedia.org/wiki/The_Sopranos) in early December last year and had gone to check out the Wikipedia page for the series. Much to my surprise, I couldn't actually find it when doing a basic Google search for "The Sopranos"

**You should note that Google have changed their search results since I captured the following recordings.** As such, they no longer reflect what you receive when doing a query for "The Sopranos".

A number of the same elements appear but they have been sprinkled throughout the results rather than all stacked at the top of the page.

Lastly, Wikipedia is clearly visible at the top of the page as the first result making my original complaint outdated.

Having said that, the fact that someone at Google signed off on what was, until quite recently, a hideous, bloated layout doesn't exactly inspire confidence in the product.

I just happen to have taken a screen recording of this mess which was live at least as recently as early December and so that's what I'd like to present to you now:

<video style="display: inherit; margin: 0 auto;" width="50%" controls>
<source preload src="https://cdn.utf9k.net/blog/a-recently-horrible-iteration-of-google-search/google-search-the-sopranos.mp4" type="video/mp4" />
Ah, sorry! It looks like your browser either hates the h264 codec or it just doesn't support the video tag.
</video>

What is all this?! There's so much going on visually here. We've got:

- Some tabs to see cast photos, episode listings and other bits and pieces
- A carousel of posters from the show
- Some sort of watch list/show tracker functionality? I've never actually seen a UI so I wonder where your list is saved to?
- A scoring round up which I assume is strictly critic scores. Is it a roundup of every score over the last 20 plus years? I assume so
- An arbitrary block telling me that 89% of Google users liked the show. 89% of... people who clicked thumbs up when doing a Google search for the show? Can anyone just randomly vote?
- An overview which reminds me of Wikipedia. Hey, speaking of, it's still nowhere to be seen.
- Another carousel showing the cast. Wait, what were those earlier tabs for then if I don't have a choice?

Ok, now we're actually at the search results and... oh wait, not quite yet...

- Shows other people searched for. Cool but I searched "The Sopranos", not "Shows like The Sopranos"
- Some questions (who are these even from?) such as "Is it worth watching" (yes) and "Is there a Season 7" (no)
- Episode listings. Always good to start from the last episode so I can get potentially spoiled on how characters develop. I know it probably has nothing to do with Google but the appearance of the words "FREE HBO" and "HD" feel really tacky. Even pirate sites have a little more taste in their naming schema.
- Yet another carousel with videos. Great.

Ok, now we're at the search results and you know what? The rest of it is all just crap I don't care about. All it has is derivative content like pop culture articles, streaming links and "related crime TV shows".

That's great and all but I want to find out more _about_ the show hence the search.

Eventually I just gave up and tacked "Wikipedia" on to the end of my query and got what I was after.

I don't understand though. Is this what the data showed that users were craving? I struggle to believe that a human signed off on this. It's like someone took a machine learning algorithm and set "How much metadata would you like?" to "Yes".

For comparison, here is what the equivalent search in [DuckDuckGo](https://duckduckgo.com) looked like on that same day:

<video style="display: inherit; margin: 0 auto;" width="50%" controls>
<source preload src="https://cdn.utf9k.net/blog/a-recently-horrible-iteration-of-google-search/ddg-search-the-sopranos.mp4" type="video/mp4" />
Ah, sorry! It looks like your browser either hates the h264 codec or it just doesn't support the video tag.
</video>

Not only was that much easier, it actually inlined a bunch of links you might want to look at, rather than unrolling them for you into a massive information dump.

I was also trying out [Ecosia](https://www.ecosia.org) at the time too:

<video style="display: inherit; margin: 0 auto;" width="50%" controls>
<source preload src="https://cdn.utf9k.net/blog/a-recently-horrible-iteration-of-google-search/ecosia-search-the-sopranos.mp4" type="video/mp4" />
Ah, sorry! It looks like your browser either hates the h264 codec or it just doesn't support the video tag.
</video>

I think Ecosia uses [Bing](https://bing.com) under the hood but it also surfaces Wikipedia as the first result without any troubles.

Anyway, I should also point out that the Google search result was only ever served on mobile by the way. Performing the same query on desktop just shows Wikipedia as the first result like you might expect. Thankfully those card style widgets seem to be entirely quarantined to mobile as well.

Thanks, I hate it.
