---
category: blog
date: 2021-02-11T17:00:00+13:00
description: I mean, it's what it says on the tin!
slug: zettelkasten-blog-a-good-idea
tags:
  - zettelkasten
  - blogging
  - meta
title: Using a blog like a zettelkasten seems like a good idea
---
Having recently gotten back into the swing of reading via [RSS](https://en.wikipedia.org/wiki/RSS), I spotted a post from [Mike Crittenden](https://critter.blog) called [Blogging as a Zettelkasten](https://critter.blog/2021/02/10/blogging-as-a-zettelkasten/).

It touches on the idea that a blog can act as a [zettelkasten](https://zettelkasten.de/introduction/). For the unfamiliar, a zettelkasten is nothing more than a big collection of notes. While you might imagine reams of snippets dumped into a tool like [Apple Notes](<https://en.wikipedia.org/wiki/Notes_(Apple)>), the difference is that each note (or "zettel") is generously interlinked with other notes so as to form a "web of knowledge" or a "second brain". Each note should address one standalone idea such as "English is an unproductive language" rather than a more generic "Notes on languages".[^not-succinct]

The very blog post [I just linked](https://critter.blog/2021/02/10/blogging-as-a-zettelkasten/) is a good example of what a zettelkasten note would look like. There are a number of hyperlinks scattered about and rather than reiterate previous ideas, you can just link to prior knowledge that has been expanded in detail elsewhere, should the reader choose to follow.[^internet] As time goes on, themes start to appear, not unlike one of those crazy pinboards you see detectives use.

It is said that new insights should just sort of "fall out" by putting ideas in close proximity where your brain can make all the connections it likes. Your brain already works this way for the most part, like when you have a eureka moment in the shower, and so the idea is to basically make that process as easy as possible. While most examples seem to have degenerated into YouTube productivity clickbait, ["How to Use Roam to Outline a New Article in Under 20 Minutes"](https://www.youtube.com/watch?v=RvWic15iXjk) is still a golden example of what this process looks like. That was probably the single most thing that made me raise an eyebrow in interest.

Now then, while I've already generated enough content for a "What I don't like about zettelkasten software" type post later on, this post is best kept succinct and in line with the title so let's touch briefly on why I think using a blog as a zettelkasten seems like a good idea.

## 1) Longevity

The main issue that should concern anyone semi-serious about zettel software is that you're inherently dealing with information that may be retained for quite some time, if not possibly an entire lifetime. In the grand scheme of things, software itself is not a very old medium and yet, it feels like [some](https://snyk.io/blog/how-much-do-we-really-know-about-how-packages-behave-on-the-npm-registry/) ecosystems tend to degrade within mere months, if not years.[^gatsby]

The beauty of just using a blog, and particularly a static site backed by any text-based format, is that it... I was going to say that it ["degrades gracefully through time"](https://brandur.org/fragments/graceful-degradation-time) only to realise that humans are incapable of original thought and there is no such thing as free will.

I also can't help but notice that a lot of the attempts in this space are from relatively fresh startups, rather than long-term established companies. Not that either is necessarily more equipped but the idea that [Roam Research](https://roamresearch.com) has raised [$200 million](https://www.theinformation.com/articles/a-200-million-seed-valuation-for-roam-shows-investor-frenzy-for-note-taking-apps) in funding, as opposed to [bootstrapping](https://www.investopedia.com/articles/investing/082814/companies-succeeded-bootstrapping.asp), is absolutely horrifying to me.

On the face of it, I'm sure users are happy that Roam has the cash to make the app nice and crisp but the idea that you would entrust any amount of long term knowledge storage to a business that will inevitably be ripped apart by venture capitalists in 5 years when it doesn't turn on a profit on "Joe Schmo's 40,000 hyperlink sprawl regarding [himalayan pinecones](https://en.wikipedia.org/wiki/Juniper)" isn't exactly comforting.[^funding]

## 2) One System To Rule Them All

Trying to have just one way of doing things is often not ideal because you're probably forcing unrelated things into one box.

In this case though, I find having multiple systems for writing is annoying. Blog posts are just text and "zettels" are just text so why not have one workflow for dealing with both. It may be that different software is required (whether web-based or desktop software) or even a unique plain text format such as [org-mode](https://orgmode.org) in the case of [org-roam](https://www.orgroam.com)

Less software is always nice, right?

## 3) Reliability

There's one piece of "zettel" software [in particular](https://logseq.com) that comes to mind where I fumbled some magical formatting code in the web editor and destroyed a post beyond recognition. While it was backed by Git, everything autosaves so I had to do some unwiring. I actually chalk it up to user error but if I can't trust myself to not break the software (as has happened twice), then perhaps the UX unavoidably has to be called into question.

I also remember Roam Research used to suffer from some site troubles back in the early days. It isn't hugely comforting knowing that your knowledge might be inaccessible whether it be [on a train or in a car](https://www.site.uottawa.ca/~lucia/courses/2131-02/A2/trythemsource.txt).

## 4) It's hidden in plain sight (a secret rant)

Part of me has come to associate "zettelkasten" with the whole "Productivity Porn" movement. The idea is nice but the wider fanbase often gives me pause. To be clear though, I think a lot of that ecosystem floats around YouTube and Reddit rather than say, the [home](https://github.com/org-roam/org-roam) of [Jethro Kuan](https://jethro.dev)'s [elisp](https://www.gnu.org/software/emacs/manual/html_node/elisp/Introduction.html#Introduction) [child](https://www.orgroam.com).

Also, who the hell is [Tiago Forte](https://fortelabs.co/)? He's like a bargain bin Elon Musk who just appeared out of thin air one day and no one seems to know why. Why are people paying this man [$5000](https://web.archive.org/web/20210101170747/https://www.buildingasecondbrain.com/) to go _right click_ ➡ "New text file"? I don't understand.

Anyway, in that vein, blogging feels like a zettelkasten hidden in plain sight. It carries all of the benefits of one without having to think about the wider ecosystem and that sounds pretty comforting.

Having convinced myself that reducing the scope of each blog post is probably a good idea while writing this post, I've now got an entire scrawl of at least 5 different topics on my normally empty whiteboard.

I haven't even done anything yet and so far, it seems pretty promising!

[^not-succinct]:
    Can I just take a second to say that it feels massively ironic that most of the literature around zettelkasten topics are so dense to the point of giving me a brain aneurysm.
    <span></span>
    Like, just go back and have a look at that [earlier link for zettelkasten](https://zettelkasten.de/introduction/). What the hell is that?! That's a thesis, not an introduction!
    <span></span>
    It's almost as bad as that [New York Times recipe](https://cooking.nytimes.com/recipes/1017089-maple-shortbread-bars) that starts off by referencing 9/11.

[^internet]: Wait a minute, the internet is basically just one big zettelkasten?!
[^gatsby]:
    I've recently been stuck in a dilemma with [Gatsby](https://gatsbyjs.com) between "Oooh, looks shiny" and "This is going to erode in like 2 years, isn't it".
    <span></span>
    It does actually have some nice functionality but whether it's worth the risk is an important question, not to mention the insanity that is `node_modules`.

[^funding]:
    While that might seem like an overly negative view, and congratulations to any business that survives the pitch meeting/incubator gauntlet, I can't help but believe it never ends well as you get deeper and deeper into funding, and the later investors also want their 40,000% return.
    <span></span>
    Slowly, the crushing expectations of higher profits cause you to reduce the feature set and raise the price or maybe you'll manage to IPO and jump ship with a nice bag of cash before the whole thing starts slowly sinking into the ocean.
    <span></span>
    The foundations feel unstable right from the second you sign the agreement."
