---
category: blog
date: 2021-01-31T15:41:00+13:00
description: The difference between nothing and something depends on whether the curtain has been raised yet
slug: is-anything-happening-behind-the-curtain
tags:
  - doubts
  - finance
  - worldview
title: Is anything happening behind the curtain?
---
This week has definitely been one of the more interesting ones I can remember.

First up is the [GameStop short squeeze of 2021](https://en.wikipedia.org/wiki/GameStop_short_squeeze). A pretty fascinating event, that seemed to highlight far more structural issues than the original squeezer, [/u/deepfuckingvalue](https://www.wsj.com/articles/keith-gill-drove-the-gamestop-reddit-mania-he-talked-to-the-journal-11611931696) could have ever predicted.

One of the biggest issues to arrive from this event, and one to keep in mind, is the belief that [Robinhood](https://robinhood.com/us/en/) blocked users from buying stock. While I'm no day trader, it may turn out that what initially looks like a villanous attempt to screw the little guy is [actually the result](https://pca.st/gw6fvzay) of Robinhood being asked to put up even more money to protect against the risk involved.

Either way, it doesn't matter because they effectively look the same. Whether an attempt to screw the little guy or a genuine, albeit irresponsible situation they've found themselves in, because they can't communicate via any other language than corporate press release jargon, users struggle to tell the difference.

This isn't really a post about finance though.

A second event that just so happened to occur this week and is not of any particular note other than I read about it on [Hacker News](https://news.ycombinator.com) a little bit, is the [suspension of Element](https://twitter.com/element_hq/status/1355663753380032512) from the [Google Play Store](https://play.google.com/store).

For the unaware, Element is essentially a chat client. The servers it connects to are hosted by users rather than all living under one company such as [Facebook Messenger](https://messenger.com) or [WhatsApp](https://www.whatsapp.com/). Ah wait, those are the same company...

This is also an instance where, due to Google being uncommunicative, users can't discern between malicious intent and "the algorithms" accidentally making a user report as being reason to take down a chat client.

While I understand corporate policy means that Google can't openly state why or what triggered problems, it only fuels the sentiment that Google is picking winners and losers at a whim. The lack of transparency provides space to theorise that "Ah, Google has a chat client. Many in fact! They must be protecting their own and putting a dampener on competition."

That very well could be true! Personally, I subscribe to the idea that most malicious things are actually just people in close proximity either being inept or actually being malicious for their own reasons, and that proximity creates the illusion of a wide group "pulling the strings".

I've never really thought about why I've arrived at that conclusion before now but I suppose it's a mix of "It sounds like a good middle of the road option" (which can be a bias in itself as well mind you) mixed with the thought of "If everything were controlled, why is there so much disorder. We should be much deeper into dystopic territory by now, none of this slow burn crap".

Lastly, with all these things stewing in my head, something clicked which is what caused me to sit down right now and churn out this post. It reminded me of one of my old work places. Some of the people leads had a program of sorts that was going to work through previous issues and err, I dunno, make it a better place to work? It wasn't an awful place but it had some instances of "Why would anyone think this is a good idea?"

I'm not really sure if anything came of those attempts. Maybe a lot changed? If it did, I couldn't really tell and that can definitely be the case when things change slowly over time. Either way, one of the things I used to say in my 1:1 review meetings is something like "The difference between a whole lot of stuff happening behind the scenes, and nothing, are pretty much the same".

That is to say, imagine yourself watching a play. You're sitting in the front row and the curtains are down. You might start daydreaming about all of the scrambling that must be going on backstage. Actors taking their ready positions. Set people hurridly putting the final touches in place. The lighting people making sure they don't accidentally turn the lights up too slowly at the begining, as I once did back in high school.

At that very same moment, someone across the aisle from you is probably thinking "What are these people doing? Nothing is happening! What a waste of money if they can't even start on time."

Part of this can be chalked up to not understanding, in this case, the requirements of putting on a play. It's a lot! I don't even particularly know myself in great depth so someone who runs those sorts of things surely appreciated the nuance needed to get such a thing running.

I suppose all this is to say, it feels like an all too common occurence where a little (or a lot) of transparency can help escape these otherwise unenviable situations. Had Robinhood simply outlined that they fucked up and that they didn't have enough capital to allow trading, maybe we'd be in a different position. It would still suck for them but they would be branded as stupid for a little while rather than being branded as "Illuminati corporate shill who fucked the little guy"

That does go against human nature though where the expectation is that it's safer to be obtuse so that your choices (often with limited information on hand) can't be criticised and ideally not even spotted at all!

I've mentioned the series before, which just outlines how much I appreciate the idea, so once more I'm going to share the [Evernote Behind the Scenes](https://www.youtube.com/playlist?list=PL4I5cq2DfrSpehLO_71NCjKSZE0nGXIvf) series that they've still been going on with.

For a company that has been understood as having [fallen by the wayside](https://usefyi.com/evernote-history/), I think this is one of the more innovative things I've seen which genuinely makes me want to see them succeed.

Actually, innovative isn't even the right word like it's not a new or particularly amazing idea but it takes a lot of guts to actually do so props to them and honestly I kind of aspire to do something like that one day.
