---
category: blog
date: 2020-12-01T00:00:00+13:00
description: Is software reliable? Probably not
slug: solid-systems
tags:
  - shopping
  - reliability
title: Will we ever get solid systems?
---
If I had a crystal ball in front of me, one of the things I would like to ask is "Will we, the human race, ever get solid systems?".

I don't mean [SOLID](https://en.wikipedia.org/wiki/SOLID), I don't even know what that means, but you know, robust and just generally not prone to letting the user fall right through the cracks by taking an unexpected route.

I can think of a couple of examples from the past month or so but they're purely anecdotal of course. There are plenty of great systems that work 99.99% of the time, like [EFTPOS](https://en.wikipedia.org/wiki/EFTPOS) or the toilet in my bathroom but I also don't know how you would even go about using such a thing in a way that breaks it.

Anyway, that's not really my point.

Just recently, I bought a delivery saver coupon from my local supermarket. It means that I can get as many deliveries as I want during a 3 month period and I don't have to pay a delivery fee.

That seems pretty straight forward and I'd been meaning to buy one so I thought, why not. I'll buy one and then I'll use it on my next grocery order.

It exists just like any item on the store website so I added it to my cart. I was being lazy and didn't want to expend the mental energy on thinking what to buy so I just got that for now since I'd get to use it shortly. It'd be silly to buy it only to have to wait for my next order to get the discount anyway, right?

So, I added it to my cart and then it asked me if I wanted it delivered or if I wanted to pick it up in store.

Well, that's a bit of a strange question. Isn't it just a coupon code? Ah, I bet it's just a bit of a hack and they have a service at the end which emails me the coupon code.

I don't want to cause any undue trouble, and it's more hassle for me to receive a delivery in the first place so I chose to pick it up at 8am on a Tuesday.

I got my confirmation sure enough and... no code. That's weird and I can't find the coupon code input either but ah, it'll probably arrive in a bit.

Tuesday rolls around, and I had since forgotten I had bought the code (I'm really bad at procrastinating my grocery orders) and I get a text message saying my order is ready to pick up in store. Great, I guess I'll go over there.

First, one staff member checked all of the customer pick up lockers and there was no dice. Next, they said they'd try and well, I think the assumption was that this was something perhaps to be printed out in the back office? I figured maybe it was something like gift card but no one really seemed to know what form this actual delivery saver took.

A third staff member went out back and after about 10 minutes, they returned with a copy of the receipt and no coupon code. It turns out that despite there being an item, just like any other item on the store website, there's nothing to actually retrieve.

Instead, it's more like an account flag that signifies to the order picker to scan a barcode, from a sheet of barcodes they have at their back desk, and that applies the delivery discount.

That would have been nice to know beforehand. The downfall here I suppose is that I had expected this item to operate just as any other item would in that it represents an asset whether it be a physical item or a digital barcode.

In my defense however, the system in question still treated it like any other item by creating an order, forwarding that order to someone to go and "prepare" and then causing trouble for the staff members who were confused.

What likely happened is that whoever entered this item into the system made the assumption that it would always be bundled as part of an order. I wonder if anyone considered the possibility of just buying that item by itself. Worse yet, I bet if I had requested a delivery, a truck would still have stopped by my house with the driver unsure what was actually requested.

The fact that you could arguably induce confusion (and pollution) by using an ordering system incorrectly is borderline insanity but one that we live with daily.

On a similar note, I had recently booked a doctors appointment online for a late Monday morning. Before Monday came around, I had received an SMS telling me that the doctor didn't work Monday and that they had cancelled my appointment.

Firstly, that seems like an odd way to treat your patients but sure, I get it. Secondly, why is scheduling so hard?

I dislike nothing more than invoking the current year, as if that is any sort of claim to having made progress. Having existed for X number of years doesn't necessarily mean we've collectively progressed in any meaningful way. I bet you the Greeks were no better at scheduling that we were for sure.

The next step was to book a new appointment but how am I supposed to know if that won't get cancelled either? How can I have any faith in a system that lets me book timeslots that don't exist? This isn't the first time it has happened before either.

For all the time and money that employers spent on having to pay workers less and get more out of their existing cost, it baffles me to no end that they would let employees spend god only knows how many hours a year having to deal with systems that let you do things that should be invalid but still pass validation.

Anyway, is anything I've said so far actionable? No

Are we going to get solid, reliable systems and finally see the light as a society? Definitely not

Perhaps the biggest issue I imagine is just a general lack of feedback, in a system sense.

If there is only one cashier overseeing the self checkout area, and 4 people have been blocked by the "Nice alcohol. Are you over 18?" prompt, followed by another person who wants their package then that's not a good system.

Clearly it's heavily bottlenecked and there should be more staff, yes but the only inputs I get are doing nothing (still a choice) or getting shitty with the attendant hoping that it escalates my situation up to the top of their work queue.

Neither of those options have any lasting effect, or even make it into a review of how the system operates, which is barely.

Anyway, I don't know who works on these sorts of customer facing bits of software but a little QA wouldn't go amiss.

Better yet, get a bunch of kids to use your system and ask them if they can try and break it. I feel like they'd be better at imagining all of the silly permutations like "I want a cheeseburger with no cheese, no patty and no bun", which is a very real thing you can order at a McDonalds self service. It'll still cost you the price of a cheeseburger but it's more than worth it watching the ordering system (ie fry cooks) be uttly baffled.

Unfortunately, it has no economic impact on anyone above the ground floor. Why can't there be loopholes like this for hedge funds. That'd be cool to watch seize up for a little bit.

Lastly, a bit of irony. The store in question was testing out a new "Scan and go" system. The idea is you scan all of your items and go. The execution fell apart though because one couple needed a supervisor to sign off on their purchase. Maybe they had bought wine.

They ended up waiting there for a good five minutes while the attendant had to balanced between some guy buying like 10 bottles of cordial, 2 people waiting for alcohol checks (one of which was me, perhaps to no ones surprise) and said couple.

So much for scan and go.
