---
category: blog
date: 2020-10-11T00:00:00+13:00
description: As I work through deleting a bunch of accounts, I note down the various issues that make it harder than it should be
slug: digital-spring-cleaning
tags:
  - internet
  - cleaning
  - data
title: Digital Spring Cleaning
---
It's spring here in New Zealand, and unfortunately I think I've spent more time decluttering digital items instead of physical, but I've still had an interesting time as a result

## Why are people so protective of my data?

Part of my clean involved tidying up my password manager, since it tends to accumulate a lot of accounts that I don't need anymore.

Normally I err more on the side of a digital hoarder but I decided to go [ham](https://genius.com/Jay-z-and-kanye-west-ham-lyrics) on all the "stuff" I have, and so that included digital "assets".

### Cleaning up my own mess

For the most part, deleting accounts was pretty straight forward. Somewhere under Settings would be a big red delete button, easy enough.

### Contacting customer support

A little notch higher were those sites that I had to contact support. Some of that is understandable, for those who have data in disparate systems and/or just haven't implemented the functionality to trigger a cascading delete.

Most sites were fine about it. Some would offer a discount or free credit for… an account I'm not using and clearly stated as much.

There were a couple that asked me to provide the email for my account or username which was fine but it's the email address I'm emailing you from…

Of the customer support request batch, [Tile](https://downloadtile.com/) was perhaps the most confusing. They asked me what year I registered my account (uhh, this year? maybe last), how many tiles I had associated (1) and the names + activation dates of tiles associated with my account. I don't know about you but I don't keep track of these things so I just had to make a rough guess. That was yesterday so I'll see if they accept that before escalating things. This is only made weirder by the fact that before asking those questions, they linked me a reset page for the product I have that has a tile built into it. If the questions are meant to be a security measure, giving me the answer in the same breath is kind of missing the point but oh well.

### Having to search for a human

This category was thankfully quite small and perhaps the most fun to problem solve. Personally, I consider these to be one-off issues rather than being intentionally troubled.

[Dark](https://darklang.com/) was the first contender

Looking at the site, there's no mention of who is behind the language. Inside the application(?), there's no profile page or anything like that.

Eventually, I discovered the Slack community where one of the co-founders informed me that there isn't a user-facing way to delete an account.

We ended up having a conversation about Dark in general and I actually forgot what I was even there for. I was highly skeptical as to whether something like Dark would take off, and I still am, but I enjoyed chatting with 'em so I thought I might as well try it out again. Ironically, the only product/services I was convinced (or perhaps convinced myself) to retry was one of the few that made no attempt to retain users.

The second contender, [Autocode](https://autocode.com/) (previously [stdlib](https://stdlib.com/) by [Polybit](https://polybit.com/)) overlooked some email addresses that no longer existed.

It was pretty easy to infer the new support email by tacking support onto the end of their current domain, and they were super quick to fix it (and delete my account) so it wasn't much trouble at all.

I suppose it's easy to have happen as a startup changing things rapidly, including your name, combined with the number of people who go out of their way to "delete" an account probably being pretty low.

Anyway, ironically I probably spent the least amount of time on this section compared to sites that had gone out of their way to try and design an offboarding process.

### Having to sign up for another thing, in order to leave

Arguably, the former meets this but I consider that a lack of a process rather than a poorly designed process.

The name of the service escapes me (unfortunately) but there was one site where I had to make an account for their Zendesk-reskinned support system that was entirely different from the account I was trying to delete.

Yeah, I had to make an account to delete an account. How stupid is that.

I think I wrote in the ticket to "Please also delete this support account as well"

Of course, it's all digital but I still can't help but feel like I'm generating digital garbage.

### Handing my data back

There were a couple of sites where I simply felt I had no choice but to exercise the [nuclear option](https://en.wikipedia.org/wiki/Nuclear_option).

If I couldn't request my data to be deleted, or even contact anyone, I suppose the account isn't mine in any meaningful sense and I'm just leasing it so I gave the lease back.

More specifically, I would generate an absurdly long password (ie 40+ characters), remove any PII and then change the email address to `postmaster@<domain>`

To be clear, all of these services happened to have nothing in the way of invoices or anything of the sort.

It's not really ideal but I feel a little lighter having returned property which wasn't really mind in the first place. It's one more entry I can remove from my password manager.

### All hope is lost

There were thankfully only about two sites where there was just no course of action I could find, such as no ability to change email address or seemingly contact support to get any sort of response.

For those sites, I just changed the password once again and logged out for the final time. I wasn't using them anyway so they'll just join the rest of the digital waste.

I still would have liked to have tidied up my own mess though.

## Remaining thoughts

I noticed a tendency of a few of the smaller services to apologise that the application/tool didn't work for me.

In my case, I didn't really view it as a failing? Often times, I viewed it more that I wasn't a good fit for the tool. Sometimes I couldn't even figure out how the tool "viewed the world" so I wasn't sure if I was going against the grain of how it was intended to be used.

I suppose it made me appreciate even more, the hard part of product management in that I could easily provide some feedback like "I couldn't do Y thing with this tool" but I should hope that some founders know when to just discard feedback and chalk it up to a user mismatch over arbitrarily forcing concepts into their tool.

There were some tools where I didn't use them, but I knew exactly why I didn't use them. There were others I rarely used and one of those asked if I'd like to join an interview session in exchange for X months of their subscription tier. It got me thinking that if there were more tools, especially the ones I did have specific criticisms of, that asked for user interviews, I'd probably do some of them. Arguably, I'd prefer to do them more if there was no incentive, rather than an incentive I don't have any use for. Personally, I just find those sorts of user interviews fun, both participating and having run a handful myself.

I could mention how some sort of [digital identity](https://en.wikipedia.org/wiki/Self-sovereign_identity) would make any of the above redundant and so on but personally, I think it's wishful thinking, in my lifetime anyway.

Too many business and individuals like to unneccessarily complicate things in a variety of ways: using email addresses as later-unchangable IDs, abstracting themselves away from users so much that you can't find a real person or simply just viewing data as an asset to be kept, rather than a liability to be managed like any other risk.

I would say that much like smoking, the best way to quit is to never start, but even that doesn't hold true with email addresses ending up in all sorts of third party systems you've never heard of.

The above exercise is kind of pointless in that light but I'm not really interested in entirely erasing my footprint so much as I'd just like my password manager to reflect the services that I'm actively using. I'm sure some services just have a deleted: true flag but that's still deactivated as far as I'm concerned.

Maybe one day I'll move to Europe and then I can rub my hands in glee as I fire out hundreds of pissy GDPR emails threatening vague legal action.

Actually, there's an idea. I still have a few customer support requests I'm waiting on for accounts to be deactivated. If I don't hear from them, I wonder if CCing Investor Relations would get me any sort of response?

I'll give it a try later this week.
