---
category: blog
date: 2020-10-06T00:00:00+13:00
description: It's wild that you can couple a physical business to digital technology to the extent that one can't operate without the other
slug: internet-reliance
tags:
  - internet
  - business
title: Relying on the internet as a business
---
I went to get a haircut about 45 minutes before writing this post, and the internet went out briefly. I overheard one of the hair stylists say

> It's weird to think how much we rely on the internet, huh?

Clearly, this isn't a new thought, and this post is being made up as I write it but it's always an interesting thought.

Anyway, the first thing I heard when I walked in the door was "I'll be with you in 2 seconds, the internet has just gone out".

To be quite clear, I like the hair stylist I go to. I hate haircuts so any observations are just that but naturally, I thought

> What does that have to do with haircuts

---

I thought about it a bit while I was there and realised it must be quite hard to be a non-technical business owner.

For starters, when the internet "goes out", all sorts of things start breaking of course. You can't reach your booking system. Perhaps people are booking still, and some managed service is confirming them automatically, but you have no visibility into your expected workflow for later that day.

You're also not really giving proper attention to the people presently there either, since it's in the back of your mind.

You're non-technical after all, you don't really have a mental model of all of the devices in your building and how many of them depend on ethernet or a wireless access point.

I mean, maybe you know roughly what does of course but there's plenty of things that are easy to get about since they… always just work?

There wasn't actually any music, or rather it stopped playing at one point. Personally, I wouldn't have noticed but lo and behold, Spotify does indeed require the internet.

They have mobile EFTPOS terminals that have no cables too so I wonder if they're running off of WiFi too. That makes them about as useful as a brick without those juicy packets.

---

Anyway, this post is partly me trying to sort through my spaghetti thoughts and I think there were two main things that popped into my head:

> As a business owner, just how many dependencies do you end up with that you don't properly understand?

I wonder to what extent, slowly over time, you get introduced to the cooler, mobile EFTPOS terminal. Don't be tied down with all those cables, you could be trendy.

Ok, ok, I'm being heavily sarcastic, no one actually drops however much on a whim for non-essentials but with the rise in internet-connected "things", perhaps there ends up being an unavoidable Ship of Theseus type effect where one day, your entire business can be closed for the day if the internet goes out.

Even for business that seemingly have no real essential need for the internet, but get convinced about some cool new online booking system or whatever. I can imagine as "internet" niches dry up over time, ever more businesses will be convinced to dive into technology in order to create new niches.

The booking system that the hair stylist I used is some basic bootstrap thing with some dropdowns yet there's an entire business that makes "premium hair salon booking systems". Perhaps the wildest part is that time is the bottleneck here, right?

Surely booking can't physically be any more complex than it was as a kid, when staff had paper-based agendas.

In this case, I'm just talking about places with a comparable number of staff of course. You'd want something a bit more scalable with tens or hundreds of staff but until we get hair stylists that rent out a warehouse for some sort of olympic hairdressing event, the problem space seems about the same to me as it ever did. What's the problem we solved here exactly?

At this point I'm just ranting about technology but this does bring me around to my second question:

> Is there, or should there be, such a thing as technology risk assessment/dependency modelling for businesses?

This goes back to the mention of mental models but for your average business owner, I imagine you might not really understand that technology isn't a monolith? You've got disciplines ranging from wild west code slinging to "Just wrapped up a 7 month design trip visiting the wetlands of Croatia"

Bootstrap is fine, I don't hate Javascript for keeping me hostage and Zuck can grill meats all he wants but I know for sure when I look at a barebones booking system and wonder "So what do they do all day? This seems like a grad project", their customers most likely don't have the same point of view.

Taste in design isn't really a concern here but I can't help but wish there was some sort of crash course where people could work through hypotheticals like the above situation I described.

I'm not really sure what to say here other than you can't really avoid engineering a single point of failure if you don't even know what that is.

Also, if I was trying to run a business and focus on "what actually matters", I'd probably just think "Sounds boring/complicated/nerd crap" which is ironic given, you know, I'm writing this post.

---

Realistically, none of this matters. No one else noticed, or even cared, especially not enough to spend their entire lunch break writing over 70 something lines on hair styling.

There's perhaps something more to think about and I probably shouldn't publish this given how it's kind of half baked but maybe it'll inspire you to write something actionable and coherent.

Personally, I think if we still had 3.5mm jacks, I could have just streamed Spotify via mobile for them until the internet came back on. How's that for collective action?
