---
category: "blog"
date: 2020-08-30T00:00:00+13:00
description: "Thoughts upon entering my second job in the industry"
slug: "day-one"
tags:
  - "work"
title: "Day One"
---

It's the night before my first day with Mercedes-Benz as a Site Reliability Engineer. This post is a sequel to [Day Xero](https://utf9k.net/blog/day-xero), written a few years back.

It was never intended to have a follow-up, but it might be a nice reference point to capture how I'm feeling each time I'm about to enter an entirely foreign environment.

Speaking of, that's a good place to start.

## Entering a new environment

Having spent so long in one place, it's always a strange feeling having to start from scratch.

I don't have a good mental model of how this new office looks, or even how big it is. I mean, it seemed sizable from the outside? I suppose as long as I can find the bathroom, the rest doesn't really matter so much.

To be clear, I'm not actually concerned about the building, or being lost. If anything, it's quite exciting!

Of course, human nature means you start thinking about all of the unknowns no matter what. How does everyone dress? Am I going to be underdressed? I don't want to be overdressed!

Realistically, the bounds of what is acceptable dress code is pretty wide so it's not difficult to find something that'll fit any situation. All you want to do is find something that'll do and then you can scope out the situation from there.

I don't know why I expect people to just be specifically wearing business casual, or expect me to be. No one hired me for what I wear. It's also just another office like any other. I think having worked in the same one for ages, I stop thinking of it as an "office", or even a "business".

Anyway, this whole aspect is stupid. At no point has dress code or anything of the sort come up. I've thought about it more than I probably should have which is why I've left it in and I think a later point might give some insight as to why it even came up in the first place.

## Imposter Syndrome

This one is a classic and so there's no point hiding it under a wishy-washy title.

Admittedly, I'm actually feeling pretty good about a fresh start so I'm not feeling this very much, but it has popped up here and there.

I haven't even properly met anyone yet but the general communication style has been pretty straight to the point and honest. Even if that didn't turn out to be accurate going forward, I'm not really in the business of pretending (much) myself. If I was, I wouldn't even be publishing such a post.

If I were to think about why I'm not too badly affected by imposter syndrome this time out, I'd say it's partly due to my general viewpoint on job interviews nowadays. That is, I believe it is job of the interviewer to determine if you're a decent fit for a position or not. The same mentality applies for say; submitting a talk to a conference or entering anything competitive.

Hypothetically, let's say I'm not the right person for the job. Just to be clear, I don't mean in a meritocracy sense, because it's questionable whether such a thing exists. In this scenario, imagine I'm just not equipped to actually do well and I'm still completely lost, even after a few months.

It's only fair to say that this wasn't a failing on my part. As far as a system concerned with hiring someone goes, the fault would lie in the hiring process itself not being rigorous enough. Not only is it not something worth concerning myself with, but it's also something I quite literally have no control or involvement in.

## Systems

I've been thinking a fair bit about my job and what aspects of it I like and don't like.

Programming, I think, is pretty cool. The idea of it being a job is something I like and I'm interested in getting better as a developer. That said, only to a certain point.

When it comes to being the best at a particular language, or keeping up with the latest fancy tools, I really don't care to a certain extent. Sure, I'll check 'em out and get somewhat decent but also I don't for a minute think any of this stuff translates directly into a good product or service.

Does it contribute? Yeah, it can but it's just one small piece of a much larger effort that encompasses relationship building, marketing, support systems and so on.

Anyway, all this is to say, I think I find systems in general more interesting than any specifically "tech". Systems exist in any discipline and can be anything from a codebase to simply what inputs from eg; a Product Manager result in what outcomes from developers? Why do those inputs come about? Perhaps they're overridden by external parties who wield a bigger stick? Maybe it's just bad communication? It's not always clear just by taking a system at face value.

Having said all this, I'll be going from one set of systems that I like to think I'm at least a little familiar with, to an entirely new environment where I have no idea how or why anything is done the way it is.

It'll be fun to poke things and see what outcomes you get as a result.

## Brain dumping

I thought about it quite a bit, which is that I've spent about 2 1/2 years learning a bunch of things that are highly transferrable but also a whole bunch that definitely aren't.

Every business has their own wacky way of doing things and I don't expect for a minute that a decent amount of information I've come to think about day to day, will be transferrable or even useful going forward.

I can't really just think my way into forgetting and I know it'll naturally just fade over time but it's interesting to have a big wad of information floating around my head that is suddenly rendered useless almost overnight. At least, it's useless to me anyway.

## Backdrop

One thing worth mentioning, that I somehow almost forgot, is that Auckland, New Zealand is currently in lockdown which expires at midnight tonight.

Before I even get inducted into my new job, there'll be a mini-induction to cover how this business specifically deals with COVID-19 issues such as how many people can be in the office and so on.

Ironically, I was partly responsible for onboarding a few people during our first lockdown with my previous employer and now I'll be on the other side of the fence, being onboarded myself.

## Why does it feel uncomfortable starting from scratch?

After writing all of the above, I mulled over it a bit and realised something. It's really easy to forget that people come and go all the time when it comes to businesses.

The more I think about it, it's easy to think there's some sort of spotlight on you when first starting out. You sort of imagine that everyone has been in their roles for hundreds of years and you're joining something that has been humming along just fine without you. Time to prove yourself, recruit!

That's not accurate at all of course. People are poached, hired, fired, resign, change roles and go on extended leave all the time. So common in fact, no one really cares beyond a certain point how a new starter is performing. They've got their own stuff to deal with, day to day. I know I certainly never paid attention to new people starting in other teams. I forgot some of our new starters in my previous team were just that pretty quickly. There's no reason to think this will be any different.

Finally, it's literally someone's job to handle the setup for new people starting and making sure they can start off being relatively productive. If it was rare, it wouldn't be someone's job, it'd just be an ad hoc process picked up by a group probably.

---

That's about all I had off the top of my head anyway. None of the above is really useful for me to note down but I figure it might be an interesting series of posts to share with someone just starting out down the road.

Something like "Hey, it's pretty scary starting out but here's a look at how you progress as the years go on. You just naturally sort of figure stuff out."

Well, it seems to happen like that anyway.

I'm just sitting in my head with some popcorn and getting ready to enjoy the show. At some point, I'll probably remember that I'm starting from scratch. "Oh no", I'll think, "It's been a week and I still haven't submitted any code", as if code submission somehow proves "I've made it".

Humans in charge of being rational I suppose.
