---
category: blog
date: 2020-05-12T00:00:00+13:00
description: Looking back on the idea of a quantified self
slug: mental-overhead-of-data
tags:
  - data
  - overhead
  - off-the-cuff
title: Data hoarding seems like a large mental overhead
---
This isn't a post that I've outlined before hand, or even really considered in any particular depth. I'm just making up this post, and it's structure as I type.

Having said that, I've got a few points on my whiteboard that made something click, along with some thoughts that have been frustrating me for a little bit now.

I like to use [Exist](https://exist.io), a service for collecting personal data. It's run a nice Australian duo and I have no issues with the service. All of the data collection is automated, and is explicitly authorised using regular OAuth.

Having all of that data consolidated in one place is nice.

I still feel like I could be doing more with it.

I could easily too, since I can export all that data at any point, and play with it or fetch certain subsets via their API.

On a slightly different note, it has the ability to track my day manually. I can write a short note of how I'm feeling, a rating of my mood from 1 - 5, and also I can add tags to reflect what I did during that day.

Easy enough and I can observe trends over time as more data is gathered.

This post is not about data collection. Nothing here is malicious just to be clear.

I haven't updated my mood, tags and so on for a few days now and I keep missing it. It's an understandable side effect of being stuck inside due to a global pandemic.

The more I really think about it, I start to realise that there is a compounding effect that's very subtle.

I start to feel back because I'm missing out on that data.

I feel guilty because the picture I'm trying to capture is now missing some snippets of data. It's no longer a continuous streak. I could just input from today onwards but there's a little bit of guilt that is prompting me to backfill those days.

There's a weird self guilt that I'm not maintaining a dataset that's as close to perfect as I can manage.

Ironic since I'm missing that data since the first 24 years of my life but this would be the same feeling if I would journalling in a notebook and missed a day.

So, there's two things here I think I've identified: I have a bunch of data and I could be doing more interesting things with it, and I have another bunch of data but I'm not keeping it "complete"… even though I'm not looking back at it.

I could though! In some hypothetical future where I stop being reactionary, actually relax and review what I've got collected.

At this point, I'm tempted to just throw away all that data and relieve myself of my self imposed burden to keep that dataset up to date, day after day.

The data is becoming a massive mental overhead, and arguably an emotional liability.

I suppose we expect, and hope that companies treat our data as a liability. While it's obviously an asset to me, there's no reason why upkeeping that data isn't also incurring a debt of sorts. Generating data is easy but actually recording it and auditing it would of course be some sort of investment.

I don't know if that last sentence actually reflects that I'm trying to say properly but I'm going to leave this as is, given I'm writing it purely off the cuff with no edits.

What else?

I think all of my filesystems are mental liabilities at this point.

There's so much crap scattered across my home desktop, home laptop, work laptop, phone? Images, documents, text snippets?

It's all crap that slowly piles up in my mind.

I should be cleaning it all up.

Perhaps I should turn off my desktop icons for starters but that doesn't really address my issue.

I just want to stop accumulating crap. How can I be a digital minimalist?

My work Google Drive is full of stuff I've just dumped in there and never looked at again.

There are shared drives I've been invited to, or requested access to, telling myself that I'll make use of all of this wonderful information.

Maybe it's wonderful, I don't know. It's too much information, that's for sure.

What I'm getting out of this is that if I haven't used something, or can't justify keeping it, I need to just delete it?

There are plenty of data sets I've requested thinking I'll use them for cool projects but I never get around to it. Traffic data, parking data, data for this, data for that. It all becomes more and more of a liability in the back of your mind because of all of the things you "could" have done or are sitting unfinished.

Bah!

My bookmarks are just the same. I've got a stockpile of articles which might be amazing or they might be a waste of time. The more that piles up too, geez, when I actually create stuff instead of consuming content, hahaha

Picking and choosing is very hard.

Dropping books is another thing I really need to learn how to do. I'll start one, get partway in, get bored but still slog through it. Sometimes I'm pleasantly surprised but the idea of having it marked as "stalled" in my mind is almost a worse fate.

Open loops is probably the keyword here?

How do you close them?

Is just removing something off a list satisfactory? Tell yourself "I'm done with that book/show/codebase/movie/manga/article/course" and then move on? Seems easier said than done?

Perhaps another contributor to all of this is generally using internet tools to track backlogs.

I'm a big fan of [Trakt](https://trakt.tv) for example. No authority says "Thou must finish all movies or shows they intend to watch" but it's hard to not look at a list and wish to complete it.

Finishing one list, in one medium alone is essentially impossible in a human lifetime, let alone all mediums you might appreciate.

Hmm.

I don't really have any good answers but hopefully writing all of this down means I can point to some words when I want to express my frustration.

I'd love to hear your thoughts, if you've got any suggestions. You can email me at marcus (at) utf9k.net.

You could of course use any other content method on my [about](/about) but just make sure the medium is enough to express your thoughts.

This post wouldn't make a very good "tweetstorm" if you ask me.

Thanks for reading!
