---
category: blog
date: 2020-04-13T00:00:00+13:00
description: For no particular reason, I documented all the crap I haul around and my plan to slim it down even further
slug: reducing-my-edc-2019
tags:
  - organisation
title: Reducing my everyday carry during 2019
---
During the beginning of 2019, I had quite a bit of stuff I was carrying around and it bugged me quite a bit.

I managed to reduce down the complexity by quite a large amount, and it's probably one of the better investments I've made recently.

Given that I haven't discarded my previous setup (just yet), I was able to recreate a bunch of before and after photos showing my progression over time.

I'm not recommending you emulate my setup but it might serve as inspiration to make your own investment, into reducing or optimising your everyday carry (EDC going forward).

Before we get started, I should point out that this setup has actually be retired for something even more optimal (for me) but that's a post for another time.

**You can click on each photo to view a full size version**

## The original setup

![An aerial photo of a table containing items I carry each day, with pieces of paper beside each item describing the problems with each. The photo contains my phone, wallet, keys and wired earbuds. I didn't actually have the wired earbuds anymore so I've just drawn a picture to represent them.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/01-original-carry.jpeg)

My EDC was already fairly compact and consisted of the following:

- Google Pixel 3a (very lightweight!)

- Wallet packed with cards (slow to sort through + a lot of unused cards)

- A carabiner with a bunch of keys (which key is which?!)

- A pair of wired earbuds (represented by a placeholder + easily gets tangled)

Let's have a look at these individually as we break down my setup and slowly rebuild it

## Assessing my wallet

![A close up photo of a table with my wallet folded open on it. A piece of paper represents my transit card as I no longer had it at the time of writing this post.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/02-wallet-old.jpeg)

There's quite a lot in my wallet that I don't use, and different cards definitely get access more than others.

Let's start by taking a closer look at those cards

### Regular cards

![An aerial photo of a table with numerous cards scattered around. There are different types from loyalty cards to business cards, as described below.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/03-cards-scattered.jpeg)

There's a variety of different cards here:

- Business cards

- Gift cards

- Loyalty cards

- Membership cards (plastic + NFC)

- Bank cards

![A close up photo of two business cards. One is for stripe.com and another is for readme.com.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/04-business-cards.jpeg)

Business cards are pretty easy to get rid of as a first step. They just went straight into my contacts list. I don't have any need to carry them and should have digitised them a long time ago.

![A closeup photo of my phone with the table and cards in the background, although heavily blurred. The screen of my phone is open to an application that shows digital versions of the loyalty cards. More specifically, the barcodes for each of the physical cards has been captured onto my phone.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/05-loyalty-cards.jpeg)

I don't use loyalty cards often enough, to make the space they take up worth it. Thankfully, it's easy to digitise them nowadays (if they have a barcode) and carry them on my phone instead.

![A closeup photo of my phone with Google Pay open to show my digital bank card. Thankfully any identifying information has been removed. For effect, behind the phone to the side is the table again with my physical bank cards sitting on it, although blurred out for effect.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/06-gpay-cards.jpeg)

Last but not least, I can reduce the amount of time I'm pulling bank cards out of my wallet by adding them to Google Pay. I still need them on hand for larger purchases due to paywave limits.

One type of card I can't simply digitise or reduce are my arcade cards. From what I remember, the arcade balance card itself is part of the [MIFARE DESFire](https://www.mifare.net/en/products/chip-card-ics/mifare-desfire/) family. Android does support [Host Emulation](https://developer.android.com/guide/topics/connectivity/nfc/hce) but from the little I've read, it isn't possible to emulate MIFARE cards nor would a software emulation necessarily be secure anyway.

Similarly, I have a [BANA Passport](https://www.bandainamcoid.com/banapassport/en/) which I use to store my save progress with [Midnight Tune 6](https://wanganmaxi-official.com/wanganmaxi6/en/special/001.php), a particular arcade game I quite enjoy.

I can live with carrying those two day to day, given that visiting the arcade is more of a spur of the moment thing, so it makes more sense to keep it on hand, than say an [EB Games](https://www.ebgames.co.nz) gift card

### Transit card

This is my most used card, given I use it at least once a day on weekdays and sometimes multiple times on the weekend. Having it lumped in with all of my other cards is fine but it'd be nice if it was easier to access given it's part of the "hot path".

What I ended up doing was taking it and replacing it with one of the [limited edition HOP tags](https://at.govt.nz/bus-train-ferry/at-hop-card/buy-at-hop-card/buy-an-at-hop-key-tag/) that Auckland Transport occasionally releases.

![A close up photo of a table surface containing three items: A piece of paper representing my physical transit card, an arrow pointing to the right and a smaller, badge sized transit card designed for keychains. The arrow is supposed to symbolise that I've gone from one transit card to another.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/07-hop.jpeg)

They're designed to live with your keys, coming with a metallic keychain, but I removed that for reasons which will be a little clearer as we continue on.

### Reviewing our progress so far

After all of that reduction, my wallet is slimmed down to just the following essentials

![A close up photo of a table surface showing the smaller transit card to the left, a few remaining physical cards that I like to keep around and a carabiner containing various house keys.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/08-cards.jpeg)

Nowadays, I wouldn't even carry the gift card around, instead just opting to either digitise it (if possible) or remembering to bring it whenever I decide to go in store or order online.

My wallet has served me well for quite some time but it's really easy for just these few cards to fall out, since it's designed to hold a number of cards.

I was browsing the web one day for unique takes on wallets and I came across this thing. It looks a bit confusing at first but having used it for the better part of a year, I really enjoyed it. Here's what it looks like disassembled.

![A close up photo of a table surface containing a metal device that has been unscrewed. The base plate is on the right with three little stands to provide room in between itself and the top plate. The idea is that the cards sit in between the gap. The top plate is red and sitting to the left of the base plate with three small screws sitting just below it.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/09-wallet-disassembled.jpeg)

It probably doesn't look like much at the moment so let's add some keys and accessories

![A close up photo of a table surface with just the metal base plate from the previous photo. Two of the little stands appear to have two keys sitting on them, tucked nicely so they don't extend beyond the base plate itself. The third stand has a small USB drive sitting on it.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/10-wallet-setup.jpeg)

I've got my three house keys, a bottle opener (under the blue key) and a USB drive all sitting snuggly in there.

![A close up photo of a table surface with the assembled metal wallet sitting on it. The wallet is upside down, with the keys and USB drive extended beyond the base plate. The bottom of the base plate is visible, as the wallet is upside down, and has a large clip at the bottom for slotting cards into.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/11-wallet-underside.jpeg)

That's not all. We can stick those remaining cards in the bottom card holder too.

![A side photo of the assembled metal wallet, sitting on a table surface. The previously mentioned clip has been filled with about 8 to 10 physical cards at a glance. They seem to be tightly secured.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/12-wallet-underside-full.jpeg)

To top it all off, I had some spare 3M wall hanger strips floating around so I repurposed one to affix my travel tag to the top of this contraption using velcro

![An aerial photo of the assembled metal wallet sitting on a table surface. It is positioned right side up this time showing the red top plate. On top of the red plate is the small badge sized transit card, seemingly hovering in place. It's actually attached to a velcro strip although you can't visually tell that from the photo.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/13-wallet-top.jpeg)

Et voila, a pretty compact setup if I say so myself!

![A side photo of the assembled metal wallet sitting on a table surface. It's positioned in the same way as the previous photo just with the angle being from the side. If the reader were to squint, they could make out the velcro strip mentioned before but no attention is drawn to it.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/14-wallet-side.jpeg)

## Untangling my headphones

I used to have various pairs of earbuds over the years that were good enough.

![A close up photo of a table surface with two pieces of paper. One on the left says "Such a mess to untangle" with a sad face and an arrow pointing to the right. The piece of paper on the right is a ridiculously bad drawing of wired earbuds with text at the top that reads "Wired earbuds". I no longer had the them in my position so this is supposed to be a placeholder for the real thing.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/15-wired-earbuds.jpeg)

I felt like I must have lost multiple hours of my life just untangling them over the years so I decided I might as well invest in a decent pair.

While they seem to be much more popular and acclaimed these days, I had taken a gamble at the time and invested in a pair of [Sony WF-1000XM3 Wireless Earbuds](https://www.mightyape.co.nz/product/sony-wf-1000xm3-industry-leading-noise-canceling-truly-wireless-earbuds-black/30990778) during a period when the Apple Airpods were basically the only thing you were supposed to buy.

Given the price, I actually opted to pay them off over a period of time (might as well build my credit score after all!)

That said, they've been a worthwhile investment for me. The battery life is great, considering they're properly wireless, and I'm always surprised how many charges I can get from putting them back in the case. When using them as a daily driver, back when walking to work was a thing, I would generally only need to recharge them once a week at most? More like once every 2 weeks I think.

![A side view of a table with two pieces of paper and a red almost electronic pouch looking thing that has a red glowing light. It's actually a pair of Sony WF-1000XM3 Wireless Earbuds in their carry card but unfortunately, it's hard to make out in the photo. Maybe it's just hard to make out on my monitor. Anyway, the pieces of paper are the paper placeholder of my wired earbuds and an arrow pointing right to indicate they've transformed into the new wireless earbuds.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/16-wireless-earbuds.jpeg)

Also, I've been pleasantly surprised at the software updates that still roll out. About 6 months after I bought them, they received support for Amazon Alexa, which was a nice surprise given they already support the Google Assistant. Not that I use either…

## Wrapping up

I believe that covers everything?

I've reduced my wallet by probably 90%, moved my transit card to its own dedicated spot since it's on the "hot path" and I no longer have to spend any time untangling my headphones

![A close up of three items on the table surface. To the right, and closest to the camera, is my phone. It's the Google Pixel 3a and it shows a almost purely black lock screen except for the time, some Japanese song playing on Spotify and the weather which is 19 degrees celcius at the time of the photo. To the right, also close to the camera is the carry case for the Sony wireless earbuds. At the back of the photo, and quite blurred, is the metallic wallet.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/17-all-three.jpeg)

As I mentioned earlier, I've made some further changes which I'll likely cover in a 2020 edition of this post.

![A mid range shot of the same three items from the previous photo on a table surface. They are just sitting in a slightly different configuration but the details are all the same.](https://cdn.utf9k.net/blog/reducing-my-edc-2019/18-all-third-alt.jpeg)

Mainly, I found that while the wallet served me well, it was a bit too heavy to take when I took up running earlier this year.

My fix was to just unscrew it, take out my two main house keys and keep them in my pocket but reassembling my wallet got kinda tedious pretty quickly.

Until next time, see what you're able to pull off with a wallet reduction!
