---
category: blog
date: 2020-03-08T00:00:00+13:00
description: A weird one off post where I documented the various bookmarks I had captured
slug: bookmarking-march-2020
tags:
  - bookmarks
  - organisation
title: My bookmarking categories in March 2020
---
For no particular reason, other than I figured it might help me make better sense of how I organise articles, here's a fairly detailed breakdown of my bookmarking setup.

Currently I'm using [Raindrop.io](https://raindrop.io) but I've also used [Pinboard](https://pinboard.in), [Pocket](https://getpocket.com) and [Larder](https://larder.io) happily in the past too.

At the moment, Raindrop seems like the most comprehensive of the bookmarking apps I've tried. It has a very nice UI, a consistent desktop/mobile experience, a (newly launched) API and supports syncing content to a storage provider (Dropbox or Google Drive) too.

Anyway, I've linked some articles that I've found interesting myself within a lot of the categories.

Most of them need some work, and I've got almost as many unsorted bookmarks as I do sorted since I write a custom title, description and apply tags for searching rather than just dumping them.

I had a lot of stuff from Pocket that I archived which makes up the bulk of it. Most things I had in Pinboard were tagged so they were easy to transition into Raindrop.

If you've got any feedback or want to share your own bookmarking categories, let me know! You can find my contact details on my [about](/about) page B)

## ???

Anything that is generally quirky or surprising like [this](https://audiokarma.org/forums/index.php?threads/jerry-seinfelds-speakers.48414/), [this](https://cooking.stackexchange.com/questions/105602/steak-dropped-in-soapy-dish-water) or [this](https://oukosher.org/blog/industrial-kosher/peanut-butter-ii-standard-of-identity/)

## Behind the Scenes

Great stories or posts that reveal what goes on behind the scenes of various products and companies

[Generally trends towards game development](https://news.ycombinator.com/item?id=20908168)

## Business

### Economics

This tends to be anything related to the economy, [the theory of economics](https://en.wikipedia.org/wiki/Capitol_Hill_Babysitting_Co-op) or [generally anything to do with money](https://abstrusegoose.com/389)

### Marketing

Lessons and resources related to marketing of products, or marketing as an art

### Reports

Various reports (shareholder, [governmental](https://www.bankofengland.co.uk/-/media/boe/files/prudential-regulation/consultation-paper/2019/building-operational-resilience-impact-tolerances-for-important-business-services.pdf), [memos](https://sriramk.com/memos/goldberg-music.pdf))

### Resources

General advice or reference material for going about conducting business and/or setting one up

### Strategy

The art of [setting strategy](https://apenwarr.ca/log/20190926), as it relates to business, and [how business things get done, in spite of their sheer scale](https://danluu.com/sounds-easy/)

## Design

### Inspiration

Cool websites that have interesting designs in some form or another

### Resources

Design resources such as fonts, CSS frameworks, placeholder images or guides on how best to layout a design

### UI / UX

Tips and tricks on providing a functional, accessible design. Generally just for web design but doesn't strictly have to be.

## Miscellaneous

[Anything that doesn't have an obvious category](https://digitalworldproblems.tumblr.com/post/76036641581/while-im-looking-at-that-moviecode-post-he). If there seems to be a grouping of related articles, it'd prompt the creation of a new category but I also don't want to generate more categories that are useful.

## Postmortems

Reviews in what went wrong, whether it be [business](https://www.propublica.org/article/the-red-cross-secret-disaster), [software](https://www.defmacro.org/2017/01/18/why-rethinkdb-failed.html) or [videogames](http://www.fudco.com/chip/lessons.html). As this category grows, I'll likely split them out into eg; Business/Postmortems but for now, I don't have a big enough collection.

## Productivity

Anything related to the art of productivity. It may also just be [articles reminding you that sometimes less is more!](https://nesslabs.com/jomo)

## Recommendations

Things that I have been recommended but haven't looked into yet. If they are part of a medium that I track somewhere else (eg; books into Goodreads, games into How Long To Beat), then I tend to just put them there straight away. [There may be threads that have a wide range of recommendations](https://www.neogaf.com/threads/dead-franchises-almost-nobody-but-you-seems-to-want-back.1355948/) eg; book recommendations so I generally scour them when I get time and put the interesting items into eg; Goodreads.

## Shopping

Things that look cool and I might want to buy one day. I may also just want to keep them for reference to link to people too.

## Society

### Discourse

A bit of a wishy washy grouping but anything related to discussion of ideas and [what can go wrong as a result](https://en.wikipedia.org/wiki/G._K._Chesterton#Chesterton.27s_fence). Perhaps communication is a clearer name for this category.

### Governments

Articles related to governments, whether it be their functions, warfare (from a political point of view, not an on-the-ground point of view) or just ["government related things"](https://web.archive.org/web/20071031080918/http://www.geocities.com/capecanaveral/4411/apollo13.htm)

### Infrastructure

This can be [specific infrastructure](https://en.wikipedia.org/wiki/Signalling_System_No._7) or articles about infrastructure in general ie cost overruns or how a traffic light system operates

### News Media

Resources provided by the news media (eg; a database containing financial entities and their appearances in the media) or articles about the media itself. This doesn't contain articles FROM the news media however. It's more of a meta category.

### People

This could be articles on [specific people](<https://en.wikipedia.org/wiki/Robert_Parker_(wine_critic)>) (biographies, news pieces) or ["people" in a broader sense](https://www.buzzfeednews.com/article/scottlucas/san-francisco-spent-a-decade-being-rich-important-and) such as a story on a town or city.

### Politics

Politics of any form, whether it be governmental (elections, "red tape") or more local such as office or industry politics

### World Views

A bit of an abstract category. This contains articles and quotes that upon reading, I thought ["Oh! This gave me some insight into how certain groups or individuals come to view the world."](https://news.ycombinator.com/item?id=14391552). That's neither a good or a bad thing, just interesting. Often it contains things that I've never considered before myself.

## Sports

I had two links related to wrestling I put in here. I don't follow sports much but sometimes there can be interesting crossovers between say sports and business.

## Technology

### Databases

Articles, Stack Overflow snippets and links in general related to "databases". For now, this has no subcategorisation between eg; MySQL v Postgres, SQL vs "NoSQL" and databases themselves vs database concepts.

### Growing As A Developer

Some recommendations from other developers (eg; keep a logbook), utilities (resume creators, competency matrixes) and other tools for improving as a developer

### Historical Events

Links to "historical events" which can be anything from [unexpected outages](https://github.com/npm/npm/issues/20791) and [long running debates](https://github.com/facebook/react/issues/10191) to [fascinating snippets that somehow haven't been lost yet](http://www.doublewide.net/passport.htm)

### Languages

Anything specific to a programming language whether it be a blog post, tutorial, library or book. At the moment, I haven't split these out into subcategories as each article is tagged with their respective langauges anyway making search easy.

### Lower Level

Anything related to "low level things". As someone who deals primarily with higher level languages (Python, Javascript) day to day, I classify C++ and C as low level too, haha.

### Neighbours

This is really just blog posts with no particular category or links to entire websites or blogs. Neighbours in this term just means other developers in the industry.

### Networking

As it suggests on the tin, any articles, posts etc related to networking in general.

### Observability

This is a pretty new and empty category. I'm misusing the term on purpose as it has links to articles relating to observability as well as monitoring.

### Reference Materials

Anything (lists, lists of lists, books, websites etc) that are useful to reference. There are some things in here that shouldn't be such as books on building applications in a specific language so it's a little bit of a dumping ground at the moment. I don't have a good distinction for where language-specific guides should live (languages or reference materials?)

### Reverse Engineering

All things related to the art of reverse engineering such as applications, blog posts and reference guides

### Security

As it says on the tin. Recommendations as well as [interesting implementations](https://stackoverflow.com/questions/2669690/why-does-google-prepend-while1-to-their-json-responses) related to security.

### Shared Concepts

If it's technical / software development related but not part of any specific category (Unicode for example), I stick it in here

### The Art of Development

This is another wishy-washy category since it has some things which should be [part of Growing As A Developer](https://blog.pragmaticengineer.com/on-writing-well/) as well as things that are more like [how you should properly structure data](https://www.devever.net/~hl/xml) rather than the actual act of development itself. I still need to refine this more.

### The Industry Itself

This could be stories about ["people" (in an individual sense)](http://www.bbsdocumentary.com/library/CONTROVERSY/LAWSUITS/SEA/katzbio.txt), ["people" (in the group sense)](https://www.hanselman.com/blog/DarkMatterDevelopersTheUnseen99.aspx), [people opposing other people](https://gigaom.com/2011/02/18/war-is-hell-welcome-to-the-twitter-wars-of-2011/) and also [choices made by people](https://eager.io/blog/the-languages-which-almost-were-css/). Sometimes companies too.

### Tooling

Tools and utilities that are useful to refer to later. Think CLIs, GUIs, CDNs and any other 3 letter combination you like.

## The Art of Writing

Something I'm looking to flesh out but any articles or references on how to write better!
