---
category: blog
date: 2020-02-07T00:00:00+13:00
description: I think it's a good idea to publish your existing work, even if you don't like it. You don't like it now but others earlier in their journey may appreciate it in a way that you can't anymore.
slug: publish-old-works
tags:
  - rambling
  - portfolio
title: You should publish your older works
---
If you haven't seen it, [Ira Glass on Storytelling 3](https://www.youtube.com/watch?v=X2wLP0izeJE) is a video worth watching.

Just the first few minutes is enough.

I've recommended it a number of times in the last few years, and I'll likely continue to do so for many years to come.

To repeat the premise of the video, Ira describes taste as the gap between what you can accomplish right now, with your current skillset, and what you _know_ is good.

Your taste may be "killer", as he puts it, but that gap means you recognise your work isn't quite up to what you consider good enough.

That gap, and the craving to close it, can be motivating in the best of times, and straight up depressing in others.

While progression over time will close your own gap, I would also point out the taste (and gap) of others.

Your taste will evolve over time, but others may be far ahead or behind your current progression of taste (if we pretend there is such a thing as scale of taste for a minute)

What I'm trying to say is that, if you're a painter for example, you might dislike your latest work. You may even think your work from 5 years ago is utter rubbish.

Perhaps but don't mistake that for thinking no one else is or can ever appreciate it.

Someone years from now may strumble upon your back catalogue (online or off) and find a great deal of inspiration, knowledge or appreciation that you yourself don't hold presently.

I like to think the same applies for software and "old" source code as well.

It gets a bit asterisky with things like objectively uncompilable code, custom frameworks that have security bugs and so on but you may have source code or old projects you think are bad, that others can gain inspiration from or just generally appreciate.

Arguably, that's the only reason I leave anything I've written online is that maybe someone else might get some use out of it in the future.

Anyway, while this can somewhat apply to software, I made a note to write this post a long time ago, in response to some artist friends who wondered why they would ever upload their old work.

For someone who doesn't make or generally seek out artworks, my own taste is pretty weak so I might appreciate an entry level "low taste" piece of work more than whatever is considered to be an "acquired taste".

There's plenty of low tasters out there so you should try and embrace them :)
