---
category: blog
date: 2019-08-19T00:00:00+13:00
description: In which I turn 25 and look back over my writing hobby to date
slug: "25"
tags:
  - meta
title: "25"
---
It's 6:30pm on my 25th birthday and I've been reflecting a bit on what I've managed to accomplish so far. While this isn't a post about that, there's no better time to assess the state of my personal site and where I'd like to go forward.

## The current state

At present, my blog isn't really best effort. I'd like to write more things but I never really make it an actual goal. I'd say the biggest reason is that I've been wrapped up in work side projects instead of my own personal side projects so I'll be looking to stop doing that.

My site has gone through plenty of iterations, with the current being a static site, built with Hugo and hosted on Netlify. It works but it's not exactly how I'd like it.

Along the way, pages have disappeared. There used to be a projects page which never got filled in properly. There was also an archive of reviews I wrote years back. They're still there but not publically exposed anywhere.

## Where I'd like to get to

I always seem to fumble around a lot with Markdown. It works great but there's always things missing I wish I had. Some markdown libraries support tables while some don't, or defer to extensions.

I've come across Asciidoc recently and it seems to be exactly what I'd like. Even as a general document format, it seems pretty handy.

Hugo does have support for it, but it runs with some hardcoded flags that are annoying. It requires a Hugo heading block so you might get a mix like so:

```bash
---
title: 25
date: 2019-08-19
tags: [meta]
---

= 25
Marcus Crane <marcus@utf9k.net>
v1.0, 2019-08-19

It's 6:30pm...
```

This works fine but I'd like to stick to just one single format. Mixing metadata just for Hugo and metadata just for Asciidoc is annoying so I'll have a look into that. Asciidoc itself provides pretty much everything I'd want out the box for a static site. The remainder is just building the category pages and so on, which I don't necessarily need a fully fledged framework for.

## Some topics I'd like to look into

I've got a list of topics I sometimes keep handy but I haven't invested much time into exploring.

Off the top of my head, there's some stuff I'd like to write about and others I'd have to research. In no particular order:

- A writeup of all the iterations of my site with pros and cons (eg; Django, Flask, Hugo, Jekyll etc)

- A comparison of "Prepay SMS UIs"

  - A little while ago I changed cell providers (and then switched back). Topping up credit using SMS based menus was fascinating since it's like this whole web.

  - It'd be interesting to model the various states you can get into and just talk about text based UIs in general

  - Perhaps there'd be some lessons from there that could be reused in chat based UIs or whatever the flavour of the month is with Slack.

- Donating to those who are homeless / on the streets in the future

  - With plenty of things moving to Paywave type technology, what will happen?

  - Personally, I rarely/never carry cash on me anymore so I couldn't give spare change even if I wanted

- My own personal de-googlify post

  - I recently deleted my Google account after finding a replacement for YouTube (exported my subscriptions as an RSS feed)

  - Most other services I had a replacement for, or never used them.

  - Currently running LineageOS with a custom location provider so pretty much no reliance on Google stuff for Android

  - One missing piece then I'd be ready to write about how it's worked for (quite well actually)

  - I'm not hardline "my freedoms" so I still run eg; Instagram and what not. The idea isn't to be pure but find a balance between convenience and privacy (as much as that's a thing hah)

- Github vs Gitlab

  - I recently imported some stuff to Gitlab. I haven't invested much time into it but it seems promising given how many features they've developed.

  - They could all just be quite shallow and not very reliable however.

- Reducing my "every day carry"

  - I recently managed to merge my keys, cards and public transport tag into one which has been working quite well

  - I'd always fancied the idea of not having a wallet but couldn't really see how it would work

- Picking mediums

  - Us humans seem to be bad at picking mediums. We do tweetstorms about political policy or complex issues rather than doing long form.

  - In some cases, shorter mediums are popular but the medium itself shapes the content

  - To fit eg; Twitter's message size, you're going to simplify ideas as much as you can (but no more) but nuance may get lost in the process.

## Other things to add

- A proper projects page

  - I've got some stuff I can probably put up but it would also give me a reason to focus on personal projects more

- Bring back the reviews page

  - I'd like to have something (automation idk) embed cover art and what not for reviews so they look a bit more official

- Perhaps a stats page

  - I used to have this at one point which would pull information from various places

  - It was a nice excuse to play around with technology I wasn't familiar with like Redis or Celery queues

- Setting the whole dynamic vs static thing

  - Part of me wants to go back to dynamic all the time as an excuse to learn new technologies

  - Maybe a mix of the two is would suit me best. Just use asciidoc (via a subprocess) to render pages / store them statically while dynamically building the list type pages

## How do I get there

I just gotta start leaving my laptop at work or else I get tempted to work on work technologies honestly. None of the above is hard but it's easy to get side tracked or want to finish off something.

In this case, there's no requirement for me to do so. Things just happen to cross over with my interests.

Anyway, this post is me committing to changing that, and also having a list of things to look into before I forget.

Perhaps we'll do a 26 this time next year. On that note.

## Some final thoughts

- This site is essentially my portfolio but I don't care to make it particularly professional. The style is "Things past me would enjoy stumbling upon".

- While there may be some posts about specialised topics, none of them should be sacred and should attempt to be readable by anyone.

  - There's that scale that tells you if text is at a 3rd grade reading level etc. That could be an interesting thing to run over some posts.

- I rarely look at analytics. They don't have any bearing on what I write. Comments I don't mind but they're not really integrated well. Maybe I'll get rid of them.

- I'd like the site to be a bit more nice to look at. I tried the whole dark scheme for a bit and it's good but not quite perfect. Maybe I even support both?

- Reference books seem to have some cool layouts. I could probably pull some inspiration from them.

- I think I've fallen out of love with menus. If I do have then, breadcrumb style things might be a way to go.

- I'd like to look back in a few years and see a bunch of stuff that reflects who I was, and how much I know, at that point in time. That's partly why having a format that lasts is important since Hugo may disappear one day for all I know.

Thanks for reading
