---
category: blog
date: 2019-03-20T00:00:00+13:00
description: It's surprising that the idea of an emergency service is even viable, considering how many people are doing things at any given time
slug: future-of-emergency-services
tags:
  - future
  - people
title: What is the future of emergency services?
---
Yesterday, I had an onset of severe abdominal pains. I didn't want to overreact so I called [Healthline](https://www.health.govt.nz/your-health/services-and-support/health-care-services/healthline) who recommended I see either my GP, or [A&E](https://en.wikipedia.org/wiki/Emergency_department) within the next 6 hours.

Shortly after I hung up, I had a pain spike bad enough to make me burst into tears. I wasn't getting anywhere clutching my stomach on the floor so I called an ambulance.

An operator took my information, said that someone would be on their way and then hung up. I waited… and waited… Just over an hour passed before I gave up and called an Uber. One just happened to be 2 minutes away, with the entire trip only taking about 10 minutes from start to finish.

Part of me worried they had turned up only to find me not there so I called back and asked to have the request cancelled. They did so and I asked what the state of the callout was only to find that nothing was ever dispatched due to a high callout rate in my area. Presumably based on my age and the symptoms, they figured I was at low risk?

It didn't leave me with a good feeling or sense of security but it did get me wondering about two things: Statistics and the future of emergency services.

Most of this article would likely have been joking about how there will probably be "Uber for Ambulances" as I often have.

> new startup idea: uber for ambulances. cheaper rates than a normal ambulance unless rugby is on then it's 6x surge prices or you're fucked — [@sentreh](https://twitter.com/sentreh)

There have been [a](https://www.nytimes.com/2018/10/01/upshot/uber-lyft-and-the-urgency-of-saving-money-on-ambulances.html) [few](https://www.buzzfeednews.com/article/carolineodonovan/taking-uber-lyft-emergency-room-legal-liabilities) writeups about how patients are using ridesharing services in place of ambulances and I think I understand why.

[This non-peer reviewed paper](http://www2.ku.edu/~kuwpaper/2017Papers/201708.pdf) in particular, from the University of Kansas, noted an 8% decline in ambulance callouts following the launch of Uber in each respective city measured in the study.

Now having said all this, there was actually an announcement this time last year for [Uber Health](https://www.uber.com/newsroom/uber-health/) in the US. The service is more for booking health-related rides on behalf of patients, as opposed to straight up replacing ambulances but give it enough time and I could see that extra capacity being leveraged to fill in the gaps.

My second question, and one that I'm not really qualified to answer, is to do with the actual callout rates.

The [St John](https://en.wikipedia.org/wiki/St_John_New_Zealand) Organisation are the primary dispatcher of ambulances in New Zealand, providing emergency services to [nearly 90% of New Zealanders](https://www.stjohn.org.nz/What-we-do/St-John-Ambulance-Services/) according to their own website.

They have a handy [section on response times](https://www.stjohn.org.nz/News--Info/Our-Performance/Response-Times/) which links to the [Ministry of Health's Emergency Ambulance Service national performance reports](https://www.health.govt.nz/new-zealand-health-system/key-health-sector-organisations-and-people/naso-national-ambulance-sector-office/emergency-ambulance-services-eas/performance-quality-and-safety/emergency-ambulance-service-national-performance-reports). Look a bit closer and you'll see "For information about St John's performance visit the performance section of their web site." which just leads us back to where we started!

Thankfully, their annual reports contain some of the information we're after. Let's take the [2018 Annual report](https://www.stjohn.org.nz/globalassets/documents/publications/annual-report/stj-annual-report_2018_lq.pdf) as an example.

If we jump all the way to Page 50, we can see a breakdown of numbers with 533,669 ambulance emergency calls made. Another line item mentions 480,411 patients treated or transported by ambulance officers. If we were to very roughly assume that 1 call correlated with 1 patient, that would leave 53,258 calls that are never responded to.

Obviously that's not the whole picture. One call could be for a car crash with multiple injuries while the already deceased may not be counted as "Patients treated or transported". Similarly, it doesn't take into account prank calls, duplicate calls and no-show patients who can't cancel callouts.

Either way, I think it still does point out that there's likely a chunk of callouts that never get responded to as a result of unstaffing combined with ever increasing callout numbers. It's pretty dystopian having something like the "Gig Economy" acting as a replacement for essential services but I suppose I'll take what I can get.

Besides, I never liked the attention that came with flashing lights and sirens anyway.
