---
category: blog
date: 2018-02-28T00:00:00+13:00
description: Stories are fascinating but speed running them is a recipe for trouble
slug: lore-tabs
tags:
  - people
title: Humans don't come with lore tabs
---
This post has been a long time coming because I've never really known how to express it. I'm not even sure I can write it properly anyway but I'm going to at least try.

I recently started the Xero Graduate Programme which has been amazing! As with any new position, it inevitably involves meeting a lot of new people for the first time. I'm not really here to talk about the program itself which is a story for another time.

I'm purely talking about my own experiences struggling to interact with people properly. I figure by writing about it, even if I should fail to improve as a result, you'll at least have an insight to how some people struggle with this kinda stuff.

I often feel like I'm stuck in a recurring loop where I'll meet someone that I consider to be not only interesting, but worth knowing, and so I decide "I'd like to know more about this person". I mean, we all do it but the more I consider my past approaches, I've realised that I was digging for lore first, rather than getting to properly know the person.

What do I mean? Well, let me take a step back and explain what lore is. It's a term that is found commonly in fictional universes such as TV series, games, comics, movies and so on. If the story and character progression of a TV series is the plot, then lore is the mythos of the characters and its world. Past battles, heroic struggles, craters left where cities once stood, ancient texts left by those past and so on. Obviously I'm not suggesting that your average person is supposed to be some kind of otherworldly being but the point is, humans don't have lore tabs.

What I mean is that you can't, and shouldn't, be able to just learn about someone in an instant. Game of Thrones is likely a popular example of this. I haven't watched it but I know that if I were to start, I could pour over its wiki and spend hours learning about cities, people, kingdoms, tribes and so on. For years, humans have been fascinated by good stories and lore, no matter the medium it takes, is probably the purest concentration of stories past.

Actual humans - living people - may have good stories and interesting tales but you can't just skip to the last page and find out what happens to your favourite character. At some point, you might consider learning a lot about someone would make you a better friend because you can understand their nuances. Learning what makes them tick may allow you to adapt but friendships aren't the result of studying someone's past. Funnily enough, they're the result of being a part of someone's past, which can only be done by being in the present. Ironic since it's almost putting the two backwards but in a sense, that's what I had been doing.

What leads someone to think like that? I've been mulling over this lately because almost all of us act out the same pattern to an extent. Biographies, literally the story of others, are a popular book category while Wikipedia has detailed articles on any celebrity you can imagine. They're still people too like you and me so where do you draw the line? Heck, the sheer scale of public information shared by society makes it easier than ever before to scope out someone's past. We're the most documented group of humans in history, essentially recording our autobiographies in real time. The only deciding factor I can up with has to be intent.

It's not what it used to be but I remembered a post from Lifehacker that I read back when, geez, I must've been about 14 at the time? The author was talking about Last.FM. The short of it is that you can "scrobble" music you listen to. It just records a song as listened to once you've hit, say 80% of the song played. Over time, you can view a history of your favourite artists, get recommendations and generally just share your taste in music. The post was talking about the Last.FM service, and specifically how the author had noted their friend would scrobble happy tracks on a good day and vice versa when things were looking bleak.

Their friend was inadvertently letting on to how they truly felt without possibly giving it a second thought. I couldn't track down the original post which is probably long gone but the author noted how it enabled them to be a better friend to an extent. I'm fairly certain that was actually the day I signed up for the service and I still use it to this day. Spotify and other popular services still have native integrations built into their clients. Perhaps it's obvious but the same never happened for me. Who could expect such a thing with so much content floating around. Even if someone did have a look, you'd have to be consciously looking for patterns anyway. If I can't be lucky enough to have someone who thinks like that, surely I can be that person for someone else, right? The intention is good so what could go wrong?

Like most things that get out of hand, this all started small and with the best of intentions. I've got two past examples that quickly spiraled in different directions. I'll leave them up for you to decide what's good, bad and in between. Sometimes things are never so clear cut, especially in the moment.

I once was getting ready for a date and I was quite excited! It's not often that I set them up and when I do, I try to put in my best efforts. I was stood up and left very confused. Not only that, I was blocked on every conceivable platform for no obvious reason. I know it's often said but I genuinely didn't get it. I should've shrugged it off but it kept eating away at me until I decided I needed to find out just to get over it. Back to what I said about biographies, she'd had a YouTube channel with a public view history. Roughly 30% of the views she watched were themed around dealing with anxiety. Part of me wish I had known that earlier so I could have been more accomodating if that's what she needed but context matters. Here was a relative stranger that I have no right to know any more than she lets on personally. I still feel bad for her honestly even though I was the one who got burnt. Were they bad actions to take even though they had good intentions? I honestly can't say.

I was scrolling my timeline one night and came across a tweet from a teenager. He'd claimed to have just swallowed an entire bottle of medicine in a suicide attempt that he desperately wanted to undo. Rounding up an online acquaintance, we put our cursed skills to work as quick as we could. From little more than a username, we narrowed him down to a first name, nationality, gender, age estimate and state. Unfortunately it wasn't enough specific enough that any authorities would be able to put it to use but he did end up surviving. I had previously sent him a message reassuring him since he'd disappeared offline but I never got a response.

He's still active to this day I believe but understandably, two strangers digging up your information can be disconcering no matter the circumstance. I still feel bad about the situation, despite the outcome. As you comb through those forum posts, abandoned IRC logs and tweets, you begin to feel like you understand the person. You can almost picture how they're thinking by what they say, and even more crucially, what they don't. It's like you know the person for a brief moment only to remember it's a one way screen and they could give less of a shit about you despite the attempt. Good actions? Good intent? What's the difference? They're essentially the same story, right but they feel different.

Anyway, what's the point of this little exercise, and this post as a whole? The big picture of it is that realistically, what I've just described is a problem. I often have a problem with getting to properly know people. I'm great at learning who someone is but generally at a distance. If a group of friends are the main cast, I'm one of the extras in the background. Honestly, I probably don't think I'm worthy enough to be promoted to a main character in this scenario because I often struggle to see it happening. I was recently at a meetup and I felt painfully like the odd one out. You can almost read the indifference in some people's face when you talk to them. If I've learnt anything over the last few years, it's that I think I'll always cope better being picky with this sort of stuff. Sometimes I try to be friendly and seemingly the other party gets the wrong impression that I have some kind of motive. To steal a quote from Wargames, it often feels like the only winning move is not to play.

If you've ever read Dale Carnegie's How to Win Friends and Influence People, then good on you because I haven't. In the book, he comes to the conclusion that for others to take a genuine interest in you, it takes little more than being interested in them. The more you ask questions of others, the more interesting they will apparently find you. Perhaps it's true, I couldn't say but lately I feel like mystery might be a common thread. Looking back, some of the more interesting people I've met have been quite illusive. That is to say, they're never around. At that point, I have to wonder though if it's the absence generates the mystery or if being a wanted person generates the absence. Perhaps one feeds the other and the secret is to just not give a shit and purposely be unavailable. Just rarely look at notifications and struggle to keep appointments. Slowly disappear from view until you're all but forgotten. I'm joking of course but I wonder if there's something to be learnt from those people.

All in all, what have we learnt? Well, I've basically admitted that I may or may not be an awful person depending on how you've felt after taking this lengthy journey. Odds are that you've already made up your mind well before now if we've met before. Hopefully you've gained some insight into the meta of dealing with other people. I suppose this kind of thing comes naturally but I feel like I missed a memo somewhere. Either way, the first step is admitting something is wrong. Once you do that, hopefully it should be more straightfoward to progress and become a better person. Perhaps you can let me know how I get on?

Now if you'll excuse me, I have to go and return some videotapes.
