---
category: blog
date: 2017-12-18T00:00:00+13:00
description: I ran a Wiki for a little while and here's what I learned
slug: wiki-thoughts
tags:
  - community
  - leadership
  - wiki
title: Some thoughts about running a wiki
---
Recently, I started playing a mobile game called [Blustone](http://bs.visualshower.com/). It's not perfect and for all the minor issues I have with it, it's pretty enjoyable for the most part. The most important draw however has been the community.

It's not huge and it does have its bad apples but for the most part, I've met a few nice people online.

Anyway, that brings me to the [VSFan](https://vsfan.net/wiki) which I started since there were hardly any English resources, let alone gathered all in one place. I always thought sites like [Serebii](http://serebii.net/) were cool as a kid and wished I could make my own site like that.

Oh, I should probably mention that VSFan is short for [VisualShower Fan](http://visualshower.com/), in reference to the developers.

Anyway, it was half an excuse to dig into a project I cared about and half to generate some decent community resources because generally that stuff is already taken care of for most games by people much more dedicated than myself so this was quite a discover finding something that's hardly documented beyond a handful of YouTube videos and some scattered blog posts and walkthroughs.

It'll probably be my first project that actually has some proper viewership and it kinda gives me the shits a bit knowing that the longer it exists, the more it's engrained into Google's search results or old chat messages/forum posts so there's no going back!

That said, I've got nightly backups, both stored on the server itself (I can only afford one for now!) plus rsynced out to my little Intel NUC server at home so I am actually treating this properly but I think freaking out a little goes for anything that gets put online. I've been solving that by not running any analytics or looking at the server logs and just pretending it's only me and a few pals editing. There might not even be any users for all I know!

Err, I feel like I had a point since I'm writing this as I go. Oh yeah, the next thing I'll be having to think about all the community management bits.

Registrations require email verification, primarily due to one rogue spambot a few weeks back but I think it also works nicely as a buffer for quality. While some users may feel going into their email client and back is too much work, I think it's a low enough barrier that it'll deter those who aren't invested enough to register an account.

Next up is guidelines which I still need to write. You don't wanna make them too strict but you also don't want to say "Go nuts, do anything" because you'll inevitably end up with vandalism. Personally, my primary concern is a drop in quality but I mean, that's flawed both in the sense that it's hard to be objective about your own tastes/skills and also it assumes a lot about others who may/will be just as hard working. I don't have any trouble admitting that however because if you can't, then how can you possibly get rid of those concerns, right?

While I'm the "creator", I definitely think the best route is to treat admin roles as janitors essentially. Sure, they clean up messes and we likely don't give janitors enough credit but as soon as you attach a social standing or a general elevation of "worth" to your roles, it's a bit of a meltdown waiting to happen. It'll only ever serve to separate groups and, probably, generate nepotism and what not.

On the flipside though, treating everyone equally is silly because some users will be better at some things than others. Some users may be immature (which isn't always tied to age) and may propose nonsense rules or err, be unable to "see the trees for the forest" as they say. I can't think of any specific examples at the moment but I guess what I'm getting at is that you do need moderation but as long as you only use it in, ahem, moderation.

Another spark of division I wonder about is the following scenario. Let's say I'm interested in contributing but I'm too literal when it comes to condensing the contents of an episode into a summary. I might write "X did this. Next, X did that. Y came along." which is technically correct and accurate but it's not necessarily enjoyable to read.

Some may say "Don't post if it's not quality" because they're interested in keeping the bar high at all times. Seeing as we're just getting started, our focus should be on content. Not only that but having something is often better than nothing at all. Provided it's detailed enough, it gives a starting point which the "wordsmiths" among us can shape without having to invest time into research.

In that sense, it gives users with different abilities and experience levels things to do. If you're not so great at writing, make some stubs or provide some referencial data like EXP tables or pull some better screenshots. While the main resource for a wiki is text, fortunately there are more ways than one to communicate with the user.

Err, anyway, this whole post was pretty impromptu and I just wanted to spit out some stuff I'd been thinking about for a while now. None of it is edited and chances are I'll never read it again but I don't think I made any typos!

If you have any thoughts yourself or just want to leave a comment, you can send me a tweet to [@sentreh](https://twitter.com/sentreh).
